       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSAC170.                                        
       DATE-WRITTEN.   OCT 2000.                                        
      ******************************************************************        
      *                                                                *        
      *                 PROGRAM MODIFICATION LOG                       *        
      *                                                                *        
      *   DATE    INITIALS   REASON                                    *        
      * --------  --------   -------------------------------------     *        
T22767*  10/00     CBSI       NEW PROGRAM                              *        
T22767*  10/17/01  BASKAR     CHANGE THE SC PIPELINE CASH GL           *        
C25923*  02/12/02  BASKAR     PROGRAM IS MODIFIED TO HANDLE BANK DRAFT.*        
      *                       BANK TRANSFER LOGIC IS MOVED FROM CA190  *        
      *                       TO AC170.                                *        
      *                       VALIDATION PART IS ALSO ADDED HERE FROM  *        
      *                       PCSAC161 AND PCSAC163.                   *        
C25923*  02/20/02  BASKAR     ADD CASH REPORT FOR THE CASH LOCAL OFFICE*        
C25923*  05/07/02  BASKAR     WRITE CORRECT CASH LOCAL OFFICE FOR DRAFT*        
C25923*  03/25/02  BASKAR     USE CASH OFFICE 22 FOR SEB DRAFTS        *        
C25923*  04/12/02  BASKAR     1) MADE CHANGES TO ADD A DATE IN BANKXFER*        
C25923*                       WHICH WILL TELL WHEN THE FUND IS EXPECTED*        
C25923*                       IN THE BANK.                             *        
C25923*                       2) IF THE PAYMENT IS FROM AN AGENT DON'T *        
C25923*                       WRITE BANK TRANSFER INSTEAD WRITE JOURNAL*        
C25923*                       FOR THE BATCH AMOUNT FOR AN OFFSET GL    *        
C25923*  04/26/02  R SPIRES   ADD APS DIRECTED MERCHANDISE PAYMENTS.   *        
BASKAR*  07/01/02  BASKAR     DO NOT ALLOW PIPELINE ACCOUNTS IN SEB    *        
C28301*  02/03/03  BASKAR 1.  USE CSS_CASHIER_OFFICE TABLE TO ASSIGN   *        
C28301*                       CASH LOCAL OFFICE FOR DIFFERENT TYPES OF *        
C28301*                       PAYMENTS INSTEAD OF HARDCODING EACH TYPE *        
C28301*                   2.  DO NOT WRITE HEADER RECORD IN AC01 FILE  *        
C28301*                       IF ALL PAYMENTS IN A BATCH ARE REJECTED  *        
C27875*  02/27/03  BASKAR     REMOVE PIPELINE VALIDATION               *        
C28322*  04/08/03  BASKAR     REJECT COBB PAYMENTS - FINAL BILLED AND  *        
C28322*                       ORIGINATION CD IS 'T' IN                 *        
C28322*                       CSS_MKT_XREF_ACCT                        *        
T29106*  09/13/03  GS90520    CHECK ADDED NOT TO PROCESS PREVIOUS      *        
T29106*                       DAYS WORK                                *        
T29889*  12/02/03  COVANSYS   DO NOT VALIDATE IF THE ACCOUNT HAS A DFA *        
T29889*                       DELETED PART OF CODE THAT CHECKS THE SAME*        
C29529*  04/12/04  SS19371    FOR TYPE 6 DETAIL RECORDS, IF THE        *        
C29529*                       PYMT-POSTED-FL = 'Y', DO NOT WRITE RECORD*        
C29529*                       TO OUTPUT FILE FOR POSTING IN THE 160    *        
C29529*                       SERIES -- THESE PAYMENTS HAVE ALREADY    *        
C29529*                       POSTED AND THE BANK TRANSFER LOGIC WAS   *        
C29529*                       HANDLED IN PCSCA190                      *        
C33928* 08/09/06   AP40911    CHANGES MADE TO TAKE OUT MODEL_SQL       *        
C33928*                       AND ALSO WITH UR.                        *        
C33928* 10/10/06   BASKAR V   PERFORMANCE IMPROVEMENT - MOVED JOURNAL  *        
C33928*                       AND BANK TRANSFER LOGIC TO PCSAC171.     *        
C33928*                       REMOVE CHANGES FOR CML28322.             *        
A01987* 12/28/09   BASKAR V   MOVE ZERO TO ACCOUNT NO IF IT IS NOT     *        
A01987*                       NUMERIC                                  *        
A02388* 05/10/10   C BROWN    ADDED CODE TO CHECK FOR ARCHIVED ACCOUNT *        
A02388*                       IF NOT FOUND                             *        
A03311* 04/18/11   BASKAR V   MAKE PAYMENT POSTING AND BANK TRANSFER   *        
A03311*                       IN SAME CASHIER OFFICE                   *        
A03311* 11/11/11   BASKAR V   FIX -803 PROD PROBLEM FOR DRAFTS         *        
A03311* 11/16/11   BASKAR V   CORRECT COMMENTS                         *        
P00641* 05/01/12   DB41297    REMOVE TBGLATNO UNUSED FIELDS.           *        
      ******************************************************************        
      *                                                                         
              REMARKS.                                                  
      *                                                                         
      ******************************************************************        
      *  THIS PROGRAM READS IN THE DAILY CASH PAYMENT TRANSACTIONS     *        
      *  FROM THE BANCTEC FORMAT FILES AND CREATES 3 DIFFERENT FILES,  *        
      *  THE FILES ARE:                                                *        
      *                                                                *        
      *  PAYMENTS FOR CIS                                              *        
      *  PAYMENTS FOR GAS SYSTEM                                       *        
      *  PAYMENTS FOR ERROR ACCOUNTS                                   *        
      *                                                                *        
      *  THIS PROGRAM ALSO JOURNALS INTO CASH DRAWER JOURNAL TABLES    *        
      *  AND CREATES A CSS_BANK_TRANSFER ROW FOR THE TOTAL PAYMENTS    *        
      *  FOR EACH BATCH IN THE FILE.                                   *        
      ******************************************************************        
      *                                                                         
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
      *                                                                         
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
                                                                        
       ENVIRONMENT DIVISION.                                            
      *CONFIGURATION SECTION.                                                   
      *    SPECIAL NAMES.      C01 IS TOP-OF-PAGE.                              
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSAC01.                                                            
       COPY CSSAC20.                                                            
       COPY CSSAC21.                                                            
       COPY CSSAC22.                                                            
       COPY CSSAC03.                                                            
       COPY CSSAC24.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ******************************************************************        
      **  CFDAC01 - FD FOR BANCTEC SEQUENTIAL INPUT FILE.             **        
      ******************************************************************        
       COPY CFDAC01.                                                            
      ******************************************************************        
      **  THIS FILE CONTAINS BANCTEC CASH REMITTANCE PAYMENTS RECORDS.**        
      ******************************************************************        
       COPY CSHCBCTC.                                                           
      ******************************************************************        
      ** CFDAC20 - FD FOR BANCTEC SEQUENTIAL OUTPUT FILE              **        
      **                     CIS-ACCOUNT                              **        
      ******************************************************************        
       COPY CFDAC20.                                                            
       01    FIOAC20-REC                   PIC X(80).                   
      ******************************************************************        
      ** CFDAC21 - FD FOR BANCTEC SEQUENTIAL OUTPUT FILE              **        
      **                  PIPLINE-ACCOUNT                             **        
      ******************************************************************        
       COPY CFDAC21.                                                            
       01    FIOAC21-REC                   PIC X(60).                   
      ******************************************************************        
      ** CFDAC22 - FD FOR BANCTEC SEQUENTIAL OUTPUT FILE              **        
      **                   ERROR-ACCOUNT                              **        
      ******************************************************************        
       COPY CFDAC22.                                                            
       01    FIOAC22-REC                   PIC X(60).                   
                                                                        
      ******************************************************************        
      ** CFDAC03 - FD FOR BANK DRAFT SEQUENTIAL INPUT FILE            **        
      ** THIS FILE CONTAINS DRAFT PAYMENTS.                           **        
      ******************************************************************        
       COPY CFDAC03.                                                            
C29529 COPY FIOAC03B.                                                           
                                                                        
      ******************************************************************        
      ** CFDAC24 - FD FOR BANK DRAFT OUTPUT FILE                      **        
      ** THIS FILE CONTAINS ALL VALID DRAFT PAYMENTS                  **        
      ******************************************************************        
       COPY CFDAC24.                                                            
C29529 01    FIOAC24-REC                   PIC X(105).                  
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC170'.
MSQ017     COPY MFASQLM.
      ******************************************************************        
      *                                                                *        
      *             'WORKING STORAGE FOR PCSAC170 STARTS HERE'.        *        
      ******************************************************************        
                                                                        
       COPY FIOAC21.                                                            
                                                                        
       01 WS-FLAGS.                                                     
          05  WS-DEBIT-FLAG                     PIC X(01).              
          05  WS-EXISTS-FLAG                    PIC X(01).              
A02388    05  WS-ARCHIVE-FLAG                   PIC X(01).              
       01  WS-SWITCHES.                                                 
           05  WS-FCSAC01-EOF-SW                PIC X(01) VALUE 'N'.    
                       88  WS-FCSAC01-AT-EOF              VALUE 'Y'.    
                       88  WS-FCSAC01-NOT-AT-EOF          VALUE 'N'.    
           05  WS-FCSAC03-EOF-SW                PIC X(01) VALUE 'N'.    
                       88  WS-FCSAC03-AT-EOF              VALUE 'Y'.    
                       88  WS-FCSAC03-NOT-AT-EOF          VALUE 'N'.    
           05  WS-FIRST-BANCTEC-HEADER-SW       PIC X(01) VALUE 'Y'.    
                       88  WS-FIRST-BANCTEC-HEADER        VALUE 'Y'.    
           05  WS-FAC01-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FAC01-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
           05  WS-FAC03-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FAC03-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
           05  WS-FAC20-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FAC20-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
           05  WS-FAC21-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FAC21-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
           05  WS-FAC22-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FAC22-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
           05  WS-FAC24-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FAC24-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
           05  WS-INPUT-FILE-STATUS             PIC X(01) VALUE 'N'.    
                       88  INPUT-NOT-EXISTS               VALUE 'N'.    
                       88  INPUT-EXISTS                   VALUE 'Y'.    
           05  WS-PAYMENT-SW                    PIC X(01) VALUE 'N'.    
                       88  WS-DRAFT                       VALUE 'Y'.    
                       88  WS-OTHERS                      VALUE 'N'.    
                       88  WS-AGENT                       VALUE 'A'.    
C33928                 88  WS-MAIL                        VALUE 'M'.    
           05  WS-VALID-ACCT-SW                 PIC X(01) VALUE 'Y'.    
                       88  WS-VALID-ACCOUNT               VALUE 'Y'.    
                       88  WS-NOT-VALID-ACCOUNT           VALUE 'N'.    
                                                                        
       01  WS-DATE-VARIABLES.                                           
           05  WS-DATE-CENTURY.                                         
               10  WS-CEN-CC                    PIC 9(02) VALUE ZEROES. 
               10  WS-CEN-YY                    PIC 9(02) VALUE ZEROES. 
           05  WS-AC01-DATE.                                            
               10  WS-AC01-CC                   PIC 9(02) VALUE ZEROES. 
               10  WS-AC01-YY                   PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-AC01-MM                   PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-AC01-DD                   PIC 9(02) VALUE ZEROES. 
           05  WS-DRAFT-DATE.                                           
               10  WS-DRAFT-CC                  PIC 9(02) VALUE ZEROES. 
               10  WS-DRAFT-YY                  PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-DRAFT-MM                  PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-DRAFT-DD                  PIC 9(02) VALUE ZEROES. 
T29106     05  WS-CHECK-DATE.                                           
T29106         10  WS-CHECK-CC                  PIC X(02) VALUE '20'.   
T29106         10  WS-CHECK-YY                  PIC X(02) VALUE SPACES. 
T29106         10  FILLER                       PIC X(01) VALUE '-'.    
T29106         10  WS-CHECK-MM                  PIC X(02) VALUE SPACES. 
T29106         10  FILLER                       PIC X(01) VALUE '-'.    
T29106         10  WS-CHECK-DD                  PIC X(02) VALUE SPACES. 
           05  WS-TRAN-TIME                     PIC X(08) VALUE SPACES. 
           05  WS-XFR-TS                        PIC X(26) VALUE SPACES. 
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-SCPC-SEQ-NO                   PIC 9(06) VALUE 1.      
           05  WS-ERR-SEQ-NO                    PIC 9(06) VALUE 1.      
           05  WS-CIS-NO-OF-DOCS                PIC 9(06) VALUE ZEROES. 
           05  WS-CIS-BATCH-TOTAL               PIC S9(11)V99           
                                                          VALUE ZEROES. 
           05  WS-SCPC-NO-OF-DOCS               PIC 9(06) VALUE ZEROES. 
           05  WS-SCPC-BATCH-TOTAL              PIC S9(11)V99           
                                                          VALUE ZEROES. 
           05  WS-ERR-NO-OF-DOCS                PIC 9(06) VALUE ZEROES. 
           05  WS-ERR-BATCH-TOTAL               PIC S9(11)V99           
                                                          VALUE ZEROES. 
           05  WS-BATCH-TOTAL-COUNT             PIC 9(04) VALUE ZEROES. 
           05  WS-BATCH-TOTAL-AMOUNT            PIC S9(11)V99           
                                                          VALUE ZEROES. 
C29529     05  WS-DRAFT-TOTAL-COUNT-N           PIC 9(06) VALUE ZEROES. 
C29529     05  WS-DRAFT-TOTAL-COUNT-Y           PIC 9(06) VALUE ZEROES. 
C29529     05  WS-DRAFT-TOTAL-COUNT-ALL         PIC 9(06) VALUE ZEROES. 
           05  WS-DRAFT-BATCH-COUNT             PIC 9(06) VALUE ZEROES. 
           05  WS-DRAFT-BATCH-AMOUNT            PIC 9(10)V99            
                                                          VALUE ZEROES. 
C29529     05  WS-DRAFT-TOTAL-AMOUNT-N          PIC 9(10)V99            
C29529                                                    VALUE ZEROES. 
C29529     05  WS-DRAFT-TOTAL-AMOUNT-Y          PIC 9(10)V99            
C29529                                                    VALUE ZEROES. 
C29529     05  WS-DRAFT-TOTAL-AMOUNT-ALL        PIC 9(10)V99            
                                                          VALUE ZEROES. 
           05  WS-DRAFT-HASH-TOTAL              PIC 9(10) VALUE ZEROES. 
       01  WS-WORK-VARIABLES.                                           
           05  WS-ERR-MSG                       PIC X(100) VALUE SPACES.
           05  WS-ERR-MSG2                      PIC X(100) VALUE SPACES.
           05  WS-REJECT-REASON                 PIC X(01)  VALUE SPACES.
           05  WS-DISP-CASH-DRAWER-ID           PIC 9(03).              
           05  WS-DISP-CUSTOMER-NO              PIC 9(10).              
           05  WS-DISP-ACCOUNT-NO               PIC 9(13).              
           05  WS-DISP-FILE-AMOUNT              PIC 9(10).99            
                                                          VALUE ZEROES. 
           05  WS-DISP-TOTAL-AMOUNT             PIC 9(10).99            
                                                          VALUE ZEROES. 
           05  WS-DRAFT-ACCT-NO                 PIC X(13).              
           05  WS-DRAFT-ACCT-NO-NUM REDEFINES WS-DRAFT-ACCT-NO          
                                                PIC 9(13).              
           05  WS-NULL-INDICATOR1               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CNTL-TS-NI                    PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CJ-DATE-NI                    PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CJ-TIME-NI                    PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CASH-GL-ACCT                  PIC 9(03)V9(04)         
                                                          VALUE ZEROES. 
           05  WS-BNKXFR-GL-ACCT                PIC 9(03)V9(04)         
                                                          VALUE ZEROES. 
           05  WS-SCPC-GL-ACCT                  PIC 9(03)V9(04)         
                                                          VALUE ZEROES. 
           05  WS-ERR-GL-ACCT                   PIC 9(03)V9(04)         
                                                          VALUE ZEROES. 
           05  WS-PREV-REC-TYPE                 PIC 9(01) VALUE ZEROES. 
           05  WS-PREV-BATCH-NO                 PIC 9(04) VALUE ZEROES. 
           05  WS-AMT-9                         PIC 9(08)V99.           
           05  WS-AMT-X                                                 
               REDEFINES WS-AMT-9               PIC X(10).              
                                                                        
                                                                        
       01  WS-HARDCODED-VARIABLES.                                      
           05  WS-AC21                          PIC X(04) VALUE 'AC21'. 
           05  WS-AC22                          PIC X(04) VALUE 'AC22'. 
           05  WS-AC23                          PIC X(04) VALUE 'AC23'. 
           05  WS-AC24                          PIC X(04) VALUE 'AC24'. 
           05  WS-COMPANY                       PIC X(02) VALUE '01'.   
           05  WS-CSR                           PIC S9(9)V9(5)          
                                                          VALUE 1.00000.
C28322     05  WS-SEB                           PIC S9(9)V9(5)          
C28322                                                    VALUE 2.00000.
           05  WS-DATABASE                      PIC X(08) VALUE         
                                                          'DATABASE'.   
           05  WS-CASHIER-USER-ID               PIC X(07) VALUE SPACES. 
           05  WS-CASHIER-CASH-OFFICE           PIC X(03) VALUE SPACES. 
           05  WS-BATCH-DEP-CASH-OFF            PIC X(03) VALUE SPACES. 
           05  WS-DEP-XFER-METHOD               PIC X(01) VALUE 'A'.    
                       88  AUTOMATIC-TRANSFER             VALUE 'A'.    
                       88  MANUAL-TRANSFER                VALUE 'M'.    
           05  WS-CASHIER-BANK-ID               PIC 9(05) VALUE 2.      
           05  WS-CASHIER-LOCAL-OFFICE          PIC X(03) VALUE SPACES. 
           05  WS-COMPANY-NAME                  PIC X(13) VALUE         
                                                       'SCE&G COMPANY'. 
           05  WS-PGRMNAME                      PIC X(08) VALUE         
                                                       'PCSAC170'.      
           05  WS-Y                             PIC X(01) VALUE 'Y'.    
           05  WS-N                             PIC X(01) VALUE 'N'.    
           05  WS-J                             PIC X(01) VALUE 'J'.    
           05  WS-LIT-A                         PIC X(01) VALUE 'A'.    
           05  WS-LIT-C                         PIC X(01) VALUE 'C'.    
           05  WS-LIT-D                         PIC X(01) VALUE 'D'.    
           05  WS-ZERO                          PIC 9(01) VALUE 0.      
           05  WS-LIT-ZERO                      PIC X(10) VALUE ZEROES. 
           05  WS-ONE                           PIC 9(01) VALUE 1.      
           05  WS-TWO                           PIC 9(01) VALUE 2.      
           05  WS-THREE                         PIC 9(01) VALUE 3.      
           05  WS-FOUR                          PIC 9(01) VALUE 4.      
           05  WS-FIVE                          PIC 9(01) VALUE 5.      
           05  WS-SIX                           PIC 9(01) VALUE 6.      
           05  WS-SEVEN                         PIC 9(01) VALUE 7.      
           05  WS-EIGHT                         PIC 9(01) VALUE 8.      
           05  WS-NINE                          PIC 9(01) VALUE 9.      
           05  WS-YES                           PIC X(01) VALUE 'Y'.    
           05  WS-NO                            PIC X(01) VALUE 'N'.    
           05  WS-28                            PIC 9(02) VALUE 28.     
C28301     05  WS-1                             PIC X(01) VALUE '1'.    
C28301     05  WS-2                             PIC X(01) VALUE '2'.    
           05  WS-009                           PIC X(03) VALUE '009'.  
           05  WS-025                           PIC X(03) VALUE '025'.  
           05  WS-029                           PIC X(03) VALUE '029'.  
           05  WS-017                           PIC X(03) VALUE '017'.  
           05  WS-019                           PIC X(03) VALUE '019'.  
           05  WS-024                           PIC X(03) VALUE '024'.  
           05  WS-006                           PIC X(03) VALUE '006'.  
           05  WS-004                           PIC X(03) VALUE '004'.  
           05  WS-018                           PIC X(03) VALUE '018'.  
           05  WS-022                           PIC X(03) VALUE '022'.  
           05  WS-027                           PIC X(03) VALUE '027'.  
           05  WS-028                           PIC X(03) VALUE '028'.  
           05  WS-036                           PIC X(03) VALUE '036'.  
           05  WS-039                           PIC X(03) VALUE '039'.  
           05  WS-101                           PIC 9(03) VALUE 101.    
           05  WS-19                            PIC 9(02) VALUE 19.     
           05  WS-20                            PIC 9(02) VALUE 20.     
           05  WS-M                             PIC X(01) VALUE 'M'.    
           05  WS-METER-NO                      PIC X(09) VALUE         
                                                         '000000000'.   
           05  WS-ALL9-ACNO                     PIC 9(13) VALUE         
                                                          9999999999999.
           05  WS-TRAN-ID                       PIC X(04) VALUE 'A170'. 
           05  MULTIPLE-ROWS-SELECTED           PIC S9(09)              
                                                    VALUE -811 COMP.    
           05 WS-PAYMENT-SOURCE-CD.                                     
              10 WS-PAYMENT-SOURCE-1            PIC X(01) VALUE '0'.    
              10 WS-PAYMENT-SOURCE-2            PIC X(01) VALUE '0'.    
                                                                        
      ******************************************************************        
      **   COPYBOOKS USED IN THE PROGRAM                              **        
      ******************************************************************        
       COPY CJF00101.                                                           
       COPY CWS00021.                                                           
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00104.                                                           
       COPY CWS00056.                                                           
                                                                        
           EXEC SQL                                                             
            INCLUDE CWS00315                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE SQLCA                                                       
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_ACCOUNT                                                **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBACCT                                                      
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_XREF_ACCOUNT                                           **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBXREF                                                      
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_GL_ACCT-NO                                             **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBGLATNO                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_BANK                                                   **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBBANK                                                      
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_BANK_TRANSFER                                          **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBBNKXFR                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CASHIER                                                **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCSHIER                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CASHIER_OFFICE                                         **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCSHOFF                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CSH_DRWR_CNTL                                          **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCDCNTL                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CSH_DRWR_JRNL                                          **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE  TBCDJRNL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_JOB PARM                                               **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE  TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DFA_ACCT                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUSTOMER                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CSH_REPORT_HDR                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCSRPHD                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_HOLIDAY                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
A02388******************************************************************        
A02388*    HST_ACCOUNT                                                 *        
A02388******************************************************************        
A02388                                                                  
A02388     EXEC SQL                                                             
A02388         INCLUDE TBHACCT                                                  
A02388     END-EXEC.                                                            
A02388                                                                  
      ******************************************************************        
      *    'WORKING STORAGE FOR PCSAC170 ENDS HERE '.                  *        
      ******************************************************************        
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      **                         M A I N L I N E                      **        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
                                                                        
           SET WS-DRAFT                  TO TRUE                        
           PERFORM 0500-PROCESS-DRAFTS                                  
              THRU 0500-EXIT                                            
                   UNTIL WS-FCSAC03-AT-EOF.                             
                                                                        
           SET WS-OTHERS                 TO TRUE                        
           PERFORM 1000-PROCESS-FCSAC01                                 
              THRU 1000-EXIT                                            
                   UNTIL WS-FCSAC01-AT-EOF.                             
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0100-INITIALIZATION                                         **        
      **  COMMON INITIALIZATION ROUTINE                               **        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 0200-OPEN-FILES                                      
              THRU 0200-EXIT.                                           
           PERFORM 0300-SETUP-DATES                                     
              THRU 0300-EXIT.                                           
           PERFORM 0400-SETUP-GL-ACCTS                                  
              THRU 0400-EXIT.                                           
                                                                        
BASKAR     MOVE WS-COMPANY               TO C8-COMPANY-NO               
BASKAR                                      Y2-CASH-COMPANY-NO          
BASKAR     MOVE WS-DATABASE              TO C8-DELINQ-CD                
BASKAR     PERFORM 7800-SELECT-DATABASE  THRU 7800-EXIT                 
                                                                        
           PERFORM 7000-READ-FCSAC01                                    
              THRU 7000-EXIT.                                           
                                                                        
      ** CHECK FOR EMPTY INPUT FILE; IF EMPTY, DISPLAY MESSAGE                  
           IF WS-FCSAC01-AT-EOF                                         
              DISPLAY ' '                                               
              DISPLAY '******************************************'      
              DISPLAY '**   PCSAC170 PROCESSING INFORMATION    **'      
              DISPLAY '**   FCSAC01 FILE EMPTY.                **'      
              DISPLAY '**   FOR THIS RUN, NO BANCTEC CASH      **'      
              DISPLAY '**   REMITTANCE PAYMENTS OR PAYMENT     **'      
              DISPLAY '**   AGENCY PAYMENTS WERE READ.         **'      
              DISPLAY '**   PROCESSING WILL CONTINUE.          **'      
              DISPLAY '******************************************'      
           ELSE                                                         
      ** CHECK IF FIRST RECORD IS OF DETAIL TYPE; IF NOT, ABEND                 
              IF REC-TYPE-DET = WS-ONE                                  
T29106           MOVE MONTH-DET                 TO   WS-CHECK-MM        
T29106           MOVE DAY-DET                   TO   WS-CHECK-DD        
T29106           MOVE YEAR-DET                  TO   WS-CHECK-YY        
T29106           IF WS-CHECK-DATE NOT = WS-INPUT-DATE                   
T29106               DISPLAY ' '                                        
T29106               DISPLAY '****************************************' 
T29106               DISPLAY '** PCSAC170 PROCESSING ERROR          **' 
T29106               DISPLAY '** FCSAC01 FILE INPUT DATE '              
T29106                                             WS-CHECK-DATE ' **'  
T29106               DISPLAY '** NOT EQUAL COMMON DATE   '              
T29106                                             WS-INPUT-DATE ' **'  
T29106               DISPLAY '****************************************' 
T29106               PERFORM 9900-ABEND                                 
T29106                  THRU 9900-EXIT                                  
T29106           END-IF                                                 
                 MOVE REC-TYPE-DET       TO   WS-PREV-REC-TYPE          
                 PERFORM 1120-FETCH-CASH-OFFICE                         
                    THRU 1120-EXIT                                      
                 MOVE Y2-ERROR-GL-OFFSET TO WS-ERR-GL-ACCT              
              ELSE                                                      
                 STRING  '** FIRST RECORD IS NOT OF DETAIL TYPE **'     
                                                       DELIMITED BY SIZE
                 WS-FAC01-STATUS                       DELIMITED BY SIZE
                                         INTO WS-ERR-MSG                
                 PERFORM 8900-DISPLAY-ERR-TERM                          
                    THRU 8900-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7050-READ-FCSAC03                                    
              THRU 7050-EXIT                                            
                                                                        
           IF WS-FCSAC03-AT-EOF                                         
              DISPLAY ' '                                               
              DISPLAY '******************************************'      
              DISPLAY '**   PCSAC170 PROCESSING INFORMATION    **'      
              DISPLAY '**   FCSAC03 FILE EMPTY.                **'      
              DISPLAY '**   FOR THIS RUN,NO BANK DRAFT OR EPAY **'      
              DISPLAY '**   PAYMENTS WERE READ.                **'      
              DISPLAY '**   PROCESSING WILL CONTINUE.          **'      
              DISPLAY '******************************************'      
           ELSE                                                         
              IF C8-DELINQ-VALUE = WS-CSR                               
                 MOVE WS-025             TO Y2-CASH-LOCAL-OFFICE        
                                            WS-BATCH-DEP-CASH-OFF       
                                            WS-CASHIER-CASH-OFFICE      
              ELSE                                                      
                 MOVE WS-022             TO Y2-CASH-LOCAL-OFFICE        
                                            WS-BATCH-DEP-CASH-OFF       
                                            WS-CASHIER-CASH-OFFICE      
              END-IF                                                    
                                                                        
              MOVE SPACES                TO Y2-PAYMENT-SOURCE-CD        
              PERFORM 7510-SELECT-CSH-OFF   THRU 7510-EXIT              
              MOVE Y2-ERROR-GL-OFFSET    TO WS-ERR-GL-ACCT              
           END-IF                                                       
                                                                        
           IF WS-FCSAC01-AT-EOF  AND  WS-FCSAC03-AT-EOF                 
              STRING  '** BANCTEC AND BANK DRAFT FILES WERE EMPTY **'   
                                                       DELIMITED BY SIZE
                                         INTO WS-ERR-MSG                
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0200-OPEN-FILES                                             **        
      **                                                              **        
      ******************************************************************        
       0200-OPEN-FILES.                                                 
      *---------------*                                                         
           MOVE '0200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           OPEN INPUT FCSAC01-FILE.                                     
           IF WS-FAC01-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  '** FILE OPEN ERROR FCSAC01  **' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FAC01-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
           OPEN INPUT FCSAC03-FILE.                                     
           IF WS-FAC03-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  '** FILE OPEN ERROR FCSAC03  **' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FAC03-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSAC20-FILE.                                    
           IF WS-FAC20-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  '** FILE OPEN ERROR OF CIS OUTPUT FILE FCSAC20 **'
                                                       DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FAC20-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSAC21-FILE.                                    
           IF WS-FAC21-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  '** FILE OPEN ERROR OF PIPELINE OUTPUT FILE    **'
                                                       DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FAC21-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSAC22-FILE.                                    
           IF WS-FAC22-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  '**   OPEN ERROR OF ERROR OUTPUT FILE          **'
                                                       DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FAC22-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSAC24-FILE.                                    
           IF WS-FAC24-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  '**   OPEN ERROR OF DRAFT OUTPUT FILE          **'
                                                       DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FAC24-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0300-SETUP-DATES                                            **        
      **                                                              **        
      ******************************************************************        
       0300-SETUP-DATES.                                                
      *----------------*                                                        
           MOVE '0300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 6251-GET-FJC01-DATE                                  
              THRU 6251-EXIT.                                           
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '            TO WS-PGRMNAME                 
              MOVE SPACES                TO WS-INPUT-AREA               
              MOVE SPACES                TO WS-INPUT-DATA-BREAKDOWN     
              PERFORM 6251-GET-FJC01-DATE                               
                 THRU 6251-EXIT                                         
              MOVE 'PCSAC170'            TO WS-PGRMNAME                 
           END-IF.                                                      
                                                                        
       0300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0400-SETUP-GL-ACCTS                                         **        
      **                                                              **        
      ******************************************************************        
       0400-SETUP-GL-ACCTS.                                             
      *-------------------*                                                     
           MOVE '0400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-LIT-ZERO              TO CJ-CUSTOMER-NO.             
           MOVE WS-COMPANY               TO GO-COMPANY-NO.              
           MOVE 'CLR-CASH'               TO GO-GL-ACCT-NAME.            
                                                                        
           PERFORM 7900-SELECT-GL-ACCT-NO                               
              THRU 7900-EXIT.                                           
           MOVE  GO-GL-ACCT-NO           TO WS-CASH-GL-ACCT.            
                                                                        
           MOVE 'CLR-PST-ER'             TO GO-GL-ACCT-NAME.            
           PERFORM 7900-SELECT-GL-ACCT-NO                               
              THRU 7900-EXIT.                                           
           MOVE  GO-GL-ACCT-NO           TO WS-BNKXFR-GL-ACCT.          
                                                                        
T22767     MOVE 'CLR-SCPC'               TO GO-GL-ACCT-NAME.            
           PERFORM 7900-SELECT-GL-ACCT-NO                               
              THRU 7900-EXIT.                                           
           MOVE  GO-GL-ACCT-NO           TO WS-SCPC-GL-ACCT.            
                                                                        
                                                                        
       0400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    0500-PROCESS-DRAFTS                                       **        
      **                                                              **        
      **                                                              **        
      ******************************************************************        
       0500-PROCESS-DRAFTS.                                             
      *--------------------*                                                    
           MOVE '0500'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EVALUATE CSHCNACH-RECORD-TYPE                                
               WHEN 1                                                   
                  PERFORM 8000-WRITE-FCSAC24                            
                     THRU 8000-EXIT                                     
               WHEN 5                                                   
                  MOVE WS-20             TO WS-DRAFT-CC                 
                  MOVE CSHCNACH-5-CO-EFF-DATE-YY                        
                                         TO WS-DRAFT-YY                 
                  MOVE CSHCNACH-5-CO-EFF-DATE-MM                        
                                         TO WS-DRAFT-MM                 
                  MOVE CSHCNACH-5-CO-EFF-DATE-DD                        
                                         TO WS-DRAFT-DD                 
                  MOVE WS-DRAFT-DATE     TO CS-DATE-CASH-REPORT         
                  PERFORM 8000-WRITE-FCSAC24                            
                     THRU 8000-EXIT                                     
               WHEN 6                                                   
C29529            IF CSHCNACH-6-PYMT-POSTED-FL NOT = 'Y'                
                      ADD CSHCNACH-6-DRAFT-AMT                          
C29529                                   TO WS-DRAFT-TOTAL-AMOUNT-N     
C29529                ADD WS-ONE         TO WS-DRAFT-TOTAL-COUNT-N      
                      MOVE CSHCNACH-6-ID-NBR TO WS-DRAFT-ACCT-NO        
                      MOVE WS-DRAFT-ACCT-NO-NUM                         
                                         TO AT-ACCOUNT-NO               
                                            XR-OLD-ACCOUNT-NO           
                      MOVE CSHCNACH-6-DRAFT-AMT                         
                                         TO WS-AMT-9                    
                      PERFORM 1150-VALIDATE-DETAILS                     
                         THRU 1150-EXIT                                 
                      IF FIOAC21-REJECT-REASON EQUAL SPACES             
                          PERFORM 1140-GET-CIS-ACCOUNT                  
                             THRU 1140-EXIT                             
                                                                        
                          IF FIOAC21-REJECT-REASON EQUAL SPACES         
                             ADD WS-ONE       TO WS-DRAFT-BATCH-COUNT   
                             ADD CSHCNACH-6-DRAFT-AMT                   
                                              TO WS-DRAFT-BATCH-AMOUNT  
                             ADD CSHCNACH-6-TRANSITR-8                  
                                              TO WS-DRAFT-HASH-TOTAL    
                              PERFORM 8000-WRITE-FCSAC24                
                                 THRU 8000-EXIT                         
                          ELSE                                          
                             PERFORM 1400-PROCESS-ERR-REC               
                                THRU 1400-EXIT                          
                          END-IF                                        
                      ELSE                                              
                         IF AMOUNT-EQUALS-ZEROS AND                     
                            CSHCNACH-6-TRANSACTION-CODE EQUAL WS-28     
                             CONTINUE                                   
                         ELSE                                           
                             PERFORM 1400-PROCESS-ERR-REC               
                                THRU 1400-EXIT                          
                         END-IF                                         
                      END-IF                                            
                  ELSE                                                  
C29529                ADD WS-ONE         TO WS-DRAFT-TOTAL-COUNT-Y      
C29529                ADD CSHCNACH-6-DRAFT-AMT                          
C29529                                   TO WS-DRAFT-TOTAL-AMOUNT-Y     
C29529            END-IF                                                
               WHEN 8                                                   
                  MOVE WS-DRAFT-BATCH-COUNT                             
                    TO CSHCNACH-8-ENTRY-ADDENDA-COUNT                   
                  MOVE WS-DRAFT-BATCH-AMOUNT                            
                    TO CSHCNACH-8-TOTAL-DEBIT                           
                  MOVE WS-DRAFT-HASH-TOTAL                              
                    TO CSHCNACH-8-ENTRY-HASH                            
                                                                        
                  PERFORM 8000-WRITE-FCSAC24                            
                     THRU 8000-EXIT                                     
                  PERFORM 1500-WRITE-DRAFT-JOURNAL                      
                     THRU 1500-EXIT                                     
                  PERFORM 2800-WRITE-ERR-HEADER-REC                     
                     THRU 2800-EXIT                                     
                  PERFORM 2810-WRITE-ERR-TRAILER-REC                    
                     THRU 2810-EXIT                                     
               WHEN 9                                                   
                  PERFORM 1115-CHECK-DRAFT-TOTALS                       
                     THRU 1115-EXIT                                     
                                                                        
                  MOVE WS-DRAFT-BATCH-COUNT                             
                    TO CSHCNACH-9-ENTRY-ADDENDA-COUNT                   
                  MOVE WS-DRAFT-BATCH-AMOUNT                            
                    TO CSHCNACH-9-TOTAL-DEBIT                           
                  MOVE WS-DRAFT-HASH-TOTAL                              
                    TO CSHCNACH-9-ENTRY-HASH                            
                                                                        
      * HERE BLOCK COUNT IS NOT CALCULATED BECAUSE THIS FILE WILL GO TO         
      * BATCH PAYMENTS PROCESSING AND PAYMENTS WILL NOT USE THIS.               
                                                                        
                  PERFORM 8000-WRITE-FCSAC24                            
                     THRU 8000-EXIT                                     
           END-EVALUATE                                                 
                                                                        
           PERFORM 7050-READ-FCSAC03                                    
              THRU 7050-EXIT                                            
           .                                                            
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      **    1000-PROCESS-FCSAC01                                      **        
      **                                                              **        
      **                                                              **        
      ******************************************************************        
       1000-PROCESS-FCSAC01.                                            
      *--------------------*                                                    
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           IF  REC-TYPE-DET         NOT =   WS-PREV-REC-TYPE            
               PERFORM 1100-BATCH-BREAK                                 
                  THRU 1100-EXIT                                        
               GO TO 1000-CONTINUE
           END-IF.                                     
                                                                        
      ** INCREMENT RECORD COUNT & AMOUNT                       **               
           ADD WS-ONE                    TO WS-BATCH-TOTAL-COUNT.       
           ADD AMT-DET                   TO WS-BATCH-TOTAL-AMOUNT.      
                                                                        
      ** FINDS IF THE DETAIL REC IS OF CIS A/C                 **               
           MOVE ACCT-NO-9-DET            TO AT-ACCOUNT-NO               
                                            XR-OLD-ACCOUNT-NO.          
           MOVE AMT-DET                  TO WS-AMT-9                    
                                                                        
           PERFORM 1150-VALIDATE-DETAILS                                
              THRU 1150-EXIT                                            
                                                                        
           IF FIOAC21-REJECT-REASON EQUAL SPACES                        
              PERFORM 1140-GET-CIS-ACCOUNT                              
                 THRU 1140-EXIT                                         
                                                                        
              IF FIOAC21-REJECT-REASON EQUAL SPACES                     
                 PERFORM 1200-PROCESS-CIS-REC                           
                    THRU 1200-EXIT                                      
              ELSE                                                      
BASKAR              PERFORM 1400-PROCESS-ERR-REC                        
BASKAR                 THRU 1400-EXIT                                   
              END-IF                                                    
           ELSE                                                         
              PERFORM 1400-PROCESS-ERR-REC                              
                 THRU 1400-EXIT                                         
           END-IF.                                                      
                                                                        
                                                                        
       1000-CONTINUE.                                                   
           PERFORM 7000-READ-FCSAC01                                    
              THRU 7000-EXIT.                                           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    1100-BATCH-BREAK                                          **        
      **                                                              **        
      **        VERIFIES IF THE SUM  AND TOTAL NUMBER OF RECORDS IN   **        
      **        DETAIL MATCHES WITH THE AMOUNT AND TOTAL NUMBER OF    **        
      **        ENTRIES REPORTED ON THE HEADER BY BANCTEC.            **        
      ******************************************************************        
       1100-BATCH-BREAK.                                                
      *----------------*                                                        
           MOVE '1100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
      **   ABEND IF RECORD TYPE IS NOT A HEADER                 **              
           IF REC-TYPE-DET NOT = WS-THREE                               
              STRING 'RECORD NOT HEADER' DELIMITED BY SIZE              
                     'RECORD TYPE : '    DELIMITED BY SIZE              
                     REC-TYPE-BTR,       DELIMITED BY SIZE              
                     'OUT SEQ NO : '     DELIMITED BY SIZE              
                     OUT-SEQ-NO-BTR,     DELIMITED BY SIZE              
                     'BATCH NO: '        DELIMITED BY SIZE              
A03311               REPORT-BTR2,        DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
               PERFORM 8900-DISPLAY-ERR-TERM                            
                  THRU 8900-EXIT                                        
                                                                        
           END-IF.                                                      
                                                                        
      **   CHECKS IF HEADER COUNT & AMOUNT MATCHES WITH SUM OF   **             
      **   ACTUAL DETAIL RECORD COUNT & AMOUNT                  **              
                                                                        
           PERFORM 1110-CHECK-BATCH-TOTALS                              
              THRU 1110-EXIT.                                           
                                                                        
                                                                        
           IF Y2-PAYMENT-AGENT-FL = WS-Y                                
              SET WS-AGENT               TO TRUE                        
              PERFORM 1400-PROCESS-ERR-REC                              
                 THRU 1400-EXIT                                         
           ELSE                                                         
C33928        SET WS-MAIL                TO TRUE                        
C33928        PERFORM 1400-PROCESS-ERR-REC                              
C33928           THRU 1400-EXIT                                         
           END-IF                                                       
                                                                        
C28301     IF WS-CIS-NO-OF-DOCS = 0 AND WS-CIS-BATCH-TOTAL = 0          
C28301        CONTINUE                                                  
C28301     ELSE                                                         
              PERFORM 2600-WRITE-CIS-HEADER-REC                         
                 THRU 2600-EXIT                                         
C28301     END-IF                                                       
                                                                        
           PERFORM 2700-WRITE-PIP-HEADER-REC                            
              THRU 2700-EXIT.                                           
           PERFORM 2710-WRITE-PIP-TRAILER-REC                           
              THRU 2710-EXIT.                                           
                                                                        
           PERFORM 2800-WRITE-ERR-HEADER-REC                            
              THRU 2800-EXIT.                                           
           PERFORM 2810-WRITE-ERR-TRAILER-REC                           
              THRU 2810-EXIT.                                           
                                                                        
      ** RESETTING ALL COUNTERS WHENEVER BATCH GETS CHANGED                     
           MOVE ZEROES                   TO WS-BATCH-TOTAL-COUNT,       
                                            WS-BATCH-TOTAL-AMOUNT,      
                                            WS-CIS-NO-OF-DOCS,          
                                            WS-CIS-BATCH-TOTAL,         
                                            WS-SCPC-NO-OF-DOCS,         
                                            WS-SCPC-BATCH-TOTAL,        
                                            WS-ERR-NO-OF-DOCS,          
                                            WS-ERR-BATCH-TOTAL.         
           MOVE WS-ONE                   TO WS-PREV-REC-TYPE.           
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1110-CHECK-BATCH-TOTALS                                     **        
      **                                                              **        
      ******************************************************************        
        1110-CHECK-BATCH-TOTALS.                                        
      *----------------------*                                                  
           MOVE '1110'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           IF TOTAL-NO-DOCS-BTR = WS-BATCH-TOTAL-COUNT                  
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING '** BKT HEADER PROBLEM. NO OF ENTRIES  **'        
                                             DELIMITED BY SIZE          
                      'ON HEADER RECORD DO NOT MATCH ACTUAL  **'        
                                             DELIMITED BY SIZE          
                                         INTO    WS-ERR-MSG             
               STRING 'BATCH NUMBER  '        DELIMITED BY SIZE         
                       WS-PREV-BATCH-NO,      DELIMITED BY SIZE         
                     ',HEADER NO OF ENTRIES ' DELIMITED BY SIZE         
                       TOTAL-NO-DOCS-BTR,     DELIMITED BY SIZE         
                     ',ACTUAL NO OF ENTRIES ' DELIMITED BY SIZE         
                       WS-BATCH-TOTAL-COUNT   DELIMITED BY SIZE         
                                         INTO WS-ERR-MSG2               
               PERFORM 8900-DISPLAY-ERR-TERM                            
                  THRU 8900-EXIT                                        
           END-IF.                                                      
                                                                        
           IF DOC-TOTAL-BTR = WS-BATCH-TOTAL-AMOUNT                     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE DOC-TOTAL-BTR        TO WS-DISP-FILE-AMOUNT         
               MOVE WS-BATCH-TOTAL-AMOUNT                               
                                         TO WS-DISP-TOTAL-AMOUNT        
               STRING  '** BKT HEADER PROBLEM.TOTAL AMOUNT IN '         
                                             DELIMITED BY SIZE          
                       'THE FILE IS NOT EQUAL ACTUAL FILE AMT.**'       
                                             DELIMITED BY SIZE          
                                         INTO    WS-ERR-MSG             
               STRING 'BATCH NUMBER  '       DELIMITED BY SIZE          
                      WS-PREV-BATCH-NO,      DELIMITED BY SIZE          
                    'FILE AMOUNT '           DELIMITED BY SIZE          
                      WS-DISP-FILE-AMOUNT,   DELIMITED BY SIZE          
                    'ACTUAL AMOUNT '         DELIMITED BY SIZE          
                      WS-DISP-TOTAL-AMOUNT,  DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8900-DISPLAY-ERR-TERM                            
                  THRU 8900-EXIT                                        
           END-IF.                                                      
                                                                        
           MOVE MONTH-BTR                TO WS-AC01-MM.                 
           MOVE DAY-BTR                  TO WS-AC01-DD.                 
           MOVE YEAR-BTR                 TO WS-AC01-YY.                 
                                                                        
           IF WS-AC01-YY > 50                                           
                 MOVE WS-19              TO WS-AC01-CC                  
           ELSE                                                         
                 MOVE WS-20              TO WS-AC01-CC                  
           END-IF.                                                      
                                                                        
       1110-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      **  1115-CHECK-DRAFT-TOTALS                                     **        
      **                                                              **        
      ******************************************************************        
        1115-CHECK-DRAFT-TOTALS.                                        
      *----------------------*                                                  
           MOVE '1115'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
                                                                        
C29529     COMPUTE WS-DRAFT-TOTAL-COUNT-ALL =                           
C29529             WS-DRAFT-TOTAL-COUNT-N + WS-DRAFT-TOTAL-COUNT-Y      
C29529     DISPLAY WS-DRAFT-TOTAL-COUNT-ALL                             
C29529     DISPLAY WS-DRAFT-TOTAL-COUNT-N                               
C29529     DISPLAY WS-DRAFT-TOTAL-COUNT-Y                               
C29529     IF WS-DRAFT-TOTAL-COUNT-ALL = CSHCNACH-9-ENTRY-ADDENDA-COUNT 
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING '** DRAFT PROBLEM. NO OF ENTRIES '                
                                              DELIMITED BY SIZE         
                      'ON TRAILER RECORD DO NOT MATCH ACTUAL  **'       
                                              DELIMITED BY SIZE         
                                         INTO    WS-ERR-MSG             
               STRING 'DRAFT FILE COUNT  '    DELIMITED BY SIZE         
              CSHCNACH-9-ENTRY-ADDENDA-COUNT, DELIMITED BY SIZE         
                    ', ACTUAL NO OF ENTRIES ' DELIMITED BY SIZE         
                       WS-DRAFT-TOTAL-COUNT-ALL  DELIMITED BY SIZE      
                                         INTO WS-ERR-MSG2               
               PERFORM 8900-DISPLAY-ERR-TERM                            
                  THRU 8900-EXIT                                        
           END-IF.                                                      
                                                                        
C29529     COMPUTE WS-DRAFT-TOTAL-AMOUNT-ALL =                          
C29529             WS-DRAFT-TOTAL-AMOUNT-N + WS-DRAFT-TOTAL-AMOUNT-Y    
C29529     DISPLAY WS-DRAFT-TOTAL-AMOUNT-ALL                            
C29529     DISPLAY WS-DRAFT-TOTAL-AMOUNT-N                              
C29529     DISPLAY WS-DRAFT-TOTAL-AMOUNT-Y                              
C29529     IF WS-DRAFT-TOTAL-AMOUNT-ALL = CSHCNACH-9-TOTAL-DEBIT        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE CSHCNACH-9-TOTAL-DEBIT                              
                                         TO WS-DISP-FILE-AMOUNT         
               MOVE WS-DRAFT-TOTAL-AMOUNT-ALL                           
                                         TO WS-DISP-TOTAL-AMOUNT        
               STRING  '** DRAFT PROBLEM.TRAILER AMOUNT IS '            
                                             DELIMITED BY SIZE          
                       'DIFFERENT FROM DETAIL TOTAL AMOUNT.**'          
                                             DELIMITED BY SIZE          
                                         INTO    WS-ERR-MSG             
               STRING 'DRAFT AMOUNT  '       DELIMITED BY SIZE          
                 WS-DISP-FILE-AMOUNT ,       DELIMITED BY SIZE          
                    ', ACTUAL AMOUNT '       DELIMITED BY SIZE          
                WS-DISP-TOTAL-AMOUNT         DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8900-DISPLAY-ERR-TERM                            
                  THRU 8900-EXIT                                        
           END-IF                                                       
           .                                                            
       1115-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1120-FETCH-CASH-OFFICE                                      **        
      **                                                              **        
      ******************************************************************        
       1120-FETCH-CASH-OFFICE.                                          
      *----------------------*                                                  
           MOVE '1120'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
C28301     IF C8-DELINQ-VALUE = WS-CSR                                  
C28301        MOVE WS-1                  TO WS-PAYMENT-SOURCE-1         
C28301     ELSE                                                         
C28301        MOVE WS-2                  TO WS-PAYMENT-SOURCE-1         
C28301     END-IF                                                       
                                                                        
           MOVE WS-COMPANY               TO Y2-CASH-COMPANY-NO.         
           MOVE BATCH-TYPE-DET2          TO WS-PAYMENT-SOURCE-2.        
           MOVE WS-PAYMENT-SOURCE-CD     TO Y2-PAYMENT-SOURCE-CD.       
                                                                        
           PERFORM 7500-SELECT-CASH-OFFICE                              
              THRU 7500-EXIT.                                           
                                                                        
       1120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1130-GET-CASHIER-CODE                                       **        
      **                                                              **        
      ******************************************************************        
       1130-GET-CASHIER-CODE.                                           
      *---------------------*                                                   
           MOVE '1130'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-CASHIER-USER-ID       TO Y1-USER-ID.                 
           MOVE WS-COMPANY               TO Y1-CASH-COMPANY-NO.         
                                                                        
            PERFORM 7550-SELECT-CASHIER-CODE                            
               THRU 7550-EXIT.                                          
                                                                        
       1130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1140-GET-CIS-ACCOUNT                                        **        
      **                                                              **        
      ******************************************************************        
       1140-GET-CIS-ACCOUNT.                                            
      *--------------------*                                                    
           MOVE '1140'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-N                     TO WS-EXISTS-FLAG              
A02388                                      WS-ARCHIVE-FLAG.            
                                                                        
           PERFORM 7100-SELECT-CIS-ACCOUNT                              
              THRU 7100-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7200-GET-OLD-ACCOUNT                              
                 THRU 7200-EXIT                                         
                                                                        
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                WHEN SUCCESSFUL-CALL                                    
                  IF WS-DRAFT                                           
                     MOVE XR-NEW-ACCOUNT-NO TO WS-DRAFT-ACCT-NO-NUM     
                                               AT-ACCOUNT-NO            
                                               CSHCNACH-6-ID-NBR        
                  ELSE                                                  
                     MOVE XR-NEW-ACCOUNT-NO TO ACCT-NO-9-DET            
                                               AT-ACCOUNT-NO            
                  END-IF                                                
                  PERFORM 7100-SELECT-CIS-ACCOUNT                       
                     THRU 7100-EXIT                                     
                WHEN NOT-FOUND                                          
A02388             PERFORM 7140-CHECK-ARCHIVED-ACCTS THRU 7140-EXIT     
A02388             IF WS-ARCHIVE-FLAG = 'Y'                             
A02388                SET ACCOUNT-IS-ARCHIVED TO TRUE                   
A02388             ELSE                                                 
A02388                SET ACCOUNT-NOT-FOUND TO TRUE                     
A02388             END-IF                                               
                   GO TO 1140-EXIT                                      
                WHEN MULTIPLE-ROWS-SELECTED                             
                   SET MULTIPLE-OLD-ACCOUNTS TO TRUE                    
                   GO TO 1140-EXIT                                      
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
           MOVE AT-CUSTOMER-NO           TO CJ-CUSTOMER-NO              
                                            CU-CUSTOMER-NO              
           PERFORM 7240-SELECT-CUST      THRU 7240-EXIT                 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              SET CUSTOMER-ROW-NOT-FOUND TO TRUE                        
              GO TO 1140-EXIT                                           
           END-IF                                                       
                                                                        
           IF AT-CODE-ACCT-STAT = WS-J                                  
              SET ACCOUNT-IS-INACTIVE    TO TRUE                        
              GO TO 1140-EXIT                                           
           END-IF                                                       
           .                                                            
       1140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1150-VALIDATE-DETAILS                                       **        
      **                                                              **        
      ******************************************************************        
       1150-VALIDATE-DETAILS.                                           
      *---------------------*                                                   
           MOVE '1150'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE SPACES                   TO FIOAC21-REJECT-REASON       
                                                                        
           IF WS-DRAFT                                                  
              IF WS-DRAFT-ACCT-NO-NUM NOT NUMERIC                       
                 SET ACCOUNT-NOT-NUMERIC TO TRUE                        
              END-IF                                                    
           ELSE                                                         
              IF ACCT-NO-9-DET NOT NUMERIC                              
                 SET ACCOUNT-NOT-NUMERIC TO TRUE                        
A01987           MOVE ZERO  TO ACCT-NO-9-DET                            
              END-IF                                                    
C25923        IF PAY-CD-DET EQUAL '1'                                   
C25923           SET APS-DIRECTED-PYMT TO TRUE                          
C25923        END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-AMT-X NOT NUMERIC                                      
              SET AMOUNT-NOT-NUMERIC     TO TRUE                        
           END-IF                                                       
                                                                        
           IF WS-AMT-9 EQUAL ZEROES                                     
              SET AMOUNT-EQUALS-ZEROS    TO TRUE                        
           END-IF                                                       
           .                                                            
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1200-PROCESS-CIS-REC                                        **        
      **                                                              **        
      ******************************************************************        
       1200-PROCESS-CIS-REC.                                            
      *--------------------*                                                    
           MOVE '1200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           ADD AMT-DET                     TO WS-CIS-BATCH-TOTAL.       
           ADD WS-ONE                      TO WS-CIS-NO-OF-DOCS.        
                                                                        
           WRITE FIOAC20-REC             FROM DETAIL-REC.               
                                                                        
           IF WS-FAC20-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING '** FILE WRITE ERROR FCSAC20 **' DELIMITED BY SIZE 
              WS-FAC20-STATUS                         DELIMITED BY SIZE 
                                         INTO WS-ERR-MSG                
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1300-PROCESS-SCPC-REC                                       **        
      **                                                              **        
      ******************************************************************        
       1300-PROCESS-SCPC-REC.                                           
      *---------------------*                                                   
           MOVE '1300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           ADD WS-ONE                    TO WS-SCPC-NO-OF-DOCS.         
           ADD AMT-DET                   TO WS-SCPC-BATCH-TOTAL.        
                                                                        
           MOVE FIOAC21-REJECT-REASON    TO WS-REJECT-REASON            
           INITIALIZE                   FIOAC21-NON-CIS-PMT-DTL-REC.    
                                                                        
           MOVE WS-SCPC-SEQ-NO           TO FIOAC21-NCP-DTL-SEQ-NO.     
           MOVE ACCT-NO-9-DET            TO FIOAC21-NCP-DTL-ACCT-NO.    
           MOVE WS-REJECT-REASON         TO FIOAC21-REJECT-REASON.      
           MOVE AMT-DET                  TO FIOAC21-NCP-DTL-PMT-AMT.    
           MOVE WS-SCPC-GL-ACCT          TO FIOAC21-NCP-DTL-CR-GL.      
           MOVE WS-CASH-GL-ACCT          TO FIOAC21-NCP-DTL-DR-GL.      
           MOVE WS-AC21                  TO FIOAC21-NCP-DTL-TRAN-ID.    
                                                                        
           WRITE FIOAC21-REC FROM FIOAC21-NON-CIS-PMT-DTL-REC.          
                                                                        
           IF WS-FAC21-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING '** FILE WRITE ERROR FCSAC21 **' DELIMITED BY SIZE 
              WS-FAC21-STATUS                         DELIMITED BY SIZE 
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1400-PROCESS-ERR-REC                                        **        
      **                                                              **        
      ******************************************************************        
       1400-PROCESS-ERR-REC.                                            
      *--------------------*                                                    
           MOVE '1400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE FIOAC21-REJECT-REASON    TO WS-REJECT-REASON            
           INITIALIZE                       FIOAC21-NON-CIS-PMT-DTL-REC.
                                                                        
           ADD WS-ONE                    TO WS-ERR-NO-OF-DOCS.          
                                                                        
           MOVE WS-REJECT-REASON         TO FIOAC21-REJECT-REASON.      
           MOVE WS-ERR-SEQ-NO            TO FIOAC21-NCP-DTL-SEQ-NO.     
           MOVE WS-ERR-GL-ACCT           TO FIOAC21-NCP-DTL-CR-GL.      
           MOVE WS-CASH-GL-ACCT          TO FIOAC21-NCP-DTL-DR-GL.      
           MOVE WS-AC22                  TO FIOAC21-NCP-DTL-TRAN-ID     
                                                                        
           EVALUATE TRUE                                                
               WHEN WS-DRAFT                                            
                 ADD CSHCNACH-6-DRAFT-AMT   TO WS-ERR-BATCH-TOTAL       
                 MOVE WS-DRAFT-ACCT-NO-NUM  TO FIOAC21-NCP-DTL-ACCT-NO  
                 MOVE CSHCNACH-6-DRAFT-AMT  TO FIOAC21-NCP-DTL-PMT-AMT  
               WHEN WS-AGENT                                            
                 ADD WS-BATCH-TOTAL-AMOUNT  TO WS-ERR-BATCH-TOTAL       
                 MOVE WS-BATCH-TOTAL-AMOUNT TO FIOAC21-NCP-DTL-PMT-AMT  
                 MOVE ZERO               TO FIOAC21-NCP-DTL-ACCT-NO     
                 MOVE WS-J               TO FIOAC21-REJECT-REASON       
                 MOVE WS-CASH-GL-ACCT    TO FIOAC21-NCP-DTL-CR-GL       
                 MOVE Y2-DEP-CASH-GL-OFFSET TO FIOAC21-NCP-DTL-DR-GL    
                 MOVE WS-AC23            TO FIOAC21-NCP-DTL-TRAN-ID     
                 SET  WS-OTHERS          TO TRUE                        
               WHEN WS-MAIL                                             
                 ADD WS-BATCH-TOTAL-AMOUNT  TO WS-ERR-BATCH-TOTAL       
                 MOVE WS-BATCH-TOTAL-AMOUNT TO FIOAC21-NCP-DTL-PMT-AMT  
                 MOVE ZERO               TO FIOAC21-NCP-DTL-ACCT-NO     
                 MOVE WS-N               TO FIOAC21-REJECT-REASON       
                 MOVE WS-CASH-GL-ACCT    TO FIOAC21-NCP-DTL-CR-GL       
                 MOVE WS-CASH-GL-ACCT    TO FIOAC21-NCP-DTL-DR-GL       
                 MOVE WS-AC24            TO FIOAC21-NCP-DTL-TRAN-ID     
                 SET  WS-OTHERS          TO TRUE                        
               WHEN WS-OTHERS                                           
                 ADD AMT-DET             TO WS-ERR-BATCH-TOTAL          
                 MOVE ACCT-NO-9-DET      TO FIOAC21-NCP-DTL-ACCT-NO     
                 MOVE AMT-DET            TO FIOAC21-NCP-DTL-PMT-AMT     
           END-EVALUATE                                                 
                                                                        
           WRITE FIOAC22-REC FROM FIOAC21-NON-CIS-PMT-DTL-REC.          
                                                                        
           IF WS-FAC22-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING '** FILE WRITE ERROR FCSAC22 **' DELIMITED BY SIZE 
              WS-FAC22-STATUS                         DELIMITED BY SIZE 
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1500-WRITE-DRAFT-JOURNAL.                                   **        
      **                                                              **        
      ******************************************************************        
       1500-WRITE-DRAFT-JOURNAL.                                        
      *-------------------------*                                               
           MOVE '1500'                    TO WS-ACTIVE-PARAGRAPH.       
                                                                        
           INITIALIZE                       DCLCSS-CSH-DRWR-CNTL,       
                                            DCLCSS-CSH-DRWR-JRNL,       
                                            DCLCSS-BANK-TRANSFER.       
                                                                        
           MOVE WS-COMPANY               TO YR-CASH-COMPANY-NO,         
                                            CS-CASH-COMPANY-NO,         
                                            Y1-CASH-COMPANY-NO,         
                                            GO-COMPANY-NO.              
           MOVE WS-LIT-C                 TO CS-CODE-CSH-DRWR-STAT.      
                                                                        
           SET AUTOMATIC-TRANSFER        TO TRUE                        
                                                                        
           MOVE Y2-BATCH-DEP-CASH-OFF    TO WS-BATCH-DEP-CASH-OFF,      
                                            CS-CASH-LOCAL-OFFICE,       
                                            YR-CASH-LOCAL-OFFICE.       
           MOVE Y2-USER-ID               TO WS-CASHIER-USER-ID,         
                                            YR-USER-ID.                 
           MOVE Y2-LOCAL-OFFICE          TO WS-CASHIER-LOCAL-OFFICE     
           MOVE Y2-DEP-DEFT-BANK-ID      TO WS-CASHIER-BANK-ID          
                                                                        
           PERFORM 1130-GET-CASHIER-CODE                                
              THRU 1130-EXIT.                                           
                                                                        
           PERFORM 7560-SELECT-BANK-ST-CD                               
              THRU 7560-EXIT.                                           
                                                                        
           PERFORM 7700-GET-CURRENT-TIMESTAMP                           
              THRU 7700-EXIT.                                           
                                                                        
           MOVE WS-LIT-C                 TO CS-CODE-CSH-DRWR-STAT,      
                                            YR-STATUS.                  
           MOVE WS-DRAFT-DATE            TO CS-DATE-CASH-REPORT,        
                                            YR-DATE-CASH-REPORT.        
           MOVE WS-XFR-TS                TO YR-CLOSED-TS.               
                                                                        
           PERFORM 7325-SELECT-CASH-REPORT                              
              THRU 7325-EXIT                                            
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8325-CREATE-CASH-REPORT                           
                 THRU 8325-EXIT                                         
           END-IF                                                       
                                                                        
           PERFORM 7450-GET-MAX-DRFT-DRWR                               
              THRU 7450-EXIT.                                           
                                                                        
           ADD  WS-ONE                   TO CS-CASH-DRAWER-ID           
                                                                        
           PERFORM 2100-WRITE-CNTL-JRNL-AUTO                            
              THRU 2100-EXIT                                            
                                                                        
           PERFORM 2200-WRITE-BANK-XFR                                  
              THRU 2200-EXIT                                            
           .                                                            
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2000-WRITE-JRNLS-BNKXFR                                     **        
      **                                                              **        
      ******************************************************************        
       2000-WRITE-JRNLS-BNKXFR.                                         
      *-----------------------*                                                 
           MOVE '2000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           IF  AUTOMATIC-TRANSFER                                       
A03311         MOVE REPORT-BTR2          TO CS-CASH-DRAWER-ID           
               MOVE WS-LIT-C             TO CS-CODE-CSH-DRWR-STAT       
                                                                        
               PERFORM 2100-WRITE-CNTL-JRNL-AUTO                        
                  THRU 2100-EXIT                                        
                                                                        
               PERFORM 2200-WRITE-BANK-XFR                              
                  THRU 2200-EXIT                                        
           ELSE                                                         
               PERFORM 2300-WRITE-CNTL-JRNL-MANUAL                      
                  THRU 2300-EXIT                                        
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2100-WRITE-CNTL-JRNL-AUTO                                   **        
      **      CASH DRAWER CONTROL AND JOURNAL ENTRIES ARE CREATED     **        
      **      FOR AUTOATIC TRANSACTIONS                               **        
      ******************************************************************        
       2100-WRITE-CNTL-JRNL-AUTO.                                       
      *-------------------------*                                               
           MOVE '2100'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
      ** POPULATES CNTL RECORD                                                  
           PERFORM 2120-SET-CASH-DRWR-CNTL-VALUES                       
              THRU 2120-EXIT.                                           
                                                                        
           PERFORM 8200-CREATE-CASH-DRWR-CNTL                           
              THRU 8200-EXIT.                                           
                                                                        
      *   POPULATES JOURNAL RECORD                                              
                                                                        
           PERFORM 2150-SET-CASH-DRWR-JRNL-VALUES                       
              THRU 2150-EXIT.                                           
                                                                        
                                                                        
      *   POPULATES TRAN-DATA VALUES - COPYBOOK CJF00101                        
                                                                        
           PERFORM 2160-POPULATE-TRAN-DATA                              
              THRU 2160-EXIT.                                           
           MOVE CJF00101                 TO CJ-TRAN-DATA.               
                                                                        
           PERFORM 8300-CREATE-CASH-DRWR-JRNL                           
              THRU 8300-EXIT.                                           
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2120-SET-CASH-DRWR-CNTL-VALUES                              **        
      **                                                              **        
      **                                                              **        
      ******************************************************************        
       2120-SET-CASH-DRWR-CNTL-VALUES.                                  
      *-------------------------*                                               
           MOVE '2120'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-COMPANY               TO CS-CASH-COMPANY-NO.         
           MOVE WS-BATCH-DEP-CASH-OFF    TO CS-CASH-LOCAL-OFFICE,       
                                            CS-CASH-REPORT-NO.          
           MOVE WS-CASHIER-USER-ID       TO CS-USER-ID.                 
                                                                        
           MOVE WS-ZERO                  TO CS-AMT-CASH-DEBIT,          
                                            CS-AMT-CASH-CREDIT,         
                                            CS-AMT-AR-DEBIT,            
                                            CS-AMT-AR-CREDIT,           
                                            CS-AMT-CK-ISS-DEBIT,        
                                            CS-AMT-CK-ISS-CREDIT,       
                                            CS-AMT-GL-DEBIT,            
                                            CS-AMT-GL-CREDIT,           
                                            CS-AMT-CASH-BEGIN-BAL,      
                                            CS-AMT-BASIC-WORK.          
                                                                        
           IF WS-DRAFT                                                  
              MOVE WS-DRAFT-DATE           TO CS-DATE-CASH-REPORT       
C29529        MOVE WS-DRAFT-TOTAL-AMOUNT-N TO CS-AMT-CASH-DEBIT         
                                              CS-AMT-CASH-CREDIT        
              MOVE WS-LIT-D                TO CS-CODE-PYMT-FACILITY     
           ELSE                                                         
              MOVE WS-AC01-DATE          TO CS-DATE-CASH-REPORT         
              MOVE WS-BATCH-TOTAL-AMOUNT TO CS-AMT-CASH-DEBIT           
                                            CS-AMT-CASH-CREDIT          
              MOVE WS-M                  TO CS-CODE-PYMT-FACILITY       
           END-IF                                                       
                                                                        
           MOVE WS-ONE                   TO CS-NO-ITEMS-ENTERED.        
                                                                        
           MOVE WS-INPUT-DATE            TO CS-DATE-LAST-ACTIVITY.      
           MOVE Y1-CASHIER-CODE          TO CS-CASHIER-CODE.            
           MOVE SPACES                   TO CS-CODE-FCS-EXTRACTED.      
                                                                        
           IF AUTOMATIC-TRANSFER                                        
              MOVE WS-XFR-TS             TO CS-BALANCED-TS              
              MOVE WS-ZERO               TO WS-CNTL-TS-NI               
              MOVE WS-CASHIER-USER-ID    TO CS-BALANCED-BY              
           ELSE                                                         
              MOVE SPACES                TO CS-BALANCED-BY              
              MOVE -1                    TO WS-CNTL-TS-NI               
           END-IF.                                                      
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2150-SET-CASH-DRWR-JRNL-VALUES                              **        
      ******************************************************************        
       2150-SET-CASH-DRWR-JRNL-VALUES.                                  
      *------------------------------*                                          
           MOVE '2150'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE CS-CASH-COMPANY-NO       TO CJ-CASH-COMPANY-NO,         
                                            CJ-COMPANY-NO.              
           MOVE CS-CASH-LOCAL-OFFICE     TO CJ-CASH-LOCAL-OFFICE,       
                                            CJ-CASH-REPORT-NO.          
           MOVE WS-ONE                   TO CJ-TRAN-APPL-NO.            
           MOVE CS-NO-ITEMS-ENTERED      TO CJ-ENTRY-NO.                
           MOVE CS-CASH-DRAWER-ID        TO CJ-CASH-DRAWER-ID.          
           MOVE WS-CASHIER-LOCAL-OFFICE  TO CJ-LOCAL-OFFICE,            
                                            CJ-ENTRY-LOC.               
           MOVE WS-LIT-A                 TO CJ-JRNL-SORT-ID.            
           MOVE WS-ALL9-ACNO             TO CJ-ACCOUNT-NO.              
           MOVE WS-ZERO                  TO CJ-GL-ACCT-NO.              
           MOVE WS-METER-NO              TO CJ-METER-NO.                
           MOVE WS-ZERO                  TO CJ-TRAN-COMMENT-LEN.        
           MOVE SPACES                   TO CJ-TRAN-COMMENT-TEXT.       
                                                                        
           MOVE WS-TRAN-TIME             TO CJ-TRAN-TIME.               
           MOVE WS-TRAN-ID               TO CJ-TRAN-ID.                 
           MOVE CS-DATE-CASH-REPORT      TO CJ-DATE-CASH-REPORT.        
           MOVE WS-INPUT-DATE            TO CJ-DATE-TRAN.               
           MOVE WS-INPUT-DATE            TO CJ-DATE-LAST-ACTION.        
           MOVE WS-LIT-A                 TO CJ-CODE-ENTRY-SOURCE.       
           MOVE CS-USER-ID               TO CJ-USER-ID.                 
           MOVE SPACES                   TO CJ-BATCH-SEND-LOC.          
           MOVE SPACES                   TO CJ-ENTRY-LOC.               
           MOVE SPACES                   TO CJ-CODE-TRAN-ERRORS.        
           MOVE SPACES                   TO CJ-CODE-JRNL-EXTRACT.       
           MOVE SPACES                   TO CJ-CODE-STATUS.             
           MOVE WS-LIT-C                 TO CJ-CURRENCY-TYPE.           
           MOVE CS-CODE-PYMT-FACILITY    TO CJ-CODE-PYMT-FACILITY.      
           MOVE SPACES                   TO CJ-CSR-PC-ID.               
           MOVE WS-ZERO                  TO CJ-CUSTOMER-NO.             
                                                                        
           MOVE SPACES                   TO CJ-BALANCED-BY.             
           MOVE -1                       TO WS-CJ-DATE-NI               
                                            WS-CJ-TIME-NI.              
                                                                        
           IF  AUTOMATIC-TRANSFER                                       
               MOVE WS-INPUT-DATE        TO CJ-DATE-BALANCED            
               MOVE WS-TRAN-TIME         TO CJ-TIME-BALANCED            
               MOVE WS-ZERO              TO WS-CJ-DATE-NI               
                                            WS-CJ-TIME-NI               
               MOVE WS-CASHIER-USER-ID   TO CJ-BALANCED-BY              
           END-IF.                                                      
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2160-POPULATE-TRAN-DATA                                     **        
      **                                                              **        
      ******************************************************************        
       2160-POPULATE-TRAN-DATA.                                         
      *-----------------------*                                                 
           MOVE '2160'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE SPACES                   TO CJF00101.                   
           MOVE WS-101                   TO WS-101-JRNL-FORMAT-NO.      
           MOVE WS-ONE                   TO WS-101-CASH-DRAWER-USED.    
                                                                        
           IF WS-DRAFT                                                  
C29529        MOVE WS-DRAFT-TOTAL-AMOUNT-N TO WS-101-AMOUNT-ENTERED     
                                              WS-101-AMT-POSTED         
           ELSE                                                         
              MOVE WS-BATCH-TOTAL-AMOUNT TO WS-101-AMOUNT-ENTERED       
                                            WS-101-AMT-POSTED           
           END-IF                                                       
                                                                        
           MOVE WS-CASH-GL-ACCT          TO WS-101-ACCT-GEN-LED-DR.     
           IF AUTOMATIC-TRANSFER                                        
              MOVE WS-CASH-GL-ACCT       TO WS-101-ACCT-GEN-LED-CR      
           ELSE                                                         
              MOVE WS-BNKXFR-GL-ACCT     TO WS-101-ACCT-GEN-LED-CR      
           END-IF.                                                      
                                                                        
           MOVE ZEROES                   TO WS-101-ITEM-ID-NO,          
                                            WS-101-DETAIL-END-AR-BAL,   
                                            WS-101-ACCT-END-AR-BAL,     
                                            WS-101-REVENUE-MONTH.       
                                                                        
           MOVE WS-CASHIER-BANK-ID       TO WS-101-FCS-DEP-BANK-CD.     
           MOVE D1-FCS-DEP-BANK-ST-CD    TO WS-101-FCS-DEP-BANK-ST-CD.  
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2200-WRITE-BANK-XFR                                         **        
      **                                                              **        
      ******************************************************************        
       2200-WRITE-BANK-XFR.                                             
      *----------------------*                                                  
           MOVE '2200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-COMPANY               TO YB-CASH-COMPANY-NO.         
           MOVE Y2-BATCH-DEP-CASH-OFF    TO YB-CASH-LOCAL-OFFICE.       
           MOVE CS-CASH-DRAWER-ID        TO YB-CASH-DRAWER-ID.          
           MOVE CS-DATE-CASH-REPORT      TO YB-DATE-CASH-REPORT.        
           MOVE WS-CASHIER-USER-ID       TO YB-USER-ID.                 
           MOVE WS-CASHIER-BANK-ID       TO YB-BANK-ID.                 
                                                                        
           IF WS-DRAFT                                                  
C29529        MOVE WS-DRAFT-TOTAL-AMOUNT-N TO YB-TRANSFER-AMT           
              MOVE WS-DRAFT-DATE           TO WS-NEW-BUSINESS-DAY       
           ELSE                                                         
              MOVE DOC-TOTAL-BTR         TO YB-TRANSFER-AMT             
              MOVE WS-AC01-DATE          TO WS-NEW-BUSINESS-DAY         
           END-IF                                                       
                                                                        
           PERFORM Y2-PYMT-TO-POST-DAYS TIMES                           
              MOVE WS-N                  TO WS-NEXT-BUSINESS-DAY        
              MOVE WS-Y                  TO WS-HOLIDAY-EXISTS           
              PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
                 THRU 6500-NEXT-BUSINESS-DAY-EXIT                       
                UNTIL NEXT-BUSINESS-DAY-FOUND                           
           END-PERFORM                                                  
           MOVE WS-NEW-BUSINESS-DAY      TO YB-BANK-POST-DT             
                                                                        
           MOVE WS-XFR-TS                TO YB-TRANSFER-TS.             
           MOVE WS-LIT-C                 TO YB-CURRENCY-TYPE.           
           MOVE WS-LIT-D                 TO YB-CODE-DR-CR.              
                                                                        
           PERFORM 8100-CREATE-BANK-TRANSFER                            
              THRU 8100-EXIT                                            
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2300-WRITE-CNTL-JRNL-MANUAL                                 **        
      **      CASH DRAWER CONTROL AND JOURNAL ENTRIES ARE CREATED     **        
      **      FOR MANUAL TRANSACTIONS                                 **        
      ******************************************************************        
       2300-WRITE-CNTL-JRNL-MANUAL.                                     
      *---------------------------*                                             
           MOVE '2300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-COMPANY               TO CS-CASH-COMPANY-NO.         
           MOVE Y2-BATCH-DEP-CASH-OFF    TO CS-CASH-LOCAL-OFFICE.       
           MOVE WS-LIT-A                 TO CS-CODE-CSH-DRWR-STAT.      
           MOVE WS-AC01-DATE             TO CS-DATE-CASH-REPORT         
           PERFORM 7300-SELECT-CASH-DRWR-CNTL                           
              THRU 7300-EXIT.                                           
                                                                        
                                                                        
      * IF A PREV BATCH IS NOT THERE, CREATE A NEW BATCH-NO                     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 2310-GET-MAX-CASH-DRAWER                          
                 THRU 2310-EXIT                                         
                                                                        
              ADD  WS-ONE                TO CS-CASH-DRAWER-ID           
                                                                        
              PERFORM 2120-SET-CASH-DRWR-CNTL-VALUES                    
                 THRU 2120-EXIT                                         
              PERFORM 8200-CREATE-CASH-DRWR-CNTL                        
                 THRU 8200-EXIT                                         
                                                                        
      * IF A PREV BATCH IS THERE, UPDATE THAT CNTL ROW                          
                                                                        
           ELSE                                                         
              ADD WS-ONE                       TO CS-NO-ITEMS-ENTERED   
              ADD WS-BATCH-TOTAL-AMOUNT        TO CS-AMT-CASH-DEBIT,    
                                                  CS-AMT-CASH-CREDIT    
              MOVE WS-CASHIER-USER-ID          TO CS-USER-ID            
              MOVE Y1-CASHIER-CODE             TO CS-CASHIER-CODE       
              MOVE WS-INPUT-DATE               TO CS-DATE-LAST-ACTIVITY 
              PERFORM 8600-UPDATE-CASH-DRWR-CNTL                        
                 THRU 8600-EXIT                                         
           END-IF.                                                      
                                                                        
      * WRITE THE JRNL RECORDS                                                  
                                                                        
           PERFORM 2150-SET-CASH-DRWR-JRNL-VALUES                       
              THRU 2150-EXIT.                                           
                                                                        
           PERFORM 2160-POPULATE-TRAN-DATA                              
              THRU 2160-EXIT.                                           
                                                                        
           MOVE CJF00101                 TO CJ-TRAN-DATA.               
                                                                        
           PERFORM 8300-CREATE-CASH-DRWR-JRNL                           
              THRU 8300-EXIT.                                           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2310-GET-MAX-CASH-DRAWER                                    **        
      **                                                              **        
      ******************************************************************        
       2310-GET-MAX-CASH-DRAWER.                                        
      *------------------------*                                                
           MOVE '2310'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-COMPANY               TO CS-CASH-COMPANY-NO.         
           MOVE Y2-BATCH-DEP-CASH-OFF    TO CS-CASH-LOCAL-OFFICE.       
           MOVE WS-LIT-C                 TO CS-CODE-CSH-DRWR-STAT.      
           MOVE WS-AC01-DATE             TO CS-DATE-CASH-REPORT.        
                                                                        
           PERFORM 7400-GET-MAX-CNTL-DRWR                               
              THRU 7400-EXIT.                                           
                                                                        
           MOVE WS-LIT-A                 TO CS-CODE-CSH-DRWR-STAT.      
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2600-WRITE-CIS-HEADER-REC                                   **        
      **                                                              **        
      ******************************************************************        
       2600-WRITE-CIS-HEADER-REC.                                       
      *-------------------------*                                               
           MOVE '2600'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-CIS-BATCH-TOTAL       TO DOC-TOTAL-BTR               
                                            CHECK-TOTAL-BTR.            
           MOVE WS-CIS-NO-OF-DOCS        TO TOTAL-NO-DOCS-BTR.          
                                                                        
           WRITE FIOAC20-REC             FROM BATCH-TOTAL-REC.          
                                                                        
           IF WS-FAC20-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING '** FILE WRITE ERROR FCSAC01 **' DELIMITED BY SIZE 
              WS-FAC20-STATUS                         DELIMITED BY SIZE 
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2700-WRITE-PIP-HEADER-REC                                   **        
      **                                                              **        
      ******************************************************************        
       2700-WRITE-PIP-HEADER-REC.                                       
      *-------------------------*                                               
           MOVE '2700'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           INITIALIZE                   FIOAC21-NON-CIS-PMT-HEADER-REC. 
           MOVE LOW-VALUES               TO FIOAC21-NCP-REC-TYPE.       
           MOVE WS-SCPC-SEQ-NO           TO FIOAC21-NCP-SEQ-NO.         
           MOVE WS-COMPANY               TO FIOAC21-NCP-HDR-CO.         
           MOVE WS-CASHIER-CASH-OFFICE   TO                             
                                     FIOAC21-NCP-HDR-LOCAL-OFFICE.      
A03311     MOVE REPORT-BTR2              TO FIOAC21-NCP-HDR-DRWR-ID.    
                                                                        
           MOVE MONTH-BTR                TO FIOAC21-NCP-DRWR-MM         
           MOVE DAY-BTR                  TO FIOAC21-NCP-DRWR-DD         
           MOVE YEAR-BTR                 TO FIOAC21-NCP-DRWR-YY         
           MOVE WS-AC01-CC               TO FIOAC21-NCP-DRWR-CC         
                                                                        
           MOVE WS-INPUT-DATE(6:2)       TO FIOAC21-NCP-HDR-CRE-MM.     
           MOVE WS-INPUT-DATE(9:2)       TO FIOAC21-NCP-HDR-CRE-DD.     
           MOVE WS-INPUT-DATE(1:4)       TO FIOAC21-NCP-HDR-CRE-CCYY.   
                                                                        
           MOVE WS-CASHIER-USER-ID       TO FIOAC21-NCP-HDR-USER-ID.    
                                                                        
           WRITE FIOAC21-REC FROM FIOAC21-NON-CIS-PMT-HEADER-REC.       
                                                                        
           IF WS-FAC22-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING '** FILE WRITE ERROR FCSAC21 **'                   
                                                    DELIMITED BY SIZE   
              WS-FAC21-STATUS                       DELIMITED BY SIZE   
                                            INTO    WS-ERR-MSG          
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2710-WRITE-PIP-TRAILER-REC                                  **        
      **                                                              **        
      ******************************************************************        
       2710-WRITE-PIP-TRAILER-REC.                                      
      *--------------------------*                                              
           MOVE '2710'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           INITIALIZE                       FIOAC21-NON-CIS-PMT-TRL-REC.
           MOVE WS-SCPC-SEQ-NO           TO FIOAC21-NCP-TRL-SEQ-NO.     
           MOVE HIGH-VALUES              TO FIOAC21-NCP-TRL-REC-TYPE.   
           MOVE WS-SCPC-NO-OF-DOCS       TO FIOAC21-NCP-TRL-BATCH-COUNT.
           MOVE WS-SCPC-BATCH-TOTAL      TO FIOAC21-NCP-TRL-BATCH-TOTAL.
                                                                        
           WRITE FIOAC21-REC FROM FIOAC21-NON-CIS-PMT-TRL-REC.          
                                                                        
           IF WS-FAC21-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING '** FILE WRITE ERROR FCSAC21 **' DELIMITED BY SIZE 
              WS-FAC21-STATUS                         DELIMITED BY SIZE 
                                         INTO WS-ERR-MSG                
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
           ADD 1                         TO WS-SCPC-SEQ-NO.             
                                                                        
       2710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2800-WRITE-ERR-HEADER-REC                                   **        
      **                                                              **        
      ******************************************************************        
       2800-WRITE-ERR-HEADER-REC.                                       
      *-------------------------*                                               
           MOVE '2800'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           INITIALIZE                    FIOAC21-NON-CIS-PMT-HEADER-REC.
           MOVE WS-ERR-SEQ-NO            TO FIOAC21-NCP-SEQ-NO.         
           MOVE LOW-VALUES               TO FIOAC21-NCP-REC-TYPE.       
           MOVE WS-COMPANY               TO FIOAC21-NCP-HDR-CO.         
           MOVE WS-CASHIER-CASH-OFFICE   TO                             
                                     FIOAC21-NCP-HDR-LOCAL-OFFICE.      
           MOVE CS-CASH-DRAWER-ID        TO FIOAC21-NCP-HDR-DRWR-ID.    
                                                                        
           IF WS-DRAFT                                                  
              MOVE WS-DRAFT-MM           TO FIOAC21-NCP-DRWR-MM         
              MOVE WS-DRAFT-DD           TO FIOAC21-NCP-DRWR-DD         
              MOVE WS-DRAFT-YY           TO FIOAC21-NCP-DRWR-YY         
              MOVE WS-DRAFT-CC           TO FIOAC21-NCP-DRWR-CC         
           ELSE                                                         
              MOVE MONTH-BTR             TO FIOAC21-NCP-DRWR-MM         
              MOVE DAY-BTR               TO FIOAC21-NCP-DRWR-DD         
              MOVE YEAR-BTR              TO FIOAC21-NCP-DRWR-YY         
              MOVE WS-AC01-CC            TO FIOAC21-NCP-DRWR-CC         
A03311        MOVE REPORT-BTR2           TO FIOAC21-NCP-HDR-DRWR-ID     
           END-IF                                                       
                                                                        
           MOVE WS-INPUT-DATE(6:2)       TO FIOAC21-NCP-HDR-CRE-MM.     
           MOVE WS-INPUT-DATE(9:2)       TO FIOAC21-NCP-HDR-CRE-DD.     
           MOVE WS-INPUT-DATE(1:4)       TO FIOAC21-NCP-HDR-CRE-CCYY.   
                                                                        
           MOVE WS-CASHIER-USER-ID       TO FIOAC21-NCP-HDR-USER-ID.    
                                                                        
           WRITE FIOAC22-REC FROM FIOAC21-NON-CIS-PMT-HEADER-REC.       
                                                                        
           IF WS-FAC22-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING '** FILE WRITE ERROR FCSAC22 **'                   
                                                    DELIMITED BY SIZE   
              WS-FAC22-STATUS                       DELIMITED BY SIZE   
                                            INTO    WS-ERR-MSG          
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2810-WRITE-ERR-TRAILER-REC                                  **        
      **                                                              **        
      ******************************************************************        
       2810-WRITE-ERR-TRAILER-REC.                                      
      *--------------------------*                                              
           MOVE '2810'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           INITIALIZE                       FIOAC21-NON-CIS-PMT-TRL-REC.
           MOVE WS-ERR-SEQ-NO            TO FIOAC21-NCP-TRL-SEQ-NO.     
           MOVE HIGH-VALUES              TO FIOAC21-NCP-TRL-REC-TYPE.   
           MOVE WS-ERR-NO-OF-DOCS        TO FIOAC21-NCP-TRL-BATCH-COUNT.
           MOVE WS-ERR-BATCH-TOTAL       TO FIOAC21-NCP-TRL-BATCH-TOTAL.
                                                                        
           WRITE FIOAC22-REC FROM FIOAC21-NON-CIS-PMT-TRL-REC.          
                                                                        
           IF WS-FAC22-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING '** FILE WRITE ERROR FCSAC22 **' DELIMITED BY SIZE 
              WS-FAC22-STATUS                         DELIMITED BY SIZE 
                                         INTO WS-ERR-MSG                
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
           ADD 1                         TO WS-ERR-SEQ-NO.              
                                                                        
       2810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **   6500-GET-NEXT-BUSINESS-DAY                                 **        
      **   COPYBOOK CPD00315 CONTAINS THE LOGIC FOR FINDING           **        
      **   THE NEXT BUSINESS DAY.                                     **        
      ******************************************************************        
                                                                        
            EXEC SQL                                                            
                INCLUDE CPD00315                                                
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      **  7000-READ-FCSAC01                                           **        
      **                                                              **        
      ******************************************************************        
       7000-READ-FCSAC01.                                               
      *-------------------*                                                     
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           READ FCSAC01-FILE                                            
                 AT END                                                 
                 MOVE WS-Y               TO WS-FCSAC01-EOF-SW.          
                                                                        
           IF   WS-FAC01-SUCCESSFUL OR WS-FCSAC01-AT-EOF                
                MOVE FIOAC01-REC         TO FIOAC20-REC                 
           ELSE                                                         
                STRING  'READ ERROR OF BANCTEC INPUT FILE     **'       
                                                      DELIMITED BY SIZE 
                WS-FAC01-STATUS                       DELIMITED BY SIZE 
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
      **  TO SKIP NOTICE TYPE RECORDS IN THE INPUT FILE **                      
           IF REC-TYPE-DET = WS-TWO                                     
              GO TO 7000-READ-FCSAC01                                   
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7050-READ-FCSAC03                                           **        
      **                                                              **        
      ******************************************************************        
       7050-READ-FCSAC03.                                               
      *-------------------*                                                     
           MOVE '7050'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           READ FCSAC03-FILE                                            
                 AT END                                                 
                 MOVE WS-Y               TO WS-FCSAC03-EOF-SW.          
                                                                        
           IF   WS-FAC03-SUCCESSFUL OR WS-FCSAC03-AT-EOF                
                CONTINUE                                                
           ELSE                                                         
                STRING  'READ ERROR OF DRAFT INPUT FILE       **'       
                                                      DELIMITED BY SIZE 
                WS-FAC03-STATUS                       DELIMITED BY SIZE 
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
           .                                                            
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7100-SELECT-CIS-ACCOUNT                                     **        
      **                                                              **        
      ******************************************************************        
       7100-SELECT-CIS-ACCOUNT.                                         
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT :WS-Y,                                               
                   CUSTOMER_NO,                                         
                   CODE_ACCT_STAT,                                      
C28322             CODES_DATA_PRESENT,                                  
C28322             COMPANY_NO                                           
             INTO  :WS-EXISTS-FLAG,                                     
                   :AT-CUSTOMER-NO,                                     
                   :AT-CODE-ACCT-STAT,                                  
C28322             :AT-CODES-DATA-PRESENT,                              
C28322             :AT-COMPANY-NO                                       
             FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                            
            WHERE  ACCOUNT_NO           = :AT-ACCOUNT-NO                
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT :WS-Y,                                                       
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            CODE_ACCT_STAT,                                              
MFA-TR*            CODES_DATA_PRESENT,                                          
MFA-TR*            COMPANY_NO                                                   
MFA-TR*      INTO  :WS-EXISTS-FLAG,                                             
MFA-TR*            :AT-CUSTOMER-NO,                                             
MFA-TR*            :AT-CODE-ACCT-STAT,                                          
MFA-TR*            :AT-CODES-DATA-PRESENT,                                      
MFA-TR*            :AT-COMPANY-NO                                               
MFA-TR*      FROM  CSS_ACCOUNT                                                  
MFA-TR*     WHERE  ACCOUNT_NO           = :AT-ACCOUNT-NO                        
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT    
              END-IF                                                    
           ELSE                                                         
C28322         MOVE AT-ACCOUNT-NO        TO WS-DISP-ACCOUNT-NO          
               STRING  'CHECKING IF AN A/C IS CIS ACCOUNT    **'        
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
               STRING 'ACCOUNT NO    '                                  
                                      DELIMITED BY SIZE                 
C28322         WS-DISP-ACCOUNT-NO     DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02388******************************************************************        
A02388**  7140-CHECK-ARCHIVED-ACCTS                                   **        
A02388**                                                              **        
A02388******************************************************************        
A02388 7140-CHECK-ARCHIVED-ACCTS.                                       
A02388                                                                  
A02388     MOVE '7140' TO WS-ACTIVE-PARAGRAPH.                          
A02388     MOVE AT-ACCOUNT-NO TO HA-ACCOUNT-NO.                         
A02388                                                                  
A02388     EXEC SQL                                                     
A02388      SELECT :WS-Y                                                
A02388        INTO :WS-ARCHIVE-FLAG                                     
A02388        FROM  HST_ACCOUNT WITH(READUNCOMMITTED)                           
A02388       WHERE  ACCOUNT_NO           = :HA-ACCOUNT-NO               
A02388                                                           
A02388     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT :WS-Y                                                        
MFA-TR*       INTO :WS-ARCHIVE-FLAG                                             
MFA-TR*       FROM  HST_ACCOUNT                                                 
MFA-TR*      WHERE  ACCOUNT_NO           = :HA-ACCOUNT-NO                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02388                                                                  
A02388     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02388                                                                  
A02388     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02388        CONTINUE                                                  
A02388     ELSE                                                         
A02388        MOVE HA-ACCOUNT-NO      TO WS-DISP-ACCOUNT-NO             
A02388        STRING  'CHECKING IF AN A/C IS ARCHIVED    **'            
A02388                                DELIMITED BY SIZE                 
A02388                                INTO    WS-ERR-MSG                
A02388        STRING 'ACCOUNT NO    '                                   
A02388                                DELIMITED BY SIZE                 
A02388        WS-DISP-ACCOUNT-NO      DELIMITED BY SIZE                 
A02388                                INTO    WS-ERR-MSG2               
A02388        PERFORM 8800-DIS-TABLE-ERROR THRU 8800-EXIT               
A02388     END-IF.                                                      
A02388                                                                  
A02388 7140-EXIT.                                                       
A02388     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7200-GET-OLD-ACCOUNT                                        **        
      **                                                              **        
      ******************************************************************        
       7200-GET-OLD-ACCOUNT.                                            
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT :WS-Y,                                              
                    NEW_ACCOUNT_NO                                      
               INTO :WS-EXISTS-FLAG,                                    
                    :XR-NEW-ACCOUNT-NO                                  
               FROM CSS_XREF_ACCT WITH(READUNCOMMITTED)                         
              WHERE OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO                 
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT :WS-Y,                                                      
MFA-TR*             NEW_ACCOUNT_NO                                              
MFA-TR*        INTO :WS-EXISTS-FLAG,                                            
MFA-TR*             :XR-NEW-ACCOUNT-NO                                          
MFA-TR*        FROM CSS_XREF_ACCT                                               
MFA-TR*       WHERE OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO                         
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
              MULTIPLE-ROWS-SELECTED OR NOT-FOUND                       
               NEXT SENTENCE                                            
           ELSE                                                         
C28322         MOVE XR-OLD-ACCOUNT-NO    TO WS-DISP-ACCOUNT-NO          
               STRING 'CHECKING IF AN A/C IS OLD CIS ACCOUNT **'        
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
               STRING 'ACCOUNT NO    '                                  
                                      DELIMITED BY SIZE                 
C28322         WS-DISP-ACCOUNT-NO     DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7240-SELECT CUSTOMER                                        **        
      **                                                              **        
      ******************************************************************        
       7240-SELECT-CUST.                                                
      *----------------*                                                        
           MOVE '7240'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT CODE_CUST_STATUS                                    
               INTO :CU-CODE-CUST-STATUS                                
               FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                          
              WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CODE_CUST_STATUS                                            
MFA-TR*        INTO :CU-CODE-CUST-STATUS                                        
MFA-TR*        FROM CSS_CUSTOMER                                                
MFA-TR*       WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           MOVE CU-CUSTOMER-NO           TO WS-DISP-CUSTOMER-NO         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR SELECTING CUSTOMER **'                     
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              STRING ' CUSTOMER NO '         DELIMITED BY SIZE          
                      WS-DISP-CUSTOMER-NO    DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7300-SELECT-CASH-DRWR-CNTL                                  **        
      **                                                              **        
      ******************************************************************        
       7300-SELECT-CASH-DRWR-CNTL.                                      
      *--------------------------*                                              
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT CASH_DRAWER_ID,                                      
                   DATE_CASH_REPORT,                                    
                   AMT_CASH_DEBIT,                                      
                   AMT_CASH_CREDIT,                                     
                   NO_ITEMS_ENTERED                                     
             INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1,                       
                  :CS-DATE-CASH-REPORT,                                 
                  :CS-AMT-CASH-DEBIT,                                   
                  :CS-AMT-CASH-CREDIT,                                  
                  :CS-NO-ITEMS-ENTERED                                  
             FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                       
            WHERE CASH_COMPANY_NO       = :CS-CASH-COMPANY-NO           
             AND  CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE         
             AND  CODE_CSH_DRWR_STAT    = :CS-CODE-CSH-DRWR-STAT        
             AND  DATE_CASH_REPORT      = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT CASH_DRAWER_ID,                                              
MFA-TR*            DATE_CASH_REPORT,                                            
MFA-TR*            AMT_CASH_DEBIT,                                              
MFA-TR*            AMT_CASH_CREDIT,                                             
MFA-TR*            NO_ITEMS_ENTERED                                             
MFA-TR*      INTO :CS-CASH-DRAWER-ID                                            
MFA-TR*           :WS-NULL-INDICATOR1,                                          
MFA-TR*           :CS-DATE-CASH-REPORT,                                         
MFA-TR*           :CS-AMT-CASH-DEBIT,                                           
MFA-TR*           :CS-AMT-CASH-CREDIT,                                          
MFA-TR*           :CS-NO-ITEMS-ENTERED                                          
MFA-TR*      FROM CSS_CSH_DRWR_CNTL                                             
MFA-TR*     WHERE CASH_COMPANY_NO       = :CS-CASH-COMPANY-NO                   
MFA-TR*      AND  CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE                 
MFA-TR*      AND  CODE_CSH_DRWR_STAT    = :CS-CODE-CSH-DRWR-STAT                
MFA-TR*      AND  DATE_CASH_REPORT      = :CS-DATE-CASH-REPORT                  
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                              OR NOT-FOUND                              
              IF  WS-NULL-INDICATOR1 < ZERO                             
                  MOVE NOT-FOUND         TO WS-ACTIVE-RETURN-CODE       
              END-IF                                                    
           ELSE                                                         
               MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID      
               STRING ' ERROR SELECTING CASH DRAWER ID **'              
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                      CS-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      CS-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                      ' CASH DRAWER STATUS ' DELIMITED BY SIZE          
                      CS-CODE-CSH-DRWR-STAT  DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7325-SELECT-CASH-REPORT                                     **        
      **                                                              **        
      ******************************************************************        
       7325-SELECT-CASH-REPORT.                                         
      *------------------------*                                                
           MOVE '7325'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT USER_ID                                             
               INTO :YR-USER-ID                                         
               FROM CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )           
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*        INTO :YR-USER-ID                                                 
MFA-TR*        FROM CSS_CSH_REPORT_HDR                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :YR-DATE-CASH-REPORT                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'ERROR IN SELECTING CASH REPORT HEADER**'         
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                      YR-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      YR-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                      ',DATE CASH REPORT'    DELIMITED BY SIZE          
                      YR-DATE-CASH-REPORT    DELIMITED BY SIZE          
                                       INTO WS-ERR-MSG2                 
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7400-GET-MAX-CNTL-DRWR                                      **        
      **                                                              **        
      ******************************************************************        
       7400-GET-MAX-CNTL-DRWR.                                          
      *----------------------*                                                  
           MOVE '7400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT MAX(CASH_DRAWER_ID)                                 
               INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1              
               FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND CODE_CSH_DRWR_STAT = :CS-CODE-CSH-DRWR-STAT         
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(CASH_DRAWER_ID)                                         
MFA-TR*        INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1                      
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                           
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*         AND CODE_CSH_DRWR_STAT = :CS-CODE-CSH-DRWR-STAT                 
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                   
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-NULL-INDICATOR1 < ZERO  OR                            
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               MOVE WS-ZERO          TO CS-CASH-DRAWER-ID               
               GO TO 7400-EXIT                                          
           END-IF.                                                      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID      
               STRING 'ERROR GETTING MAX CNTL DRAWER ID **'             
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                       CS-CASH-LOCAL-OFFICE, DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      CS-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                      ',CASH DRAWER STATUS'  DELIMITED BY SIZE          
                      CS-CODE-CSH-DRWR-STAT  DELIMITED BY SIZE          
                                       INTO WS-ERR-MSG2                 
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03311******************************************************************        
A03311**  SELECT THE MAXIMUM CASH DRAWER ID FROM CASH DRAWER CONTROL  **        
      **  TABLE FOR THE GIVEN DATE AND CASHIER OFFICE                 **        
      ******************************************************************        
       7450-GET-MAX-DRFT-DRWR.                                          
      *----------------------*                                                  
           MOVE '7450'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT MAX(CASH_DRAWER_ID)                                 
               INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1              
               FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(CASH_DRAWER_ID)                                         
MFA-TR*        INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1                      
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                           
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                   
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF  WS-NULL-INDICATOR1 < ZERO  OR                            
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               MOVE WS-ZERO          TO CS-CASH-DRAWER-ID               
               GO TO 7450-EXIT                                          
           END-IF                                                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID      
               STRING 'ERROR GETTING MAX CNTL DRAWER ID **'             
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                       CS-CASH-LOCAL-OFFICE, DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      CS-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                      ',CASH DRAWER STATUS'  DELIMITED BY SIZE          
                      CS-CODE-CSH-DRWR-STAT  DELIMITED BY SIZE          
                                       INTO WS-ERR-MSG2                 
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
A03311 7450-EXIT.                                                       
A03311     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7500-SELECT-CASH-OFFICE                                     **        
      **                                                              **        
      ******************************************************************        
       7500-SELECT-CASH-OFFICE.                                         
      *-----------------------*                                                 
           MOVE '7500'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
C28301                                                                  
C28301     EXEC SQL                                                     
C28301      SELECT CASH_LOCAL_OFFICE,                                   
C28301             BATCH_DEP_CASH_OFF,                                  
C28301             DEP_XFER_METHOD,                                     
C28301             USER_ID,                                             
C28301             DEP_DEFT_BANK_ID,                                    
C28301             LOCAL_OFFICE,                                        
C28301             DEP_CASH_GL_OFFSET,                                  
C28301             PAYMENT_AGENT_FL,                                    
C28301             PYMT_TO_POST_DAYS,                                   
C28301             ERROR_GL_OFFSET                                      
C28301       INTO :Y2-CASH-LOCAL-OFFICE,                                
C28301            :Y2-BATCH-DEP-CASH-OFF,                               
C28301            :Y2-DEP-XFER-METHOD,                                  
C28301            :Y2-USER-ID,                                          
C28301            :Y2-DEP-DEFT-BANK-ID,                                 
C28301            :Y2-LOCAL-OFFICE,                                     
C28301            :Y2-DEP-CASH-GL-OFFSET,                               
C28301            :Y2-PAYMENT-AGENT-FL,                                 
C28301            :Y2-PYMT-TO-POST-DAYS,                                
C28301            :Y2-ERROR-GL-OFFSET                                   
C28301       FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                      
C28301      WHERE CASH_COMPANY_NO      = :Y2-CASH-COMPANY-NO            
C28301       AND  PAYMENT_SOURCE_CD    = :Y2-PAYMENT-SOURCE-CD          
C33928                                                           
C28301     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT CASH_LOCAL_OFFICE,                                           
MFA-TR*            BATCH_DEP_CASH_OFF,                                          
MFA-TR*            DEP_XFER_METHOD,                                             
MFA-TR*            USER_ID,                                                     
MFA-TR*            DEP_DEFT_BANK_ID,                                            
MFA-TR*            LOCAL_OFFICE,                                                
MFA-TR*            DEP_CASH_GL_OFFSET,                                          
MFA-TR*            PAYMENT_AGENT_FL,                                            
MFA-TR*            PYMT_TO_POST_DAYS,                                           
MFA-TR*            ERROR_GL_OFFSET                                              
MFA-TR*      INTO :Y2-CASH-LOCAL-OFFICE,                                        
MFA-TR*           :Y2-BATCH-DEP-CASH-OFF,                                       
MFA-TR*           :Y2-DEP-XFER-METHOD,                                          
MFA-TR*           :Y2-USER-ID,                                                  
MFA-TR*           :Y2-DEP-DEFT-BANK-ID,                                         
MFA-TR*           :Y2-LOCAL-OFFICE,                                             
MFA-TR*           :Y2-DEP-CASH-GL-OFFSET,                                       
MFA-TR*           :Y2-PAYMENT-AGENT-FL,                                         
MFA-TR*           :Y2-PYMT-TO-POST-DAYS,                                        
MFA-TR*           :Y2-ERROR-GL-OFFSET                                           
MFA-TR*      FROM CSS_CASHIER_OFFICE                                            
MFA-TR*     WHERE CASH_COMPANY_NO      = :Y2-CASH-COMPANY-NO                    
MFA-TR*      AND  PAYMENT_SOURCE_CD    = :Y2-PAYMENT-SOURCE-CD                  
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28301                                                                  
C28301     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C28301                                                                  
C28301     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C28301         IF (Y2-DEP-CASH-GL-OFFSET EQUAL ZERO AND                 
C28301             Y2-PAYMENT-AGENT-FL = WS-Y) OR                       
C28301            Y2-ERROR-GL-OFFSET  EQUAL ZERO                        
C28301            STRING ' ERROR GL OFFSET OR DEP GL OFFSET IS ZERO **' 
C28301                                       DELIMITED BY SIZE          
C28301                                   INTO WS-ERR-MSG                
C28301            STRING ' CASH COMPANY NO   '  DELIMITED BY SIZE       
C28301                   Y2-CASH-COMPANY-NO     DELIMITED BY SIZE       
C28301                   'PAYMENT CODE  '       DELIMITED BY SIZE       
C28301                   Y2-PAYMENT-SOURCE-CD   DELIMITED BY SIZE       
C28301                                   INTO WS-ERR-MSG2               
C28301            PERFORM 8800-DIS-TABLE-ERROR                          
C28301               THRU 8800-EXIT                                     
C28301         END-IF                                                   
C28301     ELSE                                                         
C28301         STRING ' ERROR GETTING CASH OFFICE, USER ID  **'         
C28301                                       DELIMITED BY SIZE          
C28301                                   INTO WS-ERR-MSG                
C28301         STRING ' CASH COMPANY NO   '  DELIMITED BY SIZE          
C28301                Y2-CASH-COMPANY-NO     DELIMITED BY SIZE          
C28301                'PAYMENT CODE  '       DELIMITED BY SIZE          
C28301                Y2-PAYMENT-SOURCE-CD   DELIMITED BY SIZE          
C28301                                   INTO WS-ERR-MSG2               
C28301         PERFORM 8800-DIS-TABLE-ERROR                             
C28301            THRU 8800-EXIT                                        
C28301     END-IF                                                       
C28301* C28301 CHANGES END                                                      
                                                                        
           MOVE  Y2-CASH-LOCAL-OFFICE  TO WS-CASHIER-CASH-OFFICE.       
           MOVE  Y2-BATCH-DEP-CASH-OFF TO WS-BATCH-DEP-CASH-OFF.        
           MOVE  Y2-DEP-XFER-METHOD    TO WS-DEP-XFER-METHOD.           
           MOVE  Y2-USER-ID            TO WS-CASHIER-USER-ID.           
           MOVE  Y2-LOCAL-OFFICE       TO WS-CASHIER-LOCAL-OFFICE.      
           MOVE  Y2-DEP-DEFT-BANK-ID   TO WS-CASHIER-BANK-ID.           
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7510-SELECT-CSH-OFF                                         **        
      **                                                              **        
      ******************************************************************        
       7510-SELECT-CSH-OFF.                                             
           MOVE '7510'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                SELECT USER_ID,                                         
                       BATCH_DEP_CASH_OFF,                              
                       DEP_XFER_METHOD,                                 
                       DEP_DEFT_BANK_ID,                                
                       LOCAL_OFFICE,                                    
                       DEP_CASH_GL_OFFSET,                              
                       PAYMENT_AGENT_FL,                                
                       PYMT_TO_POST_DAYS,                               
                       ERROR_GL_OFFSET                                  
                  INTO :Y2-USER-ID,                                     
                       :Y2-BATCH-DEP-CASH-OFF,                          
                       :Y2-DEP-XFER-METHOD,                             
                       :Y2-DEP-DEFT-BANK-ID,                            
                       :Y2-LOCAL-OFFICE,                                
                       :Y2-DEP-CASH-GL-OFFSET,                          
                       :Y2-PAYMENT-AGENT-FL,                            
                       :Y2-PYMT-TO-POST-DAYS,                           
                       :Y2-ERROR-GL-OFFSET                              
                  FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                 
                 WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO          
                   AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE        
                   AND PAYMENT_SOURCE_CD = :Y2-PAYMENT-SOURCE-CD        
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT USER_ID,                                                 
MFA-TR*                BATCH_DEP_CASH_OFF,                                      
MFA-TR*                DEP_XFER_METHOD,                                         
MFA-TR*                DEP_DEFT_BANK_ID,                                        
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                DEP_CASH_GL_OFFSET,                                      
MFA-TR*                PAYMENT_AGENT_FL,                                        
MFA-TR*                PYMT_TO_POST_DAYS,                                       
MFA-TR*                ERROR_GL_OFFSET                                          
MFA-TR*           INTO :Y2-USER-ID,                                             
MFA-TR*                :Y2-BATCH-DEP-CASH-OFF,                                  
MFA-TR*                :Y2-DEP-XFER-METHOD,                                     
MFA-TR*                :Y2-DEP-DEFT-BANK-ID,                                    
MFA-TR*                :Y2-LOCAL-OFFICE,                                        
MFA-TR*                :Y2-DEP-CASH-GL-OFFSET,                                  
MFA-TR*                :Y2-PAYMENT-AGENT-FL,                                    
MFA-TR*                :Y2-PYMT-TO-POST-DAYS,                                   
MFA-TR*                :Y2-ERROR-GL-OFFSET                                      
MFA-TR*           FROM CSS_CASHIER_OFFICE                                       
MFA-TR*          WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO                  
MFA-TR*            AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE                
MFA-TR*            AND PAYMENT_SOURCE_CD = :Y2-PAYMENT-SOURCE-CD                
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF (Y2-DEP-CASH-GL-OFFSET EQUAL ZERO AND                 
                   Y2-PAYMENT-AGENT-FL = WS-Y) OR                       
                  Y2-ERROR-GL-OFFSET  EQUAL ZERO                        
                  STRING ' ERROR GL OFFSET OR DEP GL OFFSET IS ZERO **' 
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
                  STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE       
                         Y2-CASH-LOCAL-OFFICE   DELIMITED BY SIZE       
                         'PAYMENT CODE  '       DELIMITED BY SIZE       
                         Y2-PAYMENT-SOURCE-CD   DELIMITED BY SIZE       
                                         INTO WS-ERR-MSG2               
                  PERFORM 8800-DIS-TABLE-ERROR                          
                     THRU 8800-EXIT                                     
               END-IF                                                   
           ELSE                                                         
               STRING ' ERROR GETTING CASH OFFICE, USER ID  **'         
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                      Y2-CASH-LOCAL-OFFICE   DELIMITED BY SIZE          
                      'PAYMENT CODE  '       DELIMITED BY SIZE          
                      Y2-PAYMENT-SOURCE-CD   DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      **  7550-SELECT-CASHIER-CODE                                    **        
      **                                                              **        
      ******************************************************************        
       7550-SELECT-CASHIER-CODE.                                        
           MOVE '7550'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT CASHIER_CODE                                        
               INTO :Y1-CASHIER-CODE                                    
               FROM CSS_CASHIER WITH(READUNCOMMITTED)                           
              WHERE USER_ID            = :Y1-USER-ID                    
                AND CASH_COMPANY_NO    = :Y1-CASH-COMPANY-NO            
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CASHIER_CODE                                                
MFA-TR*        INTO :Y1-CASHIER-CODE                                            
MFA-TR*        FROM CSS_CASHIER                                                 
MFA-TR*       WHERE USER_ID            = :Y1-USER-ID                            
MFA-TR*         AND CASH_COMPANY_NO    = :Y1-CASH-COMPANY-NO                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING ' ERROR GETTING CASHIER CODE **'                  
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' FOR USER ID       '  DELIMITED BY SIZE          
                      Y1-USER-ID,            DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      Y1-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7560-SELECT-BANK-ST-CD                                      **        
      **                                                              **        
      ******************************************************************        
       7560-SELECT-BANK-ST-CD.                                          
      *----------------------*                                                  
           MOVE '7560'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-CASHIER-BANK-ID       TO D1-BANK-ID.                 
                                                                        
           EXEC SQL                                                     
             SELECT FCS_DEP_BANK_ST_CD                                  
               INTO :D1-FCS-DEP-BANK-ST-CD                              
               FROM CSS_BANK WITH(READUNCOMMITTED)                              
              WHERE BANK_ID = :D1-BANK-ID                               
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT FCS_DEP_BANK_ST_CD                                          
MFA-TR*        INTO :D1-FCS-DEP-BANK-ST-CD                                      
MFA-TR*        FROM CSS_BANK                                                    
MFA-TR*       WHERE BANK_ID = :D1-BANK-ID                                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING  'ERROR GETTING BANK ST CD  **'                   
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
               STRING 'BANK ID '      DELIMITED BY SIZE                 
                 WS-CASHIER-BANK-ID   DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7700-GET-CURRENT-TIMESTAMP                                  **        
      **                                                              **        
      ******************************************************************        
       7700-GET-CURRENT-TIMESTAMP.                                      
      *--------------------------*                                              
           MOVE '7700'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
C33928     EXEC SQL                                                     
C33928         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-XFR-TS                                        
C33928     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT TIMESTAMP                                         
MFA-TR*        INTO   :WS-XFR-TS                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33928                                                                  
C33928     EXEC SQL                                                     
C33928         SELECT
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-TRAN-TIME                                     
C33928     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT TIME                                              
MFA-TR*        INTO   :WS-TRAN-TIME                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33928                                                                  
                                                                        
           MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE.                     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'ERROR GETTING TIMESTAMP VALUE **'                
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
                                                                        
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7800-SELECT-DATABASE                                        **        
      **                                                              **        
      ******************************************************************        
       7800-SELECT-DATABASE.                                            
      *---------------------*                                                   
           MOVE '7800'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT DELINQ_VALUE                                         
              INTO :C8-DELINQ-VALUE                                     
              FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                        
             WHERE COMPANY_NO           = :C8-COMPANY-NO                
               AND DELINQ_CD            = :C8-DELINQ-CD                 
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT DELINQ_VALUE                                                 
MFA-TR*       INTO :C8-DELINQ-VALUE                                             
MFA-TR*       FROM CSS_DELINQUENCY                                              
MFA-TR*      WHERE COMPANY_NO           = :C8-COMPANY-NO                        
MFA-TR*        AND DELINQ_CD            = :C8-DELINQ-CD                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 STRING 'ERROR SELECTING DELINQUENCY CODE **'           
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
                 STRING 'DELINQUENCY CODE '  DELIMITED BY SIZE          
                         C8-DELINQ-CD,       DELIMITED BY SIZE          
                         'COMPANY NO  '      DELIMITED BY SIZE          
                          C8-COMPANY-NO      DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7900-SELECT-GL-ACCT-NO                                      **        
      **                                                              **        
      ******************************************************************        
       7900-SELECT-GL-ACCT-NO.                                          
      *----------------------*                                                  
           MOVE '7900'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT GL_ACCT_NO                                           
             INTO :GO-GL-ACCT-NO                                        
             FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                          
            WHERE COMPANY_NO           = :GO-COMPANY-NO                 
             AND  GL_ACCT_NAME         = :GO-GL-ACCT-NAME               
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT GL_ACCT_NO                                                   
MFA-TR*      INTO :GO-GL-ACCT-NO                                                
MFA-TR*      FROM CSS_GL_ACCT_NO                                                
MFA-TR*     WHERE COMPANY_NO           = :GO-COMPANY-NO                         
MFA-TR*      AND  GL_ACCT_NAME         = :GO-GL-ACCT-NAME                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  DISPLAY 'ERROR SELECTING ACCOUNT NUMBER **'           
                          GO-GL-ACCT-NAME                               
              ELSE                                                      
              STRING 'ERROR SELECTING ACCOUNT NUMBER **'                
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              STRING 'GL ACCOUNT NAME  '     DELIMITED BY SIZE          
                      GO-GL-ACCT-NAME   ,    DELIMITED BY SIZE          
                      'COMPANY NO  '         DELIMITED BY SIZE          
                       GO-COMPANY-NO         DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8000-WRITE-FCSAC24.                                         **        
      **                                                              **        
      ******************************************************************        
       8000-WRITE-FCSAC24.                                              
      *------------------*                                                      
           MOVE '8000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           WRITE FIOAC24-REC FROM CSHCNACH-OUTPUT-RECORD                
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8100-CREATE-BANK-TRANSFER                                   **        
      **                                                              **        
      ******************************************************************        
       8100-CREATE-BANK-TRANSFER.                                       
      *-------------------------*                                               
           MOVE '8100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            INSERT INTO CSS_BANK_TRANSFER                               
                    ( CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      DATE_CASH_REPORT,                                 
                      CASH_DRAWER_ID,                                   
                      TRANSFER_TS,                                      
                      CURRENCY_TYPE,                                    
                      USER_ID,                                          
                      BANK_ID,                                          
                      TRANSFER_AMT,                                     
                      CODE_DR_CR,                                       
                      BANK_POST_DT)                                     
                      VALUES (                                          
                      :YB-CASH-COMPANY-NO,                              
                      :YB-CASH-LOCAL-OFFICE,                            
                      IIF(TRY_CONVERT(DATE, :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) ),                        
                      :YB-CASH-DRAWER-ID,                               
                      CIS.CHAR2TIMESTAMP(:YB-TRANSFER-TS),                      
                      :YB-CURRENCY-TYPE,                                
                      :YB-USER-ID,                                      
                      :YB-BANK-ID,                                      
                      :YB-TRANSFER-AMT,                                 
                      :YB-CODE-DR-CR,                                   
                      IIF(TRY_CONVERT(DATE, :YB-BANK-POST-DT
              ) IS NULL OR (PATINDEX('%.%', :YB-BANK-POST-DT
              ) <> 0) OR (LEN(:YB-BANK-POST-DT) <> 10), CIS.CHAR2DATE(
                                                       :YB-BANK-POST-DT
              ), CONVERT(DATE, :YB-BANK-POST-DT) ))                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     INSERT INTO CSS_BANK_TRANSFER                                       
MFA-TR*             ( CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               CASH_DRAWER_ID,                                           
MFA-TR*               TRANSFER_TS,                                              
MFA-TR*               CURRENCY_TYPE,                                            
MFA-TR*               USER_ID,                                                  
MFA-TR*               BANK_ID,                                                  
MFA-TR*               TRANSFER_AMT,                                             
MFA-TR*               CODE_DR_CR,                                               
MFA-TR*               BANK_POST_DT)                                             
MFA-TR*               VALUES (                                                  
MFA-TR*               :YB-CASH-COMPANY-NO,                                      
MFA-TR*               :YB-CASH-LOCAL-OFFICE,                                    
MFA-TR*               :YB-DATE-CASH-REPORT,                                     
MFA-TR*               :YB-CASH-DRAWER-ID,                                       
MFA-TR*               :YB-TRANSFER-TS,                                          
MFA-TR*               :YB-CURRENCY-TYPE,                                        
MFA-TR*               :YB-USER-ID,                                              
MFA-TR*               :YB-BANK-ID,                                              
MFA-TR*               :YB-TRANSFER-AMT,                                         
MFA-TR*               :YB-CODE-DR-CR,                                           
MFA-TR*               :YB-BANK-POST-DT)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE YB-CASH-DRAWER-ID     TO WS-DISP-CASH-DRAWER-ID      
              STRING ' ERROR INSERTING INTO CSS_BANK_TRANSFER **'       
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              STRING 'LOCAL OFFICE     '     DELIMITED BY SIZE          
                   YB-CASH-LOCAL-OFFICE,     DELIMITED BY SIZE          
                  ',CASH COMPANY NO   '      DELIMITED BY SIZE          
                   YB-CASH-COMPANY-NO,       DELIMITED BY SIZE          
                   ',DATE CASH REPORT'       DELIMITED BY SIZE          
                   YB-DATE-CASH-REPORT,      DELIMITED BY SIZE          
                   ',CASH DRAWER ID'         DELIMITED BY SIZE          
                   WS-DISP-CASH-DRAWER-ID,   DELIMITED BY SIZE          
                   ',USER ID       '         DELIMITED BY SIZE          
                   YB-USER-ID                DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8200-CREATE-CASH-DRWR-CNTL                                  **        
      **                                                              **        
      ******************************************************************        
       8200-CREATE-CASH-DRWR-CNTL.                                      
      *--------------------------*                                              
           MOVE '8200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            INSERT INTO CSS_CSH_DRWR_CNTL (                             
                        CASH_COMPANY_NO,                                
                        CASH_LOCAL_OFFICE,                              
                        CASH_REPORT_NO,                                 
                        DATE_CASH_REPORT,                               
                        CASH_DRAWER_ID,                                 
                        AMT_CASH_DEBIT,                                 
                        AMT_CASH_CREDIT,                                
                        AMT_AR_DEBIT,                                   
                        AMT_AR_CREDIT,                                  
                        AMT_CK_ISS_DEBIT,                               
                        AMT_CK_ISS_CREDIT,                              
                        AMT_GL_DEBIT,                                   
                        AMT_GL_CREDIT,                                  
                        AMT_CASH_BEGIN_BAL,                             
                        AMT_BASIC_WORK,                                 
                        USER_ID,                                        
                        CASHIER_CODE,                                   
                        CODE_PYMT_FACILITY,                             
                        CODE_FCS_EXTRACTED,                             
                        CODE_CSH_DRWR_STAT,                             
                        DATE_LAST_ACTIVITY,                             
                        BALANCED_BY,                                    
                        BALANCED_TS,                                    
                        NO_ITEMS_ENTERED )                              
             VALUES (                                                   
                        :CS-CASH-COMPANY-NO,                            
                        :CS-CASH-LOCAL-OFFICE,                          
                        :CS-CASH-REPORT-NO,                             
                        IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) ),                        
                        :CS-CASH-DRAWER-ID,                             
                        :CS-AMT-CASH-DEBIT,                             
                        :CS-AMT-CASH-CREDIT,                            
                        :CS-AMT-AR-DEBIT,                               
                        :CS-AMT-AR-CREDIT,                              
                        :CS-AMT-CK-ISS-DEBIT,                           
                        :CS-AMT-CK-ISS-CREDIT,                          
                        :CS-AMT-GL-DEBIT,                               
                        :CS-AMT-GL-CREDIT,                              
                        :CS-AMT-CASH-BEGIN-BAL,                         
                        :CS-AMT-BASIC-WORK,                             
                        :CS-USER-ID,                                    
                        :CS-CASHIER-CODE,                               
                        :CS-CODE-PYMT-FACILITY,                         
                        :CS-CODE-FCS-EXTRACTED,                         
                        :CS-CODE-CSH-DRWR-STAT,                         
                        IIF(TRY_CONVERT(DATE, :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) ),                      
                        :CS-BALANCED-BY,                                
                        CIS.CHAR2TIMESTAMP(:CS-BALANCED-TS 
                                           :WS-CNTL-TS-NI),                
                        :CS-NO-ITEMS-ENTERED )                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     INSERT INTO CSS_CSH_DRWR_CNTL (                                     
MFA-TR*                 CASH_COMPANY_NO,                                        
MFA-TR*                 CASH_LOCAL_OFFICE,                                      
MFA-TR*                 CASH_REPORT_NO,                                         
MFA-TR*                 DATE_CASH_REPORT,                                       
MFA-TR*                 CASH_DRAWER_ID,                                         
MFA-TR*                 AMT_CASH_DEBIT,                                         
MFA-TR*                 AMT_CASH_CREDIT,                                        
MFA-TR*                 AMT_AR_DEBIT,                                           
MFA-TR*                 AMT_AR_CREDIT,                                          
MFA-TR*                 AMT_CK_ISS_DEBIT,                                       
MFA-TR*                 AMT_CK_ISS_CREDIT,                                      
MFA-TR*                 AMT_GL_DEBIT,                                           
MFA-TR*                 AMT_GL_CREDIT,                                          
MFA-TR*                 AMT_CASH_BEGIN_BAL,                                     
MFA-TR*                 AMT_BASIC_WORK,                                         
MFA-TR*                 USER_ID,                                                
MFA-TR*                 CASHIER_CODE,                                           
MFA-TR*                 CODE_PYMT_FACILITY,                                     
MFA-TR*                 CODE_FCS_EXTRACTED,                                     
MFA-TR*                 CODE_CSH_DRWR_STAT,                                     
MFA-TR*                 DATE_LAST_ACTIVITY,                                     
MFA-TR*                 BALANCED_BY,                                            
MFA-TR*                 BALANCED_TS,                                            
MFA-TR*                 NO_ITEMS_ENTERED )                                      
MFA-TR*      VALUES (                                                           
MFA-TR*                 :CS-CASH-COMPANY-NO,                                    
MFA-TR*                 :CS-CASH-LOCAL-OFFICE,                                  
MFA-TR*                 :CS-CASH-REPORT-NO,                                     
MFA-TR*                 :CS-DATE-CASH-REPORT,                                   
MFA-TR*                 :CS-CASH-DRAWER-ID,                                     
MFA-TR*                 :CS-AMT-CASH-DEBIT,                                     
MFA-TR*                 :CS-AMT-CASH-CREDIT,                                    
MFA-TR*                 :CS-AMT-AR-DEBIT,                                       
MFA-TR*                 :CS-AMT-AR-CREDIT,                                      
MFA-TR*                 :CS-AMT-CK-ISS-DEBIT,                                   
MFA-TR*                 :CS-AMT-CK-ISS-CREDIT,                                  
MFA-TR*                 :CS-AMT-GL-DEBIT,                                       
MFA-TR*                 :CS-AMT-GL-CREDIT,                                      
MFA-TR*                 :CS-AMT-CASH-BEGIN-BAL,                                 
MFA-TR*                 :CS-AMT-BASIC-WORK,                                     
MFA-TR*                 :CS-USER-ID,                                            
MFA-TR*                 :CS-CASHIER-CODE,                                       
MFA-TR*                 :CS-CODE-PYMT-FACILITY,                                 
MFA-TR*                 :CS-CODE-FCS-EXTRACTED,                                 
MFA-TR*                 :CS-CODE-CSH-DRWR-STAT,                                 
MFA-TR*                 :CS-DATE-LAST-ACTIVITY,                                 
MFA-TR*                 :CS-BALANCED-BY,                                        
MFA-TR*                 :CS-BALANCED-TS  :WS-CNTL-TS-NI,                        
MFA-TR*                 :CS-NO-ITEMS-ENTERED )                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING ' ERROR INSERTING  INTO CSS_CSH_DRWR_CNTL **'     
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID      
                 STRING 'LOCAL OFFICE     '  DELIMITED BY SIZE          
                      CS-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      CS-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                      ',DATE CASH REPORT'    DELIMITED BY SIZE          
                      CS-DATE-CASH-REPORT,   DELIMITED BY SIZE          
                      ',CASH-REPORT-NO '     DELIMITED BY SIZE          
                      CS-CASH-REPORT-NO,     DELIMITED BY SIZE          
                      ',CASH DRAWER ID'      DELIMITED BY SIZE          
                      WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
                                                                        
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8300-CREATE-CASH-DRWR-JRNL                                  **        
      **                                                              **        
      ******************************************************************        
       8300-CREATE-CASH-DRWR-JRNL.                                      
      *--------------------------*                                              
           MOVE '8300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            INSERT INTO CSS_CSH_DRWR_JRNL (                             
                   CASH_COMPANY_NO,                                     
                   CASH_LOCAL_OFFICE,                                   
                   CASH_REPORT_NO,                                      
                   DATE_CASH_REPORT,                                    
                   CASH_DRAWER_ID,                                      
                   DATE_TRAN,                                           
                   ENTRY_NO,                                            
                   TRAN_APPL_NO,                                        
                   LOCAL_OFFICE,                                        
                   COMPANY_NO,                                          
                   JRNL_SORT_ID,                                        
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,                                         
                   GL_ACCT_NO,                                          
                   METER_NO,                                            
                   TRAN_TIME,                                           
                   TRAN_ID,                                             
                   DATE_LAST_ACTION,                                    
                   CODE_ENTRY_SOURCE,                                   
                   USER_ID,                                             
                   BATCH_SEND_LOC,                                      
                   ENTRY_LOC,                                           
                   CODE_TRAN_ERRORS,                                    
                   CODE_JRNL_EXTRACT,                                   
                   DATE_BALANCED,                                       
                   TIME_BALANCED,                                       
                   BALANCED_BY,                                         
                   CODE_STATUS,                                         
                   CURRENCY_TYPE,                                       
                   CODE_PYMT_FACILITY,                                  
                   TRAN_DATA,                                           
                   CSR_PC_ID,                                           
                   TRAN_COMMENT )                                       
              VALUES (                                                  
                   :CJ-CASH-COMPANY-NO,                                 
                   :CJ-CASH-LOCAL-OFFICE,                               
                   :CJ-CASH-REPORT-NO,                                  
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) ),                        
                   :CJ-CASH-DRAWER-ID,                                  
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-TRAN
              ) <> 0) OR (LEN(:CJ-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :CJ-DATE-TRAN
              ), CONVERT(DATE, :CJ-DATE-TRAN) ),                               
                   :CJ-ENTRY-NO,                                        
                   :CJ-TRAN-APPL-NO,                                    
                   :CJ-LOCAL-OFFICE,                                    
                   :CJ-COMPANY-NO,                                      
                   :CJ-JRNL-SORT-ID,                                    
                   :CJ-ACCOUNT-NO,                                      
                   :CJ-CUSTOMER-NO,                                     
                   :CJ-GL-ACCT-NO,                                      
                   :CJ-METER-NO,                                        
                   CIS.CHAR2TIME(:CJ-TRAN-TIME),                                
                   :CJ-TRAN-ID,                                         
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:CJ-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-LAST-ACTION
              ), CONVERT(DATE, :CJ-DATE-LAST-ACTION) ),                        
                   :CJ-CODE-ENTRY-SOURCE,                               
                   :CJ-USER-ID,                                         
                   :CJ-BATCH-SEND-LOC,                                  
                   :CJ-ENTRY-LOC,                                       
                   :CJ-CODE-TRAN-ERRORS ,                               
                   :CJ-CODE-JRNL-EXTRACT,                               
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-BALANCED 
                                         :WS-CJ-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-BALANCED 
                                                         :WS-CJ-DATE-NI
              ) <> 0) OR (LEN(:CJ-DATE-BALANCED :WS-CJ-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-BALANCED :WS-CJ-DATE-NI
              ), CONVERT(DATE, :CJ-DATE-BALANCED :WS-CJ-DATE-NI) ),            
                   CIS.CHAR2TIME(:CJ-TIME-BALANCED :WS-CJ-TIME-NI),             
                   :CJ-BALANCED-BY,                                     
                   :CJ-CODE-STATUS,                                     
                   :CJ-CURRENCY-TYPE,                                   
                   :CJ-CODE-PYMT-FACILITY,                              
                   :CJ-TRAN-DATA,                                       
                   :CJ-CSR-PC-ID,                                       
                   :CJ-TRAN-COMMENT )                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     INSERT INTO CSS_CSH_DRWR_JRNL (                                     
MFA-TR*            CASH_COMPANY_NO,                                             
MFA-TR*            CASH_LOCAL_OFFICE,                                           
MFA-TR*            CASH_REPORT_NO,                                              
MFA-TR*            DATE_CASH_REPORT,                                            
MFA-TR*            CASH_DRAWER_ID,                                              
MFA-TR*            DATE_TRAN,                                                   
MFA-TR*            ENTRY_NO,                                                    
MFA-TR*            TRAN_APPL_NO,                                                
MFA-TR*            LOCAL_OFFICE,                                                
MFA-TR*            COMPANY_NO,                                                  
MFA-TR*            JRNL_SORT_ID,                                                
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            GL_ACCT_NO,                                                  
MFA-TR*            METER_NO,                                                    
MFA-TR*            TRAN_TIME,                                                   
MFA-TR*            TRAN_ID,                                                     
MFA-TR*            DATE_LAST_ACTION,                                            
MFA-TR*            CODE_ENTRY_SOURCE,                                           
MFA-TR*            USER_ID,                                                     
MFA-TR*            BATCH_SEND_LOC,                                              
MFA-TR*            ENTRY_LOC,                                                   
MFA-TR*            CODE_TRAN_ERRORS,                                            
MFA-TR*            CODE_JRNL_EXTRACT,                                           
MFA-TR*            DATE_BALANCED,                                               
MFA-TR*            TIME_BALANCED,                                               
MFA-TR*            BALANCED_BY,                                                 
MFA-TR*            CODE_STATUS,                                                 
MFA-TR*            CURRENCY_TYPE,                                               
MFA-TR*            CODE_PYMT_FACILITY,                                          
MFA-TR*            TRAN_DATA,                                                   
MFA-TR*            CSR_PC_ID,                                                   
MFA-TR*            TRAN_COMMENT )                                               
MFA-TR*       VALUES (                                                          
MFA-TR*            :CJ-CASH-COMPANY-NO,                                         
MFA-TR*            :CJ-CASH-LOCAL-OFFICE,                                       
MFA-TR*            :CJ-CASH-REPORT-NO,                                          
MFA-TR*            :CJ-DATE-CASH-REPORT,                                        
MFA-TR*            :CJ-CASH-DRAWER-ID,                                          
MFA-TR*            :CJ-DATE-TRAN,                                               
MFA-TR*            :CJ-ENTRY-NO,                                                
MFA-TR*            :CJ-TRAN-APPL-NO,                                            
MFA-TR*            :CJ-LOCAL-OFFICE,                                            
MFA-TR*            :CJ-COMPANY-NO,                                              
MFA-TR*            :CJ-JRNL-SORT-ID,                                            
MFA-TR*            :CJ-ACCOUNT-NO,                                              
MFA-TR*            :CJ-CUSTOMER-NO,                                             
MFA-TR*            :CJ-GL-ACCT-NO,                                              
MFA-TR*            :CJ-METER-NO,                                                
MFA-TR*            :CJ-TRAN-TIME,                                               
MFA-TR*            :CJ-TRAN-ID,                                                 
MFA-TR*            :CJ-DATE-LAST-ACTION,                                        
MFA-TR*            :CJ-CODE-ENTRY-SOURCE,                                       
MFA-TR*            :CJ-USER-ID,                                                 
MFA-TR*            :CJ-BATCH-SEND-LOC,                                          
MFA-TR*            :CJ-ENTRY-LOC,                                               
MFA-TR*            :CJ-CODE-TRAN-ERRORS ,                                       
MFA-TR*            :CJ-CODE-JRNL-EXTRACT,                                       
MFA-TR*            :CJ-DATE-BALANCED :WS-CJ-DATE-NI,                            
MFA-TR*            :CJ-TIME-BALANCED :WS-CJ-TIME-NI,                            
MFA-TR*            :CJ-BALANCED-BY,                                             
MFA-TR*            :CJ-CODE-STATUS,                                             
MFA-TR*            :CJ-CURRENCY-TYPE,                                           
MFA-TR*            :CJ-CODE-PYMT-FACILITY,                                      
MFA-TR*            :CJ-TRAN-DATA,                                               
MFA-TR*            :CJ-CSR-PC-ID,                                               
MFA-TR*            :CJ-TRAN-COMMENT )                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE CJ-CASH-DRAWER-ID      TO WS-DISP-CASH-DRAWER-ID    
               STRING ' ERROR INSERTING  INTO CSS_CSH_DRWR_JRNL **'     
                                           DELIMITED BY SIZE            
                                         INTO WS-ERR-MSG                
               STRING 'LOCAL OFFICE     '  DELIMITED BY SIZE            
                    CJ-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE            
                    ',CASH COMPANY NO   '  DELIMITED BY SIZE            
                    CJ-CASH-COMPANY-NO,    DELIMITED BY SIZE            
                    ',DATE CASH REPORT'    DELIMITED BY SIZE            
                    CJ-DATE-CASH-REPORT,   DELIMITED BY SIZE            
                    ',CASH-REPORT-NO '     DELIMITED BY SIZE            
                    CJ-CASH-REPORT-NO,     DELIMITED BY SIZE            
                    ',CASH DRAWER ID'      DELIMITED BY SIZE            
                    WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE            
                                         INTO WS-ERR-MSG2               
                                                                        
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8325-CREATE-CASH-REPORT                                     **        
      **                                                              **        
      ******************************************************************        
       8325-CREATE-CASH-REPORT.                                         
      *------------------------*                                                
           MOVE '8325'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_REPORT_HDR                             
                    ( CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      DATE_CASH_REPORT,                                 
                      USER_ID,                                          
                      STATUS,                                           
                      CLOSED_TS)                                        
             VALUES ( :YR-CASH-COMPANY-NO                               
                      ,:YR-CASH-LOCAL-OFFICE                            
                      ,IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )                         
                      ,:YR-USER-ID                                      
                      ,:YR-STATUS                                       
                      ,CIS.CHAR2TIMESTAMP(:YR-CLOSED-TS))                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_REPORT_HDR                                     
MFA-TR*             ( CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               USER_ID,                                                  
MFA-TR*               STATUS,                                                   
MFA-TR*               CLOSED_TS)                                                
MFA-TR*      VALUES ( :YR-CASH-COMPANY-NO                                       
MFA-TR*               ,:YR-CASH-LOCAL-OFFICE                                    
MFA-TR*               ,:YR-DATE-CASH-REPORT                                     
MFA-TR*               ,:YR-USER-ID                                              
MFA-TR*               ,:YR-STATUS                                               
MFA-TR*               ,:YR-CLOSED-TS)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'ERROR IN INSERTING CASH REPORT HEADER**'         
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                      YR-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      YR-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                      ',DATE CASH REPORT'    DELIMITED BY SIZE          
                      YR-DATE-CASH-REPORT    DELIMITED BY SIZE          
                                       INTO WS-ERR-MSG2                 
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       8325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8600-UPDATE-CASH-DRWR-CNTL                                  **        
      **                                                              **        
      ******************************************************************        
       8600-UPDATE-CASH-DRWR-CNTL.                                      
      *---------------------------*                                             
           MOVE '8600'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            UPDATE CSS_CSH_DRWR_CNTL                                    
             SET AMT_CASH_DEBIT        = :CS-AMT-CASH-DEBIT,            
                 AMT_CASH_CREDIT       = :CS-AMT-CASH-CREDIT,           
                 USER_ID               = :CS-USER-ID,                   
                 CASHIER_CODE          = :CS-CASHIER-CODE,              
                 DATE_LAST_ACTIVITY = IIF(TRY_CONVERT(DATE, 
                                                 :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) ),           
                 NO_ITEMS_ENTERED      = :CS-NO-ITEMS-ENTERED           
            WHERE CASH_COMPANY_NO      = :CS-CASH-COMPANY-NO            
             AND CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE          
             AND CASH_DRAWER_ID        = :CS-CASH-DRAWER-ID             
             AND DATE_CASH_REPORT      = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     UPDATE CSS_CSH_DRWR_CNTL                                            
MFA-TR*      SET AMT_CASH_DEBIT        = :CS-AMT-CASH-DEBIT,                    
MFA-TR*          AMT_CASH_CREDIT       = :CS-AMT-CASH-CREDIT,                   
MFA-TR*          USER_ID               = :CS-USER-ID,                           
MFA-TR*          CASHIER_CODE          = :CS-CASHIER-CODE,                      
MFA-TR*          DATE_LAST_ACTIVITY = :CS-DATE-LAST-ACTIVITY,                   
MFA-TR*          NO_ITEMS_ENTERED      = :CS-NO-ITEMS-ENTERED                   
MFA-TR*     WHERE CASH_COMPANY_NO      = :CS-CASH-COMPANY-NO                    
MFA-TR*      AND CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*      AND CASH_DRAWER_ID        = :CS-CASH-DRAWER-ID                     
MFA-TR*      AND DATE_CASH_REPORT      = :CS-DATE-CASH-REPORT                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                NEXT SENTENCE                                           
           ELSE                                                         
              MOVE CS-CASH-DRAWER-ID     TO WS-DISP-CASH-DRAWER-ID      
              STRING ' ERROR UPDATE CASH DRAWER CONTROL **'             
                                               DELIMITED BY SIZE        
                                         INTO WS-ERR-MSG                
                STRING 'LOCAL OFFICE     '           DELIMITED BY SIZE  
                   CS-CASH-LOCAL-OFFICE,             DELIMITED BY SIZE  
                   ',CASH COMPANY NO   '             DELIMITED BY SIZE  
                   CS-CASH-COMPANY-NO,               DELIMITED BY SIZE  
                   ',DATE CASH REPORT'               DELIMITED BY SIZE  
                   CS-DATE-CASH-REPORT,              DELIMITED BY SIZE  
                   ',CASH DRAWER ID'                 DELIMITED BY SIZE  
                   WS-DISP-CASH-DRAWER-ID            DELIMITED BY SIZE  
                                         INTO WS-ERR-MSG2               
                                                                        
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF                                                       
           .                                                            
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8800-DIS-TABLE-ERROR                                        **        
      **                                                              **        
      ******************************************************************        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'.    
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'.    
           DISPLAY  WS-ERR-MSG.                                         
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE.     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
                                                                        
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **  8900-DISPLAY-ERR-TERM                                       **        
      **                                                              **        
      ******************************************************************        
       8900-DISPLAY-ERR-TERM.                                           
      *---------------------*                                                   
           DISPLAY '                                   '.               
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSAC170 PROCESSING ERROR        **'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**       PROCESSING TERMINATED          **'.        
           DISPLAY '******************************************'.        
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  9000-TERMINATE                                              **        
      *        NORMAL TERMINATION OF THE PROGRAM                      **        
      ******************************************************************        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH.        
           CLOSE FCSAC01-FILE.                                          
                                                                        
           IF WS-FAC01-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  'CLOSE ERROR- BANKTEK INPUT FILE'                 
                                         DELIMITED BY SIZE              
                      'FILE STATUS = '   DELIMITED BY SIZE              
                       WS-FAC01-STATUS   DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              DISPLAY '**' WS-ERR-MSG                                   
           END-IF.                                                      
                                                                        
           CLOSE FCSAC03-FILE.                                          
                                                                        
           IF WS-FAC03-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  'CLOSE ERROR- DRAFT INPUT FILE'                   
                                         DELIMITED BY SIZE              
                      'FILE STATUS = '   DELIMITED BY SIZE              
                       WS-FAC03-STATUS   DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              DISPLAY '**' WS-ERR-MSG                                   
           END-IF.                                                      
                                                                        
           CLOSE FCSAC20-FILE.                                          
                                                                        
           IF WS-FAC20-SUCCESSFUL                                       
               NEXT SENTENCE                                            
           ELSE                                                         
              STRING  'CLOSE ERROR OF CIS OUTPUT FILE'                  
                                         DELIMITED SIZE                 
                      'FILE STATUS = '   DELIMITED BY SIZE              
                       WS-FAC20-STATUS   DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              DISPLAY '**' WS-ERR-MSG                                   
           END-IF.                                                      
                                                                        
           CLOSE FCSAC21-FILE.                                          
                                                                        
           IF WS-FAC21-SUCCESSFUL                                       
               NEXT SENTENCE                                            
           ELSE                                                         
              STRING  'CLOSE ERROR OF PIPELINE OUTPUT FILE'             
                                         DELIMITED BY SIZE              
                      'FILE STATUS = '   DELIMITED BY SIZE              
                       WS-FAC21-STATUS   DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              DISPLAY '**' WS-ERR-MSG                                   
           END-IF.                                                      
                                                                        
           CLOSE FCSAC22-FILE.                                          
                                                                        
           IF WS-FAC22-SUCCESSFUL                                       
               NEXT SENTENCE                                            
           ELSE                                                         
              STRING  'CLOSE ERROR OF ERROR OUTPUT FILE'                
                                         DELIMITED BY SIZE              
                      'FILE STATUS = '   DELIMITED BY SIZE              
                       WS-FAC22-STATUS   DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              DISPLAY '**' WS-ERR-MSG                                   
           END-IF.                                                      
                                                                        
           CLOSE FCSAC24-FILE.                                          
                                                                        
           IF WS-FAC22-SUCCESSFUL                                       
               NEXT SENTENCE                                            
           ELSE                                                         
              STRING  'CLOSE ERROR OF DRAFT OUTPUT FILE'                
                                         DELIMITED BY SIZE              
                      'FILE STATUS = '   DELIMITED BY SIZE              
                       WS-FAC24-STATUS   DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              DISPLAY '**' WS-ERR-MSG                                   
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
