       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSAC169.                                         
       DATE-WRITTEN.  03 MARCH 2001.                                    
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **                    SCANA CORPORATION                        ** 00070000
      **                        COLUMBIA                             ** 00080000
      **-------------------------------------------------------------** 00110000
      **----------------- CUSTOMER SERVICE SYSTEM -------------------** 00120000
      **-------------------------------------------------------------** 00130000
      ***************************************************************** 00140000
      **                                                             ** 00150000
      **              PROGRAM  MODIFICATION  LOG                     ** 00160000
      **    DATE    INITIALS     COMMENTS                            ** 00170000
      **   =======  ==========   ==================================  ** 00180000
      **                                                             ** 00191000
      **   03/2001  SA CHENNAI   CREATED                             ** 00200000
T35434**   02/2007  COVANSYS     REPLACED CSS_MODEL_SQL WITH SET     ** 00210000
T35434**                         STATEMENT                           ** 00220000
P00613**   02/12/14 LG41184      SET BANK-DISCRET-DATA(2:1) TO SPACE ** 00230002
P00613**                         IN THE FILE THAT GOES TO THE BANK.  ** 00240002
      ***************************************************************** 00400000
                                                                        
      *================================================================*00420000
      *================================================================*00430000
      *                                                                *00440000
      *   THIS PROGRAM SPLITS ALL THE EPAY ACCOUNTS FROM THE DRAFT     *00441000
      *   FILE AND CREATES SEPARATE FILES FOR DRAFT ACCOUNTS (FIOCADFT)*00442000
      *   AND EPAY ACCOUNTS (FIOCAEPY).                                *00450000
      *================================================================*00490000
      *================================================================*00500000
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           COPY CSSAC03.                                                00610000
           COPY CSSDRFT.                                                00611000
           COPY CSSEPAY.                                                00620000
           COPY CSSC169.                                                00630000
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
                                                                        
      *-------------------------------------------------------------*   00700000
      *         FD FOR BANK DRAFT INPUT FILE                        *   00710000
      *-------------------------------------------------------------*   00720000
       COPY CFDAC03.                                                    00730000
                                                                        
      *-------------------------------------------------------------*   00731000
      *         THIS FILE CONTAINS BANKDRAFT RECORDS                *   00732000
      *-------------------------------------------------------------*   00733000
       COPY FIOAC03.                                                    00740000
                                                                        
      *-------------------------------------------------------------*   00751000
      *         FD FOR BANK DRAFT OUTPUT FILE (INPUT TO PCSAC160)   *   00752000
      *-------------------------------------------------------------*   00753000
       COPY CFDCADFT.                                                   00760000
       01   FIOCADFT.                                                   
            03  CSHCNACH-OUTPUT-DRAFT          PIC X(94).               
                                                                        
      *-------------------------------------------------------------*   00781000
      *         FD FOR E-PAYMENTS OUTPUT FILE (INPUT TO PCSAC160)   *   00782000
      *-------------------------------------------------------------*   00783000
       COPY CFDCAEPY.                                                   00790000
       01   FIOCAEPY.                                                   
            03  CSHCNACH-OUTPUT-EPAY           PIC X(94).               
                                                                        
      *-------------------------------------------------------------*   00820000
      *         FD FOR ERROR FILE, THIS WILL SEND EMAIL TO          *   00821000
      *  ISDCSRCAPSSUPPORT TEAM WHEN NO EPAY RECORDS FOUND          *   00821100
      *-------------------------------------------------------------*   00822000
       FD  FCS169OT-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 80 CHARACTERS                                
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01   FCS169OUT-REC                      PIC X(80).               
      *                                                                 00850000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC169'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05  WS-PGRMNAME                     PIC X(08)                
                                                       VALUE 'PCSAC169'.
           05  WS-BLOCK-CNT                    PIC 9(06).               
           05  WS-CENTURY                      PIC X(02).               
           05  WS-DRAFT-REC-WRITTEN            PIC 9(06) VALUE ZEROES.  
           05  WS-EPAY-REC-WRITTEN             PIC 9(06) VALUE ZEROES.  
           05  WS-REC-WRITTEN                  PIC 9(06) VALUE ZEROES.  
           05  WS-CSHCNACH-6-TRANSITR-8-DFT    PIC 9(10).               
           05  WS-CSHCNACH-6-TRANSITR-8-EPY    PIC 9(10).               
           05  WS-CSHCNACH-ADDENDA-COUNT-DFT   PIC 9(06) VALUE ZEROES.  
           05  WS-CSHCNACH-ADDENDA-COUNT-EPY   PIC 9(06) VALUE ZEROES.  
           05  WS-CSHCNACH-6-DRAFT-AMT-DFT     PIC 9(10)V99.            
           05  WS-CSHCNACH-6-DRAFT-AMT-EPY     PIC 9(10)V99.            
           05  WS-DRAFT-TAX-ID-LIT             PIC X(20)  VALUE         
               'DRAFT-TAX-ID-EPAY   '.                                  
           05  WS-VALID-TAX-ID                 PIC 9(10).               
           05  WS-COMPANY-NAME                 PIC X(16).               
      *                                                                 01130000
           05  WS-WORK-CNT                     PIC 9(06).               
           05  WS-WORK-CNT-DIGIT    REDEFINES WS-WORK-CNT.              
               10  WS-WORK-CNT-DIGIT5          PIC 9(05).               
               10  WS-WORK-CNT-DIGIT6TH        PIC 9(01).               
      *                                                                 01170700
       01  WS-BKD-DATE.                                                 
           05  WS-BKD-DATE-CC              PIC X(02).                   
           05  WS-BKD-DATE-YY              PIC X(02).                   
           05  FILLER                      PIC X(01) VALUE '-'.         
           05  WS-BKD-DATE-MM              PIC X(02).                   
           05  FILLER                      PIC X(01) VALUE '-'.         
           05  WS-BKD-DATE-DD              PIC X(02).                   
      *                                                                 01171500
       01  WS-LITERALS.                                                 
           05  WS-Y                            PIC X(01)  VALUE 'Y'.    
           05  WS-N                            PIC X(01)  VALUE 'N'.    
           05  WS-01                           PIC X(02)  VALUE '01'.   
      *                                                                 01172000
       01  WS-FILE-STATUS-AREA.                                         
           05  WS-FAC03-STATUS                 PIC X(02).               
               88  FAC03-SUCCESSFUL            VALUE '00'.              
           05  WS-FCADFT-STATUS                PIC X(02).               
               88  FCADFT-SUCCESSFUL           VALUE '00'.              
           05  WS-FCAEPY-STATUS                PIC X(02).               
               88  FCAEPY-SUCCESSFUL           VALUE '00'.              
           05  WS-FCS169OUT-STATUS             PIC X(02) VALUE '00'.    
               88  FCS169-SUCCESSFUL           VALUE '00'.              
      *                                                                 01203000
       01  WS-FLAGS.                                                    
           05  WS-EPAY-RECORD                  PIC X(01) VALUE 'N'.     
               88  NO-EPAY-RECORDS             VALUE 'N'.               
      *                                                                 01207000
       01  WS-EOF-FLAG                         PIC X(01)  VALUE 'N'.    
           88  END-OF-FILE                     VALUE 'Y'.               
      *                                                                 01284000
       01  WS-TIME-STAMP-SAVE                  PIC X(19).               
      *                                                                 01286000
       01  MAILHEAD-1.                                                  
           05  FILLER                          PIC X(22) VALUE          
               'HELO DOMAIN:     SCANA'.                                
                                                                        
       01  MAILHEAD-2.                                                  
           05  FILLER                          PIC X(15) VALUE          
               'MAIL FROM:   <T'.                                       
           05  MAIL2-JOB-NAME                  PIC X(07).               
           05  FILLER                          PIC X(20) VALUE          
               '@SCEGJES2.SCANA.COM>'.                                  
                                                                        
       01  MAILHEAD-3.                                                  
           05  FILLER                          PIC X(42) VALUE          
               'RCPT TO:     <ISDCSRCAPSSUPPORT@SCANA.COM>'.            
                                                                        
       01  MAILHEAD-4.                                                  
           05  FILLER                          PIC X(04) VALUE          
               'DATA'.                                                  
      *                                                                 01290700
       01  MAILHEAD-5.                                                  
           05  FILLER                          PIC X(19) VALUE          
               'FROM: CSR PAGING <T'.                                   
           05  MAIL5-JOB-NAME                  PIC X(07).               
           05  FILLER                          PIC X(20) VALUE          
               '@SCEGJES2.SCANA.COM>'.                                  
                                                                        
       01  MAILHEAD-6.                                                  
           05  FILLER                          PIC X(35) VALUE          
               'TO:   <ISDCSRCAPSSUPPORT@SCANA.COM>'.                   
                                                                        
       01  MAILHEAD-7.                                                  
           05  FILLER                          PIC X(10) VALUE          
               'SUBJECT:  '.                                            
           05  MAIL7-JOB-NAME                  PIC X(07).               
                                                                        
       01  MAILHEAD-8.                                                  
           05  FILLER                          PIC X(44) VALUE          
               'NON-CRITICAL ERROR OCCURED DURING PROCESSING'.          
      *                                                                 01292800
       01  MAILHEAD-9.                                                  
           05  FILLER                    PIC X(80) VALUE SPACES.        
                                                                        
       01  WS02-ERROR-LINE.                                             
           05  FILLER                    PIC X(01) VALUE SPACES.        
           05  WS02-ERROR-DATE           PIC X(19).                     
           05  FILLER                    PIC X(02) VALUE SPACES.        
           05  WS02-ERROR-DESC           PIC X(58).                     
      *                                                                 01296000
       COPY CWS00010.                                                   01297000
       COPY FIOJC01.                                                    01298000
      *                                                                 01300000
           EXEC SQL                                                     01300100
                INCLUDE SQLCA                                           01300200
           END-EXEC.                                                    01300300
                                                                        
      ***************************************************************** 01304500
      *  COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND               * 01304600
      ***************************************************************** 01304700
                                                                        
           COPY CWS00303.                                               01304900
                                                                        
      ***************************************************************** 01305100
      *  COPY BOOK FOR COMMON DATE                                    * 01305200
      ***************************************************************** 01305300
                                                                        
           COPY CWS00038.                                               01305500
                                                                        
      ***************************************************************** 01305700
      *  ABEND SWITCH COPYBOOK                                        * 01305800
      ***************************************************************** 01305900
                                                                        
           COPY CWS09900.                                               01306100
                                                                        
      ***************************************************************** 01307000
      *    CSS_JOB_PARM                                               * 01307100
      ***************************************************************** 01307200
           EXEC SQL                                                     01307300
               INCLUDE TBJBPARM                                         01307400
           END-EXEC.                                                    01307500
                                                                        
      ***************************************************************** 01307700
      *    CSS_DELINQUENCY                                            * 01307800
      ***************************************************************** 01307900
           EXEC SQL                                                     01308000
              INCLUDE TBDELQ                                            01308100
           END-EXEC.                                                    01309000
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARM.                                                        
           05  LNGTH                   PIC S9(04) COMP.                 
           05  WS-PASS-JOB             PIC X(07).                       
                                                                        
       PROCEDURE DIVISION USING PARM.                                   
                                                                        
      ******************************************************************04141000
      *             M A I N L I N E                                    *04142000
      ******************************************************************04142100
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                                      
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-INPUT                                   
              THRU 1000-EXIT UNTIL  END-OF-FILE                         
                                                                        
           IF NO-EPAY-RECORDS                                           
              MOVE 03 TO RETURN-CODE                                    
              PERFORM 8400-WRITE-PAGEOUT                                
                 THRU 8400-EXIT                                         
           END-IF.                                                      
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04631000
      * COMMON INITIALIZE PARA FOR OPENING FILES                       *04632000
      ******************************************************************04633000
       0100-INITIALIZE.                                                 
                                                                        
      * OPEN THE INPUT DRAFT FILE                                       04651000
           OPEN INPUT FCSAC03-FILE                                      
      *                                                                 04670000
           IF  FAC03-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** PCSCA169  PROCESSING ERROR  **'              
               DISPLAY '0100-ERROR ON FCSAC03 OPEN.  STATUS IS '        
                       WS-FAC03-STATUS                                  
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF                                                       
      *                                                                 04780000
      * OPEN THE OUTPUT DRAFT FILE                                      04781000
           OPEN OUTPUT FCSCADFT-FILE                                    
      *                                                                 04800000
           IF  FCADFT-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** PCSCA169  PROCESSING ERROR  **'              
               DISPLAY ' ERROR ON FCSCADRT OPEN.  STATUS IS '           
                       WS-FCADFT-STATUS                                 
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF                                                       
      *                                                                 04910000
      * OPEN THE OUTPUT EPAY FILE                                       04911000
           OPEN OUTPUT FCSCAEPY-FILE                                    
      *                                                                 04930000
           IF  FCAEPY-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** PCSCA169   PROCESSING ERROR  **'             
               DISPLAY '0100-ERROR ON FCSCAEPY OPEN.  STATUS IS '       
                       WS-FCAEPY-STATUS                                 
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF                                                       
      *                                                                 05040000
           PERFORM 0200-GET-COMMONDATE                                  
              THRU 0200-EXIT                                            
      *                                                                 05043000
      * SELECT THE VALID TAX ID AND COMPANY NAME                        05044000
           MOVE WS-DRAFT-TAX-ID-LIT   TO C8-DELINQ-CD                   
           MOVE WS-01                 TO C8-COMPANY-NO                  
                                                                        
           PERFORM 7650-SELECT-COMPANY-DRAFT-INFO                       
              THRU 7650-EXIT                                            
                                                                        
           MOVE C8-DESCRIPTION-TEXT (1:10)  TO WS-VALID-TAX-ID          
           MOVE C8-DESCRIPTION-TEXT (12:16) TO WS-COMPANY-NAME          
      *                                                                 05121000
           PERFORM 7100-GET-TIMESTAMP                                   
              THRU 7100-EXIT                                            
      *                                                                 05124000
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05621000
      *       GET COMMONDATE.                                          *05622000
      ******************************************************************05623000
       0200-GET-COMMONDATE.                                             
                                                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES     TO WS-INPUT-AREA                          
              MOVE SPACES     TO WS-INPUT-DATA-BREAKDOWN                
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
              MOVE 'PCSAC160' TO WS-PGRMNAME
           END-IF.                           
                                                                        
           MOVE WS-INPUT-DATE(1:2) TO WS-CENTURY.                       
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05650000
      ******************************************************************05650100
      *       VALIDATE INPUT DATE IN THE BANKDRAFT HEADER              *05650200
      ******************************************************************05650300
       0700-PROCESS-BKD-HEADER.                                         
                                                                        
           MOVE   WS-CENTURY        TO WS-BKD-DATE-CC                   
           MOVE CSHCNACH-1-FILE-CREATE-YY                               
                                    TO WS-BKD-DATE-YY                   
           MOVE CSHCNACH-1-FILE-CREATE-MM                               
                                    TO WS-BKD-DATE-MM                   
           MOVE CSHCNACH-1-FILE-CREATE-DD                               
                                    TO WS-BKD-DATE-DD                   
           IF WS-INPUT-DATE NOT = WS-BKD-DATE                           
                 DISPLAY '  '                                           
                 DISPLAY '** PCSAC169 PROCESSING ERROR '                
                 DISPLAY '** DATE ON BANKDRAFT HEADER (' WS-BKD-DATE    
                     ') DOES NOT MATCH RUN DATE (' WS-INPUT-DATE        
                 DISPLAY '** PROCESSING TERMINATED '                    
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-IF.                                                      
                                                                        
       0700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05660000
      ******************************************************************05670000
      *  READS AND VALIDATE THE RECORDS                                *05680000
      ******************************************************************05690000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE SPACES TO CSHCNACH-OUTPUT-RECORD                        
                                                                        
           PERFORM 1100-READ-RECORDS                                    
              THRU 1100-EXIT                                            
                                                                        
           PERFORM 1200-VALIDATE-RECORDS                                
              THRU 1200-EXIT                                            
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06590000
      ******************************************************************06591000
      *  1100-READ-RECORDS.                                            *06592000
      *       READS THE INPUT FCSAC03 FILE                             *06592100
      ******************************************************************06593000
       1100-READ-RECORDS.                                               
                                                                        
           READ FCSAC03-FILE                                            
             AT END MOVE WS-Y     TO WS-EOF-FLAG                        
                                                                        
           IF FAC03-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              IF END-OF-FILE                                            
                 MOVE SPACES      TO CSHCNACH-OUTPUT-RECORD             
              ELSE                                                      
                 DISPLAY 'ERROR ON READING FCSAC03'                     
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND           THRU 9900-EXIT            
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06770100
      * 1200-VALIDATE-RECORDS                                          *06771000
      *        SPLITS THE INPUT FILE AND WRITE IT TO TWO OUTPUT FILES  *06771100
      *        1. DRAFT   AND   2. EPAY                                *06771200
      ******************************************************************06772000
       1200-VALIDATE-RECORDS.                                           
                                                                        
           EVALUATE  CSHCNACH-RECORD-TYPE                               
                                                                        
              WHEN '1'                                                  
                  PERFORM 0700-PROCESS-BKD-HEADER                       
                     THRU 0700-EXIT                                     
                                                                        
                  PERFORM 2000-WRITE-DRAFT                              
                     THRU 2000-EXIT                                     
                                                                        
                  MOVE WS-VALID-TAX-ID                                  
                    TO CSHCNACH-1-IMMED-ORIGIN                          
                  MOVE WS-COMPANY-NAME                                  
                    TO CSHCNACH-1-IMMED-ORIGIN-NAME                     
                                                                        
                  PERFORM 2100-WRITE-EPAY                               
                     THRU 2100-EXIT                                     
              WHEN '5'                                                  
                 PERFORM 2000-WRITE-DRAFT                               
                    THRU 2000-EXIT                                      
                                                                        
                 MOVE 'WEB'                                             
                   TO CSHCNACH-5-STD-ENTRY-CLASS                        
                 MOVE WS-VALID-TAX-ID                                   
                   TO CSHCNACH-5-COMPANY-ID                             
                 MOVE WS-COMPANY-NAME                                   
                   TO CSHCNACH-5-COMPANY-NAME                           
                                                                        
                 PERFORM 2100-WRITE-EPAY                                
                    THRU 2100-EXIT                                      
              WHEN '6'                                                  
P00613           IF CSHCNACH-6-BANK-DISCRET-DATA(1:1) = SPACES          
                    ADD 1  TO WS-CSHCNACH-ADDENDA-COUNT-DFT             
                                                                        
                    MOVE WS-CSHCNACH-ADDENDA-COUNT-DFT                  
                      TO CSHCNACH-6-TRACE-SEQ                           
                                                                        
                    ADD CSHCNACH-6-TRANSITR-8                           
                     TO WS-CSHCNACH-6-TRANSITR-8-DFT                    
                    ADD CSHCNACH-6-DRAFT-AMT                            
                     TO WS-CSHCNACH-6-DRAFT-AMT-DFT                     
P00613              IF CSHCNACH-6-BANK-DISCRET-DATA(2:1) = 'I'          
P00613                 MOVE SPACE TO CSHCNACH-6-BANK-DISCRET-DATA(2:1)  
P00613              END-IF                                              
                                                                        
                    PERFORM 2000-WRITE-DRAFT                            
                       THRU 2000-EXIT                                   
                 ELSE                                                   
P00613              IF CSHCNACH-6-BANK-DISCRET-DATA(1:1) = 'S'          
                       ADD 1  TO WS-CSHCNACH-ADDENDA-COUNT-EPY          
                                                                        
                       MOVE WS-CSHCNACH-ADDENDA-COUNT-EPY               
                         TO CSHCNACH-6-TRACE-SEQ                        
                                                                        
                       ADD CSHCNACH-6-TRANSITR-8                        
                        TO WS-CSHCNACH-6-TRANSITR-8-EPY                 
                       ADD CSHCNACH-6-DRAFT-AMT                         
                        TO WS-CSHCNACH-6-DRAFT-AMT-EPY                  
P00613                 IF CSHCNACH-6-BANK-DISCRET-DATA(2:1) = 'I'       
P00613                    MOVE SPACE TO                                 
P00613                         CSHCNACH-6-BANK-DISCRET-DATA(2:1)        
P00613                 END-IF                                           
                                                                        
                       PERFORM 2100-WRITE-EPAY                          
                          THRU 2100-EXIT                                
                                                                        
                       MOVE WS-Y                                        
                         TO WS-EPAY-RECORD                              
                    END-IF                                              
                 END-IF                                                 
              WHEN '8'                                                  
                 MOVE WS-CSHCNACH-ADDENDA-COUNT-DFT                     
                   TO CSHCNACH-8-ENTRY-ADDENDA-COUNT                    
                 MOVE WS-CSHCNACH-6-TRANSITR-8-DFT                      
                   TO CSHCNACH-8-ENTRY-HASH                             
                 MOVE WS-CSHCNACH-6-DRAFT-AMT-DFT                       
                   TO CSHCNACH-8-TOTAL-DEBIT                            
                                                                        
                 PERFORM 2000-WRITE-DRAFT                               
                    THRU 2000-EXIT                                      
                                                                        
                 MOVE WS-CSHCNACH-ADDENDA-COUNT-EPY                     
                   TO CSHCNACH-8-ENTRY-ADDENDA-COUNT                    
                 MOVE WS-CSHCNACH-6-TRANSITR-8-EPY                      
                   TO CSHCNACH-8-ENTRY-HASH                             
                 MOVE WS-CSHCNACH-6-DRAFT-AMT-EPY                       
                   TO CSHCNACH-8-TOTAL-DEBIT                            
                 MOVE WS-VALID-TAX-ID                                   
                   TO CSHCNACH-8-COMPANY-ID                             
                                                                        
                 PERFORM 2100-WRITE-EPAY                                
                    THRU 2100-EXIT                                      
              WHEN '9'                                                  
                 MOVE WS-DRAFT-REC-WRITTEN                              
                   TO WS-REC-WRITTEN                                    
                                                                        
                 DISPLAY 'BLOCK COUNT FOR DRAFT      '                  
                                                                        
                 PERFORM 8000-CALCULATE-BLOCK                           
                    THRU 8000-EXIT                                      
                                                                        
                 MOVE WS-CSHCNACH-ADDENDA-COUNT-DFT                     
                   TO CSHCNACH-9-ENTRY-ADDENDA-COUNT                    
                 MOVE WS-CSHCNACH-6-TRANSITR-8-DFT                      
                   TO CSHCNACH-9-ENTRY-HASH                             
                 MOVE WS-CSHCNACH-6-DRAFT-AMT-DFT                       
                   TO CSHCNACH-9-TOTAL-DEBIT                            
                                                                        
                 PERFORM 2000-WRITE-DRAFT                               
                    THRU 2000-EXIT                                      
                                                                        
                 MOVE WS-EPAY-REC-WRITTEN                               
                   TO WS-REC-WRITTEN                                    
                                                                        
                 DISPLAY 'BLOCK COUNT FOR E-PAY      '                  
                                                                        
                 PERFORM 8000-CALCULATE-BLOCK                           
                    THRU 8000-EXIT                                      
                                                                        
                 MOVE WS-CSHCNACH-ADDENDA-COUNT-EPY                     
                   TO CSHCNACH-9-ENTRY-ADDENDA-COUNT                    
                 MOVE WS-CSHCNACH-6-TRANSITR-8-EPY                      
                   TO CSHCNACH-9-ENTRY-HASH                             
                 MOVE WS-CSHCNACH-6-DRAFT-AMT-EPY                       
                   TO CSHCNACH-9-TOTAL-DEBIT                            
                                                                        
                 PERFORM 2100-WRITE-EPAY                                
                    THRU 2100-EXIT                                      
           END-EVALUATE                                                 
           .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06830000
      ******************************************************************06840000
      * WRITE DRAFT FILE. (FIOCADFT)                                   *06850000
      ******************************************************************06860000
       2000-WRITE-DRAFT.                                                
                                                                        
           MOVE CSHCNACH-OUTPUT-RECORD                                  
             TO CSHCNACH-OUTPUT-DRAFT                                   
                                                                        
           WRITE FIOCADFT                                               
                                                                        
           ADD 1  TO  WS-DRAFT-REC-WRITTEN                              
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17590100
      ******************************************************************17590200
      * WRITE EPAY FILE.  (FIOCAEPY)                                   *17590300
      ******************************************************************17590400
       2100-WRITE-EPAY.                                                 
                                                                        
           MOVE CSHCNACH-OUTPUT-RECORD                                  
             TO CSHCNACH-OUTPUT-EPAY                                    
                                                                        
           WRITE FIOCAEPY                                               
                                                                        
           ADD 1  TO  WS-EPAY-REC-WRITTEN                               
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************17591600
      *  6251-GET-FJC01-DATE                                           *17591800
      ******************************************************************17592000
           EXEC SQL                                                     17592100
                INCLUDE CPD00037                                        17592200
           END-EXEC.                                                    17592300
      *                                                                 17592400
           EXEC SQL                                                     17592500
                INCLUDE CPD00038                                        17592600
           END-EXEC.                                                    17592700
      ******************************************************************17592800
      *   GET CURRENT TIMESTAMP                                        *17592900
      ******************************************************************17593000
       7100-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
T35434         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIME-STAMP-SAVE              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     17593300
MFA-TR*        SET :WS-TIME-STAMP-SAVE = CURRENT TIMESTAMP              17593400
MFA-TR*    END-EXEC.                                                    17593800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               DISPLAY 'PARA 7100-GET-TIMESTAMP'                        
               DISPLAY 'WS-ACTIVE-RETURN-CODE' WS-ACTIVE-RETURN-CODE    
T35434         DISPLAY 'ERROR IN SETTING CURRENT TIMESTAMP'             
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
HPCCDM*EJECT.                                                           17595400
                                                                        
      *************************************************************     17595600
      *                                                           *     17595700
      *7650-SELECT-COMPANY-DRAFT-INFO                             *     17595800
      *     SELECTS THE VALID TAX ID AND COMPANY DESCRIPTION      *     17595900
      *************************************************************     17596000
       7650-SELECT-COMPANY-DRAFT-INFO.                                  
                                                                        
           MOVE SPACES                       TO C8-DESCRIPTION-TEXT.    
                                                                        
           EXEC SQL                                                     
                SELECT  DELINQ_VALUE,                                   
                        DESCRIPTION                                     
                  INTO  :C8-DELINQ-VALUE,                               
                        :C8-DESCRIPTION                                 
                  FROM  CSS_DELINQUENCY                                 
                 WHERE  DELINQ_CD  = :C8-DELINQ-CD                      
                   AND  COMPANY_NO = :C8-COMPANY-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7650 ' WS-ACTIVE-RETURN-CODE                     
              DISPLAY '*************************************'           
              DISPLAY '**  PROCESSING ERROR'                            
              DISPLAY '**  PARAGRAPH = 7650- '                          
              DISPLAY '**  SELECT DELINQ VALUE'                         
              DISPLAY '**  RC                  = ' WS-ACTIVE-RETURN-CODE
              DISPLAY '**  DELINQUENCY CODE    = ' C8-DELINQ-CD         
              DISPLAY '**  PROCESSING TERMINATED'                       
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       7650-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************17599500
      *   8000-CALCULATE-BLOCK.                                        *17599600
      ******************************************************************17599700
       8000-CALCULATE-BLOCK.                                            
      *                                                                 17599900
           MOVE ZEROS                                                   
             TO WS-WORK-CNT                                             
      *                                                                 17600200
           MOVE WS-REC-WRITTEN                                          
             TO WS-WORK-CNT                                             
      *                                                                 17600500
           ADD 1                                                        
             TO WS-WORK-CNT                                             
      *                                                                 17600800
           PERFORM 8100-CAL-MULTI-10                                    
              THRU 8100-EXIT                                            
      *                                                                 17601100
           MOVE WS-BLOCK-CNT                                            
             TO CSHCNACH-9-BLOCK-COUNT                                  
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17601700
      **************************************************************    17601800
      * PARA 8100- LOOKS AT THE LAST DIGIT OF WS-WORK-CNT AND      *    17601900
      * DECIDES HOW MUCH TO ADD TO WS-WORK-CNT THAT WILL GIVE YOU  *    17602000
      * 10.                                                        *    17602100
      **************************************************************    17602200
       8100-CAL-MULTI-10.                                               
           DISPLAY 'WS-WORK-CNT BEFORE CHECKING ' WS-WORK-CNT           
                                                                        
           EVALUATE WS-WORK-CNT-DIGIT6TH                                
               WHEN 0                                                   
                ADD 0 TO WS-WORK-CNT                                    
               WHEN 1                                                   
                ADD 9 TO WS-WORK-CNT                                    
               WHEN 2                                                   
                ADD 8 TO WS-WORK-CNT                                    
               WHEN 3                                                   
                ADD 7 TO WS-WORK-CNT                                    
               WHEN 4                                                   
                ADD 6 TO WS-WORK-CNT                                    
               WHEN 5                                                   
                ADD 5 TO WS-WORK-CNT                                    
               WHEN 6                                                   
                ADD 4 TO WS-WORK-CNT                                    
               WHEN 7                                                   
                ADD 3 TO WS-WORK-CNT                                    
               WHEN 8                                                   
                ADD 2 TO WS-WORK-CNT                                    
               WHEN 9                                                   
                ADD 1 TO WS-WORK-CNT                                    
           END-EVALUATE                                                 
                                                                        
           DISPLAY 'WS-WORK-CNT AFTER  CHECKING ' WS-WORK-CNT           
           DIVIDE WS-WORK-CNT BY 10 GIVING WS-BLOCK-CNT                 
           DISPLAY 'WS-BLOCK-CNT COMPUTED       ' WS-BLOCK-CNT          
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
      *************************************************************     17605500
      *  IF NO EPAY ACCOUNTS IN THE DRAFT FILE IT WILL SEND AN    *     17605600
      *  EMAIL TO ISDCSRCAPSSUPPORT TEAM.                         *     17605700
      *************************************************************     17605800
       8400-WRITE-PAGEOUT.                                              
                                                                        
           OPEN OUTPUT FCS169OT-FILE.                                   
                                                                        
           IF FCS169-SUCCESSFUL                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSCA169 PROCESSING ERROR  **'               
              DISPLAY '**    OPEN ERROR OF PCS169OUT REPORT FILE'       
              DISPLAY '**    FILE STATUS = ' WS-FCS169OUT-STATUS        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
            MOVE WS-PASS-JOB TO MAIL2-JOB-NAME,                         
                                MAIL5-JOB-NAME,                         
                                MAIL7-JOB-NAME.                         
            WRITE FCS169OUT-REC FROM MAILHEAD-1.                        
            WRITE FCS169OUT-REC FROM MAILHEAD-2.                        
            WRITE FCS169OUT-REC FROM MAILHEAD-3.                        
            WRITE FCS169OUT-REC FROM MAILHEAD-4.                        
            WRITE FCS169OUT-REC FROM MAILHEAD-5.                        
            WRITE FCS169OUT-REC FROM MAILHEAD-6.                        
            WRITE FCS169OUT-REC FROM MAILHEAD-7.                        
            WRITE FCS169OUT-REC FROM MAILHEAD-9.                        
            WRITE FCS169OUT-REC FROM MAILHEAD-8.                        
                                                                        
            INITIALIZE WS02-ERROR-DESC.                                 
             MOVE WS-TIME-STAMP-SAVE TO WS02-ERROR-DATE.                
             MOVE 'NO E-PAY RECORDS WERE FOUND FOR THIS RUN'            
               TO WS02-ERROR-DESC                                       
            WRITE FCS169OUT-REC FROM WS02-ERROR-LINE.                   
            WRITE FCS169OUT-REC FROM MAILHEAD-9.                        
                                                                        
            PERFORM 9100-CLOSE-PCS169                                   
               THRU 9100-EXIT.                                          
                                                                        
       8400-EXIT.                                                       
            EXIT.                                                       
      *                                                                 17609900
      ******************************************************************17610000
      *    CLOSE ALL FILES.                                            *17610100
      ******************************************************************17610200
       9000-TERMINATE.                                                  
      *                                                                 17610400
           CLOSE FCSAC03-FILE                                           
      *                                                                 17610600
           IF  FAC03-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**PCSCA169   PROCESSING ERROR  **'              
               DISPLAY '9000-ERROR ON FCSAC03 CLOSE.  STATUS IS '       
                       WS-FAC03-STATUS                                  
               DISPLAY '**  PROCESSING TERMINATED  **'                  
           END-IF                                                       
      *                                                                 17611600
           CLOSE FCSCADFT-FILE                                          
      *                                                                 17611800
           IF  FCADFT-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** PCSCA169  PROCESSING ERROR  **'              
               DISPLAY '9000-ERROR ON FCSCADFT CLOSE  STATUS IS '       
                       WS-FCADFT-STATUS                                 
               DISPLAY '**  PROCESSING TERMINATED  **'                  
           END-IF                                                       
      *                                                                 17612800
           CLOSE FCSCAEPY-FILE                                          
      *                                                                 17613000
           IF  FCAEPY-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** PCSCA169  PROCESSING ERROR  **'              
               DISPLAY '9000-ERROR ON FCSCAEPY CLOSE  STATUS IS '       
                       WS-FCAEPY-STATUS                                 
               DISPLAY '**  PROCESSING TERMINATED  **'                  
           END-IF                                                       
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17614400
      *   CLOSE FCS169OT FILE                                          *17614500
      ******************************************************************17614600
       9100-CLOSE-PCS169.                                               
      *                                                                 17614800
           CLOSE FCS169OT-FILE                                          
      *                                                                 17615000
           IF  FCS169-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '** PCSCA169  PROCESSING ERROR  **'              
               DISPLAY '9100-ERROR ON FCSCA169 CLOSE  STATUS IS '       
                       WS-FCS169OUT-STATUS                              
               DISPLAY '**  PROCESSING TERMINATED  **'                  
           END-IF.                                                      
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
      ***********************************************************       17616500
      **    PERFORMED IF  PROBLEM OCCURS.                      **       17616600
      ***********************************************************       17616700
       9900-ABEND.                                                      
      *                                                                 17616900
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 'YES'                          TO WS-ABEND-SWITCH.      
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
           MOVE 12                             TO  RETURN-CODE.         
           IF WS-ABEND-YES                                              
              STOP RUN                                                  
           END-IF.                                                      
      *                                                                 17617700
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17620000
