       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSAC115.                                           
       DATE-WRITTEN.  OCTOBER 2009.                                     
      *****************************************************************         
      **                                                             **         
      **                       SCANA SERVICES                        **         
      ********           CUSTOMER INFORMATION SYSTEM          *********         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE        INITIALS       REASON                           **         
      ** ----------  --------   ------------------------------------ **         
P00526** 21/10/2009  LAT        PROGRAM INITALLY WRITTEN.            **         
A02944** 01/25/2011  R SPIRES   CHANGE O/P FILE FORMAT FOR FASTLOAD  **         
      **                                                             **         
      *****************************************************************         
      *                   PROGRAM SUMMARY                             *         
      *                                                               *         
      *   THIS PROGRAM COMPARES BILLMATRIX ENROLL-CANCEL ACTIVITY FILE*         
      *   AND DB2 TABLE CSS_ACCT_ATTRIBUTE FOR AUTOCARD ENROLLMENTS   *         
      *   AND CANCELLATIONS AND REPORTS ANY DISCREPENCIES.            *         
      *                                                               *         
      *****************************************************************         
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           *         
      *****************************************************************         
      *   0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION                  
      *   1000 - 1999     INPUT PROCESSING CONTROL PATH                         
      *   2000 - 2999     OUTPUT PROCESSING CONTROL PATH                        
      *   3000 - 4999     BATCH PROCESSING MODULES - NOT USED                   
      *   5000 - 5999     COMMON PROGRAM MODULES                                
      *   6000 - 6999     COMMON SYSTEM MODULES                                 
      *   7000 - 7999     INPUT MODULES                                         
      *   8000 - 8999     OUTPUT MODULES                                        
      *   9000 - 9799     TERMINATION MODULES                                   
      *   9800 - 9899     XCTLS TO PROGRAMS                                     
      *   9900 - 9999     ABEND/ABORT MODULES                                   
      *                                                                         
      **************************************************************            
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT AC115BMX-FILE                                         
             ASSIGN UT-S-AC115BMX                                       
             FILE STATUS IS WS-AC115BMX-STATUS.                         
                                                                        
           SELECT RP115OUT-FILE                                         
             ASSIGN UT-S-AC115OUT                                       
             FILE STATUS IS WS-RP115OUT-STATUS.                         
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  AC115BMX-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD                                 
           DATA RECORD     IS AC115-DETAIL-REC.                         
       COPY FIOAC115.                                                           
                                                                        
       FD  RP115OUT-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
       01  RP115-OUT-REC               PIC X(70).                       
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC115'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-WORK-VARIABLES.                                            
          05 WS-ACCOUNT-NO             PIC 9(13) VALUE 0.               
          05 WS-SYSIN-COMPANY-NO       PIC X(02) VALUE SPACES.          
          05 WS-CURRENT-DATE           PIC X(10).                       
          05 WS-EXCPTN-COUNT           PIC 9(05) VALUE 0.               
          05 WS-LAST-RUN-DATA.                                          
             10 WS-LAST-RUN            PIC X(14).                       
                88 WS-LAST-RUN-TXT     VALUE 'LAST RUN DATE='.          
             10 WS-LAST-RUN-DT         PIC X(10).                       
             10 FILLER                 PIC X(56).                       
      *                                                                         
          05 WS-LAST-RUN-DATE-TS       PIC X(26).                       
          05 WS-LAST-RUN-DATE-TS-R  REDEFINES WS-LAST-RUN-DATE-TS.      
             10 WS-LAST-RUN-DATE       PIC X(10).                       
             10 WS-LAST-RUN-TS         PIC X(16).                       
                                                                        
          05 WS-COMMON-DATE-TS         PIC X(26).                       
          05 WS-COMMON-DATE-TS-R  REDEFINES WS-COMMON-DATE-TS.          
             10 WS-COMMON-DATE         PIC X(10).                       
             10 WS-TIMESTAMP           PIC X(16).                       
      *                                                                         
       01 WS-MISC-FIELDS.                                               
          05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSAC115'.      
          05 WS-PGRMNAME               PIC X(08) VALUE 'PCSAC115'.      
          05 WS-ERROR-MSG              PIC X(120) VALUE SPACES.         
          05 WS-RETURN-CODE-DISP       PIC +ZZZZZZZZ9.                  
          05 WS-NULL-IND               PIC S9(04) COMP.                 
          05 WS-NULL-IND1              PIC S9(04) COMP.                 
          05 WS-STATUS-CD              PIC X(01) VALUE SPACE.           
          05 WS-N                      PIC X(01) VALUE 'N'.             
          05 WS-Y                      PIC X(01) VALUE 'Y'.             
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 WS-AC115BMX-STATUS        PIC X(02).                       
             88 AC115BMX-SUCCESSFUL              VALUE '00'.            
          05 WS-RP115OUT-STATUS        PIC X(02).                       
             88 RP115OUT-SUCCESSFUL              VALUE '00'.            
          05 WS-AC115BMX-FLAG          PIC X(01) VALUE SPACES.          
             88 END-OF-AC115BMX                  VALUE 'Y'.             
                                                                        
       01 WS-DETAIL-REC.                                                
          05 WS-OUTFILE-DET-REC.                                        
             10 RP115-ACCOUNT-NO                PIC X(13).              
             10 RP115-AUTOC-STATUS              PIC X(01).              
             10 RP115-STATUS-DATE               PIC X(10).              
A02944       10 RP115-COMMENTS                  PIC X(46).              
                                                                        
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      *** DCLGEN FOR CSS_ACCOUNT - AT                                           
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      *** DCLGEN FOR CSS_JOB_PARM - G6                                          
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      *** DCLGEN FOR CSS_ACCT_ATTRIBUTE - YP                                    
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE ACCT_ATTRIBUTE CURSOR FOR                         
              SELECT YP.ACCOUNT_NO,                                     
                     YP.ATTRIBUTE_DESC,                                 
                     YP.ATTRIBUTE_VALUE_DT,                             
                     YP.ATTRIBUTE_VALUE_TX,                             
                     YP.STATUS_CD                                       
                FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED),               
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE YP.ACCOUNT_NO = AT.ACCOUNT_NO                      
                 AND AT.COMPANY_NO = :AT-COMPANY-NO                     
                 AND YP.ATTRIBUTE_DESC      = 'AUTO_CARD_PAY'           
                 AND YP.ATTRIBUTE_VALUE_DT >= IIF(TRY_CONVERT(DATE, 
                                                        :WS-LAST-RUN-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DT
              ) <> 0) OR (LEN(:WS-LAST-RUN-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-LAST-RUN-DT
              ), CONVERT(DATE, :WS-LAST-RUN-DT) )           
                 AND CIS.SUBSTR3(YP.ATTRIBUTE_VALUE_TX,81,1) = ' '           
                 AND (((YP.CREATED_TS   >  CIS.CHAR2TIMESTAMP(
                                                   :WS-LAST-RUN-DATE-TS
              )         
                      AND YP.CREATED_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-COMMON-DATE-TS
              ))          
                      AND YP.STATUS_CD  =  'A')                         
                                    OR                                  
                     (CIS.SUBSTR3(YP.ATTRIBUTE_VALUE_TX,1,9)                 
                                               = 'CANCEL_TS'    AND     
                     (CIS.SUBSTR3(YP.ATTRIBUTE_VALUE_TX,11,25)               
                                         > :WS-LAST-RUN-DATE-TS AND     
                     CIS.SUBSTR3(YP.ATTRIBUTE_VALUE_TX,11,25)                
                                        <= :WS-COMMON-DATE-TS)  AND     
                     YP.STATUS_CD IN ('C','B')))                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCT_ATTRIBUTE CURSOR FOR                                 
MFA-TR*       SELECT YP.ACCOUNT_NO,                                             
MFA-TR*              YP.ATTRIBUTE_DESC,                                         
MFA-TR*              YP.ATTRIBUTE_VALUE_DT,                                     
MFA-TR*              YP.ATTRIBUTE_VALUE_TX,                                     
MFA-TR*              YP.STATUS_CD                                               
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP,                                     
MFA-TR*              CSS_ACCOUNT AT                                             
MFA-TR*        WHERE YP.ACCOUNT_NO = AT.ACCOUNT_NO                              
MFA-TR*          AND AT.COMPANY_NO = :AT-COMPANY-NO                             
MFA-TR*          AND YP.ATTRIBUTE_DESC      = 'AUTO_CARD_PAY'                   
MFA-TR*          AND YP.ATTRIBUTE_VALUE_DT >= :WS-LAST-RUN-DT                   
MFA-TR*          AND SUBSTR(YP.ATTRIBUTE_VALUE_TX,81,1) = ' '                   
MFA-TR*          AND (((YP.CREATED_TS   >  :WS-LAST-RUN-DATE-TS                 
MFA-TR*               AND YP.CREATED_TS <= :WS-COMMON-DATE-TS)                  
MFA-TR*               AND YP.STATUS_CD  =  'A')                                 
MFA-TR*                             OR                                          
MFA-TR*              (SUBSTR(YP.ATTRIBUTE_VALUE_TX,1,9)                         
MFA-TR*                                        = 'CANCEL_TS'    AND             
MFA-TR*              (SUBSTR(YP.ATTRIBUTE_VALUE_TX,11,25)                       
MFA-TR*                                  > :WS-LAST-RUN-DATE-TS AND             
MFA-TR*              SUBSTR(YP.ATTRIBUTE_VALUE_TX,11,25)                        
MFA-TR*                                 <= :WS-COMMON-DATE-TS)  AND             
MFA-TR*              YP.STATUS_CD IN ('C','B')))                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
           PERFORM 2000-PROCESS-ACCOUNTS     THRU 2000-EXIT.            
           PERFORM 9000-TERMINATE            THRU 9000-EXIT.            
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *0100-INITIALIZE.  OPENS INPUT/OUTPUT FILES.                              
      *****************************************************************         
       0100-INITIALIZE.                                                 
           MOVE '0100'                       TO WS-ACTIVE-PARAGRAPH.    
      *                                                                         
           OPEN INPUT  AC115BMX-FILE.                                   
           IF AC115BMX-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  'INPUT FILE OPEN STATUS IS ' DELIMITED BY SIZE    
                       WS-AC115BMX-STATUS          DELIMITED BY SIZE    
                       INTO WS-ERROR-MSG                                
              PERFORM 8900-DISPLAY-ABEND     THRU 8900-EXIT             
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT RP115OUT-FILE.                                   
           IF RP115OUT-SUCCESSFUL                                       
              MOVE SPACES TO RP115-COMMENTS                             
           ELSE                                                         
              STRING  'OUTPUT FILE OPEN STATUS IS ' DELIMITED BY SIZE   
                       WS-RP115OUT-STATUS            DELIMITED BY SIZE  
                       INTO WS-ERROR-MSG                                
              PERFORM 8900-DISPLAY-ABEND     THRU 8900-EXIT             
           END-IF.                                                      
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       1000-PROCESS-INPUT.                                              
           ACCEPT WS-SYSIN-COMPANY-NO        FROM SYSIN.                
           MOVE WS-SYSIN-COMPANY-NO          TO G6-COMPANY-NO.          
                                                                        
           MOVE '-19.00.00.000000'           TO WS-LAST-RUN-TS,         
                                                WS-TIMESTAMP.           
           PERFORM 7450-GET-LAST-RUN-DT      THRU 7450-EXIT.            
           MOVE WS-LAST-RUN-DT               TO WS-LAST-RUN-DATE.       
      *                                                                         
           PERFORM 1150-GET-COMMON-DT        THRU 1150-EXIT.            
           DISPLAY ' LAST RUN TIMESTAMP    = ' WS-LAST-RUN-DATE-TS.     
           DISPLAY ' COMMON DATE TIMESTAMP = ' WS-COMMON-DATE-TS.       
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *GET COMMON DATE                                                          
      ****************************************************************          
       1150-GET-COMMON-DT.                                              
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '                  TO WS-PGRMNAME           
              MOVE '01'                        TO G6-COMPANY-NO         
              MOVE SPACES                      TO WS-INPUT-AREA         
              MOVE SPACES                      TO                       
                                           WS-INPUT-DATA-BREAKDOWN      
              PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT           
              MOVE WS-PROGRAM-NAME             TO WS-PGRMNAME           
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE      TO WS-COMMON-DATE.                   
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *2000-PROCESS-ACCOUNTS.                                                   
      **************************************************************            
       2000-PROCESS-ACCOUNTS.                                           
           PERFORM 2500-PROCESS-FROM-FILE    THRU 2500-EXIT             
                        UNTIL END-OF-AC115BMX.                          
           MOVE WS-SYSIN-COMPANY-NO          TO AT-COMPANY-NO.          
           PERFORM 7125-OPEN-CURSOR          THRU 7125-EXIT.            
           PERFORM 7250-ACCTS-FROM-CUR       THRU 7250-EXIT             
                        UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.        
           PERFORM 7145-CLOSE-CURSOR         THRU 7145-EXIT.            
           IF WS-EXCPTN-COUNT = 0                                       
              PERFORM 8300-WRITE-BLANK-REC   THRU 8300-EXIT             
           END-IF.                                                      
           DISPLAY 'NO. OF EXCEPTIONS = ' WS-EXCPTN-COUNT.              
                                                                        
           PERFORM 7650-GET-CURR-DATE        THRU 7650-EXIT.            
           PERFORM 8400-UPDATE-LAST-RUN-DT   THRU 8400-EXIT.            
           IF OVERRIDE-DATE-LOADED                                      
              PERFORM 8450-UPDATE-OVERRIDE-DT   THRU 8450-EXIT          
           END-IF.                                                      
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2500-PROCESS-FROM-FILE.                                          
           INITIALIZE DCLCSS-ACCT-ATTRIBUTE.                            
           MOVE '2500'                       TO WS-ACTIVE-PARAGRAPH.    
           PERFORM 7050-READ-INPUT-FILE      THRU 7050-EXIT.            
           MOVE E-ACCOUNT-NO                 TO WS-ACCOUNT-NO.          
           MOVE WS-ACCOUNT-NO                TO YP-ACCOUNT-NO.          
           PERFORM 7100-SELECT-ACCT-ATTR     THRU 7100-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 8350-UPDATE-ACCT-ATTR  THRU 8350-EXIT             
              IF AT-COMPANY-NO NOT = WS-SYSIN-COMPANY-NO                
                 MOVE 'DIFFERENT COMPANY ACCT'  TO RP115-COMMENTS       
                 PERFORM 8200-WRITE-OUTFILE     THRU 8200-EXIT          
                 GO TO 2500-EXIT                                        
              END-IF                                                    
              IF (YP-STATUS-CD = WS-STATUS-CD) OR                       
                     ((YP-STATUS-CD = 'B' OR YP-STATUS-CD = 'C') AND    
                      (WS-STATUS-CD = 'C'))                             
                 NEXT SENTENCE                                          
              ELSE                                                      
                 STRING 'STATUS IN OUR DATABASE IS ' DELIMITED BY SIZE  
                         YP-STATUS-CD DELIMITED BY SIZE                 
                                      INTO RP115-COMMENTS               
                 PERFORM 8200-WRITE-OUTFILE  THRU 8200-EXIT             
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'NOT FOUND IN DATABASE' TO RP115-COMMENTS         
                 MOVE WS-STATUS-CD            TO YP-STATUS-CD           
                 MOVE SPACES                  TO YP-ATTRIBUTE-VALUE-DT  
                 PERFORM 8200-WRITE-OUTFILE   THRU 8200-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *6251-GET-FJC01-DATE                                                      
      ****************************************************************          
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
                                                                        
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
      *                                                                         
       7050-READ-INPUT-FILE.                                            
           MOVE '7050'                       TO WS-ACTIVE-PARAGRAPH.    
           READ AC115BMX-FILE                                           
                AT END                                                  
                   MOVE 'Y'                  TO WS-AC115BMX-FLAG.       
                                                                        
           IF END-OF-AC115BMX                                           
              GO TO 2500-EXIT                                           
           ELSE                                                         
              IF AC115BMX-SUCCESSFUL                                    
                 EVALUATE E-RECORD-ID                                   
                    WHEN 'D'                                            
                       EVALUATE E-AUTOC-STATUS                          
                          WHEN 'ENR'                                    
                             MOVE 'A'       TO WS-STATUS-CD             
                          WHEN 'CAN'                                    
                             MOVE 'C'       TO WS-STATUS-CD             
                          WHEN OTHER                                    
                             MOVE SPACE     TO WS-STATUS-CD             
                       END-EVALUATE                                     
                                                                        
                    WHEN 'T'                                            
                       MOVE SPACES           TO WS-STATUS-CD            
                       MOVE 'Y'              TO WS-AC115BMX-FLAG        
                       GO TO 2500-EXIT                                  
                                                                        
                    WHEN OTHER                                          
                       STRING 'INVALUD RECORD ID '  DELIMITED BY SIZE   
                               E-RECORD-ID          DELIMITED BY SIZE   
                               INTO WS-ERROR-MSG                        
                       PERFORM 8900-DISPLAY-ABEND   THRU 8900-EXIT      
                 END-EVALUATE                                           
                                                                        
                 IF E-ACCOUNT-NO NOT NUMERIC                            
                    STRING 'ACCOUNT '            DELIMITED BY SIZE      
                            E-ACCOUNT-NO         DELIMITED BY SIZE      
                           ' IS NOT NUMERIC. '   DELIMITED BY SIZE      
                      INTO WS-ERROR-MSG                                 
                    PERFORM 8900-DISPLAY-ABEND   THRU 8900-EXIT         
                 END-IF                                                 
              ELSE                                                      
                 STRING 'AC115BMX FILE READ ERROR ' DELIMITED SIZE      
                        'FILE STATUS IS '  DELIMITED BY SIZE            
                        WS-AC115BMX-STATUS DELIMITED BY SIZE            
                                           INTO WS-ERROR-MSG            
                 PERFORM 8900-DISPLAY-ABEND  THRU 8900-EXIT             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-ACCT-ATTR.                                           
           EXEC SQL                                                     
              SELECT YP.ACCOUNT_NO,                                     
                     AT.COMPANY_NO,                                     
                     YP.ATTRIBUTE_DESC,                                 
                     YP.ATTRIBUTE_VALUE_DT,                             
                     YP.ATTRIBUTE_VALUE_TX,                             
                     YP.STATUS_CD                                       
                INTO :YP-ACCOUNT-NO,                                    
                     :AT-COMPANY-NO,                                    
                     :YP-ATTRIBUTE-DESC,                                
                     :YP-ATTRIBUTE-VALUE-DT :WS-NULL-IND,                
                     :YP-ATTRIBUTE-VALUE-TX :WS-NULL-IND1,               
                     :YP-STATUS-CD                                      
              FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED),                 
                   CSS_ACCOUNT AT WITH(READUNCOMMITTED)                         
             WHERE YP.ACCOUNT_NO = :YP-ACCOUNT-NO                       
               AND YP.ACCOUNT_NO = AT.ACCOUNT_NO                        
               AND YP.ATTRIBUTE_DESC  = 'AUTO_CARD_PAY'                 
               AND YP.ATTRIBUTE_VALUE_DT >= IIF(TRY_CONVERT(DATE, 
                                                        :WS-LAST-RUN-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DT
              ) <> 0) OR (LEN(:WS-LAST-RUN-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-LAST-RUN-DT
              ), CONVERT(DATE, :WS-LAST-RUN-DT) )             
               AND YP.ATTRIBUTE_VALUE_DT <= IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )             
P00526*        AND SUBSTR(ATTRIBUTE_VALUE_TX, 81,1) = ' '                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT YP.ACCOUNT_NO,                                             
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              YP.ATTRIBUTE_DESC,                                         
MFA-TR*              YP.ATTRIBUTE_VALUE_DT,                                     
MFA-TR*              YP.ATTRIBUTE_VALUE_TX,                                     
MFA-TR*              YP.STATUS_CD                                               
MFA-TR*         INTO :YP-ACCOUNT-NO,                                            
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :YP-ATTRIBUTE-DESC,                                        
MFA-TR*              :YP-ATTRIBUTE-VALUE-DT:WS-NULL-IND,                        
MFA-TR*              :YP-ATTRIBUTE-VALUE-TX:WS-NULL-IND1,                       
MFA-TR*              :YP-STATUS-CD                                              
MFA-TR*       FROM CSS_ACCT_ATTRIBUTE YP,                                       
MFA-TR*            CSS_ACCOUNT AT                                               
MFA-TR*      WHERE YP.ACCOUNT_NO = :YP-ACCOUNT-NO                               
MFA-TR*        AND YP.ACCOUNT_NO = AT.ACCOUNT_NO                                
MFA-TR*        AND YP.ATTRIBUTE_DESC  = 'AUTO_CARD_PAY'                         
MFA-TR*        AND YP.ATTRIBUTE_VALUE_DT >= :WS-LAST-RUN-DT                     
MFA-TR*        AND YP.ATTRIBUTE_VALUE_DT <= :WS-COMMON-DATE                     
MFA-TR*        AND SUBSTR(ATTRIBUTE_VALUE_TX, 81,1) = ' '                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND < 0                                        
                 MOVE SPACES           TO YP-ATTRIBUTE-VALUE-DT         
              END-IF                                                    
              IF WS-NULL-IND1 < 0                                       
                 MOVE SPACES           TO YP-ATTRIBUTE-VALUE-TX-TEXT    
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE '7100'                 TO WS-ACTIVE-PARAGRAPH     
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-RETURN-CODE-DISP     
                 STRING 'ACCOUNT NO = '        DELIMITED BY SIZE        
                         WS-ACCOUNT-NO         DELIMITED BY SIZE        
                        ', SQLCODE = '         DELIMITED BY SIZE        
                         WS-RETURN-CODE-DISP   DELIMITED BY SIZE        
                        INTO WS-ERROR-MSG                               
                 PERFORM 8900-DISPLAY-ABEND  THRU 8900-EXIT             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7125-OPEN-CURSOR.                                                
           EXEC SQL                                                     
              OPEN ACCT_ATTRIBUTE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7125'                    TO WS-ACTIVE-PARAGRAPH     
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-RETURN-CODE-DISP     
              STRING 'LAST-RUN-DATE '                                   
                     WS-LAST-RUN-DT      DELIMITED BY SIZE              
                     ' SQLCODE = '                                      
                     WS-RETURN-CODE-DISP DELIMITED BY SIZE              
                     INTO WS-ERROR-MSG                                  
              PERFORM 8900-DISPLAY-ABEND     THRU 8900-EXIT             
           END-IF.                                                      
       7125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7135-FETCH-CURSOR.                                               
           EXEC SQL                                                     
              FETCH ACCT_ATTRIBUTE                                      
               INTO :YP-ACCOUNT-NO,                                     
                    :YP-ATTRIBUTE-DESC,                                 
                    :YP-ATTRIBUTE-VALUE-DT :WS-NULL-IND,                 
                    :YP-ATTRIBUTE-VALUE-TX :WS-NULL-IND1,                
                    :YP-STATUS-CD                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND < 0                                        
                 MOVE SPACES           TO YP-ATTRIBUTE-VALUE-DT         
              END-IF                                                    
              IF WS-NULL-IND1 < 0                                       
                 MOVE SPACES           TO YP-ATTRIBUTE-VALUE-TX-TEXT    
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE '7135'                 TO WS-ACTIVE-PARAGRAPH     
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-RETURN-CODE-DISP     
                 STRING 'LAST-RUN-DATE '       DELIMITED BY SIZE        
                        WS-LAST-RUN-DT         DELIMITED BY SIZE        
                        ' SQLCODE = '          DELIMITED BY SIZE        
                        WS-RETURN-CODE-DISP    DELIMITED BY SIZE        
                        INTO WS-ERROR-MSG                               
                 PERFORM 8900-DISPLAY-ABEND  THRU 8900-EXIT             
              END-IF                                                    
           END-IF.                                                      
       7135-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7145-CLOSE-CURSOR.                                               
           EXEC SQL                                                     
              CLOSE ACCT_ATTRIBUTE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7145'                    TO WS-ACTIVE-PARAGRAPH     
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-RETURN-CODE-DISP     
              STRING 'LAST-RUN-DATE ' DELIMITED BY SIZE                 
                     WS-LAST-RUN-DT   DELIMITED BY SIZE                 
                     ' SQLCODE = '    DELIMITED BY SIZE                 
                     WS-RETURN-CODE-DISP DELIMITED BY SIZE              
                     INTO WS-ERROR-MSG                                  
              PERFORM 8900-DISPLAY-ABEND     THRU 8900-EXIT             
           END-IF.                                                      
       7145-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7250-ACCTS-FROM-CUR.                                             
           PERFORM 7135-FETCH-CURSOR         THRU 7135-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE YP-ACCOUNT-NO             TO WS-ACCOUNT-NO           
              MOVE YP-STATUS-CD              TO WS-STATUS-CD            
              MOVE 'NOT FOUND IN BILLMATRIX FILE' TO RP115-COMMENTS     
              PERFORM 8200-WRITE-OUTFILE     THRU 8200-EXIT             
              PERFORM 8350-UPDATE-ACCT-ATTR  THRU 8350-EXIT             
           END-IF.                                                      
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7450-GET-LAST-RUN-DT.                                            
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                    
                 AND COMPANY_NO   = :G6-COMPANY-NO                      
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                            
MFA-TR*          AND COMPANY_NO   = :G6-COMPANY-NO                              
MFA-TR*          AND CMND_CODE    = 'PARM'                                      
MFA-TR*          AND SEQ_NO       = 10                                          
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA              TO WS-LAST-RUN-DATA        
              DISPLAY ' LAST RUN DATE = ' WS-LAST-RUN-DT                
           ELSE                                                         
              MOVE '7450'                    TO WS-ACTIVE-PARAGRAPH     
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-RETURN-CODE-DISP     
              STRING 'PROGRAM '            DELIMITED BY SIZE            
                     WS-PROGRAM-NAME       DELIMITED BY SIZE            
                     ', COMPANY = '        DELIMITED BY SIZE            
                     G6-COMPANY-NO         DELIMITED BY SIZE            
                     ', SQLCODE = '        DELIMITED BY SIZE            
                     WS-RETURN-CODE-DISP   DELIMITED BY SIZE            
                     INTO WS-ERROR-MSG                                  
              PERFORM 8900-DISPLAY-ABEND     THRU 8900-EXIT             
           END-IF.                                                      
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7650-GET-CURR-DATE.                                                      
      *GET CURRENT DATE                                                         
      ****************************************************************          
       7650-GET-CURR-DATE.                                              
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE '7650'                   TO WS-ACTIVE-PARAGRAPH     
               MOVE WS-ACTIVE-RETURN-CODE    TO WS-RETURN-CODE-DISP     
               STRING ' SQLCODE = '         DELIMITED BY SIZE           
                      WS-RETURN-CODE-DISP   DELIMITED BY SIZE           
                      INTO WS-ERROR-MSG                                 
               PERFORM 8900-DISPLAY-ABEND    THRU 8900-EXIT             
           END-IF.                                                      
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8200-WRITE-OUTFILE.                                              
           ADD 1                             TO WS-EXCPTN-COUNT.        
           MOVE YP-ACCOUNT-NO                TO RP115-ACCOUNT-NO.       
           MOVE YP-STATUS-CD                 TO RP115-AUTOC-STATUS.     
           IF YP-ATTRIBUTE-VALUE-DT = SPACES                            
              MOVE '1900-01-01'              TO RP115-STATUS-DATE       
           ELSE                                                         
              MOVE YP-ATTRIBUTE-VALUE-DT     TO RP115-STATUS-DATE       
           END-IF.                                                      
           WRITE RP115-OUT-REC               FROM WS-OUTFILE-DET-REC.   
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8300-WRITE-BLANK-REC.                                            
           MOVE '0000000000000'              TO RP115-ACCOUNT-NO.       
           MOVE '1900-01-01'                 TO RP115-STATUS-DATE.      
           MOVE SPACES                       TO RP115-AUTOC-STATUS,     
                                                RP115-COMMENTS.         
           WRITE RP115-OUT-REC               FROM WS-OUTFILE-DET-REC.   
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8350-UPDATE-ACCT-ATTR.                                           
           IF YP-ATTRIBUTE-VALUE-TX-TEXT > SPACES                       
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES          TO YP-ATTRIBUTE-VALUE-TX-TEXT        
           END-IF.                                                      
                                                                        
           MOVE 'R'                TO YP-ATTRIBUTE-VALUE-TX-TEXT(81:1). 
           MOVE +81                TO YP-ATTRIBUTE-VALUE-TX-LEN.        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCT_ATTRIBUTE                                 
                 SET ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX        
               WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                    
                 AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8350'                    TO WS-ACTIVE-PARAGRAPH     
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-RETURN-CODE-DISP     
              STRING 'ACCOUNT NO = '       DELIMITED BY SIZE            
                     WS-ACCOUNT-NO         DELIMITED BY SIZE            
                     ', SQLCODE = '        DELIMITED BY SIZE            
                     WS-RETURN-CODE-DISP   DELIMITED BY SIZE            
                     INTO WS-ERROR-MSG                                  
              PERFORM 8900-DISPLAY-ABEND     THRU 8900-EXIT             
           END-IF.                                                      
       8350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8400-UPDATE-LAST-RUN-DT.                                         
           MOVE WS-CURRENT-DATE              TO WS-LAST-RUN-DT.         
           MOVE WS-LAST-RUN-DATA             TO G6-PARM-DATA.           
           MOVE WS-SYSIN-COMPANY-NO          TO G6-COMPANY-NO.          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
                 SET PARM_DATA    = :G6-PARM-DATA                       
               WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                    
                 AND COMPANY_NO   = :G6-COMPANY-NO                      
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8400'                    TO WS-ACTIVE-PARAGRAPH     
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-RETURN-CODE-DISP     
              STRING 'COMPANY = '          DELIMITED BY SIZE            
                     G6-COMPANY-NO         DELIMITED BY SIZE            
                     WS-LAST-RUN-DATA      DELIMITED BY SIZE            
                     ', SQLCODE = '        DELIMITED BY SIZE            
                     WS-RETURN-CODE-DISP   DELIMITED BY SIZE            
                     INTO WS-ERROR-MSG                                  
              PERFORM 8900-DISPLAY-ABEND     THRU 8900-EXIT             
           END-IF.                                                      
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *8450-UPDATE-OVERRIDE-DT                                                  
      *UPDATE OVERRIDE RUN DATE TO INACTIVE.                                    
      *****************************************************************         
       8450-UPDATE-OVERRIDE-DT.                                         
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
                 SET STATUS = 'I'                                       
               WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                    
                 AND COMPANY_NO   = :G6-COMPANY-NO                      
                 AND CMND_CODE    = 'DATE'                              
                 AND SEQ_NO       = 20                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8450'                    TO WS-ACTIVE-PARAGRAPH     
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-RETURN-CODE-DISP     
              STRING 'COMPANY = '          DELIMITED BY SIZE            
                     G6-COMPANY-NO         DELIMITED BY SIZE            
                     ', SQLCODE = '        DELIMITED BY SIZE            
                     WS-RETURN-CODE-DISP   DELIMITED BY SIZE            
                     INTO WS-ERROR-MSG                                  
              PERFORM 8900-DISPLAY-ABEND     THRU 8900-EXIT             
           END-IF.                                                      
       8450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *8900-DISPLAY-ABEND.                                                      
      *DISPLAY ERROR AND CALL ABEND- PARA.                                      
      *****************************************************************         
       8900-DISPLAY-ABEND.                                              
           DISPLAY ' '.                                                 
           DISPLAY '****** ERROR IN PROCESSING PCSAC115 ******'.        
           DISPLAY '****** ABEND PARAGRAPH - ' WS-ACTIVE-PARAGRAPH.     
           DISPLAY '** ' WS-ERROR-MSG.                                  
           DISPLAY '********   PROCESSING TERMINATED   *********'       
           PERFORM 9900-ABEND                THRU 9900-EXIT.            
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
           CLOSE AC115BMX-FILE.                                         
           CLOSE RP115OUT-FILE.                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *9900-ABEND.                                                              
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
