       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSAC114.                                          
       AUTHOR.       PRASAD ALLADA.                                     
       DATE-WRITTEN. SEP 2009.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **   THIS PROGRAM CREATES EXTRACT FILES TO GENERATE THE         **        
      **   DAILY BILLMATRIX PAYMENT FILE FROM THE NEW TABLE           **        
      **   CSS_PENDING_AUTO_CARD.                                     **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     NOT USED                              **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     NOT USED                              **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **                PROGRAM  MODIFICATION  LOG                    **        
      ******************************************************************        
      ** DATE     USER ID  REASON                                     **        
      ** -------  -------  ------                                     **        
      ** 09/2009  PA94870  INITIAL IMPLEMENTATION FOR PROJCSR526      **        
ACT081** 04/2015  DB41297  CHANGE TO ONLY PICK PRIMARY EMAIL.         **        
      ** A05136                                                       **        
A05348** 07/23/15 AA97148  INCREASED EMAIL-ADDR FIELD LENGTH TO AVOID **00540000
      **                   EMAIL ADDRESS TRUNCATION.                  **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSAP01.                                                            
       COPY CSSAP02.                                                            
       COPY CSSAR01.                                                            
       COPY CSSAR02.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD FCSCGBPF-FILE                                                 
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD                                   
           DATA RECORD IS FCSCGBPF-REC.                                 
       01 FCSCGBPF-REC                       PIC X(80).                 
      *                                                                         
       FD FCPSNBPF-FILE                                                 
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD                                   
           DATA RECORD IS FCPSNBPF-REC.                                 
       01 FCPSNBPF-REC                       PIC X(80).                 
      *                                                                         
       FD FCSCGBPR-FILE                                                 
            RECORD CONTAINS 80  CHARACTERS                              
                  RECORDING MODE IS F.                                  
       01 FCSCGBPR-REC.                                                 
          02 SCNG-RESTART-DATA-REC  PIC X(80).                          
          02 SCNG-RESTART-HEADER-REC REDEFINES SCNG-RESTART-DATA-REC.   
           05  SCNG-RESTART-HDR-RECORD-ID       PIC X(02).              
           05  SCNG-RESTART-RUN-DATE-REC.                               
               10  SCNG-RESTART-YEAR-CC         PIC X(02).              
               10  SCNG-RESTART-YEAR-YY         PIC X(02).              
               10  SCNG-RESTART-MONTH-DET       PIC X(02).              
               10  SCNG-RESTART-DAY-DET         PIC X(02).              
           05  FILLER              PIC X(68) VALUE SPACES.              
          02 SCNG-RESTART-DETAIL-REC REDEFINES SCNG-RESTART-DATA-REC.   
           05  SCNG-RESTART-DET-RECORD-ID        PIC X(02).             
           05  SCNG-RESTART-ACCOUNT-NO           PIC X(13).             
           05  SCNG-RESTART-PYMNT-AMT PIC 9(07).9(2).                   
A05348     05  SCNG-RESTART-EMAIL-ADDR           PIC X(55).             
          02 SCNG-RESTART-TRAILR-REC REDEFINES SCNG-RESTART-DATA-REC.   
           05  SCNG-RESTART-TRL-RECORD-ID        PIC X(02).             
           05  SCNG-RESTART-TOTAL-RECORDS        PIC X(8).              
           05  SCNG-RESTART-TOTAL-AMT PIC 9(10).9(2).                   
           05  FILLER               PIC X(50) VALUE SPACES.             
      *                                                                         
       FD FCPSNBPR-FILE                                                 
            RECORD CONTAINS 80  CHARACTERS                              
                  RECORDING MODE IS F.                                  
       01 FCPSNBPR-REC.                                                 
          02 PSN-RESTART-DATA-REC  PIC X(80).                           
          02 PSN-RESTART-HEADER-REC REDEFINES PSN-RESTART-DATA-REC.     
           05  PSN-RESTART-HDR-RECORD-ID       PIC X(02).               
           05  PSN-RESTART-RUN-DATE-REC.                                
               10  PSN-RESTART-YEAR-CC         PIC X(02).               
               10  PSN-RESTART-YEAR-YY         PIC X(02).               
               10  PSN-RESTART-MONTH-DET       PIC X(02).               
               10  PSN-RESTART-DAY-DET         PIC X(02).               
           05  FILLER              PIC X(68) VALUE SPACES.              
          02 PSN-RESTART-DETAIL-REC REDEFINES PSN-RESTART-DATA-REC.     
           05  PSN-RESTART-DET-RECORD-ID        PIC X(02).              
           05  PSN-RESTART-ACCOUNT-NO           PIC X(13).              
           05  PSN-RESTART-PYMNT-AMT PIC 9(07).9(2).                    
A05348     05  PSN-RESTART-EMAIL-ADDR           PIC X(55).              
          02 PSN-RESTART-TRAILR-REC REDEFINES PSN-RESTART-DATA-REC.     
           05  PSN-RESTART-TRL-RECORD-ID        PIC X(02).              
           05  PSN-RESTART-TOTAL-RECORDS        PIC X(8).               
           05  PSN-RESTART-TOTAL-AMT PIC 9(10).9(2).                    
           05  FILLER               PIC X(50) VALUE SPACES.             
      *                                                                         
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC114'.
MSQ017     COPY MFASQLM.
      ******************************************************************        
      *                                                                *        
      *             'WORKING STORAGE FOR PCSAC114 STARTS HERE'.        *        
      ******************************************************************        
                                                                        
       COPY CSPNDCRD.                                                           
                                                                        
       01  WS-START                        PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSAC114 STARTS HERE'.            
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-FCSCG-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FCSCG-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
           05  WS-FCPSN-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FCPSN-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
           05  WS-FCSCR-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FCSCR-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
           05  WS-FCPSR-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FCPSR-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
                                                                        
       01  WS-VARIABLES.                                                
           05  WS-NULL-IND-01              PIC S9(4)  COMP VALUE 0.     
           05  WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE ZERO.      
           05  WS-TOTAL-AMT-CSRSEB PIC S9(10)V9(2) USAGE COMP-3 VALUE 0.
           05  WS-TOTAL-AMT-PSNC   PIC S9(10)V9(2) USAGE COMP-3 VALUE 0.
           05  WS-TOTAL-RECS-CSRSEB        PIC 9(8)   VALUE ZEROS.      
           05  WS-TOTAL-RECS-PSNC          PIC 9(8)   VALUE ZEROS.      
           05  WS-WORK-DATE                PIC X(10).                   
           05  WS-WORK-DATE-DEF REDEFINES WS-WORK-DATE.                 
               10 WS-WORK-DATECCYY         PIC X(04).                   
               10 WS-WORK-DATEHYPH1        PIC X(01).                   
               10 WS-WORK-DATEMM           PIC X(02).                   
               10 WS-WORK-DATEHYPH2        PIC X(01).                   
               10 WS-WORK-DATEDD           PIC X(02).                   
           05  WS-PAYMENT-DATE             PIC X(10) VALUE SPACES.      
COB305     05 WS-PAYMENT-AMT        PIC S9(9)V9(2) USAGE COMP-3 VALUE 0. 
           05  WS-COMMON-DATE.                                          
               10 WS-COMMON-DATECCYY         PIC X(04).                 
               10 WS-COMMON-DATEMM           PIC X(02).                 
               10 WS-COMMON-DATEDD           PIC X(02).                 
           05  WS-PGMNAME                  PIC X(08)  VALUE 'PCSAC114'. 
           05  WS-DAY          PIC S9(4) COMP VALUE 9.                  
           05  WS-ROW-COUNT    PIC S9(9) COMP VALUE ZERO.               
           05  WS-DISPLAY-SQLCODE    PIC -(8)9.                         
           05  WS-ERR-MSG      PIC X(100).                              
           05  WS-N                         PIC X(01)  VALUE 'N'.       
           05  WS-Y                         PIC X(01)  VALUE 'Y'.       
           05  WS-EMAIL-ADDR.                                           
              49 WS-EMAIL-ADDRESS-TX-LEN  PIC S9(4) USAGE COMP.         
              49 WS-EMAIL-ADDRESS-TX-TEXT  PIC X(100).                  
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
                                                                        
       01  WS-CONSTANTS.                                                
           05  WS-PGRMNAME                 PIC X(8)   VALUE 'PCSAC114'. 
           05  PROGRAM-NAME                PIC X(8)   VALUE 'PCSAC114'. 
                                                                        
       01  WS-RESTART-MISC.                                             
           05  WS-CHKP-LUW-LIMIT           PIC 9(05)  VALUE 0.          
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(05)  VALUE 10.         
           05  WS-LUW-PROCESSED-CSRSEB     PIC S9(07) VALUE ZERO COMP-3.
           05  WS-LUW-PROCESSED-PSNC       PIC S9(07) VALUE ZERO COMP-3.
           05  WS-RECORDS-PROCESSED-CSRSEB PIC S9(07) VALUE ZERO COMP-3.
           05  WS-RECORDS-PROCESSED-PSNC   PIC S9(07) VALUE ZERO COMP-3.
           05  WS-FCSCGBPR-READ-COUNT      PIC 9(07)  VALUE 0.          
           05  WS-FCPSNBPR-READ-COUNT      PIC 9(07)  VALUE 0.          
           05  WS-R-TOT-AMT-CSRSEB PIC S9(10)V9(2) USAGE COMP-3 VALUE 0.
           05  WS-R-TOT-AMT-PSNC   PIC S9(10)V9(2) USAGE COMP-3 VALUE 0.
           05  WS-COMMIT-NUMBER-CSRSEB     PIC S9(04) VALUE +0 COMP.    
           05  WS-COMMIT-NUMBER-PSNC       PIC S9(04) VALUE +0 COMP.    
           05  WS-ACCOUNT-NUMBER           PIC  9(13) VALUE 0  COMP.    
           05  WS-IS-THIS-A-RESTART        PIC X(01)  VALUE 'N'.        
               88  WS-THIS-IS-A-RESTART               VALUE 'Y'.        
               88  WS-NOT-A-RESTART                   VALUE 'N'.        
           05  WS-RESTART-RECORD           PIC X(01)  VALUE 'N'.        
               88  WS-RESTART-REC-FOUND               VALUE 'Y'.        
               88  WS-RESTART-REC-NOT-FOUND           VALUE 'N'.        
           05  WS-FCSCGBPR-DATA-SW      PIC X(01) VALUE 'Y'.            
               88 END-OF-FCSCGBPR                 VALUE 'N'.            
           05  WS-FCPSNBPR-DATA-SW      PIC X(01) VALUE 'Y'.            
               88 END-OF-FCPSNBPR                 VALUE 'N'.            
           05  WS-FCSCGBPR-ACC-FOUND    PIC X(01) VALUE 'N'.            
               88 FCSCGBPR-EMPTY                  VALUE 'E'.            
               88 FCSCGBPR-ACC-FOUND              VALUE 'Y'.            
           05  WS-FCPSNBPR-ACC-FOUND    PIC X(01) VALUE 'N'.            
               88 FCPSNBPR-EMPTY                  VALUE 'E'.            
               88 FCPSNBPR-ACC-FOUND              VALUE 'Y'.            
                                                                        
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-KEY.                                          
               10  WS-RESTART-EVENT-DATE   PIC X(08).                   
               10  WS-RESTART-CSRSEB       PIC X(06) VALUE 'CSRSEB'.    
               10  WS-RESTART-ACCOUNT-CSRSEB      PIC X(13).            
               10  WS-RESTART-REC-CSRSEB          PIC 9(08).            
COB305         10 WS-AMT-CSRSEB        PIC S9(10)V9(2) USAGE COMP-3 
COB305           VALUE 0.          
               10  WS-RESTART-PSNC         PIC X(06) VALUE '  PSNC'.    
               10  WS-RESTART-ACCOUNT-PSNC        PIC X(13).            
               10  WS-RESTART-REC-PSNC            PIC 9(08).            
COB305         10 WS-AMT-PSNC        PIC S9(10)V9(2) USAGE COMP-3 
COB305           VALUE 0.          
                                                                        
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-END-ACCOUNT-CUR-SW       PIC X(1) VALUE 'N'.          
               88  WS-END-ACCOUNT-CUR      VALUE 'Y'.                   
               88  WS-NOT-END-ACCOUNT-CUR  VALUE 'N'.                   
           05  WS-FETCH-SUCCESS-SW         PIC X(1) VALUE 'N'.          
               88  WS-FETCH-SUCCESS        VALUE 'Y'.                   
               88  WS-FETCH-NOT-SUCCESS    VALUE 'N'.                   
           05 WS-BAD-WORKING-DAY         PIC X(1).                      
               88  BAD-WORKING-DAY          VALUE 'N'.                  
               88  GOOD-WORKING-DAY         VALUE 'Y'.                  
           05  WS-DISPLAY-KEY.                                          
               10  WS-DISPLAY-ACCOUNT      PIC 9(13).                   
               10  WS-DISPLAY-DATE         PIC X(10).                   
               10  WS-COMPANY-CD           PIC X(10).                   
                                                                        
       01  WS-COMMIT-DATA.                                              
           05  WS-COMMIT-TEXT              PIC X(09).                   
           05  WS-COMMIT-NUM               PIC 9(05).                   
           05  FILLER                      PIC X(66).                   
                                                                        
      ******************************************************************        
      **                                                              **        
      ** WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS             **        
      **                                                              **        
      ******************************************************************        
      /*****   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
      /*****   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      /*****   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
      /*****   WS AREA NEEDED FOR CPD00037                                      
       COPY FIOJC01.                                                            
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSAC114 START HERE '.               
      ******************************************************************        
      **                                                              **        
      **  TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS     **        
      **  (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM     **        
      **  WILL ALWAYS BE SQLCA.                                       **        
      **                                                              **        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      /                                                                         
      / CSS_JOB_PARM DCLGEN                                                     
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCOUNT DCLGEN                                                      
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      /                                                                         
      / CSS_PNDNG_CARD_PMT                                                      
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBPNDCRD                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_CUST_EMAIL (PREFIX = NE)                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTEML                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_RESTART (RF)                                                        
      /                                                                         
           EXEC SQL                                                             
              INCLUDE TBRESTRT                                                  
           END-EXEC.                                                            
      /                                                                         
      ******************************************************************        
      **                                                              **        
      **  CURSOR DECLARATIONS (IF ANY) GO LAST                        **        
      **                                                              **        
      ******************************************************************        
      **CURSOR TO EXTRACT THE ACCOUNT CODE ACCOUNTS                             
           EXEC SQL                                                     
              DECLARE ACCOUNT_CUR CURSOR WITH HOLD FOR                  
               SELECT  PC.ACCOUNT_NO                                    
                      ,PC.PAYMENT_DATE                                  
                      ,PC.PAYMENT_AMT                                   
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), PC.CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                      ,AT.COMPANY_NO                                    
                      ,NE.EMAIL_ADDRESS_TX                              
                 FROM CSS_PNDNG_CARD_PMT PC WITH(READUNCOMMITTED)               
                 INNER JOIN CSS_ACCOUNT AT WITH(READUNCOMMITTED)                
                 ON   PC.ACCOUNT_NO = AT.ACCOUNT_NO                     
                 AND  PC.STATUS_CODE = 'A'                              
                 AND  PC.PAYMENT_AMT > 0                                
                                                                        
                 LEFT OUTER JOIN CSS_CUST_EMAIL NE WITH(READUNCOMMITTED)        
                 ON AT.CUSTOMER_NO = NE.CUSTOMER_NO                     
ACT081           AND NE.EMAIL_TYPE_CD = 'P1'                            
                                                                        
                 WHERE PC.PAYMENT_DATE <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) )                 
                 ORDER BY PC.PAYMENT_DATE                               
                                                                        
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCOUNT_CUR CURSOR WITH HOLD FOR                          
MFA-TR*        SELECT  PC.ACCOUNT_NO                                            
MFA-TR*               ,PC.PAYMENT_DATE                                          
MFA-TR*               ,PC.PAYMENT_AMT                                           
MFA-TR*               ,PC.CREATED_TS                                            
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*               ,NE.EMAIL_ADDRESS_TX                                      
MFA-TR*          FROM CSS_PNDNG_CARD_PMT PC                                     
MFA-TR*          INNER JOIN CSS_ACCOUNT AT                                      
MFA-TR*          ON   PC.ACCOUNT_NO = AT.ACCOUNT_NO                             
MFA-TR*          AND  PC.STATUS_CODE = 'A'                                      
MFA-TR*          AND  PC.PAYMENT_AMT > 0                                        
MFA-TR*                                                                         
MFA-TR*          LEFT OUTER JOIN CSS_CUST_EMAIL NE                              
MFA-TR*          ON AT.CUSTOMER_NO = NE.CUSTOMER_NO                             
MFA-TR*          AND NE.EMAIL_TYPE_CD = 'P1'                                    
MFA-TR*                                                                         
MFA-TR*          WHERE PC.PAYMENT_DATE <= :WS-WORK-DATE                         
MFA-TR*          ORDER BY PC.PAYMENT_DATE                                       
MFA-TR*                                                                         
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            
      /                                                                         
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PROCESSING OF PROGRAM                   **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION  THRU 0100-EXIT.                 
           PERFORM 1000-PROCESS-ACCOUNT THRU 1000-EXIT                  
             UNTIL WS-END-ACCOUNT-CUR.                                  
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-PGRMNAME             TO RF-NAME-PROGRAM           
              MOVE 1                       TO RF-DUP-CNTRL-NO           
              MOVE 1                       TO RF-PARTITION-NO           
              PERFORM 8930-DELETE-RESTART-RECORD THRU 8930-EXIT         
           END-IF.                                                      
           PERFORM 9000-TERMINATE       THRU 9000-EXIT.                 
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      COMMON INITIALIZATION ROUTINE                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSAC114 PROCESSING              **'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '******************************************'.        
                                                                        
      ** GET THE COMMIT JOB PARM                                                
           PERFORM 0110-COMMIT-JOB-PARM THRU 0110-EXIT.                 
                                                                        
      ** CHECK IF THIS IS A RESTART                                             
           SET  WS-NOT-A-RESTART           TO TRUE                      
           MOVE WS-PGRMNAME                TO RF-NAME-PROGRAM           
           MOVE 1                          TO RF-DUP-CNTRL-NO           
                                              RF-PARTITION-NO           
      ** GET THE COMMON JOB PARM FOR DATE                                       
           PERFORM 0200-SELECT-COMMON-PARM THRU 0200-EXIT.              
                                                                        
           PERFORM 8910-CHECK-FOR-RESTART  THRU 8910-EXIT               
                                                                        
           PERFORM 0150-OPEN-FILES                                      
              THRU 0150-EXIT.                                           
                                                                        
           SET WS-NOT-END-ACCOUNT-CUR  TO TRUE.                         
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 3000-PROCESS-RESTART-FILE THRU 3000-EXIT
           END-IF.         
                                                                        
                                                                        
           PERFORM 7000-OPEN-ACCOUNT   THRU 7000-EXIT.                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** SELECTS THE COMMIT NO                                        **        
      ******************************************************************        
       0110-COMMIT-JOB-PARM.                                            
                                                                        
           PERFORM 7680-GET-COMMIT-PARM THRU  7680-EXIT                 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA(1:14) TO WS-COMMIT-DATA                 
           END-IF                                                       
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE             
           EVALUATE TRUE                                                
              WHEN WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSAC114 PROCESSING INFO   **'            
                 DISPLAY '**    COMMIT PARM NOT PRESENT'                
                 DISPLAY '**  DEFAULT CHKP LUW 50 IS USED'              
                 MOVE WS-DEFAULT-CHKP-LUW-LIMIT TO WS-CHKP-LUW-LIMIT    
              WHEN WS-COMMIT-NUM NOT NUMERIC                            
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSAC114 INFO              **'            
                 DISPLAY '**      RETURN CODE = ' WS-DISPLAY-SQLCODE    
                 DISPLAY '**    COMMIT PARM NOT NUMERIC'                
                 DISPLAY '**    KEY = ' WS-COMMIT-DATA                  
                 DISPLAY '**  PROCESSING TERMINATED  **'                
                 PERFORM 9900-ABEND      THRU 9900-EXIT                 
              WHEN WS-COMMIT-NUM  NUMERIC                               
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSAC114 PROCESSING INFO  **'             
                 MOVE WS-COMMIT-NUM  TO  WS-CHKP-LUW-LIMIT              
                 DISPLAY '**    CHKP LUW IS ' WS-CHKP-LUW-LIMIT         
           END-EVALUATE                                                 
           .                                                            
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0150-OPEN-FILES                                             **        
      **                                                              **        
      ******************************************************************        
       0150-OPEN-FILES.                                                 
                                                                        
           MOVE '0150'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
             OPEN INPUT FCSCGBPR-FILE                                   
             IF WS-FCSCR-SUCCESSFUL                                     
                 CONTINUE                                               
              ELSE                                                      
              STRING  '** FILE OPEN ERROR FCSCGBPR **' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FCSCR-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
             END-IF                                                     
                                                                        
             OPEN INPUT FCPSNBPR-FILE                                   
             IF WS-FCPSR-SUCCESSFUL                                     
                 CONTINUE                                               
              ELSE                                                      
              STRING  '** FILE OPEN ERROR FCPSNBPR **' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FCPSR-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
             END-IF                                                     
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSCGBPF-FILE                                    
           IF WS-FCSCG-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              STRING  '** FILE OPEN ERROR FCSCGBPF **' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FCSCG-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCPSNBPF-FILE.                                   
           IF WS-FCPSN-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              STRING  '** FILE OPEN ERROR FCPSNBPF **' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FCPSN-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
       0150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      **  3000-PROCESS-RESTART-FILE.                                **          
      **      WHEN CURRENT RUN IS A RESTART - CHECKS THE INPUT FILE **          
      **      FOR THE ACCURACY AND COPIES THE RECORDS TO OUTPUTFILE **          
      ****************************************************************          
      *                                                                         
       3000-PROCESS-RESTART-FILE.                                       
                                                                        
           PERFORM 7170-READ-FCSCGBPR         THRU 7170-EXIT.           
           DISPLAY 'FIRST RECORD ' FCSCGBPR-REC                         
           IF END-OF-FCSCGBPR                                           
              SET FCSCGBPR-EMPTY TO TRUE                                
              DISPLAY ' '                                               
              DISPLAY '**  PCSAC114 PROCESSING        **'               
              DISPLAY '**  FCSCGBPF FILE FROM PREV    **'               
              DISPLAY '**  RUN IS EMPTY.              **'               
           END-IF.                                                      
                                                                        
           IF WS-RESTART-ACCOUNT-CSRSEB > 0                             
              PERFORM 3100-PROCESS-CSRSEB-FILE
           END-IF.                         
                                                                        
           PERFORM 7180-READ-FCPSNBPR THRU 7180-EXIT.                   
           IF (END-OF-FCPSNBPR AND (NOT FCSCGBPR-ACC-FOUND))            
              SET FCPSNBPR-EMPTY TO TRUE                                
              DISPLAY ' '                                               
              DISPLAY '**  PCSAC114 PROCESSING        **'               
              DISPLAY '**  FCPSNBPF FILE FROM PREV    **'               
              DISPLAY '**  RUN IS EMPTY AND RESTART   **'               
              DISPLAY '**  ACC NOT FOUND IN FCSCGBPF  **'               
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-RESTART-ACCOUNT-PSNC   > 0                             
              PERFORM 3200-PROCESS-PSNC-FILE
           END-IF.                           
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-PROCESS-CSRSEB-FILE.                                        
           IF SCNG-RESTART-HDR-RECORD-ID EQUAL '01'                     
              AND SCNG-RESTART-RUN-DATE-REC EQUAL WS-COMMON-DATE        
              MOVE SCNG-RESTART-HEADER-REC TO FCSCGBPF-REC              
              PERFORM 8200-WRITE-SCG-RECORD THRU 8200-EXIT              
           ELSE                                                         
             DISPLAY 'COMMON DATE DOES NOT MATCH RESTART DATE'          
             DISPLAY 'COMMON  DATE = ' WS-WORK-DATE                     
             DISPLAY 'RESTART DATE = ' SCNG-RESTART-RUN-DATE-REC        
             PERFORM 9900-ABEND                THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM WITH TEST AFTER UNTIL                                
            (SCNG-RESTART-ACCOUNT-NO EQUAL WS-RESTART-ACCOUNT-CSRSEB    
               AND WS-FCSCGBPR-READ-COUNT = WS-RESTART-REC-CSRSEB)      
               OR  END-OF-FCSCGBPR                                      
                                                                        
             PERFORM 7170-READ-FCSCGBPR         THRU 7170-EXIT          
             IF SCNG-RESTART-DET-RECORD-ID = '02'                       
               ADD +1             TO WS-FCSCGBPR-READ-COUNT             
               MOVE SCNG-RESTART-DETAIL-REC TO FCSCGBPF-REC             
               PERFORM 8200-WRITE-SCG-RECORD THRU 8200-EXIT             
               MOVE SCNG-RESTART-PYMNT-AMT TO WS-PAYMENT-AMT            
               ADD WS-PAYMENT-AMT         TO WS-R-TOT-AMT-CSRSEB        
             END-IF                                                     
             IF SCNG-RESTART-TRL-RECORD-ID = '03'                       
               MOVE SCNG-RESTART-TRAILR-REC TO FCSCGBPF-REC             
               PERFORM 8200-WRITE-SCG-RECORD THRU 8200-EXIT             
             END-IF                                                     
            IF (SCNG-RESTART-ACCOUNT-NO EQUAL WS-RESTART-ACCOUNT-CSRSEB)
               SET FCSCGBPR-ACC-FOUND TO TRUE                           
            END-IF                                                      
           END-PERFORM.                                                 
                                                                        
            ADD WS-FCSCGBPR-READ-COUNT TO WS-TOTAL-RECS-CSRSEB          
            ADD WS-R-TOT-AMT-CSRSEB TO WS-TOTAL-AMT-CSRSEB              
                                                                        
           CLOSE FCSCGBPR-FILE.                                         
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       3200-PROCESS-PSNC-FILE.                                          
                                                                        
           IF NOT END-OF-FCPSNBPR                                       
            IF    PSN-RESTART-HDR-RECORD-ID EQUAL '01'                  
              AND PSN-RESTART-RUN-DATE-REC EQUAL WS-COMMON-DATE         
              MOVE PSN-RESTART-HEADER-REC TO FCPSNBPF-REC               
              PERFORM 8210-WRITE-PSN-RECORD THRU 8210-EXIT              
            ELSE                                                        
             DISPLAY 'COMMON DATE DOES NOT MATCH RESTART DATE'          
             DISPLAY 'COMMON  DATE = ' WS-WORK-DATE                     
             DISPLAY 'RESTART DATE = '  PSN-RESTART-RUN-DATE-REC        
             PERFORM 9900-ABEND                THRU 9900-EXIT           
            END-IF                                                      
           END-IF.                                                      
                                                                        
           PERFORM WITH TEST AFTER UNTIL                                
            ( PSN-RESTART-ACCOUNT-NO EQUAL WS-RESTART-ACCOUNT-PSNC      
               AND WS-FCPSNBPR-READ-COUNT = WS-RESTART-REC-PSNC)        
               OR  END-OF-FCPSNBPR                                      
                                                                        
             PERFORM 7180-READ-FCPSNBPR THRU 7180-EXIT                  
             IF  PSN-RESTART-DET-RECORD-ID = '02'                       
               ADD +1             TO WS-FCPSNBPR-READ-COUNT             
               MOVE  PSN-RESTART-DETAIL-REC TO FCPSNBPF-REC             
               PERFORM 8210-WRITE-PSN-RECORD THRU 8210-EXIT             
               MOVE  PSN-RESTART-PYMNT-AMT TO WS-PAYMENT-AMT            
               ADD WS-PAYMENT-AMT         TO WS-R-TOT-AMT-PSNC          
             END-IF                                                     
             IF  PSN-RESTART-TRL-RECORD-ID = '03'                       
               MOVE  PSN-RESTART-TRAILR-REC TO FCPSNBPF-REC             
               PERFORM 8210-WRITE-PSN-RECORD THRU 8210-EXIT             
             END-IF                                                     
                                                                        
            IF ( PSN-RESTART-ACCOUNT-NO EQUAL WS-RESTART-ACCOUNT-PSNC)  
               SET FCPSNBPR-ACC-FOUND TO TRUE                           
            END-IF                                                      
                                                                        
           END-PERFORM.                                                 
                                                                        
           ADD WS-FCPSNBPR-READ-COUNT TO WS-TOTAL-RECS-PSNC             
           ADD WS-R-TOT-AMT-PSNC   TO WS-TOTAL-AMT-PSNC                 
                                                                        
           CLOSE FCPSNBPR-FILE.                                         
                                                                        
           IF (NOT FCSCGBPR-ACC-FOUND)                                  
                 AND                                                    
                (NOT FCPSNBPR-ACC-FOUND)                                
              DISPLAY ' '                                               
              DISPLAY '**  PCSAC114 PROCESSING        **'               
              DISPLAY '**  RESTART ACOCUNT NOT FOUND  **'               
              DISPLAY '**  IN EITHER SCEG FILE OR PSNC**'               
              DISPLAY '**  FILE. RESTART FILES INVALID**'               
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  0200-SELECT-COMMON-PARM                                   **          
      **      GETS THE COMMON DATE                                  **          
      ****************************************************************          
      *                                                                         
       0200-SELECT-COMMON-PARM.                                         
      *                                                                         
           MOVE '0200' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
      * GET COMMON DATE                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '                  TO WS-PGRMNAME           
              MOVE SPACES                      TO WS-INPUT-AREA         
              MOVE SPACES                      TO                       
                                           WS-INPUT-DATA-BREAKDOWN      
              PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT           
              MOVE WS-PGMNAME                  TO WS-PGRMNAME           
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE      TO WS-WORK-DATE.                     
           MOVE WS-WORK-DATECCYY   TO WS-COMMON-DATECCYY.               
           MOVE WS-WORK-DATEMM     TO WS-COMMON-DATEMM.                 
           MOVE WS-WORK-DATEDD     TO WS-COMMON-DATEDD.                 
           MOVE WS-COMMON-DATE     TO WS-RESTART-EVENT-DATE.            
                                                                        
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1000-PROCESS-ACCOUNT                                      **          
      ****************************************************************          
       1000-PROCESS-ACCOUNT.                                            
      *                                                                         
           PERFORM 7010-FETCH-ACCOUNT           THRU 7010-EXIT.         
           PERFORM 7500-PROCESS-ACCOUNT         THRU 7500-EXIT.         
           IF WS-END-ACCOUNT-CUR AND WS-FETCH-SUCCESS                   
              PERFORM 7900-WRITE-TRAILER-REC THRU 7900-EXIT             
           END-IF.                                                      
                                                                        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7000-OPEN-ACCOUNT                                         **          
      **      OPEN THE MAIN CURSOR ACCOUNT_CUR                      **          
      ****************************************************************          
      *                                                                         
       7000-OPEN-ACCOUNT.                                               
      *                                                                         
           MOVE '7000' TO WS-ACTIVE-PARAGRAPH.                          
           DISPLAY 'WORK DATE IS ' WS-WORK-DATE.                        
           EXEC SQL                                                     
               OPEN ACCOUNT_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN ACCOUNT_CUR '                       
               DISPLAY '       7000-OPEN-ACCOUNT '                      
               DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7010-FETCH-ACCOUNT                                        **          
      **      FETCH THE ACCOUNTS FOR PROCESSING                     **          
      ****************************************************************          
      *                                                                         
       7010-FETCH-ACCOUNT.                                              
      *                                                                         
           MOVE '7010' TO WS-ACTIVE-PARAGRAPH.                          
           MOVE SPACES TO NE-EMAIL-ADDRESS-TX-TEXT                      
                                                                        
           EXEC SQL                                                     
               FETCH ACCOUNT_CUR                                        
                INTO :PC-ACCOUNT-NO                                     
                    ,:PC-PAYMENT-DATE                                   
                    ,:PC-PAYMENT-AMT                                    
                    ,:PC-CREATED-TS                                     
                    ,:AT-COMPANY-NO                                     
                    ,:NE-EMAIL-ADDRESS-TX :WS-NULL-IND-01                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE PC-ACCOUNT-NO TO WS-ACCOUNT-NO                       
              SET WS-FETCH-SUCCESS TO TRUE                              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET WS-END-ACCOUNT-CUR TO TRUE                         
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE       
                 DISPLAY '*******************************************'  
                 DISPLAY '       ABENDING PROGRAM '                     
                 DISPLAY '       FETCH ACCOUNT_CUR '                    
                 DISPLAY '       7010-FETCH-ACCOUNT '                   
                 DISPLAY ' RETURN CODE    = ' WS-DISPLAY-SQLCODE        
                 DISPLAY ' ACCOUNT NO     = ' PC-ACCOUNT-NO             
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND      THRU 9900-EXIT                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7020-CLOSE-ACCOUNT                                        **          
      **      CLOSE THE MAIN CURSOR ACCOUNT_CUR                     **          
      ****************************************************************          
      *                                                                         
       7020-CLOSE-ACCOUNT.                                              
      *                                                                         
           MOVE '7020' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
               CLOSE ACCOUNT_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
                 MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE       
                 DISPLAY '*******************************************'  
                 DISPLAY '       ABENDING PROGRAM '                     
                 DISPLAY '       CLOSE ACCOUNT_CUR '                    
                 DISPLAY '       7020-CLOSE-ACCOUNT '                   
                 DISPLAY ' RETURN CODE    = ' WS-DISPLAY-SQLCODE        
                 DISPLAY ' ACCOUNT NO     = ' PC-ACCOUNT-NO             
                 DISPLAY '*******************************************'  
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7170-READ-FCSCGBPR                                       **          
      **      READS THE INPUT FILE FCSCGBPR-FILE                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7170-READ-FCSCGBPR.                                              
      *                                                                         
           READ FCSCGBPR-FILE                                           
               AT END                                                   
                   INITIALIZE FCSCGBPR-REC                              
                   MOVE 'N'               TO WS-FCSCGBPR-DATA-SW        
                   GO                     TO 7170-EXIT.                 
                                                                        
           IF WS-FCSCR-SUCCESSFUL OR WS-FCSCR-STATUS = '46'             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7170-ERROR ON FCSCGBPR READ.  STATUS IS '       
                        WS-FCSCR-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **   7180-READ-FCPSNBPR                                       **          
      **      READS THE INPUT FILE FCPSNBPR-FILE                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7180-READ-FCPSNBPR.                                              
      *                                                                         
           READ FCPSNBPR-FILE                                           
               AT END                                                   
                   INITIALIZE FCPSNBPR-REC                              
                   MOVE 'N'               TO WS-FCPSNBPR-DATA-SW        
                   GO                     TO 7180-EXIT.                 
                                                                        
           IF WS-FCPSR-SUCCESSFUL OR WS-FCPSR-STATUS = '46'             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7180-ERROR ON FCPSNBPR READ.  STATUS IS '       
                        WS-FCPSR-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7500-PROCESS-ACCOUNT.                                            
           MOVE '7500' TO WS-ACTIVE-PARAGRAPH.                          
           MOVE '7500'                 TO WS-ACTIVE-PARAGRAPH.          
           MOVE SPACES TO EMAIL-ADDR.                                   
           IF NOT WS-END-ACCOUNT-CUR                                    
           IF AT-COMPANY-NO = '01'                                      
              ADD 1 TO WS-TOTAL-RECS-CSRSEB                             
              ADD PC-PAYMENT-AMT TO WS-TOTAL-AMT-CSRSEB                 
              IF WS-TOTAL-RECS-CSRSEB = 1                               
                 PERFORM 7550-WRITE-HEADER THRU 7550-EXIT               
              END-IF                                                    
              PERFORM 7800-WRITE-CSRSEB THRU 7800-EXIT                  
           ELSE                                                         
              ADD 1 TO WS-TOTAL-RECS-PSNC                               
              ADD PC-PAYMENT-AMT TO WS-TOTAL-AMT-PSNC                   
              IF WS-TOTAL-RECS-PSNC = 1                                 
                 PERFORM 7550-WRITE-HEADER THRU 7550-EXIT               
              END-IF                                                    
              PERFORM 7700-WRITE-PSNC THRU 7700-EXIT                    
           END-IF                                                       
           MOVE SPACES TO NE-EMAIL-ADDRESS-TX-TEXT                      
           MOVE PC-ACCOUNT-NO TO WS-ACCOUNT-NO                          
           MOVE PC-PAYMENT-DATE TO WS-PAYMENT-DATE                      
           PERFORM 7950-UPDATE-ACCOUNT THRU 7950-EXIT                   
                                                                        
           IF AT-COMPANY-NO = '01'                                      
              ADD 1 TO WS-LUW-PROCESSED-CSRSEB                          
              ADD 1 TO WS-RECORDS-PROCESSED-CSRSEB                      
              MOVE WS-ACCOUNT-NO TO WS-RESTART-ACCOUNT-CSRSEB           
              MOVE WS-TOTAL-RECS-CSRSEB TO WS-RESTART-REC-CSRSEB        
              IF WS-LUW-PROCESSED-CSRSEB = WS-CHKP-LUW-LIMIT            
                MOVE WS-RESTART-DATA         TO RF-RESTART-DATA-TEXT    
                MOVE +125                    TO RF-RESTART-DATA-LEN     
                                                                        
                MOVE WS-PGRMNAME             TO RF-NAME-PROGRAM         
                MOVE 1                       TO RF-DUP-CNTRL-NO         
                MOVE 1                       TO RF-PARTITION-NO         
                PERFORM 8920-WRITE-RESTART-RECORD                       
                                           THRU 8920-EXIT               
                                                                        
                PERFORM 8898-ISSUE-CHKP      THRU 8898-EXIT             
                                                                        
                SET  WS-THIS-IS-A-RESTART    TO TRUE                    
                ADD +1                       TO WS-COMMIT-NUMBER-CSRSEB 
                MOVE ZERO                    TO WS-LUW-PROCESSED-CSRSEB 
                                                                        
                MOVE WS-RESTART-ACCOUNT-CSRSEB TO WS-ACCOUNT-NUMBER     
                MOVE WS-ACCOUNT-NUMBER       TO WS-DISPLAY-ACCOUNT      
                MOVE WS-WORK-DATE            TO WS-DISPLAY-DATE         
                MOVE 'CSR/SEB'               TO WS-COMPANY-CD           
                                                                        
                DISPLAY '   '                                           
                DISPLAY 'TOTAL RECORDS PROCESSED = '                    
                        WS-RECORDS-PROCESSED-CSRSEB                     
                DISPLAY '** COMMIT NUMBER ' WS-COMMIT-NUMBER-CSRSEB     
                      ' FOR KEY ' WS-DISPLAY-KEY                        
              END-IF                                                    
           ELSE                                                         
              ADD 1 TO WS-LUW-PROCESSED-PSNC                            
              ADD 1 TO WS-RECORDS-PROCESSED-PSNC                        
              MOVE WS-ACCOUNT-NO TO WS-RESTART-ACCOUNT-PSNC             
              MOVE WS-TOTAL-RECS-PSNC   TO WS-RESTART-REC-PSNC          
              IF WS-LUW-PROCESSED-PSNC   = WS-CHKP-LUW-LIMIT            
                MOVE WS-RESTART-DATA         TO RF-RESTART-DATA-TEXT    
                MOVE +125                    TO RF-RESTART-DATA-LEN     
                                                                        
                MOVE WS-PGRMNAME             TO RF-NAME-PROGRAM         
                MOVE 1                       TO RF-DUP-CNTRL-NO         
                MOVE 1                       TO RF-PARTITION-NO         
                PERFORM 8920-WRITE-RESTART-RECORD                       
                                           THRU 8920-EXIT               
                                                                        
                PERFORM 8898-ISSUE-CHKP      THRU 8898-EXIT             
                                                                        
                SET  WS-THIS-IS-A-RESTART    TO TRUE                    
                ADD +1                       TO WS-COMMIT-NUMBER-PSNC   
                MOVE ZERO                    TO WS-LUW-PROCESSED-PSNC   
                                                                        
                MOVE WS-RESTART-ACCOUNT-PSNC   TO WS-ACCOUNT-NUMBER     
                MOVE WS-ACCOUNT-NUMBER       TO WS-DISPLAY-ACCOUNT      
                MOVE WS-WORK-DATE            TO WS-DISPLAY-DATE         
                MOVE 'PSNC   '               TO WS-COMPANY-CD           
                                                                        
                DISPLAY '   '                                           
                DISPLAY 'TOTAL RECORDS PROCESSED = '                    
                        WS-RECORDS-PROCESSED-PSNC                       
                DISPLAY '** COMMIT NUMBER ' WS-COMMIT-NUMBER-PSNC       
                      ' FOR KEY ' WS-DISPLAY-KEY                        
              END-IF                                                    
           END-IF                                                       
                                                                        
           END-IF.                                                      
       7500-EXIT.                                                       
           EXIT.                                                        
       7550-WRITE-HEADER.                                               
           MOVE '7550' TO WS-ACTIVE-PARAGRAPH.                          
           MOVE WS-WORK-DATE TO WS-INPUT-RUN-DATE.                      
           MOVE WS-INPUT-RUN-DATE-CC   TO YEAR-CC.                      
           MOVE WS-INPUT-RUN-DATE-YY   TO YEAR-YY.                      
           MOVE WS-INPUT-RUN-DATE-MM   TO MONTH-DET.                    
           MOVE WS-INPUT-RUN-DATE-DD   TO DAY-DET.                      
           IF AT-COMPANY-NO = '01'                                      
              MOVE HEADER-REC TO FCSCGBPF-REC                           
              PERFORM 8200-WRITE-SCG-RECORD THRU 8200-EXIT              
           ELSE                                                         
              MOVE HEADER-REC TO FCPSNBPF-REC                           
              PERFORM 8210-WRITE-PSN-RECORD THRU 8210-EXIT              
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **    7600-START-FCSJC01                                        **        
      ******************************************************************        
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
                                                                        
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      ** SELECTS THE COMMIT DATA                                      **        
      ******************************************************************        
       7680-GET-COMMIT-PARM.                                            
           MOVE '7600'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT PARM_DATA                                           
               INTO :G6-PARM-DATA                                       
               FROM CSS_JOB_PARM                                        
              WHERE PROGRAM_NAME = 'PCSAC114'                           
                AND COMPANY_NO   = '01'                                 
                AND CMND_CODE    = 'PARM'                               
                AND SEQ_NO       = 1                                    
                AND STATUS       = 'A'                                  
                AND CIS.SUBSTR3(PARM_DATA,1,6) = 'COMMIT'                    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PARM_DATA                                                   
MFA-TR*        INTO :G6-PARM-DATA                                               
MFA-TR*        FROM CSS_JOB_PARM                                                
MFA-TR*       WHERE PROGRAM_NAME = 'PCSAC114'                                   
MFA-TR*         AND COMPANY_NO   = '01'                                         
MFA-TR*         AND CMND_CODE    = 'PARM'                                       
MFA-TR*         AND SEQ_NO       = 1                                            
MFA-TR*         AND STATUS       = 'A'                                          
MFA-TR*         AND SUBSTR(PARM_DATA,1,6) = 'COMMIT'                            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  ERROR WHILE FETCHING COMMIT PARM  **'        
              DISPLAY '**  PARAGRAPH     = 7680-GET-COMMIT-PARM'        
              DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE         
              DISPLAY '***********************************'             
           END-IF                                                       
           .                                                            
       7680-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-WRITE-PSNC.                                                 
           MOVE '7700'                 TO WS-ACTIVE-PARAGRAPH.          
           MOVE PC-ACCOUNT-NO TO ACCOUNT-NO.                            
           MOVE PC-PAYMENT-AMT TO PYMNT-AMT.                            
           IF WS-NULL-IND-01 = 0                                        
             MOVE SPACES TO EMAIL-ADDR                                  
             MOVE NE-EMAIL-ADDRESS-TX-TEXT TO EMAIL-ADDR                
           END-IF.                                                      
           MOVE DETAIL-REC TO FCPSNBPF-REC.                             
           PERFORM 8210-WRITE-PSN-RECORD THRU 8210-EXIT.                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
       7800-WRITE-CSRSEB.                                               
           MOVE '7800' TO WS-ACTIVE-PARAGRAPH.                          
           MOVE PC-ACCOUNT-NO TO ACCOUNT-NO.                            
           MOVE PC-PAYMENT-AMT TO PYMNT-AMT.                            
           IF WS-NULL-IND-01 = 0                                        
             MOVE SPACES TO EMAIL-ADDR                                  
             MOVE NE-EMAIL-ADDRESS-TX-TEXT TO EMAIL-ADDR                
           END-IF.                                                      
           MOVE DETAIL-REC TO FCSCGBPF-REC.                             
           PERFORM 8200-WRITE-SCG-RECORD THRU 8200-EXIT.                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
       7900-WRITE-TRAILER-REC.                                          
           MOVE '7900'                 TO WS-ACTIVE-PARAGRAPH.          
           INITIALIZE TRIAL-REC.                                        
           MOVE '03' TO TRL-RECORD-ID.                                  
           IF WS-TOTAL-RECS-CSRSEB > 0                                  
              MOVE WS-TOTAL-RECS-CSRSEB TO TOTAL-RECORDS                
              MOVE WS-TOTAL-AMT-CSRSEB TO TOTAL-AMT                     
              MOVE TRIAL-REC TO FCSCGBPF-REC                            
              PERFORM 8200-WRITE-SCG-RECORD THRU 8200-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-TOTAL-RECS-PSNC > 0                                    
              MOVE WS-TOTAL-RECS-PSNC   TO TOTAL-RECORDS                
              MOVE WS-TOTAL-AMT-PSNC   TO TOTAL-AMT                     
              MOVE TRIAL-REC TO FCPSNBPF-REC                            
              PERFORM 8210-WRITE-PSN-RECORD THRU 8210-EXIT              
           END-IF.                                                      
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7950-UPDATE-ACCOUNT.                                             
           MOVE '7950'                 TO WS-ACTIVE-PARAGRAPH.          
           MOVE ZEROS                  TO WS-ROW-COUNT                  
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_PNDNG_CARD_PMT                                
               SET    STATUS_CODE = 'E',                                
                      EXTRACTED_TS = CIS.CURRENT$TIMESTAMP()                  
               WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO                       
                 AND  PAYMENT_DATE = IIF(TRY_CONVERT(DATE, 
                                                       :WS-PAYMENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PAYMENT-DATE
              ) <> 0) OR (LEN(:WS-PAYMENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PAYMENT-DATE
              ), CONVERT(DATE, :WS-PAYMENT-DATE) )                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PNDNG_CARD_PMT                                        
MFA-TR*        SET    STATUS_CODE = 'E',                                        
MFA-TR*               EXTRACTED_TS = CURRENT TIMESTAMP                          
MFA-TR*        WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO                               
MFA-TR*          AND  PAYMENT_DATE = :WS-PAYMENT-DATE                           
MFA-TR*        QUERYNO 7950                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '**   ERROR ON 7950-UPDATE-ACCOUNT  **'          
               DISPLAY '**      RETURN CODE = ' WS-DISPLAY-SQLCODE      
               DISPLAY '**   ACCOUNT NUMBER = ' WS-ACCOUNT-NO           
               DISPLAY '**   PAYMENT DATE   = ' WS-PAYMENT-DATE         
               DISPLAY '**      PROCESSING TERMINATED      **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-DISPLAY-ERR-TERM.                                           
           DISPLAY '                                   '.               
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSAC114 PROCESSING ERROR        **'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**       PROCESSING TERMINATED          **'.        
           DISPLAY '******************************************'.        
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8200-WRITE-SCG-RECORD.                                                
      ******************************************************************        
       8200-WRITE-SCG-RECORD.                                           
                                                                        
           WRITE FCSCGBPF-REC.                                          
                                                                        
           IF WS-FCSCG-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSAC114 PROCESSING ERROR  **'               
              DISPLAY '**    WRITE ERROR ON SCG     FILE'               
              DISPLAY '**    FILE STATUS = ' WS-FCSCG-STATUS            
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
                                                                        
           INITIALIZE FCSCGBPF-REC.                                     
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8210-WRITE-PSN-RECORD.                                                
      ******************************************************************        
       8210-WRITE-PSN-RECORD.                                           
                                                                        
           WRITE FCPSNBPF-REC.                                          
                                                                        
           IF WS-FCPSN-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSAC114 PROCESSING ERROR  **'               
              DISPLAY '**    WRITE ERROR ON PSN     FILE'               
              DISPLAY '**    FILE STATUS = ' WS-FCPSN-STATUS            
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
                                                                        
           INITIALIZE FCPSNBPF-REC.                                     
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8898-ISSUE-CHKP.                                             *09910000
      *        COMMIT ALL THE CHANGES                                  *09920000
      ******************************************************************        
                                                                        
       8898-ISSUE-CHKP.                                                 
           EXEC SQL                                                     09970000
              INCLUDE CPD00047                                          09980000
           END-EXEC                                                     09990000
           .                                                            10000000
                                                    
       8898-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8910-CHECK-FOR-RESTART                                       *08560000
      *        CHECKS FOR RESTART DATA FOR THE PROGRAM NAME            *08570000
      ******************************************************************        
                                                                        
       8910-CHECK-FOR-RESTART.                                          
                                                                        
           EXEC SQL                                                     
             SELECT RESTART_DATA                                        
               INTO :RF-RESTART-DATA                                    
               FROM CSS_RESTART WITH(READUNCOMMITTED)                           
              WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                     
                AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                     
                AND PARTITION_NO = :RF-PARTITION-NO                     
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08630000
MFA-TR*      SELECT RESTART_DATA                                        08640000
MFA-TR*        INTO :RF-RESTART-DATA                                    08650000
MFA-TR*        FROM CSS_RESTART                                         08660000
MFA-TR*       WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                     08670000
MFA-TR*         AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                     08680000
MFA-TR*         AND PARTITION_NO = :RF-PARTITION-NO                     08690000
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 8910                                                     
MFA-TR*    END-EXEC                                                     08700000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                MOVE RF-RESTART-DATA-TEXT  TO WS-RESTART-DATA           
                SET  WS-THIS-IS-A-RESTART  TO TRUE                      
                DISPLAY '***********************************'           
                DISPLAY '**         PROCESSING INFO       **'           
                DISPLAY '**        THIS IS A RESTART      **'           
                DISPLAY '***********************************'           
              WHEN NOT-FOUND                                            
                CONTINUE                                                
              WHEN OTHER                                                
                MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
                DISPLAY '***********************************'           
                DISPLAY '**  PROCESSING ERROR             **'           
                DISPLAY '**  PARAGRAPH     = 8910-CHECK-FOR-RESTART'    
                DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE       
                DISPLAY '**  PROGRAM NAME  = ' RF-NAME-PROGRAM          
                DISPLAY '**  DUP CNTRL NO  = ' RF-DUP-CNTRL-NO          
                DISPLAY '**  PARTITION NO  = ' RF-PARTITION-NO          
                DISPLAY '**  PROCESSING TERMINATED        **'           
                DISPLAY '***********************************'           
                PERFORM 9900-ABEND         THRU 9900-EXIT               
           END-EVALUATE                                                 
           .                                                            
       8910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8920-WRITE-RESTART-RECORD                                    *09030000
      *        INSERTS OR UPDATES THE RESTART RECORD IN RESTART TABLE  *09040000
      ******************************************************************        
                                                                        
       8920-WRITE-RESTART-RECORD.                                       
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              EXEC SQL                                                  
                UPDATE CSS_RESTART                                      
                   SET RESTART_DATA = :RF-RESTART-DATA                  
                 WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                  
                   AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                  
                   AND PARTITION_NO = :RF-PARTITION-NO                  
                                                            
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*       EXEC SQL                                                          
MFA-TR*         UPDATE CSS_RESTART                                              
MFA-TR*            SET RESTART_DATA = :RF-RESTART-DATA                          
MFA-TR*          WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                          
MFA-TR*            AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                          
MFA-TR*            AND PARTITION_NO = :RF-PARTITION-NO                          
MFA-TR*          QUERYNO 8920                                                   
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           ELSE                                                         
              EXEC SQL                                                  
                INSERT INTO CSS_RESTART                                 
                       (NAME_PROGRAM,                                   
                       PARTITION_NO,                                    
                       DUP_CNTRL_NO,                                    
                       RESTART_DATA)                                    
                VALUES                                                  
                       (:RF-NAME-PROGRAM,                               
                       :RF-PARTITION-NO,                                
                       :RF-DUP-CNTRL-NO,                                
                       :RF-RESTART-DATA)                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF                                                       
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH     = 8920-WRITE-RESTART-RECORD **'
              DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**  PROGRAM NAME  = ' RF-NAME-PROGRAM            
              DISPLAY '**  DUP CNTRL NO  = ' RF-DUP-CNTRL-NO            
              DISPLAY '**  PARTITION NO  = ' RF-PARTITION-NO            
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           .                                                            
       8920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8930-DELETE-RESTART-RECORD.                                  *09550000
      *        DELETES RESTART RECORD FROM THE RESTART TABLE           *09560000
      ******************************************************************        
       8930-DELETE-RESTART-RECORD.                                      
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_RESTART                                    
              WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                     
                AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                     
                AND PARTITION_NO = :RF-PARTITION-NO                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND)                       
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 8930-DELETE-RESTART-RECORD' 
              DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE        
              DISPLAY '**  PROGRAM NAME   = ' RF-NAME-PROGRAM           
              DISPLAY '**  DUP CNTRL NO   = ' RF-DUP-CNTRL-NO           
              DISPLAY '**  PARTITION NO   = ' RF-PARTITION-NO           
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF                                                       
           .                                                            
       8930-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **  9000-TERMINATE                                            **          
      **       PROGRAM WRAP UP                                      **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCGBPF-FILE                                          
                 FCPSNBPF-FILE.                                         
                                                                        
           PERFORM 7020-CLOSE-ACCOUNT       THRU 7020-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             DISPLAY '*******************************************'      
             DISPLAY '           PCSAC114 ENDING '                      
             DISPLAY '*******************************************'      
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **  9700-PROCESS-ABEND.                                       **          
      ****************************************************************          
      *                                                                         
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
