       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSAC113.                                        
       DATE-WRITTEN.   SEP, 2009.                                       
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00120000
      ********                      DB2                       ********* 00130000
      ***************************************************************** 00140000
      **                                                             ** 00150000
      **              PROGRAM  MODIFICATION  LOG                     ** 00160000
      **    DATE    INITIALS     REASON                              ** 00170000
      **    ____    ________     ______                              ** 00180000
PRJ526** 09/28/09    AP40911     INITIAL REQUEST FOR PROGRAM         ** 00190000
A02714** 12/13/11    AP40911     ADD CANCEL REASON.                  **         
      ***************************************************************** 00400000
                                                                        
      *================================================================*00420000
      ******************************************************************00430000
      *               P R O G R A M  S U M M A R Y                     *        
      *                                                                *        
      * THIS BATCH PROCESS IS TO UPDATE THE PAYMENT AMOUNTS AS NEEDED  *        
      * DUE TO ACCOUNT ACTIVITY THAT HAS AFFECTED THE ACCOUNT BALANCE  *        
      * SINCE BILLING.  IT WILL RUN FOR ACCOUNTS ENROLLED              *        
      * IN AUTO-CARD RECURRING PROCESS WHERE BILLED BALANCE IS NOT     *        
      * EQUAL TO THE AUTO-CARD PAYMENT AMOUNT.                         *        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
            SELECT FCSPT33-FILE                                         
              ASSIGN TO UT-S-FCSPT33                                    
              FILE STATUS IS WS-FCSPT33-STATUS.                         
                                                                        
      *****************************************************************         
      *         SELECT STATEMENT FOR OUTPUT REPORT FILE               *         
      *****************************************************************         
                                                                        
       COPY CSSPT331.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *   FD SECTION & LAYOUT FOR REPORT OUTPUT FILE                *           
      ***************************************************************           
       COPY CFDPT33.                                                            
       COPY CFDPT331.                                                           
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC113'.
MSQ017     COPY MFASQLM.
      ******************************************************************        
      *                                                                *        
      *             'WORKING STORAGE FOR PCSAC113 STARTS HERE'.        *        
      ******************************************************************        
                                                                        
       01  WS-CURRENT-DATE.                                             
           05  WS-CURRENT-YY                 PIC 9(02).                 
           05  WS-CURRENT-MM                 PIC 9(02).                 
           05  WS-CURRENT-DD                 PIC 9(02).                 
                                                                        
       01  WS-CURRENT-TIME                   PIC 9(08).                 
       01  WS-MISC.                                                     
           05 WS-CURRENT-TS           PIC X(26)      VALUE SPACES.      
           05 WS-ABEND-PARAGRAPH      PIC XXXX       VALUE SPACES.      
           05 WS-SQLCODE              PIC --------9.                    
           05 WS-UPDDELINQ-CODE       PIC X(15) VALUE 'CARD-UPD-DELINQ'.
COB305     05 WS-UPDDELINQ-VALUE        PIC S9(9)V9(5) USAGE COMP-3 
COB305       VALUE 0.      
           05 WS-CANDELINQ-CODE       PIC X(15) VALUE 'CARD-CAN-DELINQ'.
COB305     05 WS-CANDELINQ-VALUE        PIC S9(9)V9(5) USAGE COMP-3 
COB305       VALUE 0.      
           05 WS-FCSPT33-STATUS       PIC X(02).                        
               88  FCSPT33-SUCCESSFUL             VALUE '00'.           
           05 WS-FCA331-STATUS        PIC X(02).                        
               88  FCSPT331-SUCCESSFUL            VALUE '00'.           
           05 WS-RPT1-PAGE-NO         PIC 9(04)   VALUE 0.              
           05 WS-RPT1-LINE-NO         PIC 9(02)   VALUE 0.              
           05 WS-RPT2-PAGE-NO         PIC 9(04)   VALUE 0.              
           05 WS-RPT2-LINE-NO         PIC 9(02)   VALUE 0.              
           05  WS-ERR-MSG1                      PIC X(100) VALUE SPACES.
           05  WS-ERR-MSG2                      PIC X(100) VALUE SPACES.
           05  WS-ERR-MSG3                      PIC X(100) VALUE SPACES.
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                    PIC X(01)  VALUE 'Y'.            
           05  WS-N                    PIC X(01)  VALUE 'N'.            
           05  WS-YES                  PIC X(01)  VALUE 'Y'.            
           05  WS-NO                   PIC X(01)  VALUE 'N'.            
           05  WS-PGRMNAME             PIC X(10)  VALUE 'PCSAC113  '.   
           05  PROGRAM-NAME            PIC X(08)  VALUE 'PCSAC113'.     
           05  WS-CARD-TRANS-CMNT      PIC X(27)  VALUE                 
              'PRE AUTOCARD PAYMENT UPDATE'.                            
           05  WS-APPL-PRG-ID          PIC X(08)     VALUE 'PCSAC113'.  
           05  WS-F                    PIC X(01)     VALUE 'F'.         
           05  WS-PC-ACCOUNT-NO        PIC  X(13).                      
           05  WS-PC-ACCOUNT-NO-NUM REDEFINES WS-PC-ACCOUNT-NO          
                                       PIC  9(13).                      
COB305     05 WS-PC-PAYMT-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-PC-PAYMT-DATE        PIC X(10)    VALUE SPACES.       
COB305     05 WS-AT-TOTAL-AR-BALANCE        PIC S9(11)V9(2) 
COB305       USAGE COMP-3 VALUE 0.    
           05  WS-PRE-CARD-AMT         PIC  -ZZZ,ZZZ,ZZ9.99.            
           05  WS-CUR-CARD-AMT         PIC  -ZZZ,ZZZ,ZZ9.99.            
       01 WS-FLAGS.                                                     
          05 WS-LIEAP                   PIC X(1)   VALUE ' '.           
                                                                        
       01 WS-SWITCHES.                                                  
           05  WS-OPEN-CUR              PIC X(01)    VALUE 'N'.         
           05  WS-DATA-REPORT1          PIC X(01)    VALUE 'N'.         
           05  WS-DATA-REPORT2          PIC X(01)    VALUE 'N'.         
           05  WS-NO-DATA               PIC X(01)    VALUE 'N'.         
                                                                        
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADERS        **          
      ****************************************************************          
                                                                        
       01  WS-HEADER-LINES.                                             
           05  WS-RPT-HEADER-1.                                         
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  P-RPT-TITLE-PGNM          PIC X(08)  VALUE           
                                                         'PCSAC113'.    
               10  FILLER                    PIC X(40)  VALUE SPACES.   
               10  P-RPT-COMP-NAME           PIC X(39)  VALUE SPACES.   
               10  FILLER                    PIC X(26)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                       'RUN-DATE:'.     
               10  P-RPT-RUN-MM              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE '/'.      
               10  P-RPT-RUN-DD              PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE '/'.      
               10  P-RPT-RUN-YY              PIC X(02).                 
           05  WS-RPT-HEADER-2.                                         
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  FILLER                    PIC X(05)  VALUE 'DATE:'.  
               10  P-REP1-MM                 PIC X(02).                 
               10  FILLER                    PIC X(01)     VALUE '/'.   
               10  P-REP1-DD                 PIC X(02).                 
               10  FILLER                    PIC X(01)     VALUE '/'.   
               10  P-REP1-YY                 PIC X(02).                 
               10  FILLER                    PIC X(35)  VALUE SPACES.   
               10  FILLER                    PIC X(61)  VALUE           
                    'PRE-AUTO-CARD AMOUNT UPDATE REPORT '.              
               10  FILLER                    PIC X(04)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                      'RUN-TIME:'.      
               10  WS-REP1-HH                PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  WS-REP1-MIN               PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  WS-REP1-SS                PIC X(02).                 
                                                                        
           05  WS-RPT2-HEADER-2.                                        
               10  FILLER                    PIC X(02)  VALUE SPACES.   
               10  FILLER                    PIC X(05)  VALUE 'DATE:'.  
               10  P-REP2-MM                 PIC X(02).                 
               10  FILLER                    PIC X(01)     VALUE '/'.   
               10  P-REP2-DD                 PIC X(02).                 
               10  FILLER                    PIC X(01)     VALUE '/'.   
               10  P-REP2-YY                 PIC X(02).                 
               10  FILLER                    PIC X(35)  VALUE SPACES.   
               10  FILLER                    PIC X(61)  VALUE           
                  'AUTO-CARD PAYMENT AMOUNT NOT EQUAL TO BILL BALANCE'. 
               10  FILLER                    PIC X(04)  VALUE SPACES.   
               10  FILLER                    PIC X(09)  VALUE           
                                                      'RUN-TIME:'.      
               10  WS-REP2-HH                PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  WS-REP2-MIN               PIC X(02).                 
               10  FILLER                    PIC X(01)  VALUE ':'.      
               10  WS-REP2-SS                PIC X(02).                 
           05  WS-RPT-HEADER-3.                                         
               10  FILLER              PIC X(115)   VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
               10  P-RPT-PAGE-NO       PIC ZZ,ZZZ.                      
               10  FILLER              PIC X(07)    VALUE SPACES.       
                                                                        
           05  WS-RPT2-HEADER-3.                                        
               10  FILLER              PIC X(115)   VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
               10  P-RPT2-PAGE-NO      PIC ZZ,ZZZ.                      
               10  FILLER              PIC X(07)    VALUE SPACES.       
                                                                        
       01  WS-PRINT-REP-HDR-1.                                          
           05  FILLER                  PIC X(02)  VALUE SPACES.         
           05  FILLER                  PIC X(09)    VALUE               
                                       'ACCNT NBR'.                     
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(10)    VALUE               
                                       'PAYMT DATE'.                    
           05  FILLER                  PIC X(07)    VALUE SPACES.       
           05  FILLER                  PIC X(12)    VALUE               
                                       'PAYMT AMOUNT'.                  
           05  FILLER                  PIC X(08)    VALUE SPACES.       
           05  FILLER                  PIC X(10)    VALUE               
                                       'AR BALANCE'.                    
           05  FILLER                  PIC X(08)    VALUE SPACES.       
           05  FILLER                  PIC X(13)    VALUE               
                                       'UPDATE AMOUNT'.                 
           05  FILLER                  PIC X(13)    VALUE SPACES.       
           05  FILLER                  PIC X(31)    VALUE SPACES.       
                                                                        
       01  WS-PRINT-REP2-HDR-1.                                         
           05  FILLER                  PIC X(02)  VALUE SPACES.         
           05  FILLER                  PIC X(09)    VALUE               
                                       'ACCNT NBR'.                     
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(10)    VALUE               
                                       'PAYMT DATE'.                    
           05  FILLER                  PIC X(07)    VALUE SPACES.       
           05  FILLER                  PIC X(12)    VALUE               
                                       'PAYMT AMOUNT'.                  
           05  FILLER                  PIC X(08)    VALUE SPACES.       
           05  FILLER                  PIC X(10)    VALUE               
                                       'AR BALANCE'.                    
           05  FILLER                  PIC X(65)    VALUE SPACES.       
                                                                        
       01  WS-PRINT-REP-HDR-2.                                          
           05  FILLER                  PIC X(132)   VALUE '*'.          
                                                                        
       01  WS-PRINT-REP-DET-1.                                          
           05  FILLER                  PIC X(02)    VALUE SPACES.       
           05  P-RPT1-ACC-NUMB         PIC X(13)    VALUE SPACES.       
           05  FILLER                  PIC X(08)    VALUE SPACES.       
           05  P-RPT1-PAY-DATE         PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(01)    VALUE SPACES.       
           05  P-RPT1-PAY-AMT          PIC ZZZ,ZZ9.99   VALUE ZEROES.   
           05  FILLER                  PIC X(10)      VALUE SPACES.     
           05  P-RPT1-AR-BALANCE       PIC Z(09).99-.                   
           05  FILLER                  PIC X(08)       VALUE SPACES.    
           05  P-RPT1-UPDATE-AMT       PIC Z(09).99-.                   
           05  FILLER                  PIC X(05)    VALUE SPACES.       
           05  FILLER                  PIC X(40)    VALUE SPACES.       
                                                                        
       01  WS-PRINT-REP2-DET-1.                                         
           05  FILLER                  PIC X(02)    VALUE SPACES.       
           05  P-RPT2-ACC-NUMB         PIC X(13)    VALUE SPACES.       
           05  FILLER                  PIC X(08)    VALUE SPACES.       
           05  P-RPT2-PAY-DATE         PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(01)    VALUE SPACES.       
           05  P-RPT2-PAY-AMT          PIC ZZZ,ZZ9.99   VALUE ZEROES.   
           05  FILLER                  PIC X(10)      VALUE SPACES.     
           05  P-RPT2-AR-BALANCE       PIC Z(09).99-.                   
           05  FILLER                  PIC X(62)    VALUE SPACES.       
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
                                                                        
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                    '*** END OF REPORT ***'.                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
                                                                        
                                                                        
       COPY FIOJC01.                                                    03010000
       COPY CWS00303.                                                           
       COPY CWS00039.                                                   01300000
       COPY CWS00038.                                                   01320000
       COPY CWS09900.                                                   01260000
      ****************************************************************          
      * CONTAINS WS-VARIABLES FOR FINDING NEXT BUSINESS DAY          *  02960000
      ****************************************************************          
           EXEC SQL                                                     02970000
               INCLUDE CWS00315                                         02980000
           END-EXEC.                                                    02990000
                                                                        
      ****************************************************************          
      *     SQL COMMUNICATION AREA                                   *          
      ****************************************************************          
           EXEC SQL                                                     03130000
               INCLUDE SQLCA                                            03140000
           END-EXEC.                                                    03150000
                                                                        
      ****************************************************************          
      *    CSS_JOB_PARM - G6                                         *          
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_HOLIDAY - J8                                             *        
      ******************************************************************        
           EXEC SQL                                                     03210000
               INCLUDE TBHLDAY                                          03220000
           END-EXEC.                                                    03230000
                                                                        
      ****************************************************************          
      * CSS_COMPANY - C7                                             *  05370000
      ****************************************************************          
                                                                        
           EXEC SQL                                                     05390000
             INCLUDE TBCOMPNY                                           05400000
           END-EXEC.                                                    05410000
                                                                        
      ****************************************************************          
      *     CSS_ACCOUNT - AT                                         *          
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_MT_TRN_HST_DET - MI                                    *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBMNHDT                                                     
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_MNT_TRANS_HIST - MH                                    *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBMNHIST                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_DELINQUENCY - C8                                       *         
      *===============================================================*         
             EXEC SQL                                                           
                INCLUDE TBDELQ                                                  
             END-EXEC.                                                          
                                                                        
      *===============================================================*         
      *    CSS_LIEAP - LI                                             *         
      *===============================================================*         
             EXEC SQL                                                           
                INCLUDE TBLIEAP                                                 
             END-EXEC.                                                          
                                                                        
      *===============================================================*         
      *     CSS_PNDNG_CARD_PMT - PC                                   *         
      *===============================================================*         
             EXEC SQL                                                           
                INCLUDE TBPNDCRD                                                
             END-EXEC.                                                          
                                                                        
                                                                        
           EXEC SQL                                                     
                DECLARE PNDNG_CARD_CUR CURSOR WITH HOLD FOR             
                SELECT   PC.ACCOUNT_NO                                  
                        ,PC.PAYMENT_DATE                                
                        ,PC.PAYMENT_AMT                                 
                        ,PC.STATUS_CODE                                 
                        ,AT.ACCOUNT_NO                                  
                        ,AT.TOTAL_AR_BALANCE                            
                        ,AT.COMPANY_NO                                  
                        ,AT.DATE_BILL_DAY_90                            
              FROM CSS_PNDNG_CARD_PMT PC WITH(READUNCOMMITTED)                  
                  ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                         
             WHERE PC.ACCOUNT_NO = AT.ACCOUNT_NO                        
               AND PC.PAYMENT_DATE <= IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )              
               AND PC.STATUS_CODE = 'A'                                 
               AND (PC.PAYMENT_AMT > AT.TOTAL_AR_BALANCE OR             
                    PC.PAYMENT_AMT < AT.TOTAL_AR_BALANCE)               
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03890000
MFA-TR*         DECLARE PNDNG_CARD_CUR CURSOR WITH HOLD FOR             03900000
MFA-TR*         SELECT   PC.ACCOUNT_NO                                          
MFA-TR*                 ,PC.PAYMENT_DATE                                        
MFA-TR*                 ,PC.PAYMENT_AMT                                         
MFA-TR*                 ,PC.STATUS_CODE                                         
MFA-TR*                 ,AT.ACCOUNT_NO                                          
MFA-TR*                 ,AT.TOTAL_AR_BALANCE                                    
MFA-TR*                 ,AT.COMPANY_NO                                          
MFA-TR*                 ,AT.DATE_BILL_DAY_90                                    
MFA-TR*       FROM CSS_PNDNG_CARD_PMT PC                                        
MFA-TR*           ,CSS_ACCOUNT AT                                               
MFA-TR*      WHERE PC.ACCOUNT_NO = AT.ACCOUNT_NO                                
MFA-TR*        AND PC.PAYMENT_DATE <= :WS-NEW-BUSINESS-DAY                      
MFA-TR*        AND PC.STATUS_CODE = 'A'                                         
MFA-TR*        AND (PC.PAYMENT_AMT > AT.TOTAL_AR_BALANCE OR                     
MFA-TR*             PC.PAYMENT_AMT < AT.TOTAL_AR_BALANCE)                       
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                    04020000
                                                                        
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                 *         
      *    THE MAIN PROCESSING OF PROGRAM                             *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 7000-OPEN-PNDNG-CARD-CUR    THRU 7000-EXIT.          
           PERFORM 7100-FETCH-PNDNG-CARD-CUR   THRU 7100-EXIT           
                      UNTIL WS-NO-DATA = 'Y'.                           
           PERFORM 7200-CLOSE-PNDNG-CARD-CUR   THRU 7200-EXIT.          
           PERFORM 8500-END-DATA-PARA          THRU 8500-EXIT.          
           CLOSE FCSPT33-FILE.                                          
           CLOSE FCSPT331-FILE.                                         
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                               *         
      *  THIS PROCEDURE OPENS THE FILES, ACCEPTS SYSTEM DATE & TIME   *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'  TO WS-ABEND-PARAGRAPH.                          
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF FCSPT33-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-FCSPT33-STATUS         TO  WS-SQLCODE             
              STRING '    ERROR OPENING FCSPT33 FILE     **'            
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG1               
              STRING 'FCSPT33-STATUS= ' WS-SQLCODE                      
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
              PERFORM 8900-DISPLAY-ERR-MSG  THRU 8900-EXIT              
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSPT331-FILE.                                   
           IF FCSPT331-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-FCA331-STATUS         TO  WS-SQLCODE              
              STRING '    ERROR OPENING FCSPT331 FILE    **'            
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG1               
              STRING 'FCSPT331-STATUS= ' WS-SQLCODE                     
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
              PERFORM 8900-DISPLAY-ERR-MSG  THRU 8900-EXIT              
           END-IF.                                                      
      * GET CURRENT DATE                                                        
                                                                        
           ACCEPT WS-CURRENT-DATE          FROM DATE.                   
           MOVE   WS-CURRENT-YY            TO P-RPT-RUN-YY.             
           MOVE   WS-CURRENT-MM            TO P-RPT-RUN-MM.             
           MOVE   WS-CURRENT-DD            TO P-RPT-RUN-DD.             
                                                                        
      * GET CURRENT TIME                                                        
                                                                        
           ACCEPT WS-CURRENT-TIME          FROM TIME.                   
           MOVE   WS-CURRENT-TIME(1:2)     TO WS-REP1-HH                
                                            , WS-REP2-HH.               
           MOVE   WS-CURRENT-TIME(3:2)     TO WS-REP1-MIN               
                                            , WS-REP2-MIN.              
           MOVE   WS-CURRENT-TIME(5:2)     TO WS-REP1-SS                
                                            , WS-REP2-SS.               
                                                                        
                                                                        
           PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT.              
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON    '            TO WS-PGRMNAME               
              MOVE SPACES                  TO WS-INPUT-AREA             
              MOVE SPACES                  TO                           
                                             WS-INPUT-DATA-BREAKDOWN    
              PERFORM 6251-GET-FJC01-DATE  THRU 6251-EXIT               
              MOVE PROGRAM-NAME            TO WS-PGRMNAME               
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE           TO WS-NEW-BUSINESS-DAY.         
           MOVE WS-INPUT-DATE(3:2)      TO P-REP1-YY                    
                                         , P-REP2-YY.                   
           MOVE WS-INPUT-DATE(6:2)      TO P-REP1-MM                    
                                         , P-REP2-MM.                   
           MOVE WS-INPUT-DATE(9:2)      TO P-REP1-DD                    
                                         , P-REP2-DD.                   
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
                           THRU 6500-NEXT-BUSINESS-DAY-EXIT             
                     UNTIL NEXT-BUSINESS-DAY-FOUND                      
           DISPLAY 'NEXT BUSINESS DAY=' WS-NEW-BUSINESS-DAY.            
      * GET COMPANY NAME                                                        
           PERFORM 7225-SELECT-COMPANY-NAME THRU 7225-EXIT.             
           MOVE  C7-COMPANY-NAME            TO P-RPT-COMP-NAME.         
      * GET DELINQUENCY VALUE                                                   
           MOVE WS-UPDDELINQ-CODE           TO C8-DELINQ-CD.            
           PERFORM 7250-GET-DELINQUENCY     THRU 7250-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-UPDDELINQ-VALUE.      
           MOVE WS-CANDELINQ-CODE           TO C8-DELINQ-CD.            
           PERFORM 7250-GET-DELINQUENCY     THRU 7250-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-CANDELINQ-VALUE.      
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 5000-PROCESS-ACCOUNT                                           *        
      ******************************************************************        
       5000-PROCESS-ACCOUNT.                                            
           MOVE '5000'  TO WS-ABEND-PARAGRAPH.                          
           MOVE PC-ACCOUNT-NO        TO WS-PC-ACCOUNT-NO-NUM.           
           MOVE PC-PAYMENT-AMT       TO WS-PC-PAYMT-AMT                 
                                      , WS-PRE-CARD-AMT.                
           MOVE PC-PAYMENT-DATE      TO WS-PC-PAYMT-DATE.               
           MOVE AT-TOTAL-AR-BALANCE  TO WS-AT-TOTAL-AR-BALANCE          
                                      , WS-CUR-CARD-AMT.                
           PERFORM 7275-CHECK-LIEAP-ROW THRU 7275-EXIT                  
             IF WS-LIEAP = 'Y'                                          
                PERFORM 8610-WRITE-FCSPT331 THRU 8610-EXIT              
                GO TO 5000-EXIT                                         
             END-IF                                                     
           EVALUATE TRUE                                                
               WHEN AT-TOTAL-AR-BALANCE <= 0                            
                 IF WS-CANDELINQ-VALUE = 1                              
                    PERFORM 7350-CANCEL-PNDNG-CARD  THRU 7350-EXIT      
                    PERFORM  8600-WRITE-FCSPT33 THRU 8600-EXIT          
                 ELSE                                                   
                    PERFORM 8600-WRITE-FCSPT33  THRU 8600-EXIT          
                 END-IF                                                 
                                                                        
               WHEN WS-PC-PAYMT-AMT < WS-AT-TOTAL-AR-BALANCE            
                 PERFORM  8610-WRITE-FCSPT331 THRU 8610-EXIT            
                                                                        
               WHEN WS-PC-PAYMT-AMT > WS-AT-TOTAL-AR-BALANCE            
                 IF WS-UPDDELINQ-VALUE = 1                              
                    PERFORM 7300-UPDATE-CARD-AMOUNT THRU 7300-EXIT      
                    PERFORM  8600-WRITE-FCSPT33 THRU 8600-EXIT          
                 ELSE                                                   
                    PERFORM 8600-WRITE-FCSPT33  THRU 8600-EXIT          
                 END-IF                                                 
            END-EVALUATE.                                               
       5000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 08880000
      *    6251-GET-FJC01-DATE                                       ** 08890000
      *                                                              ** 08900000
      *    COPYBOOK CPD00037 CONTAINS THE LOGIC FOR FINDING THE      ** 08910000
      *    OVERRIDE DATE.                                            ** 08920000
      ***************************************************************** 08930000
                                                                        
       COPY CPD00037.                                                   08860000
                                                                        
      ***************************************************************** 08880000
      *    6500-GET-NEXT-BUSINESS-DAY                                ** 08890000
      *                                                              ** 08900000
      *    COPYBOOK CPD00315 CONTAINS THE LOGIC FOR FINDING          ** 08910000
      *    THE NEXT BUSINESS DAY.                                    ** 08920000
      ***************************************************************** 08930000
                                                                        
           EXEC SQL                                                     08950000
               INCLUDE CPD00315                                         08960000
           END-EXEC.                                                    08970000
                                                                        
      *****************************************************************         
      * 7000-OPEN-PNDNG-CARD-CUR                                      *         
      *****************************************************************         
       7000-OPEN-PNDNG-CARD-CUR.                                        
                                                                        
           MOVE '7000'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                OPEN PNDNG_CARD_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-SQLCODE.                                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-Y               TO  WS-OPEN-CUR                   
           ELSE                                                         
              STRING '    ERROR OPENING PNDNG_CARD_CUR   **'            
                                   DELIMITED BY SIZE                    
                                   INTO    WS-ERR-MSG1                  
              STRING 'SQLCODE=   ' WS-SQLCODE                           
                                   DELIMITED BY SIZE                    
                                   INTO    WS-ERR-MSG2                  
              PERFORM 8900-DISPLAY-ERR-MSG  THRU 8900-EXIT              
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7100-FETCH-PNDNG-CARD-CUR                                      *        
      ******************************************************************        
       7100-FETCH-PNDNG-CARD-CUR.                                       
                                                                        
           MOVE '7100'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                FETCH PNDNG_CARD_CUR INTO                               
                      :PC-ACCOUNT-NO,                                   
                      :PC-PAYMENT-DATE,                                 
                      :PC-PAYMENT-AMT,                                  
                      :PC-STATUS-CODE,                                  
                      :AT-ACCOUNT-NO,                                   
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-COMPANY-NO,                                   
                      :AT-DATE-BILL-DAY-90                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-SQLCODE.                                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                PERFORM 5000-PROCESS-ACCOUNT THRU 5000-EXIT             
             ELSE                                                       
                MOVE 'Y'              TO WS-NO-DATA                     
             END-IF                                                     
           ELSE                                                         
               STRING '    ERROR FETCHING PNDNG_CARD_CUR  **'           
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG1               
               STRING 'SQLCODE=  ' WS-SQLCODE                           
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
              PERFORM 8900-DISPLAY-ERR-MSG  THRU 8900-EXIT              
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7200-CLOSE-PNDNG-CARD-CUR                                      *        
      ******************************************************************        
       7200-CLOSE-PNDNG-CARD-CUR.                                       
                                                                        
           MOVE '7200'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                CLOSE PNDNG_CARD_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-SQLCODE.                                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING '    ERROR CLOSING PNDNG_CARD_CUR     **'          
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG1               
              STRING 'SQLCODE=   ' WS-SQLCODE                           
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
              PERFORM 8900-DISPLAY-ERR-MSG  THRU 8900-EXIT              
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7225-SELECT-COMPANY-NAME                                                
      * READ COMPANY USER TABLE TO GET COMPANY NAME                   *         
      *****************************************************************         
       7225-SELECT-COMPANY-NAME.                                        
           MOVE '7225'  TO WS-ABEND-PARAGRAPH.                          
           EXEC SQL                                                     
              SELECT COMPANY_NAME                                       
              INTO :C7-COMPANY-NAME                                     
              FROM CSS_COMPANY                                          
              WHERE COMPANY_NO ='01'                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-SQLCODE.                                  
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
               CONTINUE                                                 
            ELSE                                                        
               STRING 'ERROR SELECTING COMPANY_NAME FROM  **'           
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG1               
               STRING 'CSS_COMPANY  ' DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
               STRING 'SQLCODE =  ' WS-SQLCODE                          
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG3               
               PERFORM 8900-DISPLAY-ERR-MSG  THRU 8900-EXIT             
           END-IF.                                                      
       7225-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7250-GET-DELINQUENCY                                          *         
      *     SELECT DELINQUENCY VALUE TO DETERMINE IF UPDATE AND REPORT*         
      *          OR JUST REPORT                                       *         
      *****************************************************************         
       7250-GET-DELINQUENCY.                                            
      *                                                                         
           MOVE '7250'  TO WS-ABEND-PARAGRAPH.                          
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
                 WHERE DELINQ_CD  = :C8-DELINQ-CD                       
                  AND  COMPANY_NO ='01'                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*          WHERE DELINQ_CD  = :C8-DELINQ-CD                               
MFA-TR*           AND  COMPANY_NO ='01'                                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE                     
                              WS-SQLCODE.                               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               STRING 'ERROR SELECTING DELINQ_VALUE FROM  **'           
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG1               
               STRING 'CSS_DELINQUENCY'  DELIMITED BY SIZE              
                                         INTO    WS-ERR-MSG2            
               STRING 'SQLCODE =  ' WS-SQLCODE                          
                                         DELIMITED BY SIZE              
                                         INTO    WS-ERR-MSG3            
              PERFORM 8900-DISPLAY-ERR-MSG  THRU 8900-EXIT              
           END-IF.                                                      
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7275-CHECK-LIEAP-ROW                                          *         
      *     CHECK IF ACCOUNT IS IN CSS_LIEAP TABLE AFTER THE          *         
      *         ACCOUNT WAS BILLED FOR THE ZERO BILLED DATE.          *         
      *****************************************************************         
       7275-CHECK-LIEAP-ROW.                                            
                                                                        
           MOVE '7275'  TO WS-ABEND-PARAGRAPH.                          
           EXEC SQL                                                     
           SELECT TOP(1) LI.ACCOUNT_NO                                         
           INTO  :LI-ACCOUNT-NO                                         
             FROM CSS_LIEAP LI WITH(READUNCOMMITTED)                            
              WHERE LI.ACCOUNT_NO =:PC-ACCOUNT-NO                       
              AND   CAST(LI.VOUCHER_PAY_DT AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :AT-DATE-BILL-DAY-90
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-90
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-90
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-90
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-90) )     
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT LI.ACCOUNT_NO                                                 
MFA-TR*    INTO  :LI-ACCOUNT-NO                                                 
MFA-TR*      FROM CSS_LIEAP LI                                                  
MFA-TR*       WHERE LI.ACCOUNT_NO =:PC-ACCOUNT-NO                               
MFA-TR*       AND   DATE(LI.VOUCHER_PAY_DT) >= :AT-DATE-BILL-DAY-90             
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE                   
                                WS-SQLCODE.                             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                  MOVE 'Y'    TO WS-LIEAP                               
              ELSE                                                      
                  MOVE 'N'    TO WS-LIEAP                               
              END-IF                                                    
           ELSE                                                         
              STRING 'ERROR SELECTING CSS_LIEAP ACCOUNT   **'           
                                     DELIMITED BY SIZE                  
                                     INTO WS-ERR-MSG1                   
              STRING 'ACCOUNT-NO=  ' WS-PC-ACCOUNT-NO                   
                                     DELIMITED BY SIZE                  
                                     INTO WS-ERR-MSG2                   
              STRING 'SQLCODE=  ' WS-SQLCODE                            
                                     DELIMITED BY SIZE                  
                                     INTO    WS-ERR-MSG3                
              PERFORM 8900-DISPLAY-ERR-MSG  THRU 8900-EXIT              
           END-IF.                                                      
       7275-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16690000
      *  7300-UPDATE-CARD-AMOUNT.                                    *  16700000
      ****************************************************************  16710000
       7300-UPDATE-CARD-AMOUNT.                                         
           MOVE '7300'  TO WS-ABEND-PARAGRAPH.                          
              EXEC SQL                                                  
                 UPDATE  CSS_PNDNG_CARD_PMT                             
                 SET PAYMENT_AMT    = :AT-TOTAL-AR-BALANCE              
                 WHERE ACCOUNT_NO   = :PC-ACCOUNT-NO                    
                 AND PAYMENT_DATE   = IIF(TRY_CONVERT(DATE, 
                                                       :PC-PAYMENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PC-PAYMENT-DATE
              ) <> 0) OR (LEN(:PC-PAYMENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :PC-PAYMENT-DATE
              ), CONVERT(DATE, :PC-PAYMENT-DATE) )                  
                 AND PAYMENT_AMT    = :PC-PAYMENT-AMT                   
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*          UPDATE  CSS_PNDNG_CARD_PMT                                     
MFA-TR*          SET PAYMENT_AMT    = :AT-TOTAL-AR-BALANCE                      
MFA-TR*          WHERE ACCOUNT_NO   = :PC-ACCOUNT-NO                            
MFA-TR*          AND PAYMENT_DATE   = :PC-PAYMENT-DATE                  12190000
MFA-TR*          AND PAYMENT_AMT    = :PC-PAYMENT-AMT                   12200000
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE                  
                                 WS-SQLCODE.                            
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                PERFORM 7400-INSERT-CARD-UPD-TRNS-HIST THRU 7400-EXIT   
             ELSE                                                       
               STRING 'ERROR UPDATING CSS_PNDNG_CARD_PMT **'            
                                      DELIMITED BY SIZE                 
                                      INTO WS-ERR-MSG1                  
               STRING 'ACCOUNT_NO = ' WS-PC-ACCOUNT-NO,                 
                                      DELIMITED BY SIZE                 
                     'PAYMENT_DATE =' WS-PC-PAYMT-DATE                  
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
               STRING 'SQLCODE =    ' WS-SQLCODE                        
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG3               
                PERFORM 8900-DISPLAY-ERR-MSG  THRU 8900-EXIT            
             END-IF.                                                    
       7300-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  16690000
      *  7350-CANCEL-PNDNG-CARD                                      *  16700000
      ****************************************************************  16710000
       7350-CANCEL-PNDNG-CARD.                                          
           MOVE '7350'  TO WS-ABEND-PARAGRAPH.                          
           EXEC SQL                                                     
                UPDATE CSS_PNDNG_CARD_PMT                               
                 SET STATUS_CODE        = 'X'                           
                    ,CANCELLED_TS       = CIS.CURRENT$TIMESTAMP()             
A02714              ,PMT_CANCEL_REAS_CD = 'BC'                          
                WHERE  ACCOUNT_NO     = :PC-ACCOUNT-NO                  
                AND    PAYMENT_DATE   = IIF(TRY_CONVERT(DATE, 
                                                       :PC-PAYMENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PC-PAYMENT-DATE
              ) <> 0) OR (LEN(:PC-PAYMENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :PC-PAYMENT-DATE
              ), CONVERT(DATE, :PC-PAYMENT-DATE) )                
                AND    PAYMENT_AMT    = :PC-PAYMENT-AMT                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_PNDNG_CARD_PMT                               12170000
MFA-TR*          SET STATUS_CODE        = 'X'                                   
MFA-TR*             ,CANCELLED_TS       = CURRENT TIMESTAMP                     
MFA-TR*             ,PMT_CANCEL_REAS_CD = 'BC'                                  
MFA-TR*         WHERE  ACCOUNT_NO     = :PC-ACCOUNT-NO                  12180000
MFA-TR*         AND    PAYMENT_DATE   = :PC-PAYMENT-DATE                12190000
MFA-TR*         AND    PAYMENT_AMT    = :PC-PAYMENT-AMT                 12200000
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-SQLCODE.                                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               PERFORM 7405-INSERT-CARD-CAN-TRNS-HIST THRU 7405-EXIT    
           ELSE                                                         
               STRING 'ERROR UPDATING CSS_PNDNG_CARD_PMT     **'        
                                       DELIMITED BY SIZE                
                                       INTO  WS-ERR-MSG1                
               STRING 'ACCOUNT-NO = ' WS-PC-ACCOUNT-NO,                 
                                       DELIMITED BY SIZE                
                      'PAYMENT-DATE =' WS-PC-PAYMT-DATE                 
                                       DELIMITED BY SIZE                
                                       INTO  WS-ERR-MSG2                
               STRING 'SQLCODE =    '  WS-SQLCODE                       
                                       DELIMITED BY SIZE                
                                       INTO    WS-ERR-MSG3              
                PERFORM 8900-DISPLAY-ERR-MSG  THRU 8900-EXIT            
           END-IF.                                                      
       7350-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  16690000
      *  7400-INSERT-CARD-UPD-TRNS-HIST.                                16700000
      ****************************************************************  16710000
       7400-INSERT-CARD-UPD-TRNS-HIST.                                  
           MOVE '7400'  TO WS-ABEND-PARAGRAPH.                          
           PERFORM 7410-SELECT-TIMESTAMP THRU 7410-EXIT.                
      ** DATA FOR CSS_MNT_TRANS_HIST                                            
           MOVE WS-CURRENT-TS             TO MH-TRANS-HIST-SEQ-NO.      
           MOVE WS-F                      TO MH-CODE-TRAN-TYPE.         
           MOVE SPACES                    TO MH-RESP-AREA-ID.           
           MOVE PC-ACCOUNT-NO             TO MH-ACCOUNT-NO.             
           MOVE 0                         TO MH-CUSTOMER-NO.            
           MOVE 0                         TO MH-PREMISE-NO.             
           MOVE 'SYSTEM'                  TO MH-USER-ID.                
           MOVE +37                       TO MH-TRAN-COMMENT-LEN.       
           MOVE WS-CARD-TRANS-CMNT        TO MH-TRAN-COMMENT-TEXT.      
           MOVE WS-APPL-PRG-ID            TO MH-APPL-PROGRAM-ID.        
                                                                        
      ** DATA FOR CSS_MT_TRN_HST_DET                                            
           MOVE WS-CURRENT-TS             TO MI-TRANS-HIST-SEQ-NO.      
           MOVE 1                         TO MI-TRAN-APPL-NO.           
           MOVE 'PAYMENT AMOUNT'          TO MI-COLUMN-DESC.            
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE +20                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE WS-PRE-CARD-AMT           TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE +20                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE WS-CUR-CARD-AMT           TO MI-CHG-COLUMN-VALUE-TEXT.  
      *                                                                         
           PERFORM 7420-INSERT-MN-TRANS-HIST  THRU 7420-EXIT.           
           PERFORM 7430-INSERT-MN-TRN-HST-DET THRU 7430-EXIT.           
      *                                                                         
           MOVE 2                         TO MI-TRAN-APPL-NO.           
           MOVE 'PAYMENT DATE'            TO MI-COLUMN-DESC.            
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE +10                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE PC-PAYMENT-DATE           TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE +10                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE PC-PAYMENT-DATE           TO MI-CHG-COLUMN-VALUE-TEXT.  
           PERFORM 7430-INSERT-MN-TRN-HST-DET THRU 7430-EXIT.           
      *                                                                         
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16690000
      *  7405-INSERT-CARD-CAN-TRNS-HIST.                                16700000
      ****************************************************************  16710000
       7405-INSERT-CARD-CAN-TRNS-HIST.                                  
           MOVE '7405'  TO WS-ABEND-PARAGRAPH.                          
           PERFORM 7410-SELECT-TIMESTAMP THRU 7410-EXIT.                
      ** DATA FOR CSS_MNT_TRANS_HIST                                            
           MOVE WS-CURRENT-TS             TO MH-TRANS-HIST-SEQ-NO.      
           MOVE WS-F                      TO MH-CODE-TRAN-TYPE.         
           MOVE SPACES                    TO MH-RESP-AREA-ID.           
           MOVE PC-ACCOUNT-NO             TO MH-ACCOUNT-NO.             
           MOVE 0                         TO MH-CUSTOMER-NO.            
           MOVE 0                         TO MH-PREMISE-NO.             
           MOVE 'SYSTEM'                  TO MH-USER-ID.                
           MOVE +37                       TO MH-TRAN-COMMENT-LEN.       
           MOVE WS-CARD-TRANS-CMNT        TO MH-TRAN-COMMENT-TEXT.      
           MOVE WS-APPL-PRG-ID            TO MH-APPL-PROGRAM-ID.        
                                                                        
      ** DATA FOR CSS_MT_TRN_HST_DET                                            
           MOVE WS-CURRENT-TS             TO MI-TRANS-HIST-SEQ-NO.      
           MOVE 1                         TO MI-TRAN-APPL-NO.           
           MOVE 'PREVENT PAYMENT'         TO MI-COLUMN-DESC.            
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE +2                        TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE 'NO'                      TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE +3                        TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'YES'                     TO MI-CHG-COLUMN-VALUE-TEXT.  
      *                                                                         
           PERFORM 7420-INSERT-MN-TRANS-HIST  THRU 7420-EXIT.           
           PERFORM 7430-INSERT-MN-TRN-HST-DET THRU 7430-EXIT.           
                                                                        
       7405-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  16690000
      *  7410-SELECT-TIMESTAMP.                                      *  16700000
      ****************************************************************  16710000
       7410-SELECT-TIMESTAMP.                                           
           MOVE '7410'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TS   = CURRENT TIMESTAMP                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE                    
                               WS-SQLCODE.                              
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               STRING ' ERROR SELECTING CURRENT TIMESTAMP **'           
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG1               
               STRING 'SQLCODE =    ' WS-SQLCODE                        
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
               PERFORM 8900-DISPLAY-ERR-MSG  THRU 8900-EXIT             
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7420 INSERT A ROW INTO CSS_MNT_TRANS_HIST                      *        
      ******************************************************************        
       7420-INSERT-MN-TRANS-HIST.                                       
           MOVE '7420'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_MNT_TRANS_HIST                          
                     ( TRANS_HIST_SEQ_NO,                               
                       DATE_TRANS,                                      
                       CODE_TRAN_TYPE,                                  
                       RESP_AREA_ID,                                    
                       ACCOUNT_NO,                                      
                       CUSTOMER_NO,                                     
                       PREMISE_NO,                                      
                       USER_ID,                                         
                       APPL_PROGRAM_ID,                                 
                       TRAN_COMMENT,                                    
                       ENTITY_KEY_DESC)                                 
                VALUES                                                  
                     ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
                       CAST(SYSDATETIMEOFFSET() AS DATE),                       
                       :MH-CODE-TRAN-TYPE,                              
                       :MH-RESP-AREA-ID,                                
                       :MH-ACCOUNT-NO,                                  
                       :MH-CUSTOMER-NO,                                 
                       :MH-PREMISE-NO,                                  
                       :MH-USER-ID,                                     
                       :MH-APPL-PROGRAM-ID,                             
                       :MH-TRAN-COMMENT,                                
                       :MH-ENTITY-KEY-DESC)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MNT_TRANS_HIST                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO,                                       
MFA-TR*                DATE_TRANS,                                              
MFA-TR*                CODE_TRAN_TYPE,                                          
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                PREMISE_NO,                                              
MFA-TR*                USER_ID,                                                 
MFA-TR*                APPL_PROGRAM_ID,                                         
MFA-TR*                TRAN_COMMENT,                                            
MFA-TR*                ENTITY_KEY_DESC)                                         
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                CURRENT DATE,                                            
MFA-TR*                :MH-CODE-TRAN-TYPE,                                      
MFA-TR*                :MH-RESP-AREA-ID,                                        
MFA-TR*                :MH-ACCOUNT-NO,                                          
MFA-TR*                :MH-CUSTOMER-NO,                                         
MFA-TR*                :MH-PREMISE-NO,                                          
MFA-TR*                :MH-USER-ID,                                             
MFA-TR*                :MH-APPL-PROGRAM-ID,                                     
MFA-TR*                :MH-TRAN-COMMENT,                                        
MFA-TR*                :MH-ENTITY-KEY-DESC)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE                      
                             WS-SQLCODE.                                
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'ERROR INSERTING INTO CSS_MNT_TRANS_HIST  **'     
                                        DELIMITED BY SIZE               
                                        INTO WS-ERR-MSG1                
               STRING 'ACCOUNT-NO= '    WS-PC-ACCOUNT-NO                
                                        DELIMITED BY SIZE               
                                        INTO WS-ERR-MSG2                
               STRING 'SQLCODE =   '    WS-SQLCODE                      
                                        DELIMITED BY SIZE               
                                        INTO  WS-ERR-MSG3               
              PERFORM 8900-DISPLAY-ERR-MSG THRU 8900-EXIT               
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7430 INSERT A ROW INTO CSS_MT_TRN_HST_DET                               
      ******************************************************************        
       7430-INSERT-MN-TRN-HST-DET.                                      
           MOVE '7430'  TO WS-ABEND-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_MT_TRN_HST_DET                          
                     ( TRANS_HIST_SEQ_NO,                               
                       TRAN_APPL_NO,                                    
                       COLUMN_DESC,                                     
                       TABLE_ID,                                        
                       PRV_COLUMN_VALUE,                                
                       CHG_COLUMN_VALUE)                                
                VALUES                                                  
                     ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),               
                       :MI-TRAN-APPL-NO,                                
                       :MI-COLUMN-DESC,                                 
                       :MI-TABLE-ID,                                    
                       :MI-PRV-COLUMN-VALUE,                            
                       :MI-CHG-COLUMN-VALUE)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MT_TRN_HST_DET                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO,                                       
MFA-TR*                TRAN_APPL_NO,                                            
MFA-TR*                COLUMN_DESC,                                             
MFA-TR*                TABLE_ID,                                                
MFA-TR*                PRV_COLUMN_VALUE,                                        
MFA-TR*                CHG_COLUMN_VALUE)                                        
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MI-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :MI-TRAN-APPL-NO,                                        
MFA-TR*                :MI-COLUMN-DESC,                                         
MFA-TR*                :MI-TABLE-ID,                                            
MFA-TR*                :MI-PRV-COLUMN-VALUE,                                    
MFA-TR*                :MI-CHG-COLUMN-VALUE)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE                    
                               WS-SQLCODE.                              
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'ERROR INSERTING INTO CSS_MT_TRN_HIST_DET **'     
                                       DELIMITED BY SIZE                
                                       INTO   WS-ERR-MSG1               
               STRING 'ACCOUNT-NO= '   WS-PC-ACCOUNT-NO                 
                                       DELIMITED BY SIZE                
                                       INTO   WS-ERR-MSG2               
               STRING 'SQLCODE =    '  WS-SQLCODE                       
                                       DELIMITED BY SIZE                
                                       INTO   WS-ERR-MSG3               
              PERFORM 8900-DISPLAY-ERR-MSG THRU 8900-EXIT               
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08880000
      *    7600-START-FCSJC01                                        ** 08890000
      *    7610-READ-FCSJC01                                         ** 08890000
      *    7611-CLOSE                                                ** 08890000
      *                                                              ** 08900000
      ***************************************************************** 08930000
      *                                                                 08760000
           EXEC SQL                                                     11960000
               INCLUDE CPD00038                                         11970000
           END-EXEC.                                                    11980000
      *                                                                 08800000
      ******************************************************************        
      *                                                                *        
      *   8000-PRINT-PRT33-HDR.                                        *        
      *   IT WRITES THE PRE-AUTO-CARD AMOUNT UPDATE REPORT HEADER      *        
      ******************************************************************        
       8000-PRINT-REP-HDR.                                              
                                                                        
           WRITE PRT33-RECORD FROM WS-RPT-HEADER-1                      
                 AFTER ADVANCING TOP-OF-PAGE.                           
           WRITE PRT33-RECORD FROM WS-RPT-HEADER-2                      
                 AFTER ADVANCING 1 LINE.                                
           ADD +1 TO WS-RPT1-PAGE-NO.                                   
           MOVE WS-RPT1-PAGE-NO TO P-RPT-PAGE-NO.                       
           WRITE PRT33-RECORD FROM WS-RPT-HEADER-3                      
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33-RECORD FROM WS-PRINT-REP-HDR-1                   
                 AFTER ADVANCING 3 LINE.                                
           WRITE PRT33-RECORD FROM WS-PRINT-REP-HDR-2                   
                 AFTER ADVANCING 1 LINE.                                
           MOVE ZEROES TO WS-RPT1-LINE-NO.                              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   8010-PRINT-PRT331-HDR.                                       *        
      *   IT WRITES THE CARD PAYMENT AMOUNT NOT EQUAL TO BILL BALANCE  *        
      *            REPORT HEADER                                       *        
      ******************************************************************        
       8010-PRINT-REP2-HDR.                                             
                                                                        
           WRITE PRT331-RECORD FROM WS-RPT-HEADER-1                     
                 AFTER ADVANCING TOP-OF-PAGE.                           
           WRITE PRT331-RECORD FROM WS-RPT2-HEADER-2                    
                 AFTER ADVANCING 1 LINE.                                
           ADD +1 TO WS-RPT2-PAGE-NO.                                   
           MOVE WS-RPT2-PAGE-NO TO P-RPT2-PAGE-NO.                      
           WRITE PRT331-RECORD FROM WS-RPT2-HEADER-3                    
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT331-RECORD FROM WS-PRINT-REP2-HDR-1                 
                 AFTER ADVANCING 3 LINE.                                
           WRITE PRT331-RECORD FROM WS-PRINT-REP-HDR-2                  
                 AFTER ADVANCING 1 LINE.                                
           MOVE ZEROES TO WS-RPT2-LINE-NO.                              
      *                                                                         
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *   8400-MOVE-PRINT1-FIELDS.                                   *          
      *       MOVES THE DETAILS INTO THE PRINT FIELDS FOR REPORT1    *          
      ****************************************************************          
      *                                                                         
       8400-MOVE-PRINT1-FIELDS.                                         
                                                                        
           MOVE PC-ACCOUNT-NO          TO P-RPT1-ACC-NUMB.              
           MOVE PC-PAYMENT-DATE        TO P-RPT1-PAY-DATE.              
           MOVE PC-PAYMENT-AMT         TO P-RPT1-PAY-AMT.               
           MOVE AT-TOTAL-AR-BALANCE    TO P-RPT1-AR-BALANCE.            
                                                                        
           IF AT-TOTAL-AR-BALANCE < 0                                   
              MOVE 0 TO P-RPT1-UPDATE-AMT                               
           ELSE                                                         
              MOVE AT-TOTAL-AR-BALANCE TO P-RPT1-UPDATE-AMT             
           END-IF.                                                      
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   8410-MOVE-PRINT2-FIELDS.                                   *          
      *       MOVES THE DETAILS INTO THE PRINT FIELDS FOR REPORT1    *          
      ****************************************************************          
      *                                                                         
       8410-MOVE-PRINT2-FIELDS.                                         
                                                                        
           MOVE PC-ACCOUNT-NO          TO P-RPT2-ACC-NUMB.              
           MOVE PC-PAYMENT-DATE        TO P-RPT2-PAY-DATE.              
           MOVE PC-PAYMENT-AMT         TO P-RPT2-PAY-AMT.               
           MOVE AT-TOTAL-AR-BALANCE    TO P-RPT2-AR-BALANCE.            
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8500-END-DATA-PARA.                                      **          
      **       WRITES END OF THE REPORT LINE.                       **          
      ****************************************************************          
       8500-END-DATA-PARA.                                              
                                                                        
           IF WS-DATA-REPORT1 = 'N'                                     
              PERFORM 8000-PRINT-REP-HDR    THRU 8000-EXIT              
              WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER             
                 ADVANCING 2 LINES                                      
             END-IF                                                     
           IF WS-DATA-REPORT2 = 'N'                                     
              PERFORM 8010-PRINT-REP2-HDR     THRU 8010-EXIT            
              WRITE PRT331-RECORD FROM WS-NO-DATA-LINE AFTER            
                    ADVANCING 2 LINES                                   
           END-IF                                                       
              WRITE PRT33-RECORD FROM  WS-END-DATA-LINE AFTER           
                    ADVANCING 2 LINES.                                  
              WRITE PRT331-RECORD FROM WS-END-DATA-LINE AFTER           
                    ADVANCING 2 LINES.                                  
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   8600-WRITE-FCSPT33                                           *        
      *        WRITES THE RECORD INTO THE REPORT FILE                  *        
      *                                                                *        
      ******************************************************************        
       8600-WRITE-FCSPT33.                                              
      *                                                                         
           IF WS-DATA-REPORT1 = 'N'                                     
              PERFORM 8000-PRINT-REP-HDR         THRU 8000-EXIT         
              PERFORM 8400-MOVE-PRINT1-FIELDS THRU 8400-EXIT            
              MOVE ZEROES TO WS-RPT1-LINE-NO                            
              MOVE 'Y' TO  WS-DATA-REPORT1                              
           END-IF.                                                      
           IF WS-RPT1-LINE-NO > 50                                      
              PERFORM 8000-PRINT-REP-HDR         THRU 8000-EXIT         
              MOVE ZEROES TO WS-RPT1-LINE-NO                            
           END-IF                                                       
           PERFORM 8400-MOVE-PRINT1-FIELDS THRU 8400-EXIT               
           WRITE PRT33-RECORD FROM WS-PRINT-REP-DET-1                   
                 AFTER  ADVANCING 1 LINE                                
           ADD 1 TO WS-RPT1-LINE-NO.                                    
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   8610-WRITE-FCSPT331                                          *        
      *        WRITES THE RECORD INTO THE REPORT FILE                  *        
      *                                                                *        
      ******************************************************************        
       8610-WRITE-FCSPT331.                                             
      *                                                                         
           IF WS-DATA-REPORT2 = 'N'                                     
              PERFORM 8010-PRINT-REP2-HDR     THRU 8010-EXIT            
              PERFORM 8410-MOVE-PRINT2-FIELDS THRU 8410-EXIT            
              MOVE ZEROES TO WS-RPT2-LINE-NO                            
              MOVE 'Y' TO  WS-DATA-REPORT2                              
           END-IF                                                       
           IF WS-RPT2-LINE-NO > 50                                      
              PERFORM 8010-PRINT-REP2-HDR     THRU 8010-EXIT            
              MOVE ZEROES                     TO WS-RPT2-LINE-NO        
           END-IF                                                       
           PERFORM 8410-MOVE-PRINT2-FIELDS    THRU 8410-EXIT            
           WRITE PRT331-RECORD FROM WS-PRINT-REP2-DET-1                 
                 AFTER  ADVANCING 1 LINE                                
           ADD 1 TO WS-RPT2-LINE-NO.                                    
                                                                        
       8610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8900-DISPLAY-ERR-MSG.                                       **        
      **                                                              **        
      ******************************************************************        
       8900-DISPLAY-ERR-MSG.                                            
                                                                        
           DISPLAY '                                   '.               
           DISPLAY ' ******************************************'.       
           DISPLAY ' **     PCSAC113 PROCESSING ERROR         **'.      
           DISPLAY ' ** CURRENT PARAGRAPH=' WS-ABEND-PARAGRAPH   .      
           DISPLAY ' **' WS-ERR-MSG1.                                   
           DISPLAY ' **' WS-ERR-MSG2.                                   
           DISPLAY ' **' WS-ERR-MSG3.                                   
           DISPLAY ' **       PROCESSING TERMINATED           **'.      
           DISPLAY ' ******************************************'.       
                                                                        
           PERFORM 9900-ABEND  THRU 9900-EXIT.                          
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-TERMINATE.                                                         
      ******************************************************************        
       9000-TERMINATE.                                                  
           IF WS-OPEN-CUR = 'Y'                                         
              PERFORM 7200-CLOSE-PNDNG-CARD-CUR THRU 7200-EXIT          
           END-IF.                                                      
           CLOSE FCSPT33-FILE.                                          
           CLOSE FCSPT331-FILE.                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16690000
      *  9900-ABEND.                                                 *  16700000
      ****************************************************************  16710000
           EXEC SQL                                                     16740000
               INCLUDE CPD09900                                         16750000
           END-EXEC.                                                    16760000
