       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSAC112.                                          
       AUTHOR.       RICK SPIRES.                                       
       DATE-WRITTEN. OCT 2009.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **   THIS PROGRAM LOADS NEW TABLE CSS_PNDNG_CARD_PMT FROM       **        
      **   THE FCSBE90 FILE WHICH IS CREATED IN THE PRIOR STEP FROM   **        
      **   BILL PRINT FILE FCSBE28.                                   **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **                PROGRAM  MODIFICATION  LOG                    **        
      ******************************************************************        
      **   DATE    USER ID  REASON                                    **        
      ** --------  -------  ------                                    **        
      ** 10/20/09  RS40309  INITIAL IMPLEMENTATION.                   **        
A02714** 01/11/12  AP40911  ADD CREDIT CARD PAYMENT CANCEL REASON.    **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSBE90.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD FCSBE90-FILE                                                  
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD                                   
           DATA RECORD IS FCSBE90-REC.                                  
       01 FCSBE90-REC                       PIC X(80).                  
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC112'.
MSQ017     COPY MFASQLM.
      ******************************************************************        
      *                                                                *        
      *             'WORKING STORAGE FOR PCSAC112 STARTS HERE'.        *        
      ******************************************************************        
                                                                        
       01  WS-START                        PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSAC112 STARTS HERE'.            
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-FBE90-STATUS                  PIC X(02) VALUE '00'.   
                       88  FBE90-READ-OK                  VALUE '00'    
                                                                '04'.   
           05  WS-END-OF-BE90                  PIC X      VALUE 'N'.    
               88  END-OF-BE90                            VALUE 'Y'.    
                                                                        
       01  WS-VARIABLES.                                                
           05  WS-PARM-COMP-NO             PIC X(02).                   
           05  WS-NULL-IND-01              PIC S9(4)  COMP VALUE 0.     
           05  WS-NULL-IND-02              PIC S9(4)  COMP VALUE 0.     
           05  WS-NULL-IND-03              PIC S9(4)  COMP VALUE 0.     
           05  WS-ACCOUNT-NO               PIC S9(13)V COMP-3 VALUE 0.  
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-1                        PIC 9(01)  VALUE 1.          
           05  WS-ERR-MSG                  PIC X(100).                  
           05  WS-CURRENT-TS               PIC X(26).                   
                                                                        
       01  WS-CONSTANTS.                                                
           05  WS-PGRMNAME                 PIC X(8)   VALUE 'PCSAC112'. 
           05  PROGRAM-NAME                PIC X(8)   VALUE 'PCSAC112'. 
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-PROCESS-SW                   PIC 9(01)  VALUE 1.      
               88  PROCESS-CSR                            VALUE 1.      
               88  PROCESS-SEB                            VALUE 2.      
           05  WS-ACCOUNT-SW                   PIC 9(01)  VALUE 0.      
               88  ACCOUNT-FOUND                          VALUE 1.      
               88  ACCOUNT-NOTFND                         VALUE 2.      
                                                                        
      ******************************************************************        
      **                                                              **        
      ** WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS             **        
      **                                                              **        
      ******************************************************************        
      /*****   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
      /*****   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      /*****   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
      /*****   WS AREA FOR INPUT FILE.                                          
       COPY FIOEXT90.                                                           
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSAC112 START HERE '.               
      ******************************************************************        
      **                                                              **        
      **  TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS     **        
      **  (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM     **        
      **  WILL ALWAYS BE SQLCA.                                       **        
      **                                                              **        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCOUNT                                                             
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      /                                                                         
      / CSS_ACCT_ATTRIBUTE (PREFIX = YP)                                        
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACTATT                                                 
           END-EXEC.                                                            
      /                                                                         
      / CSS_DELINQUENCY                                                         
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      /                                                                         
      / CSS_PNDNG_CARD_PMT                                                      
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBPNDCRD                                                 
           END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PROCESSING OF PROGRAM                   **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION  THRU 0100-EXIT.                 
           PERFORM 1000-PROCESS-ACCOUNT THRU 1000-EXIT.                 
           PERFORM 9000-TERMINATE       THRU 9000-EXIT.                 
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      COMMON INITIALIZATION ROUTINE                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
           PERFORM 0150-OPEN-FILES                                      
              THRU 0150-EXIT.                                           
                                                                        
      *****************************************************************         
      * CHECK CSS_DELINQUENCY TABLE TO DETERMINE IF SCEG/PSNC OR SEB  *         
      * ACCOUNT --                                                    *         
      *****************************************************************         
      *                                                                         
           MOVE 'DATABASE'                    TO C8-DELINQ-CD.          
           MOVE WS-PARM-COMP-NO               TO C8-COMPANY-NO.         
           PERFORM 7400-CALL-DELIQUENCY       THRU 7400-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-1                       TO WS-PROCESS-SW          
           ELSE                                                         
              MOVE C8-DELINQ-VALUE            TO WS-PROCESS-SW          
           END-IF.                                                      
                                                                        
           PERFORM 7200-GET-CURRENT-TIMESTAMP THRU 7200-EXIT.           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  0150-OPEN-FILES                                             **        
      **                                                              **        
      ******************************************************************        
       0150-OPEN-FILES.                                                 
      *---------------*                                                         
           MOVE '0150'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           OPEN INPUT FCSBE90-FILE.                                     
           IF FBE90-READ-OK                                             
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  '** FILE OPEN ERROR FCSBE90  **' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FBE90-STATUS                          DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
                                                                        
       0150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      **  1000-PROCESS-ACCOUNT                                      **          
      **      READ INPUT BE90 FILE AND WRITE ROWS TO CSS_PNDNG_CARD_**          
      **      CSS_PNDNG_CARD_PMT TABLE                              **          
      ****************************************************************          
       1000-PROCESS-ACCOUNT.                                            
      *---------------*                                                         
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 7000-READ-FCSBE90            THRU 7000-EXIT.         
      *                                                                         
           PERFORM UNTIL END-OF-BE90                                    
              MOVE EXT-AUTOCARD-ACCOUNT-NO      TO PC-ACCOUNT-NO        
              PERFORM 8000-SELECT-PC            THRU 8000-EXIT          
              IF ACCOUNT-FOUND                                          
                IF EXT-AUTOCARD-PAYMENT-DATE = PC-PAYMENT-DATE          
                   PERFORM 8300-DELETE-PC       THRU 8300-EXIT          
                ELSE                                                    
                   PERFORM 8100-CANCEL-PC       THRU 8100-EXIT          
                END-IF                                                  
              END-IF                                                    
              PERFORM 2000-FORMAT-PC            THRU 2000-EXIT          
              PERFORM 8200-INSERT-PC            THRU 8200-EXIT          
              PERFORM 7000-READ-FCSBE90         THRU 7000-EXIT          
           END-PERFORM                                                  
           .                                                            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **  2000-FORMAT-PC                                              **        
      **      FORMATS DATA FOR CSS_PNDNG_CARD_PMT                     **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2000-FORMAT-PC.                                                  
      *---------------*                                                         
           MOVE '2000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE EXT-AUTOCARD-ACCOUNT-NO        TO PC-ACCOUNT-NO         
           MOVE EXT-AUTOCARD-PAYMENT-DATE      TO PC-PAYMENT-DATE       
           MOVE EXT-AUTOCARD-AMOUNT            TO PC-PAYMENT-AMT        
           MOVE 'A'                            TO PC-STATUS-CODE        
           MOVE WS-CURRENT-TS                  TO PC-CREATED-TS         
           MOVE SPACES                         TO PC-EXTRACTED-TS       
           MOVE SPACES                         TO PC-PYMT-POSTED-TS     
           MOVE SPACES                         TO PC-CANCELLED-TS       
           MOVE -1                             TO WS-NULL-IND-01        
           MOVE -1                             TO WS-NULL-IND-02        
           MOVE -1                             TO WS-NULL-IND-03        
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7000-READ-FCSBE90.                                               
      *---------------*                                                         
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           READ FCSBE90-FILE INTO EXT-AUTO-CARD-REC                     
               AT END                                                   
                  MOVE WS-Y   TO WS-END-OF-BE90.                        
           IF FBE90-READ-OK OR END-OF-BE90                              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSAC112 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBE90        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBE90-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      **  7200-GET-CURRENT-TIMESTAMP.                           **              
      **      GETS THE CURRENT TIMESTAMP FROM CSS_MODEL_SQL.    **              
      ************************************************************              
                                                                        
       7200-GET-CURRENT-TIMESTAMP.                                      
      *---------------*                                                         
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT TIMESTAMP                                         
MFA-TR*        INTO   :WS-CURRENT-TS                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '************** PCSAC112 ************'            
              DISPLAY '7200-GET-CURRENT-TIMESTAMP'                      
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**         PROCESSING TERMINATED         **'     
              DISPLAY '************** PCSAC112 ************'            
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DETERMINES IF WE ARE PROCESS SCEG/PSNC OR SEB                           
      ******************************************************************        
       7400-CALL-DELIQUENCY.                                            
      *---------------*                                                         
           MOVE '7400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                SELECT DELINQ_VALUE                                     
                  INTO :C8-DELINQ-VALUE                                 
                  FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
                 WHERE DELINQ_CD = :C8-DELINQ-CD                        
                   AND COMPANY_NO = :C8-COMPANY-NO                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DELINQ_VALUE                                             
MFA-TR*           INTO :C8-DELINQ-VALUE                                         
MFA-TR*           FROM CSS_DELINQUENCY                                          
MFA-TR*          WHERE DELINQ_CD = :C8-DELINQ-CD                                
MFA-TR*            AND COMPANY_NO = :C8-COMPANY-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************** PCSAC112 ************'           
               DISPLAY 'ERROR IN 7400-CALL-DELINQUENCY'                 
               DISPLAY 'SQLCODE ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY 'PROCESSING TERMINATED  '                        
               DISPLAY '************** PCSAC112 ************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT CSS_PNDNG_CARD_PMT TABLE ROWS                           *        
      *----------------------------------------------------------------*        
       8000-SELECT-PC.                                                  
      *---------------------*                                                   
           MOVE '8000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE 0                        TO WS-ACCOUNT-SW               
           MOVE EXT-AUTOCARD-ACCOUNT-NO  TO PC-ACCOUNT-NO               
                                                                        
           EXEC SQL                                                     
              SELECT PAYMENT_DATE                                       
                    ,PAYMENT_AMT                                        
              INTO :PC-PAYMENT-DATE                                     
                  ,:PC-PAYMENT-AMT                                      
              FROM CSS_PNDNG_CARD_PMT WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :PC-ACCOUNT-NO                         
                 AND STATUS_CODE = 'A'                                  
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PAYMENT_DATE                                               
MFA-TR*             ,PAYMENT_AMT                                                
MFA-TR*       INTO :PC-PAYMENT-DATE                                             
MFA-TR*           ,:PC-PAYMENT-AMT                                              
MFA-TR*       FROM CSS_PNDNG_CARD_PMT                                           
MFA-TR*       WHERE ACCOUNT_NO = :PC-ACCOUNT-NO                                 
MFA-TR*          AND STATUS_CODE = 'A'                                          
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              SET ACCOUNT-FOUND TO TRUE                                 
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              SET ACCOUNT-NOTFND TO TRUE                                
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSAC112 PROCESSING ERROR           **'     
              DISPLAY '**   DELETE FROM PC TABLE FAILED         **'     
              DISPLAY '**   SQLCODE WAS: ', WS-ACTIVE-RETURN-CODE       
              DISPLAY ' ACCOUNT = ', PC-ACCOUNT-NO                      
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF                                                       
           END-IF                                                       
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CANCELS CSS_PNDNG_CARD_PMT TABLE ROWS                          *        
      *----------------------------------------------------------------*        
       8100-CANCEL-PC.                                                  
      *---------------------*                                                   
           MOVE '8100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE EXT-AUTOCARD-ACCOUNT-NO  TO PC-ACCOUNT-NO               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PNDNG_CARD_PMT                                 
                 SET STATUS_CODE        = 'X'                           
                    ,CANCELLED_TS       = CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )                
A02714              ,PMT_CANCEL_REAS_CD = 'BC'                          
              WHERE ACCOUNT_NO = :PC-ACCOUNT-NO                         
                 AND STATUS_CODE = 'A'                                  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PNDNG_CARD_PMT                                         
MFA-TR*          SET STATUS_CODE        = 'X'                                   
MFA-TR*             ,CANCELLED_TS       = :WS-CURRENT-TS                        
MFA-TR*             ,PMT_CANCEL_REAS_CD = 'BC'                                  
MFA-TR*       WHERE ACCOUNT_NO = :PC-ACCOUNT-NO                                 
MFA-TR*          AND STATUS_CODE = 'A'                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSAC112 PROCESSING ERROR           **'     
              DISPLAY '**   DELETE FROM PC TABLE FAILED         **'     
              DISPLAY '**   SQLCODE WAS: ', WS-ACTIVE-RETURN-CODE       
              DISPLAY ' ACCOUNT = ', PC-ACCOUNT-NO                      
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *   8200-INSERT-PC                                              *         
      *                                                               *         
      *   PERFORMS DB2 INSERT OF CSS_PNDNG_CARD_PMT                   *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8200-INSERT-PC.                                                  
      *---------------*                                                         
           MOVE '8200'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_PNDNG_CARD_PMT                            
                    (ACCOUNT_NO,                                        
                     PAYMENT_DATE,                                      
                     PAYMENT_AMT,                                       
                     STATUS_CODE,                                       
                     CREATED_TS,                                        
                     EXTRACTED_TS,                                      
                     PYMT_POSTED_TS,                                    
                     CANCELLED_TS)                                      
              VALUES                                                    
                    (:PC-ACCOUNT-NO,                                    
                     IIF(TRY_CONVERT(DATE, :PC-PAYMENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PC-PAYMENT-DATE
              ) <> 0) OR (LEN(:PC-PAYMENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :PC-PAYMENT-DATE
              ), CONVERT(DATE, :PC-PAYMENT-DATE) ),                            
                     :PC-PAYMENT-AMT,                                   
                     :PC-STATUS-CODE,                                   
                     CIS.CHAR2TIMESTAMP(:PC-CREATED-TS),                        
                     CIS.CHAR2TIMESTAMP(:PC-EXTRACTED-TS :WS-NULL-IND-01
              ),                   
                     CIS.CHAR2TIMESTAMP(:PC-PYMT-POSTED-TS 
                                        :WS-NULL-IND-02),                 
                     CIS.CHAR2TIMESTAMP(:PC-CANCELLED-TS :WS-NULL-IND-03
              ))                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_PNDNG_CARD_PMT                                    
MFA-TR*             (ACCOUNT_NO,                                                
MFA-TR*              PAYMENT_DATE,                                              
MFA-TR*              PAYMENT_AMT,                                               
MFA-TR*              STATUS_CODE,                                               
MFA-TR*              CREATED_TS,                                                
MFA-TR*              EXTRACTED_TS,                                              
MFA-TR*              PYMT_POSTED_TS,                                            
MFA-TR*              CANCELLED_TS)                                              
MFA-TR*       VALUES                                                            
MFA-TR*             (:PC-ACCOUNT-NO,                                            
MFA-TR*              :PC-PAYMENT-DATE,                                          
MFA-TR*              :PC-PAYMENT-AMT,                                           
MFA-TR*              :PC-STATUS-CODE,                                           
MFA-TR*              :PC-CREATED-TS,                                            
MFA-TR*              :PC-EXTRACTED-TS:WS-NULL-IND-01,                           
MFA-TR*              :PC-PYMT-POSTED-TS:WS-NULL-IND-02,                         
MFA-TR*              :PC-CANCELLED-TS:WS-NULL-IND-03)                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSAC112 PROCESSING ERROR           **'     
              DISPLAY '**   INSERT TO PC TABLE FAILED           **'     
              DISPLAY '**   SQLCODE WAS: ', WS-ACTIVE-RETURN-CODE       
              DISPLAY ' ACCOUNT = ', PC-ACCOUNT-NO                      
              DISPLAY ' PAYMENT DT  =  ', PC-PAYMENT-DATE               
              DISPLAY ' PC RECORD = ', DCLCSS-PNDNG-CARD-PMT            
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETE CSS_PNDNG_CARD_PMT TABLE ROWS                           *        
      *----------------------------------------------------------------*        
       8300-DELETE-PC.                                                  
      *---------------------*                                                   
           MOVE '8300'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE EXT-AUTOCARD-ACCOUNT-NO  TO PC-ACCOUNT-NO               
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_PNDNG_CARD_PMT                             
              WHERE ACCOUNT_NO = :PC-ACCOUNT-NO                         
                AND STATUS_CODE = 'A'                                   
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSAC112 PROCESSING ERROR           **'     
              DISPLAY '**   DELETE FROM PC TABLE FAILED         **'     
              DISPLAY '**   SQLCODE WAS: ', WS-ACTIVE-RETURN-CODE       
              DISPLAY ' ACCOUNT = ', PC-ACCOUNT-NO                      
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF                                                       
           .                                                            
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
       8900-DISPLAY-ERR-TERM.                                           
      *---------------------*                                                   
           DISPLAY '                                   '.               
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSAC112 PROCESSING ERROR        **'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**       PROCESSING TERMINATED          **'.        
           DISPLAY '******************************************'.        
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  9000-TERMINATE                                            **          
      **       PROGRAM WRAP UP                                      **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBE90-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
