       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSAC110.                                            
       AUTHOR. SIVARAJAN.                                               
       DATE-WRITTEN. MARCH 2008.                                        
                                                                        
      ******************************************************************00060000
      * READ THE FLAT FILE FIOBE59 AND INSERT OR DELETE THE RECORD     *00071007
      * INTO CSS_PNDNG_BNK_DRFT ACCORDINGLY.                           *00080000
      ******************************************************************00090000
      *                                                                *00100000
      ******************************************************************00110000
      ***          M O D I F I C A T I O N   H I S T O R Y           ***00120000
      ******************************************************************00130000
      *                                                              ***00140000
      *  WHO      WHEN        WHAT                                   ***00150000
      *--------------------------------------------------------------***00160000
T35152*  CVNS     03/14/2008  BILL REDESIGN                          ***00180007
T35152*  CHENNAI                                                     ***00181007
      *--------------------------------------------------------------***00190000
       ENVIRONMENT DIVISION.                                            
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSBE59.                                                    00251007
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       COPY CFDBE59.                                                    00310409
       COPY FIOBE59.                                                    00311007
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSAC110'.
MSQ017     COPY MFASQLM.
      *************************                                         00340000
       01  WS-MISC-FIELDS.                                              
           05  WS-PGRMNAME               PIC X(08)  VALUE 'PCSAC110'.   
      *                                                                 00370000
       01  WS-LITERALS.                                                 
           05  WS-INS-DEL-FLAG           PIC X(01) VALUE SPACES.        
           05  WS-DRAFT-DATE             PIC X(10).                     
           05  WS-INS-DEL-FLSG           PIC X(01) VALUE SPACES.        
           05  WS-N                      PIC X(01) VALUE 'N'.           
           05  WS-Y                      PIC X(01) VALUE 'Y'.           
           05  RS-RETURN-CODE-DISP       PIC S9(9)  VALUE +000.         
           05  RS-RETURN-CODE            PIC S9(9)  VALUE +000.         
      *                                                                 00470000
       01  WS-COUNTERS.                                                 
           05  WS-DEL-COUNTER-DISP       PIC  ZZZZZZ99.                 
           05  WS-INST-COUNTER-DISP      PIC  ZZZZZZ99.                 
           05  WS-EPAY-COUNTER-DISP      PIC  ZZZZZZ99.                 
           05  WS-TOT-COUNTER-DISP       PIC  ZZZZZZ99.                 
           05  WS-TOT-CNTR-DISP          PIC  ZZZZZZ99.                 
           05  WS-INST-AMT-DISP          PIC  ZZZZZZZZ99.99.            
           05  WS-INST-AMOUNT-DISP       PIC  ZZZZZZZZ99.99.            
           05  WS-EPAY-AMOUNT-DISP       PIC  ZZZZZZZZ99.99.            
           05  WS-DEL-AMOUNT-DISP        PIC  ZZZZZZZZ99.99.            
           05  WS-DEL-AMT-DISP           PIC  ZZZZZZZZ99.99.            
COB305     05 WS-DELETE-COUNTER        PIC S9(07) COMP-3 VALUE 0.             
COB305     05 WS-TOTAL-COUNTER        PIC S9(07) COMP-3 VALUE 0.             
COB305     05 WS-INSERT-COUNTER        PIC S9(07) COMP-3 VALUE 0.             
COB305     05 WS-EPAY-COUNTER        PIC S9(07) COMP-3 VALUE 0.             
COB305     05 WS-INSERT-AMOUNT        PIC S9(09)V9(2) COMP-3 VALUE 0.        
COB305     05 WS-DELETE-AMOUNT        PIC S9(09)V9(2) COMP-3 VALUE 0.        
COB305     05 WS-EPAY-AMOUNT        PIC S9(09)V9(2) COMP-3 VALUE 0.        
COB305     05 WS-TOTAL-AMOUNT        PIC S9(09)V9(2) COMP-3 VALUE 0.        
      *                                                                 00580000
       01  WS-SWITCHES.                                                 
           05  WS-FBE59-STATUS           PIC X(02)  VALUE '00'.         
               88 FIOBE59-SUCCESSFUL                VALUE '00'.         
                                                                        
           05  WS-END-OF-JOB-SW          PIC  X(01) VALUE 'N'.          
               88  END-OF-FILE                      VALUE 'Y'.          
      *                                                                 00650000
       01  WS-PRINT-MESSAGE-AREA.                                       
           05  WS-SUCCESFULL-RUN-MSG.                                   
               10  FILLER                PIC X(49)  VALUE               
                   'PCSAC110  HAS COMPLETED SUCCESSFULLY - THERE ARE '. 
               10  FILLER                PIC X(9)   VALUE 'NO ERRORS'.  
      *                                                                 00710000
                                                                        
       COPY CWS00021.                                                   00720000
       COPY CWS00038.                                                   00730000
       COPY FIOJC01.                                                    00740000
       COPY CWS0070B.                                                   00750000
       COPY CWS09900.                                                   00760000
       COPY CWS00303.                                                   00770000
      *                                                                 00780000
           EXEC SQL                                                     00790000
               INCLUDE SQLCA                                            00800000
           END-EXEC.                                                    00810000
      *                                                                 00820000
           EXEC SQL                                                     00830000
               INCLUDE CWS00010                                         00840000
           END-EXEC.                                                    00850000
      *                                                                 00860000
           EXEC SQL                                                     00870000
               INCLUDE TBJBPARM                                         00880000
           END-EXEC.                                                    00890000
      *                                                                 00900000
           EXEC SQL                                                     00910000
               INCLUDE TBPDBKDF                                         00920000
           END-EXEC.                                                    00930000
      *                                                                 00940000
      ******************************************************************00941000
       PROCEDURE DIVISION.                                              
      ******************************************************************00951000
      ***************                                                   00961000
       0000-MAINLINE.                                                   
      ***************                                                   00971000
           PERFORM 1000-INITIALIZATION  THRU 1000-EXIT.                 
           PERFORM 1200-PROCESS-DRAFT-HEADER THRU 1200-EXIT             
           PERFORM 1300-PROCESS-PARA                                    
                   THRU 1300-EXIT UNTIL END-OF-FILE                     
           PERFORM 9000-TERMINATE       THRU 9000-EXIT                  
           DISPLAY '        ***********************              '      
           DISPLAY  'TOTAL INSERTED REC FOR THIS RUN ==>'               
                    WS-INST-COUNTER-DISP                                
           DISPLAY  'TOTAL DELETED  REC FOR THIS RUN ==>'               
                    WS-DEL-COUNTER-DISP                                 
           DISPLAY  'TOTAL REAL TIME NOT DELETED THIS RUN ==>'          
                    WS-EPAY-COUNTER-DISP                                
           DISPLAY '        ***********************              '      
           DISPLAY   WS-SUCCESFULL-RUN-MSG                              
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01100000
      *1000-INITIALIZATION                                             *01110000
      *        COMMON INITIALIZATION ROUTINE                           *01120000
      ******************************************************************01130000
      ************************                                          01131000
       1000-INITIALIZATION.                                             
      ************************                                          01141000
                                                                        
           MOVE '1000' TO WS-ACTIVE-PARAGRAPH                           
           MOVE ZEROS  TO WS-INSERT-AMOUNT                              
           MOVE ZEROS  TO WS-DELETE-AMOUNT                              
           MOVE ZEROS  TO WS-EPAY-AMOUNT                                
           MOVE ZEROS  TO WS-TOTAL-AMOUNT                               
           MOVE ZEROS  TO WS-INSERT-COUNTER                             
           MOVE ZEROS  TO WS-DELETE-COUNTER                             
           MOVE ZEROS  TO WS-EPAY-COUNTER                               
           MOVE ZEROS  TO WS-TOTAL-COUNTER                              
                                                                        
           OPEN INPUT  FCSBE59-FILE                                     
                                                                        
           IF FIOBE59-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '************* PCSAC110 *******************'     
               DISPLAY '** PCSAC110 PROCESSING ERROR            **'     
               DISPLAY '*  OPEN  ERROR ON FIOBE59               **'     
               DISPLAY '*  FILE STATUS = ' WS-FBE59-STATUS              
               DISPLAY '*         PROCESSING TERMINATED         **'     
               DISPLAY '************* PCSAC110 *******************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           DISPLAY 'OPEN INPUT  FCSBE59-FILE SUCCESS'                   
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                   
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES     TO WS-INPUT-AREA                          
              MOVE SPACES     TO WS-INPUT-DATA-BREAKDOWN                
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
              MOVE 'PCSAC110' TO WS-PGRMNAME                            
                                                                        
              MOVE WS-INPUT-DATE(1:2) TO WS-CENTURY                     
           END-IF                                                       
           PERFORM 1100-READ-FIOBE59    THRU 1100-EXIT                  
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ********************                                              01531000
       1100-READ-FIOBE59.                                               
      ********************                                              01541000
                                                                        
           MOVE '1100' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           READ FCSBE59-FILE AT END                                     
                SET END-OF-FILE TO TRUE                                 
           END-READ                                                     
                                                                        
           IF FIOBE59-SUCCESSFUL                                        
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '************* PCSAC110 *******************'     
               DISPLAY '** PCSAC110 PROCESSING ERROR            **'     
               DISPLAY '*  READ  ERROR ON FIOBE59               **'     
               DISPLAY '*  FILE STATUS = ' WS-FBE59-STATUS              
               DISPLAY '*         PROCESSING TERMINATED         **'     
               DISPLAY '************* PCSAC110 *******************'     
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ************************************************************      01760000
      *   1200-PROCESS-DRAFT-HEADER                                     01770000
      *                                                                 01780000
      ************************************************************      01790000
      ****************************                                      01791000
       1200-PROCESS-DRAFT-HEADER.                                       
      ****************************                                      01801000
           IF END-OF-FILE                                               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF (E-FBE59-KEY-BREC IS NOT EQUAL LOW-VALUES)             
                  DISPLAY '1ST RECORD MUST BE BANKDRAFT FILE HEADER. '  
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              ELSE                                                      
                  MOVE E-FBE59-CREATE-DATE-BREC TO WS-DRAFT-DATE        
                  IF WS-INPUT-DATE NOT = WS-DRAFT-DATE                  
                     DISPLAY '**                           ** '         
                     DISPLAY '** PCSAC110 PROCESSING ERROR **'          
                     DISPLAY '** DATE ON BANKDRAFT HEADER = '           
                     WS-DRAFT-DATE                                      
                     DISPLAY '** DOES NOT MATCH RUN DATE = '            
                     WS-INPUT-DATE                                      
                     DISPLAY '** PROCESSING TERMINATED     **'          
                     PERFORM 9900-ABEND THRU 9900-EXIT                  
                  END-IF                                                
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************                                           02091000
       1250-LOAD-PARA.                                                  
      ***********************                                           02101000
           IF E-FBE59-KEY-EREC  = HIGH-VALUES                           
              COMPUTE WS-TOTAL-COUNTER = WS-EPAY-COUNTER +              
                      WS-INSERT-COUNTER + WS-DELETE-COUNTER             
              MOVE WS-INSERT-COUNTER TO WS-INST-COUNTER-DISP            
              MOVE WS-DELETE-COUNTER TO WS-DEL-COUNTER-DISP             
              MOVE WS-EPAY-COUNTER   TO WS-EPAY-COUNTER-DISP            
                                                                        
              IF WS-TOTAL-COUNTER = E-FBE59-RECORD-COUNT-EREC           
                 IF WS-INSERT-AMOUNT = E-FBE59-INSERT-AMOUNT            
                    IF E-FBE59-DELETE-AMOUNT = (WS-DELETE-AMOUNT +      
                                                WS-EPAY-AMOUNT)         
                       MOVE WS-Y TO WS-END-OF-JOB-SW                    
                    ELSE                                                
                        MOVE E-FBE59-DELETE-AMOUNT TO WS-DEL-AMOUNT-DISP
                        MOVE WS-DELETE-AMOUNT TO WS-DEL-AMT-DISP        
                        MOVE WS-EPAY-AMOUNT   TO WS-EPAY-AMOUNT-DISP    
                        DISPLAY '**************************************'
                        DISPLAY '* MISMATCH IN THE DELETE AMOUNT     **'
                        DISPLAY 'TOTAL DELETING AMOUNT FROM FILE ===>'  
                                 WS-DEL-AMOUNT-DISP                     
                        DISPLAY 'TOTAL AMT DELETED FROM TABLE ======>'  
                                 WS-DEL-AMT-DISP                        
                        DISPLAY 'TOTAL EPAY AMOUNT FROM TABLE ======>'  
                                 WS-EPAY-AMOUNT-DISP                    
                        DISPLAY '**************************************'
                        PERFORM 9900-ABEND THRU 9900-EXIT               
                    END-IF                                              
                 ELSE                                                   
                     MOVE E-FBE59-INSERT-AMOUNT TO WS-INST-AMOUNT-DISP  
                     MOVE WS-INSERT-AMOUNT      TO WS-INST-AMT-DISP     
                     DISPLAY '*****************************************'
                     DISPLAY '** MISMATCH IN THE INSERT AMOUNT      ***'
                     DISPLAY 'TOTAL INSERT AMOUNT FROM FILE ==> '       
                              WS-INST-AMOUNT-DISP                       
                     DISPLAY 'TOTAL AMT INSERTED INTO TABLE ==> '       
                              WS-INST-AMT-DISP                          
                     DISPLAY '*****************************************'
                     PERFORM 9900-ABEND THRU 9900-EXIT                  
                 END-IF                                                 
              ELSE                                                      
                 MOVE E-FBE59-RECORD-COUNT-EREC TO WS-TOT-COUNTER-DISP  
                 MOVE WS-TOTAL-COUNTER      TO WS-TOT-CNTR-DISP         
                 DISPLAY '*********************************************'
                 DISPLAY '** MISMATCH IN THE TOTAL NO OF RECORD **'     
                 DISPLAY 'TOTAL NO OF RECORD FROM FILE  ============>'  
                           WS-TOT-COUNTER-DISP                          
                 DISPLAY 'TOT REC INSERTED AND DELETED FROM TABLE ==>'  
                           WS-TOT-CNTR-DISP                             
                 DISPLAY '*********************************************'
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           ELSE                                                         
               MOVE E-FBE59-ACCOUNT-NO     TO PB-ACCOUNT-NO             
               MOVE E-FBE59-DRAFT-DATE     TO PB-DRAFT-DATE             
               MOVE E-FBE59-DRAFT-AMT      TO PB-DRAFT-AMT              
               MOVE E-FBE59-TRANSACTION-CD TO PB-TRANSACTION-CD         
               MOVE E-FBE59-CODE-SOURCE-ID TO PB-CODE-SOURCE-ID         
               MOVE E-FBE59-BANK-SEQ-NO    TO PB-CUST-BANK-SEQ-NO       
               MOVE E-FBE59-INS-DEL-FLAG   TO WS-INS-DEL-FLAG           
           END-IF                                                       
           .                                                            
       1250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************                                           02501000
       1300-PROCESS-PARA.                                               
      ***********************                                           02511000
           PERFORM 1100-READ-FIOBE59    THRU 1100-EXIT                  
           PERFORM 1250-LOAD-PARA THRU 1250-EXIT                        
           IF END-OF-FILE                                               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-INS-DEL-FLAG = 'I'                                  
                 ADD 1 TO WS-INSERT-COUNTER                             
                 ADD PB-DRAFT-AMT TO WS-INSERT-AMOUNT                   
                 PERFORM 2000-INSERT-PNDNG-DRAFT THRU 2000-EXIT         
              END-IF                                                    
                                                                        
              IF WS-INS-DEL-FLAG = 'D'                                  
                 IF PB-CODE-SOURCE-ID = 'E'                             
                    ADD 1 TO WS-EPAY-COUNTER                            
                    ADD PB-DRAFT-AMT TO WS-EPAY-AMOUNT                  
                 ELSE                                                   
                    ADD 1 TO WS-DELETE-COUNTER                          
                    ADD PB-DRAFT-AMT TO WS-DELETE-AMOUNT                
                    PERFORM 2001-DELETE-PND-DRAFT THRU 2001-EXIT        
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************                                           02711000
       2000-INSERT-PNDNG-DRAFT.                                         
      ***********************                                           02721000
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_PNDNG_BNK_DRFT                           
                      (ACCOUNT_NO,                                      
                       DRAFT_AMT,                                       
                       DRAFT_DATE,                                      
                       TRANSACTION_CD,                                  
                       CUST_BANK_SEQ_NO,                                
                       CODE_SOURCE_ID)                                  
               VALUES                                                   
                      (:PB-ACCOUNT-NO,                                  
                       :PB-DRAFT-AMT,                                   
                       IIF(TRY_CONVERT(DATE, :PB-DRAFT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PB-DRAFT-DATE
              ) <> 0) OR (LEN(:PB-DRAFT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :PB-DRAFT-DATE
              ), CONVERT(DATE, :PB-DRAFT-DATE) ),                              
                       :PB-TRANSACTION-CD,                              
                       :PB-CUST-BANK-SEQ-NO,                            
                       :PB-CODE-SOURCE-ID)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02740000
MFA-TR*        INSERT INTO CSS_PNDNG_BNK_DRFT                           02750000
MFA-TR*               (ACCOUNT_NO,                                      02760000
MFA-TR*                DRAFT_AMT,                                       02770000
MFA-TR*                DRAFT_DATE,                                      02780000
MFA-TR*                TRANSACTION_CD,                                  02790000
MFA-TR*                CUST_BANK_SEQ_NO,                                02791000
MFA-TR*                CODE_SOURCE_ID)                                  02800000
MFA-TR*        VALUES                                                   02810000
MFA-TR*               (:PB-ACCOUNT-NO,                                  02820000
MFA-TR*                :PB-DRAFT-AMT,                                   02830000
MFA-TR*                :PB-DRAFT-DATE,                                  02840000
MFA-TR*                :PB-TRANSACTION-CD,                              02850000
MFA-TR*                :PB-CUST-BANK-SEQ-NO,                            02851000
MFA-TR*                :PB-CODE-SOURCE-ID)                              02860000
MFA-TR*    END-EXEC.                                                    02870000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE WS-PGRMNAME                TO ABEND-PROGRAM         
               MOVE '2000'                     TO ABEND-FUNCTION        
               MOVE 'CSS_PNDNG_BNK_DRFT'       TO TABLE-1               
               MOVE 'ACCOUNT-NO'               TO TABLE-ELEMENT-1       
               MOVE PB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF                
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************                                           03011000
       2001-DELETE-PND-DRAFT.                                           
      ***********************                                           03021000
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_PNDNG_BNK_DRFT                           
                WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                       
                   AND DRAFT_DATE = IIF(TRY_CONVERT(DATE, :PB-DRAFT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PB-DRAFT-DATE
              ) <> 0) OR (LEN(:PB-DRAFT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :PB-DRAFT-DATE
              ), CONVERT(DATE, :PB-DRAFT-DATE) )                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03040000
MFA-TR*        DELETE FROM CSS_PNDNG_BNK_DRFT                           03050000
MFA-TR*         WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                       03060000
MFA-TR*            AND DRAFT_DATE = :PB-DRAFT-DATE                      03061000
MFA-TR*    END-EXEC.                                                    03070000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE WS-PGRMNAME                TO ABEND-PROGRAM         
               MOVE '2001'                     TO ABEND-FUNCTION        
               MOVE 'CSS_PNDNG_BNK_DRFT'       TO TABLE-1               
               MOVE 'ACCOUNT-NO'               TO TABLE-ELEMENT-1       
               MOVE PB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT
           END-IF               
           .                                                            
       2001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************                                           03230000
      * 6251-GET-FJC01-DATE                                             03240000
      ***********************                                           03250000
           EXEC SQL                                                     03260000
                INCLUDE CPD00037                                        03270000
           END-EXEC.                                                    03280000
           EXEC SQL                                                     03290000
                INCLUDE CPD00038                                        03300000
           END-EXEC.                                                    03310000
                                                                        
      *****************                                                 03321000
       9000-TERMINATE.                                                  
      *****************                                                 03331000
                                                                        
           CLOSE FCSBE59-FILE                                           
           IF  FIOBE59-SUCCESSFUL                                       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************* PCSAC110 *******************'     
               DISPLAY '* CLOSE  ERROR ON FIOBE59              *'       
               DISPLAY '* FILE STATUS = ' WS-FBE59-STATUS               
               DISPLAY '*         PROCESSING TERMINATED        *'       
               DISPLAY '************* PCSAC110 *******************'     
           END-IF                                                       
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
      *************************************************************     03490000
      * ABEND ROUTINE PERFORMED IF VSAM OR DB2 PROBLEM OCCURS. *        03500000
      * 9900-ABEND                                                *     03510000
      *************************************************************     03520000
                 EXEC SQL                                               03530000
                   INCLUDE CPD0023B                                     03540000
                 END-EXEC.                                              03550000
      ******************************************************************03560000
      *******     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE         03570000
      ******************************************************************03580000
                 EXEC SQL                                               03590000
                   INCLUDE CPD09900                                     03600000
                 END-EXEC.                                              03610000
                                                                        
