       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        MCSSO067.                                     
COB303 DATE-WRITTEN.      FEBRUARY 03, 1995.                            
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  PROGRAM:         MCSSO067                                     *        
      *  CALLING PROGRAM: S025                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS CALLED BY S025 AS PART OF THE SERVICE ORDER   *        
      *  POSTING PROCESS. THIS PROGRAM CONVERTS SERVICE ORDER CHARGES  *        
      *  INTO RECONNECT CHARGES OR CONTRACTS DEPENDING ON THE ORDER    *        
      *  TYPE. CONTRACT DETAILS ARE INSERTED INTO CSS_CONTRACT AND     *        
      *  CSS_CNT_DETAIL TABLES AND RECONNECT DETAILS ARE INSERTED      *        
      *  INTO CSS_CONNECT_CHRG TABLE.                                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/03/96    SK       RPC ORIGINALLY CODED.                    *        
      *  03/11/96    SK       FCS RELATED MODIFICATIONS.               *        
      *  09/04/96    WMG      TPR 5172 - ASSIGN ABEND TABLE            *        
      *                       INFORMATION TO VARIABLES IN THE          *        
      *                       LINKAGE SECTION IN ALL SQL ERROR         *        
      *                       PROCESSING ROUTINES.                     *        
      *  10/23/96    WMG      PCR 212 - OBTAIN THE NEW RCC CODE AND    *        
      *                       SPLIT THE RECONNECT CHARGE BASED ON THE  *        
      *                       NEW RCC CODE.                            *        
      *  12/16/96    AS       TPR 8027- FIXED PROGRAM TO ZERO OUT RCC  *        
      *                       ROWS WITH NEGATIVE AMOUNTS IN CSS_AR_CNTL*        
      *                       WHILE POSTING RECONNECT ORDERS.          *        
      *  12/18/96    AS       TPR 8195- FIXED PROGRAM TO NOT MOVE      *        
      *                       CC-AMT-TRANS TO JOURNAL FIELDS FOR       *        
      *                       NON-RECONNECT SERVICE ORDERS.            *        
      *                                                                *        
      *  01/27/97    CHANDIRA TPR 7931- FIXED AR_LOCKOUT CURSOR        *        
      *                       AND AN ERROR MESSAGE IS RETURNED TO      *        
      *                       THE CALLER, IF THE INDICATOR IS 'N'      *        
      *                                                                *        
      *  02/11/97    DB       TPR 8728 - LABOR CHARGES HAVE CODE 'A'   *        
      *                                                                *        
      *  03/13/97    WMG      TPR 8829 - REMOVE SOME RECONNECT SPECIFIC*        
      *                       LOGIC AND RETRIEVE THE RECONNECT CHARGE  *        
      *                       AMOUNT FROM THE RECONNECT TABLES.        *        
      *  03/17/97    WMG      TPR 9731 - REMOVE THE AR LOCKOUT CHECK   *        
      *                       FROM THIS PROGRAM AND ADD IT TO S025.    *        
      *                       PCR 404  - SPLIT OUT THE JOURNALLING OF  *        
      *                       THE RECONNECT AND SO-CHARGES AMOUNTS.    *        
      *  03/28/97    WMG      PCR 404  - CHANGE THE TRAN TYPE TO 'S'   *        
      *                       FOR 'CHG' AND MOVE THE CORRECT USER TABLE*        
      *                       PROGRAM NAMES TO THE JOURNALLING         *        
      *                       VARIABLES.                               *        
      *  04/07/97    WMG      TPR 10142 - INITIALIZE CJF00101 AND SET  *        
      *                       THE 101 JOURNALLING VARIABLES BEFORE     *        
      *                       CALLING THE JOURNALLING ROUTINES.        *        
      *  04/17/97    WMG      TPR 10463 - POPULATE CASH DRAWER JOURNAL *        
      *                       VARIABLES FOR BOTH E & G RECONNECT       *        
      *                       JOURNALS WHEN THE RECONNECT CHARGES ARE  *        
      *                       SPLIT.                                   *        
      * 01/27/98    SYBASE   CHANGES MADE FOR CTBBIND FOR CHAR AND     *        
      *                       VARCHAR FIELDS. FOR ASE PROBLEM -> SYB   *        
      *  05/27/98    FB       TPR 16573 - ABEND DISPLAYS.              *        
      *  09/24/1998  JVH      TPR 17950 - CITY TAX SHOULD ALWAYS =     *        
      *                       ZERO, AND AREA TAX IS OTHER TAX, NOT CITY*        
      *                       ALSO, MODIFY TO ONLY CREATE ONLY ONE     *        
      *                       AGREGATE CONTRACT DETAIL ROW             *        
      * 10/06/98     PRA      DUPLICATE FOUND IN PARAGRAPH 8300 IS OK  *        
      * 10/22/98     PRA      REMOVED COMPARE OF RECONNECT CHARGE AMT  *        
      *                       FROM USER TABLE (U7) WITH RECONNECT CHRG *        
      *                       AMOUNT FROM RECONNECT AGREEMENT (DL)     *        
      *                       ONLY INSERT CONNECT CHRG & AR TRANS HIST *        
      *                       IF RECONNECT CHARGE IS VALID (NOT '000') *        
      *  12/16/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
      *             MADRAS    ABEND PARAMETERS                         *        
      *  12/17/98    AF       INCLUDED A SELECT MAX ON LAST_UPDATE_TS  *        
      *                       IN PARA 7301 SO THAT MOST RECENT RCC     *        
      *                       WILL BE PULLED IN WHEN POSTING A RECNT   *        
      *  02/04/99    FB       ALLOWED NOT-FOUND WHEN DELETING          *        
      *                       RECONNECT AGREEMENT.                     *        
      *  02/15/99    LO       ADD DISTINCT TO SELECT THAT IS SELECTING *        
      *                       THE RECONNECT AR_CNTL ROWS.              *        
      *  08/19/99    bab      ADDED PARAGRAPH 9000-SEND-ERROR-RESULT.  *        
      *                       COPYBOOKS CPD00003, CPD00006, CPD00008,  *        
      *                       CPD00073 & CPD0010S WERE UPDATED TO      *        
      *                       CALL 9000- WHEN THERE'S AN SQL ERROR.    *        
      *  04/06/00    CBSI     POPULATED REVENUE DISTRICT WHEN CONTRACT *        
      *              CHENNAI  INSERTED INTO CSS_COTRACT                *        
      *  10/11/00    JS       ADDED PARA 7304- AND 7307- TO RESET CDP  *        
      *                       IF THE ROW IN AR_CNTL IS DELETED         *        
      *  04/09/01    CHANELLE MCR310 PSNC.  RECOMPILE FOR CPD00006 AND *        
      *                       CSS_GL_ACCT_NO CHANGES.                  *        
T23235*  06/18/01    COVANSYS ADDED CURSOR TO GET THE MIDDLE DIGIT OF  *        
T23235*              CHENNAI  CODE-REVENUE-CLASS FROM CSS-UTIL-ENVRNMT *        
T23235*              CHENNAI  AND USED IT TO GET RECONNECT INFO.       *        
T25116*  09/20/01    FB       ADD PSNC CONTRACT NAMES / IDS.           *        
T25395*  10/15/01    FB       CORRECT DEBIT G/L.                       *        
C24880*  12/10/02    FB/AS    ESTABLISH SEB 102 CONTRACTS AS CONNECTION*        
C24880*                       CHARGE DFA                               *        
C20053*  09/29/03    FB       INCLUDE CHARGES COMMENTS IN TRANSACTION  *        
C20253*                       HISTORY RECORD.                          *        
C26296*  01/18/05    PRA      AUTOMATED DEPOSITS AT RECONNECT POSTING  *        
C26296*                       ORIG REQ WQ LOGIC COMMENTED OUT          *        
C28237*  06/27/06    VP94820  FIDED SERVICE CHARGES POSTING BASED ON   *        
C28237*                       WORK PERIOD - PSNC GL PROJECT            *        
C33924*  10/02/06    FB       UNCOMMENT RECONNECT CHARGE LOGIC.        *00322700
REARCH*  01/16/07    PA       SO REARRCH MODIFICATIONS                 *        
REARCH*                       CONVERT OPEN CLIENT CALLS TO DB2 CALLS   *        
C36210*  12/10/07    FB       AGL SERVICE ESTABLISHMENT FEES.          *00322700
C37033*  02/29/08  SK42147    CHANGES TO GET CORRECT CONTRACT ITEM ID  *00322700
C36587*  06/03/08  SS19371    ADD FACTORS FOR ESTABLISHMENT AND        *00322700
C36587*                       RECONNECT CHARGE TAX FEES                *00322700
C37422*  10/03/08  SS19371    ADD COMMENTS FOR RECONNECT CHARGE TAX    *00322700
C37422*                       AND USE COMMONDATE FOR START DATE        *00322700
A37061*  03/12/09  FB         GET ACCOUNT_TYPE_CD FROM CSS_ACCOUNT.    *00322700
A00956*  02/04/09  SP94986    REPLACED CPD00006 WITH CPD0006A          *        
A37741*  11/14/09  SB93596    DECLARED  S-RETURN-CODE                  *        
A37741*                       RESPECTIVE TO CPD00067 CHANGES          **        
A37666*  12/03/09  FB         CLEAN UP MAINTENANCE TRANSHIST.          *00322700
A00479*  04/12/10  DB18339    ADDED CODE TO PREVENT -803 ERROR.        *00322700
P00641*  05/01/12  DB41297    GET GL-ACCT-NAME-DESC FROM CSS_GL_ACCT_NO*        
P00794*  05/28/14  DB18339    ADDED RECCHGTAX FOR PSNC ACCOUNTS        *        
A04880*  08/14/14  DB18339    ADDED PARAMETER FOR CSR03515.            *        
P00794*  09/15/14  DB18339    CHANGED RESP AREA TO SPACES ON RECCHGTAX *        
P00794*                       TRANSACTION HISTORY.                     *        
AC501G*  03/26/15  DB18339    ADDED GET TIMESTAMP BEFORE WRITING TO MNT*        
AC501G*                       TRANS HISTORY in 5505 and 5630.          *        
ACT109*  05/23/15  RS7M249    DELETE UNUSED COPYBOOK(S).               *        
AC501G*  06/30/15  DB18339    ADDED CODES DATA PRESENT CHANGE FOR SEB  *        
AC501G*                       CONNECT CHARGE.                          *        
ACT097*  04/15/16  MC95456    REMOVED UNUSED COPY BOOKS.               *        
A05317*  10/14/16    FMB      REMOVE UNUSED CONTACT COLUMNS AND        *        
A05317*                       CCA00001.                                *        
P01137*  03/01/17    FMB      OPTIMIZATION. INITIALIZE INDEXES.       *         
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'MCSSO067'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR MCSSO067 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---< CSS_ACCOUNT        - AT >                                           
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_PREMISE        - PR >                                           
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_CUSTOMER       - CU >                                           
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_CONTRACT       - CT >                                           
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_CONTRACT_INFO  - K6 >                                           
           EXEC SQL                                                             
              INCLUDE TBCNTINF                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_CNT_DETAIL     - EA >                                           
           EXEC SQL                                                             
              INCLUDE TBCNTDET                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_AR_CNTL        - AC >                                           
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_USER_PROFILE   - PF >                                           
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_CONNECT_CHRG   - CC >                                           
           EXEC SQL                                                             
              INCLUDE TBCCCHRG                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_AR_TRANS_HIST  - AR >                                           
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_AR_TRN_HST_DET - AU >                                           
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_CSH_DRWR_JRNL  - CJ >                                           
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_CSH_DRWR_CNTL  - CS >                                           
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_BCH_JRNL_CNTL  - BC >                                           
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_BATCH_JRNL     - BJ >                                           
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_MISC_JRNL      - MJ >                                           
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_GL_ACCT_NO     - GO >                                           
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_RECONNECT_CHRG - U7 >                                           
           EXEC SQL                                                             
              INCLUDE TBRCNCHR                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_DELINQUENCY    - C8 >                                           
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_RECONNECT      - DL >                                           
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
                                                                        
C24880     EXEC SQL                                                             
C24880        INCLUDE TBCHGTYP                                                  
C24880     END-EXEC.                                                            
C24880                                                                  
C24880     EXEC SQL                                                             
C24880        INCLUDE TBDFAACT                                                  
C24880     END-EXEC.                                                            
C24880                                                                  
C24880     EXEC SQL                                                             
C24880        INCLUDE TBDFARCV                                                  
C24880     END-EXEC.                                                            
                                                                        
C26296*---< CSS_MNT_TRANS_HIST - MH >                                           
C26296     EXEC SQL                                                             
C26296        INCLUDE TBMNHIST                                                  
C26296     END-EXEC.                                                            
                                                                        
C26296*---< CSS_MT_TRN_HST-DET - MI >                                           
C26296     EXEC SQL                                                             
C26296        INCLUDE TBMNHDT                                                   
C26296     END-EXEC.                                                            
                                                                        
C26296*---< CSS_CRED_COLL      - CL  >                                          
C26296     EXEC SQL                                                             
C26296         INCLUDE TBCRCOLL                                                 
C26296     END-EXEC.                                                            
                                                                        
C28237*---< CSS_SO_SERVICE_CHG - SV  >                                          
C28237     EXEC SQL                                                             
C28237         INCLUDE TBSRVCHG                                                 
C28237     END-EXEC.                                                            
                                                                        
C36587**************************************************************            
C36587* CSS_SO_ORDER_INST, VI                                                   
C36587**************************************************************            
C36587     EXEC SQL                                                             
C36587         INCLUDE TBSOODR                                                  
C36587     END-EXEC.                                                            
                                                                        
C36587**************************************************************            
C36587* CSS_BILL_WINDOW, BN                                                     
C36587**************************************************************            
C36587     EXEC SQL                                                             
C36587         INCLUDE TBBILWDW                                                 
C36587     END-EXEC.                                                            
                                                                        
C36587**************************************************************            
C36587* CSS_FIXED_FACTOR, FF                                                    
C36587**************************************************************            
C36587     EXEC SQL                                                     01420000
C36587        INCLUDE TBFXDFCT                                          01430000
C36587     END-EXEC.                                                    01440000
                                                                        
      ******************************************************************        
      * COBOL WORKING STORAGE COPY BOOKS                               *        
      ******************************************************************        
                                                                        
      * ERROR HANDLING                                                          
           COPY CWS00010.                                                       
                                                                        
      * ERROR WORK AREA - SUPPORTS ONLINE / CSR JOURNALS                        
           COPY CWS00027.                                                       
                                                                        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
                                                                        
      * WORKING STORAGE FOR GL-MNEMONICS AND GL-NUMBERS                         
           COPY CWS00061.                                                       
                                                                        
      * COMMON JOURNAL WORKING STORAGE                                          
           EXEC SQL                                                             
A00956        INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
           COPY CJF00101.                                                       
           COPY CJF00102.                                                       
           COPY CJF00103.                                                       
           COPY CJF00113.                                                       
                                                                        
      * WORKING STORAGE FOR CODES-DATA-PRESENT (MF)                             
           COPY CWS00056.                                                       
                                                                        
      * WORKING STORAGE FOR SO-CODES-DATA-PRESENT                               
           COPY CWS00059.                                                       
                                                                        
      *****************************************************************         
      * WORK AREAS                                                    *         
      *****************************************************************         
                                                                        
REARCH 01  PROGRAM-NAME                 PIC X(08) VALUE 'MCSSO067'.     
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-PROC                 POINTER.                        
           05  GWL-INIT-HANDLE          POINTER.                        
           05  GWL-RC                   PIC S9(9) COMP.                 
           05  GWL-STATUS-NR            PIC S9(9) COMP.                 
           05  GWL-STATUS-DONE          PIC S9(9) COMP.                 
           05  GWL-STATUS-COUNT         PIC S9(9) COMP.                 
           05  GWL-STATUS-COMM          PIC S9(9) COMP.                 
           05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                 
           05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 
                                                                        
       01  CS-LIB-MISC-FIELDS.                                          
           05  WS-CSL-CMD-HANDLE       PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-CON-HANDLE       PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-CTX-HANDLE       PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-NULL             PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-RC               PIC S9(9) COMP.                  
           05  WS-CSL-RESTYPE          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-ITEM-NUM             PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-COPIED               PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-COPIED-NULL          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-INDICATOR            PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-INDICATOR-NULL       PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-NUMROWS              PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RPC-RC               PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RPC-SUCCESS          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RETURN-CODE          PIC S9(9) COMP SYNC VALUE +0.    
                                                                        
A37741 01  S-RETURN-CODE               PIC S9(9) VALUE 0.               
                                                                        
       01  CS-PROPERTY-FIELDS.                                          
           05  WS-SO-CHARGES-RPC     PIC X(23)                          
                VALUE 'csrddat.dbo.pd_D0000250'.                        
           05  WS-SO-RPC-LEN           PIC S9(9) COMP VALUE +23.        
           05  WS-OUTLEN               PIC S9(9) COMP VALUE +0.         
           05  WS-STRLEN               PIC S9(9) COMP VALUE +0.         
           05  WS-MSGLIMIT             PIC S9(9) COMP VALUE +5.         
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ID1                PIC S9(9) COMP VALUE 1.          
                                                                        
       01  WS-DATAFMT.                                                  
           05 WS-NM-PARM               PIC X(132).                      
           05 WS-NMLEM-PARM            PIC S9(9) COMP SYNC.             
           05 WS-DATATYPE-PARM         PIC S9(9) COMP SYNC.             
           05 WS-FORMT-PARM            PIC S9(9) COMP SYNC.             
           05 WS-MAXLENGTH-PARM        PIC S9(9) COMP SYNC.             
           05 WS-SCALE-PARM            PIC S9(9) COMP SYNC.             
           05 WS-PRECISION-PARM        PIC S9(9) COMP SYNC.             
           05 WS-FNTSTATUS-PARM        PIC S9(9) COMP SYNC.             
           05 WS-FMTCOUNT-PARM         PIC S9(9) COMP SYNC.             
           05 WS-USERTYPE-PARM         PIC S9(9) COMP SYNC.             
           05 WS-LOCALE-PARM           PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-DATAFMT-BIND.                                             
           05 WS-NM-BIND               PIC X(132).                      
           05 WS-NMLEM-BIND            PIC S9(9) COMP SYNC.             
           05 WS-DATATYPE-BIND         PIC S9(9) COMP SYNC.             
           05 WS-FORMT-BIND            PIC S9(9) COMP SYNC.             
           05 WS-MAXLENGTH-BIND        PIC S9(9) COMP SYNC.             
           05 WS-SCALE-BIND            PIC S9(9) COMP SYNC.             
           05 WS-PRECISION-BIND        PIC S9(9) COMP SYNC.             
           05 WS-FNTSTATUS-BIND        PIC S9(9) COMP SYNC.             
           05 WS-FMTCOUNT-BIND         PIC S9(9) COMP SYNC.             
           05 WS-USERTYPE-BIND         PIC S9(9) COMP SYNC.             
           05 WS-LOCALE-BIND           PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-SO-CHARGES-TB.                                            
           05 WS-SO-CHARGES-LIST                                        
              OCCURS 20 TIMES INDEXED BY WS-CHRGX.                      
              10  WS-RPC-RETURN-CODE          PIC S9(4) COMP.           
              10  WS-CODE-UTIL-TYPE           PIC X(01).                
              10  WS-STD-LABOR-CHRG           PIC X(11).                
              10  WS-STD-LABOR-CHRG-NUM REDEFINES WS-STD-LABOR-CHRG     
                                              PIC 9(09)V99.             
              10  WS-CALC-LABOR-CHRG          PIC X(11).                
              10  WS-CALC-LABOR-CHRG-NUM REDEFINES WS-CALC-LABOR-CHRG   
                                              PIC 9(09)V99.             
              10  WS-MATERIAL-CHRG            PIC X(11).                
              10  WS-MATERIAL-CHRG-NUM REDEFINES WS-MATERIAL-CHRG       
                                              PIC 9(09)V99.             
              10  WS-OTHER-CHRG               PIC X(11).                
              10  WS-OTHER-CHRG-NUM REDEFINES WS-OTHER-CHRG             
                                              PIC 9(09)V99.             
              10  WS-CHRG-FOR-MATERIAL        PIC X(11).                
              10  WS-CHRG-FOR-MATERIAL-NUM REDEFINES                    
                       WS-CHRG-FOR-MATERIAL   PIC 9(09)V99.             
              10  WS-STATE-TAX                PIC X(11).                
              10  WS-STATE-TAX-NUM REDEFINES WS-STATE-TAX               
                                              PIC 9(09)V99.             
              10  WS-AREA-TAX                 PIC X(11).                
              10  WS-AREA-TAX-NUM REDEFINES WS-AREA-TAX                 
                                              PIC 9(09)V99.             
              10  WS-COMMENTS                 PIC X(35).                
              10  WS-ENDV-ELEC-CHRG           PIC X(11).                
              10  WS-ENDV-ELEC-CHRG-NUM REDEFINES                       
                       WS-ENDV-ELEC-CHRG      PIC 9(09)V99.             
              10  WS-ENDV-GAS-CHRG            PIC X(11).                
              10  WS-ENDV-GAS-CHRG-NUM REDEFINES                        
                       WS-ENDV-GAS-CHRG       PIC 9(09)V99.             
C28237        10  WS-CODE-WORK-PRD            PIC X(01).                
C28237        10  WS-CODE-ACCT-TYPE           PIC X(01).                
      *************************************************************             
      *==>WORKING STORAGE CHG FOR CTBBIND ISSUE SYB 01/27/98   <==*             
      *************************************************************             
       01  WS-SO-CHARGES-TB-BD.                                         
           05  WS-RPC-RETURN-CODE-BD       PIC S9(4) COMP.              
                                                                        
       01  WS-CODE-UTIL-TYPE-BD-01.                                     
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-CODE-UTIL-TYPE-BD        PIC X(01).                   
                                                                        
       01  WS-STD-LABOR-CHRG-BD-01.                                     
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-STD-LABOR-CHRG-BD        PIC X(11).                   
                                                                        
       01  WS-CALC-LABOR-CHRG-BD-01.                                    
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-CALC-LABOR-CHRG-BD       PIC X(11).                   
                                                                        
       01  WS-MATERIAL-CHRG-BD-01.                                      
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-MATERIAL-CHRG-BD         PIC X(11).                   
                                                                        
       01  WS-OTHER-CHRG-BD-01.                                         
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-OTHER-CHRG-BD            PIC X(11).                   
                                                                        
       01  WS-CHRG-FOR-MATERIAL-BD-01.                                  
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-CHRG-FOR-MATERIAL-BD     PIC X(11).                   
                                                                        
       01  WS-STATE-TAX-BD-01.                                          
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-STATE-TAX-BD             PIC X(11).                   
                                                                        
       01  WS-AREA-TAX-BD-01.                                           
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-AREA-TAX-BD              PIC X(11).                   
                                                                        
       01  WS-COMMENTS-BD-01.                                           
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-COMMENTS-BD              PIC X(35).                   
                                                                        
       01  WS-ENDV-ELEC-CHRG-BD-01.                                     
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-ENDV-ELEC-CHRG-BD        PIC X(11).                   
                                                                        
       01  WS-ENDV-GAS-CHRG-BD-01.                                      
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-ENDV-GAS-CHRG-BD         PIC X(11).                   
                                                                        
C28237 01  WS-CODE-WORK-PRD-BD-01.                                      
C28237     05  FILLER                      PIC S9(4) COMP.              
C28237     05  WS-CODE-WORK-PRD-BD         PIC X(01).                   
                                                                        
C28237 01  WS-CODE-ACCT-TYPE-BD-01.                                     
C28237     05  FILLER                      PIC S9(4) COMP.              
C28237     05  WS-CODE-ACCT-TYPE-BD        PIC X(01).                   
      *************************************************************             
      *==>END STORAGE CHG FOR CTBBIND ISSUE SYB 01/27/98       <==*             
      *************************************************************             
                                                                        
       01  WS-DATALEN                      PIC S9(9) COMP SYNC VALUE +0.
       01  WS-INDIC                        PIC S9(9) COMP SYNC VALUE +0.
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-TIMESTAMP        PIC X(26).                   
           05  WS-CURRENT-DATE             PIC X(10).                   
           05  WS-SERV-ORDER-NO-C          PIC X(13) VALUE SPACES.      
           05  WS-CODE-UTIL-TYPE-PREV      PIC X(01).                   
           05  WS-HOLD-CHARGE-AM           PIC S9(09)V9(02) COMP-3      
                                                            VALUE 0.    
           05  WS-TOTAL-RCC-CHARGES        PIC S9(09)V9(02) COMP-3      
                                                            VALUE 0.    
           05  WS-TOTAL-SO-CHARGES         PIC S9(09)V9(02) COMP-3      
                                                            VALUE 0.    
           05  WS-TEMP-TOTAL               PIC S9(09)V9(02) COMP-3      
                                                            VALUE 0.    
COB305     05 WS-GL-ACCT-NO-AR-CNT        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0. 
COB305     05 WS-GL-ACCT-NO-AR-DFA        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0. 
COB305     05 WS-GL-ACCT-NO-AR-CCC        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0. 
           05  WS-CNT-NAME-CD-ELEC         PIC S9(4) USAGE COMP         
                                               VALUE 101.               
           05  WS-CNT-NAME-CD-GAS          PIC S9(4) USAGE COMP         
                                               VALUE 102.               
T25116     05  WS-CNT-NAME-CD-PSNC         PIC S9(4) USAGE COMP         
T25116                                         VALUE 1518.              
           05  WS-CNT-ITEM-ID              PIC S9(09) COMP VALUE 0.     
           05  WS-CCC-ITEM-ID              PIC S9(09) COMP VALUE 0.     
           05  WS-CNT-DET-SEQ-NO           PIC S9(04) COMP VALUE 0.     
           05  WS-AMT-POSTED               PIC S9(07)V99 VALUE ZERO.    
           05  WS-AMT-POSTED-TOTAL         PIC S9(07)V99 VALUE ZERO.    
           05  WS-STATE-TAX-ELEC           PIC S9(07)V99 VALUE ZERO.    
           05  WS-AREA-TAX-ELEC            PIC S9(07)V99 VALUE ZERO.    
           05  WS-STATE-TAX-GAS            PIC S9(07)V99 VALUE ZERO.    
           05  WS-AREA-TAX-GAS             PIC S9(07)V99 VALUE ZERO.    
           05  WS-STATE-TAX-DET            PIC S9(07)V99 VALUE ZERO.    
           05  WS-AREA-TAX-DET             PIC S9(07)V99 VALUE ZERO.    
           05  WS-HOLD-TRAN-BALANCE        PIC S9(09)V99 COMP-3 VALUE 0.
           05  WS-NULL-IND01               PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-IND02               PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-IND03               PIC S9(04) COMP VALUE 0.     
C36587     05  WS-NULL-IND-FF              PIC S9(04) COMP VALUE 0.     
C37422     05  WS-NULL-IND-DUR             PIC S9(04) COMP VALUE 0.     
C37422     05  WS-SETUP-TS.                                             
C37422         10  WS-SETUP-TS-DATE        PIC X(10).                   
C37422         10  WS-SETUP-TS-TIME        PIC X(16)                    
C37422                                       VALUE '-00.00.00.000000'.  
C37422     05  WS-COMMONDATE               PIC X(10).                   
C36587     05  WS-FACT-VAL-Z               PIC -Z(09).9(06).            
C36587     05  WS-FACTOR-TEXT              PIC 9(9).9(6).               
C36587     05  WS-DURATION-TEXT            PIC 9(4).                    
C36587     05  WS-DURA-VAL-Z               PIC Z(04).                   
           05  WS-DATE-ORIG-PYMT-IND       PIC S9(4) COMP VALUE 0.      
           05  WS-AR-SUMMARY-EXISTS        PIC X(01).                   
           05  WS-NO-LOCKOUT-EXISTS        PIC X(01).                   
C24880     05  WS-DATABASE                 PIC 9(1)  VALUE ZERO.        
C24880         88 CSR-DATABASE                       VALUE 1.           
C24880         88 SEB-DATABASE                       VALUE 2.           
           05  SW-RESULTS                  PIC X(01) VALUE 'Y'.         
               88 NO-MORE-RESULTS                    VALUE 'N'.         
               88 MORE-RESULTS                       VALUE 'Y'.         
           05  SW-FETCH                    PIC X(01) VALUE 'Y'.         
               88 NO-MORE-ROWS                       VALUE 'N'.         
               88 MORE-ROWS                          VALUE 'Y'.         
C37422     05  WS-PARTIAL-PREPAY           PIC X(01) VALUE 'N'.         
C37422         88 NO-PARTIAL-PREPAY                  VALUE 'N'.         
C37422         88 PARTIAL-PREPAY                     VALUE 'Y'.         
C37422     05  WS-FULL-PREPAY              PIC X(01) VALUE 'N'.         
C37422         88 NO-PREPAYMENT                      VALUE 'N'.         
C37422         88 FULL-PREPAY                        VALUE 'Y'.         
           05  WS-CASH-DRAWER.                                          
               10  WS-CD-COMPANY-NO        PIC X(02).                   
               10  WS-CD-LOCAL-OFFICE      PIC X(03).                   
               10  WS-CD-REPORT-NO         PIC X(03).                   
               10  WS-CD-REPORT-DATE       PIC X(10).                   
               10  WS-CASH-DRAWER-ID       PIC S9(04) COMP.             
           05  WS-A                        PIC X(01) VALUE 'A'.         
           05  WS-B                        PIC X(01) VALUE 'B'.         
           05  WS-C                        PIC X(01) VALUE 'C'.         
           05  WS-L                        PIC X(01) VALUE 'A'.         
           05  WS-M                        PIC X(01) VALUE 'M'.         
           05  WS-S                        PIC X(01) VALUE 'S'.         
           05  WS-ELEC-ONLY-FLAG           PIC X(01) VALUE 'N'.         
           05  WS-GAS-ONLY-FLAG            PIC X(01) VALUE 'N'.         
           05  WS-ELEC-GAS-FLAG            PIC X(01) VALUE 'N'.         
           05  WS-SPLIT-ELEC               PIC 9(09)V9(2) VALUE 0.      
           05  WS-SPLIT-GAS                PIC 9(09)V9(2) VALUE 0.      
           05  WS-SPLIT-AMT                PIC 9(09)V9(2) VALUE 0.      
           05  WS-REMAIN-AMT               PIC 9(09)V9(2) VALUE 0.      
           05  WS-RECONNECT-CHARGE         PIC 9(09)V9(2) VALUE 0.      
COB305     05 WS-EREV-CCC-GL        PIC S9(3)V9(4) COMP-3 VALUE 0.       
COB305     05 WS-GREV-CCC-GL        PIC S9(3)V9(4) COMP-3 VALUE 0.       
COB305     05 WS-EREV-CCC-GL-HOLD        PIC S9(3)V9(4) COMP-3 VALUE 0.       
COB305     05 WS-GREV-CCC-GL-HOLD        PIC S9(3)V9(4) COMP-3 VALUE 0.       
           05  WS-CRED-CHRG-EXISTS         PIC X(01) VALUE 'N'.         
           05  WS-PROCESS-CHARGES          PIC X(01) VALUE 'N'.         
           05  WS-ORDER-TYPE-CD            PIC X(02) VALUE SPACES.      
           05  WS-RCC-DET-FOUND            PIC X(01) VALUE 'N'.         
           05  DUPLICATE-FOUND             PIC S9(09) VALUE -803 COMP.  
           05  WS-RECNCT-TYPE-CD           PIC X(01) VALUE 'Y'.         
           05  WS-AMT-TRAN-BALANCE-ED      PIC -(9)9.99 .               
           05  WS-AMT-UNUSED-CR-ED         PIC -(9)9.99 .               
           05  WS-CDP                      PIC X(32).                   
           05  WS-UNSET-CDP                PIC X(01) VALUE 'N'.         
T23235     05  WS-CLASS                    PIC X(01) VALUE SPACES.      
T23235     05  WS-ACCT-TYPE-CD             PIC X(01) VALUE SPACES.      
C24880     05  WS-DFA-CODE-UTIL-TYPE       PIC X.                       
C24880     05  WS-DFA-AMOUNT               PIC S9(9)V99 COMP-3 VALUE 0. 
C24880     05  WS-DFA-ITEM-ID              PIC S9(09) COMP   VALUE +0.  
C24880     05  WS-DFA-NULL-IND             PIC S9(04) COMP   VALUE +0.  
C24880     05  WS-DFA-NULL-IND2            PIC S9(04) COMP   VALUE +0.  
C26296     05  WS-USER-ID                  PIC X(07).                   
C26296     05  WS-ACCOUNT-NO-CHAR          PIC X(13).                   
C26296     05  WS-ACCOUNT-NO-NUM   REDEFINES WS-ACCOUNT-NO-CHAR         
C26296                                     PIC 9(13).                   
C26296     05  WS-AUTO-DEP-AM-EDT          PIC $$$$,$$$,$$9.99.         
C26296     05  WS-WQ-COMMENTS              PIC X(47)  VALUE             
C26296         'NO MAXIMUM DEPOSIT CALCULATED FOR AUTO DEPOSIT.'.       
C26296     05  WS-WQ-FREE-FORM-AREA        PIC X(19)  VALUE             
REARCH         'CREATED BY MCSSO067'.                                   
C26296     05  WS-WQ-MF-EXISTS             PIC X(01)  VALUE SPACES.     
C29296         88  WQ-MF-EXISTS                       VALUE 'Y'.        
C26296     05  WS-WQ-EXISTS                PIC X(01)  VALUE SPACES.     
C26296         88  WQ-EXISTS                          VALUE 'Y'.        
C36587     05  WS-EFF-DATE-FROM.                                        
C36587         10  WS-EFF-DATE-FROM-YYYY PIC X(4) VALUE SPACES.         
C36587         10  WS-DASH-1             PIC X(1) VALUE '-'.            
C36587         10  WS-EFF-DATE-FROM-MM   PIC X(2) VALUE SPACES.         
C36587         10  WS-DASH-2             PIC X(1) VALUE '-'.            
C36587         10  WS-EFF-DATE-FROM-DD   PIC X(2) VALUE '01'.           
C36587     05  WS-REVENUE-MONTH-RED      PIC X(6) VALUE SPACES.         
C36587     05  WS-REVENUE-MONTH.                                        
C36587         10  WS-REVENUE-YYYY       PIC X(4) VALUE SPACES.         
C36587         10  WS-REVENUE-MM         PIC X(2) VALUE SPACES.         
C26296 01  TDS-RETURN-FIELDS.                                           
C26296     05  RS-RETURN-CODE              PIC S9(9) COMP VALUE 0.      
                                                                        
C26296 01  WS-CSR03515-RETURN-FIELDS.                                   
C26296     05  WS-3515-RETURN-CODE       PIC S9(09) COMP VALUE 0.       
C26296     05  WS-3515-AUTO-DEP-AMT      PIC S9(09)V99 COMP-3 VALUE 0.  
C26296     05  WS-3515-DEP-SUCCESS       PIC X(01)  VALUE SPACES.       
C26296     05  WS-3515-DEP-CERT-NO       PIC S9(09) COMP VALUE 0.       
C26296     05  WS-3515-MAX-DEP-ZERO-WQ   PIC X(01)  VALUE SPACES.       
C26296     05  WS-3515-AMT-SECURED       PIC S9(09)V99 COMP-3 VALUE 0.  
C26296     05  WS-3515-ABEND-PROGRAM     PIC X(08)  VALUE SPACES.       
C26296     05  WS-3515-ACTIVE-PARAGRAPH  PIC X(04)  VALUE SPACES.       
C26296     05  WS-3515-ABEND-FUNCTION    PIC X(08)  VALUE SPACES.       
C26296     05  WS-3515-TABLE-1           PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-TABLE-ELEMENT-1   PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-HOSTVAR-ELEMENT-1 PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-TABLE-ELEMENT-2   PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-HOSTVAR-ELEMENT-2 PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-TABLE-ELEMENT-3   PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-HOSTVAR-ELEMENT-3 PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-TABLE-ELEMENT-4   PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-HOSTVAR-ELEMENT-4 PIC X(20)  VALUE SPACES.       
C26296***************************************************************           
C26296*    DB2 COMMUNICATION REQUIREMENT *                          *           
C26296***************************************************************           
C26296*01  LOC1                  USAGE IS SQL TYPE IS                   
C26296*                          RESULT-SET-LOCATOR VARYING.            
REARCH*01  LOC2                  USAGE IS SQL TYPE IS                   
REARCH*                          RESULT-SET-LOCATOR VARYING.            
C26296 01  ERROR-MESSAGE.                                               
C26296     02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
C26296     02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
C26296                           INDEXED BY ERROR-INDEX.                
C26296 77  ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.             
C26296 77  TRACE-MESSAGE-AREA    PIC X(256).                            
C26296 77  OPENFN                PIC X(12).                             
C26296 77  SSID                  PIC X(4).                              
C26296 77  PLANNAME              PIC X(8).                              
C26296 77  RETCODE               PIC S9(5).                             
C26296 77  REASCODE              PIC S9(5).                             
C26296 77  CLOSFN                PIC X(12).                             
C26296 77  TERMOP                PIC X(4).                              
                                                                        
C28237 01  WS-SO-CHG-TRN-TYP        PIC X(03) VALUE 'OTH'.              
C28237     88  VALID-FXD-CHG-PROCS  VALUE 'RCC', 'CNT', 'DFA'.          
C28237     88  PROCESS-FXD-CHG-RCC  VALUE 'RCC'.                        
C28237     88  PROCESS-FXD-CHG-CNT  VALUE 'CNT'.                        
C28237     88  PROCESS-FXD-CHG-DFA  VALUE 'DFA'.                        
C28237     88  PROCESS-REGULAR-SO   VALUE 'OTH'.                        
C28237 01  WS-WORK-PERIOD-CD        PIC X(01) VALUE 'N'.                
C28237     88  VLD-FXD-CHG-WK-PRD   VALUE 'Y'.                          
C28237     88  INVLD-FXD-CHG-WK-PRD VALUE 'N'.                          
C36587 01  WS-FACTOR-COMMENT        PIC X(01) VALUE 'N'.                
C36587     88  VLD-COMMENT          VALUE 'Y'.                          
C36587     88  INVLD-COMMENT        VALUE 'N'.
MSQ001        EXEC SQL
MSQ001          DECLARE AUTO-DEP-CR CURSOR
MSQ001          FOR CALL CSR03515                                       
C26296         ( :WS-ACCOUNT-NO-CHAR
                  , 'PCSSO67D'
                  , 'B'
                  , :DL-AUTO-DEP-AM
                  , :WS-USER-ID
                  , 'N'
                  , '          '
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE MATERIAL-CHG CURSOR
MSQ001          FOR CALL CSR00250                                       
REARCH         ( :WS-SERV-ORDER-NO-C
                  )
MSQ001        END-EXEC.
                          
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
REARCH COPY CCA00004.                                                   03560000
                                                                        
REARCH PROCEDURE DIVISION USING CMN-SO100-LINK-AREA.                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9600-TERMINATE-LINK        THRU 9600-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-LOAD-WORK-AREAS       THRU 1100-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-LOAD-WORK-AREAS                                           *        
      ******************************************************************        
       1100-LOAD-WORK-AREAS.                                            
                                                                        
           MOVE LOW-VALUES                    TO WS-DATAFMT             
                                                 WS-DATAFMT-BIND.       
           MOVE CMN-SERV-ORDER-NO             TO WS-SERV-ORDER-NO-C.    
           MOVE CMN-SERV-ORDER-TYPE           TO WS-ORDER-TYPE-CD.      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE                THRU 5000-EXIT.           
                                                                        
C26296* CODE ADDED FOR AUTOMTED DEPOSITS WHEN POSTING RECONNECT ORDERS          
C26296*                                                                         
C26296     IF CMN-SERV-ORDER-TYPE = 'FM006'                             
C26296        IF  DL-AUTO-DEP-CERT-NO = 0 AND DL-AUTO-DEP-AM > 0        
C26296            MOVE CMN-USER-ID                TO WS-USER-ID         
C26296            MOVE CMN-ACCOUNT-NO      TO WS-ACCOUNT-NO-NUM         
C26296            PERFORM 2250-CALL-CSR03515     THRU 2250-EXIT         
C26296*                                                                         
C26296            IF WS-3515-AUTO-DEP-AMT = 0                           
AC501G               PERFORM 7010-GET-TIMESTAMP      THRU 7010-EXIT     
C26296               PERFORM 5505-INS-AUTO-DEP-TRANS-HIST               
C26296                                               THRU 5505-EXIT     
C26296            END-IF                                                
C26296        END-IF                                                    
C26296* DELETE 'O' ROW WITH CODE SPECIAL TYPE 'R' IF THERE IS ONE.              
C26296* THIS IS A ROW CREATED BY AUTO DNP DEPOSIT WITH IMMEDIATE BILL           
C26296* OPTION                                                                  
C26296        MOVE AT-ACCOUNT-NO           TO CL-ACCOUNT-NO             
C26296        MOVE 'O'                     TO CL-CODE-NOTICE-TYPE       
C26296        MOVE 'R'                     TO CL-CODE-SPECIAL-TYPE      
C26296        PERFORM 8710-DELETE-CRED-COLL                             
C26296           THRU 8710-EXIT                                         
C26296     END-IF.                                                      
C26296*                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C26296***************************************************************           
C26296* THIS PARAGRAPH CALLS CSR03515 TO UPDATE THE AUTO DEP AMT    *           
C26296***************************************************************           
C26296 2250-CALL-CSR03515.                                              
C26296                                                                  
C26296*    EXEC SQL CALL CSR03515                                       
C26296*        (:WS-ACCOUNT-NO-CHAR                                     
C26296*        ,'PCSSO67D'                                              
C26296*        ,'B'                                                     
C26296*        ,:DL-AUTO-DEP-AM                                         
C26296*        ,:WS-USER-ID                                             
C26296*        ,'N'                                                     
A04880*        ,'          ')                                           
C26296*    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE AUTO-DEP-CR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN AUTO-DEP-CR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR AUTO-DEP-CR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
C26296      IF  SQLCODE = 466 THEN                                      
C26296*         EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE       
C26296*            CSR03515                                             
C26296*         END-EXEC                                                
C26296*         EXEC SQL                                                
C26296*           ALLOCATE AUTO-DEP-CR CURSOR FOR RESULT SET :LOC1      
C26296*         END-EXEC                                                
C26296                                                                  
C26296          EXEC SQL                                                
C26296            FETCH AUTO-DEP-CR INTO :WS-3515-RETURN-CODE           
C26296                         ,:WS-3515-AUTO-DEP-AMT                   
C26296                         ,:WS-3515-DEP-SUCCESS                    
C26296                         ,:WS-3515-DEP-CERT-NO                    
C26296                         ,:WS-3515-MAX-DEP-ZERO-WQ                
C26296                         ,:WS-3515-AMT-SECURED                    
C26296                         ,:WS-3515-ABEND-PROGRAM                  
C26296                         ,:WS-3515-ACTIVE-PARAGRAPH               
C26296                         ,:WS-3515-ABEND-FUNCTION                 
C26296                         ,:WS-3515-TABLE-1                        
C26296                         ,:WS-3515-TABLE-ELEMENT-1                
C26296                         ,:WS-3515-HOSTVAR-ELEMENT-1              
C26296                         ,:WS-3515-TABLE-ELEMENT-2                
C26296                         ,:WS-3515-HOSTVAR-ELEMENT-2              
C26296                         ,:WS-3515-TABLE-ELEMENT-3                
C26296                         ,:WS-3515-HOSTVAR-ELEMENT-3              
C26296                         ,:WS-3515-TABLE-ELEMENT-4                
C26296                         ,:WS-3515-HOSTVAR-ELEMENT-4              
C26296          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296          IF SQLCODE = SUCCESSFUL-CALL                            
C26296              EVALUATE WS-3515-RETURN-CODE                        
C26296                 WHEN 0                                           
C26296                     CONTINUE                                     
C26296                 WHEN OTHER                                       
C26296                  MOVE '2250'                TO ACTIVE-PARAGRAPH  
C26296                  MOVE 'CSR03515 FAILED'          TO CMN-TABLE-1  
C26296                  MOVE WS-3515-ABEND-PROGRAM      TO CMN-TABLE-2  
C26296                  MOVE WS-3515-TABLE-ELEMENT-1                    
C26296                                          TO CMN-TABLE-ELEMENT-1  
C26296                  MOVE WS-3515-HOSTVAR-ELEMENT-1                  
C26296                                        TO CMN-HOSTVAR-ELEMENT-1  
C26296                  MOVE WS-3515-TABLE-ELEMENT-2                    
C26296                                          TO CMN-TABLE-ELEMENT-2  
C26296                  MOVE WS-3515-HOSTVAR-ELEMENT-2                  
C26296                                        TO CMN-HOSTVAR-ELEMENT-2  
C26296                  MOVE WS-3515-TABLE-ELEMENT-3                    
C26296                                          TO CMN-TABLE-ELEMENT-3  
C26296                  MOVE WS-3515-HOSTVAR-ELEMENT-3                  
C26296                                        TO CMN-HOSTVAR-ELEMENT-3  
C26296                  MOVE WS-3515-TABLE-ELEMENT-4                    
C26296                                          TO CMN-TABLE-ELEMENT-4  
C26296                  MOVE WS-3515-HOSTVAR-ELEMENT-4                  
C26296                                        TO CMN-HOSTVAR-ELEMENT-4  
C26296                  MOVE WS-3515-RETURN-CODE                        
C26296                                        TO WS-ACTIVE-RETURN-CODE  
C26296                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT  
C26296              END-EVALUATE                                        
C26296          ELSE                                                    
C26296              MOVE '2250'                    TO ACTIVE-PARAGRAPH  
C26296              MOVE 'CSR03515 FAILED'              TO CMN-TABLE-1  
C26296              MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE  
C26296              MOVE 'ACCOUNT_NO'           TO CMN-TABLE-ELEMENT-1  
C26296              MOVE WS-ACCOUNT-NO-CHAR   TO CMN-HOSTVAR-ELEMENT-1  
C26296              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
C26296          END-IF                                                  
C26296*                                                                         
C26296          EXEC SQL                                                
C26296             CLOSE AUTO-DEP-CR                                    
C26296          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296*                                                                         
C26296          IF SQLCODE = SUCCESSFUL-CALL                            
C26296             CONTINUE                                             
C26296          ELSE                                                    
C26296             MOVE '2250'                     TO ACTIVE-PARAGRAPH  
C26296             MOVE 'CSR03515 CLOSE FAILED'         TO CMN-TABLE-1  
C26296             MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE  
C26296             MOVE 'ACCOUNT_NO'            TO CMN-TABLE-ELEMENT-1  
C26296             MOVE WS-ACCOUNT-NO-CHAR    TO CMN-HOSTVAR-ELEMENT-1  
C26296             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
C26296          END-IF                                                  
C26296      ELSE                                                        
C26296          MOVE '2250'                     TO ACTIVE-PARAGRAPH     
C26296          MOVE 'CSR03515 CALL FAILED'          TO CMN-TABLE-1     
C26296*         MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE             
C26296          MOVE  -1                   TO WS-ACTIVE-RETURN-CODE     
C26296          MOVE 'ACCOUNT_NO'            TO CMN-TABLE-ELEMENT-1     
C26296          MOVE WS-ACCOUNT-NO-CHAR    TO CMN-HOSTVAR-ELEMENT-1     
C26296          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
C26296      END-IF.                                                     
C26296*                                                                         
C26296 2250-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5000-UPDATE                                                    *        
      ******************************************************************        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           IF WS-ORDER-TYPE-CD = 'CC' OR 'NC'                           
              MOVE CMN-ACCOUNT-NO-NEW        TO AT-ACCOUNT-NO           
           ELSE                                                         
              MOVE CMN-ACCOUNT-NO            TO AT-ACCOUNT-NO           
           END-IF.                                                      
                                                                        
           MOVE CMN-CODES-SO-DATA-PRESENT    TO WS-CODES-SO-DATA-PRESENT
                                                                        
           PERFORM 7010-GET-TIMESTAMP        THRU 7010-EXIT.            
           PERFORM 7050-SELECT-ACCOUNT       THRU 7050-EXIT.            
                                                                        
           MOVE AT-COMPANY-NO                TO GO-COMPANY-NO           
C24880                                          C8-COMPANY-NO.          
C24880     MOVE ZEROS                        TO WS-DATABASE.            
C24880     MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
C24880     PERFORM 7600-SELECT-DELINQUENCY   THRU 7600-EXIT             
C24880     MOVE C8-DELINQ-VALUE              TO WS-DATABASE.            
           MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT.  
                                                                        
           PERFORM 5395-GET-RESP-AREA-ID        THRU 5395-EXIT.         
           PERFORM 5400-FORMAT-JOURNAL-HEADER   THRU 5400-EXIT.         
                                                                        
           IF WS-CODE-APPLY-CHARGES = WS-A                              
REARCH        PERFORM 5150-CALL-CSR00250        THRU 5150-EXIT          
                                                                        
              IF WS-RPC-RETURN-CODE(1) = SUCCESSFUL-CALL OR NOT-FOUND   
                 PERFORM 5200-SUM-SO-CHARGES    THRU 5200-EXIT          
              ELSE                                                      
                 MOVE 'CICS TRANSACTION'        TO CMN-TABLE-1          
                 MOVE 'SP FAILED'               TO CMN-TABLE-2          
                 MOVE WS-RPC-RETURN-CODE(1)     TO WS-ACTIVE-RETURN-CODE
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
C28237     SET WS-CHRGX                         TO 1.                   
C28237     PERFORM UNTIL VLD-FXD-CHG-WK-PRD OR WS-CHRGX > 20            
C28237             IF  WS-CODE-WORK-PRD(WS-CHRGX) = ('W'                
C28237                 OR  SPACE                                        
C28237                 OR  LOW-VALUES                                   
C28237                 OR  HIGH-VALUES)                                 
C28237                 CONTINUE                                         
C28237             ELSE                                                 
C28237                 SET VLD-FXD-CHG-WK-PRD   TO  TRUE                
C28237             END-IF                                               
C28237             SET WS-CHRGX UP BY 1                                 
C28237     END-PERFORM.                                                 
C28237     IF  VLD-FXD-CHG-WK-PRD                                       
C28237         SET WS-CHRGX DOWN BY 1                                   
C28237         MOVE WS-CODE-WORK-PRD(WS-CHRGX)  TO   SV-WORK-PERIOD-CD  
C28237         MOVE AT-COMPANY-NO               TO   SV-COMPANY-NO      
C28237         MOVE CMN-SERV-ORDER-TYPE         TO   SV-ORDER-TYPE-CD   
C28237         MOVE WS-CODE-ACCT-TYPE(WS-CHRGX) TO                      
C28237                                            SV-ACCOUNT-TYPE-CODE  
C28237         PERFORM 7700-SEL-FXD-CHG-GL-ACCT THRU 7700-EXIT          
C28237         EVALUATE SV-PYMT-PRIORITY-LVL                            
C28237             WHEN 60                                              
C28237                  SET PROCESS-FXD-CHG-RCC TO TRUE                 
C28237             WHEN 90                                              
C28237                  SET PROCESS-FXD-CHG-DFA TO TRUE                 
C28237             WHEN 100                                             
C28237                  SET PROCESS-FXD-CHG-CNT TO TRUE                 
C28237         END-EVALUATE                                             
C28237     ELSE                                                         
C28237         SET WS-CHRGX TO 1                                        
C28237     END-IF.                                                      
           IF CMN-SERV-ORDER-TYPE = 'FM006'                             
              MOVE 'AR-CCC'                     TO GO-GL-ACCT-NAME      
              PERFORM 7400-SELECT-GL-ACCT-NO    THRU 7400-EXIT          
              MOVE GO-GL-ACCT-NO                TO WS-GL-ACCT-NO-AR-CCC 
              PERFORM 5500-PROCESS-RECONNECT    THRU 5500-EXIT          
              PERFORM 5420-TERMINATE-JRNL       THRU 5420-EXIT          
      *** TPR22968                                                              
              IF WS-UNSET-CDP NOT = 'Y'                                 
                 MOVE WS-A                      TO WS-CODE-CONNECT-CHRG 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CODE-APPLY-CHARGES NOT = WS-A                          
              MOVE WS-CODES-DATA-PRESENT        TO AT-CODES-DATA-PRESENT
              PERFORM 8400-UPDATE-ACCOUNT       THRU 8400-EXIT          
              GO TO 5000-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-TOTAL-SO-CHARGES = 0                                   
              GO TO 5000-EXIT                                           
           ELSE                                                         
              MOVE 'Y'                            TO WS-PROCESS-CHARGES 
              IF CMN-SERV-ORDER-TYPE = 'FM006'                          
                 PERFORM 7010-GET-TIMESTAMP          THRU 7010-EXIT     
                 PERFORM 5400-FORMAT-JOURNAL-HEADER  THRU 5400-EXIT     
              END-IF                                                    
              MOVE WS-TOTAL-SO-CHARGES            TO AR-AMT-ORIG-ENTERED
           END-IF.                                                      
                                                                        
C28237     IF PROCESS-FXD-CHG-RCC                                       
C28237        PERFORM 5501-PROCESS-FXD-CHG-RCC THRU 5501-EXIT           
C28237        PERFORM 5420-TERMINATE-JRNL      THRU 5420-EXIT           
           ELSE                                                         
C28237        IF PROCESS-FXD-CHG-DFA                                    
C24880           PERFORM 5550-POST-SO-CHRG-DFA  THRU 5550-EXIT          
C24880           PERFORM 5420-TERMINATE-JRNL    THRU 5420-EXIT          
C24880           MOVE 'A'                       TO WS-CODE-DFA-ACCT     
P00794           IF AT-COMPANY-NO = '26'                                
P00794              MOVE WS-DFA-AMOUNT TO DL-RECNCT-COLLECT-AMT         
P00794              PERFORM 5610-MOVE-FACTOR-VALUES THRU 5610-EXIT      
P00794              PERFORM 7010-GET-TIMESTAMP      THRU 7010-EXIT      
P00794              PERFORM 7015-RETRIEVE-MAX-SEQ-NO THRU 7015-EXIT     
P00794              ADD 1 TO FF-FIXED-FCTR-SEQ-NO                       
P00794              MOVE WS-CURRENT-TIMESTAMP TO FF-LAST-UPDATE-TS      
P00794              PERFORM 8310-INSERT-FACTOR      THRU 8310-EXIT      
AC501G              PERFORM 7010-GET-TIMESTAMP      THRU 7010-EXIT      
P00794              PERFORM 5630-ADD-TRN-COMM       THRU 5630-EXIT      
P00794           END-IF                                                 
              ELSE                                                      
                 IF SEB-DATABASE                                        
C34569              IF CMN-SERV-ORDER-TYPE = 'FM002'                    
C36587                 PERFORM 5620-CHECK-COMMENT THRU 5620-EXIT        
C36587                 PERFORM 8310-INSERT-FACTOR THRU 8310-EXIT        
AC501G                 PERFORM 7010-GET-TIMESTAMP THRU 7010-EXIT        
C36587                 PERFORM 5630-ADD-TRN-COMM  THRU 5630-EXIT        
                    ELSE                                                
C24880                 PERFORM 5550-POST-SO-CHRG-DFA  THRU 5550-EXIT    
C24880                 PERFORM 5420-TERMINATE-JRNL    THRU 5420-EXIT    
C24880                 MOVE 'A'                  TO WS-CODE-DFA-ACCT    
                    END-IF                                              
                 ELSE                                                   
C28237              IF NOT PROCESS-FXD-CHG-CNT                          
C28237                 MOVE 'AR-CNT'               TO GO-GL-ACCT-NAME   
C28237                 PERFORM 7400-SELECT-GL-ACCT-NO  THRU 7400-EXIT   
C28237                 MOVE GO-GL-ACCT-NO     TO WS-GL-ACCT-NO-AR-CNT   
C28237              END-IF                                              
                    PERFORM 5300-POST-SO-CHRG-CNT  THRU 5300-EXIT       
                    MOVE WS-A                      TO WS-CODE-CONTRACT  
                 END-IF                                                 
              END-IF                                                    
              MOVE WS-CODES-DATA-PRESENT      TO AT-CODES-DATA-PRESENT  
              PERFORM 8400-UPDATE-ACCOUNT     THRU 8400-EXIT            
C24880     END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH***************************************************************           
REARCH* THIS PARAGRAPH CALLS CSR00250                               *           
REARCH***************************************************************           
REARCH 5150-CALL-CSR00250.                                              
REARCH                                                                  
REARCH*    EXEC SQL CALL CSR00250                                       
REARCH*        (:WS-SERV-ORDER-NO-C)                                    
REARCH*    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE MATERIAL-CHG
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN MATERIAL-CHG
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR MATERIAL-CHG INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
REARCH      IF  SQLCODE = 466 THEN                                      
REARCH*         EXEC SQL ASSOCIATE LOCATORS(:LOC2) WITH PROCEDURE       
REARCH*            CSR00250                                             
REARCH*         END-EXEC                                                
REARCH*         EXEC SQL                                                
REARCH*           ALLOCATE MATERIAL-CHG CURSOR FOR RESULT SET :LOC2     
REARCH*         END-EXEC                                                
REARCH                                                                  
P01137         SET WS-CHRGX TO +1                                       
REARCH         PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
REARCH          EXEC SQL                                                
REARCH            FETCH MATERIAL-CHG INTO                               
REARCH                          :WS-RPC-RETURN-CODE-BD                  
REARCH                         ,:WS-CODE-UTIL-TYPE-BD                   
REARCH                         ,:WS-STD-LABOR-CHRG-BD                   
REARCH                         ,:WS-CALC-LABOR-CHRG-BD                  
REARCH                         ,:WS-MATERIAL-CHRG-BD                    
REARCH                         ,:WS-OTHER-CHRG-BD                       
REARCH                         ,:WS-CHRG-FOR-MATERIAL-BD                
REARCH                         ,:WS-STATE-TAX-BD                        
REARCH                         ,:WS-AREA-TAX-BD                         
REARCH                         ,:WS-COMMENTS-BD                         
REARCH                         ,:WS-ENDV-ELEC-CHRG-BD                   
REARCH                         ,:WS-ENDV-GAS-CHRG-BD                    
REARCH                         ,:WS-CODE-WORK-PRD-BD                    
REARCH                         ,:WS-CODE-ACCT-TYPE-BD                   
REARCH          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH          MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE       
REARCH          IF SQLCODE = SUCCESSFUL-CALL                            
REARCH        MOVE WS-RPC-RETURN-CODE-BD TO WS-RPC-RETURN-CODE(WS-CHRGX)
REARCH        MOVE WS-CODE-UTIL-TYPE-BD  TO WS-CODE-UTIL-TYPE(WS-CHRGX) 
REARCH        MOVE WS-STD-LABOR-CHRG-BD  TO WS-STD-LABOR-CHRG(WS-CHRGX) 
REARCH        MOVE WS-CALC-LABOR-CHRG-BD TO WS-CALC-LABOR-CHRG(WS-CHRGX)
REARCH        MOVE WS-MATERIAL-CHRG-BD   TO WS-MATERIAL-CHRG(WS-CHRGX)  
REARCH        MOVE WS-OTHER-CHRG-BD      TO WS-OTHER-CHRG(WS-CHRGX)     
REARCH        MOVE WS-CHRG-FOR-MATERIAL-BD                              
REARCH                                 TO WS-CHRG-FOR-MATERIAL(WS-CHRGX)
REARCH        MOVE WS-STATE-TAX-BD       TO WS-STATE-TAX(WS-CHRGX)      
REARCH        MOVE WS-AREA-TAX-BD        TO WS-AREA-TAX(WS-CHRGX)       
REARCH        MOVE WS-COMMENTS-BD        TO WS-COMMENTS(WS-CHRGX)       
REARCH        MOVE WS-ENDV-ELEC-CHRG-BD  TO WS-ENDV-ELEC-CHRG(WS-CHRGX) 
REARCH        MOVE WS-ENDV-GAS-CHRG-BD   TO WS-ENDV-GAS-CHRG(WS-CHRGX)  
REARCH        MOVE WS-CODE-WORK-PRD-BD   TO WS-CODE-WORK-PRD(WS-CHRGX)  
REARCH        MOVE WS-CODE-ACCT-TYPE-BD  TO WS-CODE-ACCT-TYPE(WS-CHRGX) 
REARCH        SET WS-CHRGX               UP BY 1                        
REARCH          ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND               
REARCH             SET WS-CHRGX                 DOWN BY 1               
REARCH          ELSE                                                    
REARCH             MOVE '5150'                    TO ACTIVE-PARAGRAPH   
REARCH             MOVE 'CSR00250 FETCH FAILED' TO CMN-TABLE-1          
REARCH             MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE   
REARCH             MOVE 'CSS_SO_MATERIALS'     TO CMN-TABLE-ELEMENT-1   
REARCH             MOVE WS-RPC-RETURN-CODE-BD TO CMN-HOSTVAR-ELEMENT-1  
REARCH             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
REARCH          END-IF                                                  
REARCH          END-IF                                                  
REARCH         END-PERFORM                                              
REARCH                                                                  
REARCH          EXEC SQL                                                
REARCH             CLOSE MATERIAL-CHG                                   
REARCH          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH          IF SQLCODE = SUCCESSFUL-CALL                            
REARCH             CONTINUE                                             
REARCH          ELSE                                                    
REARCH             MOVE '5150'                     TO ACTIVE-PARAGRAPH  
REARCH             MOVE 'CSR00250 FAILED'              TO CMN-TABLE-1   
REARCH             MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE   
REARCH             MOVE 'CSS_SO_MATERIALS'     TO CMN-TABLE-ELEMENT-1   
REARCH             MOVE WS-RPC-RETURN-CODE-BD TO CMN-HOSTVAR-ELEMENT-1  
REARCH             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
REARCH          END-IF                                                  
REARCH      ELSE                                                        
REARCH          MOVE '5150'                     TO ACTIVE-PARAGRAPH     
REARCH          MOVE 'CSR00250 CALL FAILED'          TO CMN-TABLE-1     
REARCH          MOVE  -1                   TO WS-ACTIVE-RETURN-CODE     
REARCH          MOVE 'CSS_SO_MATERIALS'      TO CMN-TABLE-ELEMENT-1     
REARCH          MOVE WS-RPC-RETURN-CODE-BD TO CMN-HOSTVAR-ELEMENT-1     
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH      END-IF.                                                     
REARCH                                                                  
REARCH 5150-EXIT.                                                       
REARCH     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5200-SUM-SO-CHARGES                                           *         
      * THIS PARA ADDS UP ALL CHARGES FOR ALL THE UTILITY TYPES       *         
      * THE TOTAL CHARGE AMOUNT BE WILL USED IN A/R JOURNAL HEADER    *         
      *****************************************************************         
       5200-SUM-SO-CHARGES.                                             
                                                                        
           SET WS-CHRGX                       TO 1.                     
           MOVE ZEROES                        TO WS-TOTAL-SO-CHARGES.   
                                                                        
           PERFORM UNTIL WS-CODE-UTIL-TYPE(WS-CHRGX) = SPACES OR        
                                                       LOW-VALUE        
              IF WS-CODE-UTIL-TYPE-PREV NOT =                           
                            WS-CODE-UTIL-TYPE(WS-CHRGX)                 
                 ADD WS-STD-LABOR-CHRG-NUM(WS-CHRGX) ,                  
                     WS-CALC-LABOR-CHRG-NUM(WS-CHRGX),                  
                     WS-MATERIAL-CHRG-NUM(WS-CHRGX)  ,                  
                     WS-OTHER-CHRG-NUM(WS-CHRGX) GIVING WS-TEMP-TOTAL   
                 ADD WS-TEMP-TOTAL      TO WS-TOTAL-SO-CHARGES          
                 MOVE WS-CODE-UTIL-TYPE(WS-CHRGX)                       
                                        TO WS-CODE-UTIL-TYPE-PREV       
              END-IF                                                    
                                                                        
      **** ACCUMULATE STATE AND AREA TAXES FOR EACH CODE-UTIL-TYPE ****         
              IF WS-CODE-UTIL-TYPE(WS-CHRGX) = 'E'                      
                 ADD WS-STATE-TAX-NUM(WS-CHRGX) TO WS-STATE-TAX-ELEC    
                 ADD WS-AREA-TAX-NUM(WS-CHRGX)  TO WS-AREA-TAX-ELEC     
              ELSE                                                      
                 ADD WS-STATE-TAX-NUM(WS-CHRGX) TO WS-STATE-TAX-GAS     
                 ADD WS-AREA-TAX-NUM(WS-CHRGX)  TO WS-AREA-TAX-GAS      
              END-IF                                                    
                                                                        
              SET WS-CHRGX UP BY 1                                      
           END-PERFORM.                                                 
                                                                        
           MOVE SPACES                        TO WS-CODE-UTIL-TYPE-PREV.
           SET WS-CHRGX                       TO 1.                     
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5300-POST-SO-CHRG-CNT                                         *         
      * THIS PARA CREATES CONTRACT, A/R CONTROL, AND A/R JOURNALS.    *         
      * ONE CONTRACT RECORD WILL BE CREATED FOR EACH CODE-UTIL-TYPE   *         
      *   BUT WILL HAVE MORE THAN ONE CONTRACT DETAIL ROW.            *         
      *****************************************************************         
       5300-POST-SO-CHRG-CNT.                                           
                                                                        
           SET WS-CHRGX                       TO 1.                     
                                                                        
           PERFORM UNTIL WS-CODE-UTIL-TYPE(WS-CHRGX) = SPACES OR        
                                                       LOW-VALUE        
              IF WS-CODE-UTIL-TYPE-PREV = WS-CODE-UTIL-TYPE(WS-CHRGX)   
                                                                        
                 IF WS-CHRG-FOR-MATERIAL-NUM(WS-CHRGX) > 0              
                    MOVE WS-M                 TO EA-CHARGE-TYPE-CD      
                    MOVE WS-CHRG-FOR-MATERIAL-NUM(WS-CHRGX)             
                                              TO WS-AMT-POSTED          
                    COMPUTE EA-CHARGE-AM =                              
                       WS-CHRG-FOR-MATERIAL-NUM(WS-CHRGX) -             
                       WS-STATE-TAX-NUM(WS-CHRGX) -                     
                       WS-AREA-TAX-NUM(WS-CHRGX)                        
                       MOVE WS-STATE-TAX-NUM(WS-CHRGX)                  
                                              TO WS-STATE-TAX-DET       
                       MOVE WS-AREA-TAX-NUM (WS-CHRGX)                  
                                              TO WS-AREA-TAX-DET        
                    PERFORM 5320-PROCESS-CNT-DETAIL THRU 5320-EXIT      
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 5310-PROCESS-CONTRACT THRU 5310-EXIT           
                 MOVE 0                        TO WS-CNT-DET-SEQ-NO     
                 IF (WS-STD-LABOR-CHRG-NUM(WS-CHRGX) +                  
                    WS-CALC-LABOR-CHRG-NUM(WS-CHRGX)) > 0               
                    MOVE WS-L                  TO EA-CHARGE-TYPE-CD     
                    ADD WS-STD-LABOR-CHRG-NUM(WS-CHRGX)                 
                        WS-CALC-LABOR-CHRG-NUM(WS-CHRGX)                
                        GIVING WS-AMT-POSTED                            
                    MOVE WS-AMT-POSTED         TO EA-CHARGE-AM          
                    MOVE ZEROES                TO WS-STATE-TAX-DET      
                                                  WS-AREA-TAX-DET       
                    PERFORM 5320-PROCESS-CNT-DETAIL THRU 5320-EXIT      
                 END-IF                                                 
                                                                        
                 IF WS-CHRG-FOR-MATERIAL-NUM(WS-CHRGX) > 0              
                    MOVE WS-M                  TO EA-CHARGE-TYPE-CD     
                    MOVE WS-CHRG-FOR-MATERIAL-NUM(WS-CHRGX)             
                                               TO WS-AMT-POSTED         
                    COMPUTE EA-CHARGE-AM =                              
                       WS-CHRG-FOR-MATERIAL-NUM(WS-CHRGX) -             
                       WS-STATE-TAX-NUM(WS-CHRGX) -                     
                       WS-AREA-TAX-NUM(WS-CHRGX)                        
                       MOVE WS-STATE-TAX-NUM(WS-CHRGX)                  
                                               TO WS-STATE-TAX-DET      
                       MOVE WS-AREA-TAX-NUM (WS-CHRGX)                  
                                               TO WS-AREA-TAX-DET       
                    PERFORM 5320-PROCESS-CNT-DETAIL THRU 5320-EXIT      
                 END-IF                                                 
                                                                        
                 IF WS-OTHER-CHRG-NUM(WS-CHRGX) > 0                     
                    MOVE WS-C                  TO EA-CHARGE-TYPE-CD     
                    MOVE WS-OTHER-CHRG-NUM(WS-CHRGX)                    
                                               TO WS-AMT-POSTED         
                    MOVE WS-AMT-POSTED         TO EA-CHARGE-AM          
                    MOVE ZEROES                TO WS-STATE-TAX-DET      
                                                  WS-AREA-TAX-DET       
                    PERFORM 5320-PROCESS-CNT-DETAIL THRU 5320-EXIT      
                 END-IF                                                 
                                                                        
                 MOVE WS-CODE-UTIL-TYPE(WS-CHRGX)                       
                                               TO WS-CODE-UTIL-TYPE-PREV
              END-IF                                                    
                                                                        
              SET WS-CHRGX                     UP BY 1                  
           END-PERFORM.                                                 
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5310-PROCESS-CONTRACT                                         *         
      * GET THE MAXIMUM ITEM ID ALREADY USED AND ADD 1 TO IT TO GET   *         
      * NEXT CONTRACT-ITEM-ID TO BE USED. INITIALIZE ALL THE REQUIRED *         
      * COLUMNS FOR THE CSS_CONTRACT TABLE AND INSERT THE CONTRACT    *         
      *****************************************************************         
       5310-PROCESS-CONTRACT.                                           
                                                                        
           ADD WS-STD-LABOR-CHRG-NUM(WS-CHRGX),                         
               WS-CALC-LABOR-CHRG-NUM(WS-CHRGX),                        
               WS-MATERIAL-CHRG-NUM(WS-CHRGX),                          
               WS-OTHER-CHRG-NUM(WS-CHRGX)   GIVING CT-AMT-MO-PYMT.     
                                                                        
           IF CT-AMT-MO-PYMT = 0                                        
              GO TO 5310-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-ORDER-TYPE-CD = 'CC' OR 'NC'                           
              MOVE CMN-ACCOUNT-NO-NEW    TO CT-ACCOUNT-NO               
           ELSE                                                         
              MOVE CMN-ACCOUNT-NO        TO CT-ACCOUNT-NO               
           END-IF.                                                      
                                                                        
           MOVE 100                      TO CT-PYMT-PRIORITY-LVL.       
                                                                        
           IF WS-CNT-ITEM-ID = 0                                        
              PERFORM 7100-SELECT-MAX-CNT-ITEM-ID THRU 7100-EXIT        
              IF WS-NULL-IND01 < 0 OR WS-CNT-ITEM-ID = 0                
                 MOVE 5000000            TO WS-CNT-ITEM-ID              
              ELSE                                                      
                 ADD +1                  TO WS-CNT-ITEM-ID              
              END-IF                                                    
           ELSE                                                         
              ADD +1                     TO WS-CNT-ITEM-ID              
           END-IF.                                                      
                                                                        
           MOVE WS-CNT-ITEM-ID           TO CT-CNT-ITEM-ID.             
           MOVE WS-CURRENT-DATE          TO CT-DATE-CONTRACT            
                                            CT-DATE-PYMT-START.         
           MOVE CT-AMT-MO-PYMT           TO CT-AMT-ORIG-ENTERED.        
           MOVE +1                       TO CT-NO-SCHED-PYMTS.          
           MOVE WS-C                     TO CT-CODE-CONTRACT-TYPE.      
           MOVE WS-B                     TO CT-CNT-STATUS-CD.           
                                                                        
           IF WS-CODE-UTIL-TYPE(WS-CHRGX) = 'E'                         
              MOVE WS-CNT-NAME-CD-ELEC   TO CT-CNT-NAME-CD              
              MOVE WS-STATE-TAX-ELEC     TO CT-AMT-TAX-STATE            
      * TPR 17950                                                               
      *       MOVE WS-AREA-TAX-ELEC      TO CT-AMT-TAX-CITY                     
              MOVE ZEROES                TO CT-AMT-TAX-CITY             
              MOVE WS-AREA-TAX-ELEC      TO CT-AMT-TAX-OTHER            
           ELSE                                                         
C28237        IF PROCESS-FXD-CHG-CNT                                    
C28237           MOVE  SV-CNT-NAME-CD        TO  CT-CNT-NAME-CD         
C28237        ELSE                                                      
T25116           IF AT-COMPANY-NO = '26'                                
T25116              MOVE WS-CNT-NAME-CD-PSNC TO CT-CNT-NAME-CD          
T25116           ELSE                                                   
                    MOVE WS-CNT-NAME-CD-GAS  TO CT-CNT-NAME-CD          
T25116           END-IF                                                 
C28237        END-IF                                                    
              MOVE WS-STATE-TAX-GAS      TO CT-AMT-TAX-STATE            
      * TPR 17950                                                               
      *       MOVE WS-AREA-TAX-GAS       TO CT-AMT-TAX-CITY                     
              MOVE ZEROES                TO CT-AMT-TAX-CITY             
              MOVE WS-AREA-TAX-GAS       TO CT-AMT-TAX-OTHER            
           END-IF.                                                      
           MOVE CT-CNT-NAME-CD           TO K6-CNT-NAME-CD.             
           PERFORM 7200-SELECT-CONTRACT-INFO THRU 7200-EXIT.            
           MOVE K6-REBATE-CD             TO CT-REBATE-CD.               
           MOVE K6-INTEREST-CD           TO CT-CODE-INTRST-METH.        
           MOVE K6-DFLT-INTRST-RT        TO CT-INTRST-RATE.             
           MOVE CMN-USER-ID              TO CT-USER-ID.                 
           MOVE WS-N                     TO CT-LIEN-CD.                 
           MOVE WS-A                     TO CT-CODE-BILL-TYPE.          
           MOVE SPACES                   TO CT-CREDIT-EXEMPT-CODE.      
           MOVE WS-COMMENTS(WS-CHRGX)    TO CT-CONTRACT-COMMENTS-TEXT   
C20053                                      AR-TRAN-COMMENT-TEXT.       
           MOVE LENGTH OF WS-COMMENTS    TO CT-CONTRACT-COMMENTS-LEN    
C20053                                      AR-TRAN-COMMENT-LEN.        
           MOVE PR-REV-DISTRICT-CD       TO CT-REV-DISTRICT-CD.         
                                                                        
           PERFORM 8000-INSERT-CONTRACT    THRU 8000-EXIT.              
           PERFORM 5311-CREATE-AR-CONTROL  THRU 5311-EXIT.              
                                                                        
           MOVE ZERO                     TO WS-AMT-POSTED-TOTAL.        
                                                                        
       5310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5311-CREATE-AR-CONTROL                                        *         
      *  THIS PARA INSERTS AR-CONTROL DETAIL RECORD FOR EACH CONTRACT *         
      *  OR RECONNECT CHARGES CREATED.                                *         
      *  IF SUMMARY AR-CNTL RECORD DOES NOT EXIST THEN INSERT ONE.    *         
      *****************************************************************         
       5311-CREATE-AR-CONTROL.                                          
                                                                        
           IF (CMN-SERV-ORDER-TYPE = 'FM006' AND                        
C28237         WS-PROCESS-CHARGES = 'N')     OR                         
C28237         PROCESS-FXD-CHG-RCC                                      
              MOVE CC-ACCOUNT-NO          TO AC-ACCOUNT-NO              
              MOVE CC-PYMT-PRIORITY-LVL   TO AC-PYMT-PRIORITY-LVL       
              MOVE CC-CCC-ITEM-ID         TO AC-ITEM-ID                 
              MOVE CC-AMT-ORIG-ENTERED    TO AC-AMT-TRAN-BALANCE        
           ELSE                                                         
              MOVE CT-ACCOUNT-NO          TO AC-ACCOUNT-NO              
              MOVE CT-PYMT-PRIORITY-LVL   TO AC-PYMT-PRIORITY-LVL       
              MOVE CT-CNT-ITEM-ID         TO AC-ITEM-ID                 
              MOVE CT-AMT-ORIG-ENTERED    TO AC-AMT-TRAN-BALANCE        
           END-IF.                                                      
                                                                        
           MOVE ZEROES                    TO AC-AMT-AR-DAY-00,          
                                             AC-AMT-AR-DAY-30,          
                                             AC-AMT-AR-DAY-60,          
                                             AC-AMT-AR-DAY-90,          
                                             AC-AMT-UNUSED-CR.          
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO AC-LAST-UPDATE-TS.         
           PERFORM 8200-INSERT-AR-CNTL    THRU 8200-EXIT.               
                                                                        
           MOVE ZEROES                    TO AC-ITEM-ID.                
           PERFORM 7300-SELECT-AR-CNTL    THRU 7300-EXIT.               
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE AC-AMT-TRAN-BALANCE    TO WS-HOLD-TRAN-BALANCE       
              MOVE ZEROES                 TO AC-AMT-TRAN-BALANCE        
              PERFORM 8200-INSERT-AR-CNTL THRU 8200-EXIT                
              MOVE WS-HOLD-TRAN-BALANCE   TO AC-AMT-TRAN-BALANCE        
           END-IF.                                                      
                                                                        
       5311-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5320-PROCESS-CNT-DETAIL                                       *         
      * THIS PARA CREATES RECORDS IN CSS_CNT_DETAIL TABLE WITH DATA   *         
      * RETRIEVED FROM CSS_CONTRACT_INFO FOR THE CHARGE-TYPE          *         
      *****************************************************************         
       5320-PROCESS-CNT-DETAIL.                                         
                                                                        
           ADD +1                             TO WS-CNT-DET-SEQ-NO.     
                                                                        
           IF WS-CNT-DET-SEQ-NO EQUAL +1 THEN                           
               MOVE CT-ACCOUNT-NO             TO EA-ACCOUNT-NO          
               MOVE CT-CNT-ITEM-ID            TO EA-CNT-ITEM-ID         
               MOVE CT-PYMT-PRIORITY-LVL      TO EA-PYMT-PRIORITY-LVL   
               MOVE WS-CODE-UTIL-TYPE(WS-CHRGX) TO EA-CODE-SERVICE-TYPE 
               MOVE EA-CHARGE-AM              TO WS-HOLD-CHARGE-AM      
      *        ADD +1                         TO WS-CNT-DET-SEQ-NO              
                                                                        
               MOVE K6-COST-CENTER            TO EA-COST-CENTER         
               MOVE K6-GL-ACCT-NO             TO EA-GL-ACCT-NO          
               MOVE K6-WRT-OFF-GL-ACCT-NO     TO EA-WRT-OFF-GL-ACCT-NO  
                                                                        
               PERFORM 8100-INSERT-CNT-DETAIL     THRU 8100-EXIT        
      *        PERFORM 5321-CREATE-AR-TRN-HST     THRU 5321-EXIT                
           ELSE                                                         
             COMPUTE EA-CHARGE-AM EQUAL                                 
                 EA-CHARGE-AM + WS-HOLD-CHARGE-AM                       
                                                                        
             MOVE EA-CHARGE-AM                TO WS-HOLD-CHARGE-AM      
                                                                        
             PERFORM 8110-UPDATE-CNT-DETAIL       THRU 8110-EXIT        
           END-IF.                                                      
                                                                        
C28237     IF PROCESS-FXD-CHG-CNT                                       
C28237        PERFORM 5322-CREATE-FXD-CHG-AR-TRN-HST THRU 5322-EXIT     
C28237     ELSE                                                         
              PERFORM 5321-CREATE-AR-TRN-HST         THRU 5321-EXIT     
C28237     END-IF.                                                      
                                                                        
       5320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5321-CREATE-AR-TRN-HST                                        *         
      * THIS PARA INITIALIZES VALUES FOR AR-TRANS-HIST-DETAIL TABLE   *         
      * AND INSERTS ROW IN THE TABLE.                                 *         
      *****************************************************************         
       5321-CREATE-AR-TRN-HST.                                          
                                                                        
           ADD +1                            TO AU-TRAN-APPL-NO.        
                                                                        
           IF CMN-SERV-ORDER-TYPE = 'FM006' AND WS-PROCESS-CHARGES = 'N'
                                                                        
      ****** GET GL-NUMBERS FOR RECONNECT-REVENUE ACCOUNT *****                 
      *      INITIALIZE VALUES FOR RECONNECT CHARGES *                          
              IF WS-CODE-UTIL-TYPE(WS-CHRGX) = 'E'                      
                 MOVE 'EREV-CCC'              TO GO-GL-ACCT-NAME        
              ELSE                                                      
                 MOVE 'GREV-CCC'              TO GO-GL-ACCT-NAME        
              END-IF                                                    
                                                                        
              PERFORM 7400-SELECT-GL-ACCT-NO  THRU 7400-EXIT            
              MOVE GO-GL-ACCT-NO              TO AU-GL-ACCT-CREDIT      
              MOVE WS-GL-ACCT-NO-AR-CCC       TO AU-GL-ACCT-DEBIT       
              MOVE CC-AMT-TRANS               TO AU-AMT-POSTED          
              MOVE CC-CCC-ITEM-ID             TO AU-ITEM-ID             
              MOVE SPACES                     TO AU-CODE-CONTRACT-TYPE  
                                                                        
              IF U7-RCNCT-ELEC-SVC-FL = 'Y' AND                         
                 U7-RCNCT-GAS-SVC-FL  = 'Y'                             
                 MOVE 'PCT-ELEC-RCC-ALLOC'       TO C8-DELINQ-CD        
                 PERFORM 7600-SELECT-DELINQUENCY THRU 7600-EXIT         
                 COMPUTE C8-DELINQ-VALUE = C8-DELINQ-VALUE / 100        
                 COMPUTE WS-SPLIT-AMT = CC-AMT-TRANS * C8-DELINQ-VALUE  
                 COMPUTE WS-REMAIN-AMT = CC-AMT-TRANS - WS-SPLIT-AMT    
                 MOVE 'EREV-CCC'                 TO GO-GL-ACCT-NAME     
                 PERFORM 7400-SELECT-GL-ACCT-NO  THRU 7400-EXIT         
                 MOVE GO-GL-ACCT-NO              TO WS-EREV-CCC-GL      
                                                    WS-EREV-CCC-GL-HOLD 
                                                    AU-GL-ACCT-CREDIT   
                 MOVE WS-SPLIT-AMT               TO AU-AMT-POSTED       
                 PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT   
                 ADD +1                          TO AU-TRAN-APPL-NO     
                 MOVE 'GREV-CCC'                 TO GO-GL-ACCT-NAME     
                 PERFORM 7400-SELECT-GL-ACCT-NO  THRU 7400-EXIT         
                 MOVE GO-GL-ACCT-NO              TO WS-EREV-CCC-GL      
                                                    WS-GREV-CCC-GL-HOLD 
                                                    AU-GL-ACCT-CREDIT   
                 MOVE WS-REMAIN-AMT              TO AU-AMT-POSTED       
                 PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT   
              ELSE                                                      
                 IF U7-RCNCT-ELEC-SVC-FL = 'Y'                          
                    MOVE 'EREV-CCC'              TO GO-GL-ACCT-NAME     
                    PERFORM 7400-SELECT-GL-ACCT-NO THRU 7400-EXIT       
                    MOVE GO-GL-ACCT-NO           TO WS-EREV-CCC-GL      
                                                    WS-EREV-CCC-GL-HOLD 
                                                    AU-GL-ACCT-CREDIT   
                 END-IF                                                 
                 IF U7-RCNCT-GAS-SVC-FL = 'Y'                           
                    MOVE 'GREV-CCC'              TO GO-GL-ACCT-NAME     
                    PERFORM 7400-SELECT-GL-ACCT-NO THRU 7400-EXIT       
                    MOVE GO-GL-ACCT-NO           TO WS-EREV-CCC-GL      
                                                    WS-GREV-CCC-GL-HOLD 
                                                    AU-GL-ACCT-CREDIT   
                 END-IF                                                 
                 MOVE CC-AMT-TRANS               TO AU-AMT-POSTED       
                 PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT   
              END-IF                                                    
           ELSE                                                         
      ****** INITIALIZE VALUES FOR CONTRACT                                     
              MOVE EA-GL-ACCT-NO              TO AU-GL-ACCT-CREDIT      
              MOVE WS-GL-ACCT-NO-AR-CNT       TO AU-GL-ACCT-DEBIT       
              MOVE WS-AMT-POSTED              TO AU-AMT-POSTED          
              MOVE EA-CNT-ITEM-ID             TO AU-ITEM-ID             
              MOVE WS-C                       TO AU-CODE-CONTRACT-TYPE  
              PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT      
           END-IF.                                                      
                                                                        
      ****** WRITE CASH DRAWER JOURNALS                                         
           IF CMN-SERV-ORDER-TYPE = 'FM006' AND WS-PROCESS-CHARGES = 'N'
              IF U7-RCNCT-ELEC-SVC-FL = 'Y' AND                         
                 U7-RCNCT-GAS-SVC-FL  = 'Y'                             
                                                                        
                 INITIALIZE CJF00102                                    
                 MOVE WS-SPLIT-AMT           TO WS-102-AMT-POSTED       
                 MOVE WS-EREV-CCC-GL-HOLD    TO WS-102-ACCT-GEN-LED-CR  
                 PERFORM 5600-LOAD-JRNL-VARS THRU 5600-EXIT             
                                                                        
                 PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT        
                                                                        
                 IF WS-JRNL-RTRN-CODE NOT EQUAL SPACES                  
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE 'USERABEN'          TO ABEND-PROGRAM           
                    MOVE 'ONLINE JOURNAL ROUTINE FAILED'                
                                             TO DSNTIAR-MESSAGE-1       
                    MOVE WS-JRNL-RTRN-CODE   TO DSNTIAR-MESSAGE-2       
                    MOVE 'Y'                 TO WS-USER-FORCE-ABEND     
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
                 END-IF                                                 
                                                                        
                 INITIALIZE CJF00102                                    
                 MOVE WS-REMAIN-AMT          TO WS-102-AMT-POSTED       
                 MOVE WS-GREV-CCC-GL-HOLD    TO WS-102-ACCT-GEN-LED-CR  
                 PERFORM 5600-LOAD-JRNL-VARS THRU 5600-EXIT             
                                                                        
                 PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT        
                                                                        
                 IF WS-JRNL-RTRN-CODE NOT EQUAL SPACES                  
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE 'USERABEN'          TO ABEND-PROGRAM           
                    MOVE 'ONLINE JOURNAL ROUTINE FAILED'                
                                             TO DSNTIAR-MESSAGE-1       
                    MOVE WS-JRNL-RTRN-CODE   TO DSNTIAR-MESSAGE-2       
                    MOVE 'Y'                 TO WS-USER-FORCE-ABEND     
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
                 END-IF                                                 
              ELSE                                                      
                 INITIALIZE CJF00102                                    
                 IF U7-RCNCT-ELEC-SVC-FL = 'Y'                          
                    MOVE WS-EREV-CCC-GL      TO WS-102-ACCT-GEN-LED-CR  
                 END-IF                                                 
                 IF U7-RCNCT-GAS-SVC-FL = 'Y'                           
                    MOVE WS-EREV-CCC-GL      TO WS-102-ACCT-GEN-LED-CR  
                 END-IF                                                 
                 MOVE CC-AMT-TRANS           TO WS-102-AMT-POSTED       
                 PERFORM 5600-LOAD-JRNL-VARS THRU 5600-EXIT             
                                                                        
                 PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT        
                                                                        
                 IF WS-JRNL-RTRN-CODE NOT EQUAL SPACES                  
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE 'USERABEN'          TO ABEND-PROGRAM           
                    MOVE 'ONLINE JOURNAL ROUTINE FAILED'                
                                             TO DSNTIAR-MESSAGE-1       
                    MOVE WS-JRNL-RTRN-CODE   TO DSNTIAR-MESSAGE-2       
                    MOVE 'Y'                 TO WS-USER-FORCE-ABEND     
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              INITIALIZE CJF00102                                       
              PERFORM 5600-LOAD-JRNL-VARS       THRU 5600-EXIT          
                                                                        
              PERFORM 6400-ONLINE-JRNL-ROUTINE  THRU 6400-EXIT          
                                                                        
              IF WS-JRNL-RTRN-CODE EQUAL SPACES                         
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE 'USERABEN'                TO ABEND-FUNCTION       
                 MOVE 'ONLINE JOURNAL ROUTINE FAILED'                   
                                                TO DSNTIAR-MESSAGE-1    
                 MOVE WS-JRNL-RTRN-CODE         TO DSNTIAR-MESSAGE-2    
                 MOVE 'Y'                       TO WS-USER-FORCE-ABEND  
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5321-EXIT.                                                       
           EXIT.                                                        
                                                                        
S28237***************************************************************** 11570000
S28237* 5322-CREATE-FXD-CHG-AR-TRN-HST                                * 11580000
S28237*   THIS PARA INITIALIZES VALUES FOR AR-TRANS-HIST-DETAIL TABLE * 11600000
S28237*   AND INSERTS ROW IN THE TABLE FOR ALL FIXED SO CHARGES.      * 11610000
S28237***************************************************************** 11620000
S28237 5322-CREATE-FXD-CHG-AR-TRN-HST.                                  
S28237     ADD +1                            TO   AU-TRAN-APPL-NO.      
S28237     IF PROCESS-FXD-CHG-RCC                                       
S28237        MOVE WS-GREV-CCC-GL-HOLD       TO   AU-GL-ACCT-CREDIT     
S28237        MOVE WS-GL-ACCT-NO-AR-CCC      TO   AU-GL-ACCT-DEBIT      
S28237        MOVE WS-TOTAL-SO-CHARGES       TO   AU-AMT-POSTED         
S28237        MOVE CC-CCC-ITEM-ID            TO   AU-ITEM-ID            
S28237        MOVE SPACES                    TO   AU-CODE-CONTRACT-TYPE 
S28237     ELSE                                                         
S28237        MOVE EA-GL-ACCT-NO             TO   AU-GL-ACCT-CREDIT     
S28237        MOVE WS-GL-ACCT-NO-AR-CNT      TO   AU-GL-ACCT-DEBIT      
S28237        MOVE WS-AMT-POSTED             TO   AU-AMT-POSTED         
S28237        MOVE EA-CNT-ITEM-ID            TO   AU-ITEM-ID            
S28237        MOVE WS-C                      TO   AU-CODE-CONTRACT-TYPE 
S28237     END-IF.                                                      
S28237     PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST                        
S28237                                       THRU 6500-EXIT.            
S28237     PERFORM 5600-LOAD-JRNL-VARS       THRU 5600-EXIT.            
S28237     PERFORM 6400-ONLINE-JRNL-ROUTINE  THRU 6400-EXIT.            
S28237     IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
S28237        NEXT SENTENCE                                             
S28237     ELSE                                                         
S28237        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
S28237        MOVE 'USERABEN'                TO ABEND-FUNCTION          
S28237        MOVE 'ONLINE JOURNAL ROUTINE FAILED'                      
S28237                                       TO DSNTIAR-MESSAGE-1       
S28237        MOVE WS-JRNL-RTRN-CODE         TO DSNTIAR-MESSAGE-2       
S28237        MOVE 'Y'                       TO WS-USER-FORCE-ABEND     
S28237        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
S28237     END-IF.                                                      
S28237 5322-EXIT.                                                       
S28237     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5395-GET-RESP-AREA-ID.                                        *         
      *****************************************************************         
       5395-GET-RESP-AREA-ID.                                           
                                                                        
           MOVE CMN-USER-ID                   TO PF-USER-ID.            
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE                                   
               WHERE USER_ID = :PF-USER-ID                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :PF-USER-ID                                      
MFA-TR*        QUERYNO 5395                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '5395'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_USER_PROFILE'         TO CMN-TABLE-1            
              MOVE 'USER_ID'                  TO CMN-TABLE-ELEMENT-1    
              MOVE PF-USER-ID                 TO CMN-HOSTVAR-ELEMENT-1  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5395-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5400-FORMAT-JOURNAL-HEADER                                    *         
      * THIS PARA INITIALIZES ALL THE COLUMNS REQUIRED FOR CREATING   *         
      * AR-JOURNAL HEADER RECORD AND SOME OF THE COLUMNS OF DETAIL    *         
      *****************************************************************         
       5400-FORMAT-JOURNAL-HEADER.                                      
                                                                        
           IF WS-ORDER-TYPE-CD = 'CC' OR 'NC'                           
              MOVE CMN-ACCOUNT-NO-NEW     TO AR-ACCOUNT-NO              
                                             AU-ACCOUNT-NO              
           ELSE                                                         
              MOVE CMN-ACCOUNT-NO         TO AR-ACCOUNT-NO              
                                             AU-ACCOUNT-NO              
           END-IF.                                                      
                                                                        
           PERFORM 7010-GET-TIMESTAMP     THRU 7010-EXIT.               
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO AR-TRANS-HIST-SEQ-NO       
                                             AU-TRANS-HIST-SEQ-NO.      
           MOVE WS-CURRENT-DATE           TO AR-DATE-TRANS.             
           MOVE WS-S                      TO AR-CODE-TRAN-TYPE.         
           MOVE AT-TOTAL-AR-BALANCE       TO AR-AMT-BILLED-UNPAID.      
           MOVE PF-RESP-AREA-ID           TO AR-RESP-AREA-ID.           
                                                                        
           IF CMN-SERV-ORDER-TYPE = 'FM006' AND WS-PROCESS-CHARGES = 'N'
              MOVE 'PCSSO67B'             TO AR-APPL-PROGRAM-ID         
           ELSE                                                         
              MOVE 'PCSSO67A'             TO AR-APPL-PROGRAM-ID         
           END-IF.                                                      
                                                                        
           MOVE CMN-USER-ID               TO AR-USER-ID.                
           MOVE AT-COMPANY-NO             TO AR-COMPANY-NO.             
           MOVE SPACES                    TO AR-PYMT-REFUNDED-IND.      
           MOVE ZEROES                    TO AR-TRAN-COMMENT-LEN.       
           MOVE SPACES                    TO AR-TRAN-COMMENT-TEXT.      
           MOVE SPACES                    TO AR-PYMT-FACILITY-CD        
                                             AR-RECORD-ONLY-FL          
                                             AR-DATE-ORIG-PYMT          
                                             AU-CODE-AR-AGE             
                                             AU-CODE-CONTRACT-TYPE      
                                             AU-CURRENCY-TYPE.          
           MOVE ZEROES                    TO AU-CURRENCY-AMT            
                                             AU-TRAN-APPL-NO.           
           MOVE -1                        TO WS-DATE-ORIG-PYMT-IND.     
                                                                        
           PERFORM 5410-INIT-CASH-JOURNAL THRU 5410-EXIT.               
                                                                        
           MOVE CMN-CD-COMPANY-NO         TO AR-CASH-COMPANY-NO.        
           MOVE CMN-CD-LOCAL-OFFICE       TO AR-CASH-LOCAL-OFFICE.      
           MOVE CMN-CD-REPORT-NO          TO AR-CASH-REPORT-NO.         
           MOVE CMN-CD-REPORT-DATE        TO AR-DATE-CASH-REPORT.       
           MOVE CMN-CASH-DRAWER-ID        TO AR-CASH-DRAWER-ID.         
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5410-INIT-CASH-JOURNAL                                        *         
      * THIS PARA CALLS CPD0006A TO VERIFY USER PROFILE AND GETS      *         
      *   CASH DRAWER ID FOR CASH JOURNALING                          *         
      *****************************************************************         
       5410-INIT-CASH-JOURNAL.                                          
                                                                        
           MOVE '5410'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           MOVE AT-COMPANY-NO            TO WS-100-COMPANY-NO.          
                                                                        
      ****** THESE FILEDS WERE POPULATED BY CALLING CPD00020  ******            
      ****** (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50. ******            
           MOVE 9                        TO WS-TRAN-OPER-LEVEL.         
           MOVE 1                        TO WS-TRAN-OCAP-FIELD.         
           MOVE 1                        TO WS-TRAN-OCAP-VALUE.         
           MOVE WS-C                     TO WS-TRAN-JRNL-TYPE.          
           MOVE WS-N                     TO WS-TRAN-HOLD-EXEMPT-FLAG.   
                                                                        
      ****** THESE FILEDS WERE POPULATED BY CALLING CPD00021 ******             
      ****** (PARAGRAPH 5980) TO VERIFY USER-ID.             ******             
           MOVE CMN-USER-ID              TO WS-JRNL-OL-TEMP-ID.         
           MOVE WS-JRNL-CK-OPER-ID       TO WS-JRNL-OPERATION-RQST.     
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           MOVE WS-JRNL-OL-OPR-LOC       TO WS-TERM-LOC.                
                                                                        
      ****** THESE FILEDS WERE POPULATED BY CALLING CPD00022 ******             
      ****** (PARAGRAPH 5990) TO ACCESS CASH DRAWER CONTROL. ******             
           MOVE ZEROES                   TO WS-CASH-DRAWER-ID.          
           MOVE '01'                     TO CMN-CD-COMPANY-NO.          
           MOVE '998'                    TO CMN-CD-LOCAL-OFFICE.        
           MOVE '998'                    TO CMN-CD-REPORT-NO.           
           MOVE WS-CURRENT-DATE          TO CMN-CD-REPORT-DATE.         
           MOVE 9999                     TO CMN-CASH-DRAWER-ID.         
                                                                        
           MOVE CMN-CD-COMPANY-NO        TO WS-JRNL-OL-COMPANY.         
           MOVE CMN-CD-LOCAL-OFFICE      TO WS-JRNL-OL-LOC-OFF.         
           MOVE CMN-CD-REPORT-NO         TO WS-JRNL-OL-REPORT-NO.       
           MOVE CMN-CD-REPORT-DATE       TO WS-JRNL-OL-REPORT-DT.       
           MOVE CMN-CASH-DRAWER-ID       TO WS-JRNL-OL-CASH-DRWR.       
                                                                        
           MOVE WS-TERM-LOC              TO WS-JRNL-OL-TERM-LOC         
                                            WS-JRNL-OL-CASH-LOC         
                                            WS-JRNL-OL-OPR-LOC.         
           MOVE WS-JRNL-VALIDATE-OPER    TO WS-JRNL-OPERATION-RQST.     
           MOVE WS-C                     TO WS-JRNL-SOURCE-CODE.        
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE   TO WS-JRNL-OL-AUTH-TYPE        
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE      
           END-IF.                                                      
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           MOVE WS-A                     TO WS-100-JRNL-SORT-ID.        
           MOVE AT-ACCOUNT-NO            TO WS-100-ACCT-NO.             
           MOVE AT-CUSTOMER-NO           TO WS-100-CUSTOMER-NO.         
           MOVE AT-PREMISE-NO            TO WS-100-PREMISE-NO.          
           MOVE 'SO67'                   TO WS-100-CODE-TERMINAL-TRAN.  
           MOVE WS-CURRENT-DATE          TO WS-100-DATE-LAST-ACTION.    
           MOVE WS-C                     TO WS-100-CODE-ENTRY-SOURCE.   
           MOVE AT-LOCAL-OFFICE          TO WS-100-LOCAL-OFFICE-CD.     
                                                                        
       5410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5420-TERMINATE-JRNL                                           *         
      *****************************************************************         
       5420-TERMINATE-JRNL.                                             
                                                                        
           MOVE '5420'                       TO ACTIVE-PARAGRAPH.       
           MOVE WS-JRNL-CNTRL-ONLY           TO WS-JRNL-OPERATION-RQST. 
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE  THRU 6400-EXIT.            
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'USERABEN'                TO ABEND-FUNCTION          
              MOVE 'ONLINE JOURNAL ROUTINE FAILED'                      
                                             TO DSNTIAR-MESSAGE-1       
              MOVE WS-JRNL-RTRN-CODE         TO DSNTIAR-MESSAGE-2       
              MOVE 'Y'                       TO WS-USER-FORCE-ABEND     
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       5420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5500-PROCESS-RECONNECT                                        *         
      *****************************************************************         
       5500-PROCESS-RECONNECT.                                          
                                                                        
           MOVE CMN-ACCOUNT-NO                 TO CC-ACCOUNT-NO         
                                                  DL-ACCOUNT-NO.        
           MOVE AT-COMPANY-NO                  TO U7-COMPANY-NO         
                                                                        
A37061     EVALUATE AT-ACCOUNT-TYPE-CODE                                
A37061         WHEN 'R'                                                 
A37061             MOVE 'R' TO WS-ACCT-TYPE-CD                          
A37061         WHEN 'C'                                                 
A37061             MOVE 'C' TO WS-ACCT-TYPE-CD                          
A37061         WHEN OTHER                                               
A37061             MOVE 'I' TO WS-ACCT-TYPE-CD                          
A37061     END-EVALUATE.                                                
                                                                        
           PERFORM 7500-GET-RECONNECT-INFO     THRU 7500-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00794        IF SEB-DATABASE OR AT-COMPANY-NO = '26'                   
C36210           MOVE DL-RECNCT-COLLECT-AMT    TO CC-AMT-ORIG-ENTERED   
C36210                                            CC-AMT-TRANS          
C36210                                            WS-TOTAL-RCC-CHARGES  
C36210                                            AR-AMT-ORIG-ENTERED   
P00794           IF AT-COMPANY-NO = '26'                                
P00794              MOVE U7-RCNCT-CHRG-AM      TO CC-AMT-ORIG-ENTERED   
P00794                                            CC-AMT-TRANS          
P00794                                            WS-TOTAL-RCC-CHARGES  
P00794                                            AR-AMT-ORIG-ENTERED   
P00794                                            DL-RECNCT-COLLECT-AMT 
P00794           END-IF                                                 
C37422*********  DETERMINE IF ANY PREPAYMENT TO RECONNECT HAS OCCURRED          
C37422*********  IF PARTIAL PREPAYMENT, UPDATE DURATION FROM NULL TO 1          
C37422*********  IF NO PREPAYMENT, INSERT FACTOR WITH DURATION = 1              
C37422*********  IF FULL PREPAYMENT, DO NOT INSERT FACTOR                       
C37422           PERFORM 5610-MOVE-FACTOR-VALUES THRU 5610-EXIT         
C37422           PERFORM 7800-GET-FACTOR-INFO    THRU 7800-EXIT         
C37422           PERFORM 7010-GET-TIMESTAMP      THRU 7010-EXIT         
C37422           IF PARTIAL-PREPAY                                      
C37422              PERFORM 8320-UPDATE-FACTOR   THRU 8320-EXIT         
C37422              PERFORM 8321-INSERT-MNT-ROW  THRU 8321-EXIT         
C37422           ELSE                                                   
C37422              IF NO-PREPAYMENT                                    
C37422                 PERFORM 7015-RETRIEVE-MAX-SEQ-NO THRU 7015-EXIT  
C37422                 ADD 1 TO FF-FIXED-FCTR-SEQ-NO                    
C37422                 PERFORM 8310-INSERT-FACTOR      THRU 8310-EXIT   
AC501G                 PERFORM 7010-GET-TIMESTAMP      THRU 7010-EXIT   
C37422                 PERFORM 5630-ADD-TRN-COMM       THRU 5630-EXIT   
C37422              END-IF                                              
C37422           END-IF                                                 
              ELSE                                                      
                 MOVE U7-RCNCT-CHRG-AM         TO CC-AMT-ORIG-ENTERED   
                                                  CC-AMT-TRANS          
                                                  WS-TOTAL-RCC-CHARGES  
                                                  AR-AMT-ORIG-ENTERED   
C36210        END-IF                                                    
           ELSE                                                         
              MOVE ZERO                        TO CC-AMT-ORIG-ENTERED   
                                                  CC-AMT-TRANS          
                                                  WS-TOTAL-RCC-CHARGES  
                                                  AR-AMT-ORIG-ENTERED   
           END-IF.                                                      
                                                                        
           MOVE 060                            TO CC-PYMT-PRIORITY-LVL. 
           MOVE WS-CURRENT-DATE                TO CC-DATE-TRANS.        
           MOVE ZEROES                         TO CC-AMT-TAX-CITY,      
                                                  CC-AMT-TAX-STATE,     
                                                  CC-AMT-TAX-XCISE,     
                                                  CC-AMT-TAX-OTHER.     
           MOVE WS-B                           TO CC-CODE-CCC-TYPE.     
                                                                        
           PERFORM 5510-CHECK-CONNECT-CHRG     THRU 5510-EXIT.          
                                                                        
           IF WS-CCC-ITEM-ID = 0 AND WS-CRED-CHRG-EXISTS = 'N'          
              PERFORM 7150-SELECT-MAX-CCC-ITEM-ID THRU 7150-EXIT        
              IF WS-NULL-IND02 < 0                                      
                 MOVE 0                        TO WS-CCC-ITEM-ID        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CRED-CHRG-EXISTS = 'N'                                 
              ADD +1                           TO WS-CCC-ITEM-ID        
              MOVE WS-CCC-ITEM-ID              TO CC-CCC-ITEM-ID        
           ELSE                                                         
              MOVE AC-ITEM-ID                  TO CC-CCC-ITEM-ID        
           END-IF.                                                      
                                                                        
           IF WS-CRED-CHRG-EXISTS = 'N'                                 
              PERFORM 5311-CREATE-AR-CONTROL   THRU 5311-EXIT           
           END-IF.                                                      
                                                                        
           IF WS-RECNCT-TYPE-CD = 'Y'                                   
             PERFORM 5321-CREATE-AR-TRN-HST    THRU 5321-EXIT           
             PERFORM 8300-INSERT-CONNECT-CHRG  THRU 8300-EXIT           
AC501G       PERFORM 7304-SELECT-CDP           THRU 7304-EXIT           
AC501G       MOVE 'A'                          TO WS-CDP(4:1)           
AC501G       MOVE WS-CDP                       TO AT-CODES-DATA-PRESENT 
AC501G       PERFORM 7307-UPDATE-CDP           THRU 7307-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 8700-DELETE-RECONNECT       THRU 8700-EXIT.          
                                                                        
           IF AC-AMT-TRAN-BALANCE = 0                                   
              PERFORM 7305-DELETE-RCC          THRU 7305-EXIT           
              PERFORM 7306-CHECK-FOR-RCC-DET   THRU 7306-EXIT           
              IF WS-RCC-DET-FOUND NOT = 'Y'                             
                 PERFORM 7303-DELETE-RCC-SUM   THRU 7303-EXIT           
                 PERFORM 7304-SELECT-CDP       THRU 7304-EXIT           
                 MOVE SPACES                   TO WS-CDP(4:1)           
                 MOVE WS-CDP                   TO AT-CODES-DATA-PRESENT 
                 PERFORM 7307-UPDATE-CDP       THRU 7307-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
C28237***************************************************************** 13660000
C28237* 5501-PROCESS-FXD-CHG-RCC                                      * 13670000
C28237* PROCESS RECONNECT FOR FIXED SERVICE CHARGES                   * 13680000
C28237***************************************************************** 13720000
C28237 5501-PROCESS-FXD-CHG-RCC.                                        
C28237                                                                  
C28237     IF WS-ORDER-TYPE-CD = 'CC' OR 'NC'                           
C28237        MOVE CMN-ACCOUNT-NO-NEW      TO   CC-ACCOUNT-NO           
C28237     ELSE                                                         
C28237        MOVE CMN-ACCOUNT-NO          TO   CC-ACCOUNT-NO           
C28237     END-IF.                                                      
C28237                                                                  
C28237     MOVE ZERO                       TO   CC-AMT-ORIG-ENTERED     
C28237                                          CC-AMT-TRANS            
C28237                                          WS-TOTAL-RCC-CHARGES    
C28237                                          AR-AMT-ORIG-ENTERED.    
C28237     MOVE 060                        TO   CC-PYMT-PRIORITY-LVL.   
C28237     MOVE WS-CURRENT-DATE            TO   CC-DATE-TRANS.          
C28237     MOVE ZEROES                     TO   CC-AMT-TAX-CITY         
C28237                                          CC-AMT-TAX-STATE        
C28237                                          CC-AMT-TAX-XCISE        
C28237                                          CC-AMT-TAX-OTHER.       
C28237     MOVE WS-B                       TO   CC-CODE-CCC-TYPE.       
                                                                        
A00479     MOVE WS-TOTAL-SO-CHARGES        TO   CC-AMT-ORIG-ENTERED     
A00479                                          CC-AMT-TRANS            
A00479                                          WS-TOTAL-RCC-CHARGES    
A00479                                          AR-AMT-ORIG-ENTERED.    
C28237     PERFORM 5510-CHECK-CONNECT-CHRG THRU 5510-EXIT.              
C28237     IF WS-CCC-ITEM-ID = 0 AND WS-CRED-CHRG-EXISTS = 'N'          
C28237        PERFORM 7150-SELECT-MAX-CCC-ITEM-ID THRU 7150-EXIT        
C28237        IF WS-NULL-IND02 < 0                                      
C28237           MOVE 0                        TO WS-CCC-ITEM-ID        
C28237        END-IF                                                    
C28237     END-IF.                                                      
C28237     IF WS-CRED-CHRG-EXISTS = 'N'                                 
C28237        ADD +1                           TO WS-CCC-ITEM-ID        
C28237        MOVE WS-CCC-ITEM-ID              TO CC-CCC-ITEM-ID        
C28237     ELSE                                                         
C28237        MOVE AC-ITEM-ID                  TO CC-CCC-ITEM-ID        
C28237     END-IF.                                                      
A00479     IF WS-CRED-CHRG-EXISTS = 'N'                                 
C28237        PERFORM 5311-CREATE-AR-CONTROL  THRU 5311-EXIT            
A00479     END-IF.                                                      
C28237     PERFORM 5322-CREATE-FXD-CHG-AR-TRN-HST                       
C28237                                     THRU 5322-EXIT.              
                                                                        
C28237     IF WS-CODE-WORK-PRD(WS-CHRGX) = 'A'                          
C28237        MOVE '006' TO U7-RCNCT-TYPE-NO                            
C28237     ELSE                                                         
C28237        MOVE '005' TO U7-RCNCT-TYPE-NO                            
C28237     END-IF.                                                      
C28237     PERFORM 8300-INSERT-CONNECT-CHRG    THRU 8300-EXIT.          
                                                                        
C28237     PERFORM 7304-SELECT-CDP   THRU 7304-EXIT.                    
C28237     MOVE 'A'                  TO   WS-CDP(4:1).                  
C28237     MOVE WS-CDP               TO   AT-CODES-DATA-PRESENT.        
C28237     PERFORM 7307-UPDATE-CDP   THRU 7307-EXIT.                    
                                                                        
C28237     IF AC-AMT-TRAN-BALANCE = 0                                   
C28237        PERFORM 7305-DELETE-RCC          THRU 7305-EXIT           
C28237        PERFORM 7306-CHECK-FOR-RCC-DET   THRU 7306-EXIT           
C28237        IF WS-RCC-DET-FOUND NOT = 'Y'                             
C28237           PERFORM 7303-DELETE-RCC-SUM                            
C28237                                     THRU 7303-EXIT               
C28237           PERFORM 7304-SELECT-CDP   THRU 7304-EXIT               
C28237           MOVE SPACES               TO   WS-CDP(4:1)             
C28237           MOVE WS-CDP               TO   AT-CODES-DATA-PRESENT   
C28237           PERFORM 7307-UPDATE-CDP   THRU 7307-EXIT               
C28237        END-IF                                                    
C28237     END-IF.                                                      
C28237                                                                  
C28237 5501-EXIT.                                                       
C28237     EXIT.                                                        
                                                                        
C26296*****************************************************************         
C26296* 5505-INS-AUTO-DEP-TRANS-HIST                                  *         
C26296*     LOAD VARIABLES FOR INS INTO TRANS HIST FOR AUTO DEP       *         
C26296*****************************************************************         
C26296 5505-INS-AUTO-DEP-TRANS-HIST.                                    
C26296                                                                  
C26296     MOVE CMN-ACCOUNT-NO          TO MH-ACCOUNT-NO.               
C26296     MOVE 'PANEL090C'             TO MH-APPL-PROGRAM-ID.          
C26296     MOVE 'F'                     TO MH-CODE-TRAN-TYPE.           
A37666     MOVE ZEROES                  TO MH-CUSTOMER-NO.              
C26296     MOVE WS-CURRENT-DATE         TO MH-DATE-TRANS.               
A37666     MOVE ZEROES                  TO MH-PREMISE-NO.               
C26296     MOVE SPACES                  TO MH-RESP-AREA-ID.             
C26296     MOVE WS-CURRENT-TIMESTAMP    TO MH-TRANS-HIST-SEQ-NO.        
C26296     MOVE 'SYSTEM'                TO MH-USER-ID.                  
C26296     MOVE 0                       TO MH-TRAN-COMMENT-LEN.         
C26296     MOVE SPACE                   TO MH-TRAN-COMMENT-TEXT.        
C26296                                                                  
C26296     MOVE +1                      TO MI-TRAN-APPL-NO.             
C26296     MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
C26296     MOVE 'AUTO DEP AMT'          TO MI-COLUMN-DESC.              
C26296     MOVE DL-AUTO-DEP-AM          TO WS-AUTO-DEP-AM-EDT.          
C26296     MOVE +15                     TO MI-PRV-COLUMN-VALUE-LEN.     
C26296     MOVE WS-AUTO-DEP-AM-EDT      TO MI-PRV-COLUMN-VALUE-TEXT.    
C26296     MOVE WS-3515-AUTO-DEP-AMT    TO WS-AUTO-DEP-AM-EDT.          
C26296     MOVE +15                     TO MI-CHG-COLUMN-VALUE-LEN.     
C26296     MOVE WS-AUTO-DEP-AM-EDT      TO MI-CHG-COLUMN-VALUE-TEXT.    
C26296     MOVE SPACES                  TO MI-TABLE-ID.                 
C26296     PERFORM 6530-LOAD-MNT-TRANS-HIST.                            
C26296                                                                  
C26296 5505-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
      ***************************************************************** 14189000
      * 5510-CHECK-CONNECT-CHRG                                       * 14188200
      * THIS PARAGRAPH CHECKS FOR EXISTING CONNECT CHARGES.  IF A     * 14188400
      * CONNECT CHARGE ROW EXISTS IN THE AR CONTROL TABLE WITH AN ITEM* 14188500
      * ID > 0 AND A TRAN BALANCE < 0 THEN ADD THE TOTAL STANDARD     * 14188600
      * CHARGES AMOUNT FOR THE SERVICE ORDER TO THE TRAN BALANCE OF   * 14188700
      * THIS AR CONTROL ROW.                                          * 14188800
      ***************************************************************** 14189000
       5510-CHECK-CONNECT-CHRG.                                         
                                                                        
           MOVE CMN-ACCOUNT-NO                  TO AC-ACCOUNT-NO.       
           MOVE +60                             TO AC-PYMT-PRIORITY-LVL.
                                                                        
           MOVE 'N'                             TO WS-CRED-CHRG-EXISTS. 
           PERFORM 7301-CHECK-AR-CTRL-CRED      THRU 7301-EXIT.         
           IF WS-CRED-CHRG-EXISTS = 'Y'                                 
              COMPUTE AC-AMT-TRAN-BALANCE = AC-AMT-TRAN-BALANCE         
                                            + CC-AMT-TRANS              
              PERFORM 7302-UPDATE-CTRL-CRED     THRU 7302-EXIT          
           END-IF.                                                      
                                                                        
       5510-EXIT.                                                       
           EXIT.                                                        
                                                                        
C24880*************************************************************             
C24880* 5550-POST-SO-CHRG-DFA.                                    *             
C24880*************************************************************             
C24880 5550-POST-SO-CHRG-DFA.                                           
C24880                                                                  
C24880     SET WS-CHRGX                       TO 1.                     
C24880     MOVE 0.00                          TO WS-DFA-AMOUNT.         
C24880     INITIALIZE DCLCSS-DFA-RECVBLE.                               
C24880     MOVE ZEROES                        TO WS-STATE-TAX-DET       
C24880                                           WS-AREA-TAX-DET.       
C24880                                                                  
C24880     PERFORM UNTIL WS-CODE-UTIL-TYPE(WS-CHRGX) = SPACES OR        
C24880                                                 LOW-VALUE OR     
C24880                                                 WS-CHRGX > 20    
C24880        IF WS-CHRGX = 1                                           
C24880           PERFORM 5560-GET-DFA-CHARGE  THRU 5560-EXIT            
C24880        END-IF                                                    
                                                                        
C24880        IF WS-CODE-UTIL-TYPE-PREV = WS-CODE-UTIL-TYPE(WS-CHRGX)   
C24880           COMPUTE WS-DFA-AMOUNT = WS-DFA-AMOUNT       +          
C24880                   WS-CHRG-FOR-MATERIAL-NUM (WS-CHRGX) +          
C24880                   WS-STD-LABOR-CHRG-NUM (WS-CHRGX)    +          
C24880                   WS-CALC-LABOR-CHRG-NUM (WS-CHRGX)   +          
C24880                   WS-OTHER-CHRG-NUM (WS-CHRGX)                   
C24880           COMPUTE WS-STATE-TAX-DET = WS-STATE-TAX-DET +          
C24880                   WS-STATE-TAX-NUM(WS-CHRGX)                     
C24880           COMPUTE WS-AREA-TAX-DET  = WS-AREA-TAX-DET  +          
C24880                   WS-AREA-TAX-NUM (WS-CHRGX)                     
C24880        ELSE                                                      
C24880           PERFORM 5570-ADD-DFA         THRU 5570-EXIT            
C24880           PERFORM 5560-GET-DFA-CHARGE  THRU 5560-EXIT            
C24880           COMPUTE WS-DFA-AMOUNT = WS-DFA-AMOUNT       +          
C24880                   WS-CHRG-FOR-MATERIAL-NUM (WS-CHRGX) +          
C24880                   WS-STD-LABOR-CHRG-NUM (WS-CHRGX)    +          
C24880                   WS-CALC-LABOR-CHRG-NUM (WS-CHRGX)   +          
C24880                   WS-OTHER-CHRG-NUM (WS-CHRGX)                   
C24880        END-IF                                                    
C24880        SET WS-CHRGX                    UP BY 1                   
C24880     END-PERFORM.                                                 
C24880     PERFORM 5570-ADD-DFA               THRU 5570-EXIT.           
C24880                                                                  
C24880 5550-EXIT.                                                       
C24880     EXIT.                                                        
                                                                        
C24880************************************************************              
C24880* 5560-GET-DFA-CHARGE.                                     *              
C24880************************************************************              
C24880 5560-GET-DFA-CHARGE.                                             
                                                                        
C24880     INITIALIZE WS-DFA-AMOUNT.                                    
C24880     MOVE WS-CODE-UTIL-TYPE(WS-CHRGX)   TO WS-CODE-UTIL-TYPE-PREV.
C24880     MOVE AT-ACCOUNT-NO                 TO DA-ACCOUNT-NO.         
C24880     MOVE +90                           TO DA-PYMT-PRIORITY-LVL.  
C24880     PERFORM 7000-MAX-DFA               THRU 7000-EXIT.           
C24880     ADD 1                              TO WS-DFA-ITEM-ID.        
C24880     MOVE AT-COMPANY-NO                 TO Z8-COMPANY-NO.         
C24880     MOVE 'H'                           TO Z8-CODE-DFA-DESC.      
C24880     MOVE 45                            TO DV-DFA-PYMT-PRIORITY.  
                                                                        
C28237     IF PROCESS-FXD-CHG-DFA                                       
C28237        IF WS-ORDER-TYPE-CD = 'ON'                                
C28237           MOVE 'X'                     TO DA-CODE-DFA-DESC       
C28237        ELSE                                                      
C28237           MOVE 'Y'                     TO DA-CODE-DFA-DESC       
C28237        END-IF                                                    
C28237     ELSE                                                         
C24880        PERFORM 7020-GET-CHARGES-GL-NO  THRU 7020-EXIT            
C24880        MOVE Z8-CODE-DFA-DESC           TO DA-CODE-DFA-DESC       
C28237     END-IF.                                                      
C24880*    MOVE Z8-CHARGE-AM                  TO WS-DFA-AMOUNT.                 
                                                                        
C24880 5560-EXIT.                                                       
C24880     EXIT.                                                        
                                                                        
C24880**********************************************************                
C24880*5570-ADD-DFA.                                           *                
C24880**********************************************************                
C24880 5570-ADD-DFA.                                                    
C24880     PERFORM 7010-GET-TIMESTAMP         THRU 7010-EXIT.           
C24880     MOVE WS-DFA-ITEM-ID                TO DA-DFA-ITEM-ID         
C24880                                           DV-AGREEMENT-NO.       
C24880     MOVE WS-DFA-AMOUNT                 TO DA-AMT-ORIG-ENTERED    
C24880                                           DA-AMT-MO-PYMT         
C24880                                           DV-AMT-CONTRACT-DEFR   
C24880                                           DV-AMT-DAY-00.         
C24880     MOVE WS-CURRENT-DATE               TO DA-DATE-OF-AGREE       
C24880                                           DA-DATE-PYMT-START.    
C24880     MOVE 'A'                           TO DA-CODE-DFA-TYPE       
C24880                                           DA-CODE-DFA-STATUS.    
C24880     MOVE 0                             TO DA-AMT-UNDEFERD-RECV.  
C24880     MOVE 1                             TO DA-NO-SCHED-PYMTS.     
C24880     MOVE CMN-USER-ID                   TO DA-CSR-USERID.         
C24880     MOVE 0                             TO DA-AMT-EXTRA-DEPOSIT.  
C24880     MOVE 0                             TO DA-FRST-ERNST-PAY-AMT. 
C24880     MOVE SPACES                        TO DA-FRST-ERNST-PAY-DT.  
C24880     MOVE 0                             TO DA-SCND-ERNST-PAY-AMT. 
C24880     MOVE SPACES                        TO DA-SCND-ERNST-PAY-DT.  
C24880     MOVE SPACES                        TO DA-CODE-COMPLY-HIST.   
C24880     MOVE '0'                           TO DA-RCNTLY-BLLD-MTH.    
C24880     MOVE WS-CURRENT-TIMESTAMP          TO DA-LAST-UPDATE-TS.     
C24880     MOVE ' '                           TO DA-REVERSE-REASON.     
C24880     MOVE -1                            TO WS-DFA-NULL-IND        
C24880                                           WS-DFA-NULL-IND2.      
C24880     PERFORM 8150-INSERT-DFA            THRU 8150-EXIT.           
C24880                                                                  
C24880     INITIALIZE DCLCSS-AR-CNTL.                                   
C24880     MOVE DA-ACCOUNT-NO                 TO AC-ACCOUNT-NO.         
C24880     MOVE +90                           TO AC-PYMT-PRIORITY-LVL.  
C24880     PERFORM 7030-AR-CNTL               THRU 7030-EXIT.           
C24880     MOVE WS-DFA-ITEM-ID                TO AC-ITEM-ID.            
C24880     MOVE WS-CURRENT-TIMESTAMP          TO AC-LAST-UPDATE-TS.     
C24880     MOVE WS-DFA-AMOUNT                 TO AC-AMT-TRAN-BALANCE.   
C24880     PERFORM 8200-INSERT-AR-CNTL        THRU 8200-EXIT.           
C24880                                                                  
C24880     MOVE WS-CURRENT-TIMESTAMP          TO AR-TRANS-HIST-SEQ-NO   
C24880                                           AU-TRANS-HIST-SEQ-NO.  
C24880     MOVE DA-ACCOUNT-NO                 TO AR-ACCOUNT-NO          
C24880                                           AU-ACCOUNT-NO.         
C24880     MOVE WS-DFA-AMOUNT                 TO AR-AMT-ORIG-ENTERED    
C24880                                           AU-AMT-POSTED          
C24880                                           WS-102-AMT-POSTED.     
C24880     MOVE AT-TOTAL-AR-BALANCE           TO AR-AMT-BILLED-UNPAID.  
C24880     MOVE 'PCSSO67C'                    TO AR-APPL-PROGRAM-ID.    
C24880     MOVE AT-COMPANY-NO                 TO AR-CASH-COMPANY-NO     
C24880                                           AR-COMPANY-NO.         
C24880     MOVE +9999                         TO AR-CASH-DRAWER-ID.     
C24880     MOVE '998'                         TO AR-CASH-LOCAL-OFFICE.  
C24880     MOVE '998'                         TO AR-CASH-REPORT-NO.     
C24880     MOVE 'A'                           TO AR-CODE-TRAN-TYPE.     
C24880     MOVE WS-CURRENT-DATE               TO AR-DATE-CASH-REPORT    
C24880                                           AR-DATE-TRANS.         
C24880     MOVE SPACES                        TO AR-DATE-ORIG-PYMT      
C24880                                           AR-PYMT-FACILITY-CD    
C24880                                           AR-PYMT-RCPT-PRNTD-CD  
C24880                                           AR-PYMT-REFUNDED-IND   
C24880                                           AR-RECORD-ONLY-FL.     
C24880     MOVE PF-RESP-AREA-ID               TO AR-RESP-AREA-ID.       
C24880     MOVE CMN-USER-ID                   TO AR-USER-ID.            
C24880     MOVE SPACES                        TO AU-CODE-AR-AGE         
C24880     MOVE 0                             TO AU-CURRENCY-AMT.       
C24880     MOVE SPACES                        TO AU-CODE-CONTRACT-TYPE  
C24880                                           AU-CURRENCY-TYPE       
C24880     MOVE WS-DFA-ITEM-ID                TO AU-ITEM-ID.            
C24880     MOVE +1                            TO AU-TRAN-APPL-NO.       
C24880     MOVE Z8-GL-ACCT-NO                 TO AU-GL-ACCT-CREDIT.     
C28237     IF NOT PROCESS-FXD-CHG-DFA                                   
C24880        MOVE 'AR-DFA'                   TO GO-GL-ACCT-NAME        
C24880        PERFORM 7400-SELECT-GL-ACCT-NO  THRU 7400-EXIT            
C24880        MOVE GO-GL-ACCT-NO              TO WS-GL-ACCT-NO-AR-DFA   
C24880        MOVE WS-GL-ACCT-NO-AR-DFA       TO AU-GL-ACCT-DEBIT       
C28237     END-IF.                                                      
C24880     PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST                        
C24880                                        THRU 6500-EXIT.           
C24880     MOVE DA-ACCOUNT-NO                 TO AC-ACCOUNT-NO          
C24880     MOVE DA-ACCOUNT-NO                 TO DV-ACCOUNT-NO.         
C24880     MOVE AC-PYMT-PRIORITY-LVL          TO DV-PYMT-PRIORITY-LVL.  
C24880     PERFORM 8500-INSERT-DFA-RECV       THRU 8500-EXIT.           
C24880     INITIALIZE DCLCSS-DFA-RECVBLE.                               
C24880                                                                  
C24880     INITIALIZE CJF00102                                          
C24880     MOVE WS-DFA-AMOUNT                 TO WS-TOTAL-SO-CHARGES    
C24880     PERFORM 5600-LOAD-JRNL-VARS        THRU 5600-EXIT.           
C24880                                                                  
C24880     PERFORM 6400-ONLINE-JRNL-ROUTINE   THRU 6400-EXIT.           
C24880                                                                  
C24880     IF WS-JRNL-RTRN-CODE NOT EQUAL SPACES                        
C24880        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C24880        MOVE 'USERABEN'                 TO ABEND-PROGRAM          
C24880        MOVE 'ONLINE JOURNAL ROUTINE FAILED'                      
C24880                                        TO DSNTIAR-MESSAGE-1      
C24880        MOVE WS-JRNL-RTRN-CODE          TO DSNTIAR-MESSAGE-2      
C24880        MOVE 'Y'                        TO WS-USER-FORCE-ABEND    
C24880        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C24880     END-IF.                                                      
C24880                                                                  
C24880 5570-EXIT.                                                       
C24880     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5600-LOAD-JRNL-VARS.                                          *         
      *****************************************************************         
       5600-LOAD-JRNL-VARS.                                             
                                                                        
           MOVE AT-TOTAL-AR-BALANCE         TO WS-102-ACCT-END-AR-BAL.  
           MOVE SPACES                      TO WS-102-CASH-DRAWER-USED. 
           MOVE 102                         TO WS-102-JRNL-FORMAT-NO.   
                                                                        
           IF CMN-SERV-ORDER-TYPE = 'FM006' AND WS-PROCESS-CHARGES = 'N'
              MOVE WS-TOTAL-RCC-CHARGES     TO WS-102-AMOUNT-ENTERED    
              MOVE SPACES                   TO WS-102-AR-AGE            
           ELSE                                                         
              MOVE WS-TOTAL-SO-CHARGES      TO WS-102-AMOUNT-ENTERED    
              MOVE 'P'                      TO WS-102-AR-AGE            
              MOVE AU-AMT-POSTED            TO WS-102-AMT-POSTED        
           END-IF.                                                      
                                                                        
           MOVE AU-GL-ACCT-DEBIT            TO WS-102-ACCT-GEN-LED-DR.  
           MOVE AU-GL-ACCT-CREDIT           TO WS-102-ACCT-GEN-LED-CR.  
           MOVE WS-CURRENT-DATE             TO WS-102-DATE-AR-BILLED.   
           MOVE AU-ITEM-ID                  TO WS-102-ITEM-ID-NO.       
                                                                        
           ADD AU-AMT-POSTED                TO WS-AMT-POSTED-TOTAL.     
           MOVE WS-AMT-POSTED-TOTAL         TO WS-102-DETAIL-END-BAL.   
                                                                        
           MOVE ZEROES                      TO WS-102-DETAIL-END-AR-BAL.
           MOVE WS-STATE-TAX-DET            TO WS-102-STAT-TAX-AMT.     
      *TPR 17950                                                                
      *    MOVE WS-AREA-TAX-DET             TO WS-102-CITY-TAX-AMT.             
           MOVE ZEROES                      TO WS-102-CITY-TAX-AMT.     
      *    MOVE ZEROES                      TO WS-102-OTHER-TAX-AMT.            
           MOVE WS-AREA-TAX-DET             TO WS-102-OTHER-TAX-AMT.    
           MOVE ZEROES                      TO WS-102-XCIS-TAX-AMT.     
                                                                        
           IF WS-STATE-TAX-NUM(WS-CHRGX) GREATER THAN ZEROES            
              MOVE SPACES                   TO WS-102-CODE-STAT-TAX-XMT 
           ELSE                                                         
              MOVE WS-A                     TO WS-102-CODE-STAT-TAX-XMT 
           END-IF.                                                      
                                                                        
C24880     IF AC-ITEM-ID > 45000000                                     
C24880        IF WS-STATE-TAX-DET GREATER THAN ZEROES                   
C24880           MOVE SPACES                TO WS-102-CODE-STAT-TAX-XMT 
C24880        ELSE                                                      
C24880           MOVE WS-A                  TO WS-102-CODE-STAT-TAX-XMT 
C24880        END-IF                                                    
C24880     END-IF.                                                      
                                                                        
      * TPR 17950                                                               
           IF WS-AREA-TAX-NUM(WS-CHRGX) GREATER THAN ZEROES             
      *       MOVE SPACES                   TO WS-102-CODE-CITY-TAX-XMT         
              MOVE SPACES                   TO WS-102-CODE-OTHER-TAX-XMT
           ELSE                                                         
      *       MOVE WS-A                     TO WS-102-CODE-CITY-TAX-XMT         
              MOVE WS-A                     TO WS-102-CODE-OTHER-TAX-XMT
           END-IF.                                                      
                                                                        
C24880     IF AC-ITEM-ID > 45000000                                     
C24880        IF WS-AREA-TAX-DET GREATER THAN ZEROES                    
C24880           MOVE SPACES                TO WS-102-CODE-OTHER-TAX-XMT
C24880        ELSE                                                      
C24880           MOVE WS-A                  TO WS-102-CODE-OTHER-TAX-XMT
C24880        END-IF                                                    
C24880     END-IF.                                                      
                                                                        
      *    MOVE WS-A                       TO WS-102-CODE-OTHER-TAX-XMT.        
           MOVE WS-A                       TO WS-102-CODE-CITY-TAX-XMT. 
           MOVE WS-A                       TO WS-102-CODE-XCIS-TAX-XMT. 
                                                                        
           MOVE PR-REV-DISTRICT-CD      TO WS-102-CODE-REVENUE-DISTRICT.
           MOVE PR-CODE-PREMISE-STAT    TO WS-102-CODE-PREMISE-STATUS.  
           MOVE CU-CODE-EMPL-ACCT       TO WS-102-CODE-EMPL-ACCT.       
           MOVE AT-CODE-COMPANY-ACCT    TO WS-102-CODE-COMPANY-ACCT.    
           MOVE AT-CODE-ACCT-STAT       TO WS-102-CODE-ACCOUNT-STATUS.  
           MOVE AU-TRAN-APPL-NO         TO WS-100-JRNL-TRAN-APPL-NO.    
           MOVE AT-DATE-LAST-ACTION     TO WS-100-DATE-LAST-ACTION.     
           MOVE WS-CURRENT-DATE         TO AT-DATE-LAST-ACTION.         
           MOVE AU-AMT-POSTED           TO WS-JRNL-GEN-LEG-CREDIT-AMT   
                                           WS-JRNL-RCV-DEBIT-AMT.       
                                                                        
           MOVE CJF00102                TO WS-100-USER-DEFINED-AREA.    
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST.      
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
C36587*****************************************************************         
C36587* 5610-MOVE-FACTOR-VALUES                                       *         
C36587*****************************************************************         
C36587 5610-MOVE-FACTOR-VALUES.                                         
C36587                                                                  
C36587     PERFORM 7024-RETRIEVE-UTIL-ENV   THRU 7024-EXIT.             
C36587     PERFORM 7025-RETRIEVE-MIN-REV-MO THRU 7025-EXIT.             
C36587     MOVE WS-EFF-DATE-FROM      TO FF-EFF-DATE-FROM.              
                                                                        
C36587     MOVE DL-DATETIME-SETUP     TO WS-SETUP-TS-DATE.              
C36587     MOVE WS-SETUP-TS           TO FF-LAST-UPDATE-TS.             
C36587                                                                  
C36587     MOVE AT-ACCOUNT-NO         TO FF-ACCOUNT-NO.                 
C36587     MOVE 'RECCHGTAX'           TO FF-FACTOR-ID.                  
C36587     MOVE VI-CODE-UTIL-TYPE     TO FF-CODE-UTIL-TYPE.             
C36587     MOVE VI-IC-NO              TO FF-IC-NO.                      
C36587     MOVE '10'                  TO FF-CMPNT-ID-CD.                
C36587     MOVE 'B'                   TO FF-CODE-SEASON.                
C36587     MOVE 'R'                   TO FF-INSTR-USE-TYPE-CD.          
C36587     MOVE 0                     TO FF-CODE-TIME-PERIOD.           
C36587     MOVE '2999-12-31'          TO FF-EFF-DATE-TO.                
C36587     MOVE '00'                  TO FF-FIXED-FCTR-TYP-CD.          
C36587     MOVE DL-RECNCT-COLLECT-AMT TO FF-FACTOR.                     
C36587     MOVE 0                     TO FF-FAC-CHRG-BASE-AM.           
C36587     MOVE 0                     TO FF-RT-PKG-OPT-SEQ-NO.          
C36587     MOVE 1                     TO FF-DURATION-REMAIN-NO.         
C36587                                                                  
C36587                                                                  
C36587 5610-EXIT.                                                       
C36587     EXIT.                                                        
                                                                        
C36587*****************************************************************         
C36587* 5620-CHECK-COMMENT                                            *         
C36587*****************************************************************         
C36587 5620-CHECK-COMMENT.                                              
C36587                                                                  
C36587     SET WS-CHRGX                         TO 1.                   
C36587     PERFORM UNTIL VLD-COMMENT OR WS-CHRGX > 20                   
C36587        EVALUATE WS-COMMENTS(WS-CHRGX)                            
C36587           WHEN 'MTRORDPR'                                        
C36587              MOVE 'MTRORDPR' TO FF-FACTOR-ID                     
C36587              MOVE 'MTR ORD-TAXABLE' TO MH-TRAN-COMMENT-TEXT      
C36587              MOVE 15 TO MH-TRAN-COMMENT-LEN                      
C36587              SET VLD-COMMENT TO TRUE                             
C36587           WHEN 'MTRORDNPR'                                       
C36587              MOVE 'MTRORDNPR' TO FF-FACTOR-ID                    
C36587              MOVE 'MTR ORD-NOT TAXABLE' TO MH-TRAN-COMMENT-TEXT  
C36587              MOVE 19 TO MH-TRAN-COMMENT-LEN                      
C36587              SET VLD-COMMENT TO TRUE                             
C36587           WHEN OTHER                                             
C36587              CONTINUE                                            
C36587        END-EVALUATE                                              
C36587        SET WS-CHRGX UP BY 1                                      
C36587     END-PERFORM.                                                 
                                                                        
C36587     PERFORM 7024-RETRIEVE-UTIL-ENV   THRU 7024-EXIT.             
C36587     PERFORM 7025-RETRIEVE-MIN-REV-MO THRU 7025-EXIT.             
C36587     MOVE WS-EFF-DATE-FROM      TO FF-EFF-DATE-FROM.              
                                                                        
C37422     PERFORM 7010-GET-TIMESTAMP       THRU 7010-EXIT.             
C37422     MOVE WS-CURRENT-TIMESTAMP  TO FF-LAST-UPDATE-TS.             
C36587                                                                  
C36587     MOVE AT-ACCOUNT-NO         TO FF-ACCOUNT-NO                  
C36587     MOVE VI-CODE-UTIL-TYPE     TO FF-CODE-UTIL-TYPE.             
C36587     MOVE VI-IC-NO              TO FF-IC-NO.                      
C36587     MOVE '10'                  TO FF-CMPNT-ID-CD.                
C36587     MOVE 'B'                   TO FF-CODE-SEASON.                
C36587     MOVE 'R'                   TO FF-INSTR-USE-TYPE-CD.          
C36587     MOVE 0                     TO FF-CODE-TIME-PERIOD.           
C36587     MOVE '2999-12-31'          TO FF-EFF-DATE-TO.                
C36587     MOVE '00'                  TO FF-FIXED-FCTR-TYP-CD.          
C36587     MOVE WS-TOTAL-SO-CHARGES   TO FF-FACTOR.                     
C36587     MOVE 0                     TO FF-FAC-CHRG-BASE-AM.           
C36587     MOVE 0                     TO FF-RT-PKG-OPT-SEQ-NO.          
C36587     MOVE 1                     TO FF-DURATION-REMAIN-NO.         
C36587                                                                  
C36587     PERFORM 7015-RETRIEVE-MAX-SEQ-NO THRU 7015-EXIT.             
C36587     ADD 1 TO FF-FIXED-FCTR-SEQ-NO.                               
C36587                                                                  
C36587 5620-EXIT.                                                       
C36587     EXIT.                                                        
                                                                        
C36587*****************************************************************         
C36587* 5630-ADD-TRN-COMM.                                            *         
C36587*****************************************************************         
C36587 5630-ADD-TRN-COMM.                                               
                                                                        
C37422     IF CMN-SERV-ORDER-TYPE = 'FM006'                             
C37422        MOVE 'INSERT RCC - CHARGE AMOUNT TO BE TAXED ONLY' TO     
C37422            MH-TRAN-COMMENT-TEXT                                  
C37422        MOVE 43 TO MH-TRAN-COMMENT-LEN                            
C37422     END-IF.                                                      
                                                                        
C36587     MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
C36587     MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
C36587     MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
P00794     MOVE SPACES                   TO MH-RESP-AREA-ID.            
A37666     MOVE ZEROES                   TO MH-CUSTOMER-NO.             
C36587     MOVE CMN-ACCOUNT-NO           TO MH-ACCOUNT-NO.              
A37666     MOVE ZEROES                   TO MH-PREMISE-NO.              
C36587     MOVE 'SYSTEM'                 TO MH-USER-ID.                 
C36587     MOVE 'PCSSO67E'               TO MH-APPL-PROGRAM-ID.         
                                                                        
C36587     MOVE +1                      TO MI-TRAN-APPL-NO.             
C36587     MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
C36587     MOVE 'FACTOR-VALUE'          TO MI-COLUMN-DESC.              
C36587     MOVE +7                      TO MI-PRV-COLUMN-VALUE-LEN.     
C36587     MOVE '**NEW**'               TO MI-PRV-COLUMN-VALUE-TEXT.    
C36587     MOVE FF-FACTOR               TO WS-FACTOR-TEXT.              
C36587     MOVE WS-FACTOR-TEXT          TO WS-FACT-VAL-Z.               
C36587     MOVE WS-FACT-VAL-Z           TO MI-CHG-COLUMN-VALUE-TEXT.    
C36587     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
C36587                                  TO MI-CHG-COLUMN-VALUE-LEN.     
C36587     MOVE SPACES                  TO MI-TABLE-ID.                 
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
C36587     MOVE +2                      TO MI-TRAN-APPL-NO.             
C36587     MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
C36587     MOVE 'DURATION'              TO MI-COLUMN-DESC.              
C36587     MOVE +7                      TO MI-PRV-COLUMN-VALUE-LEN.     
C36587     MOVE '**NEW**'               TO MI-PRV-COLUMN-VALUE-TEXT.    
C36587     MOVE +04                     TO MI-CHG-COLUMN-VALUE-LEN.     
C36587     MOVE FF-DURATION-REMAIN-NO   TO WS-DURATION-TEXT.            
C36587     MOVE WS-DURATION-TEXT        TO WS-DURA-VAL-Z.               
C36587     MOVE WS-DURA-VAL-Z           TO MI-CHG-COLUMN-VALUE-TEXT.    
C36587     MOVE SPACES                  TO MI-TABLE-ID.                 
C36587     PERFORM 6530-LOAD-MNT-TRANS-HIST.                            
                                                                        
C36587 5630-EXIT.                                                       
C36587     EXIT.                                                        
      *****************************************************************         
      *      COPY BOOK FOR CASH DRAWER JOURNALING                     * 14205000
      *****************************************************************         
           EXEC SQL                                                             
A00956        INCLUDE CPD0006A                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00008                                                  
           END-EXEC.                                                            
                                                                        
C26296*****************************************************************         
C26296* COPYBOOK FOR MAINT TRANS HIST                                 *         
C26296*****************************************************************         
C26296     EXEC SQL                                                             
C26296        INCLUDE CPD00067                                                  
C26296     END-EXEC.                                                            
                                                                        
C24880*****************************************************************         
C24880* 7000-MAX-DFA.                                                 *         
C24880*****************************************************************         
C24880 7000-MAX-DFA.                                                    
                                                                        
C24880     EXEC SQL                                                     
C24880        SELECT MAX(DFA_ITEM_ID)                                   
C24880          INTO :WS-DFA-ITEM-ID :WS-DFA-NULL-IND                    
C24880          FROM CSS_DFA_ACCT                                       
C24880         WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO                 
C24880           AND PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL          
C24880           AND DFA_ITEM_ID       > 45000000                       
                                                            
C24880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(DFA_ITEM_ID)                                           
MFA-TR*         INTO :WS-DFA-ITEM-ID:WS-DFA-NULL-IND                            
MFA-TR*         FROM CSS_DFA_ACCT                                               
MFA-TR*        WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL                  
MFA-TR*          AND DFA_ITEM_ID       > 45000000                               
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C24880     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C24880                                                                  
C24880     EVALUATE WS-ACTIVE-RETURN-CODE                               
C24880         WHEN SUCCESSFUL-CALL                                     
C24880         WHEN NOT-FOUND                                           
C24880            IF WS-DFA-NULL-IND = -1                               
C24880               MOVE 45000000             TO WS-DFA-ITEM-ID        
C24880            END-IF                                                
C24880         WHEN OTHER                                               
C24880             MOVE '7000'                 TO ACTIVE-PARAGRAPH      
C24880             MOVE 'CSS_DFA_ACCT'         TO CMN-TABLE-1           
C24880             MOVE 'ACCOUNT_NO'           TO CMN-TABLE-ELEMENT-1   
C24880             MOVE DA-ACCOUNT-NO          TO CMN-HOSTVAR-ELEMENT-1 
C24880             PERFORM 9900-SQL-ERROR-ROUTINE                       
C24880                                         THRU 9900-EXIT           
C24880     END-EVALUATE.                                                
                                                                        
C24880 7000-EXIT.                                                       
C24880     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7010-GET-TIMESTAMP                                            *         
      *****************************************************************         
       7010-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :WS-CURRENT-TIMESTAMP,                             
                     :WS-CURRENT-DATE                                   
                FROM CSS_MODEL_SQL                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP,                                         
MFA-TR*              CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-TIMESTAMP,                                     
MFA-TR*              :WS-CURRENT-DATE                                           
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_MODEL_SQL'            TO CMN-TABLE-1            
              MOVE 'CURRENT TIMESTAMP'        TO CMN-TABLE-ELEMENT-1    
              MOVE 'CURRENT DATE'             TO CMN-TABLE-ELEMENT-2    
              MOVE WS-CURRENT-TIMESTAMP       TO CMN-HOSTVAR-ELEMENT-1  
              MOVE WS-CURRENT-DATE            TO CMN-HOSTVAR-ELEMENT-2  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
C36587******************************************************************09420000
C36587* 7015-RETRIEVE-MAX-SEQ-NO.                                               
C36587******************************************************************09420000
C36587 7015-RETRIEVE-MAX-SEQ-NO.                                        
C36587                                                                  
C36587     EXEC SQL                                                     
C36587         SELECT MAX(FIXED_FCTR_SEQ_NO)                            
C36587           INTO :FF-FIXED-FCTR-SEQ-NO :WS-NULL-IND-FF              
C36587           FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                   
C36587          WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO            
C36587            AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE        
C36587            AND FF.IC_NO              = :FF-IC-NO                 
C36587                                                           
                                                            
C36587     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(FIXED_FCTR_SEQ_NO)                                    
MFA-TR*          INTO :FF-FIXED-FCTR-SEQ-NO:WS-NULL-IND-FF                      
MFA-TR*          FROM CSS_FIXED_FCTR FF                                         
MFA-TR*         WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                    
MFA-TR*           AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE                
MFA-TR*           AND FF.IC_NO              = :FF-IC-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7015                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36587                                                                  
C36587     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36587                                                                  
C36587     EVALUATE WS-ACTIVE-RETURN-CODE                               
C36587         WHEN SUCCESSFUL-CALL                                     
C36587         WHEN NOT-FOUND                                           
C36587             IF WS-NULL-IND-FF < 0                                
C36587                MOVE 0 TO FF-FIXED-FCTR-SEQ-NO                    
C36587             END-IF                                               
C36587         WHEN OTHER                                               
C36587             MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
C36587             MOVE '7015'            TO ACTIVE-PARAGRAPH           
C36587             MOVE 'SELECT'          TO ABEND-FUNCTION             
C36587             MOVE 'CSS_FIXED_FCTR'  TO TABLE-1                    
C36587             MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
C36587             MOVE FF-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
C36587             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
C36587             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C36587     END-EVALUATE.                                                
C36587                                                                  
C36587 7015-EXIT.                                                       
C36587     EXIT.                                                        
                                                                        
C24880**************************************************************            
C24880* 7020-GET-CHARGES-GL-NO.                                    *            
C24880**************************************************************            
C24880 7020-GET-CHARGES-GL-NO.                                          
C24880                                                                  
C24880     EXEC SQL                                                     
C24880        SELECT GL_ACCT_NO,                                        
C24880               CHARGE_TYPE_CD,                                    
C24880               CHARGE_DESC_TX                                     
C24880*              CHARGE_AM                                                  
C24880          INTO :Z8-GL-ACCT-NO,                                    
C24880               :Z8-CHARGE-TYPE-CD,                                
C24880               :Z8-CHARGE-DESC-TX                                 
C24880*              :Z8-CHARGE-AM                                              
C24880          FROM CSS_CHARGE_TYPE                                    
C24880         WHERE COMPANY_NO       = :Z8-COMPANY-NO                  
C24880           AND CODE_DFA_DESC    = :Z8-CODE-DFA-DESC               
C24880           AND CHARGE_STATUS_CD = 'A'                             
C24880           AND CHARGE_SEQUENCE_NO IN                              
C24880               (SELECT MAX(CHARGE_SEQUENCE_NO)                    
C24880                  FROM CSS_CHARGE_TYPE                            
C24880                 WHERE COMPANY_NO       = :Z8-COMPANY-NO          
C24880                   AND CODE_DFA_DESC    = :Z8-CODE-DFA-DESC       
C24880                   AND CHARGE_STATUS_CD = 'A')                    
                                                            
C24880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NO,                                                
MFA-TR*              CHARGE_TYPE_CD,                                            
MFA-TR*              CHARGE_DESC_TX                                             
MFA-TR*              CHARGE_AM                                                  
MFA-TR*         INTO :Z8-GL-ACCT-NO,                                            
MFA-TR*              :Z8-CHARGE-TYPE-CD,                                        
MFA-TR*              :Z8-CHARGE-DESC-TX                                         
MFA-TR*              :Z8-CHARGE-AM                                              
MFA-TR*         FROM CSS_CHARGE_TYPE                                            
MFA-TR*        WHERE COMPANY_NO       = :Z8-COMPANY-NO                          
MFA-TR*          AND CODE_DFA_DESC    = :Z8-CODE-DFA-DESC                       
MFA-TR*          AND CHARGE_STATUS_CD = 'A'                                     
MFA-TR*          AND CHARGE_SEQUENCE_NO IN                                      
MFA-TR*              (SELECT MAX(CHARGE_SEQUENCE_NO)                            
MFA-TR*                 FROM CSS_CHARGE_TYPE                                    
MFA-TR*                WHERE COMPANY_NO       = :Z8-COMPANY-NO                  
MFA-TR*                  AND CODE_DFA_DESC    = :Z8-CODE-DFA-DESC               
MFA-TR*                  AND CHARGE_STATUS_CD = 'A')                            
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C24880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C24880        NEXT SENTENCE                                             
C24880     ELSE                                                         
C24880        MOVE '7020'                     TO ACTIVE-PARAGRAPH       
C24880        MOVE 'CSS_CHARGE_TYPE'          TO CMN-TABLE-1            
C24880        MOVE 'COMPANY_NO'               TO CMN-TABLE-ELEMENT-1    
C24880        MOVE 'CODE_DFA_DESC'            TO CMN-TABLE-ELEMENT-2    
C24880        MOVE Z8-COMPANY-NO              TO CMN-HOSTVAR-ELEMENT-1  
C24880        MOVE Z8-CODE-DFA-DESC           TO CMN-HOSTVAR-ELEMENT-2  
C24880        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C24880     END-IF.                                                      
C24880                                                                  
C24880 7020-EXIT.                                                       
C24880     EXIT.                                                        
                                                                        
C36587******************************************************************09420000
C36587* 7024-RETRIEVE-UTIL-ENV                                                  
C36587******************************************************************09420000
C36587 7024-RETRIEVE-UTIL-ENV.                                          
                                                                        
C36587     MOVE CMN-SERV-ORDER-NO             TO VI-SERV-ORDER-NO.      
C36587                                                                  
C36587     EXEC SQL                                                     
C36587         SELECT VI.IC_NO ,                                        
C36587                VI.CODE_UTIL_TYPE                                 
C36587           INTO :VI-IC-NO,                                        
C36587                :VI-CODE-UTIL-TYPE                                
C36587           FROM CSS_SO_ORDER_INST VI                              
C36587          WHERE VI.SERV_ORDER_NO = :VI-SERV-ORDER-NO              
                                                            
C36587                                                                  
C36587     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VI.IC_NO ,                                                
MFA-TR*               VI.CODE_UTIL_TYPE                                         
MFA-TR*          INTO :VI-IC-NO,                                                
MFA-TR*               :VI-CODE-UTIL-TYPE                                        
MFA-TR*          FROM CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE VI.SERV_ORDER_NO = :VI-SERV-ORDER-NO                      
MFA-TR*        QUERYNO 7024                                                     
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36587                                                                  
C36587     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36587                                                                  
C36587     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36587        NEXT SENTENCE                                             
C36587     ELSE                                                         
C36587        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C36587        MOVE '7024'               TO ACTIVE-PARAGRAPH             
C36587        MOVE 'SELECT'             TO ABEND-FUNCTION               
C36587        MOVE 'CSS_SO_ORDER_INST'  TO TABLE-1                      
C36587        MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1              
C36587        MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1            
C36587        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36587        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36587     END-IF.                                                      
C36587                                                                  
C36587 7024-EXIT.                                                       
C36587     EXIT.                                                        
                                                                        
C36587******************************************************************09420000
C36587* 7025-RETRIEVE-MIN-REV-MO                                                
C36587******************************************************************09420000
C36587 7025-RETRIEVE-MIN-REV-MO.                                        
C36587                                                                  
C37422     EXEC SQL                                                     
C37422         SELECT (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           CIS.SUBSTR3(PARM_DATA,1,10) E) T)                      
C37422           INTO :WS-COMMONDATE                                    
C37422           FROM CSS_JOB_PARM                                      
C37422          WHERE PROGRAM_NAME = 'COMMONDATE'                       
C37422            AND COMPANY_NO   = '01'                               
C37422            AND CMND_CODE    = 'CA00'                             
C37422            AND SEQ_NO       = 0                                  
C37422            AND STATUS       = 'A'                                
                                                           
C37422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE(SUBSTR(PARM_DATA,1,10))                              
MFA-TR*          INTO :WS-COMMONDATE                                            
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME = 'COMMONDATE'                               
MFA-TR*           AND COMPANY_NO   = '01'                                       
MFA-TR*           AND CMND_CODE    = 'CA00'                                     
MFA-TR*           AND SEQ_NO       = 0                                          
MFA-TR*           AND STATUS       = 'A'                                        
MFA-TR*        QUERYNO 70251                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37422                                                                  
C37422     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C37422        MOVE WS-COMMONDATE        TO BN-DATE-EXTRACT              
C37422     ELSE                                                         
C37422        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C37422        MOVE '7025'               TO ACTIVE-PARAGRAPH             
C37422        MOVE 'SELECT'             TO ABEND-FUNCTION               
C37422        MOVE 'CSS_JOB_PARM'       TO TABLE-1                      
C37422        MOVE 'PROGRAM_NAME'       TO TABLE-ELEMENT-1              
C37422        MOVE 'COMMONDATE'         TO HOSTVAR-ELEMENT-1            
C37422        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C37422        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C37422     END-IF.                                                      
C36587                                                                  
C36587     EXEC SQL                                                     
C36587         SELECT MIN(REVENUE_MONTH)                                
C36587           INTO :BN-REVENUE-MONTH                                 
C36587           FROM CSS_BILL_WINDOW BN                                
C36587          WHERE BN.DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                
                                                           
C36587     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MIN(REVENUE_MONTH)                                        
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE BN.DATE_EXTRACT = :BN-DATE-EXTRACT                        
MFA-TR*        QUERYNO 70252                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36587                                                                  
C36587     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36587                                                                  
C36587     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36587        MOVE BN-REVENUE-MONTH     TO WS-REVENUE-MONTH-RED         
C36587        MOVE WS-REVENUE-MONTH-RED TO WS-REVENUE-MONTH             
C36587        MOVE WS-REVENUE-YYYY      TO WS-EFF-DATE-FROM-YYYY        
C36587        MOVE WS-REVENUE-MM        TO WS-EFF-DATE-FROM-MM          
C36587     ELSE                                                         
C36587        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C36587        MOVE '7025'               TO ACTIVE-PARAGRAPH             
C36587        MOVE 'SELECT'             TO ABEND-FUNCTION               
C36587        MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                      
C36587        MOVE 'DATE_EXTRACT'       TO TABLE-ELEMENT-1              
C36587        MOVE WS-CURRENT-DATE      TO HOSTVAR-ELEMENT-1            
C36587        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36587        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36587     END-IF.                                                      
C36587                                                                  
C36587 7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
C24880******************************************************************        
C24880* 7030-AR-CNTL.                                                           
C24880******************************************************************        
C24880 7030-AR-CNTL.                                                    
C24880                                                                  
C24880     MOVE '7030'                        TO ACTIVE-PARAGRAPH.      
C24880     MOVE 0                             TO AC-ITEM-ID.            
C24880                                                                  
C24880     EXEC SQL                                                     
C24880         SELECT ACCOUNT_NO                                        
C24880           INTO :AC-ACCOUNT-NO                                    
C24880           FROM CSS_AR_CNTL                                       
C24880          WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
C24880            AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
C24880            AND ITEM_ID           = :AC-ITEM-ID                   
                                                            
C24880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :AC-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                 
MFA-TR*           AND ITEM_ID           = :AC-ITEM-ID                           
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C24880                                                                  
C24880     EVALUATE WS-ACTIVE-RETURN-CODE                               
C24880         WHEN SUCCESSFUL-CALL                                     
C24880             CONTINUE                                             
C24880         WHEN NOT-FOUND                                           
C24880             MOVE WS-CURRENT-TIMESTAMP  TO AC-LAST-UPDATE-TS      
C24880             MOVE 0                     TO AC-AMT-TRAN-BALANCE    
C24880             PERFORM 8200-INSERT-AR-CNTL                          
C24880                                        THRU 8200-EXIT            
C24880         WHEN OTHER                                               
C24880             MOVE 'CSS_AR_CNTL'         TO CMN-TABLE-1            
C24880             MOVE 'ACCOUNT_NO'          TO CMN-TABLE-ELEMENT-1    
C24880             MOVE 'PYMT_PRIORITY_LVL'   TO CMN-TABLE-ELEMENT-2    
C24880             MOVE AC-ACCOUNT-NO         TO CMN-HOSTVAR-ELEMENT-1  
C24880             MOVE AC-PYMT-PRIORITY-LVL  TO CMN-HOSTVAR-ELEMENT-2  
C24880             PERFORM 9900-SQL-ERROR-ROUTINE                       
C24880                                        THRU 9900-EXIT            
C24880     END-EVALUATE.                                                
C24880                                                                  
C24880 7030-EXIT.                                                       
C24880     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7050-SELECT-ACCOUNT                                           *         
      * THIS PARA SELECTS DATA FROM CSS_ACCOUNT FOR THE ACCOUNT       *         
      *****************************************************************         
       7050-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT AT.COMPANY_NO        ,                            
                      AT.LOCAL_OFFICE      ,                            
                      AT.CUSTOMER_NO       ,                            
                      AT.PREMISE_NO        ,                            
                      AT.TOTAL_AR_BALANCE  ,                            
                      AT.CODES_DATA_PRESENT,                            
                      AT.CODE_COMPANY_ACCT ,                            
                      AT.CODE_ACCT_STAT    ,                            
                      AT.DATE_LAST_ACTION  ,                            
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS    ,                            
                      CU.CODE_EMPL_ACCT    ,                            
                      PR.REV_DISTRICT_CD   ,                            
                      PR.CODE_PREMISE_STAT ,                            
A37061                AT.ACCOUNT_TYPE_CODE                              
                 INTO :AT-COMPANY-NO        ,                           
                      :AT-LOCAL-OFFICE      ,                           
                      :AT-CUSTOMER-NO       ,                           
                      :AT-PREMISE-NO        ,                           
                      :AT-TOTAL-AR-BALANCE  ,                           
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-CODE-COMPANY-ACCT ,                           
                      :AT-CODE-ACCT-STAT    ,                           
                      :AT-DATE-LAST-ACTION  ,                           
                      :AT-LAST-UPDATE-TS    ,                           
                      :CU-CODE-EMPL-ACCT    ,                           
                      :PR-REV-DISTRICT-CD   ,                           
                      :PR-CODE-PREMISE-STAT ,                           
A37061                :AT-ACCOUNT-TYPE-CODE                             
                 FROM CSS_ACCOUNT  AT,                                  
                      CSS_PREMISE  PR,                                  
                      CSS_CUSTOMER CU                                   
                WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
                  AND AT.PREMISE_NO  = PR.PREMISE_NO                    
                  AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.COMPANY_NO        ,                                    
MFA-TR*               AT.LOCAL_OFFICE      ,                                    
MFA-TR*               AT.CUSTOMER_NO       ,                                    
MFA-TR*               AT.PREMISE_NO        ,                                    
MFA-TR*               AT.TOTAL_AR_BALANCE  ,                                    
MFA-TR*               AT.CODES_DATA_PRESENT,                                    
MFA-TR*               AT.CODE_COMPANY_ACCT ,                                    
MFA-TR*               AT.CODE_ACCT_STAT    ,                                    
MFA-TR*               AT.DATE_LAST_ACTION  ,                                    
MFA-TR*               AT.LAST_UPDATE_TS    ,                                    
MFA-TR*               CU.CODE_EMPL_ACCT    ,                                    
MFA-TR*               PR.REV_DISTRICT_CD   ,                                    
MFA-TR*               PR.CODE_PREMISE_STAT ,                                    
MFA-TR*               AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*          INTO :AT-COMPANY-NO        ,                                   
MFA-TR*               :AT-LOCAL-OFFICE      ,                                   
MFA-TR*               :AT-CUSTOMER-NO       ,                                   
MFA-TR*               :AT-PREMISE-NO        ,                                   
MFA-TR*               :AT-TOTAL-AR-BALANCE  ,                                   
MFA-TR*               :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-CODE-COMPANY-ACCT ,                                   
MFA-TR*               :AT-CODE-ACCT-STAT    ,                                   
MFA-TR*               :AT-DATE-LAST-ACTION  ,                                   
MFA-TR*               :AT-LAST-UPDATE-TS    ,                                   
MFA-TR*               :CU-CODE-EMPL-ACCT    ,                                   
MFA-TR*               :PR-REV-DISTRICT-CD   ,                                   
MFA-TR*               :PR-CODE-PREMISE-STAT ,                                   
MFA-TR*               :AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*          FROM CSS_ACCOUNT  AT,                                          
MFA-TR*               CSS_PREMISE  PR,                                          
MFA-TR*               CSS_CUSTOMER CU                                           
MFA-TR*         WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                           
MFA-TR*           AND AT.PREMISE_NO  = PR.PREMISE_NO                            
MFA-TR*           AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_ACCOUNT'              TO CMN-TABLE-1            
              MOVE 'CSS_PREMISE'              TO CMN-TABLE-2            
              MOVE 'CSS_CUSTOMER'             TO CMN-TABLE-3            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE AT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7100-SELECT-MAX-CNT-ITEM-ID                                   *         
      * THIS PARA SELECTS MAXIMUM CONTRACT ITEM ID USED FOR AN ACCOUNT*         
      *****************************************************************         
       7100-SELECT-MAX-CNT-ITEM-ID.                                     
                                                                        
           EXEC SQL                                                     
               SELECT MAX(CNT_ITEM_ID)                                  
                 INTO :WS-CNT-ITEM-ID :WS-NULL-IND01                     
                 FROM CSS_CONTRACT                                      
                WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL         
C37033            AND  CNT_ITEM_ID NOT BETWEEN 9000000 AND 9500999      
C37033            AND   CNT_ITEM_ID      >= 5000000                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(CNT_ITEM_ID)                                          
MFA-TR*          INTO :WS-CNT-ITEM-ID:WS-NULL-IND01                             
MFA-TR*          FROM CSS_CONTRACT                                              
MFA-TR*         WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL                 
MFA-TR*           AND  CNT_ITEM_ID NOT BETWEEN 9000000 AND 9500999              
MFA-TR*           AND   CNT_ITEM_ID      >= 5000000                             
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CONTRACT'             TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
              MOVE CT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE CT-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7150-SELECT-MAX-CCC-ITEM-ID                                   *         
      * THIS PARA SELECTS MAXIMUM CONNECT ITEM ID USED FOR AN ACCOUNT *         
      *****************************************************************         
       7150-SELECT-MAX-CCC-ITEM-ID.                                     
                                                                        
           EXEC SQL                                                     
               SELECT MAX (CCC_ITEM_ID)                                 
                 INTO :WS-CCC-ITEM-ID :WS-NULL-IND02                     
                 FROM CSS_CONNECT_CHRG                                  
                WHERE ACCOUNT_NO        = :CC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :CC-PYMT-PRIORITY-LVL         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX (CCC_ITEM_ID)                                         
MFA-TR*          INTO :WS-CCC-ITEM-ID:WS-NULL-IND02                             
MFA-TR*          FROM CSS_CONNECT_CHRG                                          
MFA-TR*         WHERE ACCOUNT_NO        = :CC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :CC-PYMT-PRIORITY-LVL                 
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CONNECT_CHRG'         TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
              MOVE CC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE CC-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7200-SELECT-CONTRACT-INFO                                     *         
      * THIS PARA SELECTS CONTRACT-INFO DETAILS                       *         
      *****************************************************************         
       7200-SELECT-CONTRACT-INFO.                                       
                                                                        
           EXEC SQL                                                     
               SELECT GL_ACCT_NO        ,                               
                      COST_CENTER       ,                               
                      REBATE_CD         ,                               
                      INTEREST_CD       ,                               
                      DFLT_INTRST_RT    ,                               
                      WRT_OFF_GL_ACCT_NO                                
                 INTO :K6-GL-ACCT-NO        ,                           
                      :K6-COST-CENTER       ,                           
                      :K6-REBATE-CD         ,                           
                      :K6-INTEREST-CD       ,                           
                      :K6-DFLT-INTRST-RT    ,                           
                      :K6-WRT-OFF-GL-ACCT-NO                            
                 FROM CSS_CONTRACT_INFO                                 
                WHERE CNT_NAME_CD = :K6-CNT-NAME-CD                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GL_ACCT_NO        ,                                       
MFA-TR*               COST_CENTER       ,                                       
MFA-TR*               REBATE_CD         ,                                       
MFA-TR*               INTEREST_CD       ,                                       
MFA-TR*               DFLT_INTRST_RT    ,                                       
MFA-TR*               WRT_OFF_GL_ACCT_NO                                        
MFA-TR*          INTO :K6-GL-ACCT-NO        ,                                   
MFA-TR*               :K6-COST-CENTER       ,                                   
MFA-TR*               :K6-REBATE-CD         ,                                   
MFA-TR*               :K6-INTEREST-CD       ,                                   
MFA-TR*               :K6-DFLT-INTRST-RT    ,                                   
MFA-TR*               :K6-WRT-OFF-GL-ACCT-NO                                    
MFA-TR*          FROM CSS_CONTRACT_INFO                                         
MFA-TR*         WHERE CNT_NAME_CD = :K6-CNT-NAME-CD                             
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CONTRACT_INFO'        TO CMN-TABLE-1            
              MOVE 'CNT_NAME_CD'              TO CMN-TABLE-ELEMENT-1    
              MOVE K6-CNT-NAME-CD             TO CMN-HOSTVAR-ELEMENT-1  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7300-SELECT-AR-CNTL                                           *         
      * THIS PARA CHECKS IF SUMMARY ROW FOR CONTRACT EXISTS           *         
      *****************************************************************         
       7300-SELECT-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-AR-SUMMARY-EXISTS                             
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
                  AND ITEM_ID           = :AC-ITEM-ID                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-AR-SUMMARY-EXISTS                                     
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                 
MFA-TR*           AND ITEM_ID           = :AC-ITEM-ID                           
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_AR_CNTL'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
              MOVE 'ITEM_ID'                  TO CMN-TABLE-ELEMENT-3    
              MOVE AC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE AC-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
              MOVE AC-ITEM-ID                 TO CMN-HOSTVAR-ELEMENT-3  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7301-CHECK-AR-CTRL-CRED                                       *         
      * THIS PARA CHECKS IF SUMMARY ROW FOR CONTRACT EXISTS           *         
      *****************************************************************         
       7301-CHECK-AR-CTRL-CRED.                                         
                                                                        
           EXEC SQL                                                     
               SELECT 'Y',                                              
                      ITEM_ID,                                          
                      AMT_TRAN_BALANCE                                  
                 INTO :WS-CRED-CHRG-EXISTS,                             
                      :AC-ITEM-ID,                                      
                      :AC-AMT-TRAN-BALANCE                              
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
                  AND ITEM_ID           > 0                             
                  AND AMT_TRAN_BALANCE  < 0                             
                  AND LAST_UPDATE_TS    =                               
                        (SELECT MAX(LAST_UPDATE_TS)                     
                           FROM CSS_AR_CNTL                             
                          WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO      
                          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL 
                          AND ITEM_ID           > 0                     
                          AND AMT_TRAN_BALANCE  < 0 )                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y',                                                      
MFA-TR*               ITEM_ID,                                                  
MFA-TR*               AMT_TRAN_BALANCE                                          
MFA-TR*          INTO :WS-CRED-CHRG-EXISTS,                                     
MFA-TR*               :AC-ITEM-ID,                                              
MFA-TR*               :AC-AMT-TRAN-BALANCE                                      
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                 
MFA-TR*           AND ITEM_ID           > 0                                     
MFA-TR*           AND AMT_TRAN_BALANCE  < 0                                     
MFA-TR*           AND LAST_UPDATE_TS    =                                       
MFA-TR*                 (SELECT MAX(LAST_UPDATE_TS)                             
MFA-TR*                    FROM CSS_AR_CNTL                                     
MFA-TR*                   WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO              
MFA-TR*                   AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
MFA-TR*                   AND ITEM_ID           > 0                             
MFA-TR*                   AND AMT_TRAN_BALANCE  < 0 )                           
MFA-TR*        QUERYNO 7301                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7301'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_AR_CNTL'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
              MOVE 'ITEM_ID'                  TO CMN-TABLE-ELEMENT-3    
              MOVE 'AMT_TRAN_BALANCE'         TO CMN-TABLE-ELEMENT-4    
              MOVE AC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE AC-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
              MOVE '> 0'                      TO CMN-HOSTVAR-ELEMENT-3  
              MOVE '< 0'                      TO CMN-HOSTVAR-ELEMENT-4  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7301-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7302-UPDATE-CTRL-CRED.                                        *         
      * THIS PARAGRAPH UPDATES THE TRAN AMOUNT FOR THE AR CONTROL     *         
      * RECORD FOUND IN 7301.                                         *         
      *****************************************************************         
       7302-UPDATE-CTRL-CRED.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_AR_CNTL                                       
                  SET AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE          
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
                  AND ITEM_ID           = :AC-ITEM-ID                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_AR_CNTL                                               
MFA-TR*           SET AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE                  
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                 
MFA-TR*           AND ITEM_ID           = :AC-ITEM-ID                           
MFA-TR*        QUERYNO 7302                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7302'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_AR_CNTL'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
              MOVE 'ITEM_ID'                  TO CMN-TABLE-ELEMENT-3    
              MOVE 'AMT_TRAN_BALANCE'         TO CMN-TABLE-ELEMENT-4    
              MOVE AC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE AC-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
              MOVE AC-ITEM-ID                 TO CMN-HOSTVAR-ELEMENT-3  
              MOVE AC-AMT-TRAN-BALANCE        TO WS-AMT-TRAN-BALANCE-ED 
              MOVE WS-AMT-TRAN-BALANCE-ED     TO CMN-HOSTVAR-ELEMENT-4  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7302-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7303-DELETE-RCC-SUM.                                          *         
      * THIS PARAGRAPH DELETES THE AR_CNTL SUMMARY RECORD FOR THE     *         
      * RECONNECT.                                                    *         
      *****************************************************************         
       7303-DELETE-RCC-SUM.                                             
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_AR_CNTL                                  
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
                  AND ITEM_ID           = 0                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_AR_CNTL                                          
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                 
MFA-TR*           AND ITEM_ID           = 0                                     
MFA-TR*        QUERYNO 7303                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7303'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_AR_CNTL'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
              MOVE AC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE AC-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7303-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7304-SELECT-CDP                                               *         
      * THIS PARAGRAPH UNSETS THE CDP IF RCC ROW IS DELETED           *         
      *****************************************************************         
       7304-SELECT-CDP.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT CODES_DATA_PRESENT                                
               INTO :WS-CDP                                             
               FROM CSS_ACCOUNT                                         
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODES_DATA_PRESENT                                        
MFA-TR*        INTO :WS-CDP                                                     
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*        QUERYNO 7304                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7304'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_ACCOUNT'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE AC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7304-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7305-DELETE-RCC.                                              *         
      * THIS PARAGRAPH DELETES THE DETAIL RECORD FOR THE RECONNECT.   *         
      *****************************************************************         
       7305-DELETE-RCC.                                                 
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_AR_CNTL                                  
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
                  AND ITEM_ID           = :CC-CCC-ITEM-ID               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_AR_CNTL                                          
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                 
MFA-TR*           AND ITEM_ID           = :CC-CCC-ITEM-ID                       
MFA-TR*        QUERYNO 7305                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7305'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_AR_CNTL'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
              MOVE 'ITEM_ID'                  TO CMN-TABLE-ELEMENT-3    
              MOVE AC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE AC-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
              MOVE CC-CCC-ITEM-ID             TO CMN-HOSTVAR-ELEMENT-3  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7305-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7306-CHECK-FOR-RCC-DET.                                       *         
      * THIS PARAGRAPH DELETES THE DETAIL RECORD FOR THE RECONNECT.   *         
      *****************************************************************         
       7306-CHECK-FOR-RCC-DET.                                          
                                                                        
           EXEC SQL                                                     
               SELECT DISTINCT 'Y'                                      
                 INTO :WS-RCC-DET-FOUND                                 
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
                  AND ITEM_ID           > 0                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTINCT 'Y'                                              
MFA-TR*          INTO :WS-RCC-DET-FOUND                                         
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                 
MFA-TR*           AND ITEM_ID           > 0                                     
MFA-TR*        QUERYNO 7306                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7306'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_AR_CNTL'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
              MOVE AC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE AC-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7306-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7307-UPDATE-CDP.                                              *         
      * THIS PARAGRAPH UNSETS THE CDP                                 *         
      *****************************************************************         
       7307-UPDATE-CDP.                                                 
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
              SET  CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT          
              WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*       SET  CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT                  
MFA-TR*       WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 7307                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'                        TO WS-UNSET-CDP           
              MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT       
           ELSE                                                         
              MOVE '7307'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_ACCOUNT'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE AC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7307-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7400-SELECT-GL-ACCT-NO                                        *         
      * THIS PARA SELECTS GL-ACCOUNT-NO FOR THE GL-ACCOUNT-NAME       *         
      *****************************************************************         
       7400-SELECT-GL-ACCT-NO.                                          
                                                                        
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :GO-GL-ACCT-NO                                    
                 FROM CSS_GL_ACCT_NO                                    
      *         WHERE COMPANY_NO   = :GO-COMPANY-NO                             
                WHERE COMPANY_NO   = '01'                               
                  AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GL_ACCT_NO                                                
MFA-TR*          INTO :GO-GL-ACCT-NO                                            
MFA-TR*          FROM CSS_GL_ACCT_NO                                            
MFA-TR*         WHERE COMPANY_NO   = :GO-COMPANY-NO                             
MFA-TR*         WHERE COMPANY_NO   = '01'                                       
MFA-TR*           AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                           
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_GL_ACCT_NO'           TO CMN-TABLE-1            
              MOVE 'COMPANY_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'GL_ACCT_NAME'             TO CMN-TABLE-ELEMENT-2    
              MOVE '01'                       TO CMN-HOSTVAR-ELEMENT-1  
              MOVE GO-GL-ACCT-NAME            TO CMN-HOSTVAR-ELEMENT-2  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7500-GET-RECONNECT-INFO                                       *         
      * THIS PARAGRAPH SELECTS THE RECONNECT TYPE, AMOUNT AND OTHER   *         
      * CODES PERTINENT TO THE RECONNECT ORDER.                       *         
      *****************************************************************         
       7500-GET-RECONNECT-INFO.                                         
                                                                        
           EXEC SQL                                                     
               SELECT U7.RCNCT_TYPE_NO    ,                             
                      U7.RCNCT_CHRG_AM    ,                             
                      U7.RCNCT_ELEC_SVC_FL,                             
                      U7.RCNCT_GAS_SVC_FL ,                             
                      DL.RECNCT_COLLECT_AMT,                            
C26296                DL.AUTO_DEP_CERT_NO,                              
C26296                DL.AUTO_DEP_AM,                                   
C37422                DL.DATETIME_SETUP                                 
                 INTO :U7-RCNCT-TYPE-NO    ,                            
                      :U7-RCNCT-CHRG-AM    ,                            
                      :U7-RCNCT-ELEC-SVC-FL,                            
                      :U7-RCNCT-GAS-SVC-FL ,                            
                      :DL-RECNCT-COLLECT-AMT,                           
C26296                :DL-AUTO-DEP-CERT-NO,                             
C26296                :DL-AUTO-DEP-AM,                                  
C37422                :DL-DATETIME-SETUP                                
                 FROM CSS_RECONNECT_CHRG U7,                            
                      CSS_RECONNECT      DL                             
                WHERE DL.ACCOUNT_NO          = :DL-ACCOUNT-NO           
                  AND U7.COMPANY_NO          = :U7-COMPANY-NO           
                  AND DL.RECNCT_TYPE_CD      = U7.RCNCT_TYPE_NO         
T23235            AND U7.RCNCT_ACCT_TYPE_CD  = :WS-ACCT-TYPE-CD         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT U7.RCNCT_TYPE_NO    ,                                     
MFA-TR*               U7.RCNCT_CHRG_AM    ,                                     
MFA-TR*               U7.RCNCT_ELEC_SVC_FL,                                     
MFA-TR*               U7.RCNCT_GAS_SVC_FL ,                                     
MFA-TR*               DL.RECNCT_COLLECT_AMT,                                    
MFA-TR*               DL.AUTO_DEP_CERT_NO,                                      
MFA-TR*               DL.AUTO_DEP_AM,                                           
MFA-TR*               DL.DATETIME_SETUP                                         
MFA-TR*          INTO :U7-RCNCT-TYPE-NO    ,                                    
MFA-TR*               :U7-RCNCT-CHRG-AM    ,                                    
MFA-TR*               :U7-RCNCT-ELEC-SVC-FL,                                    
MFA-TR*               :U7-RCNCT-GAS-SVC-FL ,                                    
MFA-TR*               :DL-RECNCT-COLLECT-AMT,                                   
MFA-TR*               :DL-AUTO-DEP-CERT-NO,                                     
MFA-TR*               :DL-AUTO-DEP-AM,                                          
MFA-TR*               :DL-DATETIME-SETUP                                        
MFA-TR*          FROM CSS_RECONNECT_CHRG U7,                                    
MFA-TR*               CSS_RECONNECT      DL                                     
MFA-TR*         WHERE DL.ACCOUNT_NO          = :DL-ACCOUNT-NO                   
MFA-TR*           AND U7.COMPANY_NO          = :U7-COMPANY-NO                   
MFA-TR*           AND DL.RECNCT_TYPE_CD      = U7.RCNCT_TYPE_NO                 
MFA-TR*           AND U7.RCNCT_ACCT_TYPE_CD  = :WS-ACCT-TYPE-CD                 
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-RECNCT-TYPE-CD                          
                 MOVE  0  TO DL-AUTO-DEP-CERT-NO                        
                 MOVE  0  TO DL-AUTO-DEP-AM                             
              WHEN OTHER                                                
                 MOVE '7500'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'CSS_RECONNECT_CHRG'    TO CMN-TABLE-1            
                 MOVE 'CSS_RECONNECT'         TO CMN-TABLE-2            
                 MOVE 'ACCOUNT_NO'            TO CMN-TABLE-ELEMENT-1    
                 MOVE 'COMPANY_NO'            TO CMN-TABLE-ELEMENT-2    
                 MOVE DL-ACCOUNT-NO           TO CMN-HOSTVAR-ELEMENT-1  
                 MOVE U7-COMPANY-NO           TO CMN-HOSTVAR-ELEMENT-2  
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7600-SELECT-DELINQUENCY                                       *         
      * THIS PARAGRAPH SELECTS THE DELINQUENCY FACTOR.                *         
      *****************************************************************         
       7600-SELECT-DELINQUENCY.                                         
                                                                        
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY                                   
                WHERE DELINQ_CD  = :C8-DELINQ-CD                        
                  AND COMPANY_NO = :AT-COMPANY-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*           AND COMPANY_NO = :AT-COMPANY-NO                               
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_DELINQUENCY'          TO CMN-TABLE-1            
              MOVE 'DELINQ_CD'                TO CMN-TABLE-ELEMENT-1    
              MOVE C8-DELINQ-CD               TO CMN-HOSTVAR-ELEMENT-1  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
C28237***************************************************************** 17012900
C28237* 7700-SEL-FXD-CHG-GL-ACCT                                      * 17013000
C28237* THIS PARAGRAPH SELECTS THE GL ACCT FOR FIXED SO CHARGES       * 17013200
C28237***************************************************************** 17013400
C28237 7700-SEL-FXD-CHG-GL-ACCT.                                        
C28237                                                                  
C28237     EXEC SQL                                                     
C28237          SELECT                                                  
C28237                  GL_ACCT_DEBIT                                   
C28237                 ,GL_ACCT_CREDIT                                  
C28237                 ,PYMT_PRIORITY_LVL                               
C28237                 ,CNT_NAME_CD                                     
C28237            INTO                                                  
C28237                  :SV-GL-ACCT-DEBIT                               
C28237                 ,:SV-GL-ACCT-CREDIT                              
C28237                 ,:SV-PYMT-PRIORITY-LVL                           
C28237                 ,:SV-CNT-NAME-CD                                 
C28237            FROM                                                  
C28237                  CSS_SO_SERVICE_CHG                              
C28237           WHERE                                                  
C28237                  COMPANY_NO         = :SV-COMPANY-NO             
C28237             AND  ORDER_TYPE_CD      = :SV-ORDER-TYPE-CD          
C28237             AND  WORK_PERIOD_CD     = :SV-WORK-PERIOD-CD         
C28237             AND  ACCOUNT_TYPE_CODE  = :SV-ACCOUNT-TYPE-CODE      
                                                            
C28237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     17013700
MFA-TR*         SELECT                                                  17013800
MFA-TR*                 GL_ACCT_DEBIT                                   17013800
MFA-TR*                ,GL_ACCT_CREDIT                                  17013800
MFA-TR*                ,PYMT_PRIORITY_LVL                               17013800
MFA-TR*                ,CNT_NAME_CD                                     17013800
MFA-TR*           INTO                                                  17013900
MFA-TR*                 :SV-GL-ACCT-DEBIT                               17013800
MFA-TR*                ,:SV-GL-ACCT-CREDIT                              17013800
MFA-TR*                ,:SV-PYMT-PRIORITY-LVL                           17013800
MFA-TR*                ,:SV-CNT-NAME-CD                                 17013800
MFA-TR*           FROM                                                  17014000
MFA-TR*                 CSS_SO_SERVICE_CHG                              17014000
MFA-TR*          WHERE                                                  17014100
MFA-TR*                 COMPANY_NO         = :SV-COMPANY-NO                     
MFA-TR*            AND  ORDER_TYPE_CD      = :SV-ORDER-TYPE-CD                  
MFA-TR*            AND  WORK_PERIOD_CD     = :SV-WORK-PERIOD-CD                 
MFA-TR*            AND  ACCOUNT_TYPE_CODE  = :SV-ACCOUNT-TYPE-CODE              
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                    17014200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28237                                                                  
C28237     MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.   
C28237                                                                  
C28237     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C28237        MOVE  SV-GL-ACCT-CREDIT      TO  WS-EREV-CCC-GL           
C28237                                         WS-GREV-CCC-GL-HOLD      
C28237                                         AU-GL-ACCT-CREDIT        
C28237                                         Z8-GL-ACCT-NO            
C28237        MOVE  SV-GL-ACCT-DEBIT       TO  AU-GL-ACCT-DEBIT         
C28237                                         WS-GL-ACCT-NO-AR-DFA     
C28237                                         WS-GL-ACCT-NO-AR-CNT     
C28237                                         WS-GL-ACCT-NO-AR-CCC     
C28237                                                                  
C28237     ELSE                                                         
C28237        MOVE '7700'                  TO ACTIVE-PARAGRAPH          
C28237        MOVE 'CSS_SO_SERVICE_CHG'    TO CMN-TABLE-1               
C28237        MOVE 'COMPANY_NO'            TO CMN-TABLE-ELEMENT-1       
C28237        MOVE 'ORDER_TYPE_CD'         TO CMN-TABLE-ELEMENT-2       
C28237        MOVE 'WORK_PERIOD_CD'        TO CMN-TABLE-ELEMENT-3       
C28237        MOVE SV-COMPANY-NO           TO CMN-HOSTVAR-ELEMENT-2     
C28237        MOVE SV-ORDER-TYPE-CD        TO CMN-HOSTVAR-ELEMENT-1     
C28237        MOVE SV-WORK-PERIOD-CD       TO CMN-HOSTVAR-ELEMENT-3     
C28237        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C28237     END-IF.                                                      
C28237                                                                  
C28237 7700-EXIT.                                                       
C28237     EXIT.                                                        
                                                                        
C37422***************************************************************** 17012900
C37422* 7800-GET-FACTOR-INFO                                          * 17013000
C37422* THIS PARAGRAPH DETERMINES IF A RECONNECT TAX FACTOR WAS       * 17013200
C37422*      ALREADY CREATED THROUGH PREPAYMENT PROCESS               * 17013200
C37422***************************************************************** 17013400
C37422 7800-GET-FACTOR-INFO.                                            
C37422                                                                  
C37422     EXEC SQL                                                     
C37422          SELECT FF.FIXED_FCTR_SEQ_NO,                            
C37422                 DURATION_REMAIN_NO                               
C37422            INTO :FF-FIXED-FCTR-SEQ-NO,                           
C37422                 :FF-DURATION-REMAIN-NO :WS-NULL-IND-DUR           
C37422            FROM CSS_FIXED_FCTR FF                                
C37422           WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO               
C37422             AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE           
C37422             AND FF.IC_NO          = :FF-IC-NO                    
C37422             AND FF.FACTOR_ID      = :FF-FACTOR-ID                
C37422             AND FF.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :FF-LAST-UPDATE-TS
              )           
C37422             AND FF.FIXED_FCTR_SEQ_NO = (                         
C37422                 SELECT MAX(FF2.FIXED_FCTR_SEQ_NO)                
C37422                   FROM CSS_FIXED_FCTR FF2                        
C37422                  WHERE FF.ACCOUNT_NO     = FF2.ACCOUNT_NO        
C37422                    AND FF.CODE_UTIL_TYPE = FF2.CODE_UTIL_TYPE    
C37422                    AND FF.IC_NO          = FF2.IC_NO             
C37422                    AND FF.FACTOR_ID      = FF2.FACTOR_ID         
C37422                    AND FF.LAST_UPDATE_TS = FF2.LAST_UPDATE_TS)   
                                                            
C37422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17013700
MFA-TR*         SELECT FF.FIXED_FCTR_SEQ_NO,                                    
MFA-TR*                DURATION_REMAIN_NO                                       
MFA-TR*           INTO :FF-FIXED-FCTR-SEQ-NO,                                   
MFA-TR*                :FF-DURATION-REMAIN-NO:WS-NULL-IND-DUR                   
MFA-TR*           FROM CSS_FIXED_FCTR FF                                        
MFA-TR*          WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                       
MFA-TR*            AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                   
MFA-TR*            AND FF.IC_NO          = :FF-IC-NO                            
MFA-TR*            AND FF.FACTOR_ID      = :FF-FACTOR-ID                        
MFA-TR*            AND FF.LAST_UPDATE_TS = :FF-LAST-UPDATE-TS                   
MFA-TR*            AND FF.FIXED_FCTR_SEQ_NO = (                                 
MFA-TR*                SELECT MAX(FF2.FIXED_FCTR_SEQ_NO)                        
MFA-TR*                  FROM CSS_FIXED_FCTR FF2                                
MFA-TR*                 WHERE FF.ACCOUNT_NO     = FF2.ACCOUNT_NO                
MFA-TR*                   AND FF.CODE_UTIL_TYPE = FF2.CODE_UTIL_TYPE            
MFA-TR*                   AND FF.IC_NO          = FF2.IC_NO                     
MFA-TR*                   AND FF.FACTOR_ID      = FF2.FACTOR_ID                 
MFA-TR*                   AND FF.LAST_UPDATE_TS = FF2.LAST_UPDATE_TS)           
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*    END-EXEC.                                                    17014200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37422                                                                  
C37422     MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.   
C37422                                                                  
C37422     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C37422        IF WS-NULL-IND-DUR < 0                                    
C37422           MOVE 'Y' TO WS-PARTIAL-PREPAY                          
C37422           MOVE 'N' TO WS-FULL-PREPAY                             
C37422        ELSE                                                      
C37422           MOVE 'N' TO WS-PARTIAL-PREPAY                          
C37422           MOVE 'Y' TO WS-FULL-PREPAY                             
C37422        END-IF                                                    
C37422     ELSE                                                         
C37422        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C37422           MOVE 'N' TO WS-FULL-PREPAY                             
C37422        ELSE                                                      
C37422           MOVE '7800'                  TO ACTIVE-PARAGRAPH       
C37422           MOVE 'CSS_FIXED_FACTOR'      TO CMN-TABLE-1            
C37422           MOVE 'ACCOUNT_NO'            TO CMN-TABLE-ELEMENT-1    
C37422           MOVE 'IC_NO'                 TO CMN-TABLE-ELEMENT-2    
C37422           MOVE 'FACTOR_ID'             TO CMN-TABLE-ELEMENT-3    
C37422           MOVE FF-ACCOUNT-NO           TO CMN-HOSTVAR-ELEMENT-2  
C37422           MOVE FF-IC-NO                TO CMN-HOSTVAR-ELEMENT-1  
C37422           MOVE FF-FACTOR-ID            TO CMN-HOSTVAR-ELEMENT-3  
C36587           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
C37422     END-IF
           END-IF.                                                      
C37422                                                                  
C37422 7800-EXIT.                                                       
C37422     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000-INSERT-CONTRACT                                          *         
      * INSERT THE CONTRACT RECORD INTO CSS_CONTRACT TABLE            *         
      *****************************************************************         
       8000-INSERT-CONTRACT.                                            
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CONTRACT                                 
                      (ACCOUNT_NO        ,                              
                       PYMT_PRIORITY_LVL ,                              
                       CNT_ITEM_ID       ,                              
                       DATE_CONTRACT     ,                              
                       AMT_MO_PYMT       ,                              
                       DATE_PYMT_START   ,                              
                       CODE_INTRST_METH  ,                              
                       INTRST_RATE       ,                              
                       NO_SCHED_PYMTS    ,                              
                       AMT_ORIG_ENTERED  ,                              
                       AMT_TAX_STATE     ,                              
                       AMT_TAX_CITY      ,                              
                       AMT_TAX_OTHER     ,                              
                       CODE_CONTRACT_TYPE,                              
                       CNT_STATUS_CD     ,                              
                       CNT_NAME_CD       ,                              
                       USER_ID           ,                              
                       LIEN_CD           ,                              
                       LAST_UPDATE_TS    ,                              
                       CODE_BILL_TYPE    ,                              
                       REBATE_CD         ,                              
                       CREDIT_EXEMPT_CODE,                              
                       REV_DISTRICT_CD   ,                              
                       CONTRACT_COMMENTS)                               
               VALUES (:CT-ACCOUNT-NO        ,                          
                       :CT-PYMT-PRIORITY-LVL ,                          
                       :CT-CNT-ITEM-ID       ,                          
                       IIF(TRY_CONVERT(DATE, :CT-DATE-CONTRACT
              ) IS NULL OR (PATINDEX('%.%', :CT-DATE-CONTRACT
              ) <> 0) OR (LEN(:CT-DATE-CONTRACT) <> 10), CIS.CHAR2DATE(
                                                      :CT-DATE-CONTRACT
              ), CONVERT(DATE, :CT-DATE-CONTRACT) )     ,                      
                       :CT-AMT-MO-PYMT       ,                          
                       IIF(TRY_CONVERT(DATE, :CT-DATE-PYMT-START
              ) IS NULL OR (PATINDEX('%.%', :CT-DATE-PYMT-START
              ) <> 0) OR (LEN(:CT-DATE-PYMT-START
              ) <> 10), CIS.CHAR2DATE(:CT-DATE-PYMT-START
              ), CONVERT(DATE, :CT-DATE-PYMT-START) )   ,                      
                       :CT-CODE-INTRST-METH  ,                          
                       :CT-INTRST-RATE       ,                          
                       :CT-NO-SCHED-PYMTS    ,                          
                       :CT-AMT-ORIG-ENTERED  ,                          
                       :CT-AMT-TAX-STATE     ,                          
                       :CT-AMT-TAX-CITY      ,                          
                       :CT-AMT-TAX-OTHER     ,                          
                       :CT-CODE-CONTRACT-TYPE,                          
                       :CT-CNT-STATUS-CD     ,                          
                       :CT-CNT-NAME-CD       ,                          
                       :CT-USER-ID           ,                          
                       :CT-LIEN-CD           ,                          
                       CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP) ,              
                       :CT-CODE-BILL-TYPE    ,                          
                       :CT-REBATE-CD         ,                          
                       :CT-CREDIT-EXEMPT-CODE,                          
                       :CT-REV-DISTRICT-CD   ,                          
                       :CT-CONTRACT-COMMENTS)                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CONTRACT                                         
MFA-TR*               (ACCOUNT_NO        ,                                      
MFA-TR*                PYMT_PRIORITY_LVL ,                                      
MFA-TR*                CNT_ITEM_ID       ,                                      
MFA-TR*                DATE_CONTRACT     ,                                      
MFA-TR*                AMT_MO_PYMT       ,                                      
MFA-TR*                DATE_PYMT_START   ,                                      
MFA-TR*                CODE_INTRST_METH  ,                                      
MFA-TR*                INTRST_RATE       ,                                      
MFA-TR*                NO_SCHED_PYMTS    ,                                      
MFA-TR*                AMT_ORIG_ENTERED  ,                                      
MFA-TR*                AMT_TAX_STATE     ,                                      
MFA-TR*                AMT_TAX_CITY      ,                                      
MFA-TR*                AMT_TAX_OTHER     ,                                      
MFA-TR*                CODE_CONTRACT_TYPE,                                      
MFA-TR*                CNT_STATUS_CD     ,                                      
MFA-TR*                CNT_NAME_CD       ,                                      
MFA-TR*                USER_ID           ,                                      
MFA-TR*                LIEN_CD           ,                                      
MFA-TR*                LAST_UPDATE_TS    ,                                      
MFA-TR*                CODE_BILL_TYPE    ,                                      
MFA-TR*                REBATE_CD         ,                                      
MFA-TR*                CREDIT_EXEMPT_CODE,                                      
MFA-TR*                REV_DISTRICT_CD   ,                                      
MFA-TR*                CONTRACT_COMMENTS)                                       
MFA-TR*        VALUES (:CT-ACCOUNT-NO        ,                                  
MFA-TR*                :CT-PYMT-PRIORITY-LVL ,                                  
MFA-TR*                :CT-CNT-ITEM-ID       ,                                  
MFA-TR*                :CT-DATE-CONTRACT     ,                                  
MFA-TR*                :CT-AMT-MO-PYMT       ,                                  
MFA-TR*                :CT-DATE-PYMT-START   ,                                  
MFA-TR*                :CT-CODE-INTRST-METH  ,                                  
MFA-TR*                :CT-INTRST-RATE       ,                                  
MFA-TR*                :CT-NO-SCHED-PYMTS    ,                                  
MFA-TR*                :CT-AMT-ORIG-ENTERED  ,                                  
MFA-TR*                :CT-AMT-TAX-STATE     ,                                  
MFA-TR*                :CT-AMT-TAX-CITY      ,                                  
MFA-TR*                :CT-AMT-TAX-OTHER     ,                                  
MFA-TR*                :CT-CODE-CONTRACT-TYPE,                                  
MFA-TR*                :CT-CNT-STATUS-CD     ,                                  
MFA-TR*                :CT-CNT-NAME-CD       ,                                  
MFA-TR*                :CT-USER-ID           ,                                  
MFA-TR*                :CT-LIEN-CD           ,                                  
MFA-TR*                :WS-CURRENT-TIMESTAMP ,                                  
MFA-TR*                :CT-CODE-BILL-TYPE    ,                                  
MFA-TR*                :CT-REBATE-CD         ,                                  
MFA-TR*                :CT-CREDIT-EXEMPT-CODE,                                  
MFA-TR*                :CT-REV-DISTRICT-CD   ,                                  
MFA-TR*                :CT-CONTRACT-COMMENTS)                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CONTRACT'             TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
              MOVE 'CNT_ITEM_ID'              TO CMN-TABLE-ELEMENT-3    
              MOVE 'DATE_CONTRACT'            TO CMN-TABLE-ELEMENT-4    
              MOVE CT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE CT-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
              MOVE CT-CNT-ITEM-ID             TO CMN-HOSTVAR-ELEMENT-3  
              MOVE CT-DATE-CONTRACT           TO CMN-HOSTVAR-ELEMENT-4  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8100-INSERT-CNT-DETAIL                                        *         
      *****************************************************************         
       8100-INSERT-CNT-DETAIL.                                          
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_CNT_DETAIL                              
                     (ACCOUNT_NO        ,                               
                      CNT_ITEM_ID       ,                               
                      CODE_SERVICE_TYPE ,                               
                      CHARGE_AM         ,                               
                      CHARGE_TYPE_CD    ,                               
                      COST_CENTER       ,                               
                      GL_ACCT_NO        ,                               
                      PYMT_PRIORITY_LVL ,                               
                      WRT_OFF_GL_ACCT_NO)                               
               VALUES                                                   
                     (:EA-ACCOUNT-NO        ,                           
                      :EA-CNT-ITEM-ID       ,                           
                      :EA-CODE-SERVICE-TYPE ,                           
                      :EA-CHARGE-AM         ,                           
                      :EA-CHARGE-TYPE-CD    ,                           
                      :EA-COST-CENTER       ,                           
                      :EA-GL-ACCT-NO        ,                           
                      :EA-PYMT-PRIORITY-LVL ,                           
                      :EA-WRT-OFF-GL-ACCT-NO)                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CNT_DETAIL'           TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'CNT_ITEM_ID'              TO CMN-TABLE-ELEMENT-2    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-3    
              MOVE 'CODE_SERVICE_TYPE'        TO CMN-TABLE-ELEMENT-4    
              MOVE EA-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE EA-CNT-ITEM-ID             TO CMN-HOSTVAR-ELEMENT-2  
              MOVE EA-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-3  
              MOVE EA-CODE-SERVICE-TYPE       TO CMN-HOSTVAR-ELEMENT-4  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8110-UPDATE-CNT-DETAIL                                        *         
      *****************************************************************         
       8110-UPDATE-CNT-DETAIL.                                          
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CNT_DETAIL                                    
                   SET CHARGE_AM     = :EA-CHARGE-AM                    
                 WHERE ACCOUNT_NO    = :EA-ACCOUNT-NO                   
                   AND CNT_ITEM_ID   = :EA-CNT-ITEM-ID                  
                   AND CODE_SERVICE_TYPE = :EA-CODE-SERVICE-TYPE        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CNT_DETAIL                                            
MFA-TR*            SET CHARGE_AM     = :EA-CHARGE-AM                            
MFA-TR*          WHERE ACCOUNT_NO    = :EA-ACCOUNT-NO                           
MFA-TR*            AND CNT_ITEM_ID   = :EA-CNT-ITEM-ID                          
MFA-TR*            AND CODE_SERVICE_TYPE = :EA-CODE-SERVICE-TYPE                
MFA-TR*       QUERYNO 8110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '8110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CNT_DETAIL'           TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'CNT_ITEM_ID'              TO CMN-TABLE-ELEMENT-2    
              MOVE 'CODE-SERVICE-TYPE'        TO CMN-TABLE-ELEMENT-3    
              MOVE EA-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE EA-CNT-ITEM-ID             TO CMN-HOSTVAR-ELEMENT-2  
              MOVE EA-CODE-SERVICE-TYPE       TO CMN-HOSTVAR-ELEMENT-3  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
C24880************************************************************              
C24880* 8150-INSERT-DFA.                                         *              
C24880************************************************************              
C24880 8150-INSERT-DFA.                                                 
C24880                                                                  
C24880     EXEC SQL                                                     
C24880          INSERT INTO CSS_DFA_ACCT                                
C24880          ( ACCOUNT_NO,                                           
C24880            PYMT_PRIORITY_LVL,                                    
C24880            DFA_ITEM_ID,                                          
C24880            DATE_OF_AGREE,                                        
C24880            CODE_DFA_TYPE,                                        
C24880            AMT_MO_PYMT,                                          
C24880            DATE_PYMT_START,                                      
C24880            NO_SCHED_PYMTS,                                       
C24880            AMT_ORIG_ENTERED,                                     
C24880            CSR_USERID,                                           
C24880            CODE_DFA_STATUS,                                      
C24880            RCNTLY_BLLD_MTH,                                      
C24880            AMT_UNDEFERD_RECV,                                    
C24880            CODE_DFA_DESC,                                        
C24880            AMT_EXTRA_DEPOSIT,                                    
C24880            REVERSE_REASON,                                       
C24880            CODE_COMPLY_HIST,                                     
C24880            FRST_ERNST_PAY_DT,                                    
C24880            FRST_ERNST_PAY_AMT,                                   
C24880            SCND_ERNST_PAY_DT,                                    
C24880            SCND_ERNST_PAY_AMT,                                   
C24880            PYMNT_ARNGMNT_CMTS,                                   
C24880            LAST_UPDATE_TS )                                      
C24880          VALUES                                                  
C24880          ( :DA-ACCOUNT-NO,                                       
C24880            :DA-PYMT-PRIORITY-LVL,                                
C24880            :DA-DFA-ITEM-ID,                                      
C24880            IIF(TRY_CONVERT(DATE, :DA-DATE-OF-AGREE
              ) IS NULL OR (PATINDEX('%.%', :DA-DATE-OF-AGREE
              ) <> 0) OR (LEN(:DA-DATE-OF-AGREE) <> 10), CIS.CHAR2DATE(
                                                      :DA-DATE-OF-AGREE
              ), CONVERT(DATE, :DA-DATE-OF-AGREE) ),                           
C24880            :DA-CODE-DFA-TYPE,                                    
C24880            :DA-AMT-MO-PYMT,                                      
C24880            IIF(TRY_CONVERT(DATE, :DA-DATE-PYMT-START
              ) IS NULL OR (PATINDEX('%.%', :DA-DATE-PYMT-START
              ) <> 0) OR (LEN(:DA-DATE-PYMT-START
              ) <> 10), CIS.CHAR2DATE(:DA-DATE-PYMT-START
              ), CONVERT(DATE, :DA-DATE-PYMT-START) ),                         
C24880            :DA-NO-SCHED-PYMTS,                                   
C24880            :DA-AMT-ORIG-ENTERED,                                 
C24880            :DA-CSR-USERID,                                       
C24880            :DA-CODE-DFA-STATUS,                                  
C24880            :DA-RCNTLY-BLLD-MTH,                                  
C24880            :DA-AMT-UNDEFERD-RECV,                                
C24880            :DA-CODE-DFA-DESC,                                    
C24880            :DA-AMT-EXTRA-DEPOSIT,                                
C24880            :DA-REVERSE-REASON,                                   
C24880            :DA-CODE-COMPLY-HIST,                                 
C24880            IIF(TRY_CONVERT(DATE, :DA-FRST-ERNST-PAY-DT 
                                        :WS-DFA-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :DA-FRST-ERNST-PAY-DT 
                                                       :WS-DFA-NULL-IND
              ) <> 0) OR (LEN(:DA-FRST-ERNST-PAY-DT :WS-DFA-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:DA-FRST-ERNST-PAY-DT 
                                                       :WS-DFA-NULL-IND
              ), CONVERT(DATE, :DA-FRST-ERNST-PAY-DT :WS-DFA-NULL-IND
              ) ),                
C24880            :DA-FRST-ERNST-PAY-AMT,                               
C24880            IIF(TRY_CONVERT(DATE, :DA-SCND-ERNST-PAY-DT 
                                        :WS-DFA-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :DA-SCND-ERNST-PAY-DT 
                                                      :WS-DFA-NULL-IND2
              ) <> 0) OR (LEN(:DA-SCND-ERNST-PAY-DT :WS-DFA-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:DA-SCND-ERNST-PAY-DT 
                                                      :WS-DFA-NULL-IND2
              ), CONVERT(DATE, :DA-SCND-ERNST-PAY-DT :WS-DFA-NULL-IND2
              ) ),               
C24880            :DA-SCND-ERNST-PAY-AMT,                               
C24880            :DA-PYMNT-ARNGMNT-CMTS,                               
C24880            CIS.CHAR2TIMESTAMP(:DA-LAST-UPDATE-TS))                       
C24880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_DFA_ACCT                                        
MFA-TR*         ( ACCOUNT_NO,                                                   
MFA-TR*           PYMT_PRIORITY_LVL,                                            
MFA-TR*           DFA_ITEM_ID,                                                  
MFA-TR*           DATE_OF_AGREE,                                                
MFA-TR*           CODE_DFA_TYPE,                                                
MFA-TR*           AMT_MO_PYMT,                                                  
MFA-TR*           DATE_PYMT_START,                                              
MFA-TR*           NO_SCHED_PYMTS,                                               
MFA-TR*           AMT_ORIG_ENTERED,                                             
MFA-TR*           CSR_USERID,                                                   
MFA-TR*           CODE_DFA_STATUS,                                              
MFA-TR*           RCNTLY_BLLD_MTH,                                              
MFA-TR*           AMT_UNDEFERD_RECV,                                            
MFA-TR*           CODE_DFA_DESC,                                                
MFA-TR*           AMT_EXTRA_DEPOSIT,                                            
MFA-TR*           REVERSE_REASON,                                               
MFA-TR*           CODE_COMPLY_HIST,                                             
MFA-TR*           FRST_ERNST_PAY_DT,                                            
MFA-TR*           FRST_ERNST_PAY_AMT,                                           
MFA-TR*           SCND_ERNST_PAY_DT,                                            
MFA-TR*           SCND_ERNST_PAY_AMT,                                           
MFA-TR*           PYMNT_ARNGMNT_CMTS,                                           
MFA-TR*           LAST_UPDATE_TS )                                              
MFA-TR*         VALUES                                                          
MFA-TR*         ( :DA-ACCOUNT-NO,                                               
MFA-TR*           :DA-PYMT-PRIORITY-LVL,                                        
MFA-TR*           :DA-DFA-ITEM-ID,                                              
MFA-TR*           :DA-DATE-OF-AGREE,                                            
MFA-TR*           :DA-CODE-DFA-TYPE,                                            
MFA-TR*           :DA-AMT-MO-PYMT,                                              
MFA-TR*           :DA-DATE-PYMT-START,                                          
MFA-TR*           :DA-NO-SCHED-PYMTS,                                           
MFA-TR*           :DA-AMT-ORIG-ENTERED,                                         
MFA-TR*           :DA-CSR-USERID,                                               
MFA-TR*           :DA-CODE-DFA-STATUS,                                          
MFA-TR*           :DA-RCNTLY-BLLD-MTH,                                          
MFA-TR*           :DA-AMT-UNDEFERD-RECV,                                        
MFA-TR*           :DA-CODE-DFA-DESC,                                            
MFA-TR*           :DA-AMT-EXTRA-DEPOSIT,                                        
MFA-TR*           :DA-REVERSE-REASON,                                           
MFA-TR*           :DA-CODE-COMPLY-HIST,                                         
MFA-TR*           :DA-FRST-ERNST-PAY-DT:WS-DFA-NULL-IND,                        
MFA-TR*           :DA-FRST-ERNST-PAY-AMT,                                       
MFA-TR*           :DA-SCND-ERNST-PAY-DT:WS-DFA-NULL-IND2,                       
MFA-TR*           :DA-SCND-ERNST-PAY-AMT,                                       
MFA-TR*           :DA-PYMNT-ARNGMNT-CMTS,                                       
MFA-TR*           :DA-LAST-UPDATE-TS)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C24880                                                                  
C24880     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C24880        NEXT SENTENCE                                             
C24880     ELSE                                                         
C24880        MOVE '8150'                     TO ACTIVE-PARAGRAPH       
C24880        MOVE 'CSS_DFA_ACCT'             TO CMN-TABLE-1            
C24880        MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
C24880        MOVE DA-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
C24880        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C24880     END-IF.                                                      
C24880                                                                  
C24880 8150-EXIT.                                                       
C24880     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8200-INSERT-AR-CNTL                                           *         
      *****************************************************************         
       8200-INSERT-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_AR_CNTL                                   
                     (ACCOUNT_NO       ,                                
                      PYMT_PRIORITY_LVL,                                
                      ITEM_ID          ,                                
                      AMT_AR_DAY_00    ,                                
                      AMT_AR_DAY_30    ,                                
                      AMT_AR_DAY_60    ,                                
                      AMT_AR_DAY_90    ,                                
                      AMT_UNUSED_CR    ,                                
                      AMT_TRAN_BALANCE ,                                
                      LAST_UPDATE_TS)                                   
              VALUES (:AC-ACCOUNT-NO       ,                            
                      :AC-PYMT-PRIORITY-LVL,                            
                      :AC-ITEM-ID          ,                            
                      :AC-AMT-AR-DAY-00    ,                            
                      :AC-AMT-AR-DAY-30    ,                            
                      :AC-AMT-AR-DAY-60    ,                            
                      :AC-AMT-AR-DAY-90    ,                            
                      :AC-AMT-UNUSED-CR    ,                            
                      :AC-AMT-TRAN-BALANCE ,                            
                      CIS.CHAR2TIMESTAMP(:AC-LAST-UPDATE-TS))                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_AR_CNTL                                           
MFA-TR*              (ACCOUNT_NO       ,                                        
MFA-TR*               PYMT_PRIORITY_LVL,                                        
MFA-TR*               ITEM_ID          ,                                        
MFA-TR*               AMT_AR_DAY_00    ,                                        
MFA-TR*               AMT_AR_DAY_30    ,                                        
MFA-TR*               AMT_AR_DAY_60    ,                                        
MFA-TR*               AMT_AR_DAY_90    ,                                        
MFA-TR*               AMT_UNUSED_CR    ,                                        
MFA-TR*               AMT_TRAN_BALANCE ,                                        
MFA-TR*               LAST_UPDATE_TS)                                           
MFA-TR*       VALUES (:AC-ACCOUNT-NO       ,                                    
MFA-TR*               :AC-PYMT-PRIORITY-LVL,                                    
MFA-TR*               :AC-ITEM-ID          ,                                    
MFA-TR*               :AC-AMT-AR-DAY-00    ,                                    
MFA-TR*               :AC-AMT-AR-DAY-30    ,                                    
MFA-TR*               :AC-AMT-AR-DAY-60    ,                                    
MFA-TR*               :AC-AMT-AR-DAY-90    ,                                    
MFA-TR*               :AC-AMT-UNUSED-CR    ,                                    
MFA-TR*               :AC-AMT-TRAN-BALANCE ,                                    
MFA-TR*               :AC-LAST-UPDATE-TS)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_AR_CNTL'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
              MOVE 'ITEM_ID'                  TO CMN-TABLE-ELEMENT-3    
              MOVE 'AMT_TRAN_BALANCE'         TO CMN-TABLE-ELEMENT-4    
              MOVE AC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE AC-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
              MOVE AC-ITEM-ID                 TO CMN-HOSTVAR-ELEMENT-3  
              MOVE AC-AMT-TRAN-BALANCE        TO WS-AMT-TRAN-BALANCE-ED 
              MOVE WS-AMT-TRAN-BALANCE-ED     TO CMN-HOSTVAR-ELEMENT-4  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8300-INSERT-CONNECT-CHRG                                      *         
      *****************************************************************         
       8300-INSERT-CONNECT-CHRG.                                        
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_CONNECT_CHRG                            
                     (ACCOUNT_NO       ,                                
                      PYMT_PRIORITY_LVL,                                
                      CCC_ITEM_ID      ,                                
                      AMT_ORIG_ENTERED ,                                
                      CODE_CCC_TYPE    ,                                
                      RCNCT_TYPE_NO    ,                                
                      AMT_TAX_STATE    ,                                
                      AMT_TAX_CITY     ,                                
                      AMT_TAX_XCISE    ,                                
                      AMT_TAX_OTHER    ,                                
                      AMT_TRANS        ,                                
                      DATE_TRANS       ,                                
                      LAST_UPDATE_TS)                                   
               VALUES                                                   
                     (:CC-ACCOUNT-NO       ,                            
                      :CC-PYMT-PRIORITY-LVL,                            
                      :CC-CCC-ITEM-ID      ,                            
                      :CC-AMT-ORIG-ENTERED ,                            
                      :CC-CODE-CCC-TYPE    ,                            
                      :U7-RCNCT-TYPE-NO    ,                            
                      :CC-AMT-TAX-STATE    ,                            
                      :CC-AMT-TAX-CITY     ,                            
                      :CC-AMT-TAX-XCISE    ,                            
                      :CC-AMT-TAX-OTHER    ,                            
                      :CC-AMT-TRANS        ,                            
                      IIF(TRY_CONVERT(DATE, :CC-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :CC-DATE-TRANS
              ) <> 0) OR (LEN(:CC-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :CC-DATE-TRANS
              ), CONVERT(DATE, :CC-DATE-TRANS) )       ,                       
                      CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP))                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_CONNECT_CHRG                                    
MFA-TR*              (ACCOUNT_NO       ,                                        
MFA-TR*               PYMT_PRIORITY_LVL,                                        
MFA-TR*               CCC_ITEM_ID      ,                                        
MFA-TR*               AMT_ORIG_ENTERED ,                                        
MFA-TR*               CODE_CCC_TYPE    ,                                        
MFA-TR*               RCNCT_TYPE_NO    ,                                        
MFA-TR*               AMT_TAX_STATE    ,                                        
MFA-TR*               AMT_TAX_CITY     ,                                        
MFA-TR*               AMT_TAX_XCISE    ,                                        
MFA-TR*               AMT_TAX_OTHER    ,                                        
MFA-TR*               AMT_TRANS        ,                                        
MFA-TR*               DATE_TRANS       ,                                        
MFA-TR*               LAST_UPDATE_TS)                                           
MFA-TR*        VALUES                                                           
MFA-TR*              (:CC-ACCOUNT-NO       ,                                    
MFA-TR*               :CC-PYMT-PRIORITY-LVL,                                    
MFA-TR*               :CC-CCC-ITEM-ID      ,                                    
MFA-TR*               :CC-AMT-ORIG-ENTERED ,                                    
MFA-TR*               :CC-CODE-CCC-TYPE    ,                                    
MFA-TR*               :U7-RCNCT-TYPE-NO    ,                                    
MFA-TR*               :CC-AMT-TAX-STATE    ,                                    
MFA-TR*               :CC-AMT-TAX-CITY     ,                                    
MFA-TR*               :CC-AMT-TAX-XCISE    ,                                    
MFA-TR*               :CC-AMT-TAX-OTHER    ,                                    
MFA-TR*               :CC-AMT-TRANS        ,                                    
MFA-TR*               :CC-DATE-TRANS       ,                                    
MFA-TR*               :WS-CURRENT-TIMESTAMP)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR DUPLICATE-FOUND                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_CONNECT_CHRG'         TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'CCC_ITEM_ID'              TO CMN-TABLE-ELEMENT-2    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-3    
              MOVE 'RCNCT_TYPE_NO'            TO CMN-TABLE-ELEMENT-4    
              MOVE CC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE CC-CCC-ITEM-ID             TO CMN-HOSTVAR-ELEMENT-2  
              MOVE CC-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-3  
              MOVE U7-RCNCT-TYPE-NO           TO CMN-HOSTVAR-ELEMENT-4  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
C36587*****************************************************************         
C36587* 8310-INSERT-FACTOR                                            *         
C36587*****************************************************************         
C36587 8310-INSERT-FACTOR.                                              
C36587                                                                  
C36587     EXEC SQL                                                     
C36587         INSERT INTO CSS_FIXED_FCTR                               
C36587                (ACCOUNT_NO        ,                              
C36587                 CODE_UTIL_TYPE    ,                              
C36587                 IC_NO             ,                              
C36587                 FIXED_FCTR_SEQ_NO ,                              
C36587                 FACTOR_ID         ,                              
C36587                 EFF_DATE_FROM     ,                              
C36587                 CMPNT_ID_CD       ,                              
C36587                 CODE_SEASON       ,                              
C36587                 INSTR_USE_TYPE_CD ,                              
C36587                 CODE_TIME_PERIOD  ,                              
C36587                 EFF_DATE_TO       ,                              
C36587                 FIXED_FCTR_TYP_CD ,                              
C36587                 FACTOR            ,                              
C36587                 FAC_CHRG_BASE_AM  ,                              
C36587                 LAST_UPDATE_TS    ,                              
C36587                 DURATION_REMAIN_NO,                              
C36587                 RT_PKG_OPT_SEQ_NO)                               
C36587         VALUES                                                   
C36587                (:FF-ACCOUNT-NO       ,                           
C36587                 :FF-CODE-UTIL-TYPE   ,                           
C36587                 :FF-IC-NO            ,                           
C36587                 :FF-FIXED-FCTR-SEQ-NO,                           
C36587                 :FF-FACTOR-ID        ,                           
C36587                 IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )    ,                       
C36587                 :FF-CMPNT-ID-CD      ,                           
C36587                 :FF-CODE-SEASON      ,                           
C36587                 :FF-INSTR-USE-TYPE-CD,                           
C36587                 :FF-CODE-TIME-PERIOD ,                           
C36587                 IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )      ,                       
C36587                 :FF-FIXED-FCTR-TYP-CD,                           
C36587                 :FF-FACTOR           ,                           
C36587                 :FF-FAC-CHRG-BASE-AM ,                           
C36587                 CIS.CHAR2TIMESTAMP(:FF-LAST-UPDATE-TS)   ,               
C36587                 :FF-DURATION-REMAIN-NO,                          
C36587                 :FF-RT-PKG-OPT-SEQ-NO)                           
C36587                                                                  
C36587     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIXED_FCTR                               01720001
MFA-TR*               (ACCOUNT_NO        ,                                      
MFA-TR*                CODE_UTIL_TYPE    ,                                      
MFA-TR*                IC_NO             ,                                      
MFA-TR*                FIXED_FCTR_SEQ_NO ,                                      
MFA-TR*                FACTOR_ID         ,                                      
MFA-TR*                EFF_DATE_FROM     ,                                      
MFA-TR*                CMPNT_ID_CD       ,                                      
MFA-TR*                CODE_SEASON       ,                                      
MFA-TR*                INSTR_USE_TYPE_CD ,                                      
MFA-TR*                CODE_TIME_PERIOD  ,                                      
MFA-TR*                EFF_DATE_TO       ,                                      
MFA-TR*                FIXED_FCTR_TYP_CD ,                                      
MFA-TR*                FACTOR            ,                                      
MFA-TR*                FAC_CHRG_BASE_AM  ,                                      
MFA-TR*                LAST_UPDATE_TS    ,                                      
MFA-TR*                DURATION_REMAIN_NO,                                      
MFA-TR*                RT_PKG_OPT_SEQ_NO)                                       
MFA-TR*        VALUES                                                           
MFA-TR*               (:FF-ACCOUNT-NO       ,                                   
MFA-TR*                :FF-CODE-UTIL-TYPE   ,                                   
MFA-TR*                :FF-IC-NO            ,                                   
MFA-TR*                :FF-FIXED-FCTR-SEQ-NO,                                   
MFA-TR*                :FF-FACTOR-ID        ,                                   
MFA-TR*                :FF-EFF-DATE-FROM    ,                                   
MFA-TR*                :FF-CMPNT-ID-CD      ,                                   
MFA-TR*                :FF-CODE-SEASON      ,                                   
MFA-TR*                :FF-INSTR-USE-TYPE-CD,                                   
MFA-TR*                :FF-CODE-TIME-PERIOD ,                                   
MFA-TR*                :FF-EFF-DATE-TO      ,                                   
MFA-TR*                :FF-FIXED-FCTR-TYP-CD,                                   
MFA-TR*                :FF-FACTOR           ,                                   
MFA-TR*                :FF-FAC-CHRG-BASE-AM ,                                   
MFA-TR*                :FF-LAST-UPDATE-TS   ,                                   
MFA-TR*                :FF-DURATION-REMAIN-NO,                                  
MFA-TR*                :FF-RT-PKG-OPT-SEQ-NO)                                   
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36587                                                                  
C36587     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36587                                                                  
C36587     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36587        CONTINUE                                                  
C36587     ELSE                                                         
C36587        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C36587        MOVE '8310'                TO ACTIVE-PARAGRAPH            
C36587        MOVE 'INSERT'              TO ABEND-FUNCTION              
C36587        MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                     
C36587        MOVE 'FF-ACCOUNT_NO'       TO TABLE-ELEMENT-1             
C36587        MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C36587        MOVE 'FF-FACTOR-ID'        TO TABLE-ELEMENT-2             
C36587        MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
C36587        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36587        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36587     END-IF.                                                      
C36587                                                                  
C36587 8310-EXIT.                                                       
C36587     EXIT.                                                        
                                                                        
C36587*****************************************************************         
C36587* 8320-UPDATE-FACTOR                                            *         
C36587*****************************************************************         
C36587 8320-UPDATE-FACTOR.                                              
C36587                                                                  
C36587     EXEC SQL                                                     
C36587         UPDATE CSS_FIXED_FCTR                                    
C36587            SET DURATION_REMAIN_NO = 1                            
C36587          WHERE ACCOUNT_NO = :FF-ACCOUNT-NO                       
C36587            AND CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE               
C36587            AND IC_NO = :FF-IC-NO                                 
C36587            AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO         
                                                            
C36587     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_FIXED_FCTR                                    01720001
MFA-TR*           SET DURATION_REMAIN_NO = 1                                    
MFA-TR*         WHERE ACCOUNT_NO = :FF-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO = :FF-IC-NO                                         
MFA-TR*           AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO                 
MFA-TR*       QUERYNO 8320                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36587                                                                  
C36587     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36587                                                                  
C36587     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36587        CONTINUE                                                  
C36587     ELSE                                                         
C36587        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C36587        MOVE '8320'                TO ACTIVE-PARAGRAPH            
C36587        MOVE 'UPDATE'              TO ABEND-FUNCTION              
C36587        MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                     
C36587        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C36587        MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C36587        MOVE 'FACTOR_ID'           TO TABLE-ELEMENT-2             
C36587        MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
C36587        MOVE 'FIXED_FCTR_SEQ_NO'   TO TABLE-ELEMENT-3             
C36587        MOVE FF-FIXED-FCTR-SEQ-NO  TO HOSTVAR-ELEMENT-3           
C36587        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36587        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36587     END-IF.                                                      
C36587                                                                  
C36587 8320-EXIT.                                                       
C36587     EXIT.                                                        
                                                                        
C37422*****************************************************************         
C37422* 8321-INSERT-MNT-ROW.                                                    
C37422*****************************************************************         
C37422 8321-INSERT-MNT-ROW.                                             
C37422                                                                  
C37422     MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
C37422     MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
C37422     MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
C37422     MOVE 'AGL'                    TO MH-RESP-AREA-ID.            
A37666     MOVE ZEROES                   TO MH-CUSTOMER-NO.             
C37422     MOVE CMN-ACCOUNT-NO           TO MH-ACCOUNT-NO.              
A37666     MOVE ZEROES                   TO MH-PREMISE-NO.              
C37422     MOVE 'SYSTEM'                 TO MH-USER-ID.                 
C37422     MOVE 'PCSSO67E'               TO MH-APPL-PROGRAM-ID.         
C37422     MOVE 'INSERT RCC - CHARGE AMOUNT TO BE TAXED ONLY' TO        
C37422        MH-TRAN-COMMENT-TEXT.                                     
C37422     MOVE 43                      TO MH-TRAN-COMMENT-LEN.         
                                                                        
C37422     MOVE +1                      TO MI-TRAN-APPL-NO.             
C37422     MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
C37422     MOVE 'DURATION'              TO MI-COLUMN-DESC.              
C37422     MOVE +4                      TO MI-PRV-COLUMN-VALUE-LEN.     
C37422     MOVE 'NULL'                  TO MI-PRV-COLUMN-VALUE-TEXT.    
C37422     MOVE +04                     TO MI-CHG-COLUMN-VALUE-LEN.     
C37422     MOVE FF-DURATION-REMAIN-NO   TO WS-DURATION-TEXT.            
C37422     MOVE WS-DURATION-TEXT        TO WS-DURA-VAL-Z.               
C37422     MOVE WS-DURA-VAL-Z           TO MI-CHG-COLUMN-VALUE-TEXT.    
C37422     MOVE SPACES                  TO MI-TABLE-ID.                 
C37422     PERFORM 6530-LOAD-MNT-TRANS-HIST.                            
                                                                        
C37422 8321-EXIT.                                                       
C37422     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8400-UPDATE-ACCOUNT                                           *         
      *****************************************************************         
       8400-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,       
                     LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )         
               WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                    
                 AND LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,               
MFA-TR*              LAST_UPDATE_TS     = :WS-CURRENT-TIMESTAMP                 
MFA-TR*        WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                            
MFA-TR*          AND LAST_UPDATE_TS = :AT-LAST-UPDATE-TS                        
MFA-TR*       QUERYNO 8400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_ACCOUNT'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'LAST_UPDATE_TS'           TO CMN-TABLE-ELEMENT-2    
              MOVE AT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE AT-LAST-UPDATE-TS          TO CMN-HOSTVAR-ELEMENT-2  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
C24880************************************************************              
C24880* 8500-INSERT-DFA-RECV.                                    *              
C24880************************************************************              
C24880 8500-INSERT-DFA-RECV.                                            
C24880                                                                  
C24880     EXEC SQL                                                     
C24880          INSERT INTO CSS_DFA_RECVBLE                             
C24880               (ACCOUNT_NO       ,                                
C24880                AGREEMENT_NO     ,                                
C24880                AMT_CONTRACT_DEFR,                                
C24880                AMT_DAY_00       ,                                
C24880                AMT_DAY_30       ,                                
C24880                AMT_DAY_60       ,                                
C24880                AMT_DAY_90       ,                                
C24880                CNT_ITEM_ID      ,                                
C24880                DFA_PYMT_PRIORITY,                                
C24880                PYMT_PRIORITY_LVL)                                
C24880         VALUES                                                   
C24880               (:DV-ACCOUNT-NO       ,                            
C24880                :DV-AGREEMENT-NO     ,                            
C24880                :DV-AMT-CONTRACT-DEFR,                            
C24880                :DV-AMT-DAY-00       ,                            
C24880                :DV-AMT-DAY-30       ,                            
C24880                :DV-AMT-DAY-60       ,                            
C24880                :DV-AMT-DAY-90       ,                            
C24880                :DV-CNT-ITEM-ID      ,                            
C24880                :DV-DFA-PYMT-PRIORITY,                            
C24880                :DV-PYMT-PRIORITY-LVL)                            
C24880     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C24880                                                                  
C24880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C24880                             OR DUPLICATE-FOUND                   
C24880        NEXT SENTENCE                                             
C24880     ELSE                                                         
C24880        MOVE '8500'                     TO ACTIVE-PARAGRAPH       
C24880        MOVE 'CSS_DFA_RECVBLE'          TO CMN-TABLE-1            
C24880        MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
C24880        MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
C24880        MOVE DV-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
C24880        MOVE DV-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
C24880        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C24880     END-IF.                                                      
C24880                                                                  
C24880 8500-EXIT.                                                       
C24880     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8600-UPDATE-AR-CNTL.                                          *         
      *****************************************************************         
       8600-UPDATE-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
                 SET AMT_UNUSED_CR = :AC-AMT-UNUSED-CR,                 
                     AMT_AR_DAY_00 = :AC-AMT-AR-DAY-00                  
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_AR_CNTL                                                
MFA-TR*          SET AMT_UNUSED_CR = :AC-AMT-UNUSED-CR,                         
MFA-TR*              AMT_AR_DAY_00 = :AC-AMT-AR-DAY-00                          
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           = :AC-ITEM-ID                            
MFA-TR*       QUERYNO 8600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_AR_CNTL'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'PYMT_PRIORITY_LVL'        TO CMN-TABLE-ELEMENT-2    
              MOVE 'ITEM_ID'                  TO CMN-TABLE-ELEMENT-3    
              MOVE 'AMT_UNUSED_CR'            TO CMN-TABLE-ELEMENT-4    
              MOVE AC-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              MOVE AC-PYMT-PRIORITY-LVL       TO CMN-HOSTVAR-ELEMENT-2  
              MOVE AC-ITEM-ID                 TO CMN-HOSTVAR-ELEMENT-3  
              MOVE AC-AMT-UNUSED-CR           TO WS-AMT-UNUSED-CR-ED    
              MOVE WS-AMT-UNUSED-CR-ED        TO CMN-HOSTVAR-ELEMENT-4  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8700-DELETE-RECONNECT                                         *         
      *****************************************************************         
       8700-DELETE-RECONNECT.                                           
                                                                        
           EXEC SQL                                                     
                DELETE FROM CSS_RECONNECT                               
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_RECONNECT                                       
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*       QUERYNO 8700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '8700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_RECONNECT'            TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE AT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
C26296*****************************************************************         
C26296* 8710-DELETE-CRED_COLL                                         *         
C26296*****************************************************************         
C26296 8710-DELETE-CRED-COLL.                                           
                                                                        
C26296     EXEC SQL                                                     
C26296          DELETE FROM CSS_CRED_COLL                               
C26296          WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                
C26296            AND CODE_NOTICE_TYPE  = :CL-CODE-NOTICE-TYPE          
C26296            AND CODE_SPECIAL_TYPE = :CL-CODE-SPECIAL-TYPE         
                                                            
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CRED_COLL                                       
MFA-TR*         WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                        
MFA-TR*           AND CODE_NOTICE_TYPE  = :CL-CODE-NOTICE-TYPE                  
MFA-TR*           AND CODE_SPECIAL_TYPE = :CL-CODE-SPECIAL-TYPE                 
MFA-TR*       QUERYNO 8710                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C26296     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C26296*                                                                         
C26296     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C26296        NEXT SENTENCE                                             
C26296     ELSE                                                         
C26296        MOVE '8710'                     TO ACTIVE-PARAGRAPH       
C26296        MOVE 'CSS_CRED_COLL'            TO CMN-TABLE-1            
C26296        MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
C26296        MOVE CL-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
C26296        MOVE 'CODE_NOTICE_TYPE'         TO CMN-TABLE-ELEMENT-2    
C26296        MOVE CL-CODE-NOTICE-TYPE        TO CMN-HOSTVAR-ELEMENT-2  
C26296        MOVE 'CODE_SPECIAL_TYPE'        TO CMN-TABLE-ELEMENT-3    
C26296        MOVE CL-CODE-SPECIAL-TYPE       TO CMN-HOSTVAR-ELEMENT-3  
C26296        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C26296     END-IF.                                                      
C26296*                                                                         
C26296 8710-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
      ******************************************************************        
      *  9000-SEND-ERROR-RESULT                                        *        
      *  THIS PARAGRAPH:                                               *        
      *    1) IS A DUMMY PARAGRAPH TO SUPPORT COPYBOOKS CPD00003,      *        
      *       CPD0006A, CPD00008, CPD00073 & CPD0010S                  *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           CONTINUE.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9600-TERMINATE-LINK                                            *        
      ******************************************************************        
       9600-TERMINATE-LINK.                                             
                                                                        
REARCH     EXIT PROGRAM.                                                
                                                                        
       9600-EXIT.                                                       
           EXIT.                                                        
                                                                        
C26296******************************************************************        
C26296* 9700-PROCESS-ABEND.                                            *        
C26296* THIS PARAGRAPH ADDED FOR CPD00055                              *        
C26296******************************************************************        
C26296 9700-PROCESS-ABEND.                                              
                                                                        
C26296     PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT.     
                                                                        
C26296 9700-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE                                         *        
      * THIS IS REQUIRED SO THAT CONTROL IS RETURNED TO S025.          *        
      ******************************************************************        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           MOVE 'Y'                           TO CMN-ABEND-CHECK.       
           MOVE WS-ACTIVE-RETURN-CODE         TO CMN-RETURN-CODE.       
           MOVE ACTIVE-PARAGRAPH              TO CMN-ACTIVE-PARAGRAPH.  
           MOVE PROGRAM-NAME                  TO CMN-PROGRAM-NAME.      
                                                                        
REARCH     EXIT PROGRAM.                                                
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
