       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     MCSSO061.                                        
       DATE-WRITTEN.   JUNE 1988.                                       
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                                                               *         
      *               SOUTH CAROLINA ELECTRIC & GAS                   *         
      *                                                               *         
      *  PROGRAM:  PCSSO061                                           *         
      *                                                               *         
      *****************************************************************         
      *                                                               *         
      *                 PROGRAM  MODIFICATION  LOG                    *         
      *                                                               *         
      *     DATE    INITIALS    COMMENTS                              *         
      *   --------  --------    -----------------------------------   *         
      *   09/10/93    EOB       INITIATION OF MULTIPLE SERVICE ORDERS *         
      *   11/14/95    WMG       ADDED DNP, DNPFB, ORDER REASON AND    *         
      *                         SO-PENDING FUNCTIONALITY:             *         
      *                         PARAGRAPHS 8320, 8325, 8330, 8331,    *         
      *                                    8332, 8400, 8410, 8420,    *         
      *                                    8450, 8460                 *         
      *   03/18/96    WMG       ADJUSTED LOGIC WHEN INSERTING A ROW   *         
      *                         INTO CSS_CUST_PREM_HIST WHEN          *         
      *                         ACTIVATING AN ACCOUNT.  DELETED THE   *         
      *                         8332 PARAGRAPH.  CHANGED ORDER TYPE   *         
      *                         DETERMINATION LOGIC.                  *         
      *   05/01/96    WMG       TPR 4038 - MODIFIED LOGIC TO INSERT   *         
      *                         INTO CSS_CUST_PREM_HIST WHEN A ROW FOR*         
      *                         THE ACCOUNT IS NOT FOUND.             *         
      *                                                               *         
      *   08/28/96    WMG       TPR 5172 - ASSIGN ABEND TABLE         *         
      *                         INFORMATION TO VARIABLES IN THE       *         
      *                         LINKAGE SECTION IN ALL SQL ERROR      *         
      *                         PROCESSING ROUTINES.                  *         
      *                                                               *         
      *   09/17/96    WMG       TPR 5368 - RETRIEVE MASTER/SUB ACCOUNT*         
      *                         INFORMATION ON THE PRIOR ACCOUNT AND  *         
      *                         UPDATE THE NEW ACCOUNT WHEN REVERTING *         
      *                         TO THE LANDLORD ON A CUSTOMER CHANGE  *         
      *                         ORDER.                                *         
      *   10/16/96    WMG       TPR 5813 - MOVE LOGIC ADDED FOR TPR   *         
      *                         5368 TO THE WS-MISCELLANEOUS-VARIABLES*         
      *                         GROUP OF WORKING STORAGE VARIABLES.   *         
      *   10/22/96    MAD       PCR 360 - MODIFIED CODE TO PROCESS ALL*         
      *                         DNP ORDER REASONS AND UPDATE NORMAL   *         
      *                         CREDIT HISTORY WHEN THE DNP REASON    *         
      *                         CODE VALUES ARE 'N' (NORMAL) OR 'O'   *         
      *                         (NORMAL W/RETURNED CHECK)             *         
      *   12/05/96    WMG       TPR 7959 - REMOVED CHECK FOR          *         
      *                         'AT-TOTAL-AR-BALANCE > 0' IN PARAGRAPH*         
      *                         5260 WHEN SETTING ACCOUNT STATUSES.   *         
      *                                                               *         
      *   12/06/96    WMG       TPR 8003 - WHEN ACTIVATING A NEW      *         
      *                         ACCOUNT, CHECK THE WS-CODE-BUDGET     *         
      *                         BYTE OF CODES_DATA_PRESENT FOR THE    *         
      *                         NEW ACCOUNT.  IF IT IS EQUAL TO SPACES*         
      *                         THEN SET THE WS-CODE-UTL BYTE TO 'A'. *         
      *                         THIS WILL HELP TO DETERMINE IF THE    *         
      *                         ACCOUNT IS UTILITY RELATED OR NOT.    *         
      *                                                               *         
      *   12/11/96    AS        TPR 8070 - FOR OCCUPANT CHANGE ORDERS,*         
      *                         SELECT THE CUSTOMER NUMBER FOR THE NEW*         
      *                         ACCOUNT WHEN INSERTING A ROW IN       *         
      *                         CSS_CUST_PREM_HIST.                   *         
      *                                                               *         
TP5912*   01/21/97    CHANDIRA  TPR 5912 - INSERT TO CSS_MNT_TRAN_HIST*         
TP5912*                         IS IMPLEMENTED.                       *         
TP5912*                                                               *         
TP8840*   01/30/97    CHANDIRA  TPR 8840 - UPDATE CSS_CREDIT_PROFILE  *         
TP8840*                         FOR THE DNP ORDER.                    *         
TP8840*                                                               *         
TP9033*   01/30/97    RAO JADA  TPR 9033 - STATUS REASON IS CHANGED   *         
TP9033*                         NON-PAYMENT IN CASE OF DNPFB ORDER.   *         
      *                                                               *         
      *   02/12/97    WMG       TPR 9032 - DO NOT SET ACCOUNT STATUS  *         
      *                         REASON WHEN POSTING A DNP ORDER.      *         
      *                                                               *         
TP9578*   03/05/97    CHANDIRA  CSS_CREDIT_PROFILE - UPDATE OF ARREARS*         
TP9578*                         FLAG IS REMOVED.                      *         
      *                                                               *         
      *   03/25/97    WMG       TPR 9868 - REMOVED LOGIC TO SET THE   *         
      *                         ACCOUNT STATUS CODE FOR OLD ACCOUNTS. *         
      *                         THIS IS NOW COMPLETED IN PCSSO062.    *         
      *                                                               *         
      *   04/08/97    WMG       TPR 10184 - WHEN INSERTING INTO       *         
      *                         CSS_CUST_PREM_HIST, MOVE THE AT       *         
      *                         ACCT_CREATE_DT VALUE TO               *         
      *                         CH-DATE-UTIL-SVC-STRT INSTEAD OF USING*         
      *                         THE SERVICE ORDER COMPLETION DATE.    *         
      *                                                               *         
      *   07/16/98    FB        TPR 17110 - THE 8312 ROUTINE WAS      *         
      *                         UPDATING THE TRANSFER TO ACCOUNT WHEN *         
      *                         IT SHOULD HAVE BEEN UPDATING THE      *         
      *                         TRANSFER FLAG.  A TRANFER TO ACCOUNT  *         
      *                         NUMBER WAS BEING CARRIED FORWARD      *         
      *                         INCORRECTLY FOR A CUSTOMER CHANGE.    *         
      *   09/24/98    FB        TPR 17758 - THE CUSTOMER NUMBER OF    *         
      *                         THE NEW ACCOUNT IN A CUSTOMER CHANGE  *         
      *                         WAS POPULATED WITH THE WRONG CUSTOMER *         
      *                         NUMBER.                               *         
      *                                                               *         
      *   09/24/98    FB        TPR 17419 - UNDO CHANGES MADE FOR     *         
      *                         TPR 10184.  USE SERVICE ORDER         *         
      *                         COMPLETION DATE FOR                   *         
      *                         CH-DATE-UTIL-SVC-STRT.                *         
      *                                                               *         
T17380*   09/25/98    PRA       PCR - AUTOMATICALLY INSERT A RECONNECT*         
      *                         AGREEMENT WHEN A DNP01 IS POSTED      *         
      *                                                               *         
T17534*   10/06/98    FB        SET PREMISE STATUS TO ACTIVE FOR A    *         
      *                         CUSTOMER CHANGE AS WELL AS A SET.     *         
      *                                                               *         
T18326*   10/29/98    FB        UPDATE ACCOUNT START DATE WITH ORDER  *         
      *                         COMPLETION DATE.  UPDATE SERVICE END  *         
      *                         DATES FOR BACKDATED ORDERS.           *         
      *                                                               *         
T18382*   11/05/98    PRA      -PULL RECONNECT CHARGE FOR ELEC IF     *         
      *                         ELEC/GAS CUST                         *         
      *                        -LOAD LOCAL OFFICE AND COMPANY NO      *         
      *                         BEFORE CALLING CPD00068               *         
      *                        -CORRECT PANEL NO IN HIST              *         
      *                                                               *         
T18467*   11/17/98    FB        ON CUSTOMER OR OCCUPANT CHANGE ORDERS,*         
      *                         GET THE PREVIOUS CODE_ACCT_STAT FROM  *         
      *                         THE NEW ACCOUNT.                      *         
      *                                                               *         
T17071*   11/19/98    MJ        ADDED INCLUDE TBCSTALT FOR CUST_ALERT *         
      *                         FOR CPD00068 CHANGES.                 *         
      *                                                               *         
T18605*   12/02/98    FB        FOR CC OR OC, WRITE MNT TRANS HIST FOR*         
      *                         THE NEW ACCOUNT.                      *         
      *                                                               *         
T18529*   12/03/98    AF        DELETE  ANY EXISTING RECONNECT        *         
      *                         AGREEMENTS FOR THE ACCOUNT PRIOR TO   *         
      *                         INSERTING A NEW ONE.                  *         
CBSI  *  12/21/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
      *                                                                         
T18688*  12/28/98     PRA       CHANGES TO CPD00068 DISREGARDING DNP  *         
      *                         LIMITS REQUIRES CHANGE OF SWITCH      *         
T18916*  01/22/99     FB        ADDED JOIN TO CSS_NAME IN 7820-       *         
      *                         SELECT TO GET CUSTOMER NAME.          *         
ADAM  *  01/27/99     AMG       MOVE WS-CENTURY TO WS-DATE-CC.        *         
      *                                                               *         
T18736*  03/08/99     PRA       NEEDED ADDITIONAL FIELDS FOR CPD00068 *         
      *                                                               *         
T19691*  04/15/99     FB        ADDED CUSTOMER_ROLE_CD TO SELECT OF   *         
      *                         CUSTOMER NAME.                        *         
T20005*  05/14/99     PRA       MOVED RECONNECT AGREEMENT DELETION    *         
      *                         PRIOR TO LOADING FIELDS FOR NEW       *         
      *                         AGREEMENT                             *         
T20031*  05/18/99     FB        IGNORE -803 WHEN INSERTING INTO       *         
      *                         CSS_MSTSUB_ACCT.                      *         
T20091*  05/26/99     FB        IGNORE -803 WHEN INSERTING INTO       *         
      *                         CSS_BILL_ADDR_XREF FOR REVERTS.       *         
T19935*  06/02/99     FB        SET CREDIT GROUP TO 'S' FOR REVERTS   *         
      *                         THAT ARE CONSOLIDATED SUBS.           *         
T19936*  08/10/99     TH        SET THE SUB ACCT BILLED TO B(BYPASS)  *         
      *                         PROPERLY WHEN REVERT TO LANDLORD.     *         
T20290*  08/27/99     FB        DO NOT COPY CODE_PERM_BILL FOR A      *         
      *                         CUSTOMER CHANGE.                      *         
T20690*  09/29/99     FB        STRAIGHTEN OUT REVERT FLAGS.          *         
T20855*  09/29/99     FB        IGNORE -803 WHEN INSERTING INTO       *         
      *                         CSS_ACCT_BILL_NMES.                   *         
T21897*  03/22/00     FB        IF ADDRESS ID IS 0, ADDRESS FORMAT    *         
      *                         MUST BE ' ' FOR LANDLORD UPDATE.      *         
T21448*  03/22/00     FB        BILL_HIST_XFER_IND NOT SET TO 'Y' FOR *         
      *                         CONSOLIDATED SUB ACCOUNTS (NOT REVERT)*         
T19557*  03/29/00    CBSI       COPYBOOK CDP00068 CHANGED TO SUB      *         
T19557*              MADRAS     PROGRAM SCSCO068.                     *         
T22148*  04/28/00     FB        POPULATE COMPANY_NO FROM CSS_ACCOUNT  *         
      *                         WHEN INSERTING CSS_BILL_ADDR_XREF.    *         
T22158*  05/02/00     FB        COMMENT OUT HANDLE ABEND.             *         
T22251*  06/14/00     FB        POST BANKRUPT REASON TO PRIOR ACCOUNT *         
T22251*                         FOR A CUSTOMER/OCCUPANT CHANGE.       *         
T22359*  06/23/00    SR82046  MADE CHANGES TO KEEP IDENTITY OF PROGRAM*         
      *                       CALLING SCSCO068 OR SCSCB068.  THERE IS *         
      *                       SPECIFIC LOGIC IN CPD00068 FOR CERTAIN  *         
      *                       PROGRAMS WHICH WAS NOT BEING EXECUTED   *         
      *                       PROPERLY BECAUSE THE PROGRAM NAME WAS   *         
      *                       ALWAYS SCSCO068 OR SCSCB068.            *         
T22519*  07/25/00     FB        BANKRUPTCY INDICATOR BEING WRITTEN    *         
T22519*                         INCORRECTLY.  PREVIOUS AND CURRENT    *         
T22519*                         FIELD REVERSED.                       *         
T22829*  09/25/00     FB        ALLOW OCCUPANT CHANGE IN SEB.         *         
T22829*                         UPDATES TO CSS_MKT_XREF_ACCT.         *         
T22870*  12/18/00     FB        DELETE ALL ROWS FOR ACCOUNT FROM      *         
T22870*                         CSS_BILL_ADDR_XREF BEFORE INSERTING   *         
T22870*                         NEW ROW TO PREVENT DUPLICATES.        *         
T23513*  01/23/2001   CBSI      CHANGES MADE TO DISTINGUISH DATABASES *         
T23513*               MADRAS    DATABASES SEB AND NON SEB TO          *         
T23513*                         INCORPORATE PSNC IN NON SEB           *         
T23618*  03/15/01     RR      INCLUDED SEASONAL AS POSSIBLE REVERT.   *         
T23618*                       IF CODE-RENTAL-PROP = 'S'               *         
T23501*  05/08/01     BK88121   FOR MULTICOMPANY CHANGES COMPANY-NO   *         
T23501*                         INCLUDED IN THE WHERE CLAUSE OF       *         
T23501*                         CSS_DELINQUENCY TABLE                 *         
T23237*  06/27/01     PRA      CML 23237-15 ADD NEW ORDER REASON 'Q'  *         
T23235*  06/28/01     PRA      --ADD CURSOR TO FIND ACCOUNT TYPE CODE *         
T23235*                        TO FIND RECONNECT CHARGE               *         
T23235*                        --ALSO ADD UPDATE OF CSS_CREDIT_PROFILE*         
T23235*                        FOR SECOND NOTICES                     *         
T24815*  08/23/01     FB        DO NOT CHANGE ACCOUNT STATUS REASON   *         
T24815*                         OF OLD ACCOUNT FROM NON-PAYMENT.      *         
T25243*  10/05/01     FB        UPDATE CSS_CRED_COLL FOR NOT ORDERS   *         
T25622*  11/08/01     DD        ADD DISTINCT TO UPDATE CSS_CRED_COLL  *         
      *                         IN PARAGRAPH 7410                     *         
T26266*  04/18/2002   RR        AUTOMATIC WAIVER COMPLETION           *         
C26959*  07/12/2002   FB        COPY UNEXPIRED DHR INFO FOR SEBR      *         
C26959*                         CUSTOMERS UNLESS MANUALLY ENTERED.    *         
C27862*  11/07/2002   RR        ENTER 5900 FOR REGULATED ACCTS ONLY   *         
      *                                                               *         
T28065*  12/16/2002   DD        DO NOT ALLOW SUBDIVISION LIGHTING TO  *         
T28065*                         BE CHARGED ON COMMERCIAL RATE ACCOUNTS*         
C28491*  02/21/03     RR        FIX OCCUPANT CHANGE FOR SEB           *         
C26288*  04/02/03     FB        AT RISK CUSTOMERS START IN BALANCE    *         
C26288*                         CREDIT GROUP.                         *         
C29608*  09/10/03     RR        CHANGE WS-ACCT-TYPE-VALUE TO          *         
C29608*                         WS-ACCT-TYPE-VAL TO AVOID CONFLICT W/ *         
C29608*                         CHANGES MADE TO CWS000068             *         
C28788*  09/10/03     RR        GET IVR-EXEMPT-CD IN ACCT SELECT      *         
C29307*  10/06/03     SR        INSERT A ROW IN CSS_NAME_ACCT_XREF    *         
C29307*                         TABLE W/ NEW NAME ID WHEN PREMISE IS  *         
C29307*                         REVERTED TO THE LANDLORD.             *         
C27317*  12/26/03     SS82048   CHANGES FOR SEB ACN ACCT CREDIT SCORE *         
C30058*  03/02/04     LHO       ADDED CODE TO RETURN 3000 ERROR CODE  *         
C30058*                         IF AN ACTIVE MERCHANDISE CONTRACT     *         
C30058*                         EXISTS FOR COMPANY 26 FOR ANY FB TYPE *         
C30058*                         ORDER.  ALSO ADDED CODE TO CREATE A WQ*         
C30058*                         FOR DNP ORDERS WITH AN ACTIVE         *         
C30058*                         MERCHANDISE CONTRACT.                 *         
C26296*  01/17/05     PRA       AUTOMATED DEPOSITS AT DNP POSTING     *         
C32789*  10/11/05     ARW       EXCLUDE ROWS WITH CR_RQST_REASON_CD OF*         
C32789*                         'B' WHEN SELECT FROM CSS_CREDIT_HIST  *         
C33254*  11/07/05     ARW       UPDATE LAST_BILL_DATE TO ORDER        *         
C33254*                         COMPLETION DATE                       *         
T34128*  04/10/06     FB        KEEP CODE_PERM_BILL FOR NEW ACCOUNT.  *         
T34128*                         DO NOT DEFAULT TO A.                  *         
REARCH*  01/16/07     PA        SO REARCH MODIFICATIONS               *         
REARCH*                         CONVERT OPEN CLIENT CALLS TO DB2 CALLS*         
C36164*  08/09/07     FB        CORRECTED TABLE ID FOR CSS_WAIVER.    *         
C35362*  08/13/07     FB        CORRECTED SERVICE_EST_DATE.           *         
C36210*  11/19/08     FB        AGL DEREGULATED NON-SENIOR            *         
C36210*                         RECONNECT FEES.                       *         
T37635*  09/03/08     AW        ADDING OCCUPANT CHANGE TO LOGIC SO    *         
T37635*                         PARA 8800 WILL BE CALLED TO UPATE     *         
T37635*                         CODE_PREMISE_STAT TO 'A'              *         
A00765*  03/10/09    SV95326    ADDED 9000-SEND-ERROR-RESULT PARA     * PCS00230
A00765*                         BECAUSE CPD00067 NOW CALLED THIS PARA.*         
A37061*  03/10/09    SV95326    REPLACE CSS_UTIL_ENVRMT CODE_REV_CLASS*         
A37061*                         MIDDLE DIGIT CHECK WITH CSS_ACCOUNT   *         
A37061*                         ACCOUNT_TYPE_CODE                     *         
A01232*  06/09/09    DB18339    ADDING CODE TO HANDLE AGL NUMBER WITH *         
A01232*                         CUSTOMER CHANGE FOR SEB ACCTS         *         
P00172*  07/08/09     FB        REMOVE DHR LOGIC.                     *         
A01422*  08/26/09     FB        DO NOT COPY BILL_HIST_XFER_IND FROM   *         
A01422*                         OLD ACCOUNT TO NEW ACCOUNT FOR CC/OC. *         
A37666*  12/03/09     FB        CLEAN UP MAINTENANCE TRANSHIST.       *         
P00342*  03/11/10     MSR       DO NOT PROCESS ROWS WITH CR_BUREAU_CD *         
P00342*                         = 'P'.                                *         
A35665*  05/11/10     FB        SET EXTRA POSTAGE CODE WHEN REVERTING *         
A35665*                         TO AN INTERNATIONAL ADDRESS.          *         
A02516*  07/06/10     FB        CHECK ACCOUNT STATUS OF MASTER BEFORE *         
A02516*                         SETTING UP MASTER/SUB FOR REVERT.     *         
P00399*  08/06/10     FB        REMOVE BALANCE CREDIT GROUP.  UNDO    *         
P00399*                         CHANGES MADE FOR CML 26288.           *         
A02499*  02/07/11     FB        WHEN BANKRUPT REASON, SET PULL CODE   *         
A02499*                         AND PAPERLESS.                        *         
A02940*  04/26/11     DB18339   CHANGED RECONNECT FEE TO BE THE SAME  *         
A02940*                         FOR SENIOR AND NON-SENIOR DEREG SEB   *         
P00453*  05/10/11     SS19371   ADD CHECK FOR PAY AND GO AS WELL AS   *         
P00453*                         BUDGET BILLING WHEN SETTING FOR UTIL  *         
P00471*  05/27/11     PK98692   ADD TWO NEW ORDER REASONS:'W'- RESCH  *         
P00471*                         DNP AND 'T'-RESCH DNP W/RET CHK       *         
P00453*  06/08/11     SS19371   DO NOT SET WAIVER FOR ACCOUNTS SET    *         
P00453*                         UP ON PREPAY PLAN IN SEB              *         
P00471*  08/01/11     PK98692   DPP DROP CHANGES :                    *         
P00471*                        1.ADD 4 NEW ORDER REASONS TO           *         
P00471*                          5400-PROCESS-ACCT-DATA               *         
P00471*                          J-NORMAL DPP; K-NORMAL DPP W/RET CHK *         
P00471*                          U-DROPPED DPP;V-DROPPED DPP W/RET CHK*         
P00471*                        2.CALL CPD00109 TO DROP DPP ON DNP.    *         
P00581*  12/14/11     DB18339  NEW HANDLING FOR SEB DEREG RECONN FEES *         
P00473*  02/23/12     MS93554  CHANGES ADDED TO PULL APPROVED CRM VRSN*         
P00677*  07/17/12     DB18339  ON CC, MOVING REG PROF ROW TO NEW ACCT           
P00704*  12/12/12     SC41135  ADD AUTOMATIC WAIVERS FOR ALL CSR CUST *         
P00726*  05/23/14     DB18339  CHANGING RECONNECT AGREEMENT SQL       *         
P00726*                        IN PARA 7940 AND INSERT IN 8930.       *         
A04880*  08/14/14     DB18339  ADDING PARAMETER TO CSR03515.          *         
P00726*  10/30/14     DB18339  ADDED NOT-FOUND TO PARA 7940.          *         
ACT102*  03/18/16     MC95456  INITIALIZE CWS00077-FIELDS TO AVOID    *         
ACT102*                        PROBLEM WITH WS-77-USER-ID-ASGN.       *         
A05317*  06/22/16     FB       SEB RECONNECT MODS.                    *         
      *****************************************************************         
      *                                                               *         
      *              ---- BASIC SEQUENCE STRUCTURE ----               *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'MCSSO061'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                        PIC X(40)                    
REARCH              VALUE 'WORKING STORAGE FOR MCSSO061 STARTS HERE'.   
                                                                        
       COPY CWS00004.                                                           
       COPY CWS00010.                                                           
       COPY CWS00021.                                                           
       COPY CWS00056.                                                           
       COPY CWS00059.                                                           
       COPY CWS00303.                                                           
P00471 COPY CJF00101.                                                           
T19557*--------< LINKAGE SECTION VARIABLES FOR SCSCO068 >                       
T19557 COPY CWS0068L.                                                   01680000
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00071                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0091A                                                  
           END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471        INCLUDE CWS00317                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471        INCLUDE CWS0013B                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471        INCLUDE CWS00007                                                  
P00471     END-EXEC.                                                            
                                                                        
T23513*--------< CSS_DELINQUENCY TABLE >                                        
T23513     EXEC SQL                                                             
T23513         INCLUDE TBDELQ                                                   
T23513     END-EXEC.                                                            
                                                                        
P00581*--------< CSS_JOB_PARM    TABLE >                                        
P00581     EXEC SQL                                                             
P00581         INCLUDE TBJBPARM                                                 
P00581     END-EXEC.                                                            
                                                                        
P00581*--------< CSS_ACCT_RTPK_AGR DF  >                                        
T23235*--------< CSS_UTIL_ENVRNMT TABLE >                                       
T23235     EXEC SQL                                                             
T23235         INCLUDE TBUTLENV                                                 
T23235     END-EXEC.                                                            
                                                                        
C30058*--------< CSS_CONTRACT           >                                       
C30058     EXEC SQL                                                             
C30058         INCLUDE TBCNTRCT                                                 
C30058     END-EXEC.                                                            
                                                                        
       01  WS-WORK-AREA.                                                
           05  WS-DISPLAY-SQLCODE          PIC -Z(8)9.                  
           05  WS-CUSTOMER-BREAKDOWN       PIC 9(10).                   
           05  FILLER REDEFINES WS-CUSTOMER-BREAKDOWN.                  
               10  FILLER                  PIC 9(01).                   
               10  WS-CUSTOMER-NO          PIC 9(09).                   
           05  CMN-MESSAGE                 PIC X(38).                   
           05  CMN-MESSAGE-NO              PIC X(05).                   
           05  WS-EDIT-ORDER-TYPE          PIC X(05).                   
           05  WS-HOLD-COMPLETED-DATE      PIC X(10).                   
COB305     05 WS-AT-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.          
           05  WS-AT-ACCT-CREATE-DT        PIC X(26).                   
           05  WS-AT-CODE-ACCT-STAT        PIC X(01).                   
           05  WS-AT-CREDIT-GROUP          PIC X(01).                   
           05  WS-NO-OF-DAYS               PIC S9(04) COMP.             
           05  WS-SO-OFF-DATE              PIC X(10).                   
P00471     05  WS-TODAYS-DATE-061          PIC X(10).                   
P00471     05  WS-CURRENT-DATE-061         PIC X(10) VALUE 'SPACES'.    
P00726     05  WS-CURRENT-TS-061           PIC X(26) VALUE 'SPACES'.    
           05  WS-NULL-VALUE               PIC S9(04) COMP VALUE 0.     
           05  WS-NULL-INDICATOR           PIC S9(04) COMP.             
T18326     05  WS-REVISED-END-DATE         PIC X(10).                   
T18736     05  WS-BILL-DAY-00-NI           PIC S9(04)   COMP VALUE +0.  
T18736     05  WS-BILL-DAY-30-NI           PIC S9(04)   COMP VALUE +0.  
T18736     05  WS-BILL-DAY-60-NI           PIC S9(04)   COMP VALUE +0.  
T18736     05  WS-BILL-DAY-90-NI           PIC S9(04)   COMP VALUE +0.  
T28065     05  WS-IC-NO                    PIC 9(04)    COMP.           
T28065     05  WS-LR-EXISTS                PIC S9(04)   COMP VALUE 0.   
P00471     05  WS-DFA-FLAG                 PIC X(01)    VALUE 'N'.      
P00471     05  WS-DFA-RECV-SW              PIC X(01)    VALUE 'N'.      
P00471         88 RECV-DONE                             VALUE 'Y'.      
P00471     05  WS-COMMON-DATE              PIC X(10)    VALUE SPACES.   
P00471     05  WS-SPLIT-REVMTH.                                         
P00471         10  WS-SPLIT-YEAR           PIC 9(04)  VALUE 0.          
P00471         10  WS-SPLIT-MONTH          PIC 9(02)  VALUE 0.          
P00471     05  WS-REVENUE-MONTH-NUM            PIC 9(06) VALUE 0.       
P00471     05  WS-ATTRIBUTE-VALUE-CD           PIC X(05) VALUE SPACES.  
                                                                        
       01  ORDER-TYPE-DEFINITIONS.                                      
           05  WS-VALID-SET-ORDER          PIC X(05) VALUE 'FM002'.     
           05  WS-VALID-CC-ORDER           PIC X(02) VALUE 'CC'.        
           05  WS-VALID-OC-ORDER           PIC X(02) VALUE 'NC'.        
           05  WS-VALID-DNP-ORDER          PIC X(05) VALUE 'DNP01'.     
           05  WS-VALID-DNPFB-ORDER        PIC X(05) VALUE 'DNPFB'.     
           05  WS-VALID-OFF-ORDER          PIC X(02) VALUE 'OF'.        
           05  WS-VALID-ON-ORDER           PIC X(02) VALUE 'ON'.        
           05  WS-VALID-MC-ORDER           PIC X(02) VALUE 'MC'.        
T23235     05  WS-VALID-NOT-ORDER          PIC X(05) VALUE 'NOT01'.     
           05  ORDER-TYPE-1                PIC X(05).                   
           05  ORDER-TYPE-2                PIC X(02).                   
                                                                        
       01  WS-MISCELLANEOUS-VARIABLES.                                  
ACT102     05  WS-DATE-CREATED             PIC X(10)   VALUE SPACES.    
           05  WS-ORIG-ACCT-STAT           PIC X(01).                   
T5813      05  WS-ACCT-XFER-TO             PIC S9(13)V COMP-3 VALUE 0.  
T5813      05  WS-MST-SUB-ACCT-IND         PIC X(01)   VALUE SPACE.     
TP5912     05  PREV-CODE-ACCT-STAT         PIC X(1).                    
TP5912     05  PREV-BANKRUPTCY-IND         PIC X(1).                    
           05  WS-ACCT-CREATE-TS.                                       
               10  WS-ACCT-CREATE-DT       PIC X(10).                   
               10  FILLER                  PIC X(16).                   
           05  WS-COMPLETED-DATE-INPUT.                                 
               10  WS-COMPLETED-DATE-USA   PIC X(10).                   
               10  FILLER                  PIC X(16).                   
           05  WS-PENDING-ACCT-CREATE-DT.                               
               10  WS-PENDING-ACCT-DATE    PIC X(10).                   
               10  FILLER                  PIC X(16).                   
           05  WS-DATETIME-FORMAT.                                      
               10  WS-DATETIME-YEAR        PIC X(04).                   
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-DATETIME-MONTH       PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-DATETIME-DAY         PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-DATETIME-HOUR        PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '.'.         
               10  WS-DATETIME-MIN         PIC X(02).                   
T20068         10  FILLER                  PIC X(08) VALUE              
T20068                                            '.00.0000'.           
T20068         10  WS-DATETIME-MS.                                      
T20068             15  WS-DATETIME-MS1        PIC 9(01) VALUE ZERO.     
T20068             15  WS-DATETIME-MS2        PIC 9(01) VALUE ZERO.     
T20068*                                                                         
T20068     05 WS-DAY-HIST-CTR              PIC S9(04) COMP VALUE ZERO.  
                                                                        
           05  WS-DATE-ACCT-CREATED        PIC X(10).                   
           05  WS-NEW-NAME-ID              PIC S9(13)V USAGE COMP-3     
                                                     VALUE 0.           
           05  WS-CMN-ACCT-MOVED           PIC X(01) VALUE 'N'.         
T17380     05  WS-ELEC-FOUND               PIC X(01) VALUE 'N'.         
T17380     05  WS-GAS-FOUND                PIC X(01) VALUE 'N'.         
T17380     05  WS-NRML-HRS-FLAG            PIC X(01) VALUE 'Y'.         
T17380     05  WS-AMT-TOT-RECONNECT        PIC S9(11)V99.               
T17380     05  WS-TOT-RCNCT-EDT            PIC $$$,$$$,$$$,$$9.99.      
T17380     05  WS-RCNCT-COLLCT-EDT         PIC $$$$,$$$,$$9.99.         
C26296     05  WS-AUTO-DEP-AM-EDT          PIC $$$$,$$$,$$9.99.         
COB305     05 WS-DL-AUTO-DEP-AM        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
T18382     05  WS-PANEL-NO                 PIC X(09) VALUE SPACES.      
T19935     05  WS-REVERT-SUB               PIC X VALUE 'N'.             
T19557     05  WS-EIBRESP                  PIC S9(8)                    
T19557                                     COMP SYNC VALUE ZERO.        
T22829     05  WS-COUNT-XREF               PIC S9(4)   COMP VALUE 0.    
T22829     05  WS-DIST-ACCT                PIC X(10)   VALUE SPACES.    
T22829     05  WS-NUM-COUNT                PIC 9.                       
T22829     05  WS-CHAR-COUNT REDEFINES     WS-NUM-COUNT PIC X.          
T22829     05  WS-HOLD-DIST-ACCT           PIC X(20).                   
T22829     05  WS-NULL-IND-X               PIC S9(04) COMP.             
T23513     05  WS-DATABASE                 PIC 9(01)   VALUE 0.         
T23513         88 CSR-DATABASE                         VALUE 1.         
T23513         88 SEB-DATABASE                         VALUE 2.         
C27862     05  WS-REGULATED-FL             PIC X(01) VALUE 'N'.         
C26288     05  WS-COMPANY-NO               PIC X(02) VALUE '  '.        
P00471     05  WS-ACCOUNT-NO-061           PIC S9(13)V COMP-3 VALUE 0.  
C26296     05  WS-USER-ID                  PIC X(07).                   
C26296     05  WS-ACCOUNT-NO-CHAR          PIC X(13).                   
C26296     05  WS-ACCOUNT-NO-NUM   REDEFINES WS-ACCOUNT-NO-CHAR         
C26296                                     PIC 9(13).                   
C34128     05  WS-HOLD-CODE-PERM-BILL      PIC X(01) VALUE SPACES.      
A01422     05  WS-HOLD-BILL-HIST-XFER      PIC X(01) VALUE SPACES.      
C35362     05  WS-ACCOUNT-NO-NEW           PIC S9(13)V COMP-3 VALUE 0.  
C36210     05  WS-SEB-DEREG-NON-SENIOR     PIC X(01)  VALUE 'Y'.        
COB305     05 WS-SEB-DEREG-NON-SENIOR-RCC        PIC S9(7)V9(2) 
COB305       USAGE COMP-3 VALUE 0. 
COB305     05 WS-SEB-DEREG-RCC        PIC S9(7)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
P00581     05  WS-SEB-RATE-TYPE            PIC X(02) VALUE SPACES.      
P00581     05  WS-OPT-EFF-DT               PIC X(10).                   
P00581     05  WS-PARM-OPT-EFF-DT          PIC X(10).                   
P00581     05  WS-PARM-DATA                PIC X(80).                   
A02516     05  WS-LL-CODE-ACCT-STAT        PIC X(01) VALUE SPACES.      
                                                                        
C30058 01  WORK-FIELDS.                                                 
C30058     05  WS-LC-MESSAGE.                                           
C30058         07  WS-LC-MSG1          PIC X(51)    VALUE               
C30058         'ACTIVE MERCHANDISE CONTRACT EXISTS ON ACCOUNT. '.       
C30058         07  WS-LC-MSG2          PIC X(51)    VALUE               
C30058     'CNT MUST BE TRANSFERRED BEFORE ACCT CAN FINAL BILL'.        
C30058     05  WS-ACTIVE-CONTRACT      PIC X  VALUE 'N'.                
                                                                        
T26266 01  WS-WAIVER.                                                   
T26266     05  WS-CR-ACTION-FL             PIC X(1)  VALUE SPACE.       
T26266     05  WS-RQST-REAS-CD             PIC X(1)  VALUE SPACE.       
T26266     05  WS-WAIVER-EXISTS            PIC X(1)  VALUE 'N'.         
T26266     05  WS-WAIVER-ADDED             PIC X(1)  VALUE 'N'.         
COB305     05 WS-WAIV-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.          
T26266     05  WS-NULL-IND                 PIC S9(4) USAGE COMP VALUE 0.
T26266     05  WS-SB-BOND-ITEM-ID          PIC S9(9) USAGE COMP VALUE 0.
T26266     05  WS-SB-TRIGGER-DATE          PIC X(10) VALUE SPACES.      
T26266     05  WS-TRIGGER-DATE-NI         PIC S9(4) USAGE COMP VALUE -1.
T26266     05  WS-SB-WAIVER-TYPE-CD        PIC X(1)  VALUE SPACE.       
T26266     05  WS-SB-BOND-TYPE             PIC X(1)  VALUE 'C'.         
T26266     05  WS-SB-CODE-STATUS           PIC X(1)  VALUE 'A'.         
T26266     05  WS-SB-CODE-STATUS-REAS      PIC X(20) VALUE SPACES.      
T26266     05  WS-SB-WAIV-SOURCE-DESC      PIC X(35) VALUE SPACES.      
T26266     05  WS-SB-COMMENTS              PIC X(72)                    
                               VALUE 'WAIVER ADDED BY SYSTEM'.          
                                                                        
T23235 01 WS-ACCT-TYPE-CODE                PIC X(01) VALUE SPACES.      
T23235 01 WS-ACCT-TYPE-VAL                 PIC X(01) VALUE SPACES.      
       01 WS-NON-UTIL-FOUND                PIC X(01) VALUE 'N'.         
P00677 01 WS-REG-EXISTS-OLD-ACCT           PIC X(01) VALUE 'N'.         
P00677 01 WS-REG-EXISTS-NEW-ACCT           PIC X(01) VALUE 'N'.         
P00677 01 WS-AGL-SENIOR-ATTR               PIC X(01) VALUE 'N'.         
P00677 01 WS-AGL-SENIOR-STATUS             PIC X(01) VALUE 'N'.         
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-A                        PIC X(01)   VALUE 'A'.       
           05  WS-B                        PIC X(01)   VALUE 'B'.       
           05  WS-C                        PIC X(01)   VALUE 'C'.       
           05  WS-J                        PIC X(01)   VALUE 'J'.       
           05  WS-S                        PIC X(01)   VALUE 'S'.       
P00471     05  WS-R                        PIC X(01)   VALUE 'R'.       
P00471     05  WS-D                        PIC X(01)   VALUE 'D'.       
P00471     05  WS-0                        PIC 9(01)   VALUE 0.         
P00471     05  WS-90                       PIC S9(4)   USAGE COMP       
P00471                                                 VALUE 90.        
P00471     05  WS-100                      PIC S9(4)   USAGE COMP       
                                                       VALUE 100.       
T5172      05  WS-YES                      PIC X(01)   VALUE 'Y'.       
ACT102     05  WS-Y                        PIC X(01)   VALUE 'Y'.       
ACT102     05  WS-N                        PIC X(01)   VALUE 'N'.       
           05  WS-RCC-FOUND                PIC X(01)   VALUE 'N'.       
T5368      05  WS-REVERT-TO-LANDLORD       PIC X(01)   VALUE 'R'.       
           05  WS-FORCED                   PIC X(01)   VALUE 'F'.       
           05  WS-CUST-PREM-HIST-FOUND     PIC X(01)   VALUE 'N'.       
           05  WS-DISCONNECT-HIST.                                      
               10  WS-DISCONNECT-HIST-1                PIC X(01).       
               10  WS-DISCONNECT-HIST-FILLER           PIC X(23).       
           05  WS-DISC-EXCEPTN-HIST.                                    
               10  WS-DISC-EXCEPTN-HIST-1              PIC X(01).       
               10  WS-DISC-EXCEPTN-HIST-FILLER         PIC X(23).       
T17380     05  MULTIPLE-ROWS-SELECTED      PIC S9(09) VALUE -811 COMP.  
T24815     05  WS-PREV-STAT-REASON         PIC X(01)  VALUE SPACES.     
                                                                        
T5172  01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'MCSSO061'.      
                                                                        
ACT102 01  MCSCB077                    PIC X(08) VALUE 'MCSCB077'.      
ACT102 01  WS-MCSCB077-OUTPUT.                                          
ACT102     05  WS-MCSCB077-RET-CODE    PIC S9(09) COMP VALUE 0.         
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  MCSCB068                PIC X(8) VALUE 'MCSCB068'.       
                                                                        
C26296 01  WS-CSR03515-RETURN-FIELDS.                                   
C26296     05  WS-3515-RETURN-CODE       PIC S9(09) COMP VALUE 0.       
C26296     05  WS-3515-AUTO-DEP-AMT      PIC S9(09)V99 COMP-3 VALUE 0.  
C26296     05  WS-3515-DEP-SUCCESS       PIC X(01)  VALUE SPACES.       
C26296     05  WS-3515-DEP-CERT-NO       PIC S9(09) COMP VALUE 0.       
C26296     05  WS-3515-MAX-DEP-ZERO-WQ   PIC X(01)  VALUE SPACES.       
C26296     05  WS-3515-AMT-SECURED       PIC S9(09)V99 COMP-3 VALUE 0.  
C26296     05  WS-3515-ABEND-PROGRAM     PIC X(08)  VALUE SPACES.       
C26296     05  WS-3515-ACTIVE-PARAGRAPH  PIC X(04)  VALUE SPACES.       
C26296     05  WS-3515-ABEND-FUNCTION    PIC X(08)  VALUE SPACES.       
C26296     05  WS-3515-TABLE-1           PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-TABLE-ELEMENT-1   PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-HOSTVAR-ELEMENT-1 PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-TABLE-ELEMENT-2   PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-HOSTVAR-ELEMENT-2 PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-TABLE-ELEMENT-3   PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-HOSTVAR-ELEMENT-3 PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-TABLE-ELEMENT-4   PIC X(20)  VALUE SPACES.       
C26296     05  WS-3515-HOSTVAR-ELEMENT-4 PIC X(20)  VALUE SPACES.       
C26296***************************************************************           
C26296*    DB2 COMMUNICATION REQUIREMENT *                          *           
C26296***************************************************************           
C26296*01  LOC1                  USAGE IS SQL TYPE IS                   
C26296*                          RESULT-SET-LOCATOR VARYING.            
C26296 01  ERROR-MESSAGE.                                               
C26296     02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
C26296     02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
C26296                           INDEXED BY ERROR-INDEX.                
C26296 77  ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.             
C26296 77  TRACE-MESSAGE-AREA    PIC X(256).                            
C26296 77  OPENFN                PIC X(12).                             
C26296 77  SSID                  PIC X(4).                              
C26296 77  PLANNAME              PIC X(8).                              
C26296 77  RETCODE               PIC S9(5).                             
C26296 77  REASCODE              PIC S9(5).                             
C26296 77  CLOSFN                PIC X(12).                             
C26296 77  TERMOP                PIC X(4).                              
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
                                                                        
      ****************************************************************          
      *    DB2 DCLGEN DECLARATIONS.                                  *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRECNCT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMSTSUB                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLADRX                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAMEID                                                  
           END-EXEC.                                                            
                                                                        
T17110     EXEC SQL                                                             
T17110        INCLUDE TBATBLNM                                                  
T17110     END-EXEC.                                                            
                                                                        
T17380     EXEC SQL                                                             
               INCLUDE TBRCNCHR                                                 
           END-EXEC.                                                            
                                                                        
T22829     EXEC SQL                                                             
T22829         INCLUDE TBMRKXR                                                  
T22829     END-EXEC.                                                            
                                                                        
T25243     EXEC SQL                                                             
T25243         INCLUDE TBCRCOLL                                                 
T25243     END-EXEC.                                                            
                                                                        
T26266     EXEC SQL                                                             
T26266         INCLUDE TBSTYBND                                                 
T26266     END-EXEC.                                                            
                                                                        
T26959     EXEC SQL                                                             
T26959         INCLUDE TBREGPRF                                                 
T26959     END-EXEC.                                                            
                                                                        
T35665     EXEC SQL                                                             
T35665         INCLUDE TBADRFRE                                                 
T35665     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBDFAACT                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBDFARCV                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBCCCHRG                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBARCNTL                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBACTATT                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBSBLMSG                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBARHIST                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBARHDT                                                  
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBMSJRNL                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBBJCNTL                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBBTJRNL                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBGLATNO                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBCDJRNL                                                 
P00471     END-EXEC.                                                            
                                                                        
P00471     EXEC SQL                                                             
P00471         INCLUDE TBCDCNTL                                                 
P00471     END-EXEC.                                                            
                                                                        
P00726     EXEC SQL                                                             
P00726         INCLUDE TBRECTRM                                                 
P00726     END-EXEC.                                                            
                                                                        
ACT102*                                                                         
ACT102/***** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR MCSCB077              
ACT102     EXEC SQL                                                             
ACT102          INCLUDE CWS00077                                                
ACT102     END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE AUTO-DEP-CR CURSOR
MSQ001          FOR CALL CSR03515                                       
C26296         ( :WS-ACCOUNT-NO-CHAR
                  , 'MCSSO061'
                  , 'B'
                  , :DL-AUTO-DEP-AM
                  , :WS-USER-ID
                  , 'N'
                  , '          '
                  )
MSQ001        END-EXEC.
     
ACT102                                                                  
P00471*                                                                         
       LINKAGE SECTION.                                                 
                                                                        
REARCH COPY CCA00004.                                                           
                                                                        
                                                                        
REARCH PROCEDURE DIVISION USING CMN-SO100-LINK-AREA.                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
                                                                        
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
           PERFORM 0130-INIT-CWS00021-FLDS THRU 0130-EXIT.              
           PERFORM 0150-INIT-CWS00303-FLDS THRU 0150-EXIT.              
           PERFORM 0205-INIT-CWS00010-FLDS THRU 0205-EXIT.              
           PERFORM 0215-INIT-CWS00056-FLDS THRU 0215-EXIT.              
           PERFORM 1000-PROCESS-INPUT      THRU 1000-EXIT.              
           PERFORM 2000-PROCESS-OUTPUT     THRU 2000-EXIT.              
           PERFORM 9001-TERMINATE-LINK     THRU 9001-EXIT.              
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      *                                                                *        
      *     INITIALIZES ALL WORKING STORAGE FIELDS AND DB2 HOST        *        
      *     VARIABLES EACH TIME THIS SUBROUTINE IS CALLED.             *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           MOVE LOW-VALUES                 TO WS-WORK-AREA.             
           MOVE ZEROES                     TO WS-HOLD-COMPLETED-DATE    
           MOVE LOW-VALUES                 TO DCLCSS-ACCOUNT            
                                              DCLCSS-CUSTOMER           
                                              DCLCSS-CUST-PREM-HIST.    
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*    EJECT                                                                
                                                                        
      **************************************************                        
      * COPYBOOK INCLUDES.                             *                        
      **************************************************                        
           COPY CPD0021B.                                                       
           COPY CPD0303B.                                                       
           COPY CPDX010B.                                                       
           COPY CPD0056B.                                                       
HPCCDM*    EJECT                                                                
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     PERFORMS RECEIVES OF INPUT AND CONTROLS EDITING AND        *        
      *     PROCESSING OF IT.                                          *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE 1000                       TO ACTIVE-PARAGRAPH.         
                                                                        
           PERFORM 1100-LOAD-WORK-AREAS    THRU 1100-EXIT.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1100 LOAD WORK AREAS                                           *        
      *                                                                *        
      *     LOADS THE WORK AREAS FOR USE IN THE PROGRAM.               *        
      *                                                                *        
      ******************************************************************        
       1100-LOAD-WORK-AREAS.                                            
                                                                        
           MOVE 1100                      TO ACTIVE-PARAGRAPH.          
           MOVE ZEROES                    TO WS-DATE-BREAKDOWN.         
REARCH     MOVE WS-CURRENT-DATE-061       TO WS-COMP-JULEDATE.          
           MOVE WS-MONTH                  TO WS-DATE-MM.                
           MOVE WS-DATEHOLD-DAY           TO WS-DATE-DD.                
           MOVE WS-YEAR                   TO WS-DATE-YY.                
ADAM       MOVE WS-CENTURY                TO WS-DATE-CC.                
P00471     MOVE WS-DATE-BREAKDOWN         TO WS-TODAYS-DATE-061.        
           MOVE CMN-SERV-ORDER-TYPE       TO ORDER-TYPE-1               
                                             ORDER-TYPE-2.              
           MOVE CMN-HOLD-COMPLETED-DATE   TO WS-HOLD-COMPLETED-DATE.    
           MOVE CMN-CODES-SO-DATA-PRESENT TO WS-CODES-SO-DATA-PRESENT.  
           MOVE CMN-SO-OFF-DATE           TO WS-SO-OFF-DATE.            
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
T17380     PERFORM 5510-GET-TIMESTAMP          THRU 5510-EXIT.          
           MOVE MH-DATE-TRANS                  TO WS-CURRENT-DATE-061.  
P00726     MOVE MH-TRANS-HIST-SEQ-NO           TO WS-CURRENT-TS-061.    
           PERFORM 5000-UPDATE                 THRU 5000-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
C26296***************************************************************           
C26296* THIS PARAGRAPH CALLS CSR03515 TO UPDATE THE AUTO DEP AMT    *           
C26296***************************************************************           
C26296 2250-CALL-CSR03515.                                              
C26296                                                                  
C26296*    EXEC SQL CALL CSR03515                                       
C26296*        (:WS-ACCOUNT-NO-CHAR                                     
REARCH*        ,'MCSSO061'                                              
C26296*        ,'B'                                                     
C26296*        ,:DL-AUTO-DEP-AM                                         
C26296*        ,:WS-USER-ID                                             
C26296*        ,'N'                                                     
A04880*        ,'          ')                                           
C26296*    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE AUTO-DEP-CR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN AUTO-DEP-CR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR AUTO-DEP-CR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
C26296      IF  SQLCODE = 466 THEN                                      
C26296*         EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE       
C26296*            CSR03515                                             
C26296*         END-EXEC                                                
C26296*         EXEC SQL                                                
C26296*           ALLOCATE AUTO-DEP-CR CURSOR FOR RESULT SET :LOC1      
C26296*         END-EXEC                                                
C26296          EXEC SQL                                                
C26296            FETCH AUTO-DEP-CR INTO :WS-3515-RETURN-CODE           
C26296                         ,:WS-3515-AUTO-DEP-AMT                   
C26296                         ,:WS-3515-DEP-SUCCESS                    
C26296                         ,:WS-3515-DEP-CERT-NO                    
C26296                         ,:WS-3515-MAX-DEP-ZERO-WQ                
C26296                         ,:WS-3515-AMT-SECURED                    
C26296                         ,:WS-3515-ABEND-PROGRAM                  
C26296                         ,:WS-3515-ACTIVE-PARAGRAPH               
C26296                         ,:WS-3515-ABEND-FUNCTION                 
C26296                         ,:WS-3515-TABLE-1                        
C26296                         ,:WS-3515-TABLE-ELEMENT-1                
C26296                         ,:WS-3515-HOSTVAR-ELEMENT-1              
C26296                         ,:WS-3515-TABLE-ELEMENT-2                
C26296                         ,:WS-3515-HOSTVAR-ELEMENT-2              
C26296                         ,:WS-3515-TABLE-ELEMENT-3                
C26296                         ,:WS-3515-HOSTVAR-ELEMENT-3              
C26296                         ,:WS-3515-TABLE-ELEMENT-4                
C26296                         ,:WS-3515-HOSTVAR-ELEMENT-4              
C26296          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296          IF SQLCODE = SUCCESSFUL-CALL                            
C26296              EVALUATE WS-3515-RETURN-CODE                        
C26296                 WHEN 0                                           
C26296                     CONTINUE                                     
C26296                 WHEN OTHER                                       
C26296                  MOVE '2250'                TO ACTIVE-PARAGRAPH  
C26296                  MOVE 'CSR03515 FAILED'          TO CMN-TABLE-1  
C26296                  MOVE WS-3515-ABEND-PROGRAM      TO CMN-TABLE-2  
C26296                  MOVE WS-3515-TABLE-ELEMENT-1                    
C26296                                          TO CMN-TABLE-ELEMENT-1  
C26296                  MOVE WS-3515-HOSTVAR-ELEMENT-1                  
C26296                                        TO CMN-HOSTVAR-ELEMENT-1  
C26296                  MOVE WS-3515-TABLE-ELEMENT-2                    
C26296                                          TO CMN-TABLE-ELEMENT-2  
C26296                  MOVE WS-3515-HOSTVAR-ELEMENT-2                  
C26296                                        TO CMN-HOSTVAR-ELEMENT-2  
C26296                  MOVE WS-3515-TABLE-ELEMENT-3                    
C26296                                          TO CMN-TABLE-ELEMENT-3  
C26296                  MOVE WS-3515-HOSTVAR-ELEMENT-3                  
C26296                                        TO CMN-HOSTVAR-ELEMENT-3  
C26296                  MOVE WS-3515-TABLE-ELEMENT-4                    
C26296                                          TO CMN-TABLE-ELEMENT-4  
C26296                  MOVE WS-3515-HOSTVAR-ELEMENT-4                  
C26296                                        TO CMN-HOSTVAR-ELEMENT-4  
C26296                  MOVE WS-3515-RETURN-CODE                        
C26296                                        TO WS-ACTIVE-RETURN-CODE  
C26296                  PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT  
C26296          ELSE                                                    
C26296              MOVE '2250'                    TO ACTIVE-PARAGRAPH  
C26296              MOVE 'CSR03515 FAILED'              TO CMN-TABLE-1  
C26296              MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE  
C26296              MOVE 'ACCOUNT_NO'           TO CMN-TABLE-ELEMENT-1  
C26296              MOVE WS-ACCOUNT-NO-CHAR   TO CMN-HOSTVAR-ELEMENT-1  
C26296              PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT      
C26296          END-IF                                                  
C26296*                                                                         
C26296          EXEC SQL                                                
C26296             CLOSE AUTO-DEP-CR                                    
C26296          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296*                                                                         
C26296          IF SQLCODE = SUCCESSFUL-CALL                            
C26296             CONTINUE                                             
C26296          ELSE                                                    
C26296             MOVE '2250'                     TO ACTIVE-PARAGRAPH  
C26296             MOVE 'CSR03515 CLOSE FAILED'         TO CMN-TABLE-1  
C26296             MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE  
C26296             MOVE 'ACCOUNT_NO'            TO CMN-TABLE-ELEMENT-1  
C26296             MOVE WS-ACCOUNT-NO-CHAR    TO CMN-HOSTVAR-ELEMENT-1  
C26296             PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT       
C26296          END-IF                                                  
C26296      ELSE                                                        
C26296          MOVE '2250'                     TO ACTIVE-PARAGRAPH     
C26296          MOVE 'CSR03515 CALL FAILED'          TO CMN-TABLE-1     
C26296          MOVE -1                    TO WS-ACTIVE-RETURN-CODE     
C26296          MOVE 'ACCOUNT_NO'            TO CMN-TABLE-ELEMENT-1     
C26296          MOVE WS-ACCOUNT-NO-CHAR    TO CMN-HOSTVAR-ELEMENT-1     
C26296          PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT          
C26296      END-IF.                                                     
C26296*                                                                         
C26296 2250-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5000-UPDATE.                                                   *        
      *                                                                *        
      *     PERFORM THE UPDATES FOR THE ORDER TYPE.                    *        
      *                                                                *        
      ******************************************************************        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           IF ORDER-TYPE-1 = WS-VALID-SET-ORDER                         
              MOVE 'Y'                         TO WS-CMN-ACCT-MOVED     
           END-IF.                                                      
                                                                        
           MOVE CMN-ACCOUNT-NO                 TO CH-ACCOUNT-NO.        
           MOVE CMN-PREMISE-NO                 TO CH-PREMISE-NO.        
                                                                        
           PERFORM 5200-PROCESS-ACCT-UPDATES   THRU 5200-EXIT.          
           PERFORM 5500-JRNL-TRAN-PROCESS      THRU 5500-EXIT.          
                                                                        
           IF ORDER-TYPE-1 = WS-VALID-SET-ORDER AND                     
              WS-CMN-ACCT-MOVED = 'Y'                                   
              MOVE CMN-ACCOUNT-NO              TO CMN-ACCOUNT-NO        
           END-IF.                                                      
                                                                        
           IF ORDER-TYPE-1 = WS-VALID-SET-ORDER OR                      
T17534        ORDER-TYPE-2 = WS-VALID-CC-ORDER  OR                      
T37635        ORDER-TYPE-2 = WS-VALID-OC-ORDER                          
                 PERFORM 8800-UPDATE-PREM-STAT    THRU 8800-EXIT        
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5050-GET-NEW-NAME-ID                                           *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       5050-GET-NEW-NAME-ID.                                            
                                                                        
           MOVE 'PANEL090'                    TO WS-91-PANEL-NO.        
           MOVE CMN-USER-ID                   TO WS-91-USERID.          
           MOVE AT-ACCOUNT-NO                 TO WS-91-ACCOUNT-NO.      
           MOVE ZEROES                        TO WS-91-CUSTOMER-NO.     
           MOVE ZEROES                        TO WS-91-PREMISE-NO.      
                                                                        
           PERFORM 6302-GET-NEW-NAME-ID       THRU 6302-EXIT.           
           MOVE WS-91-NEW-NAME-ID             TO WS-NEW-NAME-ID.        
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5200-PROCESS-ACCT-UPDATES.                                     *        
      *                                                                *        
      *     GET THE ACCOUNT INFORMATION AND PROCESS THE ORDER TYPE.    *        
      *                                                                *        
      ******************************************************************        
       5200-PROCESS-ACCT-UPDATES.                                       
                                                                        
           MOVE CMN-ACCOUNT-NO                  TO AT-ACCOUNT-NO.       
           PERFORM 7210-SELECT-ACCOUNT          THRU 7210-EXIT.         
                                                                        
           MOVE AT-CODE-ACCT-STAT               TO PREV-CODE-ACCT-STAT. 
           MOVE AT-BANKRUPTCY-IND               TO PREV-BANKRUPTCY-IND. 
           MOVE AT-CUSTOMER-NO                  TO CU-CUSTOMER-NO.      
T24815     MOVE AT-CODE-STATUS-REASON           TO WS-PREV-STAT-REASON. 
C26288     MOVE AT-COMPANY-NO                   TO WS-COMPANY-NO.       
C26288     MOVE AT-ACCOUNT-NO                   TO WS-ACCOUNT-NO        
P00471                                             WS-ACCOUNT-NO-061.   
                                                                        
C30058     IF WS-COMPANY-NO = '26'                                      
C30058         IF (ORDER-TYPE-1 = WS-VALID-DNPFB-ORDER OR               
C30058                            WS-VALID-DNP-ORDER) OR                
C30058            (ORDER-TYPE-2 = WS-VALID-OFF-ORDER OR                 
C30058                            WS-VALID-CC-ORDER OR                  
C30058                            WS-VALID-OC-ORDER)                    
C30058             PERFORM 5210-SELECT-CONTRACTS THRU 5210-EXIT         
C30058         END-IF                                                   
C30058     END-IF.                                                      
C30058*                                                                         
      *    IF ORDER-TYPE-1 = 'FM002' OR (ORDER-TYPE-2 = 'CC' OR 'NC')           
           IF ORDER-TYPE-2 = 'CC' OR 'NC'                               
              MOVE CMN-ACCOUNT-NO-NEW           TO WS-AT-ACCOUNT-NO     
              PERFORM 7211-SELECT-ACCOUNT       THRU 7211-EXIT          
T18467        MOVE WS-AT-CODE-ACCT-STAT         TO PREV-CODE-ACCT-STAT  
              PERFORM 5300-CHECK-ACCT-CREATE-DT THRU 5300-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 5400-PROCESS-ACCT-DATA       THRU 5400-EXIT.         
                                                                        
T26266* ADD WAIVER ONLY WHEN POSTING SET, CC, OR OC ORDERS                      
T26266     IF (ORDER-TYPE-1 = 'FM002'    OR                             
T26266         (ORDER-TYPE-2 = 'CC' OR 'NC'))                           
T26266                                                                  
T26266* USE THE CORRECT ACCOUNT_NO                                              
T26266       IF ORDER-TYPE-2 = 'CC' OR 'NC'                             
T26266         MOVE CMN-ACCOUNT-NO-NEW           TO WS-WAIV-ACCT-NO     
T26266       ELSE                                                       
T26266         MOVE CMN-ACCOUNT-NO               TO WS-WAIV-ACCT-NO     
M26266       END-IF                                                     
T26266                                                                  
T26266* SET FLAGS THAT DETERMINE IF WAIVER SHOULD BE ADDED.                     
T26266       PERFORM 5700-SEL-CRED-ACTION-FL      THRU 5700-EXIT        
T26266                                                                  
T26266* DETERMINE MAX BOND-ITEM-ID                                              
T26266       PERFORM 5705-SEL-MAX-WAIVER          THRU 5705-EXIT        
T26266       IF WS-NULL-IND < 0                                         
T26266         MOVE 0                            TO WS-SB-BOND-ITEM-ID  
T26266       END-IF                                                     
T26266       ADD 1                              TO WS-SB-BOND-ITEM-ID   
T26266                                                                  
T26266* SET WAIVER SOURCE CODE IF NOT REVERT-TO-LL                              
T26266       IF (WS-SB-WAIVER-TYPE-CD NOT EQUAL 'L')                    
T26266         MOVE 'D' TO WS-SB-WAIVER-TYPE-CD                         
T26266       END-IF                                                     
T26266                                                                  
T26266* ADD WAIVER                                                              
P00704      IF CSR-DATABASE                                             
T26266       IF (WS-SB-WAIVER-TYPE-CD = 'L') OR                         
T26266         (WS-CR-ACTION-FL = 'W' AND                               
C27317         (WS-RQST-REAS-CD = 'D' OR = 'A')) THEN                   
T26266            IF WS-WAIVER-EXISTS = 'N'                             
P00453            AND WS-CODE-PRE-PAY-PLAN NOT = 'A'                    
T26266              PERFORM 5710-ADD-WAIVER          THRU 5710-EXIT     
T26266              MOVE 'Y'                         TO WS-WAIVER-ADDED 
T26266              MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT 
T26266              MOVE 'A'                         TO WS-CODE-SEC-ACCT
T26266              MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT 
T26266              MOVE WS-WAIV-ACCT-NO             TO AT-ACCOUNT-NO   
T26266              PERFORM 8420-UPDATE-CODES-DATA-PRES THRU 8420-EXIT  
T26266            END-IF                                                
T26266       END-IF                                                     
P00704      END-IF                                                      
T26266     END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
C30058******************************************************************        
C30058* 5210-SELECT-CONTRACTS.                                         *        
C30058*                                                                *        
C30058*     SELECT ACTIVE MERCHANDIS CONTRACTS FOR PSNC(COMP-26),      *        
C30058*     OMITTING THIRD PARTY CONTRACTS (CNT = 1080)                *        
C30058*     SEND A WQ FOR DNP ORDERS.                                  *        
C30058*                                                                *        
C30058******************************************************************        
C30058 5210-SELECT-CONTRACTS.                                           
C30058                                                                  
                                                                        
C30058     EXEC SQL                                                     
C30058       SELECT TOP(1) 'Y'                                                 
C30058         INTO :WS-ACTIVE-CONTRACT                                 
C30058         FROM CSS_CONTRACT                                        
C30058        WHERE ACCOUNT_NO    = :WS-ACCOUNT-NO-061                  
C30058          AND CNT_STATUS_CD IN ('A', 'B')                         
C30058          AND CODE_CONTRACT_TYPE = 'B'                            
C30058          AND CODE_BILL_TYPE = 'C'                                
C30058          AND CNT_NAME_CD <> 1080                                 
C30058                                           
                                                            
C30058     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-ACTIVE-CONTRACT                                         
MFA-TR*        FROM CSS_CONTRACT                                                
MFA-TR*       WHERE ACCOUNT_NO    = :WS-ACCOUNT-NO-061                          
MFA-TR*         AND CNT_STATUS_CD IN ('A', 'B')                                 
MFA-TR*         AND CODE_CONTRACT_TYPE = 'B'                                    
MFA-TR*         AND CODE_BILL_TYPE = 'C'                                        
MFA-TR*         AND CNT_NAME_CD = 1080                                         
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 5210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30058*                                                                         
C30058     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30058     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30058        NEXT SENTENCE                                             
C30058     ELSE                                                         
C30058        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C30058        MOVE '5210'                    TO ACTIVE-PARAGRAPH        
C30058        MOVE 'CSS_CONTRACT'            TO CMN-TABLE-1             
C30058        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
C30058        MOVE WS-ACCOUNT-NO-061         TO CMN-HOSTVAR-ELEMENT-1   
C30058        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
C30058     END-IF.                                                      
C30058*                                                                         
C30058     IF WS-ACTIVE-CONTRACT = 'Y'                                  
C30058         IF ORDER-TYPE-1 = WS-VALID-DNP-ORDER                     
ACT102             INITIALIZE CWS00077-FIELDS                           
ACT102             MOVE 304               TO WS-77-CATEGORY-ID          
C30058             PERFORM 5520-GET-RESP-AREA THRU 5520-EXIT            
ACT102             MOVE PF-RESP-AREA-ID   TO WS-77-RESP-AREA-ID         
ACT102             MOVE CMN-SERV-ORDER-NO TO WS-77-SERV-ORDER-NO        
ACT102             MOVE CMN-USER-ID       TO WS-77-USER-ID-ORIG         
C30058             PERFORM 5215-GET-CURRENT-DT THRU 5215-EXIT           
ACT102             MOVE WS-DATE-CREATED   TO WS-77-DATE-REQUIRED        
ACT102             MOVE CMN-ACCOUNT-NO    TO WS-77-ACCOUNT-NO           
ACT102             MOVE CMN-PREMISE-NO    TO WS-77-PREMISE-NO           
ACT102             MOVE CMN-CUSTOMER-NO    TO WS-77-CUSTOMER-NO         
ACT102             MOVE AT-LOCAL-OFFICE   TO WS-77-LOCAL-OFFICE         
ACT102             MOVE '4'               TO WS-77-ROUTE-CATEGORY       
ACT102             MOVE 'N'               TO WS-77-PRIORITY             
ACT102             MOVE WS-LC-MESSAGE     TO WS-77-COMMENTS-TEXT        
ACT102             MOVE LENGTH OF WS-LC-MESSAGE TO WS-77-COMMENTS-LEN   
ACT102             MOVE SPACES            TO WS-77-FREE-FORM-TXT        
ACT102             MOVE ZERO              TO WS-77-FREE-FORM-LEN        
ACT102             MOVE PROGRAM-NAME      TO WS-77-CREATED-BY           
C30058             PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT        
C30058         ELSE                                                     
C30058             MOVE 'ACTIVE CONTRACT'  TO CMN-TABLE-1               
C30058             MOVE 'ACCOUNT-NO'  TO CMN-TABLE-ELEMENT-1            
C30058             MOVE 3000 TO CMN-TABLE-ELEMENT-2                     
C30058             MOVE WS-ACCOUNT-NO-061 TO CMN-HOSTVAR-ELEMENT-1      
C30058             MOVE 'Y' TO CMN-ABEND-CHECK                          
C30058             PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT        
C30058         END-IF                                                   
C30058     END-IF.                                                      
C30058*                                                                         
C30058*                                                                         
C30058 5210-EXIT.                                                       
C30058     EXIT.                                                        
                                                                        
C30058******************************************************************        
C30058* 5215-GET-CURRENT-DT.                                           *        
C30058*                                                                *        
C30058*     GET CURRENT DATE FOR WQ INSERT.                            *        
C30058*                                                                *        
C30058******************************************************************        
C30058 5215-GET-CURRENT-DT.                                             
C30058     MOVE '5215'      TO ACTIVE-PARAGRAPH.                        
C30058                                                                  
C30058     EXEC SQL                                                     
ACT102         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-CREATED                      
C30058     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DATE-CREATED = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30058                                                                  
C30058     MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
C30058                                                                  
C30058     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30058        NEXT SENTENCE                                             
C30058     ELSE                                                         
C30058        MOVE 'SERV_ORDER_NO'            TO CMN-TABLE-ELEMENT-1    
C30058        MOVE CMN-SERV-ORDER-NO          TO CMN-HOSTVAR-ELEMENT-1  
C30058        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C30058     END-IF.                                                      
C30058                                                                  
C30058 5215-EXIT.                                                       
C30058     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5300-CHECK-ACCT-CREATE-DT.                                     *        
      *                                                                *        
      *     IF THE COMPLETION DATE IS LESS THAN THE ACCOUNT CREATEION  *        
      *     DATE FOR A PENDING ACCOUNT, THEN UPDATE THE ACCOUNT        *        
      *     CREATION DATE TO THE ORDER COMPLETION DATE.                *        
      *                                                                *        
      ******************************************************************        
       5300-CHECK-ACCT-CREATE-DT.                                       
                                                                        
           IF WS-AT-CODE-ACCT-STAT = 'P'                                
              MOVE WS-AT-ACCT-CREATE-DT     TO WS-PENDING-ACCT-CREATE-DT
              MOVE WS-HOLD-COMPLETED-DATE   TO WS-COMPLETED-DATE-INPUT  
              PERFORM 7900-CHECK-NO-DAYS    THRU 7900-EXIT              
                                                                        
              IF WS-NO-OF-DAYS > 0                                      
                 PERFORM 7910-MOVE-DATE     THRU 7910-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5400-PROCESS-ACCT-DATA.                                        *        
      *                                                                *        
      *     SETS THE ACCOUNT TABLE CODES ACCORDING TO THE ORDER TYPE.  *        
      *                                                                *        
      ******************************************************************        
       5400-PROCESS-ACCT-DATA.                                          
                                                                        
           MOVE '5400'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           MOVE WS-A                           TO AT-CODE-STATUS-REASON.
                                                                        
T23513     MOVE ZEROS                          TO WS-DATABASE.          
T23513     MOVE 'DATABASE'                     TO C8-DELINQ-CD.         
T23513     PERFORM 7950-GET-DELINQ-VALUE THRU 7950-EXIT.                
T23513     MOVE C8-DELINQ-VALUE                TO WS-DATABASE.          
                                                                        
           IF ORDER-TYPE-2 = WS-VALID-CC-ORDER OR WS-VALID-OC-ORDER     
              MOVE CMN-ACCOUNT-NO-NEW          TO AT-ACCOUNT-NO         
              MOVE WS-A                        TO AT-CODE-ACCT-STAT     
                                                                        
              IF CMN-ORDER-REASON = WS-REVERT-TO-LANDLORD               
                 PERFORM 7600-GET-MASTER-ACCT  THRU 7600-EXIT           
                                                                        
A02516           IF SI-LL-MASTER-ACCT-NO > 0                            
A02516               PERFORM 7610-GET-MASTER-STAT THRU 7610-EXIT        
A02516           END-IF                                                 
                                                                        
                 IF SI-LL-MASTER-ACCT-NO > 0                            
                                                                        
T19935              MOVE 'Y'                   TO WS-REVERT-SUB         
                    MOVE SI-LL-MASTER-ACCT-NO  TO WS-ACCT-XFER-TO       
                    MOVE 'S'                   TO WS-MST-SUB-ACCT-IND   
                                                                        
                    PERFORM 8600-INSERT-MST-ACCT  THRU 8600-EXIT        
                                                                        
                    MOVE 'S'                   TO AT-CREDIT-GROUP       
                    MOVE 'Y'                   TO AT-BILL-HIST-XFER-IND 
                    MOVE 'Y'                   TO AT-AR-XFER-IND        
                    PERFORM 7700-GET-MASTER-CODES THRU 7700-EXIT        
                    PERFORM 8311-UPDATE-MST-CODES THRU 8311-EXIT        
T20290           ELSE                                                   
A01422               MOVE WS-HOLD-BILL-HIST-XFER TO                     
A01422                    AT-BILL-HIST-XFER-IND                         
C34128               MOVE WS-HOLD-CODE-PERM-BILL TO AT-CODE-PERM-BILL   
                 END-IF                                                 
                                                                        
                 PERFORM 7795-CHECK-LL-FLAG    THRU 7795-EXIT           
T23618           IF PR-CODE-RENTAL-PROP = 'D' OR 'S'                    
                    PERFORM 5550-REVERT-TO-LL       THRU 5550-EXIT      
T26266              MOVE 'L'               TO WS-SB-WAIVER-TYPE-CD      
                 END-IF                                                 
T20290        ELSE                                                      
A01422            MOVE WS-HOLD-BILL-HIST-XFER TO AT-BILL-HIST-XFER-IND  
C34128            MOVE WS-HOLD-CODE-PERM-BILL TO AT-CODE-PERM-BILL      
              END-IF                                                    
                                                                        
T20490        IF WS-MST-SUB-ACCT-IND = 'S'                              
T19935           IF WS-REVERT-SUB = 'Y'                                 
T19935               MOVE 'S'                  TO AT-CREDIT-GROUP       
T20690               MOVE 'Y'                  TO AT-AR-XFER-IND        
                                                  AT-BILL-HIST-XFER-IND 
T19935           ELSE                                                   
                     MOVE 'N'                  TO AT-CREDIT-GROUP       
                     MOVE SPACES               TO WS-MST-SUB-ACCT-IND   
                                                  AT-AR-XFER-IND        
                                                  AT-BILL-HIST-XFER-IND 
T20490               MOVE  ZEROES              TO WS-ACCT-XFER-TO       
T20690           END-IF                                                 
                 PERFORM 8312-UPDATE-XFER-IND  THRU 8312-EXIT           
              ELSE                                                      
                 MOVE WS-AT-CREDIT-GROUP       TO AT-CREDIT-GROUP       
              END-IF                                                    
                                                                        
              PERFORM 8310-UPDATE-CSS-ACCOUNT  THRU 8310-EXIT           
              PERFORM 7220-GET-NEW-ACCT-CODES  THRU 7220-EXIT           
                                                                        
              MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT 
                                                                        
T8003         IF WS-CODE-BUDGET NOT = 'A'                               
P00453        AND WS-CODE-PRE-PAY-PLAN NOT = 'A'                        
T8003            MOVE CMN-ACCOUNT-NO-NEW       TO AT-ACCOUNT-NO         
T8003            MOVE WS-A                     TO WS-CODE-UTL           
T8003            MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT 
T8003            PERFORM 8420-UPDATE-CODES-DATA-PRES THRU 8420-EXIT     
T8003         END-IF                                                    
                                                                        
              IF CMN-ORDER-REASON = WS-FORCED AND                       
T24815           WS-PREV-STAT-REASON NOT = 'C'                          
                    MOVE CMN-ACCOUNT-NO       TO AT-ACCOUNT-NO          
                    PERFORM 8430-UPDATE-AT-STATUS-REASON THRU 8430-EXIT 
                    MOVE CMN-ACCOUNT-NO-NEW   TO AT-ACCOUNT-NO          
              END-IF                                                    
                                                                        
T21448        IF AT-MST-SUB-ACCT-IND = 'S'                              
T21448            PERFORM 8425-UPDATE-HIST-XFER THRU 8425-EXIT          
T21448        END-IF                                                    
           END-IF.                                                      
                                                                        
           IF ORDER-TYPE-1 = WS-VALID-SET-ORDER OR                      
              ORDER-TYPE-2 = WS-VALID-CC-ORDER  OR                      
              ORDER-TYPE-2 = WS-VALID-ON-ORDER                          
                                                                        
               MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT
               MOVE ZERO                        TO WS-NULL-INDICATOR    
                                                                        
C35362         MOVE CMN-ACCOUNT-NO-NEW TO WS-ACCOUNT-NO-NEW             
               PERFORM 7400-SELECT-CUST-DATE    THRU 7400-EXIT          
                                                                        
               IF WS-NULL-INDICATOR = -1                                
                  MOVE WS-HOLD-COMPLETED-DATE   TO CU-SERVICE-EST-DATE  
                  PERFORM 8300-UPDATE-CSS-CUSTOMER THRU 8300-EXIT       
               END-IF                                                   
                                                                        
              IF ORDER-TYPE-1 = WS-VALID-SET-ORDER                      
                 MOVE ZERO                     TO WS-NULL-INDICATOR     
                                                                        
                 PERFORM 7370-SELECT-CUST-PREM-HIST THRU 7370-EXIT      
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
T17419              MOVE WS-HOLD-COMPLETED-DATE TO                      
T17419                   CH-DATE-UTIL-SVC-STRT                          
                    MOVE LOW-VALUES            TO CH-DATE-UTIL-SVC-END  
                    MOVE -1                    TO WS-NULL-VALUE         
                    PERFORM 8331-INSERT-CUST-PREM-HIST THRU 8331-EXIT   
T18326              PERFORM 5475-REVISE-DATES          THRU 5475-EXIT   
                 END-IF                                                 
                                                                        
                 MOVE WS-A                        TO AT-CODE-ACCT-STAT  
                 MOVE CMN-ACCOUNT-NO              TO AT-ACCOUNT-NO      
T21448           IF AT-MST-SUB-ACCT-IND = 'S'                           
T21448               MOVE 'Y' TO AT-BILL-HIST-XFER-IND                  
T21448           END-IF                                                 
                 PERFORM 8310-UPDATE-CSS-ACCOUNT  THRU 8310-EXIT        
                                                                        
T8003            IF WS-CODE-BUDGET NOT = 'A' AND WS-CODE-UTL NOT = 'A'  
P00453           AND WS-CODE-PRE-PAY-PLAN NOT = 'A'                     
T8003               MOVE WS-A                  TO WS-CODE-UTL           
T8003               MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT 
T8003               PERFORM 8420-UPDATE-CODES-DATA-PRES THRU 8420-EXIT  
T8003            END-IF                                                 
                                                                        
                 IF PREV-CODE-ACCT-STAT = 'P'                           
                    PERFORM 8315-UPDATE-CUST-PLAN       THRU 8315-EXIT  
                 END-IF                                                 
                                                                        
              ELSE IF ORDER-TYPE-2 = WS-VALID-CC-ORDER                  
                 MOVE CMN-ACCOUNT-NO               TO CH-ACCOUNT-NO     
                 MOVE ZERO                         TO WS-NULL-INDICATOR 
                 PERFORM 7370-SELECT-CUST-PREM-HIST THRU 7370-EXIT      
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND         
                    WS-NULL-INDICATOR     = -1                          
                    MOVE WS-HOLD-COMPLETED-DATE  TO CH-DATE-UTIL-SVC-END
                    PERFORM 8330-UPDATE-CUST-PREM-HIST THRU 8330-EXIT   
                 END-IF                                                 
                                                                        
                 IF WS-AT-CODE-ACCT-STAT NOT = 'A'                      
T17419              MOVE WS-HOLD-COMPLETED-DATE TO                      
T17419                   CH-DATE-UTIL-SVC-STRT                          
                    MOVE -1                   TO WS-NULL-VALUE          
                    MOVE LOW-VALUES           TO CH-DATE-UTIL-SVC-END   
                    MOVE CMN-ACCOUNT-NO-NEW   TO CH-ACCOUNT-NO          
T17758              PERFORM 7500-SELECT-NEW-CUST       THRU 7500-EXIT   
                    PERFORM 8331-INSERT-CUST-PREM-HIST THRU 8331-EXIT   
T18326              PERFORM 5475-REVISE-DATES          THRU 5475-EXIT   
                 END-IF                                                 
              END-IF                                                    
           END-IF
           END-IF.                                                      
                                                                        
           IF ORDER-TYPE-2 = WS-VALID-OC-ORDER                          
              MOVE ZERO                      TO WS-NULL-INDICATOR       
              MOVE CMN-ACCOUNT-NO            TO CH-ACCOUNT-NO           
                                                                        
              PERFORM 7370-SELECT-CUST-PREM-HIST THRU 7370-EXIT         
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
                 WS-NULL-INDICATOR     = -1                             
                 MOVE WS-HOLD-COMPLETED-DATE TO CH-DATE-UTIL-SVC-END    
                                                                        
                 PERFORM 8330-UPDATE-CUST-PREM-HIST THRU 8330-EXIT      
              END-IF                                                    
                                                                        
T17419        MOVE WS-HOLD-COMPLETED-DATE TO                            
T17419             CH-DATE-UTIL-SVC-STRT                                
              MOVE -1                        TO WS-NULL-VALUE           
              MOVE LOW-VALUES                TO CH-DATE-UTIL-SVC-END    
              MOVE CMN-ACCOUNT-NO-NEW        TO CH-ACCOUNT-NO           
                                                                        
T8070         PERFORM 7500-SELECT-NEW-CUST       THRU 7500-EXIT         
              PERFORM 8331-INSERT-CUST-PREM-HIST THRU 8331-EXIT         
T18326        PERFORM 5475-REVISE-DATES          THRU 5475-EXIT         
           END-IF.                                                      
                                                                        
           IF ORDER-TYPE-2 = WS-VALID-OFF-ORDER                         
              MOVE ZERO                           TO WS-NULL-INDICATOR  
              PERFORM 7370-SELECT-CUST-PREM-HIST  THRU 7370-EXIT        
                                                                        
              IF WS-NULL-INDICATOR = -1                                 
                 MOVE WS-HOLD-COMPLETED-DATE    TO CH-DATE-UTIL-SVC-END 
                 PERFORM 8330-UPDATE-CUST-PREM-HIST   THRU 8330-EXIT    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF ORDER-TYPE-1 = WS-VALID-DNP-ORDER                         
               MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT  
               MOVE 'A'                       TO WS-CODE-PENDING-DNP    
               MOVE WS-CODES-DATA-PRESENT     TO AT-CODES-DATA-PRESENT  
                                                                        
               PERFORM 8420-UPDATE-CODES-DATA-PRES THRU 8420-EXIT       
                                                                        
PCR360         IF CMN-ORDER-REASON = 'A' OR CMN-ORDER-REASON = 'B' OR   
PCR360            CMN-ORDER-REASON = 'D' OR CMN-ORDER-REASON = 'H' OR   
PCR360            CMN-ORDER-REASON = 'I' OR CMN-ORDER-REASON = 'M' OR   
PCR360            CMN-ORDER-REASON = 'N' OR CMN-ORDER-REASON = 'O' OR   
C23237            CMN-ORDER-REASON = 'Q' OR                             
P00471            CMN-ORDER-REASON = 'T' OR CMN-ORDER-REASON = 'W' OR   
P00471            CMN-ORDER-REASON = 'J' OR CMN-ORDER-REASON = 'K' OR   
P00471            CMN-ORDER-REASON = 'U' OR CMN-ORDER-REASON = 'V' OR   
TP8840            CMN-ORDER-REASON = 'S' OR CMN-ORDER-REASON = 'X' OR   
TP8840            CMN-SERV-ORDER-TYPE     = WS-VALID-DNP-ORDER          
                                                                        
                  PERFORM 8450-GET-CREDIT-PROFILE  THRU 8450-EXIT       
                                                                        
                  IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
PCR360               IF CMN-ORDER-REASON = 'N' OR CMN-ORDER-REASON = 'O'
P00471               OR CMN-ORDER-REASON = 'J' OR CMN-ORDER-REASON = 'K'
P00471               OR CMN-ORDER-REASON = 'U' OR CMN-ORDER-REASON = 'V'
                       MOVE CZ-DISCONNECT-HIST TO WS-DISCONNECT-HIST    
                       MOVE '4'                TO WS-DISCONNECT-HIST-1  
                       MOVE WS-DISCONNECT-HIST TO CZ-DISCONNECT-HIST    
                     ELSE                                               
                       MOVE CZ-DISC-EXCEPTN-HIST TO WS-DISC-EXCEPTN-HIST
                       MOVE '4'                TO WS-DISC-EXCEPTN-HIST-1
                       MOVE WS-DISC-EXCEPTN-HIST TO CZ-DISC-EXCEPTN-HIST
                     END-IF                                             
                                                                        
                                                                        
                     PERFORM 8460-UPDATE-CREDIT-PROFILE THRU 8460-EXIT  
                  END-IF                                                
               END-IF                                                   
                                                                        
               MOVE CMN-ACCOUNT-NO             TO AT-ACCOUNT-NO         
               PERFORM 8310-UPDATE-CSS-ACCOUNT THRU 8310-EXIT           
T17380         PERFORM 5425-PROCESS-RECONNECT  THRU 5425-EXIT           
P00471         IF WS-CODE-DPP-ACCT = 'A'                                
P00471            MOVE SPACES                  TO WS-ATTRIBUTE-VALUE-CD 
P00471            MOVE CMN-ACCOUNT-NO          TO YP-ACCOUNT-NO         
P00471            PERFORM 7850-CHECK-DPP-DROP-EXEMPT   THRU 7850-EXIT   
P00471            IF WS-ATTRIBUTE-VALUE-CD > SPACE                      
P00471               CONTINUE                                           
P00471            ELSE                                                  
P00471               MOVE 'D'                  TO WS-DPP-DROP-CALL-TYPE 
P00471               MOVE WS-CURRENT-DATE-061     TO WS-COMMON-DATE     
P00471               PERFORM 8945-GET-DPP-ITEM-ID THRU 8945-EXIT        
P00471               MOVE    WS-AC-ITEM-ID        TO WS-DFA-ITEM-ID     
P00471               PERFORM 5260-REMOVE-FROM-DPP THRU 5260-CPD109-EXIT 
P00471            END-IF                                                
P00471         END-IF                                                   
      *                                                                         
           END-IF.                                                      
                                                                        
           IF ORDER-TYPE-1 = WS-VALID-DNPFB-ORDER                       
               MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT 
               MOVE ' '                        TO WS-CODE-PENDING-DNP   
TP9033         MOVE 'C'                        TO AT-CODE-STATUS-REASON 
               PERFORM 8310-UPDATE-CSS-ACCOUNT     THRU 8310-EXIT       
                                                                        
               PERFORM 8400-SEARCH-FOR-RCC         THRU 8400-EXIT       
               IF WS-RCC-FOUND = 'Y'                                    
                  PERFORM 8410-DELETE-RCC          THRU 8410-EXIT       
               END-IF                                                   
                                                                        
               MOVE WS-CODES-DATA-PRESENT      TO AT-CODES-DATA-PRESENT 
               PERFORM 8420-UPDATE-CODES-DATA-PRES THRU 8420-EXIT       
                                                                        
               MOVE ZERO                           TO WS-NULL-INDICATOR 
               PERFORM 7370-SELECT-CUST-PREM-HIST  THRU 7370-EXIT       
               IF WS-NULL-INDICATOR = -1                                
                  MOVE WS-HOLD-COMPLETED-DATE  TO CH-DATE-UTIL-SVC-END  
                  PERFORM 8330-UPDATE-CUST-PREM-HIST  THRU 8330-EXIT    
               END-IF                                                   
           END-IF.                                                      
                                                                        
T23235     IF ORDER-TYPE-1 = WS-VALID-NOT-ORDER                         
T23235                                                                  
T23235         PERFORM 8450-GET-CREDIT-PROFILE  THRU 8450-EXIT          
T23235                                                                  
T23235         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
T23235            IF CMN-ORDER-REASON = 'N' OR CMN-ORDER-REASON = 'O'   
T23235              MOVE CZ-DISCONNECT-HIST TO WS-DISCONNECT-HIST       
T23235              MOVE 'F'                TO WS-DISCONNECT-HIST-1     
T23235              MOVE WS-DISCONNECT-HIST TO CZ-DISCONNECT-HIST       
T23235            ELSE                                                  
T23235              MOVE CZ-DISC-EXCEPTN-HIST TO WS-DISC-EXCEPTN-HIST   
T23235              MOVE 'F'                TO WS-DISC-EXCEPTN-HIST-1   
T23235              MOVE WS-DISC-EXCEPTN-HIST TO CZ-DISC-EXCEPTN-HIST   
T23235            END-IF                                                
T23235                                                                  
T23235            PERFORM 8460-UPDATE-CREDIT-PROFILE THRU 8460-EXIT     
T23235         END-IF                                                   
T25243         PERFORM 7410-SELECT-CRED-COLL THRU 7410-EXIT             
T25243         IF WS-NON-UTIL-FOUND = 'Y'                               
T25243             IF CMN-ORDER-REASON = 'N' OR 'O'                     
T25243                 MOVE 'F'       TO CZ-NON-UTL-CR-HST(1:1)         
T25243                 PERFORM 8710-UPD-NONUTL-NORMAL-CREDIT THRU       
T25243                         8710-EXIT                                
T25243             ELSE                                                 
T25243                 MOVE 'F'       TO CZ-NON-UTL-CR-HST-EX(1:1)      
T25243                 PERFORM 8700-UPD-NONUTL-EXCEPT-CREDIT THRU       
T25243                         8700-EXIT                                
T25243             END-IF                                               
T25243         END-IF                                                   
T23235                                                                  
T23235         MOVE CMN-ACCOUNT-NO             TO AT-ACCOUNT-NO         
T23235         PERFORM 8310-UPDATE-CSS-ACCOUNT THRU 8310-EXIT           
T23235     END-IF.                                                      
                                                                        
           IF ORDER-TYPE-2 = WS-VALID-OC-ORDER OR WS-VALID-CC-ORDER     
T22251        MOVE CMN-ACCOUNT-NO              TO AT-ACCOUNT-NO         
           END-IF                                                       
                                                                        
           PERFORM 5450-PROCESS-FLAGS              THRU 5450-EXIT.      
                                                                        
T22251     IF ORDER-TYPE-2 = WS-VALID-OC-ORDER OR WS-VALID-CC-ORDER     
              MOVE CMN-ACCOUNT-NO-NEW          TO AT-ACCOUNT-NO         
           ELSE                                                         
              MOVE CMN-ACCOUNT-NO              TO AT-ACCOUNT-NO         
           END-IF                                                       
                                                                        
           PERFORM 8500-SET-ACCT-TYPE-CODE         THRU 8500-EXIT.      
                                                                        
T28065     IF ORDER-TYPE-1 = WS-VALID-SET-ORDER AND                     
T28065        (AT-ACCOUNT-TYPE-CODE = 'C' OR                            
T28065         AT-ACCOUNT-TYPE-CODE = 'I')                              
T28065            PERFORM 8510-DELETE-SUB-LIGHTING THRU 8510-EXIT       
T28491     END-IF.                                                      
                                                                        
A01232     IF (ORDER-TYPE-2 = WS-VALID-OC-ORDER OR WS-VALID-CC-ORDER)   
A01232       OR ORDER-TYPE-1 = WS-VALID-SET-ORDER                       
T23513         IF SEB-DATABASE                                          
A01232          IF ORDER-TYPE-2 = WS-VALID-OC-ORDER OR WS-VALID-CC-ORDER
T22829            PERFORM 5600-SEB-OC       THRU 5600-EXIT              
C26959          END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
T17380* 5425-PROCESS-RECONNECT.                                        *        
      *                                                                *        
      *     GETS INFO FOR INSERTING RECONNECT AND TRANS HIST           *        
      *                                                                *        
      ******************************************************************        
       5425-PROCESS-RECONNECT.                                          
                                                                        
T20005     PERFORM 8920-SEARCH-FOR-RECONNECT        THRU 8920-EXIT.     
T18688     MOVE 'Y'                        TO CALC-DNP-BAL-NO-LIMIT-SW  
                                              CALC-ARREARS-SW           
                                              CALC-BALANCE-SW.          
           MOVE WS-CURRENT-DATE-061        TO WS-HOLD-DATE.             
T18382     PERFORM 7510-GET-LO-CO-CPD00068  THRU 7510-EXIT.             
T19557     MOVE SPACES                     TO ABEND-FUNCTION .          
T19557     PERFORM 9500-CALL-CPD00068      THRU 9500-EXIT.              
T19557     MOVE RS-RETURN-CODE             TO  WS-ACTIVE-RETURN-CODE,   
T19557                                        SQLCODE.                  
T19557     IF ABEND-FUNCTION  > SPACES                                  
T19557        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
T19557     END-IF.                                                      
                                                                        
           PERFORM 7930-SET-ELEC-FLAG      THRU 7930-EXIT.              
           PERFORM 7935-SET-GAS-FLAG       THRU 7935-EXIT.              
T18382     IF WS-ELEC-FOUND = 'Y' AND WS-GAS-FOUND = 'Y'                
T18382        MOVE 'N' TO WS-GAS-FOUND                                  
T18382     END-IF.                                                      
           MOVE 'Y'                        TO WS-NRML-HRS-FLAG.         
T23235     MOVE CMN-ACCOUNT-NO             TO UT-ACCOUNT-NO.            
T23235     PERFORM 5800-GET-ACCT-TYPE-CODE   THRU 5800-EXIT.            
           PERFORM 7940-GET-RECONNECT-CHARGE THRU 7940-EXIT.            
                                                                        
C36210     IF SEB-DATABASE                                              
C36210         MOVE CMN-ACCOUNT-NO TO LR-ACCOUNT-NO                     
C36210         PERFORM 5890-CHECK-REG-PROF   THRU 5890-EXIT             
C36210         IF WS-REGULATED-FL = 'N'                                 
P00581             MOVE CMN-ACCOUNT-NO TO UT-ACCOUNT-NO                 
P00581             PERFORM 7955-GET-REV-MTH THRU 7955-EXIT              
P00581             IF WS-SEB-RATE-TYPE = 'VP'                           
P00581                 MOVE 'DEREG-RCC' TO C8-DELINQ-CD                 
P00581                 PERFORM 7950-GET-DELINQ-VALUE THRU 7950-EXIT     
P00581             ELSE                                                 
P00581                 MOVE 'DEREG-RCC' TO G6-PROGRAM-NAME              
P00581                 PERFORM 7945-GET-JOB-PARM THRU 7945-EXIT         
P00581                 MOVE G6-PARM-DATA TO WS-PARM-DATA                
P00581                 MOVE WS-PARM-DATA(1:10) TO WS-PARM-OPT-EFF-DT    
P00581                 IF WS-OPT-EFF-DT >= WS-PARM-OPT-EFF-DT           
P00581                    MOVE 'DEREG-RCC' TO C8-DELINQ-CD              
P00581                 ELSE                                             
P00581                    MOVE 'DEREG-RCC-OLD' TO C8-DELINQ-CD          
P00581                 END-IF                                           
P00581                 PERFORM 7950-GET-DELINQ-VALUE THRU 7950-EXIT     
P00581             END-IF                                               
P00581             MOVE C8-DELINQ-VALUE TO                              
P00581                  WS-SEB-DEREG-RCC                                
P00581             MOVE WS-SEB-DEREG-RCC TO                             
P00581                  U7-RCNCT-CHRG-AM
               END-IF
           END-IF.                               
      *                                                                         
C26296     PERFORM 7420-SELECT-CRED-PROF-AMT        THRU 7420-EXIT.     
C26296     MOVE 0 TO DL-AUTO-DEP-CERT-NO.                               
      *                                                                         
C26296     IF DL-AUTO-DEP-AM > 0                                        
C26296        MOVE CMN-USER-ID                    TO WS-USER-ID         
C26296        MOVE CMN-ACCOUNT-NO          TO WS-ACCOUNT-NO-NUM         
C26296        PERFORM 2250-CALL-CSR03515         THRU 2250-EXIT         
                                                                        
C26296        IF WS-3515-AUTO-DEP-AMT < DL-AUTO-DEP-AM                  
C26296           MOVE DL-AUTO-DEP-AM       TO WS-DL-AUTO-DEP-AM         
C26296           MOVE WS-3515-AUTO-DEP-AMT TO DL-AUTO-DEP-AM            
C26296        END-IF                                                    
                                                                        
C26296        IF WS-3515-AUTO-DEP-AMT = 0                               
C26296           PERFORM 5505-INS-AUTO-DEP-TRANS-HIST                   
C26296                                           THRU 5505-EXIT         
C26296        END-IF                                                    
C26296     END-IF.                                                      
                                                                        
C26296     IF WS-COMPANY-NO = '26' AND DL-AUTO-DEP-AM > 0               
C26296        COMPUTE WS-AMT-TOT-RECONNECT =                            
C26296          DL-AUTO-DEP-AM + U7-RCNCT-CHRG-AM + WS-AMT-DNP-BAL      
C26296        MOVE WS-AMT-TOT-RECONNECT TO DL-AMT-TOT-RECONNECT         
C26296     ELSE                                                         
              COMPUTE WS-AMT-TOT-RECONNECT =                            
                              U7-RCNCT-CHRG-AM + WS-AMT-DNP-BAL         
              MOVE WS-AMT-TOT-RECONNECT TO DL-AMT-TOT-RECONNECT         
C26296     END-IF.                                                      
                                                                        
T20005* MOVED DELETION OF OLD RECONNECT BEFORE LOADING NEW VALUES               
T18529*    PERFORM 8920-SEARCH-FOR-RECONNECT        THRU 8920-EXIT.             
      *                                                                         
A05317     IF SEB-DATABASE                                              
A05317         MOVE 'N' TO DL-RCC-BILL-OPTION-CD                        
A05317     ELSE                                                         
A05317         MOVE 'I' TO DL-RCC-BILL-OPTION-CD
           END-IF.                       
                                                                        
           PERFORM 8930-INSERT-RECONNECT            THRU 8930-EXIT.     
           PERFORM 8935-INSERT-RCNCT-TRANS-HIST     THRU 8935-EXIT.     
                                                                        
       5425-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 5450-PROCESS-FLAGS.                                           *         
      *                                                               *         
      *     THIS PROCEDURE PROCESSES THE PENDING DNP FLAG AND SETS    *         
      *     THE BANKRUPTCY INDICATOR IF NECESSARY.                    *         
      *                                                               *         
      *****************************************************************         
       5450-PROCESS-FLAGS.                                              
                                                                        
           IF CMN-ORDER-REASON = 'B' AND                                
              (ORDER-TYPE-2 = WS-VALID-CC-ORDER OR WS-VALID-OFF-ORDER)  
              MOVE 'B' TO AT-BANKRUPTCY-IND                             
              PERFORM 8320-UPDATE-BANKRUPTCY-IND  THRU 8320-EXIT        
           END-IF.                                                      
                                                                        
           IF CMN-PENDING-DNP-FLAG = 'N'                                
              PERFORM 8325-UPDATE-PREM-DNP-FLAG   THRU 8325-EXIT        
           END-IF.                                                      
                                                                        
           PERFORM 8326-UPDATE-PREM-OFF-DATE      THRU 8326-EXIT.       
                                                                        
       5450-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
T18326*   5475-REVISE-DATES.                                           *        
T18326*                                                                *        
T18326*   UPDATE ACCT_CREATE_DT WITH THE ORDER COMPLETION DATE.        *        
T18326*   UPDATE ANY DATE_UTIL_SVC_END DATES ON CSS_CUST_PREM_HIST     *        
T18326*   (FOR THIS PREMISE) THAT ARE GREATER THAN THE ORDER           *        
T18326*   COMPLETION DATE WITH THE ORDER COMPLETION DATE.              *        
T18326*                                                                *        
T18326******************************************************************        
T18326 5475-REVISE-DATES.                                               
T18326                                                                  
T18326     MOVE CMN-ACCOUNT-NO-NEW TO WS-AT-ACCOUNT-NO.                 
T18326     PERFORM 7910-MOVE-DATE THRU 7910-EXIT.                       
T18326     MOVE AT-ACCT-CREATE-DT TO WS-REVISED-END-DATE.               
T18326     PERFORM 7915-UPDATE-PREMHIST THRU 7915-EXIT.                 
T18326                                                                  
T18326 5475-EXIT.                                                       
T18326     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *   5500-JRNL-TRAN-PROCESS.                                      *        
      *                                                                *        
      *   1.   MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *        
      *        THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,  *        
      *        THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).           *        
      *                                                                *        
      ******************************************************************        
       5500-JRNL-TRAN-PROCESS.                                          
                                                                        
           IF PREV-CODE-ACCT-STAT = AT-CODE-ACCT-STAT AND               
              PREV-BANKRUPTCY-IND = AT-BANKRUPTCY-IND                   
              GO TO 5500-EXIT                                           
           END-IF.                                                      
                                                                        
T17380* NEED TO CALL THIS EARLIER FOR DATE FOR INSERT                           
T17380*    PERFORM 5510-GET-TIMESTAMP     THRU 5510-EXIT.                       
           PERFORM 5520-GET-RESP-AREA     THRU 5520-EXIT.               
                                                                        
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
           MOVE SPACES                    TO MH-RESP-AREA-ID.           
T18605     IF ORDER-TYPE-2 = 'CC' OR 'NC'                               
T18605         MOVE CMN-ACCOUNT-NO-NEW    TO MH-ACCOUNT-NO              
T18605     ELSE                                                         
               MOVE CMN-ACCOUNT-NO        TO MH-ACCOUNT-NO
           END-IF.             
A37666     MOVE ZEROES                    TO MH-CUSTOMER-NO.            
A37666     MOVE ZEROES                    TO MH-PREMISE-NO.             
           MOVE CMN-USER-ID               TO MH-USER-ID.                
           MOVE PF-RESP-AREA-ID           TO MH-RESP-AREA-ID.           
           MOVE PROGRAM-NAME              TO MH-APPL-PROGRAM-ID.        
           MOVE SPACES                    TO MH-TRAN-COMMENT-TEXT       
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO       
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE 0                         TO MH-TRAN-COMMENT-LEN.       
           MOVE 0                         TO MI-TRAN-APPL-NO.           
                                                                        
           IF PREV-CODE-ACCT-STAT NOT = AT-CODE-ACCT-STAT               
              ADD +1                      TO MI-TRAN-APPL-NO            
              MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN    
                                             MI-PRV-COLUMN-VALUE-LEN    
              MOVE AT-CODE-ACCT-STAT      TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE PREV-CODE-ACCT-STAT    TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'CODE ACCT STAT'       TO MI-COLUMN-DESC             
              MOVE '67'                   TO MI-TABLE-ID                
                                                                        
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
           END-IF.                                                      
                                                                        
           IF PREV-BANKRUPTCY-IND NOT = AT-BANKRUPTCY-IND               
              ADD +1                      TO MI-TRAN-APPL-NO            
              MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
T22519        MOVE PREV-BANKRUPTCY-IND    TO MI-PRV-COLUMN-VALUE-TEXT   
T22519        MOVE AT-BANKRUPTCY-IND      TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE 'BANKRUPTCY IND'       TO MI-COLUMN-DESC             
              MOVE '68'                   TO MI-TABLE-ID                
                                                                        
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
            END-IF.                                                     
                                                                        
T26266     IF WS-WAIVER-ADDED = 'Y'                                     
T26266        ADD +1                        TO MI-TRAN-APPL-NO          
T26266        MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
T26266        MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
T26266        MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
T26266        MOVE WS-SB-WAIVER-TYPE-CD     TO MI-CHG-COLUMN-VALUE-TEXT 
T26266        MOVE 'WAIVER TYPE CD'         TO MI-COLUMN-DESC           
T36164        MOVE 'A6'                     TO MI-TABLE-ID              
              MOVE 'SERVICE ORDER POSTED AND WAIVER ADDED BY SYSTEM'    
                                            TO MH-TRAN-COMMENT-TEXT     
              MOVE +47                      TO MH-TRAN-COMMENT-LEN      
              PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT         
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
C26296*****************************************************************         
C26296* 5505-INS-AUTO-DEP-TRANS-HIST                                  *         
C26296*                                                               *         
C26296*     LOAD VARIABLES FOR INS INTO TRANS HIST FOR AUTO DEP       *         
C26296*                                                               *         
C26296*****************************************************************         
C26296 5505-INS-AUTO-DEP-TRANS-HIST.                                    
C26296                                                                  
C26296     MOVE CMN-ACCOUNT-NO          TO MH-ACCOUNT-NO.               
C26296     MOVE 'PANEL090C'             TO MH-APPL-PROGRAM-ID.          
C26296     MOVE 'F'                     TO MH-CODE-TRAN-TYPE.           
A37666     MOVE ZEROES                  TO MH-CUSTOMER-NO.              
A37666     MOVE ZEROES                  TO MH-PREMISE-NO.               
C26296     MOVE SPACES                  TO MH-RESP-AREA-ID.             
C26296     MOVE 'SYSTEM'                TO MH-USER-ID.                  
C26296     MOVE 0                       TO MH-TRAN-COMMENT-LEN.         
C26296     MOVE SPACE                   TO MH-TRAN-COMMENT-TEXT.        
                                                                        
C26296     MOVE +1                      TO MI-TRAN-APPL-NO.             
C26296     MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
C26296     MOVE 'AUTO DEP AMT'          TO MI-COLUMN-DESC.              
C26296     MOVE WS-DL-AUTO-DEP-AM       TO WS-AUTO-DEP-AM-EDT.          
C26296     MOVE +15                     TO MI-PRV-COLUMN-VALUE-LEN.     
C26296     MOVE WS-AUTO-DEP-AM-EDT      TO MI-PRV-COLUMN-VALUE-TEXT.    
C26296     MOVE WS-3515-AUTO-DEP-AMT    TO WS-AUTO-DEP-AM-EDT.          
C26296     MOVE +15                     TO MI-CHG-COLUMN-VALUE-LEN.     
C26296     MOVE WS-AUTO-DEP-AM-EDT      TO MI-CHG-COLUMN-VALUE-TEXT.    
C26296     MOVE SPACES                  TO MI-TABLE-ID.                 
C26296     PERFORM 6530-LOAD-MNT-TRANS-HIST.                            
C26296                                                                  
C26296 5505-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 5510-GET-TIMESTAMP.                                           *         
      *                                                               *         
      *****************************************************************         
       5510-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :MH-TRANS-HIST-SEQ-NO,                             
                     :MH-DATE-TRANS                                     
                FROM CSS_MODEL_SQL                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP,                                         
MFA-TR*              CURRENT DATE                                               
MFA-TR*         INTO :MH-TRANS-HIST-SEQ-NO,                                     
MFA-TR*              :MH-DATE-TRANS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*       QUERYNO 5510                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5510'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CSS_MODEL_SQL'           TO CMN-TABLE-1             
CBSI          MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE CMN-ACCOUNT-NO            TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       5510-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 5520-GET-RESP-AREA.                                           *         
      *                                                               *         
      *****************************************************************         
       5520-GET-RESP-AREA.                                              
                                                                        
           MOVE CMN-USER-ID                  TO PF-USER-ID              
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE                                   
               WHERE USER_ID = :PF-USER-ID                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :PF-USER-ID                                      
MFA-TR*       QUERYNO 5520                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5520'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CSS_USER_PROFILE'        TO CMN-TABLE-1             
              MOVE 'USER_ID'                 TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-2     
              MOVE PF-USER-ID                TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE CMN-ACCOUNT-NO            TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       5520-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 5550-REVERT-TO-LL.                                            *         
      *                                                               *         
      *****************************************************************         
       5550-REVERT-TO-LL.                                               
                                                                        
           PERFORM 7800-GET-LANDLORD-INFO      THRU 7800-EXIT.          
A35665     IF SI-ADDRESS-FORMAT = 'B'                                   
A35665        PERFORM 7805-GET-COUNTRY THRU 7805-EXIT
           END-IF.                  
           PERFORM 7810-UPDATE-LL-ACCT         THRU 7810-EXIT.          
           PERFORM 7820-GET-NAME-ID            THRU 7820-EXIT.          
           PERFORM 7825-GET-NAME-INFO          THRU 7825-EXIT.          
           PERFORM 5050-GET-NEW-NAME-ID        THRU 5050-EXIT.          
           PERFORM 7827-INSERT-NAME            THRU 7827-EXIT.          
C29307     MOVE AT-ACCOUNT-NO                  TO HT-ACCOUNT-NO.        
C29307     PERFORM 7828-SELECT-NAME-ACCT-XREF  THRU 7828-EXIT.          
C29307     MOVE WS-NEW-NAME-ID                 TO HT-NAME-ID.           
C29307     PERFORM 7829-INSERT-NAME-ACCT-XREF  THRU 7829-EXIT.          
T22870     PERFORM 7831-DELETE-BILL-ADDR       THRU 7831-EXIT.          
           PERFORM 7830-INSERT-BILL-ADDR       THRU 7830-EXIT.          
           PERFORM 7835-INSERT-BILL-NAME       THRU 7835-EXIT.          
                                                                        
       5550-EXIT.                                                       
           EXIT.                                                        
                                                                        
T22829*****************************************************************         
T22829* 5600-SEB-OC.                                                  *         
T22829*                                                               *         
T22829*****************************************************************         
T22829 5600-SEB-OC.                                                     
T22829                                                                  
T22829     MOVE CMN-ACCOUNT-NO TO XM-ACCOUNT-NO.                        
T22829     PERFORM 7960-SELECT-MARKET-XREF THRU 7960-EXIT.              
T22829     MOVE XM-DIST-ACCT-NO TO WS-HOLD-DIST-ACCT.                   
T22829     MOVE XM-DIST-ACCT-NO(11:10) TO WS-DIST-ACCT.                 
T22829     PERFORM 7970-COUNT-MARKET-XREF  THRU 7970-EXIT.              
T22829     COMPUTE WS-COUNT-XREF = WS-COUNT-XREF + 1.                   
T22829     IF WS-COUNT-XREF > 9                                         
T22829         MOVE +5600                      TO WS-ACTIVE-RETURN-CODE 
T22829         MOVE '5600'                     TO ACTIVE-PARAGRAPH      
T22829         MOVE '>9 DIST ACCOUNTS'         TO CMN-TABLE-1           
T22829         PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT
           END-IF.          
T22829                                                                  
T22829     MOVE WS-COUNT-XREF TO WS-NUM-COUNT.                          
T22829     MOVE 'C' TO XM-DIST-ACCT-NO(1:1).                            
T22829     MOVE WS-CHAR-COUNT TO XM-DIST-ACCT-NO(2:1).                  
T22829     PERFORM 7980-UPDATE-MARKET-XREF THRU 7980-EXIT.              
T22829     MOVE CMN-ACCOUNT-NO-NEW TO XM-ACCOUNT-NO.                    
T22829     MOVE WS-HOLD-DIST-ACCT TO XM-DIST-ACCT-NO.                   
T22829     PERFORM 7990-INSERT-MARKET-XREF THRU 7990-EXIT.              
P00677     MOVE 'N' TO WS-REG-EXISTS-OLD-ACCT.                          
P00677     PERFORM 5895-SELECT-REG-PROFILE THRU 5895-EXIT.              
P00677     IF WS-REG-EXISTS-OLD-ACCT = 'Y'                              
P00677       MOVE 'N' TO WS-REG-EXISTS-NEW-ACCT                         
P00677       PERFORM 5896-SELECT-NEW-REG-PROFILE THRU 5896-EXIT         
P00677       IF WS-REG-EXISTS-NEW-ACCT = 'Y'                            
P00677         PERFORM 7996-UPDATE-REG-PROFILE THRU 7996-EXIT           
P00677       ELSE                                                       
P00677         PERFORM 7995-INSERT-REG-PROFILE THRU 7995-EXIT           
P00677       END-IF                                                     
P00677       MOVE 'N' TO WS-AGL-SENIOR-ATTR                             
P00677     END-IF.                                                      
P00677     PERFORM 5897-CHECK-OLD-ACCT-FOR-SNR THRU 5897-EXIT.          
P00677     IF WS-AGL-SENIOR-ATTR = 'Y'                                  
P00677       PERFORM 7998-INSERT-AGL-SENIOR-ATTR THRU 7998-EXIT         
P00677     END-IF.                                                      
T22829                                                                  
T22829 5600-EXIT.                                                       
T22829     EXIT.                                                        
                                                                        
T23235 5800-GET-ACCT-TYPE-CODE.                                         
T23235                                                                  
A37061     PERFORM 7280-SEL-ACCT-TYPE-CODE  THRU 7280-EXIT.             
T23235                                                                  
A37061     MOVE AT-ACCOUNT-TYPE-CODE       TO WS-ACCT-TYPE-VAL.         
A37061     IF WS-ACCT-TYPE-VAL = 'R'                                    
T23235        MOVE 'R' TO WS-ACCT-TYPE-CODE                             
T23235     ELSE                                                         
A37061        IF WS-ACCT-TYPE-VAL = 'C'                                 
T23235          MOVE 'C' TO WS-ACCT-TYPE-CODE                           
T23235        ELSE                                                      
T23235          MOVE 'I' TO WS-ACCT-TYPE-CODE                           
T23235        END-IF                                                    
T23235     END-IF.                                                      
T23235                                                                  
T23235 5800-EXIT.                                                       
T23235     EXIT.                                                        
                                                                        
T26266*****************************************************************         
T26266*                                                               *         
T26266*   5700-SEL-CRED-ACTION-FL                                     *         
T26266*                                                               *         
T26266*****************************************************************         
       5700-SEL-CRED-ACTION-FL.                                         
                                                                        
           MOVE '5700'                       TO ACTIVE-PARAGRAPH.       
                                                                        
      * RETRIEVE FLAGS FROM CREDIT CHECK OF CUSTOMER                            
           EXEC SQL                                                     
               SELECT CR_ACTION_FL,                                     
                      CR_RQST_REASON_CD                                 
                 INTO :WS-CR-ACTION-FL,                                 
                      :WS-RQST-REAS-CD                                  
                 FROM CSS_CREDIT_HIST                                   
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
                  AND CR_HIST_TRAN_TM =                                 
                       (SELECT MAX(CR_HIST_TRAN_TM)                     
                          FROM CSS_CREDIT_HIST                          
                         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO            
C32789                     AND CR_RQST_REASON_CD <> 'B'                 
P00342                     AND CR_BUREAU_CD <> 'P'                      
                           AND CR_HIST_TRAN_DT =                        
                               (SELECT MAX(CR_HIST_TRAN_DT)             
                                  FROM CSS_CREDIT_HIST                  
                                 WHERE CUSTOMER_NO = :AT-CUSTOMER-NO    
C32789                             AND CR_RQST_REASON_CD <> 'B'         
P00342                             AND CR_BUREAU_CD <> 'P'))            
                  AND CR_HIST_TRAN_DT =                                 
                               (SELECT MAX(CR_HIST_TRAN_DT)             
                                  FROM CSS_CREDIT_HIST                  
                                 WHERE CUSTOMER_NO = :AT-CUSTOMER-NO    
C32789                             AND CR_RQST_REASON_CD <> 'B'         
P00342                             AND CR_BUREAU_CD <> 'P')             
C32789            AND CR_RQST_REASON_CD <> 'B'                          
P00342            AND CR_BUREAU_CD <> 'P'                               
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CR_ACTION_FL,                                             
MFA-TR*               CR_RQST_REASON_CD                                         
MFA-TR*          INTO :WS-CR-ACTION-FL,                                         
MFA-TR*               :WS-RQST-REAS-CD                                          
MFA-TR*          FROM CSS_CREDIT_HIST                                           
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*           AND CR_HIST_TRAN_TM =                                         
MFA-TR*                (SELECT MAX(CR_HIST_TRAN_TM)                             
MFA-TR*                   FROM CSS_CREDIT_HIST                                  
MFA-TR*                  WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                    
MFA-TR*                    AND CR_RQST_REASON_CD <> 'B'                         
MFA-TR*                    AND CR_BUREAU_CD <> 'P'                              
MFA-TR*                    AND CR_HIST_TRAN_DT =                                
MFA-TR*                        (SELECT MAX(CR_HIST_TRAN_DT)                     
MFA-TR*                           FROM CSS_CREDIT_HIST                          
MFA-TR*                          WHERE CUSTOMER_NO = :AT-CUSTOMER-NO            
MFA-TR*                            AND CR_RQST_REASON_CD <> 'B'                 
MFA-TR*                            AND CR_BUREAU_CD <> 'P'))                    
MFA-TR*           AND CR_HIST_TRAN_DT =                                         
MFA-TR*                        (SELECT MAX(CR_HIST_TRAN_DT)                     
MFA-TR*                           FROM CSS_CREDIT_HIST                          
MFA-TR*                          WHERE CUSTOMER_NO = :AT-CUSTOMER-NO            
MFA-TR*                            AND CR_RQST_REASON_CD <> 'B'                 
MFA-TR*                            AND CR_BUREAU_CD <> 'P')                     
MFA-TR*           AND CR_RQST_REASON_CD <> 'B'                                  
MFA-TR*           AND CR_BUREAU_CD <> 'P'                                       
MFA-TR*       QUERYNO 57001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_CRED_HIST'           TO CMN-TABLE-1             
              MOVE 'CUSTOMER_NO'             TO CMN-TABLE-ELEMENT-1     
              MOVE AT-CUSTOMER-NO            TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
      * DETERMINE IF A WAIVER ALREADY EXISTS FOR THE ACCOUNT                    
           EXEC SQL                                                     
               SELECT DISTINCT('Y')                                     
                 INTO :WS-WAIVER-EXISTS                                 
                 FROM CSS_SURETY_BOND                                   
                WHERE ACCOUNT_NO = :WS-WAIV-ACCT-NO                     
                  AND CODE_BOND_TYPE = 'C'                              
                  AND CODE_STATUS = 'A'                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTINCT('Y')                                             
MFA-TR*          INTO :WS-WAIVER-EXISTS                                         
MFA-TR*          FROM CSS_SURETY_BOND                                           
MFA-TR*         WHERE ACCOUNT_NO = :WS-WAIV-ACCT-NO                             
MFA-TR*           AND CODE_BOND_TYPE = 'C'                                      
MFA-TR*           AND CODE_STATUS = 'A'                                         
MFA-TR*       QUERYNO 57002                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_SURETY_BOND'         TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
              MOVE WS-WAIV-ACCT-NO           TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
T26266*****************************************************************         
T26266*                                                               *         
T26266*   5705-SEL-MAX-WAIVER                                         *         
T26266**  OBTAIN THE MAX BOND-ITEM-ID IN ORDER TO SET ITEM ID FOR     *         
T26266**  FOR NEW WAIVER                                              *         
T26266*****************************************************************         
       5705-SEL-MAX-WAIVER.                                             
                                                                        
           MOVE '5705'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT MAX(BOND_WAIV_ITEM_ID)                            
                 INTO :WS-SB-BOND-ITEM-ID :WS-NULL-IND                   
                 FROM CSS_SURETY_BOND                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(BOND_WAIV_ITEM_ID)                                    
MFA-TR*          INTO :WS-SB-BOND-ITEM-ID:WS-NULL-IND                           
MFA-TR*          FROM CSS_SURETY_BOND                                           
MFA-TR*       QUERYNO 5705                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_SURETY_BOND'          TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'WAIVER_SOURCE_CD'         TO CMN-TABLE-ELEMENT-2    
              MOVE WS-WAIV-ACCT-NO            TO CMN-HOSTVAR-ELEMENT-1  
              MOVE WS-SB-WAIVER-TYPE-CD       TO CMN-HOSTVAR-ELEMENT-2  
              PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       5705-EXIT.                                                       
           EXIT.                                                        
                                                                        
T26266*****************************************************************         
T26266*                                                               *         
T26266*   5710-ADD-WAIVER                                             *         
T26266*                                                               *         
T26266*****************************************************************         
       5710-ADD-WAIVER.                                                 
                                                                        
           MOVE '5710'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SURETY_BOND                              
                   (ACCOUNT_NO,                                         
                    BOND_WAIV_ITEM_ID,                                  
                    WAIVER_TYPE_CD,                                     
                    CODE_STATUS,                                        
                    COMMENTS,                                           
                    CODE_STATUS_REAS,                                   
                    WAIVER_SOURCE_DESC,                                 
                    TRIGGER_DATE,                                       
                    CODE_BOND_TYPE)                                     
               VALUES                                                   
                   (:WS-WAIV-ACCT-NO,                                   
                    :WS-SB-BOND-ITEM-ID,                                
                    :WS-SB-WAIVER-TYPE-CD,                              
                    :WS-SB-CODE-STATUS,                                 
                    :WS-SB-COMMENTS,                                    
                    :WS-SB-CODE-STATUS-REAS,                            
                    :WS-SB-WAIV-SOURCE-DESC,                            
                    IIF(TRY_CONVERT(DATE, :WS-SB-TRIGGER-DATE 
                                          :WS-TRIGGER-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :WS-SB-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ) <> 0) OR (LEN(:WS-SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:WS-SB-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ), CONVERT(DATE, :WS-SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI
              ) ),             
                    :WS-SB-BOND-TYPE)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SURETY_BOND                                      
MFA-TR*            (ACCOUNT_NO,                                                 
MFA-TR*             BOND_WAIV_ITEM_ID,                                          
MFA-TR*             WAIVER_TYPE_CD,                                             
MFA-TR*             CODE_STATUS,                                                
MFA-TR*             COMMENTS,                                                   
MFA-TR*             CODE_STATUS_REAS,                                           
MFA-TR*             WAIVER_SOURCE_DESC,                                         
MFA-TR*             TRIGGER_DATE,                                               
MFA-TR*             CODE_BOND_TYPE)                                             
MFA-TR*        VALUES                                                           
MFA-TR*            (:WS-WAIV-ACCT-NO,                                           
MFA-TR*             :WS-SB-BOND-ITEM-ID,                                        
MFA-TR*             :WS-SB-WAIVER-TYPE-CD,                                      
MFA-TR*             :WS-SB-CODE-STATUS,                                         
MFA-TR*             :WS-SB-COMMENTS,                                            
MFA-TR*             :WS-SB-CODE-STATUS-REAS,                                    
MFA-TR*             :WS-SB-WAIV-SOURCE-DESC,                                    
MFA-TR*             :WS-SB-TRIGGER-DATE:WS-TRIGGER-DATE-NI,                     
MFA-TR*             :WS-SB-BOND-TYPE)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_SURETY_BOND'          TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE 'WAIVER_SOURCE_CD'         TO CMN-TABLE-ELEMENT-2    
              MOVE WS-WAIV-ACCT-NO            TO CMN-HOSTVAR-ELEMENT-1  
              MOVE WS-SB-WAIVER-TYPE-CD       TO CMN-HOSTVAR-ELEMENT-2  
              PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       5710-EXIT.                                                       
           EXIT.                                                        
C27862******************************************************************        
C27862* CHECK TO SEE IF ACCT IS REGULATED OR NOT                       *        
C27862*                                                                *        
C27862******************************************************************        
C27862                                                                  
C27862 5890-CHECK-REG-PROF.                                             
C27862                                                                  
C27862     MOVE '5890'                  TO ACTIVE-PARAGRAPH.            
C27862                                                                  
C27862     MOVE CMN-ACCOUNT-NO-NEW      TO LR-ACCOUNT-NO                
C27862                                                                  
C27862     EXEC SQL                                                     
P00172        SELECT TOP(1) 'Y'                                                
C27862          INTO :WS-REGULATED-FL                                   
C27862          FROM CSS_REG_PROFILE                                    
C27862         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                        
P00172                                           
                                                            
C27862     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-REGULATED-FL                                           
MFA-TR*         FROM CSS_REG_PROFILE                                            
MFA-TR*        WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*       QUERYNO 5890                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27862                                                                  
C26959     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
C27862                                                                  
C27582     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C27862        NEXT SENTENCE                                             
C27862     ELSE                                                         
C26959        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C26959        MOVE 'CSS_REG_PROFILE'         TO CMN-TABLE-1             
C26959        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
C26959        MOVE CMN-ACCOUNT-NO-NEW        TO CMN-HOSTVAR-ELEMENT-1   
C26959        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
C27582     END-IF.                                                      
C27862                                                                  
C27862 5890-EXIT.                                                       
C27862     EXIT.                                                        
                                                                        
P00677******************************************************************        
P00677* 5895-SELECT-REG-PROFILE                                        *        
P00677*  PULLS OLD REG PROFILE TO COPY TO NEW ACCOUNT                  *        
P00677*  CALLED FROM 5600-SEB-OC                                       *        
P00677******************************************************************        
P00677                                                                  
P00677 5895-SELECT-REG-PROFILE.                                         
P00677                                                                  
P00677     MOVE '5895'                  TO ACTIVE-PARAGRAPH.            
P00677                                                                  
P00677     MOVE CMN-ACCOUNT-NO          TO LR-ACCOUNT-NO                
P00677                                                                  
P00677     EXEC SQL                                                     
P00677        SELECT TOP(1) CUSTOMER_NO,
              PREMISE_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), GROUP_EFF_TS, 121), 
           ' ', '-'), ':', '.') GROUP_EFF_TS,
              REG_GROUP_CD,
              SENIOR_FL,
              'Y'                                                
P00677          INTO :LR-CUSTOMER-NO,                                   
P00677               :LR-PREMISE-NO,                                    
P00677               :LR-GROUP-EFF-TS,                                  
P00677               :LR-REG-GROUP-CD,                                  
P00677               :LR-SENIOR-FL,                                     
P00677               :WS-REG-EXISTS-OLD-ACCT                            
P00677         FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                    
P00677         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                        
P00677                                       
P00677                                                      
P00677     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              GROUP_EFF_TS,                                              
MFA-TR*              REG_GROUP_CD,                                              
MFA-TR*              SENIOR_FL,                                                 
MFA-TR*              'Y'                                                        
MFA-TR*         INTO :LR-CUSTOMER-NO,                                           
MFA-TR*              :LR-PREMISE-NO,                                            
MFA-TR*              :LR-GROUP-EFF-TS,                                          
MFA-TR*              :LR-REG-GROUP-CD,                                          
MFA-TR*              :LR-SENIOR-FL,                                             
MFA-TR*              :WS-REG-EXISTS-OLD-ACCT                                    
MFA-TR*        FROM CSS_REG_PROFILE LR                                          
MFA-TR*        WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*       QUERYNO 5895                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00677                                                                  
P00677     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00677                                                                  
P00677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00677        NEXT SENTENCE                                             
P00677     ELSE                                                         
P00677        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00677        MOVE 'CSS_REG_PROFILE'         TO CMN-TABLE-1             
P00677        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
P00677        MOVE LR-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
P00677        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
P00677     END-IF.                                                      
P00677                                                                  
P00677 5895-EXIT.                                                       
P00677     EXIT.                                                        
                                                                        
P00677******************************************************************        
P00677* 5896-SELECT-NEW-REG-PROFILE                                    *        
P00677*  CHECKS IF NEW REG PROFILE ALREADY EXISTS                      *        
P00677*  CALLED FROM 5600-SEB-OC                                       *        
P00677******************************************************************        
P00677                                                                  
P00677 5896-SELECT-NEW-REG-PROFILE.                                     
P00677                                                                  
P00677     MOVE '5896'                  TO ACTIVE-PARAGRAPH.            
P00677                                                                  
P00677     MOVE CMN-ACCOUNT-NO-NEW      TO LR-ACCOUNT-NO                
P00677                                                                  
P00677     EXEC SQL                                                     
P00677        SELECT TOP(1) 'Y'                                                
P00677          INTO :WS-REG-EXISTS-NEW-ACCT                            
P00677         FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                    
P00677         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                        
P00677                                       
P00677                                                      
P00677     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-REG-EXISTS-NEW-ACCT                                    
MFA-TR*        FROM CSS_REG_PROFILE LR                                          
MFA-TR*        WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*       QUERYNO 5896                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00677                                                                  
P00677     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00677                                                                  
P00677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00677        NEXT SENTENCE                                             
P00677     ELSE                                                         
P00677        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00677        MOVE 'CSS_REG_PROFILE'         TO CMN-TABLE-1             
P00677        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
P00677        MOVE LR-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
P00677        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
P00677     END-IF.                                                      
P00677                                                                  
P00677 5896-EXIT.                                                       
P00677     EXIT.                                                        
                                                                        
P00677******************************************************************        
P00677* 5897-CHECK-OLD-ACCT-FOR-SNR                                    *        
P00677*  CHECKS IF OLD ACCT HAS AGL SENIOR ATTRIBUTE                   *        
P00677*  CALLED FROM 5600-SEB-OC                                       *        
P00677******************************************************************        
P00677                                                                  
P00677 5897-CHECK-OLD-ACCT-FOR-SNR.                                     
P00677                                                                  
P00677     MOVE '5897'                  TO ACTIVE-PARAGRAPH.            
P00677                                                                  
P00677     MOVE CMN-ACCOUNT-NO          TO YP-ACCOUNT-NO                
P00677                                                                  
P00677     EXEC SQL                                                     
P00677        SELECT TOP(1) 'Y',
              STATUS_CD                                          
P00677          INTO :WS-AGL-SENIOR-ATTR,                               
P00677               :WS-AGL-SENIOR-STATUS                              
P00677         FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                 
P00677         WHERE ACCOUNT_NO = :YP-ACCOUNT-NO                        
P00677           AND ATTRIBUTE_DESC = 'AGL DISCOUNT SR'                 
P00677                                       
P00677                                                      
P00677     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y',                                                       
MFA-TR*              STATUS_CD                                                  
MFA-TR*         INTO :WS-AGL-SENIOR-ATTR,                                       
MFA-TR*              :WS-AGL-SENIOR-STATUS                                      
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE YP                                       
MFA-TR*        WHERE ACCOUNT_NO = :YP-ACCOUNT-NO                                
MFA-TR*          AND ATTRIBUTE_DESC = 'AGL DISCOUNT SR'                         
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*       QUERYNO 5897                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00677                                                                  
P00677     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00677                                                                  
P00677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00677        NEXT SENTENCE                                             
P00677     ELSE                                                         
P00677        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00677        MOVE 'CSS_ACCT_ATTRIBUTE'      TO CMN-TABLE-1             
P00677        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
P00677        MOVE YP-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
P00677        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
P00677     END-IF.                                                      
P00677                                                                  
P00677 5897-EXIT.                                                       
P00677     EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               * 00022008
      *    COPY OF CPD00091 - COPIED TO MAKE USE OF THE POSTING ERROR * 00023008
      *                       ROUTINES.                               * 00024008
      *                                                               * 00027008
      *****************************************************************         
       6302-GET-NEW-NAME-ID.                                            
                                                                        
           PERFORM 6304-LOCK-NAME-ID-CNTRL     THRU 6304-EXIT           
           PERFORM 6306-SELECT-NAME-ID-CNTL    THRU 6306-EXIT.          
                                                                        
           IF I7-NAME-ID >= WS-MAX-NAME-CNTL                            
              MOVE WS-MAX-NAME-ERROR-CODE      TO WS-ACTIVE-RETURN-CODE 
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '6302'                      TO ACTIVE-PARAGRAPH      
              MOVE 'NAME ID ABEND'             TO CMN-TABLE-1           
              PERFORM 9990-SQL-ERROR-ROUTINE   THRU 9990-EXIT           
           END-IF.                                                      
                                                                        
           ADD 1                               TO I7-NAME-ID.           
                                                                        
           MOVE I7-NAME-ID                     TO WS-GAS-NAME-ID-NUM    
                                                                        
           IF WS-GAS-NAME-ID-2 = 3 AND WS-GAS-NAME-ID-5-6 = 97          
              MOVE 98                          TO WS-GAS-NAME-ID-5-6    
              MOVE WS-GAS-NAME-ID-NUM          TO I7-NAME-ID            
           END-IF.                                                      
                                                                        
           MOVE I7-NAME-ID                     TO WS-91-NAME-ID.        
                                                                        
           MOVE WS-91-NAME-ID-12               TO WS-NBR-TO-BE-CHECKED2.
           PERFORM 6210-CALCULATE-CHECK-DIGIT  THRU 6210-EXIT.          
           MOVE WS-CHECK-DIGIT2                TO WS-91-NAME-CHECK-DGT. 
           MOVE WS-91-NAME-ID                  TO WS-91-NEW-NAME-ID.    
                                                                        
           PERFORM 6308-UPDATE-NAME-ID-CNTL    THRU 6308-EXIT.          
                                                                        
       6302-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6304-LOCK-NAME-ID-CNTRL.                                       *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       6304-LOCK-NAME-ID-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE('CSS_NAME_ID_CNTL')         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '6304'                      TO ACTIVE-PARAGRAPH      
CBSI          MOVE 'CSS_NAME_ID_CNTL'          TO CMN-TABLE-1           
CBSI          MOVE 'ACCOUNT_NO'                TO CMN-TABLE-ELEMENT-1   
CBSI          MOVE CMN-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1 
              PERFORM 9990-SQL-ERROR-ROUTINE   THRU 9990-EXIT           
           END-IF.                                                      
                                                                        
       6304-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6306-SELECT-NAME-ID-CNTL                                       *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       6306-SELECT-NAME-ID-CNTL.                                        
                                                                        
           EXEC SQL                                                     
              SELECT NAME_ID                                            
                INTO :I7-NAME-ID                                        
                FROM CSS_NAME_ID_CNTL                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_ID                                                    
MFA-TR*         INTO :I7-NAME-ID                                                
MFA-TR*         FROM CSS_NAME_ID_CNTL                                           
MFA-TR*         QUERYNO 6306                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '6306'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CSS_NAME_ID_CNTL'          TO CMN-TABLE-1           
CBSI          MOVE 'ACCOUNT_NO'                TO CMN-TABLE-ELEMENT-1   
CBSI          MOVE CMN-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1 
              PERFORM 9990-SQL-ERROR-ROUTINE   THRU 9990-EXIT           
           END-IF.                                                      
                                                                        
       6306-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6308-UPDATE-NAME-ID-CNTL                                       *        
      *                                                                *        
      *    1. SAVE INCREMENTED LAST NUMBER USED.                       *        
      *                                                                *        
      ******************************************************************        
       6308-UPDATE-NAME-ID-CNTL.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME_ID_CNTL                                   
                 SET NAME_ID = :I7-NAME-ID                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME_ID_CNTL                                           
MFA-TR*          SET NAME_ID = :I7-NAME-ID                                      
MFA-TR*         QUERYNO 6308                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '6308'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CSS_NAME_ID_CNTL'          TO CMN-TABLE-1           
              MOVE 'NAME_ID'                   TO CMN-TABLE-ELEMENT-1   
CBSI          MOVE 'ACCOUNT_NO'                TO CMN-TABLE-ELEMENT-2   
              MOVE I7-NAME-ID                  TO CMN-HOSTVAR-ELEMENT-1 
CBSI          MOVE CMN-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-2 
              PERFORM 9990-SQL-ERROR-ROUTINE   THRU 9990-EXIT           
           END-IF.                                                      
                                                                        
       6308-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * INCLUDE CPD00071                                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00071                                                  
           END-EXEC.                                                            
                                                                        
TP5912*****************************************************************         
TP5912* COPY CPD00067.                                                *         
TP5912*****************************************************************         
TP5912     EXEC SQL                                                             
A00765        INCLUDE CPD00067                                                  
TP5912     END-EXEC.                                                            
                                                                        
                                                                        
P00471*****************************************************************         
P00471* COPY CPD00109. - COPYBOOK THAT DROPS DPP                      *         
P00471*****************************************************************         
P00471     EXEC SQL                                                             
P00471        INCLUDE CPD00109                                                  
P00471     END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 7210-SELECT-ACCOUNT                                           *         
      *                                                               *         
      *    SELECT A ROW FROM THE TABLE CSS_ACCOUNT.                   *         
      *    PERFORMED BY 5000-UPDATE.                                  *         
      *    PERFORMS     9990-SQL-ERROR-ROUTINE.                       *         
      *****************************************************************         
       7210-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7210'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT TOTAL_AR_BALANCE       ,                          
                      CODES_DATA_PRESENT     ,                          
                      CODE_ACCT_STAT         ,                          
TP5912                CODE_STATUS_REASON     ,                          
TP5912                BANKRUPTCY_IND         ,                          
TP5912                CODES_DATA_PRESENT     ,                          
                      CUSTOMER_NO            ,                          
T5368                 ACCT_XFER_TO           ,                          
T5368                 MST_SUB_ACCT_IND       ,                          
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT         ,               
                      CREDIT_GROUP           ,                          
                      BILL_HIST_XFER_IND     ,                          
                      AR_XFER_IND            ,                          
                      PRINT_TYPE_CD          ,                          
                      CODE_PERM_BILL         ,                          
T20068                PREMISE_NO             ,                          
T22148                COMPANY_NO             ,                          
C50028                LOCAL_OFFICE           ,                          
C28788                IVR_EXEMPT_CD          ,                          
P00471                REV_MTH_LST_NRML                                  
                 INTO :AT-TOTAL-AR-BALANCE   ,                          
                      :AT-CODES-DATA-PRESENT ,                          
                      :AT-CODE-ACCT-STAT     ,                          
TP5912                :AT-CODE-STATUS-REASON ,                          
TP5912                :AT-BANKRUPTCY-IND     ,                          
TP5912                :AT-CODES-DATA-PRESENT ,                          
                      :AT-CUSTOMER-NO        ,                          
T5368                 :AT-ACCT-XFER-TO       ,                          
T5368                 :AT-MST-SUB-ACCT-IND   ,                          
                      :AT-ACCT-CREATE-DT     ,                          
                      :AT-CREDIT-GROUP       ,                          
                      :AT-BILL-HIST-XFER-IND ,                          
                      :AT-AR-XFER-IND        ,                          
                      :AT-PRINT-TYPE-CD      ,                          
                      :AT-CODE-PERM-BILL     ,                          
T20068                :AT-PREMISE-NO         ,                          
T22148                :AT-COMPANY-NO         ,                          
C30058                :AT-LOCAL-OFFICE       ,                          
C28788                :AT-IVR-EXEMPT-CD      ,                          
P00471                :AT-REV-MTH-LST-NRML                              
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TOTAL_AR_BALANCE       ,                                  
MFA-TR*               CODES_DATA_PRESENT     ,                                  
MFA-TR*               CODE_ACCT_STAT         ,                                  
MFA-TR*               CODE_STATUS_REASON     ,                                  
MFA-TR*               BANKRUPTCY_IND         ,                                  
MFA-TR*               CODES_DATA_PRESENT     ,                                  
MFA-TR*               CUSTOMER_NO            ,                                  
MFA-TR*               ACCT_XFER_TO           ,                                  
MFA-TR*               MST_SUB_ACCT_IND       ,                                  
MFA-TR*               ACCT_CREATE_DT         ,                                  
MFA-TR*               CREDIT_GROUP           ,                                  
MFA-TR*               BILL_HIST_XFER_IND     ,                                  
MFA-TR*               AR_XFER_IND            ,                                  
MFA-TR*               PRINT_TYPE_CD          ,                                  
MFA-TR*               CODE_PERM_BILL         ,                                  
MFA-TR*               PREMISE_NO             ,                                  
MFA-TR*               COMPANY_NO             ,                                  
MFA-TR*               LOCAL_OFFICE           ,                                  
MFA-TR*               IVR_EXEMPT_CD          ,                                  
MFA-TR*               REV_MTH_LST_NRML                                          
MFA-TR*          INTO :AT-TOTAL-AR-BALANCE   ,                                  
MFA-TR*               :AT-CODES-DATA-PRESENT ,                                  
MFA-TR*               :AT-CODE-ACCT-STAT     ,                                  
MFA-TR*               :AT-CODE-STATUS-REASON ,                                  
MFA-TR*               :AT-BANKRUPTCY-IND     ,                                  
MFA-TR*               :AT-CODES-DATA-PRESENT ,                                  
MFA-TR*               :AT-CUSTOMER-NO        ,                                  
MFA-TR*               :AT-ACCT-XFER-TO       ,                                  
MFA-TR*               :AT-MST-SUB-ACCT-IND   ,                                  
MFA-TR*               :AT-ACCT-CREATE-DT     ,                                  
MFA-TR*               :AT-CREDIT-GROUP       ,                                  
MFA-TR*               :AT-BILL-HIST-XFER-IND ,                                  
MFA-TR*               :AT-AR-XFER-IND        ,                                  
MFA-TR*               :AT-PRINT-TYPE-CD      ,                                  
MFA-TR*               :AT-CODE-PERM-BILL     ,                                  
MFA-TR*               :AT-PREMISE-NO         ,                                  
MFA-TR*               :AT-COMPANY-NO         ,                                  
MFA-TR*               :AT-LOCAL-OFFICE       ,                                  
MFA-TR*               :AT-IVR-EXEMPT-CD      ,                                  
MFA-TR*               :AT-REV-MTH-LST-NRML                                      
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 7210                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AT-CODE-ACCT-STAT         TO WS-ORIG-ACCT-STAT       
           ELSE                                                         
T5172         MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
T5172         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T5172         MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T5172         PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 7211-SELECT-ACCOUNT                                           *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
       7211-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7211'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
                      CODE_ACCT_STAT,                                   
                      CREDIT_GROUP,                                     
                      COMPANY_NO,                                       
C34128                CODE_PERM_BILL,                                   
A01422                BILL_HIST_XFER_IND                                
                 INTO :WS-AT-ACCT-CREATE-DT,                            
                      :WS-AT-CODE-ACCT-STAT,                            
                      :WS-AT-CREDIT-GROUP,                              
                      :WS-COMPANY-NO,                                   
C34128                :WS-HOLD-CODE-PERM-BILL,                          
A01422                :WS-HOLD-BILL-HIST-XFER                           
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCT_CREATE_DT,                                           
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               CREDIT_GROUP,                                             
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               CODE_PERM_BILL,                                           
MFA-TR*               BILL_HIST_XFER_IND                                        
MFA-TR*          INTO :WS-AT-ACCT-CREATE-DT,                                    
MFA-TR*               :WS-AT-CODE-ACCT-STAT,                                    
MFA-TR*               :WS-AT-CREDIT-GROUP,                                      
MFA-TR*               :WS-COMPANY-NO,                                           
MFA-TR*               :WS-HOLD-CODE-PERM-BILL,                                  
MFA-TR*               :WS-HOLD-BILL-HIST-XFER                                   
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO                            
MFA-TR*         QUERYNO 7211                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
              MOVE WS-AT-ACCOUNT-NO          TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7211-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
T8003 *****************************************************************         
T8003 * 7220-GET-NEW-ACCT-CODES                                       *         
T8003 *                                                               *         
T8003 *    OBTAIN THE CODES DATA PRESENT VALUE FROM THE NEW ACCOUNT.  *         
T8003 *    (THIS IS ONLY DONE WHEN THE ORDER IS A CUSTOMER OR OCCUPANT*         
T8003 *    CHANGE).                                                   *         
T8003 *                                                               *         
T8003 *****************************************************************         
T8003  7220-GET-NEW-ACCT-CODES.                                         
T8003                                                                   
T8003      MOVE '7220'                       TO ACTIVE-PARAGRAPH.       
T8003                                                                   
T8003      EXEC SQL                                                     
T8003          SELECT CODES_DATA_PRESENT,                               
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
T21448                MST_SUB_ACCT_IND                                  
T8003            INTO :AT-CODES-DATA-PRESENT,                           
                      :AT-ACCT-CREATE-DT,                               
T21448                :AT-MST-SUB-ACCT-IND                              
T8003            FROM CSS_ACCOUNT                                       
T8003           WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
T8003      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODES_DATA_PRESENT,                                       
MFA-TR*               ACCT_CREATE_DT,                                           
MFA-TR*               MST_SUB_ACCT_IND                                          
MFA-TR*          INTO :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-ACCT-CREATE-DT,                                       
MFA-TR*               :AT-MST-SUB-ACCT-IND                                      
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 7220                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T8003                                                                   
T8003      MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T8003                                                                   
T8003      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T8003         NEXT SENTENCE                                             
T8003      ELSE                                                         
T8003         MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
T8003         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T8003         MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T8003         PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
T8003      END-IF.                                                      
T8003                                                                   
T8003  7220-EXIT.                                                       
T8003      EXIT.                                                        
                                                                        
A37061******************************************************************        
A37061*  7280-SEL-ACCT-TYPE-CODE                                       *        
A37061******************************************************************        
A37061 7280-SEL-ACCT-TYPE-CODE.                                         
A37061                                                                  
A37061     MOVE '7280'                        TO ACTIVE-PARAGRAPH.      
A37061                                                                  
A37061     EXEC SQL                                                     
A37061         SELECT ACCOUNT_TYPE_CODE                                 
A37061           INTO :AT-ACCOUNT-TYPE-CODE                             
A37061           FROM CSS_ACCOUNT                                       
A37061          WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                       
                                                            
A37061     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_TYPE_CODE                                         
MFA-TR*          INTO :AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 7280                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37061                                                                  
A37061     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37061                                                                  
A37061     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A37061        NEXT SENTENCE                                             
A37061     ELSE                                                         
A37061        MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
A37061        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
A37061        MOVE  CMN-ACCOUNT-NO           TO CMN-HOSTVAR-ELEMENT-1   
A37061        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
A37061     END-IF.                                                      
A37061                                                                  
A37061 7280-EXIT.                                                       
A37061     EXIT.                                                        
A37061*                                                                         
                                                                        
      *****************************************************************         
      * 7370-SELECT-CUST-PREM-HIST.                                   *         
      *                                                               *         
      *    SELECT THE SERVICE END DATE FROM THE CSS_CUST_PREM_HIST    *         
      *    TABLE.                                                     *         
      *    PERFORMED BY 5400-PROCESS-ACCT-DATA.                       *         
      *    PERFORMS     9990-SQL-ERROR-ROUTINE.                       *         
      *****************************************************************         
       7370-SELECT-CUST-PREM-HIST.                                      
                                                                        
           MOVE '7370'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT DATE_UTIL_SVC_END                                 
                 INTO :CH-DATE-UTIL-SVC-END :WS-NULL-INDICATOR           
                 FROM CSS_CUST_PREM_HIST                                
                WHERE ACCOUNT_NO = :CH-ACCOUNT-NO                       
                  AND PREMISE_NO = :CH-PREMISE-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_UTIL_SVC_END                                         
MFA-TR*          INTO :CH-DATE-UTIL-SVC-END:WS-NULL-INDICATOR                   
MFA-TR*          FROM CSS_CUST_PREM_HIST                                        
MFA-TR*         WHERE ACCOUNT_NO = :CH-ACCOUNT-NO                               
MFA-TR*           AND PREMISE_NO = :CH-PREMISE-NO                               
MFA-TR*         QUERYNO 7270                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_CUST_PREM_HIST'      TO CMN-TABLE-1             
T5172         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T5172         MOVE 'PREMISE_NO'              TO CMN-TABLE-ELEMENT-2     
T5172         MOVE CH-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T5172         MOVE CH-PREMISE-NO             TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7370-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 7400-SELECT-CUST-DATE.                                        *         
      *                                                               *         
      *    SELECT THE SERVICE ESTIMATION DATE FOR THE CUSTOMER.       *         
      *    PERFORMS     9990-SQL-ERROR-ROUTINE.                       *         
      *****************************************************************         
       7400-SELECT-CUST-DATE.                                           
                                                                        
           MOVE '7400'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT SERVICE_EST_DATE,                                 
C35362                CU.CUSTOMER_NO                                    
                 INTO :CU-SERVICE-EST-DATE :WS-NULL-INDICATOR,           
C35362                :CU-CUSTOMER-NO                                   
                 FROM CSS_CUSTOMER CU,                                  
C35262                CSS_ACCOUNT AT                                    
C35362          WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NEW                   
C35362            AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERVICE_EST_DATE,                                         
MFA-TR*               CU.CUSTOMER_NO                                            
MFA-TR*          INTO :CU-SERVICE-EST-DATE:WS-NULL-INDICATOR,                   
MFA-TR*               :CU-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_CUSTOMER CU,                                          
MFA-TR*               CSS_ACCOUNT AT                                            
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NEW                           
MFA-TR*           AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_CUSTOMER'            TO CMN-TABLE-1             
T5172         MOVE 'CUSTOMER_NO'             TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-2     
T5172         MOVE CU-CUSTOMER-NO            TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE CMN-ACCOUNT-NO            TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T25243 7410-SELECT-CRED-COLL.                                           
T25243                                                                  
T25243     MOVE '7410'                        TO ACTIVE-PARAGRAPH.      
T25243                                                                  
T25243     EXEC SQL                                                     
T25243         SELECT DISTINCT 'Y'                                      
T25243           INTO :WS-NON-UTIL-FOUND                                
T25243           FROM CSS_CRED_COLL                                     
T25243          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
T25243            AND CODE_NOTICE_TYPE IN ('S','U')                     
                                                            
T25243     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTINCT 'Y'                                              
MFA-TR*          INTO :WS-NON-UTIL-FOUND                                        
MFA-TR*          FROM CSS_CRED_COLL                                             
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND CODE_NOTICE_TYPE IN ('S','U')                             
MFA-TR*         QUERYNO 7410                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25243                                                                  
T25243     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T25243                                                                  
T25243     EVALUATE WS-ACTIVE-RETURN-CODE                               
T25243         WHEN SUCCESSFUL-CALL                                     
T25243             CONTINUE                                             
T25243         WHEN NOT-FOUND                                           
T25243             MOVE 'N' TO WS-NON-UTIL-FOUND                        
T25243         WHEN OTHER                                               
T5172             MOVE 'CSS_CRED_COLL'       TO CMN-TABLE-1             
CBSI              MOVE 'ACCOUNT_NO'          TO CMN-TABLE-ELEMENT-1     
CBSI              MOVE CMN-ACCOUNT-NO        TO CMN-HOSTVAR-ELEMENT-1   
T25243            PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT         
T25243     END-EVALUATE.                                                
T25243                                                                  
T25243 7410-EXIT.                                                       
T25243     EXIT.                                                        
                                                                        
C26296 7420-SELECT-CRED-PROF-AMT.                                       
C26296                                                                  
C26296     MOVE '7420'                        TO ACTIVE-PARAGRAPH.      
C26296                                                                  
C26296     EXEC SQL                                                     
C26296         SELECT AUTO_DEP_AM                                       
C26296           INTO :DL-AUTO-DEP-AM                                   
C26296           FROM CSS_CREDIT_PROFILE                                
C26296          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AUTO_DEP_AM                                               
MFA-TR*          INTO :DL-AUTO-DEP-AM                                           
MFA-TR*          FROM CSS_CREDIT_PROFILE                                        
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 7420                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
C26296     EVALUATE WS-ACTIVE-RETURN-CODE                               
C26296         WHEN SUCCESSFUL-CALL                                     
C26296             CONTINUE                                             
C26296         WHEN NOT-FOUND                                           
C26296             MOVE 0 TO DL-AUTO-DEP-AM                             
C26296         WHEN OTHER                                               
C26296            MOVE 'CSS_CREDIT_PROFILE'  TO CMN-TABLE-1             
C26296            MOVE 'ACCOUNT_NO'          TO CMN-TABLE-ELEMENT-1     
C26296            MOVE CMN-ACCOUNT-NO        TO CMN-HOSTVAR-ELEMENT-1   
C26296            PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT         
C26296     END-EVALUATE.                                                
C26296                                                                  
C26296 7420-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
T8070 *****************************************************************         
T8070 * 7500-SELECT-NEW-CUST                                          *         
T8070 *                                                               *         
T8070 *    SELECT CUSTOMER NUMBER FROM CSS_ACCOUNT.                   *         
T8070 *    PERFORMED BY 5400-PROCESS-ACCT-DATA.                       *         
T8070 *    PERFORMS     9990-SQL-ERROR-ROUTINE.                       *         
T8070 *****************************************************************         
T8070  7500-SELECT-NEW-CUST.                                            
T8070                                                                   
T8070      MOVE '7500'                       TO ACTIVE-PARAGRAPH.       
T8070                                                                   
T8070      EXEC SQL                                                     
T8070          SELECT CUSTOMER_NO                                       
T8070            INTO :AT-CUSTOMER-NO                                   
T8070            FROM CSS_ACCOUNT                                       
T8070           WHERE ACCOUNT_NO = :CH-ACCOUNT-NO                       
                                                            
T8070      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*          INTO :AT-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :CH-ACCOUNT-NO                               
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T8070                                                                   
T8070      MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T8070                                                                   
T8070      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T8070         MOVE AT-CODE-ACCT-STAT         TO WS-ORIG-ACCT-STAT       
T8070      ELSE                                                         
T8070         MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
T8070         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T8070         MOVE CH-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T8070         PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
T8070      END-IF.                                                      
T8070                                                                   
T8070  7500-EXIT.                                                       
T8070      EXIT.                                                        
                                                                        
      *****************************************************************         
T18382* 7510-GET-LO-CO-CPD00068                                       *         
      *                                                               *         
      *    SELECT LOCAL OFFICE AND COMPANY NO FOR CALL TO CPD00068    *         
T18736*    ADDED OTHER FIELDS NECESSARY FOR CALL TO CPD00068          *         
      *    PERFORMED BY 5425-PROCESS-RECONNECT.                       *         
      *    PERFORMS     9990-SQL-ERROR-ROUTINE.                       *         
      *****************************************************************         
       7510-GET-LO-CO-CPD00068.                                         
                                                                        
           MOVE '7510'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT LOCAL_OFFICE,                                     
                      COMPANY_NO,                                       
T18736                NOTICE_EXEMPT_CD,                                 
T18736                CODE_DISC_OK,                                     
T18736                DATE_BILL_DAY_00,                                 
T18736                DATE_BILL_DAY_30,                                 
T18736                DATE_BILL_DAY_60,                                 
T18736                DATE_BILL_DAY_90,                                 
C28788                IVR_EXEMPT_CD                                     
                 INTO :AT-LOCAL-OFFICE,                                 
                      :AT-COMPANY-NO,                                   
T18736                :AT-NOTICE-EXEMPT-CD,                             
T18736                :AT-CODE-DISC-OK,                                 
T18736                :AT-DATE-BILL-DAY-00 :WS-BILL-DAY-00-NI,           
T18736                :AT-DATE-BILL-DAY-30 :WS-BILL-DAY-30-NI,           
T18736                :AT-DATE-BILL-DAY-60 :WS-BILL-DAY-60-NI,           
T18736                :AT-DATE-BILL-DAY-90 :WS-BILL-DAY-90-NI,           
C28788                :AT-IVR-EXEMPT-CD                                 
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :CH-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LOCAL_OFFICE,                                             
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               NOTICE_EXEMPT_CD,                                         
MFA-TR*               CODE_DISC_OK,                                             
MFA-TR*               DATE_BILL_DAY_00,                                         
MFA-TR*               DATE_BILL_DAY_30,                                         
MFA-TR*               DATE_BILL_DAY_60,                                         
MFA-TR*               DATE_BILL_DAY_90,                                         
MFA-TR*               IVR_EXEMPT_CD                                             
MFA-TR*          INTO :AT-LOCAL-OFFICE,                                         
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-NOTICE-EXEMPT-CD,                                     
MFA-TR*               :AT-CODE-DISC-OK,                                         
MFA-TR*               :AT-DATE-BILL-DAY-00:WS-BILL-DAY-00-NI,                   
MFA-TR*               :AT-DATE-BILL-DAY-30:WS-BILL-DAY-30-NI,                   
MFA-TR*               :AT-DATE-BILL-DAY-60:WS-BILL-DAY-60-NI,                   
MFA-TR*               :AT-DATE-BILL-DAY-90:WS-BILL-DAY-90-NI,                   
MFA-TR*               :AT-IVR-EXEMPT-CD                                         
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :CH-ACCOUNT-NO                               
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T18736        IF WS-BILL-DAY-00-NI < 0                                  
T18736            MOVE LOW-VALUES           TO AT-DATE-BILL-DAY-00      
T18736        END-IF                                                    
T18736        IF WS-BILL-DAY-30-NI < 0                                  
T18736            MOVE LOW-VALUES           TO AT-DATE-BILL-DAY-30      
T18736        END-IF                                                    
T18736        IF WS-BILL-DAY-60-NI < 0                                  
T18736            MOVE LOW-VALUES           TO AT-DATE-BILL-DAY-60      
T18736        END-IF                                                    
T18736        IF WS-BILL-DAY-90-NI < 0                                  
T18736            MOVE LOW-VALUES           TO AT-DATE-BILL-DAY-90      
T18736        END-IF                                                    
           ELSE                                                         
              MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
CBSI          MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
              MOVE CH-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
C36210 7550-SEB-DEREG-SENIOR.                                           
C36210                                                                  
C36210     EXEC SQL                                                     
C36210         SELECT TOP(1) 'N'                                               
C36210           INTO :WS-SEB-DEREG-NON-SENIOR                          
C36210           FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                
C36210                CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
C36210          WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                       
C36210            AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                 
C36210            AND SENIOR_RATE_FL IN ('S', 'Y')                      
C36210                                           
C36210                                                           
                                                            
C36210     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'N'                                                       
MFA-TR*          INTO :WS-SEB-DEREG-NON-SENIOR                                  
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT,                                      
MFA-TR*               CSS_RATE_PLAN_DESC RD                                     
MFA-TR*         WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                               
MFA-TR*           AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                         
MFA-TR*           AND SENIOR_RATE_FL IN ('S', 'Y')                              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7550                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36210                                                                  
C36210     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C36210                                                                  
C36210     EVALUATE WS-ACTIVE-RETURN-CODE                               
C36210        WHEN SUCCESSFUL-CALL                                      
C36210            CONTINUE                                              
C36210        WHEN NOT-FOUND                                            
C36210           MOVE 'Y' TO WS-SEB-DEREG-NON-SENIOR                    
C36210        WHEN OTHER                                                
C36210           MOVE '7550'                  TO ACTIVE-PARAGRAPH       
C36210           MOVE 'CSS_UTIL_ENVRNMT'      TO CMN-TABLE-1            
C36210           MOVE 'ACCOUNT_NO'            TO CMN-TABLE-ELEMENT-1    
C36210           MOVE UT-ACCOUNT-NO           TO CMN-HOSTVAR-ELEMENT-1  
C36210           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C36210     END-EVALUATE.                                                
C36210                                                                  
C36210 7550-EXIT.                                                       
C36210     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7600-GET-MASTER-ACCT.                                         *         
      *                                                               *         
      *    SELECT THE MASTER ACCOUNT FOR THIS ACCOUNT.                *         
      *                                                               *         
      *****************************************************************         
       7600-GET-MASTER-ACCT.                                            
                                                                        
           MOVE '7600'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT LL_MASTER_ACCT_NO                                 
                 INTO :SI-LL-MASTER-ACCT-NO                             
                 FROM CSS_LANDLORD                                      
                WHERE PREMISE_NO = :CH-PREMISE-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LL_MASTER_ACCT_NO                                         
MFA-TR*          INTO :SI-LL-MASTER-ACCT-NO                                     
MFA-TR*          FROM CSS_LANDLORD                                              
MFA-TR*         WHERE PREMISE_NO = :CH-PREMISE-NO                               
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_LANDLORD'            TO CMN-TABLE-1             
              MOVE 'PREMISE_NO'              TO CMN-TABLE-ELEMENT-1     
              MOVE CH-PREMISE-NO             TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02516 7610-GET-MASTER-STAT.                                            
A02516                                                                  
A02516     MOVE '7610'                        TO ACTIVE-PARAGRAPH.      
A02516                                                                  
A02516     EXEC SQL                                                     
A02516         SELECT CODE_ACCT_STAT                                    
A02516           INTO :WS-LL-CODE-ACCT-STAT                             
A02516           FROM CSS_ACCOUNT                                       
A02516          WHERE ACCOUNT_NO = :SI-LL-MASTER-ACCT-NO                
A02516                                                      
A02516     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_ACCT_STAT                                            
MFA-TR*          INTO :WS-LL-CODE-ACCT-STAT                                     
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :SI-LL-MASTER-ACCT-NO                        
MFA-TR*         QUERYNO 7610                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02516                                                                  
A02516     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A02516                                                                  
A02516     EVALUATE WS-ACTIVE-RETURN-CODE                               
A02516         WHEN SUCCESSFUL-CALL                                     
A02516             IF WS-LL-CODE-ACCT-STAT NOT = 'A'                    
A02516                 MOVE ZEROES TO SI-LL-MASTER-ACCT-NO              
A02516             END-IF                                               
A02516         WHEN NOT-FOUND                                           
A02516             MOVE ZEROES TO SI-LL-MASTER-ACCT-NO                  
A02516         WHEN OTHER                                               
A02516             MOVE 'CSS_ACCOUNT'        TO CMN-TABLE-1             
A02516             MOVE 'ACCOUNT_NO'         TO CMN-TABLE-ELEMENT-1     
A02516             MOVE SI-LL-MASTER-ACCT-NO TO CMN-HOSTVAR-ELEMENT-1   
A02516             PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT        
A02516     END-EVALUATE.                                                
A02516                                                                  
A02516 7610-EXIT.                                                       
A02516     EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 7700-GET-MASTER-CODES.                                        *         
      *                                                               *         
      *    SELECT THE PRINT TYPE AND CODE PERM BILL FROM THE MASTER   *         
      *    ACCOUNT.                                                   *         
      *****************************************************************         
       7700-GET-MASTER-CODES.                                           
                                                                        
           MOVE '7700'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT PRINT_TYPE_CD,                                    
                      CODE_PERM_BILL                                    
                 INTO :AT-PRINT-TYPE-CD,                                
                      :AT-CODE-PERM-BILL                                
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :SI-LL-MASTER-ACCT-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PRINT_TYPE_CD,                                            
MFA-TR*               CODE_PERM_BILL                                            
MFA-TR*          INTO :AT-PRINT-TYPE-CD,                                        
MFA-TR*               :AT-CODE-PERM-BILL                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :SI-LL-MASTER-ACCT-NO                        
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
              MOVE SI-LL-MASTER-ACCT-NO      TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 7795-CHECK-LL-FLAG.                                           *         
      *                                                               *         
T17110*    SELECT THE CODE_RENTAL_PROP FLAG FROM CSS_PREMISE.         *         
      *****************************************************************         
       7795-CHECK-LL-FLAG.                                              
                                                                        
           MOVE '7795'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT CODE_RENTAL_PROP                                  
                 INTO :PR-CODE-RENTAL-PROP                              
                 FROM CSS_PREMISE                                       
                WHERE PREMISE_NO = :CH-PREMISE-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_RENTAL_PROP                                          
MFA-TR*          INTO :PR-CODE-RENTAL-PROP                                      
MFA-TR*          FROM CSS_PREMISE                                               
MFA-TR*         WHERE PREMISE_NO = :CH-PREMISE-NO                               
MFA-TR*         QUERYNO 7795                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_PREMISE'             TO CMN-TABLE-1             
              MOVE 'PREMISE_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-2     
              MOVE CH-PREMISE-NO             TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE CMN-ACCOUNT-NO            TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7795-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************20800000
      * 7800-GET-LANDLORD-INFO.                                        *20800000
      *                                                                *20800000
      *                                                                *20800000
      ******************************************************************20800000
       7800-GET-LANDLORD-INFO.                                          
                                                                        
           MOVE '7800'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT ADDRESS_ID,                                       
T17198                ADDRESS_FORMAT                                    
                 INTO :SI-ADDRESS-ID,                                   
T17198                :SI-ADDRESS-FORMAT                                
                 FROM CSS_LANDLORD                                      
                WHERE PREMISE_NO = :CH-PREMISE-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     27640000
MFA-TR*        SELECT ADDRESS_ID,                                       27650000
MFA-TR*               ADDRESS_FORMAT                                            
MFA-TR*          INTO :SI-ADDRESS-ID,                                   27710000
MFA-TR*               :SI-ADDRESS-FORMAT                                        
MFA-TR*          FROM CSS_LANDLORD                                      27730000
MFA-TR*         WHERE PREMISE_NO = :CH-PREMISE-NO                       27740000
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*    END-EXEC.                                                    27760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21897        IF SI-ADDRESS-ID = 0                                      
T21897            MOVE ' ' TO SI-ADDRESS-FORMAT                         
T21897        END-IF                                                    
           ELSE                                                         
              MOVE 'CSS_LANDLORD'             TO CMN-TABLE-1            
              MOVE 'PREMISE_NO'               TO CMN-TABLE-ELEMENT-1    
CBSI          MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-2    
CBSI          MOVE CH-PREMISE-NO              TO CMN-HOSTVAR-ELEMENT-1  
CBSI          MOVE CMN-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-2  
CBSI          PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
A35665 7805-GET-COUNTRY.                                                
A35665                                                                  
A35665     MOVE '7805'                       TO ACTIVE-PARAGRAPH.       
A35665                                                                  
A35665     EXEC SQL                                                     
A35665         SELECT ADDR_COUNTRY                                      
A35665           INTO :DZ-ADDR-COUNTRY                                  
A35665           FROM CSS_ADDR_FREEFORM                                 
A35665          WHERE ADDRESS_ID = :SI-ADDRESS-ID                       
A35665                                                      
A35665     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     27640000
MFA-TR*        SELECT ADDR_COUNTRY                                      27650000
MFA-TR*          INTO :DZ-ADDR-COUNTRY                                  27710000
MFA-TR*          FROM CSS_ADDR_FREEFORM                                 27730000
MFA-TR*         WHERE ADDRESS_ID = :SI-ADDRESS-ID                       27740000
MFA-TR*         QUERYNO 7805                                                    
MFA-TR*    END-EXEC.                                                    27760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A35665                                                                  
A35665     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
A35665                                                                  
A35665     EVALUATE WS-ACTIVE-RETURN-CODE                               
A35665         WHEN SUCCESSFUL-CALL                                     
A35665             IF DZ-ADDR-COUNTRY > ' ' AND                         
A35665                DZ-ADDR-COUNTRY NOT = 'USA'                       
A35665                    MOVE 'D' TO AT-CODE-PERM-BILL                 
A35665             END-IF                                               
A35665         WHEN NOT-FOUND                                           
A35665             CONTINUE                                             
A35665         WHEN OTHER                                               
A35665             MOVE 'CSS_LANDLORD'        TO CMN-TABLE-1            
A35665             MOVE 'PREMISE_NO'          TO CMN-TABLE-ELEMENT-1    
A35665             MOVE 'ACCOUNT_NO'          TO CMN-TABLE-ELEMENT-2    
A35665             MOVE CH-PREMISE-NO         TO CMN-HOSTVAR-ELEMENT-1  
A35665             MOVE CMN-ACCOUNT-NO        TO CMN-HOSTVAR-ELEMENT-2  
A35665             PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT        
A35665     END-EVALUATE.                                                
A35665                                                                  
A35665 7805-EXIT.                                                       
A35665     EXIT.                                                        
                                                                        
      ******************************************************************20800000
      * 7810-UPDATE-LL-ACCT.                                           *20800000
      *                                                                *20800000
      *                                                                *20800000
      ******************************************************************20800000
       7810-UPDATE-LL-ACCT.                                             
                                                                        
           MOVE '7810'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET ADDRESS_ID     = :SI-ADDRESS-ID,                  
T17198                ADDRESS_FORMAT = :SI-ADDRESS-FORMAT               
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     27640000
MFA-TR*        UPDATE CSS_ACCOUNT                                       27650000
MFA-TR*           SET ADDRESS_ID     = :SI-ADDRESS-ID,                  27710000
MFA-TR*               ADDRESS_FORMAT = :SI-ADDRESS-FORMAT                       
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       27740000
MFA-TR*         QUERYNO 7810                                                    
MFA-TR*    END-EXEC.                                                    27760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_ACCOUNT'              TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
CBSI          MOVE 'ADDRESS_ID'               TO CMN-TABLE-ELEMENT-2    
CBSI          MOVE 'ADDRESS_FORMAT'           TO CMN-TABLE-ELEMENT-3    
              MOVE AT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
CBSI          MOVE SI-ADDRESS-ID              TO CMN-HOSTVAR-ELEMENT-2  
CBSI          MOVE SI-ADDRESS-FORMAT          TO CMN-HOSTVAR-ELEMENT-3  
CBSI          PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************20800000
      * 7820-GET-NAME-ID.                                              *20800000
      *                                                                *20800000
      *                                                                *20800000
      ******************************************************************20800000
       7820-GET-NAME-ID.                                                
                                                                        
           MOVE '7820'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT HT.NAME_ID                                        
                 INTO :HT-NAME-ID                                       
                 FROM CSS_NAME_ACCT_XREF HT,                            
T18916                CSS_NAME           DQ                             
                WHERE HT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
T18916            AND HT.NAME_ID = DQ.NAME_ID                           
T18916            AND DQ.NAME_TYPE = 'CN'                               
T19691            AND HT.CUSTOMER_ROLE_CD = ' '                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     27640000
MFA-TR*        SELECT HT.NAME_ID                                        27650000
MFA-TR*          INTO :HT-NAME-ID                                       27710000
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME           DQ                                     
MFA-TR*         WHERE HT.ACCOUNT_NO = :AT-ACCOUNT-NO                    27740000
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*         QUERYNO 7820                                                    
MFA-TR*    END-EXEC.                                                    27760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_NAME_ACCT_XREF'       TO CMN-TABLE-1            
T18916        MOVE 'CSS_NAME'                 TO CMN-TABLE-2            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
              MOVE AT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
CBSI          PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************20800000
      * 7825-GET-NAME-INFO.                                            *20800000
      *                                                                *20800000
      *                                                                *20800000
      ******************************************************************20800000
       7825-GET-NAME-INFO.                                              
                                                                        
           MOVE '7825'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT NAME_FORMAT   ,                                   
                      FIRST_NAME    ,                                   
                      MIDDLE_NAME   ,                                   
                      LAST_NAME     ,                                   
                      TITLE_PREFIX  ,                                   
                      TITLE_SUFFIX_1,                                   
                      TITLE_SUFFIX_2,                                   
                      FULL_NAME                                         
                 INTO :DQ-NAME-FORMAT   ,                               
                      :DQ-FIRST-NAME    ,                               
                      :DQ-MIDDLE-NAME   ,                               
                      :DQ-LAST-NAME     ,                               
                      :DQ-TITLE-PREFIX  ,                               
                      :DQ-TITLE-SUFFIX-1,                               
                      :DQ-TITLE-SUFFIX-2,                               
                      :DQ-FULL-NAME                                     
                 FROM CSS_NAME                                          
                WHERE NAME_ID = :HT-NAME-ID                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     27640000
MFA-TR*        SELECT NAME_FORMAT   ,                                           
MFA-TR*               FIRST_NAME    ,                                           
MFA-TR*               MIDDLE_NAME   ,                                           
MFA-TR*               LAST_NAME     ,                                           
MFA-TR*               TITLE_PREFIX  ,                                           
MFA-TR*               TITLE_SUFFIX_1,                                           
MFA-TR*               TITLE_SUFFIX_2,                                           
MFA-TR*               FULL_NAME                                                 
MFA-TR*          INTO :DQ-NAME-FORMAT   ,                                       
MFA-TR*               :DQ-FIRST-NAME    ,                                       
MFA-TR*               :DQ-MIDDLE-NAME   ,                                       
MFA-TR*               :DQ-LAST-NAME     ,                                       
MFA-TR*               :DQ-TITLE-PREFIX  ,                                       
MFA-TR*               :DQ-TITLE-SUFFIX-1,                                       
MFA-TR*               :DQ-TITLE-SUFFIX-2,                                       
MFA-TR*               :DQ-FULL-NAME                                             
MFA-TR*          FROM CSS_NAME                                                  
MFA-TR*         WHERE NAME_ID = :HT-NAME-ID                             27740000
MFA-TR*         QUERYNO 7825                                                    
MFA-TR*    END-EXEC.                                                    27760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_NAME'                 TO CMN-TABLE-1            
              MOVE 'NAME_ID'                  TO CMN-TABLE-ELEMENT-1    
CBSI          MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-2    
              MOVE HT-NAME-ID                 TO CMN-HOSTVAR-ELEMENT-1  
CBSI          MOVE CMN-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-2  
CBSI          PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       7825-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************35280000
      * 7827-INSERT-NAME                                               *35290000
      *                                                                *35510000
      *                                                                *35510000
      ******************************************************************35380000
       7827-INSERT-NAME.                                                
                                                                        
           MOVE '7827'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                  (NAME_ID       ,                                      
                   NAME_TYPE     ,                                      
                   NAME_FORMAT   ,                                      
                   CREATED_DATE  ,                                      
                   FIRST_NAME    ,                                      
                   MIDDLE_NAME   ,                                      
                   LAST_NAME     ,                                      
                   TITLE_PREFIX  ,                                      
                   TITLE_SUFFIX_1,                                      
                   TITLE_SUFFIX_2,                                      
                   FULL_NAME)                                           
              VALUES                                                    
                  (:WS-NEW-NAME-ID   ,                                  
                   'AN'              ,                                  
                   :DQ-NAME-FORMAT   ,                                  
                   CIS.CURRENT$TIMESTAMP() ,                                  
                   :DQ-FIRST-NAME    ,                                  
                   :DQ-MIDDLE-NAME   ,                                  
                   :DQ-LAST-NAME     ,                                  
                   :DQ-TITLE-PREFIX  ,                                  
                   :DQ-TITLE-SUFFIX-1,                                  
                   :DQ-TITLE-SUFFIX-2,                                  
                   :DQ-FULL-NAME)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     35440000
MFA-TR*       INSERT INTO CSS_NAME                                      35450000
MFA-TR*           (NAME_ID       ,                                      35460000
MFA-TR*            NAME_TYPE     ,                                      35470000
MFA-TR*            NAME_FORMAT   ,                                      35480000
MFA-TR*            CREATED_DATE  ,                                      35490000
MFA-TR*            FIRST_NAME    ,                                      35500000
MFA-TR*            MIDDLE_NAME   ,                                      35510000
MFA-TR*            LAST_NAME     ,                                      35520000
MFA-TR*            TITLE_PREFIX  ,                                      35551000
MFA-TR*            TITLE_SUFFIX_1,                                      35540000
MFA-TR*            TITLE_SUFFIX_2,                                      35550000
MFA-TR*            FULL_NAME)                                           35560000
MFA-TR*       VALUES                                                    35570000
MFA-TR*           (:WS-NEW-NAME-ID   ,                                  35570000
MFA-TR*            'AN'              ,                                  35580000
MFA-TR*            :DQ-NAME-FORMAT   ,                                  35590000
MFA-TR*            CURRENT TIMESTAMP ,                                  35600000
MFA-TR*            :DQ-FIRST-NAME    ,                                  35610000
MFA-TR*            :DQ-MIDDLE-NAME   ,                                  35620000
MFA-TR*            :DQ-LAST-NAME     ,                                  35651000
MFA-TR*            :DQ-TITLE-PREFIX  ,                                  35640000
MFA-TR*            :DQ-TITLE-SUFFIX-1,                                  35650000
MFA-TR*            :DQ-TITLE-SUFFIX-2,                                  35660000
MFA-TR*            :DQ-FULL-NAME)                                       35670000
MFA-TR*    END-EXEC.                                                    35680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_NAME'                 TO CMN-TABLE-1            
              MOVE 'NAME_ID'                  TO CMN-TABLE-ELEMENT-1    
CBSI          MOVE 'NAME_FORMAT'              TO CMN-TABLE-ELEMENT-2    
CBSI          MOVE 'FIRST_NAME'               TO CMN-TABLE-ELEMENT-3    
CBSI          MOVE 'MIDDLE_NAME'              TO CMN-TABLE-ELEMENT-4    
              MOVE HT-NAME-ID                 TO CMN-HOSTVAR-ELEMENT-1  
CBSI          MOVE DQ-NAME-FORMAT             TO CMN-HOSTVAR-ELEMENT-2  
CBSI          MOVE DQ-FIRST-NAME              TO CMN-HOSTVAR-ELEMENT-3  
CBSI          MOVE DQ-MIDDLE-NAME             TO CMN-HOSTVAR-ELEMENT-4  
CBSI          PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       7827-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29307******************************************************************35280000
C29307* 7828-SELECT-NAME-ACCT-XREF.                                    *35290000
C29307*                                                                *35510000
C29307*                                                                *35510000
C29307******************************************************************35380000
C29307 7828-SELECT-NAME-ACCT-XREF.                                      
C29307                                                                  
C29307     MOVE '7828'                       TO ACTIVE-PARAGRAPH.       
C29307                                                                  
C29307     EXEC SQL                                                     
C29307        SELECT NAME_ID                                            
C29307              ,COMPANY_NO                                         
C29307              ,CUSTOMER_NO                                        
C29307              ,ADDRESS_ID                                         
C29307              ,PREMISE_NO                                         
C29307              ,CONTACT_ID                                         
C29307              ,CUSTOMER_ROLE_CD                                   
C29307              ,STATE                                              
C29307              ,TOWN                                               
C29307              ,LOCAL_OFFICE                                       
C29307          INTO                                                    
C29307              :HT-NAME-ID                                         
C29307             ,:HT-COMPANY-NO                                      
C29307             ,:HT-CUSTOMER-NO                                     
C29307             ,:HT-ADDRESS-ID                                      
C29307             ,:HT-PREMISE-NO                                      
C29307             ,:HT-CONTACT-ID                                      
C29307             ,:HT-CUSTOMER-ROLE-CD                                
C29307             ,:HT-STATE                                           
C29307             ,:HT-TOWN                                            
C29307             ,:HT-LOCAL-OFFICE                                    
C29307          FROM CSS_NAME_ACCT_XREF                                 
C29307         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
                                                            
C29307     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     35440000
MFA-TR*       SELECT NAME_ID                                            35450000
MFA-TR*             ,COMPANY_NO                                         35470000
MFA-TR*             ,CUSTOMER_NO                                        35480000
MFA-TR*             ,ADDRESS_ID                                         35500000
MFA-TR*             ,PREMISE_NO                                         35510000
MFA-TR*             ,CONTACT_ID                                         35520000
MFA-TR*             ,CUSTOMER_ROLE_CD                                   35551000
MFA-TR*             ,STATE                                              35540000
MFA-TR*             ,TOWN                                               35550000
MFA-TR*             ,LOCAL_OFFICE                                       35560000
MFA-TR*         INTO                                                    35570000
MFA-TR*             :HT-NAME-ID                                         35570000
MFA-TR*            ,:HT-COMPANY-NO                                      35580000
MFA-TR*            ,:HT-CUSTOMER-NO                                     35590000
MFA-TR*            ,:HT-ADDRESS-ID                                      35610000
MFA-TR*            ,:HT-PREMISE-NO                                      35620000
MFA-TR*            ,:HT-CONTACT-ID                                      35651000
MFA-TR*            ,:HT-CUSTOMER-ROLE-CD                                35640000
MFA-TR*            ,:HT-STATE                                           35650000
MFA-TR*            ,:HT-TOWN                                            35660000
MFA-TR*            ,:HT-LOCAL-OFFICE                                    35670000
MFA-TR*         FROM CSS_NAME_ACCT_XREF                                         
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*         QUERYNO 7828                                                    
MFA-TR*    END-EXEC.                                                    35680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29307                                                                  
C29307     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C29307                                                                  
C29307     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -811           
C29307        NEXT SENTENCE                                             
C29307     ELSE                                                         
C29307        MOVE 'CSS_NAME_ACCT_XREF'       TO CMN-TABLE-1            
C29307        MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
C29307        MOVE HT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
C29307        PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
C29307     END-IF.                                                      
C29307                                                                  
C29307 7828-EXIT.                                                       
C29307     EXIT.                                                        
C29307                                                                  
C29307******************************************************************35280000
C29307* 7829-INSERT-NAME-ACCT-XREF.                                    *35290000
C29307*                                                                *35510000
C29307*                                                                *35510000
C29307******************************************************************35380000
C29307 7829-INSERT-NAME-ACCT-XREF.                                      
C29307                                                                  
C29307     MOVE '7829'                       TO ACTIVE-PARAGRAPH.       
C29307                                                                  
C29307     EXEC SQL                                                     
C29307        INSERT INTO CSS_NAME_ACCT_XREF                            
C29307              (NAME_ID                                            
C29307              ,COMPANY_NO                                         
C29307              ,CUSTOMER_NO                                        
C29307              ,ACCOUNT_NO                                         
C29307              ,ADDRESS_ID                                         
C29307              ,PREMISE_NO                                         
C29307              ,CONTACT_ID                                         
C29307              ,CUSTOMER_ROLE_CD                                   
C29307              ,STATE                                              
C29307              ,TOWN                                               
C29307              ,LOCAL_OFFICE)                                      
C29307         VALUES                                                   
C29307             (:HT-NAME-ID                                         
C29307             ,:HT-COMPANY-NO                                      
C29307             ,:HT-CUSTOMER-NO                                     
C29307             ,:HT-ACCOUNT-NO                                      
C29307             ,:HT-ADDRESS-ID                                      
C29307             ,:HT-PREMISE-NO                                      
C29307             ,:HT-CONTACT-ID                                      
C29307             ,:HT-CUSTOMER-ROLE-CD                                
C29307             ,:HT-STATE                                           
C29307             ,:HT-TOWN                                            
C29307             ,:HT-LOCAL-OFFICE)                                   
C29307     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29307                                                                  
C29307     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C29307                                                                  
C29307     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29307        NEXT SENTENCE                                             
C29307     ELSE                                                         
C29307        MOVE 'CSS_NAME_ACCT_XREF'       TO CMN-TABLE-1            
C29307        MOVE 'NAME_ID'                  TO CMN-TABLE-ELEMENT-1    
C29307        MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-2    
C29307        MOVE HT-NAME-ID                 TO CMN-HOSTVAR-ELEMENT-1  
C29307        MOVE HT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-2  
C29307        PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
C29307     END-IF.                                                      
C29307                                                                  
C29307 7829-EXIT.                                                       
C29307     EXIT.                                                        
C29307                                                                  
                                                                        
      ******************************************************************20800000
      * 7830-INSERT-BILL-ADDR.                                         *20800000
      *                                                                *20800000
      *                                                                *20800000
      ******************************************************************20800000
       7830-INSERT-BILL-ADDR.                                           
                                                                        
           MOVE '7830'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_BILL_ADDR_XREF                           
                  (NAME_ID   ,                                          
                   COMPANY_NO,                                          
                   ACCOUNT_NO,                                          
                   ADDRESS_ID)                                          
               VALUES                                                   
                  (:WS-NEW-NAME-ID,                                     
                   :AT-COMPANY-NO ,                                     
                   :AT-ACCOUNT-NO ,                                     
                   :SI-ADDRESS-ID)                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
T22870     EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CSS_BILL_ADDR_XREF'  TO CMN-TABLE-1            
                   MOVE 'ACCOUNT_NO'          TO CMN-TABLE-ELEMENT-1    
CBSI               MOVE 'NAME_ID'             TO CMN-TABLE-ELEMENT-2    
CBSI               MOVE 'ADDRESS_ID'          TO CMN-TABLE-ELEMENT-3    
CBSI               MOVE 'COMPANY_NO'          TO CMN-TABLE-ELEMENT-4    
                   MOVE AT-ACCOUNT-NO         TO CMN-HOSTVAR-ELEMENT-1  
CBSI               MOVE WS-NEW-NAME-ID        TO CMN-HOSTVAR-ELEMENT-2  
CBSI               MOVE SI-ADDRESS-ID         TO CMN-HOSTVAR-ELEMENT-3  
CBSI               MOVE AT-COMPANY-NO         TO CMN-HOSTVAR-ELEMENT-4  
CBSI               PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT        
           END-EVALUATE.                                                
                                                                        
       7830-EXIT.                                                       
           EXIT.                                                        
                                                                        
T22870 7831-DELETE-BILL-ADDR.                                           
T22870                                                                  
T22870     MOVE '7831'                       TO ACTIVE-PARAGRAPH.       
T22870     EXEC SQL                                                     
T22870         DELETE FROM CSS_BILL_ADDR_XREF                           
T22870          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
T22870            AND COMPANY_NO = :AT-COMPANY-NO                       
                                                            
T22870     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_BILL_ADDR_XREF                                   
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND COMPANY_NO = :AT-COMPANY-NO                               
MFA-TR*         QUERYNO 7831                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22870     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T22870     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T22870        CONTINUE                                                  
T22870     ELSE                                                         
T22870        MOVE 'CSS_BILL_ADDR_XREF'       TO CMN-TABLE-1            
T22870        MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
T22870        MOVE 'COMPANY_NO'               TO CMN-TABLE-ELEMENT-2    
T22870        MOVE AT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
T22870        MOVE AT-COMPANY-NO              TO CMN-HOSTVAR-ELEMENT-2  
T22870        PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
T22870     END-IF.                                                      
T22870                                                                  
T22870 7831-EXIT.                                                       
T22870     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************20800000
      * 7835-INSERT-BILL-NAME.                                         *20800000
      *                                                                *20800000
      *                                                                *20800000
      ******************************************************************20800000
       7835-INSERT-BILL-NAME.                                           
                                                                        
           MOVE '7835'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ACCT_BILL_NMES                           
                  (ACCOUNT_NO,                                          
                   NAME_TYPE ,                                          
                   NAME_ID)                                             
               VALUES                                                   
                  (:AT-ACCOUNT-NO,                                      
                   'AN'          ,                                      
                   :WS-NEW-NAME-ID)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
T20855                                ALREADY-EXISTS                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_ACCT_BILL_NMES'       TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
CBSI          MOVE 'NAME_ID'                  TO CMN-TABLE-ELEMENT-2    
              MOVE AT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
CBSI          MOVE WS-NEW-NAME-ID             TO CMN-HOSTVAR-ELEMENT-2  
CBSI          PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       7835-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00471*****************************************************************         
P00471* 7850-CHECK-DPP-DROP-EXEMPT.                                   *         
P00471*****************************************************************         
P00471*                                                                         
P00471 7850-CHECK-DPP-DROP-EXEMPT.                                      
P00471*                                                                         
P00471     MOVE '7850'                       TO ACTIVE-PARAGRAPH.       
P00471     EXEC SQL                                                     
P00471        SELECT ATTRIBUTE_VALUE_CD                                 
P00471          INTO :WS-ATTRIBUTE-VALUE-CD                             
P00471          FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
P00471         WHERE YP.ACCOUNT_NO          = :YP-ACCOUNT-NO            
P00471           AND YP.ATTRIBUTE_DESC      ='AUTODPPDRPEXEMPIND'       
P00471           AND STATUS_CD              ='A'                        
P00471                                                           
P00471                                                      
P00471     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ATTRIBUTE_VALUE_CD                                         
MFA-TR*         INTO :WS-ATTRIBUTE-VALUE-CD                                     
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                                      
MFA-TR*        WHERE YP.ACCOUNT_NO          = :YP-ACCOUNT-NO                    
MFA-TR*          AND YP.ATTRIBUTE_DESC      ='AUTODPPDRPEXEMPIND'               
MFA-TR*          AND STATUS_CD              ='A'                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7850                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00471*                                                                         
P00471     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00471                                                                  
P00471     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00471        CONTINUE                                                  
P00471     ELSE                                                         
P00471        MOVE 'CSS_ACCT_ATTRIBUTE'       TO CMN-TABLE-1            
P00471        MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
P00471        MOVE 'ATTRIBUTE_DESC'           TO CMN-TABLE-ELEMENT-2    
P00471        MOVE YP-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
P00471        MOVE 'AUTODPPDRPEXEMPIND'       TO CMN-HOSTVAR-ELEMENT-2  
P00471        PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
P00471     END-IF.                                                      
P00471*                                                                         
P00471 7850-EXIT.                                                       
P00471     EXIT.                                                        
P00471*                                                                         
                                                                        
      ******************************************************************20800000
      * 7900-CHECK-NO-DAYS.                                            *20800000
      *                                                                *20800000
      *                                                                *20800000
      ******************************************************************20800000
       7900-CHECK-NO-DAYS.                                              
                                                                        
           MOVE '7900'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              SELECT CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                  :WS-PENDING-ACCT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PENDING-ACCT-DATE
              ) <> 0) OR (LEN(:WS-PENDING-ACCT-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PENDING-ACCT-DATE
              ), CONVERT(DATE, :WS-PENDING-ACCT-DATE) )) -                
                     CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                 :WS-COMPLETED-DATE-USA
              ) IS NULL OR (PATINDEX('%.%', :WS-COMPLETED-DATE-USA
              ) <> 0) OR (LEN(:WS-COMPLETED-DATE-USA
              ) <> 10), CIS.CHAR2DATE(:WS-COMPLETED-DATE-USA
              ), CONVERT(DATE, :WS-COMPLETED-DATE-USA) ))                 
                INTO :WS-NO-OF-DAYS                                     
                FROM CSS_MODEL_SQL                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     27640000
MFA-TR*       SELECT DAYS(DATE(:WS-PENDING-ACCT-DATE)) -                        
MFA-TR*              DAYS(DATE(:WS-COMPLETED-DATE-USA))                         
MFA-TR*         INTO :WS-NO-OF-DAYS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         QUERYNO 7900                                                    
MFA-TR*    END-EXEC.                                                    27760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_MODEL_SQL'            TO CMN-TABLE-1            
CBSI          MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE CMN-ACCOUNT-NO            TO CMN-HOSTVAR-ELEMENT-1   
CBSI          PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************20800000
      * 7910-MOVE-DATE.                                                *20800000
      *                                                                *20800000
      *                                                                *20800000
      ******************************************************************20800000
       7910-MOVE-DATE.                                                  
                                                                        
           MOVE CMN-HOLD-COMPLETED-DATE(7:4)  TO WS-DATETIME-YEAR.      
           MOVE CMN-HOLD-COMPLETED-DATE(1:2)  TO WS-DATETIME-MONTH.     
           MOVE CMN-HOLD-COMPLETED-DATE(4:2)  TO WS-DATETIME-DAY.       
           MOVE CMN-HOLD-COMPLETED-TIME(1:2)  TO WS-DATETIME-HOUR.      
           MOVE CMN-HOLD-COMPLETED-TIME(4:2)  TO WS-DATETIME-MIN.       
                                                                        
T20068     PERFORM 7911-COUNT-CUST-PREM       THRU 7911-EXIT.           
T20068*                                                                         
T20068     IF WS-DAY-HIST-CTR > 10                                      
T20068        MOVE WS-DAY-HIST-CTR            TO WS-DATETIME-MS         
T20068     ELSE                                                         
T20068        MOVE WS-DAY-HIST-CTR            TO WS-DATETIME-MS2        
T20068     END-IF.                                                      
T20068                                                                  
           MOVE WS-DATETIME-FORMAT            TO AT-ACCT-CREATE-DT.     
                                                                        
           PERFORM 7920-UPDATE-AT-CREATE-DT   THRU 7920-EXIT.           
                                                                        
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
T20068******************************************************************20800000
T20068* 7911-COUNT-CUST-PREM                                           *20800000
T20068*                                                                *20800000
T20068*                                                                *20800000
T20068******************************************************************20800000
T20068 7911-COUNT-CUST-PREM.                                            
T20068                                                                  
T20068     MOVE '7911'                        TO ACTIVE-PARAGRAPH.      
T20068                                                                  
T20068     EXEC SQL                                                     
T20068         SELECT COUNT(*)                                          
T20068           INTO :WS-DAY-HIST-CTR                                  
T20068           FROM CSS_CUST_PREM_HIST                                
T20068          WHERE PREMISE_NO         = :AT-PREMISE-NO               
T20068            AND DATE_UTIL_SVC_STRT = IIF(TRY_CONVERT(DATE, 
                                                :WS-HOLD-COMPLETED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-COMPLETED-DATE
              ) <> 0) OR (LEN(:WS-HOLD-COMPLETED-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-HOLD-COMPLETED-DATE
              ), CONVERT(DATE, :WS-HOLD-COMPLETED-DATE) )      
                                                            
T20068     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-DAY-HIST-CTR                                          
MFA-TR*          FROM CSS_CUST_PREM_HIST                                        
MFA-TR*         WHERE PREMISE_NO         = :AT-PREMISE-NO                       
MFA-TR*           AND DATE_UTIL_SVC_STRT = :WS-HOLD-COMPLETED-DATE              
MFA-TR*         QUERYNO 7911                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20068                                                                  
T20068     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T20068                                                                  
T20068     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T20068        NEXT SENTENCE                                             
T20068     ELSE                                                         
T20068        MOVE 'CSS_CUST_PREM_HIST'      TO CMN-TABLE-1             
T20068        MOVE 'DATE_UTIL_SVC_STRT'      TO CMN-TABLE-ELEMENT-2     
T20068        MOVE 'PREMISE_NO'              TO CMN-TABLE-ELEMENT-1     
T20068        MOVE AT-PREMISE-NO             TO CMN-HOSTVAR-ELEMENT-1   
T20068        MOVE WS-HOLD-COMPLETED-DATE    TO CMN-HOSTVAR-ELEMENT-2   
T20068        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
T20068     END-IF.                                                      
T20068                                                                  
T20068 7911-EXIT.                                                       
T20068     EXIT.                                                        
                                                                        
      *****************************************************************         
T18326* 7915-UPDATE-PREMHIST.                                         *         
T18326*                                                               *         
T18326*                                                               *         
T18326*****************************************************************         
T18326 7915-UPDATE-PREMHIST.                                            
T18326                                                                  
T18326     MOVE '7915'                        TO ACTIVE-PARAGRAPH.      
T18326                                                                  
T18326     EXEC SQL                                                     
T18326         UPDATE CSS_CUST_PREM_HIST                                
T18326            SET DATE_UTIL_SVC_END = IIF(TRY_CONVERT(DATE, 
                                                   :WS-REVISED-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REVISED-END-DATE
              ) <> 0) OR (LEN(:WS-REVISED-END-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-REVISED-END-DATE
              ), CONVERT(DATE, :WS-REVISED-END-DATE) )          
T18326          WHERE PREMISE_NO     = :CH-PREMISE-NO                   
T18326            AND DATE_UTIL_SVC_END > IIF(TRY_CONVERT(DATE, 
                                                   :WS-REVISED-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REVISED-END-DATE
              ) <> 0) OR (LEN(:WS-REVISED-END-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-REVISED-END-DATE
              ), CONVERT(DATE, :WS-REVISED-END-DATE) )          
                                                            
T18326     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUST_PREM_HIST                                        
MFA-TR*           SET DATE_UTIL_SVC_END = :WS-REVISED-END-DATE                  
MFA-TR*         WHERE PREMISE_NO     = :CH-PREMISE-NO                           
MFA-TR*           AND DATE_UTIL_SVC_END > :WS-REVISED-END-DATE                  
MFA-TR*         QUERYNO 7915                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18326                                                                  
T18326     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T18326                                                                  
T18326     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T18326        NEXT SENTENCE                                             
T18326     ELSE                                                         
T18326        MOVE 'CSS_CUST_PREM_HIST'      TO CMN-TABLE-1             
T18326        MOVE 'PREMISE_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'DATE_UTIL_SVC_END'       TO CMN-TABLE-ELEMENT-2     
CBSI          MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-3     
T18326        MOVE CH-PREMISE-NO             TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE WS-REVISED-END-DATE       TO CMN-HOSTVAR-ELEMENT-2   
CBSI          MOVE CMN-ACCOUNT-NO            TO CMN-HOSTVAR-ELEMENT-3   
T18326        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
T18326     END-IF.                                                      
T18326                                                                  
T18326 7915-EXIT.                                                       
T18326     EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 7920-UPDATE-AT-CREATE-DT.                                     *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
       7920-UPDATE-AT-CREATE-DT.                                        
                                                                        
           MOVE '7920'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET ACCT_CREATE_DT = CIS.CHAR2TIMESTAMP(
                                                     :AT-ACCT-CREATE-DT
              )               
                WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET ACCT_CREATE_DT = :AT-ACCT-CREATE-DT                       
MFA-TR*         WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO                            
MFA-TR*         QUERYNO 7920                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'ACCT_CREATE_DT'          TO CMN-TABLE-ELEMENT-2     
              MOVE WS-AT-ACCOUNT-NO          TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE AT-ACCT-CREATE-DT         TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
T17380* 7930-SET-ELEC-FLAG                                             *        
      *                                                                *        
      *     CHECK TO SEE IF THERE IS ELEC AT THIS ACCOUNT              *        
      *                                                                *        
      ******************************************************************        
       7930-SET-ELEC-FLAG.                                              
                                                                        
           MOVE '7930'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-ELEC-FOUND                                    
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'E'                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ELEC-FOUND                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*         QUERYNO 7930                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                   OR MULTIPLE-ROWS-SELECTED                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_MTRD_ENVRNMT'        TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
              MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7930-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
T17380* 7935-SET-GAS-FLAG                                              *        
      *                                                                *        
      *     CHECK TO SEE IF THERE IS GAS AT THIS ACCOUNT               *        
      *                                                                *        
      ******************************************************************        
       7935-SET-GAS-FLAG.                                               
                                                                        
           MOVE '7935'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-GAS-FOUND                                     
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'G'                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-GAS-FOUND                                             
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*         QUERYNO 7935                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                   OR MULTIPLE-ROWS-SELECTED                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_MTRD_ENVRNMT'        TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
              MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7935-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
T17380* 7940-GET-RECONNECT-CHARGE                                      *        
      *                                                                *        
      *     GET RECONNECT CHARGE FROM CSS_RECONNECT_CHRG               *        
      *                                                                *        
      ******************************************************************        
       7940-GET-RECONNECT-CHARGE.                                       
                                                                        
           MOVE '7940'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) U7.RCNCT_TYPE_NO,
              U7.RCNCT_TYPE_TX,
              U7.RCNCT_CHRG_AM,
              [3T].RCNCT_TERM_ID                                  
                 INTO :U7-RCNCT-TYPE-NO,                                
                      :U7-RCNCT-TYPE-TX,                                
                      :U7-RCNCT-CHRG-AM,                                
P00726                :3T-RCNCT-TERM-ID                                 
P00726           FROM CSS_RECONNECT_CHRG U7 WITH(READUNCOMMITTED)               
P00726               ,CSS_RECONNECT_TERM [3T] WITH(READUNCOMMITTED)             
P00726          WHERE U7.COMPANY_NO         = :AT-COMPANY-NO            
P00726            AND U7.RCNCT_ELEC_SVC_FL  = :WS-ELEC-FOUND            
P00726            AND U7.RCNCT_GAS_SVC_FL   = :WS-GAS-FOUND             
P00726            AND U7.RCNCT_NRML_HRS_FL  = :WS-NRML-HRS-FLAG         
P00726            AND U7.RCNCT_ACCT_TYPE_CD = :WS-ACCT-TYPE-CODE        
P00726            AND [3T].RCNCT_ACCT_TYPE_CD = U7.RCNCT_ACCT_TYPE_CD     
P00726            AND [3T].RCNCT_TYPE_NO      = U7.RCNCT_TYPE_NO          
P00726            AND [3T].COMPANY_NO         = U7.COMPANY_NO             
P00726            AND [3T].RCNCT_SAME_DAY_FL  = 'Y'                       
P00726            AND [3T].RCNCT_TERM_EFF_DT <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)              
P00726            AND [3T].RCNCT_TERM_EXP_DT >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)              
P00726            ORDER BY [3T].RCNCT_TERM_ID                             
P00726                                            
P00726                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT U7.RCNCT_TYPE_NO,                                         
MFA-TR*               U7.RCNCT_TYPE_TX,                                         
MFA-TR*               U7.RCNCT_CHRG_AM,                                         
MFA-TR*               3T.RCNCT_TERM_ID                                          
MFA-TR*          INTO :U7-RCNCT-TYPE-NO,                                        
MFA-TR*               :U7-RCNCT-TYPE-TX,                                        
MFA-TR*               :U7-RCNCT-CHRG-AM,                                        
MFA-TR*               :3T-RCNCT-TERM-ID                                         
MFA-TR*          FROM CSS_RECONNECT_CHRG U7                                     
MFA-TR*              ,CSS_RECONNECT_TERM 3T                                     
MFA-TR*         WHERE U7.COMPANY_NO         = :AT-COMPANY-NO                    
MFA-TR*           AND U7.RCNCT_ELEC_SVC_FL  = :WS-ELEC-FOUND                    
MFA-TR*           AND U7.RCNCT_GAS_SVC_FL   = :WS-GAS-FOUND                     
MFA-TR*           AND U7.RCNCT_NRML_HRS_FL  = :WS-NRML-HRS-FLAG                 
MFA-TR*           AND U7.RCNCT_ACCT_TYPE_CD = :WS-ACCT-TYPE-CODE                
MFA-TR*           AND 3T.RCNCT_ACCT_TYPE_CD = U7.RCNCT_ACCT_TYPE_CD             
MFA-TR*           AND 3T.RCNCT_TYPE_NO      = U7.RCNCT_TYPE_NO                  
MFA-TR*           AND 3T.COMPANY_NO         = U7.COMPANY_NO                     
MFA-TR*           AND 3T.RCNCT_SAME_DAY_FL  = 'Y'                               
MFA-TR*           AND 3T.RCNCT_TERM_EFF_DT <= CURRENT DATE                      
MFA-TR*           AND 3T.RCNCT_TERM_EXP_DT >= CURRENT DATE                      
MFA-TR*           ORDER BY 3T.RCNCT_TERM_ID                                     
MFA-TR*           FETCH FIRST 1 ROW ONLY                                        
MFA-TR*           WITH UR                                                       
MFA-TR*         QUERYNO 7940                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
P00726     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_RECONNECT_CHRG'      TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
              MOVE 'RCNCT_ELEC_SVC_FL'       TO CMN-TABLE-ELEMENT-2     
              MOVE 'RCNCT_GAS_SVC_FL'        TO CMN-TABLE-ELEMENT-3     
              MOVE 'RCNCT_NRML_HRS_FL'       TO CMN-TABLE-ELEMENT-4     
              MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
              MOVE WS-ELEC-FOUND             TO CMN-HOSTVAR-ELEMENT-2   
              MOVE WS-GAS-FOUND              TO CMN-HOSTVAR-ELEMENT-3   
              MOVE WS-NRML-HRS-FLAG          TO CMN-HOSTVAR-ELEMENT-4   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00581 7945-GET-JOB-PARM.                                               
P00581     MOVE '7945'                        TO ACTIVE-PARAGRAPH.      
P00581        EXEC SQL                                                  
P00581           SELECT  PARM_DATA                                      
P00581           INTO    :G6-PARM-DATA                                  
P00581           FROM    CSS_JOB_PARM                                   
P00581           WHERE   PROGRAM_NAME = :G6-PROGRAM-NAME                
P00581             AND   COMPANY_NO = :AT-COMPANY-NO                    
P00581             AND   CMND_CODE  = 'PARM'                            
P00581             AND   STATUS     = 'A'                               
P00581                                                      
P00581        END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT  PARM_DATA                                              
MFA-TR*          INTO    :G6-PARM-DATA                                          
MFA-TR*          FROM    CSS_JOB_PARM                                           
MFA-TR*          WHERE   PROGRAM_NAME = :G6-PROGRAM-NAME                        
MFA-TR*            AND   COMPANY_NO = :AT-COMPANY-NO                            
MFA-TR*            AND   CMND_CODE  = 'PARM'                                    
MFA-TR*            AND   STATUS     = 'A'                                       
MFA-TR*         QUERYNO 7945                                                    
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00581     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00581        NEXT SENTENCE                                             
P00581     ELSE                                                         
P00581        MOVE 'CSS_JOB_PARM'            TO CMN-TABLE-1             
P00581        MOVE 'PROGRAM NAME'            TO CMN-TABLE-ELEMENT-1     
P00581        MOVE G6-PROGRAM-NAME           TO CMN-HOSTVAR-ELEMENT-1   
P00581        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
P00581     END-IF.                                                      
P00581 7945-EXIT.                                                       
P00581     EXIT.                                                        
P00581                                                                  
T23513 7950-GET-DELINQ-VALUE.                                           
T23513     MOVE '7950'                        TO ACTIVE-PARAGRAPH.      
T23513        EXEC SQL                                                  
T23513           SELECT  DELINQ_VALUE                                   
T23513           INTO    :C8-DELINQ-VALUE                               
T23513           FROM    CSS_DELINQUENCY                                
T23513           WHERE   DELINQ_CD  = :C8-DELINQ-CD                     
T23501             AND   COMPANY_NO = :AT-COMPANY-NO                    
                                                            
T23513        END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT  DELINQ_VALUE                                           
MFA-TR*          INTO    :C8-DELINQ-VALUE                                       
MFA-TR*          FROM    CSS_DELINQUENCY                                        
MFA-TR*          WHERE   DELINQ_CD  = :C8-DELINQ-CD                             
MFA-TR*            AND   COMPANY_NO = :AT-COMPANY-NO                            
MFA-TR*         QUERYNO 7950                                                    
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23513     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T23513     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T23513        NEXT SENTENCE                                             
T23513     ELSE                                                         
T23513        MOVE 'CSS_DELINQUENCY'         TO CMN-TABLE-1             
T23513        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
T23513     END-IF.                                                      
T23513 7950-EXIT.                                                       
T23513     EXIT.                                                        
                                                                        
      ******************************************************************        
P00581* 7955-GET-REV-MTH                                               *        
P00581*                                                                *        
P00581*     GETS START REVENUE EFFECTIVE MONTH FROM CSS_ACCT_RTPK_AGR  *        
P00581*                                                                *        
P00581******************************************************************        
P00581 7955-GET-REV-MTH.                                                
P00581                                                                  
P00581     MOVE '7955'                        TO ACTIVE-PARAGRAPH.      
P00581                                                                  
P00581     EXEC SQL                                                     
P00581         SELECT DF.OPT_AGRMT_EFF_DT                               
P00581               ,F1.OPT_CALC_TYPE_CD                               
P00581          INTO :WS-OPT-EFF-DT                                     
P00581              ,:WS-SEB-RATE-TYPE                                  
P00581         FROM CSS_ACCT_RTPK_AGR DF                                
P00581             ,CSS_UTIL_ENVRNMT UT                                 
P00581             ,CRM_RT_PKG_OPTION F1                                
P00581         WHERE UT.ACCOUNT_NO = DF.ACCOUNT_NO                      
P00581           AND UT.CODE_UTIL_TYPE = DF.CODE_UTIL_TYPE              
P00581           AND DF.IC_NO = UT.IC_NO                                
P00581           AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO        
P00581           AND F1.OPTION_CD = DF.OPTION_CD                        
P00473           AND F1.OPT_VSTART_TS <= CIS.CURRENT$TIMESTAMP()              
P00473           AND F1.OPT_VEND_TS   >= CIS.CURRENT$TIMESTAMP()              
P00473           AND F1.PROC_STATUS_CD = 'AC'                           
P00581           AND UT.ACCOUNT_NO = :UT-ACCOUNT-NO                     
P00581                                                      
P00581     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DF.OPT_AGRMT_EFF_DT                                       
MFA-TR*              ,F1.OPT_CALC_TYPE_CD                                       
MFA-TR*         INTO :WS-OPT-EFF-DT                                             
MFA-TR*             ,:WS-SEB-RATE-TYPE                                          
MFA-TR*        FROM CSS_ACCT_RTPK_AGR DF                                        
MFA-TR*            ,CSS_UTIL_ENVRNMT UT                                         
MFA-TR*            ,CRM_RT_PKG_OPTION F1                                        
MFA-TR*        WHERE UT.ACCOUNT_NO = DF.ACCOUNT_NO                              
MFA-TR*          AND UT.CODE_UTIL_TYPE = DF.CODE_UTIL_TYPE                      
MFA-TR*          AND DF.IC_NO = UT.IC_NO                                        
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO                
MFA-TR*          AND F1.OPTION_CD = DF.OPTION_CD                                
MFA-TR*          AND F1.OPT_VSTART_TS <= CURRENT TIMESTAMP                      
MFA-TR*          AND F1.OPT_VEND_TS   >= CURRENT TIMESTAMP                      
MFA-TR*          AND F1.PROC_STATUS_CD = 'AC'                                   
MFA-TR*          AND UT.ACCOUNT_NO = :UT-ACCOUNT-NO                             
MFA-TR*        QUERYNO 7955                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581                                                                  
P00581     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00581                                                                  
P00581     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00581        NEXT SENTENCE                                             
P00581     ELSE                                                         
P00581        MOVE 'CSS_ACCT_RTPK_AGR'       TO CMN-TABLE-1             
P00581        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
P00581        MOVE UT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
P00581        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
P00581     END-IF.                                                      
P00581                                                                  
P00581 7955-EXIT.                                                       
P00581     EXIT.                                                        
                                                                        
T22829                                                                  
T22829*****************************************************************         
T22829* 7960-SELECT-MARKET-XREF.                                      *         
T22829*****************************************************************         
T22829 7960-SELECT-MARKET-XREF.                                         
T22829                                                                  
T22829     MOVE '7960'                        TO ACTIVE-PARAGRAPH.      
T22829                                                                  
T22829     EXEC SQL                                                     
T22829         SELECT ACCOUNT_NO,                                       
T22829                COMPANY_NO,                                       
T22829                AFF_COMPANY_NO,                                   
T22829                ORIG_DIST_ACCT_NO,                                
T22829                DIST_ACCT_NO,                                     
T22829                DIST_COMPANY_NO,                                  
T22829                MKT_POOL_GRP,                                     
T22829                RATE_SCHEDULE,                                    
T22829                ORIGINATION_CD,                                   
T22829                SIGN_UP_STATUS_CD                                 
T22829           INTO :XM-ACCOUNT-NO,                                   
T22829                :XM-COMPANY-NO,                                   
T22829                :XM-AFF-COMPANY-NO,                               
T22829                :XM-ORIG-DIST-ACCT-NO,                            
T22829                :XM-DIST-ACCT-NO,                                 
T22829                :XM-DIST-COMPANY-NO,                              
T22829                :XM-MKT-POOL-GRP,                                 
T22829                :XM-RATE-SCHEDULE,                                
T22829                :XM-ORIGINATION-CD,                               
T22829                :XM-SIGN-UP-STATUS-CD :WS-NULL-IND-X               
T22829           FROM CSS_MKT_XREF_ACCT                                 
T22829           WHERE ACCOUNT_NO = :XM-ACCOUNT-NO                      
                                                            
T22829     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               AFF_COMPANY_NO,                                           
MFA-TR*               ORIG_DIST_ACCT_NO,                                        
MFA-TR*               DIST_ACCT_NO,                                             
MFA-TR*               DIST_COMPANY_NO,                                          
MFA-TR*               MKT_POOL_GRP,                                             
MFA-TR*               RATE_SCHEDULE,                                            
MFA-TR*               ORIGINATION_CD,                                           
MFA-TR*               SIGN_UP_STATUS_CD                                         
MFA-TR*          INTO :XM-ACCOUNT-NO,                                           
MFA-TR*               :XM-COMPANY-NO,                                           
MFA-TR*               :XM-AFF-COMPANY-NO,                                       
MFA-TR*               :XM-ORIG-DIST-ACCT-NO,                                    
MFA-TR*               :XM-DIST-ACCT-NO,                                         
MFA-TR*               :XM-DIST-COMPANY-NO,                                      
MFA-TR*               :XM-MKT-POOL-GRP,                                         
MFA-TR*               :XM-RATE-SCHEDULE,                                        
MFA-TR*               :XM-ORIGINATION-CD,                                       
MFA-TR*               :XM-SIGN-UP-STATUS-CD:WS-NULL-IND-X                       
MFA-TR*          FROM CSS_MKT_XREF_ACCT                                         
MFA-TR*          WHERE ACCOUNT_NO = :XM-ACCOUNT-NO                              
MFA-TR*         QUERYNO 7960                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22829                                                                  
T22829     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T22829                                                                  
T22829     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22829        NEXT SENTENCE                                             
T22829     ELSE                                                         
T22829        MOVE 'CSS_MKT_XREF_ACCT'       TO CMN-TABLE-1             
T22829        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T22829        MOVE XM-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T22829        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
T22829     END-IF.                                                      
T22829                                                                  
T22829 7960-EXIT.                                                       
T22829     EXIT.                                                        
T22829                                                                  
T22829*****************************************************************         
T22829* 7970-COUNT-MARKET-XREF.                                       *         
T22829*****************************************************************         
T22829 7970-COUNT-MARKET-XREF.                                          
T22829                                                                  
T22829     MOVE '7970'                        TO ACTIVE-PARAGRAPH.      
T22829                                                                  
T22829     EXEC SQL                                                     
T22829         SELECT COUNT(*)                                          
T22829           INTO :WS-COUNT-XREF                                    
T22829           FROM CSS_MKT_XREF_ACCT                                 
T22829           WHERE CIS.SUBSTR3(DIST_ACCT_NO,11,10) = :WS-DIST-ACCT       
T22829             AND CIS.SUBSTR3(DIST_ACCT_NO,1,1) = 'C'                   
                                                            
T22829     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-COUNT-XREF                                            
MFA-TR*          FROM CSS_MKT_XREF_ACCT                                         
MFA-TR*          WHERE SUBSTR(DIST_ACCT_NO,11,10) = :WS-DIST-ACCT               
MFA-TR*            AND SUBSTR(DIST_ACCT_NO,1,1) = 'C'                           
MFA-TR*         QUERYNO 7970                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22829                                                                  
T22829     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T22829                                                                  
T22829     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22829        NEXT SENTENCE                                             
T22829     ELSE                                                         
T22829        MOVE 'CSS_MKT_XREF_ACCT'       TO CMN-TABLE-1             
T22829        MOVE 'DIST_ACCT_NO'            TO CMN-TABLE-ELEMENT-1     
T22829        MOVE XM-DIST-ACCT-NO           TO CMN-HOSTVAR-ELEMENT-1   
T22829        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
T22829     END-IF.                                                      
T22829                                                                  
T22829 7970-EXIT.                                                       
T22829     EXIT.                                                        
T22829                                                                  
T22829*****************************************************************         
T22829* 7980-UPDATE-MARKET-XREF.                                      *         
T22829*****************************************************************         
T22829 7980-UPDATE-MARKET-XREF.                                         
T22829                                                                  
T22829     MOVE '7980'                        TO ACTIVE-PARAGRAPH.      
T22829                                                                  
T22829     EXEC SQL                                                     
T22829         UPDATE CSS_MKT_XREF_ACCT                                 
T22829            SET DIST_ACCT_NO = :XM-DIST-ACCT-NO                   
T22829           WHERE ACCOUNT_NO = :XM-ACCOUNT-NO                      
                                                            
T22829     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MKT_XREF_ACCT                                         
MFA-TR*           SET DIST_ACCT_NO = :XM-DIST-ACCT-NO                           
MFA-TR*          WHERE ACCOUNT_NO = :XM-ACCOUNT-NO                              
MFA-TR*         QUERYNO 7980                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22829                                                                  
T22829     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T22829                                                                  
T22829     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22829        NEXT SENTENCE                                             
T22829     ELSE                                                         
T22829        MOVE 'CSS_MKT_XREF_ACCT'       TO CMN-TABLE-1             
T22829        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T22829        MOVE XM-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T22829        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
T22829     END-IF.                                                      
T22829                                                                  
T22829 7980-EXIT.                                                       
T22829     EXIT.                                                        
                                                                        
T22829*****************************************************************         
T22829* 7990-INSERT-MARKET-XREF.                                      *         
T22829*****************************************************************         
T22829 7990-INSERT-MARKET-XREF.                                         
T22829                                                                  
T22829     MOVE '7990'                        TO ACTIVE-PARAGRAPH.      
T22829                                                                  
T22829     EXEC SQL                                                     
T22829         INSERT INTO CSS_MKT_XREF_ACCT                            
T22829                  (ACCOUNT_NO,                                    
T22829                   COMPANY_NO,                                    
T22829                   AFF_COMPANY_NO,                                
T22829                   ORIG_DIST_ACCT_NO,                             
T22829                   DIST_ACCT_NO,                                  
T22829                   DIST_COMPANY_NO,                               
T22829                   MKT_POOL_GRP,                                  
T22829                   RATE_SCHEDULE,                                 
T22829                   ORIGINATION_CD,                                
T22829                   SIGN_UP_STATUS_CD)                             
T22829         VALUES(:XM-ACCOUNT-NO,                                   
T22829                :XM-COMPANY-NO,                                   
T22829                :XM-AFF-COMPANY-NO,                               
T22829                :XM-ORIG-DIST-ACCT-NO,                            
T22829                :XM-DIST-ACCT-NO,                                 
T22829                :XM-DIST-COMPANY-NO,                              
T22829                :XM-MKT-POOL-GRP,                                 
T22829                :XM-RATE-SCHEDULE,                                
T22829                :XM-ORIGINATION-CD,                               
T22829                :XM-SIGN-UP-STATUS-CD  )                          
T22829     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22829                                                                  
T22829     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T22829                                                                  
T22829     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22829        NEXT SENTENCE                                             
T22829     ELSE                                                         
T22829        MOVE 'CSS_MKT_XREF_ACCT'       TO CMN-TABLE-1             
T22829        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T22829        MOVE XM-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T22829        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
T22829     END-IF.                                                      
T22829                                                                  
T22829 7990-EXIT.                                                       
T22829     EXIT.                                                        
                                                                        
P00677*****************************************************************         
P00677* 7995-INSERT-REG-PROFILE.                                      *         
P00677*  CALLED FROM 5600-SEB-OC                                      *         
P00677*****************************************************************         
P00677 7995-INSERT-REG-PROFILE.                                         
P00677                                                                  
P00677     MOVE '7995'                        TO ACTIVE-PARAGRAPH.      
P00677     MOVE CMN-ACCOUNT-NO-NEW            TO LR-ACCOUNT-NO.         
P00677                                                                  
P00677     EXEC SQL                                                     
P00677         INSERT INTO CSS_REG_PROFILE                              
P00677                  (ACCOUNT_NO,                                    
P00677                   CUSTOMER_NO,                                   
P00677                   PREMISE_NO,                                    
P00677                   GROUP_EFF_TS,                                  
P00677                   REG_GROUP_CD,                                  
P00677                   SENIOR_FL,                                     
P00677                   LAST_UPDATE_TS)                                
P00677         VALUES(:LR-ACCOUNT-NO,                                   
P00677                :LR-CUSTOMER-NO,                                  
P00677                :LR-PREMISE-NO,                                   
P00677                CIS.CHAR2TIMESTAMP(:LR-GROUP-EFF-TS),                     
P00677                :LR-REG-GROUP-CD,                                 
P00677                :LR-SENIOR-FL,                                    
P00677                CIS.CURRENT$TIMESTAMP())                                
P00677     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_REG_PROFILE                                      
MFA-TR*                 (ACCOUNT_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  GROUP_EFF_TS,                                          
MFA-TR*                  REG_GROUP_CD,                                          
MFA-TR*                  SENIOR_FL,                                             
MFA-TR*                  LAST_UPDATE_TS)                                        
MFA-TR*        VALUES(:LR-ACCOUNT-NO,                                           
MFA-TR*               :LR-CUSTOMER-NO,                                          
MFA-TR*               :LR-PREMISE-NO,                                           
MFA-TR*               :LR-GROUP-EFF-TS,                                         
MFA-TR*               :LR-REG-GROUP-CD,                                         
MFA-TR*               :LR-SENIOR-FL,                                            
MFA-TR*               CURRENT TIMESTAMP)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00677                                                                  
P00677     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00677                                                                  
P00677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00677        NEXT SENTENCE                                             
P00677     ELSE                                                         
P00677        MOVE 'CSS_REG_PROFILE'         TO CMN-TABLE-1             
P00677        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
P00677        MOVE CMN-ACCOUNT-NO-NEW        TO CMN-HOSTVAR-ELEMENT-1   
P00677        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
P00677     END-IF.                                                      
P00677                                                                  
P00677 7995-EXIT.                                                       
P00677     EXIT.                                                        
                                                                        
P00677*****************************************************************         
P00677* 7996-UPDATE-REG-PROFILE.                                      *         
P00677*  CALLED FROM 5600-SEB-OC                                      *         
P00677*****************************************************************         
P00677 7996-UPDATE-REG-PROFILE.                                         
P00677                                                                  
P00677     MOVE '7996'                        TO ACTIVE-PARAGRAPH.      
P00677     MOVE CMN-ACCOUNT-NO-NEW            TO LR-ACCOUNT-NO.         
P00677                                                                  
P00677     EXEC SQL                                                     
P00677         UPDATE CSS_REG_PROFILE                                   
P00677           SET  CUSTOMER_NO    = :LR-CUSTOMER-NO,                 
P00677                PREMISE_NO     = :LR-PREMISE-NO,                  
P00677                GROUP_EFF_TS   = CIS.CHAR2TIMESTAMP(
                                                       :LR-GROUP-EFF-TS
              ),                
P00677                REG_GROUP_CD   = :LR-REG-GROUP-CD,                
P00677                SENIOR_FL      = :LR-SENIOR-FL,                   
P00677                LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()                
P00677           WHERE ACCOUNT_NO    = :LR-ACCOUNT-NO                   
P00677                                                      
P00677     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_REG_PROFILE                                           
MFA-TR*          SET  CUSTOMER_NO    = :LR-CUSTOMER-NO,                         
MFA-TR*               PREMISE_NO     = :LR-PREMISE-NO,                          
MFA-TR*               GROUP_EFF_TS   = :LR-GROUP-EFF-TS,                        
MFA-TR*               REG_GROUP_CD   = :LR-REG-GROUP-CD,                        
MFA-TR*               SENIOR_FL      = :LR-SENIOR-FL,                           
MFA-TR*               LAST_UPDATE_TS = CURRENT TIMESTAMP                        
MFA-TR*          WHERE ACCOUNT_NO    = :LR-ACCOUNT-NO                           
MFA-TR*          QUERYNO 7996                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00677                                                                  
P00677     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00677                                                                  
P00677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00677        NEXT SENTENCE                                             
P00677     ELSE                                                         
P00677        MOVE 'CSS_REG_PROFILE'         TO CMN-TABLE-1             
P00677        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
P00677        MOVE CMN-ACCOUNT-NO-NEW        TO CMN-HOSTVAR-ELEMENT-1   
P00677        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
P00677     END-IF.                                                      
P00677                                                                  
P00677 7996-EXIT.                                                       
P00677     EXIT.                                                        
                                                                        
P00677*****************************************************************         
P00677* 7998-INSERT-AGL-SENIOR-ATTR.                                  *         
P00677*  CALLED FROM 5600-SEB-OC                                      *         
P00677*****************************************************************         
P00677 7998-INSERT-AGL-SENIOR-ATTR.                                     
P00677                                                                  
P00677     MOVE '7998'                    TO ACTIVE-PARAGRAPH.          
P00677     MOVE CMN-ACCOUNT-NO-NEW        TO YP-ACCOUNT-NO.             
P00677     MOVE 'AGL DISCOUNT SR'         TO YP-ATTRIBUTE-DESC.         
P00677     MOVE 'YES'                     TO YP-ATTRIBUTE-VALUE-CD.     
P00677     MOVE ' '                       TO YP-ATTRIBUTE-VALUE-TX-TEXT.
P00677     MOVE 1                         TO YP-ATTRIBUTE-VALUE-TX-LEN. 
P00677     MOVE WS-AGL-SENIOR-STATUS      TO YP-STATUS-CD.              
P00677                                                                  
P00677     EXEC SQL                                                     
P00677        INSERT INTO CSS_ACCT_ATTRIBUTE                            
P00677               (ACCOUNT_NO        ,                               
P00677                ATTRIBUTE_DESC    ,                               
P00677                ATTRIBUTE_VALUE_CD,                               
P00677                ATTRIBUTE_VALUE_DT,                               
P00677                ATTRIBUTE_VALUE_TX,                               
P00677                CREATED_TS        ,                               
P00677                STATUS_CD )                                       
P00677        VALUES                                                    
P00677               (:YP-ACCOUNT-NO        ,                           
P00677                :YP-ATTRIBUTE-DESC    ,                           
P00677                :YP-ATTRIBUTE-VALUE-CD,                           
P00677                CAST(SYSDATETIMEOFFSET() AS DATE)          ,              
P00677                :YP-ATTRIBUTE-VALUE-TX,                           
P00677                CIS.CURRENT$TIMESTAMP()     ,                           
P00677                :YP-STATUS-CD)                                    
P00677     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_ATTRIBUTE                            01720001
MFA-TR*              (ACCOUNT_NO        ,                                       
MFA-TR*               ATTRIBUTE_DESC    ,                                       
MFA-TR*               ATTRIBUTE_VALUE_CD,                                       
MFA-TR*               ATTRIBUTE_VALUE_DT,                                       
MFA-TR*               ATTRIBUTE_VALUE_TX,                                       
MFA-TR*               CREATED_TS        ,                                       
MFA-TR*               STATUS_CD )                                               
MFA-TR*       VALUES                                                            
MFA-TR*              (:YP-ACCOUNT-NO        ,                                   
MFA-TR*               :YP-ATTRIBUTE-DESC    ,                                   
MFA-TR*               :YP-ATTRIBUTE-VALUE-CD,                                   
MFA-TR*               CURRENT DATE          ,                                   
MFA-TR*               :YP-ATTRIBUTE-VALUE-TX,                                   
MFA-TR*               CURRENT TIMESTAMP     ,                                   
MFA-TR*               :YP-STATUS-CD)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00677                                                                  
P00677     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00677                                                                  
P00677     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00677        CONTINUE                                                  
P00677     ELSE                                                         
P00677        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00677        MOVE '7998'                TO ACTIVE-PARAGRAPH            
P00677        MOVE 'INSERT'              TO ABEND-FUNCTION              
P00677        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
P00677        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00677        MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00677        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00677        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00677     END-IF.                                                      
P00677                                                                  
P00677 7998-EXIT.                                                       
P00677     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8300-UPDATE-CSS-CUSTOMER.                                     *         
      *                                                               *         
      *    UPDATE A ROW IN THE TABLE CSS_CUSTOMER.                    *         
      *    PERFORMED BY 5200-PROCESS-ACCT-DATA.                       *         
      *    PERFORMS     9990-SQL-ERROR-ROUTINE.                       *         
      *****************************************************************         
       8300-UPDATE-CSS-CUSTOMER.                                        
                                                                        
           MOVE '8300'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUSTOMER                                      
                  SET SERVICE_EST_DATE = IIF(TRY_CONVERT(DATE, 
                                                   :CU-SERVICE-EST-DATE
              ) IS NULL OR (PATINDEX('%.%', :CU-SERVICE-EST-DATE
              ) <> 0) OR (LEN(:CU-SERVICE-EST-DATE
              ) <> 10), CIS.CHAR2DATE(:CU-SERVICE-EST-DATE
              ), CONVERT(DATE, :CU-SERVICE-EST-DATE) ),          
                      LAST_UPDATE_TS   = CIS.CURRENT$TIMESTAMP()              
T5172           WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUSTOMER                                              
MFA-TR*           SET SERVICE_EST_DATE = :CU-SERVICE-EST-DATE,                  
MFA-TR*               LAST_UPDATE_TS   = CURRENT TIMESTAMP                      
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*         QUERYNO 8300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_CUSTOMER'            TO CMN-TABLE-1             
T5172         MOVE 'CUSTOMER_NO'             TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'SERVICE_EST_DATE'        TO CMN-TABLE-ELEMENT-2     
CBSI          MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-3     
T5172         MOVE CU-CUSTOMER-NO            TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE CU-SERVICE-EST-DATE       TO CMN-HOSTVAR-ELEMENT-2   
CBSI          MOVE CMN-ACCOUNT-NO            TO CMN-HOSTVAR-ELEMENT-3   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8310-UPDATE-CSS-ACCOUNT.                                      *         
      *                                                               *         
      *    UPDATE THE CODE ACCOUNT STATUS AND THE CODE STATUS REASON  *         
      *    IN THE CSS_ACCOUNT TABLE.                                  *         
      *    PERFORMED BY 5200-PROCESS-ACCT-UPDATES.                    *         
      *    PERFORMS     9990-SQL-ERROR-ROUTINE.                       *         
      *****************************************************************         
       8310-UPDATE-CSS-ACCOUNT.                                         
                                                                        
           MOVE '8310'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODE_ACCT_STAT     = :AT-CODE-ACCT-STAT    ,      
                      CODE_STATUS_REASON = :AT-CODE-STATUS-REASON,      
                      LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()     ,      
                      CREDIT_GROUP       = :AT-CREDIT-GROUP      ,      
                      BILL_HIST_XFER_IND = :AT-BILL-HIST-XFER-IND,      
                      PRINT_TYPE_CD      = :AT-PRINT-TYPE-CD     ,      
                      CODE_PERM_BILL     = :AT-CODE-PERM-BILL           
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET CODE_ACCT_STAT     = :AT-CODE-ACCT-STAT    ,              
MFA-TR*               CODE_STATUS_REASON = :AT-CODE-STATUS-REASON,              
MFA-TR*               LAST_UPDATE_TS     = CURRENT TIMESTAMP     ,              
MFA-TR*               CREDIT_GROUP       = :AT-CREDIT-GROUP      ,              
MFA-TR*               BILL_HIST_XFER_IND = :AT-BILL-HIST-XFER-IND,              
MFA-TR*               PRINT_TYPE_CD      = :AT-PRINT-TYPE-CD     ,              
MFA-TR*               CODE_PERM_BILL     = :AT-CODE-PERM-BILL                   
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 8310                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
T5172         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'CODE_ACCT_STAT'          TO CMN-TABLE-ELEMENT-2     
CBSI          MOVE 'CODE_STATUS_REASON'      TO CMN-TABLE-ELEMENT-3     
CBSI          MOVE 'CREDIT_GROUP'            TO CMN-TABLE-ELEMENT-4     
T5172         MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE AT-CODE-ACCT-STAT         TO CMN-HOSTVAR-ELEMENT-2   
CBSI          MOVE AT-CODE-STATUS-REASON     TO CMN-HOSTVAR-ELEMENT-3   
CBSI          MOVE AT-CREDIT-GROUP           TO CMN-HOSTVAR-ELEMENT-4   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8310-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8311-UPDATE-MST-CODES.                                        *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
       8311-UPDATE-MST-CODES.                                           
                                                                        
           MOVE '8311'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
T17110            SET ACCT_XFER_TO       = :WS-ACCT-XFER-TO      ,      
                      MST_SUB_ACCT_IND   = :WS-MST-SUB-ACCT-IND  ,      
                      AR_XFER_IND        = :AT-AR-XFER-IND              
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET ACCT_XFER_TO       = :WS-ACCT-XFER-TO      ,              
MFA-TR*               MST_SUB_ACCT_IND   = :WS-MST-SUB-ACCT-IND  ,              
MFA-TR*               AR_XFER_IND        = :AT-AR-XFER-IND                      
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 8311                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'ACCT_XFER_TO'            TO CMN-TABLE-ELEMENT-2     
CBSI          MOVE 'MST_SUB_ACCT_IND'        TO CMN-TABLE-ELEMENT-3     
CBSI          MOVE 'AR_XFER_IND'             TO CMN-TABLE-ELEMENT-4     
              MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE WS-ACCT-XFER-TO           TO CMN-HOSTVAR-ELEMENT-2   
CBSI          MOVE WS-MST-SUB-ACCT-IND       TO CMN-HOSTVAR-ELEMENT-3   
CBSI          MOVE AT-AR-XFER-IND            TO CMN-HOSTVAR-ELEMENT-4   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8311-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8312-UPDATE-XFER-IND.                                         *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
       8312-UPDATE-XFER-IND.                                            
                                                                        
           MOVE '8312'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
T17110            SET AR_XFER_IND = :AT-AR-XFER-IND                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET AR_XFER_IND = :AT-AR-XFER-IND                             
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 8312                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'AR_XFER_IND'             TO CMN-TABLE-ELEMENT-2     
              MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE AT-AR-XFER-IND            TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8312-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8315-UPDATE-CUST-PLAN                                         *         
      *                                                               *         
      *    UPDATE THE LAST_BILL_DATE OF ALL CUST PLAN ROWS FOR THE   *          
      *    PENDING ACCOUNT TO THE COMPLETED DATE.                     *         
      *                                                               *         
      *****************************************************************         
       8315-UPDATE-CUST-PLAN.                                           
                                                                        
           MOVE '8315'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUST_PLAN                                     
                  SET DATE_PLAN_START = IIF(TRY_CONVERT(DATE, 
                                                :WS-HOLD-COMPLETED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-COMPLETED-DATE
              ) <> 0) OR (LEN(:WS-HOLD-COMPLETED-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-HOLD-COMPLETED-DATE
              ), CONVERT(DATE, :WS-HOLD-COMPLETED-DATE) ),        
C33254                LAST_BILL_DATE  = IIF(TRY_CONVERT(DATE, 
                                                :WS-HOLD-COMPLETED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-COMPLETED-DATE
              ) <> 0) OR (LEN(:WS-HOLD-COMPLETED-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-HOLD-COMPLETED-DATE
              ), CONVERT(DATE, :WS-HOLD-COMPLETED-DATE) )         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUST_PLAN                                             
MFA-TR*           SET DATE_PLAN_START = :WS-HOLD-COMPLETED-DATE,                
MFA-TR*               LAST_BILL_DATE  = :WS-HOLD-COMPLETED-DATE                 
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 8315                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_CUST_PLAN'           TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'LAST_BILL_DATE'          TO CMN-TABLE-ELEMENT-2     
              MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE WS-HOLD-COMPLETED-DATE    TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8315-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8320-UPDATE-BANKRUPTCY-IND                                    *         
      *                                                               *         
      *    UPDATE THE BANKRUPTCY INDICATOR ON THE CSS_ACCOUNT TABLE   *         
      *    ACCORDING TO THE ORDER TYPE AND ORDER REASON.              *         
      *    IF THE ORDER TYPE IS "NC" OR "CC" AND THE ORDER REASON IS  *         
      *    'B' THEN SET THE INDICATOR TO 'B' FOR THE PRIOR ACCOUNT    *         
      *    NUMBER.  WHEN THE ORDER TYPE IS "OFF" AND THE ORDER REASON *         
      *    IS 'B' THEN SET THE INDICATOR TO 'B' FOR THE NORMAL ACCOUNT*         
      *    NUMBER.  ALSO, THE ACCOUNT STATUS REASON WILL BE SET TO 'E'*         
      *    (BANKRUPT).                                                *         
      *****************************************************************         
       8320-UPDATE-BANKRUPTCY-IND.                                      
                                                                        
           MOVE '8320'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET BANKRUPTCY_IND     = :AT-BANKRUPTCY-IND,          
                      CODE_STATUS_REASON = 'E',                         
A02499                CODE_PERM_BILL     = 'B',                         
A02499                NO_BILL_COPIES     = 0                            
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET BANKRUPTCY_IND     = :AT-BANKRUPTCY-IND,                  
MFA-TR*               CODE_STATUS_REASON = 'E',                                 
MFA-TR*               CODE_PERM_BILL     = 'B',                                 
MFA-TR*               NO_BILL_COPIES     = 0                                    
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 8320                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
T5172         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'BANKRUPTCY_IND'          TO CMN-TABLE-ELEMENT-2     
T5172         MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE AT-BANKRUPTCY-IND         TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8320-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8325-UPDATE-PREM-DNP-FLAG.                                    *         
      *                                                               *         
      *    UPDATE THE SERV_ORDER_PEND FLAG ON THE CSS_PREMISE TABLE   *         
      *    WITH BLANKS WHEN THE ACCOUNT HAS ONLY 1 PENDING DNP ORDER. *         
      *****************************************************************         
       8325-UPDATE-PREM-DNP-FLAG.                                       
                                                                        
           MOVE '8325'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET SERV_ORDER_PEND = ''                              
                WHERE PREMISE_NO      = :CH-PREMISE-NO                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PREMISE                                               
MFA-TR*           SET SERV_ORDER_PEND = ''                                      
MFA-TR*         WHERE PREMISE_NO      = :CH-PREMISE-NO                          
MFA-TR*         QUERYNO 8325                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_PREMISE'             TO CMN-TABLE-1             
T5172         MOVE 'PREMISE_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-2     
T5172         MOVE CH-PREMISE-NO             TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE CMN-ACCOUNT-NO            TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8325-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8326-UPDATE-PREM-OFF-DATE.                                    *         
      *                                                               *         
      *    UPDATE THE SERV_ORDER_PEND FLAG ON THE CSS_PREMISE TABLE   *         
      *    WITH BLANKS WHEN THE ACCOUNT HAS ONLY 1 PENDING DNP ORDER. *         
      *****************************************************************         
       8326-UPDATE-PREM-OFF-DATE.                                       
                                                                        
           MOVE '8326'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           IF WS-SO-OFF-DATE > SPACES                                   
              MOVE 0                          TO WS-NULL-VALUE          
           ELSE                                                         
              MOVE -1                         TO WS-NULL-VALUE          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET PEND_OFF_ORD_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-SO-OFF-DATE 
                                                         :WS-NULL-VALUE
              ) IS NULL OR (PATINDEX('%.%', :WS-SO-OFF-DATE 
                                                         :WS-NULL-VALUE
              ) <> 0) OR (LEN(:WS-SO-OFF-DATE :WS-NULL-VALUE
              ) <> 10), CIS.CHAR2DATE(:WS-SO-OFF-DATE :WS-NULL-VALUE
              ), CONVERT(DATE, :WS-SO-OFF-DATE :WS-NULL-VALUE) )   
                WHERE PREMISE_NO      = :CH-PREMISE-NO                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PREMISE                                               
MFA-TR*           SET PEND_OFF_ORD_DT = :WS-SO-OFF-DATE:WS-NULL-VALUE           
MFA-TR*         WHERE PREMISE_NO      = :CH-PREMISE-NO                          
MFA-TR*         QUERYNO 8326                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_PREMISE'             TO CMN-TABLE-1             
              MOVE 'PREMISE_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-2     
              MOVE CH-PREMISE-NO             TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE CMN-ACCOUNT-NO            TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8326-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8330-UPDATE-CUST-PREM-HIST.                                   *         
      *                                                               *         
      *    UPDATE THE DATE SERVICE END IN THE CSS_CUST_PREM_HIST TABLE*         
      *    PERFORMED BY 5200-PROCESS-ACCT-UPDATES.                    *         
      *    PERFORMS     9990-SQL-ERROR-ROUTINE.                       *         
      *****************************************************************         
       8330-UPDATE-CUST-PREM-HIST.                                      
                                                                        
           MOVE '8330'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUST_PREM_HIST                                
                  SET DATE_UTIL_SVC_END = IIF(TRY_CONVERT(DATE, 
                                                  :CH-DATE-UTIL-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :CH-DATE-UTIL-SVC-END
              ) <> 0) OR (LEN(:CH-DATE-UTIL-SVC-END
              ) <> 10), CIS.CHAR2DATE(:CH-DATE-UTIL-SVC-END
              ), CONVERT(DATE, :CH-DATE-UTIL-SVC-END) )         
                WHERE ACCOUNT_NO        = :CH-ACCOUNT-NO                
                  AND PREMISE_NO        = :CH-PREMISE-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUST_PREM_HIST                                        
MFA-TR*           SET DATE_UTIL_SVC_END = :CH-DATE-UTIL-SVC-END                 
MFA-TR*         WHERE ACCOUNT_NO        = :CH-ACCOUNT-NO                        
MFA-TR*           AND PREMISE_NO        = :CH-PREMISE-NO                        
MFA-TR*         QUERYNO 8330                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_CUST_PREM_HIST'      TO CMN-TABLE-1             
T5172         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T5172         MOVE 'PREMISE_NO'              TO CMN-TABLE-ELEMENT-2     
CBSI          MOVE 'DATE_UTIL_SVC_END'       TO CMN-TABLE-ELEMENT-3     
T5172         MOVE CH-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T5172         MOVE CH-PREMISE-NO             TO CMN-HOSTVAR-ELEMENT-2   
CBSI          MOVE CH-DATE-UTIL-SVC-END      TO CMN-HOSTVAR-ELEMENT-3   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8330-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8331-INSERT-CUST-PREM-HIST.                                   *         
      *                                                               *         
      *     INSERTS A ROW INTO THE CSS_CUST_PREM_HIST TABLE FOR THE   *         
      *     GIVEN ACCOUNT NUMBER.                                     *         
      *****************************************************************         
       8331-INSERT-CUST-PREM-HIST.                                      
                                                                        
           MOVE '8331'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CUST_PREM_HIST                           
                      (PREMISE_NO        ,                              
                       ACCOUNT_NO        ,                              
                       DATE_UTIL_SVC_STRT,                              
                       DATE_UTIL_SVC_END ,                              
                       CUSTOMER_NO)                                     
                   VALUES                                               
                      (:CH-PREMISE-NO        ,                          
                       :CH-ACCOUNT-NO        ,                          
                       IIF(TRY_CONVERT(DATE, :CH-DATE-UTIL-SVC-STRT
              ) IS NULL OR (PATINDEX('%.%', :CH-DATE-UTIL-SVC-STRT
              ) <> 0) OR (LEN(:CH-DATE-UTIL-SVC-STRT
              ) <> 10), CIS.CHAR2DATE(:CH-DATE-UTIL-SVC-STRT
              ), CONVERT(DATE, :CH-DATE-UTIL-SVC-STRT) ),                      
                       IIF(TRY_CONVERT(DATE, :CH-DATE-UTIL-SVC-END 
                                             :WS-NULL-VALUE
              ) IS NULL OR (PATINDEX('%.%', :CH-DATE-UTIL-SVC-END 
                                                         :WS-NULL-VALUE
              ) <> 0) OR (LEN(:CH-DATE-UTIL-SVC-END :WS-NULL-VALUE
              ) <> 10), CIS.CHAR2DATE(:CH-DATE-UTIL-SVC-END 
                                                         :WS-NULL-VALUE
              ), CONVERT(DATE, :CH-DATE-UTIL-SVC-END :WS-NULL-VALUE) ),        
                       :AT-CUSTOMER-NO)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CUST_PREM_HIST                                   
MFA-TR*               (PREMISE_NO        ,                                      
MFA-TR*                ACCOUNT_NO        ,                                      
MFA-TR*                DATE_UTIL_SVC_STRT,                                      
MFA-TR*                DATE_UTIL_SVC_END ,                                      
MFA-TR*                CUSTOMER_NO)                                             
MFA-TR*            VALUES                                                       
MFA-TR*               (:CH-PREMISE-NO        ,                                  
MFA-TR*                :CH-ACCOUNT-NO        ,                                  
MFA-TR*                :CH-DATE-UTIL-SVC-STRT,                                  
MFA-TR*                :CH-DATE-UTIL-SVC-END:WS-NULL-VALUE,                     
MFA-TR*                :AT-CUSTOMER-NO)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_CUST_PREM_HIST'       TO CMN-TABLE-1            
T5172         MOVE 'PREMISE_NO'               TO CMN-TABLE-ELEMENT-1    
T5172         MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-2    
T5172         MOVE 'CUSTOMER_NO'              TO CMN-TABLE-ELEMENT-3    
CBSI          MOVE 'DATE_UTIL_SVC_STRT'       TO CMN-TABLE-ELEMENT-4    
T5172         MOVE CH-PREMISE-NO              TO CMN-HOSTVAR-ELEMENT-1  
T5172         MOVE CH-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-2  
T5172         MOVE AT-CUSTOMER-NO             TO CMN-HOSTVAR-ELEMENT-3  
CBSI          MOVE CH-DATE-UTIL-SVC-STRT      TO CMN-HOSTVAR-ELEMENT-4  
              PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       8331-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8400-SEARCH-FOR-RCC.                                           *        
      *                                                                *        
      *     CHECK TO SEE IF THERE IS A RCC FOR THIS ACCOUNT.           *        
      *                                                                *        
      ******************************************************************        
       8400-SEARCH-FOR-RCC.                                             
                                                                        
           MOVE '8400'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-RCC-FOUND                                     
                 FROM CSS_RECONNECT                                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-RCC-FOUND                                             
MFA-TR*          FROM CSS_RECONNECT                                             
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 8400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_RECONNECT'           TO CMN-TABLE-1             
T5172         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T5172         MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8410-DELETE-RCC.                                               *        
      *                                                                *        
      *     DELETE THE RECONNECT ROW FROM THE CSS_RECONNECT TABLE FOR  *        
      *     THE GIVEN ACCOUNT.                                         *        
      ******************************************************************        
       8410-DELETE-RCC.                                                 
                                                                        
           MOVE '8410'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_RECONNECT                                
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_RECONNECT                                        
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 8410                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_RECONNECT'           TO CMN-TABLE-1             
T5172         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T5172         MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8420-UPDATE-CODES-DATA-PRES.                                  *         
      *                                                               *         
      *     UPDATE THE CODES DATA PRESENT COLUMN ON CSS_ACCOUNT.      *         
      *                                                               *         
      *****************************************************************         
       8420-UPDATE-CODES-DATA-PRES.                                     
                                                                        
           MOVE '8420'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT       
                WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT               
MFA-TR*         WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                       
MFA-TR*         QUERYNO 8420                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
T5172         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T5172         MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
T21448*****************************************************************         
T21448* 8425-UPDATE-HIST-XFER.                                        *         
T21448*                                                               *         
T21448*     UPDATE THE BILL HIST XFER FLAG ON CSS_ACCOUNT.            *         
T21448*                                                               *         
T21448*****************************************************************         
T21448 8425-UPDATE-HIST-XFER.                                           
T21448                                                                  
T21448     MOVE '8425'                        TO ACTIVE-PARAGRAPH.      
T21448                                                                  
T21448     EXEC SQL                                                     
T21448         UPDATE CSS_ACCOUNT                                       
T21448            SET BILL_HIST_XFER_IND = 'Y'                          
T21448          WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO               
                                                            
T21448     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET BILL_HIST_XFER_IND = 'Y'                                  
MFA-TR*         WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                       
MFA-TR*         QUERYNO 8425                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21448                                                                  
T21448     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T21448                                                                  
T21448     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21448        NEXT SENTENCE                                             
T21448     ELSE                                                         
T21448        MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
T21448        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T21448        MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T21448        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
T21448     END-IF.                                                      
T21448                                                                  
T21448 8425-EXIT.                                                       
T21448     EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8430-UPDATE-AT-STATUS-REASON.                                 *         
      *                                                               *         
      *     UPDATE THE ACCOUNT STATUS REASON ON CSS_ACCOUNT.          *         
      *                                                               *         
      *****************************************************************         
       8430-UPDATE-AT-STATUS-REASON.                                    
                                                                        
           MOVE '8430'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODE_STATUS_REASON = 'D'                          
                WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET CODE_STATUS_REASON = 'D'                                  
MFA-TR*         WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                       
MFA-TR*         QUERYNO 8430                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
              MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8430-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8450-GET-CREDIT-PROFILE.                                      *         
      *                                                               *         
      *     GET THE DISCONNECT HISTORY AND DISCONNECT EXCEPTION       *         
      *     HISTORY COLUMNS FOR THE ACCOUNT.                          *         
      *****************************************************************         
       8450-GET-CREDIT-PROFILE.                                         
                                                                        
           MOVE '8450'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT DISCONNECT_HIST,                                  
                      DISC_EXCEPTN_HIST                                 
                 INTO :CZ-DISCONNECT-HIST,                              
                      :CZ-DISC-EXCEPTN-HIST                             
                 FROM CSS_CREDIT_PROFILE                                
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISCONNECT_HIST,                                          
MFA-TR*               DISC_EXCEPTN_HIST                                         
MFA-TR*          INTO :CZ-DISCONNECT-HIST,                                      
MFA-TR*               :CZ-DISC-EXCEPTN-HIST                                     
MFA-TR*          FROM CSS_CREDIT_PROFILE                                        
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 8450                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_CREDIT_PROFILE'      TO CMN-TABLE-1             
T5172         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T5172         MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8460-UPDATE-CREDIT-PROFILE.                                   *         
      *                                                               *         
      *     UPDATE THE DISCONNECT HISTORY AND THE DISCONNECT EXCEPTION*         
      *     HISTORY COLUMNS IN THE CREDIT PROFILE TABLE FOR THE       *         
      *     ACCOUNT.                                                  *         
      *****************************************************************         
       8460-UPDATE-CREDIT-PROFILE.                                      
                                                                        
           MOVE '8460'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CREDIT_PROFILE                                
                  SET DISCONNECT_HIST   = :CZ-DISCONNECT-HIST,          
                      DISC_EXCEPTN_HIST = :CZ-DISC-EXCEPTN-HIST         
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CREDIT_PROFILE                                        
MFA-TR*           SET DISCONNECT_HIST   = :CZ-DISCONNECT-HIST,                  
MFA-TR*               DISC_EXCEPTN_HIST = :CZ-DISC-EXCEPTN-HIST                 
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*         QUERYNO 8460                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T5172         MOVE 'CSS_CREDIT_PROFILE'      TO CMN-TABLE-1             
T5172         MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'DISCONNECT_HIST'         TO CMN-TABLE-ELEMENT-2     
CBSI          MOVE 'DISC_EXCEPTN_HIST'       TO CMN-TABLE-ELEMENT-3     
T5172         MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE CZ-DISCONNECT-HIST        TO CMN-HOSTVAR-ELEMENT-2   
CBSI          MOVE CZ-DISC-EXCEPTN-HIST      TO CMN-HOSTVAR-ELEMENT-3   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8460-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8500-SET-ACCT-TYPE-CODE.                                      *         
      *                                                               *         
      *     UPDATE THE ACCOUNT TYPE CODE ON CSS_ACCOUNT.              *         
      *                                                               *         
      *****************************************************************         
       8500-SET-ACCT-TYPE-CODE.                                         
                                                                        
           MOVE '8500'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE CMN-ACCOUNT-TYPE-CODE         TO AT-ACCOUNT-TYPE-CODE.  
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE         
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE                 
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*         QUERYNO 8500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_ACCOUNT'             TO CMN-TABLE-1             
              MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
CBSI          MOVE 'ACCOUNT_TYPE_CODE'       TO CMN-TABLE-ELEMENT-2     
              MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
CBSI          MOVE AT-ACCOUNT-TYPE-CODE      TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8510-DELETE-SUB-LIGHTING.                                     *         
      *                                                               *         
      *     DELETE SUBDIVISION LIGHTING ROW FROM CSS_UTIL_ENVRNMT     *         
      *     AND CSS_CUST_PLAN                                         *         
      *****************************************************************         
T28065 8510-DELETE-SUB-LIGHTING.                                        
T28065                                                                  
T28065     MOVE '8510'                        TO ACTIVE-PARAGRAPH.      
T28065                                                                  
T28065     EXEC SQL                                                     
T28065        SELECT IC_NO                                              
T28065          INTO :UT-IC-NO                                          
T28065          FROM CSS_UTIL_ENVRNMT                                   
T28065        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
T28065          AND CODE_UTIL_TYPE = 'U'                                
T28065          AND RATE_PLAN_NO = '064'                                
                                                            
T28065     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IC_NO                                                      
MFA-TR*         INTO :UT-IC-NO                                                  
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*         AND CODE_UTIL_TYPE = 'U'                                        
MFA-TR*         AND RATE_PLAN_NO = '064'                                        
MFA-TR*       QUERYNO 8510                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T28065        MOVE 'CSS_UTIL_ENVRNMT'        TO CMN-TABLE-1             
T28065        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T28065        MOVE 'IC_NO'                   TO CMN-TABLE-ELEMENT-2     
T28065        MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T28065        MOVE UT-IC-NO                  TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
                                                                        
T28065     PERFORM 8520-DELETE-CUST-PLAN      THRU 8520-EXIT.           
T28065     PERFORM 8530-DELETE-UTIL-ENVRNMT   THRU 8530-EXIT.           
T28065     PERFORM 8540-CHECK-FOR-LIGHTING-ROWS THRU 8540-EXIT.         
                                                                        
       8510-EXIT.                                                       
           EXIT.                                                        
                                                                        
T28065*****************************************************************         
T28065* 8520-DELETE-CUST-PLAN.                                        *         
T28065*                                                               *         
T28065*    DELETE SUBDIVSION LIGHTING ROW FROM CSS_CUST_PLAN.         *         
T28065*                                                               *         
T28065*****************************************************************         
       8520-DELETE-CUST-PLAN.                                           
                                                                        
T28065     MOVE '8520'                    TO ACTIVE-PARAGRAPH.          
                                                                        
T28065     EXEC SQL                                                     
T28065        DELETE FROM CSS_CUST_PLAN                                 
T28065             WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                    
T28065               AND CODE_UTIL_TYPE = 'U'                           
T28065               AND IC_NO = :UT-IC-NO                              
                                                            
T28065     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_PLAN                                         
MFA-TR*            WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*              AND CODE_UTIL_TYPE = 'U'                                   
MFA-TR*              AND IC_NO = :UT-IC-NO                                      
MFA-TR*       QUERYNO 8520                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T28065        MOVE 'CSS_CUST_PLAN'           TO CMN-TABLE-1             
T28065        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T28065        MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T28065        MOVE 'IC_NO'                   TO CMN-TABLE-ELEMENT-2     
T28065        MOVE UT-IC-NO                  TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
T28065 8520-EXIT.                                                       
T28065     EXIT.                                                        
                                                                        
T28065*****************************************************************         
T28065* 8530-DELETE-UTIL-ENVRNMT.                                     *         
T28065*                                                               *         
T28065*    DELETE SUBDIVSION LIGHTING ROW FROM CSS_UTIL_ENVRNMT.      *         
T28065*                                                               *         
T28065*****************************************************************         
       8530-DELETE-UTIL-ENVRNMT.                                        
                                                                        
T28065     MOVE '8530'                    TO ACTIVE-PARAGRAPH.          
                                                                        
T28065     EXEC SQL                                                     
T28065        DELETE FROM CSS_UTIL_ENVRNMT                              
T28065             WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                    
T28065               AND CODE_UTIL_TYPE = 'U'                           
T28065               AND IC_NO = :UT-IC-NO                              
T28065               AND RATE_PLAN_NO = '064'                           
                                                            
T28065     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_UTIL_ENVRNMT                                      
MFA-TR*            WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*              AND CODE_UTIL_TYPE = 'U'                                   
MFA-TR*              AND IC_NO = :UT-IC-NO                                      
MFA-TR*              AND RATE_PLAN_NO = '064'                                   
MFA-TR*       QUERYNO 8530                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T28065        MOVE 'CSS_UTIL_ENVRNMT'        TO CMN-TABLE-1             
T28065        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T28065        MOVE UT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
T28065        MOVE 'IC_NO'                   TO CMN-TABLE-ELEMENT-2     
T28065        MOVE UT-IC-NO                  TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8530-EXIT.                                                       
           EXIT.                                                        
                                                                        
T28065*****************************************************************         
T28065* 8540-CHECK-FOR-LIGHTING-ROWS.                                 *         
T28065*                                                               *         
T28065*    CHECKS FOR ADDITIONAL LIGHTING ROWS IN CSS_UTIL-ENVRNMT.   *         
T28065*                                                               *         
T28065*****************************************************************         
       8540-CHECK-FOR-LIGHTING-ROWS.                                    
                                                                        
T28065     MOVE '8540'                    TO ACTIVE-PARAGRAPH.          
                                                                        
T28065     EXEC SQL                                                     
T28065         SELECT COUNT(*)                                          
T28065           INTO :WS-LR-EXISTS                                     
T28065           FROM CSS_UTIL_ENVRNMT                                  
T28065          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
T28065            AND CODE_UTIL_TYPE = 'U'                              
T28065            AND RATE_PLAN_NO NOT IN ('064')                       
                                                            
T28065     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-LR-EXISTS                                             
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = 'U'                                      
MFA-TR*           AND RATE_PLAN_NO NOT IN ('064')                               
MFA-TR*       QUERYNO 8540                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T28065        MOVE 'CSS_UTIL_ENVRNMT'        TO CMN-TABLE-1             
T28065        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-1     
T28065        MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
T28065     IF WS-LR-EXISTS > 0                                          
T28065        NEXT SENTENCE                                             
T28065     ELSE                                                         
T28065        PERFORM 8550-UPDATE-PREMISE THRU 8550-EXIT                
T28065     END-IF.                                                      
                                                                        
       8540-EXIT.                                                       
           EXIT.                                                        
                                                                        
T28065*****************************************************************         
T28065* 8550-UPDATE-PREMISE.                                          *         
T28065*                                                               *         
T28065*    UPDATES LITE_AVAILABLE_IND IN CSS_PREMISE.                 *         
T28065*                                                               *         
T28065*****************************************************************         
       8550-UPDATE-PREMISE.                                             
                                                                        
T28065     MOVE '8550'                    TO ACTIVE-PARAGRAPH.          
                                                                        
T28065     EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                 SET LITE_AVAILABLE_IND = 'I'                           
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PREMISE                                               
MFA-TR*          SET LITE_AVAILABLE_IND = 'I'                                   
MFA-TR*         WHERE PREMISE_NO = :AT-PREMISE-NO                               
MFA-TR*       QUERYNO 8550                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T28065        MOVE 'CSS_PREMISE'             TO CMN-TABLE-1             
T28065        MOVE 'PREMISE_NO'              TO CMN-TABLE-ELEMENT-1     
T28065        MOVE AT-PREMISE-NO             TO CMN-HOSTVAR-ELEMENT-1   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8600-INSERT-MST-ACCT.                                         *         
      *                                                               *         
      *    INSERT THE MASTER ACCOUNT INFORMATION.                     *         
      *                                                               *         
      *****************************************************************         
       8600-INSERT-MST-ACCT.                                            
                                                                        
           MOVE '8600'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_MSTSUB_ACCT                               
                 (MST_ACCT_NO     ,                                     
                  SUB_ACCT_NO     ,                                     
                  SUB_ACCT_BLLD_OK)                                     
              VALUES                                                    
                 (:SI-LL-MASTER-ACCT-NO,                                
                  :AT-ACCOUNT-NO       ,                                
T19936            'B')                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
T20031                                ALREADY-EXISTS                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_MSTSUB_ACCT'         TO CMN-TABLE-1             
              MOVE 'MST_ACCT_NO'             TO CMN-TABLE-ELEMENT-1     
              MOVE SI-LL-MASTER-ACCT-NO      TO CMN-HOSTVAR-ELEMENT-1   
              MOVE 'SUB_ACCT_NO'             TO CMN-TABLE-ELEMENT-2     
              MOVE AT-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-2   
              PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
T25243******************************************************************PCS03730
T25243* 8700-UPD-NONUTL-EXCEPT-CREDIT                                  *PCS03750
T25243*                                                                *        
T25243*                                                                *        
T25243*                                                                *        
T25243******************************************************************PCS03780
T25243 8700-UPD-NONUTL-EXCEPT-CREDIT.                                   
T25243                                                                  
T25243     EXEC SQL                                                     
T25243         UPDATE CSS_CREDIT_PROFILE                                
T25243            SET NON_UTL_CR_HST_EX = :CZ-NON-UTL-CR-HST-EX         
T25243          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
T25243     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CREDIT_PROFILE                                        
MFA-TR*           SET NON_UTL_CR_HST_EX = :CZ-NON-UTL-CR-HST-EX                 
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*       QUERYNO 8700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25243                                                                  
T25243     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
T25243                                           RS-RETURN-CODE.        
T25243                                                                  
T25243     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T25243        CONTINUE                                                  
T25243     ELSE                                                         
T25243        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T25243        MOVE '8700'                     TO ACTIVE-PARAGRAPH       
T25243        MOVE 'UPD-NONUTL-EXCEPT-CR'     TO TABLE-1                
T25243        MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-2                
T25243        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T25243        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T25243        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T25243     END-IF.                                                      
T25243                                                                  
T25243 8700-EXIT.                                                       
T25243     EXIT.                                                        
                                                                        
T25243******************************************************************PCS03730
T25243* 8710-UPD-NONUTL-NORMAL-CREDIT                                  *PCS03750
T25243*                                                                *        
T25243*                                                                *        
T25243*                                                                *        
T25243******************************************************************PCS03780
T25243 8710-UPD-NONUTL-NORMAL-CREDIT.                                   
T25243                                                                  
T25243     EXEC SQL                                                     
T25243         UPDATE CSS_CREDIT_PROFILE                                
T25243            SET NON_UTL_CR_HST = :CZ-NON-UTL-CR-HST               
T25243          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
T25243     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CREDIT_PROFILE                                        
MFA-TR*           SET NON_UTL_CR_HST = :CZ-NON-UTL-CR-HST                       
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*       QUERYNO 8710                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25243                                                                  
T25243     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
T25243                                           RS-RETURN-CODE.        
T25243                                                                  
T25243     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T25243        CONTINUE                                                  
T25243     ELSE                                                         
T25243        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T25243        MOVE '8710'                     TO ACTIVE-PARAGRAPH       
T25243        MOVE 'UPD NONUTL NORMAL CR'     TO TABLE-1                
T25243        MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-2                
T25243        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T25243        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T25243        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T25243     END-IF.                                                      
T25243                                                                  
T25243 8710-EXIT.                                                       
T25243     EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************53852000
      * 8800-UPDATE-PREM-STAT.                                         *53860000
      *                                                                *53870000
      *                                                                *53880000
      ******************************************************************53890000
       8800-UPDATE-PREM-STAT.                                           
                                                                        
           MOVE '8800'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET CODE_PREMISE_STAT = 'A'                           
                WHERE PREMISE_NO = :CH-PREMISE-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     53940000
MFA-TR*        UPDATE CSS_PREMISE                                       53950000
MFA-TR*           SET CODE_PREMISE_STAT = 'A'                           53960000
MFA-TR*         WHERE PREMISE_NO = :CH-PREMISE-NO                       53980000
MFA-TR*       QUERYNO 8800                                                      
MFA-TR*    END-EXEC.                                                    53990000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'CSS_PREMISE'              TO CMN-TABLE-1            
              MOVE 'PREMISE_NO'               TO CMN-TABLE-ELEMENT-1    
CBSI          MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-2    
              MOVE CH-PREMISE-NO              TO CMN-HOSTVAR-ELEMENT-1  
CBSI          MOVE CMN-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-2  
CBSI          PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00471                                                                  
P00471******************************************************************26370000
P00471* BATCH JOURNAL ROUTINE. 6400-BATCH-JRNL-ROUTINE.                *26380000
P00471******************************************************************26390000
P00471*                                                                 26400000
P00471     COPY CPD0013B.                                               26410000
P00471*                                                                 26420000
P00471     EXEC SQL                                                     26430000
P00471         INCLUDE CPD0007B                                         26440000
P00471     END-EXEC.                                                    26450000
P00471*                                                                 26460000
P00471     EXEC SQL                                                     26510000
P00471        INCLUDE CPD00008                                          26520000
P00471     END-EXEC.                                                    26530000
P00471*                                                                 26530000
P00471     EXEC SQL                                                     26530000
P00471        INCLUDE CPD0006A                                          26530000
P00471     END-EXEC.                                                    26530000
                                                                        
C30058*                                                                 54140000
ACT102***************************************************************** 10403000
ACT102*    8895-INSERT-WORK-QUEUE.                                      10405000
ACT102***************************************************************** 10407000
ACT102 8895-INSERT-WORK-QUEUE.                                          
                                                                        
ACT102     INITIALIZE   WS-MCSCB077-OUTPUT.                             
ACT102     INITIALIZE   ABEND-FUNCTION.                                 
                                                                        
ACT102     CALL MCSCB077 USING CWS00077-FIELDS,                         
ACT102                         ABEND-FILE,                              
ACT102                         WS-MCSCB077-RET-CODE.                    
                                                                        
ACT102     MOVE WS-MCSCB077-RET-CODE     TO WS-ACTIVE-RETURN-CODE       
ACT102                                                                  
ACT102     IF ABEND-FUNCTION > SPACES OR WS-MCSCB077-RET-CODE NOT = 0   
ACT102        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT102        MOVE '8895'                TO ACTIVE-PARAGRAPH            
ACT102        MOVE 'CALL'                TO ABEND-FUNCTION              
ACT102        MOVE 'MCSCB077'            TO TABLE-1                     
ACT102        MOVE 'CUSTOMER NO'         TO TABLE-ELEMENT-1             
ACT102        MOVE WS-77-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1           
ACT102        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
ACT102     END-IF.                                                      
                                                                        
ACT102 8895-EXIT.                                                       
ACT102      EXIT.                                                       
      *****************************************************************         
T18529* 8920-SEARCH-FOR-RECONNECT                                     *         
      *                                                               *         
      *     SEARCHES FOR RECONNECT AGREEMENT IN CSS_RECONNECT.        *         
      *     IF FOUND, WILL DELETE IT BEFORE INSERTING NEW RECONNECT.  *         
      *                                                               *         
      *****************************************************************         
       8920-SEARCH-FOR-RECONNECT.                                       
                                                                        
           MOVE '8920'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT AMT_TOT_RECONNECT,                                
                      RECNCT_COLLECT_AMT,                               
                      RECNCT_TYPE_CD                                    
               INTO :DL-AMT-TOT-RECONNECT,                              
                    :DL-RECNCT-COLLECT-AMT,                             
                    :DL-RECNCT-TYPE-CD                                  
               FROM CSS_RECONNECT                                       
               WHERE ACCOUNT_NO  =  :AT-ACCOUNT-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AMT_TOT_RECONNECT,                                        
MFA-TR*               RECNCT_COLLECT_AMT,                                       
MFA-TR*               RECNCT_TYPE_CD                                            
MFA-TR*        INTO :DL-AMT-TOT-RECONNECT,                                      
MFA-TR*             :DL-RECNCT-COLLECT-AMT,                                     
MFA-TR*             :DL-RECNCT-TYPE-CD                                          
MFA-TR*        FROM CSS_RECONNECT                                               
MFA-TR*        WHERE ACCOUNT_NO  =  :AT-ACCOUNT-NO                              
MFA-TR*       QUERYNO 8920                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM 8925-DELETE-RECONNECT   THRU 8925-EXIT       
                   PERFORM 8940-DELETE-RCNCT-TRANS-HIST THRU 8940-EXIT  
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CSS_RECONNNECT'      TO CMN-TABLE-1            
                   MOVE 'ACCOUNT_NO'          TO CMN-TABLE-ELEMENT-1    
                   MOVE AT-ACCOUNT-NO         TO CMN-HOSTVAR-ELEMENT-1  
                   PERFORM 9990-SQL-ERROR-ROUTINE   THRU 9990-EXIT      
               END-EVALUATE.                                            
                                                                        
       8920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
T18529* 8925-DELETE-RECONNECT                                         *         
      *                                                               *         
      *     DELETES RECONNECT AGREEMENT FROM  CSS_RECONNECT.          *         
      *                                                               *         
      *****************************************************************         
       8925-DELETE-RECONNECT.                                           
                                                                        
           MOVE '8925'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_RECONNECT                                
               WHERE ACCOUNT_NO  =  :AT-ACCOUNT-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_RECONNECT                                        
MFA-TR*        WHERE ACCOUNT_NO  =  :AT-ACCOUNT-NO                              
MFA-TR*       QUERYNO 8925                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'CSS_RECONNNECT'      TO CMN-TABLE-1                
               MOVE 'ACCOUNT_NO'          TO CMN-TABLE-ELEMENT-1        
               MOVE AT-ACCOUNT-NO         TO CMN-HOSTVAR-ELEMENT-1      
               PERFORM 9990-SQL-ERROR-ROUTINE   THRU 9990-EXIT          
           END-IF.                                                      
                                                                        
       8925-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
T17380* 8930-INSERT-RECONNECT                                         *         
      *                                                               *         
      *     INSERTS A ROW INTO THE CSS_RECONNECT TABLE FOR THE        *         
      *     GIVEN ACCOUNT NUMBER.                                     *         
C26296*     ADD 2 NEW FIELDS TO INSERT FOR AUTO DEP                   *         
      *****************************************************************         
       8930-INSERT-RECONNECT.                                           
                                                                        
           MOVE '8930'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_RECONNECT                                
                      (ACCOUNT_NO            ,                          
                       AGREEMENT_COMMENTS    ,                          
                       AMT_TOT_RECONNECT     ,                          
                       DATETIME_SETUP        ,                          
                       RECNCT_COLLECT_AMT    ,                          
                       RECNCT_NRML_HR_IND    ,                          
                       RECNCT_TYPE_CD        ,                          
                       USER_ID               ,                          
                       AUTO_DEP_CERT_NO      ,                          
                       AUTO_DEP_AM           ,                          
P00726                 RCNCT_TERM_ID         ,                          
P00726                 LAST_UPDATE_TS        ,                          
P00726                 LAST_UPDATE_USERID    ,                          
P00726                 RCC_BILL_OPTION_CD)                              
                   VALUES                                               
                      (:AT-ACCOUNT-NO        ,                          
                       'SYSTEM GENERATED'    ,                          
                       :DL-AMT-TOT-RECONNECT ,                          
                       IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE-061
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE-061
              ) <> 0) OR (LEN(:WS-CURRENT-DATE-061
              ) <> 10), CIS.CHAR2DATE(:WS-CURRENT-DATE-061
              ), CONVERT(DATE, :WS-CURRENT-DATE-061) )  ,                      
                       :U7-RCNCT-CHRG-AM     ,                          
                       :WS-NRML-HRS-FLAG     ,                          
                       :U7-RCNCT-TYPE-NO     ,                          
                       'SYSTEM'              ,                          
                       :DL-AUTO-DEP-CERT-NO  ,                          
                       :DL-AUTO-DEP-AM       ,                          
P00726                 :3T-RCNCT-TERM-ID     ,                          
P00726                 CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS-061)    ,              
P00726                 'SYSTEM'              ,                          
A05317                 :DL-RCC-BILL-OPTION-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_RECONNECT                                        
MFA-TR*               (ACCOUNT_NO            ,                                  
MFA-TR*                AGREEMENT_COMMENTS    ,                                  
MFA-TR*                AMT_TOT_RECONNECT     ,                                  
MFA-TR*                DATETIME_SETUP        ,                                  
MFA-TR*                RECNCT_COLLECT_AMT    ,                                  
MFA-TR*                RECNCT_NRML_HR_IND    ,                                  
MFA-TR*                RECNCT_TYPE_CD        ,                                  
MFA-TR*                USER_ID               ,                                  
MFA-TR*                AUTO_DEP_CERT_NO      ,                                  
MFA-TR*                AUTO_DEP_AM           ,                                  
MFA-TR*                RCNCT_TERM_ID         ,                                  
MFA-TR*                LAST_UPDATE_TS        ,                                  
MFA-TR*                LAST_UPDATE_USERID    ,                                  
MFA-TR*                RCC_BILL_OPTION_CD)                                      
MFA-TR*            VALUES                                                       
MFA-TR*               (:AT-ACCOUNT-NO        ,                                  
MFA-TR*                'SYSTEM GENERATED'    ,                                  
MFA-TR*                :DL-AMT-TOT-RECONNECT ,                                  
MFA-TR*                :WS-CURRENT-DATE-061  ,                                  
MFA-TR*                :U7-RCNCT-CHRG-AM     ,                                  
MFA-TR*                :WS-NRML-HRS-FLAG     ,                                  
MFA-TR*                :U7-RCNCT-TYPE-NO     ,                                  
MFA-TR*                'SYSTEM'              ,                                  
MFA-TR*                :DL-AUTO-DEP-CERT-NO  ,                                  
MFA-TR*                :DL-AUTO-DEP-AM       ,                                  
MFA-TR*                :3T-RCNCT-TERM-ID     ,                                  
MFA-TR*                :WS-CURRENT-TS-061    ,                                  
MFA-TR*                'SYSTEM'              ,                                  
MFA-TR*                :DL-RCC-BILL-OPTION-CD)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_RECONNECT'            TO CMN-TABLE-1            
              MOVE 'ACCOUNT_NO'               TO CMN-TABLE-ELEMENT-1    
CBSI          MOVE 'DATETIME_SETUP'           TO CMN-TABLE-ELEMENT-2    
CBSI          MOVE 'RECNCT_NRML_HR_IND'       TO CMN-TABLE-ELEMENT-3    
CBSI          MOVE 'RECNCT_TYPE_CD'           TO CMN-TABLE-ELEMENT-4    
              MOVE AT-ACCOUNT-NO              TO CMN-HOSTVAR-ELEMENT-1  
CBSI          MOVE WS-CURRENT-DATE-061        TO CMN-HOSTVAR-ELEMENT-2  
CBSI          MOVE WS-NRML-HRS-FLAG           TO CMN-HOSTVAR-ELEMENT-3  
CBSI          MOVE U7-RCNCT-TYPE-NO           TO CMN-HOSTVAR-ELEMENT-4  
              PERFORM 9990-SQL-ERROR-ROUTINE  THRU 9990-EXIT            
           END-IF.                                                      
                                                                        
       8930-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
T17380* 8935-INSERT-RCNCT-TRANS-HIST                                  *         
      *                                                               *         
      *     INSERTS INTO TRANSACTION HISTORY FOR RECONNECT            *         
      *     AGREEMENT.                                                *         
      *                                                               *         
      *****************************************************************         
       8935-INSERT-RCNCT-TRANS-HIST.                                    
                                                                        
T18529     PERFORM 5510-GET-TIMESTAMP          THRU 5510-EXIT.          
           MOVE 'PANEL090A'             TO WS-PANEL-NO                  
                                                                        
           MOVE 'F'                     TO MH-CODE-TRAN-TYPE.           
           MOVE SPACES                  TO MH-RESP-AREA-ID.             
           MOVE CMN-ACCOUNT-NO          TO MH-ACCOUNT-NO.               
A37666     MOVE ZEROES                  TO MH-CUSTOMER-NO.              
A37666     MOVE ZEROES                  TO MH-PREMISE-NO.               
           MOVE 'SYSTEM'                TO MH-USER-ID.                  
           MOVE WS-PANEL-NO             TO MH-APPL-PROGRAM-ID.          
           MOVE 0                       TO MH-TRAN-COMMENT-LEN.         
           MOVE SPACE                   TO MH-TRAN-COMMENT-TEXT.        
           MOVE +1                      TO MI-TRAN-APPL-NO.             
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
           MOVE 'AGRMT TO COLLCT'       TO MI-COLUMN-DESC.              
           MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE DL-AMT-TOT-RECONNECT    TO WS-TOT-RCNCT-EDT.            
           MOVE +18                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE WS-TOT-RCNCT-EDT        TO MI-CHG-COLUMN-VALUE-TEXT.    
           MOVE SPACES                  TO MI-TABLE-ID.                 
           PERFORM 6530-LOAD-MNT-TRANS-HIST.                            
                                                                        
           ADD +1                       TO MI-TRAN-APPL-NO.             
           MOVE 'RCC TO COLLECT'        TO MI-COLUMN-DESC.              
           MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE U7-RCNCT-CHRG-AM        TO WS-RCNCT-COLLCT-EDT.         
           MOVE +15                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE WS-RCNCT-COLLCT-EDT     TO MI-CHG-COLUMN-VALUE-TEXT.    
           MOVE SPACES                  TO MI-TABLE-ID.                 
           PERFORM 6530-LOAD-MNT-TRANS-HIST.                            
                                                                        
           ADD +1                       TO MI-TRAN-APPL-NO.             
           MOVE 'RCC TYPE'              TO MI-COLUMN-DESC.              
           MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE +35                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE U7-RCNCT-TYPE-TX        TO MI-CHG-COLUMN-VALUE-TEXT.    
           MOVE SPACES                  TO MI-TABLE-ID.                 
           PERFORM 6530-LOAD-MNT-TRANS-HIST.                            
                                                                        
C26296     ADD +1                       TO MI-TRAN-APPL-NO.             
C26296     MOVE 'AUTO DEP AMT'          TO MI-COLUMN-DESC.              
C26296     MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN.     
C26296     MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT.    
C26296     MOVE DL-AUTO-DEP-AM          TO WS-AUTO-DEP-AM-EDT.          
C26296     MOVE +15                     TO MI-CHG-COLUMN-VALUE-LEN.     
C26296     MOVE WS-AUTO-DEP-AM-EDT      TO MI-CHG-COLUMN-VALUE-TEXT.    
C26296     MOVE SPACES                  TO MI-TABLE-ID.                 
C26296     PERFORM 6530-LOAD-MNT-TRANS-HIST.                            
                                                                        
       8935-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
T18529* 8940-DELETE-RCNCT-TRANS-HIST                                  *         
      *                                                               *         
      *     INSERTS THE DELETED RECONNECT AGREEMENT INTO              *         
      *     TRANSACTION HISTORY.                                      *         
      *                                                               *         
      *****************************************************************         
       8940-DELETE-RCNCT-TRANS-HIST.                                    
                                                                        
           MOVE '8940'                        TO ACTIVE-PARAGRAPH.      
           MOVE 'PANEL090B'                   TO WS-PANEL-NO.           
                                                                        
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           MOVE SPACES                 TO MH-RESP-AREA-ID.              
           MOVE CMN-ACCOUNT-NO         TO MH-ACCOUNT-NO.                
A37666     MOVE ZEROES                 TO MH-CUSTOMER-NO.               
A37666     MOVE ZEROES                 TO MH-PREMISE-NO.                
           MOVE 'SYSTEM'               TO MH-USER-ID.                   
           MOVE WS-PANEL-NO            TO MH-APPL-PROGRAM-ID.           
           MOVE 0                      TO MH-TRAN-COMMENT-LEN.          
           MOVE SPACE                  TO MH-TRAN-COMMENT-TEXT.         
                                                                        
           MOVE +1                     TO MI-TRAN-APPL-NO.              
           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO.         
           MOVE 'AGRMT TO COLLECT'     TO MI-COLUMN-DESC.               
           MOVE DL-AMT-TOT-RECONNECT   TO WS-TOT-RCNCT-EDT.             
           MOVE +18                    TO MI-PRV-COLUMN-VALUE-LEN.      
           MOVE WS-TOT-RCNCT-EDT       TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN.      
           MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE SPACES                 TO MI-TABLE-ID.                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST.                            
                                                                        
           ADD +1                      TO MI-TRAN-APPL-NO.              
           MOVE 'RCC TO COLLECT'       TO MI-COLUMN-DESC.               
           MOVE DL-RECNCT-COLLECT-AMT  TO WS-RCNCT-COLLCT-EDT.          
           MOVE +15                    TO MI-PRV-COLUMN-VALUE-LEN.      
           MOVE WS-RCNCT-COLLCT-EDT    TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN.      
           MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE SPACES                 TO MI-TABLE-ID.                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST.                            
                                                                        
           ADD +1                      TO MI-TRAN-APPL-NO.              
           MOVE 'RCC TYPE'             TO MI-COLUMN-DESC.               
           MOVE +35                    TO MI-PRV-COLUMN-VALUE-LEN.      
           MOVE DL-RECNCT-TYPE-CD      TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN.      
           MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE SPACES                 TO MI-TABLE-ID.                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST.                            
                                                                        
       8940-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00471*****************************************************************         
P00471* 8945-GET-DPP-ITEM-ID.                                         *         
P00471*                                                               *         
P00471*****************************************************************         
P00471 8945-GET-DPP-ITEM-ID.                                            
P00471                                                                  
P00471     MOVE WS-ACCOUNT-NO-061         TO AC-ACCOUNT-NO              
P00471                                                                  
P00471     EXEC SQL                                                     
P00471        SELECT ITEM_ID                                            
P00471          INTO :WS-AC-ITEM-ID                                     
P00471          FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
P00471         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
P00471           AND PYMT_PRIORITY_LVL = 90                             
P00471           AND ITEM_ID           >= 30000000                      
P00471           AND ITEM_ID           <  40000000                      
P00471                                                           
P00471                                                      
P00471     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ITEM_ID                                                    
MFA-TR*         INTO :WS-AC-ITEM-ID                                             
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = 90                                     
MFA-TR*          AND ITEM_ID           >= 30000000                              
MFA-TR*          AND ITEM_ID           <  40000000                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 8945                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00471                                                                  
P00471     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00471     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00471        NEXT SENTENCE                                             
P00471     ELSE                                                         
P00471        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00471        MOVE '8945'                    TO ACTIVE-PARAGRAPH        
P00471        MOVE 'CSS_AR_CNTL'             TO CMN-TABLE-1             
P00471        MOVE 'ITEM_ID'                 TO CMN-TABLE-ELEMENT-1     
P00471        MOVE 'ACCOUNT_NO'              TO CMN-TABLE-ELEMENT-2     
P00471        MOVE 90                        TO CMN-HOSTVAR-ELEMENT-1   
P00471        MOVE AC-ACCOUNT-NO             TO CMN-HOSTVAR-ELEMENT-2   
P00471        PERFORM 9990-SQL-ERROR-ROUTINE THRU 9990-EXIT             
P00471     END-IF.                                                      
P00471                                                                  
P00471 8945-EXIT.                                                       
P00471     EXIT.                                                        
P00471*                                                                         
                                                                        
A00765****************************************************************          
A00765* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *          
A00765****************************************************************          
A00765 9000-SEND-ERROR-RESULT.                                          
A00765                                                                  
A00765 9000-EXIT.                                                       
A00765*                                                                         
      *****************************************************************         
      * 9001-TERMINATE-TO-CICS                                        *         
      *                                                               *         
      *     RETURN CONTROL TO CICS OR NEXT HIGHER LOGICAL LEVEL       *         
      *                                                               *         
      *****************************************************************         
       9001-TERMINATE-LINK.                                             
                                                                        
REARCH     EXIT PROGRAM.                                                
                                                                        
       9001-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH* CALLS THE SUBPROGRAM SCSCO068                                           
REARCH******************************************************************        
REARCH 9500-CALL-CPD00068.                                              
REARCH                                                                  
REARCH      CALL MCSCB068  USING  CWS00068-FIELDS                       
REARCH                            WS-CODES-DATA-PRESENT                 
REARCH                            DCLCSS-ACCOUNT                        
REARCH                            ABEND-FILE                            
REARCH                            RS-RETURN-CODE.                       
REARCH      MOVE RS-RETURN-CODE   TO WS-ACTIVE-RETURN-CODE,             
REARCH                               S-RETURN-CODE.                     
REARCH      IF ABEND-FUNCTION  > SPACES                                 
REARCH          IF ABEND-FUNCTION EQUAL 'BADDATA'                       
REARCH              MOVE -1        TO S-RETURN-CODE,                    
REARCH                                WS-ACTIVE-RETURN-CODE             
REARCH          END-IF                                                  
REARCH          PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT               
REARCH      END-IF.                                                     
                                                                        
REARCH                                                                  
REARCH 9500-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH                                                                  
      ******************************************************************        
T17380* 9700-PROCESS-ABEND.                                            *        
      * THIS PARAGRAPH NECESSARY FOR CPD00068                          *        
      *                                                                *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
      *                                                                         
           PERFORM 9990-SQL-ERROR-ROUTINE           THRU 9990-EXIT.     
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH****************************************************************          
REARCH* 9900-SQL-ERROR-ROUTINE.                                      *          
REARCH*                                                              *          
REARCH****************************************************************          
REARCH 9900-SQL-ERROR-ROUTINE.                                          
REARCH                                                                  
REARCH     MOVE WS-YES                   TO CMN-ABEND-CHECK.            
REARCH     MOVE WS-ACTIVE-RETURN-CODE    TO CMN-RETURN-CODE.            
REARCH     MOVE ACTIVE-PARAGRAPH         TO CMN-ACTIVE-PARAGRAPH.       
REARCH     MOVE PROGRAM-NAME             TO CMN-PROGRAM-NAME.           
REARCH                                                                  
REARCH 9900-EXIT.                                                       
REARCH     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9990-SQL-ERROR-ROUTINE.                                        *        
      *                                                                *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       9990-SQL-ERROR-ROUTINE.                                          
                                                                        
           MOVE WS-YES                     TO CMN-ABEND-CHECK.          
           MOVE WS-ACTIVE-RETURN-CODE      TO CMN-RETURN-CODE.          
           MOVE ACTIVE-PARAGRAPH           TO CMN-ACTIVE-PARAGRAPH.     
           MOVE PROGRAM-NAME               TO CMN-PROGRAM-NAME.         
REARCH     EXIT PROGRAM.                                                
                                                                        
       9990-EXIT.                                                       
           EXIT.                                                        
                                                                        
