       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    MCSCO061.                                         
       DATE-WRITTEN.  08/07/2001.                                       
       AUTHOR      .  COVANSYS.                                         
      *****************************************************************         
      *****           SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                                                             **         
      *********         CUSTOMER SERVICE SYSTEM            ************         
      *********                DB2                         ************         
      *****************************************************************         
      **               !!! WARNING  !!!!                             **         
      **               -----------------                             **         
      ** CPD00061 HAS BEEN CONVERTED INTO A PROGRAM.  THE NAME OF    **         
      ** THIS PROGRAM IS:                                            **         
      **                 SCSCO061 - FOR ON-LINE COMPONENTS           **         
      **                 SCSCB061 - FOR BATCH COMPONENTS             **         
      **                                                             **         
      ** THESE PROGRAMS INCLUDE COPYBOOKS:                           **         
      ** 1.  CWS00061 (WORKING STORAGE),                             **         
      ** 2.  CPD00061 (PROCEDURE DIVISION LOGIC)                     **         
      ** 3.  CWS0061L (LINKAGE SECTION)                              **         
      **                                                             **         
      ** PROGRAMS THAT INCLUDED CPD00061/CWS00061 NOW LINK TO        **         
      ** SCSCO061/SCSCB061 AND INCLUDE COPYBOOK CWS00061 TO PASS     **         
      ** INFORMATION BACK AND FORTH BETWEEN THE CALLING AND CALLED   **         
      ** PROGRAMS.                                                   **         
      **               !!! BE CAREFUL !!!!                           **         
      **               -------------------                           **         
      ** BE CAREFUL ABOUT THE FOLLOWING:                             **         
      ** 1. THE LENGTH OF COPYBOOK CWS00061L MUST MATCH THE LENGTH   **         
      **    OF THE DFHCOMMAREA IN PROGRAM SCSCO061.                  **         
      *****************************************************************         
      **                                                             **         
      **                  PROGRAM MODIFICATION LOG                   **         
      **    DATE      INITIALS   REASON                              **         
      **    ____      ________   ______                              **         
      **                                                             **         
      **    08/07/01  COVANSYS   COPY BOOK CPD00061 CHANGED TO SUB   **         
      **              CHENNAI    PROGRAM.                            **         
REARCH**    06/16/03  AD88124    CODE CHANGES MADE TO CALL THIS      **         
REARCH**                         PROGRAM FROM DB2 STORED PROCEDURE.  **         
      *****************************************************************         
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'MCSCO061'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR SCSCO061 STARTS HERE'.            
                                                                        
       01  WS-CALL-ENVIRONMENT         PIC X(01) VALUE 'O'.             
           88 ONLINE-CALL                        VALUE 'O'.             
           88 BATCH-CALL                         VALUE 'B'.             
       01  PROGRAM-NAME                PIC X(08) VALUE 'MCSCO061'.      
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-1                    PIC 9(01) VALUE 1.               
                                                                        
REARCH*    COPY CWS00010.                                                       
      ******************************************************************        
      *  COPYBOOK THAT CONTAINS WS-ACTIVE-RETURN-CODE, SUCCESSFUL-CALL *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ************************ SQL DECLARATIONS ************************00003200
      *                                                                         
           EXEC SQL                                                     00003300
              INCLUDE SQLCA                                             00003400
           END-EXEC.                                                    00004000
      *                                                                         
           EXEC SQL                                                     00006000
              INCLUDE TBGLATNO                                          00007000
           END-EXEC.                                                    00008000
                                                                        
      ************************ SQL DECLARATIONS END ********************00003200
      *                                                                         
REARCH*    EXEC SQL                                                             
REARCH*        INCLUDE CWS00061                                                 
REARCH*    END-EXEC                                                             
      *                                                                         
REARCH*    EXEC SQL                                                             
REARCH*        INCLUDE CWS0061L                                                 
REARCH*    END-EXEC                                                             
      *                                                                         
REARCH*01  RS-RETURN-CODE              PIC S9(9) COMP VALUE 0.          00002800
      *                                                                         
      ******************************************************************        
      * CURSOR DECLARATION FOR RETRIEVING GL VALUES FOR THE GIVEN      *        
      * COMPANY NO.                                                    *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE GL-CPD61-CSR CURSOR FOR                          
               SELECT GL_ACCT_NO,                                       
                      GL_ACCT_NAME                                      
               FROM  CSS_GL_ACCT_NO                                     
               WHERE COMPANY_NO =:GO-COMPANY-NO                         
               ORDER BY GL_ACCT_NO                                      
           END-EXEC.                                                    
      *                                                                         
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
REARCH*01  DFHCOMMAREA                 PIC X(11337).                            
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWS00061                                                 
REARCH     END-EXEC                                                             
REARCH     COPY CWS00010.                                                       
REARCH 01  RS-RETURN-CODE              PIC S9(9) COMP VALUE 0.          
                                                                        
       PROCEDURE DIVISION USING  WS-GL-ACCT-NAME                        
                                ,WS-GL-ACCT-MAJOR-FIELDS                
                                ,WS-VALID-COMPANY-NOS                   
                                ,WS-GL-NAME-INFO                        
                                ,WS-GL-ACCT-NO-TABLE                    
                                ,ABEND-FILE                             
                                ,RS-RETURN-CODE.                        
      *                                                                         
      ******************************************************************        
      **  0000-MAINLINE                                               **        
      **      CONTROLS MAIN PROCESSING OF PROGRAM                     **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
REARCH*    IF  EIBCALEN IS EQUAL LENGTH OF WS-CPD61-LINK-RECORD                 
REARCH     IF WS-VALID-COMPANY-NOS > SPACES                             
REARCH*        PERFORM 0100-MOVE-DFH-LINK THRU 0100-EXIT                        
               PERFORM 0700-LOAD-GL-NO-VALUES                           
                                          THRU 0700-EXIT                
                  VARYING WS-VALID-CO-SUB FROM WS-1 BY WS-1             
                     UNTIL WS-VALID-CO-SUB > WS-MAX-CO                  
                   OR WS-VALID-CO-NO (WS-VALID-CO-SUB) EQUAL WS-GL-99   
           ELSE                                                         
               MOVE 'SCSCO061'            TO ABEND-PROGRAM              
               MOVE 'BADDATA'             TO ABEND-FUNCTION             
               MOVE '999'                 TO RS-RETURN-CODE             
           END-IF.                                                      
      *                                                                         
REARCH*    PERFORM 0200-MOVE-LINK-DFH     THRU 0200-EXIT.                       
           PERFORM 9999-SCSCO061-EXIT     THRU 9999-EXIT.               
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
REARCH******************************************************************        
REARCH* 0100-MOVE-DFH-LINK                                             *        
REARCH*     MOVE CWS0061L VARIABLES TO WORKING STORAGE VARIABLES       *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 0100-MOVE-DFH-LINK.                                              
REARCH*                                                                         
REARCH*    MOVE DFHCOMMAREA               TO WS-CPD61-LINK-RECORD.              
REARCH*    MOVE WS-GL-ACCT-NAME-61-LK     TO WS-GL-ACCT-NAME.                   
REARCH*    MOVE WS-GL-ACCT-MAJOR-FIELDS-61-LK                                   
REARCH*                                   TO WS-GL-ACCT-MAJOR-FIELDS.           
REARCH*    MOVE WS-VALID-COMPANY-NOS-61-LK                                      
REARCH*                                   TO WS-VALID-COMPANY-NOS.              
REARCH*    MOVE WS-GL-NAME-INFO-61-LK     TO WS-GL-NAME-INFO.                   
REARCH*    MOVE WS-GL-ACCT-NO-TABLE-61-LK TO WS-GL-ACCT-NO-TABLE.               
REARCH*    MOVE WS-CPD00061-CALLING-PGM-61-LK                                   
REARCH*                                   TO WS-CPD00061-CALLING-PGM.           
REARCH*    MOVE WS-ABEND-FILE-61-LK       TO ABEND-FILE.                        
REARCH*    MOVE WS-RETURN-CODE-61-LK      TO RS-RETURN-CODE.                    
REARCH*                                                                         
      *    IF WS-CPD00061-CALLING-PGM > LOW-VALUES AND                          
      *       WS-CPD00061-CALLING-PGM > SPACES                                  
      *       MOVE WS-CPD00061-CALLING-PGM                                      
      *                                   TO PROGRAM-NAME                       
      *    END-IF.                                                              
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0200-MOVE-DFH-LINK                                             *        
      *     MOVE WORKING STORAGE VARIABLES TO CWS0061L VARIABLES       *        
      ******************************************************************        
      *                                                                         
REARCH*0200-MOVE-LINK-DFH.                                                      
      *                                                                         
REARCH*    MOVE WS-GL-ACCT-NAME           TO WS-GL-ACCT-NAME-61-LK.             
REARCH*    MOVE WS-GL-ACCT-MAJOR-FIELDS   TO                                    
REARCH*                                   WS-GL-ACCT-MAJOR-FIELDS-61-LK.        
REARCH*    MOVE WS-VALID-COMPANY-NOS      TO WS-VALID-COMPANY-NOS-61-LK.        
REARCH*    MOVE WS-GL-NAME-INFO           TO WS-GL-NAME-INFO-61-LK.             
REARCH*    MOVE WS-GL-ACCT-NO-TABLE       TO WS-GL-ACCT-NO-TABLE-61-LK.         
REARCH*    MOVE WS-CPD00061-CALLING-PGM   TO                                    
REARCH*                                   WS-CPD00061-CALLING-PGM-61-LK.        
REARCH*    MOVE ABEND-FILE                TO WS-ABEND-FILE-61-LK.               
REARCH*    MOVE RS-RETURN-CODE            TO WS-RETURN-CODE-61-LK.              
REARCH*    MOVE WS-CPD61-LINK-RECORD      TO DFHCOMMAREA.                       
REARCH*                                                                         
REARCH*0200-EXIT.                                                               
REARCH*    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      * 0700-LOAD-GL-NO-VALUES                                         *        
      *     LOAD GL VALUES IN WS TABLES FOR ALL THE ACCOUNT NUMBERS.   *00006000
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00061                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * THE FOLLOWING PARAS ARE BEING PERFORMED BY                     *        
      * 0700-LOAD-GL-NO-VALUES. SEE CWS00061 FOR GENERAL COMMENTS.     *        
      *                                                                *        
      ******************************************************************        
      * 7000-OPEN-CPD61-GL-CSR                                         *        
      *     OPENS CURSOR FOR CSS_GL_ACCT_NO TABLE                      *        
      ******************************************************************        
      *                                                                *        
       7000-OPEN-CPD61-GL-CSR.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN GL-CPD61-CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7000'                TO ACTIVE-PARAGRAPH           
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                    
               MOVE 'GO-COMPANY-NO'       TO TABLE-ELEMENT-1            
               MOVE GO-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7000C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7010-FETCH-CPD61-GL-CSR                                        *        
      *     PERFORMS FETCH OF GL ACCOUNT NUMBERS & NAMES FROM          *        
      *     CSS_GL_ACCT_NO TABLE                                       *        
      ******************************************************************        
      *                                                                         
       7010-FETCH-CPD61-GL-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
               FETCH GL-CPD61-CSR                                       
               INTO :GO-GL-ACCT-NO,                                     
                    :GO-GL-ACCT-NAME                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7010'                TO ACTIVE-PARAGRAPH           
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                    
               MOVE 'GO-COMPANY-NO'       TO TABLE-ELEMENT-1            
               MOVE GO-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7010C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-CLOSE-CPD61-GL-CSR                                        *        
      *     CLOSING OF CURSOR FOR CSS_GL_ACCT_NO TABLE                 *        
      ******************************************************************        
      *                                                                         
       7020-CLOSE-CPD61-GL-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
               CLOSE GL-CPD61-CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7020'                TO ACTIVE-PARAGRAPH           
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                    
               MOVE 'GO-COMPANY-NO'       TO TABLE-ELEMENT-1            
               MOVE GO-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7020C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      *     RETURNS THE CONTROL TO CALLING PROGRAM                     *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
                                                                        
      *                                                                         
REARCH*    PERFORM 0200-MOVE-LINK-DFH     THRU 0200-EXIT.                       
           PERFORM 9999-SCSCO061-EXIT     THRU  9999-EXIT.              
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9999-SCSCB061-EXIT                                             *        
      *     EXITS & RETURNS THE CONTROL TO CALLING PROGRAM             *        
      ******************************************************************        
      *                                                                         
       9999-SCSCO061-EXIT.                                              
                                                                        
REARCH*    EXEC CICS                                                            
REARCH*        RETURN                                                           
REARCH*    END-EXEC.                                                            
           EXIT PROGRAM.                                                
      *                                                                         
       9999-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
