       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    MCSCB076.                                         
       DATE-WRITTEN.  10/21/2013.                                       
       AUTHOR      .  NC94746.                                          
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                       COVANSYS                              **         
      **                                                             **         
      *********         CUSTOMER SERVICE SYSTEM           *************         
      *********                DB2                        *************         
      *****************************************************************         
      **                                                             **         
      **                  PROGRAM MODIFICATION LOG                   **         
      **    DATE    INITIALS   REASON                                **         
      **    ____    ________   ______                                **         
      **                                                             **         
      **  07/31/16  NC94746    NEW CODE                              **         
      *****************************************************************         
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'MCSCB076'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                    PIC X(40)                         
           VALUE 'WORKING STORAGE FOR MCSCB076 STARTS HERE'.            
                                                                        
       01 WS-CALL-ENVIRONMENT         PIC X(01) VALUE 'O'.              
          88 ONLINE-CALL              VALUE 'O'.                        
          88 BATCH-CALL               VALUE 'B'.                        
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME             PIC X(08) VALUE 'MCSCB076'.       
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_GAS_METER,  PREFIX - GM                  *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_EQUIPMENT,  PREFIX - EQ                  *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_GAS_TST_GROUP,  PREFIX - GG              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBGASGRP                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTR_TEST_HIST , PREFIX - MQ              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBMTRTST                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTR_TEST_GROUP, PREFIX - GR              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBMTRGP                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_JOB_PARM,       PREFIX - G6              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_ACCOUNT,        PREFIX - AT              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_UTIL_ENVRNMT,   PREFIX - UT              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTRD_ENVRNMT,   PREFIX - MN              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_CNSMPTN_HIST,   PREFIX - CX              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_METER_TYPE,     PREFIX - M7              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBMTRTYP                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_MTR_CAP,        PREFIX - MC              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    COPYBOOK FOR CSS_DELINQUENCY,    PREFIX - C8              *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CPD00099                                   *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************** 00010000
      *  JRNL-ROUTINE                                                 * 00020000
      ***************************************************************** 00080000
           EXEC SQL                                                     01555900
              INCLUDE CWS00013                                          01556000
           END-EXEC.                                                    01557000
                                                                        
      ***************************************************************** 00010000
      * WORKING STORAGE FOR CPD00076                                  * 00020000
      ***************************************************************** 00080000
      *    EXEC SQL                                                     01555900
      *       INCLUDE CWS00076                                          01556000
      *    END-EXEC.                                                    01557000
      *                                                                 00890000
      ***************************************************************** 00010000
      *  WORKING STORAGE COPY BOOKS                                   * 00020000
      ***************************************************************** 00080000
           COPY CWS00303.                                                       
                                                                        
      *****************************************************************         
      * COPYBOOK FOR THE WORKING STORAGE VARIABLES                    *         
      *****************************************************************         
      *                                                                         
      *    EXEC SQL                                                             
      *         INCLUDE CWS00076                                                
      *    END-EXEC.                                                            
      *                                                                 01570004
      /*********** SQL DECLARATIONS  END************************        00003200
       01 CWS76-VARS.                                                   
           05 WS-CALL-TYPE               PIC X(01)  VALUE SPACES.       
           05 WS-DATE-LAST-TESTED-IND    PIC S9(04) COMP VALUE 0.       
           05 WS-LAST-TEST-SEL-DT-IND    PIC S9(04) COMP VALUE 0.       
           05 WS-DATE-PURCHASED-IND      PIC S9(04) COMP VALUE 0.       
           05 WS-TARGET-QT               PIC S9(09) COMP VALUE 0.       
           05 WS-EVENT-TIMESTAMP         PIC X(26)  VALUE SPACES.       
           05 WS-EVENT-DATE.                                            
              10 WS-EVENT-CCYY            PIC 9(04).                    
              10 WS-EVENT-SEP1            PIC X(01).                    
              10 WS-EVENT-MM              PIC 9(02).                    
              10 WS-EVENT-SEP2            PIC X(01).                    
              10 WS-EVENT-DD              PIC 9(02).                    
           05 WS-ERROR-FLAG              PIC 9(01)  VALUE 0.            
               88 NO-ERROR-FOUND         VALUE 0.                       
               88 ERROR-FOUND            VALUE 1.                       
           05 WS-DELQ-SMPL-MMDD          PIC 9(04).                     
           05 WS-TODAYS-DATE             PIC X(10).                     
           05 WS-SMPL-END-DATE.                                         
              10 WS-SMPL-CCYY            PIC 9(04).                     
              10 WS-SMPL-SEP1            PIC X(01).                     
              10 WS-SMPL-MM              PIC 9(02).                     
              10 WS-SMPL-SEP2            PIC X(01).                     
              10 WS-SMPL-DD              PIC 9(02).                     
           05 WS-CUR-DATE.                                              
              10 WS-CUR-YEARS            PIC 9(04).                     
              10 FILLER                  PIC X(01).                     
              10 WS-CUR-MM               PIC 9(02).                     
              10 FILLER                  PIC X(01).                     
              10 WS-CUR-DD               PIC 9(02).                     
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
           COPY CLS00076.                                                       
                                                                        
           COPY CWS00010.                                                       
                                                                        
                                                                        
                                                                        
       PROCEDURE DIVISION USING CLS00076-FIELDS,                        
                                ABEND-FILE.                             
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 0200-VALIDATE-INPUT THRU 0200-EXIT.                  
                                                                        
           IF NO-ERROR-FOUND                                            
              PERFORM 1000-PROCESS-METER  THRU 1000-EXIT                
           END-IF.                                                      
                                                                        
           PERFORM 9999-MCSCB076-EXIT  THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
                                                                        
           MOVE 'N'                   TO CLS76-FLAG-MTR-QUALIFY.        
           MOVE 'GAS-SMPL-TST-END-DT'    TO C8-DELINQ-CD.               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *================================================================*        
       0200-VALIDATE-INPUT.                                             
      *================================================================*        
                                                                        
           IF CLS76-COMPANY-NO = '01' OR '26'                           
              MOVE CLS76-COMPANY-NO   TO GM-COMPANY-NO                  
                                         C8-COMPANY-NO                  
           ELSE                                                         
              SET ERROR-FOUND         TO TRUE                           
           END-IF.                                                      
                                                                        
           IF CLS76-ACCOUNT-NO > ZERO                                   
              MOVE CLS76-ACCOUNT-NO   TO CX-ACCOUNT-NO                  
           ELSE                                                         
              SET ERROR-FOUND         TO TRUE                           
           END-IF.                                                      
                                                                        
           IF CLS76-UTILITY-TYPE = 'G'                                  
              MOVE CLS76-UTILITY-TYPE TO GM-CODE-UTIL-TYPE              
           ELSE                                                         
              SET ERROR-FOUND         TO TRUE                           
           END-IF.                                                      
                                                                        
           IF CLS76-METER-NO (9:) >  SPACES                             
              MOVE CLS76-METER-NO     TO GM-METER-NO                    
           ELSE                                                         
              SET ERROR-FOUND         TO TRUE                           
           END-IF.                                                      
                                                                        
           IF CLS76-CALL-TYPE  = 'I' OR 'C'                             
              MOVE CLS76-CALL-TYPE    TO WS-CALL-TYPE                   
           ELSE                                                         
              SET ERROR-FOUND         TO TRUE                           
           END-IF.                                                      
                                                                        
           IF CLS76-EVENT-TIMESTAMP > SPACES                            
              MOVE CLS76-EVENT-TIMESTAMP TO WS-EVENT-TIMESTAMP          
           ELSE                                                         
              SET ERROR-FOUND         TO TRUE                           
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1000-PROCESS-METER.                                              
      *================================================================*        
                                                                        
           PERFORM 1050-PROCESS-DATES      THRU 1050-EXIT.              
           PERFORM 1100-MTR-INSTALL-DTLS   THRU 1100-EXIT.              
                                                                        
      ***  REQUIREMENT CHANGE - METER CAN BE TESTED EVEN NO USAGE ON IT         
      *    IF NO-ERROR-FOUND                                                    
      *       PERFORM 1200-CHECK-MTR-CONS      THRU 1200-EXIT                   
      *    END-IF.                                                              
      *                                                                         
           IF NO-ERROR-FOUND                                            
              PERFORM 1300-CHECK-TEST-GRP  THRU 1300-EXIT               
           END-IF.                                                      
                                                                        
           IF NO-ERROR-FOUND AND GR-AUTO-SAMPLE-TST-FL = 'Y'            
              PERFORM 1400-PROCESS-TEST-HIST THRU 1400-EXIT             
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1050-PROCESS-DATES.                                              
      *================================================================*        
                                                                        
           PERFORM 7990-GET-DELINQUENCY    THRU 7990-EXIT.              
                                                                        
           PERFORM 7900-GET-CURRENT-DATE   THRU 7900-EXIT               
                                                                        
           MOVE WS-TODAYS-DATE             TO WS-CUR-DATE               
                                              WS-SMPL-END-DATE.         
                                                                        
           MOVE C8-DELINQ-VALUE            TO WS-DELQ-SMPL-MMDD         
           MOVE WS-DELQ-SMPL-MMDD (1:2)    TO WS-SMPL-MM                
           MOVE WS-DELQ-SMPL-MMDD (3:2)    TO WS-SMPL-DD.               
                                                                        
           MOVE WS-EVENT-TIMESTAMP(1:4)    TO WS-EVENT-CCYY             
           MOVE WS-EVENT-TIMESTAMP(6:2)    TO WS-EVENT-MM               
           MOVE WS-EVENT-TIMESTAMP(9:2)    TO WS-EVENT-DD               
           MOVE WS-SMPL-SEP1               TO WS-EVENT-SEP1             
           MOVE WS-SMPL-SEP2               TO WS-EVENT-SEP2.            
                                                                        
       1050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1100-MTR-INSTALL-DTLS.                                           
      *================================================================*        
                                                                        
           MOVE SPACES                TO EQ-CODE-CRNT-LOC               
                                         GM-LAST-TEST-SEL-CD            
                                         GM-DATE-LAST-TESTED            
                                         EQ-DATE-PURCHASED              
                                         GM-LAST-TEST-SEL-DT.           
                                                                        
           PERFORM 7000-CHECK-MTR-INSTALLED THRU 7000-EXIT.             
           IF GM-LAST-TEST-SEL-DT = SPACES                              
              AND WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET ERROR-FOUND         TO TRUE                           
           END-IF.                                                      
                                                                        
           IF (EQ-CODE-CRNT-LOC = 'J'                                   
              AND EQ-CRNT-LOC-NO > 0                                    
              AND WS-CALL-TYPE = 'I' )                                  
              OR WS-CALL-TYPE = 'C'                                     
              CONTINUE                                                  
           ELSE                                                         
              SET ERROR-FOUND         TO TRUE                           
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1200-CHECK-MTR-CONS.                                             
      *================================================================*        
                                                                        
           MOVE GM-CODE-UTIL-TYPE        TO CX-CODE-UTIL-TYPE           
           MOVE GM-METER-NO              TO CX-METER-NO                 
           PERFORM 7300-CHECK-USAGE-HIST    THRU 7300-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              SET ERROR-FOUND         TO TRUE                           
           END-IF.                                                      
                                                                        
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1300-CHECK-TEST-GRP.                                             
      *================================================================*        
                                                                        
           MOVE SPACES                TO GG-MTR-TEST-GRP-CD.            
                                                                        
           IF EQ-DATE-PURCHASED = SPACES                                
              MOVE WS-TODAYS-DATE             TO EQ-DATE-PURCHASED      
           END-IF.                                                      
           IF GM-DATE-LAST-TESTED = SPACES                              
              MOVE WS-TODAYS-DATE             TO GM-DATE-LAST-TESTED    
           END-IF.                                                      
           PERFORM 7100-GET-METER-TEST-GRP  THRU 7100-EXIT              
           IF GG-MTR-TEST-GRP-CD > SPACES                               
              MOVE WS-TODAYS-DATE     TO WS-CUR-DATE                    
              MOVE WS-CUR-YEARS       TO MQ-TEST-YEAR                   
              MOVE GM-CODE-UTIL-TYPE  TO MQ-CODE-UTIL-TYPE              
              MOVE GM-COMPANY-NO      TO MQ-COMPANY-NO                  
              MOVE GG-MTR-TEST-GRP-CD TO MQ-MTR-TEST-GRP-CD             
           ELSE                                                         
              SET ERROR-FOUND         TO TRUE                           
           END-IF.                                                      
                                                                        
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1400-PROCESS-TEST-HIST.                                          
      *================================================================*        
                                                                        
           MOVE ZERO               TO MQ-SELECTED-QT                    
                                      MQ-SAMPLE-MIN-QT                  
                                                                        
           PERFORM 7200-CHECK-MTR-HIST      THRU 7200-EXIT              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 1450-UPDATE-TEST-HIST      THRU 1450-EXIT         
           ELSE                                                         
              SET ERROR-FOUND         TO TRUE                           
           END-IF.                                                      
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       1450-UPDATE-TEST-HIST.                                           
      *================================================================*        
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-CALL-TYPE = 'I'                                   
                AND MQ-SELECTED-QT < WS-TARGET-QT                       
                AND WS-EVENT-DATE  < WS-SMPL-END-DATE                   
                 MOVE 'Y'             TO CLS76-FLAG-MTR-QUALIFY         
                 MOVE ZERO            TO CLS76-RETURN-CODE              
              WHEN WS-CALL-TYPE = 'C'                                   
                 IF MQ-STATUS-CD = SPACES                               
                    MOVE 'B'    TO MQ-STATUS-CD                         
                 END-IF                                                 
                 PERFORM 8000-UPDATE-TEST-HIST   THRU 8000-EXIT         
                 PERFORM 8100-UPDATE-GAS-METER   THRU 8100-EXIT         
                 MOVE 'Y'             TO CLS76-FLAG-MTR-QUALIFY         
                 MOVE ZERO            TO CLS76-RETURN-CODE              
              WHEN OTHER                                                
                 CONTINUE                                               
           END-EVALUATE.                                                
                                                                        
       1450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7000-CHECK-MTR-INSTALLED.                                        
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT GM.TEST_SCHED_CD                                  
                     ,GM.METER_SIZE_ID                                  
                     ,GM.DATE_LAST_TESTED                               
                     ,GM.CODE_METER_TYPE                                
                     ,GM.LAST_TEST_SEL_CD                               
                     ,GM.LAST_TEST_SEL_DT                               
                     ,EQ.DATE_PURCHASED                                 
                     ,EQ.CODE_CRNT_LOC                                  
                     ,EQ.CRNT_LOC_NO                                    
                     ,EQ.CODE_MAKE                                      
                     ,EQ.LOCAL_OFFICE                                   
               INTO   :GM-TEST-SCHED-CD                                 
                     ,:GM-METER-SIZE-ID                                 
                     ,:GM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-IND     
                     ,:GM-CODE-METER-TYPE                               
                     ,:GM-LAST-TEST-SEL-CD                              
                     ,:GM-LAST-TEST-SEL-DT :WS-LAST-TEST-SEL-DT-IND     
                     ,:EQ-DATE-PURCHASED :WS-DATE-PURCHASED-IND         
                     ,:EQ-CODE-CRNT-LOC                                 
                     ,:EQ-CRNT-LOC-NO                                   
                     ,:EQ-CODE-MAKE                                     
                     ,:EQ-LOCAL-OFFICE                                  
               FROM CSS_GAS_METER GM WITH(READUNCOMMITTED)                      
                   ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                      
               WHERE GM.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE             
                 AND GM.METER_NO       = :GM-METER-NO                   
                 AND GM.COMPANY_NO     = :GM-COMPANY-NO                 
                 AND EQ.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE              
                 AND EQ.DEVICE_NO      = GM.METER_NO                    
                 AND EQ.COMPANY_NO     = GM.COMPANY_NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GM.TEST_SCHED_CD                                          
MFA-TR*              ,GM.METER_SIZE_ID                                          
MFA-TR*              ,GM.DATE_LAST_TESTED                                       
MFA-TR*              ,GM.CODE_METER_TYPE                                        
MFA-TR*              ,GM.LAST_TEST_SEL_CD                                       
MFA-TR*              ,GM.LAST_TEST_SEL_DT                                       
MFA-TR*              ,EQ.DATE_PURCHASED                                         
MFA-TR*              ,EQ.CODE_CRNT_LOC                                          
MFA-TR*              ,EQ.CRNT_LOC_NO                                            
MFA-TR*              ,EQ.CODE_MAKE                                              
MFA-TR*              ,EQ.LOCAL_OFFICE                                           
MFA-TR*        INTO   :GM-TEST-SCHED-CD                                         
MFA-TR*              ,:GM-METER-SIZE-ID                                         
MFA-TR*              ,:GM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-IND             
MFA-TR*              ,:GM-CODE-METER-TYPE                                       
MFA-TR*              ,:GM-LAST-TEST-SEL-CD                                      
MFA-TR*              ,:GM-LAST-TEST-SEL-DT :WS-LAST-TEST-SEL-DT-IND             
MFA-TR*              ,:EQ-DATE-PURCHASED :WS-DATE-PURCHASED-IND                 
MFA-TR*              ,:EQ-CODE-CRNT-LOC                                         
MFA-TR*              ,:EQ-CRNT-LOC-NO                                           
MFA-TR*              ,:EQ-CODE-MAKE                                             
MFA-TR*              ,:EQ-LOCAL-OFFICE                                          
MFA-TR*        FROM CSS_GAS_METER GM                                            
MFA-TR*            ,CSS_EQUIPMENT EQ                                            
MFA-TR*        WHERE GM.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE                     
MFA-TR*          AND GM.METER_NO       = :GM-METER-NO                           
MFA-TR*          AND GM.COMPANY_NO     = :GM-COMPANY-NO                         
MFA-TR*          AND EQ.CODE_UTIL_TYPE = GM.CODE_UTIL_TYPE                      
MFA-TR*          AND EQ.DEVICE_NO      = GM.METER_NO                            
MFA-TR*          AND EQ.COMPANY_NO     = GM.COMPANY_NO                          
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO CLS76-RETURN-CODE     
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7000'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_GAS_METER'             TO TABLE-1               
              MOVE 'CODE_UTIL_TYPE'            TO TABLE-ELEMENT-1       
              MOVE 'METER_NO'                  TO TABLE-ELEMENT-2       
              MOVE 'COMPANY_NO'                TO TABLE-ELEMENT-3       
              MOVE GM-CODE-UTIL-TYPE           TO HOSTVAR-ELEMENT-1     
              MOVE GM-METER-NO                 TO HOSTVAR-ELEMENT-2     
              MOVE GM-COMPANY-NO               TO HOSTVAR-ELEMENT-3     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7100-GET-METER-TEST-GRP.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT GR.MTR_TEST_GRP_CD                                
                     ,GR.SO_REQUIRED_FL                                 
                     ,GR.CUST_NOTIFY_FL                                 
                     ,GR.AUTO_SAMPLE_TST_FL                             
               INTO   :GG-MTR-TEST-GRP-CD                               
                     ,:GR-SO-REQUIRED-FL                                
                     ,:GR-CUST-NOTIFY-FL                                
                     ,:GR-AUTO-SAMPLE-TST-FL                            
               FROM CSS_GAS_TST_GROUP  GG WITH(READUNCOMMITTED)                 
                   ,CSS_MTR_TEST_GROUP GR WITH(READUNCOMMITTED)                 
               WHERE GG.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE             
                 AND GG.METER_SIZE_ID  = :GM-METER-SIZE-ID              
                 AND GG.COMPANY_NO     = :GM-COMPANY-NO                 
                 AND GG.CODE_UTIL_TYPE = GR.CODE_UTIL_TYPE              
                 AND GG.MTR_TEST_GRP_CD = GR.MTR_TEST_GRP_CD            
                 AND GG.COMPANY_NO     = GR.COMPANY_NO                  
                 AND ((GR.SELECT_TYPE_CD  = 'T'                         
                     AND IIF(TRY_CONVERT(DATE, :GM-DATE-LAST-TESTED
              ) IS NULL OR (PATINDEX('%.%', :GM-DATE-LAST-TESTED
              ) <> 0) OR (LEN(:GM-DATE-LAST-TESTED
              ) <> 10), CIS.CHAR2DATE(:GM-DATE-LAST-TESTED
              ), CONVERT(DATE, :GM-DATE-LAST-TESTED) ) BETWEEN                 
                                        GG.BEGIN_PURCHASE_DT            
                                    AND GG.END_PURCHASE_DT)             
                    OR (GR.SELECT_TYPE_CD  = 'P'                        
                     AND IIF(TRY_CONVERT(DATE, :EQ-DATE-PURCHASED
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-PURCHASED
              ) <> 0) OR (LEN(:EQ-DATE-PURCHASED
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-PURCHASED
              ), CONVERT(DATE, :EQ-DATE-PURCHASED) )   BETWEEN                 
                                        GG.BEGIN_PURCHASE_DT            
                                    AND GG.END_PURCHASE_DT))            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GR.MTR_TEST_GRP_CD                                        
MFA-TR*              ,GR.SO_REQUIRED_FL                                         
MFA-TR*              ,GR.CUST_NOTIFY_FL                                         
MFA-TR*              ,GR.AUTO_SAMPLE_TST_FL                                     
MFA-TR*        INTO   :GG-MTR-TEST-GRP-CD                                       
MFA-TR*              ,:GR-SO-REQUIRED-FL                                        
MFA-TR*              ,:GR-CUST-NOTIFY-FL                                        
MFA-TR*              ,:GR-AUTO-SAMPLE-TST-FL                                    
MFA-TR*        FROM CSS_GAS_TST_GROUP  GG                                       
MFA-TR*            ,CSS_MTR_TEST_GROUP GR                                       
MFA-TR*        WHERE GG.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE                     
MFA-TR*          AND GG.METER_SIZE_ID  = :GM-METER-SIZE-ID                      
MFA-TR*          AND GG.COMPANY_NO     = :GM-COMPANY-NO                         
MFA-TR*          AND GG.CODE_UTIL_TYPE = GR.CODE_UTIL_TYPE                      
MFA-TR*          AND GG.MTR_TEST_GRP_CD = GR.MTR_TEST_GRP_CD                    
MFA-TR*          AND GG.COMPANY_NO     = GR.COMPANY_NO                          
MFA-TR*          AND ((GR.SELECT_TYPE_CD  = 'T'                                 
MFA-TR*              AND :GM-DATE-LAST-TESTED BETWEEN                           
MFA-TR*                                 GG.BEGIN_PURCHASE_DT                    
MFA-TR*                             AND GG.END_PURCHASE_DT)                     
MFA-TR*             OR (GR.SELECT_TYPE_CD  = 'P'                                
MFA-TR*              AND :EQ-DATE-PURCHASED   BETWEEN                           
MFA-TR*                                 GG.BEGIN_PURCHASE_DT                    
MFA-TR*                             AND GG.END_PURCHASE_DT))                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO CLS76-RETURN-CODE     
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7100'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_GAS_TST_GROUP'         TO TABLE-1               
              MOVE 'CSS_MTR_TEST_GROUP'        TO TABLE-2               
              MOVE 'METER_SIZE_ID'             TO TABLE-ELEMENT-1       
              MOVE 'METER_NO'                  TO TABLE-ELEMENT-2       
              MOVE 'COMPANY_NO'                TO TABLE-ELEMENT-3       
              MOVE GM-METER-SIZE-ID            TO HOSTVAR-ELEMENT-1     
              MOVE GM-METER-NO                 TO HOSTVAR-ELEMENT-2     
              MOVE GM-COMPANY-NO               TO HOSTVAR-ELEMENT-3     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7200-CHECK-MTR-HIST.                                             
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT SELECTED_QT                                       
                     ,SAMPLE_MIN_QT                                     
                     ,SAMPL_OVERAGE_PCT                                 
                     ,SAMPL_CORRECTV_PCT                                
                     ,SAMPL_ADDITIONL_QT                                
                     ,ROUND(COALESCE(SAMPLE_MIN_QT +                
                       (SAMPLE_MIN_QT                                   
                           * SAMPL_OVERAGE_PCT /100),0),0)               
                     ,STATUS_CD                                         
               INTO   :MQ-SELECTED-QT                                   
                     ,:MQ-SAMPLE-MIN-QT                                 
                     ,:MQ-SAMPL-OVERAGE-PCT                             
                     ,:MQ-SAMPL-CORRECTV-PCT                            
                     ,:MQ-SAMPL-ADDITIONL-QT                            
                     ,:WS-TARGET-QT                                     
                     ,:MQ-STATUS-CD                                     
               FROM CSS_MTR_TEST_HIST WITH(READUNCOMMITTED)                     
               WHERE CODE_UTIL_TYPE      = :MQ-CODE-UTIL-TYPE           
                 AND TEST_YEAR           = :MQ-TEST-YEAR                
                 AND TEST_SCHED_CD       = 'R'                          
                 AND MTR_TEST_GRP_CD     = :MQ-MTR-TEST-GRP-CD          
                 AND COMPANY_NO          = :MQ-COMPANY-NO               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SELECTED_QT                                               
MFA-TR*              ,SAMPLE_MIN_QT                                             
MFA-TR*              ,SAMPL_OVERAGE_PCT                                         
MFA-TR*              ,SAMPL_CORRECTV_PCT                                        
MFA-TR*              ,SAMPL_ADDITIONL_QT                                        
MFA-TR*              ,INT(ROUND(COALESCE(SAMPLE_MIN_QT +                        
MFA-TR*                (SAMPLE_MIN_QT                                           
MFA-TR*                    * SAMPL_OVERAGE_PCT /100),0)))                       
MFA-TR*              ,STATUS_CD                                                 
MFA-TR*        INTO   :MQ-SELECTED-QT                                           
MFA-TR*              ,:MQ-SAMPLE-MIN-QT                                         
MFA-TR*              ,:MQ-SAMPL-OVERAGE-PCT                                     
MFA-TR*              ,:MQ-SAMPL-CORRECTV-PCT                                    
MFA-TR*              ,:MQ-SAMPL-ADDITIONL-QT                                    
MFA-TR*              ,:WS-TARGET-QT                                             
MFA-TR*              ,:MQ-STATUS-CD                                             
MFA-TR*        FROM CSS_MTR_TEST_HIST                                           
MFA-TR*        WHERE CODE_UTIL_TYPE      = :MQ-CODE-UTIL-TYPE                   
MFA-TR*          AND TEST_YEAR           = :MQ-TEST-YEAR                        
MFA-TR*          AND TEST_SCHED_CD       = 'R'                                  
MFA-TR*          AND MTR_TEST_GRP_CD     = :MQ-MTR-TEST-GRP-CD                  
MFA-TR*          AND COMPANY_NO          = :MQ-COMPANY-NO                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO CLS76-RETURN-CODE     
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7200'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_MTR_TEST_HIST'         TO TABLE-1               
              MOVE 'MTR_TEST_GRP_CD'           TO TABLE-ELEMENT-1       
              MOVE 'METER_NO'                  TO TABLE-ELEMENT-2       
              MOVE 'TEST_YEAR'                 TO TABLE-ELEMENT-3       
              MOVE MQ-MTR-TEST-GRP-CD          TO HOSTVAR-ELEMENT-1     
              MOVE GM-METER-NO                 TO HOSTVAR-ELEMENT-2     
              MOVE MQ-TEST-YEAR                TO HOSTVAR-ELEMENT-3     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7300-CHECK-USAGE-HIST.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 1                                                 
               INTO   :CX-NO-UNITS                                      
               FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                      
               WHERE CODE_UTIL_TYPE      = :CX-CODE-UTIL-TYPE           
                 AND METER_NO            = :CX-METER-NO                 
                 AND ACCOUNT_NO          = :CX-ACCOUNT-NO               
                 AND NO_UNITS            >  0                           
                 AND CODE_METER_READ     = 'J'                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1                                                         
MFA-TR*        INTO   :CX-NO-UNITS                                              
MFA-TR*        FROM CSS_CNSMPTN_HIST                                            
MFA-TR*        WHERE CODE_UTIL_TYPE      = :CX-CODE-UTIL-TYPE                   
MFA-TR*          AND METER_NO            = :CX-METER-NO                         
MFA-TR*          AND ACCOUNT_NO          = :CX-ACCOUNT-NO                       
MFA-TR*          AND NO_UNITS            >  0                                   
MFA-TR*          AND CODE_METER_READ     = 'J'                                  
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO CLS76-RETURN-CODE     
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7300'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_CNSMPTN_HIST'          TO TABLE-1               
              MOVE 'MTR_TEST_GRP_CD'           TO TABLE-ELEMENT-1       
              MOVE 'METER_NO'                  TO TABLE-ELEMENT-2       
              MOVE 'TEST_YEAR'                 TO TABLE-ELEMENT-3       
              MOVE MQ-MTR-TEST-GRP-CD          TO HOSTVAR-ELEMENT-1     
              MOVE GM-METER-NO                 TO HOSTVAR-ELEMENT-2     
              MOVE MQ-TEST-YEAR                TO HOSTVAR-ELEMENT-3     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7900-GET-CURRENT-DATE.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
             SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TODAYS-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-TODAYS-DATE = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO CLS76-RETURN-CODE     
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7900'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SET'                       TO ABEND-FUNCTION        
              MOVE 'SYSDUMMY1'                 TO TABLE-1               
              MOVE 'METER_NO'                  TO TABLE-ELEMENT-1       
              MOVE GM-METER-NO                 TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7990-GET-DELINQUENCY.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
              WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
                AND   COMPANY_NO = :C8-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*       INTO    :C8-DELINQ-VALUE                                          
MFA-TR*       FROM    CSS_DELINQUENCY                                           
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*         AND   COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7990                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO CLS76-RETURN-CODE     
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7990'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_DELINQUENCY'           TO TABLE-1               
              MOVE 'DELINQ_CD'                 TO TABLE-ELEMENT-1       
              MOVE C8-DELINQ-CD                TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7990-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       8000-UPDATE-TEST-HIST.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_MTR_TEST_HIST                                 
                 SET SELECTED_QT      = SELECTED_QT + 1                 
                    ,AUTO_SELECTED_QT = AUTO_SELECTED_QT + 1            
                    ,STATUS_CD        = :MQ-STATUS-CD                   
               WHERE CODE_UTIL_TYPE      = :MQ-CODE-UTIL-TYPE           
                 AND TEST_YEAR           = :MQ-TEST-YEAR                
                 AND TEST_SCHED_CD       = 'R'                          
                 AND MTR_TEST_GRP_CD     = :MQ-MTR-TEST-GRP-CD          
                 AND COMPANY_NO          = :MQ-COMPANY-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO CLS76-RETURN-CODE     
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '8000'                      TO ACTIVE-PARAGRAPH      
              MOVE 'UPDATE'                    TO ABEND-FUNCTION        
              MOVE 'CSS_MTR_TEST_HIST'         TO TABLE-1               
              MOVE 'MTR_TEST_GRP_CD'           TO TABLE-ELEMENT-1       
              MOVE 'METER_NO'                  TO TABLE-ELEMENT-2       
              MOVE 'TEST_YEAR'                 TO TABLE-ELEMENT-3       
              MOVE MQ-MTR-TEST-GRP-CD          TO HOSTVAR-ELEMENT-1     
              MOVE GM-METER-NO                 TO HOSTVAR-ELEMENT-2     
              MOVE MQ-TEST-YEAR                TO HOSTVAR-ELEMENT-3     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       8100-UPDATE-GAS-METER.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_GAS_METER                                     
               SET LAST_TEST_SEL_DT = CAST(SYSDATETIMEOFFSET() AS DATE),        
                   LAST_TEST_SEL_CD = :MQ-MTR-TEST-GRP-CD               
               WHERE CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE                
               AND   METER_NO       = :GM-METER-NO                      
               AND   COMPANY_NO     = :GM-COMPANY-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_GAS_METER                                             
MFA-TR*        SET LAST_TEST_SEL_DT = CURRENT DATE,                             
MFA-TR*            LAST_TEST_SEL_CD = :MQ-MTR-TEST-GRP-CD                       
MFA-TR*        WHERE CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE                        
MFA-TR*        AND   METER_NO       = :GM-METER-NO                              
MFA-TR*        AND   COMPANY_NO     = :GM-COMPANY-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO CLS76-RETURN-CODE     
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '8100'                      TO ACTIVE-PARAGRAPH      
              MOVE 'UPDATE'                    TO ABEND-FUNCTION        
              MOVE 'CSS_GAS_METER'             TO TABLE-1               
              MOVE 'MTR_TEST_GRP_CD'           TO TABLE-ELEMENT-1       
              MOVE 'METER_NO'                  TO TABLE-ELEMENT-2       
              MOVE 'TEST_YEAR'                 TO TABLE-ELEMENT-3       
              MOVE MQ-MTR-TEST-GRP-CD          TO HOSTVAR-ELEMENT-1     
              MOVE GM-METER-NO                 TO HOSTVAR-ELEMENT-2     
              MOVE MQ-TEST-YEAR                TO HOSTVAR-ELEMENT-3     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *    EXEC SQL                                                             
      *       INCLUDE CPD00076                                                  
      *    END-EXEC.                                                            
      *                                                                         
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9999-MCSCB076-EXIT  THRU 9999-EXIT.                  
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-MCSCB076-EXIT.                                              
                                                                        
           GOBACK.                                                      
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
