       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   MCSCA182.                                          
       AUTHOR.       CBSIMDS.                                           
       DATE-WRITTEN. NOVEMBER 1999.                                     
                                                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **           COMPLETE BUSINESS SOLUTIONS INC., MAD             **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **                                                             **         
      **  DATE    INITIALS             REASON                        **         
      **________  ________           ______________                  **         
      **                                                             **         
      ** 11/99    CBSI            INITIAL VERSION OF  SUB PROGRAM    **         
      **          MADRAS          RETURNING LAST UPDATE TS           **         
REARCH** 06/16/03 AD88124         CODE CHANGES MADE TO CALL THIS     **         
REARCH**                          PROGRAM FROM DB2 STORED PROCEDURE. **         
      *****************************************************************         
      *                    PROGRAM NARRATIVE                          *         
      *                                                               *         
      *  THIS PROGRAM USES THE PARM VALUES SENT BY THE CALLING        *         
      *  PROGRAM TO RETRIEVE THE LAST UPDATE TIMESTAMP FROM CSS_      *         
      *  ACCOUNT                                                      *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                6000 - 6999     INPUT MODULES                           
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
                                                                        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'MCSCA182'.
MSQ017     COPY MFASQLM.
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * WORKING STORAGE ERROR HANDLING COPY BOOK.                               
      *****************************************************************         
      *                                                                         
       COPY CWS00303.                                                   00896011
REARCH*COPY CWS00010.                                                           
      *****************************************************************         
      * COPY BOOK HOLDING LINK VARIABLES                                        
      *****************************************************************         
REARCH*COPY CWS00182.                                                           
      *                                                                         
       LINKAGE SECTION.                                                 
                                                                        
REARCH*01  DFHCOMMAREA                       PIC X(885).                        
COB305 01 SCSCA182-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.  
REARCH 01 SCSCA182-RETURN-CODE               PIC S9(09).                
REARCH 01 SCSCA182-LAST-UPDATE-TS            PIC X(26).                 
REARCH    COPY CWS00010.                                                        
      *                                                                         
REARCH PROCEDURE DIVISION USING  SCSCA182-ACCOUNT-NO                    
                                ,SCSCA182-RETURN-CODE                   
                                ,SCSCA182-LAST-UPDATE-TS                
                                ,ABEND-FILE.                            
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
REARCH*    IF  EIBCALEN IS EQUAL LENGTH OF SCSCA182-LINK-RECORD                 
REARCH*        MOVE DFHCOMMAREA              TO SCSCA182-LINK-RECORD            
REARCH     IF SCSCA182-ACCOUNT-NO > 0                                   
               PERFORM 2000-PROCESS-OUTPUT   THRU 2000-EXIT             
           ELSE                                                         
               MOVE 100                      TO SQLCODE                 
               MOVE 'BAD DATA'               TO ABEND-FUNCTION          
               MOVE SQLCODE                  TO SCSCA182-RETURN-CODE    
           END-IF.                                                      
      *                                                                         
REARCH*    MOVE ABEND-FILE                   TO ABEND-FILE-LK.                  
REARCH*    MOVE SCSCA182-LINK-RECORD         TO DFHCOMMAREA.                    
           PERFORM 9999-SCSCA182-EXIT        THRU 9999-EXIT .           
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  RECEIVES THE INPUT PARMS FROM THE CALLING PROGRAM AND SENDS   *        
      *  BACK THE OUTPUT PARMS TO THE CALLING PROGRAM                  *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE SCSCA182-ACCOUNT-NO          TO AT-ACCOUNT-NO.          
           PERFORM 6000-GET-LAST-UPDATE-TS   THRU 6000-EXIT.            
      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               MOVE AT-LAST-UPDATE-TS        TO SCSCA182-LAST-UPDATE-TS 
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECTS LAST UPDATE TS FROM CSS_ACCOUNT                        *        
      ******************************************************************        
      *                                                                         
       6000-GET-LAST-UPDATE-TS.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                 INTO :AT-LAST-UPDATE-TS                                
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LAST_UPDATE_TS                                            
MFA-TR*          INTO :AT-LAST-UPDATE-TS                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  SQLCODE = SUCCESSFUL-CALL                                
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                TO SCSCA182-RETURN-CODE      
               MOVE '6000'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE  SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSS_ACCOUNT'          TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
           END-IF.                                                      
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * RETURNS TO CALLING PROGRAM                                     *        
      ******************************************************************        
       9999-SCSCA182-EXIT.                                              
      *                                                                         
REARCH*     EXEC CICS                                                           
REARCH*         RETURN                                                          
REARCH*     END-EXEC.                                                           
REARCH     EXIT PROGRAM.                                                
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
