       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. MCS03413.                                            
       AUTHOR. BASKAR VANNI.                                            
       DATE-WRITTEN.                                                    
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *  DATE       INITIALS              REASON                      *         
      *~~~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *         
C35842*07/14/2008 BASKAR VANNI  NEW PROGRAM TO HANDLE DNP/RECONNECT   *         
C35842*                         REAL TIME, THIS INCLUDES CSR02336 AND *         
C35842*                         FG_I_CANCEL_DNP FUNCTIONALITIES       *         
A01004*03/25/2009 BASKAR VANNI  ADD ACCOUNT NO IN ALL ERROR DISPLAYS  *         
A01016*08/11/2009 LG41184       ADD ORDER-TYPE-CD TO CSR00125 FETCH   *         
A01016*                         AND USE IT TO SET UPDATE-PROFILE.     *         
A01016*                         NEW PARM ADDED TO CSR02122.           *         
P00526*09/09/2009 LG41184       CHANGES FOR COLLECTIONS CREDIT/DEBIT  *         
P00526*                         CARD PROJECT.                         *         
P00420*07/29/2010 BASKAR VANNI  MOVED THE MAIN LOGIC INTO CPD03413    *         
P00586*11/29/2013 BASKAR VANNI  ADDED CURRENT USER TO WRITE IN WQ     *         
A05203*10/19/2015 RICK BLACK    ADDED DB2 COPYBOOKS USED BY CPD03413. *         
P00774*11/10/2015 WR19680       ADD NEW CALL FROM CSR02294 FOR        *         
P00774*                         MISC CREDIT                           *         
ACT247*  12/07/15  RB19957      REMOVE REFERENCE TO CSS_DNP_NOT_WORKED*         
ACT247*   APPL00005136,ACT247   DB2 TABLE BECAUSE IT IS NO LONGER     *         
ACT247*                         BEING USED.                           *         
ACT196*07/05/2016  VIJAY        ADDED WS-WQ-CREATED-BY                *         
      * A05460                                                        *         
P00948*08/16/2016  VENKAT.P     LEAST AMOUNT TO P[AY CHANGES          *         
ACT028*02/15/2017  TP7R341      REMOVE STA SUMMARY AND DETAIL TABLES  *         
ACT028*     APPL00005744                                              *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
      *---------------------------------------------------------------*         
      * THIS PROGRAM CANCELS THE DNP ORDER OR MAKE IT TO TURNED DOWN  *         
      * STATUS OR MAKES THE RECONNECT TO ACTIVE DEPENDING ON THE      *         
      * FACILITY CODE AND UPDATE ACTION FLAG PASSED TO THIS PROGRAM.  *         
      *---------------------------------------------------------------*         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'MCS03413'.
MSQ017     COPY MFASQLM.
       01  WS-CONSTANTS.                                                
           05 PROGRAM-NAME                 PIC X(08) VALUE 'MCS03413'.  
           05 WS-A                         PIC X(01) VALUE 'A'.         
           05 WS-B                         PIC X(01) VALUE 'B'.         
           05 WS-H                         PIC X(01) VALUE 'H'.         
           05 WS-DNPFB                     PIC X(05) VALUE 'DNPFB'.     
           05 WS-SDNP                      PIC X(04) VALUE 'SDNP'.      
           05 WS-BMX                       PIC X(04) VALUE 'BMX '.      
P00774     05 WS-MISC-CRED                 PIC X(04) VALUE '310H'.      
           05 WS-SO-ORDER-TYPE-CD-C        PIC X(05) VALUE 'FM006'.     
           05 WS-NOTICE                    PIC X(04) VALUE 'NOTC'.      
           05 WS-SO-PANEL-NO               PIC X(04) VALUE '113'.       
           05 WS-RESOLVED                  PIC X(01) VALUE 'R'.         
           05 WS-INCOMPLETE                PIC X(01) VALUE 'I'.         
           05 WS-SO-REMARK-MSG             PIC X(19) VALUE              
                                               'DISCONNECT CANCELED'.   
           05 WS-WQ-COMMENTS-MSG           PIC X(41) VALUE              
               'DNP CANCELLED, DO NOT WORK SERVICE ORDER '.             
           05 WS-WQ-N-COMMENTS-MSG.                                     
              10 WS-WQ-N-COMMENTS-MSG1     PIC X(54) VALUE              
               'NEW DISCONNECT NOTICE HAS GENERATED WITH NEW DNP DATE,'.
              10 WS-WQ-N-COMMENTS-MSG2     PIC X(26) VALUE              
               ' DO NOT WORK SERVICE ORDER'.                            
           05 WS-WQ-DNPFB-MSG              PIC X(41) VALUE              
               'PAYMT RECVD ON DNPFB; NO RECONNECT EXISTS'.             
           05 WS-WQ-DNP-COMPLETE.                                       
              10  WS-WQ-DNP-MSG1           PIC X(17) VALUE              
               'PAYMENT RECEIVED.'.                                     
              10  WS-WQ-DNP-MSG2           PIC X(22) VALUE              
               'DNP STATE IS COMPLETE.'.                                
              10  WS-WQ-DNP-MSG3           PIC X(44) VALUE              
               'POST ORDER AND REVIEW FOR POSSIBLE RECONNECT'.          
           05 WS-N-WQ-DNP-COMPLETE.                                     
              10 WS-N-WQ-DNP-MSG1          PIC X(54) VALUE              
               'NEW DISCONNECT NOTICE HAS GENERATED WITH NEW DNP DATE;'.
              10 WS-N-WQ-DNP-MSG2          PIC X(55) VALUE              
              ' CANCELLATION OF OLD DNP FAILED BECAUSE OF ORDER STATE/'.
              10 WS-N-WQ-DNP-MSG3          PIC X(39) VALUE              
               ' STATUS; MANUALLY CANCEL THE DNP ORDER.'.               
A05203     05 WS-SYSTEM                    PIC X(07)  VALUE 'SYSTEM'.   
A05203     05 WS-ARRANGEMENT-COMMENTS.                                  
A05203        10 FILLER                    PIC X(45)   VALUE            
A05203           'ARRANGEMENT COMPLETED DURING PAYMENT POSTING.'.       
                                                                        
       01  WS-NULL-INDICATOR.                                           
           05 WS-IND-01                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-02                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-04                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-05                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-06                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-07                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-08                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-09                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-10                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-11                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-12                    PIC S9(04) COMP VALUE +0.    
A05203     05 WS-ARNG-SCHD-SEQ-NULL        PIC S9(04) COMP VALUE -1.    
A05203     05 WS-ARNG-DUE-DT-NULL          PIC S9(04) COMP VALUE -1.    
                                                                        
       01  WS-VARIABLES.                                                
P00948     05 WS-LEAST-AMT-DUE-CD          PIC X(13)  VALUE             
P00948                                                'LEAST-AMT-DUE'.  
P00948     05 WS-LEAST-AMT-DUE             PIC S9(4)V9(2) USAGE COMP-3  
P00948                                                    VALUE 0.      
           05 WS-ACCT-NO-C                 PIC X(13).                   
           05 WS-RECONNECT-IND             PIC X(01) VALUE 'N'.         
           05 WS-COMMENTS                  PIC X(100).                  
           05 WS-UPDATE-PROFILE            PIC X(01).                   
           05 WS-RETURN-FLAG               PIC X(01).                   
COB305     05 WS-DELINQ-VALUE        PIC S9(09) COMP-3 VALUE 0.           
           05 WS-SERVICE-ORDER-NO          PIC 9(13).                   
           05 WS-RELEASE-DATE              PIC X(10) VALUE SPACES.      
           05 WS-CURRENT-DATE              PIC X(10) VALUE SPACES.      
P00586     05 WS-CURR-USER                 PIC X(07) VALUE SPACES.      
           05 WS-WORK-DAY-TABLE.                                        
              10 WS-WORK-DAY-LIST OCCURS 30 TIMES                       
                    ASCENDING KEY WS-WORK-DAY INDEXED BY WD-INDX.       
                 15 WS-WORK-DAY            PIC X(10).                   
           05 WS-ADJ-DAY                   PIC S9(9) COMP.              
           05 WS-ORDER-TYPE-CD             PIC X(05) VALUE SPACES.      
           05 WS-ORDER-STATE-CD            PIC X(01).                   
           05 WS-SERV-ORDER-STATUS         PIC X(02).                   
           05 WS-ORDER-REASON              PIC X(01).                   
COB305     05 WS-SERV-ORDER-NO        PIC 9(13)V USAGE COMP-3 VALUE 0.     
           05 WS-ORDER-REASON-TEMP         PIC X(15).                   
           05 WS-SERV-ORDER-NO-C           PIC X(13).                   
           05 WS-SERV-ORDER-NO-I REDEFINES WS-SERV-ORDER-NO-C           
                                           PIC 9(13).                   
COB305     05 WS-SERV-ORDER-NO-D        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-SO-ORDER-TYPE-FLAG        PIC X(01) VALUE SPACE.       
           05 WS-SO-RETURN-CD              PIC S9(04) COMP.             
           05 WS-DNPFB-RETURN-CD           PIC S9(04) COMP.             
           05 WS-INSERT-WORK-QUEUE         PIC X(01).                   
           05 WS-TEMP-HIST                 PIC X(01).                   
           05 WS-TEMP-HIST-NUM             PIC 9(01).                   
           05 WS-PENDING-DNP-FLAG          PIC X(01).                   
           05 WS-SERV-ORDER-CHAR           PIC X(13).                   
           05 WS-SO-REMARK-TX-C.                                        
              49 WS-SO-REMARK-TX-LEN       PIC S9(4) COMP SYNC VALUE +0.
              49 WS-SO-REMARK-TX-TEXT      PIC X(19) VALUE SPACES.      
           05 WS-RESP-AREA-ID              PIC X(03) VALUE SPACES.      
           05 WS-WQ-PRIORITY-C             PIC X(01).                   
           05 WS-WQ-COMMENTS-C.                                         
              49 WS-WQ-COMMENTS-LEN        PIC S9(4) COMP SYNC VALUE +0.
              49 WS-WQ-COMMENTS-TEXT       PIC X(150) VALUE SPACES.     
           05 WS-AMOUNT-DISC-BAL           PIC X(12).                   
COB305     05 WS-SERV-ORDER-NO-TEMP        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-RCNCT-RETURN-CD           PIC S9(04) COMP.             
           05 WS-WQ-ITEM-ID                PIC S9(10)V COMP-3 VALUE +0. 
           05 WS-WQ-ROUTING-CATGRY-C       PIC X(01).                   
           05 WS-WQ-LOCAL-OFFICE-C         PIC X(03).                   
           05 WS-WQ-USER-ID-ORIG-C         PIC X(07).                   
           05 WS-WQ-USER-ID-ASGN-C         PIC X(07).                   
           05 WS-WQ-RESP-AREA-ID-C         PIC X(03).                   
           05 WS-WQ-CATEGORY-ID-D          PIC S9(04) USAGE COMP.       
           05 WS-WQ-ACCOUNT-NO-C           PIC X(13).                   
           05 WS-WQ-ACCOUNT-NO-I REDEFINES WS-WQ-ACCOUNT-NO-C           
                                           PIC 9(13).                   
COB305     05 WS-WQ-ACCOUNT-NO-D        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-WQ-PREMISE-NO-C           PIC X(10).                   
           05 WS-WQ-PREMISE-NO-I REDEFINES WS-WQ-PREMISE-NO-C           
                                           PIC 9(10).                   
COB305     05 WS-WQ-PREMISE-NO-D        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-WQ-CUSTOMER-NO-C          PIC X(10).                   
           05 WS-WQ-CUSTOMER-NO-I REDEFINES WS-WQ-CUSTOMER-NO-C         
                                           PIC 9(10).                   
COB305     05 WS-WQ-CUSTOMER-NO-D        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-WQ-SERV-ORDER-NO-C        PIC X(13).                   
           05 WS-WQ-SERV-ORDER-NO-I REDEFINES WS-WQ-SERV-ORDER-NO-C     
                                           PIC 9(13).                   
COB305     05 WS-WQ-SERV-ORDER-NO-D        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-WQ-FREE-FORM-AREA-C.                                   
              49 WS-WQ-FREE-FORM-LEN       PIC S9(4) COMP SYNC VALUE +0.
              49 WS-WQ-FREE-FORM-TEXT      PIC X(20) VALUE SPACES.      
           05 WS-SO-UPDATE-REMARKS-C       PIC X(01) VALUE 'Y'.         
           05 WS-SO-SELECT-UPDATE-C        PIC X(01) VALUE 'U'.         
           05 WS-SO-DNP-CANCEL-REASON      PIC X(01).                   
           05 WS-CURR-TIMESTAMP            PIC X(26).                   
           05 WS-WQ-DATE-REQUIRED          PIC X(26).                   
           05 WS-WQ-DATE-CREATED           PIC X(26).                   
ACT196     05 WS-WQ-CREATED-BY             PIC X(16).                   
           05 WS-SO-ACCOUNT-NO-C           PIC X(13).                   
           05 WS-SO-ACCOUNT-NO-I REDEFINES WS-SO-ACCOUNT-NO-C           
                                           PIC 9(13).                   
           05 WS-SO-PREMISE-NO-C           PIC X(10).                   
           05 WS-SO-PREMISE-NO-I REDEFINES WS-SO-PREMISE-NO-C           
                                           PIC 9(10).                   
           05 WS-SO-USER-ID-C              PIC X(06) VALUE 'SYSTEM'.    
           05 WS-RETURN-CODE               PIC S9(4) COMP.              
           05 WS-LOCAL-OFFICE              PIC X(03) VALUE SPACES.      
           05 WS-WORK-AREA                 PIC X(40) VALUE SPACES.      
           05 WS-CREW-ID                   PIC X(06) VALUE SPACES.      
COB305     05 WS-ITEM-ID        PIC S9(10) COMP-3 VALUE 0.           
           05 WS-CAD-TRANS-TY-ACT          PIC X(01).                   
A05203     05 WS-AMT-TO-COMPLY             PIC S9(09)V99 COMP-3 VALUE 0.
A05203     05 WS-TOTAL-ARREARS             PIC S9(9)V99 COMP-3 VALUE 0. 
A05203     05 WS-ARNG-COMPLIANCE-CD        PIC X(02) VALUE SPACES.      
A05203     05 WS-COMP-2-CHAR-CONV          PIC ZZZZZZZZ9.99.            
A05203     05 WS-PYMT-AMOUNT             PIC S9(09)V99 COMP-3 VALUE +0. 
A05203     05 S-RETURN-CODE                PIC S9(4).                   
A05203     05 S-ACTIVE-PARAGRAPH           PIC X(05).                   
                                                                        
      *01  LOC1      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC2      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC3      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC4      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC5      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC6      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC7      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC8      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC9      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC10     USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-TURN-DOWN-SW              PIC X(01) VALUE 'N'.          
             88 TURNED-DOWN                         VALUE 'T'.          
             88 NOT-TURNED-DOWN                     VALUE 'N'.          
          05 WS-DATABASE-SW               PIC 9(01) VALUE 0.            
             88 CSR-DATABASE                        VALUE 1.            
             88 SEB-DATABASE                        VALUE 2.            
          05 WS-UPDATE-ACTION             PIC X(01) VALUE SPACES.       
             88 BILLING                             VALUE 'B'.          
             88 PAYMENT                             VALUE 'P'.          
             88 TURN-DOWN                           VALUE 'T'.          
             88 NEW-NOTICE                          VALUE 'N'.          
          05 WS-WORK-QUEUE-SW             PIC X(01) VALUE SPACES.       
             88 DNP-CANCEL-WQ                       VALUE 'A'.          
             88 DNP-COMPLETE-WQ                     VALUE 'B'.          
             88 DNPFB-WQ                            VALUE 'C'.          
             88 NEW-NOTICE-WQ                       VALUE 'D'.          
          05 WS-SO-UPDATE-WORKED-SW       PIC X(01) VALUE 'N'.          
             88 SO-UPDATE-WORKED                    VALUE 'Y'.          
             88 SO-UPDATE-NOT-WORKED                VALUE 'N'.          
          05 WS-DNP-SWITCH                PIC X(01) VALUE 'N'.          
             88 WS-DNP01                            VALUE 'D'.          
             88 WS-DNP-FINALBILL                    VALUE 'F'.          
          05 WS-RETURN-CD-SW              PIC X(01) VALUE ' '.          
             88 RETURN-CODE-5000                    VALUE 'A'.          
             88 RETURN-CODE-100                     VALUE 'B'.          
          05 WS-DNP-REC-ERR-SW            PIC X(01) VALUE ' '.          
             88 DNP-ERROR                           VALUE 'A'.          
             88 RECONNECT-ERROR                     VALUE 'B'.          
P00526    05 WS-PAID-SENT-SW              PIC X(01) VALUE 'N'.          
P00526       88 PAID-SENT                           VALUE 'Y'.          
P00526       88 PAID-NOT-SENT                       VALUE 'N'.          
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * SQL COMMUNICATION AREA                                        *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_ACCOUNT - AT                                           *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBACCT                                                      
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_DELINQUENCY - C8                                       *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBDELQ                                                      
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_HOLIDAY - J8                                           *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBHLDAY                                                     
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_CREDIT_PROFILE - CZ                                    *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCRPROF                                                    
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_PREMISE - PR                                           *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBPREM                                                      
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_SO_DATA VO                                             *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBSODAT                                                     
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_SO_DNP_CANCEL - XK                                     *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBSODNPC                                                    
           END-EXEC.                                                            
                                                                        
A05203*********** START OF DB2 INCLUDES FOR CPD03413 ************               
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203* CPD00068 WORKING STORAGE COPYBOOK                             *         
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203     EXEC SQL                                                             
A05203        INCLUDE CWS00068                                                  
A05203     END-EXEC.                                                            
A05203                                                                  
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203* CSS_MNT_TRANS_HIST - MH                                                 
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203     EXEC SQL                                                             
A05203        INCLUDE TBMNHIST                                                  
A05203     END-EXEC.                                                            
A05203                                                                  
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203* CSS_MT_TRN_HST_DET - MI                                                 
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203     EXEC SQL                                                             
A05203        INCLUDE TBMNHDT                                                   
A05203     END-EXEC.                                                            
A05203                                                                  
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203* CSS_USER_PROFILE - PF                                                   
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203     EXEC SQL                                                             
A05203        INCLUDE TBUSRPRF                                                  
A05203     END-EXEC.                                                            
A05203                                                                  
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203* CSS_CRED_ARNG_ACTN - W4                                                 
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203     EXEC SQL                                                             
A05203       INCLUDE TBCRDACT                                                   
A05203     END-EXEC.                                                            
A05203                                                                  
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203* CSS_CRED_ARNGMENT   - X1                                                
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203     EXEC SQL                                                             
A05203       INCLUDE TBCRARNG                                                   
A05203     END-EXEC.                                                            
A05203                                                                  
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203* CSS_CRED_ARNG_HIST  - WY                                                
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203     EXEC SQL                                                             
A05203       INCLUDE TBCRARHS                                                   
A05203     END-EXEC.                                                            
A05203                                                                  
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203*  CSS_ARNG_ATTR      - UY                                                
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203     EXEC SQL                                                             
A05203       INCLUDE TBARGATT                                                   
A05203     END-EXEC.                                                            
A05203                                                                  
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203*  CSS_BILLING_HDR    - BI                                                
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203     EXEC SQL                                                             
A05203        INCLUDE TBBLLHDR                                                  
A05203     END-EXEC.                                                            
A05203                                                                  
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203* CSS_CRED_ARNG_SCHD  - WX                                                
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203     EXEC SQL                                                             
A05203       INCLUDE TBCRARSC                                                   
A05203     END-EXEC.                                                            
A05203                                                                  
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203*  CSS_REG_PROFILE    - LR                                                
A05203*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A05203     EXEC SQL                                                             
A05203       INCLUDE TBREGPRF                                                   
A05203     END-EXEC.                                                            
A05203************* END OF DB2 INCLUDES FOR CPD03413 ************               
                                                                        
       COPY FIOJC01.                                                            
      * DB2 SQL ERROR CHECKING                                                  
       COPY CWS00303.                                                           
      * CODES-DATA-PRESENT FROM CSS_ACCOUNT                                     
       COPY CWS00056.                                                           
MSQ001        EXEC SQL
MSQ001          DECLARE C1 CURSOR
MSQ001          FOR CALL CSR00125                                       
                   ( :WS-SO-ACCOUNT-NO-C
                  , :WS-SO-PREMISE-NO-C
                  , :WS-SO-USER-ID-C
                  , :WS-SO-REMARK-TX-C
                  , :WS-SO-UPDATE-REMARKS-C
                  , :WS-SO-SELECT-UPDATE-C
                  , :WS-SO-PANEL-NO
                  , :WS-SO-ORDER-TYPE-FLAG
                  , :WS-SO-DNP-CANCEL-REASON
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C8 CURSOR
MSQ001          FOR CALL CSR00336                                       
                         ( :WS-ACCT-NO-C
                  , 'FM006'
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C9 CURSOR
MSQ001          FOR CALL CSR00337                                       
                        ( :WS-SERV-ORDER-NO-C
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C10 CURSOR
MSQ001          FOR CALL CSR02122                                       
                        ( :WS-ACCT-NO-C
                  , :WS-WQ-PREMISE-NO-C
                  , :WS-ORDER-REASON
                  , :WS-SO-DNP-CANCEL-REASON
                  , :WS-PENDING-DNP-FLAG
                  , :WS-UPDATE-PROFILE
                  , :WS-AMOUNT-DISC-BAL
                  , :WS-SO-PANEL-NO
                  , :WS-ORDER-TYPE-CD
                  , :WS-SO-REMARK-TX-C
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C3 CURSOR
MSQ001          FOR CALL CSR04675                                            
                    ( :WS-WQ-ITEM-ID
                  , :WS-WQ-ROUTING-CATGRY-C
                  , :WS-WQ-LOCAL-OFFICE-C
                  , :WS-WQ-USER-ID-ORIG-C
                  , :WS-WQ-USER-ID-ASGN-C
                  , :WS-WQ-RESP-AREA-ID-C
                  , :WS-WQ-CATEGORY-ID-D
                  , :WS-WQ-ACCOUNT-NO-D
                  , :WS-WQ-PREMISE-NO-D
                  , :WS-WQ-CUSTOMER-NO-D
                  , :WS-WQ-SERV-ORDER-NO-D
                  , :WS-WQ-COMMENTS-C
                  , :WS-WQ-DATE-REQUIRED
                  , :WS-WQ-DATE-CREATED
                  , :WS-WQ-PRIORITY-C
                  , :WS-WQ-FREE-FORM-AREA-C
                  , :WS-WQ-CREATED-BY
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C4 CURSOR
MSQ001          FOR CALL CSR04422                                       
                       ( :WS-SO-ACCOUNT-NO-C
                  , :WS-SO-ORDER-TYPE-CD-C
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR00423                                            
                    ( :WS-SERV-ORDER-NO-D
                  )
MSQ001        END-EXEC.
                  
                                                                        
       LINKAGE SECTION.                                                 
       01 WS-ACCOUNT-NO            PIC 9(13).                           
       01 WS-UPDATE-ACTION-FL      PIC X(01).                           
       01 WS-FACILITY-CODE         PIC X(01).                           
       01 WS-DNP-RET-CODE          PIC S9(4) COMP.                      
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION USING                                         
                           WS-ACCOUNT-NO                                
                         , WS-UPDATE-ACTION-FL                          
                         , WS-FACILITY-CODE                             
                         , WS-DNP-RET-CODE                              
                         , ABEND-FILE.                                  
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *                          M A I N L I N E                      *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       0000-MAINLINE.                                                   
      *--------------*                                                          
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-ACCOUNT                                 
              THRU 1000-EXIT                                            
                                                                        
           EXIT PROGRAM                                                 
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD03413                                                  
           END-EXEC.                                                            
A05203*                                                                         
A05203     EXEC SQL                                                             
A05203        INCLUDE CPD00067                                                  
A05203     END-EXEC.                                                            
A05203*                                                                         
A05203 9000-SEND-ERROR-RESULT.                                          
A05203                                                                  
A05203     MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
A05203                                   ABEND-SQLCODE.                 
A05203                                                                  
A05203     EXEC SQL                                                     
A05203         ROLLBACK                                                 
A05203     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05203                                                                  
A05203     IF SQLCODE = 0                                               
A05203        CONTINUE                                                  
A05203     ELSE                                                         
A05203        MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
A05203     END-IF.                                                      
A05203*                                                                 42900000
A05203 9000-EXIT.                                                       
A05203*                                                                 42920000
A05203*******************************************************           42920000
A05203*   9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT COPYBOOK   *           42920000
A05203*******************************************************           42920000
A05203     EXEC SQL                                                     42920000
A05203        INCLUDE CPDSP300                                          42920000
A05203     END-EXEC.                                                    42920000
