       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     GMC660.                                          
       DATE-WRITTEN.   JULY 1997.                                       
      ***************************************************************** 00040000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** 00050000
      **        SCE&G, COMPLETE BUSINESS SOLUTIONS INDIA LTD.        ** 00060000
      **                     MADRAS, INDIA                           ** 00070000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00080000
      ********                      DB2                       ********* 00090000
      ***************************************************************** 00100000
      **                                                             ** 00110000
      **               PROGRAM  MODIFICATION  LOG                    ** 00120000
      **                                                             ** 00130000
      **    DATE     INITIALS                 REASON                 ** 00140000
      **  ________   ________   ___________________________________  ** 00150000
T14965**   02/98      CBSI      CHANGED  ERROR MESSAGE FOR SQLCODE   ** 00160000
      **                        OF 100 IN 7500-GET-CURRENT-DATE.     ** 00160100
      **                        CHANGED CODE TO DO AN INSERT ON      ** 00160200
      **                        CSS_MTR_TEST_STATS IF NO RECORD IS   ** 00160300
      **                        FOUND DURING UPDATE ON               ** 00160400
      **                        CSS_MTR_TEST_STATS.                  ** 00160500
      **                                                             ** 00160600
T18125**   10/98      CBSI      CHANGES MADE TO CALCULATE MEAN, STAND.* 00160700
      **                        DEVIATION & OTHER STATISTICS CORRECTLY* 00160800
      **                        PROGRAM NAME IS CHANGED FROM PCSMT660** 00161000
      **                        TO GMC660 AS PER STANDARDS.          ** 00161000
      **                                                             ** 00161000
T33287**   11/05      JC91900   CONVERT ALL COMPONENTS RELATED TO ELE**         
T33287**                        SUBSYSTEM TO ELC.                    **         
      **                                                             ** 00161000
A05136** 24 JUN 2015  RF10596   REMOVE COMMENTED OUT DATA            **         
      **                                                             ** 00161000
      ***************************************************************** 00162000
           REMARKS.                                                     
                              GMC660 NARRATIVE                          
      ******************************************************************00190000
      *                    GAS METER SAMPLING ANALYSIS                 *00200000
      *         THIS PROGRAM ANALYZES THE RESULTS OF EACH SAMPLE TEST  *00201000
      *         GROUP. THE PROGRAM CAN BE RUN IN REPORT/UPDATE MODE.   *00210000
      *         WHEN THE PROGRAM IS RUN IN REPORT MODE, IT PRODUCES    *00220000
      *         A REPORT OF THE ANALYSIS RESULTS. WHEN THE PROGRAM IS  *00230000
      *         RUN IN UPDATE MODE, IT WILL UPDATE TABLES MTR_TEST_HIST*00240000
      *         MTR_TEST_STATS AND PRODUCES A REPORT.                  *00250000
      ******************************************************************00260000
      *                                                                 00270000
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    2000 - 4999     MAJOR PROCESSING LOOP               
                    5000 - 5999     COMMON PROGRAM MODULES              
                    7000 - 7999     SQL MODULES                         
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
HPCCDM*EJECT                                                            00400000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER. IBM-3090 WITH DEBUGGING MODE.                   
       OBJECT-COMPUTER. IBM-3090.                                       
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
      *                                                                 00460000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSMT16.                                                    00490000
       COPY CSSMT14.                                                    00500000
       COPY CSSPT33.                                                    00501000
       COPY CSSP232.                                                    00540000
T18125 COPY CSSP233.                                                    00550001
      *                                                                 00570000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDMT16.                                                    00600000
       COPY FIOMT16.                                                    00610000
       COPY CFDMT14.                                                    00620000
       COPY FIOMT14.                                                    00630000
       COPY CFDPT33.                                                    00631000
       COPY CFDP232.                                                    00640000
T18125 COPY CFDP233.                                                    00650001
                                                                        
      *                                                                 00760000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'GMC660'.
MSQ017     COPY MFASQLM.
       01  WS-START                            PIC X(40) VALUE          
           'WORKING STORAGE FOR GMC660 STARTS HERE'.                    
      *                                                                 00800000
      * PSNC TEST SELECTION & AQL INDEX VALUES                          00800000
       COPY GMCCSAMP.                                                   00810000
      *                                                                 00800000
      * SCEG TEST SELECTION & AQL INDEX VALUES                          00800000
T33287 COPY ELCHSAMP.                                                   00810000
      *                                                                 00800000
       01  WS-B5-PERCENT-DEFECTIVE-TABLE.                               
           05  WS-B5-TABLE-ENTRY OCCURS 355 TIMES.                      
               15  WS-B5-QUALITY-INDEX         PIC 99V99.               
               15  WS-B5-EST-PCT-DEFEC OCCURS 16 TIMES                  
                                               PIC 99V999.              
      *                                                                 00870000
       01  WS-B5-SAMPLE-SIZE-TABLE.                                     
           05  WS-B5-SAMPLE-SIZE-DATA.                                  
               15  FILLER                      PIC 999   VALUE 3.       
               15  FILLER                      PIC 999   VALUE 4.       
               15  FILLER                      PIC 999   VALUE 5.       
               15  FILLER                      PIC 999   VALUE 7.       
               15  FILLER                      PIC 999   VALUE 10.      
               15  FILLER                      PIC 999   VALUE 15.      
               15  FILLER                      PIC 999   VALUE 20.      
               15  FILLER                      PIC 999   VALUE 25.      
               15  FILLER                      PIC 999   VALUE 30.      
               15  FILLER                      PIC 999   VALUE 35.      
               15  FILLER                      PIC 999   VALUE 40.      
               15  FILLER                      PIC 999   VALUE 50.      
               15  FILLER                      PIC 999   VALUE 75.      
               15  FILLER                      PIC 999   VALUE 100.     
               15  FILLER                      PIC 999   VALUE 150.     
               15  FILLER                      PIC 999   VALUE 200.     
           05  WS-B5-SAMPLE-SIZE-OCCURS REDEFINES                       
                                          WS-B5-SAMPLE-SIZE-DATA.       
               15  WS-B5-SAMPLE-SIZE-MAX OCCURS 16 TIMES                
                                               PIC 999.                 
      *                                                                 01100000
       01  WS-TEST-RESULT-TABLE.                                        
           05  WS-TEST-RESULT-ENTRY OCCURS 1700 TIMES.                  
T18125         15  WS-TEST-AVG-IN-RATE         PIC 999V999.             
               15  WS-TEST-IS-A-DOG-FLAG       PIC X        VALUE 'N'.  
                   88  WS-TEST-IS-A-DOG                     VALUE 'Y'.  
                   88  WS-TEST-IS-NOT-A-DOG                 VALUE 'N'.  
      *                                                                 01170000
       01  WS-TEST-VARIABLES.                                           
           05  WS-TEST-SUB                     PIC 9(5)     VALUE 0.    
           05  WS-SIZE-SUB                     PIC 9(3)     VALUE 0.    
           05  WS-METER-SUB                    PIC 9(5)     VALUE 0.    
           05  WS-QL-SUB                       PIC 9(3)     VALUE 0.    
           05  WS-NBR-TESTS                    PIC 9(5)     VALUE 0.    
           05  WS-NBR-TEST-RECS                PIC 9(5)     VALUE 0.    
           05  WS-UPPER-QUAL-LIMIT             PIC 9(3)     VALUE 0.    
           05  WS-LOWER-QUAL-LIMIT             PIC 9(3)     VALUE 0.    
           05  WS-NBR-TESTS-WO-DOGS            PIC 9(5)     VALUE 0.    
           05  WS-POPULATION-SIZE              PIC 9(7)     VALUE 0.    
           05  WS-MEAN-DOG-TEST                PIC 9(3)V999 VALUE 0.    
           05  WS-MEAN-DOG-LIMIT               PIC 9(5)V999 VALUE 0.    
           05  WS-TOTAL-DEVIATION              PIC 9(5)V999 VALUE 0.    
           05  WS-TOT-EST-PCT-DEFEC            PIC 9(3)V999 VALUE 0.    
           05  WS-TOT-EST-PCT-DEFEC-E          PIC Z(2)9.999.           
           05  WS-SAMPL-MAX-PCT-DEFEC          PIC 9(3)V999 VALUE 0.    
           05  WS-SAMPL-MAX-PCT-DEFEC-E        PIC Z(2)9.999.           
           05  WS-EST-PCT-DEFEC                PIC 9(2)V999 VALUE 0.    
           05  WS-QUALITY-INDEX                PIC S999V99  COMP-3      
               VALUE +0.                                                
           05  WS-PERFORMANCE-MESSAGE          PIC X(46)    VALUE       
               SPACES.                                                  
           05  WS-COMPARISON-LITERAL           PIC X(02)    VALUE       
               SPACES.                                                  
T18125     05  WS-TOTAL-AVG-IN-RATE            PIC 9(5)V999 VALUE 0.    
T18125     05  WS-SUM-SQR-RATE                 PIC 9(7)V99  VALUE 0.    
T18125     05  WS-AVG-RATE                     PIC 9(3)V9   VALUE 0.    
T18125     05  WS-MAX-LIMIT                    PIC S9(3)V99 COMP-3      
T18125         VALUE +0.                                                
T18125     05  WS-MIN-LIMIT                    PIC S9(3)V99 COMP-3      
T18125         VALUE +0.                                                
      *                                                                 01410000
       01  WS-PARM-DATA.                                                
           05  FILLER                          PIC X(13)  VALUE SPACES. 
           05  WS-GRP-CD                       PIC X(02)  VALUE SPACES. 
           05  FILLER                          PIC X(65)  VALUE SPACES. 
      *                                                                 01460000
       01  WS-UPDATE-REPORT.                                            
           05  FILLER                          PIC X(11)  VALUE SPACES. 
           05  WS-RUNTYPE                      PIC X(06)  VALUE SPACES. 
           05  FILLER                          PIC X(63)  VALUE SPACES. 
      *                                                                 01510000
       01  WS-END-OF-DATA.                                              
           05  FILLER                          PIC X(57)  VALUE SPACES. 
           05  FILLER                          PIC X(20)  VALUE         
               '***END OF REPORT*** '.                                  
           05  FILLER                          PIC X(55)  VALUE SPACES. 
      *                                                                 01561000
T18125 01  WS-NO-DATA-LINE.                                             
T18125     05  FILLER                  PIC X(55)    VALUE SPACES.       
T18125     05  FILLER                  PIC X(22)    VALUE               
T18125               '***NO DATA THIS RUN***'.                          
T18125     05  FILLER                  PIC X(55)    VALUE SPACES.       
T18125*                                                                 02720000
       01  WS-LITERALS.                                                 
           05  WS-ONE                          PIC 9(02)  VALUE 1.      
           05  WS-A                            PIC X(01)  VALUE 'A'.    
           05  WS-N                            PIC X(01)  VALUE 'N'.    
           05  WS-Y                            PIC X(01)  VALUE 'Y'.    
           05  WS-P                            PIC X(01)  VALUE 'P'.    
           05  WS-R                            PIC X(01)  VALUE 'R'.    
           05  WS-E                            PIC X(01)  VALUE 'E'.    
           05  WS-F                            PIC X(01)  VALUE 'F'.    
           05  WS-G                            PIC X(01)  VALUE 'G'.    
T18125     05  WS-J                            PIC X(01)  VALUE 'J'.    
           05  WS-NO                           PIC X(01)  VALUE 'N'.    
           05  WS-YES                          PIC X(01)  VALUE 'Y'.    
           05  WS-RUN-DATE                     PIC X(10).               
           05  WS-COMP-NO                      PIC X(2)   VALUE '01'.   
           05  WS-UPDATE                       PIC X(06)  VALUE         
               'UPDATE'.                                                
           05  WS-REPORT                       PIC X(06)  VALUE         
               'REPORT'.                                                
           05  WS-PGRMNAME                     PIC X(08)  VALUE         
               'GMC660'.                                                
           05  WS-SQLCODE                      PIC -ZZZZZZZZ9.9.        
      *                                                                 01780000
       01  WS-MISC.                                                     
T22243     05  WS-SYSIN-COMP-NO                PIC X(02)  VALUE SPACES. 
           05  WS-SUB                          PIC 9(03)  VALUE ZEROES. 
           05  WS-SUB1                         PIC 9(03)  VALUE ZEROES. 
           05  WS-LINE-COUNT                   PIC 9(02)  VALUE 57.     
           05  WS-ERR-COUNT                    PIC 9(02)  VALUE 57.     
T18125     05  WS-DTL-COUNT                    PIC 9(02)  VALUE 57.     
           05  WS-PAGE-COUNT                   PIC 9(03)  VALUE ZEROES. 
           05  WS-ERR-PAGE-NO                  PIC 9(03)  VALUE ZEROES. 
T18125     05  WS-DTL-PAGE-NO                  PIC 9(03)  VALUE ZEROES. 
           05  WS-MAX-B5-ROWS                  PIC 9(03)  VALUE 355.    
      *                                                                 01860000
       01  WS-SWITCHES.                                                 
           05  WS-B5-FOUND                     PIC X(01)  VALUE 'N'.    
               88  B5-FOUND                               VALUE 'Y'.    
               88  B5-NOT-FOUND                           VALUE 'N'.    
           05  WS-B3-FOUND                     PIC X(01)  VALUE 'N'.    
               88  B3-FOUND                               VALUE 'Y'.    
               88  B3-NOT-FOUND                           VALUE 'N'.    
           05  WS-GROUP-CD-FOUND               PIC X(01)  VALUE 'N'.    
               88  GROUP-CD-FOUND                         VALUE 'Y'.    
               88  GROUP-CD-NOT-FOUND                     VALUE 'N'.    
           05  WS-INV-TEST-QTY                 PIC X(01)  VALUE 'N'.    
               88  TEST-QTY-LOW                           VALUE 'Y'.    
           05  WS-FILE-FLAG                    PIC X(01)  VALUE 'Y'.    
               88  MORE-RECORDS                           VALUE 'Y'.    
               88  NO-MORE-RECORDS                        VALUE 'N'.    
           05  WS-UPDATE-FLAG                  PIC X(01)  VALUE 'N'.    
               88  UPDATE-FLAG                            VALUE 'Y'.    
           05  WS-FMT14-STATUS                 PIC X(02)  VALUE '00'.   
               88  FMT14-SUCCESS                          VALUE '00'.   
           05  WS-FMT16-STATUS                 PIC X(02)  VALUE '00'.   
               88  FMT16-SUCCESS                          VALUE '00'.   
T18125     05  WS-END-PROCESS                  PIC X(01)  VALUE 'N'.    
T18125         88  END-OF-PROCESS                         VALUE 'Y'.    
           05  WS-TRACE-SW                     PIC X(01)  VALUE 'N'.    
               88  WS-TRACE-ON                            VALUE 'Y'.    
               88  WS-TRACE-OFF                           VALUE 'N'.    
      *                                                                 02070000
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                           PIC 9(02).               
           05  WS-MM                           PIC 9(02).               
           05  WS-SS                           PIC 9(02).               
           05  WS-TT                           PIC 9(02).               
      *                                                                 02130000
       COPY CWS00303.                                                   02140000
       COPY CWS09900.                                                   02150000
      *                                                                 02160000
       COPY CWS00004.                                                   02170000
       COPY CWS00010.                                                   02180000
       COPY CWS00301.                                                   02190000
LP     COPY CWS00038.                                                           
LP     COPY CWS00039.                                                           
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
      *                                                                 02200000
       01  WS-REPORT-AREA.                                              
           05  HEADER-01.                                               
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  FILLER                      PIC X(09)  VALUE         
                   'GMC660-'.                                           
               10  HDR-01-SUFFIX               PIC X(02).               
               10  FILLER                      PIC X(40)  VALUE SPACES. 
T22243         10  HDR-01-TITLE                PIC X(31)  VALUE SPACES. 
               10  FILLER                      PIC X(28)  VALUE SPACES. 
               10  FILLER                      PIC X(09)  VALUE         
                   'RUN DATE:'.                                         
T18125         10  HDR-01-DATE                 PIC X(10).               
      *                                                                 02330000
           05  HEADER-02.                                               
               10  FILLER                      PIC X(50)  VALUE SPACES. 
               10  FILLER                      PIC X(31)  VALUE         
                   'GAS METERS SAMPLE ANALYSIS FOR '.                   
               10  HDR-02-YEAR                 PIC X(04)  VALUE SPACES. 
               10  FILLER                      PIC X(26)  VALUE SPACES. 
               10  FILLER                      PIC X(11)  VALUE         
                   'RUN TIME:  '.                                       
               10  HDR-02-TIME.                                         
                   15 HDR-02-HH                PIC X(02)  VALUE SPACES. 
                   15 FILLER                   PIC X(01)  VALUE ':'.    
                   15 HDR-02-MM                PIC X(02)  VALUE SPACES. 
                   15 FILLER                   PIC X(01)  VALUE ':'.    
                   15 HDR-02-SS                PIC X(02)  VALUE SPACES. 
      *                                                                 02480000
           05  HEADER-02A.                                              
               10  FILLER                      PIC X(36)  VALUE SPACES. 
               10  FILLER                      PIC X(42)  VALUE         
                   'METERS WITH LAST TEST DATE > SELECTION DT,'.        
               10  FILLER                      PIC X(18)  VALUE         
                   ' BUT NO TEST FOUND'.                                
               10  FILLER                      PIC X(19)  VALUE SPACES. 
               10  FILLER                      PIC X(05)  VALUE 'PAGE:'.
               10  FILLER                      PIC X(04)  VALUE SPACES. 
               10  HDR-02A-PAGE                PIC ZZ,ZZ9.              
      *                                                                 02482000
           05  HEADER-03.                                               
               10  FILLER                      PIC X(115) VALUE SPACES. 
               10  FILLER                      PIC X(05)  VALUE 'PAGE:'.
               10  FILLER                      PIC X(04)  VALUE SPACES. 
               10  HDR-03-PAGE                 PIC ZZ,ZZ9.              
      *                                                                 02540000
           05  HEADER-04.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'GROUP TESTED.....................................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-04-GRP-CD               PIC X(02)  VALUE SPACES. 
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  HDR-04-GRP-DESC             PIC X(25)  VALUE SPACES. 
               10  FILLER                      PIC X(37)  VALUE SPACES. 
      *                                                                 02640000
           05  HEADER-05.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'SAMPLE SIZE......................................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-05-SAMPL-SIZE           PIC ZZZ,ZZ9.             
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 02720000
T18125     05  HEADER-05A.                                              
T18125         10  FILLER                      PIC X(10)  VALUE SPACES. 
T18125         10  FILLER                      PIC X(50)  VALUE         
T18125             'SUM OF VALUES....................................:'.
T18125         10  FILLER                      PIC X(03)  VALUE SPACES. 
T18125         10  HDR-05A-SUM-VAL             PIC Z(4)9.99.            
T18125         10  FILLER                      PIC X(59)  VALUE SPACES. 
T18125*                                                                 02728000
T18125     05  HEADER-05B.                                              
T18125         10  FILLER                      PIC X(10)  VALUE SPACES. 
T18125         10  FILLER                      PIC X(50)  VALUE         
T18125             'SUM OF SQUARED VALUES............................:'.
T18125         10  FILLER                      PIC X(02)  VALUE SPACES. 
T18125         10  HDR-05B-SUM-SQR-VAL         PIC Z(6)9.99.            
T18125         10  FILLER                      PIC X(59)  VALUE SPACES. 
T18125*                                                                 02729700
           05  HEADER-06.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'STANDARD DEVIATION...............................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-06-STAND-DEV            PIC ZZ9.99.              
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 02800000
           05  HEADER-07.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'X BAR (MEAN).....................................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-07-XBAR                 PIC ZZ9.99.              
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 02880000
           05  HEADER-08.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'UPPER SPECIFICATION LIMIT U......................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-08-UPPER-LIM            PIC ZZ9.99.              
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 02960000
           05  HEADER-09.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'LOWER SPECIFICATION LIMIT L......................:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-09-LOWER-LIM            PIC ZZ9.99.              
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 03040000
           05  HEADER-10.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'UPPER QUALITY INDEX..............................:'.
               10  FILLER                      PIC X(06)  VALUE SPACES. 
               10  HDR-10-UPPER-INDEX          PIC -Z9.99.              
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 03120000
           05  HEADER-11.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'LOWER QUALITY INDEX..............................:'.
               10  FILLER                      PIC X(06)  VALUE SPACES. 
               10  HDR-11-LOWER-INDEX          PIC -Z9.99.              
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 03200000
           05  HEADER-12.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'ESTIMATE OF PERCENT DEFECTIVE ABOVE U (TABLE B-5):'.
               10  FILLER                      PIC X(06)  VALUE SPACES. 
               10  HDR-12-ABOVE-U              PIC Z9.999.              
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 03280000
           05  HEADER-13.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'ESTIMATE OF PERCENT DEFECTIVE BELOW L (TABLE B-5):'.
               10  FILLER                      PIC X(06)  VALUE SPACES. 
               10  HDR-13-BELOW-L              PIC Z9.999.              
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 03360000
           05  HEADER-14.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'ESTIMATE OF PERCENT DOGS.........................:'.
               10  FILLER                      PIC X(06)  VALUE SPACES. 
               10  HDR-14-PER-DOGS             PIC Z9.99.               
               10  FILLER                      PIC X(59)  VALUE SPACES. 
      *                                                                 03440000
           05  HEADER-15.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'TOTAL EST. OF PERCENT DEFECTIVE IN GROUP.........:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-15-TOT-DEFEC            PIC ZZ9.999.             
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 03520000
           05  HEADER-16.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(50)  VALUE         
                   'MAX ALLOWED PERCENT DEFEC (TABLE B-3)............:'.
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  HDR-16-MAX-ALLOW            PIC ZZ9.999.             
               10  FILLER                      PIC X(58)  VALUE SPACES. 
      *                                                                 03600000
           05  HEADER-17.                                               
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  FILLER                      PIC X(40)  VALUE         
                   'THE TESTED RESULT BASED ON TABLE B-5...:'.          
               10  FILLER                      PIC X(80)  VALUE SPACES. 
      *                                                                 03660000
           05  HEADER-18.                                               
               10  FILLER                      PIC X(20)  VALUE SPACES. 
               10  HDR-18-PER-MESG             PIC X(46)  VALUE SPACES. 
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  HDR-18-PART1                PIC X(07).               
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  HDR-18-COM-LIT              PIC X(02)  VALUE SPACES. 
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  HDR-18-PART2                PIC X(07).               
               10  FILLER                      PIC X(45)  VALUE SPACES. 
      *                                                                 03761000
           05  HEADER-19.                                               
               10  FILLER                      PIC X(130) VALUE SPACES. 
      *                                                                 03770000
           05  ERROR-DETAIL.                                            
               10  FILLER                      PIC X(10)  VALUE SPACES. 
               10  ERR-METER-NO                PIC X(09)  VALUE SPACES. 
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  ERR-GR-CD                   PIC X(02)  VALUE SPACES. 
               10  FILLER                      PIC X(05)  VALUE SPACES. 
               10  ERR-DESC                    PIC X(50)  VALUE SPACES. 
               10  FILLER                      PIC X(49)  VALUE SPACES. 
      *                                                                 03840000
T18125     05  WS-RPT3-HDR2.                                            
ST             10  FILLER                      PIC X(46)  VALUE SPACES. 
               10  FILLER                      PIC X(36)  VALUE         
                   'SAMPLE GAS METER TEST PLAN FOR YEAR '.              
               10  WS-RPT3-YEAR                PIC X(04)  VALUE SPACES. 
               10  FILLER                      PIC X(25)  VALUE SPACES. 
               10  FILLER                      PIC X(11)  VALUE         
                   'RUN TIME:  '.                                       
               10  WS-RPT3-TIME.                                        
                   15 WS-RPT3-HH               PIC X(02)  VALUE SPACES. 
                   15 FILLER                   PIC X(01)  VALUE ':'.    
                   15 WS-RPT3-MM               PIC X(02)  VALUE SPACES. 
                   15 FILLER                   PIC X(01)  VALUE ':'.    
                   15 WS-RPT3-SS               PIC X(02)  VALUE SPACES. 
      *                                                                 03841501
           05  WS-RPT3-HDR3.                                            
               10  FILLER                      PIC X(52)  VALUE SPACES. 
               10  FILLER                      PIC X(12)  VALUE         
                   'TEST GROUP: '.                                      
               10  WS-RPT3-GRP-CD              PIC X(02)  VALUE SPACES. 
               10  FILLER                      PIC X(01)  VALUE SPACES. 
               10  WS-RPT3-GRP-DESC            PIC X(25)  VALUE SPACES. 
               10  FILLER                      PIC X(23)  VALUE SPACES. 
               10  FILLER                      PIC X(05)  VALUE 'PAGE:'.
               10  FILLER                      PIC X(04)  VALUE SPACES. 
               10  WS-RPT3-PAGE                PIC ZZ,ZZ9.              
      *                                                                 03844001
           05  WS-RPT3-HDR4.                                            
               10  FILLER                      PIC X(05).               
               10  FILLER                      PIC X(05) VALUE          
                   'METER'.                                             
               10  FILLER                      PIC X(10) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE          
                   'TEST'.                                              
               10  FILLER                      PIC X(07) VALUE SPACES.  
               10  FILLER                      PIC X(16) VALUE          
                   '-INCOMING PROOF-'.                                  
               10  FILLER                      PIC X(04) VALUE SPACES.  
               10  FILLER                      PIC X(16) VALUE          
                   '-OUTGOING PROOF-'.                                  
               10  FILLER                      PIC X(66) VALUE SPACES.  
      *                                                                 03847601
           05  WS-RPT3-HDR5.                                            
               10  FILLER                      PIC X(05).               
               10  FILLER                      PIC X(06) VALUE          
                   'NUMBER'.                                            
               10  FILLER                      PIC X(09) VALUE SPACES.  
               10  FILLER                      PIC X(04) VALUE          
                   'DATE'.                                              
               10  FILLER                      PIC X(07) VALUE SPACES.  
               10  FILLER                      PIC X(16) VALUE          
                   'OPEN CHECK  AVG '.                                  
               10  FILLER                      PIC X(04) VALUE SPACES.  
               10  FILLER                      PIC X(16) VALUE          
                   'OPEN CHECK  AVG '.                                  
               10  FILLER                      PIC X(06) VALUE SPACES.  
               10  FILLER                      PIC X(07) VALUE          
                   'ADDRESS'.                                           
               10  FILLER                      PIC X(52) VALUE SPACES.  
      *                                                                 03852901
           05  WS-RPT3-DETAIL.                                          
               10  FILLER                      PIC X(04).               
               10  WS-RPT3-MTR-NO              PIC X(09).               
               10  FILLER                      PIC X(04) VALUE SPACES.  
               10  WS-RPT3-DATE-TEST           PIC X(10).               
               10  FILLER                      PIC X(03) VALUE SPACES.  
               10  WS-RPT3-IN-OPEN             PIC Z(3).9.              
               10  FILLER                      PIC X(01) VALUE SPACES.  
               10  WS-RPT3-IN-CHECK            PIC Z(3).9.              
               10  FILLER                      PIC X(01) VALUE SPACES.  
               10  WS-RPT3-IN-AVG              PIC Z(3).9.              
               10  FILLER                      PIC X(03) VALUE SPACES.  
               10  WS-RPT3-OUT-OPEN            PIC Z(3).9.              
               10  FILLER                      PIC X(01) VALUE SPACES.  
               10  WS-RPT3-OUT-CHECK           PIC Z(3).9.              
               10  FILLER                      PIC X(01) VALUE SPACES.  
               10  WS-RPT3-OUT-AVG             PIC Z(3).9.              
               10  FILLER                      PIC X(06) VALUE SPACES.  
               10  WS-RPT3-ADDRESS             PIC X(59).               
      *                                                                 03856501
       01  WS-SYSTEM-DATE.                                              
           05  WS-SYSTEM-YY                    PIC 9(02).               
           05  WS-SYSTEM-MM                    PIC 9(02).               
           05  WS-SYSTEM-DD                    PIC 9(02).               
      *                                                                 03890000
       01  WS-FORMAT-DATE.                                              
           05  WS-FORMAT-MM                    PIC 9(02).               
           05  FILLER                          PIC X(01)  VALUE '/'.    
           05  WS-FORMAT-DD                    PIC 9(02).               
           05  FILLER                          PIC X(01)  VALUE '/'.    
           05  WS-FORMAT-YY                    PIC 9(04).               
      *                                                                 03960000
       01  WS-CURRENT-DATE                     PIC X(10).               
       01  WS-CUR-DATE REDEFINES WS-CURRENT-DATE.                       
           10  WS-CURRENT-YEAR                 PIC 9(04).               
           10  FILLER                          PIC X(01).               
           10  WS-CURRENT-MM                   PIC 9(02).               
           10  FILLER                          PIC X(01).               
           10  WS-CURRENT-DD                   PIC 9(02).               
T14965 01  WS-CURRENT-TIMESTAMP                PIC X(26).               
      *                                                                 04040000
       01  WS-END                              PIC X(40) VALUE          
           'WORKING STORAGE FOR GMC660 ENDS HERE  '.                    
      *                                                                 04080000
           EXEC SQL                                                     04090000
               INCLUDE SQLCA                                            04100000
           END-EXEC.                                                    04110000
      *                                                                 04120000
      * TABLE DECLARATION FOR CSS_MTR_TEST_GROUP***************         04130000
      *                                                                 04140000
           EXEC SQL                                                     04150000
               INCLUDE TBMTRGP                                          04160000
           END-EXEC.                                                    04170000
      *                                                                 04180000
      * TABLE DECLARATION FOR CSS_MTR_TEST_HIST****************         04190000
      *                                                                 04200000
           EXEC SQL                                                     04210000
               INCLUDE TBMTRTST                                         04220000
           END-EXEC.                                                    04230000
      *                                                                 04240000
      * TABLE DECLARATION FOR CSS_MTR_TEST_STATS***************         04250000
      *                                                                 04260000
           EXEC SQL                                                     04270000
               INCLUDE TBTSTATS                                         04280000
           END-EXEC.                                                    04290000
      *                                                                 04300000
      * TABLE DECLARATION FOR CSS_GAS_MTR_TEST****************          04310000
      *                                                                 04320000
           EXEC SQL                                                     04330000
               INCLUDE TBGMTEST                                         04340000
           END-EXEC.                                                    04350000
      *                                                                 04360000
      * TABLE DECLARATION FOR CSS_GAS_METER*******************          04370000
      *                                                                 04380000
           EXEC SQL                                                     04390000
               INCLUDE TBGASMTR                                         04400000
           END-EXEC.                                                    04410000
      *                                                                 04420000
      * TABLE DECLARATION FOR CSS_JOB_PARM ********************         04430000
      *                                                                 04440000
           EXEC SQL                                                     04450000
               INCLUDE TBJBPARM                                         04460000
           END-EXEC.                                                    04470000
      *                                                                 04480000
T18125* TABLE DECLARATION FOR CSS_ACCOUNT  ********************         04481002
ST    *                                                                 04482002
           EXEC SQL                                                     04483002
               INCLUDE TBACCT                                           04484002
           END-EXEC.                                                    04485002
      *                                                                 04486002
      * TABLE DECLARATION FOR CSS_PREMISE *********************         04486104
      *                                                                 04486204
           EXEC SQL                                                     04486304
               INCLUDE TBPREM                                           04486404
           END-EXEC.                                                    04486504
      *                                                                 04486604
      * TABLE DECLARATION FOR CSS_MTRD_ENVRNMT ****************         04487002
      *                                                                 04488002
           EXEC SQL                                                     04489002
               INCLUDE TBMTRENV                                         04489102
           END-EXEC.                                                    04489202
      *                                                                 04489302
      * TABLE DECLARATION FOR CSS_EQUIPMENT *******************         04489402
      *                                                                 04489502
           EXEC SQL                                                     04489602
               INCLUDE TBEQUIP                                          04489702
           END-EXEC.                                                    04489802
      *                                                                 04489902
      * TABLE DECLARATION FOR CSS_ADDRESS_FORMATTED ***********         04490002
      *                                                                 04490102
           EXEC SQL                                                     04490202
               INCLUDE TBADRFMT                                         04490302
           END-EXEC.                                                    04490402
      *                                                                 04490502
T22243* TABLE DECLARATION FOR CSS_COMPANY           ***********         04490002
T22243     EXEC SQL                                                             
T22243         INCLUDE TBCOMPNY                                                 
T22243     END-EXEC.                                                            
T22243*                                                                         
           EXEC SQL                                                     04491000
               INCLUDE CWS00042                                         04500000
           END-EXEC.                                                    04510000
      *                                                                 04520000
      ******************************************************************04530000
      * CURSOR FOR SELECTING FROM CSS_JOB_PARM                        **04540000
      ******************************************************************04550000
           EXEC SQL                                                     
              DECLARE  JOB_PARM CURSOR FOR                              
               SELECT  SEQ_NO                                           
                      ,PARM_DATA                                        
                 FROM  CSS_JOB_PARM                                     
                WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                  
                  AND  COMPANY_NO   = :G6-COMPANY-NO                    
                  AND  CMND_CODE    = :G6-CMND-CODE                     
             ORDER BY  SEQ_NO                                           
           END-EXEC.                                                    
      *                                                                 04660000
      ******************************************************************04670000
      * CURSOR FOR SELECTING FROM CSS_MTR_TEST_HIST WHEN THERE ARE NO **04680000
      * ROWS IN CSS_JOB_PARM WITH TEST GROUP CODE.                    **04690000
      ******************************************************************04700000
           EXEC SQL                                                     
              DECLARE  TEST_GROUP CURSOR FOR                            
               SELECT  MQ.MTR_TEST_GRP_CD                               
                      ,GR.MTR_TEST_GRP_TX                               
                      ,MQ.STATUS_CD                                     
                      ,MQ.SELECTED_QT                                   
                      ,MQ.SAMPLE_MIN_QT                                 
                      ,MQ.TESTED_QT                                     
                 FROM  CSS_MTR_TEST_HIST  MQ                            
                      ,CSS_MTR_TEST_GROUP GR                            
                WHERE  MQ.CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE          
T22243            AND  MQ.COMPANY_NO      = GR.COMPANY_NO               
T22243            AND  MQ.COMPANY_NO      = :MQ-COMPANY-NO              
                  AND  MQ.CODE_UTIL_TYPE  = GR.CODE_UTIL_TYPE           
                  AND  MQ.MTR_TEST_GRP_CD = GR.MTR_TEST_GRP_CD          
                  AND  MQ.TEST_YEAR       = :MQ-TEST-YEAR               
                  AND  MQ.TEST_SCHED_CD   = :MQ-TEST-SCHED-CD           
             ORDER BY  MQ.MTR_TEST_GRP_CD                               
           END-EXEC.                                                    
      *                                                                 04880000
      ******************************************************************04890000
      * CURSOR FOR SELECTING METERS FOR THE TEST GROUP WHICH HAVE      *04900000
      * BEEN TESTED. *                                                 *04910000
      ******************************************************************04920000
           EXEC SQL                                                     
              DECLARE  GAS_METER CURSOR FOR                             
               SELECT  METER_NO                                         
                      ,METER_SIZE_ID                                    
                      ,LAST_TEST_SEL_DT                                 
                 FROM  CSS_GAS_METER                                    
                WHERE  CODE_UTIL_TYPE    = :GM-CODE-UTIL-TYPE           
T22243            AND  COMPANY_NO        = :GM-COMPANY-NO               
                  AND  LAST_TEST_SEL_CD  = :GM-LAST-TEST-SEL-CD         
                  AND  DATE_LAST_TESTED >=  LAST_TEST_SEL_DT            
           END-EXEC.                                                    
      *                                                                 05050000
      ******************************************************************05060000
      * CURSOR FOR GETTING THE FIRST TEST AFTER METER SELECTED FOR     *05070000
      * SAMPLE TESTING                                                 *05080000
      ******************************************************************05090000
           EXEC SQL                                                     
               DECLARE  METER_TEST CURSOR FOR                           
                SELECT  EQ_TESTER_ID                                    
                       ,TEST_PROVER_ID                                  
                       ,REPAIR_DESC                                     
                       ,CODE_TEST_TYPE                                  
                       ,IN_CHECK_RATE                                   
                       ,IN_OPEN_RATE                                    
                       ,DATE_TEST                                       
T18125                 ,OUT_CHECK_RATE                                  
T18125                 ,OUT_OPEN_RATE                                   
                  FROM  CSS_GAS_MTR_TEST                                
                 WHERE  CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE             
T22243             AND  COMPANY_NO     = :GT-COMPANY-NO                 
                   AND  METER_NO       = :GT-METER-NO                   
                   AND  DATE_TEST     >= IIF(TRY_CONVERT(DATE, 
                                                          :GT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :GT-DATE-TEST
              ) <> 0) OR (LEN(:GT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :GT-DATE-TEST
              ), CONVERT(DATE, :GT-DATE-TEST) )                  
              ORDER BY DATE_TEST                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05100000
MFA-TR*        DECLARE  METER_TEST CURSOR FOR                           05110000
MFA-TR*         SELECT  EQ_TESTER_ID                                    05120000
MFA-TR*                ,TEST_PROVER_ID                                  05121000
MFA-TR*                ,REPAIR_DESC                                     05140000
MFA-TR*                ,CODE_TEST_TYPE                                  05140000
MFA-TR*                ,IN_CHECK_RATE                                   05150000
MFA-TR*                ,IN_OPEN_RATE                                    05160000
MFA-TR*                ,DATE_TEST                                       05180000
MFA-TR*                ,OUT_CHECK_RATE                                  05181003
MFA-TR*                ,OUT_OPEN_RATE                                   05182003
MFA-TR*           FROM  CSS_GAS_MTR_TEST                                05190000
MFA-TR*          WHERE  CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE             05200000
MFA-TR*            AND  COMPANY_NO     = :GT-COMPANY-NO                         
MFA-TR*            AND  METER_NO       = :GT-METER-NO                   05210000
MFA-TR*            AND  DATE_TEST     >= :GT-DATE-TEST                  05220000
MFA-TR*       ORDER BY DATE_TEST                                        05230000
MFA-TR*    END-EXEC.                                                    05240000
      *                                                                 05250000
       LINKAGE SECTION.                                                 
      *                                                                 05250000
       PROCEDURE DIVISION.                                              
                                                                        
      * THE FOLLOWING CODE IS USED FOR DEBUGGING. TO ENABLE THE COBOL IIIBS013  
      * DEBUGGING FEATURES, REMOVE THE ASTERISKS FROM THE DECLARATIVES  IBS013  
      * AND THE 'SET WS-TRACE-ON TO TRUE' STATEMENT IN THE MAINLINE     IBS013  
      * ROUTINE.  ALSO MAKE SURE THE 'SOURCE-COMPUTER' STATEMENT IN THE IBS013  
      * ENVIRONMENT DIVISION SAYS 'WITH DEBUGGING OPTION'.              IBS013  
       DECLARATIVES.                                                    
       DEBUG-DECLARE SECTION.                                           
           USE FOR DEBUGGING ON ALL PROCEDURES.                         
       DEBUG-PARA.                                                      
           IF WS-TRACE-ON                                               
             DISPLAY 'ENTERING ' DEBUG-NAME DEBUG-LINE DEBUG-CONTENTS   
           END-IF.                                                      
       END DECLARATIVES.                                                
      ******************************************************************05290000
      *   CONTROLS MAIN PATH OF PROGRAM                                *05300000
      ******************************************************************05310000
       0000-MAINLINE.                                                   
                                                                        
           SET WS-TRACE-ON TO TRUE.                                     
                                                                        
           PERFORM 1000-INITIALIZATION THRU 1000-EXIT.                  
           PERFORM 2000-MAIN-PROCESS THRU 2000-EXIT.                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
      *                                                                 05380000
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            05410000
      ******************************************************************05420000
      *   INITIALIZATION ROUTINE                                       *05430000
      ******************************************************************05440000
       1000-INITIALIZATION.                                             
      *                                                                 05460000
T22243     ACCEPT WS-SYSIN-COMP-NO             FROM SYSIN.              
T22243     IF  WS-SYSIN-COMP-NO EQUAL SPACES OR LOW-VALUES              
T22243         MOVE WS-COMP-NO                 TO WS-SYSIN-COMP-NO      
T22243     END-IF.                                                      
                                                                        
T22243     MOVE WS-SYSIN-COMP-NO               TO WS-COMP-NO.           
           MOVE 01                             TO WS-SUB, WS-SUB1.      
           MOVE WS-PGRMNAME                    TO G6-PROGRAM-NAME.      
T22243     MOVE WS-COMP-NO                     TO G6-COMPANY-NO         
T22243                                            C7-COMPANY-NO.        
T22243     PERFORM 7520-GET-COMPANY-NAME       THRU 7520-EXIT.          
           MOVE WS-PARM                        TO G6-CMND-CODE.         
           MOVE 01                             TO G6-SEQ-NO.            
           PERFORM 7500-GET-CURRENT-DATE THRU 7500-EXIT.                
           DISPLAY 'WS-CURRENT-DATE = ' WS-CURRENT-DATE.                
           DISPLAY 'WS-CURRENT-TIME = ' WS-CURRENT-TIMESTAMP.           
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
LKP        DISPLAY 'WS-INPUT-DATA-BRKDN = ' WS-INPUT-DATA-BREAKDOWN.    
      *                                                                         
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
LKP            DISPLAY 'WS-INPUTDATE = ' WS-INPUT-DATE                  
LKP            DISPLAY 'G6-PARM-DATA = ' G6-PARM-DATA                   
           END-IF.                                                      
           MOVE WS-INPUT-DATE            TO WS-RUN-DATE.                
      *                                                                         
T14965     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T14965        NEXT SENTENCE                                             
T14965     ELSE                                                         
T14965         DISPLAY '********************************************'   
T14965         DISPLAY '*** NO ROWS FOUND FOR GMC660 IN JOB PARM *'     
T14965         DISPLAY '********************************************'   
T14965         PERFORM 9900-ABEND THRU 9900-EXIT                        
T14965     END-IF.                                                      
T14965*                                                                 05528000
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
      *                                                                 05550000
           MOVE WS-HH                          TO  HDR-02-HH            
T18125                                            WS-RPT3-HH.           
           MOVE WS-MM                          TO  HDR-02-MM            
T18125                                            WS-RPT3-MM.           
           MOVE WS-SS                          TO  HDR-02-SS            
T18125                                            WS-RPT3-SS.           
      *                                                                 05660000
      **** LKP- USE THE DATE FOUND ON THE CSS_JOB_PARM TABLE IF                 
      **** THE STATUS CODE IS ACTIVE ELSE USE THE CURRENT DATE                  
      **** MOVE THIS DATE TO WS-CURRENT-DATE AFTER THE HEADER                   
      ***  DETAILS. IT WILL OVERRIDE THE CURRENT DATE WITH WHAT                 
      ***  IS IN THE TABLE.                                                     
                                                                        
           IF WS-INPUT-STATUS = 'A'                                     
               MOVE WS-INPUT-RUN-DATE TO WS-CURRENT-DATE                
           END-IF.                                                      
           MOVE WS-CURRENT-YEAR                TO  HDR-02-YEAR          
T18125                                             WS-RPT3-YEAR         
T18125                                             WS-FORMAT-YY.        
T18125     MOVE WS-CURRENT-MM                  TO  WS-FORMAT-MM.        
T18125     MOVE WS-CURRENT-DD                  TO  WS-FORMAT-DD.        
           MOVE WS-FORMAT-DATE                 TO  HDR-01-DATE.         
           DISPLAY 'WS-CURRENT-YEAR = ' WS-CURRENT-YEAR.                
                                                                        
           OPEN INPUT FCSMT14-FILE.                                     
      *                                                                 05680000
           IF  FMT14-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT14  FILE OPEN ERROR'                       
               DISPLAY 'FCSMT14  FILE STATUE IS ==>' WS-FMT14-STATUS    
           END-IF.                                                      
      *                                                                 05760000
           OPEN OUTPUT FCSMT16-FILE.                                    
           IF  FMT16-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT16  FILE OPEN ERROR'                       
               DISPLAY 'FCSMT16  FILE STATUE IS ==>' WS-FMT16-STATUS    
      *        PERFORM 9900-ABEND THRU 9900-EXIT                        05830000
           END-IF.                                                      
      *                                                                 05850000
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                 05940000
           OPEN OUTPUT FCSP232-FILE.                                    
      *                                                                 06030000
T18125     OPEN OUTPUT FCSP233-FILE.                                    
T18125*                                                                 06032002
           PERFORM 1100-LOAD-B5-PARA THRU 1100-EXIT                     
                UNTIL NO-MORE-RECORDS OR WS-SUB > WS-MAX-B5-ROWS.       
      *                                                                 06060000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06090000
      ******************************************************************06100000
      ** LOADS THE WORKING STORAGE TABLE WITH TABLE B5 DATA           **06110000
      ******************************************************************06120000
       1100-LOAD-B5-PARA.                                               
           READ FCSMT14-FILE                                            
           AT END                                                       
              SET NO-MORE-RECORDS TO TRUE                               
              GO TO 1100-EXIT                                           
           END-READ.                                                    
      *                                                                 06190000
           IF  FMT14-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT14  FILE READ ERROR'                       
               DISPLAY 'FCSMT14  FILE STATUE IS ==>' WS-FMT14-STATUS    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 06270000
           IF  E-FMT14-B5-QUAL-INDEX-FLAG                               
               MOVE E-FMT14-B5-QUALITY-INDEX   TO                       
                                    WS-B5-QUALITY-INDEX (WS-SUB)        
           ELSE                                                         
               PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL WS-SUB1 > 16   
                   MOVE E-FMT14-B5-EST-PCT-DEFEC (WS-SUB1)              
                                               TO                       
                           WS-B5-EST-PCT-DEFEC (WS-SUB, WS-SUB1)        
               END-PERFORM                                              
               ADD 1                           TO WS-SUB                
           END-IF.                                                      
      *                                                                 06380000
       1100-EXIT.                                                       
           EXIT.                                                        
      ********************************************************                  
      * JOB_PARM INCLUDES FOR DATE ACCESS                                       
      ********************************************************                  
        COPY CPD00037.                                                          
        COPY CPD00040.                                                          
      *                                                                         
             EXEC SQL                                                           
                 INCLUDE CPD00038                                               
             END-EXEC.                                                          
      *                                                                         
             EXEC SQL                                                           
                 INCLUDE CPD00039                                               
             END-EXEC.                                                          
      *                                                                 06410000
      ******************************************************************06420000
      ** FETCHES THE FIRST ROW WITH PGRM NAME GMC660, CHECKS FOR      **06430000
      ** RUN TYPE AND SETS UPDATE-FLAG ACCORDINGLY, AND IN THE SECOND **06440000
      ** FETCH, IT CHECKS FOR ROWS WITH TEST GROUP AND SETS GROUP-CD- **06450000
      ** FOUND OR GROUP-CD-NOT-FOUND FLAGS ACCORDINGLY                **06460000
      ******************************************************************06470000
       2000-MAIN-PROCESS.                                               
      *                                                                 06490000
           MOVE WS-PGRMNAME                    TO G6-PROGRAM-NAME.      
           MOVE WS-COMP-NO                     TO G6-COMPANY-NO.        
           MOVE WS-PARM                        TO G6-CMND-CODE.         
           PERFORM 7000-OPEN-JOB-PARM THRU 7000-EXIT.                   
           PERFORM 7010-FETCH-JOB-PARM THRU 7010-EXIT.                  
      *                                                                 06550000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE G6-PARM-DATA               TO WS-UPDATE-REPORT      
               IF  WS-RUNTYPE EQUAL WS-UPDATE OR WS-REPORT              
                   NEXT SENTENCE                                        
               ELSE                                                     
                   DISPLAY '*******************************************'
                   DISPLAY '***GMC660 JOB PARM NOT = UPDATE/REPORT***'06
                   DISPLAY '*******************************************'
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           ELSE                                                         
               DISPLAY '********************************************'   
               DISPLAY '*** NO ROWS FOUND FOR GMC660 IN JOB PARM *'     
               DISPLAY '********************************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 06720000
           IF  WS-RUNTYPE EQUAL WS-UPDATE                               
               SET UPDATE-FLAG                 TO TRUE                  
           END-IF.                                                      
      *                                                                 06760000
           PERFORM 7010-FETCH-JOB-PARM THRU 7010-EXIT.                  
      *                                                                 06780000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               SET GROUP-CD-FOUND              TO TRUE                  
           ELSE                                                         
               SET GROUP-CD-NOT-FOUND          TO TRUE                  
           END-IF.                                                      
      *                                                                 06840000
           PERFORM 2100-PARM-OR-TEST-GROUP THRU 2100-EXIT.              
      *                                                                 06860000
           PERFORM 7020-CLOSE-JOB-PARM THRU 7020-EXIT.                  
      *                                                                 06880000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06910000
      ******************************************************************06920000
      ** BRANCHING OUT TO DIFFERENT PARAGRAPHS BASED ON THE FLAG      **06930000
      ** GROUP-CD-FOUND AND WRITING TRAILER RECORD ON FCSMT16         **06940000
      ******************************************************************06950000
       2100-PARM-OR-TEST-GROUP.                                         
      *                                                                 06970000
           IF  GROUP-CD-FOUND                                           
               PERFORM 2110-SELECT-JOB-PARM THRU 2110-EXIT              
                       UNTIL WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL
           ELSE                                                         
               PERFORM 2120-SELECT-TEST-GRP THRU 2120-EXIT              
           END-IF.                                                      
      *                                                                 07040000
           WRITE PRT33-RECORD FROM WS-END-OF-DATA AFTER 2.              
T18125     IF  WS-ERR-COUNT EQUAL 57 AND WS-ERR-PAGE-NO EQUAL ZEROS     
T18125         MOVE WS-NO-DATA-LINE            TO ERROR-DETAIL          
T18125         PERFORM 8100-WRITE-ERROR-PARA THRU 8100-EXIT             
T18125     ELSE                                                         
T18125         WRITE PR232-RECORD FROM WS-END-OF-DATA AFTER 2           
T18125     END-IF.                                                      
T18125     IF  WS-DTL-COUNT EQUAL 57 AND WS-DTL-PAGE-NO EQUAL ZEROS     
T18125         MOVE WS-NO-DATA-LINE            TO WS-RPT3-DETAIL        
T18125         PERFORM 8110-WRITE-DETAIL-RPT THRU 8110-EXIT             
T18125     ELSE                                                         
T18125         WRITE PR233-RECORD FROM WS-END-OF-DATA AFTER 2           
T18125     END-IF.                                                      
      *                                                                 07070000
           IF  UPDATE-FLAG                                              
               MOVE SPACES                     TO                       
                                               E-FMT16-END-RECORD-ID    
               MOVE WS-NBR-TEST-RECS           TO                       
                                               E-FMT16-NBR-TEST-RECS    
               MOVE SPACES                     TO E-FMT16-FILLER01      
               PERFORM 8150-WRITE-FIOMT16 THRU 8150-EXIT                
           END-IF.                                                      
      *                                                                 07160000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07190000
      ******************************************************************07200000
      ** CONTROL COMES TO THIS WHEN ROWS ARE PRESENT WITH GROUP CODE  **07210000
      ** IN CSS_JOB_PARM                                              **07220000
      ******************************************************************07230000
       2110-SELECT-JOB-PARM.                                            
      *                                                                 07250000
           MOVE 'N'                            TO WS-END-PROCESS.       
           MOVE G6-PARM-DATA                   TO WS-PARM-DATA.         
           MOVE WS-G                           TO MQ-CODE-UTIL-TYPE.    
           MOVE WS-CURRENT-YEAR                TO MQ-TEST-YEAR.         
           MOVE WS-R                           TO MQ-TEST-SCHED-CD.     
           MOVE WS-GRP-CD                      TO MQ-MTR-TEST-GRP-CD.   
T22243     MOVE WS-COMP-NO                     TO MQ-COMPANY-NO.        
           PERFORM 7050-SELECT-TEST-HIST THRU 7050-EXIT.                
           PERFORM 3000-EXTRACT-ANALYZE-TEST-GRP THRU 3000-EXIT.        
           PERFORM 7010-FETCH-JOB-PARM THRU 7010-EXIT.                  
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07360000
      ******************************************************************07370000
      ** CONTROL COMES TO THIS WHEN ROWS ARE NOT PRESENT WITH GROUP CD**07380000
      ** IN CSS_JOB_PARM                                              **07390000
      ******************************************************************07400000
       2120-SELECT-TEST-GRP.                                            
      *                                                                 07420000
           MOVE WS-G                           TO MQ-CODE-UTIL-TYPE.    
           MOVE WS-CURRENT-YEAR                TO MQ-TEST-YEAR.         
           MOVE WS-R                           TO MQ-TEST-SCHED-CD.     
T22243     MOVE WS-COMP-NO                     TO MQ-COMPANY-NO.        
              DISPLAY ' 2120- '.                                        
              DISPLAY ' WS-CURRENT-YEAR = ' WS-CURRENT-YEAR.            
              DISPLAY ' WS-R            = ' WS-R.                       
              DISPLAY ' WS-COMP-NO      = ' WS-COMP-NO.                 
           PERFORM 7060-OPEN-TEST-GROUP THRU 7060-EXIT.                 
           PERFORM 7070-FETCH-TEST-GROUP THRU 7070-EXIT.                
      *                                                                 07480000
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL    
T18125         MOVE 'N'                        TO  WS-END-PROCESS       
               PERFORM 3000-EXTRACT-ANALYZE-TEST-GRP THRU 3000-EXIT     
               PERFORM 7070-FETCH-TEST-GROUP THRU 7070-EXIT             
           END-PERFORM.                                                 
      *                                                                 07530000
           PERFORM 7080-CLOSE-TEST-GROUP THRU 7080-EXIT.                
      *                                                                 07550000
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07580000
      ******************************************************************07590000
      ** GETTING IN-OPEN-RATE AND OTHER DETAILS FROM DIFFERENT        **07600000
      ** TABLES AND CALCULATING MEAN, STANDARD DEVIATION WITH & WITHOUT*07610000
      ** DOGS FOR METERS TESTED AFTER SELECTING                       **07620000
      ******************************************************************07630000
       3000-EXTRACT-ANALYZE-TEST-GRP.                                   
           INITIALIZE WS-TEST-RESULT-TABLE.                             
           MOVE ZEROES                         TO WS-TEST-SUB           
                                                  WS-NBR-TESTS          
T18125                                            WS-SUM-SQR-RATE       
T18125                                         WS-TOTAL-AVG-IN-RATE.    
           MOVE WS-G                           TO GM-CODE-UTIL-TYPE.    
           MOVE MQ-MTR-TEST-GRP-CD             TO GM-LAST-TEST-SEL-CD.  
T22243     MOVE WS-COMP-NO                     TO GM-COMPANY-NO.        
      *                                                                 07710000
           PERFORM 7110-OPEN-GAS-METER THRU 7110-EXIT.                  
           PERFORM 7120-FETCH-GAS-METER THRU 7120-EXIT.                 
           PERFORM 3100-SELECT-METER-CURSOR THRU 3100-EXIT              
T18125               UNTIL ( WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL
T18125                OR END-OF-PROCESS ).                              
           PERFORM 7130-CLOSE-GAS-METER THRU 7130-EXIT.                 
      *                                                                 07770000
           IF  WS-NBR-TESTS NOT = MQ-TESTED-QT                          
               MOVE WS-NBR-TESTS               TO MQ-TESTED-QT          
           END-IF.                                                      
           MOVE WS-NBR-TESTS                   TO TS-ANALYSIS-QT.       
      *                                                                 07820000
      ****************************************************************  07830000
      * CALCULATE MEAN WITH DOGS FOR FULL LOAD ACCURACY TEST RESULTS *  07840000
      ****************************************************************  07850000
           IF  WS-NBR-TESTS > 0                                         
T18125         COMPUTE TS-MEAN-WITH-DOGS ROUNDED                        
T18125                  = WS-TOTAL-AVG-IN-RATE / WS-NBR-TESTS           
           ELSE                                                         
               MOVE ZEROES                     TO TS-MEAN-WITH-DOGS     
           END-IF.                                                      
      *                                                                 07880000
      ****************************************************************  07890000
      * CALCULATE STANDARD DEVIATION WITH DOGS FOR FULL LOAD ACCURACY*  07900000
      * AS  FOUND                                                    *  07910000
      ****************************************************************  07920000
           MOVE ZEROES                         TO WS-TOTAL-DEVIATION.   
           PERFORM VARYING WS-METER-SUB FROM 1 BY 1 UNTIL               
                                     WS-METER-SUB > WS-NBR-TESTS        
               COMPUTE WS-TOTAL-DEVIATION = WS-TOTAL-DEVIATION +        
T18125         (WS-TEST-AVG-IN-RATE (WS-METER-SUB)                      
                  - TS-MEAN-WITH-DOGS) ** 2                             
           END-PERFORM.                                                 
T18125     IF  WS-NBR-TESTS > 0                                         
T18125         COMPUTE TS-STD-DEV-W-DOGS ROUNDED                        
T18125             = (WS-TOTAL-DEVIATION / WS-NBR-TESTS) ** 0.5         
T18125     ELSE                                                         
T18125         MOVE ZEROES                     TO TS-STD-DEV-W-DOGS     
T18125     END-IF.                                                      
      *                                                                 08010000
           MOVE ZEROES                         TO WS-NBR-TESTS-WO-DOGS  
                                                  TS-NUMBER-OF-DOGS     
T18125                                            WS-SUM-SQR-RATE       
T18125                                            WS-TOTAL-AVG-IN-RATE. 
T18125     COMPUTE WS-MAX-LIMIT = TS-MEAN-WITH-DOGS                     
T18125                          + (TS-STD-DEV-W-DOGS * 4).              
T18125     COMPUTE WS-MIN-LIMIT = TS-MEAN-WITH-DOGS                     
T18125                          - (TS-STD-DEV-W-DOGS * 4).              
           PERFORM 3200-ACCUM-FULL-LOAD-ACCURACY THRU 3200-EXIT         
                   VARYING WS-METER-SUB FROM 1 BY 1 UNTIL               
                                     WS-METER-SUB > WS-NBR-TESTS.       
      *                                                                 08090000
      ******************************************************************08100000
      * CALCULATE MEAN WITHOUT DOGS FOR FULL LOAD ACCURACY TEST RESULTS*08110000
      ******************************************************************08120000
           IF  WS-NBR-TESTS-WO-DOGS > 0                                 
T18125         COMPUTE TS-MEAN-WITHOUT-DOGS ROUNDED =                   
T18125               WS-TOTAL-AVG-IN-RATE / WS-NBR-TESTS-WO-DOGS        
           ELSE                                                         
               MOVE ZEROES                     TO TS-MEAN-WITHOUT-DOGS  
           END-IF.                                                      
      *                                                                 08150000
      ****************************************************************  08160000
      * CALCULATE STANDARD DEVIATION WITHOUT DOGS FOR FULL LOAD      *  08170000
      * ACCURACY AS FOUND                                            *  08180000
      ****************************************************************  08190000
           MOVE ZEROES                         TO WS-TOTAL-DEVIATION.   
           PERFORM VARYING WS-METER-SUB FROM 1 BY 1 UNTIL               
                                     WS-METER-SUB > WS-NBR-TESTS        
               IF  WS-TEST-IS-NOT-A-DOG (WS-METER-SUB)                  
                   COMPUTE WS-TOTAL-DEVIATION = WS-TOTAL-DEVIATION +    
T18125               (WS-TEST-AVG-IN-RATE (WS-METER-SUB)                
                        - TS-MEAN-WITHOUT-DOGS) ** 2                    
               END-IF                                                   
           END-PERFORM.                                                 
T18125     IF  WS-NBR-TESTS-WO-DOGS > 0                                 
T18125         COMPUTE TS-STD-DEV-WO-DOGS ROUNDED                       
T18125               = (WS-TOTAL-DEVIATION/WS-NBR-TESTS-WO-DOGS) ** 0.5 
T18125     ELSE                                                         
T18125         MOVE ZEROES                     TO TS-STD-DEV-WO-DOGS    
T18125     END-IF.                                                      
T15090     IF TS-STD-DEV-WO-DOGS    EQUAL ZERO                          
T18125        MOVE +0.0001          TO TS-STD-DEV-WO-DOGS               
T15090     END-IF.                                                      
      *                                                                 08311000
      ******************************************************************08320000
      * DETERMINE THE ESTIMATED PERCENT DOGS                          **08330000
      ******************************************************************08340000
           IF  MQ-TESTED-QT > 0                                         
               COMPUTE TS-EST-PCT-DOGS                                  
                        = (TS-NUMBER-OF-DOGS / MQ-TESTED-QT) * 100      
           ELSE                                                         
               MOVE ZEROES                     TO TS-EST-PCT-DOGS       
           END-IF.                                                      
      *                                                                 08360000
      * COMPUTE THE QUALITY INDICES                                     08370000
T15090     MOVE 103                            TO WS-UPPER-QUAL-LIMIT.  
T15090     MOVE  97                            TO WS-LOWER-QUAL-LIMIT.  
      *                                                                 08390100
           IF  TS-STD-DEV-WO-DOGS > 0                                   
T18125         COMPUTE TS-UPPER-QUAL-INDEX ROUNDED                      
T15090            = (103 - TS-MEAN-WITHOUT-DOGS) / TS-STD-DEV-WO-DOGS   
T18125         COMPUTE TS-LOWER-QUAL-INDEX ROUNDED                      
T18125            = (TS-MEAN-WITHOUT-DOGS - 97) / TS-STD-DEV-WO-DOGS    
           ELSE                                                         
               MOVE ZEROES                     TO TS-UPPER-QUAL-INDEX   
                                                  TS-LOWER-QUAL-INDEX   
           END-IF.                                                      
      *                                                                 08440000
      ******************************************************************08450000
      * LOOK UP QUALITY INDICES                                        *08460000
      * ESTIMATE PERCENT ABOVE UPPER-QUALITY-INDEX BY LOOKING UP ESTIM *08470000
      * -ATED PERCENT DEFECTIVE IN TABLE B-5 USING UPPER-QUALITY-INDEX *08480000
      * AND SAMPLE SIZE.                                               *08490000
      * ESTIMATE PERCENT BELOW LOWER-QUALITY-INDEX BY LOOKING UP ESTIM *08500000
      * -ATED PERCENT DEFECTIVE IN TABLE B-5 USING LOWER-QUALITY-INDEX *08510000
      * AND SAMPLE SIZE.                                               *08520000
      ******************************************************************08530000
           MOVE WS-NO                          TO WS-B5-FOUND.          
           PERFORM VARYING WS-SIZE-SUB FROM 1 BY 1 UNTIL                
                                    WS-SIZE-SUB > 15 OR B5-FOUND        
               IF  (WS-NBR-TESTS-WO-DOGS                                
                                 <= WS-B5-SAMPLE-SIZE-MAX (WS-SIZE-SUB))
                   MOVE WS-YES                 TO WS-B5-FOUND           
               END-IF                                                   
           END-PERFORM.                                                 
T15090     COMPUTE WS-SIZE-SUB    =   WS-SIZE-SUB  - 1.                 
           IF  B5-NOT-FOUND                                             
               MOVE 16                         TO WS-SIZE-SUB           
           END-IF.                                                      
           MOVE TS-UPPER-QUAL-INDEX            TO WS-QUALITY-INDEX.     
           PERFORM 3300-DETERMINE-EST-PCT-DEFEC THRU 3300-EXIT.         
           MOVE WS-EST-PCT-DEFEC               TO TS-EST-DEFEC-ABOVE-U  
           MOVE TS-LOWER-QUAL-INDEX            TO WS-QUALITY-INDEX.     
           PERFORM 3300-DETERMINE-EST-PCT-DEFEC THRU 3300-EXIT.         
           MOVE WS-EST-PCT-DEFEC               TO TS-EST-DEFEC-BELOW-L  
      *                                                                 08710000
      ****************************************************************  08720000
      * CALCULATE TOTAL ESTIMATE OF PERCENT DEFECTIVE IN GROUP       *  08730000
      ****************************************************************  08740000
           COMPUTE WS-TOT-EST-PCT-DEFEC = TS-EST-PCT-DOGS +             
                       + TS-EST-DEFEC-ABOVE-U  + TS-EST-DEFEC-BELOW-L.  
           PERFORM 3400-DETERMINE-PERFORMANCE THRU 3400-EXIT.           
T14965*                                                                 08770100
T14965     MOVE WS-R                      TO  TS-TEST-SCHED-CD          
T14965     MOVE WS-CURRENT-TIMESTAMP      TO  TS-ANALYSIS-TS            
T14965*                                                                 08770500
           IF  UPDATE-FLAG                                              
               PERFORM 3500-UPDATE-TABLES THRU 3500-EXIT                
           END-IF.                                                      
           PERFORM 8000-PRINT-REPORT-PARA THRU 8000-EXIT.               
      *                                                                 08800000
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08830000
      ****************************************************************  08840000
      * GETTING METER NO.  WHICH HAVE BEEN SELECTED FOR TESTING     **  08850000
      ****************************************************************  08860000
       3100-SELECT-METER-CURSOR.                                        
      *                                                                 08880000
           INITIALIZE DCLCSS-GAS-MTR-TEST.                              
           MOVE WS-G                           TO GT-CODE-UTIL-TYPE.    
           MOVE GM-METER-NO                    TO GT-METER-NO.          
           MOVE GM-LAST-TEST-SEL-DT            TO GT-DATE-TEST.         
T22243     MOVE WS-COMP-NO                     TO GT-COMPANY-NO.        
           PERFORM 7140-OPEN-GAS-MTR-TEST THRU 7140-EXIT.               
           PERFORM 7150-FETCH-GAS-MTR-TEST THRU 7150-EXIT.              
      *                                                                 07480000
           PERFORM UNTIL GT-CODE-TEST-TYPE = 'C'                        
             OR WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL             
               PERFORM 7150-FETCH-GAS-MTR-TEST THRU 7150-EXIT           
           END-PERFORM.                                                 
      *                                                                 07530000
           PERFORM 3110-SELECT-TEST-CURSOR THRU 3110-EXIT.              
           PERFORM 7160-CLOSE-GAS-MTR-TEST THRU 7160-EXIT.              
T18125     IF  END-OF-PROCESS                                           
T18125         GO TO 3100-EXIT                                          
T18125     END-IF.                                                      
           PERFORM 7120-FETCH-GAS-METER THRU 7120-EXIT.                 
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08990000
      ****************************************************************  09000000
      * CHECKING WHETHER THE METER IS TESTED AFTER SELECTING OR NOT  *  09010000
      * IF NOT, WRITE THE METER NO. INTO ERROR FILE. IF IT IS TESTED *  09020000
      * WRITE THE DETAILS INTO FCSMT16                               *  09030000
      ****************************************************************  09040000
       3110-SELECT-TEST-CURSOR.                                         
      *                                                                 09060000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 4100-LOAD-ERROR-DETAIL THRU 4100-EXIT            
               GO TO 3110-EXIT                                          
           END-IF.                                                      
T18125     PERFORM 3111-PREPARE-DETAIL-RPT THRU 3111-EXIT.              
           IF  UPDATE-FLAG                                              
               ADD 1 TO WS-NBR-TEST-RECS                                
               PERFORM 4200-LOAD-FIOMT16 THRU 4200-EXIT                 
           END-IF.                                                      
           ADD 1                               TO WS-TEST-SUB.          
T18125     COMPUTE WS-AVG-RATE ROUNDED                                  
T18125          = (GT-IN-OPEN-RATE + GT-IN-CHECK-RATE) / 2.0            
T18125     MOVE WS-AVG-RATE                    TO                       
T18125                        WS-TEST-AVG-IN-RATE (WS-TEST-SUB).        
T18125     COMPUTE WS-TOTAL-AVG-IN-RATE ROUNDED =                       
T18125                 WS-TOTAL-AVG-IN-RATE + WS-AVG-RATE.              
T18125     COMPUTE WS-SUM-SQR-RATE ROUNDED =                            
T18125                 WS-SUM-SQR-RATE + WS-AVG-RATE ** 2.              
           ADD 1                               TO WS-NBR-TESTS.         
T18125     IF  WS-NBR-TESTS >= MQ-SAMPLE-MIN-QT                         
T18125         SET END-OF-PROCESS              TO TRUE                  
T18125     END-IF.                                                      
       3110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09250000
T18125 3111-PREPARE-DETAIL-RPT.                                         
T18125*                                                                 09251102
T18125     IF  MQ-MTR-TEST-GRP-CD NOT EQUAL WS-RPT3-GRP-CD              
T18125         MOVE MQ-MTR-TEST-GRP-CD         TO WS-RPT3-GRP-CD        
T18125         MOVE 58                         TO WS-DTL-COUNT          
T18125     END-IF.                                                      
T18125     MOVE GR-MTR-TEST-GRP-TX             TO WS-RPT3-GRP-DESC.     
T18125     MOVE GM-METER-NO                    TO WS-RPT3-MTR-NO.       
T18125     MOVE GT-DATE-TEST                   TO WS-RPT3-DATE-TEST.    
T18125     MOVE GT-IN-CHECK-RATE               TO WS-RPT3-IN-CHECK.     
T18125     MOVE GT-IN-OPEN-RATE                TO WS-RPT3-IN-OPEN.      
T18125     COMPUTE WS-AVG-RATE ROUNDED                                  
T18125          = (GT-IN-OPEN-RATE + GT-IN-CHECK-RATE) / 2.0            
T18125     MOVE WS-AVG-RATE                    TO WS-RPT3-IN-AVG.       
T18125     MOVE GT-OUT-CHECK-RATE              TO WS-RPT3-OUT-CHECK.    
T18125     MOVE GT-OUT-OPEN-RATE               TO WS-RPT3-OUT-OPEN.     
T18125     COMPUTE WS-AVG-RATE ROUNDED                                  
T18125          = (GT-OUT-OPEN-RATE + GT-OUT-CHECK-RATE) / 2.0          
T18125     MOVE WS-AVG-RATE                    TO WS-RPT3-OUT-AVG.      
T18125     PERFORM 7510-GET-ADDRESS THRU 7510-EXIT.                     
T18125     PERFORM 8110-WRITE-DETAIL-RPT THRU 8110-EXIT.                
T18125*                                                                 09253802
T18125 3111-EXIT.                                                       
T18125     EXIT.                                                        
T18125*                                                                 09255002
      ***************************************************************   09260000
      * ACCUMULATE FULL LOAD ACCURACY AS FOUND FOR MEAN CALCULATION *   09270000
      * WITHOUT DOGS                                                *   09280000
      ***************************************************************   09290000
       3200-ACCUM-FULL-LOAD-ACCURACY.                                   
      *                                                                 09310000
           MOVE WS-NO                          TO                       
                                WS-TEST-IS-A-DOG-FLAG (WS-METER-SUB)    
T18125     IF  (WS-TEST-AVG-IN-RATE (WS-METER-SUB) < WS-MIN-LIMIT)      
T18125         OR (WS-TEST-AVG-IN-RATE (WS-METER-SUB) > WS-MAX-LIMIT)   
               ADD 1                           TO TS-NUMBER-OF-DOGS     
               MOVE WS-YES                     TO                       
                               WS-TEST-IS-A-DOG-FLAG (WS-METER-SUB)     
           ELSE                                                         
T18125         COMPUTE WS-TOTAL-AVG-IN-RATE ROUNDED =                   
T18125                  WS-TOTAL-AVG-IN-RATE                            
T18125                           + WS-TEST-AVG-IN-RATE (WS-METER-SUB)   
T18125         COMPUTE WS-SUM-SQR-RATE ROUNDED = WS-SUM-SQR-RATE        
T18125                     + (WS-TEST-AVG-IN-RATE (WS-METER-SUB) ** 2)  
               ADD 1                           TO WS-NBR-TESTS-WO-DOGS  
           END-IF.                                                      
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09490000
      ***************************************************************   09500000
      * DETERMINE EST-PCT-DEFEC VALUE DEPENDING ON QUALITY INDEX    *   09510000
      ***************************************************************   09520000
       3300-DETERMINE-EST-PCT-DEFEC.                                    
      *                                                                 09540000
           EVALUATE TRUE                                                
              WHEN WS-QUALITY-INDEX  < 0                                
                  MOVE ZEROES                  TO WS-EST-PCT-DEFEC      
              WHEN WS-QUALITY-INDEX  > 3.90                             
                  MOVE ZEROES                  TO   WS-EST-PCT-DEFEC    
              WHEN WS-QUALITY-INDEX  = 0                                
                  COMPUTE WS-EST-PCT-DEFEC                              
                                = WS-B5-EST-PCT-DEFEC (1, WS-SIZE-SUB)  
              WHEN WS-QUALITY-INDEX  < 0.10                             
                  COMPUTE WS-EST-PCT-DEFEC                              
                                = (WS-B5-EST-PCT-DEFEC (1, WS-SIZE-SUB) 
                              + WS-B5-EST-PCT-DEFEC(2, WS-SIZE-SUB)) / 2
              WHEN WS-QUALITY-INDEX  = 0.10                             
                  COMPUTE WS-EST-PCT-DEFEC                              
                                = WS-B5-EST-PCT-DEFEC (2, WS-SIZE-SUB)  
              WHEN WS-QUALITY-INDEX  < 0.20                             
                  COMPUTE WS-EST-PCT-DEFEC                              
                                = (WS-B5-EST-PCT-DEFEC (2, WS-SIZE-SUB) 
                              + WS-B5-EST-PCT-DEFEC(3, WS-SIZE-SUB)) / 2
              WHEN WS-QUALITY-INDEX  = 0.20                             
                  COMPUTE WS-EST-PCT-DEFEC                              
                                = WS-B5-EST-PCT-DEFEC (3, WS-SIZE-SUB)  
              WHEN WS-QUALITY-INDEX  < 0.30                             
                  COMPUTE WS-EST-PCT-DEFEC                              
                                = (WS-B5-EST-PCT-DEFEC (2, WS-SIZE-SUB) 
                             + WS-B5-EST-PCT-DEFEC(3, WS-SIZE-SUB)) / 2 
              WHEN OTHER                                                
                  MOVE WS-NO                   TO WS-B5-FOUND           
                  PERFORM VARYING WS-QL-SUB FROM 1 BY 1                 
                        UNTIL WS-QL-SUB > WS-MAX-B5-ROWS OR B5-FOUND    
                     IF  (WS-QUALITY-INDEX                              
                                    <= WS-B5-QUALITY-INDEX (WS-QL-SUB)) 
                        MOVE WS-B5-EST-PCT-DEFEC(WS-QL-SUB, WS-SIZE-SUB)
                                               TO WS-EST-PCT-DEFEC      
                         MOVE WS-YES           TO WS-B5-FOUND           
                     END-IF                                             
                  END-PERFORM                                           
                  IF  B5-NOT-FOUND                                      
                      MOVE 0                   TO WS-EST-PCT-DEFEC      
                  END-IF                                                
           END-EVALUATE.                                                
      *                                                                 09960000
      ***************************************************************   09970000
      * DETERMINE MAXIMUM ALLOWABLE PERCENT DEFECTIVE TABLE B-3     *   09980000
      * FOR AQL (ACCEPTABLE QUALITY LEVEL) = 6.5                    *   09990000
      ***************************************************************   10000000
T12999     MOVE WS-NO                          TO WS-INV-TEST-QTY.      
T12999     MOVE WS-NBR-TESTS                   TO WS-POPULATION-SIZE.   
      *                                                                         
T12999     IF WS-COMP-NO = '26'                                         
T12999         PERFORM VARYING WS-SUB FROM 1 BY 1                       
T12999                    UNTIL WS-SUB > 15 OR B3-FOUND                 
T12999             IF WS-POPULATION-SIZE  < PSNC-SAMPLE-SIZE (WS-SUB)   
T12999                  MOVE WS-YES                TO WS-INV-TEST-QTY   
T12999                  MOVE WS-YES                TO WS-B3-FOUND       
T12999                  MOVE PSNC-AQL-650M(WS-SUB) TO                   
T12999                                         WS-SAMPL-MAX-PCT-DEFEC   
T12999                                         TS-MAX-PCT-DEFEC         
T12999             END-IF                                               
T12999             IF WS-POPULATION-SIZE  = PSNC-SAMPLE-SIZE (WS-SUB)   
T12999                  IF WS-POPULATION-SIZE  < MQ-SAMPLE-MIN-QT       
T12999                    MOVE WS-YES              TO WS-INV-TEST-QTY   
T12999                  END-IF                                          
T12999                  MOVE WS-YES                TO WS-B3-FOUND       
T12999                  MOVE PSNC-AQL-650M(WS-SUB) TO                   
T12999                                         WS-SAMPL-MAX-PCT-DEFEC   
T12999                                         TS-MAX-PCT-DEFEC         
T12999             END-IF                                               
T12999         END-PERFORM                                              
T12999     END-IF.                                                      
      *                                                                         
T12999     IF WS-COMP-NO = '01'                                         
T12999         PERFORM VARYING WS-SUB FROM 1 BY 1                       
T12999                    UNTIL WS-SUB > 15 OR B3-FOUND                 
T12999             IF WS-POPULATION-SIZE  < ESMP-SAMPLE-SIZE (WS-SUB)   
T12999                  MOVE WS-YES                TO WS-INV-TEST-QTY   
T12999                  MOVE WS-YES                TO WS-B3-FOUND       
T12999                  MOVE ESMP-AQL-650M(WS-SUB) TO                   
T12999                                         WS-SAMPL-MAX-PCT-DEFEC   
T12999                                         TS-MAX-PCT-DEFEC         
T12999             END-IF                                               
T12999             IF WS-POPULATION-SIZE  = ESMP-SAMPLE-SIZE (WS-SUB)   
T12999                  IF WS-POPULATION-SIZE  < MQ-SAMPLE-MIN-QT       
T12999                    MOVE WS-YES              TO WS-INV-TEST-QTY   
T12999                  END-IF                                          
T12999                  MOVE WS-YES                TO WS-B3-FOUND       
T12999                  MOVE ESMP-AQL-650M(WS-SUB) TO                   
T12999                                         WS-SAMPL-MAX-PCT-DEFEC   
T12999                                         TS-MAX-PCT-DEFEC         
T12999             END-IF                                               
T12999         END-PERFORM                                              
T12999     END-IF.                                                      
      *                                                                 10100000
T15090     MOVE WS-NO                          TO WS-B3-FOUND.          
      *                                                                 10100000
       3300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10130000
      ***************************************************************   10140000
      * CHECKING FOR ACCEPTABILITY OF THE LOT                       *   10150000
      ***************************************************************   10160000
       3400-DETERMINE-PERFORMANCE.                                      
      *                                                                 10180000
T12999     IF  TEST-QTY-LOW                                             
T12999         MOVE WS-F                       TO MQ-STATUS-CD          
T12999         MOVE SPACES                     TO WS-COMPARISON-LITERAL 
T12999         MOVE 'LOT FAILED - MINIMUM SAMPLE SIZE NOT REACHED'      
T12999                                         TO WS-PERFORMANCE-MESSAGE
T12999         GO TO 3400-EXIT                                          
T12999     END-IF.                                                      
T12999                                                                  
T12999     IF TS-UPPER-QUAL-INDEX < 0 OR TS-LOWER-QUAL-INDEX < 0        
T12999         MOVE WS-F                       TO MQ-STATUS-CD          
T12999         MOVE SPACES                     TO WS-COMPARISON-LITERAL 
T12999         MOVE 'LOT FAILED - LOWER OR UPPER QUALITY INDEX < 0 '    
T12999                                         TO WS-PERFORMANCE-MESSAGE
T12999         GO TO 3400-EXIT                                          
T12999     END-IF.                                                      
                                                                        
           IF  WS-TOT-EST-PCT-DEFEC <= WS-SAMPL-MAX-PCT-DEFEC AND       
                TS-UPPER-QUAL-INDEX >= 0 AND TS-LOWER-QUAL-INDEX >= 0   
               IF  ( TS-MEAN-WITHOUT-DOGS > WS-UPPER-QUAL-LIMIT ) OR    
                   ( TS-MEAN-WITHOUT-DOGS < WS-LOWER-QUAL-LIMIT )       
                   MOVE SPACES                 TO WS-COMPARISON-LITERAL 
                   MOVE WS-F                   TO MQ-STATUS-CD          
                   MOVE 'UPPER/LOWER SPEC LIMIT LOT NOT ACCEPTABLE'     
                                               TO WS-PERFORMANCE-MESSAGE
               ELSE                                                     
                   MOVE WS-E                   TO MQ-STATUS-CD          
                   MOVE 'LOT MEETS THE ACCEPTABILITY CRITERION:'        
                                               TO WS-PERFORMANCE-MESSAGE
                   MOVE '<='                   TO WS-COMPARISON-LITERAL 
               END-IF                                                   
           ELSE                                                         
               MOVE WS-F                       TO MQ-STATUS-CD          
               MOVE 'LOT DOES NOT MEET THE ACCEPTABILITY CRITERION:'    
                                               TO WS-PERFORMANCE-MESSAGE
               MOVE ' >'                       TO WS-COMPARISON-LITERAL 
           END-IF.                                                      
       3400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10400000
      *************************************************************     10410000
      * UPDATING CSS_MTR_TEST_HIST, CSS_MTR_TEST_STATS WITH THE   *     10420000
      * CALCULATED VALUES                                         *     10430000
      *************************************************************     10440000
       3500-UPDATE-TABLES.                                              
           MOVE WS-G                           TO MQ-CODE-UTIL-TYPE.    
           MOVE WS-R                           TO MQ-TEST-SCHED-CD.     
           MOVE WS-CURRENT-YEAR                TO MQ-TEST-YEAR.         
T22243     MOVE WS-COMP-NO                     TO MQ-COMPANY-NO.        
           PERFORM 8600-UPDATE-TEST-HIST THRU 8600-EXIT.                
           MOVE WS-G                           TO TS-CODE-UTIL-TYPE.    
           MOVE WS-CURRENT-YEAR                TO TS-TEST-YEAR.         
           MOVE MQ-MTR-TEST-GRP-CD             TO TS-MTR-TEST-GRP-CD.   
T22243     MOVE WS-COMP-NO                     TO TS-COMPANY-NO.        
           PERFORM 8700-UPDATE-TEST-STATS THRU 8700-EXIT.               
T14965     IF WS-ACTIVE-RETURN-CODE            EQUAL NOT-FOUND          
T14965        PERFORM 8800-INSERT-TEST-STATS   THRU  8800-EXIT          
T14965     END-IF.                                                      
      *                                                                 10553000
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10580000
      *************************************************************     10590000
      * LOADING ERROR DETAIL RECORD WITH METER NO & DESCRIPTION  **     10600000
      *************************************************************     10610000
       4100-LOAD-ERROR-DETAIL.                                          
           MOVE GT-METER-NO                    TO ERR-METER-NO.         
           MOVE MQ-MTR-TEST-GRP-CD             TO ERR-GR-CD.            
           PERFORM 8100-WRITE-ERROR-PARA THRU 8100-EXIT.                
      *                                                                 10670000
       4100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10700000
      ***************************************************************   10710000
      * MOVING TEST DETAILS TO FIOMT16 FIELDS TO WRITE INTO THE FILE*   10720000
      ***************************************************************   10730000
       4200-LOAD-FIOMT16.                                               
      *                                                                 10750000
           MOVE MQ-TEST-YEAR                   TO E-FMT16-TEST-YEAR.    
           MOVE MQ-MTR-TEST-GRP-CD             TO E-FMT16-GRP-CD.       
           MOVE GM-METER-NO                    TO E-FMT16-DEVICE-NO.    
           MOVE GM-LAST-TEST-SEL-DT            TO E-FMT16-DATE-TEST.    
           MOVE GT-EQ-TESTER-ID                TO E-FMT16-EQ-TESTER-ID. 
           MOVE GT-TEST-PROVER-ID              TO                       
                                                E-FMT16-TEST-PROVER-ID. 
           MOVE GM-METER-SIZE-ID               TO E-FMT16-METER-SIZE-ID.
           MOVE GT-REPAIR-DESC                 TO E-FMT16-REPAIR-DESC.  
           MOVE GT-IN-CHECK-RATE               TO E-FMT16-IN-CHECK-RATE.
           MOVE GT-IN-OPEN-RATE                TO E-FMT16-IN-OPEN-RATE. 
T22243     MOVE WS-COMP-NO                     TO E-FMT16-COMPANY-NO.   
      *                                                                 10910000
           PERFORM 8150-WRITE-FIOMT16 THRU 8150-EXIT.                   
      *                                                                 10950000
       4200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10980000
      ***************************************************************   10990000
      * MOVING VARIABLES TO CORRESPONDING REPORT HEADERS            *   11000000
      ***************************************************************   11010000
       4300-LOAD-DATA-PARA.                                             
           MOVE MQ-MTR-TEST-GRP-CD             TO HDR-04-GRP-CD.        
           MOVE GR-MTR-TEST-GRP-TX             TO HDR-04-GRP-DESC.      
T15090     MOVE MQ-TESTED-QT                   TO HDR-05-SAMPL-SIZE.    
T18125     MOVE WS-TOTAL-AVG-IN-RATE           TO HDR-05A-SUM-VAL.      
T18125     MOVE WS-SUM-SQR-RATE                TO HDR-05B-SUM-SQR-VAL.  
           MOVE TS-STD-DEV-WO-DOGS             TO HDR-06-STAND-DEV.     
           MOVE TS-MEAN-WITHOUT-DOGS           TO HDR-07-XBAR.          
T15090     MOVE 103.00                         TO HDR-08-UPPER-LIM.     
T15090     MOVE 97.00                          TO HDR-09-LOWER-LIM.     
           MOVE TS-UPPER-QUAL-INDEX            TO HDR-10-UPPER-INDEX.   
           MOVE TS-LOWER-QUAL-INDEX            TO HDR-11-LOWER-INDEX.   
           MOVE TS-EST-DEFEC-ABOVE-U           TO HDR-12-ABOVE-U.       
           MOVE TS-EST-DEFEC-BELOW-L           TO HDR-13-BELOW-L.       
           MOVE TS-EST-PCT-DOGS                TO HDR-14-PER-DOGS.      
           MOVE WS-TOT-EST-PCT-DEFEC           TO HDR-15-TOT-DEFEC      
                                            WS-TOT-EST-PCT-DEFEC-E.     
           MOVE WS-SAMPL-MAX-PCT-DEFEC         TO HDR-16-MAX-ALLOW      
                                            WS-SAMPL-MAX-PCT-DEFEC-E.   
           MOVE WS-PERFORMANCE-MESSAGE         TO HDR-18-PER-MESG.      
           MOVE WS-COMPARISON-LITERAL          TO HDR-18-COM-LIT.       
           IF  WS-COMPARISON-LITERAL NOT EQUAL SPACES                   
               MOVE WS-TOT-EST-PCT-DEFEC-E     TO HDR-18-PART1          
               MOVE WS-SAMPL-MAX-PCT-DEFEC-E   TO HDR-18-PART2          
           ELSE                                                         
               MOVE SPACES                     TO HDR-18-PART1          
                                                  HDR-18-PART2          
           END-IF.                                                      
       4300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11240000
      *************************************************************     11250000
      * OPENING JOB_PARM CURSOR                                   *     11260000
      *************************************************************     11270000
       7000-OPEN-JOB-PARM.                                              
           EXEC SQL                                                     
              OPEN  JOB_PARM                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11320000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 11340000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* OPEN   ERROR IN 7000-OPEN-JOB-PARM    *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11450000
      ***************************************************************   11460000
      ** FETCHING ROWS FROM JOB_PARM FOR THE TABLE CSS_JOB_PARM**       11470000
      ***************************************************************   11480000
       7010-FETCH-JOB-PARM.                                             
           EXEC SQL                                                     
              FETCH JOB_PARM                                            
               INTO :G6-SEQ-NO                                          
                   ,:G6-PARM-DATA                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11550000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 11570000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* FETCH  ERROR IN 7010-FETCH-JOB-PARM   *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11680000
      ***************************************************************   11690000
      ** CLOSING JOB_PARM FOR THE TABLE CSS_JOB_PARM               **   11700000
      ***************************************************************   11710000
       7020-CLOSE-JOB-PARM.                                             
           EXEC SQL                                                     
              CLOSE JOB_PARM                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11760000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 11780000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* CLOSE  ERROR IN 7020-CLOSE-JOB-PARM   *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11890000
      ***************************************************************   11900000
      ** SELECTING FROM THE TABLE CSS_MTR_TEST_HIST WHEN GROUP CODE**   11910000
      ** IS PRESENT IN JOB_PARM                                    **   11920000
      ***************************************************************   11930000
       7050-SELECT-TEST-HIST.                                           
           EXEC SQL                                                     
              SELECT  MQ.MTR_TEST_GRP_CD                                
                     ,GR.MTR_TEST_GRP_TX                                
                     ,MQ.STATUS_CD                                      
                     ,MQ.SELECTED_QT                                    
                     ,MQ.SAMPLE_MIN_QT                                  
                     ,MQ.TESTED_QT                                      
                INTO  :MQ-MTR-TEST-GRP-CD                               
                     ,:GR-MTR-TEST-GRP-TX                               
                     ,:MQ-STATUS-CD                                     
                     ,:MQ-SELECTED-QT                                   
                     ,:MQ-SAMPLE-MIN-QT                                 
                     ,:MQ-TESTED-QT                                     
                FROM  CSS_MTR_TEST_GROUP GR                             
                     ,CSS_MTR_TEST_HIST  MQ                             
               WHERE  MQ.CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE           
                 AND  MQ.CODE_UTIL_TYPE  = GR.CODE_UTIL_TYPE            
T22243           AND  MQ.COMPANY_NO      = GR.COMPANY_NO                
T22243           AND  MQ.COMPANY_NO      = :MQ-COMPANY-NO               
                 AND  MQ.TEST_YEAR       = :MQ-TEST-YEAR                
                 AND  MQ.TEST_SCHED_CD   = :MQ-TEST-SCHED-CD            
                 AND  MQ.MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD          
                 AND  MQ.MTR_TEST_GRP_CD = GR.MTR_TEST_GRP_CD           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12170000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 12190000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7050-SELECT-TEST-HIST *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY NO  = ' MQ-COMPANY-NO                 
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12300000
      **************************************************************    12310000
      ** OPENING TEST_GROUP CURSOR FOR THE TABLE CSS_MTR_TEST_HIST**    12320000
      **************************************************************    12330000
       7060-OPEN-TEST-GROUP.                                            
           EXEC SQL                                                     
              OPEN  TEST_GROUP                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12380000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 12400000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* OPEN   ERROR IN 7060-OPEN-TEST-GROUP  *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12510000
      ***************************************************************   12520000
      ** FETCHING TEST_GROUP CURSOR FOR THE TABLE CSS_MTR_TEST_HIST**   12530000
      ***************************************************************   12540000
       7070-FETCH-TEST-GROUP.                                           
           EXEC SQL                                                     
              FETCH TEST_GROUP                                          
               INTO :MQ-MTR-TEST-GRP-CD                                 
                   ,:GR-MTR-TEST-GRP-TX                                 
                   ,:MQ-STATUS-CD                                       
                   ,:MQ-SELECTED-QT                                     
                   ,:MQ-SAMPLE-MIN-QT                                   
                   ,:MQ-TESTED-QT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12650000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
           DISPLAY '7070 -' SQLCODE.                                    
           DISPLAY 'MQ-CODE-UTIL-TYPE = ' MQ-CODE-UTIL-TYPE.            
           DISPLAY 'MQ-COMPANY-NO     = ' MQ-COMPANY-NO.                
           DISPLAY 'MQ-MTR-TEST-GRP-CD= ' MQ-MTR-TEST-GRP-CD.           
           DISPLAY 'MQ-TEST-YEAR      = ' MQ-TEST-YEAR.                 
           DISPLAY 'MQ-TEST-SCHED-CD  = ' MQ-TEST-SCHED-CD.             
           DISPLAY 'MQ-SAMPLE-MIN-QT  = ' MQ-SAMPLE-MIN-QT.             
      *                                                                 12670000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* FETCH  ERROR IN 7070-FETCH-TEST-GROUP *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY NO  = ' MQ-COMPANY-NO                 
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12780000
      **************************************************************    12790000
      ** CLOSING TEST_GROUP CURSOR FOR THE TABLE CSS_MTR_TEST_HIST**    12800000
      **************************************************************    12810000
       7080-CLOSE-TEST-GROUP.                                           
           EXEC SQL                                                     
              CLOSE TEST_GROUP                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12860000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 12880000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* CLOSE  ERROR IN 7080-CLOSE-TEST-GROUP *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12990000
      **************************************************************    13000000
      ** OPENING GAS_METER CURSOR FOR THE TABLE CSS_GAS_METER     **    13010000
      **************************************************************    13020000
       7110-OPEN-GAS-METER.                                             
           EXEC SQL                                                     
              OPEN  GAS_METER                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13070000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 13090000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* OPEN   ERROR IN 7110-OPEN-GAS-METER  *'       
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13200000
      ***************************************************************   13210000
      ** FETCHING GAS_METER CURSOR FOR THE TABLE CSS_GAS_METER     **   13220000
      ***************************************************************   13230000
       7120-FETCH-GAS-METER.                                            
           EXEC SQL                                                     
              FETCH GAS_METER                                           
               INTO :GM-METER-NO                                        
                   ,:GM-METER-SIZE-ID                                   
                   ,:GM-LAST-TEST-SEL-DT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13330000
           DISPLAY 'METER NBR = ' GM-METER-NO.                          
      *                                                                 13330000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 13350000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* FETCH  ERROR IN 7120-FETCH-GAS-METER *'       
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY NO  = ' GM-COMPANY-NO                 
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13460000
      **************************************************************    13470000
      ** CLOSING GAS_METER CURSOR FOR THE TABLE CSS_GAS_METER     **    13480000
      **************************************************************    13490000
       7130-CLOSE-GAS-METER.                                            
           EXEC SQL                                                     
              CLOSE GAS_METER                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13540000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 13560000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* CLOSE  ERROR IN 7130-CLOSE-GAS-METER *'       
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13670000
      **************************************************************    13680000
      ** OPENING METER_TEST CURSOR FOR THE TABLE CSS_GAS_MTR_TEST *     13690000
      **************************************************************    13700000
       7140-OPEN-GAS-MTR-TEST.                                          
           EXEC SQL                                                     
              OPEN  METER_TEST                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13750000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 13770000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* OPEN   ERROR IN 7140-OPEN-GAS-MTR-TEST  *'    
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13880000
      ***************************************************************   13890000
      ** FETCHING METER_TEST CURSOR FOR THE TABLE CSS_GAS_MTR_TEST *    13900000
      ***************************************************************   13910000
       7150-FETCH-GAS-MTR-TEST.                                         
           EXEC SQL                                                     
             FETCH   METER_TEST                                         
              INTO  :GT-EQ-TESTER-ID                                    
                   ,:GT-TEST-PROVER-ID                                  
                   ,:GT-REPAIR-DESC                                     
                   ,:GT-CODE-TEST-TYPE                                  
                   ,:GT-IN-CHECK-RATE                                   
                   ,:GT-IN-OPEN-RATE                                    
                   ,:GT-DATE-TEST                                       
T18125             ,:GT-OUT-CHECK-RATE                                  
T18125             ,:GT-OUT-OPEN-RATE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14030000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 14050000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* SELECT ERROR IN 7150-FETCH-GAS-MTR-TEST*'     
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY-NO  = ' GT-COMPANY-NO                 
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14160000
      **************************************************************    14170000
      ** CLOSING METER_TEST CURSOR FOR THE TABLE CSS_GAS_MTR_TEST *     14180000
      **************************************************************    14190000
       7160-CLOSE-GAS-MTR-TEST.                                         
           EXEC SQL                                                     
              CLOSE METER_TEST                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14240000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 14260000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* CLOSE  ERROR IN 7160-CLOSE-GAS-MTR-TEST *'    
               DISPLAY '* RETURN CODE = ' SQLCODE                       
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14370000
      *************************************************************     14380000
      *   GET CURRENT DATE FROM CSS_JOB_PARM                    ***     14390000
      *************************************************************     14400000
       7500-GET-CURRENT-DATE.                                           
      *                                                                 14420000
            EXEC SQL                                                    
T14965          SELECT  CAST(SYSDATETIMEOFFSET() AS DATE), REPLACE(
           REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP(), 121), 
           ' ', '-'), ':', '.')                 
T14965            INTO  :WS-CURRENT-DATE, :WS-CURRENT-TIMESTAMP         
                  FROM  CSS_JOB_PARM                                    
                 WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                 
                   AND  COMPANY_NO   = :G6-COMPANY-NO                   
                   AND  CMND_CODE    = :G6-CMND-CODE                    
                   AND  SEQ_NO       = :G6-SEQ-NO                       
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                    14430000
MFA-TR*         SELECT  CURRENT DATE, CURRENT TIMESTAMP                 14440000
MFA-TR*           INTO  :WS-CURRENT-DATE, :WS-CURRENT-TIMESTAMP         14450000
MFA-TR*           FROM  CSS_JOB_PARM                                    14460000
MFA-TR*          WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                 14470000
MFA-TR*            AND  COMPANY_NO   = :G6-COMPANY-NO                   14480000
MFA-TR*            AND  CMND_CODE    = :G6-CMND-CODE                    14490000
MFA-TR*            AND  SEQ_NO       = :G6-SEQ-NO                       14500000
MFA-TR*     END-EXEC.                                                   14510000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14520000
            MOVE SQLCODE                TO WS-SQLCODE                   
      *                                                                 14522000
T14965      IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND              
                NEXT SENTENCE                                           
            ELSE                                                        
                DISPLAY '* SELECT ERROR IN 7500-GET-CURRENT-DATE *'     
                DISPLAY '* RETURN CODE = ' WS-SQLCODE                   
                DISPLAY '*         PROCESSING TERMINATED         *'     
                PERFORM 9900-ABEND            THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                 14640000
T18125*************************************************************     14641002
ST    *   GET ADDRESS                                           ***     14642002
      *************************************************************     14643002
       7510-GET-ADDRESS.                                                
      *                                                                 14645002
            EXEC SQL                                                    
                SELECT  AT.ACCOUNT_NO                                   
                       ,AT.LOCAL_OFFICE                                 
                       ,(DY.HOUSE_NO + DY.STREET_NAME)                          
                  INTO  :AT-ACCOUNT-NO                                  
                       ,:AT-LOCAL-OFFICE                                
                       ,:WS-RPT3-ADDRESS                                
                  FROM  CSS_MTRD_ENVRNMT   MN                           
                       ,CSS_ACCOUNT        AT                           
                       ,CSS_PREMISE        PR                           
                       ,CSS_ADDR_FORMATTED DY                           
                 WHERE  MN.CODE_UTIL_TYPE  = :WS-G                      
                   AND  AT.COMPANY_NO      = :WS-COMP-NO                
                   AND  PR.COMPANY_NO      = AT.COMPANY_NO              
                   AND  MN.ACCOUNT_NO      = AT.ACCOUNT_NO              
                   AND  MN.METER_NO        = :GM-METER-NO               
                   AND  PR.PREMISE_NO      = AT.PREMISE_NO              
                   AND  PR.ADDRESS_ID      = DY.ADDRESS_ID              
                   AND  AT.ACCT_CREATE_DT  =                            
                                        (SELECT MAX(A.ACCT_CREATE_DT)   
                                   FROM CSS_ACCOUNT A                   
                                       ,CSS_MTRD_ENVRNMT M              
                                  WHERE A.ACCOUNT_NO     = M.ACCOUNT_NO 
                                    AND M.CODE_UTIL_TYPE = :WS-G        
                                    AND M.METER_NO       = :GM-METER-NO)
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ031
MFA-TR*     EXEC SQL                                                    14646002
MFA-TR*         SELECT  AT.ACCOUNT_NO                                   14649002
MFA-TR*                ,AT.LOCAL_OFFICE                                 14649202
MFA-TR*                ,(DY.HOUSE_NO ||                                 14649302
MFA-TR*                 DY.STREET_NAME)                                 14649402
MFA-TR*           INTO  :AT-ACCOUNT-NO                                  14649502
MFA-TR*                ,:AT-LOCAL-OFFICE                                14649602
MFA-TR*                ,:WS-RPT3-ADDRESS                                14649702
MFA-TR*           FROM  CSS_MTRD_ENVRNMT   MN                           14649802
MFA-TR*                ,CSS_ACCOUNT        AT                           14649902
MFA-TR*                ,CSS_PREMISE        PR                           14650002
MFA-TR*                ,CSS_ADDR_FORMATTED DY                           14650102
MFA-TR*          WHERE  MN.CODE_UTIL_TYPE  = :WS-G                      14650202
MFA-TR*            AND  AT.COMPANY_NO      = :WS-COMP-NO                14650302
MFA-TR*            AND  PR.COMPANY_NO      = AT.COMPANY_NO              14650302
MFA-TR*            AND  MN.ACCOUNT_NO      = AT.ACCOUNT_NO              14650302
MFA-TR*            AND  MN.METER_NO        = :GM-METER-NO               14650502
MFA-TR*            AND  PR.PREMISE_NO      = AT.PREMISE_NO              14650602
MFA-TR*            AND  PR.ADDRESS_ID      = DY.ADDRESS_ID              14650702
MFA-TR*            AND  AT.ACCT_CREATE_DT  =                            14650802
MFA-TR*                                 (SELECT MAX(A.ACCT_CREATE_DT)   14650902
MFA-TR*                            FROM CSS_ACCOUNT A                   14651002
MFA-TR*                                ,CSS_MTRD_ENVRNMT M              14651102
MFA-TR*                           WHERE A.ACCOUNT_NO     = M.ACCOUNT_NO 14651202
MFA-TR*                             AND M.CODE_UTIL_TYPE = :WS-G        14651302
MFA-TR*                             AND M.METER_NO       = :GM-METER-NO)14651402
MFA-TR*     END-EXEC.                                                   14651502

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14653102
            MOVE SQLCODE                TO WS-SQLCODE                   
      *                                                                 14653302
            IF  SQLCODE EQUAL SUCCESSFUL-CALL                           
                NEXT SENTENCE                                           
            ELSE                                                        
                IF  SQLCODE EQUAL NOT-FOUND                             
                    MOVE ZEROS         TO AT-ACCOUNT-NO                 
                    MOVE SPACES        TO AT-LOCAL-OFFICE               
                                          WS-RPT3-ADDRESS               
                ELSE                                                    
                    DISPLAY '* SELECT ERROR IN 7510-GET-ADDRESS      *' 
                    DISPLAY '* RETURN CODE = ' WS-SQLCODE               
                    DISPLAY '*         PROCESSING TERMINATED         *' 
                    PERFORM 9900-ABEND            THRU 9900-EXIT        
                END-IF                                                  
            END-IF.                                                     
      *                                                                 14654202
       7510-EXIT.                                                       
END         EXIT.                                                       
T18125*                                                                 14655208
T22243*************************************************************     14641002
T22243*   GET COMPANY NAME                                      ***     14642002
T22243*************************************************************     14643002
T22243 7520-GET-COMPANY-NAME.                                           
T22243*                                                                 14645002
T22243      EXEC SQL                                                    
T22243          SELECT  COMPANY_NAME                                    
T22243            INTO  :C7-COMPANY-NAME                                
T22243            FROM  CSS_COMPANY                                     
T22243            WHERE COMPANY_NO   = :C7-COMPANY-NO                   
T22243      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22243*                                                                 14653102
T22243      MOVE SQLCODE                TO WS-SQLCODE                   
T22243*                                                                 14653302
T22243      IF  SQLCODE EQUAL SUCCESSFUL-CALL                           
T22243          NEXT SENTENCE                                           
T22243      ELSE                                                        
T22243              DISPLAY '* SELECT ERROR IN 7520-GET-COMPANY-NAME *' 
T22243              DISPLAY '* RETURN CODE = ' WS-SQLCODE               
T22243              DISPLAY '* COMPANY NO  = ' C7-COMPANY-NO            
T22243              DISPLAY '*         PROCESSING TERMINATED         *' 
T22243              PERFORM 9900-ABEND            THRU 9900-EXIT        
T22243                                                                  
T22243      END-IF.                                                     
T22243*                                                                 14654202
T22243 7520-EXIT.                                                       
T22243      EXIT.                                                       
      ***************************************************************** 14656000
      ** LOAD THE HEADER VARIABLES AND WRITE TO REPORT FILE WITH     ** 14660000
      ** THE NECESSARY BREAKS                                        ** 14670000
      ***************************************************************** 14680000
       8000-PRINT-REPORT-PARA.                                          
      *                                                                 14700000
            PERFORM 4300-LOAD-DATA-PARA THRU 4300-EXIT.                 
      *                                                                 14720000
T18125      IF  ( 57 - WS-LINE-COUNT) > 19                              
                NEXT SENTENCE                                           
            ELSE                                                        
                ADD  1                         TO WS-PAGE-COUNT         
                MOVE WS-PAGE-COUNT             TO HDR-03-PAGE           
                MOVE '01'                      TO HDR-01-SUFFIX         
T22243          MOVE  C7-COMPANY-NAME          TO HDR-01-TITLE          
                WRITE PRT33-RECORD FROM HEADER-01 AFTER NEW-PAGE        
                WRITE PRT33-RECORD FROM HEADER-02 AFTER 1               
                WRITE PRT33-RECORD FROM HEADER-03 AFTER 1               
                MOVE 03                        TO WS-LINE-COUNT         
            END-IF.                                                     
            WRITE PRT33-RECORD FROM HEADER-04 AFTER 2.                  
            WRITE PRT33-RECORD FROM HEADER-05 AFTER 1.                  
T18125      WRITE PRT33-RECORD FROM HEADER-05A AFTER 1.                 
T18125      WRITE PRT33-RECORD FROM HEADER-05B AFTER 1.                 
            WRITE PRT33-RECORD FROM HEADER-06 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-07 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-08 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-09 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-10 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-11 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-12 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-13 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-14 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-15 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-16 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-17 AFTER 2.                  
            WRITE PRT33-RECORD FROM HEADER-18 AFTER 1.                  
            WRITE PRT33-RECORD FROM HEADER-19 AFTER 1.                  
T18125      ADD 20                             TO WS-LINE-COUNT.        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15010000
      ***************************************************************** 15020000
      ** WRITING INTO ERROR RECORD WITH REQUIRED BREAKS              ** 15030000
      ***************************************************************** 15040000
       8100-WRITE-ERROR-PARA.                                           
      *                                                                 15060000
           IF  (57 - WS-ERR-COUNT) < 2                                  
               ADD  1                          TO WS-ERR-PAGE-NO        
               MOVE WS-ERR-PAGE-NO             TO HDR-02A-PAGE          
               MOVE '02'                       TO HDR-01-SUFFIX         
T22243         MOVE  C7-COMPANY-NAME           TO HDR-01-TITLE          
               WRITE PR232-RECORD FROM HEADER-01 AFTER NEW-PAGE         
               WRITE PR232-RECORD FROM HEADER-02 AFTER 1                
               WRITE PR232-RECORD FROM HEADER-02A AFTER 1               
               MOVE 3                          TO WS-ERR-COUNT          
           END-IF.                                                      
           WRITE PR232-RECORD FROM ERROR-DETAIL AFTER 2.                
           ADD 2                               TO WS-ERR-COUNT.         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15190000
T18125***************************************************************** 15191002
ST    ** WRITING TEST RECORD DETAILS INTO DETAIL-REPORT              ** 15192002
      ***************************************************************** 15193002
       8110-WRITE-DETAIL-RPT.                                           
      *                                                                 15195002
           IF  (57 - WS-DTL-COUNT) < 2                                  
               ADD  1                          TO WS-DTL-PAGE-NO        
               MOVE WS-DTL-PAGE-NO             TO WS-RPT3-PAGE          
               MOVE '03'                       TO HDR-01-SUFFIX         
T22243         MOVE C7-COMPANY-NAME            TO HDR-01-TITLE          
               WRITE PR233-RECORD FROM HEADER-01 AFTER NEW-PAGE         
               WRITE PR233-RECORD FROM WS-RPT3-HDR2 AFTER 1             
               WRITE PR233-RECORD FROM WS-RPT3-HDR3 AFTER 1             
               WRITE PR233-RECORD FROM WS-RPT3-HDR4 AFTER 2             
               WRITE PR233-RECORD FROM WS-RPT3-HDR5 AFTER 1             
               MOVE 6                          TO WS-DTL-COUNT          
           END-IF.                                                      
           WRITE PR233-RECORD FROM WS-RPT3-DETAIL AFTER 2.              
           ADD 2                               TO WS-DTL-COUNT.         
       8110-EXIT.                                                       
END        EXIT.                                                        
T18125*                                                                 15200202
      ***************************************************************** 15201000
      ** WRITING INTO FCSMT16 FILE                                   ** 15210000
      ***************************************************************** 15220000
       8150-WRITE-FIOMT16.                                              
           WRITE FIOMT16.                                               
      *                                                                 15250000
           IF  FMT16-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT16  FILE WRITE ERROR'                      
               DISPLAY 'FCSMT16  FILE STATUE IS ==>' WS-FMT16-STATUS    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 15257000
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15280000
      ***************************************************************** 15290000
      ** UPDATING CSS_MTR_TEST_HIST TABLE                            ** 15300000
      ***************************************************************** 15310000
       8600-UPDATE-TEST-HIST.                                           
      *                                                                 15330000
           EXEC SQL                                                     
             UPDATE  CSS_MTR_TEST_HIST                                  
                SET  STATUS_CD     = :MQ-STATUS-CD,                     
                     SELECTED_QT   = :MQ-SELECTED-QT,                   
                     SAMPLE_MIN_QT = :MQ-SAMPLE-MIN-QT,                 
                     TESTED_QT     = :MQ-TESTED-QT                      
              WHERE  CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE               
T22243          AND  COMPANY_NO      = :MQ-COMPANY-NO                   
                AND  TEST_YEAR       = :MQ-TEST-YEAR                    
                AND  TEST_SCHED_CD   = :MQ-TEST-SCHED-CD                
                AND  MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15450000
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* UPDATE ERROR IN 8600-UPDATE-TEST-HIST *'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY NO  = ' MQ-COMPANY-NO                 
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 15540000
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15570000
      ***************************************************************** 15580000
      ** UPDATING CSS_MTR_TEST_STATS TABLE                           ** 15590000
      ***************************************************************** 15600000
       8700-UPDATE-TEST-STATS.                                          
           EXEC SQL                                                     
             UPDATE  CSS_MTR_TEST_STATS                                 
                SET  MEAN_WITHOUT_DOGS  = :TS-MEAN-WITHOUT-DOGS,        
                     STD_DEV_WO_DOGS    = :TS-STD-DEV-WO-DOGS,          
                     UPPER_QUAL_INDEX   = :TS-UPPER-QUAL-INDEX,         
                     LOWER_QUAL_INDEX   = :TS-LOWER-QUAL-INDEX,         
                     EST_DEFEC_ABOVE_U  = :TS-EST-DEFEC-ABOVE-U,        
                     NUMBER_OF_DOGS     = :TS-NUMBER-OF-DOGS,           
                     ANALYSIS_QT        = :TS-ANALYSIS-QT,              
                     MEAN_WITH_DOGS     = :TS-MEAN-WITH-DOGS,           
                     STD_DEV_W_DOGS     = :TS-STD-DEV-W-DOGS,           
                     EST_DEFEC_BELOW_L  = :TS-EST-DEFEC-BELOW-L,        
                     EST_PCT_DOGS       = :TS-EST-PCT-DOGS              
              WHERE  CODE_UTIL_TYPE   = :TS-CODE-UTIL-TYPE              
T22243          AND  COMPANY_NO       = :TS-COMPANY-NO                  
                AND  TEST_YEAR        = :TS-TEST-YEAR                   
                AND  MTR_TEST_GRP_CD  = :TS-MTR-TEST-GRP-CD             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15790000
T14965     MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
T14965*                                                                 15792000
T14965     IF  SQLCODE EQUAL SUCCESSFUL-CALL  OR NOT-FOUND              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* UPDATE ERROR IN 8700-UPDATE-TEST-STATS*'      
               DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY NO  = ' TS-COMPANY-NO                 
               DISPLAY '*         PROCESSING TERMINATED         *'      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 15880000
       8700-EXIT.                                                       
           EXIT.                                                        
T14965*                                                                 15901100
T14965***************************************************************** 15902000
T14965** INSERTING RECORD IN CSS_MTR_TEST_STATS                      ** 15903000
T14965***************************************************************** 15904000
T14965 8800-INSERT-TEST-STATS.                                          
T14965     EXEC SQL                                                     
T14965       INSERT INTO  CSS_MTR_TEST_STATS                            
T14965               ( CODE_UTIL_TYPE    ,                              
T14965                 TEST_YEAR         ,                              
T14965                 MTR_TEST_GRP_CD   ,                              
T14965                 TEST_SCHED_CD     ,                              
T14965                 MEAN_WITHOUT_DOGS ,                              
T14965                 STD_DEV_WO_DOGS   ,                              
T14965                 UPPER_QUAL_INDEX  ,                              
T14965                 LOWER_QUAL_INDEX  ,                              
T14965                 EST_DEFEC_ABOVE_U ,                              
T14965                 NUMBER_OF_DOGS    ,                              
T14965                 MAX_PCT_DEFEC     ,                              
T14965                 ANALYSIS_TS       ,                              
T14965                 MEAN_WITH_DOGS    ,                              
T14965                 STD_DEV_W_DOGS    ,                              
T14965                 EST_DEFEC_BELOW_L ,                              
T14965                 ANALYSIS_QT       ,                              
T14965                 EST_PCT_DOGS      ,                              
T22243                 COMPANY_NO )                                     
T14965       VALUES                                                     
T14965              (:TS-CODE-UTIL-TYPE   ,                             
T14965               :TS-TEST-YEAR        ,                             
T14965               :TS-MTR-TEST-GRP-CD  ,                             
T14965               :TS-TEST-SCHED-CD    ,                             
T14965               :TS-MEAN-WITHOUT-DOGS,                             
T14965               :TS-STD-DEV-WO-DOGS  ,                             
T14965               :TS-UPPER-QUAL-INDEX ,                             
T14965               :TS-LOWER-QUAL-INDEX ,                             
T14965               :TS-EST-DEFEC-ABOVE-U,                             
T14965               :TS-NUMBER-OF-DOGS   ,                             
T14965               :TS-MAX-PCT-DEFEC    ,                             
T14965               CIS.CHAR2TIMESTAMP(:TS-ANALYSIS-TS)      ,                 
T14965               :TS-MEAN-WITH-DOGS   ,                             
T14965               :TS-STD-DEV-W-DOGS   ,                             
T14965               :TS-EST-DEFEC-BELOW-L,                             
T14965               :TS-ANALYSIS-QT      ,                             
T14965               :TS-EST-PCT-DOGS     ,                             
T22243               :TS-COMPANY-NO   )                                 
T14965     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15906000
MFA-TR*      INSERT INTO  CSS_MTR_TEST_STATS                            15907000
MFA-TR*              ( CODE_UTIL_TYPE    ,                              15908000
MFA-TR*                TEST_YEAR         ,                              15908100
MFA-TR*                MTR_TEST_GRP_CD   ,                              15908200
MFA-TR*                TEST_SCHED_CD     ,                              15908300
MFA-TR*                MEAN_WITHOUT_DOGS ,                              15908400
MFA-TR*                STD_DEV_WO_DOGS   ,                              15908500
MFA-TR*                UPPER_QUAL_INDEX  ,                              15908600
MFA-TR*                LOWER_QUAL_INDEX  ,                              15908700
MFA-TR*                EST_DEFEC_ABOVE_U ,                              15908800
MFA-TR*                NUMBER_OF_DOGS    ,                              15908900
MFA-TR*                MAX_PCT_DEFEC     ,                              15909000
MFA-TR*                ANALYSIS_TS       ,                              15909100
MFA-TR*                MEAN_WITH_DOGS    ,                              15909200
MFA-TR*                STD_DEV_W_DOGS    ,                              15909300
MFA-TR*                EST_DEFEC_BELOW_L ,                              15909400
MFA-TR*                ANALYSIS_QT       ,                              15909500
MFA-TR*                EST_PCT_DOGS      ,                              15909600
MFA-TR*                COMPANY_NO )                                     15909600
MFA-TR*      VALUES                                                     15909700
MFA-TR*             (:TS-CODE-UTIL-TYPE   ,                             15909800
MFA-TR*              :TS-TEST-YEAR        ,                             15909900
MFA-TR*              :TS-MTR-TEST-GRP-CD  ,                             15910000
MFA-TR*              :TS-TEST-SCHED-CD    ,                             15910100
MFA-TR*              :TS-MEAN-WITHOUT-DOGS,                             15910200
MFA-TR*              :TS-STD-DEV-WO-DOGS  ,                             15910300
MFA-TR*              :TS-UPPER-QUAL-INDEX ,                             15910400
MFA-TR*              :TS-LOWER-QUAL-INDEX ,                             15910500
MFA-TR*              :TS-EST-DEFEC-ABOVE-U,                             15910600
MFA-TR*              :TS-NUMBER-OF-DOGS   ,                             15910700
MFA-TR*              :TS-MAX-PCT-DEFEC    ,                             15910800
MFA-TR*              :TS-ANALYSIS-TS      ,                             15910900
MFA-TR*              :TS-MEAN-WITH-DOGS   ,                             15911000
MFA-TR*              :TS-STD-DEV-W-DOGS   ,                             15911100
MFA-TR*              :TS-EST-DEFEC-BELOW-L,                             15911200
MFA-TR*              :TS-ANALYSIS-QT      ,                             15911300
MFA-TR*              :TS-EST-PCT-DOGS     ,                             15911400
MFA-TR*              :TS-COMPANY-NO   )                                 15911400
MFA-TR*    END-EXEC.                                                    15912000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T14965*                                                                 15912100
T14965     IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
T14965         NEXT SENTENCE                                            
T14965     ELSE                                                         
T14965         DISPLAY '* INSERT ERROR IN 8800-UPDATE-TEST-STATS*'      
T14965         DISPLAY '* RETURN CODE = ' SQLCODE                       
T22243         DISPLAY '* COMPANY NO  = ' TS-COMPANY-NO                 
T14965         DISPLAY '*         PROCESSING TERMINATED         *'      
T14965         PERFORM 9900-ABEND            THRU 9900-EXIT             
T14965     END-IF.                                                      
T14965*                                                                 15913200
T14965 8800-EXIT.                                                       
T14965     EXIT.                                                        
      *                                                                 15914000
      ******************************************************************15930000
      *   TERMINATION ROUTINE                                          *15940000
      ******************************************************************15950000
      *                                                                 15960000
       9000-TERMINATE.                                                  
      *                                                                 15980000
           CLOSE FCSMT14-FILE.                                          
      *                                                                 16000000
           IF  FMT14-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT14  FILE CLOSE ERROR'                      
               DISPLAY 'FCSMT14  FILE STATUE IS ==>' WS-FMT14-STATUS    
           END-IF.                                                      
      *                                                                 16080000
           CLOSE FCSMT16-FILE.                                          
           IF  FMT16-SUCCESS                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FCSMT16  FILE CLOSE ERROR'                      
               DISPLAY 'FCSMT16  FILE STATUE IS ==>' WS-FMT16-STATUS    
           END-IF.                                                      
      *                                                                 16170000
           CLOSE FCSPT33-FILE.                                          
      *                                                                 16260000
           CLOSE FCSP232-FILE.                                          
      *                                                                 16350000
T18125     CLOSE FCSP233-FILE.                                          
T18125*                                                                 16352002
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16380000
      **************************************************************    16390000
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *    16400000
      **************************************************************    16410000
           EXEC SQL                                                     16420000
             INCLUDE CPD09900                                           16430000
           END-EXEC.                                                    16440000
      *                                                                 16450000
