00001  IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR009.                                           
00003  AUTHOR.        CARL SALTER.                                      
00004  DATE-WRITTEN.  MARCH 1, 1989.                                    
00005 ******************************************************************ELE009  
00006 *  THIS PROGRAM TAKES A VENDOR TAPE CONTAINING ELECTRIC METER    *ELE009  
00007 *    UPDATES AND CONVERTS THE RECORDS INTO A READABLE FORMAT     *ELE009  
00008 *    FOR THE ELECTRIC METER/HISTORY SYSTEMS.  A PARM IS USED TO  *ELE009  
00009 *    INDICATE WHETHER THE METERS ON THE TAPE ARE BEING SHIPPED   *ELE009  
00010 *    TO COLUMBIA (02) OR CHARLESTON (90).  THIS INFORMATION,     *ELE009  
00011 *    ALONG WITH OTHER SET FIELDS, ARE SUPPLIED ONTO THE NEW      *ELE009  
00012 *    TRANSACTIONS.  A TOTAL TRANSACTION IS ALSO WRITTEN FOR THE  *ELE009  
00013 *    ELECTRIC METER HISTORY TRANSACTIONS.  A REPORT IS PRINTED   *ELE009  
00014 *    INDICATING EACH VENDOR TRANSACTION THAT WAS EXTRACTED.      *ELE009  
00015 ******************************************************************ELE009  
      ******************************************************************00140201
      **                                                              **00140301
      **              PROGRAM  MODIFICATION  LOG                      **00140401
      **                                                              **00140501
      ** DATE    INITIALS       REASON                                **00140601
      **________  ________   ______________                           **00140701
      **                                                              **00140801
T18703** 12/98     CBSI      CHANGES MADE FOR POSTING THE VENDOR FILE **00140901
T18703**                     TO THE NEW SYSTEM.                       **00141001
C26373** 08/09     CBSI      CHANGED TO PROPERLY POPULATE PROGRAM ID  **        
C26373**                     TO THE OUTPUT FILE.                      **        
T33287** 11/05     JC91900   CONVERT ALL COMPONENTS RELATED TO ELE    **        
T33287**                     SUBSYSTEM TO ELC.                        **        
      **                                                              **        
C33887**  03/13/07 NC94746   ADD METER ATTACHMENTS WHILE INSERTING    **        
C33887**                     METERS INTO METER INVENTORY              **        
P00462**  01/11/11 SS95855   CHANGE RECORD LENGTH FOR FIOMT19         **        
ACT144**  08/13/13 BD09555   CONVERT FROM DATE CARD TO COMMON DATE    **        
      **                                                              **        
A05460**  14 JUN 2016 RF10596 CHANGED PROGRAM NAME FROM ELC009 TO     **        
A05460**                      CSR009 AND COPYBOOK ELCCTMAS TO CSRCTMAS**        
      **                                                              **        
      ******************************************************************00150001
00016  ENVIRONMENT DIVISION.                                            
00017  INPUT-OUTPUT SECTION.                                            
00018  FILE-CONTROL.                                                    
C33887      COPY CSSMT19.                                               ELE009  
00020       SELECT ELEMTTRN    ASSIGN UT-S-ELEMTTRN.                    
00021       SELECT ELEMHTRN    ASSIGN UT-S-ELEMHTRN.                    
00022       SELECT PRINTER     ASSIGN UT-S-PRINTER.                     
00023  DATA DIVISION.                                                   
00024  FILE SECTION.                                                    
C33887     COPY CFDMT19.                                                        
C33887     COPY FIOMT19.                                                        
00031  FD  ELEMTTRN                                                     
00032      BLOCK CONTAINS 0 RECORDS                                     
00033      RECORD CONTAINS 80 CHARACTERS                                
00034      LABEL RECORDS ARE STANDARD                                   
00035      DATA RECORD IS METER-TEST-OUT.                               
00036  01  METER-TEST-OUT.                                              
00037      03  FILLER                  PIC X(80).                       
00038  FD  ELEMHTRN                                                     
00039      BLOCK CONTAINS 0 RECORDS                                     
P00462     RECORD CONTAINS 170 CHARACTERS                               
00041      LABEL RECORDS ARE STANDARD                                   
00042      DATA RECORD IS METER-HISTORY-OUT.                            
00043  01  METER-HISTORY-OUT.                                           
P00462     03  FILLER                  PIC X(170).                      
00045  FD  PRINTER                                                      
00046      BLOCK CONTAINS 0 RECORDS                                     
00047      RECORD CONTAINS 133 CHARACTERS                               
00048      LABEL RECORDS ARE STANDARD                                   
00049      DATA RECORD IS PRINT-AREA.                                   
00050  01  PRINT-AREA.                                                  
00051      03  FILLER                 PIC X.                            
00052      03  PRINT-LINE             PIC X(132).                       
00053 ***************************************************************** ELE009  
00054  WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR009'.
MSQ017     COPY MFASQLM.
00055 ***************************************************************** ELE009  
C33887 01  WS-TEMP-FIELDS.                                              
C33887     03 WS-CURR-DATE-YYMMDD.                                      
C33887        05 WS-CURR-DATE-YY          PIC X(02) VALUE SPACES.       
C33887        05 WS-CURR-DATE-MM          PIC X(02) VALUE SPACES.       
C33887        05 WS-CURR-DATE-DD          PIC X(02) VALUE SPACES.       
00056  01  WS-FIELDS.                                                   
00057      03  EOJ-CD                  PIC S9(4)  COMP SYNC VALUE +0.   
00058      03  LN-CNT                  PIC S9(3)  COMP-3  VALUE +56.    
00059      03  PG-CNT                  PIC S9(3)  COMP-3  VALUE +0.     
00060      03  REC-CNT                 PIC S9(5)  COMP-3  VALUE +0.     
00061      03  NBR                     PIC 9              VALUE 0.      
ACT144     03  WS-PARAGRAPH            PIC X(30)   VALUE 'MAINLINE'.    
ACT144     03  WS-TABLE                PIC X(16)   VALUE 'CSS_JOB_PARM'.
00062  01  Y-N-SWITCHES.                                                
00063      03  EOJ-SW                  PIC X        VALUE 'N'.          
00064      03  ERR-SW                  PIC X        VALUE 'N'.          
00065      03  TOP-SW                  PIC X        VALUE 'N'.          
ACT144 01  WS-CURRENT-DATE             PIC X(10).                       
ACT144 01  FILLER REDEFINES WS-CURRENT-DATE.                            
ACT144     05 WS-CURRENT-YEAR.                                          
ACT144        10 WS-CURRENT-CC         PIC XX.                          
ACT144        10 WS-CURRENT-YY         PIC XX.                          
ACT144     05 FILLER                   PIC X.                           
ACT144     05 WS-CURRENT-MONTH         PIC XX.                          
ACT144     05 FILLER                   PIC X.                           
ACT144     05 WS-CURRENT-DAY           PIC XX.                          
      *                                                                 ELE009  
A05460     COPY CSRCTMAS.                                                  CL**5
      *                                                                 ELE009  
00106  01  HEADING-1.                                                   
T18703     03  FILLER                  PIC X(6)    VALUE 'CSR009'.      
T18703     03  FILLER                  PIC X(41)   VALUE SPACES.        
00110      03  FILLER                  PIC X(39)   VALUE                
00111          'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.               
00112      03  FILLER                  PIC X(38)   VALUE SPACES.        
00113      03  FILLER                  PIC X(5)    VALUE 'PAGE '.       
00114      03  PRT-PAGE                PIC ZZ9.                         
00115  01  HEADING-2A.                                                  
00116      03  FILLER                  PIC X(41)   VALUE SPACES.        
00117      03  FILLER                  PIC X(39)   VALUE                
00118      'RECORDS EXTRACTED FROM VENDOR TAPE FOR '.                   
00119      03  PRT-TITLE-LOC           PIC X(10).                       
00120      03  FILLER                  PIC X(42)   VALUE SPACES.        
00121  01  HEADING-2B.                                                  
00122      03  FILLER                  PIC X(32)   VALUE SPACES.        
00123      03  FILLER                  PIC X(68)   VALUE                
00124      'TRANSACTIONS WILL ATTEMPT TO POST ON NEXT ELECTRIC METER HISELE009  
00125 -    'TORY RUN'.                                                  ELE009  
00126      03  FILLER                  PIC X(32)   VALUE SPACES.        
00127  01  HEADING-3.                                                   
00128      03  FILLER                  PIC X(62)   VALUE SPACES.        
00129      03  CUR-MO                  PIC XX.                          
00130      03  FILLER                  PIC X       VALUE '/'.           
00131      03  CUR-DA                  PIC XX.                          
00132      03  FILLER                  PIC X       VALUE '/'.           
T18703     03  CUR-YR                  PIC X(04).                       
T18703     03  FILLER                  PIC X(60)   VALUE SPACES.        
00135  01  DETAIL-HEADING.                                              
C33887     03  FILLER                  PIC X(12)   VALUE SPACES.        
00137      03  FILLER                  PIC X(9)    VALUE 'METER NBR'.   
T18703     03  FILLER                  PIC X(08)   VALUE SPACES.        
T18703     03  FILLER                  PIC X(08)   VALUE 'CLASS CD'.    
T18703     03  FILLER                  PIC X(04)   VALUE SPACES.        
T18703     03  FILLER                  PIC X(07)   VALUE 'SPEC CD'.     
C33887     03  FILLER                  PIC X(06)   VALUE SPACES.        
C33887     03  FILLER                  PIC X(13)                        
C33887                                  VALUE 'PURCHASE DATE'.          
C33887     03  FILLER                  PIC X(06)   VALUE SPACES.        
00146      03  FILLER                  PIC X(16)   VALUE                
00147          'METER SERIAL NBR'.                                      
C33887     03  FILLER                  PIC X(07)   VALUE SPACES.        
C33887     03  FILLER                  PIC X(13)                        
C33887                           VALUE 'ATTACHMENT NO'.                 
C33887     03  FILLER                  PIC X(08)   VALUE SPACES.        
C33887     03  FILLER                  PIC X(15)                        
C33887                           VALUE 'ATTACHMENT TYPE'.               
00149  01  DETAIL-LINE.                                                 
C33887     03  FILLER                  PIC X(12)   VALUE SPACES.        
00151      03  PRT-COMPANY-METER-NBR   PIC X(9).                        
T18703     03  FILLER                  PIC X(11)   VALUE SPACES.        
T18703     03  PRT-MTR-CLASS-CD        PIC X(2).                        
T18703     03  FILLER                  PIC X(09)   VALUE SPACES.        
T18703     03  PRT-MTR-SPEC-CD         PIC X(3).                        
C33887     03  FILLER                  PIC X(10)   VALUE SPACES.        
C33887     03  PRT-MONTH-OF-PURCHASE   PIC X(2).                        
C33887     03  FILLER                  PIC X(01)   VALUE '/'.           
C33887     03  PRT-DAY-OF-PURCHASE     PIC X(2).                        
C33887     03  FILLER                  PIC X(01)   VALUE '/'.           
C33887     03  PRT-YEAR-OF-PURCHASE    PIC X(4).                        
C33887     03  FILLER                  PIC X(10)   VALUE SPACES.        
C33887     03  PRT-METER-SERIAL-NBR    PIC X(11).                       
C33887     03  FILLER                  PIC X(10)   VALUE SPACES.        
C33887     03  PRT-ATTACHMENT-NO       PIC X(12).                       
C33887     03  FILLER                  PIC X(09)   VALUE SPACES.        
C33887     03  FILLER                  PIC X(06)   VALUE SPACES.        
C33887     03  PRT-ATT-TYPE            PIC X(02).                       
C33887     03  FILLER                  PIC X(07)   VALUE SPACES.        
00165  01  TOTAL-LINE.                                                  
00166      03  FILLER                  PIC X(38)   VALUE SPACES.        
00167      03  FILLER                  PIC X(49)   VALUE                
00168          'TOTAL NUMBER OF VENDOR TRANSACTIONS EXTRACTED IS '.     
00169      03  PRT-REC-CNT             PIC ZZ,ZZ9.                      
00170      03  FILLER                  PIC X(39)   VALUE SPACES.        
ACT144     EXEC SQL                                                             
ACT144         INCLUDE SQLCA                                                    
ACT111     END-EXEC.                                                            
00171  LINKAGE SECTION.                                                 
00172  01  PARM-CARD.                                                   
00173      03  FILLER              PIC S9(4)    COMP.                   
00174      03  METER-LOCATION-PARM PIC XX.                              
00175  PROCEDURE DIVISION USING PARM-CARD.                              
ACT144     EXEC SQL SELECT  CIS.SUBSTR3(PARM_DATA,10,10)                     
ACT144         INTO  :WS-CURRENT-DATE                                   
ACT144         FROM  CSS_JOB_PARM                                       
ACT144       WHERE  PROGRAM_NAME   = 'COMMON'                           
ACT144         AND  COMPANY_NO     = '01'                               
ACT144         AND  CMND_CODE      = 'DATE'                             
ACT144         AND  SEQ_NO         = 10                                 
ACT144         AND  STATUS         = 'A'                                
ACT144     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL SELECT  SUBSTR(PARM_DATA,10,10)                             
MFA-TR*        INTO  :WS-CURRENT-DATE                                           
MFA-TR*        FROM  CSS_JOB_PARM                                               
MFA-TR*      WHERE  PROGRAM_NAME   = 'COMMON'                                   
MFA-TR*        AND  COMPANY_NO     = '01'                                       
MFA-TR*        AND  CMND_CODE      = 'DATE'                                     
MFA-TR*        AND  SEQ_NO         = 10                                         
MFA-TR*        AND  STATUS         = 'A'                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT144     PERFORM P9500-CHECK-SQL  THRU P9500-EXIT.                    
ACT144     MOVE WS-CURRENT-MONTH      TO WS-CURR-DATE-MM CUR-MO.        
ACT144     MOVE WS-CURRENT-DAY        TO WS-CURR-DATE-DD CUR-DA.        
ACT144     MOVE WS-CURRENT-YEAR       TO CUR-YR.                        
ACT144     MOVE WS-CURRENT-YY         TO WS-CURR-DATE-YY                
C33887     OPEN INPUT   FCSMT19-FILE                                    
00182           OUTPUT ELEMHTRN ELEMTTRN PRINTER.                       
00183      PERFORM P8000-EDIT-PARM-VALUE THRU P8000-EXIT.               
00184      IF ERR-SW IS EQUAL TO 'Y'                                    
00185         NEXT SENTENCE                                             
00186      ELSE                                                         
00187         PERFORM P9000-READ-VNDTAPEI THRU P9000-EXIT               
00188         PERFORM P1000-PROCESS-MAIN-ROUTINE THRU P1000-EXIT        
00189               UNTIL EOJ-SW IS EQUAL TO 'Y'
           END-IF.                       
00190      PERFORM P1500-PRINT-TOTAL-LINE THRU P1500-EXIT.              
C33887     CLOSE  FCSMT19-FILE  ELEMTTRN ELEMHTRN PRINTER.              
00192      MOVE EOJ-CD TO RETURN-CODE.                                  
00193      STOP RUN.                                                    
00194  P1000-PROCESS-MAIN-ROUTINE.                                      
00195      IF ERR-SW IS EQUAL TO 'Y'                                    
00196         MOVE 'N' TO ERR-SW                                        
00197      ELSE                                                         
C33887        IF E-FMT19-METER-NO EQUAL SPACES OR LOW-VALUES            
T18703           CONTINUE                                               
T18703        ELSE                                                      
00198         PERFORM P1100-CREATE-METER-TEST-FILE THRU P1100-EXIT      
00199         PERFORM P1200-CREATE-METER-HIST-FILE THRU P1200-EXIT      
00200         PERFORM P1300-PRINT-EXTRACTED-REC THRU P1300-EXIT
              END-IF
           END-IF.        
00201      PERFORM P9000-READ-VNDTAPEI THRU P9000-EXIT.                 
00202  P1000-EXIT.                                                      
00203      EXIT.                                                        
00204  P1100-CREATE-METER-TEST-FILE.                                    
00205      PERFORM P1110-MOVE-GENERAL-TEST-INFO THRU P1110-EXIT.        
00206      PERFORM P1120-CHK-WHICH-TEST-CITY THRU P1120-EXIT.           
00207      PERFORM P1130-WRITE-MTR-TEST-REC THRU P1130-EXIT.            
00208  P1100-EXIT.                                                      
00209      EXIT.                                                        
00210  P1110-MOVE-GENERAL-TEST-INFO.                                    
C33887     MOVE SPACES TO ZFMELMTC.                                     
C33887     MOVE E-FMT19-METER-NO       TO ZFM-METER-NO.                 
C33887     MOVE WS-CURR-DATE-YYMMDD    TO ZFM-DATE-OF-TEST.             
C33887     MOVE E-FMT19-METER-HISTORY-CODE  TO ZFM-METER-HISTORY.       
C33887     MOVE E-FMT19-PURCHASE-YY    TO ZFM-YEAR-PURCHASED.           
C33887     MOVE E-FMT19-METER-SERIAL-NBR(4:)  TO ZFM-SERIAL-NO.         
00217      MOVE 'K' TO ZFM-REASON-FOR-TEST.                             
00218      MOVE '7' TO ZFM-TEST-SCHEDULE                                
00219      MOVE 'A' TO ZFM-FCN.                                         
00220      MOVE '1' TO ZFM-CARD-SEQ.                                    
00221  P1110-EXIT.                                                      
00222      EXIT.                                                        
00223  P1120-CHK-WHICH-TEST-CITY.                                       
00224      IF METER-LOCATION-PARM IS EQUAL TO '02'                      
00225         MOVE '02' TO ZFM-DISTRICT                                 
00226      ELSE                                                         
00227         IF METER-LOCATION-PARM IS EQUAL TO '90'                   
00228            MOVE '90' TO ZFM-DISTRICT                              
00229         ELSE                                                      
00230            MOVE '00' TO ZFM-DISTRICT
              END-IF
           END-IF.                             
C33887      IF E-FMT19-METER-STORAGE-FAC > SPACES                       
C33887         MOVE E-FMT19-METER-STORAGE-FAC(1:2) TO ZFM-DISTRICT      
C33887      END-IF.                                                     
00231  P1120-EXIT.                                                      
00232      EXIT.                                                        
00233  P1130-WRITE-MTR-TEST-REC.                                        
00234      MOVE ZFMELMTC TO METER-TEST-OUT.                             
00235      WRITE METER-TEST-OUT.                                        
00236  P1130-EXIT.                                                      
00237      EXIT.                                                        
00238  P1200-CREATE-METER-HIST-FILE.                                    
00241      PERFORM P1230-WRITE-MTR-HIST-REC THRU P1230-EXIT.            
00242  P1200-EXIT.                                                      
00243      EXIT.                                                        
00308  P1230-WRITE-MTR-HIST-REC.                                        
C33887     MOVE SPACES TO METER-HISTORY-OUT                             
C33887     MOVE FIOMT19 TO METER-HISTORY-OUT.                           
00310      WRITE METER-HISTORY-OUT.                                     
00311  P1230-EXIT.                                                      
00312      EXIT.                                                        
00313  P1300-PRINT-EXTRACTED-REC.                                       
00314      IF LN-CNT IS GREATER THAN +55                                
00315         PERFORM P8100-PRINT-HEADINGS THRU P8100-EXIT
           END-IF.             
C33887     MOVE E-FMT19-METER-NO     TO PRT-COMPANY-METER-NBR.          
C33887     MOVE E-FMT19-MTR-CLASS-CD TO PRT-MTR-CLASS-CD.               
C33887     MOVE E-FMT19-MTR-SPEC-CD  TO PRT-MTR-SPEC-CD.                
C33887     MOVE E-FMT19-PURCHASE-CC  TO PRT-YEAR-OF-PURCHASE(1:2)       
C33887     MOVE E-FMT19-PURCHASE-YY  TO PRT-YEAR-OF-PURCHASE(3:2)       
C33887     MOVE E-FMT19-PURCHASE-MM  TO PRT-MONTH-OF-PURCHASE           
C33887     MOVE E-FMT19-PURCHASE-DD  TO PRT-DAY-OF-PURCHASE             
C33887     MOVE E-FMT19-METER-SERIAL-NBR  TO PRT-METER-SERIAL-NBR.      
C33887     MOVE E-FMT19-ATTACHMENT-NO  TO PRT-ATTACHMENT-NO.            
C33887     MOVE E-FMT19-ATT-TYPE       TO PRT-ATT-TYPE.                 
00324      MOVE DETAIL-LINE TO PRINT-LINE.                              
00325      PERFORM P9100-WRITE-PRINTER THRU P9100-EXIT.                 
00326      ADD +1 TO LN-CNT.                                            
00327      ADD +1 TO REC-CNT.                                           
00328  P1300-EXIT.                                                      
00329      EXIT.                                                        
00330  P1500-PRINT-TOTAL-LINE.                                          
00331      MOVE REC-CNT TO PRT-REC-CNT.                                 
00332      MOVE TOTAL-LINE TO PRINT-LINE.                               
00333      MOVE 3 TO NBR.                                               
00334      PERFORM P9100-WRITE-PRINTER THRU P9100-EXIT.                 
00335  P1500-EXIT.                                                      
00336      EXIT.                                                        
00337  P8000-EDIT-PARM-VALUE.                                           
00338      IF METER-LOCATION-PARM IS EQUAL TO '02'                      
00339         MOVE 'COLUMBIA  ' TO PRT-TITLE-LOC                        
00340      ELSE                                                         
00341         IF METER-LOCATION-PARM IS EQUAL TO '90'                   
00342            MOVE 'CHARLESTON' TO PRT-TITLE-LOC                     
00343         ELSE                                                      
00344            IF METER-LOCATION-PARM IS EQUAL TO '00'                
00345               MOVE 'STOREROOM ' TO PRT-TITLE-LOC                  
00346            ELSE                                                   
                    DISPLAY 'CSR009- PARM ERROR- PARM VALUE ENTERED IS '
00348                 METER-LOCATION-PARM UPON SYSOUT                   
00349               MOVE 'Y' TO EOJ-SW                                  
00350               MOVE 'Y' TO ERR-SW                                  
00351               MOVE '9' TO EOJ-CD
                 END-IF
              END-IF
           END-IF.                                 
00352  P8000-EXIT.                                                      
00353      EXIT.                                                        
00354  P8100-PRINT-HEADINGS.                                            
00355      ADD +1 TO PG-CNT                                             
00356      MOVE PG-CNT TO PRT-PAGE.                                     
00357      MOVE HEADING-1 TO PRINT-LINE.                                
00358      MOVE 'Y' TO TOP-SW.                                          
00359      PERFORM P9100-WRITE-PRINTER THRU P9100-EXIT.                 
00360      MOVE 'N' TO TOP-SW.                                          
00361      MOVE HEADING-2A TO PRINT-LINE.                               
00362      MOVE '1' TO NBR.                                             
00363      PERFORM P9100-WRITE-PRINTER THRU P9100-EXIT.                 
00364      MOVE HEADING-2B TO PRINT-LINE.                               
00365      PERFORM P9100-WRITE-PRINTER THRU P9100-EXIT.                 
00366      MOVE HEADING-3 TO PRINT-LINE.                                
00367      PERFORM P9100-WRITE-PRINTER THRU P9100-EXIT.                 
00368      MOVE 2 TO NBR.                                               
00369      MOVE DETAIL-HEADING TO PRINT-LINE.                           
00370      PERFORM P9100-WRITE-PRINTER THRU P9100-EXIT.                 
00371      MOVE 1 TO NBR.                                               
00372      MOVE +6 TO LN-CNT.                                           
00373  P8100-EXIT.                                                      
00374      EXIT.                                                        
00375  P9000-READ-VNDTAPEI.                                             
00376      READ  FCSMT19-FILE                                           
00377        AT END MOVE 'Y' TO EOJ-SW.                                 
00378  P9000-EXIT.                                                      
00379      EXIT.                                                        
00380  P9100-WRITE-PRINTER.                                             
00381      IF TOP-SW IS EQUAL TO 'Y'                                    
00382         WRITE PRINT-AREA                                          
00383           AFTER ADVANCING PAGE                                    
00384      ELSE                                                         
00385         WRITE PRINT-AREA                                          
00386           AFTER ADVANCING NBR LINES
           END-IF.                              
00387  P9100-EXIT.                                                      
00388      EXIT.                                                        
00380  P9500-CHECK-SQL.                                                 
00381      IF SQLCODE NOT = 0                                           
00382         DISPLAY 'CSR009 - SQLCODE =   ' SQLCODE
           END-IF.                  
00382         DISPLAY 'CSR009 - PARAGRAPH = ' WS-PARAGRAPH.             
00382         DISPLAY 'CSR009 - TABLE   =   ' WS-TABLE.                 
00387  P9500-EXIT.                                                      
00388      EXIT.                                                        
