      *****************************************************************         
      ** CWSLM003: THIS COPYBOOK IS THE WORKING STORAGE FOR CPDLM003 **         
      *****************************************************************         
      *                                                                         
       01 CPDLM3-INPUT.                                                 
          05 CPDLM3-CALL-TYPE       PIC X(01) VALUE SPACES.             
          05 CPDLM3-FXTR-SEQ        PIC S9(10)V COMP-3 VALUE 0.         
          05 CPDLM3-INSTALL-LOC-NO  PIC X(10) VALUE SPACES.             
          05 CPDLM3-ACCOUNT-NO      PIC S9(13)V COMP-3 VALUE 0.         
          05 CPDLM3-INPUT-DATE      PIC X(10) VALUE SPACES.             
          05 CPDLM3-CURR-DATE       PIC X(10) VALUE SPACES.             
          05 CPDLM3-CURR-TMSTMP     PIC X(26) VALUE SPACES.             
          05 CPDLM3-USER-ID         PIC X(07) VALUE SPACES.             
          05 CPDLM3-UPDATE-FL       PIC X(01) VALUE SPACES.             
      *                                                                         
       01 CPDLM3-OUTPUT.                                                
          05 CPDLM3-RETURN-CODE     PIC S9(09) COMP VALUE 0.            
          05 CPDLM3-TOTAL-CHRG-AM   PIC S9(5)V9(2) COMP-3 VALUE 0.      
          05 CPDLM3-DURA-LIGHT-CT   PIC X(01) VALUE SPACES.             
          05 CPDLM3-CONV-LIGHT-CT   PIC S9(4) COMP VALUE 0.             
          05 CPDLM3-APPROVAL-REQ-FL PIC X(01) VALUE SPACES.             
      *                                                                         
       01 CPDLM3-ERR-DATA.                                              
      *                                                                         
          05 CPDLM3-ERROR-FLAG      PIC X(01) VALUE SPACES.             
             88 CPDLM3-ERROR                  VALUE 'Y'.                
             88 CPDLM3-NO-ERROR               VALUE 'N'.                
      *                                                                         
          05 CPDLM3-ERROR-MSG       PIC X(06) VALUE SPACES.             
             88 CPDLM3-ERR-CALL-TYPE          VALUE 'LM3M01'.           
             88 CPDLM3-ERR-FXTR-SEQ           VALUE 'LM3M02'.           
             88 CPDLM3-ERR-LOC-NO             VALUE 'LM3M03'.           
             88 CPDLM3-ERR-ACCOUNT-NO         VALUE 'LM3M04'.           
             88 CPDLM3-DB2-ERROR              VALUE 'LM3M99'.           
      *                                                                         
       01 CPDLM3-4D-STORAGE.                                            
          05 LM3-4D-EQUIP-SEQ           PIC S9(10)V COMP-3 VALUE 0.     
          05 LM3-4D-EQUIP-TAG-NO        PIC X(12) VALUE SPACES.         
          05 LM3-4D-COMPANY-NO          PIC X(02) VALUE SPACES.         
          05 LM3-4D-CODE-SERVICE-TYPE   PIC X(01) VALUE SPACES.         
          05 LM3-4D-EQUIP-TYPE-CD       PIC X(01) VALUE SPACES.         
      *                                                                         
       01 CPDLM3-4L-STORAGE.                                            
          05 LM3-4L-CNTRCT-START-DT     PIC X(10) VALUE SPACES.         
          05 LM3-4L-CNTRCT-END-DT       PIC X(10) VALUE SPACES.         
          05 LM3-4L-CNTRCT-DURATION-CD  PIC X(02) VALUE SPACES.         
          05 LM3-4L-FIXTURE-COST-AM     PIC S9(5)V9(2) COMP-3 VALUE 0.  
          05 LM3-4L-POLE-COST-AM        PIC S9(5)V9(2) COMP-3 VALUE 0.  
          05 LM3-4L-LAST-UPDATE-USERID  PIC X(07) VALUE SPACES.         
          05 LM3-4L-CNTRCT-STATUS-CD    PIC X(01) VALUE SPACES.         
          05 LM3-4L-ORIG-TERM-CHRG-AM   PIC S9(5)V9(2) COMP-3 VALUE 0.  
          05 LM3-4L-ACTL-TERM-CHRG-AM   PIC S9(5)V9(2) COMP-3 VALUE 0.  
          05 LM3-4L-ACTL-CHRG-DT        PIC X(10) VALUE SPACES.         
      *                                                                         
       01 CPDLM3-CNTRCT-FLAG            PIC X(01) VALUE 'N'.            
          88 CPDLM3-NO-MORE-CNTRCT            VALUE 'Y'.                
      *                                                                         
       01 CPDLM3-MISC-VAR.                                              
          05 CPDLM3-POLE-BILL-FL     PIC X(01) VALUE SPACES.            
          05 CPDLM3-TERM-CHRG-AM     PIC S9(5)V9(2) COMP-3 VALUE 0.     
          05 CPDLM3-TOT-EQUIP-CST    PIC S9(5)V9(2) COMP-3 VALUE 0.     
          05 CPDLM3-DEPRECIATION-CST PIC S9(5)V9(2) COMP-3 VALUE 0.     
          05 CPDLM3-REMOVAL-CST      PIC S9(5)V9(2) COMP-3 VALUE 0.     
          05 CPDLM3-SALVAGE-CRED-CST PIC S9(5)V9(2) COMP-3 VALUE 0.     
          05 CPDLM3-REMAIN-YEARS     PIC S9(4) USAGE COMP VALUE 0.      
          05 CPDLM3-REMAIN-DAYS      PIC S9(4) USAGE COMP VALUE 0.      
          05 CPDLM3-TERM-CHRG-STR    PIC -ZZZZ9.99.                     
COB305    05 CPDLM3-DEPRECIATION-PCT        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 CPDLM3-REMOVAL-COST-PCT        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.       
COB305    05 CPDLM3-SALVAGE-CRED-PCT        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.       
                                                                        
      *                                                                         
       01 WS-NULL-INDICATORS.                                           
          05 CPDLM3-IND-ACTL-CHRG-DT PIC S9(04) COMP.                   
      *                                                                         
       01 CPDLM3-LITERALS.                                              
          05 CPDLM3-YES-NULL         PIC S9(4) VALUE -1.                
          05 CPDLM3-LMS              PIC X(03) VALUE 'LMS'.             
          05 CPDLM3-NEW              PIC X(07) VALUE '**NEW**'.         
          05 CPDLM3-TERMINATE        PIC X(01) VALUE 'T'.               
          05 CPDLM3-TRNS-HIST-TXT-1  PIC X(40) VALUE                    
                 'TERMINATION CHARGES HAVE BEEN CALCULATED'.            
          05 CPDLM3-TRNS-HIST-TXT-2  PIC X(52) VALUE                    
                 'TERMINATION CHARGES HAVE BEEN CALCULATED AND APPLIED'.
      *                                                                         
      ******************************************************************        
      **  DECLARE CURSOR TO GET ALL ACTIVE CONTRACTS FOR A PREMISE.   **        
      ******************************************************************        
      *                                                                         
           EXEC SQL DECLARE ACCT-CNTRCT-CUR CURSOR WITH HOLD FOR        
             SELECT  [4D].EQUIP_SEQ                                       
                    ,[4D].EQUIP_TAG_NO                                    
                    ,[4D].COMPANY_NO                                      
                    ,[4D].CODE_SERVICE_TYPE                               
                    ,[4D].EQUIP_TYPE_CD                                   
                    ,[4L].CNTRCT_START_DT                                 
                    ,[4L].CNTRCT_END_DT                                   
                    ,[4L].CNTRCT_DURATION_CD                              
                    ,[4L].FIXTURE_COST_AM                                 
                    ,[4L].POLE_COST_AM                                    
                    ,[4L].LAST_UPDATE_USERID                              
                    ,[4L].CNTRCT_STATUS_CD                                
                    ,[4L].ORIG_TERM_CHRG_AM                               
                    ,[4L].ACTL_TERM_CHRG_AM                               
                    ,[4L].ACTL_CHRG_DT                                    
               FROM  LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
                    ,LMS_EQUIP_CONTRACT [4L] WITH(READUNCOMMITTED)              
              WHERE  [4D].EQUIP_SEQ         =  [4L].EQUIP_SEQ               
                AND  [4D].EQUIP_TYPE_CD     = 'F'                         
                AND  [4L].INSTALL_LOC_NO    = :CPDLM3-INSTALL-LOC-NO      
                AND  [4L].ACCOUNT_NO        = :CPDLM3-ACCOUNT-NO          
                AND  [4L].CNTRCT_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                     :CPDLM3-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :CPDLM3-INPUT-DATE
              ) <> 0) OR (LEN(:CPDLM3-INPUT-DATE
              ) <> 10), CIS.CHAR2DATE(:CPDLM3-INPUT-DATE
              ), CONVERT(DATE, :CPDLM3-INPUT-DATE) )          
                AND  [4L].CNTRCT_STATUS_CD  = 'A'                         
             ORDER BY [4D].EQUIP_SEQ, [4L].CNTRCT_START_DT DESC             
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE ACCT-CNTRCT-CUR CURSOR WITH HOLD FOR                
MFA-TR*      SELECT  4D.EQUIP_SEQ                                               
MFA-TR*             ,4D.EQUIP_TAG_NO                                            
MFA-TR*             ,4D.COMPANY_NO                                              
MFA-TR*             ,4D.CODE_SERVICE_TYPE                                       
MFA-TR*             ,4D.EQUIP_TYPE_CD                                           
MFA-TR*             ,4L.CNTRCT_START_DT                                         
MFA-TR*             ,4L.CNTRCT_END_DT                                           
MFA-TR*             ,4L.CNTRCT_DURATION_CD                                      
MFA-TR*             ,4L.FIXTURE_COST_AM                                         
MFA-TR*             ,4L.POLE_COST_AM                                            
MFA-TR*             ,4L.LAST_UPDATE_USERID                                      
MFA-TR*             ,4L.CNTRCT_STATUS_CD                                        
MFA-TR*             ,4L.ORIG_TERM_CHRG_AM                                       
MFA-TR*             ,4L.ACTL_TERM_CHRG_AM                                       
MFA-TR*             ,4L.ACTL_CHRG_DT                                            
MFA-TR*        FROM  LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*             ,LMS_EQUIP_CONTRACT 4L                                      
MFA-TR*       WHERE  4D.EQUIP_SEQ         =  4L.EQUIP_SEQ                       
MFA-TR*         AND  4D.EQUIP_TYPE_CD     = 'F'                                 
MFA-TR*         AND  4L.INSTALL_LOC_NO    = :CPDLM3-INSTALL-LOC-NO              
MFA-TR*         AND  4L.ACCOUNT_NO        = :CPDLM3-ACCOUNT-NO                  
MFA-TR*         AND  4L.CNTRCT_END_DT    >= :CPDLM3-INPUT-DATE                  
MFA-TR*         AND  4L.CNTRCT_STATUS_CD  = 'A'                                 
MFA-TR*      ORDER BY 4D.EQUIP_SEQ, 4L.CNTRCT_START_DT DESC                     
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            
