      *****************************************************************         
      *****************************************************************         
      ** CWSCB122.                                                   **         
      **     COMMON COPYBOOK FOR SCSCA122/MCSCB122.                  **         
      *****************************************************************         
      *---------------------------------------------------------------*         
      *  NOTE:                                                        *         
      *      WHEN MODIFYING THIS MEMBER, SCSCA122/MCSCB122 SHOULD BE  *         
      *      EVALUATED FOR CORRESPONDING MODIFICATIONS.               *         
      *---------------------------------------------------------------*         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  -------   --------     ------                              **         
      **  15/7/14   HA7A338      INITIAL PROGRAM VERSION             **         
      *****************************************************************         
      /                                                                         
       01  WS-FIODB07.                                                  
COB305     05 WS-FDB07-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.      
           05  WS-FDB07-PROCESS-CONTROL.                                
               10  WS-ON-OFF-CYCLE-IND          PIC X(1).               
                   88  WS-OFF-CYCLE-FINAL        VALUE 'B'.             
                   88  WS-OFF-CYCLE-REBILL       VALUE 'O'.             
                   88  WS-ON-CYCLE-BILL          VALUE 'A'.             
                   88  WS-APPLY-LPC-ONLY         VALUE 'L'.             
                   88  WS-OFF-CYCLE-ACCT-TRANS   VALUE 'T'.             
               10  WS-SINGLE-ITEM-BILL-IND      PIC X(1).               
                   88  WS-SINGLE-ITEM-BILL       VALUE 'S'.             
               10  WS-MASTER-ACCOUNT-IND        PIC X(1).               
                   88  WS-MASTER-ACCOUNT         VALUE 'M'.             
                   88  WS-ADDITIVE-MAST          VALUE 'A'.             
               10  WS-REFUND-CONTROL-IND        PIC X(1).               
                   88  WS-PROCESS-REFUND         VALUE 'R'.             
               10  WS-GUARANTEE-TRANSFER-IND    PIC X(1).               
                   88  WS-TRANSFER-GUARANTEE     VALUE 'E'.             
                   88  WS-TRANSFER-GUARANTOR     VALUE 'G'.             
           05  WS-FDB07-NO-BILL-CYCLES          PIC S9(4) COMP.         
           05  WS-FDB07-PYMT-PRIORITY-LVL       PIC S9(4) COMP.         
           05  WS-FDB07-ITEM-ID                 PIC S9(9) COMP.         
           05  WS-FDB07-CREDIT-LETTER-IND       PIC X(01).              
           05  WS-FDB07-BARCODE-UNIQUE-ID       PIC X(09).              
           05  WS-PROCESS-UNIQUE-ID-FL          PIC X(01) VALUE 'N'.    
               88 WS-PROCESS-UNIQUE-ID                    VALUE 'Y'.    
               88 WS-DO-NOT-PROCESS-UNIQUE-ID             VALUE 'N'.    
                                                                        
       01  WS-CALL-ENVIRONMENT                  PIC X(01).              
      /                                                                         
       01  WS-HOLD-WK03.                                                
COB305     03 WS-WK03-TOTAL-AR-BAL        PIC S9(9)V99 COMP-3 VALUE 0.        
           03  WS-WK03-COUNT                PIC S9(4) COMP.             
           03  WS-HOLD-WK03-DATA            PIC X(220)                  
                  OCCURS 5000 TIMES                                     
                  INDEXED BY WK03-INDX.                                 
                                                                        
       01  WS-WNA-REVENUE-SUMMARY-TABLE.                                
           05  WS-WNA-REV-SUM-ISSUE-DATE       PIC X(10).               
           05  WS-WNA-REVENUE-SUMMARY-RECORD                            
                  OCCURS 25 TIMES                                       
                  INDEXED BY WS-WNA-REV-SUM-INDX.                       
               10  WS-WNA-ACCOUNT-COUNT        PIC S9(09)       COMP.   
COB305         10 WS-TOTAL-WNA-RATE        PIC S9(11)V9(05) COMP-3 
COB305           VALUE 0. 
COB305         10 WS-TOTAL-WNA-REV        PIC S9(09)V99 COMP-3 VALUE 0. 
      /                                                                         
      /                                                                         
       01  SCSCA103-ACCUMULATORS.                                       
           05  WS-WEATHER-DATA.                                         
              10  WS-WFT-CNTRL              PIC 9(04) COMP.             
              10  WS-WEATHER-FACTOR-TABLE.                              
                  15  WS-WEATHER-FACTOR-TABLE-RECORD                    
                          OCCURS 100 TIMES                              
                          INDEXED BY WS-WFT-INDEX.                      
                      20  WS-REV-CLASS-WFT      PIC X(3).               
                      20  WS-CODE-UTIL-TYPE-WFT PIC X(1).               
COB305                20 WS-FACTOR-WFT        PIC S9(01)V9(04) COMP-3 
COB305                  VALUE 0. 
COB305                20 WS-ACCUM-USAGE-WFT        PIC S9(11) COMP-3 
COB305                  VALUE 0.      
           05  WS-OPT-READ-DATE-TABLE.                                  
              10  WS-OPT-READ-DATE-DATA OCCURS 30 TIMES                 
                          INDEXED BY WS-OPT-RD-DATE-INDX.               
                  15  WS-READ-CYCLE-OP        PIC X(02).                
                  15  WS-OPT-RD-DATE-OP       PIC X(10).                
                                                                        
       01  WS-LOCAL-AND-TOTAL-ACCUM-TABLE.                              
           05  WS-LOCAL-ACCUMULATORS-DATA                               
                  OCCURS 100 TIMES                                      
                  INDEXED BY WS-LO-INDX.                                
               10  WS-LO-ACCUM-COMPANY-NO       PIC X(2).               
               10  WS-LO-ACCUM-LOCAL-OFFICE     PIC 9(3).               
               10  WS-LOCAL-OFFICE-CONTROL.                             
                   15  WS-MISC-ENTRY-TYPES         PIC X(9)             
                          OCCURS 20 TIMES                               
                          INDEXED BY WS-MT-INDX.                        
                   15  WS-REV-CLS-CODE             PIC X(3)             
                          OCCURS 50 TIMES                               
                          INDEXED BY WS-RT-INDX.                        
               10  WS-LOCAL-OFFICE-ACCUM.                               
                   15  WS-SUMMARY-REVENUE.                              
COB305                 20 WS-UTIL-ELEC-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-UTIL-GAS-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-TAX-ELEC-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-TAX-GAS-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-FAC-ELEC-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-FAC-GAS-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-INT-ELEC-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-INT-GAS-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-CNT-ELEC-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-CNT-GAS-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
                   15  WS-SUMMARY-BY-SOURCE.                            
COB305                 20 WS-ENERGY-ELEC-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-ENERGY-GAS-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-DEMAND-ELEC-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-DEMAND-GAS-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-BFC-ELEC-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-BFC-GAS-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-SFC-ELEC-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-SFC-GAS-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-FUEL-COST-ELEC-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-FUEL-COST-GAS-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-WNA-DOLLARS-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
                       20  WS-MISC-ENTRY-ACCUM                          
                              OCCURS 20 TIMES                           
                              INDEXED BY WS-MA-INDX.                    
COB305                     25 WS-MISC-ELEC-ACCUM        PIC S9(9)V99 
COB305                       COMP-3 VALUE 0. 
COB305                     25 WS-MISC-GAS-ACCUM        PIC S9(9)V99 
COB305                       COMP-3 VALUE 0. 
COB305                 20 WS-STATE-TAX-ELEC-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-STATE-TAX-GAS-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-FRANCHISE-ELEC-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-FRANCHISE-GAS-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-INTEREST-ELEC-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-INTEREST-GAS-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-SRV-CNTR-ELEC-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-SRV-CNTR-GAS-ACCUM        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
                   15  WS-SUMMARY-BY-REV-CLS.                           
                       20  WS-REV-CLS-ACCUM                             
                              OCCURS 50 TIMES                           
                              INDEXED BY WS-RA-INDX.                    
COB305                     25 WS-REVC-ELEC-ACCUM        PIC S9(9)V99 
COB305                       COMP-3 VALUE 0. 
COB305                     25 WS-REVC-GAS-ACCUM        PIC S9(9)V99 
COB305                       COMP-3 VALUE 0. 
                   15  WS-SUMMARY-BY-AR-TYPE.                           
COB305                 20 WS-NSC-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-NSC-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-NSC-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-NSC-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-NSA-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-NSA-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-NSA-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-NSA-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-NSN-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-NSN-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-NSN-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-NSN-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-LPC-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-LPC-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-LPC-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-LPC-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-LPN-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-LPN-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-LPN-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-LPN-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-UTE-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-UTE-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-UTE-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-UTE-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-UTG-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-UTG-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-UTG-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-UTG-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-EPP-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-EPP-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-EPP-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-EPP-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-RCC-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-RCC-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-RCC-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-RCC-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
      * THIS IS FOR HAVING THE TOTAL OF BACKOUT TAX AMOUNT.                     
      * USED FOR CALCULATING ACTUAL TAX REVENUE.                                
COB305                 20 WS-BACKOUT-TAX-ACCUM-E        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-BACKOUT-TAX-ACCUM-G        PIC S9(9)V99 
COB305                   COMP-3 VALUE 0. 
COB305                 20 WS-DEP-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-DEP-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-DEP-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-DEP-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-DFA-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-DFA-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-DFA-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-DFA-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-CNT-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-CNT-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-CNT-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-CNT-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-PJS-NEW-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-PJS-CUR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-PJS-ARR-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
COB305                 20 WS-PJS-BAL-ACCUM        PIC S9(9)V99 COMP-3 
COB305                   VALUE 0. 
      /                                                                         
           EXEC SQL                                                     
              DECLARE TAX-DATA CURSOR FOR                               
                 SELECT TC.TAX_TYPE,                                    
                        TR.DETAIL_ID,                                   
                        TR.DATE_FROM,                                   
                        TR.DATE_TO,                                     
                        TR.TAX_RATE,                                    
                        TU.CODE_TAX_CALC_INST,                          
                        TU.TAX_ELEC,                                    
                        TU.TAX_GAS,                                     
                        TU.TAX_MDSE,                                    
                        TU.TAX_WATER,                                   
                        TU.TAX_SEWER,                                   
                        TU.TAX_TRASH,                                   
                        TC.TAX_CNTRL_NO,                                
                        TC.FACTOR_ID                                    
                       ,TC.CODE_APPL_COND                               
                   FROM CSS_TAX_CNTL TC WITH(READUNCOMMITTED),                  
                        CSS_TAX_RATE TR WITH(READUNCOMMITTED),                  
                        CSS_TAX_USE_CNTL TU WITH(READUNCOMMITTED)               
                   WHERE CIS.SUBSTR3(TR.OPER_MODE,1,1) = 'A'                 
                     AND TR.DATE_FROM IS NOT NULL                       
                     AND TR.OPER_MODE = TC.OPER_MODE                    
                     AND TR.TAX_CNTRL_NO = TC.TAX_CNTRL_NO              
                     AND TR.TAX_ENTRY_SEQ_NO = TU.TAX_ENTRY_SEQ_NO      
                     AND TU.OPER_MODE = TC.OPER_MODE                    
                     AND TU.TAX_CNTRL_NO = TC.TAX_CNTRL_NO              
                     AND TU.DETAIL_ID = TR.DETAIL_ID                    
                   ORDER BY TC.TAX_TYPE,                                
                            TR.DETAIL_ID,                               
                            TC.TAX_CNTRL_NO,                            
                            TR.DATE_FROM DESC                           
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TAX-DATA CURSOR FOR                                       
MFA-TR*          SELECT TC.TAX_TYPE,                                            
MFA-TR*                 TR.DETAIL_ID,                                           
MFA-TR*                 TR.DATE_FROM,                                           
MFA-TR*                 TR.DATE_TO,                                             
MFA-TR*                 TR.TAX_RATE,                                            
MFA-TR*                 TU.CODE_TAX_CALC_INST,                                  
MFA-TR*                 TU.TAX_ELEC,                                            
MFA-TR*                 TU.TAX_GAS,                                             
MFA-TR*                 TU.TAX_MDSE,                                            
MFA-TR*                 TU.TAX_WATER,                                           
MFA-TR*                 TU.TAX_SEWER,                                           
MFA-TR*                 TU.TAX_TRASH,                                           
MFA-TR*                 TC.TAX_CNTRL_NO,                                        
MFA-TR*                 TC.FACTOR_ID                                            
MFA-TR*                ,TC.CODE_APPL_COND                                       
MFA-TR*            FROM CSS_TAX_CNTL TC,                                        
MFA-TR*                 CSS_TAX_RATE TR,                                        
MFA-TR*                 CSS_TAX_USE_CNTL TU                                     
MFA-TR*            WHERE SUBSTR(TR.OPER_MODE,1,1) = 'A'                         
MFA-TR*              AND TR.DATE_FROM IS NOT NULL                               
MFA-TR*              AND TR.OPER_MODE = TC.OPER_MODE                            
MFA-TR*              AND TR.TAX_CNTRL_NO = TC.TAX_CNTRL_NO                      
MFA-TR*              AND TR.TAX_ENTRY_SEQ_NO = TU.TAX_ENTRY_SEQ_NO              
MFA-TR*              AND TU.OPER_MODE = TC.OPER_MODE                            
MFA-TR*              AND TU.TAX_CNTRL_NO = TC.TAX_CNTRL_NO                      
MFA-TR*              AND TU.DETAIL_ID = TR.DETAIL_ID                            
MFA-TR*            ORDER BY TC.TAX_TYPE,                                        
MFA-TR*                     TR.DETAIL_ID,                                       
MFA-TR*                     TC.TAX_CNTRL_NO,                                    
MFA-TR*                     TR.DATE_FROM DESC                                   
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                     
              DECLARE TAX-EXCISE-DATA CURSOR FOR                        
                 SELECT BLOCK_NO,                                       
                        BLOCK_UNITS,                                    
                        DATE_FROM,                                      
                        TAX_CNTRL_NO,                                   
                        EXCISE_TAX_UNIT_AM                              
                    FROM CSS_TAX_EXCISE_AMT WITH(READUNCOMMITTED)               
                       ORDER BY TAX_CNTRL_NO ,                          
                                DATE_FROM DESC,                         
                                BLOCK_NO                                
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TAX-EXCISE-DATA CURSOR FOR                                
MFA-TR*          SELECT BLOCK_NO,                                               
MFA-TR*                 BLOCK_UNITS,                                            
MFA-TR*                 DATE_FROM,                                              
MFA-TR*                 TAX_CNTRL_NO,                                           
MFA-TR*                 EXCISE_TAX_UNIT_AM                                      
MFA-TR*             FROM CSS_TAX_EXCISE_AMT                                     
MFA-TR*                ORDER BY TAX_CNTRL_NO ,                                  
MFA-TR*                         DATE_FROM DESC,                                 
MFA-TR*                         BLOCK_NO                                        
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
      ***------  GET LIST OF TAX EXEMPT RATES                                   
           EXEC SQL                                                     
              DECLARE EXMT_RATES CURSOR FOR                             
               SELECT G6.PARM_DATA                                      
                 FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
                WHERE PROGRAM_NAME    = :G6-PROGRAM-NAME                
                  AND CMND_CODE       = :G6-CMND-CODE                   
                  AND STATUS          = :G6-STATUS                      
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EXMT_RATES CURSOR FOR                                     
MFA-TR*        SELECT G6.PARM_DATA                                              
MFA-TR*          FROM CSS_JOB_PARM G6                                           
MFA-TR*         WHERE PROGRAM_NAME    = :G6-PROGRAM-NAME                        
MFA-TR*           AND CMND_CODE       = :G6-CMND-CODE                           
MFA-TR*           AND STATUS          = :G6-STATUS                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
