      *****************************************************************         
      **   CWSCA299                                                  **         
      **     ==> P00251 - NET METERING.                              **         
      *****************************************************************         
      *****************************************************************         
      **  COPYBOOK FOR WORKING STORAGE FIELDS NEEDED FOR CPDCA299.   **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION LOG                      **         
      **              --------------------------                     **         
      **    DATE     INITIALS  REASON                                **         
      **   --------  --------  ------                                **         
      **   04/15/10  SS97726   INITIAL VERSION.                      **         
P01175**   08/23/16  P01175    TO PRINT NET ENERGY CONSUMED BY USER  **         
      *****************************************************************         
                                                                        
       01  CWS299-INPUT-AREA.                                           
      ****TO BE PASSED BY CALLING PROGRAM.                                      
COB305     05 CWS299-IN-ACCT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.    
COB305     05 CWS299-IN-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.    
           05  CWS299-IN-COMMON-DT         PIC X(10).                   
           05  CWS299-IN-APPL-PGM-ID       PIC X(08).                   
ID1959     05  CWS299-IN-OFF-CYC-BILL-CD   PIC X(01).                   
COB305     05 CWS299-IN-REV-MTH-LST-NRML        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.    
      ****TO BE RETREIVED WITHIN THE COPYBOOK CPDCA299.                         
           05  CWS299-IN-CODE-UTIL-TYPE    PIC X(01).                   
           05  CWS299-IN-RATE-PLAN         PIC X(03).                   
           05  CWS299-IN-IC-NO             PIC S9(4) USAGE COMP.        
           05  CWS299-IN-BILL-NO           PIC S9(9) USAGE COMP.        
           05  CWS299-IN-BILL-ITM-TIMESTMP PIC X(26).                   
COB305     05 CWS299-IN-REV-MTH-N2        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.    
                                                                        
       01  CWS299-LITERALS.                                             
           05  CWS299-SYSTEM               PIC X(06) VALUE 'SYSTEM'.    
           05  WS-BASIC-SERVICE            PIC X(01) VALUE 'A'.         
           05  WS-CO-GENERATION            PIC X(01) VALUE 'F'.         
           05  WS-ON-OFF-PEAK              PIC X(01) VALUE '2'.         
           05  WS-ON-OFF-SHLDR-PEAK        PIC X(01) VALUE '3'.         
           05  WS-BASIC-METER              PIC X(01) VALUE 'B'.         
           05  WS-APPLY-TO-LESR-TOU        PIC X(01) VALUE 'L'.         
           05  CWS299-CATG-ID-17           PIC S9(4) COMP VALUE +17.    
           05  CWS299-CATG-ID-138          PIC S9(4) COMP VALUE +138.   
           05  CWS299-NON-TOU              PIC S9(4) COMP VALUE +0.     
           05  CWS299-ON-PEAK              PIC S9(4) COMP VALUE +1.     
           05  CWS299-OFF-PEAK             PIC S9(4) COMP VALUE +2.     
           05  CWS299-SHOULDER             PIC S9(4) COMP VALUE +3.     
           05  CWS299-EXCLUDE              PIC X(01) VALUE 'X'.         
ID1959     05  CWS299-CR-FCTR-FACTOR-ID    PIC X(09) VALUE 'NMEXCSCR'.  
           05  CWS299-REVMTH-WQ-MSG        PIC X(50) VALUE              
               'Missing Revenue Month. Verify Cancel Rebill Months'.    
ID1959     05  CWS299-PRICE-WQ-MSG         PIC X(35) VALUE              
ID1959         'PR1 Price is either not found or 0 '.                   
                                                                        
       01  CWS299-WORK-AREA.                                            
           05  CWS299-NON-TOU-CALC-VARS.                                
COB305         10 CWS299-NON-TOU-EP        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-NON-TOU-DL        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-NON-TOU-RV        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-NON-TOU-EC        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-NON-TOU-BI        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-NON-TOU-EU        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
               10  CWS299-NON-TOU-RDDT     PIC X(10).                   
                                                                        
           05  CWS299-ON-PEAK-CALC-VARS.                                
COB305         10 CWS299-ON-PEAK-EP        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-ON-PEAK-DL        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-ON-PEAK-RV        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-ON-PEAK-EC        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-ON-PEAK-BI        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-ON-PEAK-EU        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-ON-PEAK-T12        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
               10 CWS299-ON-PEAK-T12-SEQ   PIC S9(4) USAGE COMP.        
COB305         10 CWS299-ON-PEAK-T13        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
               10 CWS299-ON-PEAK-T13-SEQ   PIC S9(4) USAGE COMP.        
               10 CWS299-ON-PEAK-RDDT      PIC X(10).                   
                                                                        
           05  CWS299-OFF-PEAK-CALC-VARS.                               
COB305         10 CWS299-OFF-PEAK-EP        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-OFF-PEAK-DL        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-OFF-PEAK-RV        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-OFF-PEAK-EC        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-OFF-PEAK-EU        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-OFF-PEAK-BI        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-OFF-PEAK-F21        PIC S9(9)V9(1) 
COB305           USAGE COMP-3 VALUE 0. 
               10  CWS299-OFF-PEAK-F21-SEQ PIC S9(4) USAGE COMP.        
COB305         10 CWS299-OFF-PEAK-F23        PIC S9(9)V9(1) 
COB305           USAGE COMP-3 VALUE 0. 
               10  CWS299-OFF-PEAK-F23-SEQ PIC S9(4) USAGE COMP.        
               10  CWS299-OFF-PEAK-RDDT    PIC X(10).                   
                                                                        
           05  CWS299-SHLDR-CALC-VARS.                                  
COB305         10 CWS299-SHLDR-EP        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-SHLDR-DL        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-SHLDR-RV        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-SHLDR-EC        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-SHLDR-EU        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-SHLDR-BI        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
COB305         10 CWS299-SHLDR-T32        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
               10  CWS299-SHLDR-T32-SEQ    PIC S9(4) USAGE COMP.        
COB305         10 CWS299-SHLDR-F31        PIC S9(9)V9(1) USAGE COMP-3 
COB305           VALUE 0. 
               10  CWS299-SHLDR-F31-SEQ    PIC S9(4) USAGE COMP.        
               10  CWS299-SHLDR-RDDT       PIC X(10).                   
                                                                        
       01  CWS299-SWITCHES.                                             
      *****************************************************************         
      *    EP - Excess Previous Bill                                  *         
      *    DL - KWH Consumed                                          *         
      *    RV - KWH Generated.                                        *         
      *    12 - Excess To Off-Peak From On-Peak.                      *         
      *    21 - Excess From On-Peak To Off-Peak.                      *         
      *    32 - Excess to Off-Peak from Shoulder.                     *         
      *    13 - Excess To Shoulder From On-Peak.                      *         
      *    23 - Excess From Shoulder To Off-Peak.                     *         
      *    31 - Excess From On-Peak To Shoulder.                      *         
      *    EC - Excess Current Bill.                                  *         
      *    BI - Net Billed.                                           *         
      *****************************************************************         
           05  CWS299-VOL-TYPE-CD          PIC X(02)  VALUE SPACES.     
               88  CWS299-VOL-TYPE-EP                 VALUE 'EP'.       
               88  CWS299-VOL-TYPE-DL                 VALUE 'DL'.       
               88  CWS299-VOL-TYPE-RV                 VALUE 'RV'.       
               88  CWS299-VOL-TYPE-EC                 VALUE 'EC'.       
P01175         88  CWS299-VOL-TYPE-EU                 VALUE 'EU'.       
               88  CWS299-VOL-TYPE-BI                 VALUE 'BI'.       
               88  CWS299-VOL-TYPE-T12                VALUE '12'.       
               88  CWS299-VOL-TYPE-T32                VALUE '32'.       
               88  CWS299-VOL-TYPE-T13                VALUE '13'.       
               88  CWS299-VOL-TYPE-F21                VALUE '21'.       
               88  CWS299-VOL-TYPE-F23                VALUE '23'.       
               88  CWS299-VOL-TYPE-F31                VALUE '31'.       
           05  CWS299-ND-TIME-PERIOD       PIC S9(4)  COMP VALUE +0.    
               88  CWS299-NON-TOU-ND                  VALUE +0.         
               88  CWS299-ON-PEAK-ND                  VALUE +1.         
               88  CWS299-OFF-PEAK-ND                 VALUE +2.         
               88  CWS299-SHOULDER-ND                 VALUE +3.         
           05  CWS299-CALL-SWITCH           PIC X(01) VALUE 'Y'.        
               88  CWS299-FIRST-CALL                  VALUE 'Y'.        
               88  CWS299-NOT-FIRST-CALL              VALUE 'N'.        
           05  CWS299-BG-ROWS-SWITCH        PIC X(01) VALUE 'N'.        
               88  CWS299-NO-MORE-BG-ROWS             VALUE 'Y'.        
           05  CWS299-PROCESS-FIRST-BG      PIC X(01) VALUE 'N'.        
               88  CWS299-FIRST-BG                    VALUE 'Y'.        
               88  CWS299-NOT-FIRST-BG                VALUE 'N'.        
           05  CWS299-RATE-PLAN-VERS        PIC X(01) VALUE 'C'.        
               88  CWS299-CURR-RATE-PLAN              VALUE 'C'.        
               88  CWS299-PREV-RATE-PLAN              VALUE 'P'.        
           05  CWS299-RATE-PLAN-TYPE        PIC X(01) VALUE 'N'.        
               88  CWS299-NOT-NM-RATE                 VALUE 'N'.        
               88  CWS299-NM-RATE                     VALUE 'Y'.        
           05  CWS299-VOL-ALLOCATED         PIC X(01) VALUE 'N'.        
               88  VOL-ALLOCATED                      VALUE 'Y'.        
           05  CWS299-MISSING-MNTHS         PIC X(01) VALUE 'N'.        
               88  MISSING-MNTHS-FOUND                VALUE 'Y'.        
               88  MISSING-MNTHS-NOT-FOUND            VALUE 'N'.        
                                                                        
       01  CWS299-TEMP-VARIABLES.                                       
           05  CWS299-HOLD-RATE-PLAN        PIC X(03).                  
           05  CWS299-HOLD-CODE-UTIL-TYPE   PIC X(01).                  
           05  CWS299-REG-TYPE-CD           PIC X(01).                  
ID1959***  05  CWS299-BAL-RESET-MMDD        PIC 9(4)  VALUE ZEROES.             
ID1959     05  CWS299-BAL-RESET-MMDD.                                   
ID1959         10  CWS299-BAL-RESET-MM      PIC 9(02).                  
ID1959         10  CWS299-BAL-RESET-DD      PIC 9(02).                  
           05  CWS299-BAL-OFFSET-TOU        PIC X(01).                  
           05  CWS299-ENERGY-UNIT-CD        PIC X(01).                  
ID1959     05  CWS299-BAL-FWD-CD            PIC X(01).                  
COB305     05 CWS299-HOLD-REV-MONTH        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.    
           05  CWS299-TEMP-REV-MONTH        PIC 9(6)  VALUE ZEROES.     
           05  CWS299-HOLD-REV-MTH-RED.                                 
               10  CWS299-HOLD-REV-MTH-YR   PIC 9(04).                  
               10  CWS299-HOLD-REV-MTH-MM   PIC 9(02).                  
           05  CWS299-CMP-BAL-FWD-RESET.                                
               10  CWS299-CMP-BAL-RST-MM    PIC 9(02).                  
               10  CWS299-CMP-BAL-RST-DD    PIC 9(02).                  
           05  CWS299-RESULT-MNTHS          PIC S9(04) USAGE COMP.      
           05  CWS299-DATE-A.                                           
               10  CWS299-DT-A-YYYY         PIC X(04) VALUE SPACES.     
               10  CWS299-DT-A-F1           PIC X(01) VALUE '-'.        
               10  CWS299-DT-A-MM           PIC X(02) VALUE SPACES.     
               10  CWS299-DT-A-F2           PIC X(01) VALUE '-'.        
               10  CWS299-DT-A-DD           PIC X(02) VALUE SPACES.     
           05  CWS299-DATE-CALC-A           PIC X(10) VALUE SPACES.     
           05  CWS299-DATE-CALC-B           PIC X(10) VALUE SPACES.     
           05  CWS299-NON-TOU-CX-DL         PIC X(01) VALUE SPACES.     
           05  CWS299-NON-TOU-CX-RV         PIC X(01) VALUE SPACES.     
           05  CWS299-ON-PEAK-CX-DL         PIC X(01) VALUE SPACES.     
           05  CWS299-OFF-PEAK-CX-DL        PIC X(01) VALUE SPACES.     
           05  CWS299-SHOULDER-CX-DL        PIC X(01) VALUE SPACES.     
           05  CWS299-ON-PEAK-CX-RV         PIC X(01) VALUE SPACES.     
           05  CWS299-OFF-PEAK-CX-RV        PIC X(01) VALUE SPACES.     
           05  CWS299-SHOULDER-CX-RV        PIC X(01) VALUE SPACES.     
           05  CWS299-CX-NOT-FOUND          PIC X(01) VALUE SPACES.     
COB305     05 CWS299-XFER-UNITS        PIC S9(9) USAGE COMP-3 VALUE 0.     
COB305     05 CWS299-TEMP-UNITS        PIC S9(9) USAGE COMP-3 VALUE 0.     
COB305     05 CWS299-XFER-TO-UNITS        PIC S9(9) USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 CWS299-XFER-FROM-UNITS        PIC S9(9) USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 CWS299-HOLD-ND-NO-UNITS        PIC S9(9) USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 CWS299-UNITS        PIC S9(9) USAGE COMP-3 VALUE 0.     
COB305     05 CWS299-HOLD-TIME-PERIOD        PIC S9(4) USAGE COMP-3 
COB305       VALUE 0.     
           05  CWS299-HOLD-SEQ-NO           PIC S9(4) USAGE COMP.       
           05  CWS299-HOLD-DATE-READ        PIC X(10) VALUE SPACES.     
ID1959     05  CWS299-NEM-2-VAR.                                        
ID1959         10 CWS299-N2-REG-TYPE-CD     PIC X(01) VALUE SPACES.     
ID1959         10 CWS299-N2-CMP-BAL-FWD-RES PIC 9(04) VALUE 0.          
ID1959         10 CWS299-N2-BAL-RESET-MMDD  PIC 9(04) VALUE 0.          
ID1959         10 CWS299-N2-BAL-OFFSET-TOU  PIC X(01) VALUE SPACES.     
ID1959         10 CWS299-N2-ENERGY-UNIT-CD  PIC X(01) VALUE SPACES.     
ID1959         10 CWS299-N2-BAL-FWD-CD      PIC X(01) VALUE SPACES.     
COB305         10 CWS299-N2-FAC-CHRG-BASE        PIC S9(7)V9(2) 
COB305           USAGE COMP-3 VALUE 0.
                                                                        
       01  CWS299-HOLD-AREA.                                            
COB305     05 CWS299-NON-TOU-PREV-EC        PIC S9(9)V9(1) USAGE COMP-3 
COB305       VALUE 0.
COB305     05 CWS299-ON-PEAK-PREV-EC        PIC S9(9)V9(1) USAGE COMP-3 
COB305       VALUE 0.
COB305     05 CWS299-OFF-PEAK-PREV-EC        PIC S9(9)V9(1) 
COB305       USAGE COMP-3 VALUE 0.
COB305     05 CWS299-SHLDR-PREV-EC        PIC S9(9)V9(1) USAGE COMP-3 
COB305       VALUE 0.
      *WORKING STORAGE TABLE TO STORE ALL NET METERING RATE PLAN DETAILS        
           05  CWS299-NET-MTR-RATE-LOOKUP.                              
               07  CWS299-NET-MTR-RATE-TABLE                            
                                   OCCURS 200 TIMES                     
                                   INDEXED BY CWS299-RT-INDX.           
                   10  CWS299-NM-RATE-PLAN        PIC X(03).            
                   10  CWS299-NM-CMPNT-ID         PIC X(02).            
                   10  CWS299-NM-CD-UTL-TYPE      PIC X(01).            
                   10  CWS299-NM-REG-TYPE-CD      PIC X(01).            
                   10  CWS299-NM-BAL-RESET-MMDD   PIC 9(4).             
                   10  CWS299-NM-BAL-OFFSET-TOU   PIC X(01).            
                   10  CWS299-NM-ENERGY-UNIT-CD   PIC X(01).            
ID1959             10  CWS299-NM-BAL-FWD-CD       PIC X(01).            
ID1959     05  CWS299-CR-FCTR-CMPNT-ID PIC X(02) VALUE SPACES.          
ID1959     05  CWS299-CR-FCTR-POWER-10 PIC S9(4) USAGE COMP VALUE 0.    
ID1959     05  CWS299-CR-FCTR-DECIMAL  PIC S9(4) USAGE COMP VALUE 0.    
ID1959     05  CWS299-CR-FCTR-DR-CR    PIC X(01) VALUE SPACES.          
ID1959     05  CWS299-CR-FCTR-PRO-FL   PIC X(01) VALUE SPACES.          
ID1959     05  CWS299-CR-FCTR-STAT-XMT PIC X(01) VALUE SPACES.          
ID1959     05  CWS299-CR-FCTR-CITY-XMT PIC X(01) VALUE SPACES.          
ID1959     05  CWS299-CR-FCTR-OTHR-XMT PIC X(01) VALUE SPACES.          
                                                                        
       01  CWS299-ERROR-DATA.                                           
           05  CWS299-ERROR-TYPE           PIC X(01) VALUE ' '.         
               88  CWS299-NO-ERROR                   VALUE ' '.         
               88  CWS299-DB2-ERROR                  VALUE 'D'.         
               88  CWS299-NON-DB2-ERROR              VALUE 'N'.         
           05  CWS299-ERROR-MESSAGE        PIC X(72).                   
           05  CWS299-ERROR-SQLCODE        PIC S9(9) COMP.              
           05  CWS299-ERROR-FUNCTION       PIC X(08).                   
           05  CWS299-ERROR-PARAGRAPH-NO   PIC X(04).                   
           05  CWS299-ERROR-PARAGRAPH-NAME PIC X(32).                   
           05  CWS299-ERROR-TABLE1         PIC X(20).                   
           05  CWS299-ERROR-TABLE2         PIC X(20).                   
           05  CWS299-ERROR-TAB-COLUMN-1   PIC X(20).                   
           05  CWS299-ERROR-TAB-COLUMN-2   PIC X(20).                   
           05  CWS299-ERROR-TAB-COLUMN-3   PIC X(20).                   
           05  CWS299-ERROR-TAB-COLUMN-4   PIC X(20).                   
           05  CWS299-ERROR-HOSTVAR-1      PIC X(20).                   
           05  CWS299-ERROR-HOSTVAR-2      PIC X(20).                   
           05  CWS299-ERROR-HOSTVAR-3      PIC X(20).                   
           05  CWS299-ERROR-HOSTVAR-4      PIC X(20).                   
                                                                        
      *****************************************************************         
      *    CURSOR TO GET ALL THE NET METERING RATES                   *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
             DECLARE NET_MTR_RATE CURSOR FOR                            
                SELECT J1.RATE_PLAN_NO                                  
                      ,J1.CMPNT_ID_CD                                   
                      ,J1.CODE_UTIL_TYPE                                
                      ,J1.REG_TYPE_CD                                   
                      ,J1.BAL_RESET_MMDD                                
                      ,J1.BAL_OFFSET_TOU_CD                             
                      ,J1.ENERGY_UNIT_CD                                
ID1959                ,J1.BAL_FWD_CD                                    
                  FROM CSS_RATE_CREATOR  RT WITH(READUNCOMMITTED)               
                      ,CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)               
                 WHERE RT.CODE_STATUS      = 'A'                        
                   AND RT.CODE_UTIL_TYPE   = J1.CODE_UTIL_TYPE          
                   AND RT.RATE_PLAN_NO     = J1.RATE_PLAN_NO            
                   AND RT.VERSION_NO_CNTRL =                            
                           (SELECT MAX(RZ.VERSION_NO_CNTRL)             
                              FROM CSS_RATE_CREATOR RZ
                           WITH(READUNCOMMITTED)                  
                             WHERE RZ.CODE_STATUS    = 'A'              
                               AND RZ.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE
                               AND RZ.RATE_PLAN_NO   = RT.RATE_PLAN_NO) 
                   AND RT.VERSION_NO_CNTRL = J1.VERSION_NO_CNTRL        
                   AND J1.BAL_FWD_CD       > ' '                        
                 ORDER BY RT.RATE_PLAN_NO                               
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE NET_MTR_RATE CURSOR FOR                                    
MFA-TR*         SELECT J1.RATE_PLAN_NO                                          
MFA-TR*               ,J1.CMPNT_ID_CD                                           
MFA-TR*               ,J1.CODE_UTIL_TYPE                                        
MFA-TR*               ,J1.REG_TYPE_CD                                           
MFA-TR*               ,J1.BAL_RESET_MMDD                                        
MFA-TR*               ,J1.BAL_OFFSET_TOU_CD                                     
MFA-TR*               ,J1.ENERGY_UNIT_CD                                        
MFA-TR*               ,J1.BAL_FWD_CD                                            
MFA-TR*           FROM CSS_RATE_CREATOR  RT                                     
MFA-TR*               ,CSS_RATE_COMP_DEF J1                                     
MFA-TR*          WHERE RT.CODE_STATUS      = 'A'                                
MFA-TR*            AND RT.CODE_UTIL_TYPE   = J1.CODE_UTIL_TYPE                  
MFA-TR*            AND RT.RATE_PLAN_NO     = J1.RATE_PLAN_NO                    
MFA-TR*            AND RT.VERSION_NO_CNTRL =                                    
MFA-TR*                    (SELECT MAX(RZ.VERSION_NO_CNTRL)                     
MFA-TR*                       FROM CSS_RATE_CREATOR RZ                          
MFA-TR*                      WHERE RZ.CODE_STATUS    = 'A'                      
MFA-TR*                        AND RZ.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE        
MFA-TR*                        AND RZ.RATE_PLAN_NO   = RT.RATE_PLAN_NO)         
MFA-TR*            AND RT.VERSION_NO_CNTRL = J1.VERSION_NO_CNTRL                
MFA-TR*            AND J1.BAL_FWD_CD       > ' '                                
MFA-TR*          ORDER BY RT.RATE_PLAN_NO                                       
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CURSOR TO GET ALL READY TO BILL NET METERING ACCOUNTS      *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
             DECLARE NET_MTR_ACCTS CURSOR FOR                           
                SELECT AT.ACCOUNT_NO                                    
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                      ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                 WHERE AT.CODE_ACCT_STAT  IN ('A','B')                  
                   AND AT.CODE_ACCT_BILLED = 'R'                        
                   AND AT.ACCOUNT_NO       = UT.ACCOUNT_NO              
                   AND UT.RATE_PLAN_NO    IN                            
                      (SELECT J1.RATE_PLAN_NO                           
                         FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)         
                             ,CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)        
                        WHERE RT.CODE_STATUS      = 'A'                 
                          AND RT.CODE_UTIL_TYPE   = J1.CODE_UTIL_TYPE   
                          AND RT.RATE_PLAN_NO     = J1.RATE_PLAN_NO     
                          AND RT.VERSION_NO_CNTRL =                     
                           (SELECT MAX(RZ.VERSION_NO_CNTRL)             
                              FROM CSS_RATE_CREATOR RZ
                           WITH(READUNCOMMITTED)                  
                             WHERE RZ.CODE_STATUS    = 'A'              
                               AND RZ.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE
                               AND RZ.RATE_PLAN_NO   = RT.RATE_PLAN_NO) 
                          AND RT.VERSION_NO_CNTRL = J1.VERSION_NO_CNTRL 
                          AND J1.BAL_FWD_CD       > ' ')                
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE NET_MTR_ACCTS CURSOR FOR                                   
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                                      
MFA-TR*          WHERE AT.CODE_ACCT_STAT  IN ('A','B')                          
MFA-TR*            AND AT.CODE_ACCT_BILLED = 'R'                                
MFA-TR*            AND AT.ACCOUNT_NO       = UT.ACCOUNT_NO                      
MFA-TR*            AND UT.RATE_PLAN_NO    IN                                    
MFA-TR*               (SELECT J1.RATE_PLAN_NO                                   
MFA-TR*                  FROM CSS_RATE_CREATOR RT                               
MFA-TR*                      ,CSS_RATE_COMP_DEF J1                              
MFA-TR*                 WHERE RT.CODE_STATUS      = 'A'                         
MFA-TR*                   AND RT.CODE_UTIL_TYPE   = J1.CODE_UTIL_TYPE           
MFA-TR*                   AND RT.RATE_PLAN_NO     = J1.RATE_PLAN_NO             
MFA-TR*                   AND RT.VERSION_NO_CNTRL =                             
MFA-TR*                    (SELECT MAX(RZ.VERSION_NO_CNTRL)                     
MFA-TR*                       FROM CSS_RATE_CREATOR RZ                          
MFA-TR*                      WHERE RZ.CODE_STATUS    = 'A'                      
MFA-TR*                        AND RZ.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE        
MFA-TR*                        AND RZ.RATE_PLAN_NO   = RT.RATE_PLAN_NO)         
MFA-TR*                   AND RT.VERSION_NO_CNTRL = J1.VERSION_NO_CNTRL         
MFA-TR*                   AND J1.BAL_FWD_CD       > ' ')                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CURSOR TO GET ALL THE UNBILLED BILLING DETAILS             *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
             DECLARE BILLING_DET CURSOR FOR                             
                SELECT BG.ACCOUNT_NO                                    
                      ,BG.BILL_NO                                       
                      ,BG.CODE_UTIL_TYPE                                
                      ,BG.IC_NO                                         
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                            
                      ,BG.RATE_PLAN_NO                                  
                      ,BG.REV_MTH_ORIG_BILL                             
                      ,BG.REVENUE_MONTH                                 
ID1959                ,BG.CODE_REVENUE_CLASS                            
                  FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                 
                      ,CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
                 WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO           
                   AND BI.DATE_BILLED       IS NULL                     
                   AND BG.ACCOUNT_NO         = BI.ACCOUNT_NO            
                   AND BG.BILL_NO            = BI.BILL_NO               
                   AND BG.CODE_UTIL_TYPE     = 'E'                      
                   AND BG.CODE_BILL_CALC     = 'A'                      
                   AND BG.CODE_BILL_ITM_TYPE = 'C'                      
                   AND BG.CODE_BILL_ITM_IND  = 'A'                      
                 ORDER BY BI.BILL_NO, BG.DATE_ORIG_BILL                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BILLING_DET CURSOR FOR                                     
MFA-TR*         SELECT BG.ACCOUNT_NO                                            
MFA-TR*               ,BG.BILL_NO                                               
MFA-TR*               ,BG.CODE_UTIL_TYPE                                        
MFA-TR*               ,BG.IC_NO                                                 
MFA-TR*               ,BG.BILL_ITEM_TIMESTMP                                    
MFA-TR*               ,BG.RATE_PLAN_NO                                          
MFA-TR*               ,BG.REV_MTH_ORIG_BILL                                     
MFA-TR*               ,BG.REVENUE_MONTH                                         
MFA-TR*               ,BG.CODE_REVENUE_CLASS                                    
MFA-TR*           FROM CSS_BILLING_HDR BI                                       
MFA-TR*               ,CSS_BILLING_DET BG                                       
MFA-TR*          WHERE BI.ACCOUNT_NO         = :BI-ACCOUNT-NO                   
MFA-TR*            AND BI.DATE_BILLED       IS NULL                             
MFA-TR*            AND BG.ACCOUNT_NO         = BI.ACCOUNT_NO                    
MFA-TR*            AND BG.BILL_NO            = BI.BILL_NO                       
MFA-TR*            AND BG.CODE_UTIL_TYPE     = 'E'                              
MFA-TR*            AND BG.CODE_BILL_CALC     = 'A'                              
MFA-TR*            AND BG.CODE_BILL_ITM_TYPE = 'C'                              
MFA-TR*            AND BG.CODE_BILL_ITM_IND  = 'A'                              
MFA-TR*          ORDER BY BI.BILL_NO, BG.DATE_ORIG_BILL                         
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CURSOR TO GET CX FOR ALL TIME PERIODS TO CREATE DL, RV     *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
             DECLARE CNSMPTN_HIST CURSOR FOR                            
                SELECT CX.NO_UNITS                                      
                      ,CX.DATE_READ                                     
                      ,CX.CODE_USAGE_ID                                 
                      ,CX.CODE_TIME_PERIOD                              
                      ,CX.CODE_DEBIT_CREDIT                             
                  FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                
                 WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO           
                   AND CX.BILL_NO            = :CX-BILL-NO              
                   AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE       
                   AND CX.IC_NO              = :CX-IC-NO                
                   AND CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )   
                   AND CX.CODE_USAGE_TYPE    = 'B'                      
                   AND CX.CODE_ITEM_STATUS   = 'A'                      
                   AND CX.CODE_USAGE_ID     IN ('A','F')                
                 ORDER BY CX.DATE_READ DESC                             
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CNSMPTN_HIST CURSOR FOR                                    
MFA-TR*         SELECT CX.NO_UNITS                                              
MFA-TR*               ,CX.DATE_READ                                             
MFA-TR*               ,CX.CODE_USAGE_ID                                         
MFA-TR*               ,CX.CODE_TIME_PERIOD                                      
MFA-TR*               ,CX.CODE_DEBIT_CREDIT                                     
MFA-TR*           FROM CSS_CNSMPTN_HIST CX                                      
MFA-TR*          WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO                   
MFA-TR*            AND CX.BILL_NO            = :CX-BILL-NO                      
MFA-TR*            AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE               
MFA-TR*            AND CX.IC_NO              = :CX-IC-NO                        
MFA-TR*            AND CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP           
MFA-TR*            AND CX.CODE_USAGE_TYPE    = 'B'                              
MFA-TR*            AND CX.CODE_ITEM_STATUS   = 'A'                              
MFA-TR*            AND CX.CODE_USAGE_ID     IN ('A','F')                        
MFA-TR*          ORDER BY CX.DATE_READ DESC                                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
