      ******************************************************************        
      * CPDCA167                                                       *        
      *                                                                *        
      * This copybook has the common routines used between SCSCA167 and*        
      * PCSCA293. The information required will be parm to know if this*        
      * was called from SCSCA167 or PCSCA293.                          *        
      * ****************************************************************        
      * PREREQUISITES: THE INPUT VARIABLES SHOULD BE POPULATED         *        
      *                PRIOR TO INVOKING THIS ROUTINE.                 *        
      ******************************************************************        
      * INPUT  : AT-ACCOUNT-NO                                         *        
      *          AR-DATE-TRANS                                         *        
      * OUTPUT : RETURNS TRANSCATION DETAILS                           *        
      ******************************************************************        
      *                COPYBOOK MODIFICATION LOG                       *        
      *               ________________________________                 *        
      *  DATE     INITIALS          REASON                             *        
      * ______    ________    ____________________________________     *        
      * 02/26/13  SV          INITIAL VERSION                          *        
      ******************************************************************        
      *  COMMON CURSORS DEFINED                                        *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE BILL_AR_TRANS CURSOR FOR                        
                SELECT ACCOUNT_NO,                                      
                       AMT_BILLED_UNPAID,                               
                       AMT_ORIG_ENTERED,                                
                       APPL_PROGRAM_ID,                                 
                       CODE_TRAN_TYPE,                                  
                       COMPANY_NO,                                      
                       DATE_ORIG_PYMT,                                  
                       DATE_TRANS,                                      
                       RECORD_ONLY_FL,                                  
                       RESP_AREA_ID,                                    
                       TRAN_COMMENT,                                    
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                               
                       USER_ID                                          
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :AR-ACCOUNT-NO                   
                  AND DATE_TRANS     = IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                   
                  AND CODE_TRAN_TYPE = :AR-CODE-TRAN-TYPE               
                ORDER BY TRANS_HIST_SEQ_NO DESC                         
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE BILL_AR_TRANS CURSOR FOR                                
MFA-TR*         SELECT ACCOUNT_NO,                                              
MFA-TR*                AMT_BILLED_UNPAID,                                       
MFA-TR*                AMT_ORIG_ENTERED,                                        
MFA-TR*                APPL_PROGRAM_ID,                                         
MFA-TR*                CODE_TRAN_TYPE,                                          
MFA-TR*                COMPANY_NO,                                              
MFA-TR*                DATE_ORIG_PYMT,                                          
MFA-TR*                DATE_TRANS,                                              
MFA-TR*                RECORD_ONLY_FL,                                          
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                TRAN_COMMENT,                                            
MFA-TR*                TRANS_HIST_SEQ_NO,                                       
MFA-TR*                USER_ID                                                  
MFA-TR*         FROM CSS_AR_TRANS_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO     = :AR-ACCOUNT-NO                           
MFA-TR*           AND DATE_TRANS     = :AR-DATE-TRANS                           
MFA-TR*           AND CODE_TRAN_TYPE = :AR-CODE-TRAN-TYPE                       
MFA-TR*         ORDER BY TRANS_HIST_SEQ_NO DESC                                 
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE AR_TRN_HST_DET CURSOR FOR                       
                SELECT                                                  
                      TRAN_APPL_NO,                                     
                      CODE_AR_AGE,                                      
                      GL_ACCT_CREDIT,                                   
                      GL_ACCT_DEBIT,                                    
                      AMT_POSTED,                                       
                      ITEM_ID,                                          
                      CODE_CONTRACT_TYPE,                               
                      CURRENCY_TYPE,                                    
                      CURRENCY_AMT                                      
                FROM CSS_AR_TRN_HST_DET WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO        = :AU-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AU-TRANS-HIST-SEQ-NO
              )         
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE AR_TRN_HST_DET CURSOR FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*               TRAN_APPL_NO,                                             
MFA-TR*               CODE_AR_AGE,                                              
MFA-TR*               GL_ACCT_CREDIT,                                           
MFA-TR*               GL_ACCT_DEBIT,                                            
MFA-TR*               AMT_POSTED,                                               
MFA-TR*               ITEM_ID,                                                  
MFA-TR*               CODE_CONTRACT_TYPE,                                       
MFA-TR*               CURRENCY_TYPE,                                            
MFA-TR*               CURRENCY_AMT                                              
MFA-TR*         FROM CSS_AR_TRN_HST_DET                                         
MFA-TR*         WHERE ACCOUNT_NO        = :AU-ACCOUNT-NO                        
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AU-TRANS-HIST-SEQ-NO                 
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                DECLARE PREV_AR_TRANS CURSOR FOR                        
                SELECT                                                  
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      AMT_ORIG_ENTERED,                                 
                      AMT_BILLED_UNPAID,                                
                      RESP_AREA_ID,                                     
                      APPL_PROGRAM_ID,                                  
                      PYMT_FACILITY_CD,                                 
                      USER_ID,                                          
                      COMPANY_NO,                                       
                      TRAN_COMMENT,                                     
                      RECORD_ONLY_FL,                                   
                      DATE_ORIG_PYMT                                    
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :AR-ACCOUNT-NO                   
                  AND DATE_TRANS     < IIF(TRY_CONVERT(DATE, 
                                                  :WS-DATE-TRANS-SEARCH
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TRANS-SEARCH
              ) <> 0) OR (LEN(:WS-DATE-TRANS-SEARCH
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-TRANS-SEARCH
              ), CONVERT(DATE, :WS-DATE-TRANS-SEARCH) )            
                  AND CODE_TRAN_TYPE = :AR-CODE-TRAN-TYPE               
                ORDER BY TRANS_HIST_SEQ_NO DESC                         
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE PREV_AR_TRANS CURSOR FOR                                
MFA-TR*         SELECT                                                          
MFA-TR*               TRANS_HIST_SEQ_NO,                                        
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               CODE_TRAN_TYPE,                                           
MFA-TR*               AMT_ORIG_ENTERED,                                         
MFA-TR*               AMT_BILLED_UNPAID,                                        
MFA-TR*               RESP_AREA_ID,                                             
MFA-TR*               APPL_PROGRAM_ID,                                          
MFA-TR*               PYMT_FACILITY_CD,                                         
MFA-TR*               USER_ID,                                                  
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               TRAN_COMMENT,                                             
MFA-TR*               RECORD_ONLY_FL,                                           
MFA-TR*               DATE_ORIG_PYMT                                            
MFA-TR*         FROM CSS_AR_TRANS_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO     = :AR-ACCOUNT-NO                           
MFA-TR*           AND DATE_TRANS     < :WS-DATE-TRANS-SEARCH                    
MFA-TR*           AND CODE_TRAN_TYPE = :AR-CODE-TRAN-TYPE                       
MFA-TR*         ORDER BY TRANS_HIST_SEQ_NO DESC                                 
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                DECLARE OLDEST_AR_TRANS CURSOR FOR                      
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                               
                       DATE_TRANS,                                      
                       CODE_TRAN_TYPE,                                  
                       AMT_ORIG_ENTERED,                                
                       AMT_BILLED_UNPAID,                               
                       RESP_AREA_ID,                                    
                       APPL_PROGRAM_ID,                                 
                       PYMT_FACILITY_CD,                                
                       USER_ID,                                         
                       COMPANY_NO,                                      
                       TRAN_COMMENT,                                    
                       RECORD_ONLY_FL,                                  
                       DATE_ORIG_PYMT                                   
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :AR-ACCOUNT-NO                   
                  AND DATE_TRANS     < IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                   
                ORDER BY TRANS_HIST_SEQ_NO                              
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE OLDEST_AR_TRANS CURSOR FOR                              
MFA-TR*         SELECT TRANS_HIST_SEQ_NO,                                       
MFA-TR*                DATE_TRANS,                                              
MFA-TR*                CODE_TRAN_TYPE,                                          
MFA-TR*                AMT_ORIG_ENTERED,                                        
MFA-TR*                AMT_BILLED_UNPAID,                                       
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                APPL_PROGRAM_ID,                                         
MFA-TR*                PYMT_FACILITY_CD,                                        
MFA-TR*                USER_ID,                                                 
MFA-TR*                COMPANY_NO,                                              
MFA-TR*                TRAN_COMMENT,                                            
MFA-TR*                RECORD_ONLY_FL,                                          
MFA-TR*                DATE_ORIG_PYMT                                           
MFA-TR*         FROM CSS_AR_TRANS_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO     = :AR-ACCOUNT-NO                           
MFA-TR*           AND DATE_TRANS     < :AR-DATE-TRANS                           
MFA-TR*         ORDER BY TRANS_HIST_SEQ_NO                                      
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                DECLARE AR_TRANS_HIST CURSOR FOR                        
                SELECT                                                  
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      AMT_ORIG_ENTERED,                                 
                      AMT_BILLED_UNPAID,                                
                      RESP_AREA_ID,                                     
                      APPL_PROGRAM_ID,                                  
                      PYMT_FACILITY_CD,                                 
                      USER_ID,                                          
                      COMPANY_NO,                                       
                      TRAN_COMMENT,                                     
                      RECORD_ONLY_FL,                                   
                      DATE_ORIG_PYMT                                    
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO       = :AR-ACCOUNT-NO                 
                  AND (TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                    :WS-PREV-HST-SEQ-NO
              )         
                      AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CURR-HST-SEQ-NO
              ))     
                ORDER BY TRANS_HIST_SEQ_NO                              
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE AR_TRANS_HIST CURSOR FOR                                
MFA-TR*         SELECT                                                          
MFA-TR*               TRANS_HIST_SEQ_NO,                                        
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               CODE_TRAN_TYPE,                                           
MFA-TR*               AMT_ORIG_ENTERED,                                         
MFA-TR*               AMT_BILLED_UNPAID,                                        
MFA-TR*               RESP_AREA_ID,                                             
MFA-TR*               APPL_PROGRAM_ID,                                          
MFA-TR*               PYMT_FACILITY_CD,                                         
MFA-TR*               USER_ID,                                                  
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               TRAN_COMMENT,                                             
MFA-TR*               RECORD_ONLY_FL,                                           
MFA-TR*               DATE_ORIG_PYMT                                            
MFA-TR*         FROM CSS_AR_TRANS_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO       = :AR-ACCOUNT-NO                         
MFA-TR*           AND (TRANS_HIST_SEQ_NO >= :WS-PREV-HST-SEQ-NO                 
MFA-TR*               AND TRANS_HIST_SEQ_NO <= :WS-CURR-HST-SEQ-NO)             
MFA-TR*         ORDER BY TRANS_HIST_SEQ_NO                                      
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
