      ***********************************************************               
      ** WORKING STORAGE COPYBOOK FOR CPDCA072 (HI-LO ROUTINE) **               
      ***********************************************************               
      *                                                                         
       01 CWS72-INPUT.                                                  
          05 CWS72-ACCOUNT-NO            PIC S9(13) COMP-3 VALUE +0.    
          05 CWS72-IC-NO                 PIC S9(04) COMP   VALUE +0.    
          05 CWS72-REV-MTH-LST-NRML      PIC S9(6)V COMP-3 VALUE -1.    
          05 CWS72-HI-LO-KEY.                                           
             15 CWS72-UTIL-TYPE          PIC X(01) VALUE ' '.           
             15 CWS72-RATE-PLAN          PIC X(03) VALUE ' '.           
          05 CWS72-MTR-REF-NO            PIC S9(4) COMP VALUE +0.       
          05 CWS72-TIME-PERIOD           PIC S9(4) COMP VALUE -1.       
P00251    05 CWS72-CODE-USAGE-ID         PIC X(01) VALUE ' '.           
          05 CWS72-ENVIRONMENT           PIC X(01) VALUE 'B'.           
             88 CWS72-ONLINE-CALL                  VALUE 'O'.           
             88 CWS72-BATCH-CALL                   VALUE 'B'.           
      *                                                                         
       01 CWS72-TEMP-STORAGE.                                           
          05 CWS72-HILO-MAX-LIMIT           PIC 9(09) VALUE 999999999.  
          05 CWS72-PGM-CPDCA072             PIC X(08) VALUE 'CPDCA072'. 
          05 CWS72-HI-FCTR-PARM              PIC 9(03).                 
          05 CWS72-LO-FCTR-PARM              PIC 9(03).                 
          05 CWS72-HL-MAX                    PIC S9(4) COMP VALUE 0.    
          05 CWS72-MNTH-SUB                  PIC 9(4).                  
          05 CWS72-PREV-MONTH1               PIC 9(2).                  
          05 CWS72-PREV-MONTH2               PIC 9(2).                  
          05 CWS72-PREV-MONTH3               PIC 9(2).                  
          05 CWS72-PREV-MONTH4               PIC 9(2).                  
COB305    05 CWS72-RMTH1        PIC S9(6) COMP-3 VALUE 0.         
COB305    05 CWS72-RMTH2        PIC S9(6) COMP-3 VALUE 0.         
COB305    05 CWS72-RMTH3        PIC S9(6) COMP-3 VALUE 0.         
COB305    05 CWS72-RMTH4        PIC S9(6) COMP-3 VALUE 0.         
          05 CWS72-WORK-DATE                    PIC 9(06).              
          05 FILLER  REDEFINES CWS72-WORK-DATE.                         
             10 CWS72-WORK-CCYY                 PIC 9(04).              
             10 CWS72-WORK-MM                   PIC 9(02).              
      *                                                                         
       01 CWS72-SWITCHES.                                               
          05 CWS72-ELEC-FACTORS-SW               PIC X VALUE ' '.       
             88 CWS72-ELEC-FACTORS-PRESENT              VALUE 'Y'.      
          05 CWS72-GAS-FACTORS-SW                PIC X VALUE ' '.       
             88 CWS72-GAS-FACTORS-PRESENT               VALUE 'Y'.      
          05 CWS72-BATCH-TABLE-SW              PIC X VALUE ' '.         
             88 CWS72-BATCH-TABLE-NOT-BUILT             VALUE ' '.      
             88 CWS72-BATCH-TABLE-BUILT                 VALUE 'Y'.      
          05 CWS72-JOB-PARM-DATA-SW            PIC X VALUE ' '.         
             88 CWS72-JOB-PARM-NOT-FETCHED              VALUE ' '.      
             88 CWS72-JOB-PARM-FETCHED                  VALUE 'Y'.      
          05 CWS72-CNS-DATA-SW                 PIC X VALUE ' '.         
             88 CWS72-NO-CNS-DATA                       VALUE ' '.      
             88 CWS72-CNS-DATA-FOUND                    VALUE 'Y'.      
          05 CWS72-ADJ-FACTOR-NEEDED-SW        PIC X VALUE ' '.         
             88 CWS72-ADJ-FCTR-NEEDED                   VALUE 'Y'.      
          05 CWS72-ADJ-FACTOR-ACTIVE-SW        PIC X VALUE ' '.         
             88 CWS72-ADJ-FCTR-ACTIVE                   VALUE 'Y'.      
      *                                                                         
       01 CWS72-ERROR-DATA.                                             
          05 CWS72-ERROR-TYPE            PIC X(01) VALUE ' '.           
             88 CWS72-NO-ERROR                     VALUE ' ', 'W'.      
             88 CWS72-WARNING                      VALUE 'W'.           
             88 CWS72-DB2-ERROR                    VALUE 'D'.           
             88 CWS72-NON-DB2-ERROR                VALUE 'N'.           
             88 CWS72-ERROR                        VALUE 'D', 'N'.      
          05 CWS72-ERROR-MESSAGE         PIC X(72).                     
          05 CWS72-ERROR-SQLCODE         PIC S9(9) COMP.                
          05 CWS72-ERROR-FUNCTION        PIC X(08).                     
          05 CWS72-ERROR-PARAGRAPH-NO    PIC X(04).                     
          05 CWS72-ERROR-PARAGRAPH-NAME  PIC X(32).                     
          05 CWS72-ERROR-TABLE1          PIC X(20).                     
          05 CWS72-ERROR-TABLE2          PIC X(20).                     
          05 CWS72-ERROR-TAB-COLUMN-1    PIC X(20).                     
          05 CWS72-ERROR-TAB-COLUMN-2    PIC X(20).                     
          05 CWS72-ERROR-TAB-COLUMN-3    PIC X(20).                     
          05 CWS72-ERROR-TAB-COLUMN-4    PIC X(20).                     
          05 CWS72-ERROR-HOSTVAR-1       PIC X(20).                     
          05 CWS72-ERROR-HOSTVAR-2       PIC X(20).                     
          05 CWS72-ERROR-HOSTVAR-3       PIC X(20).                     
          05 CWS72-ERROR-HOSTVAR-4       PIC X(20).                     
      *                                                                         
       01 CWS72-USAGE-TABLE.                                            
          05 CWS72-HI-LO-TABLE OCCURS 300 TIMES                         
                 ASCENDING KEY CWS72-HL-TBL-KEY                         
                 INDEXED BY CWS72-HL-IDX.                               
               10 CWS72-HL-TBL-KEY.                                     
                  15 CWS72-HL-UTIL-TYPE     PIC X(1).                   
                  15 CWS72-HL-RATE-PLAN     PIC X(3).                   
               10 CWS72-HL-PREV-MONTH1      PIC 9(2).                   
               10 CWS72-HL-PREV-MONTH2      PIC 9(2).                   
               10 CWS72-HL-PREV-MONTH3      PIC 9(2).                   
               10 CWS72-HL-PREV-MONTH4      PIC 9(2).                   
COB305         10 CWS72-HL-USAGE-HPCT        PIC S9(03)V99 COMP-3 
COB305          VALUE 0.       
COB305         10 CWS72-HL-USAGE-LPCT        PIC S9(03)V99 COMP-3 
COB305          VALUE 0.       
COB305         10 CWS72-HL-DEMAND-HPCT        PIC S9(03)V99 COMP-3 
COB305          VALUE 0.       
COB305         10 CWS72-HL-DEMAND-LPCT        PIC S9(03)V99 COMP-3 
COB305          VALUE 0.       
COB305         10 CWS72-HL-IBILL-MIN-KVA        PIC S9(09) COMP-3 
COB305          VALUE 0.          
COB305         10 CWS72-HL-IBILL-MAX-KVA        PIC S9(09) COMP-3 
COB305          VALUE 0.          
COB305         10 CWS72-HL-IBILL-MIN-KW        PIC S9(09) COMP-3 
COB305          VALUE 0.          
COB305         10 CWS72-HL-IBILL-MAX-KW        PIC S9(09) COMP-3 
COB305          VALUE 0.          
COB305         10 CWS72-HL-IBILL-MIN-KWH        PIC S9(09) COMP-3 
COB305          VALUE 0.          
COB305         10 CWS72-HL-IBILL-MAX-KWH        PIC S9(09) COMP-3 
COB305          VALUE 0.          
COB305         10 CWS72-HL-MIN-PFACTOR        PIC S9V99 COMP-3 VALUE 0.         
COB305         10 CWS72-HL-MAX-PFACTOR        PIC S9V99 COMP-3 VALUE 0.         
COB305         10 CWS72-HL-MIN-LFACTOR        PIC S9V99 COMP-3 VALUE 0.         
COB305         10 CWS72-HL-MAX-LFACTOR        PIC S9V99 COMP-3 VALUE 0.         
COB305         10 CWS72-HL-MKT-DEMAND-LPCT        PIC S9(03)V99 COMP-3 
COB305          VALUE 0.       
COB305         10 CWS72-HL-MKT-DEMAND-HPCT        PIC S9(03)V99 COMP-3 
COB305          VALUE 0.       
COB305         10 CWS72-HL-MKT-USAGE-LPCT        PIC S9(03)V99 COMP-3 
COB305          VALUE 0.       
COB305         10 CWS72-HL-MKT-USAGE-HPCT        PIC S9(03)V99 COMP-3 
COB305          VALUE 0.       
      *                                                                         
       01 WS-CWS72-TEMP-HILO.                                           
          05 CWS72-HL-SUB             PIC 9(04) VALUE 0.                
          05 CWS72-TEMP-HILO-TAB.                                       
             10 CWS72-TB-UTIL-TYPE      PIC X(1) OCCURS 300 TIMES.      
             10 CWS72-TB-RATE-PLAN-NO   PIC X(3) OCCURS 300 TIMES.      
             10 CWS72-TB-PREV-MONTH1    PIC X(2) OCCURS 300 TIMES.      
             10 CWS72-TB-PREV-MONTH2    PIC X(2) OCCURS 300 TIMES.      
             10 CWS72-TB-PREV-MONTH3    PIC X(2) OCCURS 300 TIMES.      
             10 CWS72-TB-PREV-MONTH4    PIC X(2) OCCURS 300 TIMES.      
COB305       10 CWS72-TB-USAGE-HPCT        PIC S9(3)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
COB305       10 CWS72-TB-USAGE-LPCT        PIC S9(3)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
COB305       10 CWS72-TB-DEMAND-HPCT        PIC S9(3)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
COB305       10 CWS72-TB-DEMAND-LPCT        PIC S9(3)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
             10 CWS72-TB-IBILL-MIN-KVA PIC S9(9) COMP OCCURS 300  TIMES.
             10 CWS72-TB-IBILL-MAX-KVA PIC S9(9) COMP OCCURS 300  TIMES.
             10 CWS72-TB-IBILL-MIN-KW   PIC S9(9) COMP OCCURS 300 TIMES.
             10 CWS72-TB-IBILL-MAX-KW   PIC S9(9) COMP OCCURS 300 TIMES.
             10 CWS72-TB-IBILL-MIN-KWH PIC S9(9) COMP OCCURS 300  TIMES.
             10 CWS72-TB-IBILL-MAX-KWH PIC S9(9) COMP OCCURS 300  TIMES.
COB305       10 CWS72-TB-MIN-PFACTOR        PIC S9(1)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
COB305       10 CWS72-TB-MAX-PFACTOR        PIC S9(1)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
COB305       10 CWS72-TB-MIN-LFACTOR        PIC S9(1)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
COB305       10 CWS72-TB-MAX-LFACTOR        PIC S9(1)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
COB305       10 CWS72-TB-MKT-DEMAND-LPCT        PIC S9(3)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
COB305       10 CWS72-TB-MKT-DEMAND-HPCT        PIC S9(3)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
COB305       10 CWS72-TB-MKT-USAGE-LPCT        PIC S9(3)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
COB305       10 CWS72-TB-MKT-USAGE-HPCT        PIC S9(3)V9(2) COMP-3 
COB305          OCCURS 300 TIMES VALUE 0.     
      *                                                                         
       01 CWS72-CONSUMPTION-DATA.                                       
          05 CWS72-MTHLY-CONS-ROW                                       
                OCCURS 4 TIMES                                          
                INDEXED BY CWS72-MC-IDX.                                
            10 CWS72-MC-REV-MONTH              PIC 9(6).                
COB305      10 CWS72-MC-KWH-CCF-READ        PIC S9(9)V9 COMP-3 VALUE 0.     
COB305      10 CWS72-MC-KW-READ        PIC S9(9) COMP-3 VALUE 0.     
COB305      10 CWS72-MC-KVA-READ        PIC S9(9) COMP-3 VALUE 0.     
COB305      10 CWS72-MC-UNC-READ        PIC S9(9)V9 COMP-3 VALUE 0.     
COB305      10 CWS72-MC-INT-READ        PIC S9(9)V9 COMP-3 VALUE 0.     
COB305      10 CWS72-MC-UNC-RATIO        PIC S99V9(3) COMP-3 VALUE 0.     
COB305      10 CWS72-MC-INT-RATIO        PIC S99V9(3) COMP-3 VALUE 0.     
            10 CWS72-MC-NO-DAYS-KWH            PIC 9(4) COMP.           
            10 CWS72-MC-NO-DAYS-UNC            PIC 9(4) COMP.           
            10 CWS72-MC-NO-DAYS-INT            PIC 9(4) COMP.           
COB305      10 CWS72-MC-CONSTANT        PIC S9(6)V9(5) COMP-3 VALUE 0.   
            10 CWS72-MC-DATA-EXISTS            PIC X(1).                
      *                                                                         
       01 CWS72-OUTPUT.                                                 
          05 CWS72-HI-KWH               PIC S9(09)V9 COMP-3 VALUE +0.   
          05 CWS72-LO-KWH               PIC S9(09)V9 COMP-3 VALUE +0.   
          05 CWS72-HI-KWH-RND           PIC S9(09) COMP-3 VALUE +0.     
          05 CWS72-LO-KWH-RND           PIC S9(09) COMP-3 VALUE +0.     
          05 CWS72-HI-KVA               PIC S9(09) COMP-3 VALUE +0.     
          05 CWS72-LO-KVA               PIC S9(09) COMP-3 VALUE +0.     
          05 CWS72-HI-KW                PIC S9(09) COMP-3 VALUE +0.     
          05 CWS72-LO-KW                PIC S9(09) COMP-3 VALUE +0.     
          05 CWS72-HI-UNC               PIC S9(09)V9 COMP-3 VALUE +0.   
          05 CWS72-HI-UNC-RND           PIC S9(09)   COMP-3 VALUE +0.   
          05 CWS72-LO-UNC               PIC S9(09)V9 COMP-3 VALUE +0.   
          05 CWS72-LO-UNC-RND           PIC S9(09)   COMP-3 VALUE +0.   
          05 CWS72-HI-INT               PIC S9(09)V9 COMP-3 VALUE +0.   
          05 CWS72-HI-INT-RND           PIC S9(09)   COMP-3 VALUE +0.   
          05 CWS72-LO-INT               PIC S9(09)V9 COMP-3 VALUE +0.   
          05 CWS72-LO-INT-RND           PIC S9(09)   COMP-3 VALUE +0.   
          05 CWS72-HI-UNC-RATIO         PIC S99V9(3) COMP-3 VALUE +0.   
          05 CWS72-LO-UNC-RATIO         PIC S99V9(3) COMP-3 VALUE +0.   
          05 CWS72-HI-INT-RATIO         PIC S99V9(3) COMP-3 VALUE +0.   
          05 CWS72-LO-INT-RATIO         PIC S99V9(3) COMP-3 VALUE +0.   
          05 CWS72-HI-POWER-FACTOR      PIC S9V99  COMP-3 VALUE +0.     
          05 CWS72-LO-POWER-FACTOR      PIC S9V99  COMP-3 VALUE +0.     
          05 CWS72-HI-LOAD-FACTOR       PIC S9V99  COMP-3 VALUE +0.     
          05 CWS72-LO-LOAD-FACTOR       PIC S9V99  COMP-3 VALUE +0.     
          05 CWS72-HI-MKT-DEMAND-PCT    PIC S9(03)V99 COMP-3 VALUE +0.  
          05 CWS72-LO-MKT-DEMAND-PCT    PIC S9(03)V99 COMP-3 VALUE +0.  
          05 CWS72-HI-MKT-USAGE-PCT     PIC S9(03)V99 COMP-3 VALUE +0.  
          05 CWS72-LO-MKT-USAGE-PCT     PIC S9(03)V99 COMP-3 VALUE +0.  
      *                                                                         
       01 CWS72-ELEC-FCTR-DATA.                                         
          05 FILLER                  PIC X(07).                         
          05 CWS72-ELEC-RANGE1       PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-ELEC-RANGE2       PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-ELEC-LPER1        PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-ELEC-HPER1        PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-ELEC-LPER2        PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-ELEC-HPER2        PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-ELEC-LPER3        PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-ELEC-HPER3        PIC 9(03).                         
      *                                                                         
       01 CWS72-GAS-FCTR-DATA.                                          
          05 FILLER                  PIC X(06).                         
          05 CWS72-GAS-RANGE1        PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-GAS-RANGE2        PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-GAS-LPER1         PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-GAS-HPER1         PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-GAS-LPER2         PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-GAS-HPER2         PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-GAS-LPER3         PIC 9(03).                         
          05 FILLER                  PIC X(03).                         
          05 CWS72-GAS-HPER3         PIC 9(03).                         
      *                                                                         
      *****************************************************************         
      *    CURSOR DECLARATIONS                                                  
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE CWS72_HIST_CSR CURSOR FOR                        
                SELECT CASE WHEN BG.REV_MTH_ORIG_BILL > 0               
                            THEN BG.REV_MTH_ORIG_BILL                   
                            ELSE BG.REVENUE_MONTH                       
                            END                                         
                      ,CX.NO_UNITS                                      
                      ,CX.NO_DEMAND_UNITS                               
                      ,CX.CONSTANT                                      
                      ,CX.CODE_USAGE_TYPE                               
                      ,CX.CODE_TOU_SEASN                                
                      ,CX.NO_DAYS                                       
                  FROM CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                
                      ,CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                
                 WHERE BG.ACCOUNT_NO         = CX.ACCOUNT_NO            
                   AND BG.CODE_UTIL_TYPE     = CX.CODE_UTIL_TYPE        
                   AND BG.IC_NO              = CX.IC_NO                 
                   AND BG.BILL_NO            = CX.BILL_NO               
                   AND BG.BILL_ITEM_TIMESTMP = CX.BILL_ITEM_TIMESTMP    
                   AND BG.ACCOUNT_NO         = :BG-ACCOUNT-NO           
                   AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE       
                   AND BG.IC_NO              = :BG-IC-NO                
                   AND BG.CODE_BILL_CALC     = 'A'                      
                   AND BG.CODE_BILL_ITM_TYPE = 'C'                      
                   AND BG.CODE_BILL_ITM_IND  = 'A'                      
                   AND CX.MTR_REF_NO         = :CX-MTR-REF-NO           
                   AND CX.CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD     
P00251             AND CX.CODE_USAGE_ID      = :CX-CODE-USAGE-ID        
                   AND CX.CODE_USAGE_TYPE IN ('B','C','E','J','I','U')  
                   AND (BG.REV_MTH_ORIG_BILL IN (:CWS72-RMTH1,          
                        :CWS72-RMTH2, :CWS72-RMTH3, :CWS72-RMTH4)       
                    OR  (BG.REVENUE_MONTH    IN (:CWS72-RMTH1,          
                        :CWS72-RMTH2, :CWS72-RMTH3, :CWS72-RMTH4)       
                         AND BG.REV_MTH_ORIG_BILL = 0 ))                
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CWS72_HIST_CSR CURSOR FOR                                
MFA-TR*         SELECT CASE WHEN BG.REV_MTH_ORIG_BILL > 0                       
MFA-TR*                     THEN BG.REV_MTH_ORIG_BILL                           
MFA-TR*                     ELSE BG.REVENUE_MONTH                               
MFA-TR*                     END                                                 
MFA-TR*               ,CX.NO_UNITS                                              
MFA-TR*               ,CX.NO_DEMAND_UNITS                                       
MFA-TR*               ,CX.CONSTANT                                              
MFA-TR*               ,CX.CODE_USAGE_TYPE                                       
MFA-TR*               ,CX.CODE_TOU_SEASN                                        
MFA-TR*               ,CX.NO_DAYS                                               
MFA-TR*           FROM CSS_BILLING_DET  BG                                      
MFA-TR*               ,CSS_CNSMPTN_HIST CX                                      
MFA-TR*          WHERE BG.ACCOUNT_NO         = CX.ACCOUNT_NO                    
MFA-TR*            AND BG.CODE_UTIL_TYPE     = CX.CODE_UTIL_TYPE                
MFA-TR*            AND BG.IC_NO              = CX.IC_NO                         
MFA-TR*            AND BG.BILL_NO            = CX.BILL_NO                       
MFA-TR*            AND BG.BILL_ITEM_TIMESTMP = CX.BILL_ITEM_TIMESTMP            
MFA-TR*            AND BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                   
MFA-TR*            AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE               
MFA-TR*            AND BG.IC_NO              = :BG-IC-NO                        
MFA-TR*            AND BG.CODE_BILL_CALC     = 'A'                              
MFA-TR*            AND BG.CODE_BILL_ITM_TYPE = 'C'                              
MFA-TR*            AND BG.CODE_BILL_ITM_IND  = 'A'                              
MFA-TR*            AND CX.MTR_REF_NO         = :CX-MTR-REF-NO                   
MFA-TR*            AND CX.CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD             
MFA-TR*            AND CX.CODE_USAGE_ID      = :CX-CODE-USAGE-ID                
MFA-TR*            AND CX.CODE_USAGE_TYPE IN ('B','C','E','J','I','U')          
MFA-TR*            AND (BG.REV_MTH_ORIG_BILL IN (:CWS72-RMTH1,                  
MFA-TR*                 :CWS72-RMTH2, :CWS72-RMTH3, :CWS72-RMTH4)               
MFA-TR*             OR  (BG.REVENUE_MONTH    IN (:CWS72-RMTH1,                  
MFA-TR*                 :CWS72-RMTH2, :CWS72-RMTH3, :CWS72-RMTH4)               
MFA-TR*                  AND BG.REV_MTH_ORIG_BILL = 0 ))                        
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE CWS72_HI_LO_CSR CURSOR WITH ROWSET               
                     POSITIONING FOR                                    
              SELECT CODE_UTIL_TYPE                                     
                    ,RATE_PLAN_NO                                       
                    ,PREVIOUS_MONTH1                                    
                    ,PREVIOUS_MONTH2                                    
                    ,PREVIOUS_MONTH3                                    
                    ,PREVIOUS_MONTH4                                    
                    ,USAGE_HIGH_PCT                                     
                    ,USAGE_LOW_PCT                                      
                    ,DEMAND_HIGH_PCT                                    
                    ,DEMAND_LOW_PCT                                     
                    ,INIT_BILL_MIN_KVA                                  
                    ,INIT_BILL_MAX_KVA                                  
                    ,INIT_BILL_MIN_KW                                   
                    ,INIT_BILL_MAX_KW                                   
                    ,INIT_BILL_MIN_KWH                                  
                    ,INIT_BILL_MAX_KWH                                  
                    ,MIN_POWER_FACTOR                                   
                    ,MAX_POWER_FACTOR                                   
                    ,MIN_LOAD_FACTOR                                    
                    ,MAX_LOAD_FACTOR                                    
                    ,MKT_DEMAND_LOW_PCT                                 
                    ,MKT_DEMAND_HI_PCT                                  
                    ,MKT_USAGE_LOW_PCT                                  
                    ,MKT_USAGE_HIGH_PCT                                 
               FROM CSS_RATE_HIGH_LOW WITH(READUNCOMMITTED)                     
               ORDER BY CODE_UTIL_TYPE, RATE_PLAN_NO                    
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CWS72_HI_LO_CSR CURSOR WITH ROWSET                       
MFA-TR*              POSITIONING FOR                                            
MFA-TR*       SELECT CODE_UTIL_TYPE                                             
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,PREVIOUS_MONTH1                                            
MFA-TR*             ,PREVIOUS_MONTH2                                            
MFA-TR*             ,PREVIOUS_MONTH3                                            
MFA-TR*             ,PREVIOUS_MONTH4                                            
MFA-TR*             ,USAGE_HIGH_PCT                                             
MFA-TR*             ,USAGE_LOW_PCT                                              
MFA-TR*             ,DEMAND_HIGH_PCT                                            
MFA-TR*             ,DEMAND_LOW_PCT                                             
MFA-TR*             ,INIT_BILL_MIN_KVA                                          
MFA-TR*             ,INIT_BILL_MAX_KVA                                          
MFA-TR*             ,INIT_BILL_MIN_KW                                           
MFA-TR*             ,INIT_BILL_MAX_KW                                           
MFA-TR*             ,INIT_BILL_MIN_KWH                                          
MFA-TR*             ,INIT_BILL_MAX_KWH                                          
MFA-TR*             ,MIN_POWER_FACTOR                                           
MFA-TR*             ,MAX_POWER_FACTOR                                           
MFA-TR*             ,MIN_LOAD_FACTOR                                            
MFA-TR*             ,MAX_LOAD_FACTOR                                            
MFA-TR*             ,MKT_DEMAND_LOW_PCT                                         
MFA-TR*             ,MKT_DEMAND_HI_PCT                                          
MFA-TR*             ,MKT_USAGE_LOW_PCT                                          
MFA-TR*             ,MKT_USAGE_HIGH_PCT                                         
MFA-TR*        FROM CSS_RATE_HIGH_LOW                                           
MFA-TR*        ORDER BY CODE_UTIL_TYPE, RATE_PLAN_NO                            
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
