      *****************************************************************         
      ** CWS0326A.                                                   **         
      **     SEB RATE RE-ENG - WORKING STORAGE COPYBOOK.             **         
      *****************************************************************         
      *---------------------------------------------------------------*         
      *  NOTE:                                                        *         
      *      WHEN MODIFYING THIS MEMBER, MEMBER CPD00326 SHOULD BE    *         
      *      EVALUATED FOR CORRESPONDING MODIFICATIONS.               *         
      *---------------------------------------------------------------*         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
C35469**  05/02/07  JC91900      INITIAL VERSION                     **         
I00113**  01/26/09  JC91900      SCANA SR. CHANGES.                  **         
P00141**  04/14/09  SS97726      ADD START/END DATE COLUMNS TO CRM   **         
P00141**                         USER TBL CRM_OPT_ATTR_INCTV.        **         
P00172**  07/14/09  VY95550      REGULATED TRANSITION CHANGES        **         
I00631**  08/10/09  SS97726      2 MONTHS GAS CONSUMPTION CREDIT.    **         
I00631**                         HANDLE FIXED FACTORS WITH ZERO      **         
I00631**                         ATTR_INCTV_VALUE.                   **         
P00211**  08/11/09  JC91900      Early renewal changes.              **         
P00245**  01/11/09  JC91900      Automated rate change letter.       **         
P00453**  01/11/11  JC91900      PREPAY CHANGES.                     **         
P00579**  01/21/12  HA7A338      CRM-SM COMMERCIAL RATE SETUP CHANGES**         
P00680**  05/11/12  SS97726      CUSTOMER RETENTION AND ACQUISITION. **         
A04019**  08/12/12  JC91900      Remove the date check to expire     **         
A04019**                         factors from current option.        **         
JC4019**  08/12/12  JC91900      Temp fix. SM Comm customers.        **         
JC4019**  09/12/12  JC91900      Remove temp fix. Add distict to     **         
JC4019**                         remove duplicate attributes.        **         
P680P2**  11/08/12  SS97726      PHASE 2 - CUSTOMER RETENTION AND    **         
P680P2**                                   ACQUISITION.              **         
P680II**  03/05/13  SS97726      Consider Intro Variable Rates also  **         
P680II**                         for Default Offer Comparison with   **         
P680II**                         Selected Offer/Option.              **         
P680PN**  04/30/13  SS97726      New appl pgm ids for negotiated     **         
P680PN**                         price.                              **         
A05094**  02/16/14  SS97726      Net Margin Reporting Changes.       **         
A05051** 03/17/2015 AS7C117      CREATE WQ IF THE ACCOUNT IS CHANGED **         
A05051** APPL5051-ACT005         FROM RESIDENTIAL TO COMMERCIAL AND  **         
A05051**                         THE ACCOUNT HAS CREDIT CARD PAYMENT **         
P00892**  04/14/15  VIJAY        FIXED RATE AUTO RENEWAL CHANGES.    **         
      *****************************************************************         
       01  WS-326-VARS.                                                 
           05 WS-CURRENT-TIME         PIC X(08) VALUE SPACES.           
           05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.           
           05 WS-CURRENT-TS           PIC X(26) VALUE SPACES.           
           05 WS-FACTOR-EXPIRE-DT     PIC X(10) VALUE SPACES.           
           05 WS-FACTOR-START-DT      PIC X(10) VALUE SPACES.           
           05 WS-CNS-READ-EXPIRE      PIC X(10) VALUE SPACES.           
           05 WS-CNS-READ-SEARCH      PIC X(10) VALUE SPACES.           
           05 WS-DT-DIFF-START        PIC X(10) VALUE SPACES.           
           05 WS-DT-DIFF-END          PIC X(10) VALUE SPACES.           
           05 WS-REV-MTH-LST-NRML     PIC 9(6)  VALUE ZEROES.           
           05 WS-TEMP-REV-MONTH       PIC 9(6)  VALUE ZEROES.           
           05 WS-ACT-REV-MTH-NEXT     PIC 9(6)  VALUE ZEROES.           
           05 WS-NEXT-REV-MTH         PIC 9(6)  VALUE ZEROES.           
           05 WS-CALC-NO-MTHS         PIC S9(9)  COMP.                  
           05 WS-REV-MTH-LST-NRML-C   PIC X(06) VALUE SPACES.           
           05 WS-TEMP-REV-MONTH-C     PIC X(06) VALUE SPACES.           
           05 WS-RESULT-DATE          PIC X(10) VALUE SPACES.           
           05 WS-DUMMY-DATE           PIC X(10) VALUE SPACES.           
           05 WS-FCTR-SRCH-DT-FRM     PIC X(10) VALUE SPACES.           
           05 WS-FCTR-SRCH-DT-TO      PIC X(10) VALUE SPACES.           
           05 WS-ACCOUNT-NO           PIC 9(13) VALUE ZEROES.           
           05 WS-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.           
           05 WS-OPTION-CD            PIC X(12) VALUE SPACES.           
           05 WS-OFFER-CD             PIC X(12) VALUE SPACES.           
           05 WS-TRANS-SEQ-ID         PIC X(04) VALUE SPACES.           
           05 WS-PROMO-CD             PIC X(12) VALUE SPACES.           
           05 WS-IC-NO                PIC X(04) VALUE SPACES.           
           05 WS-COMM-CHANNEL         PIC X(01) VALUE SPACES.           
           05 WS-CREATED-USER-ID      PIC X(07) VALUE SPACES.           
           05 WS-PROCESS-CD           PIC X(01) VALUE SPACES.           
           05 WS-OPT-AGRMT-EFF-DT     PIC X(10) VALUE SPACES.           
P00141     05 WS-OPT-AGRMT-EFF-DT-HQ  PIC X(10) VALUE SPACES.           
P00141     05 WS-TMP-OPT-AGR-EFF-DT   PIC X(10) VALUE SPACES.           
P00141     05 WS-PRV-OPT-AGR-EFF-DT   PIC X(10) VALUE SPACES.           
P00211     05 WS-DUMMY-REV-MONTH      PIC X(06) VALUE SPACES.           
A05094     05 WS-PNDG-STAT-EFF-MTH    PIC S9(9) USAGE COMP.             
A05094     05 WS-PNDG-REV-MTH-NEXT    PIC 9(6)  VALUE ZEROES.           
P00211     05 WS-CURR-KEEP-EFF-TO     PIC X(10) VALUE SPACES.           
A05094     05 WS-PNDG-OPTION-CD       PIC X(12) VALUE SPACES.           
A05094     05 WS-PNDG-OFFER-CD        PIC X(12) VALUE SPACES.           
A05094     05 WS-PNDG-OFFER-DESC      PIC X(50) VALUE SPACES.           
A05094     05 WS-PNDG-OPTION-DESC     PIC X(50) VALUE SPACES.           
P00211     05 WS-CURR-OFFER-CD        PIC X(12) VALUE SPACES.           
P00211     05 WS-CURR-OPTION-CD       PIC X(12) VALUE SPACES.           
P00211     05 WS-CURR-OFFER-DESC      PIC X(50) VALUE SPACES.           
P00211     05 WS-CURR-OPTION-DESC     PIC X(50) VALUE SPACES.           
P00892     05 WS-AGREEMNT-SOURCE-CD   PIC X(3)  VALUE SPACES.           
P00211     05 WS-MTHS-REM-CUR-TERM    PIC S9(4) USAGE COMP.             
P00211     05 WS-ADD-CTR              PIC S9(4) USAGE COMP.             
A05094     05 WS-PNDG-RTPKG-SEQ-NO    PIC S9(4) USAGE COMP.             
P00211     05 WS-CURR-RTPKG-SEQ-NO    PIC S9(4) USAGE COMP.             
P00211     05 WS-MAX-RTPKG-SEQ-NO     PIC S9(4) USAGE COMP.             
A05094     05 WS-PNDG-FF-SEQ-NO       PIC S9(4) USAGE COMP.             
P00211     05 WS-CURR-FF-SEQ-NO       PIC S9(4) USAGE COMP.             
A05094     05 WS-PNDG-DUR-NO          PIC S9(4) USAGE COMP.             
P00211     05 WS-RT-PKG-OPT-SEQ-NO    PIC S9(4) USAGE COMP.             
P00680     05 WS-CURR-FXDPRC-SEQ-NO   PIC S9(4) USAGE COMP.             
P00680     05 WS-CURR-ADJOPT-SEQ-NO   PIC S9(4) USAGE COMP.             
P00245     05 WS-STATUS-EFF-REV-MTH   PIC 9(6)  VALUE ZEROES.           
           05 WS-OPT-AGRMT-EFF-TM     PIC X(08) VALUE SPACES.           
           05 WS-EXIT-FEE-FLAG        PIC X(01) VALUE SPACES.           
           05 WS-EXIT-FEE-AMT         PIC X(11) VALUE SPACES.           
           05 WS-PREV-OPT-CODE        PIC X(12) VALUE SPACES.           
           05 WS-READ-ROUTE           PIC X(04) VALUE SPACES.           
           05 WS-RATE-PLAN-NO         PIC X(03) VALUE SPACES.           
           05 WS-PREV-RATE-PLAN-NO    PIC X(03) VALUE SPACES.           
           05 WS-CUST-AGRD-THERM      PIC X(11) VALUE SPACES.           
           05 WS-CODE-REV-CLASS       PIC X(03) VALUE SPACES.           
           05 WS-TIER-ACCT-TYPE-CD    PIC X(01) VALUE SPACES.           
           05 WS-TIER-CUST-STAT-CD    PIC X(01) VALUE SPACES.           
           05 WS-MKT-TIER-RANKING     PIC X(04) VALUE SPACES.           
           05 WS-MKT-TIER-RANKING-N   REDEFINES                         
              WS-MKT-TIER-RANKING     PIC 9(4).                         
           05 WS-MKT-TIER-START-DT    PIC X(10) VALUE SPACES.           
           05 WS-SKYMILES-NO          PIC X(12) VALUE SPACES.           
           05 WS-CREDIT-GL-NUM        PIC X(07) VALUE SPACES.           
           05 WS-CREDIT-AMT-N         PIC 9(5).9(2) VALUE ZEROES.       
           05 WS-CREDIT-AMT-C         PIC X(08) VALUE SPACES.           
           05 WS-CREDIT-AMT-C-TMP     PIC X(11) VALUE SPACES.           
           05 WS-DB-GL-ACCT-N         PIC 9(3).9(4) VALUE ZEROES.       
           05 WS-DB-GL-ACCT-C         PIC X(08) VALUE SPACES.           
           05 WS-DB-GL-ACCT-C-TMP     PIC X(07) VALUE SPACES.           
           05 WS-CALC-ERROR           PIC X(08) VALUE SPACES.           
           05 WS-PREV-STATUS          PIC X(01) VALUE SPACES.           
P00579     05 WS-TEMP-ACCT-TYPE-CD    PIC X(01) VALUE SPACES.           
           05 WS-PREV-REG-GRP-CD      PIC X(03) VALUE SPACES.           
           05 WS-PREV-CSC             PIC X(02) VALUE SPACES.           
           05 WS-CURR-CSC             PIC X(02) VALUE SPACES.           
           05 WS-PREV-GRP2-MOVE-DT    PIC X(10) VALUE SPACES.           
           05 WS-CURR-GRP2-MOVE-DT    PIC X(10) VALUE SPACES.           
           05 WS-SQLCODE-DISPL        PIC 9(03) VALUE ZEROES.           
           05 WS-NEW-RT-PKG-SEQ-NO    PIC S9(4) USAGE COMP.             
           05 WS-VERSION-PRORATE-CD   PIC X(01) VALUE SPACES.           
           05 WS-RESP-AREA-ID         PIC X(03) VALUE SPACES.           
           05 WS-TRAN-APPL-NO         PIC S9(02) VALUE +1.              
           05 WS-FACT-VAL-Z           PIC -Z(09).9(06).                 
           05 WS-FACTOR-TEXT          PIC 9(9).9(6).                    
           05 WS-ATTR-INCTV-VALUE     PIC Z(05).9(06).                  
           05 WS-ATTR-INCTV-TXT       PIC X(12) VALUE SPACES.           
           05 WS-TEMP-FACTOR-ID       PIC X(09) VALUE SPACES.           
P00680     05 WS-CURR-FXDPRC-FCTR-ID  PIC X(09) VALUE SPACES.           
P00680     05 WS-CURR-ADJOPT-FCTR-ID  PIC X(09) VALUE SPACES.           
           05 WS-TEMP-DATE-TO         PIC X(10) VALUE SPACES.           
           05 WS-TEMP-DATE-FRM        PIC X(10) VALUE SPACES.           
           05 WS-DURATION-NO          PIC S9(4) USAGE COMP.             
           05 WS-ADJ-DAY              PIC S9(4) USAGE COMP.             
           05 WS-KEEP-DUR-NO          PIC S9(4) USAGE COMP.             
P00680     05 WS-TEMP-DURATION-NO     PIC S9(4) USAGE COMP.             
           05 WS-KEEP-RT-PKG-SEQ      PIC S9(4) USAGE COMP.             
           05 WS-DURATION-NO-Z        PIC Z(04).                        
           05 WS-OPT-DURATION-NO      PIC S9(4) USAGE COMP.             
           05 WS-ONERATE-DURATION-NO  PIC S9(4) USAGE COMP.             
           05 WS-CONV-FCTR-SEQ-NO     PIC S9(4) USAGE COMP.             
           05 WS-CONV-DATE-START      PIC X(10) VALUE SPACES.           
           05 WS-FACTOR-ID-DESC       PIC X(35) VALUE SPACES.           
           05 WS-INCENTIVE-ONLY       PIC X(01) VALUE SPACES.           
           05 WS-BATCH-CALL           PIC X(01) VALUE 'N'.              
           05 WS-TIER-CUST-STAT-CD-T  PIC X(01) VALUE SPACES.           
           05 WS-TIER-ACCT-TYPE-CD-T  PIC X(01) VALUE SPACES.           
           05 WS-EFF-START-DT-T       PIC X(10) VALUE SPACES.           
           05 WS-TIER-SOURCE-CD-T     PIC X(02) VALUE SPACES.           
           05 WS-MKT-TIER-RANKING-T   PIC S9(4) USAGE COMP.             
           05 WS-PREV-MKT-TIER-DESC   PIC X(50) VALUE SPACES.           
           05 WS-CURR-MKT-TIER-DESC   PIC X(50) VALUE SPACES.           
           05 WS-START-DATE.                                            
               10 WS-START-YR         PIC X(04).                        
               10 FILLER              PIC X(01) VALUE '-'.              
               10 WS-START-MT         PIC X(02).                        
               10 FILLER              PIC X(01) VALUE '-'.              
               10 WS-START-DY         PIC X(02).                        
           05 WS-START-DATE-N.                                          
               10 WS-START-YR-N       PIC S9(4) USAGE COMP.             
               10 WS-START-MT-N       PIC S9(2) USAGE COMP.             
           05 WS-REV-MTH-PLUS-1.                                        
               10 WS-REV-P-1-YR       PIC 9(4).                         
               10 WS-REV-P-1-MM       PIC 9(2).                         
A05094     05 WS-PNDG-OPT-REV-MTH.                                      
A05094         10 WS-PNDG-REV-YR      PIC 9(4).                         
A05094         10 WS-PNDG-REV-MM      PIC 9(2).                         
           05 WS-EXIT-FEE-AMT-N       PIC 9(11) VALUE ZERO.             
           05 WS-EXIT-FEE-AMT-D  REDEFINES                              
              WS-EXIT-FEE-AMT-N       PIC S9(5)V999999.                 
           05 WS-AGRD-THERM-N         PIC 9(11) VALUE ZERO.             
           05 WS-AGRD-THERM-D    REDEFINES                              
              WS-AGRD-THERM-N         PIC S9(5)V999999.                 
           05 WS-GROUP2-MOVE          PIC 9(6)  VALUE 0.                
           05 WS-GROUP2-RED REDEFINES WS-GROUP2-MOVE.                   
               10 WS-GROUP2-YYYY      PIC 9(4).                         
               10 WS-GROUP2-MM        PIC 9(2).                         
           05 WS-GRP2-MOVE-DATE.                                        
               10 WS-GRP2-YYYY        PIC X(04) VALUE SPACE.            
               10  FILLER             PIC X(01) VALUE '-'.              
               10 WS-GRP2-MM          PIC X(02) VALUE SPACE.            
               10 FILLER              PIC X(01) VALUE '-'.              
               10 WS-GRP2-DD          PIC X(02) VALUE SPACE.            
P00172     05 WS-APPL-PROGRAM-ID      PIC X(08) VALUE SPACES.           
P00680     05 WS-FCTR-ADJUST-ELEMENT  PIC X(01).                        
P00680         88 ADD-TO-COMPONENT-AMT          VALUE 'A'.              
P00680         88 ADD-TO-NET-RATE               VALUE 'C'.              
P00680         88 REPL-NET-RATE                 VALUE 'F'.              
P00680         88 SUB-FROM-NET-RATE             VALUE 'J'.              
COB305     05 WS-ACCT-TYP-MIN-PRICE        PIC S9(3)V9(6) USAGE COMP-3 
COB305       VALUE 0.      
A05094     05 WS-TMP-OPT-CD           PIC X(12) VALUE SPACES.           
A05094     05 RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.          
P00892     05 WS-AUTO-REN-OPT-IN-FL   PIC X(01) VALUE SPACES.           
P805AP     05 WS-ACCT-ATTRIBUTE-FL    PIC X(01).                        
P805AP     05 WS-ADV-PRC-INCTV-FL     PIC X(01).                        
P805AP     05 WS-PREV-STATUS-CD       PIC X(01).                        
P805AP     05 WS-PREV-ATTR-VALUE-DT   PIC X(10).                        
P805AP     05 WS-ADV-PRC-INCTV-VALUE  PIC 9(2).                         
P805AP     05 WS-COMMON-DATE-MONTH    PIC X(02) VALUE SPACES.           
P805AP     05 WS-COMMON-DATE-MONTH-N  REDEFINES                         
P805AP        WS-COMMON-DATE-MONTH    PIC 9(2).                         
P805AP     05 WS-INCTV-DATE.                                            
P805AP        10 WS-INCTV-YR         PIC X(04).                         
P805AP        10 FILLER              PIC X(01) VALUE '-'.               
P805AP        10 WS-INCTV-MT         PIC X(02).                         
P805AP        10 FILLER              PIC X(01) VALUE '-'.               
P805AP        10 WS-INCTV-DY         PIC X(02) VALUE '01'.              
P805AP     05 WS-INCTV-YEAR      PIC X(02) VALUE SPACES.                
P805AP     05 WS-INCTV-YEAR-N REDEFINES WS-INCTV-YEAR PIC 9(2).         
                                                                        
      ******************************************************************        
      * Note: This is hold work area, when CPD00326 is called from     *        
      *       batch pgms. CPD00326 will not intialize this group data  *        
      *       item.                                                    *        
      ******************************************************************        
P00211 01  WS-326-KEEP-VARS.                                            
           05 WS-COMMON-DATE          PIC X(10) VALUE SPACES.           
P00141     05 WS-COMMON-DATE-HQ       PIC X(10) VALUE SPACES.           
           05 WS-BUSINESS-NEXT-DAY    PIC X(10) VALUE SPACES.           
           05 WS-COM-REV-MONTH-01     PIC X(10) VALUE SPACES.           
           05 WS-COM-REV-MTH-NEXT-FMT PIC X(10) VALUE SPACES.           
           05 WS-COM-REV-MTH-PREV     PIC X(06) VALUE SPACES.           
           05 WS-COM-REV-MTH-PREV-01  PIC X(10) VALUE SPACES.           
           05 WS-COM-REV-MONTH        PIC X(06) VALUE SPACES.           
           05 WS-COM-REV-MTH-NEXT     PIC X(06) VALUE SPACES.           
                                                                        
P00211 01  WS-326-KEEP-SWITCHES.                                        
P00211     05 WS-FIRST-CALL           PIC X(01) VALUE 'Y'.              
P00211        88 FIRST-CALL                     VALUE 'Y'.              
P00211        88 NOT-FIRST-CALL                 VALUE 'N'.              
                                                                        
       01  WS-CSR02294-VARS.                                            
           05  I-ACCOUNT-NO           PIC X(13).                        
           05  I-ITEM-ID              PIC S9(09) COMP.                  
           05  I-RECV-TYPE            PIC X(03)  VALUE SPACES.          
           05  I-PYMT-PRIORITY-LVL    PIC S9(04) COMP VALUE ZERO.       
           05  I-GL-ACCT-NO           PIC X(07)  VALUE SPACES.          
           05  I-CR-AMT-DAY-00        PIC X(11)  VALUE SPACES.          
           05  I-CR-AMT-DAY-30        PIC X(11)  VALUE SPACES.          
           05  I-CR-AMT-DAY-60        PIC X(11)  VALUE SPACES.          
           05  I-CR-AMT-DAY-90        PIC X(11)  VALUE SPACES.          
           05  I-CR-AMT-TOTAL         PIC X(11)  VALUE SPACES.          
           05  I-DIST-AR-TYPE-SHORT   PIC X(03)  VALUE SPACES.          
           05  I-DIST-PYMT-PRI-LVL    PIC S9(04) COMP VALUE ZERO.       
           05  I-DIST-ITEM-ID         PIC S9(09) COMP VALUE ZERO.       
           05  I-RESP-AREA-ID         PIC X(03)  VALUE SPACES.          
           05  I-USER-ID              PIC X(07)  VALUE SPACES.          
           05  I-AT-LAST-UPDATE-TS    PIC X(26)  VALUE SPACES.          
           05  I-AC-LAST-UPDATE-TS    PIC X(26)  VALUE SPACES.          
           05  I-TRANS-LEN            PIC S9(4)  COMP SYNC VALUE +0.    
           05  I-TRANS-COMMENTS       PIC X(210) VALUE SPACES.          
           05  I-PRINCIPAL            PIC X(11)  VALUE SPACES.          
           05  I-STATE-TAX            PIC X(11)  VALUE SPACES.          
           05  I-CITY-TAX             PIC X(11)  VALUE SPACES.          
           05  I-OTHER-TAX            PIC X(11)  VALUE SPACES.          
           05  I-DEF-INT              PIC X(11)  VALUE SPACES.          
           05  I-EARNED-INT           PIC X(11)  VALUE SPACES.          
           05  I-CNT-NAME-CD          PIC S9(04) COMP VALUE 0.          
           05  I-REVENUE-MONTH        PIC X(06)  VALUE SPACES.          
           05  O-RETURN-CODE          PIC S9(9)  COMP VALUE 0.          
           05  O-CANCELDNP-FLAG       PIC X(01)  VALUE SPACES.          
           05  O-AR-LOCKOUT-IND       PIC X(01)  VALUE SPACES.          
           05  O-AT-ACCT-XFER-TO      PIC X(13)  VALUE SPACES.          
           05  O-CANCELNOT-FLAG       PIC X(01)  VALUE SPACES.          
                                                                        
       01  WS-CSR00028-VARS.                                            
           10 P-RETURN-CODE           PIC S9(09) COMP VALUE +0.         
                                                                        
      *01  LOC1                     USAGE IS SQL TYPE IS                
      *                             RESULT-SET-LOCATOR VARYING.         
      *01  LOC2                     USAGE IS SQL TYPE IS                
      *                             RESULT-SET-LOCATOR VARYING.         
                                                                        
       01  WS-326-LITERALS.                                             
           05 WS-I                    PIC X(01) VALUE 'I'.              
           05 WS-U                    PIC X(01) VALUE 'U'.              
P00211     05 WS-SET-PEND-OPT         PIC X(01) VALUE 'P'.              
A05094     05 WS-PNDG-TO-ACTIVE       PIC X(01) VALUE 'A'.              
           05 BEACON-SCORE            PIC X(01) VALUE 'B'.              
           05 ACCOUNT-ATTR            PIC X(01) VALUE 'A'.              
           05 KEEP-FACTOR             PIC X(01) VALUE 'K'.              
P00211     05 WS-CANCEL               PIC X(01) VALUE 'K'.              
P00579     05 WS-COMMERCIAL           PIC X(01) VALUE 'C'.              
           05 TRANS-DRIVER-CALL       PIC X(08) VALUE 'CSR02380'.       
P00211     05 POST-BILLING-PGM        PIC X(08) VALUE 'PCSCA296'.       
P00892     05 WAUSAU-PGM              PIC X(08) VALUE 'PCSCA005'.       
P00892     05 PRE-BILLING-PGM         PIC X(08) VALUE 'PCSCA290'.       
           05 CRM-CALL                PIC X(08) VALUE 'CRM'.            
P680PN     05 CRM-NEG-CALL            PIC X(08) VALUE 'CRMN'.           
P00579     05 CRC-CALL                PIC X(08) VALUE 'CRC'.            
P680PN     05 CRC-NEG-CALL            PIC X(08) VALUE 'CRCN'.           
           05 CRS-CALL                PIC X(08) VALUE 'RS'.             
P680PN     05 CRS-NEG-CALL            PIC X(08) VALUE 'RSN'.            
           05 WEB-CALL                PIC X(08) VALUE 'WEB'.            
           05 CSR-CALL                PIC X(08) VALUE 'CSR'.            
P680PN     05 CSR-NEG-CALL            PIC X(08) VALUE 'CSRN'.           
P00680     05 ADJUST-RATE-CALL        PIC X(08) VALUE 'RSA'.            
A05051     05 BATCH-CALL-PGM          PIC X(08) VALUE 'PCSCA296'.       
           05 WS-CALL-TYPE            PIC X(01) VALUE 'C'.              
           05 INCNTV-ONLY-CALL        PIC X(01) VALUE 'I'.              
           05 COMBO-VAR-FACTOR        PIC X(02) VALUE 'CV'.             
           05 COMBO-FIX-FACTOR        PIC X(02) VALUE 'CF'.             
I00631     05 FIXED-FACTOR            PIC X(02) VALUE 'FF'.             
           05 OTHER-INCENTIVES        PIC X(02) VALUE 'IN'.             
           05 MISC-CREDIT             PIC X(02) VALUE 'MC'.             
           05 MISC-DEBIT              PIC X(09) VALUE 'MD'.             
           05 INCENTIVE               PIC X(09) VALUE 'IN'.             
           05 BEACON-ADJ-FCTR         PIC X(09) VALUE 'BCN00520'.       
           05 WS-SQL-ERROR            PIC X(08) VALUE 'CM1...'.         
           05 WS-RECV-TYPE            PIC X(03) VALUE 'MIS'.            
           05 BFC-ADJ-FACTOR          PIC X(09) VALUE 'BFCADJ001'.      
           05 BFC-CRM-FACTOR          PIC X(09) VALUE 'BCNADJ'.         
           05 NEW-SIGNUP              PIC X(01) VALUE 'N'.              
           05 EXIT-FEE                PIC X(09) VALUE 'EXIT FEE'.       
           05 SO-TRANS-DRIVER         PIC X(08) VALUE 'CSR02380'.       
           05 SP-CALD-FRM-WEB         PIC X(08) VALUE 'CSR0398W'.       
           05 SP-CALD-FRM-CSR         PIC X(08) VALUE 'CSR0398D'.       
           05 SP-CALD-FRM-CRM         PIC X(08) VALUE 'CSR0398C'.       
           05 SP-CALD-FRM-CRM-REG     PIC X(08) VALUE 'CSR039CR'.       
           05 SP-CALD-FRM-CRS         PIC X(08) VALUE 'CSR0398S'.       
           05 SP-CALD-FRM-CRS-REG     PIC X(08) VALUE 'CSR039SR'.       
P00680     05 SP-CALD-FRM-RT-ADJSTMNT PIC X(08) VALUE 'CSR0398F'.       
           05 SP-CALD-FRM-BTH         PIC X(08) VALUE 'PCSCA296'.       
           05 SP-CALD-FRM-TRNS-DRVR   PIC X(08) VALUE 'CSR02380'.       
           05 AGL-SENIOR-ATTR         PIC X(18)                         
                                         VALUE 'AGL DISCOUNT SR'.       
P00680     05 ADJUST-RATE-INCTV-TYPE  PIC X(15)                         
P00680                                   VALUE 'ADJUSTABLE RATE'.       
P00680     05 PRICE-ADDER-INCTV-TYPE  PIC X(15)                         
P00680                                   VALUE 'PRICE ADDER'.           
P00680     05 PRICE-DSCNT-INCTV-TYPE  PIC X(15)                         
P00680                                   VALUE 'PRICE DISCOUNT'.        
P00680     05 FIXED-PRICE-INCTV-TYPE  PIC X(15)                         
P00680                                   VALUE 'FIXED PRICE'.           
P00211     05 WS-INVALID-WQ-CMNTS     PIC X(250) VALUE                  
P00211          'PENDING OPTION SET TO ACTIVE. VERIFY FACTOR DATES.'.   
           05 ARREARS-CREDIT-GRP      PIC X(01) VALUE 'A'.              
           05 BALANCE-CREDIT-GRP      PIC X(01) VALUE 'B'.              
           05 GROUP1-CUSTOMER         PIC X(03) VALUE '100'.            
           05 GROUP2-CUSTOMER         PIC X(03) VALUE '200'.            
I00113     05 SCANA-SR-DEFLT-FLAG     PIC X(01) VALUE 'S'.              
I00113     05 FIXED-PRICE-OPT         PIC X(02) VALUE 'FP'.             
I00113     05 VAR-PRICE-OPT           PIC X(02) VALUE 'VP'.             
P00211     05 WS-SYSTEM               PIC X(08) VALUE 'SYSTEM'.         
P00453     05 WS-PRP-DEFAULT-TIER     PIC X(20) VALUE                   
P00453                                          'PRP-DEFAULT-TIER'.     
                                                                        
       01  WS-326-NULL-IND.                                             
           05 WS-NULL-IND-01          PIC S9(4) COMP.                   
           05 WS-NULL-IND-02          PIC S9(4) COMP.                   
           05 WS-NULL-IND-03          PIC S9(4) COMP.                   
           05 WS-NULL-IND-04          PIC S9(4) COMP.                   
           05 WS-NULL-IND-05          PIC S9(4) COMP.                   
           05 WS-NULL-IND-06          PIC S9(4) COMP.                   
           05 WS-NULL-IND-07          PIC S9(4) COMP.                   
           05 WS-NULL-IND-08          PIC S9(4) COMP.                   
           05 WS-NULL-IND-09          PIC S9(4) COMP.                   
           05 WS-NULL-IND-10          PIC S9(4) COMP.                   
           05 WS-NULL-IND-11          PIC S9(4) COMP.                   
           05 WS-NULL-IND-12          PIC S9(4) COMP.                   
           05 WS-NULL-IND-13          PIC S9(4) COMP.                   
           05 WS-NULL-IND-14          PIC S9(4) COMP.                   
           05 WS-NULL-IND-15          PIC S9(4) COMP.                   
           05 WS-NULL-IND-16          PIC S9(4) COMP.                   
           05 WS-NULL-IND-17          PIC S9(4) COMP.                   
           05 WS-NULL-IND-18          PIC S9(4) COMP.                   
           05 WS-NULL-IND-19          PIC S9(4) COMP.                   
           05 WS-NULL-IND-20          PIC S9(4) COMP.                   
P00211     05 WS-NULL-IND-21          PIC S9(4) COMP.                   
P00211     05 WS-NULL-IND-22          PIC S9(4) COMP.                   
P00211     05 WS-NULL-IND-23          PIC S9(4) COMP.                   
P00211     05 WS-NULL-IND-24          PIC S9(4) COMP.                   
P00245     05 WS-NULL-IND-25          PIC S9(4) COMP.                   
                                                                        
P00211 01  WS-326-SWITCHES.                                             
           05 WS-OTHER-FACTORS        PIC X(01) VALUE SPACES.           
              88 OTHER-FACTOR-EXISTS            VALUE 'Y'.              
              88 OTHER-FACTOR-NOT-EXISTS        VALUE 'N'.              
A05094     05 WS-NO-MORE-ROWS-326     PIC X(01) VALUE 'N'.              
A05094        88 NO-MORE-ROWS-326               VALUE 'Y'.              
           05 WS-INSERT-FACTOR-ROW    PIC X(01) VALUE 'N'.              
              88 INSERT-FACTOR-ROW              VALUE 'Y'.              
           05 WS-OK-TO-DELETE-FACTOR  PIC X(01) VALUE 'N'.              
              88 OK-TO-DELETE-FACTOR            VALUE 'Y'.              
           05 WS-CNSMPTN-FOUND        PIC X(01) VALUE 'N'.              
              88 CNSMPTN-FOUND                  VALUE 'Y'.              
           05 WS-READ-CYCLE-FOUND     PIC X(01) VALUE 'N'.              
              88 READ-CYCLE-FOUND               VALUE 'Y'.              
           05 WS-BFC-ADJ-FACTOR       PIC X(01) VALUE 'N'.              
              88 BFC-ADJ-FACTOR-EXISTS          VALUE 'Y'.              
           05 WS-REGULATED            PIC X(03) VALUE SPACES.           
              88 REGULATED-GRP1                 VALUE '100'.            
              88 REGULATED-GRP2                 VALUE '200'.            
           05 WS-ONERATE-RENEW-FL     PIC X(01) VALUE 'N'.              
              88 ACCT-OPEN-FOR-RENWL            VALUE 'Y'.              
           05 WS-EXPIRE-NEW-FCTR      PIC X(01) VALUE 'N'.              
              88 EXPIRE-NEW-FCTR                VALUE 'Y'.              
           05 WS-ONERATE-ACCT         PIC X(01) VALUE 'N'.              
              88 ACCT-ON-ONERATE                VALUE 'Y'.              
           05 WS-BATCH-PROGRAM        PIC X(08) VALUE SPACES.           
              88 SO-BATCH-PGM                   VALUE 'CSR02380'.       
           05 WS-DHR-CUSTOMER         PIC X(01) VALUE 'N'.              
              88 DHR-CUTOMER                    VALUE 'Y'.              
              88 NON-DHR-CUSTOMER               VALUE 'N'.              
           05 WS-GRP2-DATE-CHNGD      PIC X(01) VALUE 'N'.              
              88 GRP2-DATE-CHNGD                VALUE 'Y'.              
           05 WS-FRCST-CREDIT         PIC X(01) VALUE 'N'.              
              88 FRCST-CREDIT                   VALUE 'Y'.              
           05 WS-CRED-GRP-MOVE        PIC X(03) VALUE SPACES.           
              88 ARREAR-2-BALANCE               VALUE 'A2B'.            
              88 BALANCE-2-ARREAR               VALUE 'B2A'.            
           05 WS-BEACON-SCR-EXISTS    PIC X(01) VALUE 'N'.              
              88 BEACON-SCR-EXISTS              VALUE 'Y'.              
           05 WS-REGULATED-ACCOUNT    PIC X(01) VALUE 'N'.              
              88 REGULATED-ACCOUNT              VALUE 'Y'.              
           05 WS-SET-RENEWAL-MSG      PIC X(01) VALUE 'N'.              
              88 SET-RENEWAL-MSG                VALUE 'Y'.              
           05 WS-BUSINESS-DAY-FOUND   PIC X(01) VALUE 'N'.              
              88 BUSINESS-DAY-FOUND             VALUE 'Y'.              
I00113     05 WS-CUSTOMER-ON-SR-TIER  PIC X(01) VALUE 'N'.              
I00113        88 CUSTOMER-ON-SR-TIER            VALUE 'Y'.              
P00211     05 WS-CPD326-CALL-TYPE     PIC X(01) VALUE SPACES.           
P00211        88 CPD326-ONLINE-CALL             VALUE 'O'.              
P00211        88 CPD326-BATCH-CALL              VALUE 'B'.              
P00211     05 WS-INVALID-FACTOR       PIC X(01) VALUE SPACES.           
P00211        88 INVALID-FACTOR                 VALUE 'Y'.              
P00680     05 WS-ADJUSTABLE-OPTION-FL PIC X(01) VALUE SPACES.           
P00680        88 ADJUSTABLE-OPTION              VALUE 'Y'.              
P00680     05 WS-FACTOR-UPDATE-TYPE   PIC X(01) VALUE SPACES.           
P00680        88 FACTOR-DATE-UPDT               VALUE 'A'.              
P00680        88 FACTOR-VALUE-UPDT              VALUE 'B'.              
P00680        88 FACTOR-DURATION-UPDT           VALUE 'C'.              
P00680        88 FACTOR-DATE-DURATION-UPDT      VALUE 'D'.              
P680P2     05 WS-INSERT-3F-DET-SW     PIC X(01).                        
P680P2        88 DONT-INSERT-3F-DET             VALUE 'N'.              
P680P2        88 INSERT-3F-DET                  VALUE 'Y'.              
                                                                        
      *****************************************************************         
      *    CURSOR DECLARATIONS.                                       *         
      *****************************************************************         
           EXEC SQL                                                     
             DECLARE CRM_ATTR_INCTV CURSOR FOR                          
                SELECT HQ.RT_ATTR_INCTV_TYPE                            
                      ,HQ.DURATION_NO                                   
                      ,HQ.FACTOR_ID                                     
                      ,HQ.ATTR_INCTV_VALUE                              
                      ,HQ.GL_ACCT_CREDIT                                
                      ,HQ.GL_ACCT_DEBIT                                 
                      ,HQ.CATEGORY_ID                                   
                      ,HQ.WQ_ROUTE_CATEGORY                             
                      ,HQ.APPL_PROGRAM_ID                               
                      ,HQ.ATTR_INCTV_VAL_TX                             
                      ,HQ.PRIMRY_OPT_ATTR_FL                            
                      ,HQ.OPT_CHG_ACTION_CD                             
                      ,G7.SOURCE_CD                                     
                      ,G7.STATUS_CD                                     
                  FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)              
                      ,CRM_RT_ATTR_INCTV  G7 WITH(READUNCOMMITTED)              
                 WHERE HQ.OPTION_CD          = :HQ-OPTION-CD            
                   AND G7.RT_ATTR_INCTV_TYPE = HQ.RT_ATTR_INCTV_TYPE    
P00211             AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )  
P00211             AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )   
P00473             AND HQ.PROC_STATUS_CD     = 'AC'                     
P00473             AND HQ.OPT_ATTR_VSTART_TS = (                        
P00473               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                  
P00473                 FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)         
P00473                WHERE H1.OPTION_CD    = HQ.OPTION_CD              
P00473                  AND H1.RT_ATTR_INCTV_TYPE                       
P00473                                      = HQ.RT_ATTR_INCTV_TYPE     
P00473                  AND H1.ATTR_INCTV_STRT_DT                       
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
P00473                  AND H1.ATTR_INCTV_END_DT                        
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )     
P00473                  AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                 
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
P00473                  AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                   
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )     
P00473                  AND H1.PROC_STATUS_CD      = 'AC')              
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CRM_ATTR_INCTV CURSOR FOR                                  
MFA-TR*         SELECT HQ.RT_ATTR_INCTV_TYPE                                    
MFA-TR*               ,HQ.DURATION_NO                                           
MFA-TR*               ,HQ.FACTOR_ID                                             
MFA-TR*               ,HQ.ATTR_INCTV_VALUE                                      
MFA-TR*               ,HQ.GL_ACCT_CREDIT                                        
MFA-TR*               ,HQ.GL_ACCT_DEBIT                                         
MFA-TR*               ,HQ.CATEGORY_ID                                           
MFA-TR*               ,HQ.WQ_ROUTE_CATEGORY                                     
MFA-TR*               ,HQ.APPL_PROGRAM_ID                                       
MFA-TR*               ,HQ.ATTR_INCTV_VAL_TX                                     
MFA-TR*               ,HQ.PRIMRY_OPT_ATTR_FL                                    
MFA-TR*               ,HQ.OPT_CHG_ACTION_CD                                     
MFA-TR*               ,G7.SOURCE_CD                                             
MFA-TR*               ,G7.STATUS_CD                                             
MFA-TR*           FROM CRM_OPT_ATTR_INCTV HQ                                    
MFA-TR*               ,CRM_RT_ATTR_INCTV  G7                                    
MFA-TR*          WHERE HQ.OPTION_CD          = :HQ-OPTION-CD                    
MFA-TR*            AND G7.RT_ATTR_INCTV_TYPE = HQ.RT_ATTR_INCTV_TYPE            
MFA-TR*            AND HQ.ATTR_INCTV_STRT_DT <= :HQ-ATTR-INCTV-STRT-DT          
MFA-TR*            AND HQ.ATTR_INCTV_END_DT  >= :HQ-ATTR-INCTV-END-DT           
MFA-TR*            AND HQ.PROC_STATUS_CD     = 'AC'                             
MFA-TR*            AND HQ.OPT_ATTR_VSTART_TS = (                                
MFA-TR*              SELECT MAX(H1.OPT_ATTR_VSTART_TS)                          
MFA-TR*                FROM CRM_OPT_ATTR_INCTV H1                               
MFA-TR*               WHERE H1.OPTION_CD    = HQ.OPTION_CD                      
MFA-TR*                 AND H1.RT_ATTR_INCTV_TYPE                               
MFA-TR*                                     = HQ.RT_ATTR_INCTV_TYPE             
MFA-TR*                 AND H1.ATTR_INCTV_STRT_DT                               
MFA-TR*                                    <= :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*                 AND H1.ATTR_INCTV_END_DT                                
MFA-TR*                                    >= :HQ-ATTR-INCTV-END-DT             
MFA-TR*                 AND DATE(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                                    <= :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*                 AND DATE(H1.OPT_ATTR_VEND_TS)                           
MFA-TR*                                    >= :HQ-ATTR-INCTV-END-DT             
MFA-TR*                 AND H1.PROC_STATUS_CD      = 'AC')                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    RETRIEVES ALL OTHER FACTORS APPLIED TO RATES.              *         
      *****************************************************************         
           EXEC SQL                                                     
             DECLARE OTHR_FACTORS CURSOR FOR                            
                SELECT SF.FACTOR_ID                                     
                  FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                   
                      ,CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)              
                 WHERE SF.FACTOR_ID      = SA.FACTOR_ID                 
                   AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE           
                   AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO             
                   AND SA.CODE_STATUS    = 'A'                          
                   AND SA.DATE_TO        >= IIF(TRY_CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-TO) <> 0) OR (LEN(
                                                            :SA-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:SA-DATE-TO), CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) )                 
                   AND SF.FACTOR_TYPE IN ('F','V')                      
                   AND SF.FACTOR_ID NOT IN (                            
                       SELECT HQ.FACTOR_ID                              
                         FROM CRM_OPT_ATTR_INCTV HQ
                           WITH(READUNCOMMITTED)                     
P00473                  WHERE HQ.PROC_STATUS_CD  = 'AC'                 
                                           )                            
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE OTHR_FACTORS CURSOR FOR                                    
MFA-TR*         SELECT SF.FACTOR_ID                                             
MFA-TR*           FROM CSS_SPCL_FCTR SF                                         
MFA-TR*               ,CSS_SPCL_FCTR_APPL SA                                    
MFA-TR*          WHERE SF.FACTOR_ID      = SA.FACTOR_ID                         
MFA-TR*            AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                   
MFA-TR*            AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                     
MFA-TR*            AND SA.CODE_STATUS    = 'A'                                  
MFA-TR*            AND SA.DATE_TO        >= :SA-DATE-TO                         
MFA-TR*            AND SF.FACTOR_TYPE IN ('F','V')                              
MFA-TR*            AND SF.FACTOR_ID NOT IN (                                    
MFA-TR*                SELECT HQ.FACTOR_ID                                      
MFA-TR*                  FROM CRM_OPT_ATTR_INCTV HQ                             
MFA-TR*                 WHERE HQ.PROC_STATUS_CD  = 'AC'                         
MFA-TR*                                    )                                    
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    RETRIEVES ALL FIXED FACTOR.                                *         
      *****************************************************************         
           EXEC SQL                                                     
             DECLARE FIXED_FCTR CURSOR FOR                              
                SELECT DISTINCT FF.ACCOUNT_NO                           
                      ,FF.CODE_UTIL_TYPE                                
                      ,FF.IC_NO                                         
                      ,FF.FACTOR_ID                                     
                      ,FF.EFF_DATE_FROM                                 
                      ,FF.CMPNT_ID_CD                                   
                      ,FF.CODE_SEASON                                   
                      ,FF.INSTR_USE_TYPE_CD                             
                      ,FF.CODE_TIME_PERIOD                              
                      ,FF.EFF_DATE_TO                                   
                      ,FF.FIXED_FCTR_TYP_CD                             
                      ,FF.FACTOR                                        
                      ,FF.FIXED_FCTR_SEQ_NO                             
                      ,FF.DURATION_REMAIN_NO                            
P00680                ,SF.ADJUST_ELEMENT                                
P00680                ,HQ.RT_ATTR_INCTV_TYPE                            
                  FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                  
P00211                ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)               
P00680                ,CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                   
P00680                ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)              
                 WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO           
                   AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE       
                   AND FF.IC_NO              = :FF-IC-NO                
P00211             AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO    
P00211             AND DF.ACCOUNT_NO         = FF.ACCOUNT_NO            
P00211             AND DF.CODE_UTIL_TYPE     = FF.CODE_UTIL_TYPE        
P00211             AND DF.IC_NO              = FF.IC_NO                 
P00211             AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO     
P00141             AND HQ.OPTION_CD          = DF.OPTION_CD             
P00141             AND HQ.FACTOR_ID          = FF.FACTOR_ID             
P00473             AND HQ.PROC_STATUS_CD     = 'AC'                     
P00680             AND SF.FACTOR_ID          = FF.FACTOR_ID             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FIXED_FCTR CURSOR FOR                                      
MFA-TR*         SELECT DISTINCT FF.ACCOUNT_NO                                   
MFA-TR*               ,FF.CODE_UTIL_TYPE                                        
MFA-TR*               ,FF.IC_NO                                                 
MFA-TR*               ,FF.FACTOR_ID                                             
MFA-TR*               ,FF.EFF_DATE_FROM                                         
MFA-TR*               ,FF.CMPNT_ID_CD                                           
MFA-TR*               ,FF.CODE_SEASON                                           
MFA-TR*               ,FF.INSTR_USE_TYPE_CD                                     
MFA-TR*               ,FF.CODE_TIME_PERIOD                                      
MFA-TR*               ,FF.EFF_DATE_TO                                           
MFA-TR*               ,FF.FIXED_FCTR_TYP_CD                                     
MFA-TR*               ,FF.FACTOR                                                
MFA-TR*               ,FF.FIXED_FCTR_SEQ_NO                                     
MFA-TR*               ,FF.DURATION_REMAIN_NO                                    
MFA-TR*               ,SF.ADJUST_ELEMENT                                        
MFA-TR*               ,HQ.RT_ATTR_INCTV_TYPE                                    
MFA-TR*           FROM CSS_FIXED_FCTR FF                                        
MFA-TR*               ,CSS_ACCT_RTPK_AGR DF                                     
MFA-TR*               ,CSS_SPCL_FCTR SF                                         
MFA-TR*               ,CRM_OPT_ATTR_INCTV HQ                                    
MFA-TR*          WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                   
MFA-TR*            AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE               
MFA-TR*            AND FF.IC_NO              = :FF-IC-NO                        
MFA-TR*            AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO            
MFA-TR*            AND DF.ACCOUNT_NO         = FF.ACCOUNT_NO                    
MFA-TR*            AND DF.CODE_UTIL_TYPE     = FF.CODE_UTIL_TYPE                
MFA-TR*            AND DF.IC_NO              = FF.IC_NO                         
MFA-TR*            AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO             
MFA-TR*            AND HQ.OPTION_CD          = DF.OPTION_CD                     
MFA-TR*            AND HQ.FACTOR_ID          = FF.FACTOR_ID                     
MFA-TR*            AND HQ.PROC_STATUS_CD     = 'AC'                             
MFA-TR*            AND SF.FACTOR_ID          = FF.FACTOR_ID                     
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      ** END OF COPYBOOK CWS0326A                                    **         
      *****************************************************************         
