      ***************************************************************           
      ***************************************************************           
      *  CWS00223    DEPOSIT INTEREST CALCULATION                   *           
      *                                                             *           
      ***************************************************************           
      *                 P R O G R A M  S U M M A R Y                *           
      *                                                             *           
      *  THIS WORKING STORAGE SUPPORTS THE DEPOSIT INTEREST         *           
      *  CALCULATION ROUTINE (CPD0023B).                            *           
      *                                                             *           
      ***************************************************************           
      *                                                             *           
      *                  PROGRAM MODIFICATION LOG                   *           
      *                                                             *           
      *    DATE     INITIALS     COMMENTS                           *           
      *  --------   --------     ---------------------------------  *           
      *  10/09/95     JHR        COPYBOOK ORIGINALLY CODED.         *           
      *  06/27/95     CDS        TPR 3753 ADD COMPOUND INTEREST CALC*           
PCR482*  02/05/97     MAD        MODIFICATIONS MADE TO SUPPORT      *           
      *                          DEPOSIT INTEREST PROJECTIONS ON    *           
      *                          PANEL 57.                          *           
MAD617*  06/17/97     MAD        DEP-PAY-HST CURSOR SHOULD BE       *           
      *                          ORDERED BY DEP_PAY_DT ASCENDING -  *           
      *                          CPD00023 IS CHECKING FIELD TO      *           
      *                          DETERMINE IF THE PAYMENT IS > 6    *           
      *                          MONTHS OLD. OLDEST DEPOSIT PAYMENT *           
      *                          SHOULD BE SELECTED FIRST TO JUMP   *           
      *                          OUT OF THE LOOP QUICKLY.           *           
T23183*  05/03/01     KS88119    ADDED TWO VARIABLES USED FOR PSNC  *           
      *                          DEPOSIT INTEREST CALCULATIONS      *           
C25619*   11/14/01     SR82046  INTEREST CALCULATION FOR PSNC IS    *           
      *                         CHANGED TO CALCULATE FROM 90 DAYS   *           
      *                         FROM THE DEPOSIT PAID IN FULL       *           
C29752*   11/18/03    MDJ       ADDED MULT INT RATE INDICATOR AND   *           
      *                         WORKING STORAGE FIELD FOR PREV INT  *           
      *                         RATE.                               *           
      *                         ADDED WS-DATE-TEMP-CPD23 FOR PREV   *           
      *                         DATE CALCULATIONS.                  *           
C29752*   01/11/03    MDJ       ADDED SWITCH TO INDICATE IF INT WAS *           
      *                         RECALCULATED DUE TO PARTIAL REFUND  *           
      *                         MADE IN THE PAST.                   *           
T31755*   11/16/04    CVNS      ADDED A VARIABLE USED FOR TO RETRIEV*           
      *               CHENNAI   DEPOSIT AMT                         *           
      *                                                             *           
      ***************************************************************           
      ***************************************************************           
                                                                        
           05  WS-INTEREST-RATE-TABLE.                                  
               10  WS-INTEREST-RATE-DATA OCCURS 10 TIMES                
                   INDEXED BY WS-INT-INDX.                              
                   15  WS-LOCAL-OFFICE      PIC X(03).                  
                   15  WS-TAX-DISTRICT      PIC X(03).                  
                   15  WS-EFF-DATE-FROM     PIC X(10).                  
                   15  WS-EFF-DATE-TO       PIC X(10).                  
COB305             15 WS-INTRST-RATE        PIC S99V9999 COMP-3 VALUE 0.        
                                                                        
PCR482     05  WS-PROG-SWITCH.                                          
PCR482         10  WS-S031-CALL-SWITCH      PIC X(01)   VALUE 'N'.      
PCR482             88  S031-IS-CALLING-PROG             VALUE 'Y'.      
PCR482             88  S031-NOT-CALLING-PROG            VALUE 'N'.      
C29752         10  WS-RECALC-SWITCH         PIC X(01)   VALUE 'N'.      
C29752             88  INT-WAS-RECALCULATED             VALUE 'Y'.      
C29752             88  INT-WAS-NOT-RECALCULATED         VALUE 'N'.      
                                                                        
           05  WS-CALCULATIONS.                                         
               10  WS-ONE-YEAR              PIC S9(03) COMP VALUE 365.  
               10  WS-NO-OF-DAYS            PIC S9(04) COMP-3           
                                                 VALUE ZERO.            
               10  WS-CURR-INTRST-CALC      PIC S9(09)V99 COMP-3        
                                                 VALUE ZERO.            
               10  WS-INTEREST-CALC         PIC S9(09)V99 COMP-3        
                                                 VALUE ZERO.            
               10  WS-COMPLX-INTRST-CALC    PIC S9(09)V99 COMP-3        
                                                 VALUE ZERO.            
               10  WS-EFF-DATE-END          PIC X(10) VALUE SPACES.     
               10  WS-EFF-DATE-TO-PREV      PIC X(10) VALUE SPACES.     
               10  WS-DATE-6-MNT-AGO        PIC X(10) VALUE SPACES.     
               10  WS-REFUND-DATE           PIC X(10) VALUE SPACES.     
               10  WS-DATE-INTST-CALC-FROM  PIC X(10) VALUE SPACES.     
               10  WS-DATE-FROM             PIC X(10) VALUE SPACES.     
               10  WS-DATE-TO               PIC X(10) VALUE SPACES.     
               10  WS-DATE-WORK             PIC X(10) VALUE SPACES.     
C29752         10  WS-DATE-TEMP-CPD23       PIC X(10) VALUE SPACES.     
T23183         10  WS-MIN-DEP-INT-DATE      PIC X(10) VALUE SPACES.     
T23183         10  WS-DATE-91-DAYS-AGO      PIC X(10) VALUE SPACES.     
C25619         10  WS-DATE-90-DAYS-AFTER    PIC X(10) VALUE SPACES.     
C25619         10  WS-PYMT-DATE             PIC X(10) VALUE SPACES.     
               10  WS-NULL-DEP-PAY-DT-IND   PIC S9(4) COMP VALUE 0.     
C25619         10  WS-NULL-DEP-CERT-DT-IND  PIC S9(4) COMP VALUE 0.     
               10  WS-AMOUNT-WORK           PIC S9(07)V99 COMP-3        
                                                 VALUE ZERO.            
               10  RS-LT-6-MOS-AGO          PIC X(01)   VALUE 'N'.      
               10  WS-BILL-IMMEDIATELY      PIC X(01)   VALUE 'Y'.      
                   88  WS-BILL-TOMOROW                  VALUE 'N'.      
C29872         10  WS-MULTIPLE-INT-IND      PIC X(01)   VALUE 'N'.      
C29752             88  WS-MULTIPLE-INT-RATES            VALUE 'Y'.      
               10  WS-NO-OF-ADD-DAYS        PIC S9(04) COMP             
                                                 VALUE ZERO.            
               10  WS-AMT-DEPOSIT-REF       PIC S9(07)V99 COMP-3        
                                                 VALUE ZERO.            
T31755         10  WS-AMT-DEPOSIT-23        PIC S9(07)V99 COMP-3        
T31755                                           VALUE ZERO.            
               10  WS-TOTAL-NO-OF-DAYS      PIC S9(05) COMP-3           
                                                 VALUE ZERO.            
               10  WS-PREV-TOTAL-NO-OF-DAYS PIC S9(05) COMP-3           
                                                 VALUE ZERO.            
               10  WS-0                     PIC 9(01) VALUE 0.          
COB305         10 WS-PREV-INTRST-RATE        PIC S99V9999 COMP-3 
COB305           VALUE 0.        
      ***************************************************************           
      *  CURSOR DECLARATIONS.                                       *           
      ***************************************************************           
                                                                        
           EXEC SQL                                                     
              DECLARE DEP-INT-RATE CURSOR FOR                           
               SELECT INTRST_RATE,                                      
                      EFF_DATE_FROM,                                    
                      DATEADD( DAY, -1, EFF_DATE_FROM )                         
                 FROM CSS_DEP_INT_RATE                                  
                WHERE LOCAL_OFFICE     = :P6-LOCAL-OFFICE               
                  AND REV_DISTRICT_CD  = :P6-REV-DISTRICT-CD            
                  AND COMPANY_NO       = :P6-COMPANY-NO                 
                  AND EFF_DATE_FROM   <= IIF(TRY_CONVERT(DATE, 
                                                      :P6-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :P6-EFF-DATE-FROM
              ) <> 0) OR (LEN(:P6-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :P6-EFF-DATE-FROM
              ), CONVERT(DATE, :P6-EFF-DATE-FROM) )              
             ORDER BY EFF_DATE_FROM DESC                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DEP-INT-RATE CURSOR FOR                                   
MFA-TR*        SELECT INTRST_RATE,                                              
MFA-TR*               EFF_DATE_FROM,                                            
MFA-TR*               EFF_DATE_FROM - 1 DAY                                     
MFA-TR*          FROM CSS_DEP_INT_RATE                                          
MFA-TR*         WHERE LOCAL_OFFICE     = :P6-LOCAL-OFFICE                       
MFA-TR*           AND REV_DISTRICT_CD  = :P6-REV-DISTRICT-CD                    
MFA-TR*           AND COMPANY_NO       = :P6-COMPANY-NO                         
MFA-TR*           AND EFF_DATE_FROM   <= :P6-EFF-DATE-FROM                      
MFA-TR*      ORDER BY EFF_DATE_FROM DESC                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE DEP-PAY-HST CURSOR FOR                            
               SELECT DEP_PAY_DT,                                       
                      DEP_PAY_AMT                                       
                 FROM CSS_DEP_PAY_HST                                   
                WHERE ACCOUNT_NO      = :DP-ACCOUNT-NO                  
                  AND DEPOSIT_CERT_NO = :DP-DEPOSIT-CERT-NO             
             ORDER BY DEP_PAY_DT ASC                                    
           END-EXEC.                                                    
