      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      **  THIS COPYBOOK IS USED IN CPD00168 AND MAKE SURE TO SYNC    **         
      **  WITH CWS00168 WHILE CHANGING                               **         
      **                                                             **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE          INITIALS  REASON                            **         
      *    ----          --------  ------                            **         
      *    01/04/16      MS7M727   CREATE NEW COPYBOOK               **         
      *                                                              **         
      *****************************************************************         
                                                                        
      *****************************************************************         
      ** CURSOR FOR GET TRANSACTION HISTORY                          **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE GET_TRANS_HIST CURSOR FOR                        
                 SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                              
                        DATE_TRANS,                                     
                        CODE_TRAN_TYPE,                                 
                        AMT_ORIG_ENTERED,                               
                        AMT_BILLED_UNPAID,                              
                        RECORD_ONLY_FL,                                 
                        APPL_PROGRAM_ID,                                
                        USER_ID                                         
                   FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                 
                  WHERE ACCOUNT_NO = :AR-ACCOUNT-NO AND                 
                       (TRANS_HIST_SEQ_NO BETWEEN CIS.CHAR2TIMESTAMP(
                                                        :WS-PREV-SEQ-NO
              )       
                                              AND CIS.CHAR2TIMESTAMP(
                                                        :WS-CURR-SEQ-NO
              ))      
               ORDER BY TRANS_HIST_SEQ_NO                               
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     12470036
MFA-TR*        DECLARE GET_TRANS_HIST CURSOR FOR                        12480036
MFA-TR*          SELECT TRANS_HIST_SEQ_NO,                              12490036
MFA-TR*                 DATE_TRANS,                                     12500036
MFA-TR*                 CODE_TRAN_TYPE,                                 12510036
MFA-TR*                 AMT_ORIG_ENTERED,                               12520036
MFA-TR*                 AMT_BILLED_UNPAID,                              12530036
MFA-TR*                 RECORD_ONLY_FL,                                 12540036
MFA-TR*                 APPL_PROGRAM_ID,                                12550036
MFA-TR*                 USER_ID                                         12560036
MFA-TR*            FROM CSS_AR_TRANS_HIST                               12570036
MFA-TR*           WHERE ACCOUNT_NO = :AR-ACCOUNT-NO AND                 12580036
MFA-TR*                (TRANS_HIST_SEQ_NO BETWEEN :WS-PREV-SEQ-NO       12590036
MFA-TR*                                       AND :WS-CURR-SEQ-NO)      12600036
MFA-TR*        ORDER BY TRANS_HIST_SEQ_NO                               12610036
MFA-TR*        FOR FETCH ONLY WITH UR                                   12620036
MFA-TR*    END-EXEC.                                                    12630036
      *                                                                         
      *****************************************************************         
      ** CURSOR FOR GET TRANSACTION HISTORY DETAILS                             
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
                DECLARE AR_TRN_HST_DET CURSOR FOR                       
                SELECT                                                  
                      TRAN_APPL_NO,                                     
                      CODE_AR_AGE,                                      
                      GL_ACCT_CREDIT,                                   
                      GL_ACCT_DEBIT,                                    
                      AMT_POSTED,                                       
                      ITEM_ID,                                          
                      CODE_CONTRACT_TYPE,                               
                      CURRENCY_TYPE,                                    
                      CURRENCY_AMT                                      
                FROM CSS_AR_TRN_HST_DET WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO        = :AU-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AU-TRANS-HIST-SEQ-NO
              )         
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE AR_TRN_HST_DET CURSOR FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*               TRAN_APPL_NO,                                             
MFA-TR*               CODE_AR_AGE,                                              
MFA-TR*               GL_ACCT_CREDIT,                                           
MFA-TR*               GL_ACCT_DEBIT,                                            
MFA-TR*               AMT_POSTED,                                               
MFA-TR*               ITEM_ID,                                                  
MFA-TR*               CODE_CONTRACT_TYPE,                                       
MFA-TR*               CURRENCY_TYPE,                                            
MFA-TR*               CURRENCY_AMT                                              
MFA-TR*         FROM CSS_AR_TRN_HST_DET                                         
MFA-TR*         WHERE ACCOUNT_NO        = :AU-ACCOUNT-NO                        
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AU-TRANS-HIST-SEQ-NO                 
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
