      *****************************************************************         
      ** CWS00427.                                                   **         
      **     TAX PERCENTAGE  - WORKING STORAGE COPYBOOK.             **         
      *****************************************************************         
      *---------------------------------------------------------------*         
      *  NOTE:                                                        *         
      *      WHEN MODIFYING THIS MEMBER, MEMBER CPD00426 SHOULD BE    *         
      *      EVALUATED FOR CORRESPONDING MODIFICATIONS.               *         
      *---------------------------------------------------------------*         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  11/22/08  JC91900      INITIAL VERSION                     **         
A04359**  11/29/12  HA7A338      SALES TAX EXEMPTION CHANGES FOR SEB **         
A04359**                         GEORGIA MANUFACTURE CUSTOMERS       **         
P00794**  04/15/14  MC95456      PSNC TAX SCREEN CHANGES             **         
P794FX**  07/01/14  SS97726      PROD FIX                            **         
      *****************************************************************         
                                                                        
       01  WS-426-VARS.                                                 
           05 WS-CURRENT-TIME         PIC X(08) VALUE SPACES.           
           05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.           
           05 WS-CURRENT-TS           PIC X(26) VALUE SPACES.           
           05 WS-COMMON-DATE          PIC X(10) VALUE SPACES.           
           05 WS-REV-MTH-LST-NRML     PIC 9(6)  VALUE ZEROES.           
           05 WS-REV-MTH-LST-NRML-C   PIC X(06) VALUE SPACES.           
           05 WS-TAX-INDX             PIC S9(2) VALUE ZEROS.            
           05 WS-TAX-RATE-INDX        PIC S9(2) VALUE ZEROS.            
           05 WS-DUMMY-DATE           PIC X(10) VALUE SPACES.           
           05 WS-RESULT-DATE          PIC X(10) VALUE SPACES.           
           05 WS-COM-REV-MONTH        PIC X(06) VALUE SPACES.           
           05 WS-START-DATE.                                            
               10 WS-START-YR         PIC X(04).                        
               10 FILLER              PIC X(01) VALUE '-'.              
               10 WS-START-MT         PIC X(02).                        
               10 FILLER              PIC X(01) VALUE '-'.              
               10 WS-START-DY         PIC X(02).                        
           05 WS-START-DATE-N.                                          
               10 WS-START-YR-N       PIC S9(4) USAGE COMP.             
               10 WS-START-MT-N       PIC S9(2) USAGE COMP.             
           05 WS-REV-MTH-PLUS-1.                                        
               10 WS-REV-P-1-YR       PIC 9(4).                         
               10 WS-REV-P-1-MM       PIC 9(2).                         
A04359     05 WS-TOT-OTHER-TAX        PIC S9(5)V9(4) USAGE COMP-3       
A04359                                          VALUE ZEROS.            
A04359     05 WS-TOT-OTHER-TAX-XMT    PIC S9(5)V9(4) USAGE COMP-3       
A04359                                          VALUE ZEROS.            
                                                                        
       01  WS-426-LITERALS.                                             
           05 BATCH-CALL              PIC X(01) VALUE 'B'.              
           05 ONLINE-CALL             PIC X(01) VALUE 'O'.              
A04359     05 WS-GA-MFG-SALES-TAX-XMT PIC X(01) VALUE 'X'.              
           05 DEFAULT-COMPANY-NO      PIC X(02) VALUE '01'.             
           05 PSNC                    PIC X(02) VALUE '26'.             
           05 STATE-TAX               PIC 9(02) VALUE 10.               
P794FX     05 PSNC-SALES-TAX          PIC 9(02) VALUE 11.               
           05 CITY-TAX                PIC 9(02) VALUE 20.               
           05 WS-TAX-LOWER-LIMIT      PIC S9(04) COMP VALUE 10.         
           05 WS-TAX-UPPER-LIMIT      PIC S9(04) COMP VALUE 90.         
                                                                        
       01  WS-426-NULL-IND.                                             
           05 WS-NULL-IND-01          PIC S9(4) COMP.                   
           05 WS-NULL-IND-02          PIC S9(4) COMP.                   
           05 WS-NULL-IND-03          PIC S9(4) COMP.                   
           05 WS-NULL-IND-04          PIC S9(4) COMP.                   
           05 WS-NULL-IND-05          PIC S9(4) COMP.                   
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.              
              88 NO-MORE-ROWS                   VALUE 'Y'.              
           05 WS-ACCOUNT-INFO-FOUND   PIC X(01) VALUE 'N'.              
              88 ACCOUNT-INFO-FOUND             VALUE 'Y'.              
           05 WS-REV-CLASS-FOUND      PIC X(01) VALUE 'N'.              
              88 REV-CLASS-FOUND                VALUE 'Y'.              
           05 WS-FRNCHS-TX-XMPT       PIC X(01) VALUE 'N'.              
              88 FRNCHS-TX-XMPT                 VALUE 'Y'.              
           05 WS-STATE-TX-XMPT        PIC X(01) VALUE 'N'.              
              88 STATE-TX-XMPT                  VALUE 'Y'.              
           05 WS-UTIL-TYPE            PIC X(01) VALUE ' '.              
              88 UTIL-ELEC                      VALUE 'E'.              
              88 UTIL-GAS                       VALUE 'G'.              
           05 WS-DATABASE             PIC 9(01) VALUE ZERO.             
               88  CSR-DATABASE                 VALUE 1.                
               88  SEB-DATABASE                 VALUE 2.                
P00794     05 WS-PSNC-TAX             PIC 9(09)V9(5) VALUE ZEROS.       
                                                                        
      *****************************************************************         
      *    CURSOR DECLARATIONS.                                       *         
      *****************************************************************         
           EXEC SQL                                                     
             DECLARE TAX_DETAILS CURSOR FOR                             
                 SELECT TR.TAX_RATE                                     
                       ,TC.TAX_CNTRL_NO                                 
                       ,TC.FACTOR_ID                                    
                       ,TU.TAX_ELEC                                     
                       ,TU.TAX_GAS                                      
                       ,TU.CODE_TAX_CALC_INST                           
CRISPC                 ,TC.CODE_APPL_COND                               
                   FROM CSS_TAX_CNTL TC WITH(READUNCOMMITTED)                   
                       ,CSS_TAX_RATE TR WITH(READUNCOMMITTED)                   
                       ,CSS_TAX_USE_CNTL TU WITH(READUNCOMMITTED)               
                  WHERE TU.DETAIL_ID             = :TU-DETAIL-ID        
                    AND TU.TAX_CNTRL_NO          >= :WS-TAX-LOWER-LIMIT 
                    AND TU.TAX_CNTRL_NO          <  :WS-TAX-UPPER-LIMIT 
                    AND TC.ENERGY_TAX_FL         <> '#'                 
                    AND TR.DATE_FROM             <= 
              IIF(TRY_CONVERT(DATE, :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) )       
                    AND TR.DATE_TO               > 
              IIF(TRY_CONVERT(DATE, :TR-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-TO) <> 0) OR (LEN(
                                                            :TR-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:TR-DATE-TO), CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) )          
                    AND CIS.SUBSTR3(TR.OPER_MODE,1,1) = 'A'                  
                    AND TR.DETAIL_ID             = TU.DETAIL_ID         
                    AND TR.OPER_MODE             = TC.OPER_MODE         
                    AND TR.TAX_CNTRL_NO          = TC.TAX_CNTRL_NO      
                    AND TR.TAX_ENTRY_SEQ_NO      = TU.TAX_ENTRY_SEQ_NO  
                    AND TU.OPER_MODE             = TC.OPER_MODE         
                    AND TC.TAX_CNTRL_NO          = TU.TAX_CNTRL_NO      
                    AND TR.DATE_FROM IS NOT NULL                        
A04359            ORDER BY TC.TAX_CNTRL_NO DESC                         
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TAX_DETAILS CURSOR FOR                                     
MFA-TR*          SELECT TR.TAX_RATE                                             
MFA-TR*                ,TC.TAX_CNTRL_NO                                         
MFA-TR*                ,TC.FACTOR_ID                                            
MFA-TR*                ,TU.TAX_ELEC                                             
MFA-TR*                ,TU.TAX_GAS                                              
MFA-TR*                ,TU.CODE_TAX_CALC_INST                                   
MFA-TR*                ,TC.CODE_APPL_COND                                       
MFA-TR*            FROM CSS_TAX_CNTL TC                                         
MFA-TR*                ,CSS_TAX_RATE TR                                         
MFA-TR*                ,CSS_TAX_USE_CNTL TU                                     
MFA-TR*           WHERE TU.DETAIL_ID             = :TU-DETAIL-ID                
MFA-TR*             AND TU.TAX_CNTRL_NO          >= :WS-TAX-LOWER-LIMIT         
MFA-TR*             AND TU.TAX_CNTRL_NO          <  :WS-TAX-UPPER-LIMIT         
MFA-TR*             AND TC.ENERGY_TAX_FL         = '#'                         
MFA-TR*             AND TR.DATE_FROM             <= :TR-DATE-FROM               
MFA-TR*             AND TR.DATE_TO               > :TR-DATE-TO                  
MFA-TR*             AND SUBSTR(TR.OPER_MODE,1,1) = 'A'                          
MFA-TR*             AND TR.DETAIL_ID             = TU.DETAIL_ID                 
MFA-TR*             AND TR.OPER_MODE             = TC.OPER_MODE                 
MFA-TR*             AND TR.TAX_CNTRL_NO          = TC.TAX_CNTRL_NO              
MFA-TR*             AND TR.TAX_ENTRY_SEQ_NO      = TU.TAX_ENTRY_SEQ_NO          
MFA-TR*             AND TU.OPER_MODE             = TC.OPER_MODE                 
MFA-TR*             AND TC.TAX_CNTRL_NO          = TU.TAX_CNTRL_NO              
MFA-TR*             AND TR.DATE_FROM IS NOT NULL                                
MFA-TR*           ORDER BY TC.TAX_CNTRL_NO DESC                                 
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    RETRIEVES ALL OTHER FACTORS APPLIED TO RATES.              *         
      *****************************************************************         
           EXEC SQL                                                     
             DECLARE TAX_EXCISE CURSOR FOR                              
                 SELECT X6.BLOCK_NO                                     
                       ,X6.BLOCK_UNITS                                  
                       ,X6.DATE_FROM                                    
                       ,X6.TAX_CNTRL_NO                                 
                       ,X6.EXCISE_TAX_UNIT_AM                           
                   FROM CSS_TAX_EXCISE_AMT X6 WITH(READUNCOMMITTED)             
                  WHERE X6.TAX_CNTRL_NO = :X6-TAX-CNTRL-NO              
                    AND X6.DATE_FROM    = (                             
                               SELECT MAX(A.DATE_FROM)                  
                                 FROM CSS_TAX_EXCISE_AMT A
                           WITH(READUNCOMMITTED)              
                                WHERE A.TAX_CNTRL_NO = X6.TAX_CNTRL_NO  
                                  AND A.DATE_FROM <= 
              IIF(TRY_CONVERT(DATE, :X6-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :X6-DATE-FROM
              ) <> 0) OR (LEN(:X6-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :X6-DATE-FROM
              ), CONVERT(DATE, :X6-DATE-FROM) )      
                                          )                             
                  ORDER BY X6.BLOCK_NO ASC                              
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TAX_EXCISE CURSOR FOR                                      
MFA-TR*          SELECT X6.BLOCK_NO                                             
MFA-TR*                ,X6.BLOCK_UNITS                                          
MFA-TR*                ,X6.DATE_FROM                                            
MFA-TR*                ,X6.TAX_CNTRL_NO                                         
MFA-TR*                ,X6.EXCISE_TAX_UNIT_AM                                   
MFA-TR*            FROM CSS_TAX_EXCISE_AMT X6                                   
MFA-TR*           WHERE X6.TAX_CNTRL_NO = :X6-TAX-CNTRL-NO                      
MFA-TR*             AND X6.DATE_FROM    = (                                     
MFA-TR*                        SELECT MAX(A.DATE_FROM)                          
MFA-TR*                          FROM CSS_TAX_EXCISE_AMT A                      
MFA-TR*                         WHERE A.TAX_CNTRL_NO = X6.TAX_CNTRL_NO          
MFA-TR*                           AND A.DATE_FROM <= :X6-DATE-FROM              
MFA-TR*                                   )                                     
MFA-TR*           ORDER BY X6.BLOCK_NO ASC                                      
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      ** END OF COPYBOOK CWS00427                                    **         
      *****************************************************************         
