      ******************************************************************01092001
      *                                                                *01094001
      * THIS COPYBOOK IS THE WORKING STORAGE FOR CPD00166              *01093001
      *                                                                *01094001
      *     CPD00166 IS TO GET THE LATEST VERSION OF BILL FOR A REVENUE*01093001
      * MONTH.                                                         *01093001
      *                                                                *01094001
      *  INPUTS TO THE COPYBOOK : ACCOUNT-NO, CODE-UTIL-TYPE, IC-NO AND*01093001
      * REVENUE MONTH.                                                 *01093001
      *                                                                *01094001
      *    OUTPUT IS BILL-NO & BILL-ITEM-TIMESTMP OF THE LATEST VERSION*01093001
      * OF THE BILL.                                                   *01094001
      ******************************************************************01094001
      *                                                                 01092001
      * WORKING STORAGE VARIABLES                                               
      *                                                                 01092001
       01  WS-CPD00166-WORK.                                            
           05  WS-FOUND-BGC-SW                 PIC X(01)  VALUE 'N'.    
           05  WS-NO-MORE-BG-SW                PIC X(01)  VALUE 'N'.    
           05  WS-CHECK-FOR-BG                 PIC X(01)  VALUE 'N'.    
               88 BG-RECORD-EXISTS                        VALUE 'Y'.    
               88 BG-RECORD-NOT-EXISTS                    VALUE 'N'.    
JSFIX      05  WS-CPD166-TRNSP-BG-EXISTS       PIC X(01)  VALUE 'N'.    
      *                                                                         
      ******************************************************************01092001
      * CURSOR FOR GETTING THE ORIGINAL BILL FOR A REVENUE MONTH        01093001
      ******************************************************************01094001
      *                                                                         
           EXEC SQL                                                     
              DECLARE GET_ORIG_BILL CURSOR FOR                          
               SELECT BILL_NO                                           
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                
                     ,CODE_BILL_ITM_IND                                 
                     ,PRORATE_CD                                        
              FROM   CSS_BILLING_DET WITH(READUNCOMMITTED)                      
              WHERE  ACCOUNT_NO     = :BG-ACCOUNT-NO                    
                AND  CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                
                AND  IC_NO          = :BG-IC-NO                         
                AND  REVENUE_MONTH  = :BG-REVENUE-MONTH                 
                AND  REV_MTH_ORIG_BILL = 0                              
JSFIX           AND  CODE_BILL_ITM_IND  IN ('A', 'K')                   
JSFIX           AND  CODE_BILL_CALC    =  'A'                           
                AND  CODE_BILL_ITM_TYPE <> 'B'                          
JSFIX           AND  REV_RPT_CD         <> 'T'                          
           ORDER BY  BILL_NO DESC                                       
C35227          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_ORIG_BILL CURSOR FOR                          01100001
MFA-TR*        SELECT BILL_NO                                           01110001
MFA-TR*              ,BILL_ITEM_TIMESTMP                                01120001
MFA-TR*              ,CODE_BILL_ITM_IND                                 01120001
MFA-TR*              ,PRORATE_CD                                        01120001
MFA-TR*       FROM   CSS_BILLING_DET                                    01120001
MFA-TR*       WHERE  ACCOUNT_NO     = :BG-ACCOUNT-NO                    01130001
MFA-TR*         AND  CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                01130001
MFA-TR*         AND  IC_NO          = :BG-IC-NO                         01130001
MFA-TR*         AND  REVENUE_MONTH  = :BG-REVENUE-MONTH                 01130001
MFA-TR*         AND  REV_MTH_ORIG_BILL = 0                                      
MFA-TR*         AND  CODE_BILL_ITM_IND  IN ('A', 'K')                           
MFA-TR*         AND  CODE_BILL_CALC    =  'A'                                   
MFA-TR*         AND  CODE_BILL_ITM_TYPE <> 'B'                                  
MFA-TR*         AND  REV_RPT_CD         <> 'T'                                  
MFA-TR*    ORDER BY  BILL_NO DESC                                               
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                 01132305
      ****************************************************************  01092001
      * CURSOR FOR GETTING THE CANCEL/REBILL FOR A REVENUE MONTH        01093001
      ****************************************************************  01094001
      *                                                                         
           EXEC SQL                                                     
              DECLARE GET_REBILL  CURSOR FOR                            
               SELECT BILL_NO                                           
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                
                     ,CODE_BILL_ITM_IND                                 
                     ,PRORATE_CD                                        
               FROM  CSS_BILLING_DET WITH(READUNCOMMITTED)                      
              WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                 
                AND  CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE             
                AND  IC_NO             = :BG-IC-NO                      
                AND  CODE_BILL_ITM_IND = 'A'                            
                AND  CODE_BILL_ITM_TYPE = 'C'                           
JSFIX           AND  CODE_BILL_CALC     = 'A'                           
                AND  REV_MTH_ORIG_BILL <> 0                             
JSFIX           AND  REV_RPT_CD        <> 'T'                           
                AND  DATE_ORIG_BILL    = (                              
                      SELECT DATE_BILLED                                
                        FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)              
              WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                 
                AND  BILL_NO           = :BG-BILL-NO)                   
JSFIX         ORDER BY BILL_ITEM_TIMESTMP                               
C35227          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_REBILL  CURSOR FOR                            01100001
MFA-TR*        SELECT BILL_NO                                           01110001
MFA-TR*              ,BILL_ITEM_TIMESTMP                                01120001
MFA-TR*              ,CODE_BILL_ITM_IND                                 01120001
MFA-TR*              ,PRORATE_CD                                        01120001
MFA-TR*        FROM  CSS_BILLING_DET                                            
MFA-TR*       WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                         
MFA-TR*         AND  CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE                     
MFA-TR*         AND  IC_NO             = :BG-IC-NO                              
MFA-TR*         AND  CODE_BILL_ITM_IND = 'A'                            01120001
MFA-TR*         AND  CODE_BILL_ITM_TYPE = 'C'                           01120001
MFA-TR*         AND  CODE_BILL_CALC     = 'A'                                   
MFA-TR*         AND  REV_MTH_ORIG_BILL <> 0                                     
MFA-TR*         AND  REV_RPT_CD        <> 'T'                                   
MFA-TR*         AND  DATE_ORIG_BILL    = (                                      
MFA-TR*               SELECT DATE_BILLED                                        
MFA-TR*                 FROM CSS_BILLING_HDR                                    
MFA-TR*       WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                         
MFA-TR*         AND  BILL_NO           = :BG-BILL-NO)                           
MFA-TR*       ORDER BY BILL_ITEM_TIMESTMP                                       
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
