      *****************************************************************         
      * CWS00118 : THIS COPYBOOK IS THE WORKING STORAGE FOR CPD00118  *         
      *****************************************************************         
      *                                                                         
       01 WS-CPD118-ACCT-TYPE-CODE          PIC X(01) VALUE SPACES.     
       01 WS-CPD118-IC-COUNT                PIC S9(7) COMP-3 VALUE +0.  
       01 WS-CPD118-UT-UNMETER-IND          PIC X(01) VALUE SPACES.     
       01 WS-CPD118-UNMETER-IC-ACCT         PIC X(01) VALUE SPACES.     
       01 WS-CPD118-IC-ACCT-TYPE-FLAG       PIC X(01) VALUE SPACES.     
       01 WS-CPD118-ACCT-TYPE-FLAG          PIC X(01) VALUE SPACES.     
       01 WS-CPD118-RETURN-CODE             PIC S9(9) VALUE +000 COMP.  
      *                                                                         
      **** LOAD ARRAY WITH CSS_UTIL_ENVRNMT DATA OF THE ACCOUNT                 
       01 WS-CPD118-UTIL-ENV-DATA.                                      
          05 WS-CPD118-UTIL-ENV-ITEM  OCCURS 100 TIMES                  
                                        INDEXED BY WS-CPD118-IC-INDX.   
             10 WS-CPD118-IC-NO              PIC S9(04) COMP.           
             10 WS-CPD118-IC-CODE-UTIL-TYPE  PIC X(01).                 
             10 WS-CPD118-IC-REV-CLS-MID-DGT PIC X(01).                 
             10 WS-CPD118-IC-ACCT-TYPE-CD    PIC X(01).                 
             10 WS-CPD118-IC-UNMETER-IND     PIC X(01).                 
      *                                                                         
      ****************************************************************          
      * FOR EACH COMBINATION OF CODE_UTIL_TYPE & REV_CLASS MIDDLE    *          
      * DIGIT, ACCT_TYPE_CODE IS REPRESENTED IN THE FOLLOWING ARRAY. *          
      * EXAMPLE : IF CODE_UTIL_TYPE='G' & REV_CLASS MID DIGIT='1'    *          
      *           THEN ACCT_TYPE_CODE = 'R'.                         *          
      ****************************************************************          
      *                                                                         
       01 WS-CPD118-IC-ACCT-TYPE-CD-MAP.                                
           05 WS-CPD118-IC-MAP-ITEM              PIC X(69)  VALUE       
              'G1RE1RG2CE2CG7CE7CG8CE8CE9WG3IE3IG9IG6ME6MU1RU2CU3IU7CU8C        
      -          'U6ME0DG0DU0D'.                                                
           05 WS-CPD118-IC-MAP-ITEM-R REDEFINES                         
                                      WS-CPD118-IC-MAP-ITEM.            
               10 WS-CPD118-MAP-ITEM-DET         OCCURS 23 TIMES        
                                INDEXED BY WS-CPD118-MAP-INDX.          
                  15 WS-CPD118-MAP-CODE-UTIL-TYPE   PIC X(01).          
                  15 WS-CPD118-MAP-REV-CLS-MID-DGT  PIC X(01).          
                  15 WS-CPD118-MAP-ACCT-TYPE-CD     PIC X(01).          
      *                                                                         
      *****************************************************                     
      * ACCT_TYPE_CODE HIERARCHY FOR DERIVATION ARE       *                     
      * 1.WHOLESALE                                       *                     
      * 2.INDUSTRIAL                                      *                     
      * 3.RESIDENTIAL                                     *                     
      * 4.COMMERCIAL                                      *                     
      * 5.MUNCIPAL / STREET LIGHTING                      *                     
      * 6.COMPANY USE (DEADHEAD)                          *                     
      *****************************************************                     
      *                                                                         
       01 WS-CPD118-HEIRARCHY-DATA.                                     
          05 WS-CPD118-HEIRARCHY-ITEM   PIC X(06)  VALUE 'WIRCMD'.      
          05 WS-CPD118-HEIRARCHY-ITEM-R REDEFINES                       
                                        WS-CPD118-HEIRARCHY-ITEM.       
             10 WS-CPD118-HEIRARCHY-DET OCCURS 6 TIMES                  
                              INDEXED BY WS-CPD118-HA-INDX.             
                15 WS-CPD118-HA-ACCT-TYPE-CD  PIC  X(01).               
      *                                                                         
      **************************************************************            
      * CURSOR FOR FETCHING IC DETAILS FROM CSS_UTIL_ENVRNMT TABLE *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                     
               DECLARE UTIL_ENV_CUR CURSOR FOR                          
                  SELECT DISTINCT UT.IC_NO                              
                        ,UT.CODE_UTIL_TYPE                              
                        ,UT.CODE_REVENUE_CLASS                          
                        ,CASE WHEN UM.RATE_PLAN_NO > ' '                
                        THEN 'Y'                                        
                        ELSE 'N' END AS UN_MTR                          
                    FROM CSS_UTIL_ENVRNMT  UT
                           WITH(READUNCOMMITTED) LEFT JOIN                 
                         CSS_UNMTR_PLAN UM WITH(READUNCOMMITTED) ON             
                         (UM.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE         
                         AND UM.RATE_PLAN_NO = UT.RATE_PLAN_NO)         
                   WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                 
                   ORDER BY 4                                           
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UTIL_ENV_CUR CURSOR FOR                                  
MFA-TR*           SELECT DISTINCT UT.IC_NO                                      
MFA-TR*                 ,UT.CODE_UTIL_TYPE                                      
MFA-TR*                 ,UT.CODE_REVENUE_CLASS                                  
MFA-TR*                 ,CASE WHEN UM.RATE_PLAN_NO > ' '                        
MFA-TR*                 THEN 'Y'                                                
MFA-TR*                 ELSE 'N' END AS UN_MTR                                  
MFA-TR*             FROM CSS_UTIL_ENVRNMT  UT LEFT JOIN                         
MFA-TR*                  CSS_UNMTR_PLAN UM ON                                   
MFA-TR*                  (UM.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                 
MFA-TR*                  AND UM.RATE_PLAN_NO = UT.RATE_PLAN_NO)                 
MFA-TR*            WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                         
MFA-TR*            ORDER BY 4                                                   
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
