      ******************************************************************        
      **                       COPYBOOK CPDLM004                      **        
      ******************************************************************        
      ** PURPOSE: SET PENDING ACCOUNT TO ACTIVE                       **        
      **                                                              **        
      **                                                              **        
      ** INPUTS:                                                      **        
      **  LM04-ACCOUNT-NO        REQUIRED                             **        
      **  LM04-INSTALL-LOC-NO    REQUIRED                             **        
      **                                                              **        
      ** OUTPUT: ACTIVATE PENDING ACCOUNT                             **        
      **                                                              **        
      ** MAIN PROGRAM:INCLUDE CWSLM004/DCLGEN COPYBOOKS, ABEND PARA,  **        
      **              CWS00056,CPD00118,CWS00118                      **        
      ******************************************************************        
      **               COPYBOOK MODIFICATION  LOG                     **        
      **                                                              **        
      **    DATE     INITIALS                 REASON                  **        
      **  ________   ________   ___________________________________   **        
      **  03/16/15   SS95855    NEW COPYBOOK.                         **        
A#5084**  06/26/15   SS95855    ACT041 INCLUDE BILL CYCLE = SPACES    **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      ** CHECK ACCOUNT STATUS AND SET PENDING ACCOUNT TO ACTIVE       **        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *6000-LM04-SET-PEND-ACCOUNT.                                              
      ******************************************************************        
       6000-LM04-SET-PEND-ACCOUNT.                                      
      *                                                                         
           MOVE '6000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 6010-LM04-INITIALIZE THRU 6010-LM04-EXIT.            
                                                                        
           PERFORM 6020-LM04-VALIDATE   THRU 6020-LM04-EXIT.            
                                                                        
           IF LM04-NO-ERROR                                             
              PERFORM 6030-LM04-PROCESS-UPDATES THRU 6030-LM04-EXIT     
           END-IF.                                                      
      *                                                                         
       6000-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *6010-LM04-INITIALIZE.                                                    
      ******************************************************************        
       6010-LM04-INITIALIZE.                                            
      *                                                                         
           INITIALIZE                                                   
                      DCLLMS-TRANS-HIST                                 
                      DCLLMS-TRANS-HIST-DET.                            
      *                                                                         
           MOVE 'N'  TO LM04-PREM-HIST-EXIST-FL.                        
      *                                                                         
       6010-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *6020-LM04-VALIDATE.                                                      
      *** GET ACCOUNT INFO                                                      
      *** QUIT COPYBOOK IF ACCOUNT IS NOT IN PENDING STATUS                     
      *** CHECK CUST PREMISE HISTORY                                            
      ******************************************************************        
       6020-LM04-VALIDATE.                                              
      *                                                                         
           PERFORM 7000-LM04-GET-AT-INFO       THRU  7000-LM04-EXIT.    
                                                                        
           IF LM04-NO-ERROR                                             
              IF WS-ACTIVE-RETURN-CODE      = SUCCESSFUL-CALL AND       
                 LM04-AT-CODE-ACCT-STAT NOT = LM04-PENDING              
                 GO TO 6000-LM04-EXIT                                   
              END-IF                                                    
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET LM04-NON-DB2-ERROR      TO TRUE                    
                 MOVE LM04-BUSR-IS-PEND-ACCT TO LM04-BUS-RULE-ID        
                 MOVE LM04-FAILED            TO LM04-BUS-RULE-RESULT-CD 
                 GO TO 6000-LM04-EXIT                                   
              END-IF                                                    
      *                                                                         
              PERFORM 7100-LM04-CHK-PREM-HIST  THRU  7100-LM04-EXIT     
           END-IF.                                                      
      *                                                                         
           IF LM04-NO-ERROR                                             
              IF LM04-PREM-HIST-EXIST-FL = 'Y'                          
                 SET LM04-NON-DB2-ERROR      TO TRUE                    
                 MOVE LM04-BUSR-PRMS-HAS-ACTV-ACT TO LM04-BUS-RULE-ID   
                 MOVE LM04-FAILED            TO LM04-BUS-RULE-RESULT-CD 
                 GO TO 6000-LM04-EXIT                                   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6020-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *6030-LM04-PROCESS-UPDATES.                                               
      *** GET ACCOUNT TYPE CODE USING COPYBOOK CPD00118                         
      *** UPDATE ACCOUNT INFO                                                   
      *** UPDATE PREMISE STATUS WHEN IT IS 'J'                                  
      *** INSERT A ROW IN CUST_PREM_HIST                                        
      *** UPDATE CUSTOMER INFO                                                  
      *** WRITE TRANSACTION HISTORY                                             
      ******************************************************************        
       6030-LM04-PROCESS-UPDATES.                                       
      *                                                                         
           MOVE 'M01'                         TO AT-CODE-BILL-FREQ.     
           MOVE LM04-ACTIVE                   TO AT-CODE-ACCT-STAT      
                                                 AT-CODE-STATUS-REASON. 
           MOVE LM04-AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT. 
                                                                        
           IF WS-CODE-BUDGET = SPACES                                   
              MOVE 'A'                        TO WS-CODE-UTL            
              MOVE WS-CODES-DATA-PRESENT      TO AT-CODES-DATA-PRESENT  
           ELSE                                                         
              MOVE WS-CODES-DATA-PRESENT      TO AT-CODES-DATA-PRESENT  
           END-IF.                                                      
                                                                        
ACT041     IF LM04-AT-BILL-CYCLE = '00' OR SPACES                       
              MOVE LM04-UT-READ-CYCLE         TO AT-BILL-CYCLE          
           ELSE                                                         
              MOVE LM04-AT-BILL-CYCLE         TO AT-BILL-CYCLE          
           END-IF.                                                      
      *                                                                         
           MOVE LM04-ACCOUNT-NO               TO UT-ACCOUNT-NO.         
           PERFORM 6000-GET-ACCT-TYPE-CODE-CPD118 THRU 6000-CPD118-EXIT.
           IF WS-CPD118-ACCT-TYPE-CODE > SPACES                         
              MOVE WS-CPD118-ACCT-TYPE-CODE   TO AT-ACCOUNT-TYPE-CODE   
           ELSE                                                         
              MOVE LM04-AT-ACCOUNT-TYPE-CODE  TO AT-ACCOUNT-TYPE-CODE   
           END-IF.                                                      
      *                                                                         
           PERFORM 8000-LM04-UPDT-ACCT  THRU  8000-LM04-EXIT.           
      *                                                                         
           IF LM04-NO-ERROR AND LM04-PR-CODE-PREMISE-STAT  = 'J'        
              MOVE LM04-ACTIVE                TO PR-CODE-PREMISE-STAT   
                                                 PR-LITE-AVAILABLE-IND  
              PERFORM 8400-LM04-UPDT-PR-CD-STAT   THRU 8400-LM04-EXIT   
           END-IF.                                                      
      *                                                                         
           IF LM04-NO-ERROR                                             
              PERFORM 8100-LM04-INST-CUST-PR-HIS  THRU 8100-LM04-EXIT   
           END-IF.                                                      
      *                                                                         
           IF LM04-NO-ERROR                                             
              PERFORM 8200-LM04-UPDT-CUST-INFO    THRU 8200-LM04-EXIT   
           END-IF.                                                      
      *                                                                         
           IF LM04-NO-ERROR                                             
              MOVE 26                    TO MH-TRAN-COMMENT-LEN         
              MOVE 'SET PENDING ACCT TO ACTIVE'                         
                                         TO MH-TRAN-COMMENT-TEXT        
              MOVE ZERO                  TO MI-TRAN-APPL-NO             
              COMPUTE MI-TRAN-APPL-NO = MI-TRAN-APPL-NO + 1             
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE 'CODE_ACCT_STAT'      TO MI-COLUMN-DESC              
              MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE 'P'                   TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE AT-CODE-ACCT-STAT     TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6800-LM04-PROCESS-TRANS-HIST                      
                 THRU 6800-LM04-EXIT                                    
           END-IF.                                                      
      *                                                                         
       6030-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *6800-LM04-PROCESS-TRANS-HIST.                                            
      ******************************************************************        
       6800-LM04-PROCESS-TRANS-HIST.                                    
      *                                                                         
                                                                        
           IF MI-TRAN-APPL-NO = 1                                       
              PERFORM 7200-LM04-GET-RESP-AREA                           
                 THRU 7200-LM04-EXIT                                    
              IF LM04-NO-ERROR                                          
                 PERFORM 7300-LM04-GET-TIMESTAMP                        
                 THRU 7300-LM04-EXIT                                    
              END-IF                                                    
              IF LM04-NO-ERROR                                          
                 MOVE 'F'                   TO MH-CODE-TRAN-TYPE        
                 MOVE LM04-TMP-RESP-AREA-ID TO MH-RESP-AREA-ID          
                 MOVE LM04-ACCOUNT-NO       TO MH-ACCOUNT-NO            
                 MOVE LM04-AT-CUSTOMER-NO   TO MH-CUSTOMER-NO           
                 MOVE LM04-INSTALL-LOC-NO   TO MH-PREMISE-NO            
                 MOVE LM04-USER-ID          TO MH-USER-ID               
                 MOVE LM04-PROGRAM-NAME     TO MH-APPL-PROGRAM-ID       
                 MOVE LM04-ACTION-DATE      TO MH-DATE-TRANS            
                 MOVE LM04-TMP-TIMESTAMP    TO MH-TRANS-HIST-SEQ-NO     
                 PERFORM 8500-LM04-MN-TRANS-HIST                        
                    THRU 8500-LM04-EXIT                                 
                 PERFORM 8600-LM04-MN-TRN-HST-DET                       
                    THRU 8600-LM04-EXIT                                 
              END-IF                                                    
           ELSE                                                         
              PERFORM 8600-LM04-MN-TRN-HST-DET THRU 8600-LM04-EXIT      
           END-IF.                                                      
                                                                        
                                                                        
       6800-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *6999-CPD118-ERROR-ROUTINE.                                       15330000
      ******************************************************************        
       6999-CPD118-ERROR-ROUTINE.                                       
      *                                                                         
                                                                        
           MOVE '6999'                     TO ACTIVE-PARAGRAPH.         
           MOVE PROGRAM-NAME               TO ABEND-PROGRAM.            
           SET LM04-ERROR                  TO TRUE.                     
           MOVE WS-CPD118-RETURN-CODE      TO LM04-ERR-SQLCODE.         
                                                                        
       6999-CPD118-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *7000-LM04-GET-AT-INFO.                                                   
      ******************************************************************        
       7000-LM04-GET-AT-INFO.                                           
      *                                                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) AT.CUSTOMER_NO,
              AT.ACCOUNT_TYPE_CODE,
              AT.CODE_ACCT_STAT,
              AT.CODES_DATA_PRESENT,
              AT.CODE_BILL_FREQ,
              AT.BILL_CYCLE,
              UT.READ_CYCLE,
              PR.CODE_PREMISE_STAT                               
               INTO :LM04-AT-CUSTOMER-NO                                
                   ,:LM04-AT-ACCOUNT-TYPE-CODE                          
                   ,:LM04-AT-CODE-ACCT-STAT                             
                   ,:LM04-AT-CODES-DATA-PRESENT                         
                   ,:LM04-AT-CODE-BILL-FREQ                             
                   ,:LM04-AT-BILL-CYCLE                                 
                   ,:LM04-UT-READ-CYCLE                                 
                   ,:LM04-PR-CODE-PREMISE-STAT                          
                FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
                    ,CSS_PREMISE      PR WITH(READUNCOMMITTED)                  
               WHERE AT.ACCOUNT_NO = :LM04-ACCOUNT-NO                   
                 AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                      
                 AND PR.PREMISE_NO = AT.PREMISE_NO                      
                 AND UT.PREMISE_NO = AT.PREMISE_NO                      
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.CODE_BILL_FREQ                                          
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,UT.READ_CYCLE                                              
MFA-TR*             ,PR.CODE_PREMISE_STAT                                       
MFA-TR*        INTO :LM04-AT-CUSTOMER-NO                                        
MFA-TR*            ,:LM04-AT-ACCOUNT-TYPE-CODE                                  
MFA-TR*            ,:LM04-AT-CODE-ACCT-STAT                                     
MFA-TR*            ,:LM04-AT-CODES-DATA-PRESENT                                 
MFA-TR*            ,:LM04-AT-CODE-BILL-FREQ                                     
MFA-TR*            ,:LM04-AT-BILL-CYCLE                                         
MFA-TR*            ,:LM04-UT-READ-CYCLE                                         
MFA-TR*            ,:LM04-PR-CODE-PREMISE-STAT                                  
MFA-TR*         FROM CSS_ACCOUNT      AT                                        
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_PREMISE      PR                                        
MFA-TR*        WHERE AT.ACCOUNT_NO = :LM04-ACCOUNT-NO                           
MFA-TR*          AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                              
MFA-TR*          AND PR.PREMISE_NO = AT.PREMISE_NO                              
MFA-TR*          AND UT.PREMISE_NO = AT.PREMISE_NO                              
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              SET LM04-DB2-ERROR              TO TRUE                   
              MOVE SQLCODE                    TO LM04-ERR-SQLCODE       
              MOVE 'SELECT'                   TO LM04-ERR-FUNCTION      
              MOVE '7000'                     TO LM04-ERR-PARAGRAPH-NO  
              MOVE 'CSS_ACCOUNT'              TO LM04-ERR-TABLE1        
              MOVE 'ACCOUNT_NO'               TO LM04-ERR-COLUMN-1      
              MOVE LM04-ACCOUNT-NO            TO LM04-ERR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       7000-LM04-EXIT.                                                  
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *7100-LM04-CHK-PREM-HIST.                                                 
      ******************************************************************        
       7100-LM04-CHK-PREM-HIST.                                         
      *                                                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :LM04-PREM-HIST-EXIST-FL                          
                 FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                  
                WHERE PREMISE_NO = :LM04-INSTALL-LOC-NO                 
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :LM04-PREM-HIST-EXIST-FL                                  
MFA-TR*          FROM CSS_CUST_PREM_HIST                                        
MFA-TR*         WHERE PREMISE_NO = :LM04-INSTALL-LOC-NO                         
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              SET LM04-DB2-ERROR              TO TRUE                   
              MOVE SQLCODE                    TO LM04-ERR-SQLCODE       
              MOVE 'SELECT'                   TO LM04-ERR-FUNCTION      
              MOVE '7100'                     TO LM04-ERR-PARAGRAPH-NO  
              MOVE 'CSS_CUST_PREM_HIST'       TO LM04-ERR-TABLE1        
              MOVE 'PREMISE_NO'               TO LM04-ERR-COLUMN-1      
              MOVE LM04-INSTALL-LOC-NO        TO LM04-ERR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       7100-LM04-EXIT.                                                  
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *7200-LM04-GET-RESP-AREA.                                                 
      ******************************************************************        
       7200-LM04-GET-RESP-AREA.                                         
      *                                                                         
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :LM04-TMP-RESP-AREA-ID                            
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :LM04-USER-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :LM04-TMP-RESP-AREA-ID                                    
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :LM04-USER-ID                                   
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              SET LM04-DB2-ERROR              TO TRUE                   
              MOVE SQLCODE                    TO LM04-ERR-SQLCODE       
              MOVE 'SELECT'                   TO LM04-ERR-FUNCTION      
              MOVE '7200'                     TO LM04-ERR-PARAGRAPH-NO  
              MOVE 'CSS_USER_PROFILE'         TO LM04-ERR-TABLE1        
              MOVE 'USER_ID'                  TO LM04-ERR-COLUMN-1      
              MOVE LM04-USER-ID               TO LM04-ERR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       7200-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7300-LM04-GET-TIMESTAMP.                                                 
      ******************************************************************        
       7300-LM04-GET-TIMESTAMP.                                         
      *                                                                         
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :LM04-TMP-TIMESTAMP              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :LM04-TMP-TIMESTAMP  = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              SET LM04-DB2-ERROR              TO TRUE                   
              MOVE SQLCODE                    TO LM04-ERR-SQLCODE       
              MOVE 'SELECT'                   TO LM04-ERR-FUNCTION      
              MOVE '7300'                     TO LM04-ERR-PARAGRAPH-NO  
              MOVE 'SYSDUMMY'                 TO LM04-ERR-TABLE1        
              MOVE 'TIMESTAMP'                TO LM04-ERR-COLUMN-1      
              MOVE LM04-TMP-TIMESTAMP         TO LM04-ERR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       7300-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8000-LM04-UPDT-ACCT.                                                     
      ******************************************************************        
       8000-LM04-UPDT-ACCT.                                             
      *                                                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_ACCT_STAT     = :AT-CODE-ACCT-STAT            
                    ,CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
                    ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
                    ,ACCOUNT_TYPE_CODE  = :AT-ACCOUNT-TYPE-CODE         
                    ,CODE_STATUS_REASON = :AT-CODE-STATUS-REASON        
                    ,BILL_CYCLE         = :AT-BILL-CYCLE                
                    ,CODE_BILL_FREQ     = :AT-CODE-BILL-FREQ            
               WHERE ACCOUNT_NO         = :LM04-ACCOUNT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET CODE_ACCT_STAT     = :AT-CODE-ACCT-STAT                    
MFA-TR*             ,CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT                
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*             ,ACCOUNT_TYPE_CODE  = :AT-ACCOUNT-TYPE-CODE                 
MFA-TR*             ,CODE_STATUS_REASON = :AT-CODE-STATUS-REASON                
MFA-TR*             ,BILL_CYCLE         = :AT-BILL-CYCLE                        
MFA-TR*             ,CODE_BILL_FREQ     = :AT-CODE-BILL-FREQ                    
MFA-TR*        WHERE ACCOUNT_NO         = :LM04-ACCOUNT-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              SET LM04-DB2-ERROR              TO TRUE                   
              MOVE SQLCODE                    TO LM04-ERR-SQLCODE       
              MOVE 'UPDATE'                   TO LM04-ERR-FUNCTION      
              MOVE '8000'                     TO LM04-ERR-PARAGRAPH-NO  
              MOVE 'CSS_ACCOUNT'              TO LM04-ERR-TABLE1        
              MOVE 'ACCOUNT_NO'               TO LM04-ERR-COLUMN-1      
              MOVE LM04-ACCOUNT-NO            TO LM04-ERR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       8000-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8100-LM04-INST-CUST-PR-HIS.                                              
      ******************************************************************        
       8100-LM04-INST-CUST-PR-HIS.                                      
      *                                                                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CUST_PREM_HIST                           
                  (PREMISE_NO                                           
                  ,ACCOUNT_NO                                           
                  ,DATE_UTIL_SVC_STRT                                   
                  ,DATE_UTIL_SVC_END                                    
                  ,CUSTOMER_NO)                                         
               VALUES                                                   
                  (:LM04-INSTALL-LOC-NO                                 
                  ,:LM04-ACCOUNT-NO                                     
                  ,CAST(SYSDATETIMEOFFSET() AS DATE)                            
                  ,NULL                                                 
                  ,:LM04-AT-CUSTOMER-NO)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CUST_PREM_HIST                                   
MFA-TR*           (PREMISE_NO                                                   
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,DATE_UTIL_SVC_STRT                                           
MFA-TR*           ,DATE_UTIL_SVC_END                                            
MFA-TR*           ,CUSTOMER_NO)                                                 
MFA-TR*        VALUES                                                           
MFA-TR*           (:LM04-INSTALL-LOC-NO                                         
MFA-TR*           ,:LM04-ACCOUNT-NO                                             
MFA-TR*           ,CURRENT DATE                                                 
MFA-TR*           ,NULL                                                         
MFA-TR*           ,:LM04-AT-CUSTOMER-NO)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              SET LM04-DB2-ERROR              TO TRUE                   
              MOVE SQLCODE                    TO LM04-ERR-SQLCODE       
              MOVE 'INSERT'                   TO LM04-ERR-FUNCTION      
              MOVE '8100'                     TO LM04-ERR-PARAGRAPH-NO  
              MOVE 'CSS_CUST_PREM_HIST'       TO LM04-ERR-TABLE1        
              MOVE 'ACCOUNT_NO'               TO LM04-ERR-COLUMN-1      
              MOVE LM04-ACCOUNT-NO            TO LM04-ERR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       8100-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8200-LM04-UPDT-CUST-INFO.                                                
      ******************************************************************        
       8200-LM04-UPDT-CUST-INFO.                                        
      *                                                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUSTOMER                                      
                  SET SERVICE_EST_DATE = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                     ,LAST_UPDATE_TS   = CIS.CURRENT$TIMESTAMP()              
                WHERE CUSTOMER_NO      = :LM04-AT-CUSTOMER-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUSTOMER                                              
MFA-TR*           SET SERVICE_EST_DATE = CURRENT DATE                           
MFA-TR*              ,LAST_UPDATE_TS   = CURRENT TIMESTAMP                      
MFA-TR*         WHERE CUSTOMER_NO      = :LM04-AT-CUSTOMER-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              SET LM04-DB2-ERROR              TO TRUE                   
              MOVE SQLCODE                    TO LM04-ERR-SQLCODE       
              MOVE 'UPDATE'                   TO LM04-ERR-FUNCTION      
              MOVE '8200'                     TO LM04-ERR-PARAGRAPH-NO  
              MOVE 'CSS_CUSTOMER'             TO LM04-ERR-TABLE1        
              MOVE 'CUSTOMER_NO'              TO LM04-ERR-COLUMN-1      
              MOVE LM04-AT-CUSTOMER-NO        TO LM04-ERR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       8200-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8400-LM04-UPDT-PR-CD-STAT.                                               
      ******************************************************************        
       8400-LM04-UPDT-PR-CD-STAT.                                       
      *                                                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET CODE_PREMISE_STAT  = :PR-CODE-PREMISE-STAT        
                     ,LITE_AVAILABLE_IND = :PR-LITE-AVAILABLE-IND       
                WHERE PREMISE_NO         = :LM04-INSTALL-LOC-NO         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              SET LM04-DB2-ERROR              TO TRUE                   
              MOVE SQLCODE                    TO LM04-ERR-SQLCODE       
              MOVE 'UPDATE'                   TO LM04-ERR-FUNCTION      
              MOVE '8400'                     TO LM04-ERR-PARAGRAPH-NO  
              MOVE 'CSS_PREMISE'              TO LM04-ERR-TABLE1        
              MOVE 'PREMISE_NO'               TO LM04-ERR-COLUMN-1      
              MOVE LM04-INSTALL-LOC-NO        TO LM04-ERR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       8400-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8500-LM04-MN-TRANS-HIST.                                                 
      ******************************************************************        
       8500-LM04-MN-TRANS-HIST.                                         
      *                                                                         
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_MNT_TRANS_HIST                          
                     ( TRANS_HIST_SEQ_NO                                
                      ,DATE_TRANS                                       
                      ,CODE_TRAN_TYPE                                   
                      ,RESP_AREA_ID                                     
                      ,ACCOUNT_NO                                       
                      ,CUSTOMER_NO                                      
                      ,PREMISE_NO                                       
                      ,USER_ID                                          
                      ,APPL_PROGRAM_ID                                  
                      ,TRAN_COMMENT                                     
                      ,ENTITY_KEY_DESC)                                 
                VALUES                                                  
                     ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO)                
                      ,IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) )                               
                      ,:MH-CODE-TRAN-TYPE                               
                      ,:MH-RESP-AREA-ID                                 
                      ,:MH-ACCOUNT-NO                                   
                      ,:MH-CUSTOMER-NO                                  
                      ,:MH-PREMISE-NO                                   
                      ,:MH-USER-ID                                      
                      ,:MH-APPL-PROGRAM-ID                              
                      ,:MH-TRAN-COMMENT                                 
                      ,:MH-ENTITY-KEY-DESC)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MNT_TRANS_HIST                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO                                        
MFA-TR*               ,DATE_TRANS                                               
MFA-TR*               ,CODE_TRAN_TYPE                                           
MFA-TR*               ,RESP_AREA_ID                                             
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,CUSTOMER_NO                                              
MFA-TR*               ,PREMISE_NO                                               
MFA-TR*               ,USER_ID                                                  
MFA-TR*               ,APPL_PROGRAM_ID                                          
MFA-TR*               ,TRAN_COMMENT                                             
MFA-TR*               ,ENTITY_KEY_DESC)                                         
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO                                    
MFA-TR*               ,:MH-DATE-TRANS                                           
MFA-TR*               ,:MH-CODE-TRAN-TYPE                                       
MFA-TR*               ,:MH-RESP-AREA-ID                                         
MFA-TR*               ,:MH-ACCOUNT-NO                                           
MFA-TR*               ,:MH-CUSTOMER-NO                                          
MFA-TR*               ,:MH-PREMISE-NO                                           
MFA-TR*               ,:MH-USER-ID                                              
MFA-TR*               ,:MH-APPL-PROGRAM-ID                                      
MFA-TR*               ,:MH-TRAN-COMMENT                                         
MFA-TR*               ,:MH-ENTITY-KEY-DESC)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              SET LM04-DB2-ERROR              TO TRUE                   
              MOVE SQLCODE                    TO LM04-ERR-SQLCODE       
              MOVE 'INSERT'                   TO LM04-ERR-FUNCTION      
              MOVE '8500'                     TO LM04-ERR-PARAGRAPH-NO  
              MOVE 'CSS_MNT_TRANS_HIST'       TO LM04-ERR-TABLE1        
              MOVE 'TRANS_HIST_SEQ_NO'        TO LM04-ERR-COLUMN-1      
              MOVE MH-TRANS-HIST-SEQ-NO       TO LM04-ERR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       8500-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8600-LM04-MN-TRN-HST-DET.                                                
      ******************************************************************        
       8600-LM04-MN-TRN-HST-DET.                                        
      *                                                                         
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_MT_TRN_HST_DET                          
                     ( TRANS_HIST_SEQ_NO                                
                      ,TRAN_APPL_NO                                     
                      ,COLUMN_DESC                                      
                      ,TABLE_ID                                         
                      ,PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE)                                
                VALUES                                                  
                     ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO)                
                      ,:MI-TRAN-APPL-NO                                 
                      ,:MI-COLUMN-DESC                                  
                      ,:MI-TABLE-ID                                     
                      ,:MI-PRV-COLUMN-VALUE                             
                      ,:MI-CHG-COLUMN-VALUE)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MT_TRN_HST_DET                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO                                        
MFA-TR*               ,TRAN_APPL_NO                                             
MFA-TR*               ,COLUMN_DESC                                              
MFA-TR*               ,TABLE_ID                                                 
MFA-TR*               ,PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE)                                        
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO                                    
MFA-TR*               ,:MI-TRAN-APPL-NO                                         
MFA-TR*               ,:MI-COLUMN-DESC                                          
MFA-TR*               ,:MI-TABLE-ID                                             
MFA-TR*               ,:MI-PRV-COLUMN-VALUE                                     
MFA-TR*               ,:MI-CHG-COLUMN-VALUE)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              SET LM04-DB2-ERROR              TO TRUE                   
              MOVE SQLCODE                    TO LM04-ERR-SQLCODE       
              MOVE 'INSERT'                   TO LM04-ERR-FUNCTION      
              MOVE '8600'                     TO LM04-ERR-PARAGRAPH-NO  
              MOVE 'CSS_MT_TRN_HST_DET'       TO LM04-ERR-TABLE1        
              MOVE 'TRANS_HIST_SEQ_NO '       TO LM04-ERR-COLUMN-1      
              MOVE MH-TRANS-HIST-SEQ-NO       TO LM04-ERR-HOSTVAR-1     
              MOVE 'TRAN_APPL_NO '            TO LM04-ERR-COLUMN-2      
              MOVE MI-TRAN-APPL-NO            TO LM04-ERR-HOSTVAR-2     
           END-IF.                                                      
      *                                                                         
       8600-LM04-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
