      ******************************************************************        
      **                       COPYBOOK CPDLM003                      **        
      ******************************************************************        
      ** PURPOSE: CALCULATE AND UPDATE CONTRACT TERMINATION CHARGES.  **        
      **                                                              **        
      ** CALL TYPE = F --> SINGLE LIGHT FIXTURE                       **        
      ** CALL TYPE = A --> ALL THE LIGHTS OF AN ACCOUNT               **        
      **                                                              **        
      ** UPDATE FLAG = Y --> CALCULATE AND UPDATE (DEFAULT)           **        
      ** UPDATE FLAG = N --> CALCULATE BUT DO NOT UPDATE              **        
      **                                                              **        
      ** INPUTS:                                                      **        
      **  CPDLM3-CALL-TYPE       REQUIRED                             **        
      **  CPDLM3-FXTR-SEQ        OPTIONAL                             **        
      **  CPDLM3-INSTALL-LOC-NO  REQUIRED                             **        
      **  CPDLM3-ACCOUNT-NO      REQUIRED                             **        
      **  CPDLM3-INPUT-DATE      OPTIONAL                             **        
      **  CPDLM3-USER-ID         OPTIONAL                             **        
      **  CPDLM3-UPDATE-FL       OPTIONAL                             **        
      **                                                              **        
      ** OUTPUT: CONTRACT TERMINATION CHARGES & ERROR FLAG/MSG        **        
      **                                                              **        
      ** MAIN PROGRAM:INCLUDE CWSLM003/DCLGEN COPYBOOKS, ABEND PARA   **        
      **                                                              **        
      ******************************************************************        
      **               COPYBOOK MODIFICATION  LOG                     **        
      **                                                              **        
      **    DATE     INITIALS                 REASON                  **        
      **  ________   ________   ___________________________________   **        
      **  08/26/14   AD7F921    NEW COPYBOOK.                         **        
      **                        CONTRACT TERMINATION CHARGES.         **        
      **  11/15/14   GD43988    MODIFIED BASED ON LATEST SPECS.       **        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      ** COMPUTE LIGHTING CONTRACT TERMINATION CHARGES                **        
      ******************************************************************        
      *                                                                         
       6000-CPDLM3-LIGHT-CNTRCT-TERM.                                   
      *                                                                         
           MOVE '6000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        CPDLM3-OUTPUT              
                                             CPDLM3-ERR-DATA            
                                             CPDLM3-4D-STORAGE          
                                             CPDLM3-4L-STORAGE.         
      *                                                                         
           SET  CPDLM3-NO-ERROR           TO TRUE.                      
      *                                                                         
           PERFORM 6025-CPDLM3-VALIDATE-INPUT  THRU  6025-CPDLM3-EXIT.  
      *                                                                         
           EVALUATE TRUE                                                
             WHEN CPDLM3-NO-ERROR AND CPDLM3-CALL-TYPE = 'F'            
               PERFORM 6050-CPDLM3-LIGHT-CNTRCT-FXTR                    
                  THRU 6050-CPDLM3-EXIT                                 
             WHEN CPDLM3-NO-ERROR AND CPDLM3-CALL-TYPE = 'A'            
               PERFORM 6075-CPDLM3-LIGHT-CNTRCT-ACCT                    
                  THRU 6075-CPDLM3-EXIT                                 
           END-EVALUATE.                                                
      *                                                                         
       6000-CPDLM3-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** VALIDATE INPUT PARAMETERS                                    **        
      ******************************************************************        
      *                                                                         
       6025-CPDLM3-VALIDATE-INPUT.                                      
      *                                                                         
           MOVE '6025'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CPDLM3-CALL-TYPE = 'F' OR 'A'                             
              CONTINUE                                                  
           ELSE                                                         
              SET CPDLM3-ERROR            TO TRUE                       
              SET CPDLM3-ERR-CALL-TYPE    TO TRUE                       
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-CALL-TYPE = 'F'                                    
              IF CPDLM3-FXTR-SEQ > 0                                    
                 CONTINUE                                               
              ELSE                                                      
                 SET CPDLM3-ERROR         TO TRUE                       
                 SET CPDLM3-ERR-FXTR-SEQ  TO TRUE                       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-INSTALL-LOC-NO > SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              SET CPDLM3-ERROR            TO TRUE                       
              SET CPDLM3-ERR-LOC-NO       TO TRUE                       
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-ACCOUNT-NO > 0                                     
              CONTINUE                                                  
           ELSE                                                         
              SET CPDLM3-ERROR            TO TRUE                       
              SET CPDLM3-ERR-ACCOUNT-NO   TO TRUE                       
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-CPDLM3-GET-CURR-DATE    THRU 7000-CPDLM3-EXIT.  
           IF CPDLM3-INPUT-DATE > SPACES                                
              CONTINUE                                                  
           ELSE                                                         
              MOVE CPDLM3-CURR-DATE       TO CPDLM3-INPUT-DATE          
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-USER-ID > SPACES                                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'SYSTEM'               TO CPDLM3-USER-ID             
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-UPDATE-FL = 'Y' OR 'N'                             
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'Y'                    TO CPDLM3-UPDATE-FL           
           END-IF.                                                      
      *                                                                         
       6025-CPDLM3-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** COMPUTE LIGHTING CONTRACT TERMINATION CHARGES - FIXTURE      **        
      ******************************************************************        
      *                                                                         
       6050-CPDLM3-LIGHT-CNTRCT-FXTR.                                   
      *                                                                         
           MOVE '6050'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           PERFORM 7050-CPDLM3-GET-FXTR-CNTRCT THRU 7050-CPDLM3-EXIT.   
      *                                                                         
           IF CPDLM3-NO-ERROR                                           
              AND WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
              IF CPDLM3-UPDATE-FL = 'Y'                                 
                 IF LM3-4L-CNTRCT-DURATION-CD = '05'                    
                    IF LM3-4L-LAST-UPDATE-USERID = 'LMSCONV'            
                       PERFORM 7125-CPDLM3-CONV-LIGHTS-CT               
                          THRU 7125-CPDLM3-EXIT                         
                       IF CPDLM3-CONV-LIGHT-CT > 1                      
                          MOVE 'Y'        TO CPDLM3-APPROVAL-REQ-FL     
                       END-IF                                           
                    END-IF                                              
                 ELSE                                                   
                    MOVE 'Y'              TO CPDLM3-APPROVAL-REQ-FL     
                 END-IF                                                 
              END-IF                                                    
              IF CPDLM3-NO-ERROR                                        
                 PERFORM 6100-CPDLM3-PROCESS-CNTRCT                     
                    THRU 6100-CPDLM3-EXIT                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6050-CPDLM3-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** COMPUTE LIGHTING CONTRACT TERMINATION CHARGES - ACCOUNT      **        
      ******************************************************************        
      *                                                                         
       6075-CPDLM3-LIGHT-CNTRCT-ACCT.                                   
      *                                                                         
           MOVE '6075'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CPDLM3-UPDATE-FL = 'Y'                                    
              PERFORM 7100-CPDLM3-REV-DURA-LIGHTS-CT                    
                 THRU 7100-CPDLM3-EXIT                                  
              IF CPDLM3-NO-ERROR                                        
                 IF CPDLM3-DURA-LIGHT-CT > 0                            
                    MOVE 'Y'              TO CPDLM3-APPROVAL-REQ-FL     
                 ELSE                                                   
                    PERFORM 7125-CPDLM3-CONV-LIGHTS-CT                  
                       THRU 7125-CPDLM3-EXIT                            
                    IF CPDLM3-CONV-LIGHT-CT > 1                         
                       MOVE 'Y'           TO CPDLM3-APPROVAL-REQ-FL     
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-NO-ERROR                                           
              PERFORM 7200-CPDLM3-OPEN-ACCT-CUR  THRU 7200-CPDLM3-EXIT  
              PERFORM 7225-CPDLM3-FETCH-ACCT-CUR THRU 7225-CPDLM3-EXIT  
              PERFORM 6100-CPDLM3-PROCESS-CNTRCT THRU 6100-CPDLM3-EXIT  
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                   OR CPDLM3-ERROR                                      
              PERFORM 7250-CPDLM3-CLOSE-ACCT-CUR THRU 7250-CPDLM3-EXIT  
           END-IF.                                                      
      *                                                                         
       6075-CPDLM3-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** PROCESS LIGHT CONTRACT TERMINATION CHARGES                   **        
      ******************************************************************        
      *                                                                         
       6100-CPDLM3-PROCESS-CNTRCT.                                      
      *                                                                         
           MOVE '6100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        CPDLM3-MISC-VAR.           
      *                                                                         
           MOVE LM3-4D-COMPANY-NO         TO C8-COMPANY-NO              
                                             4K-COMPANY-NO.             
      *                                                                         
           PERFORM 7300-CPDLM3-GET-POLE-BILL-FL THRU 7300-CPDLM3-EXIT.  
      *                                                                         
           IF CPDLM3-NO-ERROR                                           
              IF LM3-4L-CNTRCT-DURATION-CD = '05'                       
                 PERFORM 6125-CPDLM3-CALC-TERM-CHRG-5YR                 
                    THRU 6125-CPDLM3-EXIT                               
              ELSE                                                      
                 PERFORM 6150-CPDLM3-CALC-TERM-CHRG-OTH                 
                    THRU 6150-CPDLM3-EXIT                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-NO-ERROR                                           
              COMPUTE CPDLM3-TOTAL-CHRG-AM                              
                    = CPDLM3-TOTAL-CHRG-AM + CPDLM3-TERM-CHRG-AM        
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-NO-ERROR AND CPDLM3-UPDATE-FL = 'Y'                
              IF CPDLM3-APPROVAL-REQ-FL = 'Y'                           
                 PERFORM 8000-CPDLM3-UPD-CNTRCT-PARTIAL                 
                    THRU 8000-CPDLM3-EXIT                               
              ELSE                                                      
                 PERFORM 8100-CPDLM3-UPD-CNTRCT-ALL                     
                    THRU 8100-CPDLM3-EXIT                               
              END-IF                                                    
              IF CPDLM3-NO-ERROR                                        
                 PERFORM 6200-CPDLM3-INSRT-TRNS-HIST                    
                    THRU 6200-CPDLM3-EXIT                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-NO-ERROR AND CPDLM3-CALL-TYPE = 'A'                
              INITIALIZE                  CPDLM3-4D-STORAGE             
                                          CPDLM3-4L-STORAGE             
              PERFORM 7225-CPDLM3-FETCH-ACCT-CUR THRU 7225-CPDLM3-EXIT  
           END-IF.                                                      
      *                                                                         
       6100-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 05 YEARS CONTRACT TERMINATION CHARGES                        **        
      ******************************************************************        
      *                                                                         
       6125-CPDLM3-CALC-TERM-CHRG-5YR.                                  
      *                                                                         
           MOVE '6125'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE LM3-4D-COMPANY-NO         TO C8-COMPANY-NO.             
      *                                                                         
           MOVE 'FXTR-CNTRT-TERM-CHRG'    TO C8-DELINQ-CD.              
           PERFORM 7325-CPDLM3-DELIQ-DATA THRU 7325-CPDLM3-EXIT.        
           IF CPDLM3-NO-ERROR                                           
              MOVE C8-DELINQ-VALUE        TO LM3-4L-FIXTURE-COST-AM     
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-NO-ERROR                                           
              MOVE 'POLE-CNTRT-TERM-CHRG' TO C8-DELINQ-CD               
              PERFORM 7325-CPDLM3-DELIQ-DATA THRU 7325-CPDLM3-EXIT      
              IF CPDLM3-NO-ERROR                                        
                 MOVE C8-DELINQ-VALUE     TO LM3-4L-POLE-COST-AM        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-NO-ERROR                                           
              IF CPDLM3-POLE-BILL-FL = 'Y'                              
                 COMPUTE CPDLM3-TERM-CHRG-AM = LM3-4L-FIXTURE-COST-AM   
                                             + LM3-4L-POLE-COST-AM      
              ELSE                                                      
                 COMPUTE CPDLM3-TERM-CHRG-AM = LM3-4L-FIXTURE-COST-AM   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6125-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 10, 15 ETC. YEARS CONTRACT TERMINATION CHARGES               **        
      ******************************************************************        
      *                                                                         
       6150-CPDLM3-CALC-TERM-CHRG-OTH.                                  
      *                                                                         
           MOVE '6150'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           PERFORM 7375-CPDLM3-GET-REMAIN-DAYS THRU 7375-CPDLM3-EXIT.   
      *                                                                         
           IF CPDLM3-NO-ERROR                                           
              COMPUTE CPDLM3-REMAIN-YEARS                               
                    = CPDLM3-REMAIN-DAYS / 365                          
              IF CPDLM3-REMAIN-YEARS > 0                                
                 MOVE LM3-4D-CODE-SERVICE-TYPE  TO 4K-CODE-SERVICE-TYPE 
                 MOVE LM3-4D-EQUIP-TYPE-CD      TO 4K-EQUIP-TYPE-CD     
                 MOVE LM3-4L-CNTRCT-DURATION-CD TO 4K-CNTRCT-DURATION-CD
                 MOVE CPDLM3-REMAIN-YEARS       TO 4K-DURATION-REMAIN-YR
                 PERFORM 7350-GET-LMS-TERM-CHG-CALC                     
                    THRU 7350-CPDLM3-EXIT                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-NO-ERROR AND CPDLM3-REMAIN-YEARS > 0               
              IF CPDLM3-POLE-BILL-FL = 'Y'                              
                 COMPUTE CPDLM3-TERM-CHRG-AM  = LM3-4L-FIXTURE-COST-AM  
                                              + LM3-4L-POLE-COST-AM     
              ELSE                                                      
                 COMPUTE CPDLM3-TERM-CHRG-AM  = LM3-4L-FIXTURE-COST-AM  
              END-IF                                                    
      *                                                                         
      *FOR ALL THE PERCENTAGE - TAKE 4 DECIMAL PLACES FOR CALCULATION           
              COMPUTE CPDLM3-REMOVAL-COST-PCT = 4K-REMOVAL-COST-PCT/100 
              COMPUTE CPDLM3-DEPRECIATION-PCT = 4K-DEPRECIATION-PCT/100 
              COMPUTE CPDLM3-SALVAGE-CRED-PCT = 4K-SALVAGE-CRED-PCT/100 
              MOVE CPDLM3-TERM-CHRG-AM       TO CPDLM3-TOT-EQUIP-CST    
      *                                                                         
      *ROUND EACH CALCULATION TO NEARST PENNY (2 DECIMAL PLACES)                
              COMPUTE CPDLM3-REMOVAL-CST       ROUNDED                  
                    = (CPDLM3-REMOVAL-COST-PCT * CPDLM3-TOT-EQUIP-CST)  
              COMPUTE CPDLM3-DEPRECIATION-CST  ROUNDED                  
                    = (CPDLM3-DEPRECIATION-PCT * CPDLM3-TOT-EQUIP-CST)  
              COMPUTE CPDLM3-SALVAGE-CRED-CST  ROUNDED                  
                    = (CPDLM3-SALVAGE-CRED-PCT * CPDLM3-TOT-EQUIP-CST)  
      *                                                                         
              COMPUTE CPDLM3-TERM-CHRG-AM      ROUNDED                  
                    = CPDLM3-TOT-EQUIP-CST    + CPDLM3-REMOVAL-CST      
                    - CPDLM3-DEPRECIATION-CST - CPDLM3-SALVAGE-CRED-CST 
           END-IF.                                                      
      *                                                                         
       6150-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** WRITE TRANSACTION HISTORY FOR LMS CONTRACT TABLE UPDATE FIELDS*        
      ******************************************************************        
      *                                                                         
       6200-CPDLM3-INSRT-TRNS-HIST.                                     
      *                                                                         
           MOVE '6200'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        DCLLMS-TRANS-HIST          
                                             DCLLMS-TRANS-HIST-DET.     
      *                                                                         
           MOVE LM3-4D-EQUIP-SEQ          TO 4J-EQUIP-SEQ               
                                             4S-EQUIP-SEQ.              
           MOVE CPDLM3-ACCOUNT-NO         TO 4J-ACCOUNT-NO.             
           MOVE LM3-4D-EQUIP-TAG-NO       TO 4J-EQUIP-TAG-NO.           
           MOVE CPDLM3-INSTALL-LOC-NO     TO 4J-INSTALL-LOC-NO.         
           MOVE CPDLM3-LMS                TO 4J-SOURCE-APPL-CD.         
           MOVE PROGRAM-NAME              TO 4J-APPL-PROGRAM-ID.        
           MOVE CPDLM3-CURR-TMSTMP        TO 4J-TRANS-HIST-SEQ-NO       
                                             4S-TRANS-HIST-SEQ-NO.      
           MOVE CPDLM3-CURR-DATE          TO 4J-TRANS-DATE.             
           MOVE CPDLM3-USER-ID            TO 4J-LAST-UPDATE-USERID      
                                             4S-LAST-UPDATE-USERID.     
      *                                                                         
           IF CPDLM3-APPROVAL-REQ-FL = 'Y'                              
              MOVE CPDLM3-TRNS-HIST-TXT-1 TO 4J-TRANS-COMMENTS-TEXT     
              MOVE LENGTH OF CPDLM3-TRNS-HIST-TXT-1                     
                                          TO 4J-TRANS-COMMENTS-LEN      
           ELSE                                                         
              MOVE CPDLM3-TRNS-HIST-TXT-2 TO 4J-TRANS-COMMENTS-TEXT     
              MOVE LENGTH OF CPDLM3-TRNS-HIST-TXT-2                     
                                          TO 4J-TRANS-COMMENTS-LEN      
           END-IF.                                                      
      *                                                                         
           MOVE 1                         TO 4S-DETAIL-SEQ-NO.          
      *                                                                         
           MOVE 'ORIG_TERM_CHRG_AM'       TO 4S-COLUMN-DESC.            
           MOVE LM3-4L-ORIG-TERM-CHRG-AM  TO CPDLM3-TERM-CHRG-STR.      
           MOVE CPDLM3-TERM-CHRG-STR      TO 4S-PRV-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF CPDLM3-TERM-CHRG-STR                          
                                          TO 4S-PRV-COLUMN-VALUE-LEN.   
           MOVE CPDLM3-TERM-CHRG-AM       TO CPDLM3-TERM-CHRG-STR.      
           MOVE CPDLM3-TERM-CHRG-STR      TO 4S-CHG-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF CPDLM3-TERM-CHRG-STR                          
                                          TO 4S-CHG-COLUMN-VALUE-LEN.   
           PERFORM 6300-CPDLM3-LOAD-LMS-TRN-HST                         
              THRU 6300-CPDLM3-EXIT.                                    
      *                                                                         
           IF CPDLM3-NO-ERROR                                           
              MOVE 'CNTRCT_END_DT'        TO 4S-COLUMN-DESC             
              MOVE LM3-4L-CNTRCT-END-DT   TO 4S-PRV-COLUMN-VALUE-TEXT   
              MOVE LENGTH OF LM3-4L-CNTRCT-END-DT                       
                                          TO 4S-PRV-COLUMN-VALUE-LEN    
              MOVE CPDLM3-INPUT-DATE      TO 4S-CHG-COLUMN-VALUE-TEXT   
              MOVE LENGTH OF CPDLM3-INPUT-DATE                          
                                          TO 4S-CHG-COLUMN-VALUE-LEN    
              PERFORM 6300-CPDLM3-LOAD-LMS-TRN-HST                      
                 THRU 6300-CPDLM3-EXIT                                  
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-NO-ERROR                                           
              MOVE 'CNTRCT_STATUS_CD'     TO 4S-COLUMN-DESC             
              MOVE LM3-4L-CNTRCT-STATUS-CD                              
                                          TO 4S-PRV-COLUMN-VALUE-TEXT   
              MOVE LENGTH OF LM3-4L-CNTRCT-STATUS-CD                    
                                          TO 4S-PRV-COLUMN-VALUE-LEN    
              MOVE CPDLM3-TERMINATE       TO 4S-CHG-COLUMN-VALUE-TEXT   
              MOVE LENGTH OF CPDLM3-TERMINATE                           
                                          TO 4S-CHG-COLUMN-VALUE-LEN    
              PERFORM 6300-CPDLM3-LOAD-LMS-TRN-HST                      
                 THRU 6300-CPDLM3-EXIT                                  
           END-IF.                                                      
      *                                                                         
           IF CPDLM3-APPROVAL-REQ-FL NOT = 'Y' AND CPDLM3-NO-ERROR      
              MOVE 'ACTL_CHRG_DT'         TO 4S-COLUMN-DESC             
              IF LM3-4L-ACTL-CHRG-DT > SPACES                           
                 MOVE LM3-4L-ACTL-CHRG-DT TO 4S-PRV-COLUMN-VALUE-TEXT   
                 MOVE LENGTH OF LM3-4L-ACTL-CHRG-DT                     
                                          TO 4S-PRV-COLUMN-VALUE-LEN    
              ELSE                                                      
                 MOVE CPDLM3-NEW          TO 4S-PRV-COLUMN-VALUE-TEXT   
                 MOVE LENGTH OF CPDLM3-NEW                              
                                          TO 4S-PRV-COLUMN-VALUE-LEN    
              END-IF                                                    
              MOVE CPDLM3-INPUT-DATE      TO 4S-CHG-COLUMN-VALUE-TEXT   
              MOVE LENGTH OF CPDLM3-INPUT-DATE                          
                                          TO 4S-CHG-COLUMN-VALUE-LEN    
              PERFORM 6300-CPDLM3-LOAD-LMS-TRN-HST                      
                 THRU 6300-CPDLM3-EXIT                                  
                                                                        
              IF CPDLM3-NO-ERROR                                        
                 MOVE 'ACTL_TERM_CHRG_AM' TO 4S-COLUMN-DESC             
                 MOVE LM3-4L-ACTL-TERM-CHRG-AM                          
                                          TO CPDLM3-TERM-CHRG-STR       
                 MOVE CPDLM3-TERM-CHRG-STR                              
                                          TO 4S-PRV-COLUMN-VALUE-TEXT   
                 MOVE LENGTH OF CPDLM3-TERM-CHRG-STR                    
                                          TO 4S-PRV-COLUMN-VALUE-LEN    
                 MOVE CPDLM3-TERM-CHRG-AM TO CPDLM3-TERM-CHRG-STR       
                 MOVE CPDLM3-TERM-CHRG-STR                              
                                          TO 4S-CHG-COLUMN-VALUE-TEXT   
                 MOVE LENGTH OF CPDLM3-TERM-CHRG-STR                    
                                          TO 4S-CHG-COLUMN-VALUE-LEN    
                 PERFORM 6300-CPDLM3-LOAD-LMS-TRN-HST                   
                    THRU 6300-CPDLM3-EXIT                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6200-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
       6300-CPDLM3-LOAD-LMS-TRN-HST.                                    
                                                                        
           MOVE '6300'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           IF 4S-DETAIL-SEQ-NO EQUAL 1                                  
              PERFORM 8500-CPDLM3-INS-LMS-TRN-HST    THRU               
                      8500-CPDLM3-EXIT                                  
              PERFORM 8550-CPDLM3-INS-LMS-TRN-HSTDET THRU               
                      8550-CPDLM3-EXIT                                  
           ELSE                                                         
              PERFORM 8550-CPDLM3-INS-LMS-TRN-HSTDET THRU               
                      8550-CPDLM3-EXIT                                  
           END-IF.                                                      
                                                                        
       6300-CPDLM3-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7000-CPDLM3-GET-CURRENT-DATE.                               **        
      ******************************************************************        
      *                                                                         
       7000-CPDLM3-GET-CURR-DATE.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :CPDLM3-CURR-DATE,
              :CPDLM3-CURR-TMSTMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :CPDLM3-CURR-DATE    = CURRENT DATE                          
MFA-TR*           ,:CPDLM3-CURR-TMSTMP  = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MODEL_SQL'            TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-4        
              MOVE CPDLM3-FXTR-SEQ            TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE CPDLM3-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       7000-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT FIXTURE CONTRACT DATA                                 **        
      ******************************************************************        
      *                                                                         
       7050-CPDLM3-GET-FXTR-CNTRCT.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT  [4D].EQUIP_SEQ                                      
                     ,[4D].EQUIP_TAG_NO                                   
                     ,[4D].COMPANY_NO                                     
                     ,[4D].CODE_SERVICE_TYPE                              
                     ,[4D].EQUIP_TYPE_CD                                  
                     ,[4L].CNTRCT_START_DT                                
                     ,[4L].CNTRCT_END_DT                                  
                     ,[4L].CNTRCT_DURATION_CD                             
                     ,[4L].FIXTURE_COST_AM                                
                     ,[4L].POLE_COST_AM                                   
                     ,[4L].LAST_UPDATE_USERID                             
                     ,[4L].CNTRCT_STATUS_CD                               
                     ,[4L].ORIG_TERM_CHRG_AM                              
                     ,[4L].ACTL_TERM_CHRG_AM                              
                     ,[4L].ACTL_CHRG_DT                                   
                INTO  :LM3-4D-EQUIP-SEQ                                 
                     ,:LM3-4D-EQUIP-TAG-NO                              
                     ,:LM3-4D-COMPANY-NO                                
                     ,:LM3-4D-CODE-SERVICE-TYPE                         
                     ,:LM3-4D-EQUIP-TYPE-CD                             
                     ,:LM3-4L-CNTRCT-START-DT                           
                     ,:LM3-4L-CNTRCT-END-DT                             
                     ,:LM3-4L-CNTRCT-DURATION-CD                        
                     ,:LM3-4L-FIXTURE-COST-AM                           
                     ,:LM3-4L-POLE-COST-AM                              
                     ,:LM3-4L-LAST-UPDATE-USERID                        
                     ,:LM3-4L-CNTRCT-STATUS-CD                          
                     ,:LM3-4L-ORIG-TERM-CHRG-AM                         
                     ,:LM3-4L-ACTL-TERM-CHRG-AM                         
                     ,:LM3-4L-ACTL-CHRG-DT :CPDLM3-IND-ACTL-CHRG-DT     
                FROM  LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)             
                     ,LMS_EQUIP_CONTRACT [4L] WITH(READUNCOMMITTED)             
               WHERE  [4D].EQUIP_SEQ         = :CPDLM3-FXTR-SEQ           
                 AND  [4D].EQUIP_SEQ         =  [4L].EQUIP_SEQ              
                 AND  [4D].EQUIP_TYPE_CD     = 'F'                        
                 AND  [4L].INSTALL_LOC_NO    = :CPDLM3-INSTALL-LOC-NO     
                 AND  [4L].ACCOUNT_NO        = :CPDLM3-ACCOUNT-NO         
                 AND  [4L].CNTRCT_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                     :CPDLM3-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :CPDLM3-INPUT-DATE
              ) <> 0) OR (LEN(:CPDLM3-INPUT-DATE
              ) <> 10), CIS.CHAR2DATE(:CPDLM3-INPUT-DATE
              ), CONVERT(DATE, :CPDLM3-INPUT-DATE) )         
                 AND  [4L].CNTRCT_STATUS_CD  = 'A'                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4D.EQUIP_SEQ                                              
MFA-TR*              ,4D.EQUIP_TAG_NO                                           
MFA-TR*              ,4D.COMPANY_NO                                             
MFA-TR*              ,4D.CODE_SERVICE_TYPE                                      
MFA-TR*              ,4D.EQUIP_TYPE_CD                                          
MFA-TR*              ,4L.CNTRCT_START_DT                                        
MFA-TR*              ,4L.CNTRCT_END_DT                                          
MFA-TR*              ,4L.CNTRCT_DURATION_CD                                     
MFA-TR*              ,4L.FIXTURE_COST_AM                                        
MFA-TR*              ,4L.POLE_COST_AM                                           
MFA-TR*              ,4L.LAST_UPDATE_USERID                                     
MFA-TR*              ,4L.CNTRCT_STATUS_CD                                       
MFA-TR*              ,4L.ORIG_TERM_CHRG_AM                                      
MFA-TR*              ,4L.ACTL_TERM_CHRG_AM                                      
MFA-TR*              ,4L.ACTL_CHRG_DT                                           
MFA-TR*         INTO  :LM3-4D-EQUIP-SEQ                                         
MFA-TR*              ,:LM3-4D-EQUIP-TAG-NO                                      
MFA-TR*              ,:LM3-4D-COMPANY-NO                                        
MFA-TR*              ,:LM3-4D-CODE-SERVICE-TYPE                                 
MFA-TR*              ,:LM3-4D-EQUIP-TYPE-CD                                     
MFA-TR*              ,:LM3-4L-CNTRCT-START-DT                                   
MFA-TR*              ,:LM3-4L-CNTRCT-END-DT                                     
MFA-TR*              ,:LM3-4L-CNTRCT-DURATION-CD                                
MFA-TR*              ,:LM3-4L-FIXTURE-COST-AM                                   
MFA-TR*              ,:LM3-4L-POLE-COST-AM                                      
MFA-TR*              ,:LM3-4L-LAST-UPDATE-USERID                                
MFA-TR*              ,:LM3-4L-CNTRCT-STATUS-CD                                  
MFA-TR*              ,:LM3-4L-ORIG-TERM-CHRG-AM                                 
MFA-TR*              ,:LM3-4L-ACTL-TERM-CHRG-AM                                 
MFA-TR*              ,:LM3-4L-ACTL-CHRG-DT :CPDLM3-IND-ACTL-CHRG-DT             
MFA-TR*         FROM  LMS_EQUIP_INVENTRY 4D                                     
MFA-TR*              ,LMS_EQUIP_CONTRACT 4L                                     
MFA-TR*        WHERE  4D.EQUIP_SEQ         = :CPDLM3-FXTR-SEQ                   
MFA-TR*          AND  4D.EQUIP_SEQ         =  4L.EQUIP_SEQ                      
MFA-TR*          AND  4D.EQUIP_TYPE_CD     = 'F'                                
MFA-TR*          AND  4L.INSTALL_LOC_NO    = :CPDLM3-INSTALL-LOC-NO             
MFA-TR*          AND  4L.ACCOUNT_NO        = :CPDLM3-ACCOUNT-NO                 
MFA-TR*          AND  4L.CNTRCT_END_DT    >= :CPDLM3-INPUT-DATE                 
MFA-TR*          AND  4L.CNTRCT_STATUS_CD  = 'A'                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF CPDLM3-IND-ACTL-CHRG-DT = CPDLM3-YES-NULL              
                 MOVE SPACES                  TO 4L-ACTL-CHRG-DT        
              END-IF                                                    
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_CONTRACT'       TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-4        
              MOVE CPDLM3-FXTR-SEQ            TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE CPDLM3-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       7050-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET LIGHT COUNT FOR WHICH REVIEW IS REQUIRED(DURAITON<>05)   **        
      ******************************************************************        
      *                                                                         
       7100-CPDLM3-REV-DURA-LIGHTS-CT.                                  
      *                                                                         
           EXEC SQL                                                     
              SELECT COALESCE(COUNT(*),0)                                 
                INTO :CPDLM3-DURA-LIGHT-CT                              
                FROM  LMS_EQUIP_CONTRACT [4L] WITH(READUNCOMMITTED)             
               WHERE  [4L].INSTALL_LOC_NO      = :CPDLM3-INSTALL-LOC-NO   
                 AND  [4L].ACCOUNT_NO          = :CPDLM3-ACCOUNT-NO       
                 AND  [4L].CNTRCT_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                     :CPDLM3-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :CPDLM3-INPUT-DATE
              ) <> 0) OR (LEN(:CPDLM3-INPUT-DATE
              ) <> 10), CIS.CHAR2DATE(:CPDLM3-INPUT-DATE
              ), CONVERT(DATE, :CPDLM3-INPUT-DATE) )       
                 AND  [4L].CNTRCT_STATUS_CD    = 'A'                      
                 AND  [4L].CNTRCT_DURATION_CD <> '05'                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(COUNT(*),0)                                         
MFA-TR*         INTO :CPDLM3-DURA-LIGHT-CT                                      
MFA-TR*         FROM  LMS_EQUIP_CONTRACT 4L                                     
MFA-TR*        WHERE  4L.INSTALL_LOC_NO      = :CPDLM3-INSTALL-LOC-NO           
MFA-TR*          AND  4L.ACCOUNT_NO          = :CPDLM3-ACCOUNT-NO               
MFA-TR*          AND  4L.CNTRCT_END_DT      >= :CPDLM3-INPUT-DATE               
MFA-TR*          AND  4L.CNTRCT_STATUS_CD    = 'A'                              
MFA-TR*          AND  4L.CNTRCT_DURATION_CD <> '05'                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_CONTRACT'       TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-4        
              MOVE CPDLM3-FXTR-SEQ            TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE CPDLM3-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       7100-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CONVERTED CONTRACT LIGHT COUNT                           **        
      ******************************************************************        
      *                                                                         
       7125-CPDLM3-CONV-LIGHTS-CT.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT COALESCE(COUNT(*),0)                                 
                INTO :CPDLM3-CONV-LIGHT-CT                              
                FROM  LMS_EQUIP_CONTRACT [4L] WITH(READUNCOMMITTED)             
               WHERE  [4L].INSTALL_LOC_NO      = :CPDLM3-INSTALL-LOC-NO   
                 AND  [4L].ACCOUNT_NO          = :CPDLM3-ACCOUNT-NO       
                 AND  [4L].CNTRCT_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                     :CPDLM3-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :CPDLM3-INPUT-DATE
              ) <> 0) OR (LEN(:CPDLM3-INPUT-DATE
              ) <> 10), CIS.CHAR2DATE(:CPDLM3-INPUT-DATE
              ), CONVERT(DATE, :CPDLM3-INPUT-DATE) )       
                 AND  [4L].CNTRCT_STATUS_CD    = 'A'                      
                 AND  [4L].LAST_UPDATE_USERID  = 'LMSCONV'                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(COUNT(*),0)                                         
MFA-TR*         INTO :CPDLM3-CONV-LIGHT-CT                                      
MFA-TR*         FROM  LMS_EQUIP_CONTRACT 4L                                     
MFA-TR*        WHERE  4L.INSTALL_LOC_NO      = :CPDLM3-INSTALL-LOC-NO           
MFA-TR*          AND  4L.ACCOUNT_NO          = :CPDLM3-ACCOUNT-NO               
MFA-TR*          AND  4L.CNTRCT_END_DT      >= :CPDLM3-INPUT-DATE               
MFA-TR*          AND  4L.CNTRCT_STATUS_CD    = 'A'                              
MFA-TR*          AND  4L.LAST_UPDATE_USERID  = 'LMSCONV'                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7125                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7125'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_CONTRACT'       TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-4        
              MOVE CPDLM3-FXTR-SEQ            TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE CPDLM3-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       7125-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN ACCOUNT CONTRACT CURSOR                                 **        
      ******************************************************************        
      *                                                                         
       7200-CPDLM3-OPEN-ACCT-CUR.                                       
      *                                                                         
           EXEC SQL                                                     
               OPEN ACCT-CNTRCT-CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_CONTRACT'       TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-4        
              MOVE CPDLM3-FXTR-SEQ            TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE CPDLM3-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       7200-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH ACCOUNT CONTRACT CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7225-CPDLM3-FETCH-ACCT-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH ACCT-CNTRCT-CUR                                     
               INTO :LM3-4D-EQUIP-SEQ                                   
                   ,:LM3-4D-EQUIP-TAG-NO                                
                   ,:LM3-4D-COMPANY-NO                                  
                   ,:LM3-4D-CODE-SERVICE-TYPE                           
                   ,:LM3-4D-EQUIP-TYPE-CD                               
                   ,:LM3-4L-CNTRCT-START-DT                             
                   ,:LM3-4L-CNTRCT-END-DT                               
                   ,:LM3-4L-CNTRCT-DURATION-CD                          
                   ,:LM3-4L-FIXTURE-COST-AM                             
                   ,:LM3-4L-POLE-COST-AM                                
                   ,:LM3-4L-LAST-UPDATE-USERID                          
                   ,:LM3-4L-CNTRCT-STATUS-CD                            
                   ,:LM3-4L-ORIG-TERM-CHRG-AM                           
                   ,:LM3-4L-ACTL-TERM-CHRG-AM                           
                   ,:LM3-4L-ACTL-CHRG-DT :CPDLM3-IND-ACTL-CHRG-DT       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF CPDLM3-IND-ACTL-CHRG-DT = CPDLM3-YES-NULL              
                 MOVE SPACES                  TO 4L-ACTL-CHRG-DT        
              END-IF                                                    
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7225'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_CONTRACT'       TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-4        
              MOVE CPDLM3-FXTR-SEQ            TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE CPDLM3-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       7225-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE ACCOUNT CONTRACT CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7250-CPDLM3-CLOSE-ACCT-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
               CLOSE ACCT-CNTRCT-CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_CONTRACT'       TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-4        
              MOVE CPDLM3-FXTR-SEQ            TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE CPDLM3-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       7250-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CHECK IF POLE IS BILLED                                      **        
      ******************************************************************        
      *                                                                         
       7300-CPDLM3-GET-POLE-BILL-FL.                                    
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :CPDLM3-POLE-BILL-FL                              
                 FROM  LMS_FXTR_ATTACHMTS  [4H] WITH(READUNCOMMITTED)           
                      ,LMS_EQUIP_ENVRNMT   [4F] WITH(READUNCOMMITTED)           
                WHERE  [4H].FXTR_EQUIP_SEQ  =  :LM3-4D-EQUIP-SEQ          
                  AND  [4H].EQUIP_TYPE_CD   =  'P'                        
                  AND  [4F].INSTALL_LOC_NO  =  :CPDLM3-INSTALL-LOC-NO     
                  AND  [4F].EQUIP_SEQ       =  [4H].ATTACH_EQUIP_SEQ        
                  AND  [4F].INSTALL_LOC_CD  =  'P'                        
                  AND  [4F].BILLING_FL      =  'Y'                        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :CPDLM3-POLE-BILL-FL                                      
MFA-TR*          FROM  LMS_FXTR_ATTACHMTS  4H                                   
MFA-TR*               ,LMS_EQUIP_ENVRNMT   4F                                   
MFA-TR*         WHERE  4H.FXTR_EQUIP_SEQ  =  :LM3-4D-EQUIP-SEQ                  
MFA-TR*           AND  4H.EQUIP_TYPE_CD   =  'P'                                
MFA-TR*           AND  4F.INSTALL_LOC_NO  =  :CPDLM3-INSTALL-LOC-NO             
MFA-TR*           AND  4F.EQUIP_SEQ       =  4H.ATTACH_EQUIP_SEQ                
MFA-TR*           AND  4F.INSTALL_LOC_CD  =  'P'                                
MFA-TR*           AND  4F.BILLING_FL      =  'Y'                                
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_FXTR_ATTACHMTS'       TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-4        
              MOVE CPDLM3-FXTR-SEQ            TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE CPDLM3-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       7300-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT DELINQUENCY DATA                                      **        
      ******************************************************************        
      *                                                                         
       7325-CPDLM3-DELIQ-DATA.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT  C8.DELINQ_VALUE                                  
                 INTO :C8-DELINQ-VALUE                                  
                 FROM  CSS_DELINQUENCY  C8 WITH(READUNCOMMITTED)                
                WHERE  C8.DELINQ_CD  = :C8-DELINQ-CD                    
                  AND  C8.COMPANY_NO = :C8-COMPANY-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  C8.DELINQ_VALUE                                          
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM  CSS_DELINQUENCY  C8                                      
MFA-TR*         WHERE  C8.DELINQ_CD  = :C8-DELINQ-CD                            
MFA-TR*           AND  C8.COMPANY_NO = :C8-COMPANY-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7325                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7325'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-4        
              MOVE CPDLM3-FXTR-SEQ            TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE CPDLM3-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       7325-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT TERMINATION PERCENTAGES & FORMULA                     **        
      ******************************************************************        
      *                                                                         
       7350-GET-LMS-TERM-CHG-CALC.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT  DEPRECIATION_PCT                                   
                    ,REMOVAL_COST_PCT                                   
                    ,SALVAGE_CRED_PCT                                   
               INTO :4K-DEPRECIATION-PCT                                
                   ,:4K-REMOVAL-COST-PCT                                
                   ,:4K-SALVAGE-CRED-PCT                                
               FROM  LMS_TERM_CHRG_CALC WITH(READUNCOMMITTED)                   
              WHERE  COMPANY_NO         = :4K-COMPANY-NO                
                AND  CODE_SERVICE_TYPE  = :4K-CODE-SERVICE-TYPE         
                AND  EQUIP_TYPE_CD      = :4K-EQUIP-TYPE-CD             
                AND  CNTRCT_DURATION_CD = :4K-CNTRCT-DURATION-CD        
                AND  DURATION_REMAIN_YR = :4K-DURATION-REMAIN-YR        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DEPRECIATION_PCT                                           
MFA-TR*             ,REMOVAL_COST_PCT                                           
MFA-TR*             ,SALVAGE_CRED_PCT                                           
MFA-TR*        INTO :4K-DEPRECIATION-PCT                                        
MFA-TR*            ,:4K-REMOVAL-COST-PCT                                        
MFA-TR*            ,:4K-SALVAGE-CRED-PCT                                        
MFA-TR*        FROM  LMS_TERM_CHRG_CALC                                         
MFA-TR*       WHERE  COMPANY_NO         = :4K-COMPANY-NO                        
MFA-TR*         AND  CODE_SERVICE_TYPE  = :4K-CODE-SERVICE-TYPE                 
MFA-TR*         AND  EQUIP_TYPE_CD      = :4K-EQUIP-TYPE-CD                     
MFA-TR*         AND  CNTRCT_DURATION_CD = :4K-CNTRCT-DURATION-CD                
MFA-TR*         AND  DURATION_REMAIN_YR = :4K-DURATION-REMAIN-YR                
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7350                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7350'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_TERM_CHRG_CALC'       TO TABLE-1                
              MOVE 'CODE_SERVICE_TYPE'        TO TABLE-ELEMENT-1        
              MOVE 'EQUIP_TYPE_CD'            TO TABLE-ELEMENT-2        
              MOVE 'CNTRCT_DURATION_CD'       TO TABLE-ELEMENT-3        
              MOVE 'DURATION_REMAIN_YR'       TO TABLE-ELEMENT-4        
              MOVE 4K-CODE-SERVICE-TYPE       TO HOSTVAR-ELEMENT-1      
              MOVE 4K-EQUIP-TYPE-CD           TO HOSTVAR-ELEMENT-2      
              MOVE 4K-CNTRCT-DURATION-CD      TO HOSTVAR-ELEMENT-3      
              MOVE 4K-DURATION-REMAIN-YR      TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       7350-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET REMAINING NUMBER OF DAYS                                 **        
      ******************************************************************        
      *                                                                         
       7375-CPDLM3-GET-REMAIN-DAYS.                                     
      *                                                                         
           EXEC SQL                                                     
               SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :LM3-4L-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :LM3-4L-CNTRCT-END-DT
              ) <> 0) OR (LEN(:LM3-4L-CNTRCT-END-DT
              ) <> 10), CIS.CHAR2DATE(:LM3-4L-CNTRCT-END-DT
              ), CONVERT(DATE, :LM3-4L-CNTRCT-END-DT) ))                   
                 -  CIS.DAYS(IIF(TRY_CONVERT(DATE, :CPDLM3-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :CPDLM3-INPUT-DATE
              ) <> 0) OR (LEN(:CPDLM3-INPUT-DATE
              ) <> 10), CIS.CHAR2DATE(:CPDLM3-INPUT-DATE
              ), CONVERT(DATE, :CPDLM3-INPUT-DATE) ))
            INTO
              :CPDLM3-REMAIN-DAYS                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :CPDLM3-REMAIN-DAYS                                          
MFA-TR*          = (DAYS(DATE(:LM3-4L-CNTRCT-END-DT))                           
MFA-TR*          -  DAYS(DATE(:CPDLM3-INPUT-DATE)))                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7375'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MODEL_SQL'            TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'CNTRCT_END_DT'            TO TABLE-ELEMENT-3        
              MOVE 'INPUT_DATE'               TO TABLE-ELEMENT-4        
              MOVE CPDLM3-FXTR-SEQ            TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE LM3-4L-CNTRCT-END-DT       TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       7375-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  UPDATE CONTRACT DATA - PARTIAL                              **        
      ******************************************************************        
      *                                                                         
       8000-CPDLM3-UPD-CNTRCT-PARTIAL.                                  
      *                                                                         
           EXEC SQL                                                     
               UPDATE LMS_EQUIP_CONTRACT                                
                  SET ORIG_TERM_CHRG_AM  = :CPDLM3-TERM-CHRG-AM         
                     ,CNTRCT_END_DT      = IIF(TRY_CONVERT(DATE, 
                                                     :CPDLM3-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :CPDLM3-INPUT-DATE
              ) <> 0) OR (LEN(:CPDLM3-INPUT-DATE
              ) <> 10), CIS.CHAR2DATE(:CPDLM3-INPUT-DATE
              ), CONVERT(DATE, :CPDLM3-INPUT-DATE) )           
                     ,CNTRCT_STATUS_CD   = 'T'                          
                     ,LAST_UPDATE_USERID = :CPDLM3-USER-ID              
                WHERE EQUIP_SEQ          = :LM3-4D-EQUIP-SEQ            
                  AND INSTALL_LOC_NO     = :CPDLM3-INSTALL-LOC-NO       
                  AND CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                :LM3-4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :LM3-4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:LM3-4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:LM3-4L-CNTRCT-START-DT
              ), CONVERT(DATE, :LM3-4L-CNTRCT-START-DT) )      
                  AND ACCOUNT_NO         = :CPDLM3-ACCOUNT-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE LMS_EQUIP_CONTRACT                                        
MFA-TR*           SET ORIG_TERM_CHRG_AM  = :CPDLM3-TERM-CHRG-AM                 
MFA-TR*              ,CNTRCT_END_DT      = :CPDLM3-INPUT-DATE                   
MFA-TR*              ,CNTRCT_STATUS_CD   = 'T'                                  
MFA-TR*              ,LAST_UPDATE_USERID = :CPDLM3-USER-ID                      
MFA-TR*         WHERE EQUIP_SEQ          = :LM3-4D-EQUIP-SEQ                    
MFA-TR*           AND INSTALL_LOC_NO     = :CPDLM3-INSTALL-LOC-NO               
MFA-TR*           AND CNTRCT_START_DT    = :LM3-4L-CNTRCT-START-DT              
MFA-TR*           AND ACCOUNT_NO         = :CPDLM3-ACCOUNT-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_CONTRACT'       TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'CNTRCT_START_DT'          TO TABLE-ELEMENT-3        
              MOVE 'INPUT_DATE'               TO TABLE-ELEMENT-4        
              MOVE LM3-4D-EQUIP-SEQ           TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE LM3-4L-CNTRCT-START-DT     TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       8000-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  UPDATE CONTRACT - ALL                                       **        
      ******************************************************************        
      *                                                                         
       8100-CPDLM3-UPD-CNTRCT-ALL.                                      
      *                                                                         
           EXEC SQL                                                     
               UPDATE LMS_EQUIP_CONTRACT                                
                  SET ORIG_TERM_CHRG_AM  = :CPDLM3-TERM-CHRG-AM         
                     ,CNTRCT_END_DT      = IIF(TRY_CONVERT(DATE, 
                                                     :CPDLM3-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :CPDLM3-INPUT-DATE
              ) <> 0) OR (LEN(:CPDLM3-INPUT-DATE
              ) <> 10), CIS.CHAR2DATE(:CPDLM3-INPUT-DATE
              ), CONVERT(DATE, :CPDLM3-INPUT-DATE) )           
                     ,ACTL_TERM_CHRG_AM  = :CPDLM3-TERM-CHRG-AM         
                     ,ACTL_CHRG_DT       = IIF(TRY_CONVERT(DATE, 
                                                     :CPDLM3-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :CPDLM3-INPUT-DATE
              ) <> 0) OR (LEN(:CPDLM3-INPUT-DATE
              ) <> 10), CIS.CHAR2DATE(:CPDLM3-INPUT-DATE
              ), CONVERT(DATE, :CPDLM3-INPUT-DATE) )           
                     ,CNTRCT_STATUS_CD   = 'T'                          
                     ,LAST_UPDATE_USERID = :CPDLM3-USER-ID              
                WHERE EQUIP_SEQ          = :LM3-4D-EQUIP-SEQ            
                  AND INSTALL_LOC_NO     = :CPDLM3-INSTALL-LOC-NO       
                  AND CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                :LM3-4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :LM3-4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:LM3-4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:LM3-4L-CNTRCT-START-DT
              ), CONVERT(DATE, :LM3-4L-CNTRCT-START-DT) )      
                  AND ACCOUNT_NO         = :CPDLM3-ACCOUNT-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE LMS_EQUIP_CONTRACT                                        
MFA-TR*           SET ORIG_TERM_CHRG_AM  = :CPDLM3-TERM-CHRG-AM                 
MFA-TR*              ,CNTRCT_END_DT      = :CPDLM3-INPUT-DATE                   
MFA-TR*              ,ACTL_TERM_CHRG_AM  = :CPDLM3-TERM-CHRG-AM                 
MFA-TR*              ,ACTL_CHRG_DT       = :CPDLM3-INPUT-DATE                   
MFA-TR*              ,CNTRCT_STATUS_CD   = 'T'                                  
MFA-TR*              ,LAST_UPDATE_USERID = :CPDLM3-USER-ID                      
MFA-TR*         WHERE EQUIP_SEQ          = :LM3-4D-EQUIP-SEQ                    
MFA-TR*           AND INSTALL_LOC_NO     = :CPDLM3-INSTALL-LOC-NO               
MFA-TR*           AND CNTRCT_START_DT    = :LM3-4L-CNTRCT-START-DT              
MFA-TR*           AND ACCOUNT_NO         = :CPDLM3-ACCOUNT-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_CONTRACT'       TO TABLE-1                
              MOVE 'FXTR_SEQ'                 TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-2        
              MOVE 'CNTRCT_START_DT'          TO TABLE-ELEMENT-3        
              MOVE 'INPUT_DATE'               TO TABLE-ELEMENT-4        
              MOVE LM3-4D-EQUIP-SEQ           TO HOSTVAR-ELEMENT-1      
              MOVE CPDLM3-INSTALL-LOC-NO      TO HOSTVAR-ELEMENT-2      
              MOVE LM3-4L-CNTRCT-START-DT     TO HOSTVAR-ELEMENT-3      
              MOVE CPDLM3-INPUT-DATE          TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       8100-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  INSERT TRANSACTION HISTORY                                  **        
      ******************************************************************        
      *                                                                         
       8500-CPDLM3-INS-LMS-TRN-HST.                                     
                                                                        
           MOVE '8500'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST                               
                 (                                                      
                   EQUIP_SEQ                                            
                  ,TRANS_HIST_SEQ_NO                                    
                  ,EQUIP_TAG_NO                                         
                  ,APPL_PROGRAM_ID                                      
                  ,TRANS_DATE                                           
                  ,SOURCE_APPL_CD                                       
                  ,SOURCE_APPL_REQ_NO                                   
                  ,WMS_POINT_NO                                         
                  ,INSTALL_LOC_NO                                       
                  ,INSTALL_POINT_NO                                     
                  ,ACCOUNT_NO                                           
                  ,LAST_UPDATE_USERID                                   
                  ,TRANS_COMMENTS                                       
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :4J-EQUIP-SEQ                                        
                  ,CIS.CHAR2TIMESTAMP(:4J-TRANS-HIST-SEQ-NO)                    
                  ,:4J-EQUIP-TAG-NO                                     
                  ,:4J-APPL-PROGRAM-ID                                  
                  ,IIF(TRY_CONVERT(DATE, :4J-TRANS-DATE
              ) IS NULL OR (PATINDEX('%.%', :4J-TRANS-DATE
              ) <> 0) OR (LEN(:4J-TRANS-DATE) <> 10), CIS.CHAR2DATE(
                                                         :4J-TRANS-DATE
              ), CONVERT(DATE, :4J-TRANS-DATE) )                               
                  ,:4J-SOURCE-APPL-CD                                   
                  ,:4J-SOURCE-APPL-REQ-NO                               
                  ,:4J-WMS-POINT-NO                                     
                  ,:4J-INSTALL-LOC-NO                                   
                  ,:4J-INSTALL-POINT-NO                                 
                  ,:4J-ACCOUNT-NO                                       
                  ,:4J-LAST-UPDATE-USERID                               
                  ,:4J-TRANS-COMMENTS                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO LMS_TRANS_HIST                                       
MFA-TR*          (                                                              
MFA-TR*            EQUIP_SEQ                                                    
MFA-TR*           ,TRANS_HIST_SEQ_NO                                            
MFA-TR*           ,EQUIP_TAG_NO                                                 
MFA-TR*           ,APPL_PROGRAM_ID                                              
MFA-TR*           ,TRANS_DATE                                                   
MFA-TR*           ,SOURCE_APPL_CD                                               
MFA-TR*           ,SOURCE_APPL_REQ_NO                                           
MFA-TR*           ,WMS_POINT_NO                                                 
MFA-TR*           ,INSTALL_LOC_NO                                               
MFA-TR*           ,INSTALL_POINT_NO                                             
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,TRANS_COMMENTS                                               
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :4J-EQUIP-SEQ                                                
MFA-TR*           ,:4J-TRANS-HIST-SEQ-NO                                        
MFA-TR*           ,:4J-EQUIP-TAG-NO                                             
MFA-TR*           ,:4J-APPL-PROGRAM-ID                                          
MFA-TR*           ,:4J-TRANS-DATE                                               
MFA-TR*           ,:4J-SOURCE-APPL-CD                                           
MFA-TR*           ,:4J-SOURCE-APPL-REQ-NO                                       
MFA-TR*           ,:4J-WMS-POINT-NO                                             
MFA-TR*           ,:4J-INSTALL-LOC-NO                                           
MFA-TR*           ,:4J-INSTALL-POINT-NO                                         
MFA-TR*           ,:4J-ACCOUNT-NO                                               
MFA-TR*           ,:4J-LAST-UPDATE-USERID                                       
MFA-TR*           ,:4J-TRANS-COMMENTS                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_TRANS_HIST'           TO TABLE-1                
              MOVE 'EQUIP-SEQ'                TO TABLE-ELEMENT-1        
              MOVE 'TRANS-HIST-SEQ-NO'        TO TABLE-ELEMENT-2        
              MOVE 'INSTALL-LOC-NO'           TO TABLE-ELEMENT-3        
              MOVE 'INSTALL-POINT-NO'         TO TABLE-ELEMENT-4        
              MOVE 4J-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              MOVE 4J-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-2      
              MOVE 4J-INSTALL-LOC-NO          TO HOSTVAR-ELEMENT-3      
              MOVE 4J-INSTALL-POINT-NO        TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       8500-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  INSERT TRANSACTION HISTORY DETAILS                          **        
      ******************************************************************        
      *                                                                         
       8550-CPDLM3-INS-LMS-TRN-HSTDET.                                  
                                                                        
           MOVE '8550'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST_DET                           
               (                                                        
                 EQUIP_SEQ                                              
                ,TRANS_HIST_SEQ_NO                                      
                ,DETAIL_SEQ_NO                                          
                ,COLUMN_DESC                                            
                ,PRV_COLUMN_VALUE                                       
                ,CHG_COLUMN_VALUE                                       
                ,LAST_UPDATE_USERID                                     
               )                                                        
               VALUES                                                   
               (                                                        
                 :4S-EQUIP-SEQ                                          
                ,CIS.CHAR2TIMESTAMP(:4S-TRANS-HIST-SEQ-NO)                      
                ,:4S-DETAIL-SEQ-NO                                      
                ,:4S-COLUMN-DESC                                        
                ,:4S-PRV-COLUMN-VALUE                                   
                ,:4S-CHG-COLUMN-VALUE                                   
                ,:4S-LAST-UPDATE-USERID                                 
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO LMS_TRANS_HIST_DET                                   
MFA-TR*        (                                                                
MFA-TR*          EQUIP_SEQ                                                      
MFA-TR*         ,TRANS_HIST_SEQ_NO                                              
MFA-TR*         ,DETAIL_SEQ_NO                                                  
MFA-TR*         ,COLUMN_DESC                                                    
MFA-TR*         ,PRV_COLUMN_VALUE                                               
MFA-TR*         ,CHG_COLUMN_VALUE                                               
MFA-TR*         ,LAST_UPDATE_USERID                                             
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*          :4S-EQUIP-SEQ                                                  
MFA-TR*         ,:4S-TRANS-HIST-SEQ-NO                                          
MFA-TR*         ,:4S-DETAIL-SEQ-NO                                              
MFA-TR*         ,:4S-COLUMN-DESC                                                
MFA-TR*         ,:4S-PRV-COLUMN-VALUE                                           
MFA-TR*         ,:4S-CHG-COLUMN-VALUE                                           
MFA-TR*         ,:4S-LAST-UPDATE-USERID                                         
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                          TO 4S-DETAIL-SEQ-NO       
           ELSE                                                         
              SET  CPDLM3-ERROR               TO TRUE                   
              SET  CPDLM3-DB2-ERROR           TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO CPDLM3-RETURN-CODE     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8550'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_TRANS_HIST_DET'       TO TABLE-1                
              MOVE 'EQUIP-SEQ'                TO TABLE-ELEMENT-1        
              MOVE 'TRANS-HIST-SEQ-NO'        TO TABLE-ELEMENT-2        
              MOVE 'INSTALL-LOC-NO'           TO TABLE-ELEMENT-3        
              MOVE 'INSTALL-POINT-NO'         TO TABLE-ELEMENT-4        
              MOVE 4S-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              MOVE 4S-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-2      
              MOVE 4J-INSTALL-LOC-NO          TO HOSTVAR-ELEMENT-3      
              MOVE 4J-INSTALL-POINT-NO        TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       8550-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
