      ******************************************************************        
      **                       COPYBOOK CPDLM002                      **        
      ******************************************************************        
      ** PURPOSE: COMMON ROUTINE TO WRITE LMS TRANSACTION HISTORY.    **        
      **                                                              **        
      ** INPUTS : NONE.                                               **        
      **                                                              **        
      ** OUTPUT : NONE.                                               **        
      **                                                              **        
      ** REQUIRED MAIN PGM COPYBOOKS: TBLGTHST LMS_TRANS_HIST     4J  **        
      **                              TBLMSHST LMS_TRANS_HIST_DET 4S  **        
      **                                                              **        
      ******************************************************************        
      **               COPYBOOK MODIFICATION  LOG                     **        
      **                                                              **        
      **    DATE     INITIALS                 REASON                  **        
      **  ________   ________   ___________________________________   **        
P00817**  08/20/14   SS97726    NEW COPYBOOK.                         **        
      **                                                              **        
      ******************************************************************        
       6000-LOAD-LMS-TRN-HST-CPDLM2.                                    
                                                                        
           MOVE '6000'                            TO ACTIVE-PARAGRAPH.  
                                                                        
           IF 4S-DETAIL-SEQ-NO EQUAL 1                                  
                                                                        
      *** USE CURRENT DATE WHEN NOT PASSED BY CALLING PROGRAM.                  
              IF 4J-TRANS-DATE EQUAL SPACES                             
                 PERFORM 6075-GET-CURR-DT-CPDLM2     THRU               
                         6075-CPDLM2-EXIT                               
              END-IF                                                    
                                                                        
      *** USE CURRENT TIMESTAMP WHEN NOT PASSED BY CALLING PROGRAM.             
              IF 4J-TRANS-HIST-SEQ-NO EQUAL SPACES                      
                 PERFORM 6080-GET-CURR-TS-CPDLM2     THRU               
                         6080-CPDLM2-EXIT                               
              END-IF                                                    
                                                                        
              PERFORM 6025-INS-LMS-TRN-HST-CPDLM2    THRU               
                      6025-CPDLM2-EXIT                                  
              PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU               
                      6050-CPDLM2-EXIT                                  
           ELSE                                                         
              PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU               
                      6050-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
       6000-CPDLM2-EXIT.                                                
           EXIT.                                                        
                                                                        
       6025-INS-LMS-TRN-HST-CPDLM2.                                     
                                                                        
           MOVE '6025'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST                               
                 (                                                      
                   EQUIP_SEQ,           TRANS_HIST_SEQ_NO,              
                   EQUIP_TAG_NO,        APPL_PROGRAM_ID,                
                   TRANS_DATE,          SOURCE_APPL_CD,                 
                   SOURCE_APPL_REQ_NO,  WMS_POINT_NO,                   
                   INSTALL_LOC_NO,      INSTALL_POINT_NO,               
                   ACCOUNT_NO,          LAST_UPDATE_USERID,             
                   TRANS_COMMENTS                                       
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :4J-EQUIP-SEQ,           CIS.CHAR2TIMESTAMP(
                                                  :4J-TRANS-HIST-SEQ-NO
              ),      
                   :4J-EQUIP-TAG-NO,        :4J-APPL-PROGRAM-ID,        
                   IIF(TRY_CONVERT(DATE, :4J-TRANS-DATE
              ) IS NULL OR (PATINDEX('%.%', :4J-TRANS-DATE
              ) <> 0) OR (LEN(:4J-TRANS-DATE) <> 10), CIS.CHAR2DATE(
                                                         :4J-TRANS-DATE
              ), CONVERT(DATE, :4J-TRANS-DATE) ),          
                                                    :4J-SOURCE-APPL-CD,        
                   :4J-SOURCE-APPL-REQ-NO,  :4J-WMS-POINT-NO,           
                   :4J-INSTALL-LOC-NO,      :4J-INSTALL-POINT-NO,       
                   :4J-ACCOUNT-NO,          :4J-LAST-UPDATE-USERID,     
                   :4J-TRANS-COMMENTS                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO LMS_TRANS_HIST                                       
MFA-TR*          (                                                              
MFA-TR*            EQUIP_SEQ,           TRANS_HIST_SEQ_NO,                      
MFA-TR*            EQUIP_TAG_NO,        APPL_PROGRAM_ID,                        
MFA-TR*            TRANS_DATE,          SOURCE_APPL_CD,                         
MFA-TR*            SOURCE_APPL_REQ_NO,  WMS_POINT_NO,                           
MFA-TR*            INSTALL_LOC_NO,      INSTALL_POINT_NO,                       
MFA-TR*            ACCOUNT_NO,          LAST_UPDATE_USERID,                     
MFA-TR*            TRANS_COMMENTS                                               
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :4J-EQUIP-SEQ,           :4J-TRANS-HIST-SEQ-NO,              
MFA-TR*            :4J-EQUIP-TAG-NO,        :4J-APPL-PROGRAM-ID,                
MFA-TR*            :4J-TRANS-DATE,          :4J-SOURCE-APPL-CD,                 
MFA-TR*            :4J-SOURCE-APPL-REQ-NO,  :4J-WMS-POINT-NO,                   
MFA-TR*            :4J-INSTALL-LOC-NO,      :4J-INSTALL-POINT-NO,               
MFA-TR*            :4J-ACCOUNT-NO,          :4J-LAST-UPDATE-USERID,             
MFA-TR*            :4J-TRANS-COMMENTS                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 4J-APPL-PROGRAM-ID          TO ABEND-PROGRAM         
              MOVE 'INSERT'                    TO ABEND-FUNCTION        
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
                                                  ABEND-SQLCODE         
              MOVE SQLERRMC                    TO ABEND-SQLERRMC        
              MOVE 'LMS_TRANS_HIST'            TO TABLE-1               
              MOVE 4J-EQUIP-SEQ                TO HOSTVAR-ELEMENT-1     
              MOVE 4J-TRANS-HIST-SEQ-NO        TO HOSTVAR-ELEMENT-2     
              MOVE 4J-INSTALL-LOC-NO           TO HOSTVAR-ELEMENT-3     
              MOVE 4J-INSTALL-POINT-NO         TO HOSTVAR-ELEMENT-4     
              MOVE 'EQUIP-SEQ'                 TO TABLE-ELEMENT-1       
              MOVE 'TRANS-HIST-SEQ-NO'         TO TABLE-ELEMENT-2       
              MOVE 'INSTALL-LOC-NO'            TO TABLE-ELEMENT-3       
              MOVE 'INSTALL-POINT-NO'          TO TABLE-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT        
              PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       6025-CPDLM2-EXIT.                                                
           EXIT.                                                        
                                                                        
       6050-INS-LMS-TRN-HSTDET-CPDLM2.                                  
                                                                        
           MOVE '6050'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
               INSERT INTO LMS_TRANS_HIST_DET                           
               (                                                        
                 EQUIP_SEQ,         TRANS_HIST_SEQ_NO,                  
                 DETAIL_SEQ_NO,     COLUMN_DESC,                        
                 PRV_COLUMN_VALUE,  CHG_COLUMN_VALUE,                   
                 LAST_UPDATE_USERID                                     
               )                                                        
               VALUES                                                   
               (                                                        
                 :4S-EQUIP-SEQ,         CIS.CHAR2TIMESTAMP(
                                                  :4S-TRANS-HIST-SEQ-NO
              ),          
                 :4S-DETAIL-SEQ-NO,     :4S-COLUMN-DESC,                
                 :4S-PRV-COLUMN-VALUE,  :4S-CHG-COLUMN-VALUE,           
                 :4S-LAST-UPDATE-USERID                                 
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO LMS_TRANS_HIST_DET                                   
MFA-TR*        (                                                                
MFA-TR*          EQUIP_SEQ,         TRANS_HIST_SEQ_NO,                          
MFA-TR*          DETAIL_SEQ_NO,     COLUMN_DESC,                                
MFA-TR*          PRV_COLUMN_VALUE,  CHG_COLUMN_VALUE,                           
MFA-TR*          LAST_UPDATE_USERID                                             
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*          :4S-EQUIP-SEQ,         :4S-TRANS-HIST-SEQ-NO,                  
MFA-TR*          :4S-DETAIL-SEQ-NO,     :4S-COLUMN-DESC,                        
MFA-TR*          :4S-PRV-COLUMN-VALUE,  :4S-CHG-COLUMN-VALUE,                   
MFA-TR*          :4S-LAST-UPDATE-USERID                                         
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                           TO 4S-DETAIL-SEQ-NO      
           ELSE                                                         
              MOVE 4J-APPL-PROGRAM-ID          TO ABEND-PROGRAM         
              MOVE 'INSERT'                    TO ABEND-FUNCTION        
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
                                                  ABEND-SQLCODE         
              MOVE SQLERRMC                    TO ABEND-SQLERRMC        
              MOVE 'LMS_TRANS_HIST_DET'        TO TABLE-1               
              MOVE 4S-EQUIP-SEQ                TO HOSTVAR-ELEMENT-1     
              MOVE 4S-TRANS-HIST-SEQ-NO        TO HOSTVAR-ELEMENT-2     
              MOVE 4J-INSTALL-LOC-NO           TO HOSTVAR-ELEMENT-3     
              MOVE 4J-INSTALL-POINT-NO         TO HOSTVAR-ELEMENT-4     
              MOVE 'EQUIP-SEQ'                 TO TABLE-ELEMENT-1       
              MOVE 'TRANS-HIST-SEQ-NO'         TO TABLE-ELEMENT-2       
              MOVE 'INSTALL-LOC-NO'            TO TABLE-ELEMENT-3       
              MOVE 'INSTALL-POINT-NO'          TO TABLE-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT        
              PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       6050-CPDLM2-EXIT.                                                
           EXIT.                                                        
                                                                        
       6075-GET-CURR-DT-CPDLM2.                                         
                                                                        
           MOVE '6075'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :4J-TRANS-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :4J-TRANS-DATE = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 4J-APPL-PROGRAM-ID          TO ABEND-PROGRAM         
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
                                                  ABEND-SQLCODE         
              MOVE SQLERRMC                    TO ABEND-SQLERRMC        
              MOVE 'CSS_MODEL_SQL'             TO TABLE-1               
              MOVE 4J-INSTALL-LOC-NO           TO HOSTVAR-ELEMENT-1     
              MOVE 4J-INSTALL-POINT-NO         TO HOSTVAR-ELEMENT-2     
              MOVE 'INSTALL-LOC-NO'            TO TABLE-ELEMENT-1       
              MOVE 'INSTALL-POINT-NO'          TO TABLE-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT        
              PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       6075-CPDLM2-EXIT.                                                
           EXIT.                                                        
                                                                        
       6080-GET-CURR-TS-CPDLM2.                                         
                                                                        
           MOVE '6080'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :4J-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :4J-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE 4J-TRANS-HIST-SEQ-NO        TO 4S-TRANS-HIST-SEQ-NO  
           ELSE                                                         
              MOVE 4J-APPL-PROGRAM-ID          TO ABEND-PROGRAM         
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE         
                                                  ABEND-SQLCODE         
              MOVE SQLERRMC                    TO ABEND-SQLERRMC        
              MOVE 'CSS_MODEL_SQL'             TO TABLE-1               
              MOVE 4J-INSTALL-LOC-NO           TO HOSTVAR-ELEMENT-1     
              MOVE 4J-INSTALL-POINT-NO         TO HOSTVAR-ELEMENT-2     
              MOVE 'INSTALL-LOC-NO'            TO TABLE-ELEMENT-1       
              MOVE 'INSTALL-POINT-NO'          TO TABLE-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT        
              PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       6080-CPDLM2-EXIT.                                                
           EXIT.                                                        
