      *****************************************************************         
      *****************************************************************         
      **  COPYBOOK NAME: CPDLM001 (PD) / CWSLM001 (WS)               **         
      **  THIS COPYBOOK CAN BE INCLUDED IN ONLINE AND BATCH PROGRAMS **         
      **  TO SYNC LMS WITH LIGHT BILLING.                            **         
      **                                                             **         
      *****************************************************************         
      **  INPUT DATA:                                                **         
      **            LM001-ACCOUNT-NO                                 **         
      **            LM001-INSTALL-LOC-NO                             **         
      **            LM001-INSTALL-POINT-NO                           **         
      **            LM001-ACTION-DATE                                **         
      **            LM001-ACTION-CODE                                **         
      **            LM001-NEW-RATE-UTIL-TYPE (FOR RATE CHANGE ONLY)  **         
      **            LM001-NEW-RATE-PLAN-NO   (FOR RATE CHANGE ONLY)  **         
      **            LM001-NEW-RATE-ITEM-CODE (FOR RATE CHANGE ONLY)  **         
      **                                                             **         
      *****************************************************************         
      **  VALID ACTION CODES :                                       **         
      **                   N - ADD NEW LIGHT                         **         
      **                   A - ACTIVATE EXISTING INACTIVE LIGHT      **         
      **                   R - REMOVE EXISTING ACTIVE/INACTIVE LIGHT **         
      **                   I - INACTIVATE EXISTING ACTIVE LIGHT      **         
      **                   C - RATE CHANGE (SWITH LIGHTS B/W RATES)  **         
      **                                                             **         
      *****************************************************************         
      **  OUTPUT DATA:                                               **         
      **            LM001-ERR-DATA                                   **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              COPYBOOK MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS       REASON                            **         
      ** --------   --------       ----------------------------------**         
      ** 03/15/15   ROD/NARASIMHA  NEW CODE                          **         
      ** 10/04/16   AK7T405        TO RETRIEVE LMS_FIXTURE_CHG_CD    **         
      **            A17062         FROM CSS_RATE_PAN_DESC TABLE      **         
      **                           INSTEAD OF LMS_CODE_DESC TABLE    **         
      *****************************************************************         
      *****************************************************************         
      *================================================================*        
       6300-LM001-CUST-LIGHT-SYNC.                                      
      *================================================================*        
      *                                                                         
           PERFORM 6310-LM001-INITIALIZE THRU 6310-LM001-EXIT.          
      *                                                                         
           PERFORM 6320-LM001-VALIDATE   THRU 6320-LM001-EXIT.          
      *                                                                         
           IF LM001-NO-ERROR                                            
              PERFORM 6330-LM001-PROCESS-ACTIONS THRU 6330-LM001-EXIT   
           END-IF.                                                      
      *                                                                         
       6300-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6310-LM001-INITIALIZE.                                           
      *================================================================*        
      *                                                                         
           INITIALIZE LM001-TEMP-STORAGE                                
                      LM001-AT-STORAGE                                  
                      LM001-4F-STORAGE                                  
                      LM001-CP-STORAGE                                  
                      LM001-UT-STORAGE                                  
                      LM001-ERR-DATA                                    
                      DCLCSS-MNT-TRANS-HIST                             
                      DCLCSS-MT-TRN-HST-DET.                            
      *                                                                         
       6310-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6320-LM001-VALIDATE.                                             
      *================================================================*        
      *                                                                         
           EVALUATE TRUE                                                
              WHEN NOT LM001-ACTION-VALID                               
                 SET LM001-NON-DB2-ERROR TO TRUE                        
                 MOVE 'VALID ACTION CODE REQUIRED' TO LM001-ERR-MESSAGE 
                 SET LM001-ACTION-CD-REQ TO TRUE                        
                 MOVE LM001-BUSR-VLD-ACTN-CD-REQD  TO LM001-BUS-RULE-ID 
              WHEN LM001-ACCOUNT-NO NOT NUMERIC OR                      
                   LM001-ACCOUNT-NO <= 0                                
                 SET LM001-NON-DB2-ERROR TO TRUE                        
                 MOVE 'ACCOUNT NUMBER REQUIRED' TO LM001-ERR-MESSAGE    
                 SET LM001-ACCT-NO-REQ TO TRUE                          
                 MOVE LM001-BUSR-ACCT-NUM-REQD  TO LM001-BUS-RULE-ID    
              WHEN LM001-INSTALL-LOC-NO <= SPACES OR                    
                   LM001-INSTALL-POINT-NO NOT NUMERIC OR                
                   LM001-INSTALL-POINT-NO <= 0                          
                 SET LM001-NON-DB2-ERROR TO TRUE                        
                 MOVE 'LIGHT LOCATION NO REQUIRED' TO LM001-ERR-MESSAGE 
                 SET LM001-LOCATION-NO-REQ TO TRUE                      
                 MOVE LM001-BUSR-LOC-NO-REQD    TO LM001-BUS-RULE-ID    
              WHEN LM001-ACTION-RATE-CHANGE AND                         
                   (LM001-NEW-RATE-UTIL-TYPE <= SPACES OR               
                    LM001-NEW-RATE-PLAN-NO <= SPACES OR                 
                    LM001-NEW-RATE-ITEM-CODE <= 0 )                     
                 SET LM001-NON-DB2-ERROR TO TRUE                        
                 MOVE 'NEW RATE DETAILS REQUIRED' TO LM001-ERR-MESSAGE  
                 SET LM001-NEW-RATE-DET-REQ TO TRUE                     
                 MOVE LM001-BUSR-NEW-RT-DTLS-REQD  TO LM001-BUS-RULE-ID 
              WHEN LM001-ACTION-DATE <= SPACES                          
                 SET LM001-NON-DB2-ERROR TO TRUE                        
                 MOVE 'CHANGE EFFECTIVE DATE IS NEEDED'                 
                                         TO LM001-ERR-MESSAGE           
                 SET LM001-EFFECT-DT-REQ TO TRUE                        
                 MOVE LM001-BUSR-EFF-DATE-REQD  TO LM001-BUS-RULE-ID    
              WHEN LM001-USER-ID <= SPACES                              
                 SET LM001-NON-DB2-ERROR TO TRUE                        
                 MOVE 'USER IS IS NEEDED'                               
                                         TO LM001-ERR-MESSAGE           
                 SET LM001-USER-ID-NOT-VALID TO TRUE                    
                 MOVE LM001-BUSR-USER-ID-NOT-VLD TO LM001-BUS-RULE-ID   
              WHEN LM001-PROGRAM-NAME <= SPACES                         
                 SET LM001-NON-DB2-ERROR TO TRUE                        
                 MOVE 'PROGRAM NAME IS NEEDED'                          
                                         TO LM001-ERR-MESSAGE           
                 SET LM001-PROGRAM-NAME-NOT-VALID TO TRUE               
                 MOVE LM001-BUSR-PROGRAM-NAME-REQ TO LM001-BUS-RULE-ID  
              WHEN OTHER                                                
                 CONTINUE                                               
           END-EVALUATE.                                                
      *                                                                         
           IF LM001-NO-ERROR                                            
              MOVE LM001-ACCOUNT-NO           TO LMAT-ACCOUNT-NO        
              PERFORM 7600-LM001-VALIDATE-ACCOUNT THRU 7600-LM001-EXIT  
      *COMMENTED THIS CODE TO ALLOW TO REMOVE FXTR FOR FINAL BILL ACCT          
      *       IF LMAT-CODE-ACCT-STAT = 'A' OR 'P' OR 'I'                        
      *          CONTINUE                                                       
      *       ELSE                                                              
      *          SET LM001-NON-DB2-ERROR TO TRUE                                
      *          MOVE 'ACCOUNT FINALLED' TO LM001-ERR-MESSAGE                   
      *          SET LM001-ACCT-FINALED TO TRUE                                 
      *          MOVE LM001-BUSR-ACCT-FINALED   TO LM001-BUS-RULE-ID            
      *       END-IF                                                            
           END-IF.                                                      
      *                                                                         
           IF LM001-NO-ERROR                                            
              MOVE LM001-INSTALL-LOC-NO    TO LM4F-INSTALL-LOC-NO       
              MOVE LM001-INSTALL-POINT-NO  TO LM4F-INSTALL-POINT-NO     
              PERFORM 7602-LM001-GET-LIGHT-ENVRNMT                      
                 THRU 7602-LM001-EXIT                                   
           END-IF.                                                      
      *                                                                         
           IF LM001-NO-ERROR                                            
              MOVE LM4F-CODE-UTIL-TYPE        TO LMUT-CODE-UTIL-TYPE    
              MOVE LM4F-RATE-PLAN-NO          TO LMUT-RATE-PLAN-NO      
              PERFORM 7606-LM001-GET-UTIL-IC                            
                 THRU 7606-LM001-EXIT                                   
           END-IF.                                                      
      *                                                                         
           IF LM001-NO-ERROR AND LM001-IC-EXISTS                        
              PERFORM 7604-LM001-ENV-LIGHT-COUNT                        
                 THRU 7604-LM001-EXIT                                   
      *                                                                         
              PERFORM 7608-LM001-GET-CUST-COUNT                         
                 THRU 7608-LM001-EXIT                                   
      *                                                                         
              MOVE LMCP-ITEM-SEQ-NO   TO LMTMP-MAX-ITEM-SEQ-NO          
      *                                                                         
              IF LMTMP-ACTIVE-LIGHT-COUNT = LMTMP-ACTIVE-CUST-COUNT     
              AND LMTMP-INACTV-LIGHT-COUNT = LMTMP-INACTV-CUST-COUNT    
                 MOVE LMTMP-ACTIVE-LIGHT-COUNT                          
                                         TO LMTMP-PRE-ACT-UNITS-N       
                 MOVE LMTMP-INACTV-LIGHT-COUNT                          
                                         TO LMTMP-PRE-INACT-UNITS-N     
              ELSE                                                      
                 SET LM001-NON-DB2-ERROR TO TRUE                        
                 MOVE 'LIGHT COUNTS NOT IN SYNC' TO LM001-ERR-MESSAGE   
                 SET LM001-CNT-NOT-SYNC TO TRUE                         
                 MOVE LM001-BUSR-LGHT-CNT-NOT-SYNC TO LM001-BUS-RULE-ID 
              END-IF                                                    
      *                                                                         
           END-IF.                                                      
      *                                                                         
           IF LM001-NO-ERROR AND (LM001-ACTION-INACTIVATE               
                                   OR LM001-ACTION-ACTIVATE             
                                   OR LM001-ACTION-REMOVE               
                                   OR LM001-ACTION-RATE-CHANGE)         
              EVALUATE TRUE                                             
                 WHEN LM001-IC-NOT-EXISTS                               
                   SET LM001-NON-DB2-ERROR TO TRUE                      
                   MOVE 'IC NOT FOUND' TO LM001-ERR-MESSAGE             
                   SET LM001-IC-NOT-FOUND TO TRUE                       
                   MOVE LM001-BUSR-IC-NOT-FND     TO LM001-BUS-RULE-ID  
                 WHEN LM4F-ITEM-SEQ-NO <= 0                             
                   SET LM001-NON-DB2-ERROR TO TRUE                      
                   MOVE 'ITEM SEQ NOT SET' TO LM001-ERR-MESSAGE         
                   SET LM001-ITEM-SEQ-NOT-SET TO TRUE                   
                   MOVE LM001-BUSR-ITM-SEQ-NOT-SET TO LM001-BUS-RULE-ID 
                 WHEN OTHER                                             
                   MOVE LM4F-ITEM-SEQ-NO   TO LMCP-ITEM-SEQ-NO          
                   PERFORM 7610-LM001-SELECT-CUST-PLAN                  
                      THRU 7610-LM001-EXIT                              
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       6320-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6330-LM001-PROCESS-ACTIONS.                                      
      *================================================================*        
      *                                                                         
           EVALUATE TRUE                                                
              WHEN LM001-ACTION-ADD                                     
                   PERFORM 6340-LM001-ACTION-ADD                        
              WHEN LM001-ACTION-INACTIVATE                              
                   PERFORM 6350-LM001-ACTION-INACT                      
              WHEN LM001-ACTION-ACTIVATE                                
                   PERFORM 6360-LM001-ACTION-ACTV                       
              WHEN LM001-ACTION-REMOVE                                  
                   PERFORM 6370-LM001-ACTION-REMOVE                     
              WHEN LM001-ACTION-RATE-CHANGE                             
                   PERFORM 6380-LM001-ACTION-RATE-CHG                   
              WHEN OTHER                                                
                 SET LM001-NON-DB2-ERROR TO TRUE                        
                 MOVE 'UNSUPPORTED ACTION' TO LM001-ERR-MESSAGE         
                 SET LM001-UNSUPPORT-ACTION TO TRUE                     
                 MOVE LM001-BUSR-UNSPRT-ACTN-CD TO LM001-BUS-RULE-ID    
           END-EVALUATE.                                                
      *                                                                         
       6330-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6340-LM001-ACTION-ADD.                                           
      *================================================================*        
      *                                                                         
           MOVE 19                    TO MH-TRAN-COMMENT-LEN            
           MOVE 'ADDING LIGHT BY LMS' TO MH-TRAN-COMMENT-TEXT           
           MOVE ZERO                  TO MI-TRAN-APPL-NO                
      *                                                                         
           IF LM001-IC-NOT-EXISTS                                       
              PERFORM 6382-LM001-CREATE-NEW-IC                          
                 THRU 6382-LM001-EXIT                                   
              MOVE ZERO                  TO LMTMP-MAX-ITEM-SEQ-NO       
           END-IF                                                       
                                                                        
           IF LM001-NO-ERROR                                            
              PERFORM 6384-LM001-CREATE-NEW-CUST                        
                 THRU 6384-LM001-EXIT                                   
                                                                        
           END-IF.                                                      
                                                                        
           IF LM001-NO-ERROR                                            
              MOVE LMCP-ITEM-SEQ-NO        TO LM4F-ITEM-SEQ-NO          
              MOVE LMUT-IC-NO              TO LM4F-IC-NO                
              MOVE 'Y'                     TO LM4F-BILLING-FL           
                                                                        
              PERFORM 8650-LM001-UPD-LIGHT-ENVRNMT                      
                 THRU 8650-LM001-EXIT                                   
           END-IF.                                                      
                                                                        
           IF LM001-NO-ERROR                                            
      ***     MNT TRANSACTION HISTORY START                                     
      ***     NO UNITS                                                          
              COMPUTE MI-TRAN-APPL-NO     = MI-TRAN-APPL-NO + 1         
              MOVE SPACES                TO MI-TABLE-ID                 
              IF LMTMP-PRE-ACT-UNITS-N = 0                              
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +4                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '0001'              TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +4                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE LMTMP-PRE-ACT-UNITS TO MI-PRV-COLUMN-VALUE-TEXT   
                 COMPUTE LMTMP-PRE-ACT-UNITS-N                          
                                        = LMTMP-PRE-ACT-UNITS-N + 1     
                 MOVE +4                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LMTMP-PRE-ACT-UNITS TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'NO UNITS       '     TO MI-COLUMN-DESC              
              PERFORM 6398-LM001-PROCESS-TRANS-HIST                     
                 THRU 6398-LM001-EXIT                                   
      ***     DATE PLAN START                                                   
              COMPUTE MI-TRAN-APPL-NO     = MI-TRAN-APPL-NO + 1         
              MOVE SPACES                 TO MI-TABLE-ID                
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE +10                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE LMCP-DATE-PLAN-START   TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE 'DATE PLAN START'      TO MI-COLUMN-DESC             
              PERFORM 6398-LM001-PROCESS-TRANS-HIST                     
                 THRU 6398-LM001-EXIT                                   
              IF LMTMP-ACTIVE-LIGHT-COUNT = 0                           
      ***     RATE ITEM CODE                                                    
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE SPACES             TO MI-TABLE-ID                 
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +4                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LM4F-RATE-ITEM-CODE TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'RATE ITEM CODE '   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
      ***     CD PLAN STATUS                                                    
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE '03'               TO MI-TABLE-ID                 
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE 'A'                 TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'CD PLAN STATUS '   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
      ***     USAGE FIXED                                                       
                 IF LMCP-USAGE-FIXED > ZERO                             
                    COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1      
                    MOVE SPACES          TO MI-TABLE-ID                 
                    MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN     
                    MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT    
                    MOVE +9              TO MI-CHG-COLUMN-VALUE-LEN     
                    MOVE LMCP-USAGE-FIXED TO MI-CHG-COLUMN-VALUE-TEXT   
                    MOVE 'USAGE FIXED    ' TO MI-COLUMN-DESC            
                    PERFORM 6398-LM001-PROCESS-TRANS-HIST               
                       THRU 6398-LM001-EXIT                             
                 END-IF                                                 
              END-IF                                                    
      ***     MNT TRANSACTION HISTORY END                                       
           END-IF.                                                      
       6340-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6350-LM001-ACTION-INACT.                                         
      *================================================================*        
      *                                                                         
           MOVE 30                    TO MH-TRAN-COMMENT-LEN            
           MOVE 'INACTIVATING LIGHT THROUGH LMS'                        
                                      TO MH-TRAN-COMMENT-TEXT           
           MOVE ZERO                  TO MI-TRAN-APPL-NO                
      *                                                                         
           IF LMCP-CODE-PLAN-STATUS = 'A' AND LMCP-NO-UNITS > 0         
              AND LM4F-BILLING-FL = 'Y'                                 
              IF LMCP-NO-UNITS = 1                                      
                 MOVE 'I'                     TO LMCP-CODE-PLAN-STATUS  
                 MOVE LM001-ACTION-DATE       TO LMCP-REMOVE-DATE       
                 MOVE ZERO                    TO LMCP-REMOVE-DATE-IND   
                 IF LMCP-LAST-BILL-DATE > SPACES                        
                    MOVE 0                 TO LMCP-LAST-BILL-DATE-IND   
                 ELSE                                                   
                    MOVE -1                TO LMCP-LAST-BILL-DATE-IND   
                 END-IF                                                 
                 PERFORM 8610-LM001-UPDATE-CUST                         
                    THRU 8610-LM001-EXIT                                
              ELSE                                                      
                 COMPUTE LMTMP-NO-UNITS  = LMCP-NO-UNITS - 1            
                 PERFORM 8612-LM001-UPD-CUST-UNITS                      
                    THRU 8612-LM001-EXIT                                
                                                                        
                 COMPUTE LMCP-ITEM-SEQ-NO = LMTMP-MAX-ITEM-SEQ-NO + 1   
                 MOVE 1                       TO LMCP-NO-UNITS          
                 MOVE 'I'                     TO LMCP-CODE-PLAN-STATUS  
                 MOVE LM001-ACTION-DATE       TO LMCP-REMOVE-DATE       
                 MOVE ZERO                    TO LMCP-REMOVE-DATE-IND   
                 IF LMCP-LAST-BILL-DATE > SPACES                        
                    MOVE 0                 TO LMCP-LAST-BILL-DATE-IND   
                 ELSE                                                   
                    MOVE -1                TO LMCP-LAST-BILL-DATE-IND   
                 END-IF                                                 
                 PERFORM 8620-LM001-INSERT-CP                           
                    THRU 8620-LM001-EXIT                                
                 MOVE LMCP-ITEM-SEQ-NO        TO LM4F-ITEM-SEQ-NO       
              END-IF                                                    
              MOVE 'N'                        TO LM4F-BILLING-FL        
              PERFORM 8650-LM001-UPD-LIGHT-ENVRNMT                      
                 THRU 8650-LM001-EXIT                                   
              IF LM001-NO-ERROR                                         
      ***        MNT TRANSACTION HISTORY START                                  
      ***        NO UNITS                                                       
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE SPACES             TO MI-TABLE-ID                 
                 IF LMTMP-PRE-ACT-UNITS-N = 0                           
                    MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN    
                    MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT   
                    MOVE +4               TO MI-CHG-COLUMN-VALUE-LEN    
                    MOVE '0001'           TO MI-CHG-COLUMN-VALUE-TEXT   
                 ELSE                                                   
                    MOVE +4               TO MI-PRV-COLUMN-VALUE-LEN    
                    MOVE LMTMP-PRE-ACT-UNITS                            
                                       TO MI-PRV-COLUMN-VALUE-TEXT      
                    COMPUTE LMTMP-PRE-ACT-UNITS-N                       
                                     = LMTMP-PRE-ACT-UNITS-N - 1        
                    MOVE +4               TO MI-CHG-COLUMN-VALUE-LEN    
                    MOVE LMTMP-PRE-ACT-UNITS                            
                                       TO MI-CHG-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 MOVE 'NO UNITS       '     TO MI-COLUMN-DESC           
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
      ***        REMOVE DATE                                                    
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE SPACES              TO MI-TABLE-ID                
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LMCP-REMOVE-DATE    TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'REMOVE DATE    '   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
      ***        CD PLAN STATUS                                                 
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE '03'               TO MI-TABLE-ID                 
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE 'A'                 TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE 'I'                 TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'CD PLAN STATUS '   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
              END-IF                                                    
           ELSE                                                         
              SET LM001-NON-DB2-ERROR TO TRUE                           
              MOVE 'LIGHT IS NOT ACTIVE TO MAKE INACTIVE'               
                                              TO LM001-ERR-MESSAGE      
              SET LM001-LIGHT-NOT-ACTIVE TO TRUE                        
              MOVE LM001-BUSR-LGHT-NOT-ACTV  TO LM001-BUS-RULE-ID       
           END-IF.                                                      
      *                                                                         
       6350-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6360-LM001-ACTION-ACTV.                                          
      *================================================================*        
      *                                                                         
           MOVE 28                    TO MH-TRAN-COMMENT-LEN            
           MOVE 'ACTIVATING LIGHT THROUGH LMS'                          
                                      TO MH-TRAN-COMMENT-TEXT           
           MOVE ZERO                  TO MI-TRAN-APPL-NO                
      *                                                                         
           IF LMCP-CODE-PLAN-STATUS = 'I' AND LMCP-NO-UNITS > 0         
              AND LM4F-BILLING-FL NOT = 'Y'                             
              IF LMCP-NO-UNITS = 1                                      
                 MOVE 'A'                     TO LMCP-CODE-PLAN-STATUS  
                 IF LMCP-LAST-BILL-DATE > SPACES                        
                    MOVE 0                 TO LMCP-LAST-BILL-DATE-IND   
                 ELSE                                                   
                    MOVE -1                TO LMCP-LAST-BILL-DATE-IND   
                 END-IF                                                 
                 IF LM001-ACTION-DATE = LMCP-REMOVE-DATE                
                    MOVE SPACES               TO LMCP-REMOVE-DATE       
                    MOVE -1                   TO LMCP-REMOVE-DATE-IND   
                    PERFORM 8610-LM001-UPDATE-CUST                      
                       THRU 8610-LM001-EXIT                             
                 ELSE                                                   
      ****      REMOVE PREVIOUS INACTIVE ROW AND INSERT ACTIVE ROW              
                    MOVE 'R'                  TO LMCP-CODE-PLAN-STATUS  
                    PERFORM 8610-LM001-UPDATE-CUST                      
                       THRU 8610-LM001-EXIT                             
                    COMPUTE LMCP-ITEM-SEQ-NO                            
                                = LMTMP-MAX-ITEM-SEQ-NO + 1             
                    MOVE 1                    TO LMCP-NO-UNITS          
                    MOVE 'A'                  TO LMCP-CODE-PLAN-STATUS  
                    MOVE LM001-ACTION-DATE    TO LMCP-DATE-PLAN-START   
                    MOVE SPACES               TO LMCP-REMOVE-DATE       
                    MOVE -1                   TO LMCP-REMOVE-DATE-IND   
                    MOVE SPACES               TO LMCP-LAST-BILL-DATE    
                    MOVE -1                 TO LMCP-LAST-BILL-DATE-IND  
                    PERFORM 8620-LM001-INSERT-CP                        
                       THRU 8620-LM001-EXIT                             
                    MOVE LMCP-ITEM-SEQ-NO     TO LM4F-ITEM-SEQ-NO       
                 END-IF                                                 
              ELSE                                                      
                 COMPUTE LMTMP-NO-UNITS  = LMCP-NO-UNITS - 1            
                 PERFORM 8612-LM001-UPD-CUST-UNITS                      
                    THRU 8612-LM001-EXIT                                
                                                                        
                 COMPUTE LMCP-ITEM-SEQ-NO = LMTMP-MAX-ITEM-SEQ-NO + 1   
                 MOVE 1                       TO LMCP-NO-UNITS          
                 MOVE 'A'                     TO LMCP-CODE-PLAN-STATUS  
                 MOVE LM001-ACTION-DATE       TO LMCP-DATE-PLAN-START   
                 MOVE SPACES                  TO LMCP-REMOVE-DATE       
                 MOVE -1                      TO LMCP-REMOVE-DATE-IND   
                 MOVE SPACES                  TO LMCP-LAST-BILL-DATE    
                 MOVE -1                    TO LMCP-LAST-BILL-DATE-IND  
                 PERFORM 8620-LM001-INSERT-CP                           
                    THRU 8620-LM001-EXIT                                
                 MOVE LMCP-ITEM-SEQ-NO        TO LM4F-ITEM-SEQ-NO       
              END-IF                                                    
              MOVE 'Y'                        TO LM4F-BILLING-FL        
              PERFORM 8650-LM001-UPD-LIGHT-ENVRNMT                      
                 THRU 8650-LM001-EXIT                                   
              IF LM001-NO-ERROR                                         
      ***        MNT TRANSACTION HISTORY START                                  
      ***        NO UNITS                                                       
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE SPACES             TO MI-TABLE-ID                 
                 IF LMTMP-PRE-ACT-UNITS-N = 0                           
                    MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN    
                    MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT   
                    MOVE +4               TO MI-CHG-COLUMN-VALUE-LEN    
                    MOVE '0001'           TO MI-CHG-COLUMN-VALUE-TEXT   
                 ELSE                                                   
                    MOVE +4               TO MI-PRV-COLUMN-VALUE-LEN    
                    MOVE LMTMP-PRE-ACT-UNITS                            
                                       TO MI-PRV-COLUMN-VALUE-TEXT      
                    COMPUTE LMTMP-PRE-ACT-UNITS-N                       
                                     = LMTMP-PRE-ACT-UNITS-N + 1        
                    MOVE +4               TO MI-CHG-COLUMN-VALUE-LEN    
                    MOVE LMTMP-PRE-ACT-UNITS                            
                                       TO MI-CHG-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 MOVE 'NO UNITS       '     TO MI-COLUMN-DESC           
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
      ***        DATE PLAN START                                                
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE SPACES              TO MI-TABLE-ID                
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LM001-ACTION-DATE                                 
                                          TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'DATE PLAN START'   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
      ***        CD PLAN STATUS                                                 
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE '03'               TO MI-TABLE-ID                 
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE 'I'                 TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE 'A'                 TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'CD PLAN STATUS '   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
              END-IF                                                    
           ELSE                                                         
              SET LM001-NON-DB2-ERROR TO TRUE                           
              MOVE 'NO INACTIVE LIGHT TO MAKE ACTIVE'                   
                                              TO LM001-ERR-MESSAGE      
              SET LM001-NO-INACTIVE-LIGHT TO TRUE                       
              MOVE LM001-BUSR-NO-INACTV-LGHT TO LM001-BUS-RULE-ID       
           END-IF.                                                      
      *                                                                         
       6360-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6370-LM001-ACTION-REMOVE.                                        
      *================================================================*        
      *                                                                         
           MOVE 26                    TO MH-TRAN-COMMENT-LEN            
           MOVE 'REMOVING LIGHT THROUGH LMS'                            
                                      TO MH-TRAN-COMMENT-TEXT           
           MOVE ZERO                  TO MI-TRAN-APPL-NO                
           EVALUATE TRUE                                                
              WHEN LMCP-CODE-PLAN-STATUS = 'I' AND LMCP-NO-UNITS = 1    
                 AND LM4F-BILLING-FL NOT = 'Y'                          
                 MOVE 'R'                  TO LMCP-CODE-PLAN-STATUS     
                 PERFORM 8610-LM001-UPDATE-CUST                         
                    THRU 8610-LM001-EXIT                                
                 PERFORM 8660-LM001-DEL-LIGHT-ENVRNMT                   
                    THRU 8660-LM001-EXIT                                
      ***        CD PLAN STATUS                                                 
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE '03'               TO MI-TABLE-ID                 
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE 'I'                 TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE 'R'                 TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'CD PLAN STATUS '   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
              WHEN LMCP-CODE-PLAN-STATUS = 'I' AND LMCP-NO-UNITS > 1    
                 AND LM4F-BILLING-FL NOT = 'Y'                          
                 COMPUTE LMTMP-NO-UNITS  = LMCP-NO-UNITS - 1            
                 PERFORM 8612-LM001-UPD-CUST-UNITS                      
                    THRU 8612-LM001-EXIT                                
                                                                        
                 COMPUTE LMCP-ITEM-SEQ-NO                               
                              = LMTMP-MAX-ITEM-SEQ-NO + 1               
                 MOVE 'R'                  TO LMCP-CODE-PLAN-STATUS     
                 MOVE 1                    TO LMCP-NO-UNITS             
                 PERFORM 8620-LM001-INSERT-CP                           
                    THRU 8620-LM001-EXIT                                
                 PERFORM 8660-LM001-DEL-LIGHT-ENVRNMT                   
                    THRU 8660-LM001-EXIT                                
      ***        CD PLAN STATUS                                                 
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE '03'               TO MI-TABLE-ID                 
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE 'I'                 TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE 'R'                 TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'CD PLAN STATUS '   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
              WHEN LMCP-CODE-PLAN-STATUS = 'A' AND LMCP-NO-UNITS = 1    
                   AND LM4F-BILLING-FL  = 'Y'                           
                 MOVE 'R'                     TO LMCP-CODE-PLAN-STATUS  
                 MOVE LM001-ACTION-DATE       TO LMCP-REMOVE-DATE       
                 MOVE ZERO                    TO LMCP-REMOVE-DATE-IND   
                 IF LMCP-LAST-BILL-DATE > SPACES                        
                    MOVE 0                 TO LMCP-LAST-BILL-DATE-IND   
                 ELSE                                                   
                    MOVE -1                TO LMCP-LAST-BILL-DATE-IND   
                 END-IF                                                 
                 PERFORM 8610-LM001-UPDATE-CUST                         
                    THRU 8610-LM001-EXIT                                
                 PERFORM 8660-LM001-DEL-LIGHT-ENVRNMT                   
                    THRU 8660-LM001-EXIT                                
      ***        CD PLAN STATUS                                                 
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE '03'               TO MI-TABLE-ID                 
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE 'A'                 TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE 'R'                 TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'CD PLAN STATUS '   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
      ***        REMOVE DATE                                                    
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE SPACES              TO MI-TABLE-ID                
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LMCP-REMOVE-DATE    TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'REMOVE DATE    '   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
      ***        NO UNITS                                                       
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE +4               TO MI-PRV-COLUMN-VALUE-LEN       
                 MOVE '0001'                                            
                                       TO MI-PRV-COLUMN-VALUE-TEXT      
                 COMPUTE LMTMP-PRE-ACT-UNITS-N                          
                                     = LMTMP-PRE-ACT-UNITS-N - 1        
                 MOVE +9               TO MI-CHG-COLUMN-VALUE-LEN       
                 MOVE '*DELETED*'                                       
                                       TO MI-CHG-COLUMN-VALUE-TEXT      
                 MOVE 'NO UNITS       '     TO MI-COLUMN-DESC           
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
      ***        RATE ITEM CODE                                                 
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE SPACES             TO MI-TABLE-ID                 
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE LM4F-RATE-ITEM-CODE                               
                                         TO MI-PRV-COLUMN-VALUE-TEXT    
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'                                       
                                         TO MI-CHG-COLUMN-VALUE-TEXT    
                 MOVE 'RATE ITEM CODE '  TO MI-COLUMN-DESC              
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
              WHEN LMCP-CODE-PLAN-STATUS = 'A' AND LMCP-NO-UNITS > 1    
                 AND LM4F-BILLING-FL  = 'Y'                             
                 COMPUTE LMTMP-NO-UNITS  = LMCP-NO-UNITS - 1            
                 PERFORM 8612-LM001-UPD-CUST-UNITS                      
                    THRU 8612-LM001-EXIT                                
                                                                        
                 COMPUTE LMCP-ITEM-SEQ-NO                               
                              = LMTMP-MAX-ITEM-SEQ-NO + 1               
                 MOVE 'R'                  TO LMCP-CODE-PLAN-STATUS     
                 MOVE 1                    TO LMCP-NO-UNITS             
                 MOVE LM001-ACTION-DATE     TO LMCP-REMOVE-DATE         
                 MOVE ZERO                  TO LMCP-REMOVE-DATE-IND     
                 PERFORM 8620-LM001-INSERT-CP                           
                    THRU 8620-LM001-EXIT                                
                 PERFORM 8660-LM001-DEL-LIGHT-ENVRNMT                   
                    THRU 8660-LM001-EXIT                                
      ***        CD PLAN STATUS                                                 
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE '03'               TO MI-TABLE-ID                 
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE 'A'                 TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE 'R'                 TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'CD PLAN STATUS '   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
      ***        REMOVE DATE                                                    
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 MOVE SPACES              TO MI-TABLE-ID                
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LMCP-REMOVE-DATE    TO MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE 'REMOVE DATE    '   TO MI-COLUMN-DESC             
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
      ***        NO UNITS                                                       
                 COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1         
                 IF LMTMP-PRE-ACT-UNITS-N > 0                           
                    MOVE +4               TO MI-PRV-COLUMN-VALUE-LEN    
                    MOVE LMTMP-PRE-ACT-UNITS                            
                                       TO MI-PRV-COLUMN-VALUE-TEXT      
                    COMPUTE LMTMP-PRE-ACT-UNITS-N                       
                                     = LMTMP-PRE-ACT-UNITS-N - 1        
                    MOVE +4               TO MI-CHG-COLUMN-VALUE-LEN    
                    MOVE LMTMP-PRE-ACT-UNITS                            
                                       TO MI-CHG-COLUMN-VALUE-TEXT      
                 END-IF                                                 
                 MOVE 'NO UNITS       '     TO MI-COLUMN-DESC           
                 PERFORM 6398-LM001-PROCESS-TRANS-HIST                  
                    THRU 6398-LM001-EXIT                                
              WHEN OTHER                                                
              SET LM001-NON-DB2-ERROR TO TRUE                           
              MOVE 'NO ACT/INACT LIGHT MATCH TO REMOVE'                 
                                              TO LM001-ERR-MESSAGE      
              SET LM001-ACT-INACT-LIGHT TO TRUE                         
              MOVE LM001-BUSR-NO-ACTV-INACTV-MTC TO LM001-BUS-RULE-ID   
           END-EVALUATE.                                                
      *                                                                         
      *                                                                         
       6370-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6380-LM001-ACTION-RATE-CHG.                                      
      *================================================================*        
      *                                                                         
           MOVE 40                    TO MH-TRAN-COMMENT-LEN            
           MOVE 'LIGHT RATE/RATE ITEM CHANGED THROUGH LMS'              
                                      TO MH-TRAN-COMMENT-TEXT           
           MOVE ZERO                  TO MI-TRAN-APPL-NO                
           MOVE LM4F-RATE-ITEM-CODE   TO LMTMP-RATE-ITEM-CODE           
      *                                                                         
           EVALUATE TRUE                                                
              WHEN LMCP-CODE-PLAN-STATUS = 'I' AND LMCP-NO-UNITS = 1    
                   AND LM4F-BILLING-FL NOT = 'Y'                        
                   MOVE 'R'                  TO LMCP-CODE-PLAN-STATUS   
                   PERFORM 8610-LM001-UPDATE-CUST                       
                      THRU 8610-LM001-EXIT                              
              WHEN LMCP-CODE-PLAN-STATUS = 'I' AND LMCP-NO-UNITS > 1    
                   AND LM4F-BILLING-FL NOT = 'Y'                        
                   COMPUTE LMTMP-NO-UNITS  = LMCP-NO-UNITS - 1          
                   PERFORM 8612-LM001-UPD-CUST-UNITS                    
                      THRU 8612-LM001-EXIT                              
                                                                        
                   COMPUTE LMCP-ITEM-SEQ-NO                             
                                = LMTMP-MAX-ITEM-SEQ-NO + 1             
                   MOVE 'R'                  TO LMCP-CODE-PLAN-STATUS   
                   MOVE 1                    TO LMCP-NO-UNITS           
                   PERFORM 8620-LM001-INSERT-CP                         
                      THRU 8620-LM001-EXIT                              
              WHEN LMCP-CODE-PLAN-STATUS = 'A' AND LMCP-NO-UNITS = 1    
                   AND LM4F-BILLING-FL  = 'Y'                           
                 MOVE 'R'                     TO LMCP-CODE-PLAN-STATUS  
                 MOVE LM001-ACTION-DATE       TO LMCP-REMOVE-DATE       
                 MOVE ZERO                    TO LMCP-REMOVE-DATE-IND   
                 IF LMCP-LAST-BILL-DATE > SPACES                        
                    MOVE 0                 TO LMCP-LAST-BILL-DATE-IND   
                 ELSE                                                   
                    MOVE -1                TO LMCP-LAST-BILL-DATE-IND   
                 END-IF                                                 
                 PERFORM 8610-LM001-UPDATE-CUST                         
                    THRU 8610-LM001-EXIT                                
              WHEN LMCP-CODE-PLAN-STATUS = 'A' AND LMCP-NO-UNITS > 1    
                   AND LM4F-BILLING-FL  = 'Y'                           
                   COMPUTE LMTMP-NO-UNITS  = LMCP-NO-UNITS - 1          
                   PERFORM 8612-LM001-UPD-CUST-UNITS                    
                      THRU 8612-LM001-EXIT                              
                                                                        
                   COMPUTE LMCP-ITEM-SEQ-NO                             
                                = LMTMP-MAX-ITEM-SEQ-NO + 1             
                   MOVE 'R'                  TO LMCP-CODE-PLAN-STATUS   
                   MOVE 1                    TO LMCP-NO-UNITS           
                   MOVE LM001-ACTION-DATE     TO LMCP-REMOVE-DATE       
                   MOVE ZERO                  TO LMCP-REMOVE-DATE-IND   
                   PERFORM 8620-LM001-INSERT-CP                         
                      THRU 8620-LM001-EXIT                              
              WHEN OTHER                                                
              SET LM001-NON-DB2-ERROR TO TRUE                           
              MOVE 'NO ACT/INACT LIGHT MATCH TO REMOVE'                 
                                              TO LM001-ERR-MESSAGE      
              SET LM001-ACT-INACT-LIGHT TO TRUE                         
              MOVE LM001-BUSR-NO-ACTV-INACTV-MTC TO LM001-BUS-RULE-ID   
           END-EVALUATE.                                                
      *                                                                         
           IF LM001-NO-ERROR                                            
              MOVE LM001-NEW-RATE-UTIL-TYPE   TO LMUT-CODE-UTIL-TYPE    
                                                 LM4F-CODE-UTIL-TYPE    
              MOVE LM001-NEW-RATE-PLAN-NO     TO LMUT-RATE-PLAN-NO      
                                                 LM4F-RATE-PLAN-NO      
              MOVE LM001-NEW-RATE-ITEM-CODE   TO LM4F-RATE-ITEM-CODE    
              PERFORM 7606-LM001-GET-UTIL-IC                            
                 THRU 7606-LM001-EXIT                                   
              MOVE ZEROS                 TO LMTMP-ACTIVE-CUST-COUNT     
                                            LMTMP-INACTV-CUST-COUNT     
                                            LMTMP-ACTIVE-LIGHT-COUNT    
                                            LMTMP-INACTV-LIGHT-COUNT    
                                            LMTMP-MAX-ITEM-SEQ-NO       
                                            LMCP-ITEM-SEQ-NO            
              IF LM001-IC-EXISTS                                        
                 PERFORM 7604-LM001-ENV-LIGHT-COUNT                     
                    THRU 7604-LM001-EXIT                                
      *                                                                         
                 PERFORM 7608-LM001-GET-CUST-COUNT                      
                    THRU 7608-LM001-EXIT                                
                 MOVE LMCP-ITEM-SEQ-NO   TO LMTMP-MAX-ITEM-SEQ-NO       
      *                                                                         
              END-IF                                                    
           END-IF.                                                      
           IF LM001-NO-ERROR                                            
              IF LMTMP-ACTIVE-LIGHT-COUNT = LMTMP-ACTIVE-CUST-COUNT     
              AND LMTMP-INACTV-LIGHT-COUNT = LMTMP-INACTV-CUST-COUNT    
                 CONTINUE                                               
              ELSE                                                      
                 SET LM001-NON-DB2-ERROR TO TRUE                        
                 MOVE 'NEW RATE LIGHT COUNTS NOT IN SYNC'               
                                              TO LM001-ERR-MESSAGE      
                 SET LM001-RATE-CNT-NOT-SYNC TO TRUE                    
                 MOVE LM001-BUSR-NWRT-LGHCNT-NTSYNC TO LM001-BUS-RULE-ID
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF LM001-IC-NOT-EXISTS AND LM001-NO-ERROR                    
              PERFORM 6382-LM001-CREATE-NEW-IC                          
                 THRU 6382-LM001-EXIT                                   
           END-IF                                                       
                                                                        
           IF LM001-NO-ERROR                                            
              PERFORM 6384-LM001-CREATE-NEW-CUST                        
                 THRU 6384-LM001-EXIT                                   
                                                                        
           END-IF.                                                      
                                                                        
           IF LM001-NO-ERROR                                            
              MOVE LMCP-ITEM-SEQ-NO        TO LM4F-ITEM-SEQ-NO          
              MOVE LMUT-IC-NO              TO LM4F-IC-NO                
              MOVE 'Y'                     TO LM4F-BILLING-FL           
                                                                        
              PERFORM 8650-LM001-UPD-LIGHT-ENVRNMT                      
                 THRU 8650-LM001-EXIT                                   
           END-IF.                                                      
           IF LM001-NEW-RATE-ITEM-CODE NOT = LMTMP-RATE-ITEM-CODE       
              AND LM001-NO-ERROR                                        
      ***     RATE ITEM CODE                                                    
              COMPUTE MI-TRAN-APPL-NO     = MI-TRAN-APPL-NO + 1         
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE +4                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LMTMP-RATE-ITEM-CODE                                 
                                         TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LM001-NEW-RATE-ITEM-CODE                             
                                         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE 'RATE ITEM CODE '     TO MI-COLUMN-DESC              
              PERFORM 6398-LM001-PROCESS-TRANS-HIST                     
                 THRU 6398-LM001-EXIT                                   
           END-IF.                                                      
      ***  USAGE FIXED                                                          
           IF LMCP-USAGE-FIXED > ZERO                                   
              AND LM001-NO-ERROR                                        
              COMPUTE MI-TRAN-APPL-NO  = MI-TRAN-APPL-NO + 1            
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LMCP-USAGE-FIXED      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE 'USAGE FIXED    '     TO MI-COLUMN-DESC              
              PERFORM 6398-LM001-PROCESS-TRANS-HIST                     
                 THRU 6398-LM001-EXIT                                   
           END-IF.                                                      
      *                                                                         
       6380-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6382-LM001-CREATE-NEW-IC.                                        
      *================================================================*        
      *                                                                         
           PERFORM 7612-LM001-GET-OTHER-IC-DTL                          
              THRU 7612-LM001-EXIT                                      
      *                                                                         
           IF LM001-CODE-REVENUE-CLASS > SPACES                         
              MOVE LM001-CODE-REVENUE-CLASS TO LMUT-CODE-REVENUE-CLASS  
           END-IF.                                                      
           IF SQLCODE = 100                                             
              MOVE LMAT-BILL-CYCLE    TO LMUT-READ-CYCLE                
              MOVE LM001-CODE-REVENUE-CLASS                             
                                      TO LMUT-CODE-REVENUE-CLASS        
           END-IF                                                       
      *                                                                         
                                                                        
           PERFORM 7616-LM001-CLASS-RATE                                
              THRU 7616-LM001-EXIT                                      
           IF SQLCODE = 100 OR LMQ8-STATUS-CD = 'I'                     
              SET LM001-NON-DB2-ERROR TO TRUE                           
              MOVE 'CLASS/RATE COMBINATION NOT VALID'                   
                                              TO LM001-ERR-MESSAGE      
              SET LM001-CLASS-RATE-NOT-VALID TO TRUE                    
              MOVE LM001-BUSR-CLSRT-CMB-NOT-VLD  TO LM001-BUS-RULE-ID   
           END-IF                                                       
      *                                                                         
           IF LM001-NO-ERROR                                            
              PERFORM 7614-LM001-GET-MAX-IC                             
                 THRU 7614-LM001-EXIT                                   
           END-IF.                                                      
      *                                                                         
           IF LM001-NO-ERROR                                            
              MOVE 'E'                   TO LMUT-CODE-SERVICE-TYPE      
              MOVE LM001-ACTION-DATE     TO LMUT-DATE-INSTALL           
      *                                                                         
              PERFORM 8600-LM001-INSERT-UTIL                            
                 THRU 8600-LM001-EXIT                                   
      ***     MNT TRANSACTION HISTORY START                                     
              COMPUTE MI-TRAN-APPL-NO     = MI-TRAN-APPL-NO + 1         
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LMUT-RATE-PLAN-NO     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE 'RATE PLAN NO   '     TO MI-COLUMN-DESC              
              PERFORM 6398-LM001-PROCESS-TRANS-HIST                     
                 THRU 6398-LM001-EXIT                                   
      ***     MNT TRANSACTION HISTORY END                                       
           END-IF.                                                      
      *                                                                         
       6382-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6384-LM001-CREATE-NEW-CUST.                                      
      *================================================================*        
      *                                                                         
           COMPUTE LMCP-ITEM-SEQ-NO = LMTMP-MAX-ITEM-SEQ-NO + 1         
           MOVE 'A'                      TO LMCP-CODE-PLAN-STATUS       
           MOVE 'A'                      TO LMCP-CODE-STAT-REASON       
           MOVE LM001-ACTION-DATE        TO LMCP-DATE-PLAN-START        
           MOVE ZERO                     TO LMCP-DATE-PLAN-START-IND    
           MOVE ZERO                     TO LMCP-USAGE-FIXED            
           MOVE SPACE                    TO LMTMP-LIGHT-RATE-TYPE       
           PERFORM 7624-LM001-GET-LMS-RATE THRU 7624-LM001-EXIT         
           IF LMTMP-KWH-CHRG-RATE                                       
              PERFORM 7618-LM001-GET-USAGE-FIXED                        
                 THRU 7618-LM001-EXIT                                   
           END-IF.                                                      
           MOVE ZERO                     TO LMCP-MTHLY-AMOUNT-FIXED     
           MOVE 1                        TO LMCP-NO-UNITS               
           MOVE 'E'                      TO LMCP-CODE-SERVICE-TYPE      
           MOVE SPACES                   TO LMCP-REMOVE-DATE            
           MOVE -1                       TO LMCP-REMOVE-DATE-IND        
           MOVE SPACES                   TO LMCP-DIST-NO                
           MOVE SPACES                   TO LMCP-POLE-NO                
           MOVE ZERO                     TO LMCP-LIGHT-NO               
           MOVE SPACES                   TO LMCP-LAST-BILL-DATE         
           MOVE -1                       TO LMCP-LAST-BILL-DATE-IND.    
           PERFORM 8620-LM001-INSERT-CP                                 
              THRU 8620-LM001-EXIT.                                     
      *                                                                         
       6384-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6398-LM001-PROCESS-TRANS-HIST.                                   
      *================================================================*        
           IF MI-TRAN-APPL-NO = 1                                       
              MOVE SPACES                TO LMTMP-RESP-AREA-ID          
              PERFORM 7620-LM001-GET-RESP-AREA                          
                 THRU 7620-LM001-EXIT                                   
              PERFORM 7622-LM001-SELECT-TIMESTAMP                       
                 THRU 7622-LM001-EXIT                                   
              MOVE LMTMP-TIMESTAMP       TO MH-TRANS-HIST-SEQ-NO        
              MOVE LM001-ACTION-DATE     TO MH-DATE-TRANS               
              MOVE 'F'                   TO MH-CODE-TRAN-TYPE           
              MOVE LMTMP-RESP-AREA-ID    TO MH-RESP-AREA-ID             
              MOVE LMAT-ACCOUNT-NO       TO MH-ACCOUNT-NO               
              MOVE LMAT-CUSTOMER-NO      TO MH-CUSTOMER-NO              
              MOVE LMAT-PREMISE-NO       TO MH-PREMISE-NO               
              MOVE LM001-USER-ID         TO MH-USER-ID                  
              MOVE LM001-PROGRAM-NAME    TO MH-APPL-PROGRAM-ID          
     ***      MOVE +21                   TO MH-TRAN-COMMENT-LEN                 
     ***      MOVE 'LMS LIGHT MAINT'     TO MH-TRAN-COMMENT-TEXT                
              PERFORM 8670-LM001-MN-TRANS-HIST                          
                 THRU 8670-LM001-EXIT                                   
           END-IF                                                       
                                                                        
           PERFORM 8680-LM001-MN-TRN-HST-DET THRU 8680-LM001-EXIT.      
                                                                        
       6398-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7600-LM001-VALIDATE-ACCOUNT.                                     
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT CUSTOMER_NO                                        
                    ,BILL_CYCLE                                         
                    ,CODE_ACCT_STAT                                     
                    ,LOCAL_OFFICE                                       
                    ,PREMISE_NO                                         
                    ,COMPANY_NO                                         
                INTO :LMAT-CUSTOMER-NO                                  
                    ,:LMAT-BILL-CYCLE                                   
                    ,:LMAT-CODE-ACCT-STAT                               
                    ,:LMAT-LOCAL-OFFICE                                 
                    ,:LMAT-PREMISE-NO                                   
                    ,:LMAT-COMPANY-NO                                   
              FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                            
              WHERE ACCOUNT_NO   = :LMAT-ACCOUNT-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*             ,BILL_CYCLE                                                 
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*         INTO :LMAT-CUSTOMER-NO                                          
MFA-TR*             ,:LMAT-BILL-CYCLE                                           
MFA-TR*             ,:LMAT-CODE-ACCT-STAT                                       
MFA-TR*             ,:LMAT-LOCAL-OFFICE                                         
MFA-TR*             ,:LMAT-PREMISE-NO                                           
MFA-TR*             ,:LMAT-COMPANY-NO                                           
MFA-TR*       FROM CSS_ACCOUNT                                                  
MFA-TR*       WHERE ACCOUNT_NO   = :LMAT-ACCOUNT-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR  TO TRUE                              
              IF SQLCODE = NOT-FOUND                                    
                 MOVE 'ACCOUNT NOT FOUND'                               
                                      TO LM001-ERR-MESSAGE              
              ELSE                                                      
                 MOVE 'ERROR IN SELECTING ACCOUNT DETAILS'              
                                      TO LM001-ERR-MESSAGE              
              END-IF                                                    
              MOVE SQLCODE TO LM001-ERR-SQLCODE                         
              MOVE 'SELECT'  TO LM001-ERR-FUNCTION                      
              MOVE '7600'   TO LM001-ERR-PARAGRAPH-NO                   
              MOVE '7600-LM001-VALIDATE-ACCOUNT'                        
                           TO LM001-ERR-PARAGRAPH-NAME                  
              MOVE 'CSS_ACCOUNT'       TO LM001-ERR-TABLE1              
              MOVE 'ACCOUNT_NO'        TO LM001-ERR-COLUMN-1            
              MOVE LMAT-ACCOUNT-NO     TO LM001-ERR-HOSTVAR-1           
           END-IF.                                                      
      *                                                                         
       7600-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       7602-LM001-GET-LIGHT-ENVRNMT.                                    
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT INSTALL_LOC_CD                                     
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,RATE_PLAN_NO                                       
                    ,RATE_ITEM_CODE                                     
                    ,ITEM_SEQ_NO                                        
                    ,BILLING_FL                                         
                INTO :LM4F-INSTALL-LOC-CD                               
                    ,:LM4F-CODE-UTIL-TYPE                               
                    ,:LM4F-IC-NO                                        
                    ,:LM4F-RATE-PLAN-NO                                 
                    ,:LM4F-RATE-ITEM-CODE                               
                    ,:LM4F-ITEM-SEQ-NO                                  
                    ,:LM4F-BILLING-FL                                   
              FROM LMS_EQUIP_ENVRNMT WITH(READUNCOMMITTED)                      
              WHERE INSTALL_LOC_NO =   :LM4F-INSTALL-LOC-NO             
                AND INSTALL_POINT_NO = :LM4F-INSTALL-POINT-NO           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT INSTALL_LOC_CD                                             
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_ITEM_CODE                                             
MFA-TR*             ,ITEM_SEQ_NO                                                
MFA-TR*             ,BILLING_FL                                                 
MFA-TR*         INTO :LM4F-INSTALL-LOC-CD                                       
MFA-TR*             ,:LM4F-CODE-UTIL-TYPE                                       
MFA-TR*             ,:LM4F-IC-NO                                                
MFA-TR*             ,:LM4F-RATE-PLAN-NO                                         
MFA-TR*             ,:LM4F-RATE-ITEM-CODE                                       
MFA-TR*             ,:LM4F-ITEM-SEQ-NO                                          
MFA-TR*             ,:LM4F-BILLING-FL                                           
MFA-TR*       FROM LMS_EQUIP_ENVRNMT                                            
MFA-TR*       WHERE INSTALL_LOC_NO =   :LM4F-INSTALL-LOC-NO                     
MFA-TR*         AND INSTALL_POINT_NO = :LM4F-INSTALL-POINT-NO                   
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR  TO TRUE                              
              IF SQLCODE = 100                                          
                 MOVE 'LIGHT ENVRNMT NOT FOUND'                         
                                      TO LM001-ERR-MESSAGE              
              ELSE                                                      
                 MOVE 'ERROR IN SELECTING LIGHT ENVRNMT'                
                                      TO LM001-ERR-MESSAGE              
              END-IF                                                    
              MOVE SQLCODE               TO LM001-ERR-SQLCODE           
              MOVE 'SELECT'              TO LM001-ERR-FUNCTION          
              MOVE '7602'                TO LM001-ERR-PARAGRAPH-NO      
              MOVE '7602-LM001-GET-LIGHT-ENVRNMT'                       
                                         TO LM001-ERR-PARAGRAPH-NAME    
              MOVE 'LMS_EQUIP_ENVRNMT'   TO LM001-ERR-TABLE1            
              MOVE 'INSTALL_LOC_NO'      TO LM001-ERR-COLUMN-1          
              MOVE 'INSTALL_POINT_NO'    TO LM001-ERR-COLUMN-2          
              MOVE LM4F-INSTALL-LOC-NO   TO LM001-ERR-HOSTVAR-1         
              MOVE LM4F-INSTALL-POINT-NO TO LM001-ERR-HOSTVAR-2         
           END-IF.                                                      
      *                                                                         
       7602-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7604-LM001-ENV-LIGHT-COUNT.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(CASE WHEN BILLING_FL = 'Y'                     
                          THEN 1 ELSE 0 END)                            
                    ,SUM(CASE WHEN BILLING_FL = 'Y'                     
                          THEN 0 ELSE 1 END)                            
                INTO :LMTMP-ACTIVE-LIGHT-COUNT :LMTMP-ACTIVE-NULL-IND    
                    ,:LMTMP-INACTV-LIGHT-COUNT :LMTMP-INACTV-NULL-IND    
              FROM LMS_EQUIP_ENVRNMT WITH(READUNCOMMITTED)                      
              WHERE INSTALL_LOC_NO =   :LM4F-INSTALL-LOC-NO             
                AND CODE_UTIL_TYPE =   :LM4F-CODE-UTIL-TYPE             
                AND RATE_PLAN_NO   =   :LM4F-RATE-PLAN-NO               
                AND RATE_ITEM_CODE =   :LM4F-RATE-ITEM-CODE             
                AND BILLING_FL     IN (' ', 'N', 'Y')                   
                GROUP BY INSTALL_LOC_NO                                 
                        ,CODE_UTIL_TYPE                                 
                        ,RATE_PLAN_NO                                   
                        ,RATE_ITEM_CODE                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(CASE WHEN BILLING_FL = 'Y'                             
MFA-TR*                   THEN 1 ELSE 0 END)                                    
MFA-TR*             ,SUM(CASE WHEN BILLING_FL = 'Y'                             
MFA-TR*                   THEN 0 ELSE 1 END)                                    
MFA-TR*         INTO :LMTMP-ACTIVE-LIGHT-COUNT:LMTMP-ACTIVE-NULL-IND            
MFA-TR*             ,:LMTMP-INACTV-LIGHT-COUNT:LMTMP-INACTV-NULL-IND            
MFA-TR*       FROM LMS_EQUIP_ENVRNMT                                            
MFA-TR*       WHERE INSTALL_LOC_NO =   :LM4F-INSTALL-LOC-NO                     
MFA-TR*         AND CODE_UTIL_TYPE =   :LM4F-CODE-UTIL-TYPE                     
MFA-TR*         AND RATE_PLAN_NO   =   :LM4F-RATE-PLAN-NO                       
MFA-TR*         AND RATE_ITEM_CODE =   :LM4F-RATE-ITEM-CODE                     
MFA-TR*         AND BILLING_FL     IN (' ', 'N', 'Y')                           
MFA-TR*         GROUP BY INSTALL_LOC_NO                                         
MFA-TR*                 ,CODE_UTIL_TYPE                                         
MFA-TR*                 ,RATE_PLAN_NO                                           
MFA-TR*                 ,RATE_ITEM_CODE                                         
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0 OR SQLCODE = 100                              
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR        TO TRUE                        
              MOVE 'ERROR IN SELECTING LIGHT ENVRNMT'                   
                                         TO LM001-ERR-MESSAGE           
              MOVE SQLCODE               TO LM001-ERR-SQLCODE           
              MOVE 'SELECT'              TO LM001-ERR-FUNCTION          
              MOVE '7604'                TO LM001-ERR-PARAGRAPH-NO      
              MOVE '7604-LM001-ENV-LIGHT-COUNT'                         
                                         TO LM001-ERR-PARAGRAPH-NAME    
              MOVE 'LMS_EQUIP_ENVRNMT'   TO LM001-ERR-TABLE1            
              MOVE 'INSTALL_LOC_NO'      TO LM001-ERR-COLUMN-1          
              MOVE 'CODE_UTIL_TYPE'      TO LM001-ERR-COLUMN-2          
              MOVE 'RATE_PLAN_NO  '      TO LM001-ERR-COLUMN-3          
              MOVE 'RATE_ITEM_CODE'      TO LM001-ERR-COLUMN-4          
              MOVE LM4F-INSTALL-LOC-NO   TO LM001-ERR-HOSTVAR-1         
              MOVE LM4F-CODE-UTIL-TYPE   TO LM001-ERR-HOSTVAR-2         
              MOVE LM4F-RATE-PLAN-NO     TO LM001-ERR-HOSTVAR-3         
              MOVE LM4F-RATE-ITEM-CODE   TO LM001-ERR-HOSTVAR-4         
           END-IF.                                                      
      *                                                                         
       7604-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7606-LM001-GET-UTIL-IC.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT IC_NO                                              
                INTO :LMUT-IC-NO                                        
              FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                       
              WHERE ACCOUNT_NO     =   :LMAT-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE =   :LMUT-CODE-UTIL-TYPE             
                AND RATE_PLAN_NO   =   :LMUT-RATE-PLAN-NO               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IC_NO                                                      
MFA-TR*         INTO :LMUT-IC-NO                                                
MFA-TR*       FROM CSS_UTIL_ENVRNMT                                             
MFA-TR*       WHERE ACCOUNT_NO     =   :LMAT-ACCOUNT-NO                         
MFA-TR*         AND CODE_UTIL_TYPE =   :LMUT-CODE-UTIL-TYPE                     
MFA-TR*         AND RATE_PLAN_NO   =   :LMUT-RATE-PLAN-NO                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EVALUATE TRUE                                                
              WHEN SQLCODE = 0                                          
                 SET LM001-IC-EXISTS     TO TRUE                        
              WHEN SQLCODE = 100                                        
                 SET LM001-IC-NOT-EXISTS TO TRUE                        
              WHEN SQLCODE = -811                                       
                 PERFORM 7607-LM001-CHK-IC-4MULT-IC-ACT                 
                                           THRU 7607-LM001-EXIT         
              WHEN OTHER                                                
                 SET LM001-DB2-ERROR     TO TRUE                        
                 MOVE 'ERROR IN SELECTING LIGHT ENVRNMT'                
                                         TO LM001-ERR-MESSAGE           
                 MOVE SQLCODE            TO LM001-ERR-SQLCODE           
                 MOVE 'SELECT'           TO LM001-ERR-FUNCTION          
                 MOVE '7606'             TO LM001-ERR-PARAGRAPH-NO      
                 MOVE '7606-LM001-GET-UTIL-IC'                          
                                         TO LM001-ERR-PARAGRAPH-NAME    
                 MOVE 'CSS_UTIL_ENVRNMT' TO LM001-ERR-TABLE1            
                 MOVE 'ACCOUNT_NO    '   TO LM001-ERR-COLUMN-1          
                 MOVE 'CODE_UTIL_TYPE'   TO LM001-ERR-COLUMN-2          
                 MOVE 'RATE_PLAN_NO'     TO LM001-ERR-COLUMN-3          
                 MOVE LMAT-ACCOUNT-NO    TO LM001-ERR-HOSTVAR-1         
                 MOVE LMUT-CODE-UTIL-TYPE   TO LM001-ERR-HOSTVAR-2      
                 MOVE LMUT-RATE-PLAN-NO     TO LM001-ERR-HOSTVAR-3      
           END-EVALUATE.                                                
      *                                                                         
       7606-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7607-LM001-CHK-IC-4MULT-IC-ACT.                                  
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT IC_NO                                              
                INTO :LMUT-IC-NO                                        
              FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO     =   :LMAT-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE =   :LMUT-CODE-UTIL-TYPE             
                AND RATE_PLAN_NO   =   :LMUT-RATE-PLAN-NO               
                AND EXISTS                                              
                     (SELECT 1                                          
                        FROM CSS_CUST_PLAN  CP WITH(READUNCOMMITTED)            
                       WHERE CP.ACCOUNT_NO       = UT.ACCOUNT_NO        
                         AND CP.CODE_UTIL_TYPE   = UT.CODE_UTIL_TYPE    
                         AND CP.IC_NO            = UT.IC_NO             
                         AND CP.CODE_PLAN_STATUS IN ('A','I') )         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IC_NO                                                      
MFA-TR*         INTO :LMUT-IC-NO                                                
MFA-TR*       FROM CSS_UTIL_ENVRNMT UT                                          
MFA-TR*       WHERE ACCOUNT_NO     =   :LMAT-ACCOUNT-NO                         
MFA-TR*         AND CODE_UTIL_TYPE =   :LMUT-CODE-UTIL-TYPE                     
MFA-TR*         AND RATE_PLAN_NO   =   :LMUT-RATE-PLAN-NO                       
MFA-TR*         AND EXISTS                                                      
MFA-TR*              (SELECT 1                                                  
MFA-TR*                 FROM CSS_CUST_PLAN  CP                                  
MFA-TR*                WHERE CP.ACCOUNT_NO       = UT.ACCOUNT_NO                
MFA-TR*                  AND CP.CODE_UTIL_TYPE   = UT.CODE_UTIL_TYPE            
MFA-TR*                  AND CP.IC_NO            = UT.IC_NO                     
MFA-TR*                  AND CP.CODE_PLAN_STATUS IN ('A','I') )                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EVALUATE TRUE                                                
              WHEN SQLCODE = 0                                          
                 SET LM001-IC-EXISTS     TO TRUE                        
              WHEN SQLCODE = 100                                        
                 SET LM001-IC-NOT-EXISTS TO TRUE                        
              WHEN OTHER                                                
                 SET LM001-DB2-ERROR     TO TRUE                        
                 MOVE 'ERROR IN SELECTING LIGHT ENVRNMT'                
                                         TO LM001-ERR-MESSAGE           
                 MOVE SQLCODE            TO LM001-ERR-SQLCODE           
                 MOVE 'SELECT'           TO LM001-ERR-FUNCTION          
                 MOVE '7607'             TO LM001-ERR-PARAGRAPH-NO      
                 MOVE '7607-LM001-CHK-IC-4MULT-IC-ACT'                  
                                         TO LM001-ERR-PARAGRAPH-NAME    
                 MOVE 'CSS_UTIL_ENVRNMT' TO LM001-ERR-TABLE1            
                 MOVE 'ACCOUNT_NO    '   TO LM001-ERR-COLUMN-1          
                 MOVE 'CODE_UTIL_TYPE'   TO LM001-ERR-COLUMN-2          
                 MOVE 'RATE_PLAN_NO'     TO LM001-ERR-COLUMN-3          
                 MOVE LMAT-ACCOUNT-NO    TO LM001-ERR-HOSTVAR-1         
                 MOVE LMUT-CODE-UTIL-TYPE   TO LM001-ERR-HOSTVAR-2      
                 MOVE LMUT-RATE-PLAN-NO     TO LM001-ERR-HOSTVAR-3      
           END-EVALUATE.                                                
      *                                                                         
       7607-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7608-LM001-GET-CUST-COUNT.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(CASE WHEN CODE_PLAN_STATUS = 'A'               
                          THEN NO_UNITS ELSE 0 END)                     
                    ,SUM(CASE WHEN CODE_PLAN_STATUS = 'I'               
                          THEN NO_UNITS ELSE 0 END)                     
                    ,MAX(ITEM_SEQ_NO)                                   
                INTO :LMTMP-ACTIVE-CUST-COUNT :LMTMP-ACTIVE-NULL-IND     
                    ,:LMTMP-INACTV-CUST-COUNT :LMTMP-INACTV-NULL-IND     
                    ,:LMCP-ITEM-SEQ-NO :LMTMP-CUST-NULL-IND              
              FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO     =   :LMAT-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE =   :LMUT-CODE-UTIL-TYPE             
                AND IC_NO          =   :LMUT-IC-NO                      
                AND RATE_ITEM_CODE =   :LM4F-RATE-ITEM-CODE             
                GROUP BY ACCOUNT_NO                                     
                        ,CODE_UTIL_TYPE                                 
                        ,IC_NO                                          
                        ,RATE_ITEM_CODE                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(CASE WHEN CODE_PLAN_STATUS = 'A'                       
MFA-TR*                   THEN NO_UNITS ELSE 0 END)                             
MFA-TR*             ,SUM(CASE WHEN CODE_PLAN_STATUS = 'I'                       
MFA-TR*                   THEN NO_UNITS ELSE 0 END)                             
MFA-TR*             ,MAX(ITEM_SEQ_NO)                                           
MFA-TR*         INTO :LMTMP-ACTIVE-CUST-COUNT:LMTMP-ACTIVE-NULL-IND             
MFA-TR*             ,:LMTMP-INACTV-CUST-COUNT:LMTMP-INACTV-NULL-IND             
MFA-TR*             ,:LMCP-ITEM-SEQ-NO:LMTMP-CUST-NULL-IND                      
MFA-TR*       FROM CSS_CUST_PLAN                                                
MFA-TR*       WHERE ACCOUNT_NO     =   :LMAT-ACCOUNT-NO                         
MFA-TR*         AND CODE_UTIL_TYPE =   :LMUT-CODE-UTIL-TYPE                     
MFA-TR*         AND IC_NO          =   :LMUT-IC-NO                              
MFA-TR*         AND RATE_ITEM_CODE =   :LM4F-RATE-ITEM-CODE                     
MFA-TR*         GROUP BY ACCOUNT_NO                                             
MFA-TR*                 ,CODE_UTIL_TYPE                                         
MFA-TR*                 ,IC_NO                                                  
MFA-TR*                 ,RATE_ITEM_CODE                                         
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0 OR SQLCODE = 100                              
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR        TO TRUE                        
              MOVE 'ERROR IN SELECTING LIGHT ENVRNMT'                   
                                         TO LM001-ERR-MESSAGE           
              MOVE SQLCODE               TO LM001-ERR-SQLCODE           
              MOVE 'SELECT'              TO LM001-ERR-FUNCTION          
              MOVE '7608'                TO LM001-ERR-PARAGRAPH-NO      
              MOVE '7608-LM001-GET-CUST-COUNT'                          
                                         TO LM001-ERR-PARAGRAPH-NAME    
              MOVE 'CSS_CUST_PLAN'       TO LM001-ERR-TABLE1            
              MOVE 'ACCOUNT_NO    '      TO LM001-ERR-COLUMN-1          
              MOVE 'CODE_UTIL_TYPE'      TO LM001-ERR-COLUMN-2          
              MOVE 'IC_NO         '      TO LM001-ERR-COLUMN-3          
              MOVE 'RATE_ITEM_CODE'      TO LM001-ERR-COLUMN-4          
              MOVE LMAT-ACCOUNT-NO       TO LM001-ERR-HOSTVAR-1         
              MOVE LMUT-CODE-UTIL-TYPE   TO LM001-ERR-HOSTVAR-2         
              MOVE LMUT-IC-NO            TO LM001-ERR-HOSTVAR-3         
              MOVE LM4F-RATE-ITEM-CODE   TO LM001-ERR-HOSTVAR-4         
           END-IF.                                                      
      *                                                                         
       7608-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7610-LM001-SELECT-CUST-PLAN.                                     
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT CODE_PLAN_STATUS                                   
                    ,CODE_STAT_REASON                                   
                    ,DATE_PLAN_START                                    
                    ,CODE_SERVICE_TYPE                                  
                    ,USAGE_FIXED                                        
                    ,MTHLY_AMOUNT_FIXED                                 
                    ,NO_UNITS                                           
                    ,REMOVE_DATE                                        
                    ,DIST_NO                                            
                    ,POLE_NO                                            
                    ,LIGHT_NO                                           
                    ,LAST_BILL_DATE                                     
                INTO :LMCP-CODE-PLAN-STATUS                             
                    ,:LMCP-CODE-STAT-REASON                             
                    ,:LMCP-DATE-PLAN-START :LMCP-DATE-PLAN-START-IND     
                    ,:LMCP-CODE-SERVICE-TYPE                            
                    ,:LMCP-USAGE-FIXED                                  
                    ,:LMCP-MTHLY-AMOUNT-FIXED                           
                    ,:LMCP-NO-UNITS                                     
                    ,:LMCP-REMOVE-DATE :LMCP-REMOVE-DATE-IND             
                    ,:LMCP-DIST-NO                                      
                    ,:LMCP-POLE-NO                                      
                    ,:LMCP-LIGHT-NO                                     
                    ,:LMCP-LAST-BILL-DATE :LMCP-LAST-BILL-DATE-IND       
              FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO     =   :LMAT-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE =   :LMUT-CODE-UTIL-TYPE             
                AND IC_NO          =   :LMUT-IC-NO                      
                AND RATE_ITEM_CODE =   :LM4F-RATE-ITEM-CODE             
                AND ITEM_SEQ_NO    =   :LMCP-ITEM-SEQ-NO                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_PLAN_STATUS                                           
MFA-TR*             ,CODE_STAT_REASON                                           
MFA-TR*             ,DATE_PLAN_START                                            
MFA-TR*             ,CODE_SERVICE_TYPE                                          
MFA-TR*             ,USAGE_FIXED                                                
MFA-TR*             ,MTHLY_AMOUNT_FIXED                                         
MFA-TR*             ,NO_UNITS                                                   
MFA-TR*             ,REMOVE_DATE                                                
MFA-TR*             ,DIST_NO                                                    
MFA-TR*             ,POLE_NO                                                    
MFA-TR*             ,LIGHT_NO                                                   
MFA-TR*             ,LAST_BILL_DATE                                             
MFA-TR*         INTO :LMCP-CODE-PLAN-STATUS                                     
MFA-TR*             ,:LMCP-CODE-STAT-REASON                                     
MFA-TR*             ,:LMCP-DATE-PLAN-START:LMCP-DATE-PLAN-START-IND             
MFA-TR*             ,:LMCP-CODE-SERVICE-TYPE                                    
MFA-TR*             ,:LMCP-USAGE-FIXED                                          
MFA-TR*             ,:LMCP-MTHLY-AMOUNT-FIXED                                   
MFA-TR*             ,:LMCP-NO-UNITS                                             
MFA-TR*             ,:LMCP-REMOVE-DATE:LMCP-REMOVE-DATE-IND                     
MFA-TR*             ,:LMCP-DIST-NO                                              
MFA-TR*             ,:LMCP-POLE-NO                                              
MFA-TR*             ,:LMCP-LIGHT-NO                                             
MFA-TR*             ,:LMCP-LAST-BILL-DATE:LMCP-LAST-BILL-DATE-IND               
MFA-TR*       FROM CSS_CUST_PLAN                                                
MFA-TR*       WHERE ACCOUNT_NO     =   :LMAT-ACCOUNT-NO                         
MFA-TR*         AND CODE_UTIL_TYPE =   :LMUT-CODE-UTIL-TYPE                     
MFA-TR*         AND IC_NO          =   :LMUT-IC-NO                              
MFA-TR*         AND RATE_ITEM_CODE =   :LM4F-RATE-ITEM-CODE                     
MFA-TR*         AND ITEM_SEQ_NO    =   :LMCP-ITEM-SEQ-NO                        
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR        TO TRUE                        
              MOVE 'CUST PLAN RECORDS NOT FOUND'                        
                                         TO LM001-ERR-MESSAGE           
              MOVE SQLCODE               TO LM001-ERR-SQLCODE           
              MOVE 'SELECT'              TO LM001-ERR-FUNCTION          
              MOVE '7610'                TO LM001-ERR-PARAGRAPH-NO      
              MOVE '7610-LM001-SELECT-CUST-PLAN'                        
                                         TO LM001-ERR-PARAGRAPH-NAME    
              MOVE 'CSS_CUST_PLAN    '   TO LM001-ERR-TABLE1            
              MOVE 'ACCOUNT_NO    '      TO LM001-ERR-COLUMN-1          
              MOVE 'CODE_UTIL_TYPE'      TO LM001-ERR-COLUMN-2          
              MOVE 'IC_NO         '      TO LM001-ERR-COLUMN-3          
              MOVE 'RATE_ITEM_CODE'      TO LM001-ERR-COLUMN-4          
              MOVE LMAT-ACCOUNT-NO       TO LM001-ERR-HOSTVAR-1         
              MOVE LMUT-CODE-UTIL-TYPE   TO LM001-ERR-HOSTVAR-2         
              MOVE LMUT-IC-NO            TO LM001-ERR-HOSTVAR-3         
              MOVE LM4F-RATE-ITEM-CODE   TO LM001-ERR-HOSTVAR-4         
           END-IF.                                                      
      *                                                                         
       7610-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7612-LM001-GET-OTHER-IC-DTL.                                     
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_REVENUE_CLASS,
              READ_ROUTE,
              READ_CYCLE                                         
                INTO :LMUT-CODE-REVENUE-CLASS                           
                    ,:LMUT-READ-ROUTE                                   
                    ,:LMUT-READ-CYCLE                                   
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :LMAT-ACCOUNT-NO                  
               ORDER BY CODE_UTIL_TYPE                                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_REVENUE_CLASS                                         
MFA-TR*             ,READ_ROUTE                                                 
MFA-TR*             ,READ_CYCLE                                                 
MFA-TR*         INTO :LMUT-CODE-REVENUE-CLASS                                   
MFA-TR*             ,:LMUT-READ-ROUTE                                           
MFA-TR*             ,:LMUT-READ-CYCLE                                           
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO     = :LMAT-ACCOUNT-NO                          
MFA-TR*        ORDER BY CODE_UTIL_TYPE                                          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7612                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0 OR SQLCODE = 100                              
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR IN SELECTING LIGHT ENVRNMT'                   
                                   TO LM001-ERR-MESSAGE                 
              MOVE SQLCODE TO LM001-ERR-SQLCODE                         
              MOVE 'SELECT'  TO LM001-ERR-FUNCTION                      
              MOVE '7612'    TO LM001-ERR-PARAGRAPH-NO                  
              MOVE '7612-LM001-GET-MAX-IC'                              
                            TO LM001-ERR-PARAGRAPH-NAME                 
              MOVE 'CSS_UTIL_ENVRNMT'  TO LM001-ERR-TABLE1              
              MOVE 'ACCOUNT_NO    '    TO LM001-ERR-COLUMN-1            
              MOVE LMAT-ACCOUNT-NO       TO LM001-ERR-HOSTVAR-1         
           END-IF.                                                      
      *                                                                         
       7612-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7614-LM001-GET-MAX-IC.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT COALESCE(MAX(IC_NO), 0) + 1                        
                INTO :LMUT-IC-NO                                        
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE UT.ACCOUNT_NO     = :LMAT-ACCOUNT-NO               
                 AND UT.CODE_UTIL_TYPE = :LMUT-CODE-UTIL-TYPE           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COALESCE(MAX(IC_NO), 0) + 1                                
MFA-TR*         INTO :LMUT-IC-NO                                                
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.ACCOUNT_NO     = :LMAT-ACCOUNT-NO                       
MFA-TR*          AND UT.CODE_UTIL_TYPE = :LMUT-CODE-UTIL-TYPE                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7614                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0 OR SQLCODE = 100                              
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR        TO TRUE                        
              MOVE 'ERROR IN SELECTING LIGHT ENVRNMT'                   
                                         TO LM001-ERR-MESSAGE           
              MOVE SQLCODE               TO LM001-ERR-SQLCODE           
              MOVE 'SELECT'              TO LM001-ERR-FUNCTION          
              MOVE '7614'                TO LM001-ERR-PARAGRAPH-NO      
              MOVE '7614-LM001-GET-MAX-IC'                              
                                         TO LM001-ERR-PARAGRAPH-NAME    
              MOVE 'CSS_UTIL_ENVRNMT'    TO LM001-ERR-TABLE1            
              MOVE 'ACCOUNT_NO    '      TO LM001-ERR-COLUMN-1          
              MOVE 'CODE_UTIL_TYPE'      TO LM001-ERR-COLUMN-2          
              MOVE LMAT-ACCOUNT-NO       TO LM001-ERR-HOSTVAR-1         
              MOVE LMUT-CODE-UTIL-TYPE   TO LM001-ERR-HOSTVAR-2         
           END-IF.                                                      
      *                                                                         
       7614-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7616-LM001-CLASS-RATE.                                           
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               SELECT STATUS_CD                                         
                 INTO :LMQ8-STATUS-CD                                   
                 FROM CSS_REV_CLS_RATE WITH(READUNCOMMITTED)                    
                WHERE RATE_PLAN_NO       = :LMUT-RATE-PLAN-NO           
                  AND CODE_REVENUE_CLASS = :LMUT-CODE-REVENUE-CLASS     
                  AND CODE_UTIL_TYPE     = :LMUT-CODE-UTIL-TYPE         
                  AND COMPANY_NO         = :LMAT-COMPANY-NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT STATUS_CD                                                 
MFA-TR*          INTO :LMQ8-STATUS-CD                                           
MFA-TR*          FROM CSS_REV_CLS_RATE                                          
MFA-TR*         WHERE RATE_PLAN_NO       = :LMUT-RATE-PLAN-NO                   
MFA-TR*           AND CODE_REVENUE_CLASS = :LMUT-CODE-REVENUE-CLASS             
MFA-TR*           AND CODE_UTIL_TYPE     = :LMUT-CODE-UTIL-TYPE                 
MFA-TR*           AND COMPANY_NO         = :LMAT-COMPANY-NO                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7616                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0 OR SQLCODE = 100                              
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR             TO TRUE                   
              MOVE 'ERROR IN SELECTING LIGHT ENVRNMT'                   
                                              TO LM001-ERR-MESSAGE      
              MOVE SQLCODE                    TO LM001-ERR-SQLCODE      
              MOVE 'SELECT'                   TO LM001-ERR-FUNCTION     
              MOVE '7616'                     TO LM001-ERR-PARAGRAPH-NO 
              MOVE '7616-LM001-CLASS-RATE'                              
                                            TO LM001-ERR-PARAGRAPH-NAME 
              MOVE 'CSS_REV_CLS_RATE'         TO LM001-ERR-TABLE1       
              MOVE 'RATE_PLAN_NO '            TO LM001-ERR-COLUMN-1     
              MOVE 'CODE_REVENUE_CLASS '      TO LM001-ERR-COLUMN-2     
              MOVE 'CODE_UTIL_TYPE '          TO LM001-ERR-COLUMN-3     
              MOVE 'COMPANY_NO '              TO LM001-ERR-COLUMN-4     
              MOVE LMUT-RATE-PLAN-NO          TO LM001-ERR-HOSTVAR-1    
              MOVE LMUT-CODE-REVENUE-CLASS    TO LM001-ERR-HOSTVAR-2    
              MOVE LMUT-CODE-UTIL-TYPE        TO LM001-ERR-HOSTVAR-3    
              MOVE LMAT-COMPANY-NO            TO LM001-ERR-HOSTVAR-4    
           END-IF.                                                      
      *                                                                         
       7616-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7618-LM001-GET-USAGE-FIXED.                                      
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT L9.UM_EQUIP_KWH                                    
                INTO  :LMCP-USAGE-FIXED                                 
                FROM CSS_UM_EQUIPMENT L9 WITH(READUNCOMMITTED)                  
                    ,CSS_UNMTR_PLAN   UP WITH(READUNCOMMITTED)                  
              WHERE L9.UM_EQUIP_ID      = UP.UM_EQUIP_ID                
               AND  L9.STATUS_CD        =  'A'                          
               AND  L9.UM_EQUIP_TYPE_CD =  'F'                          
               AND  UP.CODE_UTIL_TYPE   = :LM4F-CODE-UTIL-TYPE          
               AND  UP.RATE_PLAN_NO     = :LM4F-RATE-PLAN-NO            
               AND  UP.RATE_ITEM_CODE   = :LM4F-RATE-ITEM-CODE          
               AND  UP.VERSION_NO_CNTRL =                               
                 (SELECT MAX(RT.VERSION_NO_CNTRL)                       
                   FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)               
                    WHERE RT.CODE_UTIL_TYPE = UP.CODE_UTIL_TYPE         
                     AND RT.RATE_PLAN_NO    = UP.RATE_PLAN_NO           
                     AND RT.CODE_STATUS     = 'A')                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT L9.UM_EQUIP_KWH                                            
MFA-TR*         INTO  :LMCP-USAGE-FIXED                                         
MFA-TR*         FROM CSS_UM_EQUIPMENT L9                                        
MFA-TR*             ,CSS_UNMTR_PLAN   UP                                        
MFA-TR*       WHERE L9.UM_EQUIP_ID      = UP.UM_EQUIP_ID                        
MFA-TR*        AND  L9.STATUS_CD        =  'A'                                  
MFA-TR*        AND  L9.UM_EQUIP_TYPE_CD =  'F'                                  
MFA-TR*        AND  UP.CODE_UTIL_TYPE   = :LM4F-CODE-UTIL-TYPE                  
MFA-TR*        AND  UP.RATE_PLAN_NO     = :LM4F-RATE-PLAN-NO                    
MFA-TR*        AND  UP.RATE_ITEM_CODE   = :LM4F-RATE-ITEM-CODE                  
MFA-TR*        AND  UP.VERSION_NO_CNTRL =                                       
MFA-TR*          (SELECT MAX(RT.VERSION_NO_CNTRL)                               
MFA-TR*            FROM CSS_RATE_CREATOR RT                                     
MFA-TR*             WHERE RT.CODE_UTIL_TYPE = UP.CODE_UTIL_TYPE                 
MFA-TR*              AND RT.RATE_PLAN_NO    = UP.RATE_PLAN_NO                   
MFA-TR*              AND RT.CODE_STATUS     = 'A')                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7618                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR        TO TRUE                        
              MOVE 'ERROR IN SELECTING FIXED USAGE'                     
                                         TO LM001-ERR-MESSAGE           
              MOVE SQLCODE               TO LM001-ERR-SQLCODE           
              MOVE 'SELECT'              TO LM001-ERR-FUNCTION          
              MOVE '7618'                TO LM001-ERR-PARAGRAPH-NO      
              MOVE '7618-LM001-GET-USAGE-FIXED'                         
                                         TO LM001-ERR-PARAGRAPH-NAME    
              MOVE 'CSS_UM_EQUIPMENT'    TO LM001-ERR-TABLE1            
              MOVE 'RATE_PLAN_NO  '      TO LM001-ERR-COLUMN-1          
              MOVE 'RATE_ITEM_CODE'      TO LM001-ERR-COLUMN-2          
              MOVE 'CODE_UTIL_TYPE'      TO LM001-ERR-COLUMN-3          
              MOVE LM4F-RATE-PLAN-NO     TO LM001-ERR-HOSTVAR-1         
              MOVE LM4F-RATE-ITEM-CODE   TO LM001-ERR-HOSTVAR-2         
              MOVE LM4F-CODE-UTIL-TYPE   TO LM001-ERR-HOSTVAR-3         
           END-IF.                                                      
                                                                        
       7618-LM001-EXIT.                                                 
           EXIT.                                                        
      *================================================================*        
       7620-LM001-GET-RESP-AREA.                                        
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
               INTO :LMTMP-RESP-AREA-ID                                 
               FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                      
               WHERE USER_ID = :LM001-USER-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*        INTO :LMTMP-RESP-AREA-ID                                         
MFA-TR*        FROM CSS_USER_PROFILE                                            
MFA-TR*        WHERE USER_ID = :LM001-USER-ID                                   
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7620                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0 OR 100                                        
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR SELECTING RESPONSIBLE AREA'                   
                                      TO LM001-ERR-MESSAGE              
              MOVE SQLCODE TO LM001-ERR-SQLCODE                         
              MOVE 'SELECT'  TO LM001-ERR-FUNCTION                      
              MOVE '7620'   TO LM001-ERR-PARAGRAPH-NO                   
              MOVE '7620-LM001-GET-RESP-AREA'                           
                           TO LM001-ERR-PARAGRAPH-NAME                  
              MOVE 'CSS_USER_PROFILE'  TO LM001-ERR-TABLE1              
              MOVE 'USER_ID'             TO LM001-ERR-COLUMN-1          
              MOVE LM001-USER-ID         TO LM001-ERR-HOSTVAR-1         
           END-IF.                                                      
                                                                        
       7620-LM001-EXIT.                                                 
           EXIT.                                                        
                                                                        
      *================================================================*        
       7622-LM001-SELECT-TIMESTAMP.                                     
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :LMTMP-TIMESTAMP                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :LMTMP-TIMESTAMP =                                            
MFA-TR*            CURRENT TIMESTAMP                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR SELECTING TIMESTAMP'                          
                                      TO LM001-ERR-MESSAGE              
              MOVE SQLCODE TO LM001-ERR-SQLCODE                         
              MOVE 'SELECT'  TO LM001-ERR-FUNCTION                      
              MOVE '7622'   TO LM001-ERR-PARAGRAPH-NO                   
              MOVE '7622-LM001-SELECT-TIMESTAMP'                        
                           TO LM001-ERR-PARAGRAPH-NAME                  
              MOVE 'SYSDUMMY1   '     TO LM001-ERR-TABLE1               
           END-IF.                                                      
                                                                        
       7622-LM001-EXIT.                                                 
           EXIT.                                                        
                                                                        
      *================================================================*        
       7624-LM001-GET-LMS-RATE.                                         
      *================================================================*        
                                                                        
           EXEC SQL                                                     
A17062        SELECT LMS_FIXTURE_CHG_CD                                 
                INTO :LMTMP-LIGHT-RATE-TYPE                             
A17062          FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE COMPANY_NO    = :LMAT-COMPANY-NO                   
A17062           AND LMS_RATE_FL   = 'Y'                                
A17062           AND RATE_PLAN_NO  = :LM4F-RATE-PLAN-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LMS_FIXTURE_CHG_CD                                         
MFA-TR*         INTO :LMTMP-LIGHT-RATE-TYPE                                     
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE COMPANY_NO    = :LMAT-COMPANY-NO                           
MFA-TR*          AND LMS_RATE_FL   = 'Y'                                        
MFA-TR*          AND RATE_PLAN_NO  = :LM4F-RATE-PLAN-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7624                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0 OR 100                                        
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR SELECTING RESPONSIBLE AREA'                   
                                      TO LM001-ERR-MESSAGE              
              MOVE SQLCODE TO LM001-ERR-SQLCODE                         
              MOVE 'SELECT'  TO LM001-ERR-FUNCTION                      
              MOVE '7624'   TO LM001-ERR-PARAGRAPH-NO                   
              MOVE '7624-LM001-GET-LMS-RATE'                            
                           TO LM001-ERR-PARAGRAPH-NAME                  
              MOVE 'CSS_USER_PROFILE'  TO LM001-ERR-TABLE1              
              MOVE 'COMPANY_NO'          TO LM001-ERR-COLUMN-1          
A17062        MOVE 'LMS_RATE_FL'         TO LM001-ERR-COLUMN-2          
A17062        MOVE 'RATE_PLAN_NO'        TO LM001-ERR-COLUMN-3          
              MOVE LMAT-COMPANY-NO       TO LM001-ERR-HOSTVAR-1         
A17062        MOVE 'Y'                   TO LM001-ERR-HOSTVAR-2         
              MOVE LM4F-RATE-PLAN-NO     TO LM001-ERR-HOSTVAR-3         
           END-IF.                                                      
                                                                        
       7624-LM001-EXIT.                                                 
           EXIT.                                                        
      *================================================================*        
       8600-LM001-INSERT-UTIL.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_UTIL_ENVRNMT                             
                    ( PREMISE_NO                                        
                     ,CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,CODE_REVENUE_CLASS                                
                     ,CODE_SERVICE_TYPE                                 
                     ,RATE_PLAN_NO                                      
                     ,COMPANY_NO                                        
                     ,DATE_INSTALL                                      
                     ,READ_ROUTE                                        
                     ,READ_CYCLE                                        
                     ,ACCOUNT_NO                                        
                     ,LAST_UPDATE_TS)                                   
               VALUES                                                   
                   ( :LMAT-PREMISE-NO                                   
                    ,:LMUT-CODE-UTIL-TYPE                               
                    ,:LMUT-IC-NO                                        
                    ,:LMUT-CODE-REVENUE-CLASS                           
                    ,:LMUT-CODE-SERVICE-TYPE                            
                    ,:LMUT-RATE-PLAN-NO                                 
                    ,:LMAT-COMPANY-NO                                   
                    ,IIF(TRY_CONVERT(DATE, :LMUT-DATE-INSTALL
              ) IS NULL OR (PATINDEX('%.%', :LMUT-DATE-INSTALL
              ) <> 0) OR (LEN(:LMUT-DATE-INSTALL
              ) <> 10), CIS.CHAR2DATE(:LMUT-DATE-INSTALL
              ), CONVERT(DATE, :LMUT-DATE-INSTALL) )                           
                    ,:LMUT-READ-ROUTE                                   
                    ,:LMUT-READ-CYCLE                                   
                    ,:LMAT-ACCOUNT-NO                                   
                    ,CIS.CURRENT$TIMESTAMP() )                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08240000
MFA-TR*        INSERT INTO CSS_UTIL_ENVRNMT                             08241000
MFA-TR*             ( PREMISE_NO                                        08242000
MFA-TR*              ,CODE_UTIL_TYPE                                    08243000
MFA-TR*              ,IC_NO                                             08244000
MFA-TR*              ,CODE_REVENUE_CLASS                                08245000
MFA-TR*              ,CODE_SERVICE_TYPE                                 08246000
MFA-TR*              ,RATE_PLAN_NO                                      08247000
MFA-TR*              ,COMPANY_NO                                        08248000
MFA-TR*              ,DATE_INSTALL                                      08249000
MFA-TR*              ,READ_ROUTE                                        08250000
MFA-TR*              ,READ_CYCLE                                        08251000
MFA-TR*              ,ACCOUNT_NO                                        08252000
MFA-TR*              ,LAST_UPDATE_TS)                                   08253000
MFA-TR*        VALUES                                                   08259000
MFA-TR*            ( :LMAT-PREMISE-NO                                   08260000
MFA-TR*             ,:LMUT-CODE-UTIL-TYPE                               08261000
MFA-TR*             ,:LMUT-IC-NO                                        08262000
MFA-TR*             ,:LMUT-CODE-REVENUE-CLASS                           08263000
MFA-TR*             ,:LMUT-CODE-SERVICE-TYPE                            08264000
MFA-TR*             ,:LMUT-RATE-PLAN-NO                                 08265000
MFA-TR*             ,:LMAT-COMPANY-NO                                   08266000
MFA-TR*             ,:LMUT-DATE-INSTALL                                 08267000
MFA-TR*             ,:LMUT-READ-ROUTE                                   08268000
MFA-TR*             ,:LMUT-READ-CYCLE                                   08269000
MFA-TR*             ,:LMAT-ACCOUNT-NO                                   08270000
MFA-TR*             ,CURRENT TIMESTAMP )                                08271000
MFA-TR*    END-EXEC                                                     08277000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR IN INSERTING UTIL_ENVRNMT'                    
                                      TO LM001-ERR-MESSAGE              
              MOVE SQLCODE TO LM001-ERR-SQLCODE                         
              MOVE 'INSERT'  TO LM001-ERR-FUNCTION                      
              MOVE '8600'   TO LM001-ERR-PARAGRAPH-NO                   
              MOVE '8600-LM001-INSERT-UTIL'                             
                           TO LM001-ERR-PARAGRAPH-NAME                  
              MOVE 'CSS_CUST_PLAN'     TO LM001-ERR-TABLE1              
              MOVE 'ACCOUNT_NO'        TO LM001-ERR-COLUMN-1            
              MOVE 'IC_NO'             TO LM001-ERR-COLUMN-2            
              MOVE 'CODE_UTIL_TYPE'    TO LM001-ERR-COLUMN-3            
              MOVE LMAT-ACCOUNT-NO       TO LM001-ERR-HOSTVAR-1         
              MOVE LMUT-IC-NO            TO LM001-ERR-HOSTVAR-2         
              MOVE LMUT-CODE-UTIL-TYPE   TO LM001-ERR-HOSTVAR-3         
           END-IF.                                                      
                                                                        
       8600-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8610-LM001-UPDATE-CUST.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUST_PLAN                                     
                  SET CODE_PLAN_STATUS = :LMCP-CODE-PLAN-STATUS         
                     ,DATE_PLAN_START  = IIF(TRY_CONVERT(DATE, 
                                                  :LMCP-DATE-PLAN-START
              ) IS NULL OR (PATINDEX('%.%', :LMCP-DATE-PLAN-START
              ) <> 0) OR (LEN(:LMCP-DATE-PLAN-START
              ) <> 10), CIS.CHAR2DATE(:LMCP-DATE-PLAN-START
              ), CONVERT(DATE, :LMCP-DATE-PLAN-START) )          
                     ,REMOVE_DATE      = IIF(TRY_CONVERT(DATE, 
                                                     :LMCP-REMOVE-DATE 
                                                  :LMCP-REMOVE-DATE-IND
              ) IS NULL OR (PATINDEX('%.%', :LMCP-REMOVE-DATE 
                                                  :LMCP-REMOVE-DATE-IND
              ) <> 0) OR (LEN(:LMCP-REMOVE-DATE :LMCP-REMOVE-DATE-IND
              ) <> 10), CIS.CHAR2DATE(:LMCP-REMOVE-DATE 
                                                  :LMCP-REMOVE-DATE-IND
              ), CONVERT(DATE, :LMCP-REMOVE-DATE :LMCP-REMOVE-DATE-IND
              ) )          
                     ,LAST_BILL_DATE   = IIF(TRY_CONVERT(DATE, 
                                                  :LMCP-LAST-BILL-DATE 
                                               :LMCP-LAST-BILL-DATE-IND
              ) IS NULL OR (PATINDEX('%.%', :LMCP-LAST-BILL-DATE 
                                               :LMCP-LAST-BILL-DATE-IND
              ) <> 0) OR (LEN(:LMCP-LAST-BILL-DATE 
                                               :LMCP-LAST-BILL-DATE-IND
              ) <> 10), CIS.CHAR2DATE(:LMCP-LAST-BILL-DATE 
                                               :LMCP-LAST-BILL-DATE-IND
              ), CONVERT(DATE, :LMCP-LAST-BILL-DATE 
                                               :LMCP-LAST-BILL-DATE-IND
              ) )       
              WHERE ACCOUNT_NO     =   :LMAT-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE =   :LMUT-CODE-UTIL-TYPE             
                AND IC_NO          =   :LMUT-IC-NO                      
                AND RATE_ITEM_CODE =   :LM4F-RATE-ITEM-CODE             
                AND ITEM_SEQ_NO    =   :LMCP-ITEM-SEQ-NO                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08240000
MFA-TR*        UPDATE CSS_CUST_PLAN                                     08241000
MFA-TR*           SET CODE_PLAN_STATUS = :LMCP-CODE-PLAN-STATUS                 
MFA-TR*              ,DATE_PLAN_START  = :LMCP-DATE-PLAN-START                  
MFA-TR*              ,REMOVE_DATE      = :LMCP-REMOVE-DATE                      
MFA-TR*                                  :LMCP-REMOVE-DATE-IND                  
MFA-TR*              ,LAST_BILL_DATE   = :LMCP-LAST-BILL-DATE                   
MFA-TR*                                  :LMCP-LAST-BILL-DATE-IND               
MFA-TR*       WHERE ACCOUNT_NO     =   :LMAT-ACCOUNT-NO                         
MFA-TR*         AND CODE_UTIL_TYPE =   :LMUT-CODE-UTIL-TYPE                     
MFA-TR*         AND IC_NO          =   :LMUT-IC-NO                              
MFA-TR*         AND RATE_ITEM_CODE =   :LM4F-RATE-ITEM-CODE                     
MFA-TR*         AND ITEM_SEQ_NO    =   :LMCP-ITEM-SEQ-NO                        
MFA-TR*    END-EXEC                                                     08277000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR IN UPDATING CUST PLAN'                        
                                      TO LM001-ERR-MESSAGE              
              MOVE SQLCODE TO LM001-ERR-SQLCODE                         
              MOVE 'INSERT'  TO LM001-ERR-FUNCTION                      
              MOVE '8610'   TO LM001-ERR-PARAGRAPH-NO                   
              MOVE '8610-LM001-UPDATE-CUST'                             
                           TO LM001-ERR-PARAGRAPH-NAME                  
              MOVE 'CSS_CUST_PLAN'     TO LM001-ERR-TABLE1              
              MOVE 'ACCOUNT_NO'        TO LM001-ERR-COLUMN-1            
              MOVE 'IC_NO'             TO LM001-ERR-COLUMN-2            
              MOVE 'CODE_UTIL_TYPE'    TO LM001-ERR-COLUMN-3            
              MOVE 'RATE_ITEM_CODE'    TO LM001-ERR-COLUMN-4            
              MOVE LMAT-ACCOUNT-NO       TO LM001-ERR-HOSTVAR-1         
              MOVE LMUT-IC-NO            TO LM001-ERR-HOSTVAR-2         
              MOVE LMUT-CODE-UTIL-TYPE   TO LM001-ERR-HOSTVAR-3         
              MOVE LM4F-RATE-ITEM-CODE   TO LM001-ERR-HOSTVAR-4         
           END-IF.                                                      
                                                                        
       8610-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8612-LM001-UPD-CUST-UNITS.                                       
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUST_PLAN                                     
                  SET NO_UNITS = :LMTMP-NO-UNITS                        
              WHERE ACCOUNT_NO     =   :LMAT-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE =   :LMUT-CODE-UTIL-TYPE             
                AND IC_NO          =   :LMUT-IC-NO                      
                AND RATE_ITEM_CODE =   :LM4F-RATE-ITEM-CODE             
                AND ITEM_SEQ_NO    =   :LMCP-ITEM-SEQ-NO                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR IN UPDATING CUST PLAN'                        
                                      TO LM001-ERR-MESSAGE              
              MOVE SQLCODE TO LM001-ERR-SQLCODE                         
              MOVE 'INSERT'  TO LM001-ERR-FUNCTION                      
              MOVE '8612'   TO LM001-ERR-PARAGRAPH-NO                   
              MOVE '8612-LM001-UPD-CUST-UNITS'                          
                           TO LM001-ERR-PARAGRAPH-NAME                  
              MOVE 'CSS_CUST_PLAN'     TO LM001-ERR-TABLE1              
              MOVE 'ACCOUNT_NO'        TO LM001-ERR-COLUMN-1            
              MOVE 'IC_NO'             TO LM001-ERR-COLUMN-2            
              MOVE 'CODE_UTIL_TYPE'    TO LM001-ERR-COLUMN-3            
              MOVE 'RATE_ITEM_CODE'    TO LM001-ERR-COLUMN-4            
              MOVE LMAT-ACCOUNT-NO       TO LM001-ERR-HOSTVAR-1         
              MOVE LMUT-IC-NO            TO LM001-ERR-HOSTVAR-2         
              MOVE LMUT-CODE-UTIL-TYPE   TO LM001-ERR-HOSTVAR-3         
              MOVE LM4F-RATE-ITEM-CODE   TO LM001-ERR-HOSTVAR-4         
           END-IF.                                                      
                                                                        
       8612-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8620-LM001-INSERT-CP.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CUST_PLAN                                
                    ( ACCOUNT_NO                                        
                     ,IC_NO                                             
                     ,CODE_UTIL_TYPE                                    
                     ,RATE_ITEM_CODE                                    
                     ,ITEM_SEQ_NO                                       
                     ,CODE_PLAN_STATUS                                  
                     ,CODE_STAT_REASON                                  
                     ,DATE_PLAN_START                                   
                     ,USAGE_FIXED                                       
                     ,MTHLY_AMOUNT_FIXED                                
                     ,NO_UNITS                                          
                     ,CODE_SERVICE_TYPE                                 
                     ,REMOVE_DATE                                       
                     ,DIST_NO                                           
                     ,POLE_NO                                           
                     ,LIGHT_NO                                          
                     ,LAST_BILL_DATE )                                  
               VALUES                                                   
                   ( :LMAT-ACCOUNT-NO                                   
                    ,:LMUT-IC-NO                                        
                    ,:LMUT-CODE-UTIL-TYPE                               
                    ,:LM4F-RATE-ITEM-CODE                               
                    ,:LMCP-ITEM-SEQ-NO                                  
                    ,:LMCP-CODE-PLAN-STATUS                             
                    ,:LMCP-CODE-STAT-REASON                             
                    ,IIF(TRY_CONVERT(DATE, :LMCP-DATE-PLAN-START 
                                           :LMCP-DATE-PLAN-START-IND
              ) IS NULL OR (PATINDEX('%.%', :LMCP-DATE-PLAN-START 
                                              :LMCP-DATE-PLAN-START-IND
              ) <> 0) OR (LEN(:LMCP-DATE-PLAN-START 
                                              :LMCP-DATE-PLAN-START-IND
              ) <> 10), CIS.CHAR2DATE(:LMCP-DATE-PLAN-START 
                                              :LMCP-DATE-PLAN-START-IND
              ), CONVERT(DATE, :LMCP-DATE-PLAN-START 
                                              :LMCP-DATE-PLAN-START-IND
              ) )     
                    ,:LMCP-USAGE-FIXED                                  
                    ,:LMCP-MTHLY-AMOUNT-FIXED                           
                    ,:LMCP-NO-UNITS                                     
                    ,:LMCP-CODE-SERVICE-TYPE                            
                    ,IIF(TRY_CONVERT(DATE, :LMCP-REMOVE-DATE 
                                           :LMCP-REMOVE-DATE-IND
              ) IS NULL OR (PATINDEX('%.%', :LMCP-REMOVE-DATE 
                                                  :LMCP-REMOVE-DATE-IND
              ) <> 0) OR (LEN(:LMCP-REMOVE-DATE :LMCP-REMOVE-DATE-IND
              ) <> 10), CIS.CHAR2DATE(:LMCP-REMOVE-DATE 
                                                  :LMCP-REMOVE-DATE-IND
              ), CONVERT(DATE, :LMCP-REMOVE-DATE :LMCP-REMOVE-DATE-IND
              ) )             
                    ,:LMCP-DIST-NO                                      
                    ,:LMCP-POLE-NO                                      
                    ,:LMCP-LIGHT-NO                                     
                    ,IIF(TRY_CONVERT(DATE, :LMCP-LAST-BILL-DATE 
                                           :LMCP-LAST-BILL-DATE-IND
              ) IS NULL OR (PATINDEX('%.%', :LMCP-LAST-BILL-DATE 
                                               :LMCP-LAST-BILL-DATE-IND
              ) <> 0) OR (LEN(:LMCP-LAST-BILL-DATE 
                                               :LMCP-LAST-BILL-DATE-IND
              ) <> 10), CIS.CHAR2DATE(:LMCP-LAST-BILL-DATE 
                                               :LMCP-LAST-BILL-DATE-IND
              ), CONVERT(DATE, :LMCP-LAST-BILL-DATE 
                                               :LMCP-LAST-BILL-DATE-IND
              ) ))      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08240000
MFA-TR*        INSERT INTO CSS_CUST_PLAN                                08241000
MFA-TR*             ( ACCOUNT_NO                                        08242000
MFA-TR*              ,IC_NO                                             08243000
MFA-TR*              ,CODE_UTIL_TYPE                                    08244000
MFA-TR*              ,RATE_ITEM_CODE                                    08245000
MFA-TR*              ,ITEM_SEQ_NO                                       08246000
MFA-TR*              ,CODE_PLAN_STATUS                                  08247000
MFA-TR*              ,CODE_STAT_REASON                                  08248000
MFA-TR*              ,DATE_PLAN_START                                   08249000
MFA-TR*              ,USAGE_FIXED                                       08250000
MFA-TR*              ,MTHLY_AMOUNT_FIXED                                08251000
MFA-TR*              ,NO_UNITS                                          08252000
MFA-TR*              ,CODE_SERVICE_TYPE                                 08253000
MFA-TR*              ,REMOVE_DATE                                       08254000
MFA-TR*              ,DIST_NO                                           08255000
MFA-TR*              ,POLE_NO                                           08256000
MFA-TR*              ,LIGHT_NO                                          08257000
MFA-TR*              ,LAST_BILL_DATE )                                  08258000
MFA-TR*        VALUES                                                   08259000
MFA-TR*            ( :LMAT-ACCOUNT-NO                                   08260000
MFA-TR*             ,:LMUT-IC-NO                                        08261000
MFA-TR*             ,:LMUT-CODE-UTIL-TYPE                               08262000
MFA-TR*             ,:LM4F-RATE-ITEM-CODE                               08263000
MFA-TR*             ,:LMCP-ITEM-SEQ-NO                                  08264000
MFA-TR*             ,:LMCP-CODE-PLAN-STATUS                             08265000
MFA-TR*             ,:LMCP-CODE-STAT-REASON                             08266000
MFA-TR*             ,:LMCP-DATE-PLAN-START:LMCP-DATE-PLAN-START-IND     08267000
MFA-TR*             ,:LMCP-USAGE-FIXED                                  08268000
MFA-TR*             ,:LMCP-MTHLY-AMOUNT-FIXED                           08269000
MFA-TR*             ,:LMCP-NO-UNITS                                     08270000
MFA-TR*             ,:LMCP-CODE-SERVICE-TYPE                            08271000
MFA-TR*             ,:LMCP-REMOVE-DATE:LMCP-REMOVE-DATE-IND             08272000
MFA-TR*             ,:LMCP-DIST-NO                                      08273000
MFA-TR*             ,:LMCP-POLE-NO                                      08274000
MFA-TR*             ,:LMCP-LIGHT-NO                                     08275000
MFA-TR*             ,:LMCP-LAST-BILL-DATE:LMCP-LAST-BILL-DATE-IND)      08276000
MFA-TR*    END-EXEC                                                     08277000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR IN INSERTING CUST PLAN'                       
                                      TO LM001-ERR-MESSAGE              
              MOVE SQLCODE TO LM001-ERR-SQLCODE                         
              MOVE 'INSERT'  TO LM001-ERR-FUNCTION                      
              MOVE '8620'   TO LM001-ERR-PARAGRAPH-NO                   
              MOVE '8620-LM001-INSERT-CP'                               
                           TO LM001-ERR-PARAGRAPH-NAME                  
              MOVE 'CSS_CUST_PLAN'     TO LM001-ERR-TABLE1              
              MOVE 'ACCOUNT_NO'        TO LM001-ERR-COLUMN-1            
              MOVE 'IC_NO'             TO LM001-ERR-COLUMN-2            
              MOVE 'CODE_UTIL_TYPE'    TO LM001-ERR-COLUMN-3            
              MOVE 'RATE_ITEM_CODE'    TO LM001-ERR-COLUMN-4            
              MOVE LMAT-ACCOUNT-NO       TO LM001-ERR-HOSTVAR-1         
              MOVE LMUT-IC-NO            TO LM001-ERR-HOSTVAR-2         
              MOVE LMUT-CODE-UTIL-TYPE   TO LM001-ERR-HOSTVAR-3         
              MOVE LM4F-RATE-ITEM-CODE   TO LM001-ERR-HOSTVAR-4         
           END-IF.                                                      
                                                                        
       8620-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8650-LM001-UPD-LIGHT-ENVRNMT.                                    
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               UPDATE LMS_EQUIP_ENVRNMT                                 
                  SET BILLING_FL              = :LM4F-BILLING-FL        
                     ,ITEM_SEQ_NO             = :LM4F-ITEM-SEQ-NO       
                     ,IC_NO                   = :LM4F-IC-NO             
                     ,CODE_UTIL_TYPE          = :LM4F-CODE-UTIL-TYPE    
                     ,RATE_PLAN_NO            = :LM4F-RATE-PLAN-NO      
                     ,RATE_ITEM_CODE          = :LM4F-RATE-ITEM-CODE    
                     ,LAST_UPDATE_TS          = CIS.CURRENT$TIMESTAMP()       
                     ,LAST_UPDATE_USERID      = :LM001-USER-ID          
              WHERE INSTALL_LOC_NO =   :LM4F-INSTALL-LOC-NO             
                AND INSTALL_POINT_NO = :LM4F-INSTALL-POINT-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE LMS_EQUIP_ENVRNMT                                 08241000
MFA-TR*           SET BILLING_FL              = :LM4F-BILLING-FL                
MFA-TR*              ,ITEM_SEQ_NO             = :LM4F-ITEM-SEQ-NO               
MFA-TR*              ,IC_NO                   = :LM4F-IC-NO                     
MFA-TR*              ,CODE_UTIL_TYPE          = :LM4F-CODE-UTIL-TYPE            
MFA-TR*              ,RATE_PLAN_NO            = :LM4F-RATE-PLAN-NO              
MFA-TR*              ,RATE_ITEM_CODE          = :LM4F-RATE-ITEM-CODE            
MFA-TR*              ,LAST_UPDATE_TS          = CURRENT TIMESTAMP               
MFA-TR*              ,LAST_UPDATE_USERID      = :LM001-USER-ID                  
MFA-TR*       WHERE INSTALL_LOC_NO =   :LM4F-INSTALL-LOC-NO                     
MFA-TR*         AND INSTALL_POINT_NO = :LM4F-INSTALL-POINT-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO LM001-ERR-SQLCODE                         
              MOVE 'UPDATE'  TO LM001-ERR-FUNCTION                      
              MOVE '8650'   TO LM001-ERR-PARAGRAPH-NO                   
              MOVE '8650-LM001-UPD-LIGHT-ENVRNMT'                       
                           TO LM001-ERR-PARAGRAPH-NAME                  
              MOVE 'LMS_EQUIP_ENVRNMT' TO LM001-ERR-TABLE1              
              MOVE 'INSTALL_LOC_NO'    TO LM001-ERR-COLUMN-1            
              MOVE 'INSTALL_POINT_NO'  TO LM001-ERR-COLUMN-2            
              MOVE LM4F-INSTALL-LOC-NO    TO LM001-ERR-HOSTVAR-1        
              MOVE LM4F-INSTALL-POINT-NO  TO LM001-ERR-HOSTVAR-2        
           END-IF.                                                      
      *                                                                         
       8650-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8660-LM001-DEL-LIGHT-ENVRNMT.                                    
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               DELETE LMS_EQUIP_ENVRNMT                                 
              WHERE INSTALL_LOC_NO =   :LM4F-INSTALL-LOC-NO             
                AND INSTALL_POINT_NO = :LM4F-INSTALL-POINT-NO           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO LM001-ERR-SQLCODE                         
              MOVE 'DELETE'  TO LM001-ERR-FUNCTION                      
              MOVE '8660'   TO LM001-ERR-PARAGRAPH-NO                   
              MOVE '8660-LM001-DEL-LIGHT-ENVRNMT'                       
                           TO LM001-ERR-PARAGRAPH-NAME                  
              MOVE 'LMS_EQUIP_ENVRNMT' TO LM001-ERR-TABLE1              
              MOVE 'INSTALL_LOC_NO'    TO LM001-ERR-COLUMN-1            
              MOVE 'INSTALL_POINT_NO'  TO LM001-ERR-COLUMN-2            
              MOVE LM4F-INSTALL-LOC-NO    TO LM001-ERR-HOSTVAR-1        
              MOVE LM4F-INSTALL-POINT-NO  TO LM001-ERR-HOSTVAR-2        
           END-IF.                                                      
      *                                                                         
       8660-LM001-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8670-LM001-MN-TRANS-HIST.                                        
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_MNT_TRANS_HIST                          
                     ( TRANS_HIST_SEQ_NO,                               
                       DATE_TRANS,                                      
                       CODE_TRAN_TYPE,                                  
                       RESP_AREA_ID,                                    
                       ACCOUNT_NO,                                      
                       CUSTOMER_NO,                                     
                       PREMISE_NO,                                      
                       USER_ID,                                         
                       APPL_PROGRAM_ID,                                 
                       TRAN_COMMENT,                                    
                       ENTITY_KEY_DESC)                                 
                VALUES                                                  
                     ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
                       IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
                       :MH-CODE-TRAN-TYPE,                              
                       :MH-RESP-AREA-ID,                                
                       :MH-ACCOUNT-NO,                                  
                       :MH-CUSTOMER-NO,                                 
                       :MH-PREMISE-NO,                                  
                       :MH-USER-ID,                                     
                       :MH-APPL-PROGRAM-ID,                             
                       :MH-TRAN-COMMENT,                                
                       :MH-ENTITY-KEY-DESC)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MNT_TRANS_HIST                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO,                                       
MFA-TR*                DATE_TRANS,                                              
MFA-TR*                CODE_TRAN_TYPE,                                          
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                PREMISE_NO,                                              
MFA-TR*                USER_ID,                                                 
MFA-TR*                APPL_PROGRAM_ID,                                         
MFA-TR*                TRAN_COMMENT,                                            
MFA-TR*                ENTITY_KEY_DESC)                                         
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :MH-DATE-TRANS,                                          
MFA-TR*                :MH-CODE-TRAN-TYPE,                                      
MFA-TR*                :MH-RESP-AREA-ID,                                        
MFA-TR*                :MH-ACCOUNT-NO,                                          
MFA-TR*                :MH-CUSTOMER-NO,                                         
MFA-TR*                :MH-PREMISE-NO,                                          
MFA-TR*                :MH-USER-ID,                                             
MFA-TR*                :MH-APPL-PROGRAM-ID,                                     
MFA-TR*                :MH-TRAN-COMMENT,                                        
MFA-TR*                :MH-ENTITY-KEY-DESC)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR             TO TRUE                   
              MOVE 'ERROR INSERTING MAINT TRANS HIST'                   
                                              TO LM001-ERR-MESSAGE      
              MOVE SQLCODE                    TO LM001-ERR-SQLCODE      
              MOVE 'INSERT'                   TO LM001-ERR-FUNCTION     
              MOVE '8670'                     TO LM001-ERR-PARAGRAPH-NO 
              MOVE '8670-LM001-MN-TRANS-HIST'                           
                                            TO LM001-ERR-PARAGRAPH-NAME 
              MOVE 'CSS_MNT_TRANS_HIST'       TO LM001-ERR-TABLE1       
              MOVE 'TRANS_HIST_SEQ_NO'        TO LM001-ERR-COLUMN-1     
              MOVE MH-TRANS-HIST-SEQ-NO       TO LM001-ERR-HOSTVAR-1    
           END-IF.                                                      
                                                                        
       8670-LM001-EXIT.                                                 
           EXIT.                                                        
      *================================================================*        
       8680-LM001-MN-TRN-HST-DET.                                       
      *================================================================*        
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_MT_TRN_HST_DET                          
                     ( TRANS_HIST_SEQ_NO,                               
                       TRAN_APPL_NO,                                    
                       COLUMN_DESC,                                     
                       TABLE_ID,                                        
                       PRV_COLUMN_VALUE,                                
                       CHG_COLUMN_VALUE)                                
                VALUES                                                  
                     ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
                       :MI-TRAN-APPL-NO,                                
                       :MI-COLUMN-DESC,                                 
                       :MI-TABLE-ID,                                    
                       :MI-PRV-COLUMN-VALUE,                            
                       :MI-CHG-COLUMN-VALUE)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MT_TRN_HST_DET                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO,                                       
MFA-TR*                TRAN_APPL_NO,                                            
MFA-TR*                COLUMN_DESC,                                             
MFA-TR*                TABLE_ID,                                                
MFA-TR*                PRV_COLUMN_VALUE,                                        
MFA-TR*                CHG_COLUMN_VALUE)                                        
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :MI-TRAN-APPL-NO,                                        
MFA-TR*                :MI-COLUMN-DESC,                                         
MFA-TR*                :MI-TABLE-ID,                                            
MFA-TR*                :MI-PRV-COLUMN-VALUE,                                    
MFA-TR*                :MI-CHG-COLUMN-VALUE)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET LM001-DB2-ERROR             TO TRUE                   
              MOVE 'ERROR INSERTING MAINT TRANS HIST DET'               
                                              TO LM001-ERR-MESSAGE      
              MOVE SQLCODE                    TO LM001-ERR-SQLCODE      
              MOVE 'INSERT'                   TO LM001-ERR-FUNCTION     
              MOVE '8680'                     TO LM001-ERR-PARAGRAPH-NO 
              MOVE '8680-LM001-MN-TRN-HST-DET'                          
                                            TO LM001-ERR-PARAGRAPH-NAME 
              MOVE 'CSS_MT_TRN_HST_DET'       TO LM001-ERR-TABLE1       
              MOVE 'TRANS_HIST_SEQ_NO '       TO LM001-ERR-COLUMN-1     
              MOVE 'TRAN_APPL_NO '            TO LM001-ERR-COLUMN-2     
              MOVE MH-TRANS-HIST-SEQ-NO       TO LM001-ERR-HOSTVAR-1    
              MOVE MI-TRAN-APPL-NO            TO LM001-ERR-HOSTVAR-2    
           END-IF.                                                      
                                                                        
       8680-LM001-EXIT.                                                 
           EXIT.                                                        
