      ******************************************************************00010000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00020000
      **                                                              **00030000
      *********           CUSTOMER SERVICE SYSTEM              *********00040000
      *********                     DB2                        *********00050000
      **                                                              **00060000
      ******************************************************************00070000
      **--------------- P R O G R A M  S U M M A R Y -----------------**00080000
      *************************************************************** **00090000
      ** CPDKR364:                                                    **00100000
      ** This copybook is being called from Initiate Refund & Refunds **00101000
      ** Maintenance view for Credit Balance Journaling.              **00101100
      **                                                              **00102000
      ** The following programs presently use this copybook           **00112000
      ** CSR04911                                                     **00113000
      ** CSR04890                                                     **00113000
      ******************************************************************00120000
      *                                                               **00121000
      * PREREQUISITES: Below working storage variables should be      **00130000
      *                populated prior to invoking this routine.      **00140000
      *                                                               **00150000
      * WS-RFND-CHECK-AMT                                             **00240000
      * WS-RFND-CASH-AMT                                              **00240000
      * PF-RESP-AREA-ID                                               **        
      * WS-CIA-ITEM-ID-NUM                                            **        
      ******************************************************************00480000
      *                                                                *00490000
      *                     PROGRAM MODIFICATION LOG                   *00500000
      *                                                                *00510000
      *    DATE    INITIALS   COMMENTS                                 *00520000
      *  --------  --------   ---------------------------------------  *00530000
P00870*  06/02/16  AA97148    PROCEDURE ORIGINALLY CODED.              *00540000
      ******************************************************************00550000
                                                                        
      ******************************************************************00570000
      * 5200-INSERT-AR-TRANS-HIST                                      *00580000
      ******************************************************************00590000
                                                                        
       5200-CRED-BAL-JRNL-PROCESS.                                      
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO AR-TRANS-HIST-SEQ-NO     
                                               AU-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO AR-DATE-TRANS.           
           MOVE 'R'                         TO AR-CODE-TRAN-TYPE.       
                                                                        
           MOVE 0                           TO AR-AMT-ORIG-ENTERED.     
           IF WS-RFND-CHECK-AMT > 0                                     
              ADD WS-RFND-CHECK-AMT         TO AR-AMT-ORIG-ENTERED      
           END-IF                                                       
           IF WS-RFND-CASH-AMT > 0                                      
              ADD WS-RFND-CASH-AMT          TO AR-AMT-ORIG-ENTERED      
           END-IF                                                       
                                                                        
           MOVE PF-RESP-AREA-ID             TO AR-RESP-AREA-ID.         
           MOVE WS-USER-ID                  TO AR-USER-ID.              
           MOVE 'PANEL275 '                 TO AR-APPL-PROGRAM-ID.      
           MOVE 'Y'                         TO AR-PYMT-REFUNDED-IND.    
           MOVE WS-TRANS-COMMENTS-TEXT      TO AR-TRAN-COMMENT-TEXT.    
           MOVE WS-TRANS-COMMENTS-LEN       TO AR-TRAN-COMMENT-LEN.     
           IF RN-MANUAL-INDICATOR = 'C'                                 
              STRING 'PAYMENT LOCAL OFFICE:',WS-CD-LOCAL-OFFICE,        
                '; REPORT DATE:',WS-CD-REPORT-DATE,                     
                '; BATCH NO:',WS-CD-REPORT-NO,';',WS-TRANS-COMMENTS-TEXT
                 DELIMITED BY SIZE INTO AR-TRAN-COMMENT-TEXT            
              ADD +63                       TO  AR-TRAN-COMMENT-LEN     
           END-IF.                                                      
                                                                        
           MOVE AT-TOTAL-AR-BALANCE         TO AR-AMT-BILLED-UNPAID.    
           ADD  AR-AMT-ORIG-ENTERED         TO AR-AMT-BILLED-UNPAID.    
           MOVE SPACES                      TO AR-PYMT-FACILITY-CD.     
           MOVE SPACES                      TO AR-RECORD-ONLY-FL.       
           MOVE AT-COMPANY-NO               TO AR-COMPANY-NO.           
           MOVE -1                          TO WS-AR-NULL-IND-2.        
                                                                        
           IF WS-RFND-CASH-AMT > 0                                      
              MOVE WS-CD-COMPANY-NO         TO AR-CASH-COMPANY-NO       
              MOVE WS-CD-LOCAL-OFFICE       TO AR-CASH-LOCAL-OFFICE     
              MOVE WS-CD-REPORT-NO          TO AR-CASH-REPORT-NO        
              MOVE WS-CD-REPORT-DATE        TO AR-DATE-CASH-REPORT      
              MOVE WS-CASH-DRAWER-ID        TO AR-CASH-DRAWER-ID        
           ELSE                                                         
              MOVE '01'                     TO AR-CASH-COMPANY-NO       
                                               WS-CD-COMPANY-NO         
              MOVE '998'                    TO AR-CASH-LOCAL-OFFICE     
                                               WS-CD-LOCAL-OFFICE       
              MOVE '998'                    TO AR-CASH-REPORT-NO        
                                               WS-CD-REPORT-NO          
              MOVE WS-CURRENT-DATE          TO AR-DATE-CASH-REPORT      
                                               WS-CD-REPORT-DATE        
              MOVE 9999                     TO AR-CASH-DRAWER-ID        
                                               WS-CASH-DRAWER-ID        
           END-IF.                                                      
                                                                        
           PERFORM 8100-INSERT-AR-TRANS-HIST THRU 8100-KR364-EXIT       
           PERFORM 5210-INSERT-AR-DETAILS    THRU 5210-KR364-EXIT.      
                                                                        
           ADD AR-AMT-ORIG-ENTERED           TO AT-TOTAL-AR-BALANCE.    
           PERFORM 7010-ACCEPT-TIMESTAMP     THRU 7010-KR364-EXIT.      
           MOVE WS-CURRENT-TIMESTAMP         TO AT-LAST-UPDATE-TS.      
           PERFORM 8300-UPDATE-ACCOUNT       THRU 8300-KR364-EXIT.      
                                                                        
       5200-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ***************************************************************** 14210000
      * 5210-INSERT-AR-DETAILS                                        * 14220000
      ***************************************************************** 14240000
                                                                        
       5210-INSERT-AR-DETAILS.                                          
                                                                        
           PERFORM 7050-SELECT-CUSTOMER     THRU 7050-KR364-EXIT.       
                                                                        
           MOVE 'F'                         TO WS-END-OF-PROCESS        
           MOVE 'N'                         TO WS-INSERT-DEP-REQ.       
           MOVE 0                           TO WS-AU-TRAN-APPL-NO.      
                                                                        
           IF WS-RFND-CHECK-AMT > 0                                     
              MOVE WS-RFND-CHECK-AMT        TO WS-REFUND-AMT            
              MOVE 'C'                      TO WS-CHECK-CASH-IND        
           ELSE                                                         
              IF WS-RFND-CASH-AMT > 0                                   
                 MOVE WS-RFND-CASH-AMT      TO WS-REFUND-AMT            
                 MOVE 'A'                   TO WS-CHECK-CASH-IND        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 5260-MOVE-CRDBAL-FIELDS THRU 5260-KR364-EXIT.        
                                                                        
       5210-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************17600000
      * 5220-INSERT-AR-DETAILS                                         *        
      ******************************************************************17600000
                                                                        
       5220-INSERT-AR-DETAILS.                                          
                                                                        
           PERFORM 8110-INSERT-AR-DET       THRU 8110-KR364-EXIT.       
           PERFORM 5240-CASH-DRAWER-101     THRU 5240-KR364-EXIT.       
                                                                        
       5220-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************17040000
      * 5230-GET-PPL-FROM-GL                                           *        
      ******************************************************************17040000
                                                                        
       5230-GET-PPL-FROM-GL.                                            
                                                                        
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-NSC'                        
              MOVE WS-PPL-AR-TYPE-NSC        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-NSA'                        
              MOVE WS-PPL-AR-TYPE-NSA        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-NSN'                        
              MOVE WS-PPL-AR-TYPE-NSN        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-LPC'                        
              MOVE WS-PPL-AR-TYPE-LPC        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-LPN'                        
              MOVE WS-PPL-AR-TYPE-LPN        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-UTE'                        
              MOVE WS-PPL-AR-TYPE-UTE        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-UTG'                        
              MOVE WS-PPL-AR-TYPE-UTG        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-BUD'                        
              MOVE +50                       TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-CCC'                        
              MOVE WS-PPL-AR-TYPE-CCC        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-CIA'                        
              MOVE WS-PPL-AR-TYPE-CIA        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-DEP'                        
              MOVE WS-PPL-AR-TYPE-DEP        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-DFA'                        
              MOVE WS-PPL-AR-TYPE-DFA        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-CNT'                        
              MOVE WS-PPL-AR-TYPE-CNT        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-RVC'                        
              MOVE WS-PPL-AR-TYPE-RVC        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-PJS'                        
              MOVE WS-PPL-AR-TYPE-PJS        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
           IF WS-SEARCH-ACCT-NAME EQUAL 'AR-ADJ'                        
              MOVE WS-PPL-AR-TYPE-ADJ        TO WS-PYMT-PRIORITY-LVL    
           ELSE                                                         
              MOVE ZEROES                    TO WS-PYMT-PRIORITY-LVL
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.   
                                                                        
       5230-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************17730000
      * 5240-CASH-DRAWER-101.                                          *17740000
      * THIS MODULE WRITES A FORMAT 101 CASH DRAWER JOURNAL            *17750000
      *************************@****************************************17760000
                                                                        
       5240-CASH-DRAWER-101.                                            
                                                                        
           PERFORM 7040-SELECT-PREMISE        THRU 7040-KR364-EXIT.     
           PERFORM 5250-SET-100-JRNL-VARS     THRU 5250-KR364-EXIT.     
                                                                        
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
           MOVE SPACES                  TO WS-101-CASH-DRAWER-USED      
                                                                        
           MOVE AU-GL-ACCT-CREDIT       TO WS-101-ACCT-GEN-LED-CR.      
           MOVE AU-GL-ACCT-DEBIT        TO WS-101-ACCT-GEN-LED-DR.      
           MOVE 0                       TO WS-101-AMOUNT-ENTERED.       
           ADD  WS-RFND-CHECK-AMT       TO WS-101-AMOUNT-ENTERED.       
           ADD  WS-RFND-CASH-AMT        TO WS-101-AMOUNT-ENTERED.       
           MOVE AU-AMT-POSTED           TO WS-101-AMT-POSTED.           
           MOVE AU-CODE-AR-AGE          TO WS-101-AR-AGE.               
           MOVE WS-CURRENT-DATE         TO WS-101-DATE-AR-BILLED.       
           MOVE AU-ITEM-ID              TO WS-101-ITEM-ID-NO.           
           MOVE 0                       TO WS-101-DETAIL-END-BAL.       
           MOVE 0                       TO WS-101-DETAIL-END-AR-BAL.    
           MOVE AT-TOTAL-AR-BALANCE     TO WS-101-ACCT-END-AR-BAL.      
           ADD  AU-AMT-POSTED           TO WS-101-ACCT-END-AR-BAL.      
           MOVE SPACES                  TO WS-101-FUNCTION-CODE.        
           MOVE PR-REV-DISTRICT-CD      TO WS-101-CODE-REVENUE-DISTRICT.
           MOVE CU-CODE-EMPL-ACCT       TO WS-101-CODE-EMPL-ACCT.       
           MOVE AT-CODE-COMPANY-ACCT    TO WS-101-CODE-COMPANY-ACCT.    
           MOVE AT-CODE-ACCT-STAT       TO WS-101-CODE-ACCOUNT-STATUS.  
           MOVE PR-CODE-PREMISE-STAT    TO WS-101-CODE-PREMISE-STATUS.  
      *******************************************************           18140000
      * POPULATE CWS00013 VARIABLES.                        *           18150000
      *******************************************************           18160000
           MOVE AU-CURRENCY-TYPE        TO WS-JRNL-CURRENCY-TYPE.       
           MOVE SPACES                  TO WS-JRNL-CODE-PYMT-FACILITY.  
      *                                                                 18190000
           MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
      *                                                                 18210000
           MOVE AU-CURRENCY-AMT         TO WS-JRNL-RCV-DEBIT-AMT.       
           MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE.        
                                                                        
           IF WS-CHECK-CASH-IND = 'A'                                   
      **CASH.                                                           18260000
              MOVE 'S184'               TO WS-100-CODE-TERMINAL-TRAN    
              MOVE AU-CURRENCY-AMT      TO WS-JRNL-CASH-CREDIT-AMT      
           ELSE                                                         
             IF WS-CHECK-CASH-IND = 'C'                                 
      **CHECK.                                                          18310000
                MOVE '184B'             TO WS-100-CODE-TERMINAL-TRAN    
                MOVE AU-CURRENCY-AMT    TO WS-JRNL-CK-ISSUE-CREDIT-AMT  
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE             THRU 6400-EXIT. 
      *                                                                 18390000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
      *                                                                 18460000
           MOVE WS-JRNL-CNTRL-ONLY      TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE             THRU 6400-EXIT. 
      *                                                                 18490000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       5240-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ***************************************************************** 18600000
      * 5250-SET-100-JRNL-VARS                                        * 18610000
      * INITIALIZE FIELDS THAT ARE REQUIRED FOR THE MISCELLANEOUS     * 18620000
      * JOURNAL HEADER.                                               * 18630000
      ***************************************************************** 18640000
                                                                        
       5250-SET-100-JRNL-VARS.                                          
                                                                        
             MOVE AT-COMPANY-NO TO WS-100-COMPANY-NO.                   
             MOVE AT-COMPANY-NO TO BJ-COMPANY-NO.                       
                                                                        
      *******************************************************           18710000
      * THESE FILEDS WERE POPULATED BY CALLING CPD00020     *           18720000
      * (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50.    *           18730000
      *******************************************************           18740000
             MOVE 9             TO WS-TRAN-OPER-LEVEL.                  
             MOVE 1             TO WS-TRAN-OCAP-FIELD.                  
             MOVE 1             TO WS-TRAN-OCAP-VALUE.                  
             MOVE 'C'           TO WS-TRAN-JRNL-TYPE.                   
             MOVE 'N'           TO WS-TRAN-HOLD-EXEMPT-FLAG.            
                                                                        
      *******************************************************           18810000
      * THESE FILEDS WERE POPULATED BY CALLING CPD00021     *           18820000
      * (PARAGRAPH 5980) TO VERIFY USER-ID.                 *           18830000
      *******************************************************           18840000
             MOVE WS-USER-ID          TO WS-JRNL-OL-TEMP-ID.            
             MOVE WS-JRNL-CK-OPER-ID  TO WS-JRNL-OPERATION-RQST.        
             PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.           
             MOVE WS-JRNL-OL-OPR-LOC          TO WS-TERM-LOC.           
      ********************************************************          18990000
      * CHANGES FOR IMPLEMENTING FIELD CASH SYSTEM.          *          19000000
      ********************************************************          19010000
             MOVE WS-CD-COMPANY-NO     TO WS-JRNL-OL-COMPANY.           
             MOVE WS-CD-LOCAL-OFFICE   TO WS-JRNL-OL-LOC-OFF.           
             MOVE WS-CD-REPORT-NO      TO WS-JRNL-OL-REPORT-NO.         
             MOVE WS-CD-REPORT-DATE    TO WS-JRNL-OL-REPORT-DT.         
             MOVE WS-CASH-DRAWER-ID    TO WS-JRNL-OL-CASH-DRWR.         
      *                                                                 19070000
             MOVE WS-TERM-LOC          TO WS-JRNL-OL-TERM-LOC           
                                          WS-JRNL-OL-CASH-LOC           
                                          WS-JRNL-OL-OPR-LOC.           
      *                                                                 19110000
             MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.      
             MOVE 'C'                  TO WS-JRNL-SOURCE-CODE.          
                                                                        
             PERFORM 6400-ONLINE-JRNL-ROUTINE      THRU 6400-EXIT.      
      *                                                                 19160000
             MOVE 'A'                  TO WS-100-JRNL-SORT-ID.          
             MOVE AT-COMPANY-NO        TO WS-100-COMPANY-NO.            
             MOVE WS-ACCOUNT-NO-COMP3  TO WS-100-ACCT-NO.               
             MOVE AT-CUSTOMER-NO       TO WS-100-CUSTOMER-NO.           
             MOVE PR-PREMISE-NO        TO WS-100-PREMISE-NO.            
             MOVE AU-TRAN-APPL-NO      TO WS-100-JRNL-TRAN-APPL-NO.     
             MOVE AT-DATE-LAST-ACTION  TO WS-100-DATE-LAST-ACTION.      
             MOVE 'C'                  TO WS-100-CODE-ENTRY-SOURCE.     
             MOVE AT-LOCAL-OFFICE      TO WS-100-LOCAL-OFFICE-CD        
                                          WS-JRNL-OL-CASH-LOC.          
             MOVE SPACES               TO WS-100-TRANS-ERRORS.          
                                                                        
       5250-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ****************************************************************  14550000
      * 5260-MOVE-CRDBAL-FIELDS                                         14560000
      ****************************************************************  14590000
                                                                        
       5260-MOVE-CRDBAL-FIELDS.                                         
                                                                        
           MOVE 'CIA'                           TO WS-ADD-RECVBL.       
           MOVE WS-ADD-STR                      TO WS-GLED-ACCT-NAME.   
           PERFORM 7020-GL-ACCT-NO              THRU 7020-KR364-EXIT.   
           MOVE WS-GLED-ACCT-NO                 TO AU-GL-ACCT-DEBIT.    
                                                                        
           MOVE WS-GLED-ACCT-NAME               TO WS-SEARCH-ACCT-NAME. 
           PERFORM 5230-GET-PPL-FROM-GL         THRU 5230-KR364-EXIT.   
           IF WS-PYMT-PRIORITY-LVL NOT EQUAL ZEROES                     
              MOVE WS-PYMT-PRIORITY-LVL         TO AC-PYMT-PRIORITY-LVL 
           END-IF.                                                      
                                                                        
           MOVE WS-CIA-ITEM-ID-NUM              TO AC-ITEM-ID           
                                                   AU-ITEM-ID.          
                                                                        
           COMPUTE WS-RFND-AMT-NUM = WS-RFND-CHECK-AMT +                
                                     WS-RFND-CASH-AMT.                  
           MOVE WS-RFND-AMT-NUM                 TO WS-RECVBL-RFND-AMT.  
                                                                        
           PERFORM 5270-PROCESS-CHECK-CASH      THRU 5270-KR364-EXIT.   
                                                                        
       5260-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5270-PROCESS-CHECK-CASH                                        *        
      ******************************************************************        
                                                                        
       5270-PROCESS-CHECK-CASH.                                         
                                                                        
           IF WS-REFUND-AMT >= WS-RECVBL-RFND-AMT                       
              MOVE WS-RECVBL-RFND-AMT           TO AU-CURRENCY-AMT      
                                                   AU-AMT-POSTED        
              PERFORM 5280-PROCESS-AU-INSERT    THRU 5280-KR364-EXIT    
                                                                        
              IF WS-REFUND-AMT = WS-RECVBL-RFND-AMT                     
                 MOVE 'T'                       TO WS-END-OF-PROCESS    
              ELSE                                                      
                 COMPUTE                                                
                    WS-REFUND-AMT = WS-REFUND-AMT - WS-RECVBL-RFND-AMT  
              END-IF                                                    
           ELSE                                                         
                                                                        
              COMPUTE                                                   
                WS-AMOUNT-DIFF = WS-RECVBL-RFND-AMT - WS-REFUND-AMT     
                                                                        
              MOVE WS-REFUND-AMT                TO AU-CURRENCY-AMT      
                                                   AU-AMT-POSTED        
              PERFORM 5280-PROCESS-AU-INSERT    THRU 5280-KR364-EXIT    
                                                                        
              IF WS-CHECK-CASH-IND = 'C' AND WS-RFND-CASH-AMT > 0       
                 MOVE WS-RFND-CASH-AMT          TO WS-REFUND-AMT        
                 MOVE 'A'                       TO WS-CHECK-CASH-IND    
                                                                        
                 IF WS-REFUND-AMT >= WS-AMOUNT-DIFF                     
                    MOVE WS-AMOUNT-DIFF         TO AU-CURRENCY-AMT      
                                                   AU-AMT-POSTED        
                    PERFORM 5280-PROCESS-AU-INSERT THRU 5280-KR364-EXIT 
                                                                        
                    IF WS-REFUND-AMT = WS-AMOUNT-DIFF                   
                       MOVE 'T'                 TO WS-END-OF-PROCESS    
                    ELSE                                                
                       COMPUTE WS-REFUND-AMT                            
                               = WS-REFUND-AMT - WS-AMOUNT-DIFF         
                    END-IF                                              
                 ELSE                                                   
                    MOVE WS-REFUND-AMT          TO AU-CURRENCY-AMT      
                                                   AU-AMT-POSTED        
                    PERFORM 5280-PROCESS-AU-INSERT THRU 5280-KR364-EXIT 
                    MOVE 'T'                    TO WS-END-OF-PROCESS    
                 END-IF                                                 
              ELSE                                                      
                 MOVE 'T'                       TO WS-END-OF-PROCESS    
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5270-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************15470000
      *  5280 PROCESS AU INSERT.                                        15480000
      ******************************************************************15520000
                                                                        
       5280-PROCESS-AU-INSERT.                                          
                                                                        
           MOVE '0'                    TO AU-CODE-AR-AGE.               
           MOVE WS-CURRENT-TIMESTAMP   TO AU-TRANS-HIST-SEQ-NO.         
           ADD 1                       TO WS-AU-TRAN-APPL-NO.           
           MOVE WS-AU-TRAN-APPL-NO     TO AU-TRAN-APPL-NO.              
                                                                        
           MOVE WS-CHECK-CASH-IND      TO AU-CURRENCY-TYPE.             
           EVALUATE WS-CHECK-CASH-IND                                   
              WHEN 'C'                                                  
                   MOVE 'CLR-CK-ISS'        TO WS-GLED-ACCT-NAME        
                   PERFORM 7020-GL-ACCT-NO  THRU 7020-KR364-EXIT        
                   MOVE WS-GLED-ACCT-NO     TO AU-GL-ACCT-CREDIT        
              WHEN 'A'                                                  
                   MOVE 'CLR-CASH'          TO WS-GLED-ACCT-NAME        
                   PERFORM 7020-GL-ACCT-NO  THRU 7020-KR364-EXIT        
                   MOVE WS-GLED-ACCT-NO     TO AU-GL-ACCT-CREDIT        
           END-EVALUATE.                                                
                                                                        
           PERFORM 5290-PROCESS-AR-CNTL     THRU 5290-KR364-EXIT.       
           PERFORM 5220-INSERT-AR-DETAILS   THRU 5220-KR364-EXIT.       
                                                                        
       5280-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ************************************************************      15860000
      * 5290-PROCESS-AR-CNTL                                            15870000
      ************************************************************      15880000
                                                                        
       5290-PROCESS-AR-CNTL.                                            
                                                                        
           MOVE 'F'                          TO WS-BAL-NEGETIVE.        
                                                                        
           PERFORM 7030-SELECT-AR-CNTL       THRU 7030-KR364-EXIT.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
      ** ROLLBACK TRANSACTION.                                          15970000
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF AC-AMT-UNUSED-CR LESS THAN ZERO                           
              COMPUTE    AC-AMT-UNUSED-CR = -1 * AC-AMT-UNUSED-CR       
              MOVE 'T'                       TO WS-BAL-NEGETIVE         
           ELSE                                                         
              MOVE 'F'                       TO WS-BAL-NEGETIVE         
           END-IF.                                                      
                                                                        
           IF ( AC-AMT-UNUSED-CR = ZERO )                               
              OR ( AC-AMT-UNUSED-CR < AU-CURRENCY-AMT )                 
                                                                        
      ** ROLLBACK TRANSACTION.                                          16130000
              MOVE WS-CREDIT-BAL-LESS-RET-CODE TO S-RETURN-CODE         
              MOVE WS-CREDIT-BAL-LESS-RET-CODE TO WS-ACTIVE-RETURN-CODE 
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF ( AC-AMT-UNUSED-CR = AU-CURRENCY-AMT )                    
                                                                        
              IF AC-PYMT-PRIORITY-LVL = 40 OR                           
                 AC-PYMT-PRIORITY-LVL = 45                              
                 MOVE ZERO                      TO AC-AMT-UNUSED-CR     
                 PERFORM 8500-UPDATE-AR-CNTL    THRU 8500-KR364-EXIT    
              ELSE                                                      
                PERFORM 8600-DELETE-AR-CNTL     THRU 8600-KR364-EXIT    
              END-IF                                                    
                                                                        
              IF AC-PYMT-PRIORITY-LVL >= 50                             
                 MOVE 'DEL'                          TO WS-SUMM-FLAG    
                 PERFORM 5300-ADJUST-SUMMARY-PPL-ROW                    
                                                 THRU 5300-KR364-EXIT   
              END-IF                                                    
                                                                        
           ELSE                                                         
              IF ( AC-AMT-UNUSED-CR > AU-CURRENCY-AMT )                 
                                                                        
                 COMPUTE AC-AMT-UNUSED-CR =                             
                              AC-AMT-UNUSED-CR - AU-CURRENCY-AMT        
                                                                        
                 IF WS-BAL-NEGETIVE = 'T'                               
                    COMPUTE                                             
                        AC-AMT-UNUSED-CR = -1 * AC-AMT-UNUSED-CR        
                 END-IF                                                 
                                                                        
                 IF AC-PYMT-PRIORITY-LVL >= 50                          
                    COMPUTE AC-AMT-TRAN-BALANCE = AC-AMT-TRAN-BALANCE   
                               + AU-CURRENCY-AMT                        
                 END-IF                                                 
                                                                        
                 PERFORM 8500-UPDATE-AR-CNTL    THRU 8500-KR364-EXIT    
                                                                        
                 IF AC-PYMT-PRIORITY-LVL >= 50                          
                    MOVE 'ADJ'                          TO WS-SUMM-FLAG 
                    PERFORM 5300-ADJUST-SUMMARY-PPL-ROW                 
                                                    THRU 5300-KR364-EXIT
                 END-IF                                                 
                                                                        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5290-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************16560000
      * 5300-ADJUST-SUMMARY-PPL-ROW                                    *        
      ******************************************************************16560000
                                                                        
       5300-ADJUST-SUMMARY-PPL-ROW.                                     
                                                                        
           MOVE AC-ITEM-ID                   TO WS-AC-SUMM-ITEM-ID.     
           MOVE AC-AMT-UNUSED-CR             TO WS-AC-SUMM-UNUSED-CR.   
           MOVE 0                            TO AC-ITEM-ID.             
           PERFORM 7030-SELECT-AR-CNTL       THRU 7030-KR364-EXIT.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
              IF AC-AMT-UNUSED-CR < 0                                   
                 MOVE 'T'                 TO WS-SUMM-BAL-NEGV           
                                                                        
                 COMPUTE AC-AMT-UNUSED-CR                               
                               = -1 * AC-AMT-UNUSED-CR                  
              ELSE                                                      
                 MOVE 'F'                 TO WS-SUMM-BAL-NEGV           
              END-IF                                                    
                                                                        
              COMPUTE AC-AMT-UNUSED-CR =                                
                           AC-AMT-UNUSED-CR - AU-CURRENCY-AMT           
                                                                        
              IF WS-SUMM-BAL-NEGV = 'T'                                 
                 COMPUTE                                                
                     AC-AMT-UNUSED-CR = -1 * AC-AMT-UNUSED-CR           
              END-IF                                                    
                                                                        
              IF  WS-SUMM-FLAG = 'DEL'                                  
              AND AC-AMT-AR-DAY-00 = ZEROES                             
              AND AC-AMT-AR-DAY-30 = ZEROES                             
              AND AC-AMT-AR-DAY-60 = ZEROES                             
              AND AC-AMT-AR-DAY-90 = ZEROES                             
              AND AC-AMT-UNUSED-CR = ZEROES                             
                                                                        
                 PERFORM 8600-DELETE-AR-CNTL THRU 8600-KR364-EXIT       
              ELSE                                                      
                                                                        
                 PERFORM 8500-UPDATE-AR-CNTL THRU 8500-KR364-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE SPACES                       TO WS-SUMM-FLAG.           
           MOVE WS-AC-SUMM-ITEM-ID           TO AC-ITEM-ID.             
           MOVE WS-AC-SUMM-UNUSED-CR         TO AC-AMT-UNUSED-CR.       
                                                                        
       5300-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************25880000
      * 7010 ACCEPT TIMESTAMP                                          *25890000
      ******************************************************************25920000
                                                                        
       7010-ACCEPT-TIMESTAMP.                                           
                                                                        
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     25960000
MFA-TR*          SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP          25970000
MFA-TR*    END-EXEC.                                                    25980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7010-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-GL-ACCT-NO                                                *        
      ******************************************************************        
                                                                        
       7020-GL-ACCT-NO.                                                 
                                                                        
           MOVE AT-COMPANY-NO        TO GO-COMPANY-NO.                  
           MOVE WS-GLED-ACCT-NAME    TO GO-GL-ACCT-NAME.                
                                                                        
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :GO-GL-ACCT-NO                                    
                 FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                      
                WHERE COMPANY_NO   = '01'                               
                  AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20000000
MFA-TR*        SELECT GL_ACCT_NO                                        20010000
MFA-TR*          INTO :GO-GL-ACCT-NO                                    20020000
MFA-TR*          FROM CSS_GL_ACCT_NO                                    20030000
MFA-TR*         WHERE COMPANY_NO   = '01'                               20040000
MFA-TR*           AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                   20050000
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                    20060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE GO-GL-ACCT-NO   TO WS-GLED-ACCT-NO                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7020'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT            '  TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-TABLES               
                                             ABEND-SQL-PREDICATES       
               MOVE 'CSS_GL_ACCT_NO    '  TO TABLE-1                    
               MOVE 'COMPANY_NO        '  TO TABLE-ELEMENT-1            
               MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-2            
               MOVE '01'                  TO HOSTVAR-ELEMENT-1          
               MOVE GO-GL-ACCT-NAME       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7020-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************20550000
      *   7030-SELECT-AR-CNTL                                          *20560000
      ******************************************************************20600000
                                                                        
       7030-SELECT-AR-CNTL.                                             
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3         TO AC-ACCOUNT-NO.           
                                                                        
           EXEC SQL                                                     
             SELECT AMT_AR_DAY_00,                                      
                    AMT_AR_DAY_30,                                      
                    AMT_AR_DAY_60,                                      
                    AMT_AR_DAY_90,                                      
                    AMT_TRAN_BALANCE,                                   
                    AMT_UNUSED_CR,                                      
                    REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                    TOT_SUMM_UNBILLED                                   
               INTO :AC-AMT-AR-DAY-00,                                  
                    :AC-AMT-AR-DAY-30,                                  
                    :AC-AMT-AR-DAY-60,                                  
                    :AC-AMT-AR-DAY-90,                                  
                    :AC-AMT-TRAN-BALANCE,                               
                    :AC-AMT-UNUSED-CR,                                  
                    :AC-LAST-UPDATE-TS,                                 
                    :AC-TOT-SUMM-UNBILLED                               
               FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                  
                AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL           
                AND ITEM_ID           = :AC-ITEM-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     20660000
MFA-TR*      SELECT AMT_AR_DAY_00,                                      20670000
MFA-TR*             AMT_AR_DAY_30,                                      20680000
MFA-TR*             AMT_AR_DAY_60,                                      20690000
MFA-TR*             AMT_AR_DAY_90,                                      20700000
MFA-TR*             AMT_TRAN_BALANCE,                                   20710000
MFA-TR*             AMT_UNUSED_CR,                                      20720000
MFA-TR*             LAST_UPDATE_TS,                                     20730000
MFA-TR*             TOT_SUMM_UNBILLED                                   20740000
MFA-TR*        INTO :AC-AMT-AR-DAY-00,                                  20750000
MFA-TR*             :AC-AMT-AR-DAY-30,                                  20760000
MFA-TR*             :AC-AMT-AR-DAY-60,                                  20770000
MFA-TR*             :AC-AMT-AR-DAY-90,                                  20780000
MFA-TR*             :AC-AMT-TRAN-BALANCE,                               20790000
MFA-TR*             :AC-AMT-UNUSED-CR,                                  20800000
MFA-TR*             :AC-LAST-UPDATE-TS,                                 20810000
MFA-TR*             :AC-TOT-SUMM-UNBILLED                               20820000
MFA-TR*        FROM CSS_AR_CNTL                                         20830000
MFA-TR*       WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                  20840000
MFA-TR*         AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL           20850000
MFA-TR*         AND ITEM_ID           = :AC-ITEM-ID                     20860000
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7030                                                        
MFA-TR*    END-EXEC.                                                    20870000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                     OR NOT-FOUND                       
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE '7030'              TO ACTIVE-PARAGRAPH              
              MOVE SPACES              TO ABEND-TABLES                  
                                          ABEND-SQL-PREDICATES          
              MOVE 'CSS_AR_CNTL      ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
              MOVE 'ITEM-ID     '      TO TABLE-ELEMENT-2               
              MOVE 'PYMT_PRIORITY_LVL' TO TABLE-ELEMENT-3               
              MOVE AC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE AC-ITEM-ID          TO HOSTVAR-ELEMENT-2             
              MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7040-SELECT-PREMISE                                            *        
      ******************************************************************        
                                                                        
       7040-SELECT-PREMISE.                                             
                                                                        
           MOVE AT-PREMISE-NO                TO PR-PREMISE-NO.          
                                                                        
           EXEC SQL                                                     
           SELECT  CODE_PREMISE_STAT,                                   
                   REV_DISTRICT_CD,                                     
                   LOCAL_OFFICE                                         
           INTO    :PR-CODE-PREMISE-STAT,                               
                   :PR-REV-DISTRICT-CD,                                 
                   :PR-LOCAL-OFFICE                                     
           FROM    CSS_PREMISE WITH(READUNCOMMITTED)                            
           WHERE   PREMISE_NO = :PR-PREMISE-NO                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21950000
MFA-TR*    SELECT  CODE_PREMISE_STAT,                                   21960000
MFA-TR*            REV_DISTRICT_CD,                                     21970000
MFA-TR*            LOCAL_OFFICE                                         21980000
MFA-TR*    INTO    :PR-CODE-PREMISE-STAT,                               21990000
MFA-TR*            :PR-REV-DISTRICT-CD,                                 22000000
MFA-TR*            :PR-LOCAL-OFFICE                                     22010000
MFA-TR*    FROM    CSS_PREMISE                                          22020000
MFA-TR*    WHERE   PREMISE_NO = :PR-PREMISE-NO                          22030000
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7040                                                         
MFA-TR*    END-EXEC.                                                    22040000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7040'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       7040-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-SELECT-CUSTOMER                                           *        
      ******************************************************************        
                                                                        
       7050-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT CODE_EMPL_ACCT, CODE_CUST_STATUS                   
                INTO :CU-CODE-EMPL-ACCT, :CU-CODE-CUST-STATUS           
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22670000
MFA-TR*       SELECT CODE_EMPL_ACCT, CODE_CUST_STATUS                   22680000
MFA-TR*         INTO :CU-CODE-EMPL-ACCT, :CU-CODE-CUST-STATUS           22690000
MFA-TR*         FROM CSS_CUSTOMER                                       22700000
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      22710000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                    22720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE SPACES          TO ABEND-TABLES                     
               MOVE SPACES          TO ABEND-SQL-PREDICATES             
               MOVE '7050'          TO ACTIVE-PARAGRAPH                 
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE 'SELECT'        TO ABEND-FUNCTION                   
               MOVE 'CSS_CUSTOMER'  TO TABLE-1                          
               MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1                  
               MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-2                  
               MOVE AT-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1                
               MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-2                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7050-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-GET-ACCOUNT-INFO                                          *        
      ******************************************************************        
                                                                        
       7800-GET-ACCOUNT-INFO.                                           
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3   TO AT-ACCOUNT-NO.                 
                                                                        
           EXEC SQL                                                     
               SELECT CODE_COMPANY_ACCT, DATE_LAST_ACTION,              
                      CODE_ACCT_STAT,COMPANY_NO, PREMISE_NO,            
                      TOTAL_AR_BALANCE, CUSTOMER_NO ,                   
                      CODES_DATA_PRESENT,                               
                      LOCAL_OFFICE,                                     
                      REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
               INTO  :AT-CODE-COMPANY-ACCT, :AT-DATE-LAST-ACTION,       
                     :AT-CODE-ACCT-STAT,:AT-COMPANY-NO, :AT-PREMISE-NO, 
                     :AT-TOTAL-AR-BALANCE, :AT-CUSTOMER-NO,             
                     :AT-CODES-DATA-PRESENT, :AT-LOCAL-OFFICE,          
                     :AT-LAST-UPDATE-TS                                 
               FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     22290000
MFA-TR*        SELECT CODE_COMPANY_ACCT, DATE_LAST_ACTION,              22300000
MFA-TR*               CODE_ACCT_STAT,COMPANY_NO, PREMISE_NO,            22310000
MFA-TR*               TOTAL_AR_BALANCE, CUSTOMER_NO ,                   22320000
MFA-TR*               CODES_DATA_PRESENT,                               22330000
MFA-TR*               LOCAL_OFFICE,                                     22340000
MFA-TR*               LAST_UPDATE_TS                                    22350000
MFA-TR*        INTO  :AT-CODE-COMPANY-ACCT, :AT-DATE-LAST-ACTION,       22360000
MFA-TR*              :AT-CODE-ACCT-STAT,:AT-COMPANY-NO, :AT-PREMISE-NO, 22370000
MFA-TR*              :AT-TOTAL-AR-BALANCE, :AT-CUSTOMER-NO,             22380000
MFA-TR*              :AT-CODES-DATA-PRESENT, :AT-LOCAL-OFFICE,          22390000
MFA-TR*              :AT-LAST-UPDATE-TS                                 22400000
MFA-TR*        FROM  CSS_ACCOUNT                                        22410000
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       22420000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                    22430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE SPACES         TO ABEND-TABLES                       
              MOVE SPACES         TO ABEND-SQL-PREDICATES               
              MOVE '7800'         TO ACTIVE-PARAGRAPH                   
              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
              MOVE 'SELECT'       TO ABEND-FUNCTION                     
              MOVE 'CSS_ACCOUNT'  TO TABLE-1                            
              MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-1                    
              MOVE AT-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8500-UPDATE-AR-CNTL                                            *        
      ******************************************************************        
                                                                        
       8500-UPDATE-AR-CNTL.                                             
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3  TO AC-ACCOUNT-NO.                  
           MOVE WS-CURRENT-TIMESTAMP TO AC-LAST-UPDATE-TS.              
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
                SET  AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,             
                     AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30,             
                     AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60,             
                     AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90,             
                     AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE,          
                     AMT_UNUSED_CR     = :AC-AMT-UNUSED-CR,             
                     LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :AC-LAST-UPDATE-TS
              ),            
                     TOT_SUMM_UNBILLED = :AC-TOT-SUMM-UNBILLED          
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     21550000
MFA-TR*       UPDATE CSS_AR_CNTL                                        21560000
MFA-TR*         SET  AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,             21570000
MFA-TR*              AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30,             21580000
MFA-TR*              AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60,             21590000
MFA-TR*              AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90,             21600000
MFA-TR*              AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE,          21610000
MFA-TR*              AMT_UNUSED_CR     = :AC-AMT-UNUSED-CR,             21620000
MFA-TR*              LAST_UPDATE_TS    = :AC-LAST-UPDATE-TS,            21630000
MFA-TR*              TOT_SUMM_UNBILLED = :AC-TOT-SUMM-UNBILLED          21640000
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 21650000
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          21660000
MFA-TR*          AND ITEM_ID           = :AC-ITEM-ID                    21670000
MFA-TR*    END-EXEC.                                                    21680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE '8500'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_CNTL       '       TO TABLE-1                
              MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
              MOVE 'PYMT_PRIORITY_LVL'        TO TABLE-ELEMENT-2        
              MOVE 'ITEM_ID'                  TO TABLE-ELEMENT-3        
              MOVE 'TOT_SUMM_UNBILLED'        TO TABLE-ELEMENT-4        
              MOVE WS-ACCOUNT-NO-COMP3        TO HOSTVAR-ELEMENT-1      
              MOVE AC-PYMT-PRIORITY-LVL       TO HOSTVAR-ELEMENT-2      
              MOVE AC-ITEM-ID                 TO HOSTVAR-ELEMENT-3      
              MOVE AC-TOT-SUMM-UNBILLED       TO HOSTVAR-ELEMENT-4-N    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8500-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************30740000
      * 8100-INSERT-AR-TRANS-HIST                                      *30750000
      ******************************************************************30770000
                                                                        
       8100-INSERT-AR-TRANS-HIST.                                       
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_AR_TRANS_HIST                           
                       (ACCOUNT_NO,                                     
                        TRANS_HIST_SEQ_NO,                              
                        DATE_TRANS,                                     
                        CODE_TRAN_TYPE,                                 
                        AMT_ORIG_ENTERED,                               
                        AMT_BILLED_UNPAID,                              
                        RESP_AREA_ID,                                   
                        APPL_PROGRAM_ID,                                
                        PYMT_FACILITY_CD,                               
                        USER_ID,                                        
                        COMPANY_NO,                                     
                        RECORD_ONLY_FL,                                 
                        DATE_ORIG_PYMT,                                 
                        PYMT_REFUNDED_IND,                              
                        CASH_COMPANY_NO,                                
                        CASH_LOCAL_OFFICE,                              
                        CASH_REPORT_NO,                                 
                        DATE_CASH_REPORT,                               
                        CASH_DRAWER_ID,                                 
                        TRAN_COMMENT)                                   
                VALUES                                                  
                      (:AR-ACCOUNT-NO,                                  
                       CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO),               
                       IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS 
                                             :WS-AR-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS 
                                                      :WS-AR-NULL-IND-1
              ) <> 0) OR (LEN(:AR-DATE-TRANS :WS-AR-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-TRANS :WS-AR-NULL-IND-1
              ), CONVERT(DATE, :AR-DATE-TRANS :WS-AR-NULL-IND-1) ),            
                       :AR-CODE-TRAN-TYPE,                              
                       :AR-AMT-ORIG-ENTERED,                            
                       :AR-AMT-BILLED-UNPAID,                           
                       :AR-RESP-AREA-ID,                                
                       :AR-APPL-PROGRAM-ID,                             
                       :AR-PYMT-FACILITY-CD,                            
                       :AR-USER-ID,                                     
                       :AR-COMPANY-NO,                                  
                       :AR-RECORD-ONLY-FL,                              
                       IIF(TRY_CONVERT(DATE, :AR-DATE-ORIG-PYMT 
                                             :WS-AR-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-ORIG-PYMT 
                                                      :WS-AR-NULL-IND-2
              ) <> 0) OR (LEN(:AR-DATE-ORIG-PYMT :WS-AR-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-ORIG-PYMT 
                                                      :WS-AR-NULL-IND-2
              ), CONVERT(DATE, :AR-DATE-ORIG-PYMT :WS-AR-NULL-IND-2) ),        
                       :AR-PYMT-REFUNDED-IND,                           
                       :AR-CASH-COMPANY-NO,                             
                       :AR-CASH-LOCAL-OFFICE,                           
                       :AR-CASH-REPORT-NO,                              
                       IIF(TRY_CONVERT(DATE, :AR-DATE-CASH-REPORT 
                                             :WS-AR-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT 
                                                      :WS-AR-NULL-IND-3
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT :WS-AR-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT 
                                                      :WS-AR-NULL-IND-3
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT :WS-AR-NULL-IND-3
              ) ),           
                       :AR-CASH-DRAWER-ID,                              
                       :AR-TRAN-COMMENT)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     30810000
MFA-TR*         INSERT INTO CSS_AR_TRANS_HIST                           30820000
MFA-TR*                (ACCOUNT_NO,                                     30830000
MFA-TR*                 TRANS_HIST_SEQ_NO,                              30840000
MFA-TR*                 DATE_TRANS,                                     30850000
MFA-TR*                 CODE_TRAN_TYPE,                                 30860000
MFA-TR*                 AMT_ORIG_ENTERED,                               30870000
MFA-TR*                 AMT_BILLED_UNPAID,                              30880000
MFA-TR*                 RESP_AREA_ID,                                   30890000
MFA-TR*                 APPL_PROGRAM_ID,                                30900000
MFA-TR*                 PYMT_FACILITY_CD,                               30910000
MFA-TR*                 USER_ID,                                        30920000
MFA-TR*                 COMPANY_NO,                                     30930000
MFA-TR*                 RECORD_ONLY_FL,                                 30940000
MFA-TR*                 DATE_ORIG_PYMT,                                 30950000
MFA-TR*                 PYMT_REFUNDED_IND,                              30960000
MFA-TR*                 CASH_COMPANY_NO,                                30970000
MFA-TR*                 CASH_LOCAL_OFFICE,                              30980000
MFA-TR*                 CASH_REPORT_NO,                                 30990000
MFA-TR*                 DATE_CASH_REPORT,                               31000000
MFA-TR*                 CASH_DRAWER_ID,                                 31010000
MFA-TR*                 TRAN_COMMENT)                                   31020000
MFA-TR*         VALUES                                                  31030000
MFA-TR*               (:AR-ACCOUNT-NO,                                  31040000
MFA-TR*                :AR-TRANS-HIST-SEQ-NO,                           31050000
MFA-TR*                :AR-DATE-TRANS:WS-AR-NULL-IND-1,                 31060000
MFA-TR*                :AR-CODE-TRAN-TYPE,                              31070000
MFA-TR*                :AR-AMT-ORIG-ENTERED,                            31080000
MFA-TR*                :AR-AMT-BILLED-UNPAID,                           31090000
MFA-TR*                :AR-RESP-AREA-ID,                                31100000
MFA-TR*                :AR-APPL-PROGRAM-ID,                             31110000
MFA-TR*                :AR-PYMT-FACILITY-CD,                            31120000
MFA-TR*                :AR-USER-ID,                                     31130000
MFA-TR*                :AR-COMPANY-NO,                                  31140000
MFA-TR*                :AR-RECORD-ONLY-FL,                              31150000
MFA-TR*                :AR-DATE-ORIG-PYMT:WS-AR-NULL-IND-2,             31160000
MFA-TR*                :AR-PYMT-REFUNDED-IND,                           31170000
MFA-TR*                :AR-CASH-COMPANY-NO,                             31180000
MFA-TR*                :AR-CASH-LOCAL-OFFICE,                           31190000
MFA-TR*                :AR-CASH-REPORT-NO,                              31200000
MFA-TR*                :AR-DATE-CASH-REPORT:WS-AR-NULL-IND-3,           31210000
MFA-TR*                :AR-CASH-DRAWER-ID,                              31220000
MFA-TR*                :AR-TRAN-COMMENT)                                31230000
MFA-TR*    END-EXEC.                                                    31240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'DATE_TRANS'             TO TABLE-ELEMENT-2          
              MOVE 'DATE_CASH_REPORT'       TO TABLE-ELEMENT-3          
              MOVE WS-ACCOUNT-NO-COMP3      TO HOSTVAR-ELEMENT-1        
              MOVE AR-DATE-TRANS            TO HOSTVAR-ELEMENT-2        
              MOVE AR-DATE-CASH-REPORT      TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************19350000
      * 8110-INSERT-AR-DET.                                            *19360000
      ******************************************************************19380000
                                                                        
       8110-INSERT-AR-DET.                                              
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3         TO AU-ACCOUNT-NO.           
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_AR_TRN_HST_DET                          
                       (ACCOUNT_NO,                                     
                        AMT_POSTED,                                     
                        CODE_AR_AGE,                                    
                        CODE_CONTRACT_TYPE,                             
                        CURRENCY_AMT,                                   
                        CURRENCY_TYPE,                                  
                        GL_ACCT_CREDIT,                                 
                        GL_ACCT_DEBIT,                                  
                        ITEM_ID,                                        
                        TRAN_APPL_NO,                                   
                        TRANS_HIST_SEQ_NO)                              
                VALUES (:AU-ACCOUNT-NO,                                 
                       :AU-AMT-POSTED,                                  
                       :AU-CODE-AR-AGE,                                 
                       :AU-CODE-CONTRACT-TYPE,                          
                       :AU-CURRENCY-AMT,                                
                       :AU-CURRENCY-TYPE,                               
                       :AU-GL-ACCT-CREDIT,                              
                       :AU-GL-ACCT-DEBIT,                               
                       :AU-ITEM-ID,                                     
                       :AU-TRAN-APPL-NO,                                
                       CIS.CHAR2TIMESTAMP(:AU-TRANS-HIST-SEQ-NO))               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     19430000
MFA-TR*         INSERT INTO CSS_AR_TRN_HST_DET                          19440000
MFA-TR*                (ACCOUNT_NO,                                     19450000
MFA-TR*                 AMT_POSTED,                                     19460000
MFA-TR*                 CODE_AR_AGE,                                    19470000
MFA-TR*                 CODE_CONTRACT_TYPE,                             19480000
MFA-TR*                 CURRENCY_AMT,                                   19490000
MFA-TR*                 CURRENCY_TYPE,                                  19500000
MFA-TR*                 GL_ACCT_CREDIT,                                 19510000
MFA-TR*                 GL_ACCT_DEBIT,                                  19520000
MFA-TR*                 ITEM_ID,                                        19530000
MFA-TR*                 TRAN_APPL_NO,                                   19540000
MFA-TR*                 TRANS_HIST_SEQ_NO)                              19550000
MFA-TR*         VALUES (:AU-ACCOUNT-NO,                                 19560000
MFA-TR*                :AU-AMT-POSTED,                                  19570000
MFA-TR*                :AU-CODE-AR-AGE,                                 19580000
MFA-TR*                :AU-CODE-CONTRACT-TYPE,                          19590000
MFA-TR*                :AU-CURRENCY-AMT,                                19600000
MFA-TR*                :AU-CURRENCY-TYPE,                               19610000
MFA-TR*                :AU-GL-ACCT-CREDIT,                              19620000
MFA-TR*                :AU-GL-ACCT-DEBIT,                               19630000
MFA-TR*                :AU-ITEM-ID,                                     19640000
MFA-TR*                :AU-TRAN-APPL-NO,                                19650000
MFA-TR*                :AU-TRANS-HIST-SEQ-NO)                           19660000
MFA-TR*    END-EXEC.                                                    19670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19680000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8110'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_AR_TRN_HST_DET'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE WS-ACCOUNT-NO-COMP3      TO HOSTVAR-ELEMENT-1        
              MOVE 'TRAN_APPL_NO'           TO TABLE-ELEMENT-2          
              MOVE AU-TRAN-APPL-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8110-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************28890000
      * 8300-UPDATE-ACCOUNT                                            *        
      ******************************************************************28890000
                                                                        
       8300-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET DATE_LAST_ACTION   = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ),             
                     TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,         
                     LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )            
              WHERE  ACCOUNT_NO         = :AT-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     28920000
MFA-TR*       UPDATE CSS_ACCOUNT                                        28930000
MFA-TR*          SET DATE_LAST_ACTION   = :WS-CURRENT-DATE,             28940000
MFA-TR*              TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,         28950000
MFA-TR*              LAST_UPDATE_TS     = :AT-LAST-UPDATE-TS                    
MFA-TR*       WHERE  ACCOUNT_NO         = :AT-ACCOUNT-NO                28960000
MFA-TR*    END-EXEC.                                                    28970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'DATE_LAST_ACTION'       TO TABLE-ELEMENT-2          
              MOVE 'TOTAL_AR_BALANCE'       TO TABLE-ELEMENT-3          
              MOVE 'LAST_UPDATE_TS'         TO TABLE-ELEMENT-4          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-CURRENT-DATE          TO HOSTVAR-ELEMENT-2        
              MOVE AT-TOTAL-AR-BALANCE      TO HOSTVAR-ELEMENT-3-N      
              MOVE AT-LAST-UPDATE-TS        TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************21100000
      * 8600-DELETE-AR-CNTL                                            *21110000
      ******************************************************************21130000
                                                                        
       8600-DELETE-AR-CNTL.                                             
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3         TO AC-ACCOUNT-NO.           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_AR_CNTL                                   
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_AR_CNTL   '         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE WS-ACCOUNT-NO-COMP3      TO HOSTVAR-ELEMENT-1        
              MOVE 'PYMT_PRITY_LVL'         TO TABLE-ELEMENT-2          
              MOVE 'ITEM_ID'                TO TABLE-ELEMENT-3          
              MOVE AC-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-2        
              MOVE AC-ITEM-ID               TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8600-KR364-EXIT.                                                 
           EXIT.                                                        
                                                                        
