      ******************************************************************00010000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00020000
      **                                                              **00030000
      *********           CUSTOMER SERVICE SYSTEM              *********00040000
      *********                     DB2                        *********00050000
      **                                                              **00060000
      ******************************************************************00070000
      **--------------- P R O G R A M  S U M M A R Y -----------------**00080000
      *************************************************************** **00090000
      ** CPDKR363:                                                    **00100000
      ** # This copybook is used to Insert Address details into       **00101000
      **   Formatted & Freeform tables.                               **00101100
      ** # In Refunds, if any changes to the address then always will **        
      **   Insert new address.                                        **        
      **                                                              **00102000
      ** The following programs presently use this copybook           **00112000
      ** CSR04888                                                     **00113000
      ** CSR04890                                                     **00113000
      ******************************************************************00120000
      *                                                               **00121000
      *  PREREQUISITES: CWSKR363 working storage variables should be  **00130000
      *                 populated prior to invoking this routine.     **00140000
      *                                                               **00150000
      *  INPUT                                                        **00160000
      *  -----                                                        **00170000
      *  WS-KR363-ACTION-FLAG                  CHAR(01)                         
      *  WS-KR363-ADDRESS-FORMAT               CHAR(01)                         
      *  WS-KR363-ADDRESS-ID                   CHAR(01)                         
      *  WS-KR363-FMT-HOUSE-NO                 CHAR(15)                         
      *  WS-KR363-FMT-ADDR-PREFIX-1            CHAR(03)                         
      *  WS-KR363-FMT-ADDR-PREFIX-2            CHAR(02)                         
      *  WS-KR363-FMT-STREET-NAME              CHAR(30)                         
      *  WS-KR363-FMT-STREET-SUFFIX            CHAR(04)                         
      *  WS-KR363-FMT-ADDR-SUFFIX              CHAR(02)                         
      *  WS-KR363-FMT-STREET-LOC-1             CHAR(04)                         
      *  WS-KR363-FMT-STREET-LOC-2             CHAR(11)                         
      *  WS-KR363-FF-ADDR-STREET               CHAR(55)                         
      *  WS-KR363-FF-ADDR-OVERFLOW             CHAR(35)                         
      *  WS-KR363-FF-ADDR-COUNTRY              CHAR(35)                         
      *  WS-KR363-FF-ADDR-CITY-STATE           CHAR(30)                         
      *  WS-KR363-CITY                         CHAR(26)                         
      *  WS-KR363-STATE                        CHAR(02)                         
      *  WS-KR363-ZIP-CODE                     CHAR(05)                         
      *  WS-KR363-ZIP-CODE-PLUS-FOUR           CHAR(04)                         
      *                                                               **00240000
      ******************************************************************00480000
      *                                                                *00490000
      *                     PROGRAM MODIFICATION LOG                   *00500000
      *                                                                *00510000
      *    DATE    INITIALS   COMMENTS                                 *00520000
      *  --------  --------   ---------------------------------------  *00530000
P00870*  12/02/15  AA97148    PROCEDURE ORIGINALLY CODED.              *00540000
P0087A*  01/11/17  WR19680    ADDING FIX TO MOVE CITY AND STATE INTO   *        
P0087A*                       WS-KR363-FF-ADDR-CITY-STATE IF BLANK     *        
      ******************************************************************00550000
                                                                        
      ******************************************************************00570000
      * 5100-ADDRESS-PROCESS                                           *00580000
      ******************************************************************00590000
                                                                        
       5100-ADDRESS-PROCESS.                                            
                                                                        
           INITIALIZE DCLCSS-ADDR-FORMATTED                             
                      DCLCSS-ADDR-FREEFORM .                            
                                                                        
           PERFORM 5200-INSERT-ADDRESS-DTLS        THRU 5200-KR363-EXIT.
                                                                        
       5100-KR363-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************00830100
      * 5200-INSERT-ADDRESS-DTLS                                       *00830200
      ******************************************************************00830300
                                                                        
       5200-INSERT-ADDRESS-DTLS.                                        
                                                                        
           PERFORM 6202-GET-NEW-ADDRESS-ID         THRU 6202-EXIT.      
           IF WS-KR363-ADDRESS-FORMAT = 'A'                             
              PERFORM 5210-JRNL-INSERT-FMT-ADDR    THRU 5210-KR363-EXIT 
              PERFORM 8010-INSERT-FMT-ADDRESS      THRU 8010-KR363-EXIT 
           ELSE                                                         
              PERFORM 5220-JRNL-INSERT-FF-ADDR     THRU 5220-KR363-EXIT 
              PERFORM 8020-INSERT-FF-ADDRESS       THRU 8020-KR363-EXIT 
           END-IF.                                                      
                                                                        
       5200-KR363-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5210-JRNL-INSERT-FMT-ADDR                                      *        
      ******************************************************************        
                                                                        
       5210-JRNL-INSERT-FMT-ADDR.                                       
                                                                        
           MOVE '*NEW*'                     TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE 5                           TO MI-PRV-COLUMN-VALUE-LEN. 
                                                                        
      * House no                                                                
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'HOUSE_NO'                  TO MI-COLUMN-DESC.          
           MOVE 15                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-FMT-HOUSE-NO       TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DY-HOUSE-NO.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
                                                                        
      * Address Prefix 1                                                        
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'ADDR_PREFIX_1'             TO MI-COLUMN-DESC.          
           MOVE 3                           TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-FMT-ADDR-PREFIX-1  TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DY-ADDR-PREFIX-1.        
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
                                                                        
      * Address Prefix 2                                                        
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'ADDR_PREFIX_2'             TO MI-COLUMN-DESC.          
           MOVE 2                           TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-FMT-ADDR-PREFIX-2  TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DY-ADDR-PREFIX-2.        
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
                                                                        
      * Street Name                                                             
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'STREET_NAME'               TO MI-COLUMN-DESC.          
           MOVE 30                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-FMT-STREET-NAME    TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DY-STREET-NAME.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
                                                                        
      * Street Location 1                                                       
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'STREET_LOCATION_1'         TO MI-COLUMN-DESC.          
           MOVE 4                           TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-FMT-STREET-LOC-1   TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DY-STREET-LOCATION-1.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
                                                                        
      * Street Location 2                                                       
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'STREET_LOCATION_2'         TO MI-COLUMN-DESC.          
           MOVE 11                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-FMT-STREET-LOC-2   TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DY-STREET-LOCATION-2.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
                                                                        
      * Street Suffix                                                           
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'STREET_SUFFIX'             TO MI-COLUMN-DESC.          
           MOVE 4                           TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-FMT-STREET-SUFFIX  TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DY-STREET-SUFFIX.        
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
                                                                        
      * Address Suffix                                                          
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'ADDRESS_SUFFIX'            TO MI-COLUMN-DESC.          
           MOVE 2                           TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-FMT-ADDR-SUFFIX    TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DY-ADDR-SUFFIX.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
                                                                        
      * Zip Code                                                                
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'ZIP_CODE'                  TO MI-COLUMN-DESC.          
           MOVE 5                           TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-ZIP-CODE           TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DY-ZIP-CODE.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
                                                                        
      * Zip Code Plus Four                                                      
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'ZIP_CODE_PLUS_FOUR'        TO MI-COLUMN-DESC.          
           MOVE 4                           TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-ZIP-CODE-PLUS-FOUR TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DY-ZIP-CODE-PLUS-FOUR.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
                                                                        
           MOVE WS-KR363-CITY               TO A4-TOWN.                 
           MOVE WS-KR363-STATE              TO A4-STATE.                
           MOVE WS-KR363-ZIP-CODE           TO A4-ZIP-CODE.             
           PERFORM 7010-GET-TOKEN           THRU 7010-KR363-EXIT.       
           MOVE A4-ZIP-CODE-TOKEN           TO DY-ZIP-CODE-TOKEN.       
                                                                        
           MOVE WS-90-NEW-ADDRESS-ID        TO DY-ADDRESS-ID            
           MOVE SPACES                      TO DY-CARRIER-ROUTE         
                                               DY-ADDRESS-OVERFLOW      
                                               DY-USPS-DELIV-PT-CD.     
           MOVE 'F'                         TO DY-ADDR-USAGE-CD.        
                                                                        
       5210-KR363-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5220-JRNL-INSERT-FF-ADDR                                       *        
      ******************************************************************        
                                                                        
       5220-JRNL-INSERT-FF-ADDR.                                        
P0087A     IF WS-KR363-FF-ADDR-CITY-STATE = SPACES                      
P0087A         STRING WS-KR363-CITY DELIMITED BY SIZE " "               
P0087A                WS-KR363-STATE DELIMITED BY SIZE                  
P0087A                INTO WS-KR363-FF-ADDR-CITY-STATE
           END-IF.                 
                                                                        
           MOVE '*NEW*'                     TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE 5                           TO MI-PRV-COLUMN-VALUE-LEN. 
                                                                        
      * Address Street - Free Format                                            
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'ADDR_STREET'               TO MI-COLUMN-DESC.          
           MOVE 55                          TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-FF-ADDR-STREET     TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DZ-ADDR-STREET.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
                                                                        
      * Address City State - Free Format                                        
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'ADDR_CITY_STATE'           TO MI-COLUMN-DESC.          
           MOVE 30                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-FF-ADDR-CITY-STATE TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DZ-ADDR-CITY-STATE.      
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
                                                                        
      * Address Zip Code - Free Format                                          
           ADD +1                           TO MI-TRAN-APPL-NO.         
           MOVE 'ADDR_ZIP_CODE'             TO MI-COLUMN-DESC.          
           MOVE 9                           TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-KR363-ZIP-CODE           TO MI-CHG-COLUMN-VALUE-TEXT.
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
                                                                        
      * Address Country - Free Format                                           
           ADD +1                           TO MI-TRAN-APPL-NO          
           MOVE 'ADDR_COUNTRY'              TO MI-COLUMN-DESC           
           MOVE 35                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE WS-KR363-FF-ADDR-COUNTRY    TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DZ-ADDR-COUNTRY          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
                                                                        
      * Address Over Flow - Free Format                                         
           ADD +1                           TO MI-TRAN-APPL-NO          
           MOVE 'ADDRESS_OVERFLOW'          TO MI-COLUMN-DESC           
           MOVE 35                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE WS-KR363-FF-ADDR-OVERFLOW   TO MI-CHG-COLUMN-VALUE-TEXT 
                                               DZ-ADDRESS-OVERFLOW      
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
                                                                        
                                                                        
P0087A     IF WS-KR363-ZIP-CODE-PLUS-FOUR = SPACES                      
P0087A        MOVE WS-KR363-ZIP-CODE         TO WS-KR363-ADDR-ZIP-CODE  
P0087A     ELSE                                                         
P0087A        STRING WS-KR363-ZIP-CODE           DELIMITED BY SPACES    
P0087A               WS-KR363-ZIP-CODE-PLUS-FOUR DELIMITED BY SIZE      
P0087A               INTO WS-KR363-ADDR-ZIP-CODE                        
           END-IF.                                                      
                                                                        
           MOVE WS-90-NEW-ADDRESS-ID         TO DZ-ADDRESS-ID.          
           MOVE WS-KR363-ADDR-ZIP-CODE       TO DZ-ADDR-ZIP-CODE.       
                                                                        
       5220-KR363-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-GET-TOKEN                                                 *        
      ******************************************************************        
                                                                        
       7010-GET-TOKEN.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE TOWN     = :A4-TOWN                               
                  AND STATE    = :A4-STATE                              
                  AND ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE TOWN     = :A4-TOWN                                       
MFA-TR*           AND STATE    = :A4-STATE                                      
MFA-TR*           AND ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE '1' TO A4-ZIP-CODE-TOKEN                       
               WHEN OTHER                                               
                    MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE        
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7010'                 TO ACTIVE-PARAGRAPH     
                    MOVE SPACES                 TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                    MOVE SQLCODE                TO ABEND-SQLCODE        
                                                   S-RETURN-CODE        
                    MOVE 'SELECT'               TO ABEND-FUNCTION       
                    MOVE 'CSS_ZIP_CODE'         TO TABLE-1              
                    MOVE 'TOWN'                 TO TABLE-ELEMENT-1      
                    MOVE A4-TOWN                TO HOSTVAR-ELEMENT-1    
                    MOVE 'STATE'                TO TABLE-ELEMENT-2      
                    MOVE A4-STATE               TO HOSTVAR-ELEMENT-2    
                    MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-3      
                    MOVE A4-ZIP-CODE            TO HOSTVAR-ELEMENT-3    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7010-KR363-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020 GET FREEFROM ADDRESS                                      *        
      ******************************************************************        
                                                                        
       7020-GET-FREEFORM-ADDRESS.                                       
                                                                        
           EXEC SQL                                                     
                SELECT ADDR_STREET,                                     
                       ADDR_CITY_STATE,                                 
                       ADDR_ZIP_CODE,                                   
                       ADDR_COUNTRY,                                    
                       ADDRESS_OVERFLOW                                 
                  INTO :DZ-ADDR-STREET,                                 
                       :DZ-ADDR-CITY-STATE,                             
                       :DZ-ADDR-ZIP-CODE,                               
                       :DZ-ADDR-COUNTRY,                                
                       :DZ-ADDRESS-OVERFLOW                             
                  FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                  
                 WHERE ADDRESS_ID  =  :DZ-ADDRESS-ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ADDR_STREET,                                             
MFA-TR*                ADDR_CITY_STATE,                                         
MFA-TR*                ADDR_ZIP_CODE,                                           
MFA-TR*                ADDR_COUNTRY,                                            
MFA-TR*                ADDRESS_OVERFLOW                                         
MFA-TR*           INTO :DZ-ADDR-STREET,                                         
MFA-TR*                :DZ-ADDR-CITY-STATE,                                     
MFA-TR*                :DZ-ADDR-ZIP-CODE,                                       
MFA-TR*                :DZ-ADDR-COUNTRY,                                        
MFA-TR*                :DZ-ADDRESS-OVERFLOW                                     
MFA-TR*           FROM CSS_ADDR_FREEFORM                                        
MFA-TR*          WHERE ADDRESS_ID  =  :DZ-ADDRESS-ID                            
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ADDR_FREEFORM'      TO TABLE-1                  
              MOVE 'ADDRESS_ID'             TO TABLE-ELEMENT-1          
              MOVE DZ-ADDRESS-ID            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7020-KR363-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ***************************************************************** 15740000
      * 7030-GET-FMT-ADDRESS                                          * 15750000
      ***************************************************************** 15830000
                                                                        
       7030-GET-FMT-ADDRESS.                                            
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                     HOUSE_NO                                           
                    ,ADDR_PREFIX_1                                      
                    ,ADDR_PREFIX_2                                      
                    ,STREET_NAME                                        
                    ,STREET_LOCATION_1                                  
                    ,STREET_LOCATION_2                                  
                    ,STREET_SUFFIX                                      
                    ,ADDRESS_OVERFLOW                                   
                    ,ZIP_CODE                                           
                    ,ZIP_CODE_PLUS_FOUR                                 
                INTO :DY-HOUSE-NO                                       
                    ,:DY-ADDR-PREFIX-1                                  
                    ,:DY-ADDR-PREFIX-2                                  
                    ,:DY-STREET-NAME                                    
                    ,:DY-STREET-LOCATION-1                              
                    ,:DY-STREET-LOCATION-2                              
                    ,:DY-STREET-SUFFIX                                  
                    ,:DY-ADDRESS-OVERFLOW                               
                    ,:DY-ZIP-CODE                                       
                    ,:DY-ZIP-CODE-PLUS-FOUR                             
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
               WHERE ADDRESS_ID = :DY-ADDRESS-ID                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15910000
MFA-TR*       SELECT                                                    15920000
MFA-TR*              HOUSE_NO                                                   
MFA-TR*             ,ADDR_PREFIX_1                                              
MFA-TR*             ,ADDR_PREFIX_2                                              
MFA-TR*             ,STREET_NAME                                                
MFA-TR*             ,STREET_LOCATION_1                                          
MFA-TR*             ,STREET_LOCATION_2                                          
MFA-TR*             ,STREET_SUFFIX                                              
MFA-TR*             ,ADDRESS_OVERFLOW                                           
MFA-TR*             ,ZIP_CODE                                                   
MFA-TR*             ,ZIP_CODE_PLUS_FOUR                                         
MFA-TR*         INTO :DY-HOUSE-NO                                       15930000
MFA-TR*             ,:DY-ADDR-PREFIX-1                                  15930000
MFA-TR*             ,:DY-ADDR-PREFIX-2                                  15930000
MFA-TR*             ,:DY-STREET-NAME                                    15930000
MFA-TR*             ,:DY-STREET-LOCATION-1                              15930000
MFA-TR*             ,:DY-STREET-LOCATION-2                              15930000
MFA-TR*             ,:DY-STREET-SUFFIX                                  15930000
MFA-TR*             ,:DY-ADDRESS-OVERFLOW                               15930000
MFA-TR*             ,:DY-ZIP-CODE                                       15930000
MFA-TR*             ,:DY-ZIP-CODE-PLUS-FOUR                             15930000
MFA-TR*         FROM CSS_ADDR_FORMATTED DY                              15940000
MFA-TR*        WHERE ADDRESS_ID = :DY-ADDRESS-ID                        15950000
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                    15970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ADDR_FORMATTED'     TO TABLE-1                  
              MOVE 'ADDRESS_ID'             TO TABLE-ELEMENT-1          
              MOVE DY-ADDRESS-ID            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7030-KR363-EXIT.                                                 
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8010-INSERT-FMT-ADDRESS.                                                
      *****************************************************************         
                                                                        
       8010-INSERT-FMT-ADDRESS.                                         
                                                                        
               EXEC SQL                                                 
                   INSERT INTO CSS_ADDR_FORMATTED                       
                       (ADDRESS_ID                                      
                       ,HOUSE_NO                                        
                       ,ADDR_PREFIX_1                                   
                       ,ADDR_PREFIX_2                                   
                       ,STREET_NAME                                     
                       ,STREET_LOCATION_1                               
                       ,STREET_LOCATION_2                               
                       ,STREET_SUFFIX                                   
                       ,ADDR_SUFFIX                                     
                       ,ZIP_CODE                                        
                       ,ZIP_CODE_PLUS_FOUR                              
                       ,ZIP_CODE_TOKEN                                  
                       ,CARRIER_ROUTE                                   
                       ,ADDR_USAGE_CD                                   
                       ,USPS_DELIV_PT_CD)                               
                   VALUES                                               
                       (:DY-ADDRESS-ID                                  
                       ,:DY-HOUSE-NO                                    
                       ,:DY-ADDR-PREFIX-1                               
                       ,:DY-ADDR-PREFIX-2                               
                       ,:DY-STREET-NAME                                 
                       ,:DY-STREET-LOCATION-1                           
                       ,:DY-STREET-LOCATION-2                           
                       ,:DY-STREET-SUFFIX                               
                       ,:DY-ADDR-SUFFIX                                 
                       ,:DY-ZIP-CODE                                    
                       ,:DY-ZIP-CODE-PLUS-FOUR                          
                       ,:DY-ZIP-CODE-TOKEN                              
                       ,:DY-CARRIER-ROUTE                               
                       ,:DY-ADDR-USAGE-CD                               
                       ,:DY-USPS-DELIV-PT-CD)                           
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8010'                    TO ACTIVE-PARAGRAPH        
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE SQLCODE                   TO ABEND-SQLCODE           
                                                S-RETURN-CODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-1                 
              MOVE 'ADDRESS_ID'              TO TABLE-ELEMENT-1         
              MOVE 'STREET_NAME'             TO TABLE-ELEMENT-2         
              MOVE 'ZIP_CODE'                TO TABLE-ELEMENT-3         
              MOVE DY-ADDRESS-ID             TO HOSTVAR-ELEMENT-1       
              MOVE DY-STREET-NAME            TO HOSTVAR-ELEMENT-2       
              MOVE DY-ZIP-CODE               TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8010-KR363-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************22900100
      * 8020-INSERT-FF-ADDRESS                                         *22900100
      ******************************************************************22900100
                                                                        
       8020-INSERT-FF-ADDRESS.                                          
                                                                        
            EXEC SQL                                                    
               INSERT INTO CSS_ADDR_FREEFORM                            
                    (ADDRESS_ID                                         
                    ,ADDR_STREET                                        
                    ,ADDRESS_OVERFLOW                                   
                    ,ADDR_CITY_STATE                                    
                    ,ADDR_ZIP_CODE                                      
                    ,ADDR_COUNTRY)                                      
               VALUES                                                   
                    (:DZ-ADDRESS-ID                                     
                    ,:DZ-ADDR-STREET                                    
                    ,:DZ-ADDRESS-OVERFLOW                               
                    ,:DZ-ADDR-CITY-STATE                                
                    ,:DZ-ADDR-ZIP-CODE                                  
                    ,:DZ-ADDR-COUNTRY)                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE SQLCODE              TO ABEND-SQLCODE                
                                           S-RETURN-CODE                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'ADDR_STREET'        TO TABLE-ELEMENT-2              
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-3              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DZ-ADDR-STREET       TO HOSTVAR-ELEMENT-2            
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-3            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       8020-KR363-EXIT.                                                 
           EXIT.                                                        
                                                                        
