      ******************************************************************00010000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00020000
      **                                                              **00030000
      *********           CUSTOMER SERVICE SYSTEM              *********00040000
      *********                     DB2                        *********00050000
      **                                                              **00060000
      ******************************************************************00070000
      **--------------- P R O G R A M  S U M M A R Y -----------------**00080000
      *************************************************************** **00090000
      ** CPDKR362:                                                    **00100000
      ** THIS COPYBOOK IS USED TO INSERT/UPDATE NAME DETAILS INTO     **00101000
      ** CSS_NAME TABLE.                                              **00101100
      **                                                              **00102000
      ** THE FOLLOWING PROGRAMS PRESENTLY USE THIS COPYBOOK           **00112000
      ** CSR04864                                                     **00113000
      ** CSR04851                                                     **00114000
      ******************************************************************00120000
      *                                                               **00121000
      *  PREREQUISITES: CWSKR362 WORKING STORAGE VARIABLES SHOULD BE  **00130000
      *                 POPULATED PRIOR TO INVOKING THIS ROUTINE.     **00140000
      *                                                               **00150000
      *  INPUT                                                        **00160000
      *  -----                                                        **00170000
      *  WS-KR362-FIRST-NAME          CHAR(15)                        **00180000
      *  WS-KR362-MIDDLE-NAME         CHAR(15)                        **00190000
      *  WS-KR362-LAST-NAME           CHAR(40)                        **00200000
      *  WS-KR362-TITLE-PREFIX        CHAR(09)                        **00210000
      *  WS-KR362-TITLE-SUFFIX-1      CHAR(03)                        **00220000
      *  WS-KR362-UPDATE-FLAG         CHAR(01)                        **00230000
      *  WS-KR362-NAME-ID             INTEGIER                        **00231000
      *  WS-KR362-NAME-TYPE           CHAR(02)                        **00232000
      *  WS-KR362-NAME-FORMAT         CHAR(01)                        **00232000
      *                                                               **00240000
      ******************************************************************00480000
      *                                                                *00490000
      *                     PROGRAM MODIFICATION LOG                   *00500000
      *                                                                *00510000
      *    DATE    INITIALS   COMMENTS                                 *00520000
      *  --------  --------   ---------------------------------------  *00530000
P00726*  06/19/15  AA97148    PROCEDURE ORIGINALLY CODED.              *00540000
      ******************************************************************00550000
                                                                        
      ******************************************************************00570000
      * 5100-NAME-PROCESS                                              *00580000
      ******************************************************************00590000
                                                                        
       5100-NAME-PROCESS.                                               
                                                                        
           INITIALIZE DCLCSS-NAME.                                      
                                                                        
           EVALUATE WS-KR362-UPDATE-FLAG                                
            WHEN 'I'                                                    
                 PERFORM 5210-INSERT-NAME-DETAILS  THRU 5210-KR362-EXIT 
            WHEN 'U'                                                    
                 PERFORM 5220-UPDATE-NAME-DETAILS  THRU 5220-KR362-EXIT 
           END-EVALUATE.                                                
                                                                        
       5100-KR362-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************00830100
      * 5210-INSERT-NAME-DETAILS                                       *00830200
      ******************************************************************00830300
                                                                        
       5210-INSERT-NAME-DETAILS.                                        
                                                                        
           PERFORM 6302-GET-NEW-NAME-ID            THRU 6302-EXIT.      
            STRING WS-KR362-FIRST-NAME                                  
                  ,WS-KR362-MIDDLE-NAME                                 
                  ,WS-KR362-LAST-NAME DELIMITED BY SIZE                 
              INTO WS-EMB-INPUT.                                        
           MOVE 70                          TO WS-EMB-LENG.             
           MOVE SPACES                      TO WS-CMP-TABLE.            
           PERFORM 6010-REDUCE-EMBEDDED-SPACES    THRU 6010-EXIT.       
           MOVE WS-CMP-TABLE                TO DQ-FULL-NAME.            
                                                                        
                                                                        
           MOVE WS-KR362-FIRST-NAME         TO DQ-FIRST-NAME.           
           MOVE WS-KR362-MIDDLE-NAME        TO DQ-MIDDLE-NAME.          
           MOVE WS-KR362-LAST-NAME          TO DQ-LAST-NAME.            
           MOVE WS-KR362-TITLE-PREFIX       TO DQ-TITLE-PREFIX.         
           MOVE WS-KR362-TITLE-SUFFIX-1     TO DQ-TITLE-SUFFIX-1.       
           MOVE WS-91-NEW-NAME-ID           TO DQ-NAME-ID.              
           MOVE WS-KR362-NAME-TYPE          TO DQ-NAME-TYPE.            
           MOVE WS-KR362-NAME-FORMAT        TO DQ-NAME-FORMAT.          
           MOVE SPACES                      TO DQ-NICKNAME              
                                               DQ-TITLE-SUFFIX-2.       
           PERFORM 8000-INSERT-NAME               THRU 8000-KR362-EXIT. 
                                                                        
       5210-KR362-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ******************************************************************00832900
      * 5220-UPDATE-NAME-DETAILS                                       *00833000
      ******************************************************************00833100
                                                                        
       5220-UPDATE-NAME-DETAILS.                                        
                                                                        
           MOVE WS-KR362-NAME-ID            TO DQ-NAME-ID.              
           MOVE WS-KR362-FIRST-NAME         TO DQ-FIRST-NAME.           
           MOVE WS-KR362-MIDDLE-NAME        TO DQ-MIDDLE-NAME.          
           MOVE WS-KR362-LAST-NAME          TO DQ-LAST-NAME.            
           MOVE WS-KR362-TITLE-PREFIX       TO DQ-TITLE-PREFIX.         
           MOVE WS-KR362-TITLE-SUFFIX-1     TO DQ-TITLE-SUFFIX-1.       
                                                                        
           PERFORM 8500-UPDATE-NAME                THRU 8500-KR362-EXIT.
                                                                        
       5220-KR362-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ***************************************************************** 01211000
      * 8000-INSERT-NAME                                              * 01212000
      ***************************************************************** 01213000
                                                                        
       8000-INSERT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                    (NAME_ID                                            
                    ,NAME_TYPE                                          
                    ,NAME_FORMAT                                        
                    ,CREATED_DATE                                       
                    ,TITLE_PREFIX                                       
                    ,FIRST_NAME                                         
                    ,MIDDLE_NAME                                        
                    ,LAST_NAME                                          
                    ,NICKNAME                                           
                    ,TITLE_SUFFIX_1                                     
                    ,TITLE_SUFFIX_2                                     
                    ,FULL_NAME)                                         
              VALUES                                                    
                    (:DQ-NAME-ID                                        
                    ,:DQ-NAME-TYPE                                      
                    ,:DQ-NAME-FORMAT                                    
                    ,CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP)                  
                    ,:DQ-TITLE-PREFIX                                   
                    ,:DQ-FIRST-NAME                                     
                    ,:DQ-MIDDLE-NAME                                    
                    ,:DQ-LAST-NAME                                      
                    ,:DQ-NICKNAME                                       
                    ,:DQ-TITLE-SUFFIX-1                                 
                    ,:DQ-TITLE-SUFFIX-2                                 
                    ,:DQ-FULL-NAME)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     01217000
MFA-TR*       INSERT INTO CSS_NAME                                      01218000
MFA-TR*             (NAME_ID                                            01219000
MFA-TR*             ,NAME_TYPE                                          01219100
MFA-TR*             ,NAME_FORMAT                                        01219200
MFA-TR*             ,CREATED_DATE                                       01219300
MFA-TR*             ,TITLE_PREFIX                                       01219400
MFA-TR*             ,FIRST_NAME                                         01219500
MFA-TR*             ,MIDDLE_NAME                                        01219600
MFA-TR*             ,LAST_NAME                                          01219700
MFA-TR*             ,NICKNAME                                           01219800
MFA-TR*             ,TITLE_SUFFIX_1                                     01219900
MFA-TR*             ,TITLE_SUFFIX_2                                     01220000
MFA-TR*             ,FULL_NAME)                                         01220100
MFA-TR*       VALUES                                                    01220200
MFA-TR*             (:DQ-NAME-ID                                        01220300
MFA-TR*             ,:DQ-NAME-TYPE                                      01220400
MFA-TR*             ,:DQ-NAME-FORMAT                                    01220500
MFA-TR*             ,:WS-CURRENT-TIMESTAMP                              01220600
MFA-TR*             ,:DQ-TITLE-PREFIX                                   01220700
MFA-TR*             ,:DQ-FIRST-NAME                                     01220800
MFA-TR*             ,:DQ-MIDDLE-NAME                                    01220900
MFA-TR*             ,:DQ-LAST-NAME                                      01221000
MFA-TR*             ,:DQ-NICKNAME                                       01221100
MFA-TR*             ,:DQ-TITLE-SUFFIX-1                                 01221200
MFA-TR*             ,:DQ-TITLE-SUFFIX-2                                 01221300
MFA-TR*             ,:DQ-FULL-NAME)                                     01221400
MFA-TR*    END-EXEC.                                                    01221500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE SQLCODE                   TO ABEND-SQLCODE           
                                                S-RETURN-CODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_NAME'                TO TABLE-1                 
              MOVE 'NAME_ID'                 TO TABLE-ELEMENT-1         
              MOVE 'NAME_TYPE'               TO TABLE-ELEMENT-2         
              MOVE 'LAST_NAME'               TO TABLE-ELEMENT-3         
              MOVE DQ-NAME-ID                TO HOSTVAR-ELEMENT-1       
              MOVE DQ-NAME-TYPE              TO HOSTVAR-ELEMENT-2       
              MOVE DQ-LAST-NAME              TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8000-KR362-EXIT.                                                 
           EXIT.                                                        
                                                                        
      ***************************************************************** 01225000
      * 8500-UPDATE-NAME.                                               01230000
      ***************************************************************** 01240000
                                                                        
       8500-UPDATE-NAME.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME                                           
                 SET FIRST_NAME     = :DQ-FIRST-NAME                    
                    ,MIDDLE_NAME    = :DQ-MIDDLE-NAME                   
                    ,LAST_NAME      = :DQ-LAST-NAME                     
                    ,TITLE_PREFIX   = :DQ-TITLE-PREFIX                  
                    ,TITLE_SUFFIX_1 = :DQ-TITLE-SUFFIX-1                
                    ,FULL_NAME      = :DQ-FULL-NAME                     
               WHERE NAME_ID        = :DQ-NAME-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8500'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SQLCODE                    TO ABEND-SQLCODE          
                                                 S-RETURN-CODE          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_NAME'                 TO TABLE-1                
              MOVE 'NAME_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'LAST_NAME'                TO TABLE-ELEMENT-2        
              MOVE 'FIRST_NAME'               TO TABLE-ELEMENT-3        
              MOVE DQ-NAME-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE DQ-LAST-NAME               TO HOSTVAR-ELEMENT-2      
              MOVE DQ-FIRST-NAME              TO HOSTVAR-ELEMENT-3      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8500-KR362-EXIT.                                                 
           EXIT.                                                        
                                                                        
