      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      ** CPDKR361:                                                    **        
      **           THIS COPY BOOK PROCESS ARRANGEMENT ATTRIBUTES.     **00020000
      ******************************************************************        
      ** PREREQUISITES: CWSKR361 WORKING  STORAGE VARIABLES SHOULD BE **        
      **                POPULATED PRIOR TO INVOKING THIS ROUTINE.     **        
      ** INPUT :                                                      **        
      **        WS-KR361-ARNG-PLAN-ID                                 **        
      **        WS-KR361-ARNG-OPTION-ID                               **        
      **        WS-KR361-ACCOUNT-NO                                   **        
      **        WS-KR361-MAJOR-IND                                    **        
      **        WS-KR361-ACCOUNT-TYPE-CD                              **        
P0726A**        WS-KR361-TOTAL-AMOUNT                                 **        
      **        WS-KR361-ARNG-CHANNEL-CD                              **        
      **        WS-KR361-COMPLIANCE-IND                               **        
      ** OUTPUT:                                                      **        
      **        WS-KR361-MAJOR-ATTR-FL                                **        
      **        WS-KR361-NON-RES-ATTR-FL                              **        
      **        WS-KR361-COMPLIANCE-ATTR-FL                           **        
P0726B**        WS-KR361-CT-METER-ATTR-FL                             **        
P0726B**        WS-KR361-SETUP-BELOW-LMT-FL                           **        
P0726C**        WS-KR361-CMPL-CHECK-IVR-FL                            **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      **    DATE      INITIALS    REASON                              **        
      **  -------     --------    ------                              **        
P00726**  06/14/2013  AA97148     INITIAL PROGRAM VERSION             **        
P0726A**  02/26/2014  AA97148     CREDIT ARRANGEMENTS - RELEASE 2     **        
P0726A**                          CHANGES.                            **        
P0726B**  07/08/2014  AA97148     CREDIT ARRANGEMENTS RELEASE 3 CHANGES*        
P0726B**                          ADDED CT METER LIMIT CHECK          **        
P0726C**  10/28/2014  AA97148     CREDIT ARRANGEMENTS RELEASE 4.1 CHANG*        
P0726C**                          ES. ADDED CMPL CHECK FOR IVR.       **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE ARNG_ATTR CURSOR WITH ROWSET POSITIONING FOR      
               SELECT UY.ARNG_PLAN_ID                                   
                     ,UY.ARNG_ATTR_CD                                   
                     ,UY.ARNG_CHANNEL_CD                                
                     ,UY.ARNG_ATTR_EFF_DT                               
                     ,UY.ARNG_ATTR_TYPE_CD                              
                     ,UY.ARNG_ATTR_VAL_NUM                              
                     ,UY.ARNG_ATTR_VAL_CHAR                             
                     ,UY.ARNG_ATTR_EXP_DT                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           UY.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,UY.LAST_UPDATE_USERID                             
                 FROM CSS_ARNG_ATTR UY WITH(READUNCOMMITTED)                    
                WHERE UY.ARNG_PLAN_ID  = :UY-ARNG-PLAN-ID               
                ORDER BY UY.ARNG_PLAN_ID ASC                            
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ARNG_ATTR CURSOR WITH ROWSET POSITIONING FOR              
MFA-TR*        SELECT UY.ARNG_PLAN_ID                                           
MFA-TR*              ,UY.ARNG_ATTR_CD                                           
MFA-TR*              ,UY.ARNG_CHANNEL_CD                                        
MFA-TR*              ,UY.ARNG_ATTR_EFF_DT                                       
MFA-TR*              ,UY.ARNG_ATTR_TYPE_CD                                      
MFA-TR*              ,UY.ARNG_ATTR_VAL_NUM                                      
MFA-TR*              ,UY.ARNG_ATTR_VAL_CHAR                                     
MFA-TR*              ,UY.ARNG_ATTR_EXP_DT                                       
MFA-TR*              ,UY.LAST_UPDATE_TS                                         
MFA-TR*              ,UY.LAST_UPDATE_USERID                                     
MFA-TR*          FROM CSS_ARNG_ATTR UY                                          
MFA-TR*         WHERE UY.ARNG_PLAN_ID  = :UY-ARNG-PLAN-ID                       
MFA-TR*         ORDER BY UY.ARNG_PLAN_ID ASC                                    
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE OPTN_ATTR CURSOR WITH ROWSET POSITIONING FOR      
               SELECT VH.ARNG_OPTION_ID                                 
                     ,VH.ARNG_ATTR_CD                                   
                     ,VH.ARNG_CHANNEL_CD                                
                     ,VH.OPTN_ATTR_EFF_DT                               
                     ,VH.ARNG_ATTR_TYPE_CD                              
                     ,VH.ARNG_ATTR_VAL_NUM                              
                     ,VH.ARNG_ATTR_VAL_CHAR                             
                     ,VH.OPTN_ATTR_EXP_DT                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           VH.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,VH.LAST_UPDATE_USERID                             
                 FROM CSS_ARNG_OPTN_ATTR VH WITH(READUNCOMMITTED)               
                WHERE VH.ARNG_OPTION_ID = :VH-ARNG-OPTION-ID            
                ORDER BY VH.ARNG_OPTION_ID ASC                          
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OPTN_ATTR CURSOR WITH ROWSET POSITIONING FOR              
MFA-TR*        SELECT VH.ARNG_OPTION_ID                                         
MFA-TR*              ,VH.ARNG_ATTR_CD                                           
MFA-TR*              ,VH.ARNG_CHANNEL_CD                                        
MFA-TR*              ,VH.OPTN_ATTR_EFF_DT                                       
MFA-TR*              ,VH.ARNG_ATTR_TYPE_CD                                      
MFA-TR*              ,VH.ARNG_ATTR_VAL_NUM                                      
MFA-TR*              ,VH.ARNG_ATTR_VAL_CHAR                                     
MFA-TR*              ,VH.OPTN_ATTR_EXP_DT                                       
MFA-TR*              ,VH.LAST_UPDATE_TS                                         
MFA-TR*              ,VH.LAST_UPDATE_USERID                                     
MFA-TR*          FROM CSS_ARNG_OPTN_ATTR VH                                     
MFA-TR*         WHERE VH.ARNG_OPTION_ID = :VH-ARNG-OPTION-ID                    
MFA-TR*         ORDER BY VH.ARNG_OPTION_ID ASC                                  
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7540                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *5000-PROCESS-ARNG-ATTRIBUTES                                   *         
      *****************************************************************         
       5000-PROCESS-ARNG-ATTRIBUTES.                                    
                                                                        
           MOVE 'N'                      TO WS-KR361-MAJOR-ATTR-FL      
                                            WS-KR361-NON-RES-ATTR-FL    
                                            WS-KR361-COMPLIANCE-ATTR-FL 
P0726B                                      WS-KR361-LIMIT-ATTR-FL      
P0726B                                      WS-KR361-CT-METER-ATTR-FL   
P0726B                                      WS-KR361-60-90-ATTR-FL      
P0726B                                      WS-KR361-SETUP-BELOW-LMT-FL 
P0726C                                      WS-KR361-CMPL-CHECK-IVR-FL. 
           MOVE SPACES                   TO WS-ARNG-PLAN-ID-FND         
                                            WS-ARNG-OPTN-ID-FND.        
           SET WS-ARNG-ATTR-INDX         TO 1.                          
           SET WS-OPTN-ATTR-INDX         TO 1.                          
           MOVE WS-KR361-ARNG-PLAN-ID    TO UY-ARNG-PLAN-ID.            
           MOVE WS-KR361-ARNG-OPTION-ID  TO VH-ARNG-OPTION-ID.          
                                                                        
           PERFORM 5010-CHECK-LOAD-ARNG-ATTR  THRU 5010-CPDKR361-EXIT.  
           PERFORM 5100-CHECK-LOAD-OPTN-ATTR  THRU 5100-CPDKR361-EXIT.  
                                                                        
       5000-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5010-CHECK-LOAD-ARNG-ATTR                               *               
      *****************************************************************         
                                                                        
       5010-CHECK-LOAD-ARNG-ATTR.                                       
                                                                        
           IF NOT ARNG-ATTR-LOADED                                      
              PERFORM 5020-LOAD-ARNG-ATTR     THRU 5020-CPDKR361-EXIT   
              SET ARNG-ATTR-LOADED     TO TRUE                          
           END-IF.                                                      
                                                                        
           PERFORM 5030-MATCH-ARNG-PLAN-ID    THRU 5030-CPDKR361-EXIT.  
                                                                        
           IF ARNG-PLAN-ID-FND                                          
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 5020-LOAD-ARNG-ATTR     THRU 5020-CPDKR361-EXIT   
              PERFORM 5030-MATCH-ARNG-PLAN-ID THRU 5030-CPDKR361-EXIT   
           END-IF.                                                      
                                                                        
       5010-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5020-LOAD-ARNG-ATTR                                            *        
      ******************************************************************        
                                                                        
       5020-LOAD-ARNG-ATTR.                                             
                                                                        
           PERFORM 7500-OPEN-ARNG-ATTR-CSR    THRU 7500-CPDKR361-EXIT.  
           PERFORM 7510-FETCH-ARNG-ATTR-CSR   THRU 7510-CPDKR361-EXIT.  
           PERFORM 5040-LOAD-ARNG-ATTR-VAL    THRU 5040-CPDKR361-EXIT   
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7520-CLOSE-ARNG-ATTR-CSR   THRU 7520-CPDKR361-EXIT.  
                                                                        
       5020-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5030-MATCH-ARNG-PLAN-ID                                        *        
      ******************************************************************        
                                                                        
       5030-MATCH-ARNG-PLAN-ID.                                         
                                                                        
           PERFORM VARYING WS-ARNG-ATTR-INDX FROM 1 BY 1                
             UNTIL WS-ARNG-ATTR-INDX > WS-ARNG-ATTR-CNT                 
                IF T1-KR361-PLAN-ID(WS-ARNG-ATTR-INDX) =                
                   WS-KR361-ARNG-PLAN-ID                                
                   MOVE T1-KR361-ATTR-CD(WS-ARNG-ATTR-INDX)      TO     
                        WS-KR361-ARNG-ATTR-CD                           
                   MOVE T1-KR361-ATTR-VAL-NUM(WS-ARNG-ATTR-INDX) TO     
                        WS-KR361-ARNG-ATTR-VAL-NUM                      
                   SET ARNG-PLAN-ID-FND   TO TRUE                       
                   PERFORM 5200-ATTRIBUTE-VALIDATION                    
                           THRU 5200-CPDKR361-EXIT                      
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
       5030-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5040-LOAD-ARNG-ATTR-VAL                                        *        
      ******************************************************************        
                                                                        
       5040-LOAD-ARNG-ATTR-VAL.                                         
                                                                        
           ADD +1                      TO WS-ARNG-ATTR-CNT              
           MOVE UY-ARNG-PLAN-ID        TO                               
                T1-KR361-PLAN-ID(WS-ARNG-ATTR-CNT)                      
           MOVE UY-ARNG-ATTR-CD        TO                               
                T1-KR361-ATTR-CD(WS-ARNG-ATTR-CNT)                      
           MOVE UY-ARNG-CHANNEL-CD     TO                               
                T1-KR361-CHANNEL-CD(WS-ARNG-ATTR-CNT)                   
           MOVE UY-ARNG-ATTR-EFF-DT    TO                               
                T1-KR361-ATTR-EFF-DT(WS-ARNG-ATTR-CNT)                  
           MOVE UY-ARNG-ATTR-TYPE-CD   TO                               
                T1-KR361-ATTR-TYPE-CD(WS-ARNG-ATTR-CNT)                 
           MOVE UY-ARNG-ATTR-VAL-NUM   TO                               
                T1-KR361-ATTR-VAL-NUM(WS-ARNG-ATTR-CNT)                 
           MOVE UY-ARNG-ATTR-VAL-CHAR  TO                               
                T1-KR361-ATTR-VAL-CHAR(WS-ARNG-ATTR-CNT)                
           MOVE UY-ARNG-ATTR-EXP-DT    TO                               
                T1-KR361-ATTR-EXP-DT(WS-ARNG-ATTR-CNT)                  
           MOVE UY-LAST-UPDATE-TS      TO                               
                T1-KR361-LST-UPD-TS(WS-ARNG-ATTR-CNT)                   
           MOVE UY-LAST-UPDATE-USERID  TO                               
                T1-KR361-LST-USERID(WS-ARNG-ATTR-CNT)                   
                                                                        
           PERFORM 7510-FETCH-ARNG-ATTR-CSR   THRU 7510-CPDKR361-EXIT.  
                                                                        
       5040-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5100-CHECK-LOAD-OPTN-ATTR                               *               
      *****************************************************************         
                                                                        
       5100-CHECK-LOAD-OPTN-ATTR.                                       
                                                                        
           IF NOT OPTN-ATTR-LOADED                                      
              PERFORM 5110-LOAD-OPTN-ATTR     THRU 5110-CPDKR361-EXIT   
              SET OPTN-ATTR-LOADED     TO TRUE                          
           END-IF                                                       
                                                                        
           PERFORM 5120-MATCH-ARNG-OPTN-ID    THRU 5120-CPDKR361-EXIT   
                                                                        
           IF ARNG-OPTN-ID-FND                                          
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 5110-LOAD-OPTN-ATTR     THRU 5110-CPDKR361-EXIT   
              PERFORM 5120-MATCH-ARNG-OPTN-ID THRU 5120-CPDKR361-EXIT   
           END-IF.                                                      
                                                                        
       5100-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5110-LOAD-OPTN-ATTR                                            *        
      ******************************************************************        
                                                                        
       5110-LOAD-OPTN-ATTR.                                             
                                                                        
           PERFORM 7530-OPEN-OPTN-ATTR-CSR    THRU 7530-CPDKR361-EXIT.  
           PERFORM 7540-FETCH-OPTN-ATTR-CSR   THRU 7540-CPDKR361-EXIT.  
           PERFORM 5130-LOAD-OPTN-ATTR-VAL    THRU 5130-CPDKR361-EXIT   
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7550-CLOSE-OPTN-ATTR-CSR   THRU 7550-CPDKR361-EXIT.  
                                                                        
       5110-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5120-MATCH-ARNG-OPTN-ID                                        *        
      ******************************************************************        
                                                                        
       5120-MATCH-ARNG-OPTN-ID.                                         
                                                                        
           PERFORM VARYING WS-OPTN-ATTR-INDX FROM 1 BY 1                
             UNTIL WS-OPTN-ATTR-INDX > WS-OPTN-ATTR-CNT                 
                IF T2-KR361-OPTION-ID(WS-OPTN-ATTR-INDX) =              
                   WS-KR361-ARNG-OPTION-ID                              
                   SET ARNG-OPTN-ID-FND   TO TRUE                       
                   MOVE T2-KR361-ATTR-CD(WS-OPTN-ATTR-INDX)      TO     
                        WS-KR361-ARNG-ATTR-CD                           
                   MOVE T2-KR361-ATTR-VAL-NUM(WS-OPTN-ATTR-INDX) TO     
                        WS-KR361-ARNG-ATTR-VAL-NUM                      
                   PERFORM 5200-ATTRIBUTE-VALIDATION                    
                           THRU 5200-CPDKR361-EXIT                      
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
       5120-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5130-LOAD-OPTN-ATTR-VAL                                        *        
      ******************************************************************        
                                                                        
       5130-LOAD-OPTN-ATTR-VAL.                                         
                                                                        
           ADD +1                      TO WS-OPTN-ATTR-CNT              
           MOVE VH-ARNG-OPTION-ID      TO                               
                T2-KR361-OPTION-ID(WS-OPTN-ATTR-CNT)                    
           MOVE VH-ARNG-ATTR-CD        TO                               
                T2-KR361-ATTR-CD(WS-OPTN-ATTR-CNT)                      
           MOVE VH-ARNG-CHANNEL-CD     TO                               
                T2-KR361-CHANNEL-CD(WS-OPTN-ATTR-CNT)                   
           MOVE VH-OPTN-ATTR-EFF-DT    TO                               
                T2-KR361-ATTR-EFF-DT(WS-OPTN-ATTR-CNT)                  
           MOVE VH-ARNG-ATTR-TYPE-CD   TO                               
                T2-KR361-ATTR-TYPE-CD(WS-OPTN-ATTR-CNT)                 
           MOVE VH-ARNG-ATTR-VAL-NUM   TO                               
                T2-KR361-ATTR-VAL-NUM(WS-OPTN-ATTR-CNT)                 
           MOVE VH-ARNG-ATTR-VAL-CHAR  TO                               
                T2-KR361-ATTR-VAL-CHAR(WS-OPTN-ATTR-CNT)                
           MOVE VH-OPTN-ATTR-EXP-DT    TO                               
                T2-KR361-ATTR-EXP-DT(WS-OPTN-ATTR-CNT)                  
           MOVE VH-LAST-UPDATE-TS      TO                               
                T2-KR361-LST-UPD-TS(WS-OPTN-ATTR-CNT)                   
           MOVE VH-LAST-UPDATE-USERID  TO                               
                T2-KR361-LST-USERID(WS-OPTN-ATTR-CNT)                   
                                                                        
           PERFORM 7540-FETCH-OPTN-ATTR-CSR   THRU 7540-CPDKR361-EXIT.  
                                                                        
       5130-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-ATTRIBUTE-VALIDATION                                      *        
      ******************************************************************        
                                                                        
       5200-ATTRIBUTE-VALIDATION.                                       
                                                                        
            EVALUATE TRUE                                               
                WHEN WS-KR361-ARNG-ATTR-CD = 'MAJOR'    AND             
                     WS-KR361-MAJOR-IND    = 'Y'                        
                     IF WS-KR361-ARNG-ATTR-VAL-NUM <                    
P0726A                  WS-KR361-TOTAL-AMOUNT                           
                        MOVE 'Y' TO WS-KR361-MAJOR-ATTR-FL              
                     ELSE                                               
                        MOVE 'N' TO WS-KR361-MAJOR-ATTR-FL              
                     END-IF                                             
                WHEN WS-KR361-ARNG-ATTR-CD    = 'NRES'  AND             
                     WS-KR361-ACCOUNT-TYPE-CD NOT= 'R'                  
                     IF WS-KR361-ARNG-ATTR-VAL-NUM <                    
P0726A                  WS-KR361-TOTAL-AMOUNT                           
                        MOVE 'Y' TO WS-KR361-NON-RES-ATTR-FL            
                     ELSE                                               
                        MOVE 'N' TO WS-KR361-NON-RES-ATTR-FL            
                     END-IF                                             
                WHEN WS-KR361-ARNG-ATTR-CD    = 'COMPL' AND             
                     WS-KR361-COMPLIANCE-IND  = 'Y'                     
P0726A               IF WS-KR361-TOTAL-AMOUNT >                         
                        WS-KR361-ARNG-ATTR-VAL-NUM                      
                        MOVE 'N' TO WS-KR361-COMPLIANCE-ATTR-FL         
                     ELSE                                               
                        MOVE 'Y' TO WS-KR361-COMPLIANCE-ATTR-FL         
                     END-IF                                             
P0726B          WHEN WS-KR361-ARNG-ATTR-CD    = 'CTMTR' AND             
P0726B               AT-CT-METER-RATED-IND    = 'Y'                     
P0726B               IF WS-KR361-TOTAL-AMOUNT >                         
P0726B                  WS-KR361-ARNG-ATTR-VAL-NUM                      
P0726B                  MOVE 'N' TO WS-KR361-CT-METER-ATTR-FL           
P0726B               ELSE                                               
P0726B                  MOVE 'Y' TO WS-KR361-CT-METER-ATTR-FL           
P0726B               END-IF                                             
P0726B          WHEN WS-KR361-ARNG-ATTR-CD    = 'LIMIT'                 
P0726B               IF WS-KR361-TOTAL-AMOUNT >                         
P0726B                  WS-KR361-ARNG-ATTR-VAL-NUM                      
P0726B                  MOVE 'N' TO WS-KR361-LIMIT-ATTR-FL              
P0726B               ELSE                                               
P0726B                  MOVE 'Y' TO WS-KR361-LIMIT-ATTR-FL              
P0726B               END-IF                                             
P0726B          WHEN WS-KR361-ARNG-ATTR-CD    = '60+90'                 
P0726B               IF WS-KR361-60-90-AMOUNT >                         
P0726B                  WS-KR361-ARNG-ATTR-VAL-NUM                      
P0726B                  MOVE 'N' TO WS-KR361-60-90-ATTR-FL              
P0726B               ELSE                                               
P0726B                  MOVE 'Y' TO WS-KR361-60-90-ATTR-FL              
P0726B               END-IF                                             
P0726B          WHEN WS-KR361-ARNG-ATTR-CD = 'SETUP'                    
P0726B               IF WS-KR361-TOTAL-AMOUNT >                         
P0726B                  WS-KR361-ARNG-ATTR-VAL-NUM                      
P0726B                  MOVE 'N' TO WS-KR361-SETUP-BELOW-LMT-FL         
P0726B               ELSE                                               
P0726B                  MOVE 'Y' TO WS-KR361-SETUP-BELOW-LMT-FL         
P0726B               END-IF                                             
P0726C          WHEN WS-KR361-ARNG-ATTR-CD = 'IVRCK'                    
P0726C               IF WS-KR361-ARNG-ATTR-VAL-NUM = 1                  
P0726C                  MOVE 'Y' TO WS-KR361-CMPL-CHECK-IVR-FL          
P0726C               ELSE                                               
P0726C                  MOVE 'N' TO WS-KR361-CMPL-CHECK-IVR-FL          
P0726C               END-IF                                             
            END-EVALUATE.                                               
                                                                        
       5200-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-OPEN-ARNG-ATTR                                            *        
      ******************************************************************        
                                                                        
       7500-OPEN-ARNG-ATTR-CSR.                                         
                                                                        
           EXEC SQL                                                     
              OPEN ARNG_ATTR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7500'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_ARNG_ATTR'      TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7500-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-ARNG-ATTR-CSR                                       *        
      ******************************************************************        
                                                                        
       7510-FETCH-ARNG-ATTR-CSR.                                        
                                                                        
           EXEC SQL                                                     
              FETCH ARNG_ATTR                                           
               INTO :UY-ARNG-PLAN-ID                                    
                   ,:UY-ARNG-ATTR-CD                                    
                   ,:UY-ARNG-CHANNEL-CD                                 
                   ,:UY-ARNG-ATTR-EFF-DT                                
                   ,:UY-ARNG-ATTR-TYPE-CD                               
                   ,:UY-ARNG-ATTR-VAL-NUM :WS-KR361-ATTR-VAL-NUM-NULL   
                   ,:UY-ARNG-ATTR-VAL-CHAR                              
                   ,:UY-ARNG-ATTR-EXP-DT                                
                   ,:UY-LAST-UPDATE-TS                                  
                   ,:UY-LAST-UPDATE-USERID                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-KR361-ATTR-VAL-NUM-NULL < 0                            
              MOVE ZEROES               TO WS-KR361-ATTR-VAL-NUM-NULL   
                                           UY-ARNG-ATTR-VAL-NUM         
           END-IF.                                                      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE '7510'               TO ACTIVE-PARAGRAPH             
              MOVE 'ARNG PLAN ID'       TO TABLE-ELEMENT-1              
              MOVE UY-ARNG-PLAN-ID      TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7510-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-ARNG-ATTR-CSR                                       *        
      ******************************************************************        
                                                                        
       7520-CLOSE-ARNG-ATTR-CSR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE ARNG_ATTR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7520'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_ARNG_ATTR'      TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7520-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7530-OPEN-OPTN-ATTR-CSR                                        *        
      ******************************************************************        
                                                                        
       7530-OPEN-OPTN-ATTR-CSR.                                         
                                                                        
           EXEC SQL                                                     
              OPEN OPTN_ATTR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7530'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_ARNG_OPTN_ATTR' TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7530-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7540-FETCH-OPTN-ATTR-CSR                                       *        
      ******************************************************************        
                                                                        
       7540-FETCH-OPTN-ATTR-CSR.                                        
                                                                        
           EXEC SQL                                                     
              FETCH OPTN_ATTR                                           
               INTO :VH-ARNG-OPTION-ID                                  
                   ,:VH-ARNG-ATTR-CD                                    
                   ,:VH-ARNG-CHANNEL-CD                                 
                   ,:VH-OPTN-ATTR-EFF-DT                                
                   ,:VH-ARNG-ATTR-TYPE-CD                               
                   ,:VH-ARNG-ATTR-VAL-NUM :WS-KR361-ATTR-VAL-NUM-NULL   
                   ,:VH-ARNG-ATTR-VAL-CHAR                              
                   ,:VH-OPTN-ATTR-EXP-DT                                
                   ,:VH-LAST-UPDATE-TS                                  
                   ,:VH-LAST-UPDATE-USERID                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-KR361-ATTR-VAL-NUM-NULL < 0                            
              MOVE ZEROES               TO WS-KR361-ATTR-VAL-NUM-NULL   
                                           UY-ARNG-ATTR-VAL-NUM         
           END-IF.                                                      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE '7540'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_ARNG_OPTN_ATTR' TO TABLE-1                      
              MOVE 'ARNG OPTION ID'     TO TABLE-ELEMENT-1              
              MOVE VH-ARNG-OPTION-ID    TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7540-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7550-CLOSE-OPTN-ATTR-CSR                                       *        
      ******************************************************************        
                                                                        
       7550-CLOSE-OPTN-ATTR-CSR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE OPTN_ATTR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7550'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_ARNG_OPTN_ATTR' TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7550-CPDKR361-EXIT.                                              
           EXIT.                                                        
                                                                        
