      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      ** CPDKR136:                                                    **        
P00948** THIS COPY BOOK INSERTS ROWS FOR STA, STAA, STF & STFA SET UP **00020000
      ** CSR00125 - THIS PROCEDURE CANCELS ALL PENDING DNP ORDERS.    **        
      ** CSR02122 - THIS PROCEDURE UPDATES VALUES IN CSS_ACCOUNT AND  **        
      **            CSS_CREDIT PROFILE TABLE.                         **        
      ******************************************************************        
      ** PREREQUISITES: CWSKR136 WORKING STORAGE VARIABLES SHOULD BE  **        
      **                POPULATED PRIOR TO INVOKING THIS ROUTINE.     **        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00726*  06/25/14  AA97148    PROCEDURE ORIGINALLY CODED.              *        
P0726A*  01/21/15  AA97148    CREDIT ARRANGEMENTS RELEASE 5 CHANGES -  *        
P0726A*                       ADDED FINAL NOTICE DATE VALIDATION.      *        
P00948** 06/16/16  AA97148    LEAST AMOUNT DUE PROJECT CHANGES:        *        
P00948**                      ADDED NEW PAYMENT ARRANGEMENT PLANS SHORT*        
P00948**                      TERM FLEX(STF) & SHORT TERM FLEX AFTER   *        
P00948**                      (STFA).                                  *        
P00948** 07/20/16  VENKAT.P   - ADD WQ CREATED BY                      *        
P00948**                      - REPLACE 0028 WITH 4675                 *        
      ******************************************************************00320013
      ****************************************************************          
      *  CSS_CRED_COLL CURSOR                                        *          
      ****************************************************************          
                                                                        
           EXEC SQL                                                     
             DECLARE CRED-COLL-CUR CURSOR FOR                           
              SELECT CL.ACCOUNT_NO,                                     
                     CL.CODE_NOTICE_TYPE                                
                FROM CSS_CRED_COLL CL WITH(READUNCOMMITTED)                     
               WHERE CL.ACCOUNT_NO         = :CL-ACCOUNT-NO             
                 AND CL.DATE_CREDIT_ACTION > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )           
                 AND CL.DATE_CREDIT_ACTION < IIF(TRY_CONVERT(DATE, 
                                                 :WS-KR136-NEW-DNP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-KR136-NEW-DNP-DATE
              ) <> 0) OR (LEN(:WS-KR136-NEW-DNP-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-KR136-NEW-DNP-DATE
              ), CONVERT(DATE, :WS-KR136-NEW-DNP-DATE) )     
                 AND CL.CODE_NOTICE_TYPE   IN ('D', 'G', 'H', 'I')      
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05530000
MFA-TR*      DECLARE CRED-COLL-CUR CURSOR FOR                           05540000
MFA-TR*       SELECT CL.ACCOUNT_NO,                                     05550000
MFA-TR*              CL.CODE_NOTICE_TYPE                                        
MFA-TR*         FROM CSS_CRED_COLL CL                                   05650000
MFA-TR*        WHERE CL.ACCOUNT_NO         = :CL-ACCOUNT-NO             05660000
MFA-TR*          AND CL.DATE_CREDIT_ACTION > :WS-CURRENT-DATE           05670000
MFA-TR*          AND CL.DATE_CREDIT_ACTION < :WS-KR136-NEW-DNP-DATE     05670000
MFA-TR*          AND CL.CODE_NOTICE_TYPE   IN ('D', 'G', 'H', 'I')      05680000
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*      QUERYNO 7025                                                       
MFA-TR*    END-EXEC.                                                    05700000
                                                                        
      *****************************************************************         
      * 5000-STA-SETUP                                                *         
      *****************************************************************         
                                                                        
       5000-STA-SETUP.                                                  
                                                                        
           INITIALIZE DCLCSS-CRED-ARNG-ACTN.                            
                                                                        
           MOVE  AT-ACCOUNT-NO            TO WS-KR136-ACCOUNT-NO.       
           MOVE  AT-COMPANY-NO            TO C8-COMPANY-NO.             
           MOVE 'DATABASE'                TO C8-DELINQ-CD.              
           PERFORM 7060-SELECT-DELINQ-VALUE       THRU 7060-CPD136-EXIT.
           MOVE  C8-DELINQ-VALUE          TO WS-DATABASE.               
                                                                        
P00948* Arrears amount will be used for STA & STFA whereas Total Utility        
P00948* Balance amount used for STAA & STFA                                     
P00948     IF WS-CAR-ARNG-TYPE = 'STA' OR 'STF'                         
              MOVE WS-CAR-UTL-ARREARS-AMT      TO WS-KR136-UTIL-AMOUNT  
              MOVE WS-CAR-NONUTL-ARREARS-AMT   TO WS-KR136-NONUTL-AMOUNT
           ELSE                                                         
P00948        IF WS-CAR-ARNG-TYPE ='STAA' OR 'STFA'                     
              MOVE WS-CAR-TOTAL-UTL-BALANCE    TO WS-KR136-UTIL-AMOUNT  
              MOVE WS-CAR-TOTAL-NONUTL-BALANCE TO WS-KR136-NONUTL-AMOUNT
           END-IF
           END-IF.                                                      
                                                                        
      * Get delinquency value for IVR date calcualtion                          
           IF CSR-DATABASE                                              
              MOVE WS-DAY-BSEC-IVREXC-CD  TO C8-DELINQ-CD               
              PERFORM 7060-SELECT-DELINQ-VALUE    THRU 7060-CPD136-EXIT 
              MOVE  C8-DELINQ-VALUE       TO WS-DAY-BSEC-IVREXC-VAL     
              MOVE WS-DAY-DUE-CD          TO C8-DELINQ-CD               
              PERFORM 7060-SELECT-DELINQ-VALUE    THRU 7060-CPD136-EXIT 
              MOVE  C8-DELINQ-VALUE       TO WS-DAY-DUE-VAL             
                                                                        
              MOVE WS-KR136-NEW-DNP-DATE  TO WS-NEW-BUSINESS-DAY        
              MOVE WS-DAY-BSEC-IVREXC-VAL TO WS-NO-OF-DAY               
              PERFORM 6525-PREV-BUSINESS-DAY                            
                                      THRU 6525-PREV-BUSINESS-DAY-EXIT  
              MOVE WS-NEW-BUSINESS-DAY    TO WS-DATE-SCND-NOT-CREDACT   
           END-IF.                                                      
                                                                        
           PERFORM 5100-SETUP-PROCESS             THRU 5100-CPD136-EXIT.
                                                                        
       5000-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-SETUP=PROCESS                                             *        
      ******************************************************************        
                                                                        
       5100-SETUP-PROCESS.                                              
                                                                        
           IF AT-CODES-DATA-PRESENT(22:1) = 'A'                         
              MOVE  200                   TO WS-KR136-RETURN-CODE       
              GO TO 5100-CPD136-EXIT                                    
           END-IF.                                                      
                                                                        
      * Get deliquency value for WQ generation                                  
           MOVE WS-CURRENT-DATE           TO WS-NEW-BUSINESS-DAY.       
           MOVE 1                         TO WS-NO-OF-DAY.              
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
              THRU 6500-NEXT-BUSINESS-DAY-EXIT                          
           MOVE WS-NEW-BUSINESS-DAY       TO WS-WQ-NEXT-BUS-DAY-DT.     
                                                                        
           MOVE WS-KR136-ACCOUNT-NO       TO CL-ACCOUNT-NO              
           PERFORM 7900-SELECT-CRED-COLL          THRU 7900-CPD136-EXIT.
                                                                        
           MOVE WS-KR136-ORIGINAL-DNP-TYPE TO CL-CODE-NOTICE-TYPE       
           EVALUATE TRUE                                                
             WHEN CL-CODE-NOTICE-TYPE = 'D'                             
                  PERFORM 8220-DEL-FUTURE-C-ROW   THRU 8220-CPD136-EXIT 
                  IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL        
                     AND CSR-DATABASE                                   
                     IF WS-KR136-UTIL-AMOUNT > ZEROS                    
                        PERFORM 7845C-SELECT-CRED-COLL                  
                                                  THRU 7845C-CPD136-EXIT
                     ELSE                                               
                        PERFORM 7845S-SELECT-CRED-COLL                  
                                                  THRU 7845S-CPD136-EXIT
                     END-IF                                             
                     IF CL-DATE-CREDIT-ACTION > WS-CURRENT-DATE         
                        MOVE -1           TO WS-DATE-CR-ACTION-NULL     
                        PERFORM 8120-UPD-FUTURE-C-ROW                   
                                                  THRU 8120-CPD136-EXIT 
                     END-IF                                             
                  END-IF                                                
      *                                                                         
                  PERFORM 8230-DEL-FUTURE-D-ROW   THRU 8230-CPD136-EXIT 
                  IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
                     PERFORM 8200-DEL-SO-DATA-MF-DNP                    
                                                  THRU 8200-CPD136-EXIT 
                  END-IF                                                
             WHEN CL-CODE-NOTICE-TYPE = 'G'                             
                  IF CSR-DATABASE                                       
                     PERFORM 8250-DEL-E-F-ROW     THRU 8250-CPD136-EXIT 
                     PERFORM 8270-DEL-G-ROW       THRU 8270-CPD136-EXIT 
                  ELSE                                                  
                     PERFORM 8240-DEL-FUTURE-E-F-ROW                    
                                                  THRU 8240-CPD136-EXIT 
                     PERFORM 8260-DEL-FUTURE-G-ROW                      
                                                  THRU 8260-CPD136-EXIT 
                  END-IF                                                
                                                                        
                  IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
                     PERFORM 8200-DEL-SO-DATA-MF-DNP                    
                                                  THRU 8200-CPD136-EXIT 
                  END-IF                                                
             WHEN CL-CODE-NOTICE-TYPE = ('H' OR 'I')                    
                  PERFORM 8280-DEL-FUTURE-ROW     THRU 8280-CPD136-EXIT 
                  IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
                     PERFORM 8200-DEL-SO-DATA-MF-DNP                    
                                                  THRU 8200-CPD136-EXIT 
                  END-IF                                                
           END-EVALUATE                                                 
      * MOVE THE FIELDS TO INSERT IN CRED_COLL FOR CSR                          
      * FOR FINAL BILL ACCOUNTS NEED TO STOP FORECASTING CREDIT ACTION          
           IF CSR-DATABASE AND AT-CODE-ACCT-STAT NOT = 'B'              
              PERFORM 8350-DELETE-CREDCOLL        THRU 8350-CPD136-EXIT 
              PERFORM 5500-MOVE-CRED-COLL-ACTN    THRU 5500-CPD136-EXIT 
           END-IF                                                       
                                                                        
           PERFORM 7025-OPEN-CRED-COLL-CUR        THRU 7025-CPD136-EXIT 
           PERFORM 7035-FETCH-CRED-COLL-CUR       THRU 7035-CPD136-EXIT 
           PERFORM 5700-ADDL-DELETES              THRU 5700-CPD136-EXIT 
              UNTIL END-CURSOR                                          
           PERFORM 7045-CLOSE-CRED-COLL-CUR       THRU 7045-CPD136-EXIT.
                                                                        
      * CHECKS THE CSS_DELQ TABLE FOR START AND END WQ TIMES                    
           MOVE 'WQ-STA-START-TIME'       TO  C8-DELINQ-CD.             
           MOVE AT-COMPANY-NO             TO  C8-COMPANY-NO.            
           PERFORM 7060-SELECT-DELINQ-VALUE       THRU 7060-CPD136-EXIT.
           MOVE C8-DELINQ-VALUE           TO  WS-WQ-STA-START-TIME.     
           MOVE WS-WQ-STA-START-TIME      TO  WS-WQ-STA-START-TIME-N.   
           MOVE WS-WQ-STA-START-TIME-N    TO  WS-WQ-STA-START-TIME-A.   
           MOVE WS-CURRENT-TIMESTAMP      TO  WS-WQ-TIMESTAMP.          
           MOVE WS-WQ-TIMESTAMP           TO  WS-WQ-TS-FULL.            
           MOVE WS-WQ-TS-HOUR             TO  WS-WQ-TIME-HOUR.          
           MOVE WS-WQ-TS-MIN              TO  WS-WQ-TIME-MIN.           
           IF WS-WQ-TIME >= WS-WQ-STA-START-TIME-A AND                  
              WS-WQ-DNP-NXT-DAY-FL = WS-YES                             
P00948         PERFORM 5200-CALL-CSR04675         THRU 5200-CPD136-EXIT 
           END-IF.                                                      
                                                                        
       5100-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5110-PROCESS-CRED-ACTN                                         *        
      ******************************************************************        
                                                                        
       5110-PROCESS-CRED-ACTN.                                          
                                                                        
           PERFORM 7020-GET-CRED-ACTN-SEQ         THRU 7020-CPD136-EXIT.
           MOVE WS-CRED-ARNG-ACTN-SEQ  TO 4W-CRED-ARNG-ACTN-SEQ.        
                                                                        
           PERFORM 8130-INSERT-CRED-ARNG-ACTN     THRU 8130-CPD136-EXIT.
                                                                        
                                                                        
       5110-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-CALL-CSR04675.                                            *        
      ******************************************************************        
                                                                        
       5200-CALL-CSR04675.                                              
                                                                        
           MOVE 0                      TO IN-ITEM-ID-4675.              
           MOVE '5'                    TO ROUTING-CATEGORY-4675.        
           MOVE AT-LOCAL-OFFICE        TO LOCAL-OFFICE-4675.            
           MOVE WS-USER-ID             TO USER-ID-ORIG-4675.            
           MOVE SPACES                 TO USER-ID-ASGN-4675             
           MOVE LOW-VALUES             TO FREE-FORM-DATA-4675-TEXT.     
           MOVE SPACES                 TO DATE-REQUIRED-4675            
                                          DATE-CREATED-4675.            
           IF AT-COMPANY-NO = '01'                                      
               MOVE '595'              TO RESP-AREA-ID-4675             
           ELSE                                                         
               IF AT-COMPANY-NO = '26'                                  
                   MOVE 'P10'          TO RESP-AREA-ID-4675             
               END-IF                                                   
           END-IF                                                       
           MOVE WS-NORMAL              TO WQ-PRIORITY-4675              
           MOVE 0                      TO FREE-FORM-DATA-4675-LEN.      
           MOVE 288                    TO CATEGORY-ID-4675.             
           MOVE AT-ACCOUNT-NO          TO ACCOUNT-NO-4675.              
           MOVE ZEROES                 TO PREMISE-NO-4675               
                                          CUSTOMER-NO-4675              
                                          SERV-ORDER-NO-4675.           
           MOVE WS-WQ-STA-COMMENT      TO COMMENTS-4675-TEXT.           
           MOVE 40                     TO COMMENTS-4675-LEN.            
P00948     MOVE 'CPDKR136'             TO WQ-CREATED-BY-4675.           
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04675                                             
      *           (:IN-ITEM-ID-4675,                                    
      *            :ROUTING-CATEGORY-4675,                              
      *            :LOCAL-OFFICE-4675,                                  
      *            :USER-ID-ORIG-4675,                                  
      *            :USER-ID-ASGN-4675,                                  
      *            :RESP-AREA-ID-4675,                                  
      *            :CATEGORY-ID-4675,                                   
      *            :ACCOUNT-NO-4675,                                    
      *            :PREMISE-NO-4675,                                    
      *            :CUSTOMER-NO-4675,                                   
      *            :SERV-ORDER-NO-4675,                                 
      *            :COMMENTS-4675,                                      
      *            :DATE-REQUIRED-4675,                                 
      *            :DATE-CREATED-4675,                                  
      *            :WQ-PRIORITY-4675,                                   
      *            :FREE-FORM-DATA-4675,                                
P00948*            :WQ-CREATED-BY-4675)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0028
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0028
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0028 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '5900'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0028)                                                
      *       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0028 CURSOR FOR RESULT SET        
      *       :LOC0028                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0028 INTO                            
                 :RETURN-CODE-4675,                                     
                 :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4675 NOT = 0                          
                       MOVE RETURN-CODE-4675  TO WS-KR136-RETURN-CODE   
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5200'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE SQLCODE           TO ABEND-SQLCODE          
                       MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
                       MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
                       MOVE ACCOUNT-NO-4675   TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT         
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5200'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
                   MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       5200-CPD136-EXIT.                                                
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5400-CANCEL-DNP.                                               *        
      ******************************************************************        
      *                                                                         
        5400-CANCEL-DNP.                                                
      *                                                                         
           PERFORM 5410-CALL-CSR00125      THRU 5410-CPD136-EXIT.       
      *                                                                         
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC2)                                                  
      *        WITH PROCEDURE CSR00125                                  
      *    END-EXEC                                                     
      *                                                                         
      *    EXEC SQL                                                     
      *        ALLOCATE CANCEL_DNP CURSOR FOR RESULT SET                
      *        :LOC2                                                    
      *    END-EXEC                                                     
      *                                                                         
           PERFORM 5420-FETCH-CSR00125     THRU 5420-CPD136-EXIT.       
           EVALUATE WS-SO-RETURN-CD-BD                                  
              WHEN 0                                                    
                   IF CSR-DATABASE                                      
                      PERFORM 5440-UPD-ACCT-CRED-PROF-TB                
                                              THRU 5440-CPD136-EXIT     
                      MOVE 0                  TO S-RETURN-CODE          
      * DNP CANCELLED SUCCESSFULLY                                              
      *               MOVE 'BP0005'           TO S-APPL-RETURN-CODE             
      *               MOVE SPACES             TO S-APPL-PARMS                   
      *               PERFORM 8100-INSERT-GTT THRU 8100-EXIT                    
                   END-IF                                               
              WHEN 5000                                                 
                   IF CSR-DATABASE                                      
                      MOVE 0                  TO S-RETURN-CODE          
      * DNP IS IN ROUTE                                                         
      *               MOVE 'BP0006'           TO S-APPL-RETURN-CODE             
      *               MOVE SPACES             TO S-APPL-PARMS                   
      *               PERFORM 8100-INSERT-GTT THRU 8100-EXIT                    
                   END-IF                                               
              WHEN 100                                                  
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE WS-SO-RETURN-CD-BD    TO S-RETURN-CODE          
      *            MOVE SPACES                TO S-APPL-RETURN-CODE             
      *            MOVE SPACES                TO S-APPL-PARMS                   
                   MOVE 12                    TO WS-KR136-RETURN-CODE   
                   PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT         
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 5430-CLOSE-CSR00125     THRU 5430-CPD136-EXIT.       
      *                                                                         
       5400-CPD136-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5410-CALL-CSR00125.                                            *        
      ******************************************************************        
       5410-CALL-CSR00125.                                              
                                                                        
           INITIALIZE WS-CSR00125-RET-AREA.                             
                                                                        
           MOVE 'BPA;CREATED STA'         TO WS-KR136-REMARKS-TX-TEXT.  
           MOVE 17                        TO WS-KR136-REMARKS-TX-LEN.   
                                                                        
      *    EXEC SQL CALL CSR00125                                       
      *                ( :WS-KR136-ACCOUNT-NO                           
      *                 ,''                                             
      *                 ,:WS-KR136-USER-ID                              
      *                 ,:WS-KR136-REMARKS-TX                           
      *                 ,'Y'                                            
      *                 ,'U'                                            
      *                 ,'300'                                          
      *                 ,''                                             
      *                 ,'S'                                            
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CANCEL_DNP
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CANCEL_DNP
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CANCEL_DNP INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
               MOVE -1                         TO S-RETURN-CODE         
               MOVE '5410'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'DB2SP CALL'               TO ABEND-FUNCTION        
               MOVE SQLCODE                    TO ABEND-SQLCODE         
               MOVE 'CSR00125'                 TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE WS-KR136-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1     
               MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2       
               MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       5410-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5420-FETCH-CSR00125.                                           *        
      ******************************************************************        
       5420-FETCH-CSR00125.                                             
                                                                        
           EXEC SQL                                                     
           FETCH CANCEL_DNP INTO                                        
                    :WS-SO-RETURN-CD-BD                                 
                   ,:WS-SERV-ORDER-CHAR-BD                              
                   ,:WS-ORDER-REASON-BD                                 
                   ,:WS-RESP-AREA-ID-BD                                 
                   ,:WS-PENDING-DNP-FLAG-BD                             
                   ,:WS-INSERT-WORK-QUEUE-BD                            
                   ,:WS-AMOUNT-DISC-BAL                                 
                   ,:WS-ORDER-TYPE-CD-BD                                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '5420'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'CSR00125'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-KR136-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       5420-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5430-CLOSE-CSR00125.                                           *        
      ******************************************************************        
       5430-CLOSE-CSR00125.                                             
                                                                        
           EXEC SQL                                                     
             CLOSE CANCEL_DNP                                           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '5430'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE 'CSR00125'              TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE WS-KR136-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1         
              MOVE 'SQLCODE '              TO TABLE-ELEMENT-1           
              MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       5430-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5440-UPD-ACCT-CRED-PROF-TB.                                             
      ******************************************************************        
      *                                                                         
        5440-UPD-ACCT-CRED-PROF-TB.                                     
      *                                                                         
           IF WS-ORDER-TYPE-CD-BD = 'DNPFB'                             
               MOVE 'N'                    TO WS-KR136-UPDATE-PROFILE   
           ELSE                                                         
               MOVE 'Y'                    TO WS-KR136-UPDATE-PROFILE   
           END-IF.                                                      
           PERFORM 5450-CALL-CSR02122      THRU 5450-CPD136-EXIT.       
      *                                                                         
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC2)                                                  
      *        WITH PROCEDURE CSR02122                                  
      *    END-EXEC                                                     
      *                                                                         
      *    EXEC SQL                                                     
      *        ALLOCATE UPDATE_ACCT_TB CURSOR FOR RESULT SET            
      *        :LOC2                                                    
      *    END-EXEC                                                     
      *                                                                         
           PERFORM 5460-FETCH-CSR02122     THRU 5460-CPD136-EXIT.       
           EVALUATE WS-2122-RETURN-CODE                                 
              WHEN 0                                                    
              WHEN 1000                                                 
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE WS-2122-RETURN-CODE TO S-RETURN-CODE            
      *            MOVE SPACES              TO S-APPL-STATUS-CODE               
      *            MOVE SPACES              TO S-APPL-PARMS                     
                   MOVE 12                    TO WS-KR136-RETURN-CODE   
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 5470-CLOSE-CSR02122     THRU 5470-CPD136-EXIT.       
      *                                                                         
       5440-CPD136-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5450-CALL-CSR02122.                                            *        
      ******************************************************************        
                                                                        
       5450-CALL-CSR02122.                                              
                                                                        
           INITIALIZE WS-CSR02122-RET-AREA.                             
                                                                        
      *    EXEC SQL CALL CSR02122                                       
      *                ( :WS-KR136-ACCOUNT-NO                           
      *                 ,''                                             
      *                 ,:WS-ORDER-REASON-BD                            
      *                 ,'S'                                            
      *                 ,:WS-PENDING-DNP-FLAG-BD                        
      *                 ,:WS-KR136-UPDATE-PROFILE                       
      *                 ,:WS-AMOUNT-DISC-BAL                            
      *                 ,'300'                                          
      *                 ,:WS-ORDER-TYPE-CD-BD                           
      *                 ,:WS-KR136-REMARKS-TX                           
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE UPDATE_ACCT_TB
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN UPDATE_ACCT_TB
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR UPDATE_ACCT_TB INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
               MOVE -1                         TO S-RETURN-CODE         
               MOVE '5450'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'DB2SP CALL'               TO ABEND-FUNCTION        
               MOVE SQLCODE                    TO ABEND-SQLCODE         
               MOVE 'CSR02122'                 TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE WS-KR136-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1     
               MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2       
               MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       5450-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5460-FETCH-CSR02122.                                           *        
      ******************************************************************        
                                                                        
       5460-FETCH-CSR02122.                                             
                                                                        
           EXEC SQL                                                     
           FETCH UPDATE_ACCT_TB INTO                                    
                    :WS-2122-RETURN-CODE                                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '5460'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'CSR02122'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-KR136-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       5460-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5470-CLOSE-CSR02122.                                           *        
      ******************************************************************        
                                                                        
       5470-CLOSE-CSR02122.                                             
                                                                        
           EXEC SQL                                                     
             CLOSE UPDATE_ACCT_TB                                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '5470'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE 'CSR02122'              TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE WS-KR136-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1         
              MOVE 'SQLCODE '              TO TABLE-ELEMENT-1           
              MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       5470-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5500-MOVE-CRED-COLL-ACTN                                    *           
      ***************************************************************           
                                                                        
       5500-MOVE-CRED-COLL-ACTN.                                        
                                                                        
P0726A     IF WS-KR136-FINAL-NOT-MAIL-DT > SPACES                       
              MOVE 1                           TO WS-NO-OF-DAY          
              MOVE WS-KR136-FINAL-NOT-MAIL-DT  TO WS-NEW-BUSINESS-DAY   
              PERFORM 6525-PREV-BUSINESS-DAY                            
                                        THRU 6525-PREV-BUSINESS-DAY-EXIT
              MOVE WS-NEW-BUSINESS-DAY  TO WS-KR136-FIRST-NOT-DUE-DT    
              MOVE WS-KR136-ACCOUNT-NO         TO CL-ACCOUNT-NO         
                                                  4W-ACCOUNT-NO         
P0726A     END-IF.                                                      
P00948* Build cred actn rows for STAA & STFA                                    
      * Build E - ROw (1ST Notice)                                              
P00948     IF WS-CAR-ARNG-TYPE = 'STAA' OR 'STFA'                       
              IF WS-KR136-UTIL-AMOUNT > 0                               
                 MOVE 'UFN'                    TO 4W-CRED-ACTN-TYPE-CD  
                 IF WS-KR136-FIRST-NOT-MAIL-DT > SPACES                 
                    MOVE WS-KR136-FIRST-NOT-MAIL-DT                     
                                               TO 4W-CRED-ACTN-FCST-DT  
                 END-IF                                                 
                                                                        
                 IF WS-KR136-FIRST-NOT-DUE-DT     > SPACES              
                    MOVE ZEROS                 TO WS-NULL-IND1          
                    MOVE WS-KR136-FIRST-NOT-DUE-DT                      
                                               TO 4W-CRED-ACTN-DUE-DT   
                 ELSE                                                   
                    MOVE -1                    TO WS-NULL-IND1          
                 END-IF                                                 
                                                                        
                 MOVE WS-CAR-ARNG-ID           TO 4W-ARNG-ID            
                 MOVE WS-ARNG-SEQ-NO           TO 4W-CRED-ARNG-SEQ      
                 MOVE WS-KR136-UTIL-AMOUNT     TO 4W-CRED-ACTN-AM       
                 MOVE 1                        TO 4W-CRED-ACTN-SEQ      
                 PERFORM 5110-PROCESS-CRED-ACTN   THRU 5110-CPD136-EXIT 
              END-IF                                                    
      * Build T - ROw (Non Utl 1ST Notice)                                      
              IF WS-KR136-NONUTL-AMOUNT > ZEROS                         
                 MOVE 'NFN'                    TO 4W-CRED-ACTN-TYPE-CD  
                 IF WS-KR136-FIRST-NOT-MAIL-DT > SPACES                 
                    MOVE WS-KR136-FIRST-NOT-MAIL-DT                     
                                               TO 4W-CRED-ACTN-FCST-DT  
                 END-IF                                                 
                 IF WS-KR136-FIRST-NOT-DUE-DT  > SPACES                 
                    MOVE ZEROS                 TO WS-NULL-IND1          
                    MOVE WS-KR136-FIRST-NOT-DUE-DT                      
                                               TO 4W-CRED-ACTN-DUE-DT   
                 ELSE                                                   
                    MOVE -1                    TO WS-NULL-IND1          
                 END-IF                                                 
                 MOVE WS-CAR-ARNG-ID           TO 4W-ARNG-ID            
                 MOVE WS-ARNG-SEQ-NO           TO 4W-CRED-ARNG-SEQ      
                 MOVE WS-KR136-NONUTL-AMOUNT   TO 4W-CRED-ACTN-AM       
                 MOVE 1                        TO 4W-CRED-ACTN-SEQ      
                 PERFORM 5110-PROCESS-CRED-ACTN   THRU 5110-CPD136-EXIT 
              END-IF                                                    
      * Build IVR - ROw (utility)                                               
              IF WS-DATE-SCND-NOT-CREDACT > SPACES AND                  
                 AT-ACCOUNT-TYPE-CODE = 'R'                             
                 IF WS-KR136-UTIL-AMOUNT > ZEROS                        
                    MOVE 'IVR'                 TO 4W-CRED-ACTN-TYPE-CD  
                    MOVE WS-DATE-SCND-NOT-CREDACT                       
                                               TO 4W-CRED-ACTN-FCST-DT  
                    MOVE -1                    TO WS-NULL-IND1          
                    MOVE WS-CAR-ARNG-ID        TO 4W-ARNG-ID            
                    MOVE WS-ARNG-SEQ-NO        TO 4W-CRED-ARNG-SEQ      
                    MOVE WS-KR136-UTIL-AMOUNT  TO 4W-CRED-ACTN-AM       
                    MOVE 1                     TO 4W-CRED-ACTN-SEQ      
                    PERFORM 5110-PROCESS-CRED-ACTN THRU 5110-CPD136-EXIT
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
P00948* Build cred coll/cred actn rows for STA, STAA, STF & STFA                
      * Build F - ROw (2nd Notice)                                              
           IF WS-DATE-SCND-NOT-CREDACT > SPACES                         
              IF WS-KR136-UTIL-AMOUNT > ZEROS                           
      * Populate cred action/cred coll table variables                          
                 MOVE 'ULN'                    TO 4W-CRED-ACTN-TYPE-CD  
                 MOVE WS-CAR-ARNG-ID           TO 4W-ARNG-ID            
                 MOVE WS-ARNG-SEQ-NO           TO 4W-CRED-ARNG-SEQ      
                 MOVE 1                        TO 4W-CRED-ACTN-SEQ      
                 MOVE WS-F                     TO CL-CODE-NOTICE-TYPE   
                 IF WS-KR136-FINAL-NOT-MAIL-DT > SPACES                 
                    MOVE ZEROS                 TO WS-NULL-IND           
                    MOVE WS-KR136-FINAL-NOT-MAIL-DT                     
                                               TO CL-DATE-NOTICE-MAIL   
                                                  4W-CRED-ACTN-FCST-DT  
                 ELSE                                                   
                    MOVE -1                    TO WS-NULL-IND           
                 END-IF                                                 
                 IF WS-KR136-ARNG-DUE-DT > SPACES                       
                    MOVE ZEROS                 TO WS-NULL-IND1          
                    MOVE WS-KR136-ARNG-DUE-DT  TO CL-DATE-NOTICE-DUE    
                                                  4W-CRED-ACTN-DUE-DT   
                 ELSE                                                   
                    MOVE -1                    TO WS-NULL-IND1          
                 END-IF                                                 
                 IF WS-DATE-SCND-NOT-CREDACT > SPACES AND               
                                    AT-ACCOUNT-TYPE-CODE = 'R'          
                    MOVE ZEROS                 TO WS-NULL-CREDACT       
                    MOVE WS-DATE-SCND-NOT-CREDACT                       
                                               TO CL-DATE-CREDIT-ACTION 
                 ELSE                                                   
                    MOVE SPACES                TO                       
                                               WS-DATE-SCND-NOT-CREDACT 
                    MOVE -1                    TO WS-NULL-CREDACT       
                 END-IF                                                 
                 MOVE WS-KR136-UTIL-AMOUNT     TO CL-AMT-NOTICE         
                                                  4W-CRED-ACTN-AM       
                 MOVE SPACES                   TO CL-CODE-FRCST-CR-GRP  
                 MOVE ZEROS                    TO CL-ITEM-ID            
                 MOVE ZEROS                    TO CL-CODE-MESSAGE-TYPE  
                 MOVE AT-DATE-BILL-DAY-00      TO CL-DATE-BILL          
                 MOVE WS-Q                     TO CL-CODE-SPECIAL-TYPE  
P00948           IF WS-CAR-ARNG-TYPE = 'STA' OR 'STF'                   
                    PERFORM 8110-INSERT-CRED-COLL THRU 8110-CPD136-EXIT 
                 ELSE                                                   
P00948              IF WS-CAR-ARNG-TYPE = 'STAA' OR 'STFA'              
                       PERFORM 5110-PROCESS-CRED-ACTN                   
                                                  THRU 5110-CPD136-EXIT 
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
      * Build U - ROw (Non Utl 2nd Notice)                                      
              IF WS-KR136-NONUTL-AMOUNT > ZEROS                         
      * Populate cred action/cred coll table variables                          
                 MOVE 'NLN'                    TO 4W-CRED-ACTN-TYPE-CD  
                 MOVE WS-CAR-ARNG-ID           TO 4W-ARNG-ID            
                 MOVE WS-ARNG-SEQ-NO           TO 4W-CRED-ARNG-SEQ      
                 MOVE 1                        TO 4W-CRED-ACTN-SEQ      
                 MOVE WS-U                     TO CL-CODE-NOTICE-TYPE   
                 IF WS-KR136-FINAL-NOT-MAIL-DT > SPACES                 
                    MOVE WS-KR136-FINAL-NOT-MAIL-DT                     
                                               TO CL-DATE-NOTICE-MAIL   
                                                  4W-CRED-ACTN-FCST-DT  
                    MOVE ZEROS                 TO WS-NULL-IND           
                 ELSE                                                   
                    MOVE -1                    TO WS-NULL-IND           
                 END-IF                                                 
                 IF WS-KR136-ARNG-DUE-DT > SPACES                       
                    MOVE ZEROS                 TO WS-NULL-IND1          
                    MOVE WS-KR136-ARNG-DUE-DT  TO CL-DATE-NOTICE-DUE    
                                                  4W-CRED-ACTN-DUE-DT   
                 ELSE                                                   
                    MOVE -1                    TO WS-NULL-IND1          
                 END-IF                                                 
                 IF WS-DATE-SCND-NOT-CREDACT > SPACES AND               
                                       AT-ACCOUNT-TYPE-CODE = 'R'       
                    MOVE ZEROS                 TO WS-NULL-CREDACT       
                    MOVE WS-DATE-SCND-NOT-CREDACT                       
                                               TO CL-DATE-CREDIT-ACTION 
                 ELSE                                                   
                    MOVE SPACES  TO WS-DATE-SCND-NOT-CREDACT            
                    MOVE -1                    TO WS-NULL-CREDACT       
                 END-IF                                                 
                 MOVE WS-KR136-NONUTL-AMOUNT   TO CL-AMT-NOTICE         
                                                  4W-CRED-ACTN-AM       
                 MOVE SPACES                   TO CL-CODE-FRCST-CR-GRP  
                 MOVE ZEROS                    TO CL-ITEM-ID            
                 MOVE ZEROS                    TO CL-CODE-MESSAGE-TYPE  
                 MOVE AT-DATE-BILL-DAY-00      TO CL-DATE-BILL          
                 MOVE WS-Q                     TO CL-CODE-SPECIAL-TYPE  
P00948           IF WS-CAR-ARNG-TYPE = 'STA' OR 'STF'                   
                    PERFORM 8110-INSERT-CRED-COLL THRU 8110-CPD136-EXIT 
                 ELSE                                                   
P00948              IF WS-CAR-ARNG-TYPE = 'STAA' OR 'STFA'              
                       PERFORM 5110-PROCESS-CRED-ACTN                   
                                                  THRU 5110-CPD136-EXIT 
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
      * Build G - ROw (Exceptional DNP)                                         
           IF WS-KR136-UTIL-AMOUNT > ZEROS                              
      * Populate cred action/cred coll table variables                          
              MOVE 'DNP'                       TO 4W-CRED-ACTN-TYPE-CD  
              MOVE WS-CAR-ARNG-ID              TO 4W-ARNG-ID            
              MOVE WS-ARNG-SEQ-NO              TO 4W-CRED-ARNG-SEQ      
              MOVE 1                           TO 4W-CRED-ACTN-SEQ      
              MOVE WS-G                        TO CL-CODE-NOTICE-TYPE   
              MOVE -1                          TO WS-NULL-IND           
              MOVE -1                          TO WS-NULL-IND1          
              IF WS-KR136-NEW-DNP-DATE > SPACES                         
                 MOVE 0                        TO WS-NULL-CREDACT       
                 MOVE WS-KR136-NEW-DNP-DATE    TO CL-DATE-CREDIT-ACTION 
                                                  4W-CRED-ACTN-FCST-DT  
              ELSE                                                      
                 MOVE -1                       TO WS-NULL-CREDACT       
              END-IF                                                    
              MOVE WS-KR136-UTIL-AMOUNT        TO CL-AMT-NOTICE         
                                                  4W-CRED-ACTN-AM       
              MOVE SPACES                      TO CL-CODE-FRCST-CR-GRP  
              MOVE ZEROS                       TO CL-ITEM-ID            
              MOVE ZEROS                       TO CL-CODE-MESSAGE-TYPE  
              MOVE AT-DATE-BILL-DAY-00         TO CL-DATE-BILL          
              MOVE WS-Q                        TO CL-CODE-SPECIAL-TYPE  
P00948        IF WS-CAR-ARNG-TYPE = 'STA' OR 'STF'                      
                 PERFORM 8110-INSERT-CRED-COLL THRU 8110-CPD136-EXIT    
              ELSE                                                      
P00948           IF WS-CAR-ARNG-TYPE = 'STAA' OR 'STFA'                 
                    PERFORM 5110-PROCESS-CRED-ACTN                      
                                               THRU 5110-CPD136-EXIT    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
      * Build x - ROw (Non Utl Work Queue)                                      
           IF WS-KR136-NONUTL-AMOUNT > ZEROS                            
      * Populate cred action/cred coll table variables                          
              MOVE 'NWQ'                        TO 4W-CRED-ACTN-TYPE-CD 
              MOVE WS-CAR-ARNG-ID               TO 4W-ARNG-ID           
              MOVE WS-ARNG-SEQ-NO               TO 4W-CRED-ARNG-SEQ     
              MOVE 1                            TO 4W-CRED-ACTN-SEQ     
              MOVE WS-X                         TO CL-CODE-NOTICE-TYPE  
              MOVE -1                           TO WS-NULL-IND          
              MOVE -1                           TO WS-NULL-IND1         
              IF WS-KR136-NEW-DNP-DATE > SPACES                         
                 MOVE 0                         TO WS-NULL-CREDACT      
                 MOVE WS-KR136-NEW-DNP-DATE     TO CL-DATE-CREDIT-ACTION
                                                   4W-CRED-ACTN-FCST-DT 
              ELSE                                                      
                 MOVE -1                        TO WS-NULL-CREDACT      
              END-IF                                                    
              MOVE WS-KR136-NONUTL-AMOUNT       TO CL-AMT-NOTICE        
                                                   4W-CRED-ACTN-AM      
              MOVE SPACES                       TO CL-CODE-FRCST-CR-GRP 
              MOVE ZEROS                        TO CL-ITEM-ID           
              MOVE ZEROS                        TO CL-CODE-MESSAGE-TYPE 
              MOVE AT-DATE-BILL-DAY-00          TO CL-DATE-BILL         
              MOVE WS-Q                         TO CL-CODE-SPECIAL-TYPE 
P00948        IF WS-CAR-ARNG-TYPE = 'STA' OR 'STF'                      
                 PERFORM 8110-INSERT-CRED-COLL THRU 8110-CPD136-EXIT    
              ELSE                                                      
P00948           IF WS-CAR-ARNG-TYPE = 'STAA' OR 'STFA'                 
                    PERFORM 5110-PROCESS-CRED-ACTN                      
                                               THRU 5110-CPD136-EXIT    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5500-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5700-ADDL-DELETES - DELETES DNP ROW >  CURRENT DATE AND     *           
      * < PARM NEW DNP DATE, AND CORRESPONDING NOTICE AND WQ ROWS.  *           
      ***************************************************************           
                                                                        
       5700-ADDL-DELETES.                                               
                                                                        
           PERFORM 8285-DEL-ROW                   THRU 8285-CPD136-EXIT.
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              EVALUATE CL-CODE-NOTICE-TYPE                              
                 WHEN 'D'                                               
                      PERFORM 8220-DEL-FUTURE-C-ROW                     
                                                  THRU 8220-CPD136-EXIT 
                      IF WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                         MOVE -1          TO WS-DATE-CR-ACTION-NULL     
                         PERFORM 8120-UPD-FUTURE-C-ROW                  
                                                  THRU 8120-CPD136-EXIT 
                      END-IF                                            
                      MOVE 'M'            TO CL-CODE-NOTICE-TYPE        
                      PERFORM 8280-DEL-FUTURE-ROW                       
                                                  THRU 8280-CPD136-EXIT 
                 WHEN 'G'                                               
                      PERFORM 8240-DEL-FUTURE-E-F-ROW                   
                                                  THRU 8240-CPD136-EXIT 
                      IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                          MOVE -1         TO WS-DATE-CR-ACTION-NULL     
                          PERFORM 8120F-UPD-FUTURE-F-ROW                
                                                  THRU 8120F-CPD136-EXIT
                      END-IF                                            
                      MOVE 'X'            TO CL-CODE-NOTICE-TYPE        
                      PERFORM 8280-DEL-FUTURE-ROW THRU 8280-CPD136-EXIT 
                 WHEN 'H'                                               
                      PERFORM 8290-DEL-RETCHK-NOTICES                   
                                                  THRU 8290-CPD136-EXIT 
                 WHEN 'I'                                               
                      PERFORM 8295-DEL-DEP-NOTICE THRU 8295-CPD136-EXIT 
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
           PERFORM 7035-FETCH-CRED-COLL-CUR       THRU 7035-CPD136-EXIT.
                                                                        
       5700-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7000-SELECT-TIMESTAMP-DATE                                   *          
      ****************************************************************          
                                                                        
       7000-SELECT-TIMESTAMP-DATE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                     CAST(SYSDATETIMEOFFSET() AS DATE),                         
                     CIS.INT2CHAR(DATEPART(DAYOFYEAR, 
           CAST(SYSDATETIMEOFFSET() AS DATE))),                     
                     DATEPART(DAYOFYEAR, CAST(SYSDATETIMEOFFSET() 
           AS DATE))                            
                INTO :WS-CURRENT-TIMESTMP,                              
                     :WS-CURRENT-DATE,                                  
                     :WS-JULIAN-DAYS-TXT,                               
                     :WS-JULIAN-DAYS-NUM                                
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP,                                         
MFA-TR*              CURRENT DATE,                                              
MFA-TR*              CHAR(DAYOFYEAR(CURRENT DATE)),                             
MFA-TR*              DAYOFYEAR(CURRENT DATE)                                    
MFA-TR*         INTO :WS-CURRENT-TIMESTMP,                                      
MFA-TR*              :WS-CURRENT-DATE,                                          
MFA-TR*              :WS-JULIAN-DAYS-TXT,                                       
MFA-TR*              :WS-JULIAN-DAYS-NUM                                        
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-JULIAN-DAYS-NUM < 100                               
                 IF WS-JULIAN-DAYS-NUM < 10                             
                    STRING '00' WS-JULIAN-DAYS-TXT                      
                        DELIMITED BY SIZE                               
                        INTO WS-JULIAN-DATE                             
                 ELSE                                                   
                    STRING '0' WS-JULIAN-DAYS-TXT                       
                        DELIMITED BY SIZE                               
                        INTO WS-JULIAN-DATE                             
                  END-IF                                                
              ELSE                                                      
                  MOVE WS-JULIAN-DAYS-TXT TO WS-JULIAN-DATE             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7000'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE 12                     TO WS-KR136-RETURN-CODE       
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       7000-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-GET-CRED-ACTN-SEQ                                         *        
      ******************************************************************        
                                                                        
       7020-GET-CRED-ACTN-SEQ.                                          
                                                                        
           EXEC SQL                                                     
              SELECT
              NEXT VALUE FOR                  
                                           SEQ_4W_CRED_ARNG_ACTN_SEQ
            INTO
              :WS-CRED-ARNG-ACTN-SEQ    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CRED-ARNG-ACTN-SEQ = NEXTVAL FOR                          
MFA-TR*                                    SEQ_4W_CRED_ARNG_ACTN_SEQ            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7020'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SET'                  TO ABEND-FUNCTION             
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CRED_ARNG_ACTN_SEQ'   TO TABLE-ELEMENT-1            
              MOVE WS-CRED-ARNG-ACTN-SEQ  TO HOSTVAR-ELEMENT-1          
              MOVE 12                     TO WS-KR136-RETURN-CODE       
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       7020-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7025-OPEN-CRED-COLL-CUR                                       *         
      *****************************************************************         
                                                                        
       7025-OPEN-CRED-COLL-CUR.                                         
                                                                        
           EXEC SQL                                                     
              OPEN CRED-COLL-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7025'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'OPEN'                   TO ABEND-FUNCTION      
                   MOVE SQLCODE                  TO ABEND-SQLCODE       
                   MOVE 'CSS_CRED_COLL'          TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE CL-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   MOVE 12                       TO WS-KR136-RETURN-CODE
                   PERFORM 9999-BAIL-OUT                 THRU 9999-EXIT 
           END-EVALUATE.                                                
                                                                        
       7025-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7035-FETCH-CRED-COLL-CUR                                       *        
      ******************************************************************        
       7035-FETCH-CRED-COLL-CUR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH CRED-COLL-CUR                                      
               INTO :CL-ACCOUNT-NO,                                     
                    :CL-CODE-NOTICE-TYPE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   SET END-CURSOR           TO TRUE                     
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7035'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_CRED_COLL'     TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE CL-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 12                       TO WS-KR136-RETURN-CODE
                   PERFORM 9999-BAIL-OUT                 THRU 9999-EXIT 
           END-EVALUATE.                                                
                                                                        
       7035-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7045-CLOSE-CRED-COLL-CUR                                      *         
      *****************************************************************         
                                                                        
       7045-CLOSE-CRED-COLL-CUR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE CRED-COLL-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7045'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'CLOSE'                  TO ABEND-FUNCTION      
                   MOVE SQLCODE                  TO ABEND-SQLCODE       
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                   MOVE 'CSS_CRED_COLL'          TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE CL-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   MOVE 12                       TO WS-KR136-RETURN-CODE
                   PERFORM 9999-BAIL-OUT                 THRU 9999-EXIT 
           END-EVALUATE.                                                
                                                                        
       7045-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7050-SELECT-RESP-AREA                                         *         
      *****************************************************************         
                                                                        
       7050-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :WS-USER-ID                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :WS-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :WS-USER-ID                                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE WS-USER-ID            TO HOSTVAR-ELEMENT-1           
              MOVE WS-KR136-ACCOUNT-NO   TO HOSTVAR-ELEMENT-2           
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       7050-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7060-SELECT-DELINQ-VALUE                                      *         
      *****************************************************************         
                                                                        
       7060-SELECT-DELINQ-VALUE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1           
              MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              MOVE WS-KR136-ACCOUNT-NO   TO HOSTVAR-ELEMENT-3           
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       7060-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7502-GET-USA-DATE                                              *        
      ******************************************************************        
                                                                        
       7502-GET-USA-DATE.                                               
                                                                        
           MOVE '7502'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              SELECT CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ),'USA')                      
              INTO  :WS-DATE-HOLD-USA                                   
              FROM   CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CHAR(DATE(:WS-DATE-HOLD),USA)                              
MFA-TR*       INTO  :WS-DATE-HOLD-USA                                           
MFA-TR*       FROM   SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SQLCODE             TO ABEND-SQLCODE                 
              MOVE 'SYSDUMMY1'         TO TABLE-1                       
              MOVE 'WS-DATE-HOLD'      TO TABLE-ELEMENT-1               
              MOVE WS-DATE-HOLD        TO HOSTVAR-ELEMENT-1             
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2               
              MOVE WS-KR136-ACCOUNT-NO TO HOSTVAR-ELEMENT-2             
              MOVE 12                  TO WS-KR136-RETURN-CODE          
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       7502-CPD136-EXIT.                                                
           EXIT.                                                        
      *****************************************************************         
      * 7845C-SELECT-CRED-COLL                                        *         
      *****************************************************************         
      *                                                                         
       7845C-SELECT-CRED-COLL.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT DATE_CREDIT_ACTION                                
                 INTO :CL-DATE-CREDIT-ACTION :WS-DATE-CR-ACTION-NULL    
                 FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                       
               WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO                 
                 AND  CODE_NOTICE_TYPE = 'C'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_CREDIT_ACTION                                        
MFA-TR*          INTO :CL-DATE-CREDIT-ACTION :WS-DATE-CR-ACTION-NULL            
MFA-TR*          FROM CSS_CRED_COLL                                             
MFA-TR*        WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO                         
MFA-TR*          AND  CODE_NOTICE_TYPE = 'C'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 0001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7845C'                TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'        TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE CL-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE 12                     TO WS-KR136-RETURN-CODE       
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       7845C-CPD136-EXIT.                                               
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7845F-SELECT-CRED-COLL                                        *         
      *****************************************************************         
       7845F-SELECT-CRED-COLL.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT DATE_CREDIT_ACTION                                
                 INTO :CL-DATE-CREDIT-ACTION :WS-DATE-CR-ACTION-NULL    
                 FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                       
               WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO                 
                 AND  CODE_NOTICE_TYPE = 'F'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_CREDIT_ACTION                                        
MFA-TR*          INTO :CL-DATE-CREDIT-ACTION :WS-DATE-CR-ACTION-NULL            
MFA-TR*          FROM CSS_CRED_COLL                                             
MFA-TR*        WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO                         
MFA-TR*          AND  CODE_NOTICE_TYPE = 'F'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 0002                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7845F'                TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'        TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE CL-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE 12                     TO WS-KR136-RETURN-CODE       
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       7845F-CPD136-EXIT.                                               
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7845S-SELECT-CRED-COLL                                        *         
      *****************************************************************         
       7845S-SELECT-CRED-COLL.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT DATE_CREDIT_ACTION                                
                 INTO :CL-DATE-CREDIT-ACTION                            
                 FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                       
               WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO                 
                 AND  CODE_NOTICE_TYPE = 'S'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_CREDIT_ACTION                                        
MFA-TR*          INTO :CL-DATE-CREDIT-ACTION                                    
MFA-TR*          FROM CSS_CRED_COLL                                             
MFA-TR*        WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO                         
MFA-TR*          AND  CODE_NOTICE_TYPE = 'S'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 0003                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7845S'                TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'        TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE CL-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE 12                     TO WS-KR136-RETURN-CODE       
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       7845S-CPD136-EXIT.                                               
           EXIT.                                                        
      *****************************************************************         
      * 7845U-SELECT-CRED-COLL                                        *         
      *****************************************************************         
      *                                                                         
       7845U-SELECT-CRED-COLL.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT DATE_CREDIT_ACTION                                
                 INTO :CL-DATE-CREDIT-ACTION :WS-DATE-CR-ACTION-NULL    
                 FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                       
               WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO                 
                 AND  CODE_NOTICE_TYPE = 'U'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_CREDIT_ACTION                                        
MFA-TR*          INTO :CL-DATE-CREDIT-ACTION :WS-DATE-CR-ACTION-NULL            
MFA-TR*          FROM CSS_CRED_COLL                                             
MFA-TR*        WHERE  ACCOUNT_NO       = :CL-ACCOUNT-NO                         
MFA-TR*          AND  CODE_NOTICE_TYPE = 'U'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 0004                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7845U'                TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'        TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE CL-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE 12                     TO WS-KR136-RETURN-CODE       
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       7845U-CPD136-EXIT.                                               
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7900-SELECT-CRED-COLL                                         *         
      *****************************************************************         
      *                                                                         
       7900-SELECT-CRED-COLL.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-WQ-DNP-NXT-DAY-FL                             
                 FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO               
                  AND CODE_NOTICE_TYPE   IN ('D','G','I')               
                  AND DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                 :WS-WQ-NEXT-BUS-DAY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-WQ-NEXT-BUS-DAY-DT
              ) <> 0) OR (LEN(:WS-WQ-NEXT-BUS-DAY-DT
              ) <> 10), CIS.CHAR2DATE(:WS-WQ-NEXT-BUS-DAY-DT
              ), CONVERT(DATE, :WS-WQ-NEXT-BUS-DAY-DT) )       
                                            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-WQ-DNP-NXT-DAY-FL                                     
MFA-TR*          FROM CSS_CRED_COLL                                             
MFA-TR*         WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO                       
MFA-TR*           AND CODE_NOTICE_TYPE   IN ('D','G','I')                       
MFA-TR*           AND DATE_CREDIT_ACTION = :WS-WQ-NEXT-BUS-DAY-DT               
MFA-TR*         FETCH FIRST ROW ONLY  WITH  UR                                  
MFA-TR*       QUERYNO 7900                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7900'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'        TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE CL-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE 'DATE_CREDIT_ACTION'   TO TABLE-ELEMENT-2            
              MOVE WS-WQ-NEXT-BUS-DAY-DT  TO HOSTVAR-ELEMENT-2          
              MOVE 12                     TO WS-KR136-RETURN-CODE       
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       7900-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8110-INSERT-CRED-COLL                                         *         
      *****************************************************************         
      *                                                                         
       8110-INSERT-CRED-COLL.                                           
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_CRED_COLL                                
                          ( ACCOUNT_NO,                                 
                            CODE_SPECIAL_TYPE,                          
                            DATE_NOTICE_MAIL,                           
                            CODE_FRCST_CR_GRP,                          
                            ITEM_ID,                                    
                            CODE_MESSAGE_TYPE,                          
                            DATE_CREDIT_ACTION,                         
                            DATE_NOTICE_DUE,                            
                            AMT_NOTICE,                                 
                            CODE_NOTICE_TYPE,                           
                            DATE_BILL,                                  
                            LAST_UPDATE_TS)                             
               VALUES     (:CL-ACCOUNT-NO,                              
                           :CL-CODE-SPECIAL-TYPE,                       
                           IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                                 :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-MAIL 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-MAIL :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-MAIL :WS-NULL-IND
              ), CONVERT(DATE, :CL-DATE-NOTICE-MAIL :WS-NULL-IND) ),           
                           :CL-CODE-FRCST-CR-GRP,                       
                           :CL-ITEM-ID,                                 
                           :CL-CODE-MESSAGE-TYPE,                       
                           IIF(TRY_CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                                 :WS-NULL-CREDACT
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                                       :WS-NULL-CREDACT
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION :WS-NULL-CREDACT
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                                       :WS-NULL-CREDACT
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION :WS-NULL-CREDACT
              ) ),     
                           IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-DUE 
                                                 :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-DUE 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-DUE :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-DUE :WS-NULL-IND1
              ), CONVERT(DATE, :CL-DATE-NOTICE-DUE :WS-NULL-IND1) ),           
                           :CL-AMT-NOTICE,                              
                           :CL-CODE-NOTICE-TYPE,                        
                           IIF(TRY_CONVERT(DATE, :CL-DATE-BILL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-BILL
              ) <> 0) OR (LEN(:CL-DATE-BILL) <> 10), CIS.CHAR2DATE(
                                                          :CL-DATE-BILL
              ), CONVERT(DATE, :CL-DATE-BILL) ),                               
                            CIS.CURRENT$TIMESTAMP())                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CRED_COLL                                        
MFA-TR*                   ( ACCOUNT_NO,                                         
MFA-TR*                     CODE_SPECIAL_TYPE,                                  
MFA-TR*                     DATE_NOTICE_MAIL,                                   
MFA-TR*                     CODE_FRCST_CR_GRP,                                  
MFA-TR*                     ITEM_ID,                                            
MFA-TR*                     CODE_MESSAGE_TYPE,                                  
MFA-TR*                     DATE_CREDIT_ACTION,                                 
MFA-TR*                     DATE_NOTICE_DUE,                                    
MFA-TR*                     AMT_NOTICE,                                         
MFA-TR*                     CODE_NOTICE_TYPE,                                   
MFA-TR*                     DATE_BILL,                                          
MFA-TR*                     LAST_UPDATE_TS)                                     
MFA-TR*        VALUES     (:CL-ACCOUNT-NO,                                      
MFA-TR*                    :CL-CODE-SPECIAL-TYPE,                               
MFA-TR*                    :CL-DATE-NOTICE-MAIL :WS-NULL-IND,                   
MFA-TR*                    :CL-CODE-FRCST-CR-GRP,                               
MFA-TR*                    :CL-ITEM-ID,                                         
MFA-TR*                    :CL-CODE-MESSAGE-TYPE,                               
MFA-TR*                    :CL-DATE-CREDIT-ACTION :WS-NULL-CREDACT,             
MFA-TR*                    :CL-DATE-NOTICE-DUE :WS-NULL-IND1,                   
MFA-TR*                    :CL-AMT-NOTICE,                                      
MFA-TR*                    :CL-CODE-NOTICE-TYPE,                                
MFA-TR*                    :CL-DATE-BILL,                                       
MFA-TR*                     CURRENT TIMESTAMP)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '8110'                 TO ACTIVE-PARAGRAPH           
              MOVE 'INSERT'               TO ABEND-FUNCTION             
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'        TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE WS-KR136-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1          
              MOVE 12                     TO WS-KR136-RETURN-CODE       
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8110-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8120-UPD-FUTURE-C-ROW.                                      *           
      ***************************************************************           
                                                                        
       8120-UPD-FUTURE-C-ROW.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CRED_COLL                                      
                SET DATE_CREDIT_ACTION     = IIF(TRY_CONVERT(DATE, 
                                                         :WS-TEMP-DATE 
                                                :WS-DATE-CR-ACTION-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-DATE 
                                                :WS-DATE-CR-ACTION-NULL
              ) <> 0) OR (LEN(:WS-TEMP-DATE :WS-DATE-CR-ACTION-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-TEMP-DATE 
                                                :WS-DATE-CR-ACTION-NULL
              ), CONVERT(DATE, :WS-TEMP-DATE :WS-DATE-CR-ACTION-NULL) )    
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND ITEM_ID                = 0                          
                AND CODE_NOTICE_TYPE    IN ('C','S')                    
                AND DATE_CREDIT_ACTION     > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_COLL                                              
MFA-TR*         SET DATE_CREDIT_ACTION     = :WS-TEMP-DATE                      
MFA-TR*                                      :WS-DATE-CR-ACTION-NULL            
MFA-TR*         WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO                     
MFA-TR*         AND ITEM_ID                = 0                                  
MFA-TR*         AND CODE_NOTICE_TYPE    IN ('C','S')                            
MFA-TR*         AND DATE_CREDIT_ACTION     > :WS-CURRENT-DATE                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8120'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8120-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8120F-UPD-FUTURE-F-ROW.                                     *           
      ***************************************************************           
                                                                        
       8120F-UPD-FUTURE-F-ROW.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CRED_COLL                                      
                SET DATE_CREDIT_ACTION     = IIF(TRY_CONVERT(DATE, 
                                                         :WS-TEMP-DATE 
                                                :WS-DATE-CR-ACTION-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-DATE 
                                                :WS-DATE-CR-ACTION-NULL
              ) <> 0) OR (LEN(:WS-TEMP-DATE :WS-DATE-CR-ACTION-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-TEMP-DATE 
                                                :WS-DATE-CR-ACTION-NULL
              ), CONVERT(DATE, :WS-TEMP-DATE :WS-DATE-CR-ACTION-NULL) )    
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND ITEM_ID                = 0                          
                AND CODE_NOTICE_TYPE    IN ('F','U')                    
                AND DATE_CREDIT_ACTION     > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_COLL                                              
MFA-TR*         SET DATE_CREDIT_ACTION     = :WS-TEMP-DATE                      
MFA-TR*                                      :WS-DATE-CR-ACTION-NULL            
MFA-TR*         WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO                     
MFA-TR*         AND ITEM_ID                = 0                                  
MFA-TR*         AND CODE_NOTICE_TYPE    IN ('F','U')                            
MFA-TR*         AND DATE_CREDIT_ACTION     > :WS-CURRENT-DATE                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8120F'               TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8120F-CPD136-EXIT.                                               
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8130-INSERT-CRED-ARNG-ACTN                                    *         
      *****************************************************************         
                                                                        
       8130-INSERT-CRED-ARNG-ACTN.                                      
                                                                        
           IF 4W-BILL-NO <= 0                                           
              MOVE -1                     TO WS-BILL-NO-NULL            
           ELSE                                                         
              MOVE ZERO                   TO WS-BILL-NO-NULL            
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CRED_ARNG_ACTN                            
                     (CRED_ARNG_ACTN_SEQ                                
                     ,ACCOUNT_NO                                        
                     ,ARNG_ID                                           
                     ,CRED_ARNG_SEQ                                     
                     ,CRED_ACTN_TYPE_CD                                 
                     ,CRED_ACTN_SEQ                                     
                     ,BILL_NO                                           
                     ,CRED_ACTN_FCST_DT                                 
                     ,CRED_ACTN_DUE_DT                                  
                     ,CRED_ACTN_AM                                      
                     ,PROCESSED_FL)                                     
              VALUES (:4W-CRED-ARNG-ACTN-SEQ                            
                     ,:4W-ACCOUNT-NO                                    
                     ,:4W-ARNG-ID                                       
                     ,:4W-CRED-ARNG-SEQ                                 
                     ,:4W-CRED-ACTN-TYPE-CD                             
                     ,:4W-CRED-ACTN-SEQ                                 
                     ,:4W-BILL-NO :WS-BILL-NO-NULL            
                     ,IIF(TRY_CONVERT(DATE, :4W-CRED-ACTN-FCST-DT
              ) IS NULL OR (PATINDEX('%.%', :4W-CRED-ACTN-FCST-DT
              ) <> 0) OR (LEN(:4W-CRED-ACTN-FCST-DT
              ) <> 10), CIS.CHAR2DATE(:4W-CRED-ACTN-FCST-DT
              ), CONVERT(DATE, :4W-CRED-ACTN-FCST-DT) )                        
                     ,IIF(TRY_CONVERT(DATE, :4W-CRED-ACTN-DUE-DT 
                                            :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :4W-CRED-ACTN-DUE-DT 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:4W-CRED-ACTN-DUE-DT :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:4W-CRED-ACTN-DUE-DT 
                                                          :WS-NULL-IND1
              ), CONVERT(DATE, :4W-CRED-ACTN-DUE-DT :WS-NULL-IND1) )           
                     ,:4W-CRED-ACTN-AM :WS-CRED-ACTN-AM-NULL       
                     ,:4W-PROCESSED-FL)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CRED_ARNG_ACTN                                    
MFA-TR*              (CRED_ARNG_ACTN_SEQ                                        
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,ARNG_ID                                                   
MFA-TR*              ,CRED_ARNG_SEQ                                             
MFA-TR*              ,CRED_ACTN_TYPE_CD                                         
MFA-TR*              ,CRED_ACTN_SEQ                                             
MFA-TR*              ,BILL_NO                                                   
MFA-TR*              ,CRED_ACTN_FCST_DT                                         
MFA-TR*              ,CRED_ACTN_DUE_DT                                          
MFA-TR*              ,CRED_ACTN_AM                                              
MFA-TR*              ,PROCESSED_FL)                                             
MFA-TR*       VALUES (:4W-CRED-ARNG-ACTN-SEQ                                    
MFA-TR*              ,:4W-ACCOUNT-NO                                            
MFA-TR*              ,:4W-ARNG-ID                                               
MFA-TR*              ,:4W-CRED-ARNG-SEQ                                         
MFA-TR*              ,:4W-CRED-ACTN-TYPE-CD                                     
MFA-TR*              ,:4W-CRED-ACTN-SEQ                                         
MFA-TR*              ,:4W-BILL-NO           :WS-BILL-NO-NULL                    
MFA-TR*              ,:4W-CRED-ACTN-FCST-DT                                     
MFA-TR*              ,:4W-CRED-ACTN-DUE-DT  :WS-NULL-IND1                       
MFA-TR*              ,:4W-CRED-ACTN-AM      :WS-CRED-ACTN-AM-NULL               
MFA-TR*              ,:4W-PROCESSED-FL)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '8130'                 TO ACTIVE-PARAGRAPH           
              MOVE 'INSERT'               TO ABEND-FUNCTION             
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'        TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE WS-KR136-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1          
              MOVE 12                     TO WS-KR136-RETURN-CODE       
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8130-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8200-DEL-SO-DATA-MF-DNP.                                    *           
      ***************************************************************           
                                                                        
       8200-DEL-SO-DATA-MF-DNP.                                         
                                                                        
           MOVE '8200' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_SO_DATA_MF                                
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND ORDER_TYPE_CD          = 'DNP01'                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_SO_DATA_MF'      TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE CL-CODE-NOTICE-TYPE   TO HOSTVAR-ELEMENT-2           
              MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-3           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_NOTICE_TYPE'    TO TABLE-ELEMENT-2             
              MOVE 'DATE_CREDIT_ACTION'  TO TABLE-ELEMENT-3             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
      *                                                                         
       8200-CPD136-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 8210-DELETE-MED-CERT-CRED-COLL.                             *           
      ***************************************************************           
                                                                        
       8210-DELETE-MED-CERT-CRED-COLL.                                  
                                                                        
           MOVE '8210' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND ITEM_ID                = 0                          
                AND ((CODE_NOTICE_TYPE     IN ('E','F','T','U')         
                      AND DATE_NOTICE_MAIL > CAST(SYSDATETIMEOFFSET() 
           AS DATE)) OR           
                     (CODE_NOTICE_TYPE     = 'G' AND                    
                      DATE_CREDIT_ACTION   > CAST(SYSDATETIMEOFFSET() 
           AS DATE)))             
                AND CODE_SPECIAL_TYPE      = :WS-M                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CRED_COLL                                         
MFA-TR*         WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO                     
MFA-TR*         AND ITEM_ID                = 0                                  
MFA-TR*         AND ((CODE_NOTICE_TYPE     IN ('E','F','T','U')                 
MFA-TR*               AND DATE_NOTICE_MAIL > CURRENT DATE) OR                   
MFA-TR*              (CODE_NOTICE_TYPE     = 'G' AND                            
MFA-TR*               DATE_CREDIT_ACTION   > CURRENT DATE))                     
MFA-TR*         AND CODE_SPECIAL_TYPE      = :WS-M                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6690'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8210-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8220-DEL-FUTURE-C-ROW.                                      *           
      ***************************************************************           
                                                                        
       8220-DEL-FUTURE-C-ROW.                                           
                                                                        
           MOVE '8220' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND ITEM_ID                = 0                          
                AND                                                     
                      CODE_NOTICE_TYPE    IN ('C','S') AND              
                      DATE_NOTICE_MAIL    > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )            
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CRED_COLL                                         
MFA-TR*         WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO                     
MFA-TR*         AND ITEM_ID                = 0                                  
MFA-TR*         AND                                                             
MFA-TR*               CODE_NOTICE_TYPE    IN ('C','S') AND                      
MFA-TR*               DATE_NOTICE_MAIL    > :WS-CURRENT-DATE                    
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8220'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-2           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'DATE_NOTICE_MAIL'    TO TABLE-ELEMENT-2             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8220-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8230-DEL-FUTURE-D-ROW                                       *           
      ***************************************************************           
                                                                        
       8230-DEL-FUTURE-D-ROW.                                           
                                                                        
           MOVE '8230' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND ITEM_ID                = 0                          
                AND                                                     
                      (CODE_NOTICE_TYPE    = 'D' AND                    
                       DATE_CREDIT_ACTION  > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ))          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CRED_COLL                                         
MFA-TR*         WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO                     
MFA-TR*         AND ITEM_ID                = 0                                  
MFA-TR*         AND                                                             
MFA-TR*               (CODE_NOTICE_TYPE    = 'D' AND                            
MFA-TR*                DATE_CREDIT_ACTION  > :WS-CURRENT-DATE)                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8230'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-2           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'DATE_CREDIT_ACTION'  TO TABLE-ELEMENT-2             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8230-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8240-DEL-FUTURE-E-F-ROW.                                    *           
      ***************************************************************           
                                                                        
       8240-DEL-FUTURE-E-F-ROW.                                         
                                                                        
           MOVE '8240' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND ITEM_ID                = 0                          
                AND CODE_NOTICE_TYPE IN ('E','F','T','U')               
                AND DATE_NOTICE_MAIL    > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CRED_COLL                                         
MFA-TR*         WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO                     
MFA-TR*         AND ITEM_ID                = 0                                  
MFA-TR*         AND CODE_NOTICE_TYPE IN ('E','F','T','U')                       
MFA-TR*         AND DATE_NOTICE_MAIL    > :WS-CURRENT-DATE                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8240'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-2           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'DATE_NOTICE_MAIL'    TO TABLE-ELEMENT-2             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8240-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8250-DEL-E-F-ROW.                                           *           
      ***************************************************************           
                                                                        
       8250-DEL-E-F-ROW.                                                
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND ITEM_ID                = 0                          
                AND CODE_NOTICE_TYPE IN ('E','F','T','U')               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8250'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8250-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8260-DEL-FUTURE-G-ROW.                                      *           
      ***************************************************************           
                                                                        
       8260-DEL-FUTURE-G-ROW.                                           
                                                                        
           MOVE '8260' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND ITEM_ID                = 0                          
                AND CODE_NOTICE_TYPE       = 'G'                        
                AND DATE_CREDIT_ACTION  > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CRED_COLL                                         
MFA-TR*         WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO                     
MFA-TR*         AND ITEM_ID                = 0                                  
MFA-TR*         AND CODE_NOTICE_TYPE       = 'G'                                
MFA-TR*         AND DATE_CREDIT_ACTION  > :WS-CURRENT-DATE                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8260'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-2           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'DATE_CREDIT_ACTION'  TO TABLE-ELEMENT-2             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8260-CPD136-EXIT.                                                
           EXIT.                                                        
      ***************************************************************           
      * 8270-DEL-G-ROW.                                             *           
      ***************************************************************           
                                                                        
       8270-DEL-G-ROW.                                                  
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND ITEM_ID                = 0                          
                AND CODE_NOTICE_TYPE       = 'G'                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8270'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8270-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *                                                             *           
      * 8280-DEL-FUTURE-ROW                                         *           
      *                                                             *           
      ***************************************************************           
                                                                        
       8280-DEL-FUTURE-ROW.                                             
                                                                        
           MOVE '8280' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND CODE_NOTICE_TYPE       = :CL-CODE-NOTICE-TYPE       
                AND DATE_CREDIT_ACTION     > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CRED_COLL                                         
MFA-TR*         WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO                     
MFA-TR*         AND CODE_NOTICE_TYPE       = :CL-CODE-NOTICE-TYPE               
MFA-TR*         AND DATE_CREDIT_ACTION     > :WS-CURRENT-DATE                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8280'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE CL-CODE-NOTICE-TYPE   TO HOSTVAR-ELEMENT-2           
              MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-3           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_NOTICE_TYPE'    TO TABLE-ELEMENT-2             
              MOVE 'DATE_CREDIT_ACTION'  TO TABLE-ELEMENT-3             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8280-CPD136-EXIT.                                                
           EXIT.                                                        
      ***************************************************************           
      * 8285-DEL-ROW.                                               *           
      ***************************************************************           
                                                                        
       8285-DEL-ROW.                                                    
                                                                        
           MOVE '8285' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
                WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
                AND CODE_NOTICE_TYPE       = :CL-CODE-NOTICE-TYPE       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8285'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE CL-CODE-NOTICE-TYPE   TO HOSTVAR-ELEMENT-2           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_NOTICE_TYPE'    TO TABLE-ELEMENT-2             
              MOVE 12                    TO WS-KR136-RETURN-CODE        
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       8285-CPD136-EXIT.                                                
           EXIT.                                                        
      *****************************************************************         
      * 8290-DEL-RETCHK-NOTICES.                                      *         
      *****************************************************************         
                                                                        
       8290-DEL-RETCHK-NOTICES.                                         
                                                                        
           EXEC SQL                                                     
                DELETE FROM CSS_CRED_COLL                               
                WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                       
                AND (CODE_NOTICE_TYPE IN ('N', 'V', 'W') AND            
                     DATE_NOTICE_MAIL > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ))               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CRED_COLL                                       
MFA-TR*         WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                               
MFA-TR*         AND (CODE_NOTICE_TYPE IN ('N', 'V', 'W') AND                    
MFA-TR*              DATE_NOTICE_MAIL > :WS-CURRENT-DATE)                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '8290'              TO ACTIVE-PARAGRAPH         
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SQLCODE                TO ABEND-SQLCODE         
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_CRED_COLL'     TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE CL-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'CURRENT_DATE'      TO TABLE-ELEMENT-1          
                   MOVE WS-CURRENT-DATE     TO HOSTVAR-ELEMENT-1        
                   MOVE 12                  TO WS-KR136-RETURN-CODE     
                   PERFORM 9999-BAIL-OUT                 THRU 9999-EXIT 
           END-EVALUATE.                                                
                                                                        
       8290-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8295-DEL-DEP-NOTICE - DELETE DEPOSIT NOTICE.                  *         
      *****************************************************************         
                                                                        
       8295-DEL-DEP-NOTICE.                                             
                                                                        
           EXEC SQL                                                     
                DELETE FROM CSS_CRED_COLL                               
                WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                       
                AND (CODE_NOTICE_TYPE = 'O' AND                         
                     DATE_NOTICE_MAIL > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ))               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CRED_COLL                                       
MFA-TR*         WHERE ACCOUNT_NO = :CL-ACCOUNT-NO                               
MFA-TR*         AND (CODE_NOTICE_TYPE = 'O' AND                                 
MFA-TR*              DATE_NOTICE_MAIL > :WS-CURRENT-DATE)                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '8295'              TO ACTIVE-PARAGRAPH         
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SQLCODE                TO ABEND-SQLCODE         
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_CRED_COLL'     TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE CL-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'CURRENT_DATE'      TO TABLE-ELEMENT-1          
                   MOVE WS-CURRENT-DATE     TO HOSTVAR-ELEMENT-1        
                   MOVE 12                  TO WS-KR136-RETURN-CODE     
                   PERFORM 9999-BAIL-OUT                 THRU 9999-EXIT 
           END-EVALUATE.                                                
                                                                        
       8295-CPD136-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8350-DELETE-CREDCOLL                                          *         
      *****************************************************************         
                                                                        
       8350-DELETE-CREDCOLL.                                            
                                                                        
           MOVE '8350'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
              WHERE  ACCOUNT_NO         = :CL-ACCOUNT-NO                
              AND    CODE_NOTICE_TYPE  IN ('E', 'F', 'G', 'T', 'U', 'X')
              AND    ITEM_ID            = 0                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'CSS_CRED_COLL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 12                         TO WS-KR136-RETURN-CODE   
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
                                                                        
           END-IF.                                                      
                                                                        
       8350-CPD136-EXIT.                                                
           EXIT.                                                        
