      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      **              CUSTOMER INFORMATION SYSTEM                    **         
      *****************************************************************         
      **              P R O G R A M  S U M M A R Y                   **         
      **                                                             **         
      ** INSERTS CREDIT ARNG SETUP DATA INTO CORRESPONDING TABLES.   **         
      ** COPYBOOK WILL BE CALLED BY SCSKR135/MCSKR135                **         
      ** INSERTS TRANSACTION HISTORY AS NEEDED                       **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     **         
      *****************************************************************         
      **    DATE     INITIALS     REASON                             **         
      **  -------    --------     ------                             **         
P00726**  05/06/2013 VENKAT      INITIAL PROGRAM VERSION             **         
      **             VUDDANDAPU                                      **         
P0726A**  02/19/2014 AA97148     CREDIT ARRANGEMENTS DCR CHANGES.    **         
P0726B**  02/24/2014 AA97148     RELEASE 2 CHANGES - IF CDD CUSTOMER **         
P0726B**                         WANT TO BE ENROLLED ON CDD PLUS PLAN**         
P0726B**                         THEN CANCEL THE EXISTING PLAN AND   **         
P0726B**                         SETUP NEW ONE.                      **         
P0726C**  06/26/2014 AA97148     RELEASE 3 CHANGES - ADDED SHORT TERM**         
P0726C**                         AND SHORT TERM AFTER RELATED LOGIC. **         
P0726D**  09/15/2014 VV94890     Cleaned up Arrangement Setup Comments*         
P0726E**  11/12/2014 AA97148     1. DELETED CDD & CDDA CHECK WHILE   **         
P0726E**                            WHILE THE ARRANGEMENT REPLACEMENT**         
P0726E**                         2. REMOVED ARNG HIST INSERT PROCESS **         
P0726E**                            AS IT WILL BE HANDLED BY CPDKR360**         
P0726F**  11/18/2014 GOKUL       DELETE GROUP MOVEMENT ATTRIBUTE FOR **         
P0726F**                         GROUP 1 SENIOR.                     **         
P0726G**  12/22/2014 AA97148     PROD FIX - CHECK SPACES BEFORE WRITES*         
P0726G**                         FINAL NOTICE MAIL DATE TRANS.       **         
P0726H**  01/14/2015 VV94890     UPDATING THE ARNG_ACTN TABLE DURING **         
P0726H**                         THE SHORT TERM AFTER'S - FLEXED.    **         
P0726I**  06/26/2014 AA97148     CREDIT ARRANGEMENTS RELEASE 6 -ADDED**         
P0726I**                         LAST UPDATE TIMESTAMP VALIDATION FOR**         
P0726I**                         CIS MOD SETUP VIEW/NEW TBL STRUCTURE**         
P00948**  06/16/2016 AA97148     LEAST AMOUNT TO PAY CHANGES.        **         
      *****************************************************************         
      *                                                                         
      *****************************************************************         
      *5300-SETUP-CRED-ARNG.                                          *         
      *****************************************************************         
       5300-SETUP-CRED-ARNG.                                            
      *                                                                         
           MOVE WS-CAR-ACCOUNT-NO      TO WS-ACCOUNT-NO                 
           MOVE WS-ACCOUNT-NO-RED      TO WS-ACCOUNT-NO-NUM             
           MOVE WS-ACCOUNT-NO-NUM      TO WS-ACCOUNT-NO-COMP3           
                                          WS-ACCOUNT-NO-NUM2            
           MOVE WS-ACCOUNT-NO-COMP3    TO AT-ACCOUNT-NO                 
                                          X1-ACCOUNT-NO                 
                                          WX-ACCOUNT-NO                 
                                          WY-ACCOUNT-NO                 
P0726B                                    WS-KR360-ACCOUNT-NO           
P0726C                                    CL-ACCOUNT-NO                 
      *                                                                         
           PERFORM 7300-SELECT-CSS-ACCOUNT     THRU 7300-EXIT           
P0726C     MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT   
      *                                                                         
           PERFORM 7400-GET-TIMESTAMP-AND-DATE THRU 7400-EXIT           
      *                                                                         
P0726C     MOVE AT-COMPANY-NO                TO C8-COMPANY-NO.          
P0726C     MOVE WS-DAY-BSEC-IVREXC-CD        TO C8-DELINQ-CD            
P0726C     PERFORM 7060-SELECT-DELINQ-VALUE    THRU 7060-CPD136-EXIT    
P0726C     MOVE  C8-DELINQ-VALUE             TO WS-DAY-BSEC-IVREXC-VAL  
P0726C*                                                                         
P0726C     MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
P0726C     PERFORM 7850-GET-DLINQ-VAL                THRU 7850-EXIT.    
P0726C     MOVE  C8-DELINQ-VALUE             TO WS-DATABASE.            
P0726C                                                                  
P0726F     PERFORM 7820-SELECT-REG-PROFILE    THRU 7820-EXIT.           
           IF WS-CAR-ACTION-FL = 'U'                                    
MAINT         PERFORM 5340-MAINT-PLAN        THRU 5340-EXIT             
           ELSE                                                         
P0726I* TimeStamp Validation on Arrangement Setup view                          
P0726I        IF WS-CAR-LAST-UPDATE-TS = AT-LAST-UPDATE-TS              
P0726I           CONTINUE                                               
P0726I        ELSE                                                      
P0726I           MOVE 'CMN0000016'        TO WS-APPL-RETURN-CODE        
P0726I           MOVE 0                   TO RS-RETURN-CODE             
P0726I           GO TO 5300-CPD135-EXIT                                 
P0726I        END-IF                                                    
P0726C* Change Due replacing with Change Due After plan                         
P0726C        IF WS-CODE-CRED-ARNG = 'A'                                
P0726B           MOVE 0                   TO WS-KR360-PREMISE-NO        
P0726B                                       WS-KR360-CUSTOMER-NO       
P0726B           MOVE WS-RESP-AREA-ID     TO WS-KR360-RESP-AREA-ID      
P0726B           MOVE WS-CAR-USER-ID      TO WS-KR360-USER-ID           
P0726B           MOVE 'F'                 TO WS-KR360-CODE-TRAN-TYPE    
P0726B           PERFORM 5380-PROCESS-ARNG-PALN-DESC THRU 5380-EXIT     
P0726B           MOVE WS-CMP-TABLE        TO WS-KR360-COMMENT-TEXT      
P0726B           MOVE LENGTH OF WS-KR360-COMMENT-TEXT                   
P0726B                                    TO WS-KR360-COMMENT-LEN       
P0726E           MOVE WS-CAR-TOTAL-AR-BALANCE  TO WS-KR360-TOTAL-AR-BAL 
P0726E           MOVE WS-CAR-TOTAL-UTL-BALANCE TO WS-KR360-TOTAL-UTL-BAL
P0726E           MOVE WS-CAR-TOTAL-NONUTL-BALANCE                       
P0726E                                    TO WS-KR360-TOT-NONUTL-BAL    
P0726E           MOVE WS-CAR-UTL-ARREARS-AMT   TO WS-KR360-UTL-ARR-AMT  
P0726E           MOVE WS-CAR-NONUTL-ARREARS-AMT                         
P0726E                                    TO WS-KR360-NONUTL-ARR-AMT    
P0726B           PERFORM 5100-CNCL-CRED-ARNG-PROCESS                    
P0726B                                    THRU 5100-CPD360-EXIT         
P0726B           PERFORM 7400-GET-TIMESTAMP-AND-DATE THRU 7400-EXIT     
P0726B        END-IF                                                    
P0726C                                                                  
P0726C* Short Term After cannot replace for STA.                                
P0726C        IF WS-CAR-ARNG-TYPE = 'STA' OR 'STAA' OR 'STF' OR 'STFA'  
P0726C           IF WS-CODE-STA-ACCT = 'A'                              
P0726C              MOVE 'CRDARNG008'        TO WS-APPL-RETURN-CODE     
P0726C              GO TO 5300-CPD135-EXIT                              
P0726C           END-IF                                                 
P0726C        END-IF                                                    
P0726C                                                                  
SETUP         PERFORM 5330-SETUP-PLAN        THRU 5330-EXIT             
P0726C                                                                  
           END-IF.                                                      
      *                                                                         
       5300-CPD135-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PROCESS INPUT PARMS FOR SETUP CDD                              *        
      ******************************************************************        
       5310-SETUP-PROCESS.                                              
      *                                                                         
      *------< GET MAX CREDIT ARNGMENT SEQ NO >                                 
           PERFORM 7600-MAX-CRED-ARNG-SEQ    THRU 7600-EXIT             
           IF  WS-MAX-CRED-ARNG-SEQ-NULL < 0                            
           OR  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               MOVE 1                        TO WS-ARNG-SEQ-NO          
           ELSE                                                         
               MOVE WS-MAX-CRED-ARNG-SEQ     TO WS-ARNG-SEQ-NO          
               ADD  1                        TO WS-ARNG-SEQ-NO          
           END-IF                                                       
      *------< GET MAX CREDIT ARNGMENT SCHD SEQUENCE NO >                       
P00948     MOVE WS-CAR-ARNG-ID               TO WX-ARNG-ID              
P00948     MOVE WS-ARNG-SEQ-NO               TO WX-CRED-ARNG-SEQ        
           PERFORM 7700-MAX-ARNG-SCHD-SEQ    THRU 7700-EXIT             
           IF  WS-MAX-ARNG-SCHD-SEQ  < 0                                
           OR  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               MOVE 1                        TO WS-ARNG-SCHD-SEQ-NO     
           ELSE                                                         
               MOVE WS-MAX-ARNG-SCHD-SEQ     TO WS-ARNG-SCHD-SEQ-NO     
               ADD  1                        TO WS-ARNG-SCHD-SEQ-NO     
           END-IF                                                       
      *------< NULL VALIDATIONS >                                               
           IF (WS-CAR-ARNG-DUE-DT  = SPACES  OR                         
               WS-CAR-ARNG-DUE-DT  = '0001-01-01')                      
                MOVE SPACES             TO WS-CAR-ARNG-DUE-DT           
                MOVE -1                 TO WS-DATE-ARNG-SCHD-NULL       
           ELSE                                                         
                MOVE +0                 TO WS-DATE-ARNG-SCHD-NULL       
           END-IF                                                       
      *------< FORMAT DATE >                                                    
P0726C     MOVE WS-CAR-ARNG-DUE-DT           TO WS-DATE-HOLD            
           PERFORM 7800-GET-USA-DATE         THRU 7800-EXIT             
P0726C     MOVE WS-DATE-HOLD-USA             TO WS-ARNG-DUE-DT-USA      
      *------< CREATE CONF NUMBER >                                             
           PERFORM 5320-CREATE-CONF-NO       THRU 5320-EXIT             
      *------< COMMENTS >                                                       
           EVALUATE TRUE                                                
              WHEN WS-CAR-ARNG-CHANNEL-CD  = 'I'                        
                   MOVE 'IVR ARRANGEMENT'    TO WS-ARRANGEMENT-TEXT     
              WHEN WS-CAR-ARNG-CHANNEL-CD  = 'W'                        
                   MOVE 'WEB ARRANGEMENT'    TO WS-ARRANGEMENT-TEXT     
              WHEN OTHER                                                
                   MOVE 'CIS ARRANGEMENT'    TO WS-ARRANGEMENT-TEXT     
           END-EVALUATE                                                 
      *                                                                         
P0726D     MOVE WS-ARRANGEMENT-TEXT          TO WS-CRED-COMMENTS-TEXT   
P0726D     MOVE +15                          TO WS-CRED-COMMENTS-LEN    
      *                                                                         
      *------< MOVE ALL OTHER FIELDS READY FOR SETUP/INSERT >                   
           MOVE WS-CAR-ARNG-ID               TO X1-ARNG-ID              
                                                WX-ARNG-ID              
                                                WY-ARNG-ID              
           MOVE WS-ARNG-SEQ-NO               TO X1-CRED-ARNG-SEQ        
                                                WX-CRED-ARNG-SEQ        
                                                WY-CRED-ARNG-SEQ        
           MOVE WS-ARNG-SCHD-SEQ-NO          TO WX-ARNG-SCHD-SEQ        
P0726A                                          WY-ARNG-SCHD-SEQ        
           MOVE WS-CAR-ARNG-DUE-DT           TO WX-ARNG-SCHD-DUE-DT     
                                                WY-ARNG-DUE-DT          
P0726C                                          WS-KR136-ARNG-DUE-DT    
P0726B     MOVE WS-CSR-ARNG-OPTION-ID        TO X1-ARNG-OPTION-ID       
           MOVE WS-CAR-ARNG-TYPE             TO X1-ARNG-TYPE            
           MOVE WS-CAR-ARNG-CHANNEL-CD       TO X1-ARNG-CHANNEL-CD      
           MOVE 'N'                          TO X1-INSTALLMENT-FL       
           MOVE WS-CURRENT-DATE              TO X1-ARNG-START-DT        
           MOVE WS-CAR-ARNG-TOTAL-AMT        TO X1-ARNG-TOTAL-AMT       
                                                WX-ARNG-SCHD-PYMT-AMT   
           MOVE WS-CONFIRMATION-NO           TO X1-ARNG-CONFIRM-NO      
           MOVE WS-CURRENT-DATE              TO X1-ARNG-SETUP-DT        
           MOVE 1                            TO X1-ARNG-NO-INSTALL      
           MOVE SPACES                       TO X1-ARNG-COMPLIANCE-CD   
           MOVE 'A'                          TO X1-ARNG-STATUS-CD       
           MOVE 'S'                          TO WY-ARNG-CHANGE-CD       
           MOVE WS-CAR-ORIG-DUE-DT           TO X1-ORIGINAL-DUE-DT      
           MOVE WS-CAR-TOTAL-AR-BALANCE      TO WY-TOTAL-AR-BALANCE     
           MOVE WS-CAR-TOTAL-UTL-BALANCE     TO WY-TOTAL-UTL-BAL        
           MOVE WS-CAR-TOTAL-NONUTL-BALANCE  TO WY-TOTAL-NONUTL-BAL     
           MOVE WS-CAR-UTL-ARREARS-AMT       TO WY-UTL-ARREARS-AMT      
           MOVE WS-CAR-NONUTL-ARREARS-AMT    TO WY-NONUTL-ARREARS-AMT   
           MOVE WS-CAR-USER-ID               TO X1-LAST-UPDATE-USERID   
                                                WY-LAST-UPDATE-USERID   
                                                WS-USER-ID              
P0726C                                          WS-KR136-USER-ID        
           MOVE WS-CURRENT-TIMESTAMP         TO WY-ARNG-HIST-TS         
                                                X1-LAST-UPDATE-TS       
                                                WX-LAST-UPDATE-TS       
                                                WX-LAST-UPDATE-TS       
                                                WY-LAST-UPDATE-TS       
           MOVE WS-CRED-COMMENTS-TEXT        TO WY-CHANGE-COMMENTS-TEXT 
           MOVE WS-CRED-COMMENTS-LEN         TO WY-CHANGE-COMMENTS-LEN. 
P0726C     MOVE WS-CAR-ORIGINAL-DNP-DATE     TO X1-ORIGINAL-DNP-DT      
P0726C                                       WS-KR136-ORIGINAL-DNP-DATE.
P0726C     MOVE WS-CAR-ORIGINAL-DNP-TYPE     TO                         
P0726C                                       WS-KR136-ORIGINAL-DNP-TYPE.
P0726C     MOVE WS-CAR-FIRST-NOT-MAIL-DT     TO X1-FIRST-NOT-MAIL-DT    
P0726C                                       WS-KR136-FIRST-NOT-MAIL-DT.
P0726C     MOVE WS-CAR-FINAL-NOT-MAIL-DT     TO X1-FINAL-NOT-MAIL-DT    
P0726C                                       WS-KR136-FINAL-NOT-MAIL-DT.
P0726C     MOVE WS-CAR-NEW-DNP-DATE          TO WS-KR136-NEW-DNP-DATE   
P0726C                                          X1-ARNG-DNP-DT.         
      *                                                                         
       5310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 5320-CREATE-CONF-NO                                         *           
      *  MOVES THE 3 DIGIT JULIAN DATE TO THE 1ST 3 DIGITS OF THE   *           
      *     CONFIRMATION NUMBER.                                    *           
      *  CALCULATES THE RESULT FOR THE LAST 4 DIGITS OF THE         *           
      *     ACCOUNT NUMBER BY THE ARNG SEQUENCE NO.  THEN MOVES IT  *           
      *     TO THE LAST 6 DIGITS OF THE CONFIRMATION NUMBER.        *           
      *  MOVES LAST 4 DIGITS OF SSN.                                *           
      ***************************************************************           
       5320-CREATE-CONF-NO.                                             
      *                                                                         
           MOVE WS-JULIAN-DATE     TO WS-CONF-NO-JUL-DT                 
           MOVE '1'                TO WS-CONF-NO-TRANS-TYP              
      *                                                                         
           MOVE WS-ARNG-SEQ-NO     TO WS-ARNG-SEQ-NO-NUM                
           COMPUTE WS-CONF-NO-CALC =                                    
                         WS-ACCT-NO-NUM-L4 * WS-ARNG-SEQ-NO-NUM         
           MOVE WS-CONF-NO-LAST-B  TO WS-CONF-NO-LAST-6                 
      *                                                                         
           MOVE WS-CAR-SSN-LAST-4  TO WS-CONF-SSN-LAST-4                
      *                                                                         
           MOVE WS-CONFIRM-NO      TO WS-CONFIRMATION-NO.               
      *                                                                         
       5320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 5330-SETUP-PLAN                                             *           
      *                - INSERT INTO CSS_CRED_ARNGMENT              *           
      *                - INSERT INTO CSS_CRED_ARNG_HIST             *           
      *                - INSERT INTO CSS_CRED_ARNG_SCHD             *           
      *                - WRITE TRANSACTION HISTORY                  *           
      *                - UPDATE CODES DATA PRESENT VALUE            *           
      ***************************************************************           
SETUP  5330-SETUP-PLAN.                                                 
      *                                                                         
P0726C* Set codes data present based on arrangement during SETUP                
P0726C     IF WS-CAR-ARNG-TYPE = 'CDD' OR 'CDDA'                        
              MOVE 'A'             TO WS-CODE-CRED-ARNG                 
P0726C     ELSE                                                         
P00948        IF WS-CAR-ARNG-TYPE = 'STA' OR 'STAA' OR 'STF' OR 'STFA'  
P0726C           MOVE 'A'          TO WS-CODE-STA-ACCT                  
P0726C        END-IF                                                    
P0726C     END-IF                                                       
P0726C                                                                  
P0726C* Populate Arrangement table values                                       
           PERFORM 5310-SETUP-PROCESS  THRU 5310-EXIT                   
      *                                                                         
           PERFORM 8400-INSERT-CRED-ARGMT      THRU 8400-EXIT           
           PERFORM 8500-INSERT-ARNG-SCHD       THRU 8500-EXIT           
           PERFORM 8600-INSERT-ARNG-HIST       THRU 8600-EXIT           
                                                                        
           IF WS-CAR-TRNS-HST-FL = 'Y'                                  
              PERFORM 5400-JRNL-TRAN-HEAD      THRU 5400-EXIT           
              PERFORM 5500-JRNL-UPDATE         THRU 5500-EXIT           
           END-IF                                                       
      *                                                                         
P00948*STA & STF  -  Forecasted credit rows will be inserted into               
P00948*              cred_coll table                                            
P00948*STAA & STFA - Forecasted rows will be inserted into                      
P00948*              cred_arng_actn table                                       
P00948     IF WS-CAR-ARNG-TYPE = 'STA' OR 'STAA' OR 'STF' OR 'STFA'     
P0726C        PERFORM 5000-STA-SETUP           THRU 5000-CPD136-EXIT    
P0726C        IF WS-CAR-FINAL-NOT-MAIL-DT > SPACES                      
P0726C         PERFORM 5640-JRNL-FINAL-NOTICE-DT         THRU 5640-EXIT 
P0726C        END-IF                                                    
P0726C                                                                  
P0726C        EVALUATE WS-CAR-ARNG-TYPE                                 
P0726C         WHEN 'STAA'                                              
P00948         WHEN 'STFA'                                              
P0726C              PERFORM 5660-JRNL-NEW-DNP-DATE       THRU 5660-EXIT 
P0726C         WHEN 'STA'                                               
P00948         WHEN 'SFA'                                               
P0726C              IF SEB-DATABASE                                     
P0726C                 PERFORM 5650-JRNL-ORIGINAL-DNP-DT THRU 5650-EXIT 
P0726F                 IF LR-REG-GROUP-CD = '100' AND                   
P0726F                    LR-SENIOR-FL = 'Y'                            
P0726F                    PERFORM 8900-DELETE-ACCT-ATTRIBUTE            
P0726F                                                   THRU 8900-EXIT 
P0726F                 END-IF                                           
P0726C              ELSE                                                
P0726C                 IF CSR-DATABASE                                  
P0726C                    PERFORM 5650-JRNL-ORIGINAL-DNP-DT             
P0726C                                                   THRU 5650-EXIT 
P0726C                    PERFORM 5660-JRNL-NEW-DNP-DATE THRU 5660-EXIT 
P0726C                 END-IF                                           
P0726C              END-IF                                              
P0726C        END-EVALUATE                                              
P0726C     END-IF.                                                      
           PERFORM 8700-UPDATE-CSS-ACCOUNT     THRU 8700-EXIT.          
P0726C     PERFORM 5400-CANCEL-DNP             THRU 5400-CPD136-EXIT.   
      *                                                                         
       5330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
MAINT * 5340-MAINT-PLAN.                                               *        
      * MAINTANANCE PROCESS -CRED-ARNGMENT - UPDATE STATUS TO CANCEL   *        
      *                     -CRED-ARNGMENT - UPDATE COMPLIANCE CODE    *        
      *                     -CRED-ARNG-HIST- INSERT HIST ROW.          *        
      *                     -CSS_ACCOUNT - UPDATE SPACES TO 32 POS CPD *        
      ******************************************************************        
       5340-MAINT-PLAN.                                                 
      *                                                                         
CALL68     PERFORM 5350-CALL-MCSCB068          THRU 5350-EXIT           
           PERFORM 5370-MAINT-PROCESS          THRU 5370-EXIT           
      *                                                                         
SELARG     PERFORM 7200-SELECT-CRED-ARNGMENT      THRU 7200-EXIT        
      *                                                                         
P0726C*Arrangement Cancel Process                                               
P0726B     IF WS-CAR-TRNS-HST-FL = 'Y' AND WS-CAR-ARNG-STATUS-CD = 'R'  
P0726B        MOVE 0                      TO WS-KR360-PREMISE-NO        
P0726B                                       WS-KR360-CUSTOMER-NO       
P0726B        MOVE WS-RESP-AREA-ID        TO WS-KR360-RESP-AREA-ID      
P0726B        MOVE WS-CAR-USER-ID         TO WS-KR360-USER-ID           
P0726B        MOVE 'F'                    TO WS-KR360-CODE-TRAN-TYPE    
P0726B        MOVE WS-CRED-COMMENTS-TEXT  TO WS-KR360-COMMENT-TEXT      
P0726B        MOVE WS-CRED-COMMENTS-LEN   TO WS-KR360-COMMENT-LEN       
P0726B        PERFORM 5100-CNCL-CRED-ARNG-PROCESS                       
P0726B                                    THRU 5100-CPD360-EXIT         
P0726C        PERFORM 5200-DEL-CRED-ARNG-ACTN-ROWS                      
P0726C                                    THRU 5200-CPD137-EXIT         
P0726B     ELSE                                                         
P0726C*Arrangement Complete Process                                             
MNTROW        IF WS-CAR-TRNS-HST-FL = 'Y' AND                           
                 ( WS-CAR-ARNG-STATUS-CD NOT = X1-ARNG-STATUS-CD OR     
                   WS-CAR-ARNG-COMPL-CD  NOT = X1-ARNG-COMPLIANCE-CD )  
      *                                                                         
                 PERFORM 5400-JRNL-TRAN-HEAD         THRU 5400-EXIT     
      *                                                                         
P0726C           PERFORM 5690-JRNL-ARNG-ID           THRU 5690-EXIT     
P0726C           PERFORM 5680-JRNL-ARNG-TYPE         THRU 5680-EXIT     
                 IF WS-CAR-ARNG-STATUS-CD NOT = X1-ARNG-STATUS-CD       
                    PERFORM 5610-JRNL-ARNG-STATUS    THRU 5610-EXIT     
                 END-IF                                                 
      *                                                                         
                 IF WS-CAR-ARNG-COMPL-CD  NOT = X1-ARNG-COMPLIANCE-CD   
                    PERFORM 5620-ARNG-COMPLIANCE     THRU 5620-EXIT     
                 END-IF                                                 
      *                                                                         
P0726C           PERFORM 5630-JRNL-CRED-ARNG-SEQ     THRU 5630-EXIT     
P0726C           IF X1-ARNG-TYPE    = 'CDD' OR 'CDDA'                   
                    MOVE SPACES             TO WS-CODE-CRED-ARNG        
P0726C           ELSE                                                   
P00948              IF X1-ARNG-TYPE = 'STA' OR 'STAA' OR 'STF' OR 'STFA'
P0726C                 MOVE SPACES          TO WS-CODE-STA-ACCT         
P0726C              END-IF                                              
P0726C           END-IF                                                 
ATCDP            PERFORM 8700-UPDATE-CSS-ACCOUNT     THRU 8700-EXIT     
P0726C           PERFORM 5200-DEL-CRED-ARNG-ACTN-ROWS                   
P0726C                                    THRU 5200-CPD137-EXIT         
P0726E           PERFORM 8600-INSERT-ARNG-HIST       THRU 8600-EXIT     
P0726E           PERFORM 8800-UPDATE-CRED-ARNGMENT   THRU 8800-EXIT     
              END-IF                                                    
P0726B     END-IF.                                                      
      *                                                                         
       5340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5350-CALL-MCSCB068.                                            *        
      ******************************************************************        
      *                                                                         
MAINT  5350-CALL-MCSCB068.                                              
      *                                                                         
           MOVE WS-CURRENT-DATE              TO WS-HOLD-DATE            
      *                                                                         
      * Set CPD00068 Switches that are needed                                   
      *                                                                         
           MOVE 'Y' TO CALC-BALANCE-SW                                  
                       CALC-ARREARS-SW                                  
                       LOAD-DNP-DATE-SW                                 
                       LOAD-DUE-DATES-SW                                
                       CALC-PAST-DUE-SW                                 
      *                                                                         
           MOVE PROGRAM-NAME                 TO WS-CPD00068-CALLING-PGM 
           MOVE SPACES                       TO ABEND-FUNCTION          
           PERFORM 5360-CALL-MCSCB068        THRU 5360-EXIT.            
      *                                                                         
       5350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5360-CALL-MCSCB068.                                            *        
      ******************************************************************        
      *                                                                         
MAINT  5360-CALL-MCSCB068.                                              
      *                                                                         
           CALL MCSCB068  USING  CWS00068-FIELDS                        
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
      *                                                                         
           MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                               SQLCODE.                 
      *                                                                         
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                    TO RS-RETURN-CODE           
                                               WS-ACTIVE-RETURN-CODE    
              END-IF                                                    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '5360'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CALL'                   TO ABEND-FUNCTION           
              MOVE 'MCSCB068'               TO TABLE-1                  
              MOVE 12                       TO RS-RETURN-CODE           
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
      *                                                                         
       5360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5370-MAINT-PROCESS.                                            *        
      *------< MOVE ALL OTHER FIELDS READY FOR X1-UPDATE / WY-INSERT >          
      ******************************************************************        
MAINT  5370-MAINT-PROCESS.                                              
      *                                                                         
           MOVE WS-CAR-ARNG-ID               TO X1-ARNG-ID              
                                                WY-ARNG-ID              
P0726C                                          WX-ARNG-ID              
           MOVE WS-ARNG-SEQ-NO               TO X1-CRED-ARNG-SEQ        
                                                WY-CRED-ARNG-SEQ        
P0726C                                          WX-CRED-ARNG-SEQ        
P0626C                                          WS-AGREEMENT-NO         
           MOVE WS-CURRENT-TIMESTAMP         TO WY-ARNG-HIST-TS         
                                                WY-LAST-UPDATE-TS       
                                                X1-LAST-UPDATE-TS       
      *                                                                         
           MOVE -1                           TO WS-DUE-DT-NULL-IND      
P0726A                                          WS-SCHD-SEQ-NULL-IND    
           MOVE 'M'                          TO WY-ARNG-CHANGE-CD       
CPD68 *                                                                         
           MOVE WS-TOTAL-BALANCE             TO WY-TOTAL-AR-BALANCE     
P0726E                                          WS-KR360-TOTAL-AR-BAL.  
           MOVE WS-TOTAL-BALANCE-UTL         TO WY-TOTAL-UTL-BAL        
P0726E                                          WS-KR360-TOTAL-UTL-BAL. 
           MOVE WS-TOTAL-BALANCE-NONUTL      TO WY-TOTAL-NONUTL-BAL     
P0726E                                          WS-KR360-TOT-NONUTL-BAL.
           MOVE WS-AMT-ARREARS-UTL           TO WY-UTL-ARREARS-AMT      
P0726E                                          WS-KR360-UTL-ARR-AMT.   
           MOVE WS-AMT-ARREARS-NONUTL        TO WY-NONUTL-ARREARS-AMT   
P0726E                                          WS-KR360-NONUTL-ARR-AMT.
      *                                                                         
           MOVE WS-CRED-COMMENTS-TEXT        TO WY-CHANGE-COMMENTS-TEXT 
           MOVE WS-CRED-COMMENTS-LEN         TO WY-CHANGE-COMMENTS-LEN  
           MOVE WS-CAR-USER-ID               TO X1-LAST-UPDATE-USERID   
                                                WY-LAST-UPDATE-USERID   
                                                WS-USER-ID.             
      *                                                                         
       5370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726B****************************************************************          
P0726B* 5380-PROCESS-ARNG-PALN-DESC                                  *          
P0726B* Get current and replaced plan description.                   *          
P0726B****************************************************************          
P0726B                                                                  
P0726B 5380-PROCESS-ARNG-PALN-DESC.                                     
P0726B                                                                  
P0726B     MOVE SPACES                  TO WS-KR135-ARNG-ID             
P0726B                                     WS-KR135-CURR-ARNG-ID        
P0726B                                     WS-KR135-CURR-PLAN-DESC      
P0726B                                     WS-KR135-OVRRDE-PLAN-DESC.   
P0726B                                                                  
P0726B     PERFORM 7830-SEL-CURR-ARNG-ID      THRU 7830-EXIT.           
P0726B     MOVE WS-KR135-CURR-ARNG-ID   TO WS-KR135-ARNG-ID.            
P0726B     PERFORM 7810-SEL-ARNG-PLAN-DESC    THRU 7810-EXIT.           
P0726B     MOVE UF-ARNG-PLAN-DESC       TO WS-KR135-CURR-PLAN-DESC.     
P0726B                                                                  
P0726B     MOVE WS-CAR-ARNG-ID          TO WS-KR135-ARNG-ID.            
P0726B     PERFORM 7810-SEL-ARNG-PLAN-DESC    THRU 7810-EXIT.           
P0726B     MOVE UF-ARNG-PLAN-DESC       TO WS-KR135-OVRRDE-PLAN-DESC.   
P0726B                                                                  
P0726B     STRING 'ACTIVE '                  DELIMITED BY SIZE,         
P0726B             WS-KR135-CURR-PLAN-DESC   DELIMITED BY SIZE,         
P0726B             ' PLAN '                  DELIMITED BY SIZE,         
P0726B             'WAS CANCELLED AND NEW '  DELIMITED BY SIZE,         
P0726B             WS-KR135-OVRRDE-PLAN-DESC DELIMITED BY SIZE,         
P0726B             ' PLAN HAS BEEN SETUP.'   DELIMITED BY SIZE,         
P0726B                                  INTO WS-KR360-COMMENT-TEXT      
P0726B     MOVE LENGTH OF WS-KR360-COMMENT-TEXT                         
P0726B                                  TO WS-KR360-COMMENT-LEN         
P0726B     INSPECT WS-KR360-COMMENT-TEXT REPLACING ALL LOW-VALUES       
P0726B                                   BY SPACES                      
P0726B     MOVE SPACES                  TO WS-EMB-INPUT,                
P0726B                                     WS-CMP-TABLE.                
P0726B     MOVE WS-KR360-COMMENT-LEN    TO WS-EMB-LENG.                 
P0726B     MOVE WS-KR360-COMMENT-TEXT   TO WS-EMB-INPUT.                
P0726B     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
P0726B                                                                  
P0726B 5380-EXIT.                                                       
P0726B     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * JOURNALLING BEGINS HERE                                        *        
      *   5400-JRNL-TRAN-HEAD.                                         *        
      ******************************************************************        
       5400-JRNL-TRAN-HEAD.                                             
      *                                                                         
           INITIALIZE DCLCSS-MNT-TRANS-HIST                             
                      DCLCSS-MT-TRN-HST-DET                             
      *                                                                         
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS               
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO        
           PERFORM 7500-SELECT-RESP-AREA      THRU 7500-EXIT            
      *                                                                         
           MOVE 1                        TO WS-TRAN-APPL-NO             
                                            MI-TRAN-APPL-NO             
      *                                                                         
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE           
           MOVE WS-RESP-AREA-ID          TO MH-RESP-AREA-ID             
           MOVE AT-ACCOUNT-NO            TO MH-ACCOUNT-NO               
           MOVE ZEROS                    TO MH-CUSTOMER-NO              
           MOVE ZEROS                    TO MH-PREMISE-NO               
           MOVE WS-USER-ID               TO MH-USER-ID                  
           MOVE 'PANEL300'               TO MH-APPL-PROGRAM-ID          
           MOVE +0                       TO MH-TRAN-COMMENT-LEN         
           MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT.       
      *                                                                         
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726C****************************************************************          
P0726C* 5410-JRNL-STA-COMMENTS                                       *          
P0726C****************************************************************          
P0726C                                                                  
P0726C 5410-JRNL-STA-COMMENTS.                                          
P0726C                                                                  
P0726C     MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
P0726C     MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO            
P0726C     IF WS-CAR-COMMENTS-TEXT       > SPACES                       
P0726C        MOVE WS-CAR-COMMENTS-TEXT   TO MI-CHG-COLUMN-VALUE-TEXT   
P0726C        IF WS-CAR-COMMENTS-LEN     > +75                          
P0726C           MOVE +75                 TO MI-CHG-COLUMN-VALUE-LEN    
P0726C        ELSE                                                      
P0726C           MOVE WS-CAR-COMMENTS-LEN                               
P0726C                                    TO MI-CHG-COLUMN-VALUE-LEN    
P0726C        END-IF                                                    
P0726C        MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
P0726C        MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
P0726C        MOVE 'STA COMMENTS'         TO MI-COLUMN-DESC             
P0726C                                                                  
P0726C        PERFORM 6530-LOAD-MNT-TRANS-HIST           THRU 6530-EXIT 
P0726C        ADD 1                       TO WS-TRAN-APPL-NO            
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 5410-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C****************************************************************          
P0726C* 5420-JRNL-NEXT-DNP-DATE                                      *          
P0726C****************************************************************          
P0726C                                                                  
P0726C 5420-JRNL-NEXT-DNP-DATE.                                         
P0726C                                                                  
P0726C     MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
P0726C     MOVE WS-ARNG-DNP-DT            TO WS-DATE-HOLD.              
P0726C     PERFORM 7800-GET-USA-DATE                     THRU 7800-EXIT.
P0726C                                                                  
P0726C     IF WS-ARNG-DNP-DT-OLD NOT = WS-DATE-HOLD-USA                 
P0726C        MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
P0726C        IF WS-ARNG-DNP-DT     > SPACES                            
P0726C           MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
P0726C           MOVE WS-DATE-HOLD-USA    TO MI-CHG-COLUMN-VALUE-TEXT   
P0726C        END-IF                                                    
P0726C                                                                  
P0726C        IF WS-ARNG-DNP-DT-OLD > SPACES                            
P0726C           MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN    
P0726C           MOVE WS-ARNG-DNP-DT-OLD  TO MI-PRV-COLUMN-VALUE-TEXT   
P0726C        ELSE                                                      
P0726C           MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
P0726C           MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
P0726C        END-IF                                                    
P0726C                                                                  
P0726C        MOVE 'ARNG DNP DATE'        TO MI-COLUMN-DESC             
P0726C        PERFORM 6530-LOAD-MNT-TRANS-HIST           THRU 6530-EXIT 
P0726C        ADD 1                       TO WS-TRAN-APPL-NO            
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 5420-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C****************************************************************          
P0726C* 5430-JRNL-DATE-SCND-NOTICE                                   *          
P0726C****************************************************************          
P0726C                                                                  
P0726C 5430-JRNL-DATE-SCND-NOTICE.                                      
P0726C                                                                  
P0726C     MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
P0726C     MOVE WS-FINAL-NOT-MAIL-DT      TO WS-DATE-HOLD.              
P0726C     PERFORM 7800-GET-USA-DATE                     THRU 7800-EXIT.
P0726C                                                                  
P0726C     IF WS-FINAL-NOT-MAIL-OLD   NOT = WS-DATE-HOLD-USA            
P0726C        MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
P0726C        IF WS-DATE-HOLD-USA > SPACES                              
P0726C           MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
P0726C           MOVE WS-DATE-HOLD-USA    TO MI-CHG-COLUMN-VALUE-TEXT   
P0726C        END-IF                                                    
P0726C                                                                  
P0726C        IF WS-FINAL-NOT-MAIL-OLD   > SPACES                       
P0726C           MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN    
P0726C           MOVE WS-FINAL-NOT-MAIL-OLD  TO MI-PRV-COLUMN-VALUE-TEXT
P0726C        ELSE                                                      
P0726C           MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
P0726C           MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
P0726C        END-IF                                                    
P0726C                                                                  
P0726C        MOVE 'DATE SCND NOTICE'     TO MI-COLUMN-DESC             
P0726C        PERFORM 6530-LOAD-MNT-TRANS-HIST           THRU 6530-EXIT 
P0726C        ADD 1                       TO WS-TRAN-APPL-NO            
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 5430-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C****************************************************************          
P0726C* 5440-JRNL-ARNG-DUE-DATE                                      *          
P0726C****************************************************************          
P0726C                                                                  
P0726C 5440-JRNL-ARNG-DUE-DATE.                                         
P0726C                                                                  
P0726C     MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
P0726C     MOVE WS-ARNG-DUE-DT            TO WS-DATE-HOLD.              
P0726C     PERFORM 7800-GET-USA-DATE                     THRU 7800-EXIT.
P0726C                                                                  
P0726C     IF WS-ARNG-SCHD-DUE-DT-OLD NOT = WS-DATE-HOLD-USA            
P0726C        MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
P0726C        IF WS-DATE-HOLD-USA > SPACES                              
P0726C           MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
P0726C           MOVE WS-DATE-HOLD-USA    TO MI-CHG-COLUMN-VALUE-TEXT   
P0726C        END-IF                                                    
P0726C                                                                  
P0726C        IF WS-ARNG-SCHD-DUE-DT-OLD > SPACES                       
P0726C           MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN    
P0726C           MOVE WS-ARNG-SCHD-DUE-DT-OLD                           
P0726C                                    TO MI-PRV-COLUMN-VALUE-TEXT   
P0726C        ELSE                                                      
P0726C           MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
P0726C           MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
P0726C        END-IF                                                    
P0726C                                                                  
P0726C        MOVE 'ARNG DUE DATE'        TO MI-COLUMN-DESC             
P0726C        PERFORM 6530-LOAD-MNT-TRANS-HIST           THRU 6530-EXIT 
P0726C        ADD 1                       TO WS-TRAN-APPL-NO            
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 5440-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
      ***************************************************************           
      * 5500-JRNL-UPDATE                                            *           
      ***************************************************************           
       5500-JRNL-UPDATE.                                                
      *                                                                         
           MOVE '5500' TO ACTIVE-PARAGRAPH                              
      *                                                                         
           PERFORM 5510-JRNL-ARNG-PLAN-TYPE      THRU 5510-EXIT         
           PERFORM 5520-JRNL-ARNG-AMOUNT         THRU 5520-EXIT         
           PERFORM 5530-JRNL-ARNG-DUE-DT         THRU 5530-EXIT         
           PERFORM 5540-JRNL-ARNG-ID             THRU 5540-EXIT         
           PERFORM 5550-JRNL-ARNG-USERID         THRU 5550-EXIT         
           PERFORM 5560-JRNL-ARNG-STATUS         THRU 5560-EXIT         
           PERFORM 5570-JRNL-ARNG-SEQ-NO         THRU 5570-EXIT         
           PERFORM 5580-JRNL-CONFIRMATION-NO     THRU 5580-EXIT         
           PERFORM 5590-JRNL-ARNG-COMMENTS       THRU 5590-EXIT.        
      *                                                                         
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5510-JRNL-ARNG-PLAN-TYPE.                                    *          
      ****************************************************************          
       5510-JRNL-ARNG-PLAN-TYPE.                                        
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO            
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
           MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN         
           MOVE WS-CAR-ARNG-TYPE     TO MI-CHG-COLUMN-VALUE-TEXT        
           MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN         
           MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT        
           MOVE 'ARNG PLAN TYPE'     TO MI-COLUMN-DESC                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1 TO WS-TRAN-APPL-NO.                                    
      *                                                                         
       5510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5520-JRNL-ARNG-AMOUNT.                                       *          
      ****************************************************************          
       5520-JRNL-ARNG-AMOUNT.                                           
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO           
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO                
           MOVE +14                   TO MI-CHG-COLUMN-VALUE-LEN        
           MOVE WS-CAR-ARNG-TOTAL-AMT TO WS-COMP-2-CHAR-CONV            
           MOVE WS-COMP-2-CHAR-CONV   TO MI-CHG-COLUMN-VALUE-TEXT       
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN        
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT       
           MOVE 'ARNG AMOUNT'         TO MI-COLUMN-DESC                 
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1 TO WS-TRAN-APPL-NO.                                    
      *                                                                         
       5520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5530-JRNL-ARNG-DUE-DT.                                       *          
      ****************************************************************          
       5530-JRNL-ARNG-DUE-DT.                                           
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO            
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
           MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN         
           MOVE WS-ARNG-DUE-DT-USA   TO MI-CHG-COLUMN-VALUE-TEXT        
           MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN         
           MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT        
           MOVE 'ARNG DUE DATE'      TO MI-COLUMN-DESC                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1 TO WS-TRAN-APPL-NO.                                    
      *                                                                         
       5530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5540-JRNL-ARNG-ID                                            *          
      ****************************************************************          
       5540-JRNL-ARNG-ID.                                               
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO            
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
           MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN         
           MOVE WS-CAR-ARNG-ID       TO MI-CHG-COLUMN-VALUE-TEXT        
           MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN         
           MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT        
           MOVE 'ARNG ID'            TO MI-COLUMN-DESC                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1 TO WS-TRAN-APPL-NO.                                    
      *                                                                         
       5540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5550-JRNL-ARNG-USERID.                                       *          
      ****************************************************************          
       5550-JRNL-ARNG-USERID.                                           
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
           MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN         
           MOVE WS-USER-ID           TO MI-CHG-COLUMN-VALUE-TEXT        
           MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN         
           MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT        
           MOVE 'USER ID'            TO MI-COLUMN-DESC                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1 TO WS-TRAN-APPL-NO.                                    
      *                                                                         
       5550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5560-JRNL-ARNG-STATUS.                                       *          
      ****************************************************************          
       5560-JRNL-ARNG-STATUS.                                           
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
           MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN         
           MOVE 'ACTIVE'             TO MI-CHG-COLUMN-VALUE-TEXT        
           MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN         
           MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT        
           MOVE 'STATUS'             TO MI-COLUMN-DESC                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1                     TO WS-TRAN-APPL-NO.                
      *                                                                         
       5560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5570-JRNL-ARNG-SEQ-NO.                                       *          
      ****************************************************************          
       5570-JRNL-ARNG-SEQ-NO.                                           
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO            
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
           MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN         
           MOVE WS-ARNG-SEQ-NO       TO MI-CHG-COLUMN-VALUE-TEXT        
           MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN         
           MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT        
           MOVE 'ARNG SEQ NO'        TO MI-COLUMN-DESC                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1 TO WS-TRAN-APPL-NO.                                    
      *                                                                         
       5570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5580-JRNL-CONFIRMATION-NO.                                   *          
      ****************************************************************          
       5580-JRNL-CONFIRMATION-NO.                                       
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO            
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
           MOVE +20                  TO MI-CHG-COLUMN-VALUE-LEN         
           MOVE WS-CONFIRMATION-NO   TO MI-CHG-COLUMN-VALUE-TEXT        
           MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN         
           MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT        
           MOVE 'CONFIRMATION#'      TO MI-COLUMN-DESC                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1 TO WS-TRAN-APPL-NO.                                    
      *                                                                         
       5580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5590-JRNL-ARNG-COMMENTS.                                     *          
      ****************************************************************          
       5590-JRNL-ARNG-COMMENTS.                                         
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO             
           IF WS-CRED-COMMENTS-TEXT > SPACES                            
              MOVE WS-CRED-COMMENTS-TEXT TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +70                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ARNG COMMENTS'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
      *                                                                         
       5590-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5610-JRNL-ARNG-STATUS.                                       *          
      ****************************************************************          
       5610-JRNL-ARNG-STATUS.                                           
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO                
           MOVE +20                   TO MI-CHG-COLUMN-VALUE-LEN        
                                         MI-PRV-COLUMN-VALUE-LEN        
           MOVE 'ARNG STATUS'         TO MI-COLUMN-DESC                 
      *                                                                         
           EVALUATE WS-CAR-ARNG-STATUS-CD                               
               WHEN 'A'                                                 
                  MOVE 'ACTIVE'       TO MI-CHG-COLUMN-VALUE-TEXT       
               WHEN 'C'                                                 
                  MOVE 'COMPLETE'     TO MI-CHG-COLUMN-VALUE-TEXT       
               WHEN 'R'                                                 
                  MOVE 'CANCEL'       TO MI-CHG-COLUMN-VALUE-TEXT       
               WHEN OTHER                                               
                  MOVE WS-CAR-ARNG-STATUS-CD TO MI-CHG-COLUMN-VALUE-TEXT
           END-EVALUATE                                                 
      *                                                                         
           EVALUATE X1-ARNG-STATUS-CD                                   
               WHEN 'A'                                                 
                  MOVE 'ACTIVE'       TO MI-PRV-COLUMN-VALUE-TEXT       
               WHEN 'C'                                                 
                  MOVE 'COMPLETE'     TO MI-PRV-COLUMN-VALUE-TEXT       
               WHEN 'R'                                                 
                  MOVE 'CANCEL'       TO MI-PRV-COLUMN-VALUE-TEXT       
               WHEN OTHER                                               
                  MOVE WS-CAR-ARNG-STATUS-CD TO MI-PRV-COLUMN-VALUE-TEXT
           END-EVALUATE                                                 
      *                                                                         
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1                      TO WS-TRAN-APPL-NO.               
      *                                                                         
       5610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5620-ARNG-COMPLIANCE.                                        *          
      ****************************************************************          
       5620-ARNG-COMPLIANCE.                                            
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO                
           MOVE +20                   TO MI-CHG-COLUMN-VALUE-LEN        
                                         MI-PRV-COLUMN-VALUE-LEN        
           MOVE 'COMPLIANCE'          TO MI-COLUMN-DESC                 
      *                                                                         
           IF WS-CAR-ARNG-COMPL-CD = 'N'                                
              MOVE 'NO'               TO MI-CHG-COLUMN-VALUE-TEXT       
           ELSE                                                         
              IF WS-CAR-ARNG-COMPL-CD = 'Y'                             
                 MOVE 'YES'           TO MI-CHG-COLUMN-VALUE-TEXT       
              ELSE                                                      
                 MOVE 'UNKNOWN'       TO MI-CHG-COLUMN-VALUE-TEXT       
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           IF X1-ARNG-COMPLIANCE-CD = 'N'                               
              MOVE 'NO'               TO MI-PRV-COLUMN-VALUE-TEXT       
           ELSE                                                         
              IF X1-ARNG-COMPLIANCE-CD = 'Y'                            
                 MOVE 'YES'           TO MI-PRV-COLUMN-VALUE-TEXT       
              ELSE                                                      
                 MOVE 'UNKNOWN'       TO MI-PRV-COLUMN-VALUE-TEXT       
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1                      TO WS-TRAN-APPL-NO.               
      *                                                                         
       5620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726C****************************************************************          
P0726C* 5630-JRNL-CRED-ARNG-SEQ                                      *          
P0726C****************************************************************          
P0726C                                                                  
P0726C 5630-JRNL-CRED-ARNG-SEQ.                                         
P0726C                                                                  
P0726C     MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
P0726C     MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
P0726C     MOVE WS-ARNG-SEQ-NO       TO WS-HOLD-ARNG-NO.                
P0726C     MOVE WS-HOLD-ARRANGEMENT  TO MI-COLUMN-DESC.                 
P0726C     MOVE SPACE                TO MI-PRV-COLUMN-VALUE-TEXT        
P0726C                                  MI-CHG-COLUMN-VALUE-TEXT.       
P0726C     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
P0726C     ADD 1                     TO WS-TRAN-APPL-NO.                
P0726C                                                                  
P0726C 5630-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C****************************************************************          
P0726C* 5640-JRNL-FINAL-NOTICE-DT                                    *          
P0726C****************************************************************          
P0726C 5640-JRNL-FINAL-NOTICE-DT.                                       
P0726C*                                                                         
P0726C     MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO            
P0726C     MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
P0726C     IF WS-CAR-FINAL-NOT-MAIL-DT > SPACES                         
P0726C        MOVE WS-CAR-FINAL-NOT-MAIL-DT                             
P0726C                               TO WS-DATE-HOLD                    
P0726C        PERFORM 7800-GET-USA-DATE     THRU 7800-EXIT              
P0726C        MOVE WS-DATE-HOLD-USA  TO MI-CHG-COLUMN-VALUE-TEXT        
P0726C     ELSE                                                         
P0726C        MOVE SPACES            TO MI-CHG-COLUMN-VALUE-TEXT        
P0726C     END-IF.                                                      
P0726C     MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN.        
P0726C     MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN.        
P0726C     MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT.       
P0726C     MOVE 'DATE SCND NOTICE'   TO MI-COLUMN-DESC.                 
P0726C     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
P0726C     ADD 1 TO WS-TRAN-APPL-NO.                                    
P0726C*                                                                         
P0726C 5640-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C****************************************************************          
P0726C* 5650-JRNL-ORIGINAL-DNP-DT                                    *          
P0726C****************************************************************          
P0726C 5650-JRNL-ORIGINAL-DNP-DT.                                       
P0726C*                                                                         
P0726C     MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO            
P0726C     MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
P0726C     IF WS-CAR-ORIGINAL-DNP-DATE > SPACES                         
P0726C        MOVE WS-CAR-ORIGINAL-DNP-DATE                             
P0726C                               TO WS-DATE-HOLD                    
P0726C        PERFORM 7800-GET-USA-DATE     THRU 7800-EXIT              
P0726C        MOVE WS-DATE-HOLD-USA  TO MI-CHG-COLUMN-VALUE-TEXT        
P0726C     ELSE                                                         
P0726C        MOVE SPACES            TO MI-CHG-COLUMN-VALUE-TEXT        
P0726C     END-IF.                                                      
P0726C     MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN.        
P0726C     MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN.        
P0726C     MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT.       
P0726C     MOVE 'FORCST DNP DATE'    TO MI-COLUMN-DESC.                 
P0726C     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
P0726C     ADD 1 TO WS-TRAN-APPL-NO.                                    
P0726C*                                                                         
P0726C 5650-EXIT.                                                       
P0726C     EXIT.                                                        
      *                                                                         
P0726C****************************************************************          
P0726C* 5660-JRNL-NEW-DNP-DATE.                                      *          
P0726C****************************************************************          
P0726C 5660-JRNL-NEW-DNP-DATE.                                          
P0726C*                                                                         
P0726C     MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO            
P0726C     MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
P0726C     IF WS-CAR-NEW-DNP-DATE > SPACES                              
P0726C        MOVE WS-CAR-NEW-DNP-DATE                                  
P0726C                               TO WS-DATE-HOLD                    
P0726C        PERFORM 7800-GET-USA-DATE     THRU 7800-EXIT              
P0726C        MOVE WS-DATE-HOLD-USA  TO MI-CHG-COLUMN-VALUE-TEXT        
P0726C     ELSE                                                         
P0726C        MOVE SPACES            TO MI-CHG-COLUMN-VALUE-TEXT        
P0726C     END-IF.                                                      
P0726C     MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN.        
P0726C     MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN.        
P0726C     MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT.       
P0726C     MOVE 'NEXT DNP DATE'      TO MI-COLUMN-DESC.                 
P0726C     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
P0726C     ADD 1 TO WS-TRAN-APPL-NO.                                    
P0726C*                                                                         
P0726C 5660-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C*                                                                         
P0726C****************************************************************          
P0726C* 5670-JRNL-AGREEMENT-NO                                       *          
P0726C****************************************************************          
P0726C                                                                  
P0726C 5670-JRNL-AGREEMENT-NO.                                          
P0726C                                                                  
P0726C     MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
P0726C     MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
P0726C     MOVE WS-AGREEMENT-NO      TO WS-HOLD-AGREE-NO.               
P0726C     MOVE WS-HOLD-AGREEMENT    TO MI-COLUMN-DESC.                 
P0726C     MOVE SPACE                TO MI-PRV-COLUMN-VALUE-TEXT.       
P0726C     MOVE SPACE                TO MI-CHG-COLUMN-VALUE-TEXT.       
P0726C     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
P0726C     ADD 1                     TO WS-TRAN-APPL-NO.                
P0726C                                                                  
P0726C 5670-EXIT.                                                       
P0726c     EXIT.                                                        
P0726C                                                                  
P0726C****************************************************************          
P0726C* 5680-JRNL-ARNG-TYPE                                          *          
P0726C****************************************************************          
P0726C                                                                  
P0726C 5680-JRNL-ARNG-TYPE.                                             
P0726C                                                                  
P0726C     MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
P0726C     MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
P0726C     MOVE 'ARNG TYPE'          TO MI-COLUMN-DESC.                 
P0726C     MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN.        
P0726C     MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
P0726C                               TO MI-PRV-COLUMN-VALUE-LEN.        
P0726C     MOVE X1-ARNG-TYPE         TO MI-PRV-COLUMN-VALUE-TEXT.       
P0726C     MOVE '*COMPLETED*'        TO MI-CHG-COLUMN-VALUE-TEXT.       
P0726C     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
P0726C     ADD 1                     TO WS-TRAN-APPL-NO.                
P0726C                                                                  
P0726C 5680-EXIT.                                                       
P0726c     EXIT.                                                        
P0726C                                                                  
P0726C****************************************************************          
P0726C* 5690-JRNL-ARNG-ID                                            *          
P0726C****************************************************************          
P0726C                                                                  
P0726C 5690-JRNL-ARNG-ID.                                               
P0726C                                                                  
P0726C     MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
P0726C     MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
P0726C     MOVE 'ARNG ID'            TO MI-COLUMN-DESC.                 
P0726C     MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN.        
P0726C     MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN.        
P0726C     MOVE WS-CAR-ARNG-ID       TO MI-PRV-COLUMN-VALUE-TEXT.       
P0726C     MOVE '*COMPLETED*'        TO MI-CHG-COLUMN-VALUE-TEXT.       
P0726C     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
P0726C     ADD 1                     TO WS-TRAN-APPL-NO.                
P0726C                                                                  
P0726C 5690-EXIT.                                                       
P0726c     EXIT.                                                        
P0726C                                                                  
      ******************************************************************        
      *  7200-SELECT-CRED-ARNGMENT                                     *31850000
      *     SELECTS CSS_CRED_ARNGMENT                                  *        
      ******************************************************************        
      *                                                                         
       7200-SELECT-CRED-ARNGMENT.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT X1.ARNG_TYPE                                       
                    ,X1.ARNG_CHANNEL_CD                                 
                    ,X1.INSTALLMENT_FL                                  
                    ,X1.ARNG_START_DT                                   
                    ,X1.ARNG_TOTAL_AMT                                  
                    ,X1.ARNG_CONFIRM_NO                                 
                    ,X1.ARNG_SETUP_DT                                   
                    ,X1.ARNG_NO_INSTALL                                 
                    ,X1.ARNG_COMPLIANCE_CD                              
                    ,X1.ARNG_STATUS_CD                                  
                    ,X1.ORIGINAL_DUE_DT                                 
P0726C              ,CIS.CHAR2$DATE(X1.FINAL_NOT_MAIL_DT,'USA')               
P0726C              ,CIS.CHAR2$DATE(X1.ARNG_DNP_DT,'USA')                     
                INTO :X1-ARNG-TYPE                                      
                    ,:X1-ARNG-CHANNEL-CD                                
                    ,:X1-INSTALLMENT-FL                                 
                    ,:X1-ARNG-START-DT                                  
                    ,:X1-ARNG-TOTAL-AMT                                 
                    ,:X1-ARNG-CONFIRM-NO                                
                    ,:X1-ARNG-SETUP-DT                                  
                    ,:X1-ARNG-NO-INSTALL                                
                    ,:X1-ARNG-COMPLIANCE-CD                             
                    ,:X1-ARNG-STATUS-CD                                 
                    ,:X1-ORIGINAL-DUE-DT                                
P0726C              ,:WS-FINAL-NOT-MAIL-OLD :WS-FINAL-NOT-MAIL-DT-NULL  
P0726C              ,:WS-ARNG-DNP-DT-OLD :WS-ARNG-DNP-DT-NULL        
                FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                 
               WHERE ACCOUNT_NO     = :X1-ACCOUNT-NO                    
                 AND ARNG_ID        = :X1-ARNG-ID                       
                 AND CRED_ARNG_SEQ  = :X1-CRED-ARNG-SEQ                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*       SELECT X1.ARNG_TYPE                                               
MFA-TR*             ,X1.ARNG_CHANNEL_CD                                         
MFA-TR*             ,X1.INSTALLMENT_FL                                          
MFA-TR*             ,X1.ARNG_START_DT                                           
MFA-TR*             ,X1.ARNG_TOTAL_AMT                                          
MFA-TR*             ,X1.ARNG_CONFIRM_NO                                         
MFA-TR*             ,X1.ARNG_SETUP_DT                                           
MFA-TR*             ,X1.ARNG_NO_INSTALL                                         
MFA-TR*             ,X1.ARNG_COMPLIANCE_CD                                      
MFA-TR*             ,X1.ARNG_STATUS_CD                                          
MFA-TR*             ,X1.ORIGINAL_DUE_DT                                         
MFA-TR*             ,CHAR(DATE(X1.FINAL_NOT_MAIL_DT),USA)                       
MFA-TR*             ,CHAR(DATE(X1.ARNG_DNP_DT),USA)                             
MFA-TR*         INTO :X1-ARNG-TYPE                                      32260000
MFA-TR*             ,:X1-ARNG-CHANNEL-CD                                        
MFA-TR*             ,:X1-INSTALLMENT-FL                                         
MFA-TR*             ,:X1-ARNG-START-DT                                          
MFA-TR*             ,:X1-ARNG-TOTAL-AMT                                         
MFA-TR*             ,:X1-ARNG-CONFIRM-NO                                        
MFA-TR*             ,:X1-ARNG-SETUP-DT                                          
MFA-TR*             ,:X1-ARNG-NO-INSTALL                                        
MFA-TR*             ,:X1-ARNG-COMPLIANCE-CD                                     
MFA-TR*             ,:X1-ARNG-STATUS-CD                                         
MFA-TR*             ,:X1-ORIGINAL-DUE-DT                                        
MFA-TR*             ,:WS-FINAL-NOT-MAIL-OLD :WS-FINAL-NOT-MAIL-DT-NULL          
MFA-TR*             ,:WS-ARNG-DNP-DT-OLD    :WS-ARNG-DNP-DT-NULL                
MFA-TR*         FROM CSS_CRED_ARNGMENT X1                               32390000
MFA-TR*        WHERE ACCOUNT_NO     = :X1-ACCOUNT-NO                    32400000
MFA-TR*          AND ARNG_ID        = :X1-ARNG-ID                       32400000
MFA-TR*          AND CRED_ARNG_SEQ  = :X1-CRED-ARNG-SEQ                 32400000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32420000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 32420000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0726C        IF WS-FINAL-NOT-MAIL-DT-NULL < 0                          
P0726C            MOVE SPACES             TO WS-FINAL-NOT-MAIL-OLD      
P0726C            MOVE ZEROES             TO WS-FINAL-NOT-MAIL-DT-NULL  
P0726C        END-IF                                                    
P0726C        IF WS-ARNG-DNP-DT-NULL < 0                                
P0726C            MOVE SPACES             TO WS-ARNG-DNP-DT-OLD         
P0726C            MOVE ZEROES             TO WS-FINAL-NOT-MAIL-DT-NULL  
P0726C        END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE '7200'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_CRED_ARNGMENT'   TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE 12                    TO RS-RETURN-CODE             
               PERFORM 9999-BAIL-OUT            THRU 9999-EXIT          
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7300-SELECT-CSS-ACCOUNT                                       *31850000
      *     SELECTS CSS_ACCOUNT                                        *        
      ******************************************************************        
      *                                                                         
       7300-SELECT-CSS-ACCOUNT.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT                              
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.COMPANY_NO                                      
                    ,AT.CREDIT_GROUP                                    
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.ACCOUNT_TYPE_CODE                               
                    ,AT.PREMISE_NO                                      
                    ,AT.CODE_MAJOR_ACCT                                 
                    ,AT.CT_METER_RATED_IND                              
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.BILL_CYCLE                                      
                    ,COALESCE(AT.LAST_PYMT_DATE,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))             
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.CUSTOMER_NO                                     
                    ,AT.NOTICE_EXEMPT_CD                                
                    ,AT.CODE_DISC_OK                                    
                    , COALESCE(AT.DATE_BILL_DAY_00,
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))          
                    , COALESCE(AT.DATE_BILL_DAY_30,
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))          
                    , COALESCE(AT.DATE_BILL_DAY_60,
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))          
                    , COALESCE(AT.DATE_BILL_DAY_90,
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))          
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.BANKRUPTCY_IND                                  
                    ,AT.IVR_EXEMPT_CD                                   
P0726I              ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO :AT-CODES-DATA-PRESENT                             
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-COMPANY-NO                                     
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-PREMISE-NO                                     
                    ,:AT-CODE-MAJOR-ACCT                                
                    ,:AT-CT-METER-RATED-IND                             
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-LAST-PYMT-DATE                                 
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-DATE-BILL-DAY-00                               
                    ,:AT-DATE-BILL-DAY-30                               
                    ,:AT-DATE-BILL-DAY-60                               
                    ,:AT-DATE-BILL-DAY-90                               
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-IVR-EXEMPT-CD                                  
P0726I              ,:AT-LAST-UPDATE-TS                                 
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*       SELECT AT.CODES_DATA_PRESENT                              32000000
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.CODE_MAJOR_ACCT                                         
MFA-TR*             ,AT.CT_METER_RATED_IND                                      
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,IFNULL(AT.LAST_PYMT_DATE,'1900-01-01')                     
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             , IFNULL(AT.DATE_BILL_DAY_00,'1900-01-01')                  
MFA-TR*             , IFNULL(AT.DATE_BILL_DAY_30,'1900-01-01')                  
MFA-TR*             , IFNULL(AT.DATE_BILL_DAY_60,'1900-01-01')                  
MFA-TR*             , IFNULL(AT.DATE_BILL_DAY_90,'1900-01-01')                  
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.BANKRUPTCY_IND                                          
MFA-TR*             ,AT.IVR_EXEMPT_CD                                           
MFA-TR*             ,AT.LAST_UPDATE_TS                                          
MFA-TR*         INTO :AT-CODES-DATA-PRESENT                             32260000
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-CODE-MAJOR-ACCT                                        
MFA-TR*             ,:AT-CT-METER-RATED-IND                                     
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-LAST-PYMT-DATE                                         
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-DATE-BILL-DAY-00                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-30                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-60                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-90                                       
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_ACCOUNT AT                                     32390000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        32400000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32420000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 32420000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF AT-LAST-PYMT-DATE   = '1900-01-01'                     
                 MOVE SPACES TO  AT-LAST-PYMT-DATE                      
              END-IF                                                    
              IF AT-DATE-BILL-DAY-30 = '1900-01-01'                     
                 MOVE SPACES TO  AT-DATE-BILL-DAY-30                    
              END-IF                                                    
              IF AT-DATE-BILL-DAY-60 = '1900-01-01'                     
                 MOVE SPACES TO  AT-DATE-BILL-DAY-60                    
              END-IF                                                    
              IF AT-DATE-BILL-DAY-90 = '1900-01-01'                     
                 MOVE SPACES TO  AT-DATE-BILL-DAY-90                    
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE '7300'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE 12                    TO RS-RETURN-CODE             
               PERFORM 9999-BAIL-OUT            THRU 9999-EXIT          
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7400-GET-TIMESTAMP-AND-DATE.                                 *          
      *   THIS MODULE GETS CURRENT TIMESTAMP AND DATE FOR CREATING   *          
      * JOURNAL ENTRIES                                              *          
      ****************************************************************          
       7400-GET-TIMESTAMP-AND-DATE.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE),
              CIS.INT2CHAR(DATEPART(DAYOFYEAR, CAST(SYSDATETIMEOFFSET() 
           AS DATE))),
              DATEPART(DAYOFYEAR, CAST(SYSDATETIMEOFFSET() AS DATE))
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE,
              :WS-JULIAN-DAYS-TXT,
              :WS-JULIAN-DAYS-NUM      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP =  CURRENT TIMESTAMP                    
MFA-TR*          ,:WS-CURRENT-DATE      =  CURRENT DATE                         
MFA-TR*          ,:WS-JULIAN-DAYS-TXT   =  CHAR(DAYOFYEAR(CURRENT DATE))        
MFA-TR*          ,:WS-JULIAN-DAYS-NUM   =  DAYOFYEAR(CURRENT DATE)              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-JULIAN-DAYS-NUM < 100                               
                  IF WS-JULIAN-DAYS-NUM < 10                            
                      STRING '00' WS-JULIAN-DAYS-TXT                    
                         DELIMITED BY SIZE                              
                        INTO WS-JULIAN-DATE                             
                  ELSE                                                  
                      STRING '0' WS-JULIAN-DAYS-TXT                     
                         DELIMITED BY SIZE                              
                        INTO WS-JULIAN-DATE                             
                  END-IF                                                
              ELSE                                                      
                  MOVE WS-JULIAN-DAYS-TXT   TO WS-JULIAN-DATE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 12                    TO RS-RETURN-CODE              
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7500-SELECT-RESP-AREA                                         *         
      *     SELECTS CSS_PREMISE                                       *         
      *****************************************************************         
       7500-SELECT-RESP-AREA.                                           
      *                                                                         
           MOVE '7500'               TO ACTIVE-PARAGRAPH.               
      *                                                                         
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :WS-USER-ID                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :WS-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :WS-USER-ID                                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE WS-USER-ID            TO HOSTVAR-ELEMENT-1           
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
              MOVE 12                    TO RS-RETURN-CODE              
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7600-MAX-CRED-ARNG-SEQ                                        *         
      *     SELECTS CSS_CRED_ARNGMENT                                 *         
      *****************************************************************         
       7600-MAX-CRED-ARNG-SEQ.                                          
      *                                                                         
           MOVE '7600'        TO ACTIVE-PARAGRAPH.                      
      *                                                                         
           EXEC SQL                                                     
              SELECT  MAX(CRED_ARNG_SEQ)                                
              INTO    :WS-MAX-CRED-ARNG-SEQ :WS-MAX-CRED-ARNG-SEQ-NULL          
              FROM   CSS_CRED_ARNGMENT WITH(READUNCOMMITTED)                    
              WHERE  ACCOUNT_NO = :X1-ACCOUNT-NO                        
                AND  ARNG_ID    = :WS-CAR-ARNG-ID                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MAX(CRED_ARNG_SEQ)                                        
MFA-TR*       INTO    :WS-MAX-CRED-ARNG-SEQ                                     
MFA-TR*               :WS-MAX-CRED-ARNG-SEQ-NULL                                
MFA-TR*       FROM   CSS_CRED_ARNGMENT                                          
MFA-TR*       WHERE  ACCOUNT_NO = :X1-ACCOUNT-NO                                
MFA-TR*         AND  ARNG_ID    = :WS-CAR-ARNG-ID                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CRED_ARNGMENT'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'ARNG_ID'                  TO TABLE-ELEMENT-2        
              MOVE X1-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-CAR-ARNG-ID             TO HOSTVAR-ELEMENT-2      
              MOVE 12                         TO RS-RETURN-CODE         
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7700-MAX-ARNG-SCHD-SEQ                                        *         
      *     SELECTS CSS_CRED_ARNG_SCHD                                *         
      *****************************************************************         
       7700-MAX-ARNG-SCHD-SEQ.                                          
      *                                                                         
           MOVE '7700'        TO ACTIVE-PARAGRAPH.                      
      *                                                                         
           EXEC SQL                                                     
              SELECT  MAX(ARNG_SCHD_SEQ)                                
              INTO    :WS-MAX-ARNG-SCHD-SEQ :WS-MAX-ARNG-SCHD-SEQ-NULL          
              FROM   CSS_CRED_ARNG_SCHD WITH(READUNCOMMITTED)                   
              WHERE  ACCOUNT_NO     = :WX-ACCOUNT-NO                    
                AND  ARNG_ID        = :WX-ARNG-ID                       
                AND  CRED_ARNG_SEQ  = :WX-CRED-ARNG-SEQ                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MAX(ARNG_SCHD_SEQ)                                        
MFA-TR*       INTO    :WS-MAX-ARNG-SCHD-SEQ                                     
MFA-TR*               :WS-MAX-ARNG-SCHD-SEQ-NULL                                
MFA-TR*       FROM   CSS_CRED_ARNG_SCHD                                         
MFA-TR*       WHERE  ACCOUNT_NO     = :WX-ACCOUNT-NO                            
MFA-TR*         AND  ARNG_ID        = :WX-ARNG-ID                               
MFA-TR*         AND  CRED_ARNG_SEQ  = :WX-CRED-ARNG-SEQ                         
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CRED_ARNG_SCHD'       TO TABLE-1                
              MOVE 'ACCOUNT_NO   '            TO TABLE-ELEMENT-1        
              MOVE 'ARNG_ID      '            TO TABLE-ELEMENT-2        
              MOVE 'CRED_ARNG_SEQ'            TO TABLE-ELEMENT-3        
              MOVE WX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-CAR-ARNG-ID             TO HOSTVAR-ELEMENT-2      
              MOVE WS-ARNG-SEQ-NO             TO HOSTVAR-ELEMENT-3      
              MOVE 12                         TO RS-RETURN-CODE         
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7800-GET-USA-DATE                                              *        
      *     FORMATS THE DATE                                           *        
      ******************************************************************        
       7800-GET-USA-DATE.                                               
      *                                                                         
           MOVE '7800'              TO ACTIVE-PARAGRAPH.                
      *                                                                         
           EXEC SQL                                                     
P0726C        SELECT CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ),'USA')                      
P0726C        INTO  :WS-DATE-HOLD-USA                                   
P0726C        FROM   CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CHAR(DATE(:WS-DATE-HOLD),USA)                              
MFA-TR*       INTO  :WS-DATE-HOLD-USA                                           
MFA-TR*       FROM   SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE SQLCODE             TO ABEND-SQLCODE                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_MODEL_SQL'     TO TABLE-1                       
P0726C        MOVE 'WS-DATE-HOLD-USA'  TO TABLE-ELEMENT-1               
P0726C        MOVE WS-DATE-HOLD        TO HOSTVAR-ELEMENT-1             
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2             
              MOVE 12                  TO RS-RETURN-CODE                
              PERFORM 9999-BAIL-OUT    THRU 9999-EXIT                   
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726B*****************************************************************         
P0726B* 7810-SEL-ARNG-PLAN-DESC                                       *         
P0726B*****************************************************************         
P0726B                                                                  
P0726B 7810-SEL-ARNG-PLAN-DESC.                                         
P0726B                                                                  
P0726B     MOVE '7810'                        TO ACTIVE-PARAGRAPH.      
P0726B                                                                  
P0726B     EXEC SQL                                                     
P0726B        SELECT UPPER(UF.ARNG_PLAN_DESC)                           
P0726B          INTO :UF-ARNG-PLAN-DESC                                 
P0726B          FROM CSS_ARNG_PLAN UF WITH(READUNCOMMITTED)                     
P0726B         WHERE UF.COMPANY_NO        = :AT-COMPANY-NO              
P0726B           AND UF.REG_GROUP_CD      = :LR-REG-GROUP-CD            
P0726B           AND UF.ARNG_ID           = :WS-KR135-ARNG-ID           
P0726B           AND UF.ARNG_PLAN_EFF_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CAR-ARNG-DUE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CAR-ARNG-DUE-DT
              ) <> 0) OR (LEN(:WS-CAR-ARNG-DUE-DT
              ) <> 10), CIS.CHAR2DATE(:WS-CAR-ARNG-DUE-DT
              ), CONVERT(DATE, :WS-CAR-ARNG-DUE-DT) )         
P0726B           AND UF.ARNG_PLAN_EXP_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CAR-ARNG-DUE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CAR-ARNG-DUE-DT
              ) <> 0) OR (LEN(:WS-CAR-ARNG-DUE-DT
              ) <> 10), CIS.CHAR2DATE(:WS-CAR-ARNG-DUE-DT
              ), CONVERT(DATE, :WS-CAR-ARNG-DUE-DT) )         
P0726B                                                           
P0726B                                                      
P0726B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     12694000
MFA-TR*       SELECT UPPER(UF.ARNG_PLAN_DESC)                           12695000
MFA-TR*         INTO :UF-ARNG-PLAN-DESC                                 12696000
MFA-TR*         FROM CSS_ARNG_PLAN UF                                   12697000
MFA-TR*        WHERE UF.COMPANY_NO        = :AT-COMPANY-NO              12698000
MFA-TR*          AND UF.REG_GROUP_CD      = :LR-REG-GROUP-CD                    
MFA-TR*          AND UF.ARNG_ID           = :WS-KR135-ARNG-ID                   
MFA-TR*          AND UF.ARNG_PLAN_EFF_DT <= :WS-CAR-ARNG-DUE-DT                 
MFA-TR*          AND UF.ARNG_PLAN_EXP_DT >= :WS-CAR-ARNG-DUE-DT                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7810                                                       
MFA-TR*    END-EXEC.                                                    12699100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726B                                                                  
P0726B     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P0726B                                                                  
P0726B     EVALUATE SQLCODE                                             
P0726B         WHEN SUCCESSFUL-CALL                                     
P0726B              CONTINUE                                            
P0726B         WHEN NOT-FOUND                                           
P0726B              MOVE SPACES               TO UF-ARNG-PLAN-DESC      
P0726B         WHEN OTHER                                               
P0726B              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
P0726B              MOVE SPACES               TO ABEND-SQL-PREDICATES   
P0726B                                           ABEND-TABLES           
P0726B              MOVE SQLCODE              TO ABEND-SQLCODE          
P0726B              MOVE 'SELECT'             TO ABEND-FUNCTION         
P0726B              MOVE 'CSS_ARNG_PLAN'      TO TABLE-1                
P0726B              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1        
P0726B              MOVE 'REG_GROUP_CD'       TO TABLE-ELEMENT-2        
P0726B              MOVE 'ARNG_ID'            TO TABLE-ELEMENT-3        
P0726B              MOVE 'ARNG_SETUP_DT'      TO TABLE-ELEMENT-4        
P0726B              MOVE AT-COMPANY-NO        TO HOSTVAR-ELEMENT-1      
P0726B              MOVE LR-REG-GROUP-CD      TO HOSTVAR-ELEMENT-2      
P0726B              MOVE WS-CAR-ARNG-ID       TO HOSTVAR-ELEMENT-3      
P0726B              MOVE WS-CAR-ARNG-DUE-DT   TO HOSTVAR-ELEMENT-4      
P0726B              MOVE 12                   TO RS-RETURN-CODE         
P0726B              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT     
P0726B     END-EVALUATE.                                                
P0726B                                                                  
P0726B 7810-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
P0726B*****************************************************************         
P0726B* 7820-SELECT-REG-PROFILE                                       *         
P0726B*****************************************************************         
P0726B                                                                  
P0726B 7820-SELECT-REG-PROFILE.                                         
P0726B                                                                  
P0726B     MOVE '7820'                        TO ACTIVE-PARAGRAPH.      
P0726B                                                                  
P0726B     EXEC SQL                                                     
P0726B        SELECT REG_GROUP_CD                                       
P0726F              ,SENIOR_FL                                          
P0726B          INTO :LR-REG-GROUP-CD                                   
P0726F              ,:LR-SENIOR-FL                                      
P0726B          FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
P0726B         WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
P0726B                                                           
P0726B                                                      
P0726B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12694000
MFA-TR*       SELECT REG_GROUP_CD                                       12695000
MFA-TR*             ,SENIOR_FL                                          12695000
MFA-TR*         INTO :LR-REG-GROUP-CD                                   12696000
MFA-TR*             ,:LR-SENIOR-FL                                              
MFA-TR*         FROM CSS_REG_PROFILE                                    12697000
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   12698000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7820                                                       
MFA-TR*    END-EXEC.                                                    12699100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726B                                                                  
P0726B     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P0726B                                                                  
P0726B     EVALUATE SQLCODE                                             
P0726B         WHEN SUCCESSFUL-CALL                                     
P0726B              CONTINUE                                            
P0726B         WHEN NOT-FOUND                                           
P0726B              MOVE SPACES               TO LR-REG-GROUP-CD        
P0726F              MOVE SPACES               TO LR-SENIOR-FL           
P0726B         WHEN OTHER                                               
P0726B              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
P0726B              MOVE SPACES               TO ABEND-SQL-PREDICATES   
P0726B                                           ABEND-TABLES           
P0726B              MOVE SQLCODE              TO ABEND-SQLCODE          
P0726B              MOVE 'SELECT'             TO ABEND-FUNCTION         
P0726B              MOVE 'CSS_REG_PROFILE'    TO TABLE-1                
P0726B              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
P0726B              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
P0726B              MOVE 12                   TO RS-RETURN-CODE         
P0726B              PERFORM 9999-BAIL-OUT        THRU 9999-EXIT         
P0726B     END-EVALUATE.                                                
P0726B                                                                  
P0726B 7820-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
P0726B*****************************************************************         
P0726B* 7830-SEL-CURR-ARNG-ID                                         *         
P0726B*****************************************************************         
P0726B                                                                  
P0726B 7830-SEL-CURR-ARNG-ID.                                           
P0726B                                                                  
P0726B     MOVE '7830'                        TO ACTIVE-PARAGRAPH.      
P0726B                                                                  
P0726B     EXEC SQL                                                     
P0726B        SELECT TOP(1) ARNG_ID                                            
P0726B          INTO :WS-KR135-CURR-ARNG-ID                             
P0726B          FROM CSS_CRED_ARNGMENT WITH(READUNCOMMITTED)                    
P0726B         WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
P0726B           AND ARNG_STATUS_CD     = 'A'                           
P0726B                                           
P0726B                                                           
P0726B                                                      
P0726B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ARNG_ID                                                    
MFA-TR*         INTO :WS-KR135-CURR-ARNG-ID                                     
MFA-TR*         FROM CSS_CRED_ARNGMENT                                          
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                        
MFA-TR*          AND ARNG_STATUS_CD     = 'A'                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7830                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726B                                                                  
P0726B     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P0726B                                                                  
P0726B     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726B        CONTINUE                                                  
P0726B     ELSE                                                         
P0726B        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0726B        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P0726B                                           ABEND-TABLES           
P0726B        MOVE SQLCODE                    TO ABEND-SQLCODE          
P0726B        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P0726B        MOVE 'CSS_CRED_ARNGMENT'        TO TABLE-1                
P0726B        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0726B        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0726B        MOVE 12                         TO RS-RETURN-CODE         
P0726B        PERFORM 9999-BAIL-OUT           THRU 9999-EXIT            
P0726B     END-IF.                                                      
P0726B                                                                  
P0726B 7830-EXIT.                                                       
P0726B     EXIT.                                                        
P0726B                                                                  
P0726C*****************************************************************         
P0726C* 7840-SELECT-PROCESSED-CD                                      *         
P0726C*****************************************************************         
P0726C                                                                  
P0726C 7840-SELECT-PROCESSED-CD.                                        
P0726C                                                                  
P0726C     MOVE '7840'                        TO ACTIVE-PARAGRAPH.      
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        SELECT PROCESSED_CD                                       
P0726C              ,CODE_MESSAGE_TYPE                                  
P0726C          INTO :CL-PROCESSED-CD                                   
P0726C              ,:CL-CODE-MESSAGE-TYPE                              
P0726C          FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                        
P0726C         WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                  
P0726C           AND CODE_NOTICE_TYPE = 'F'                             
P0726C                                                           
P0726C                                                      
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PROCESSED_CD                                               
MFA-TR*             ,CODE_MESSAGE_TYPE                                          
MFA-TR*         INTO :CL-PROCESSED-CD                                           
MFA-TR*             ,:CL-CODE-MESSAGE-TYPE                                      
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                          
MFA-TR*          AND CODE_NOTICE_TYPE = 'F'                                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7840                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P0726C                                                                  
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0726C        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P0726C                                           ABEND-TABLES           
P0726C        MOVE SQLCODE                    TO ABEND-SQLCODE          
P0726C        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P0726C        MOVE 'CSS_CRED_COLL'            TO TABLE-1                
P0726C        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0726C        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0726C        MOVE 12                         TO RS-RETURN-CODE         
P0726C        PERFORM 9999-BAIL-OUT           THRU 9999-EXIT            
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 7840-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C*****************************************************************         
P0726C* 7850-MET-DLINQ-VAL.                                           *         
P0726C*****************************************************************         
P0726C                                                                  
P0726C 7850-GET-DLINQ-VAL.                                              
P0726C                                                                  
P0726C     MOVE '7850'                        TO ACTIVE-PARAGRAPH.      
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        SELECT C8.DELINQ_VALUE                                    
P0726C          INTO :C8-DELINQ-VALUE                                   
P0726C          FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
P0726C         WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
P0726C           AND C8.COMPANY_NO = :C8-COMPANY-NO                     
P0726C                                                           
P0726C                                                      
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7850                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P0726C                                                                  
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0726C        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P0726C                                           ABEND-TABLES           
P0726C        MOVE SQLCODE                    TO ABEND-SQLCODE          
P0726C        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P0726C        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
P0726C        MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1        
P0726C        MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
P0726C        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
P0726C        MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
P0726C        MOVE 12                         TO RS-RETURN-CODE         
P0726C        PERFORM 9999-BAIL-OUT           THRU 9999-EXIT            
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 7850-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C*****************************************************************         
P0726C* 7860-GET-ARNG-SCHD-DUE-DT                                     *         
P0726C*****************************************************************         
P0726C                                                                  
P0726C 7860-GET-ARNG-SCHD-DUE-DT.                                       
P0726C                                                                  
P0726C     MOVE '7860'                        TO ACTIVE-PARAGRAPH.      
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        SELECT CIS.CHAR2$DATE(WX.ARNG_SCHD_DUE_DT,'USA')                
P0726C          INTO :WS-ARNG-SCHD-DUE-DT-OLD                           
P0726C          FROM CSS_CRED_ARNG_SCHD WX WITH(READUNCOMMITTED)                
P0726C         WHERE WX.ACCOUNT_NO    = :WX-ACCOUNT-NO                  
P0726C           AND WX.ARNG_ID       = :WX-ARNG-ID                     
P0726C           AND WX.CRED_ARNG_SEQ = :WX-CRED-ARNG-SEQ               
P0726C                                                           
P0726C                                                      
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CHAR(DATE(WX.ARNG_SCHD_DUE_DT),USA)                        
MFA-TR*         INTO :WS-ARNG-SCHD-DUE-DT-OLD                                   
MFA-TR*         FROM CSS_CRED_ARNG_SCHD WX                                      
MFA-TR*        WHERE WX.ACCOUNT_NO    = :WX-ACCOUNT-NO                          
MFA-TR*          AND WX.ARNG_ID       = :WX-ARNG-ID                             
MFA-TR*          AND WX.CRED_ARNG_SEQ = :WX-CRED-ARNG-SEQ                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7860                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P0726C                                                                  
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0726C        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P0726C                                           ABEND-TABLES           
P0726C        MOVE SQLCODE                    TO ABEND-SQLCODE          
P0726C        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P0726C        MOVE 'CSS_CRED_ARNG_SCHD'       TO TABLE-1                
P0726C        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0726C        MOVE WX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0726C        MOVE 'ARNG_ID'                  TO TABLE-ELEMENT-2        
P0726C        MOVE WX-ARNG-ID                 TO HOSTVAR-ELEMENT-2      
P0726C        MOVE 'CRED_ARNG_SEQ'            TO TABLE-ELEMENT-3        
P0726C        MOVE WX-CRED-ARNG-SEQ           TO HOSTVAR-ELEMENT-3      
P0726C        MOVE 12                         TO RS-RETURN-CODE         
P0726C        PERFORM 9999-BAIL-OUT           THRU 9999-EXIT            
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 7860-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
      *****************************************************************         
      * 8400-INSERT-CRED-ARGMT                                        *         
      *     INSERTS CSS_CRED_ARNGMENT                                 *         
      *****************************************************************         
       8400-INSERT-CRED-ARGMT.                                          
P0726C                                                                  
P0726C     MOVE '8400'                        TO ACTIVE-PARAGRAPH.      
P0726C*                                                                         
P00948     IF X1-ORIGINAL-DUE-DT   = LOW-VALUES OR SPACES               
P00948        MOVE -1                     TO WS-ORIGINAL-DUE-DT-NULL    
P00948     ELSE                                                         
P00948        MOVE ZERO                   TO WS-ORIGINAL-DUE-DT-NULL    
P00948     END-IF                                                       
P00948                                                                  
P0726C     IF X1-ORIGINAL-DNP-DT   = LOW-VALUES OR SPACES               
P0726C        MOVE -1                     TO WS-ORIGINAL-DNP-DT-NULL    
P0726C     ELSE                                                         
P0726C        MOVE ZERO                   TO WS-ORIGINAL-DNP-DT-NULL    
P0726C     END-IF                                                       
P0726C                                                                  
P0726C     IF X1-FIRST-NOT-MAIL-DT = LOW-VALUES OR SPACES               
P0726C        MOVE -1                     TO WS-FIRST-NOT-MAIL-DT-NULL  
P0726C     ELSE                                                         
P0726C        MOVE ZERO                   TO WS-FIRST-NOT-MAIL-DT-NULL  
P0726C     END-IF                                                       
P0726C                                                                  
P0726C     IF X1-FINAL-NOT-MAIL-DT = LOW-VALUES OR SPACES               
P0726C        MOVE -1                     TO WS-FINAL-NOT-MAIL-DT-NULL  
P0726C     ELSE                                                         
P0726C        MOVE ZERO                   TO WS-FINAL-NOT-MAIL-DT-NULL  
P0726C     END-IF                                                       
P0726C                                                                  
P0726C     IF X1-ARNG-DNP-DT       = LOW-VALUES OR SPACES               
P0726C        MOVE -1                     TO WS-ARNG-DNP-DT-NULL        
P0726C     ELSE                                                         
P0726C        MOVE ZERO                   TO WS-ARNG-DNP-DT-NULL        
P0726C     END-IF                                                       
P0726C                                                                  
           MOVE '8400'               TO ACTIVE-PARAGRAPH.               
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_CRED_ARNGMENT                             
                    ( ACCOUNT_NO                                        
                    , ARNG_ID                                           
                    , CRED_ARNG_SEQ                                     
                    , ARNG_TYPE                                         
                    , ARNG_CHANNEL_CD                                   
                    , INSTALLMENT_FL                                    
                    , ARNG_START_DT                                     
                    , ARNG_TOTAL_AMT                                    
                    , ARNG_CONFIRM_NO                                   
                    , ARNG_SETUP_DT                                     
                    , ARNG_NO_INSTALL                                   
                    , ARNG_COMPLIANCE_CD                                
                    , ARNG_STATUS_CD                                    
                    , ORIGINAL_DUE_DT                                   
                    , LAST_UPDATE_TS                                    
                    , LAST_UPDATE_USERID                                
P0726B              , ARNG_OPTION_ID                                    
P0726C              , ORIGINAL_DNP_DT                                   
P0726C              , FIRST_NOT_MAIL_DT                                 
P0726C              , FINAL_NOT_MAIL_DT                                 
P0726C              , ARNG_DNP_DT)                                      
              VALUES                                                    
                   (:X1-ACCOUNT-NO                                      
                   ,:X1-ARNG-ID                                         
                   ,:X1-CRED-ARNG-SEQ                                   
                   ,:X1-ARNG-TYPE                                       
                   ,:X1-ARNG-CHANNEL-CD                                 
                   ,:X1-INSTALLMENT-FL                                  
                   ,IIF(TRY_CONVERT(DATE, :X1-ARNG-START-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-START-DT
              ) <> 0) OR (LEN(:X1-ARNG-START-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-START-DT
              ), CONVERT(DATE, :X1-ARNG-START-DT) )                            
                   ,:X1-ARNG-TOTAL-AMT                                  
                   ,:X1-ARNG-CONFIRM-NO                                 
                   ,IIF(TRY_CONVERT(DATE, :X1-ARNG-SETUP-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-SETUP-DT
              ) <> 0) OR (LEN(:X1-ARNG-SETUP-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-SETUP-DT
              ), CONVERT(DATE, :X1-ARNG-SETUP-DT) )                            
                   ,:X1-ARNG-NO-INSTALL                                 
                   ,:X1-ARNG-COMPLIANCE-CD                              
                   ,:X1-ARNG-STATUS-CD                                  
P00948             ,IIF(TRY_CONVERT(DATE, :X1-ORIGINAL-DUE-DT 
                                          :WS-ORIGINAL-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :X1-ORIGINAL-DUE-DT 
                                               :WS-ORIGINAL-DUE-DT-NULL
              ) <> 0) OR (LEN(:X1-ORIGINAL-DUE-DT 
                                               :WS-ORIGINAL-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:X1-ORIGINAL-DUE-DT 
                                               :WS-ORIGINAL-DUE-DT-NULL
              ), CONVERT(DATE, :X1-ORIGINAL-DUE-DT 
                                               :WS-ORIGINAL-DUE-DT-NULL
              ) )      
                   ,CIS.CHAR2TIMESTAMP(:X1-LAST-UPDATE-TS)                      
                   ,:X1-LAST-UPDATE-USERID                              
P0726B             ,:X1-ARNG-OPTION-ID                                  
P0726C             ,IIF(TRY_CONVERT(DATE, :X1-ORIGINAL-DNP-DT 
                                          :WS-ORIGINAL-DNP-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :X1-ORIGINAL-DNP-DT 
                                               :WS-ORIGINAL-DNP-DT-NULL
              ) <> 0) OR (LEN(:X1-ORIGINAL-DNP-DT 
                                               :WS-ORIGINAL-DNP-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:X1-ORIGINAL-DNP-DT 
                                               :WS-ORIGINAL-DNP-DT-NULL
              ), CONVERT(DATE, :X1-ORIGINAL-DNP-DT 
                                               :WS-ORIGINAL-DNP-DT-NULL
              ) )      
P0726C             ,IIF(TRY_CONVERT(DATE, :X1-FIRST-NOT-MAIL-DT 
                                          :WS-FIRST-NOT-MAIL-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :X1-FIRST-NOT-MAIL-DT 
                                             :WS-FIRST-NOT-MAIL-DT-NULL
              ) <> 0) OR (LEN(:X1-FIRST-NOT-MAIL-DT 
                                             :WS-FIRST-NOT-MAIL-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:X1-FIRST-NOT-MAIL-DT 
                                             :WS-FIRST-NOT-MAIL-DT-NULL
              ), CONVERT(DATE, :X1-FIRST-NOT-MAIL-DT 
                                             :WS-FIRST-NOT-MAIL-DT-NULL
              ) )    
P0726C             ,IIF(TRY_CONVERT(DATE, :X1-FINAL-NOT-MAIL-DT 
                                          :WS-FINAL-NOT-MAIL-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :X1-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) <> 0) OR (LEN(:X1-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:X1-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ), CONVERT(DATE, :X1-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) )    
P0726C             ,IIF(TRY_CONVERT(DATE, :X1-ARNG-DNP-DT 
                                          :WS-ARNG-DNP-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-DNP-DT 
                                                   :WS-ARNG-DNP-DT-NULL
              ) <> 0) OR (LEN(:X1-ARNG-DNP-DT :WS-ARNG-DNP-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:X1-ARNG-DNP-DT 
                                                   :WS-ARNG-DNP-DT-NULL
              ), CONVERT(DATE, :X1-ARNG-DNP-DT :WS-ARNG-DNP-DT-NULL) )         
P0726C             )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CRED_ARNGMENT                                     
MFA-TR*             ( ACCOUNT_NO                                                
MFA-TR*             , ARNG_ID                                                   
MFA-TR*             , CRED_ARNG_SEQ                                             
MFA-TR*             , ARNG_TYPE                                                 
MFA-TR*             , ARNG_CHANNEL_CD                                           
MFA-TR*             , INSTALLMENT_FL                                            
MFA-TR*             , ARNG_START_DT                                             
MFA-TR*             , ARNG_TOTAL_AMT                                            
MFA-TR*             , ARNG_CONFIRM_NO                                           
MFA-TR*             , ARNG_SETUP_DT                                             
MFA-TR*             , ARNG_NO_INSTALL                                           
MFA-TR*             , ARNG_COMPLIANCE_CD                                        
MFA-TR*             , ARNG_STATUS_CD                                            
MFA-TR*             , ORIGINAL_DUE_DT                                           
MFA-TR*             , LAST_UPDATE_TS                                            
MFA-TR*             , LAST_UPDATE_USERID                                        
MFA-TR*             , ARNG_OPTION_ID                                            
MFA-TR*             , ORIGINAL_DNP_DT                                           
MFA-TR*             , FIRST_NOT_MAIL_DT                                         
MFA-TR*             , FINAL_NOT_MAIL_DT                                         
MFA-TR*             , ARNG_DNP_DT)                                              
MFA-TR*       VALUES                                                            
MFA-TR*            (:X1-ACCOUNT-NO                                              
MFA-TR*            ,:X1-ARNG-ID                                                 
MFA-TR*            ,:X1-CRED-ARNG-SEQ                                           
MFA-TR*            ,:X1-ARNG-TYPE                                               
MFA-TR*            ,:X1-ARNG-CHANNEL-CD                                         
MFA-TR*            ,:X1-INSTALLMENT-FL                                          
MFA-TR*            ,:X1-ARNG-START-DT                                           
MFA-TR*            ,:X1-ARNG-TOTAL-AMT                                          
MFA-TR*            ,:X1-ARNG-CONFIRM-NO                                         
MFA-TR*            ,:X1-ARNG-SETUP-DT                                           
MFA-TR*            ,:X1-ARNG-NO-INSTALL                                         
MFA-TR*            ,:X1-ARNG-COMPLIANCE-CD                                      
MFA-TR*            ,:X1-ARNG-STATUS-CD                                          
MFA-TR*            ,:X1-ORIGINAL-DUE-DT   :WS-ORIGINAL-DUE-DT-NULL              
MFA-TR*            ,:X1-LAST-UPDATE-TS                                          
MFA-TR*            ,:X1-LAST-UPDATE-USERID                                      
MFA-TR*            ,:X1-ARNG-OPTION-ID                                          
MFA-TR*            ,:X1-ORIGINAL-DNP-DT   :WS-ORIGINAL-DNP-DT-NULL              
MFA-TR*            ,:X1-FIRST-NOT-MAIL-DT :WS-FIRST-NOT-MAIL-DT-NULL            
MFA-TR*            ,:X1-FINAL-NOT-MAIL-DT :WS-FINAL-NOT-MAIL-DT-NULL            
MFA-TR*            ,:X1-ARNG-DNP-DT       :WS-ARNG-DNP-DT-NULL                  
MFA-TR*            )                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'                        TO WS-CREATE-CONF-NO      
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CRED_ARNGMENT'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'ARNG_CONFIRM_NO'          TO TABLE-ELEMENT-2        
              MOVE 'ARNG_SETUP_DT'            TO TABLE-ELEMENT-3        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE X1-ARNG-CONFIRM-NO         TO HOSTVAR-ELEMENT-2      
              MOVE X1-ARNG-SETUP-DT           TO HOSTVAR-ELEMENT-3      
              MOVE 12                         TO RS-RETURN-CODE         
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8500-INSERT-ARNG-SCHD                                         *         
      *     INSERTS CSS_CRED_ARNG_SCHD                                *         
      *****************************************************************         
       8500-INSERT-ARNG-SCHD.                                           
      *                                                                         
           MOVE '8500'               TO ACTIVE-PARAGRAPH.               
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_CRED_ARNG_SCHD                            
                     ( ACCOUNT_NO                                       
                     , ARNG_ID                                          
                     , CRED_ARNG_SEQ                                    
                     , ARNG_SCHD_SEQ                                    
                     , ARNG_SCHD_PYMT_AMT                               
                     , ARNG_SCHD_DUE_DT                                 
                     , LAST_UPDATE_TS )                                 
              VALUES                                                    
                     ( :WX-ACCOUNT-NO                                   
                     , :WX-ARNG-ID                                      
                     , :WX-CRED-ARNG-SEQ                                
                     , :WX-ARNG-SCHD-SEQ                                
                     , :WX-ARNG-SCHD-PYMT-AMT                           
                     , IIF(TRY_CONVERT(DATE, :WX-ARNG-SCHD-DUE-DT 
                                             :WS-DATE-ARNG-SCHD-NULL
              ) IS NULL OR (PATINDEX('%.%', :WX-ARNG-SCHD-DUE-DT 
                                                :WS-DATE-ARNG-SCHD-NULL
              ) <> 0) OR (LEN(:WX-ARNG-SCHD-DUE-DT 
                                                :WS-DATE-ARNG-SCHD-NULL
              ) <> 10), CIS.CHAR2DATE(:WX-ARNG-SCHD-DUE-DT 
                                                :WS-DATE-ARNG-SCHD-NULL
              ), CONVERT(DATE, :WX-ARNG-SCHD-DUE-DT 
                                                :WS-DATE-ARNG-SCHD-NULL
              ) )     
                     , CIS.CHAR2TIMESTAMP(:WX-LAST-UPDATE-TS)    )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CRED_ARNG_SCHD                                    
MFA-TR*              ( ACCOUNT_NO                                               
MFA-TR*              , ARNG_ID                                                  
MFA-TR*              , CRED_ARNG_SEQ                                            
MFA-TR*              , ARNG_SCHD_SEQ                                            
MFA-TR*              , ARNG_SCHD_PYMT_AMT                                       
MFA-TR*              , ARNG_SCHD_DUE_DT                                         
MFA-TR*              , LAST_UPDATE_TS )                                         
MFA-TR*       VALUES                                                            
MFA-TR*              ( :WX-ACCOUNT-NO                                           
MFA-TR*              , :WX-ARNG-ID                                              
MFA-TR*              , :WX-CRED-ARNG-SEQ                                        
MFA-TR*              , :WX-ARNG-SCHD-SEQ                                        
MFA-TR*              , :WX-ARNG-SCHD-PYMT-AMT                                   
MFA-TR*              , :WX-ARNG-SCHD-DUE-DT :WS-DATE-ARNG-SCHD-NULL             
MFA-TR*              , :WX-LAST-UPDATE-TS    )                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CRED_ARNG_SCHD'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'ARNG_SCHD_DUE_DT'         TO TABLE-ELEMENT-3        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WX-ARNG-SCHD-DUE-DT        TO HOSTVAR-ELEMENT-3      
              MOVE 12                         TO RS-RETURN-CODE         
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8600-INSERT-ARNG-HIST                                         *         
      *     INSERTS CSS_CRED_ARNG_HIST                                *         
      *****************************************************************         
       8600-INSERT-ARNG-HIST.                                           
      *                                                                         
           MOVE '8600'               TO ACTIVE-PARAGRAPH.               
                                                                        
P0726B     IF WY-TOTAL-UTL-BAL    < 0                                   
P0726B        MOVE 0                 TO WY-TOTAL-UTL-BAL                
P0726B     END-IF.                                                      
P0726B     IF WY-TOTAL-NONUTL-BAL < 0                                   
P0726B        MOVE 0                 TO WY-TOTAL-NONUTL-BAL             
P0726B     END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_CRED_ARNG_HIST                            
                    ( ACCOUNT_NO                                        
                    , ARNG_ID                                           
                    , CRED_ARNG_SEQ                                     
                    , ARNG_HIST_TS                                      
                    , ARNG_CHANGE_CD                                    
                    , TOTAL_AR_BALANCE                                  
                    , TOTAL_UTL_BAL                                     
                    , TOTAL_NONUTL_BAL                                  
                    , UTL_ARREARS_AMT                                   
                    , NONUTL_ARREARS_AMT                                
                    , ARNG_DUE_DT                                       
P0726A              , ARNG_SCHD_SEQ                                     
                    , CHANGE_COMMENTS                                   
                    , LAST_UPDATE_TS                                    
                    , LAST_UPDATE_USERID )                              
              VALUES                                                    
                   (:WY-ACCOUNT-NO                                      
                   ,:WY-ARNG-ID                                         
                   ,:WY-CRED-ARNG-SEQ                                   
                   ,CIS.CHAR2TIMESTAMP(:WY-ARNG-HIST-TS)                        
                   ,:WY-ARNG-CHANGE-CD                                  
                   ,:WY-TOTAL-AR-BALANCE                                
                   ,:WY-TOTAL-UTL-BAL                                   
                   ,:WY-TOTAL-NONUTL-BAL                                
                   ,:WY-UTL-ARREARS-AMT                                 
                   ,:WY-NONUTL-ARREARS-AMT                              
                   ,IIF(TRY_CONVERT(DATE, :WY-ARNG-DUE-DT 
                                          :WS-DUE-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WY-ARNG-DUE-DT 
                                                    :WS-DUE-DT-NULL-IND
              ) <> 0) OR (LEN(:WY-ARNG-DUE-DT :WS-DUE-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WY-ARNG-DUE-DT 
                                                    :WS-DUE-DT-NULL-IND
              ), CONVERT(DATE, :WY-ARNG-DUE-DT :WS-DUE-DT-NULL-IND) )          
P0726A             ,:WY-ARNG-SCHD-SEQ :WS-SCHD-SEQ-NULL-IND              
                   ,:WY-CHANGE-COMMENTS                                 
                   ,CIS.CHAR2TIMESTAMP(:WY-LAST-UPDATE-TS)                      
                   ,:WY-LAST-UPDATE-USERID )                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CRED_ARNG_HIST                                    
MFA-TR*             ( ACCOUNT_NO                                                
MFA-TR*             , ARNG_ID                                                   
MFA-TR*             , CRED_ARNG_SEQ                                             
MFA-TR*             , ARNG_HIST_TS                                              
MFA-TR*             , ARNG_CHANGE_CD                                            
MFA-TR*             , TOTAL_AR_BALANCE                                          
MFA-TR*             , TOTAL_UTL_BAL                                             
MFA-TR*             , TOTAL_NONUTL_BAL                                          
MFA-TR*             , UTL_ARREARS_AMT                                           
MFA-TR*             , NONUTL_ARREARS_AMT                                        
MFA-TR*             , ARNG_DUE_DT                                               
MFA-TR*             , ARNG_SCHD_SEQ                                             
MFA-TR*             , CHANGE_COMMENTS                                           
MFA-TR*             , LAST_UPDATE_TS                                            
MFA-TR*             , LAST_UPDATE_USERID )                                      
MFA-TR*       VALUES                                                            
MFA-TR*            (:WY-ACCOUNT-NO                                              
MFA-TR*            ,:WY-ARNG-ID                                                 
MFA-TR*            ,:WY-CRED-ARNG-SEQ                                           
MFA-TR*            ,:WY-ARNG-HIST-TS                                            
MFA-TR*            ,:WY-ARNG-CHANGE-CD                                          
MFA-TR*            ,:WY-TOTAL-AR-BALANCE                                        
MFA-TR*            ,:WY-TOTAL-UTL-BAL                                           
MFA-TR*            ,:WY-TOTAL-NONUTL-BAL                                        
MFA-TR*            ,:WY-UTL-ARREARS-AMT                                         
MFA-TR*            ,:WY-NONUTL-ARREARS-AMT                                      
MFA-TR*            ,:WY-ARNG-DUE-DT:WS-DUE-DT-NULL-IND                          
MFA-TR*            ,:WY-ARNG-SCHD-SEQ:WS-SCHD-SEQ-NULL-IND                      
MFA-TR*            ,:WY-CHANGE-COMMENTS                                         
MFA-TR*            ,:WY-LAST-UPDATE-TS                                          
MFA-TR*            ,:WY-LAST-UPDATE-USERID )                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'                        TO WS-CREATE-CONF-NO      
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CRED_ARNG_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'ARNG_ID'                  TO TABLE-ELEMENT-2        
              MOVE 'CRED_ARNG_SEQ'            TO TABLE-ELEMENT-3        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WY-ARNG-ID                 TO HOSTVAR-ELEMENT-2      
              MOVE WY-CRED-ARNG-SEQ           TO HOSTVAR-ELEMENT-3      
              MOVE 12                         TO RS-RETURN-CODE         
              PERFORM 9999-BAIL-OUT           THRU 9999-EXIT            
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8700-UPDATE-CSS-ACCOUNT                                       *         
      *****************************************************************         
       8700-UPDATE-CSS-ACCOUNT.                                         
      *                                                                         
           MOVE '8700'                TO ACTIVE-PARAGRAPH.              
      *                                                                         
           MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT.         
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
              SET    CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
                    ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )         
              WHERE  ACCOUNT_NO         = :AT-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*       SET    CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT                
MFA-TR*             ,LAST_UPDATE_TS     = :WS-CURRENT-TIMESTAMP                 
MFA-TR*       WHERE  ACCOUNT_NO         = :AT-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 12                         TO RS-RETURN-CODE         
              PERFORM 9999-BAIL-OUT           THRU 9999-EXIT            
           END-IF.                                                      
      *                                                                         
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726C***************************************************************** 10998613
P0726C* 8710-UPD-FLEX-STA-SCND-NOTICE.                                * 10980057
P0726C***************************************************************** 11660013
P0726C                                                                  
P0726C 8710-UPD-FLEX-STA-SCND-NOTICE.                                   
P0726C                                                                  
P0726C     MOVE '8710'                   TO ACTIVE-PARAGRAPH.           
P0726C                                                                  
P0726C     IF WS-FINAL-NOT-MAIL-DT = LOW-VALUES OR SPACES               
P0726C        MOVE -1                    TO WS-FINAL-NOT-MAIL-DT-NULL   
P0726C     ELSE                                                         
P0726C        MOVE 0                     TO WS-FINAL-NOT-MAIL-DT-NULL   
P0726C     END-IF                                                       
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        UPDATE CSS_CRED_ARNGMENT                                  
P0726C           SET FINAL_NOT_MAIL_DT  = IIF(TRY_CONVERT(DATE, 
                                                 :WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) <> 0) OR (LEN(:WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ), CONVERT(DATE, :WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) )    
P0726C              ,ARNG_DNP_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :WS-ARNG-DNP-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ARNG-DNP-DT
              ) <> 0) OR (LEN(:WS-ARNG-DNP-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-ARNG-DNP-DT
              ), CONVERT(DATE, :WS-ARNG-DNP-DT) )               
P0726C         WHERE ACCOUNT_NO         = :X1-ACCOUNT-NO                
P0726C           AND ARNG_ID            = :X1-ARNG-ID                   
P0726C           AND CRED_ARNG_SEQ      = :X1-CRED-ARNG-SEQ             
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11030013
MFA-TR*       UPDATE CSS_CRED_ARNGMENT                                  11040057
MFA-TR*          SET FINAL_NOT_MAIL_DT  = :WS-FINAL-NOT-MAIL-DT                 
MFA-TR*                                   :WS-FINAL-NOT-MAIL-DT-NULL            
MFA-TR*             ,ARNG_DNP_DT        = :WS-ARNG-DNP-DT                       
MFA-TR*        WHERE ACCOUNT_NO         = :X1-ACCOUNT-NO                11110057
MFA-TR*          AND ARNG_ID            = :X1-ARNG-ID                   11111057
MFA-TR*          AND CRED_ARNG_SEQ      = :X1-CRED-ARNG-SEQ                     
MFA-TR*    END-EXEC.                                                    11610028

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0726C                                                                  
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0726C        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
P0726C        MOVE 'CSS_CRED_ARNGMENT'        TO TABLE-1                
P0726C        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0726C        MOVE x1-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0726C        MOVE 'ARNG_ID'                  TO TABLE-ELEMENT-2        
P0726C        MOVE X1-ARNG-ID                 TO HOSTVAR-ELEMENT-2      
P0726C        MOVE 'CRED_ARNG_SEQ'            TO TABLE-ELEMENT-3        
P0726C        MOVE X1-CRED-ARNG-SEQ           TO HOSTVAR-ELEMENT-3      
P0726C        MOVE 12                         TO RS-RETURN-CODE         
P0726C        PERFORM 9999-BAIL-OUT           THRU 9999-EXIT            
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 8710-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C***************************************************************** 10998613
P0726C* 8720-UPDATE-FLEX-STA.                                         * 10980057
P0726C***************************************************************** 11660013
P0726C                                                                  
P0726C 8720-UPDATE-FLEX-STA.                                            
P0726C                                                                  
P0726C     MOVE '8720'                        TO ACTIVE-PARAGRAPH.      
P0726C                                                                  
P0726C     IF WS-ARNG-DNP-DT = LOW-VALUES OR SPACES                     
P0726C        MOVE -1                         TO WS-ARNG-DNP-DT-NULL    
P0726C     ELSE                                                         
P0726C        MOVE 0                          TO WS-ARNG-DNP-DT-NULL    
P0726C     END-IF                                                       
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        UPDATE CSS_CRED_ARNGMENT                                  
P0726C           SET ARNG_DNP_DT        = IIF(TRY_CONVERT(DATE, 
                                                       :WS-ARNG-DNP-DT 
                                                   :WS-ARNG-DNP-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-ARNG-DNP-DT 
                                                   :WS-ARNG-DNP-DT-NULL
              ) <> 0) OR (LEN(:WS-ARNG-DNP-DT :WS-ARNG-DNP-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-ARNG-DNP-DT 
                                                   :WS-ARNG-DNP-DT-NULL
              ), CONVERT(DATE, :WS-ARNG-DNP-DT :WS-ARNG-DNP-DT-NULL) )         
P0726C         WHERE ACCOUNT_NO         = :X1-ACCOUNT-NO                
P0726C           AND ARNG_ID            = :WS-CAR-ARNG-ID               
P0726C           AND CRED_ARNG_SEQ      = :WS-ARNG-SEQ-NO               
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11030013
MFA-TR*       UPDATE CSS_CRED_ARNGMENT                                  11040057
MFA-TR*          SET ARNG_DNP_DT        = :WS-ARNG-DNP-DT                       
MFA-TR*                                   :WS-ARNG-DNP-DT-NULL                  
MFA-TR*        WHERE ACCOUNT_NO         = :X1-ACCOUNT-NO                11110057
MFA-TR*          AND ARNG_ID            = :WS-CAR-ARNG-ID               11111057
MFA-TR*          AND CRED_ARNG_SEQ      = :WS-ARNG-SEQ-NO                       
MFA-TR*    END-EXEC.                                                    11610028

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0726C                                                                  
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0726C        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
P0726C        MOVE 'CSS_CRED_ARANGEMENT'      TO TABLE-1                
P0726C        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0726C        MOVE x1-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0726C        MOVE 'ARNG_ID'                  TO TABLE-ELEMENT-2        
P0726C        MOVE WS-CAR-ARNG-ID             TO HOSTVAR-ELEMENT-2      
P0726C        MOVE 'CRED_ARNG_SEQ'            TO TABLE-ELEMENT-3        
P0726C        MOVE WS-ARNG-SEQ-NO             TO HOSTVAR-ELEMENT-3      
P0726C        MOVE 12                         TO RS-RETURN-CODE         
P0726C        PERFORM 9999-BAIL-OUT           THRU 9999-EXIT            
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 8720-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C*                                                                 11640128
P0726H***************************************************************** 10998613
P0726H* 8725-UPD-FLEX-STA-CREDACTN.                                   * 10980057
P0726H***************************************************************** 11660013
P0726H*                                                                 11670013
P0726H 8725-UPD-FLEX-STA-CREDACTN.                                      
P0726H*                                                                 11020013
P0726H     MOVE '8725'                        TO ACTIVE-PARAGRAPH.      
P0726H*                                                                 11022019
P0726H     IF WS-CREDACTN-DUE-DT  = LOW-VALUES OR SPACES                
P0726H        MOVE -1                      TO WS-CREDACTN-DUE-DT-NULL   
P0726H     ELSE                                                         
P0726H        MOVE 0                       TO WS-CREDACTN-DUE-DT-NULL   
P0726H     END-IF                                                       
P0726H*                                                                         
P0726H     IF WS-CREDACTN-FCST-DT = LOW-VALUES OR SPACES                
P0726H        MOVE -1                      TO WS-CREDACTN-FCST-DT-NULL  
P0726H     ELSE                                                         
P0726H        MOVE 0                       TO WS-CREDACTN-FCST-DT-NULL  
P0726H     END-IF                                                       
P0726H*                                                                         
P0726H     EXEC SQL                                                     
P0726H        UPDATE CSS_CRED_ARNG_ACTN                                 
P0726H           SET CRED_ACTN_DUE_DT   = IIF(TRY_CONVERT(DATE, 
                                                   :WS-CREDACTN-DUE-DT 
                                               :WS-CREDACTN-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-CREDACTN-DUE-DT 
                                               :WS-CREDACTN-DUE-DT-NULL
              ) <> 0) OR (LEN(:WS-CREDACTN-DUE-DT 
                                               :WS-CREDACTN-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-CREDACTN-DUE-DT 
                                               :WS-CREDACTN-DUE-DT-NULL
              ), CONVERT(DATE, :WS-CREDACTN-DUE-DT 
                                               :WS-CREDACTN-DUE-DT-NULL
              ) )      
P0726H              ,CRED_ACTN_FCST_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :WS-CREDACTN-FCST-DT 
                                              :WS-CREDACTN-FCST-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-CREDACTN-FCST-DT 
                                              :WS-CREDACTN-FCST-DT-NULL
              ) <> 0) OR (LEN(:WS-CREDACTN-FCST-DT 
                                              :WS-CREDACTN-FCST-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-CREDACTN-FCST-DT 
                                              :WS-CREDACTN-FCST-DT-NULL
              ), CONVERT(DATE, :WS-CREDACTN-FCST-DT 
                                              :WS-CREDACTN-FCST-DT-NULL
              ) )     
P0726H         WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
P0726H           AND ARNG_ID            = :WS-CAR-ARNG-ID               
P0726H           AND CRED_ARNG_SEQ      = :WS-ARNG-SEQ-NO               
P0726H           AND CRED_ACTN_TYPE_CD  = :WS-CREDACTN-TYPE-CD          
P0726H           AND PROCESSED_FL       = ''                            
P0726H     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11030013
MFA-TR*       UPDATE CSS_CRED_ARNG_ACTN                                 11040057
MFA-TR*          SET CRED_ACTN_DUE_DT   = :WS-CREDACTN-DUE-DT                   
MFA-TR*                                   :WS-CREDACTN-DUE-DT-NULL              
MFA-TR*             ,CRED_ACTN_FCST_DT  = :WS-CREDACTN-FCST-DT                  
MFA-TR*                                   :WS-CREDACTN-FCST-DT-NULL             
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                11110057
MFA-TR*          AND ARNG_ID            = :WS-CAR-ARNG-ID               11111057
MFA-TR*          AND CRED_ARNG_SEQ      = :WS-ARNG-SEQ-NO                       
MFA-TR*          AND CRED_ACTN_TYPE_CD  = :WS-CREDACTN-TYPE-CD                  
MFA-TR*          AND PROCESSED_FL       = ''                                    
MFA-TR*    END-EXEC.                                                    11610028

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726H*                                                                 11620028
P0726H     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0726H*                                                                 11631028
P0726H     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726H        NEXT SENTENCE                                             
P0726H     ELSE                                                         
P0726H        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0726H        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
P0726H        MOVE 'CSS_CRED_ARNG_ACTN'       TO TABLE-1                
P0726H        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0726H        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0726H        MOVE 'ARNG_ID'                  TO TABLE-ELEMENT-2        
P0726H        MOVE WS-CAR-ARNG-ID             TO HOSTVAR-ELEMENT-2      
P0726H        MOVE 'CRED_ARNG_SEQ'            TO TABLE-ELEMENT-3        
P0726H        MOVE WS-ARNG-SEQ-NO             TO HOSTVAR-ELEMENT-3      
P0726H        MOVE 'CRED_ACTN_TYPE_CD'        TO TABLE-ELEMENT-4        
P0726H        MOVE WS-CREDACTN-TYPE-CD        TO HOSTVAR-ELEMENT-4      
P0726H        MOVE 12                         TO RS-RETURN-CODE         
P0726H        PERFORM 9999-BAIL-OUT           THRU 9999-EXIT            
P0726H     END-IF.                                                      
P0726H*                                                                 11640128
P0726H 8725-EXIT.                                                       
P0726H     EXIT.                                                        
P0726H*                                                                 11640328
P0726C***************************************************************           
P0726C* 8730-UPD-FUTURE-SCND-NOTICE                                 *           
P0726C***************************************************************           
P0726C                                                                  
P0726C 8730-UPD-FUTURE-SCND-NOTICE.                                     
P0726C                                                                  
P0726C     MOVE '8730'                   TO ACTIVE-PARAGRAPH.           
P0726C                                                                  
P0726C     IF WS-FINAL-NOT-MAIL-DT = LOW-VALUES OR SPACES               
P0726C        MOVE -1                    TO WS-FINAL-NOT-MAIL-DT-NULL   
P0726C     ELSE                                                         
P0726C        MOVE 0                     TO WS-FINAL-NOT-MAIL-DT-NULL   
P0726C     END-IF                                                       
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        UPDATE CSS_CRED_COLL                                      
P0726C           SET DATE_NOTICE_MAIL   = IIF(TRY_CONVERT(DATE, 
                                                 :WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) <> 0) OR (LEN(:WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ), CONVERT(DATE, :WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) ),   
P0726C               LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
P0726C         WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO                
P0726C           AND ITEM_ID            = 0                             
P0726C           AND CODE_NOTICE_TYPE   IN ('F','U')                    
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_COLL                                              
MFA-TR*          SET DATE_NOTICE_MAIL   = :WS-FINAL-NOT-MAIL-DT                 
MFA-TR*                                   :WS-FINAL-NOT-MAIL-DT-NULL,           
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO                        
MFA-TR*          AND ITEM_ID            = 0                                     
MFA-TR*          AND CODE_NOTICE_TYPE   IN ('F','U')                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P0726C                                                                  
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C        MOVE SQLCODE               TO RS-RETURN-CODE              
P0726C        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0726C        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P0726C        MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
P0726C        MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P0726C        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P0726C        MOVE 12                    TO RS-RETURN-CODE              
P0726C        PERFORM 9999-BAIL-OUT      THRU 9999-EXIT                 
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 8730-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C***************************************************************           
P0726C* 8740-UPD-FUTURE-IVR-DT                                      *           
P0726C***************************************************************           
P0726C                                                                  
P0726C 8740-UPD-FUTURE-IVR-DT.                                          
P0726C                                                                  
P0726C     MOVE '8740'                   TO ACTIVE-PARAGRAPH.           
P0726C                                                                  
P0726C     IF WS-DATE-SCND-NOT-CREDACT = LOW-VALUES OR SPACES           
P0726C        MOVE -1                    TO WS-DATE-CR-ACTION-NULL      
P0726C     ELSE                                                         
P0726C        MOVE 0                     TO WS-DATE-CR-ACTION-NULL      
P0726C     END-IF                                                       
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        UPDATE CSS_CRED_COLL                                      
P0726C           SET DATE_CREDIT_ACTION  = IIF(TRY_CONVERT(DATE, 
                                             :WS-DATE-SCND-NOT-CREDACT 
                                                :WS-DATE-CR-ACTION-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-SCND-NOT-CREDACT 
                                                :WS-DATE-CR-ACTION-NULL
              ) <> 0) OR (LEN(:WS-DATE-SCND-NOT-CREDACT 
                                                :WS-DATE-CR-ACTION-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-SCND-NOT-CREDACT 
                                                :WS-DATE-CR-ACTION-NULL
              ), CONVERT(DATE, :WS-DATE-SCND-NOT-CREDACT 
                                                :WS-DATE-CR-ACTION-NULL
              ) ),     
P0726C               PROCESSED_CD        = :CL-PROCESSED-CD,            
P0726C               LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()            
P0726C         WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO               
P0726C           AND ITEM_ID             = 0                            
P0726C           AND CODE_NOTICE_TYPE    IN ('F','U')                   
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_COLL                                              
MFA-TR*          SET DATE_CREDIT_ACTION  = :WS-DATE-SCND-NOT-CREDACT            
MFA-TR*                                    :WS-DATE-CR-ACTION-NULL,             
MFA-TR*              PROCESSED_CD        = :CL-PROCESSED-CD,                    
MFA-TR*              LAST_UPDATE_TS      = CURRENT TIMESTAMP                    
MFA-TR*        WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO                       
MFA-TR*          AND ITEM_ID             = 0                                    
MFA-TR*          AND CODE_NOTICE_TYPE    IN ('F','U')                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P0726C                                                                  
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C        MOVE SQLCODE               TO RS-RETURN-CODE              
P0726C        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0726C        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P0726C        MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
P0726C        MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P0726C        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P0726C        MOVE 12                    TO RS-RETURN-CODE              
P0726C        PERFORM 9999-BAIL-OUT      THRU 9999-EXIT                 
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 8740-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C***************************************************************           
P0726C* 8750-UPD-FUTURE-DUE-DT-F-U-ROW.                              *          
P0726C***************************************************************           
P0726C                                                                  
P0726C 8750-UPD-FUTURE-DUE-DT-F-U-ROW.                                  
P0726C                                                                  
P0726C     MOVE '8750'                   TO ACTIVE-PARAGRAPH.           
P0726C                                                                  
P0726C     IF WS-ARNG-DUE-DT = LOW-VALUES OR SPACES                     
P0726C        MOVE -1                    TO WS-ARNG-DUE-DT-NULL         
P0726C     ELSE                                                         
P0726C        MOVE 0                     TO WS-ARNG-DUE-DT-NULL         
P0726C     END-IF                                                       
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        UPDATE CSS_CRED_COLL                                      
P0726C           SET DATE_NOTICE_DUE     = IIF(TRY_CONVERT(DATE, 
                                                       :WS-ARNG-DUE-DT 
                                                   :WS-ARNG-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-ARNG-DUE-DT 
                                                   :WS-ARNG-DUE-DT-NULL
              ) <> 0) OR (LEN(:WS-ARNG-DUE-DT :WS-ARNG-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-ARNG-DUE-DT 
                                                   :WS-ARNG-DUE-DT-NULL
              ), CONVERT(DATE, :WS-ARNG-DUE-DT :WS-ARNG-DUE-DT-NULL) )         
P0726C         WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO               
P0726C           AND ITEM_ID             = 0                            
P0726C           AND CODE_NOTICE_TYPE    IN ('F','U')                   
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_COLL                                              
MFA-TR*          SET DATE_NOTICE_DUE     = :WS-ARNG-DUE-DT                      
MFA-TR*                                    :WS-ARNG-DUE-DT-NULL                 
MFA-TR*        WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO                       
MFA-TR*          AND ITEM_ID             = 0                                    
MFA-TR*          AND CODE_NOTICE_TYPE    IN ('F','U')                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P0726C                                                                  
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C        MOVE SQLCODE               TO RS-RETURN-CODE              
P0726C        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0726C        MOVE '8750'                TO ACTIVE-PARAGRAPH            
P0726C        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P0726C        MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
P0726C        MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P0726C        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P0726C        MOVE 12                    TO RS-RETURN-CODE              
P0726C        PERFORM 9999-BAIL-OUT      THRU 9999-EXIT                 
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 8750-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C***************************************************************           
P0726C*                                                             *           
P0726C* 8760-UPD-FUTURE-F-U-ROW.                                    *           
P0726C*                                                             *           
P0726C***************************************************************           
P0726C*                                                                         
P0726C 8760-UPD-FUTURE-F-U-ROW.                                         
P0726C                                                                  
P0726C     MOVE '8760'                   TO ACTIVE-PARAGRAPH.           
P0726C                                                                  
P0726C     IF WS-DATE-SCND-NOT-CREDACT = LOW-VALUES OR SPACES           
P0726C        MOVE -1                    TO WS-DATE-CR-ACTION-NULL      
P0726C     ELSE                                                         
P0726C        MOVE 0                     TO WS-DATE-CR-ACTION-NULL      
P0726C     END-IF                                                       
P0726C                                                                  
P0726C                                                                  
P0726C     IF WS-FINAL-NOT-MAIL-DT     = LOW-VALUES OR SPACES           
P0726C        MOVE -1                    TO WS-FINAL-NOT-MAIL-DT-NULL   
P0726C     ELSE                                                         
P0726C        MOVE 0                     TO WS-FINAL-NOT-MAIL-DT-NULL   
P0726C     END-IF                                                       
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        UPDATE CSS_CRED_COLL                                      
P0726C           SET DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                             :WS-DATE-SCND-NOT-CREDACT 
                                                :WS-DATE-CR-ACTION-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-SCND-NOT-CREDACT 
                                                :WS-DATE-CR-ACTION-NULL
              ) <> 0) OR (LEN(:WS-DATE-SCND-NOT-CREDACT 
                                                :WS-DATE-CR-ACTION-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-SCND-NOT-CREDACT 
                                                :WS-DATE-CR-ACTION-NULL
              ), CONVERT(DATE, :WS-DATE-SCND-NOT-CREDACT 
                                                :WS-DATE-CR-ACTION-NULL
              ) ),      
P0726C               DATE_NOTICE_MAIL   = IIF(TRY_CONVERT(DATE, 
                                                 :WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) <> 0) OR (LEN(:WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ), CONVERT(DATE, :WS-FINAL-NOT-MAIL-DT 
                                             :WS-FINAL-NOT-MAIL-DT-NULL
              ) ),   
P0726C               LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
P0726C         WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO                
P0726C           AND ITEM_ID            = 0                             
P0726C           AND CODE_NOTICE_TYPE   IN ('F','U')                    
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_COLL                                              
MFA-TR*          SET DATE_CREDIT_ACTION = :WS-DATE-SCND-NOT-CREDACT             
MFA-TR*                                   :WS-DATE-CR-ACTION-NULL,              
MFA-TR*              DATE_NOTICE_MAIL   = :WS-FINAL-NOT-MAIL-DT                 
MFA-TR*                                   :WS-FINAL-NOT-MAIL-DT-NULL,           
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO                        
MFA-TR*          AND ITEM_ID            = 0                                     
MFA-TR*          AND CODE_NOTICE_TYPE   IN ('F','U')                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C*                                                                         
P0726C     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P0726C*                                                                         
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C        MOVE SQLCODE               TO RS-RETURN-CODE              
P0726C        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0726C        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P0726C        MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
P0726C        MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P0726C        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P0726C        MOVE 12                    TO RS-RETURN-CODE              
P0726C        PERFORM 9999-BAIL-OUT      THRU 9999-EXIT                 
P0726C     END-IF.                                                      
P0726C*                                                                         
P0726C 8760-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C*                                                                         
P0726C***************************************************************           
P0726C* 8770-UPD-FUTURE-G-X-ROW.                                    *           
P0726C***************************************************************           
P0726C                                                                  
P0726C 8770-UPD-FUTURE-G-X-ROW.                                         
P0726C                                                                  
P0726C     MOVE '8770'                   TO ACTIVE-PARAGRAPH.           
P0726C                                                                  
P0726C     IF WS-ARNG-DNP-DT = LOW-VALUES OR SPACES                     
P0726C        MOVE -1                    TO WS-ARNG-DNP-DT-NULL         
P0726C     ELSE                                                         
P0726C        MOVE 0                     TO WS-ARNG-DNP-DT-NULL         
P0726C     END-IF                                                       
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        UPDATE CSS_CRED_COLL                                      
P0726C          SET DATE_CREDIT_ACTION     = IIF(TRY_CONVERT(DATE, 
                                                       :WS-ARNG-DNP-DT 
                                                   :WS-ARNG-DNP-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-ARNG-DNP-DT 
                                                   :WS-ARNG-DNP-DT-NULL
              ) <> 0) OR (LEN(:WS-ARNG-DNP-DT :WS-ARNG-DNP-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-ARNG-DNP-DT 
                                                   :WS-ARNG-DNP-DT-NULL
              ), CONVERT(DATE, :WS-ARNG-DNP-DT :WS-ARNG-DNP-DT-NULL) )       
P0726C          WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO             
P0726C          AND ITEM_ID                = 0                          
P0726C          AND CODE_NOTICE_TYPE       IN ('G','X')                 
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_COLL                                              
MFA-TR*         SET DATE_CREDIT_ACTION     = :WS-ARNG-DNP-DT                    
MFA-TR*                                      :WS-ARNG-DNP-DT-NULL               
MFA-TR*         WHERE ACCOUNT_NO           = :CL-ACCOUNT-NO                     
MFA-TR*         AND ITEM_ID                = 0                                  
MFA-TR*         AND CODE_NOTICE_TYPE       IN ('G','X')                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P0726C                                                                  
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C        MOVE SQLCODE               TO RS-RETURN-CODE              
P0726C        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0726C        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P0726C        MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
P0726C        MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P0726C        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P0726C        MOVE 12                    TO RS-RETURN-CODE              
P0726C        PERFORM 9999-BAIL-OUT      THRU 9999-EXIT                 
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 8770-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
P0726C*****************************************************************         
P0726C* 8780-UPDATE-CRED-ARNG-SCHD                                    *         
P0726C*****************************************************************         
P0726C                                                                  
P0726C 8780-UPDATE-CRED-ARNG-SCHD.                                      
P0726C                                                                  
P0726C     MOVE '8780'                TO ACTIVE-PARAGRAPH               
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        UPDATE CSS_CRED_ARNG_SCHD                                 
P0726C           SET ARNG_SCHD_DUE_DT   = IIF(TRY_CONVERT(DATE, 
                                                        :WS-ARNG-DUE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ARNG-DUE-DT
              ) <> 0) OR (LEN(:WS-ARNG-DUE-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-ARNG-DUE-DT
              ), CONVERT(DATE, :WS-ARNG-DUE-DT) )               
P0726C         WHERE ACCOUNT_NO         = :WX-ACCOUNT-NO                
P0726C           AND ARNG_ID            = :WX-ARNG-ID                   
P0726C           AND CRED_ARNG_SEQ      = :WX-CRED-ARNG-SEQ             
P0726C     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_ARNG_SCHD                                         
MFA-TR*          SET ARNG_SCHD_DUE_DT   = :WS-ARNG-DUE-DT                       
MFA-TR*        WHERE ACCOUNT_NO         = :WX-ACCOUNT-NO                        
MFA-TR*          AND ARNG_ID            = :WX-ARNG-ID                   32400000
MFA-TR*          AND CRED_ARNG_SEQ      = :WX-CRED-ARNG-SEQ             32400000
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0726C                                                                  
P0726C     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0726C        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P0726C                                           ABEND-TABLES           
P0726C        MOVE SQLCODE                    TO ABEND-SQLCODE          
P0726C        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
P0726C        MOVE 'CSS_CRED_ARNG_SCHD'       TO TABLE-1                
P0726C        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0726C        MOVE WX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0726C        MOVE 'ARNG_ID'                  TO TABLE-ELEMENT-2        
P0726C        MOVE WX-ARNG-ID                 TO HOSTVAR-ELEMENT-2      
P0726C        MOVE 'CRED_ARNG_SEQ'            TO HOSTVAR-ELEMENT-3      
P0726C        MOVE WX-CRED-ARNG-SEQ           TO TABLE-ELEMENT-3        
P0726C        MOVE 12                         TO RS-RETURN-CODE         
P0726C        PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 8780-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
      *****************************************************************         
      * 8800-UPDATE-CRED-ARNGMENT                                     *         
      *****************************************************************         
       8800-UPDATE-CRED-ARNGMENT.                                       
      *                                                                         
           MOVE '8800'                TO ACTIVE-PARAGRAPH               
      *                                                                         
           MOVE WS-CAR-ARNG-STATUS-CD TO X1-ARNG-STATUS-CD              
           MOVE WS-CAR-ARNG-COMPL-CD  TO X1-ARNG-COMPLIANCE-CD          
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_CRED_ARNGMENT                                  
              SET    ARNG_COMPLIANCE_CD = :X1-ARNG-COMPLIANCE-CD        
                    ,ARNG_STATUS_CD     = :X1-ARNG-STATUS-CD            
              WHERE  ACCOUNT_NO         = :X1-ACCOUNT-NO                
                 AND ARNG_ID            = :X1-ARNG-ID                   
                 AND CRED_ARNG_SEQ      = :X1-CRED-ARNG-SEQ             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CRED_ARNGMENT'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 12                         TO RS-RETURN-CODE         
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726F*****************************************************************         
P0726F* 8900-DELETE-ACCT-ATTRIBUTE                                    *         
P0726F*****************************************************************         
P0726F 8900-DELETE-ACCT-ATTRIBUTE.                                      
P0726F*                                                                         
P0726F     MOVE '8900'                TO ACTIVE-PARAGRAPH               
P0726F*                                                                         
P0726F     EXEC SQL                                                     
P0726F        DELETE FROM CSS_ACCT_ATTRIBUTE                            
P0726F        WHERE  ACCOUNT_NO         = :AT-ACCOUNT-NO                
P0726F           AND ATTRIBUTE_DESC     = 'FCST CR GP BALANCE'          
P0726F     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726F*                                                                         
P0726F     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0726F*                                                                         
P0726F     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0726F        NEXT SENTENCE                                             
P0726F     ELSE                                                         
P0726F        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0726F        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P0726F                                           ABEND-TABLES           
P0726F        MOVE SQLCODE                    TO ABEND-SQLCODE          
P0726F        MOVE 'DELETE'                   TO ABEND-FUNCTION         
P0726F        MOVE 'CSS_ACCT_ATTRIBUTE'       TO TABLE-1                
P0726F        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P0726F        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P0726F        MOVE 12                         TO RS-RETURN-CODE         
P0726F        PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
P0726F     END-IF.                                                      
P0726F*                                                                         
P0726F 8900-EXIT.                                                       
P0726F     EXIT.                                                        
P0726F*                                                                         
