      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **              CUSTOMER INFORMATION SYSTEM                    **         
      *****************************************************************         
      **              P R O G R A M  S U M M A R Y                   **         
      **                                                             **         
      ** COPYBOOK HAS LOGIC TO READ THE CSS_CRED_MSG_REF TABLE AND   **         
      ** BY MATCHING THE MESSAGE ID IN CSS_CORRESP_COMM TABLE,INSERTS**         
      ** INSERTS NOTICES INTO CORRESPONDING TABLES                   **         
      ** COPYBOOK WILL BE CALLED BY SCSKR125/MCSKR125                **         
      ** INSERTS COMMUNICATION RECORD & TRANSACTION HISTORY AS NEEDED**         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     **         
      *****************************************************************         
      **    DATE     INITIALS     REASON                             **         
      **  -------    --------     ------                             **         
      **  07/27/2012 GAYATHRI    INITIAL PROGRAM VERSION             **         
      **  01/29/2013 GOKUL       CHECK FOR REG-GROUP-CD CHANGE FOR   **         
      **                         CREDIT SCORING LETTERS AND BUMP UP  **         
      **                         THE CORRESP-SEQ-NO.                 **         
P0599A**  02/16/2013 AARON       LOAD NEW FIELD CR-HIST-TRAN-DT IN   **         
P0599A**                         CORRESP VAR TABLE.                  **         
A04527**  06/06/2013 AARON       MOVE MAX-CORRESP-SEQ-NO WHEN WE DO  **         
A04527**                         CREDIT SCORE MULTIPLE TIME ON SAME DAY         
A05460**  04/13/2016 MJ13662     REMOVED IF ONLINE AND -803 LOGIC    **         
A05460**                         BECAUSE INDEX CHANGED TO NON-UNIQUE.**         
A05460**                         LAST DIGIT OF CORRESP-CREATED-BY-PGM-ID        
A05460**                         WILL CONTAIN REQUEST REASON.                   
A05460**                         MOVE ENTIRE PROGRAM NAME FOR MAINT             
A05460**                         TRANSACTION HISTORY.                           
A05460**                         ACT115                                         
      *****************************************************************         
                                                                        
      *****************************************************************         
      *DECLARE CRED-MSG-REF-BATCH                                     *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE CRED-MSG-CSR-BATCH CURSOR                         
                                         WITH ROWSET POSITIONING FOR    
                 SELECT [1I].MESSAGE_ID                                   
                       ,[1I].COMPANY_NO                                   
                       ,[1I].REG_GROUP_CD                                 
                       ,[1I].MESSAGE_VAR_NM                               
                       ,[1I].MESSAGE_VAR_DATA                             
                       ,[1I].MESSAGE_VAR_TYP_CD                           
                   FROM CSS_CRED_MSG_REF  [1I] WITH(READUNCOMMITTED)            
                  ORDER BY [1I].MESSAGE_ID ASC                            
                          ,[1I].COMPANY_NO ASC                            
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CRED-MSG-CSR-BATCH CURSOR                                 
MFA-TR*                                  WITH ROWSET POSITIONING FOR            
MFA-TR*          SELECT 1I.MESSAGE_ID                                           
MFA-TR*                ,1I.COMPANY_NO                                           
MFA-TR*                ,1I.REG_GROUP_CD                                         
MFA-TR*                ,1I.MESSAGE_VAR_NM                                       
MFA-TR*                ,1I.MESSAGE_VAR_DATA                                     
MFA-TR*                ,1I.MESSAGE_VAR_TYP_CD                                   
MFA-TR*            FROM CSS_CRED_MSG_REF  1I                                    
MFA-TR*           ORDER BY 1I.MESSAGE_ID ASC                                    
MFA-TR*                   ,1I.COMPANY_NO ASC                                    
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *5050-PROCESS-CREDIT-NOTICE.                                    *         
      *****************************************************************         
       5050-PROCESS-CREDIT-NOTICE.                                      
                                                                        
           MOVE  WS-CORRESP-MSG-ID     TO 1L-CORRESP-MSG-ID             
                                                                        
           PERFORM 5100-CHECK-LOAD-CRED-MSG      THRU 5100-CPD125-EXIT. 
           PERFORM 5400-LOAD-CORRESP-HDR         THRU 5400-CPD125-EXIT. 
           IF WS-NOTICE-CORRESP-ID > 0                                  
              PERFORM 5450-LOAD-CORRESP-NOTICE   THRU 5450-CPD125-EXIT  
           END-IF.                                                      
                                                                        
           PERFORM 5250-PROCESS-CORRESP-TBL      THRU 5250-CPD125-EXIT. 
                                                                        
       5050-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5100-CHECK-LOAD-CRED-MSG.                                     *         
      *****************************************************************         
                                                                        
       5100-CHECK-LOAD-CRED-MSG.                                        
                                                                        
           IF BATCH-CALL                                                
              IF NOT CRED-MSG-REF-LOADED                                
                 INITIALIZE WS-NOTICE-VARS                              
                 PERFORM 5650-LOAD-CRED-MSG-REF-BATCH                   
                                                 THRU 5650-CPD125-EXIT  
                 SET CRED-MSG-REF-LOADED TO TRUE                        
              END-IF                                                    
           ELSE                                                         
              IF NOT CRED-MSG-REF-LOADED                                
                PERFORM 5150-LOAD-CRED-MSG-REF   THRU 5150-CPD125-EXIT  
                SET CRED-MSG-REF-LOADED  TO TRUE                        
              END-IF                                                    
                                                                        
              PERFORM 5125-MATCH-CRED-MESSAGE-ID THRU 5125-CPD125-EXIT  
                                                                        
              IF MESSAGE-ID-FND                                         
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 5150-LOAD-CRED-MSG-REF  THRU 5150-CPD125-EXIT  
                 PERFORM 5125-MATCH-CRED-MESSAGE-ID                     
                                         THRU 5125-CPD125-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5100-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 5125-MATCH-CRED-MESSAGE-ID.                                  *          
      ****************************************************************          
       5125-MATCH-CRED-MESSAGE-ID.                                      
                                                                        
           SET WS-CRED-MSG-INDX          TO 1.                          
           SEARCH WS-NOTICE-VARS-TBL                                    
              WHEN WS-MSG-ID(WS-CRED-MSG-INDX) = WS-MESSAGE-ID          
                  SET MESSAGE-ID-FND     TO TRUE                        
           END-SEARCH.                                                  
                                                                        
        5125-CPD125-EXIT.                                               
           EXIT.                                                        
      ****************************************************************          
      * 5150-LOAD-CRED-MSG-REF.                                      *          
      ****************************************************************          
       5150-LOAD-CRED-MSG-REF.                                          
                                                                        
           PERFORM 7500-OPEN-CRED-MSG-CSR        THRU 7500-CPD125-EXIT. 
           PERFORM 7600-FETCH-CRED-MSG-CSR       THRU 7600-CPD125-EXIT. 
           PERFORM 5200-LOAD-CRED-MSG-VAL        THRU 5200-CPD125-EXIT  
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7700-CLOSE-CRED-MSG-CSR       THRU 7700-CPD125-EXIT. 
                                                                        
       5150-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5200-LOAD-CRED-MSG-VAL.                                        *         
      *****************************************************************         
       5200-LOAD-CRED-MSG-VAL.                                          
                                                                        
           ADD +1                      TO WS-CRED-MSG-CNT               
           MOVE 1I-COMPANY-NO          TO                               
                WS-MSG-REF-COMPANY-NO(WS-CRED-MSG-CNT)                  
           MOVE 1I-REG-GROUP-CD        TO                               
                WS-MSG-REF-REG-GRP-CD(WS-CRED-MSG-CNT)                  
           MOVE 1I-MESSAGE-ID          TO WS-MSG-ID(WS-CRED-MSG-CNT)    
           MOVE 1I-MESSAGE-VAR-NM      TO WS-VAR-NM(WS-CRED-MSG-CNT)    
           MOVE 1I-MESSAGE-VAR-DATA    TO WS-VAR-DATA(WS-CRED-MSG-CNT)  
           MOVE 1I-MESSAGE-VAR-TYP-CD  TO WS-VAR-TYPE(WS-CRED-MSG-CNT)  
           PERFORM 7600-FETCH-CRED-MSG-CSR       THRU 7600-CPD125-EXIT. 
                                                                        
       5200-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5250-PROCESS-CORRESP-TBL.                                      *         
      *****************************************************************         
                                                                        
       5250-PROCESS-CORRESP-TBL.                                        
                                                                        
           SET  WS-CRED-MSG-INDX                 TO 1                   
           PERFORM 5255-SEARCH-COMP-MATCH-FOUND  THRU 5255-CPD125-EXIT  
                                                                        
           SET  WS-CRED-MSG-INDX                 TO 1                   
           PERFORM 5300-SEARCH-CRED-MSG-REF      THRU 5300-CPD125-EXIT  
             UNTIL WS-CRED-MSG-INDX > WS-CRED-MSG-MAX                   
                OR WS-MSG-ID(WS-CRED-MSG-INDX) = SPACES                 
                                                                        
           IF BATCH-CALL                                                
              IF WS-CURR-COMM-INSERT-FL = 'Y'                           
                 PERFORM 5550-WRITE-COMM-DATA    THRU 5550-CPD125-EXIT  
              END-IF                                                    
              IF (WS-KR125-MNT-ACCOUNT-NO > 0                           
               OR WS-KR125-MNT-PREMISE-NO > 0                           
               OR WS-KR125-MNT-CUSTOMER-NO > 0)                         
                PERFORM 5600-WRITE-MNT-TRANS-HIST  THRU 5600-CPD125-EXIT
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5250-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5255-SEARCH-COMP-MATCH-FOUND                                  *         
      *****************************************************************         
                                                                        
       5255-SEARCH-COMP-MATCH-FOUND.                                    
                                                                        
           SEARCH WS-NOTICE-VARS-TBL AT END                             
                  MOVE 'N' TO WS-COMP-MATCH-FOUND-FL                    
             WHEN WS-CORRESP-MSG-ID  = WS-MSG-ID(WS-CRED-MSG-INDX) AND  
                  WS-CORRESP-COMPANY-NO  =                              
                  WS-MSG-REF-COMPANY-NO(WS-CRED-MSG-INDX)               
                  MOVE 'Y' TO WS-COMP-MATCH-FOUND-FL                    
           END-SEARCH.                                                  
                                                                        
       5255-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5300-SEARCH-CRED-MSG-REF                                       *         
      *****************************************************************         
                                                                        
       5300-SEARCH-CRED-MSG-REF.                                        
                                                                        
           INITIALIZE WS-CORRESP-VAR-TYPE                               
                      WS-CORRESP-VAR-NM                                 
                      WS-CORRESP-VAR-DATA.                              
                                                                        
           SEARCH WS-NOTICE-VARS-TBL                                    
      * find a row in cred_msg_ref by matching the account's                    
      * 1. company_no                                                           
      * 2. corresp_msg_id                                                       
      * 3. reg_group_cd                                                         
             WHEN WS-CORRESP-COMPANY-NO  =                              
                  WS-MSG-REF-COMPANY-NO(WS-CRED-MSG-INDX)          AND  
                  WS-CORRESP-MSG-ID  = WS-MSG-ID(WS-CRED-MSG-INDX) AND  
                  WS-NOTICE-REG-GROUP-CD =                              
                  WS-MSG-REF-REG-GRP-CD(WS-CRED-MSG-INDX)               
                     MOVE WS-VAR-NM(WS-CRED-MSG-INDX)   TO              
                          WS-CORRESP-VAR-NM                             
                     MOVE WS-VAR-DATA(WS-CRED-MSG-INDX) TO              
                          WS-CORRESP-VAR-DATA                           
                     MOVE WS-VAR-TYPE(WS-CRED-MSG-INDX) TO              
                           WS-CORRESP-VAR-TYPE                          
                     PERFORM 5350-VALIDATE-NOTICE-VAR                   
                                                  THRU 5350-CPD125-EXIT 
      * find a row in cred_msg_ref by matching the account's                    
      * 1. corresp_msg_id                                                       
      * 2. company_no                                                           
             WHEN WS-CORRESP-MSG-ID  = WS-MSG-ID(WS-CRED-MSG-INDX) AND  
                  WS-CORRESP-COMPANY-NO  =                              
                  WS-MSG-REF-COMPANY-NO(WS-CRED-MSG-INDX)               
                     MOVE WS-VAR-NM(WS-CRED-MSG-INDX)   TO              
                          WS-CORRESP-VAR-NM                             
                     MOVE WS-VAR-DATA(WS-CRED-MSG-INDX) TO              
                          WS-CORRESP-VAR-DATA                           
                     MOVE WS-VAR-TYPE(WS-CRED-MSG-INDX) TO              
                           WS-CORRESP-VAR-TYPE                          
                     PERFORM 5350-VALIDATE-NOTICE-VAR                   
                                                  THRU 5350-CPD125-EXIT 
      * find a row in cred_msg_ref by matching the account's                    
      * 1. corresp_msg_id                                                       
             WHEN WS-CORRESP-MSG-ID  = WS-MSG-ID(WS-CRED-MSG-INDX) AND  
                  WS-COMP-MATCH-FOUND-FL = 'N'                          
                     MOVE WS-VAR-NM(WS-CRED-MSG-INDX)   TO              
                          WS-CORRESP-VAR-NM                             
                     MOVE WS-VAR-DATA(WS-CRED-MSG-INDX) TO              
                          WS-CORRESP-VAR-DATA                           
                     MOVE WS-VAR-TYPE(WS-CRED-MSG-INDX) TO              
                           WS-CORRESP-VAR-TYPE                          
                        PERFORM 5350-VALIDATE-NOTICE-VAR                
                                                  THRU 5350-CPD125-EXIT 
           END-SEARCH.                                                  
           SET WS-CRED-MSG-INDX UP BY 1.                                
                                                                        
       5300-CPD125-EXIT.                                                
           EXIT.                                                        
      *****************************************************************         
      *5350-VALIDATE-NOTICE-VAR.                                      *         
      *****************************************************************         
                                                                        
       5350-VALIDATE-NOTICE-VAR.                                        
                                                                        
           INITIALIZE DCLCSS-CORRESP-VAR                                
                      WS-WRITE-NOTICE-IND.                              
           MOVE SPACES                         TO WS-WRITE-NOTICE-IND.  
                                                                        
           EVALUATE TRUE                                                
              WHEN  CC-ADDRESS-ID                                       
                                                                        
                 EVALUATE TRUE                                          
                     WHEN TP-ADDRESS-ID                                 
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-CORRESP-CC-ADDR-ID                    
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN GU-ADDRESS-ID                                 
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-CORRESP-GU-ADDR-ID                    
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  CC-NAME-ID                                          
                                                                        
                 EVALUATE TRUE                                          
                     WHEN TP-NAME-ID                                    
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-CORRESP-CC-NAME-ID                    
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  CR-HIST-TRN-TM                                      
                                                                        
                 EVALUATE TRUE                                          
                     WHEN CR-HIST-TRAN-TM                               
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-CR-HIST-TRN-TM                        
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                 END-EVALUATE                                           
P0599A        WHEN  CR-HIST-TRN-DT                                      
P0599A                                                                  
P0599A           EVALUATE TRUE                                          
P0599A               WHEN CR-HIST-TRAN-DT                               
P0599A                                                                  
P0599A                 SET WRITE-NOTICE          TO TRUE                
P0599A                                                                  
P0599A                 IF WS-CORRESP-VAR-TYPE = 'A'                     
P0599A                    MOVE WS-CR-HIST-TRN-DT                        
P0599A                                           TO 1K-CORRESP-VAR-CHAR 
P0599A                 END-IF                                           
P0599A           END-EVALUATE                                           
              WHEN  CC-ADDRESS-FORMAT                                   
                                                                        
                 EVALUATE TRUE                                          
                     WHEN GU-ADDRESS-FORMAT                             
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-GU-ADDRESS-FORMAT                     
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                     WHEN TP-ADDRESS-FORMAT                             
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-TP-ADDRESS-FORMAT                     
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  DEP-CERT-NO                                         
                                                                        
                 EVALUATE TRUE                                          
                     WHEN DEPOSIT-CERT-NO                               
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-DO-DEPOSIT-CERT-NO                    
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  ESC-RETURN-DT                                       
                                                                        
                 EVALUATE TRUE                                          
                     WHEN RETURN-DATE                                   
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-RN-RETURN-DATE                        
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  NUM-VAR-1                                           
                                                                        
                 EVALUATE TRUE                                          
                     WHEN REFUND-AMOUNT                                 
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-RN-AMT-REFUNDED                       
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                                                                        
                     WHEN LPC-AMT                                       
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-CRED-LPC-AMT   TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                                                                        
                     WHEN AMT-TOTAL-BILLED                              
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-TOTAL-AMT-BILLED-SM                   
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN FB-WO-AMT-XFERED                              
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-FB-WO-AMT-XFERED                      
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN DW-NET-AMOUNT                                 
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-DW-NET-AMOUNT  TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN OLD-BBP-AMT                                   
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-BH-PREV-AMT-MO-PYMT                   
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN RET-CHK-AMT                                   
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-RET-CHK-AMT                           
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN DEP-INT-RATE                                  
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-DEP-INT-RATE                          
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                 END-EVALUATE                                           
                                                                        
              WHEN  NUM-VAR-2                                           
                                                                        
                 EVALUATE TRUE                                          
                     WHEN TOTAL-AR-BALANCE                              
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-TOTAL-AR-BALANCE-SM                   
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN RETAIN-DEP                                    
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-RETAIN-DEP                            
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN LPC-AMT                                       
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-CRED-LPC-AMT   TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                                                                        
                     WHEN NEW-BBP-AMT                                   
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-BH-AMT-MO-PYMT                        
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN NSF-CHRG-AMT                                  
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-NSF-CHARGE-AMT                        
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN FRST-ERNST-AMT                                
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-FRST-ERNST-PAY-AMT                    
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN DEPOSIT-BAL                                   
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-DEPOSIT-BAL                           
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  NUM-VAR-3                                           
                                                                        
                 EVALUATE TRUE                                          
                     WHEN BBP-RMNG-MNTHS                                
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-BH-EPP-MTHS-RMNG                      
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN TOT-RET-CHK-AMT                               
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-TOTAL-RET-CHK-AMT                     
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN SCND-ERNST-AMT                                
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-SCND-ERNST-PAY-AMT                    
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN GU-AMOUNT-GUARANTEED                          
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-GU-AMOUNT-GUARANTEED                  
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  NUM-VAR-4                                           
                                                                        
                 EVALUATE TRUE                                          
                     WHEN SCND-ERNST-AMT                                
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-SCND-ERNST-PAY-AMT                    
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                     WHEN RET-CHK-PAST-DUE-AMT                          
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-RET-CHK-PAST-DUE-AMT                  
                                                 TO 1K-CORRESP-VAR-NUM  
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  NUM-VAR-5                                           
                                                                        
                 EVALUATE TRUE                                          
                     WHEN AUTO-DEP-CHARGED                              
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'D'                     
                          MOVE WS-AUTO-DEP-CHARGED TO 1K-CORRESP-VAR-NUM
                       END-IF                                           
                 END-EVALUATE                                           
                                                                        
              WHEN  ALPHA-VAR-1                                         
                                                                        
                 EVALUATE TRUE                                          
                     WHEN REFUND-CHECK-NO                               
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-RN-REFUND-CHECK-NO                    
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                                                                        
                     WHEN NSF-REASON-DESC                               
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-NSF-REASON-DESC                       
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                                                                        
                     WHEN STA-DUE-DATE                                  
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-DT-PYMNT-DUE-SH                       
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                     WHEN XFER-FROM-ACCT-NO                             
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-XFER-FROM-ACCT-NO                     
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                     WHEN DW-CURRENT-YEAR                               
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-DW-CURRENT-YEAR                       
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  ALPHA-VAR-2                                         
                                                                        
                 EVALUATE TRUE                                          
                     WHEN FRST-ERNST-DT                                 
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-FRST-ERNST-PAY-DT                     
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                     WHEN DRAWN-BY-NM                                   
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-DRAWN-BY-NM-T                         
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  ALPHA-VAR-3                                         
                                                                        
                 EVALUATE TRUE                                          
                     WHEN SCND-ERNST-DT                                 
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-SCND-ERNST-PAY-DT                     
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                     WHEN GU-HOME-PHONE-NO                              
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-GU-HOME-PHONE-NO                      
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  ALPHA-VAR-4                                         
                                                                        
                 EVALUATE TRUE                                          
                     WHEN TP-HOME-PHONE                                 
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-CORRESP-TP-HOME-PHONE                 
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                     WHEN SCND-ERNST-DT                                 
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-SCND-ERNST-PAY-DT                     
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                     WHEN GU-WORK-PHONE-NO                              
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-GU-WORK-PHONE-NO                      
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                 END-EVALUATE                                           
              WHEN  ALPHA-VAR-5                                         
                                                                        
                 EVALUATE TRUE                                          
                     WHEN TP-WORK-PHONE                                 
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-CORRESP-TP-WORK-PHONE                 
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                     WHEN CB-EXTENSION-NUMBER                           
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-CB-EXTENSION-NO                       
                                                 TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                     WHEN VENDOR-NAME                                   
                                                                        
                       SET WRITE-NOTICE          TO TRUE                
                                                                        
                       IF WS-CORRESP-VAR-TYPE = 'A'                     
                          MOVE WS-VENDER-NAME    TO 1K-CORRESP-VAR-CHAR 
                       END-IF                                           
                 END-EVALUATE                                           
           END-EVALUATE.                                                
                                                                        
                                                                        
           IF WRITE-NOTICE                                              
               PERFORM 5500-WRITE-CORRESP-VAR     THRU 5500-CPD125-EXIT 
               ADD +1                  TO WRITTEN-NOTICE-CNT            
           END-IF.                                                      
                                                                        
                                                                        
       5350-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5400-LOAD-CORRESP-HDR.                                         *         
      *****************************************************************         
       5400-LOAD-CORRESP-HDR.                                           
                                                                        
           INITIALIZE DCLCSS-CORRESP-HDR                                
P00599                WS-PREV-CORRESP-ID                                
P00599                WS-MAX-CORRESP-SEQ-NO.                            
                                                                        
           IF WS-CORRESP-SEQ-NO    <= ZEROES                            
              MOVE ZERO                   TO WS-CORRESP-SEQ-NO          
           END-IF                                                       
           MOVE WS-NOTICE-ACCOUNT-NO   TO 1J-ACCOUNT-NO                 
           MOVE WS-NOTICE-CUSTOMER-NO  TO 1J-CUSTOMER-NO                
           MOVE WS-NOTICE-GUARANTOR-ACCT-NO                             
                                       TO 1J-GUARNTR-ACCT-NO            
           MOVE WS-CORRESP-THD-PRTY-ID TO 1J-THD-PRTY-ID                
           MOVE WS-CORRESP-MSG-ID      TO 1J-CORRESP-MSG-ID             
           MOVE WS-CORRESP-CREATE-DT   TO 1J-CORRESP-CREATE-TS          
           MOVE WS-CORRESP-COMPANY-NO  TO 1J-CORRESP-COMPANY-NO         
           MOVE WS-NOTICE-REG-GROUP-CD TO 1J-REG-GROUP-CD               
           MOVE WS-NOTICE-SENIOR-FL    TO 1J-SENIOR-FL                  
           MOVE WS-CORRESP-STMT-DT     TO 1J-CORRESP-STMT-DT            
           MOVE WS-CORRESP-SEQ-NO      TO 1J-CORRESP-SEQ-NO             
           MOVE 'I'                    TO 1J-CORRESP-STATUS-CD          
           MOVE WS-CORRESP-TYPE-CD     TO 1J-CORRESP-TYPE-CD            
           MOVE WS-CORRESP-BARCODE-UNIQUE-ID                            
                                       TO 1J-BARCODE-UNIQUE-ID          
           MOVE WS-CORRESP-CREATED-BY-PGM-ID                            
                                       TO 1J-CREATED-BY-PGM-ID          
ACT115                                    WS-PROGRAM-ID-350             
           MOVE WS-CORRESP-LAST-UPDATE-PGM-ID                           
                                       TO 1J-LAST-UPDATE-PGM-ID         
           MOVE WS-CORRESP-LAST-UPDATE-TS                               
                                       TO 1J-LAST-UPDATE-TS             
           PERFORM 5425-GET-CORRESP-ID-VAL       THRU 5425-CPD350-EXIT. 
                                                                        
       5400-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5450-LOAD-CORRESP-NOTICE.                                      *         
      *****************************************************************         
       5450-LOAD-CORRESP-NOTICE.                                        
                                                                        
           INITIALIZE DCLCSS-CORRESP-NOTICE.                            
                                                                        
           MOVE WS-CORRESP-ID          TO 1M-CORRESP-ID                 
           MOVE WS-NOTICE-AUTO-DEP-FCST-AM                              
                                       TO 1M-AUTO-DEP-FCST-AM           
           MOVE WS-NOTICE-UTIL-PAST-DUE-AM                              
                                       TO 1M-UTIL-PAST-DUE-AM           
           MOVE WS-NOTICE-NONUTL-PAST-DUE-AM                            
                                       TO 1M-NONUTL-PAST-DUE-AM         
           MOVE WS-NOTICE-DUE-DT       TO 1M-NOTICE-DUE-DT              
           MOVE WS-NOTICE-DUE-AM       TO 1M-NOTICE-DUE-AM              
           MOVE WS-NOTICE-LAST-PAYMENT-AM                               
                                       TO 1M-LAST-PAYMENT-AM            
           MOVE WS-NOTICE-LAST-PAYMENT-DT                               
                                       TO 1M-LAST-PAYMENT-DT            
           MOVE WS-NOTICE-CASH-ONLY-FL TO 1M-CASH-ONLY-FL               
                                                                        
           PERFORM 8500-INSERT-CORRESP-NOTICE    THRU 8500-CPD350-EXIT. 
                                                                        
       5450-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5500-WRITE-CORRESP-VAR.                                        *         
      *****************************************************************         
                                                                        
       5500-WRITE-CORRESP-VAR.                                          
                                                                        
           MOVE WS-CORRESP-ID          TO 1K-CORRESP-ID.                
           MOVE WS-CORRESP-VAR-NM      TO 1K-CORRESP-VAR-NM.            
           MOVE WS-CORRESP-VAR-DATA    TO 1K-CORRESP-VAR-DATA.          
           PERFORM 8600-INSERT-CORRESP-VAR       THRU 8600-CPD350-EXIT. 
                                                                        
       5500-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5550-WRITE-COMM-DATA.                                          *         
      *****************************************************************         
                                                                        
       5550-WRITE-COMM-DATA.                                            
                                                                        
           INITIALIZE DCLCSS-COMM-DATA.                                 
           MOVE WS-KR125-COMM-ACCT-NO TO KO-ACCOUNT-NO                  
           MOVE WS-CORRESP-COMPANY-NO   TO KO-COMPANY-NO                
           MOVE WS-CURR-COMM-TYP-CD     TO KO-COMM-TYPE-CD              
           MOVE WS-CURR-COMM-SUBTYP-CD  TO KO-COMM-SUBTYPE-CODE         
           PERFORM 7100-GET-TIMESTAMP            THRU 7100-CPD125-EXIT. 
           MOVE WS-KR125-CUSTOMER-NO    TO KO-CUSTOMER-NO               
           MOVE WS-KR125-CONTACT-NAME   TO KO-CONTACT-NAME              
           MOVE WS-KR125-RED-FL-EXP-DT  TO KO-RED-FLAG-EXPIRE-DT        
           MOVE WS-KR125-CALL-END-TIME  TO KO-CALL-END-TIME             
           MOVE WS-KR125-COMM-ASSOC-CD  TO KO-COMM-ASSOC-CD             
           MOVE WS-KR125-PREMISE-NO     TO KO-PREMISE-NO                
           MOVE WS-N                    TO KO-RED-FLAG-IND              
           MOVE WS-L                    TO KO-COMM-METHOD               
           MOVE WS-O                    TO KO-COMM-DIRECTION            
           MOVE WS-SYSTEM               TO KO-USER-ID-ORIG              
           MOVE WS-CORRESP-MSG-ID       TO KO-PROMOTION-ID              
           MOVE WS-KR125-PSC-COMPL-ID   TO KO-PSC-COMPLIANCE-IND        
           MOVE 0                       TO KO-CALL-ORIGIN-ID            
           MOVE 0                       TO KO-NUMBER-TRANSFERS          
           MOVE 0                       TO KO-HOLD-TIME                 
           MOVE 0                       TO KO-QUEUE-TIME                
           MOVE WS-N                    TO KO-SCREEN-POP-IND            
           MOVE 0                       TO KO-TOTAL-CALL-TIME           
           MOVE SPACES                  TO KO-RESPONSE-REASON-CD        
           MOVE SPACES                  TO KO-RESPONSE-TYPE-CD          
           MOVE SPACES                  TO KO-SOLICITATION-CD           
           MOVE WS-N                    TO KO-COMPLAINT-FL              
           MOVE SPACES                  TO KO-DISCOVERY-MTHD-CD         
           MOVE SPACES                  TO KO-PREV-MARKETER-CD          
           MOVE WS-KR125-COMDAT-CMT     TO KO-INITIAL-COMMENT-TX        
                                                                        
           PERFORM 8300-INSERT-COMM-DATA         THRU 8300-CPD125-EXIT. 
                                                                        
       5550-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5600-WRITE-MNT-TRANS-HIST.                                     *        
ACT115* IF LETTERS WERE CREATED FOR CREDIT SCORING (CSR02329/CSR03495) *        
ACT115* LAST DIGIT CONTAINS RQST-REASON-CD.  MOVE ENTIRE PROGRAM NAME  *        
ACT115* FOR TRANSACTION HISTORY.                                       *        
      ******************************************************************        
                                                                        
       5600-WRITE-MNT-TRANS-HIST.                                       
                                                                        
           IF WS-KR125-MNT-APPL-PGM-ID <= SPACES                        
ACT115        IF WS-PROGRAM-ID-350          = 'CSR0232'                 
ACT115           MOVE 'CSR02329' TO WS-KR125-MNT-APPL-PGM-ID            
ACT115        ELSE                                                      
ACT115           IF WS-PROGRAM-ID-350       = 'CSR0349'                 
ACT115              MOVE 'CSR03495' TO WS-KR125-MNT-APPL-PGM-ID         
ACT115           ELSE                                                   
                    MOVE WS-CORRESP-CREATED-BY-PGM-ID TO                
                    WS-KR125-MNT-APPL-PGM-ID                            
ACT115           END-IF                                                 
ACT115        END-IF                                                    
           END-IF.                                                      
                                                                        
           INITIALIZE DCLCSS-MNT-TRANS-HIST.                            
           PERFORM 7100-GET-TIMESTAMP            THRU 7100-CPD125-EXIT. 
           MOVE WS-KR125-MNT-ACCOUNT-NO TO MH-ACCOUNT-NO                
           MOVE WS-KR125-MNT-PREMISE-NO TO MH-PREMISE-NO                
           MOVE WS-KR125-MNT-CUSTOMER-NO                                
                                        TO MH-CUSTOMER-NO.              
           MOVE WS-CURRENT-TIMESTAMP    TO MH-TRANS-HIST-SEQ-NO         
                                           WS-CORRESP-CREATE-DT.        
           MOVE WS-KR125-MNT-APPL-PGM-ID                                
                                        TO MH-APPL-PROGRAM-ID.          
           MOVE WS-KR125-MNT-DATE-TRANS TO MH-DATE-TRANS.               
           MOVE WS-KR125-CODE-TRAN-TYP  TO MH-CODE-TRAN-TYPE            
           MOVE WS-KR125-RESP-AREA-ID   TO MH-RESP-AREA-ID              
           MOVE WS-SYSTEM               TO MH-USER-ID.                  
           MOVE WS-KR125-TRAN-CMT       TO MH-TRAN-COMMENT.             
      *                                                                         
           PERFORM 6540-INSERT-MNT-TRANS-HIST  THRU 6540-EXIT.          
                                                                        
       5600-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5650-LOAD-CRED-MSG-REF-BATCH                                             
      *****************************************************************         
                                                                        
       5650-LOAD-CRED-MSG-REF-BATCH.                                    
                                                                        
           INITIALIZE WS-NOTICE-VARS.                                   
           MOVE 1                                TO WS-INDX             
           MOVE 0                                TO WS-ORDER-ROW-COUNT  
           SET  WS-CRED-MSG-INDX                 TO 1                   
                                                                        
           PERFORM 7710-OPEN-CRED-MSG-REF-BATCH  THRU 7710-CPD125-EXIT. 
           PERFORM 7720-FETCH-CRED-MSG-REF-BATCH THRU 7720-CPD125-EXIT. 
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 5700-LOAD-CRED-MSG-VAL-BATCH  THRU                
                                                    5700-CPD125-EXIT    
                  UNTIL WS-INDX > WS-ORDER-ROW-COUNT                    
                  OR WS-MSG-ID-ARR(WS-INDX) = SPACES                    
                                                                        
              MOVE 1             TO WS-INDX                             
                                                                        
              INITIALIZE WS-CWS102-MSG-REF-VARS                         
                                                                        
              PERFORM 7720-FETCH-CRED-MSG-REF-BATCH THRU                
                                                    7720-CPD125-EXIT    
           END-PERFORM.                                                 
                                                                        
      * IF NOT-FOUND OCCURS WHEN THERE IS A SUBSET ROW                          
           IF SQLERRD(3) > 0                                            
              PERFORM 5700-LOAD-CRED-MSG-VAL-BATCH  THRU                
                                                    5700-CPD125-EXIT    
                  UNTIL WS-INDX > WS-ORDER-ROW-COUNT                    
                  OR WS-MSG-ID-ARR(WS-INDX) = SPACES                    
           END-IF                                                       
                                                                        
           PERFORM 7730-CLOSE-CRED-MSG-BATCH-CSR THRU 7730-CPD125-EXIT. 
                                                                        
                                                                        
       5650-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5700-LOAD-CRED-MSG-VAL-BATCH                                             
      *****************************************************************         
       5700-LOAD-CRED-MSG-VAL-BATCH.                                    
                                                                        
           MOVE WS-MSG-ID-ARR(WS-INDX) TO WS-MSG-ID(WS-CRED-MSG-INDX)   
           MOVE WS-MSG-REF-COMPANY-NO-ARR(WS-INDX) TO                   
                WS-MSG-REF-COMPANY-NO(WS-CRED-MSG-INDX)                 
           MOVE WS-MSG-REF-REG-GRP-CD-ARR(WS-INDX) TO                   
                WS-MSG-REF-REG-GRP-CD(WS-CRED-MSG-INDX)                 
           MOVE WS-VAR-NM-ARR(WS-INDX) TO WS-VAR-NM(WS-CRED-MSG-INDX)   
           MOVE WS-VAR-DATA-ARR(WS-INDX)           TO                   
                WS-VAR-DATA(WS-CRED-MSG-INDX)                           
           MOVE WS-VAR-TYPE-ARR(WS-INDX)           TO                   
                WS-VAR-TYPE(WS-CRED-MSG-INDX)                           
           SET WS-CRED-MSG-INDX                    UP BY 1.             
           ADD 1                                   TO WS-INDX.          
                                                                        
       5700-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-TIMESTAMP.                                            *        
      * GET TIMESTAMP FOR MNT_TRANS_HIST FILE                          *        
      ******************************************************************        
                                                                        
       7100-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*           ,:WS-CURRENT-DATE      = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'SET'                TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'CURRENT TIMESTAMP'  TO TABLE-ELEMENT-1              
              MOVE WS-CURRENT-TIMESTAMP TO HOSTVAR-ELEMENT-1            
              MOVE 12                   TO RS-KR125-RETURN-CODE         
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
                                                                        
       7100-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-OPEN-CRED-MSG-CSR.                                        *        
      ******************************************************************        
                                                                        
       7500-OPEN-CRED-MSG-CSR.                                          
                                                                        
      *****************************************************************         
      *DECLARE CORRESP-CSR                                            *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE CRED-MSG-CSR CURSOR WITH ROWSET POSITIONING FOR   
                  SELECT [1I].MESSAGE_ID                                  
                        ,[1I].COMPANY_NO                                  
                        ,[1I].REG_GROUP_CD                                
                        ,[1I].MESSAGE_VAR_NM                              
                        ,[1I].MESSAGE_VAR_DATA                            
                        ,[1I].MESSAGE_VAR_TYP_CD                          
                  FROM CSS_CRED_MSG_REF  [1I] WITH(READUNCOMMITTED)             
                  WHERE [1I].MESSAGE_ID         = :1I-MESSAGE-ID          
                  ORDER BY [1I].COMPANY_NO ASC                            
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CRED-MSG-CSR CURSOR WITH ROWSET POSITIONING FOR           
MFA-TR*           SELECT 1I.MESSAGE_ID                                          
MFA-TR*                 ,1I.COMPANY_NO                                          
MFA-TR*                 ,1I.REG_GROUP_CD                                        
MFA-TR*                 ,1I.MESSAGE_VAR_NM                                      
MFA-TR*                 ,1I.MESSAGE_VAR_DATA                                    
MFA-TR*                 ,1I.MESSAGE_VAR_TYP_CD                                  
MFA-TR*           FROM CSS_CRED_MSG_REF  1I                                     
MFA-TR*           WHERE 1I.MESSAGE_ID         = :1I-MESSAGE-ID                  
MFA-TR*           ORDER BY 1I.COMPANY_NO ASC                                    
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              OPEN CRED-MSG-CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7500'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_CRED_MSG_REF'   TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 1I-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'MESSAGE_ID'         TO TABLE-ELEMENT-2              
              MOVE 1I-MESSAGE-ID        TO HOSTVAR-ELEMENT-2            
              MOVE 12                   TO RS-KR125-RETURN-CODE         
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       7500-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-FETCH-CRED-MSG-CSR.                                      *         
      ******************************************************************        
       7600-FETCH-CRED-MSG-CSR.                                         
                                                                        
           EXEC SQL                                                     
              FETCH CRED-MSG-CSR                                        
               INTO :1I-MESSAGE-ID                                      
                   ,:1I-COMPANY-NO                                      
                   ,:1I-REG-GROUP-CD                                    
                   ,:1I-MESSAGE-VAR-NM                                  
                   ,:1I-MESSAGE-VAR-DATA                                
                   ,:1I-MESSAGE-VAR-TYP-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7600'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_CRED_MSG_REF'   TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 1I-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'MESSAGE_ID'         TO TABLE-ELEMENT-2              
              MOVE 1I-MESSAGE-ID        TO HOSTVAR-ELEMENT-2            
              MOVE 12                   TO RS-KR125-RETURN-CODE         
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       7600-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-CLOSE-CRED-MSG-CSR                                        *        
      ******************************************************************        
                                                                        
       7700-CLOSE-CRED-MSG-CSR.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE CRED-MSG-CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7700'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_CRED_MSG_REF'   TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 1I-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'MESSAGE_ID'         TO TABLE-ELEMENT-2              
              MOVE 1I-MESSAGE-ID        TO HOSTVAR-ELEMENT-2            
              MOVE 12                   TO RS-KR125-RETURN-CODE         
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       7700-CPD125-EXIT.                                                
           EXIT.                                                        
      ******************************************************************        
      * 7710-OPEN-CRED-MSG-REF-BATCH                                            
      ******************************************************************        
                                                                        
       7710-OPEN-CRED-MSG-REF-BATCH.                                    
                                                                        
           EXEC SQL                                                     
              OPEN CRED-MSG-CSR-BATCH                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7710'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_CRED_MSG_REF'   TO TABLE-1                      
              MOVE 'MESSAGE_ID'         TO TABLE-ELEMENT-1              
              MOVE 1I-MESSAGE-ID        TO HOSTVAR-ELEMENT-1            
              MOVE 12                   TO RS-KR125-RETURN-CODE         
              PERFORM 9999-BAIL-OUT     THRU 9999-EXIT                  
           END-IF.                                                      
                                                                        
       7710-CPD125-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7720-FETCH-CRED-MSG-REF-BATCH                                           
      ******************************************************************        
       7720-FETCH-CRED-MSG-REF-BATCH.                                   

MSQ008     MOVE 500 TO MSQ008-CRED-MSG-CSR-BATCH
                                                                        
           EXEC SQL                                                     
              FOR :MSQ008-CRED-MSG-CSR-BATCH
              FETCH 
              FROM CRED-MSG-CSR-BATCH                 
                                                            
               INTO  :WS-MSG-ID-ARR                                     
                    ,:WS-MSG-REF-COMPANY-NO-ARR                         
                    ,:WS-MSG-REF-REG-GRP-CD-ARR                         
                    ,:WS-VAR-NM-ARR                                     
                    ,:WS-VAR-DATA-ARR                                   
                    ,:WS-VAR-TYPE-ARR                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM CRED-MSG-CSR-BATCH                         
MFA-TR*         FOR 500 ROWS                                                    
MFA-TR*        INTO  :WS-MSG-ID-ARR                                             
MFA-TR*             ,:WS-MSG-REF-COMPANY-NO-ARR                                 
MFA-TR*             ,:WS-MSG-REF-REG-GRP-CD-ARR                                 
MFA-TR*             ,:WS-VAR-NM-ARR                                             
MFA-TR*             ,:WS-VAR-DATA-ARR                                           
MFA-TR*             ,:WS-VAR-TYPE-ARR                                           
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-CRED-MSG-CSR-BATCH
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF SQLERRD (3) > 0                                        
                 MOVE SQLERRD (3)          TO WS-ORDER-ROW-COUNT        
              ELSE                                                      
                 MOVE 0                    TO WS-ORDER-ROW-COUNT        
              END-IF                                                    
              ADD WS-ORDER-ROW-COUNT       TO WS-C8-COUNT               
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                                                                        
                 EXEC SQL                                               
MSQ012              GET DIAGNOSTICS :MFA-GD-ROW-COUNT = ROW_COUNT     
MSQ012                              ,:MFA-GD-NUMBER        = NUMBER       
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*          EXEC SQL                                                       
MFA-TR*             GET DIAGNOSTICS :WS-ORDER-ROW-COUNT = ROW_COUNT             
MFA-TR*                             ,:WS-NUM-COND        = NUMBER               
MFA-TR*          END-EXEC                                                       
MSQ012           MOVE MFA-GD-ROW-COUNT TO WS-ORDER-ROW-COUNT
MSQ012           MOVE MFA-GD-NUMBER TO WS-NUM-COND
                                                                        
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                           ABEND-TABLES                 
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE WS-PGRMNAME          TO ABEND-PROGRAM             
                 MOVE '7720'               TO ACTIVE-PARAGRAPH          
                 MOVE 'CSS_CRED_MSG_REF'   TO TABLE-1                   
                 MOVE 'ROW COUNT'          TO TABLE-ELEMENT-1           
                 MOVE SQLERRD(3)           TO HOSTVAR-ELEMENT-1         
                 MOVE 'NUM COND'           TO TABLE-ELEMENT-2           
                 MOVE WS-NUM-COND          TO HOSTVAR-ELEMENT-2         
                 MOVE 12                   TO RS-KR125-RETURN-CODE      
                 PERFORM 9999-BAIL-OUT     THRU 9999-EXIT               
              ELSE                                                      
                 DISPLAY '********** CPD00341 ABORT  ************'      
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                           ABEND-TABLES                 
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE WS-PGRMNAME          TO ABEND-PROGRAM             
                 MOVE '7720'               TO ACTIVE-PARAGRAPH          
                 MOVE 12                   TO RS-KR125-RETURN-CODE      
                 PERFORM 9999-BAIL-OUT     THRU 9999-EXIT               
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7720-CPD125-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7730-CLOSE-CRED-MSG-BATCH-CSR                                  *        
      * CLOSE BILL_WINDOW CURSOR                                       *        
      ******************************************************************        
       7730-CLOSE-CRED-MSG-BATCH-CSR.                                   
                                                                        
           EXEC SQL                                                     
              CLOSE CRED-MSG-CSR-BATCH                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7730'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_CRED_MSG_REF'   TO TABLE-1                      
              MOVE 'MESSAGE_ID'         TO TABLE-ELEMENT-1              
              MOVE 1I-MESSAGE-ID        TO HOSTVAR-ELEMENT-1            
              MOVE 12                   TO RS-KR125-RETURN-CODE         
              PERFORM 9999-BAIL-OUT     THRU 9999-EXIT                  
           END-IF.                                                      
                                                                        
       7730-CPD125-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7740-GET-PREV-REG-GROUP-CD                                    *         
      * FOR ONLINE CALLS, GET THE PREV REG-GRP-CD AND SEQ-NO TO CHECK *         
      * IF THE REG-GRP HAS CHANGED FOR THE CUSTOMER.                  *         
      *****************************************************************         
                                                                        
       7740-GET-PREV-REG-GROUP-CD.                                      
                                                                        
           EXEC SQL                                                     
              SELECT CORRESP_ID                                         
                INTO :WS-PREV-CORRESP-ID                                
               FROM CSS_CORRESP_HDR                                     
               WHERE CUSTOMER_NO        = :1J-CUSTOMER-NO               
                 AND CORRESP_MSG_ID     = :1J-CORRESP-MSG-ID            
                 AND CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO        
                 AND CORRESP_STMT_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :1J-CORRESP-STMT-DT
              ) IS NULL OR (PATINDEX('%.%', :1J-CORRESP-STMT-DT
              ) <> 0) OR (LEN(:1J-CORRESP-STMT-DT
              ) <> 10), CIS.CHAR2DATE(:1J-CORRESP-STMT-DT
              ), CONVERT(DATE, :1J-CORRESP-STMT-DT) )           
                 AND REG_GROUP_CD       = :1J-REG-GROUP-CD              
                 AND CORRESP_STATUS_CD  = 'I'                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CORRESP_ID                                                 
MFA-TR*         INTO :WS-PREV-CORRESP-ID                                        
MFA-TR*        FROM CSS_CORRESP_HDR                                             
MFA-TR*        WHERE CUSTOMER_NO        = :1J-CUSTOMER-NO                       
MFA-TR*          AND CORRESP_MSG_ID     = :1J-CORRESP-MSG-ID                    
MFA-TR*          AND CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO                
MFA-TR*          AND CORRESP_STMT_DT    = :1J-CORRESP-STMT-DT                   
MFA-TR*          AND REG_GROUP_CD       = :1J-REG-GROUP-CD                      
MFA-TR*          AND CORRESP_STATUS_CD  = 'I'                                   
MFA-TR*      QUERYNO 7740                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                TO ABEND-TABLES                
                                            ABEND-SQL-PREDICATES        
              MOVE '7740'                TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE WS-PGRMNAME           TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE 1J-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              MOVE 'CORRESP_MSG_ID'      TO TABLE-ELEMENT-2             
              MOVE 1J-CORRESP-MSG-ID     TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE 1J-CORRESP-COMPANY-NO TO HOSTVAR-ELEMENT-3           
              MOVE 1J-REG-GROUP-CD       TO TABLE-ELEMENT-4             
              MOVE 1J-CORRESP-STMT-DT    TO HOSTVAR-ELEMENT-4           
              MOVE 12                    TO RS-KR125-RETURN-CODE        
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       7740-CPD125-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7750-GET-MAX-CORRESP-SEQ-NO                                   *         
      * FOR ONLINE CALLS, GET THE MAX SEQ-NO.                         *         
      *****************************************************************         
                                                                        
       7750-GET-MAX-CORRESP-SEQ-NO.                                     
                                                                        
           EXEC SQL                                                     
              SELECT COALESCE(MAX(CORRESP_SEQ_NO),0)                      
                INTO :WS-MAX-CORRESP-SEQ-NO                             
               FROM CSS_CORRESP_HDR                                     
               WHERE CUSTOMER_NO        = :1J-CUSTOMER-NO               
                 AND CORRESP_MSG_ID     = :1J-CORRESP-MSG-ID            
                 AND CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO        
                 AND CORRESP_STMT_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :1J-CORRESP-STMT-DT
              ) IS NULL OR (PATINDEX('%.%', :1J-CORRESP-STMT-DT
              ) <> 0) OR (LEN(:1J-CORRESP-STMT-DT
              ) <> 10), CIS.CHAR2DATE(:1J-CORRESP-STMT-DT
              ), CONVERT(DATE, :1J-CORRESP-STMT-DT) )           
                 AND CORRESP_STATUS_CD  = 'I'                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(MAX(CORRESP_SEQ_NO),0)                              
MFA-TR*         INTO :WS-MAX-CORRESP-SEQ-NO                                     
MFA-TR*        FROM CSS_CORRESP_HDR                                             
MFA-TR*        WHERE CUSTOMER_NO        = :1J-CUSTOMER-NO                       
MFA-TR*          AND CORRESP_MSG_ID     = :1J-CORRESP-MSG-ID                    
MFA-TR*          AND CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO                
MFA-TR*          AND CORRESP_STMT_DT    = :1J-CORRESP-STMT-DT                   
MFA-TR*          AND CORRESP_STATUS_CD  = 'I'                                   
MFA-TR*      QUERYNO 7750                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                TO ABEND-TABLES                
                                            ABEND-SQL-PREDICATES        
              MOVE '7750'                TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE WS-PGRMNAME           TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE 1J-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              MOVE 'CORRESP_MSG_ID'      TO TABLE-ELEMENT-2             
              MOVE 1J-CORRESP-MSG-ID     TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE 1J-CORRESP-COMPANY-NO TO HOSTVAR-ELEMENT-3           
              MOVE 'CORRESP_STMT_DT'     TO TABLE-ELEMENT-4             
              MOVE 1J-CORRESP-STMT-DT    TO HOSTVAR-ELEMENT-4           
              MOVE 12                    TO RS-KR125-RETURN-CODE        
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       7750-CPD125-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-INSERT-COMM-DATA.                                         *        
      ******************************************************************        
       8300-INSERT-COMM-DATA.                                           
                                                                        
           IF KO-RED-FLAG-EXPIRE-DT  = LOW-VALUES OR SPACES             
              MOVE -1                     TO WS-RED-FL-NULL-IND         
           ELSE                                                         
              MOVE ZERO                   TO WS-RED-FL-NULL-IND         
           END-IF                                                       
           IF KO-CALL-END-TIME = LOW-VALUES OR SPACES                   
              MOVE -1                     TO WS-END-NULL-IND            
           ELSE                                                         
              MOVE ZERO                   TO WS-END-NULL-IND            
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_COMM_DATA                                
                     ( COMMUNICATION_ID                                 
                      ,ACCOUNT_NO                                       
                      ,CUSTOMER_NO                                      
                      ,PREMISE_NO                                       
                      ,COMPANY_NO                                       
                      ,RED_FLAG_IND                                     
                      ,RED_FLAG_EXPIRE_DT                               
                      ,COMM_METHOD                                      
                      ,COMM_DIRECTION                                   
                      ,COMM_TYPE_CD                                     
                      ,COMM_SUBTYPE_CODE                                
                      ,USER_ID_ORIG                                     
                      ,CONTACT_NAME                                     
                      ,PROMOTION_ID                                     
                      ,PSC_COMPLIANCE_IND                               
                      ,CALL_ORIGIN_ID                                   
                      ,CALL_END_TIME                                    
                      ,NUMBER_TRANSFERS                                 
                      ,HOLD_TIME                                        
                      ,QUEUE_TIME                                       
                      ,SCREEN_POP_IND                                   
                      ,TOTAL_CALL_TIME                                  
                      ,INITIAL_COMMENT_TX                               
                      ,RESPONSE_REASON_CD                               
                      ,RESPONSE_TYPE_CD                                 
                      ,SOLICITATION_CD                                  
                      ,COMM_ASSOC_CD                                    
                      ,COMPLAINT_FL                                     
                      ,DISCOVERY_MTHD_CD                                
                      ,PREV_MARKETER_CD)                                
               VALUES(CIS.CURRENT$TIMESTAMP()                                 
                     ,:KO-ACCOUNT-NO                                    
                     ,:KO-CUSTOMER-NO                                   
                     ,:KO-PREMISE-NO                                    
                     ,:KO-COMPANY-NO                                    
                     ,:KO-RED-FLAG-IND                                  
                     ,CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                         :WS-RED-FL-NULL-IND)        
                     ,:KO-COMM-METHOD                                   
                     ,:KO-COMM-DIRECTION                                
                     ,:KO-COMM-TYPE-CD                                  
                     ,:KO-COMM-SUBTYPE-CODE                             
                     ,:KO-USER-ID-ORIG                                  
                     ,:KO-CONTACT-NAME                                  
                     ,:KO-PROMOTION-ID                                  
                     ,:KO-PSC-COMPLIANCE-IND                            
                     ,:KO-CALL-ORIGIN-ID                                
                     ,CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                         :WS-END-NULL-IND)                
                     ,:KO-NUMBER-TRANSFERS                              
                     ,:KO-HOLD-TIME                                     
                     ,:KO-QUEUE-TIME                                    
                     ,:KO-SCREEN-POP-IND                                
                     ,:KO-TOTAL-CALL-TIME                               
                     ,:KO-INITIAL-COMMENT-TX                            
                     ,:KO-RESPONSE-REASON-CD                            
                     ,:KO-RESPONSE-TYPE-CD                              
                     ,:KO-SOLICITATION-CD                               
                     ,:KO-COMM-ASSOC-CD                                 
                     ,:KO-COMPLAINT-FL                                  
                     ,:KO-DISCOVERY-MTHD-CD                             
                     ,:KO-PREV-MARKETER-CD)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_COMM_DATA                                        
MFA-TR*              ( COMMUNICATION_ID                                         
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,CUSTOMER_NO                                              
MFA-TR*               ,PREMISE_NO                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,RED_FLAG_IND                                             
MFA-TR*               ,RED_FLAG_EXPIRE_DT                                       
MFA-TR*               ,COMM_METHOD                                              
MFA-TR*               ,COMM_DIRECTION                                           
MFA-TR*               ,COMM_TYPE_CD                                             
MFA-TR*               ,COMM_SUBTYPE_CODE                                        
MFA-TR*               ,USER_ID_ORIG                                             
MFA-TR*               ,CONTACT_NAME                                             
MFA-TR*               ,PROMOTION_ID                                             
MFA-TR*               ,PSC_COMPLIANCE_IND                                       
MFA-TR*               ,CALL_ORIGIN_ID                                           
MFA-TR*               ,CALL_END_TIME                                            
MFA-TR*               ,NUMBER_TRANSFERS                                         
MFA-TR*               ,HOLD_TIME                                                
MFA-TR*               ,QUEUE_TIME                                               
MFA-TR*               ,SCREEN_POP_IND                                           
MFA-TR*               ,TOTAL_CALL_TIME                                          
MFA-TR*               ,INITIAL_COMMENT_TX                                       
MFA-TR*               ,RESPONSE_REASON_CD                                       
MFA-TR*               ,RESPONSE_TYPE_CD                                         
MFA-TR*               ,SOLICITATION_CD                                          
MFA-TR*               ,COMM_ASSOC_CD                                            
MFA-TR*               ,COMPLAINT_FL                                             
MFA-TR*               ,DISCOVERY_MTHD_CD                                        
MFA-TR*               ,PREV_MARKETER_CD)                                        
MFA-TR*        VALUES(CURRENT TIMESTAMP                                         
MFA-TR*              ,:KO-ACCOUNT-NO                                            
MFA-TR*              ,:KO-CUSTOMER-NO                                           
MFA-TR*              ,:KO-PREMISE-NO                                            
MFA-TR*              ,:KO-COMPANY-NO                                            
MFA-TR*              ,:KO-RED-FLAG-IND                                          
MFA-TR*              ,:KO-RED-FLAG-EXPIRE-DT :WS-RED-FL-NULL-IND                
MFA-TR*              ,:KO-COMM-METHOD                                           
MFA-TR*              ,:KO-COMM-DIRECTION                                        
MFA-TR*              ,:KO-COMM-TYPE-CD                                          
MFA-TR*              ,:KO-COMM-SUBTYPE-CODE                                     
MFA-TR*              ,:KO-USER-ID-ORIG                                          
MFA-TR*              ,:KO-CONTACT-NAME                                          
MFA-TR*              ,:KO-PROMOTION-ID                                          
MFA-TR*              ,:KO-PSC-COMPLIANCE-IND                                    
MFA-TR*              ,:KO-CALL-ORIGIN-ID                                        
MFA-TR*              ,:KO-CALL-END-TIME :WS-END-NULL-IND                        
MFA-TR*              ,:KO-NUMBER-TRANSFERS                                      
MFA-TR*              ,:KO-HOLD-TIME                                             
MFA-TR*              ,:KO-QUEUE-TIME                                            
MFA-TR*              ,:KO-SCREEN-POP-IND                                        
MFA-TR*              ,:KO-TOTAL-CALL-TIME                                       
MFA-TR*              ,:KO-INITIAL-COMMENT-TX                                    
MFA-TR*              ,:KO-RESPONSE-REASON-CD                                    
MFA-TR*              ,:KO-RESPONSE-TYPE-CD                                      
MFA-TR*              ,:KO-SOLICITATION-CD                                       
MFA-TR*              ,:KO-COMM-ASSOC-CD                                         
MFA-TR*              ,:KO-COMPLAINT-FL                                          
MFA-TR*              ,:KO-DISCOVERY-MTHD-CD                                     
MFA-TR*              ,:KO-PREV-MARKETER-CD)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_COMM_DATA'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE KO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 12                   TO RS-KR125-RETURN-CODE         
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       8300-CPD125-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8700-UPDATE-CORRESP-HDR.                                      *         
      *****************************************************************         
       8700-UPDATE-CORRESP-HDR.                                         
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_CORRESP_HDR                                    
                 SET CORRESP_STATUS_CD  = 'C'                           
               WHERE CUSTOMER_NO        = :1J-CUSTOMER-NO               
                 AND CORRESP_MSG_ID     = :1J-CORRESP-MSG-ID            
                 AND CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO        
                 AND CORRESP_STMT_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :1J-CORRESP-STMT-DT
              ) IS NULL OR (PATINDEX('%.%', :1J-CORRESP-STMT-DT
              ) <> 0) OR (LEN(:1J-CORRESP-STMT-DT
              ) <> 10), CIS.CHAR2DATE(:1J-CORRESP-STMT-DT
              ), CONVERT(DATE, :1J-CORRESP-STMT-DT) )           
                 AND REG_GROUP_CD       = :1J-REG-GROUP-CD              
                 AND CORRESP_STATUS_CD  = 'I'                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CORRESP_HDR                                            
MFA-TR*          SET CORRESP_STATUS_CD  = 'C'                                   
MFA-TR*        WHERE CUSTOMER_NO        = :1J-CUSTOMER-NO                       
MFA-TR*          AND CORRESP_MSG_ID     = :1J-CORRESP-MSG-ID                    
MFA-TR*          AND CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO                
MFA-TR*          AND CORRESP_STMT_DT    = :1J-CORRESP-STMT-DT                   
MFA-TR*          AND REG_GROUP_CD       = :1J-REG-GROUP-CD                      
MFA-TR*          AND CORRESP_STATUS_CD  = 'I'                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                TO ABEND-TABLES                
                                            ABEND-SQL-PREDICATES        
              MOVE '8700'                TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE WS-PGRMNAME           TO ABEND-PROGRAM               
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE 1J-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              MOVE 'CORRESP_ID'          TO TABLE-ELEMENT-2             
              MOVE 1J-CORRESP-MSG-ID     TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE 1J-CORRESP-COMPANY-NO TO HOSTVAR-ELEMENT-3           
              MOVE 'CORRESP_STMT_DT'     TO TABLE-ELEMENT-4             
              MOVE 1J-CORRESP-STMT-DT    TO HOSTVAR-ELEMENT-4           
              MOVE 12                    TO RS-KR125-RETURN-CODE        
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       8700-CPD125-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8800-DELETE-CORRESP-HDR                                       *         
      *****************************************************************         
                                                                        
       8800-DELETE-CORRESP-HDR.                                         
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CORRESP_HDR                               
               WHERE CORRESP_ID         = :WS-PREV-CORRESP-ID           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                TO ABEND-TABLES                
                                            ABEND-SQL-PREDICATES        
              MOVE '8800'                TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE WS-PGRMNAME           TO ABEND-PROGRAM               
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
              MOVE 'CORRESP_ID'          TO TABLE-ELEMENT-1             
              MOVE WS-PREV-CORRESP-ID    TO HOSTVAR-ELEMENT-1           
              MOVE 12                    TO RS-KR125-RETURN-CODE        
              PERFORM 9999-BAIL-OUT            THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
       8800-CPD125-EXIT.                                                
           EXIT.                                                        
