      *****************************************************************         
      **  CPDCB107 COPYBOOK TO RETRIEVE EDITED MANUAL BILL DATA FOR  **         
      **                       BILL CALC                             **         
      **.............................................................**         
      **                                                             **         
      **  I/O: CWSCB107 COPYBOOK                                     **         
      **                                                             **         
      **  REQUIRED INPUT PARAMETERS:                                 **         
      **       WS-CPD107B-ACCOUNT-NO                                 **         
      **       WS-CPD107B-BILL-NO                                    **         
      **       WS-CPD107B-CODE-UTIL-TYPE                             **         
      **       WS-CPD107B-IC-NO                                      **         
      **       WS-CPD107B-BILL-TIMESTMP                              **         
      **                                                             **         
      **  OPTIONAL INPUT PARAMETERS:                                 **         
      **       NONE                                                  **         
      **                                                             **         
      **  PROCEDURE REFERENCE: CPDCA107                              **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      *   MODIFICATION LOG -                                          *         
      *                                                               *         
      *   DATE     INITIALS        COMMENTS                           *         
      *  ------    --------        -----------------------------------*         
      * 09/16/11   SS97726         INTIALLY WRITTEN.                  *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      * 6000-CPD107B-MAIN-PROCESS.                                    *         
      * POPULATE REQUIRED PARAMETERS AND GET THE MANUAL BILL DETAILS  *         
      *****************************************************************         
      *                                                                         
       6000-CPD107B-MAIN-PROCESS.                                       
      *                                                                         
           PERFORM 6005-CPD107B-INPUT-PROCESS  THRU 6005-CPD107B-EXIT.  
                                                                        
           PERFORM 6010-CPD107B-OUTPUT-PROCESS THRU 6010-CPD107B-EXIT.  
      *                                                                         
       6000-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6005-CPD107B-INPUT-PROCESS.                                    *        
      ******************************************************************        
      *                                                                         
       6005-CPD107B-INPUT-PROCESS.                                      
      *                                                                         
           MOVE WS-CPD107B-ACCOUNT-NO       TO NG-ACCOUNT-NO            
                                               NU-ACCOUNT-NO.           
           MOVE WS-CPD107B-CODE-UTIL-TYPE   TO NG-CODE-UTIL-TYPE        
                                               NU-CODE-UTIL-TYPE.       
           MOVE WS-CPD107B-IC-NO            TO NG-IC-NO                 
                                               NU-IC-NO.                
           MOVE WS-CPD107B-BILL-NO          TO NG-BILL-NO               
                                               NU-BILL-NO.              
           MOVE WS-CPD107B-BILL-TIMESTMP    TO NG-BILL-ITEM-TIMESTMP    
                                               NU-BILL-ITEM-TIMESTMP.   
                                                                        
           MOVE WS-BC                       TO WS-NU-TBL1.              
           MOVE WS-BG                       TO WS-NU-TBL2.              
           MOVE WS-BA                       TO WS-NU-TBL3.              
           MOVE WS-CX                       TO WS-NU-TBL4.              
           MOVE WS-UC                       TO WS-NU-TBL5.              
           MOVE WS-BX                       TO WS-NU-TBL6.              
           MOVE WS-LO                       TO WS-NU-TBL7.              
           MOVE WS-XD                       TO WS-NU-TBL8.              
                                                                        
           MOVE 'N'                         TO WS-CPD107B-BILL-MAN-SW.  
           MOVE ZEROES                      TO WS-CPD107B-RETURN-CODE.  
      *                                                                         
       6005-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6010-CPD107B-OUTPUT-PROCESS.                                   *        
      ******************************************************************        
      *                                                                         
       6010-CPD107B-OUTPUT-PROCESS.                                     
      *                                                                         
           PERFORM 6060-CPD107B-GET-MANBILL-HDR                         
                                               THRU 6060-CPD107B-EXIT.  
           IF CPD107B-HAS-BILL-MAN                                      
              INITIALIZE  WS-BILLING-COMPONENT                          
                          WS-BILLING-ADJUSTMENT                         
                          WS-BILL-CALC-DETAIL-X                         
                          WS-BILL-CALC-CX                               
                          WS-BILL-CALC-UC                               
                          WS-BC-FIXED-FCTR-FF                           
                          WS-BC-ACCT-RTPK-AGR-DF                        
                          WS-BILL-CALC-FH                               
                          WS-INTERRUPT-IR                               
                          WS-INTERRUPT-NZ                               
                          WS-CNSMPTN-HOURLY                             
                                                                        
              PERFORM 6065-CPD107B-OPEN-MANBILL-DET                     
                                               THRU 6065-CPD107B-EXIT   
              PERFORM 6070-CPD107B-FETCH-MANBILL-DET                    
                                               THRU 6070-CPD107B-EXIT   
              PERFORM 6015-CPD107B-LOAD-MANBILL-DET                     
                                               THRU 6015-CPD107B-EXIT   
                UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND             
              PERFORM 6075-CPD107B-CLOSE-MANBILL-DET                    
                                               THRU 6075-CPD107B-EXIT   
           ELSE                                                         
              MOVE 'N'                      TO WS-CPD107B-BILL-MAN-SW   
              MOVE ZEROES                   TO WS-CPD107B-RETURN-CODE   
           END-IF.                                                      
      *                                                                         
       6010-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6015-CPD107B-LOAD-MANBILL-DET.                                *         
      *****************************************************************         
      *                                                                         
       6015-CPD107B-LOAD-MANBILL-DET.                                   
      *                                                                         
           EVALUATE NU-BILL-MANUAL-TBL-ID                               
               WHEN WS-BG                                               
                  PERFORM 6020-CPD107B-LOAD-BG THRU 6020-CPD107B-EXIT   
               WHEN WS-BC                                               
                  PERFORM 6025-CPD107B-LOAD-BC THRU 6025-CPD107B-EXIT   
               WHEN WS-BA                                               
                  PERFORM 6030-CPD107B-LOAD-BA THRU 6030-CPD107B-EXIT   
               WHEN WS-XD                                               
                  PERFORM 6035-CPD107B-LOAD-XD THRU 6035-CPD107B-EXIT   
               WHEN WS-LO                                               
                  PERFORM 6040-CPD107B-LOAD-LO THRU 6040-CPD107B-EXIT   
               WHEN WS-BX                                               
                  PERFORM 6045-CPD107B-LOAD-BX THRU 6045-CPD107B-EXIT   
               WHEN WS-CX                                               
                  PERFORM 6050-CPD107B-LOAD-CX THRU 6050-CPD107B-EXIT   
               WHEN WS-UC                                               
                  PERFORM 6055-CPD107B-LOAD-UC THRU 6055-CPD107B-EXIT   
           END-EVALUATE.                                                
                                                                        
           PERFORM 6070-CPD107B-FETCH-MANBILL-DET                       
                                               THRU 6070-CPD107B-EXIT.  
      *                                                                         
       6015-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6020-CPD107B-LOAD-BG.                                         *         
      *****************************************************************         
      *                                                                         
       6020-CPD107B-LOAD-BG.                                            
      *                                                                         
           INITIALIZE                       WS-N-BILLING-BG.            
           MOVE NU-BILL-MANUAL-DATA-TEXT TO WS-N-BILLING-BG             
           PERFORM 6021-CPD107B-TRNSFR-BG   THRU 6021-CPD107B-EXIT.     
      *                                                                         
       6020-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6021-CPD107B-TRNSFR-BG.                                       *         
      *****************************************************************         
      *                                                                         
       6021-CPD107B-TRNSFR-BG.                                          
      *                                                                         
           MOVE NU-ACCOUNT-NO            TO WS-BC-ACCOUNT-NO-BG.        
           MOVE NU-BILL-NO               TO WS-BC-BILL-NO-BG.           
           MOVE NU-CODE-UTIL-TYPE        TO WS-BC-CODE-UTIL-TYPE-BG.    
           MOVE NU-IC-NO                 TO WS-BC-IC-NO-BG.             
           MOVE NU-BILL-ITEM-TIMESTMP    TO WS-BC-BILL-ITEM-TIMESTMP-BG.
           MOVE WS-N-PREMISE-NO-BG       TO WS-BC-PREMISE-NO-BG.        
           MOVE WS-N-AMT-BILL-ITEM-BG    TO WS-BC-AMT-BILL-ITEM-BG.     
           MOVE WS-N-AMT-STATE-TAX-BG    TO WS-BC-AMT-STATE-TAX-BG.     
           MOVE WS-N-AMT-CITY-TAX-BG     TO WS-BC-AMT-CITY-TAX-BG.      
           MOVE WS-N-AMT-OTHER-TAX-BG    TO WS-BC-AMT-OTHER-TAX-BG.     
           MOVE WS-N-CODE-REVENUE-CLASS-BG                              
                                         TO WS-BC-CODE-REVENUE-CLASS-BG.
           MOVE WS-N-CODE-SIC-NO-BG      TO WS-BC-CODE-SIC-NO-BG.       
           MOVE WS-N-RATE-PLAN-NO-BG     TO WS-BC-RATE-PLAN-NO-BG.      
           MOVE WS-N-CODE-CURTAIL-PRTY-BG                               
                                         TO WS-BC-CODE-CURTAIL-PRTY-BG. 
           MOVE WS-N-CODE-STAT-TAX-XMT-BG                               
                                         TO WS-BC-CODE-STAT-TAX-XMT-BG. 
           MOVE WS-N-CODE-CITY-TAX-XMT-BG                               
                                         TO WS-BC-CODE-CITY-TAX-XMT-BG. 
           MOVE WS-N-CODE-OTHR-TAX-XMT-BG                               
                                         TO WS-BC-CODE-OTHR-TAX-XMT-BG. 
           MOVE WS-N-STANDBY-COMPLIED-BG TO WS-BC-STANDBY-COMPLIED-BG.  
           MOVE WS-N-NEW-RATE-PCT-BG     TO WS-BC-NEW-RATE-PCT-BG.      
           MOVE WS-N-CODE-SUB-TOTAL-BG   TO WS-BC-CODE-SUB-TOTAL-BG.    
           MOVE WS-N-TAX-REFUND-CD-BG    TO WS-BC-TAX-REFUND-CD-BG.     
           MOVE WS-N-COMPANY-NO-BG       TO WS-BC-COMPANY-NO-BG.        
           MOVE WS-N-DATE-LFTM-HI-DMD-BG TO WS-BC-DATE-LFTM-HI-DMD-BG.  
           MOVE WS-N-LFTM-HI-PEAK-DMD-BG TO WS-BC-LFTM-HI-PEAK-DMD-BG.  
           MOVE WS-N-GAS-BASE-USE-BG     TO WS-BC-GAS-BASE-USE-BG.      
           MOVE WS-N-WNA-FACTOR-BG       TO WS-BC-WNA-FACTOR-BG.        
           MOVE WS-N-BTU-FACTOR-BG       TO WS-BC-BTU-FACTOR-BG.        
           MOVE WS-N-UPDATE-ACTION-IND-BG                               
                                         TO WS-BC-UPDATE-ACTION-IND-BG. 
           MOVE WS-N-CONTRACT-DEM-CALC   TO WS-BC-CONTRACT-DEM-CALC.    
           MOVE WS-N-POWER-FACTOR-CALC   TO WS-BC-POWER-FACTOR-CALC.    
           MOVE WS-N-RATCHET-DEM-USED-CALC                              
                                         TO WS-BC-RATCHET-DEM-USED-CALC.
           MOVE WS-N-RATCHET-DATE-CALC   TO WS-BC-RATCHET-DATE-CALC.    
           MOVE WS-N-RATCHET-PCT-CALC    TO WS-BC-RATCHET-PCT-CALC.     
           MOVE WS-N-FUEL-SHIPPER-CD-BG  TO WS-BC-FUEL-SHIPPER-CD-BG.   
           MOVE WS-N-CIG-CUSTOMER-IND-BG TO WS-BC-CIG-CUSTOMER-IND-BG.  
           MOVE WS-N-CIG-TRNSP-DET-BG    TO WS-BC-CIG-TRNSP-DET-BG.     
           MOVE WS-N-BILL-CALC-CYCLE-BG  TO WS-BC-BILL-CALC-CYCLE-BG.   
           MOVE WS-N-NAICS-CD-BG         TO WS-BC-NAICS-CD-BG.          
           MOVE WS-N-LOAD-FACTOR-CALC    TO WS-BC-LOAD-FACTOR-CALC.     
           MOVE WS-N-RT-PKG-OPT-SEQ-NO-BG                               
                                         TO WS-BC-RT-PKG-OPT-SEQ-NO-BG. 
           MOVE WS-N-SPLY-SENSITIVE-IND-BG                              
                                         TO WS-BC-SPLY-SENSITIVE-IND-BG.
           MOVE WS-N-CODE-MTR-READ-FREQ-BG                              
                                         TO WS-BC-CODE-MTR-READ-FREQ-BG.
           MOVE WS-N-PRORATED-ON-NBR-DAYS-BG                            
             TO WS-BC-PRORATED-ON-NBR-DAYS-BG.                          
                                                                        
      *POPULATE THE RETURN CALC FIELDS FROM BILL CALC                           
           MOVE WS-N-NO-OF-CONS-DAYS-BG  TO WS-BC-NO-CNSMPTN-DAYS.      
           MOVE WS-N-USAGE-END-DATE-CALC TO WS-BC-CNSMPTN-END-DATE.     
           PERFORM 6080-CPD107B-GET-CNSMPTN-START                       
                                            THRU 6080-CPD107B-EXIT.     
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-CPD107B-DATE-1     TO WS-BC-CNSMPTN-START-DATE    
           END-IF.                                                      
      *                                                                         
       6021-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6025-CPD107B-LOAD-BC.                                         *         
      *****************************************************************         
      *                                                                         
       6025-CPD107B-LOAD-BC.                                            
      *                                                                         
           INITIALIZE                       WS-N-BILL-CALC-DETAIL.      
           MOVE NU-BILL-MANUAL-DATA-TEXT TO WS-N-BILL-CALC-DETAIL.      
           PERFORM 6026-CPD107B-TRNSFR-BC   THRU 6026-CPD107B-EXIT.     
      *                                                                         
       6025-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6026-CPD107B-TRNSFR-BC.                                       *         
      *****************************************************************         
      *                                                                         
       6026-CPD107B-TRNSFR-BC.                                          
      *                                                                         
           SET BC-INDX                   TO 1.                          
                                                                        
           SEARCH WS-BC-COMPONENT                                       
             AT END                                                     
                  CONTINUE                                              
             WHEN WS-BC-COMPONENT-ID (BC-INDX) EQUAL SPACES             
                  MOVE WS-N-COMPONENT-ID-BC                             
                       TO WS-BC-COMPONENT-ID (BC-INDX)                  
                  MOVE WS-N-CONSUMPTION-TYPE-BC                         
                       TO WS-BC-CONSUMPTION-TYPE (BC-INDX)              
                  MOVE WS-N-REGISTER-TYPE-BC                            
                       TO WS-BC-REGISTER-TYPE (BC-INDX)                 
                  MOVE WS-N-CODE-TOU-BC                                 
                       TO WS-BC-CODE-TOU (BC-INDX)                      
                  MOVE WS-N-CODE-SEASON-BC                              
                       TO WS-BC-CODE-SEASON (BC-INDX)                   
                  MOVE WS-N-RATE-VERSION-BC                             
                       TO WS-BC-RATE-VERSION (BC-INDX)                  
                  MOVE WS-N-READ-UNITS-BC                               
                       TO WS-BC-READ-UNITS (BC-INDX)                    
                  MOVE WS-N-NO-READ-ENTRIES-BC                          
                       TO WS-BC-NO-READ-ENTRIES (BC-INDX)               
                  MOVE WS-N-NET-UNITS-BC                                
                       TO WS-BC-NET-UNITS (BC-INDX)                     
                  MOVE WS-N-NET-UNIT-SEL-RSN-BC                         
                       TO WS-BC-NET-UNIT-SEL-RSN (BC-INDX)              
                  MOVE WS-N-BLOCKS-USED-BC                              
                       TO WS-BC-BLOCKS-USED (BC-INDX)                   
                  SET  BLK-INDX          TO 1                           
                  PERFORM VARYING WS-N-BLK-INDX FROM 1 BY 1             
                          UNTIL WS-N-BLK-INDX > 9                       
                     MOVE WS-N-BLOCK-SIZE-BC (WS-N-BLK-INDX)            
                          TO WS-BC-BLOCK-SIZE (BC-INDX BLK-INDX)        
                     MOVE WS-N-UNITS-BILLED-BC (WS-N-BLK-INDX)          
                          TO WS-BC-UNITS-BILLED (BC-INDX BLK-INDX)      
                     MOVE WS-N-PRICE-TYPE-CD-BC (WS-N-BLK-INDX)         
                          TO WS-BC-PRICE-TYPE-CD (BC-INDX BLK-INDX)     
                     MOVE WS-N-AMT-BASE-RATE-BC (WS-N-BLK-INDX)         
                          TO WS-BC-AMT-BASE-RATE (BC-INDX BLK-INDX)     
                     MOVE WS-N-AMT-NET-RATE-BC (WS-N-BLK-INDX)          
                          TO WS-BC-AMT-NET-RATE (BC-INDX BLK-INDX)      
                     MOVE WS-N-AMT-BLOCK-BC (WS-N-BLK-INDX)             
                          TO WS-BC-AMT-BLOCK (BC-INDX BLK-INDX)         
                     MOVE WS-N-WNA-BLOCK-FCT-BC (WS-N-BLK-INDX)         
                          TO WS-BC-WNA-BLOCK-FCT (BC-INDX BLK-INDX)     
                     MOVE WS-N-WNA-BLOCK-AMT-BC (WS-N-BLK-INDX)         
                          TO WS-BC-WNA-BLOCK-AMT (BC-INDX BLK-INDX)     
                     SET  BLK-INDX UP BY 1                              
                  END-PERFORM                                           
                  MOVE WS-N-CALC-COMPONENT-AMT-BC                       
                       TO WS-BC-CALC-COMPONENT-AMT (BC-INDX)            
                  MOVE WS-N-NET-COMPONENT-AMT-BC                        
                       TO WS-BC-NET-COMPONENT-AMT (BC-INDX)             
                  MOVE WS-N-SEAS-PRORATE-PCT-BC                         
                       TO WS-BC-SEAS-PRORATE-PCT (BC-INDX)              
                  MOVE WS-N-CUST-PER-SERVICE-BC                         
                       TO WS-BC-CUST-PER-SERVICE (BC-INDX)              
                  MOVE WS-N-FIXED-UM-KWH-BC                             
                       TO WS-BC-FIXED-UM-KWH (BC-INDX)                  
                  MOVE WS-N-RATE-ITEM-CODE-BC                           
                       TO WS-BC-RATE-ITEM-CODE (BC-INDX)                
                  MOVE WS-N-FIRST-WNA-BLOCK-BC                          
                       TO WS-BC-FIRST-WNA-BLOCK (BC-INDX)               
                  MOVE WS-N-USE-VAR-FUEL-BC                             
                       TO WS-BC-USE-VAR-FUEL (BC-INDX)                  
                  MOVE WS-N-EVENT-DATE-BC                               
                       TO WS-BC-EVENT-DATE (BC-INDX)                    
                  MOVE WS-N-TOTAL-WNA-AMT-BC                            
                       TO WS-BC-TOTAL-WNA-AMT (BC-INDX)                 
           END-SEARCH.                                                  
      *                                                                         
       6026-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6030-CPD107B-LOAD-BA.                                         *         
      *****************************************************************         
      *                                                                         
       6030-CPD107B-LOAD-BA.                                            
      *                                                                         
           INITIALIZE                       WS-N-BILL-ADJUST-DETAIL.    
           MOVE NU-BILL-MANUAL-DATA-TEXT TO WS-N-BILL-ADJUST-DETAIL.    
           PERFORM 6031-CPD107B-TRNSFR-BA   THRU 6031-CPD107B-EXIT.     
      *                                                                         
       6030-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6031-CPD107B-TRNSFR-BA.                                       *         
      *****************************************************************         
      *                                                                         
       6031-CPD107B-TRNSFR-BA.                                          
      *                                                                         
           SET BA-INDX                   TO 1.                          
                                                                        
           SEARCH WS-BC-ADJUSTMENT                                      
             AT END                                                     
                  CONTINUE                                              
             WHEN WS-BC-FACTOR-ID (BA-INDX) EQUAL SPACES                
                  MOVE WS-N-FACTOR-ID-BA                                
                       TO WS-BC-FACTOR-ID (BA-INDX)                     
                  MOVE WS-N-FCT-CMPNT-ID-BA                             
                       TO WS-BC-FCT-CMPNT-ID (BA-INDX)                  
                  MOVE WS-N-FCT-CNSMPT-TYPE-BA                          
                       TO WS-BC-FCT-CNSMPT-TYPE (BA-INDX)               
                  MOVE WS-N-FCT-REGISTER-TYPE-BA                        
                       TO WS-BC-FCT-REGISTER-TYPE (BA-INDX)             
                  MOVE WS-N-FCT-TOU-BA                                  
                       TO WS-BC-FCT-TOU (BA-INDX)                       
                  MOVE WS-N-FCT-SEASON-BA                               
                       TO WS-BC-FCT-SEASON (BA-INDX)                    
                  MOVE WS-N-FCT-RATE-VERSION-BA                         
                       TO WS-BC-FCT-RATE-VERSION (BA-INDX)              
                  MOVE WS-N-CODE-CALC-TYPE-BA                           
                       TO WS-BC-CODE-CALC-TYPE (BA-INDX)                
                  MOVE WS-N-CODE-ADJ-UNIT-SOURCE-BA                     
                       TO WS-BC-CODE-ADJ-UNIT-SOURCE (BA-INDX)          
                  MOVE WS-N-CODE-ADJUST-TYPE-BA                         
                       TO WS-BC-CODE-ADJUST-TYPE (BA-INDX)              
                  MOVE WS-N-ADJ-UNITS-BA                                
                       TO WS-BC-ADJ-UNITS (BA-INDX)                     
                  MOVE WS-N-FACTOR-BA                                   
                       TO WS-BC-FACTOR (BA-INDX)                        
                  MOVE WS-N-AMT-ADJUSTMENT-BA                           
                       TO WS-BC-AMT-ADJUSTMENT (BA-INDX)                
                  MOVE WS-N-STATE-TAX-XMPT-ADJ-BA                       
                       TO WS-BC-STATE-TAX-XMPT-ADJ (BA-INDX)            
                  MOVE WS-N-CITY-TAX-XMPT-ADJ-BA                        
                       TO WS-BC-CITY-TAX-XMPT-ADJ (BA-INDX)             
                  MOVE WS-N-OTHER-TAX-XMPT-ADJ-BA                       
                       TO WS-BC-OTHER-TAX-XMPT-ADJ (BA-INDX)            
                  MOVE WS-N-GL-COMPANY-NO-BA                            
                       TO WS-BC-GL-COMPANY-NO-ADJ (BA-INDX)             
                  MOVE WS-N-GL-ACCOUNT-NO-BA                            
                       TO WS-BC-GL-ACCOUNT-NO-ADJ (BA-INDX)             
                  MOVE WS-N-GL-LOCAL-OFFICE-BA                          
                       TO WS-BC-GL-LOCAL-OFFICE-ADJ (BA-INDX)           
                  MOVE WS-N-PRORATE-FL-BA                               
                       TO WS-BC-PRORATE-FL (BA-INDX)                    
                  MOVE WS-N-SPCL-GROUP-CD-BA                            
                       TO WS-BC-SPCL-GROUP-CD (BA-INDX)                 
                  MOVE WS-N-REV-INTERFACE-FL-BA                         
                       TO WS-BC-REV-INTERFACE-FL (BA-INDX)              
                  MOVE WS-N-OVR-RT-CALC-TYP-CD-BA                       
                       TO WS-BC-OVR-RT-CALC-TYP-CD (BA-INDX)            
                  MOVE WS-N-FACTOR-TYPE-BA                              
                       TO WS-BC-FACTOR-TYPE (BA-INDX)                   
                  MOVE WS-N-DURATION-START-CD-BA                        
                       TO WS-BC-DURATION-START-CD (BA-INDX)             
                  MOVE WS-N-BILL-PRT-MSG-PL-CD-BA                       
                       TO WS-BC-BILL-PRT-MSG-PL-CD (BA-INDX)            
                  MOVE WS-N-BILL-PRT-LN-ITM-FL-BA                       
                       TO WS-BC-BILL-PRT-LN-ITM-FL (BA-INDX)            
                  MOVE WS-N-FACTOR-HISTORY-CD-BA                        
                       TO WS-BC-FACTOR-HISTORY-CD (BA-INDX)             
                  MOVE WS-N-RT-PKG-OPT-SEQ-NO-BA                        
                       TO WS-BC-RT-PKG-OPT-SEQ-NO (BA-INDX)             
                  MOVE WS-N-BLOCK-NO-BA                                 
                       TO WS-BC-BLOCK-NO (BA-INDX)                      
                  MOVE WS-N-ITEM-SEQ-NO-BA                              
                       TO WS-BC-ITEM-SEQ-NO-BA (BA-INDX)                
                  MOVE WS-N-RATE-FROM-DATE-BA                           
                       TO WS-BC-RATE-FROM-DATE (BA-INDX)                
                  MOVE WS-N-PRORATE-CD-BA                               
                       TO WS-BC-PRORATE-CD (BA-INDX)                    
                  MOVE WS-N-R-FACTOR-BA                                 
                       TO WS-BC-R-FACTOR (BA-INDX)                      
                  MOVE WS-N-SPECIAL-CALC-CD-BA                          
                       TO WS-BC-SPECIAL-CALC-CD (BA-INDX)               
                  MOVE WS-N-BILL-PRT-FCTR-CD-BA                         
                       TO WS-BC-BILL-PRT-FCTR-CD (BA-INDX)              
                  MOVE WS-N-BILL-PRT-UNITS-CD-BA                        
                       TO WS-BC-BILL-PRT-UNITS-CD (BA-INDX)             
                  MOVE WS-N-BILL-PRT-SEQ-NO-BA                          
                       TO WS-BC-BILL-PRT-SEQ-NO (BA-INDX)               
                  MOVE WS-N-FCTR-ELEM-APPL-CD-BA                        
                       TO WS-BC-FCTR-ELEM-APPL-CD (BA-INDX)             
                  MOVE WS-N-MULTI-VRSN-BA-CD-BA                         
                       TO WS-BC-MULTI-VRSN-BA-CD (BA-INDX)              
           END-SEARCH.                                                  
      *                                                                         
       6031-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6035-CPD107B-LOAD-XD.                                         *         
      *****************************************************************         
      *                                                                         
       6035-CPD107B-LOAD-XD.                                            
      *                                                                         
           INITIALIZE                       WS-N-BILL-CALC-X-DETAIL.    
           MOVE NU-BILL-MANUAL-DATA-TEXT TO WS-N-BILL-CALC-X-DETAIL.    
           PERFORM 6036-CPD107B-TRNSFR-XD   THRU 6036-CPD107B-EXIT.     
      *                                                                         
       6035-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6036-CPD107B-TRNSFR-XD.                                       *         
      *****************************************************************         
      *                                                                         
       6036-CPD107B-TRNSFR-XD.                                          
      *                                                                         
           SET WS-CALC-INDX-X            TO 1.                          
                                                                        
           SEARCH WS-BILL-CALC-DATA-X                                   
             AT END                                                     
                  CONTINUE                                              
             WHEN WS-BC-COMPONENT-ID-XD (WS-CALC-INDX-X) EQUAL SPACES   
                  MOVE WS-N-COMPONENT-ID-XD                             
                       TO WS-BC-COMPONENT-ID-XD (WS-CALC-INDX-X)        
                  MOVE WS-N-CONSUMPTION-TYPE-XD                         
                       TO WS-BC-CONSUMPTION-TYPE-XD (WS-CALC-INDX-X)    
                  MOVE WS-N-REGISTER-TYPE-XD                            
                       TO WS-BC-REGISTER-TYPE-XD (WS-CALC-INDX-X)       
                  MOVE WS-N-CODE-TOU-XD                                 
                       TO WS-BC-CODE-TOU-XD (WS-CALC-INDX-X)            
                  MOVE WS-N-CODE-SEASON-XD                              
                       TO WS-BC-CODE-SEASON-XD (WS-CALC-INDX-X)         
                  MOVE WS-N-RATE-VERSION-XD                             
                       TO WS-BC-RATE-VERSION-XD (WS-CALC-INDX-X)        
                  MOVE WS-N-ITEM-SEQ-NO-XD                              
                       TO WS-BC-ITEM-SEQ-NO-XD (WS-CALC-INDX-X)         
                  MOVE WS-N-RATE-FROM-DATE-XD                           
                       TO WS-BC-RATE-FROM-DATE-XD (WS-CALC-INDX-X)      
                  MOVE WS-N-VERS-PRO-CD-XD                              
                       TO WS-BC-VERS-PRO-CD-XD (WS-CALC-INDX-X)         
                  MOVE WS-N-NO-LIGHT-POLE-UNITS-XD                      
                       TO WS-BC-LIGHT-POLE-UNITS-XD (WS-CALC-INDX-X)    
                  MOVE WS-N-KW-MDQ-DT-XD                                
                       TO WS-BC-KW-MDQ-DT-XD (WS-CALC-INDX-X)           
                  MOVE WS-N-KVA-DT-XD                                   
                       TO WS-BC-KVA-DT-XD (WS-CALC-INDX-X)              
                  MOVE WS-N-EVENT-NUMBER-XD                             
                       TO WS-BC-EVENT-NUMBER-XD (WS-CALC-INDX-X)        
                  SET  BLK-DESC-INDX     TO 1                           
                  PERFORM VARYING N-BLK-DESC-INDX FROM 1 BY 1           
                          UNTIL N-BLK-DESC-INDX > 9                     
                     MOVE WS-N-BLOCK-DESC-XD (N-BLK-DESC-INDX)          
                          TO WS-BC-BLOCK-DESC-XD                        
                                (WS-CALC-INDX-X BLK-DESC-INDX)          
                     SET  BLK-DESC-INDX UP BY 1                         
                  END-PERFORM                                           
                  MOVE WS-N-RT-CMPNT-DESC-LONG-XD                       
                       TO WS-BC-RT-CMPNT-DESC-LONG-XD (WS-CALC-INDX-X)  
           END-SEARCH.                                                  
      *                                                                         
       6036-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6040-CPD107B-LOAD-LO.                                         *         
      *****************************************************************         
      *                                                                         
       6040-CPD107B-LOAD-LO.                                            
      *                                                                         
           SET WS-LO-INDEX               TO 1.                          
                                                                        
           SEARCH WS-BILL-BSLN-HIST-DATA                                
             AT END                                                     
                  CONTINUE                                              
             WHEN WS-ACCOUNT-NO-LN (WS-LO-INDEX) EQUAL ZEROS            
                  MOVE NU-BILL-MANUAL-DATA-TEXT                         
                       TO WS-BILL-BSLN-HIST-DATA (WS-LO-INDEX)          
                  MOVE NU-ACCOUNT-NO                                    
                       TO WS-ACCOUNT-NO-LO (WS-LO-INDEX)                
                  MOVE NU-BILL-NO                                       
                       TO WS-BILL-NO-LO (WS-LO-INDEX)                   
                  MOVE NU-CODE-UTIL-TYPE                                
                       TO WS-CODE-UTIL-TYPE-LO (WS-LO-INDEX)            
                  MOVE NU-IC-NO                                         
                       TO WS-IC-NO-LO (WS-LO-INDEX)                     
                  MOVE NU-BILL-ITEM-TIMESTMP                            
                       TO WS-BILL-ITEM-TIMESTMP-LO (WS-LO-INDEX)        
           END-SEARCH.                                                  
      *                                                                         
       6040-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6045-CPD107B-LOAD-BX.                                         *         
      *****************************************************************         
      *                                                                         
       6045-CPD107B-LOAD-BX.                                            
      *                                                                         
           SET WS-BX-INDX                TO 1.                          
                                                                        
           SEARCH WS-BILL-CNTR-HIST-DATA                                
             AT END                                                     
                  CONTINUE                                              
             WHEN WS-ACCOUNT-NO-BX (WS-BX-INDX) EQUAL ZEROS             
                  MOVE NU-BILL-MANUAL-DATA-TEXT                         
                       TO WS-BILL-CNTR-HIST-DATA (WS-BX-INDX)           
                  MOVE NU-ACCOUNT-NO                                    
                       TO WS-ACCOUNT-NO-BX (WS-BX-INDX)                 
                  MOVE NU-BILL-NO                                       
                       TO WS-BILL-NO-BX (WS-BX-INDX)                    
                  MOVE NU-CODE-UTIL-TYPE                                
                       TO WS-CODE-UTIL-TYPE-BX (WS-BX-INDX)             
                  MOVE NU-IC-NO                                         
                       TO WS-IC-NO-BX (WS-BX-INDX)                      
                  MOVE NU-BILL-ITEM-TIMESTMP                            
                       TO WS-BILL-ITEM-TIMESTMP-BX (WS-BX-INDX)         
           END-SEARCH.                                                  
      *                                                                         
       6045-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6050-CPD107B-LOAD-CX.                                         *         
      *****************************************************************         
      *                                                                         
       6050-CPD107B-LOAD-CX.                                            
      *                                                                         
           INITIALIZE                       WS-N-CNSMPTN-HIST-CX.       
           MOVE NU-BILL-MANUAL-DATA-TEXT TO WS-N-CNSMPTN-HIST-CX.       
           PERFORM 6051-CPD107B-TRNSFR-CX   THRU 6051-CPD107B-EXIT.     
      *                                                                         
       6050-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6051-CPD107B-TRNSFR-CX.                                       *         
      *****************************************************************         
      *                                                                         
       6051-CPD107B-TRNSFR-CX.                                          
      *                                                                         
           SET CX-INDX                   TO 1.                          
                                                                        
           SEARCH WS-BC-CNSMPTN-DATA                                    
             AT END                                                     
                  CONTINUE                                              
             WHEN WS-BC-ACCOUNT-NO-CX (CX-INDX) EQUAL ZEROS             
                  MOVE NU-ACCOUNT-NO                                    
                       TO WS-BC-ACCOUNT-NO-CX (CX-INDX)                 
                  MOVE NU-BILL-NO                                       
                       TO WS-BC-BILL-NO-CX (CX-INDX)                    
                  MOVE NU-CODE-UTIL-TYPE                                
                       TO WS-BC-CODE-UTIL-TYPE-CX (CX-INDX)             
                  MOVE NU-IC-NO                                         
                       TO WS-BC-IC-NO-CX (CX-INDX)                      
                  MOVE NU-BILL-ITEM-TIMESTMP                            
                       TO WS-BC-BILL-ITEM-TIMESTMP-CX (CX-INDX)         
                  MOVE WS-N-MTR-REF-NO-CX                               
                       TO WS-BC-MTR-REF-NO-CX (CX-INDX)                 
                  MOVE WS-N-CODE-USAGE-VALUES-CX                        
                       TO WS-BC-CODE-USAGE-VALUES-CX (CX-INDX)          
                  MOVE WS-N-CODE-TIME-PERIOD-CX                         
                       TO WS-BC-CODE-TIME-PERIOD-CX (CX-INDX)           
                  MOVE WS-N-ITEM-SEQ-NO-CX                              
                       TO WS-BC-ITEM-SEQ-NO-CX (CX-INDX)                
                  MOVE WS-N-METER-NO-CX                                 
                       TO WS-BC-METER-NO-CX (CX-INDX)                   
                  MOVE WS-N-REG-ID-NO-CX                                
                       TO WS-BC-REG-ID-NO-CX (CX-INDX)                  
                  MOVE WS-N-DATE-READ-CX                                
                       TO WS-BC-DATE-READ-CX (CX-INDX)                  
                  MOVE WS-N-CODE-METER-READ-CX                          
                       TO WS-BC-CODE-METER-READ-CX (CX-INDX)            
                  MOVE WS-N-CODE-METER-NO-READ-CX                       
                       TO WS-BC-CODE-METER-NO-READ-CX (CX-INDX)         
                  MOVE WS-N-METER-READING-CX                            
                       TO WS-BC-METER-READING-CX (CX-INDX)              
                  MOVE WS-N-DEMAND-READING-CX                           
                       TO WS-BC-DEMAND-READING-CX (CX-INDX)             
                  MOVE WS-N-EMPLOYEE-NO-CX                              
                       TO WS-BC-EMPLOYEE-NO-CX (CX-INDX)                
                  MOVE WS-N-NO-UNITS-CX                                 
                       TO WS-BC-NO-UNITS-CX (CX-INDX)                   
                  MOVE WS-N-NO-DEMAND-UNITS-CX                          
                       TO WS-BC-NO-DEMAND-UNITS-CX (CX-INDX)            
                  MOVE WS-N-NO-DAYS-CX                                  
                       TO WS-BC-NO-DAYS-CX (CX-INDX)                    
                  MOVE WS-N-CODE-SOURCE-ID-CX                           
                       TO WS-BC-CODE-SOURCE-ID-CX (CX-INDX)             
                  MOVE WS-N-CODE-DEBIT-CREDIT-CX                        
                       TO WS-BC-CODE-DEBIT-CREDIT-CX (CX-INDX)          
                  MOVE WS-N-CODE-ITEM-STATUS-CX                         
                       TO WS-BC-CODE-ITEM-STATUS-CX (CX-INDX)           
                  MOVE WS-N-CODE-DISCOUNT-CX                            
                       TO WS-BC-CODE-DISCOUNT-CX (CX-INDX)              
                  MOVE WS-N-CONSTANT-CX                                 
                       TO WS-BC-CONSTANT-CX (CX-INDX)                   
                  MOVE WS-N-NO-DIALS-CX                                 
                       TO WS-BC-NO-DIALS-CX (CX-INDX)                   
                  MOVE WS-N-COMPANY-NO-CX                               
                       TO WS-BC-COMPANY-NO-CX (CX-INDX)                 
                  MOVE WS-N-EXCEPT-OVERRIDE-CD-CX                       
                       TO WS-BC-EXCEPT-OVERRIDE-CD-CX (CX-INDX)         
                  MOVE WS-N-REQUESTED-USAGE-CX                          
                       TO WS-BC-REQUESTED-USAGE-CX (CX-INDX)            
                  MOVE WS-N-DIGTL-INTRL-MTR-NO-CX                       
                       TO WS-BC-DIGTL-INTRL-MTR-NO-CX (CX-INDX)         
                  MOVE WS-N-DIGTL-MTR-TYPE-CX                           
                       TO WS-BC-DIGTL-MTR-TYPE-CX (CX-INDX)             
                  MOVE WS-N-CODE-TOU-SEASN-CX                           
                       TO WS-BC-CODE-TOU-SEASN-CX (CX-INDX)             
                  MOVE WS-N-EXCL-DMD-RCHT-IND-CX                        
                       TO WS-BC-EXCL-DMD-RCHT-IND-CX (CX-INDX)          
                  MOVE WS-N-UPDATE-ACTION-IND-CX                        
                       TO WS-BC-UPDATE-ACTION-IND-CX (CX-INDX)          
                  MOVE WS-N-ADDITIVE-SUB-TYPE-CALC                      
                       TO WS-BC-ADDITIVE-SUB-TYPE-CX (CX-INDX)          
                  MOVE WS-N-PREV-METER-READ-DATE-CALC                   
                       TO WS-BC-PRV-MTR-READ-DT-CALC-CX (CX-INDX)       
                  MOVE WS-N-PRV-MTR-READ-COMB-FLG-CX                    
                       TO WS-BC-PRV-MTR-READ-COMB-FLG-CX (CX-INDX)      
                  MOVE WS-N-DATE-PEAK-DEMAND-CX                         
                       TO WS-BC-DATE-PEAK-DEMAND-CX (CX-INDX)           
           END-SEARCH.                                                  
      *                                                                         
       6051-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6055-CPD107B-LOAD-UC.                                         *         
      *****************************************************************         
      *                                                                         
       6055-CPD107B-LOAD-UC.                                            
      *                                                                         
           INITIALIZE                       WS-N-UNMTRD-CNSMPTN-UC.     
           MOVE NU-BILL-MANUAL-DATA-TEXT TO WS-N-UNMTRD-CNSMPTN-UC.     
           PERFORM 6056-CPD107B-TRNSFR-UC   THRU 6056-CPD107B-EXIT.     
      *                                                                         
       6055-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6056-CPD107B-TRNSFR-UC.                                       *         
      *****************************************************************         
      *                                                                         
       6056-CPD107B-TRNSFR-UC.                                          
      *                                                                         
           SET UC-INDX                   TO 1.                          
                                                                        
           SEARCH WS-BC-UNMTRD-CNSMPTN-DATA                             
             AT END                                                     
                  CONTINUE                                              
             WHEN WS-BC-ACCOUNT-NO-UC (UC-INDX) EQUAL ZEROS             
                  MOVE NU-ACCOUNT-NO                                    
                       TO WS-BC-ACCOUNT-NO-UC (UC-INDX)                 
                  MOVE NU-BILL-NO                                       
                       TO WS-BC-BILL-NO-UC (UC-INDX)                    
                  MOVE NU-CODE-UTIL-TYPE                                
                       TO WS-BC-CODE-UTIL-TYPE-UC (UC-INDX)             
                  MOVE NU-IC-NO                                         
                       TO WS-BC-IC-NO-UC (UC-INDX)                      
                  MOVE NU-BILL-ITEM-TIMESTMP                            
                       TO WS-BC-BILL-ITEM-TIMESTMP-UC (UC-INDX)         
                  MOVE WS-N-RATE-ITEM-CODE-UC                           
                       TO WS-BC-RATE-ITEM-CODE-UC (UC-INDX)             
                  MOVE WS-N-ITEM-SEQ-NO-UC                              
                       TO WS-BC-ITEM-SEQ-NO-UC (UC-INDX)                
                  MOVE WS-N-NO-UNITS-UC                                 
                       TO WS-BC-NO-UNITS-UC (UC-INDX)                   
                  MOVE WS-N-NO-DAYS-UC                                  
                       TO WS-BC-NO-DAYS-UC (UC-INDX)                    
                  MOVE WS-N-CODE-DEBIT-CREDIT-UC                        
                       TO WS-BC-CODE-DEBIT-CREDIT-UC (UC-INDX)          
                  MOVE WS-N-USAGE-FIXED-UC                              
                       TO WS-BC-USAGE-FIXED-UC (UC-INDX)                
                  MOVE WS-N-MTHLY-AMOUNT-FIXED-UC                       
                       TO WS-BC-MTHLY-AMOUNT-FIXED-UC (UC-INDX)         
                  MOVE WS-N-DATE-USAGE-ENDS-UC                          
                       TO WS-BC-DATE-USAGE-ENDS-UC (UC-INDX)            
                  MOVE WS-N-CODE-SERVICE-TYPE-UC                        
                       TO WS-BC-CODE-SERVICE-TYPE-UC (UC-INDX)          
                  MOVE WS-N-CODE-ITEM-STATUS-UC                         
                       TO WS-BC-CODE-ITEM-STATUS-UC (UC-INDX)           
                  MOVE WS-N-CODE-SOURCE-ID-UC                           
                       TO WS-BC-CODE-SOURCE-ID-UC (UC-INDX)             
                  MOVE WS-N-DIST-NO-UC                                  
                       TO WS-BC-DIST-NO-UC (UC-INDX)                    
                  MOVE WS-N-LIGHT-NO-UC                                 
                       TO WS-BC-LIGHT-NO-UC (UC-INDX)                   
                  MOVE WS-N-POLE-NO-UC                                  
                       TO WS-BC-POLE-NO-UC (UC-INDX)                    
                  MOVE WS-N-UPDATE-ACTION-IND-UC                        
                       TO WS-BC-UPDATE-ACTION-IND-UC (UC-INDX)          
           END-SEARCH.                                                  
      *                                                                         
       6056-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6060-CPD107B-GET-MANBILL-HDR.                                  *        
      ******************************************************************        
      *                                                                         
       6060-CPD107B-GET-MANBILL-HDR.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT  'Y'                                                
                    ,NG.BILL_MAN_STATUS_CD                              
               INTO :WS-CPD107B-BILL-MAN-SW                             
                   ,:NG-BILL-MAN-STATUS-CD                              
               FROM  CSS_BILL_MANUAL NG                                 
              WHERE  NG.ACCOUNT_NO         = :NG-ACCOUNT-NO             
                AND  NG.BILL_NO            = :NG-BILL-NO                
                AND  NG.CODE_UTIL_TYPE     = :NG-CODE-UTIL-TYPE         
                AND  NG.IC_NO              = :NG-IC-NO                  
                AND  NG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NG-BILL-ITEM-TIMESTMP
              )     
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  'Y'                                                        
MFA-TR*             ,NG.BILL_MAN_STATUS_CD                                      
MFA-TR*        INTO :WS-CPD107B-BILL-MAN-SW                                     
MFA-TR*            ,:NG-BILL-MAN-STATUS-CD                                      
MFA-TR*        FROM  CSS_BILL_MANUAL NG                                         
MFA-TR*       WHERE  NG.ACCOUNT_NO         = :NG-ACCOUNT-NO                     
MFA-TR*         AND  NG.BILL_NO            = :NG-BILL-NO                        
MFA-TR*         AND  NG.CODE_UTIL_TYPE     = :NG-CODE-UTIL-TYPE                 
MFA-TR*         AND  NG.IC_NO              = :NG-IC-NO                          
MFA-TR*         AND  NG.BILL_ITEM_TIMESTMP = :NG-BILL-ITEM-TIMESTMP             
MFA-TR*     QUERYNO  6060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-CPD107B-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE 'N'                TO WS-CPD107B-BILL-MAN-SW     
                  MOVE ZEROS              TO WS-ACTIVE-RETURN-CODE      
                                             WS-CPD107B-RETURN-CODE     
               WHEN OTHER                                               
                  MOVE 'NG'               TO WS-CPD107B-DB2-TABLE-ID    
                  MOVE 'SELECT'           TO WS-CPD107B-DB2-FUNCTION    
                  MOVE '6060'             TO WS-CPD107B-DB2-PARAGRAPH   
                  MOVE NG-ACCOUNT-NO      TO WS-CPD107B-DB2-KEY-1N      
                  MOVE NG-BILL-NO         TO WS-CPD107B-DB2-KEY-2N      
                  MOVE NG-CODE-UTIL-TYPE  TO WS-CPD107B-DB2-KEY-3       
                  MOVE NG-IC-NO           TO WS-CPD107B-DB2-KEY-4N      
           END-EVALUATE.                                                
      *                                                                         
       6060-CPD107B-EXIT.                                               
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 6065-CPD107B-OPEN-MANBILL-DET.                                 *        
      * OPEN BILL_MAN_DET CURSOR.                                      *        
      ******************************************************************        
      *                                                                         
       6065-CPD107B-OPEN-MANBILL-DET.                                   
      *                                                                         
           EXEC SQL                                                     
               OPEN BILL_MAN_DET                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-CPD107B-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NU'                   TO WS-CPD107B-DB2-TABLE-ID    
              MOVE 'OPEN'                 TO WS-CPD107B-DB2-FUNCTION    
              MOVE '6065'                 TO WS-CPD107B-DB2-PARAGRAPH   
              MOVE NU-ACCOUNT-NO          TO WS-CPD107B-DB2-KEY-1N      
              MOVE NU-BILL-NO             TO WS-CPD107B-DB2-KEY-2N      
              MOVE NU-CODE-UTIL-TYPE      TO WS-CPD107B-DB2-KEY-3       
              MOVE NU-IC-NO               TO WS-CPD107B-DB2-KEY-4N      
           END-IF.                                                      
      *                                                                         
       6065-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6070-CPD107B-FETCH-MANBILL-DET.                                *        
      * FETCH BILL_MAN_DET CURSOR.                                     *        
      ******************************************************************        
      *                                                                         
       6070-CPD107B-FETCH-MANBILL-DET.                                  
      *                                                                         
           EXEC SQL                                                     
              FETCH BILL_MAN_DET                                        
               INTO :NU-BILL-MANUAL-TBL-ID                              
                   ,:NU-BILL-MANUAL-DATA                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-CPD107B-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NU'                   TO WS-CPD107B-DB2-TABLE-ID    
              MOVE 'FETCH'                TO WS-CPD107B-DB2-FUNCTION    
              MOVE '6070'                 TO WS-CPD107B-DB2-PARAGRAPH   
              MOVE NU-ACCOUNT-NO          TO WS-CPD107B-DB2-KEY-1N      
              MOVE NU-BILL-NO             TO WS-CPD107B-DB2-KEY-2N      
              MOVE NU-CODE-UTIL-TYPE      TO WS-CPD107B-DB2-KEY-3       
              MOVE NU-IC-NO               TO WS-CPD107B-DB2-KEY-4N      
           END-IF.                                                      
      *                                                                         
       6070-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6075-CPD107B-CLOSE-MANBILL-DET.                                *        
      * CLOSE BILL_MAN_DET CURSOR.                                     *        
      ******************************************************************        
      *                                                                         
       6075-CPD107B-CLOSE-MANBILL-DET.                                  
      *                                                                         
           EXEC SQL                                                     
              CLOSE BILL_MAN_DET                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-CPD107B-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NU'                   TO WS-CPD107B-DB2-TABLE-ID    
              MOVE 'CLOSE'                TO WS-CPD107B-DB2-FUNCTION    
              MOVE '6075'                 TO WS-CPD107B-DB2-PARAGRAPH   
              MOVE NU-ACCOUNT-NO          TO WS-CPD107B-DB2-KEY-1N      
              MOVE NU-BILL-NO             TO WS-CPD107B-DB2-KEY-2N      
              MOVE NU-CODE-UTIL-TYPE      TO WS-CPD107B-DB2-KEY-3       
              MOVE NU-IC-NO               TO WS-CPD107B-DB2-KEY-4N      
           END-IF.                                                      
      *                                                                         
       6075-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6080-CPD107B-GET-CNSMPTN-START.                                *        
      * CALCULATE THE CONSUMPTION START DATE.                          *        
      ******************************************************************        
      *                                                                         
       6080-CPD107B-GET-CNSMPTN-START.                                  
      *                                                                         
           MOVE SPACES                    TO WS-CPD107B-DATE-1          
                                             WS-CPD107B-DATE-2.         
           MOVE ZEROS                     TO WS-CPD107B-NO-OF-DAYS.     
                                                                        
           MOVE WS-BC-CNSMPTN-END-DATE    TO WS-CPD107B-DATE-2.         
           MOVE WS-BC-NO-CNSMPTN-DAYS     TO WS-CPD107B-NO-OF-DAYS.     
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -:WS-CPD107B-NO-OF-DAYS, 
              IIF(TRY_CONVERT(DATE, :WS-CPD107B-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD107B-DATE-2
              ) <> 0) OR (LEN(:WS-CPD107B-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-CPD107B-DATE-2
              ), CONVERT(DATE, :WS-CPD107B-DATE-2) ) )
            INTO
              :WS-CPD107B-DATE-1                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CPD107B-DATE-1 =                                          
MFA-TR*            DATE(:WS-CPD107B-DATE-2)                                     
MFA-TR*               - :WS-CPD107B-NO-OF-DAYS DAYS                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-CPD107B-RETURN-CODE.    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'MS'                   TO WS-CPD107B-DB2-TABLE-ID    
              MOVE 'SELECT'               TO WS-CPD107B-DB2-FUNCTION    
              MOVE '6080'                 TO WS-CPD107B-DB2-PARAGRAPH   
              MOVE NU-ACCOUNT-NO          TO WS-CPD107B-DB2-KEY-1N      
              MOVE NU-BILL-NO             TO WS-CPD107B-DB2-KEY-2N      
              MOVE NU-CODE-UTIL-TYPE      TO WS-CPD107B-DB2-KEY-3       
              MOVE NU-IC-NO               TO WS-CPD107B-DB2-KEY-4N      
           END-IF.                                                      
      *                                                                         
       6080-CPD107B-EXIT.                                               
           EXIT.                                                        
      *                                                                         
