      *****************************************************************         
      **   CPDCA299                                                  **         
      **     ==> P00251 - NET METERING.                              **         
      *****************************************************************         
      *****************************************************************         
      ** THIS COPYBOOK WILL ALLOCATE VOLUME DAILY FOR NET METERING   **         
      ** ACCOUNTS BASED ON THE CONSUMPTION HISTORY ENTRIES.          **         
      **                                                             **         
      **  INPUT DATA:                                                **         
      **  =*=*=*=*=*=                                                **         
      **            CWS299-IN-ACCT-NO                                **         
      **            CWS299-IN-REVENUE-MONTH                          **         
      **            CWS299-IN-COMMON-DT                              **         
      **            CWS299-IN-APPL-PGM-ID                            **         
ID1959**            CWS299-IN-OFF-CYC-BILL-CD                        **         
ID1959**            CWS299-IN-REV-MTH-LST-NRML                       **         
      **                                                             **         
      **  OUTPUT RESULT:                                             **         
      **  =*=*=*=*=*=*=*                                             **         
      *****************************************************************         
      *    EP - Excess Previous Bill                                  *         
      *    DL - KWH Consumed                                          *         
      *    RV - KWH Generated.                                        *         
      *    12 - Excess To Off-Peak From On-Peak.                      *         
      *    21 - Excess From On-Peak To Off-Peak.                      *         
      *    32 - Excess to Off-Peak from Shoulder.                     *         
      *    13 - Excess To Shoulder From On-Peak.                      *         
      *    23 - Excess From Shoulder To Off-Peak.                     *         
      *    31 - Excess From On-Peak To Shoulder.                      *         
      *    EC - Excess Current Bill.                                  *         
      *    BI - Net Billed.                                           *         
      *****************************************************************         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION LOG                      **         
      **              --------------------------                     **         
      **    DATE    INITIALS   REASON                                **         
      **  --------  --------   ------                                **         
      **  04/15/10  SS97726    INITIAL VERSION.                      **         
ID1959**  09/18/15  GD43988    NEM2 CHANGES: INSERT/UPDATE EXCESS    **         
ID1959**                       USAGE CREDIT FACTOR/FACTOR HISTORY    **         
ID1959**                       BASED ON FOLLOWING CRITERIA:          **         
ID1959**                       (DB07 ON/OFF CYCLE CODE = FINAL) OR   **         
ID1959**                       (REVNEUE MONTH = RESET REVENUE MONTH) **         
ID1959**  11/13/15  MS7M727    NEM2 CHANGES: UNITS MOVED             **         
ACT108**  07/04/16  MS7M727    REPLACE CSS_WQ_ITEMS_MF WITH          **         
ACT108**                       CSS_WQ_ITEMS TABLE.                   **         
ACT032**  07/18/16  MS7M727    ADDED BILL_NO ORDER BY DESC, <=       **         
ACT032**            A05470     REVENUE_MONTH IN WHERE CLAUSE IN      **         
ACT032**                       QUERY NO 6510                         **         
P01175**  08/23/16  AK7T405   TO PRINT NET ENERGY CONSUMED BY USER   **         
      *****************************************************************         
      *                                                                         
       6001-CPD299-VOL-ALLOC-MAIN.                                      
                                                                        
           PERFORM 6002-CPD299-INITIALIZE THRU 6002-CPD299-EXIT.        
                                                                        
           IF CWS299-NO-ERROR                                           
              SET CWS299-FIRST-BG TO TRUE                               
              MOVE 'N'                       TO CWS299-BG-ROWS-SWITCH   
              PERFORM 6700-CPD299-OPEN-BG-CURS  THRU 6700-CPD299-EXIT   
              IF CWS299-NO-ERROR                                        
                 PERFORM 6710-CPD299-FETCH-BG   THRU 6710-CPD299-EXIT   
                 IF CWS299-NO-ERROR                                     
                    PERFORM 6001A-CPD299-GET-BG THRU 6001A-CPD299-EXIT  
                                    UNTIL CWS299-NO-MORE-BG-ROWS        
                                          OR CWS299-ERROR-TYPE > SPACES 
                 END-IF                                                 
                 PERFORM 6720-CPD299-CLOSE-BG   THRU 6720-CPD299-EXIT   
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6001-CPD299-EXIT.                                                
           EXIT.                                                        
                                                                        
       6001A-CPD299-GET-BG.                                             
                                                                        
           MOVE BG-CODE-UTIL-TYPE        TO CX-CODE-UTIL-TYPE           
                                            CWS299-IN-CODE-UTIL-TYPE    
                                            CWS299-HOLD-CODE-UTIL-TYPE. 
           MOVE BG-IC-NO                 TO CX-IC-NO                    
                                            CWS299-IN-IC-NO.            
           MOVE BG-BILL-NO               TO CX-BILL-NO                  
                                            CWS299-IN-BILL-NO.          
           MOVE BG-RATE-PLAN-NO          TO CWS299-IN-RATE-PLAN         
                                            CWS299-HOLD-RATE-PLAN.      
           MOVE BG-BILL-ITEM-TIMESTMP    TO CX-BILL-ITEM-TIMESTMP       
                                            CWS299-IN-BILL-ITM-TIMESTMP.
ID1959*** IF REBILL, REV MTH ORIG BILL ELSE INPUT REVENUE MONTH                 
           IF BG-REV-MTH-ORIG-BILL > 0                                  
              MOVE BG-REV-MTH-ORIG-BILL  TO CWS299-IN-REVENUE-MONTH     
ID1959     ELSE                                                         
ID1959        MOVE CWS299-IN-REV-MTH-N2  TO CWS299-IN-REVENUE-MONTH     
           END-IF.                                                      
                                                                        
           MOVE CWS299-IN-REVENUE-MONTH  TO CWS299-HOLD-REV-MONTH.      
                                                                        
      *******CHECK IF THE BG RATE PLAN IS A NET METERING RATE.                  
           PERFORM 6003-CPD299-CHK-NM-RATE      THRU 6003-CPD299-EXIT.  
                                                                        
           IF CWS299-NM-RATE                                            
              MOVE CWS299-IN-REVENUE-MONTH   TO CWS299-TEMP-REV-MONTH   
              MOVE CWS299-TEMP-REV-MONTH     TO CWS299-HOLD-REV-MTH-RED 
              MOVE 'N'                       TO CWS299-MISSING-MNTHS    
              IF CWS299-FIRST-BG                                        
                 IF BG-REV-MTH-ORIG-BILL NOT EQUAL ZEROES               
                    PERFORM 6620-FIND-MISSING-MONTHS                    
                                                THRU 6620-CPD299-EXIT   
                  END-IF                                                
              END-IF                                                    
              IF MISSING-MNTHS-FOUND                                    
                 SET CWS299-NO-MORE-BG-ROWS TO TRUE                     
ID1959           MOVE 'Missing revenue month' TO CWS299-ERROR-MESSAGE   
ACT108           INITIALIZE CWS00077-FIELDS                             
ACT108           MOVE LENGTH OF CWS299-REVMTH-WQ-MSG                    
ACT108                                        TO WS-77-COMMENTS-LEN     
ACT108           MOVE CWS299-REVMTH-WQ-MSG    TO WS-77-COMMENTS-TEXT    
                 PERFORM 6009-CPD299-CREATE-WQ                          
                                                THRU 6009-CPD299-EXIT   
              ELSE                                                      
                 PERFORM 6120-PROCESS-VOLUME                            
                                                THRU 6120-CPD299-EXIT   
ID1959*** INSERT/UDATE EXCESS USAGE CREDIT FACTOR                               
ID1959           IF CWS299-NO-ERROR AND                                 
ID1959              CWS299-N2-FAC-CHRG-BASE < 0                         
ID1959              PERFORM 6200-CPD299-PROCESS-CRED-FCTR               
ID1959                 THRU 6200-CPD299-EXIT                            
ID1959           END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           INITIALIZE               CWS299-NON-TOU-CALC-VARS            
                                    CWS299-ON-PEAK-CALC-VARS            
                                    CWS299-OFF-PEAK-CALC-VARS           
                                    CWS299-SHLDR-CALC-VARS              
                                    CWS299-TEMP-VARIABLES               
                                    CWS299-ERROR-DATA.                  
                                                                        
           PERFORM 6710-CPD299-FETCH-BG         THRU 6710-CPD299-EXIT.  
                                                                        
       6001A-CPD299-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * INITIALIZATION PARAGRAPH AND INPUT PARAMETER VALIDATION       *         
      *****************************************************************         
       6002-CPD299-INITIALIZE.                                          
                                                                        
           MOVE 'N'              TO CWS299-VOL-ALLOCATED.               
                                                                        
           INITIALIZE               CWS299-NON-TOU-CALC-VARS            
                                    CWS299-ON-PEAK-CALC-VARS            
                                    CWS299-OFF-PEAK-CALC-VARS           
                                    CWS299-SHLDR-CALC-VARS              
                                    CWS299-TEMP-VARIABLES               
                                    CWS299-ERROR-DATA.                  
                                                                        
           MOVE ZEROS            TO CWS299-NON-TOU-PREV-EC              
                                    CWS299-ON-PEAK-PREV-EC              
                                    CWS299-OFF-PEAK-PREV-EC             
                                    CWS299-SHLDR-PREV-EC.               
                                                                        
           MOVE SPACES           TO CWS299-IN-CODE-UTIL-TYPE            
                                    CWS299-IN-BILL-ITM-TIMESTMP.        
           MOVE ZEROS            TO CWS299-IN-IC-NO                     
                                    CWS299-IN-BILL-NO.                  
                                                                        
      *******VALIDATE INPUT PARAMETERS BEFORE PROCESSING                        
           IF CWS299-IN-ACCT-NO NOT > 0                                 
              SET CWS299-NON-DB2-ERROR       TO TRUE                    
              MOVE 'INVALID ACCOUNT NUMBER'  TO CWS299-ERROR-MESSAGE    
           END-IF.                                                      
                                                                        
           IF CWS299-IN-REVENUE-MONTH NOT > 0                           
              SET CWS299-NON-DB2-ERROR       TO TRUE                    
              MOVE 'INVALID REVENUE MONTH'   TO CWS299-ERROR-MESSAGE    
           END-IF.                                                      
                                                                        
           IF CWS299-IN-COMMON-DT NOT > SPACES                          
              SET CWS299-NON-DB2-ERROR       TO TRUE                    
              MOVE 'INVALID COMMON DATE'     TO CWS299-ERROR-MESSAGE    
           END-IF.                                                      
                                                                        
           IF CWS299-FIRST-CALL AND CWS299-NO-ERROR                     
              INITIALIZE CWS299-NET-MTR-RATE-LOOKUP                     
                                                                        
      *******STORE THE NET METERING RATES IN ARRAY FOR REFERENCE.               
              PERFORM 6670-CPD299-OPEN-NM-RATE  THRU 6670-CPD299-EXIT   
              PERFORM 6680-CPD299-FETCH-NM-RATE THRU 6680-CPD299-EXIT   
              PERFORM VARYING CWS299-RT-INDX FROM 1 BY 1                
                UNTIL SQLCODE = NOT-FOUND                               
                   OR CWS299-RT-INDX > 200                              
                   OR CWS299-ERROR-TYPE NOT = SPACES                    
                      MOVE J1-RATE-PLAN-NO                              
                            TO CWS299-NM-RATE-PLAN (CWS299-RT-INDX)     
                      MOVE J1-CMPNT-ID-CD                               
                            TO CWS299-NM-CMPNT-ID (CWS299-RT-INDX)      
                      MOVE J1-CODE-UTIL-TYPE                            
                            TO CWS299-NM-CD-UTL-TYPE (CWS299-RT-INDX)   
                      MOVE J1-REG-TYPE-CD                               
                            TO CWS299-NM-REG-TYPE-CD (CWS299-RT-INDX)   
                      MOVE J1-BAL-RESET-MMDD                            
                            TO CWS299-NM-BAL-RESET-MMDD (CWS299-RT-INDX)
                      MOVE J1-BAL-OFFSET-TOU-CD                         
                            TO CWS299-NM-BAL-OFFSET-TOU (CWS299-RT-INDX)
                      MOVE J1-ENERGY-UNIT-CD                            
                            TO CWS299-NM-ENERGY-UNIT-CD (CWS299-RT-INDX)
ID1959                MOVE J1-BAL-FWD-CD                                
ID1959                      TO CWS299-NM-BAL-FWD-CD (CWS299-RT-INDX)    
                      PERFORM 6680-CPD299-FETCH-NM-RATE                 
                                                THRU 6680-CPD299-EXIT   
              END-PERFORM                                               
              PERFORM 6690-CPD299-CLOSE-NM-RATE THRU 6690-CPD299-EXIT   
ID1959*** GET EXCESS USAGE CREDIT FACTOR USER TABLE DATA                        
ID1959        IF CWS299-NO-ERROR                                        
ID1959           MOVE CWS299-CR-FCTR-FACTOR-ID  TO SF-FACTOR-ID         
ID1959           PERFORM 6725-CPD299-GET-SPCL-FCTR                      
ID1959              THRU 6725-CPD299-EXIT                               
ID1959        END-IF                                                    
                                                                        
              SET CWS299-NOT-FIRST-CALL         TO TRUE                 
           END-IF.                                                      
                                                                        
           MOVE CWS299-IN-ACCT-NO            TO AT-ACCOUNT-NO           
                                                BI-ACCOUNT-NO           
                                                BG-ACCOUNT-NO           
                                                CX-ACCOUNT-NO           
                                                ND-ACCOUNT-NO           
ACT108                                          WS-77-ACCOUNT-NO.       
ID1959*** STORE ORIGINAL INPUT INTO A HOLD VARIABLE                             
ID1959     MOVE CWS299-IN-REVENUE-MONTH   TO CWS299-IN-REV-MTH-N2.      
      *                                                                         
       6002-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * CHECK FOR NET METERING RATE.                                  *         
      *****************************************************************         
       6003-CPD299-CHK-NM-RATE.                                         
      *                                                                         
           MOVE ZEROES                    TO CWS299-CMP-BAL-FWD-RESET.  
           SET CWS299-RT-INDX             TO 1.                         
           SEARCH CWS299-NET-MTR-RATE-TABLE                             
               AT END                                                   
                  SET CWS299-NOT-NM-RATE     TO TRUE                    
             WHEN CWS299-NM-RATE-PLAN (CWS299-RT-INDX) = SPACES         
                  SET CWS299-NOT-NM-RATE     TO TRUE                    
             WHEN CWS299-NM-CD-UTL-TYPE (CWS299-RT-INDX) EQUAL          
                                         CWS299-HOLD-CODE-UTIL-TYPE     
                  AND CWS299-NM-RATE-PLAN (CWS299-RT-INDX) EQUAL        
                                         CWS299-HOLD-RATE-PLAN          
                  SET CWS299-NM-RATE         TO TRUE                    
                  MOVE CWS299-NM-REG-TYPE-CD (CWS299-RT-INDX)           
                                             TO CWS299-REG-TYPE-CD      
                  MOVE CWS299-NM-BAL-RESET-MMDD (CWS299-RT-INDX)        
                                             TO CWS299-CMP-BAL-FWD-RESET
ID1959                                          CWS299-BAL-RESET-MMDD   
                  MOVE CWS299-NM-BAL-OFFSET-TOU (CWS299-RT-INDX)        
                                             TO CWS299-BAL-OFFSET-TOU   
                  MOVE CWS299-NM-ENERGY-UNIT-CD (CWS299-RT-INDX)        
                                             TO CWS299-ENERGY-UNIT-CD   
ID1959            MOVE CWS299-NM-BAL-FWD-CD (CWS299-RT-INDX)            
ID1959                                       TO CWS299-BAL-FWD-CD       
           END-SEARCH.                                                  
                                                                        
      *  Balance forward reset month is filed one month off from                
      *  actual billing revenue month. Increment reset month by one,            
      *  and this will be used to compare with billing rev month.               
                                                                        
           IF CWS299-NM-RATE AND CWS299-CMP-BAL-RST-MM > ZEROES         
              COMPUTE CWS299-CMP-BAL-RST-MM = CWS299-CMP-BAL-RST-MM + 1 
              IF CWS299-CMP-BAL-RST-MM > 12                             
                 MOVE 01                     TO CWS299-CMP-BAL-RST-MM   
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6003-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET THE CX DETAILS FOR ALL TIME PERIODS/CODE_USAGE_ID (A,F)    *        
      ******************************************************************        
       6004-CPD299-GET-CNSMPTN.                                         
                                                                        
           PERFORM 6520-CPD299-OPEN-CX        THRU 6520-CPD299-EXIT.    
           IF CWS299-NO-ERROR                                           
              PERFORM 6530-CPD299-FETCH-CX    THRU 6530-CPD299-EXIT     
      *********STORE THE UNITS FOR DL/RV VOLUMES                                
              IF CWS299-NO-ERROR                                        
                 PERFORM 6005-CPD299-ALLOCATE-DL-RV                     
                                              THRU 6005-CPD299-EXIT     
                                  UNTIL SQLCODE = NOT-FOUND             
                                       OR CWS299-ERROR-TYPE NOT = SPACES
                                                                        
                 PERFORM 6540-CPD299-CLOSE-CX THRU 6540-CPD299-EXIT     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6004-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * ALLOCATE DL/RV VOLUMES BASED ON CNSMPTN_HIST ENTRIES.          *        
      ******************************************************************        
       6005-CPD299-ALLOCATE-DL-RV.                                      
      *                                                                         
           IF CX-CODE-DEBIT-CREDIT EQUAL 'C'                            
              COMPUTE CX-NO-UNITS = CX-NO-UNITS * -1                    
           END-IF                                                       
                                                                        
           EVALUATE CX-CODE-USAGE-ID                                    
               WHEN WS-BASIC-SERVICE                                    
                  EVALUATE CX-CODE-TIME-PERIOD                          
                      WHEN CWS299-NON-TOU                               
                         ADD CX-NO-UNITS   TO CWS299-NON-TOU-DL         
                         IF CWS299-NON-TOU-RDDT = SPACES OR             
                            CWS299-NON-TOU-RDDT < CX-DATE-READ          
                            MOVE CX-DATE-READ TO                        
                                 CWS299-NON-TOU-RDDT                    
                         END-IF                                         
                      WHEN CWS299-ON-PEAK                               
                         ADD CX-NO-UNITS   TO CWS299-ON-PEAK-DL         
                         IF CWS299-ON-PEAK-RDDT = SPACES OR             
                            CWS299-ON-PEAK-RDDT < CX-DATE-READ          
                            MOVE CX-DATE-READ TO                        
                                 CWS299-ON-PEAK-RDDT                    
                         END-IF                                         
                      WHEN CWS299-OFF-PEAK                              
                         ADD CX-NO-UNITS   TO CWS299-OFF-PEAK-DL        
                         IF CWS299-OFF-PEAK-RDDT = SPACES OR            
                            CWS299-OFF-PEAK-RDDT < CX-DATE-READ         
                            MOVE CX-DATE-READ TO                        
                                 CWS299-OFF-PEAK-RDDT                   
                         END-IF                                         
                      WHEN CWS299-SHOULDER                              
                         ADD CX-NO-UNITS   TO CWS299-SHLDR-DL           
                         IF CWS299-SHLDR-RDDT = SPACES OR               
                            CWS299-SHLDR-RDDT < CX-DATE-READ            
                            MOVE CX-DATE-READ TO                        
                                 CWS299-SHLDR-RDDT                      
                         END-IF                                         
                  END-EVALUATE                                          
               WHEN WS-CO-GENERATION                                    
                  EVALUATE CX-CODE-TIME-PERIOD                          
                      WHEN CWS299-NON-TOU                               
                         ADD CX-NO-UNITS  TO CWS299-NON-TOU-RV          
                         IF CWS299-NON-TOU-RDDT = SPACES OR             
                            CWS299-NON-TOU-RDDT < CX-DATE-READ          
                            MOVE CX-DATE-READ TO                        
                                 CWS299-NON-TOU-RDDT                    
                         END-IF                                         
                      WHEN CWS299-ON-PEAK                               
                         ADD CX-NO-UNITS   TO CWS299-ON-PEAK-RV         
                         IF CWS299-ON-PEAK-RDDT = SPACES OR             
                            CWS299-ON-PEAK-RDDT < CX-DATE-READ          
                            MOVE CX-DATE-READ TO                        
                                 CWS299-ON-PEAK-RDDT                    
                         END-IF                                         
                      WHEN CWS299-OFF-PEAK                              
                         ADD CX-NO-UNITS   TO CWS299-OFF-PEAK-RV        
                         IF CWS299-OFF-PEAK-RDDT = SPACES OR            
                            CWS299-OFF-PEAK-RDDT < CX-DATE-READ         
                            MOVE CX-DATE-READ TO                        
                                 CWS299-OFF-PEAK-RDDT                   
                         END-IF                                         
                      WHEN CWS299-SHOULDER                              
                         ADD CX-NO-UNITS   TO CWS299-SHLDR-RV           
                         IF CWS299-SHLDR-RDDT = SPACES OR               
                            CWS299-SHLDR-RDDT < CX-DATE-READ            
                            MOVE CX-DATE-READ TO                        
                                 CWS299-SHLDR-RDDT                      
                         END-IF                                         
                  END-EVALUATE                                          
           END-EVALUATE.                                                
                                                                        
           PERFORM 6530-CPD299-FETCH-CX    THRU 6530-CPD299-EXIT.       
      *                                                                         
       6005-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * ALLOCATE EP BASED ON EC OF PRIOR BG.                           *        
      ******************************************************************        
       6006-CPD299-ALLOCATE-EP.                                         
      *                                                                         
           MOVE BG-CODE-UTIL-TYPE            TO ND-CODE-UTIL-TYPE.      
           MOVE BG-IC-NO                     TO ND-IC-NO.               
           MOVE BG-BILL-NO                   TO ND-BILL-NO.             
           MOVE BG-BILL-ITEM-TIMESTMP        TO ND-BILL-ITEM-TIMESTMP.  
           MOVE 'EC'                         TO ND-VOL-TYPE-CD.         
           MOVE CWS299-ENERGY-UNIT-CD        TO ND-ENERGY-UNIT-CD.      
                                                                        
           EVALUATE CWS299-BAL-OFFSET-TOU                               
               WHEN ' '                                                 
                  MOVE CWS299-NON-TOU     TO ND-CODE-TIME-PERIOD        
                  PERFORM 6550-CPD299-GET-VOL-DLY                       
                                          THRU 6550-CPD299-EXIT         
                  COMPUTE CWS299-NON-TOU-EP ROUNDED = ND-NO-UNITS       
               WHEN WS-APPLY-TO-LESR-TOU                                
                  EVALUATE CWS299-REG-TYPE-CD                           
                      WHEN WS-ON-OFF-PEAK                               
                      WHEN WS-ON-OFF-SHLDR-PEAK                         
      *********GET EC UNITS FOR ON-PEAK                                         
                         MOVE CWS299-ON-PEAK TO ND-CODE-TIME-PERIOD     
                         PERFORM 6550-CPD299-GET-VOL-DLY                
                                           THRU 6550-CPD299-EXIT        
                         COMPUTE CWS299-ON-PEAK-EP ROUNDED =            
                                 ND-NO-UNITS                            
      *********GET EC UNITS FOR OFF-PEAK                                        
                         IF CWS299-NO-ERROR                             
                            MOVE CWS299-OFF-PEAK TO ND-CODE-TIME-PERIOD 
                            PERFORM 6550-CPD299-GET-VOL-DLY             
                                           THRU 6550-CPD299-EXIT        
                            COMPUTE CWS299-OFF-PEAK-EP ROUNDED =        
                                    ND-NO-UNITS                         
                         END-IF                                         
      *********GET EC UNITS FOR SHOULDER                                        
                         IF CWS299-NO-ERROR AND CWS299-REG-TYPE-CD      
                                            EQUAL WS-ON-OFF-SHLDR-PEAK  
                            MOVE CWS299-SHOULDER TO ND-CODE-TIME-PERIOD 
                            PERFORM 6550-CPD299-GET-VOL-DLY             
                                           THRU 6550-CPD299-EXIT        
                            COMPUTE CWS299-SHLDR-EP ROUNDED =           
                                    ND-NO-UNITS                         
                         END-IF                                         
                  END-EVALUATE                                          
           END-EVALUATE.                                                
      *                                                                         
       6006-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * ALLOCATE REMAINING VOLUMES                                     *        
      ******************************************************************        
       6007-CPD299-ALLOCATE-REM.                                        
      *                                                                         
           IF CWS299-BAL-OFFSET-TOU = WS-APPLY-TO-LESR-TOU              
              COMPUTE CWS299-ON-PEAK-EC =                               
                      CWS299-ON-PEAK-EP +                               
                      CWS299-ON-PEAK-DL +                               
                      CWS299-ON-PEAK-RV                                 
P01175        COMPUTE CWS299-ON-PEAK-EU =                               
P01175                CWS299-ON-PEAK-DL +                               
P01175                CWS299-ON-PEAK-RV                                 
              COMPUTE CWS299-OFF-PEAK-EC =                              
                      CWS299-OFF-PEAK-EP +                              
                      CWS299-OFF-PEAK-DL +                              
                      CWS299-OFF-PEAK-RV                                
P01175        COMPUTE CWS299-OFF-PEAK-EU =                              
P01175                CWS299-OFF-PEAK-DL +                              
P01175                CWS299-OFF-PEAK-RV                                
              IF CWS299-REG-TYPE-CD EQUAL WS-ON-OFF-SHLDR-PEAK          
                 COMPUTE CWS299-SHLDR-EC =                              
                         CWS299-SHLDR-EP +                              
                         CWS299-SHLDR-DL +                              
                         CWS299-SHLDR-RV                                
P01175           COMPUTE CWS299-SHLDR-EU =                              
P01175                   CWS299-SHLDR-DL +                              
P01175                   CWS299-SHLDR-RV                                
              END-IF                                                    
                                                                        
              PERFORM 6037-CPD299-XFER-VOL-UNITS THRU 6037-CPD299-EXIT  
                                                                        
           ELSE                                                         
              COMPUTE CWS299-NON-TOU-EC =                               
                      CWS299-NON-TOU-EP +                               
                      CWS299-NON-TOU-DL +                               
                      CWS299-NON-TOU-RV                                 
P01175        COMPUTE CWS299-NON-TOU-EU =                               
P01175                CWS299-NON-TOU-DL +                               
P01175                CWS299-NON-TOU-RV                                 
                                                                        
              IF CWS299-NON-TOU-EC >= 0                                 
                 COMPUTE CWS299-NON-TOU-BI = CWS299-NON-TOU-EC          
                 MOVE ZEROS               TO CWS299-NON-TOU-EC          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6007-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * INSERT/UPDATE LOGIC FOR NEW CALCULATED VOLUMES                 *        
      * BASED ON THE TYPE OF RATE ALLOCATE SPECIFIC VOLUMES            *        
      *     1. TOU RATE (2/3 REGISTERS)                                *        
      *        A. DL - DELIVERED TO CUSTOMER  --> TIME PERIOD 1,2      *        
      *        B. RV - RECEIVED FROM CUSTOMER --> TIME PERIOD 1,2      *        
      *        C. EP - EXCESS PREVIOUS BILL   --> TIME PERIOD 1,2      *        
      *        D. T2 - EXCESS TO OFF FROM ON  --> TOU 1                *        
      *        E. F1 - EXCESS FROM ON TO OFF  --> TOU 2                *        
      *        F. BI - BILLED                 --> TIME PERIOD 1,2      *        
      *        G. EC - EXCESS CURRENT BILL    --> TIME PERIOD 1,2      *        
      *     2. TOU RATE (3 REGISTERS)                                  *        
      *        A. DL - DELIVERED TO CUSTOMER  --> TIME PERIOD 3        *        
      *        B. RV - RECEIVED FROM CUSTOMER --> TIME PERIOD 3        *        
      *        C. EP - EXCESS PREVIOUS BILL   --> TIME PERIOD 3        *        
      *        D. T3 - EXCESS TO SHOULDER FROM ON  --> TOU 3        *  *        
      *        E. F1 - EXCESS FROM ON TO SHOULDER  --> TOU 3        *  *        
      *        D. T2 - EXCESS TO OFF FROM SHOULDER --> TOU 2        *  *        
      *        E. F3 - EXCESS FROM SHOULDER TO OFF --> TOU 2        *  *        
      *     3. NON-TOU RATE                                            *        
      *        A. DL - DELIVERED TO CUSTOMER  --> TIME PERIOD 0        *        
      *        B. RV - RECEIVED FROM CUSTOMER --> TIME PERIOD 0        *        
      *        C. EP - EXCESS PREVIOUS BILL   --> TIME PERIOD 0        *        
      *        D. BI - BILLED                 --> TIME PERIOD 0        *        
      *        E. EC - EXCESS CURRENT BILL    --> TIME PERIOD 0        *        
      ******************************************************************        
       6008-CPD299-INSRT-UPD-VOL.                                       
      *                                                                         
           MOVE CWS299-IN-BILL-NO            TO ND-BILL-NO.             
           MOVE CWS299-IN-CODE-UTIL-TYPE     TO ND-CODE-UTIL-TYPE.      
           MOVE CWS299-IN-IC-NO              TO ND-IC-NO.               
           MOVE CWS299-IN-BILL-ITM-TIMESTMP  TO ND-BILL-ITEM-TIMESTMP.  
           MOVE CWS299-ENERGY-UNIT-CD TO ND-ENERGY-UNIT-CD.             
           IF CWS299-BAL-OFFSET-TOU EQUAL WS-APPLY-TO-LESR-TOU          
              EVALUATE CWS299-REG-TYPE-CD                               
                WHEN WS-ON-OFF-PEAK                                     
                    PERFORM 6033-CPD299-INS-OFF-PK-VOL                  
                                                THRU 6033-CPD299-EXIT   
                    PERFORM 6034-CPD299-INS-ON-PK-VOL                   
                                                THRU 6034-CPD299-EXIT   
                WHEN WS-ON-OFF-SHLDR-PEAK                               
                    PERFORM 6033-CPD299-INS-OFF-PK-VOL                  
                                                THRU 6033-CPD299-EXIT   
                    PERFORM 6034-CPD299-INS-ON-PK-VOL                   
                                                THRU 6034-CPD299-EXIT   
                    PERFORM 6035-CPD299-INS-SHLDR-VOL                   
                                                THRU 6035-CPD299-EXIT   
                WHEN OTHER                                              
                    PERFORM 6036-CPD299-INS-NON-TOU-VOL                 
                                                THRU 6036-CPD299-EXIT   
              END-EVALUATE                                              
           ELSE                                                         
              PERFORM 6036-CPD299-INS-NON-TOU-VOL                       
                                                THRU 6036-CPD299-EXIT   
           END-IF.                                                      
      *                                                                         
       6008-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * Create missing month WQ                                        *        
      ******************************************************************        
       6009-CPD299-CREATE-WQ.                                           
      *                                                                         
ID1959     SET CWS299-NON-DB2-ERROR      TO TRUE.                       
ID1959*                                                                         
ID1959*******CHECK FOR SECURED RATE                                             
ID1959     MOVE CWS299-IN-RATE-PLAN      TO RD-RATE-PLAN-NO.            
ID1959     MOVE CWS299-IN-CODE-UTIL-TYPE TO RD-CODE-UTIL-TYPE.          
ID1959     PERFORM 6590-CPD299-CHK-SECURED THRU 6590-CPD299-EXIT.       
ID1959*                                                                         
      *******GENERATE WQ                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
ACT108         MOVE ZEROES               TO WS-77-SERV-ORDER-NO         
ACT108                                      WS-77-FREE-FORM-LEN         
ACT108         MOVE SPACES               TO WS-77-RESP-AREA-ID          
ACT108                                      WS-77-FREE-FORM-TXT         
ACT108         MOVE CWS299-IN-COMMON-DT  TO WS-77-DATE-REQUIRED         
ACT108                                      WS-77-DATE-CREATED          
ACT108         MOVE 'H'                  TO WS-77-PRIORITY              
ACT108         MOVE 4                    TO WS-77-ROUTE-CATEGORY        
               PERFORM 6610-CPD299-GET-ACCT                             
                                         THRU 6610-CPD299-EXIT          
               IF SQLCODE = SUCCESSFUL-CALL                             
ACT108            MOVE AT-PREMISE-NO     TO WS-77-PREMISE-NO            
ACT108            MOVE AT-CUSTOMER-NO    TO WS-77-CUSTOMER-NO           
ACT108            MOVE CWS299-SYSTEM     TO WS-77-USER-ID-ORIG          
ACT108                 MOVE AT-LOCAL-OFFICE   TO WS-77-LOCAL-OFFICE     
                       IF RD-SECURED-RATE-FL = 'Y'                      
ACT108                    MOVE CWS299-CATG-ID-138 TO WS-77-CATEGORY-ID  
                       ELSE                                             
ACT108                    MOVE CWS299-CATG-ID-17  TO WS-77-CATEGORY-ID  
                       END-IF                                           
                       PERFORM 6600-CPD299-INSRT-WQ                     
                                              THRU 6600-CPD299-EXIT     
                       IF SQLCODE = SUCCESSFUL-CALL                     
                          MOVE CWS299-EXCLUDE TO AT-CODE-ACCT-BILLED    
                          PERFORM 6565-CPD299-UPDATE-AT                 
                                              THRU 6565-CPD299-EXIT     
                       END-IF                                           
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
       6009-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * Insert OFF peak volume types to table.                         *        
      ******************************************************************        
       6033-CPD299-INS-OFF-PK-VOL.                                      
                                                                        
           MOVE +02                        TO CWS299-ND-TIME-PERIOD.    
                                                                        
      ******INSERT/UPDATE DL FOR OFF-PEAK                                       
           SET CWS299-VOL-TYPE-DL TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE RV FOR OFF-PEAK                                       
           SET CWS299-VOL-TYPE-RV TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE EP FOR OFF-PEAK                                       
           SET CWS299-VOL-TYPE-EP TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE BI FOR OFF-PEAK                                       
           SET CWS299-VOL-TYPE-BI TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE EC FOR OFF-PEAK                                       
           SET CWS299-VOL-TYPE-EC TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
P01175******INSERT/UPDATE EU FOR OFF-PEAK                                       
P01175     SET CWS299-VOL-TYPE-EU TO TRUE                               
P01175     PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE OFF-PEAK FROM ON                                      
           SET CWS299-VOL-TYPE-F21 TO TRUE                              
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE OFF-PEAK FROM SHOULDER                                
           SET CWS299-VOL-TYPE-F23 TO TRUE                              
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
                                                                        
       6033-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * Insert ON peak volume types to table.                          *        
      ******************************************************************        
       6034-CPD299-INS-ON-PK-VOL.                                       
                                                                        
           MOVE +01                        TO CWS299-ND-TIME-PERIOD.    
                                                                        
      ******INSERT/UPDATE DL FOR ON-PEAK                                        
           SET CWS299-VOL-TYPE-DL TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE RV FOR ON-PEAK                                        
           SET CWS299-VOL-TYPE-RV TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE EP FOR ON-PEAK                                        
           SET CWS299-VOL-TYPE-EP TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE BI FOR ON-PEAK                                        
           SET CWS299-VOL-TYPE-BI TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE EC FOR ON-PEAK                                        
           SET CWS299-VOL-TYPE-EC TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
P01175******INSERT/UPDATE EU FOR ON-PEAK                                        
P01175     SET CWS299-VOL-TYPE-EU TO TRUE                               
P01175     PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE ON-PEAK to OFF                                        
           SET CWS299-VOL-TYPE-T12 TO TRUE                              
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE ON-PEAK to SHOULDER                                   
           SET CWS299-VOL-TYPE-T13 TO TRUE                              
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
                                                                        
       6034-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * Insert SHOULDER volume types to table.                         *        
      ******************************************************************        
       6035-CPD299-INS-SHLDR-VOL.                                       
                                                                        
           MOVE +03                        TO CWS299-ND-TIME-PERIOD.    
                                                                        
      ******INSERT/UPDATE DL FOR SHOULDER                                       
           SET CWS299-VOL-TYPE-DL TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE RV FOR SHOULDER                                       
           SET CWS299-VOL-TYPE-RV TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE EP FOR SHOULDER                                       
           SET CWS299-VOL-TYPE-EP TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE BI FOR SHOULDER                                       
           SET CWS299-VOL-TYPE-BI TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE EC FOR SHOULDER                                       
           SET CWS299-VOL-TYPE-EC TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
P01175******INSERT/UPDATE EU FOR SHOULDER                                       
P01175     SET CWS299-VOL-TYPE-EU TO TRUE                               
P01175     PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE SHOULDER TO OFF                                       
           SET CWS299-VOL-TYPE-T32 TO TRUE                              
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE SHOULDER FROM ON                                      
           SET CWS299-VOL-TYPE-F31 TO TRUE                              
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
                                                                        
       6035-CPD299-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * Insert NON-TOU volume types to table.                          *        
      ******************************************************************        
       6036-CPD299-INS-NON-TOU-VOL.                                     
                                                                        
           MOVE ZEROES                     TO CWS299-ND-TIME-PERIOD.    
                                                                        
      ******INSERT/UPDATE DL FOR NON-TOU                                        
           SET CWS299-VOL-TYPE-DL TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE RV FOR NON-TOU                                        
           SET CWS299-VOL-TYPE-RV TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE EP FOR NON-TOU                                        
           SET CWS299-VOL-TYPE-EP TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE BI FOR NON-TOU                                        
           SET CWS299-VOL-TYPE-BI TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
      ******INSERT/UPDATE EC FOR NON-TOU                                        
           SET CWS299-VOL-TYPE-EC TO TRUE                               
           PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
P01175******INSERT/UPDATE EU FOR NON-TOU                                        
P01175     SET CWS299-VOL-TYPE-EU TO TRUE                               
P01175     PERFORM 6100-INS-UPD-VOL-DAILY       THRU 6100-CPD299-EXIT.  
                                                                        
       6036-CPD299-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * Trasnfer units.                                                *        
      * Excess units are applied in this order -                       *        
      *    1. Shoulder to OFF-Peak.                                    *        
      *    2. ON-Peak to Shoulder.                                     *        
      *    3. ON-Peak to OFF-Peak.                                     *        
      ******************************************************************        
       6037-CPD299-XFER-VOL-UNITS.                                      
                                                                        
      *******TRANSFER EXCESS SHOULDER TO OFF-PEAK                               
           MOVE ZEROS                  TO CWS299-XFER-UNITS             
                                          CWS299-XFER-FROM-UNITS        
                                          CWS299-XFER-TO-UNITS          
           IF CWS299-OFF-PEAK-EC > 0 AND CWS299-SHLDR-EC < 0            
                                                    AND CWS299-NO-ERROR 
                                                                        
              COMPUTE CWS299-TEMP-UNITS = CWS299-SHLDR-EC        +      
                                          CWS299-OFF-PEAK-EC            
              IF CWS299-TEMP-UNITS > 0                                  
                 MOVE CWS299-SHLDR-EC        TO CWS299-XFER-UNITS       
              ELSE                                                      
                 IF CWS299-TEMP-UNITS NOT EQUAL ZEROES                  
                    COMPUTE CWS299-XFER-UNITS = CWS299-OFF-PEAK-EC * -1 
                 END-IF                                                 
              END-IF                                                    
                                                                        
              COMPUTE CWS299-OFF-PEAK-F23  = CWS299-XFER-UNITS          
              COMPUTE CWS299-SHLDR-T32     = CWS299-XFER-UNITS * -1     
              COMPUTE CWS299-SHLDR-EC      = CWS299-SHLDR-EC      +     
                                             CWS299-SHLDR-T32           
              COMPUTE CWS299-OFF-PEAK-EC   = CWS299-OFF-PEAK-EC   +     
                                             CWS299-OFF-PEAK-F23        
                                                                        
              MOVE CWS299-SHOULDER           TO CWS299-OFF-PEAK-F23-SEQ 
              MOVE CWS299-OFF-PEAK           TO CWS299-SHLDR-T32-SEQ    
           END-IF.                                                      
                                                                        
      *******TRANSFER EXCESS ON-PEAK TO SHOULDER                                
           MOVE ZEROS                        TO CWS299-XFER-UNITS       
                                                CWS299-XFER-FROM-UNITS  
                                                CWS299-XFER-TO-UNITS    
                                                                        
           IF CWS299-SHLDR-EC > 0 AND CWS299-ON-PEAK-EC < 0             
                                                    AND CWS299-NO-ERROR 
                                                                        
              COMPUTE CWS299-TEMP-UNITS = CWS299-ON-PEAK-EC      +      
                                          CWS299-SHLDR-EC               
              IF CWS299-TEMP-UNITS > 0                                  
                 MOVE CWS299-ON-PEAK-EC      TO CWS299-XFER-UNITS       
              ELSE                                                      
                 IF CWS299-TEMP-UNITS NOT EQUAL ZEROES                  
                    COMPUTE CWS299-XFER-UNITS = CWS299-SHLDR-EC * -1    
                 END-IF                                                 
              END-IF                                                    
                                                                        
              COMPUTE CWS299-SHLDR-F31     = CWS299-XFER-UNITS          
              COMPUTE CWS299-ON-PEAK-T13   = CWS299-XFER-UNITS * -1     
              COMPUTE CWS299-ON-PEAK-EC    = CWS299-ON-PEAK-EC    +     
                                             CWS299-ON-PEAK-T13         
              COMPUTE CWS299-SHLDR-EC      = CWS299-SHLDR-EC      +     
                                             CWS299-SHLDR-F31           
                                                                        
              MOVE CWS299-ON-PEAK            TO CWS299-SHLDR-F31-SEQ    
              MOVE CWS299-SHOULDER           TO CWS299-ON-PEAK-T13-SEQ  
           END-IF.                                                      
                                                                        
      *******TRANSFER EXCESS ON-PEAK TO OFF-PEAK                                
           MOVE ZEROS                        TO CWS299-XFER-UNITS       
                                                CWS299-XFER-FROM-UNITS  
                                                CWS299-XFER-TO-UNITS    
                                                                        
           IF CWS299-OFF-PEAK-EC > 0 AND CWS299-ON-PEAK-EC < 0          
                                                  AND CWS299-NO-ERROR   
              COMPUTE CWS299-XFER-FROM-UNITS ROUNDED =                  
                      CWS299-ON-PEAK-EC                                 
              COMPUTE CWS299-XFER-TO-UNITS   ROUNDED =                  
                      CWS299-OFF-PEAK-EC                                
                                                                        
              COMPUTE CWS299-TEMP-UNITS = CWS299-ON-PEAK-EC      +      
                                          CWS299-OFF-PEAK-EC            
              IF CWS299-TEMP-UNITS > 0                                  
                 MOVE CWS299-ON-PEAK-EC      TO CWS299-XFER-UNITS       
              ELSE                                                      
                 IF CWS299-TEMP-UNITS NOT EQUAL ZEROES                  
                    COMPUTE CWS299-XFER-UNITS = CWS299-OFF-PEAK-EC * -1 
                 END-IF                                                 
              END-IF                                                    
                                                                        
              COMPUTE CWS299-OFF-PEAK-F21  = CWS299-XFER-UNITS          
              COMPUTE CWS299-ON-PEAK-T12   = CWS299-XFER-UNITS * -1     
              COMPUTE CWS299-ON-PEAK-EC    = CWS299-ON-PEAK-EC    +     
                                             CWS299-ON-PEAK-T12         
              COMPUTE CWS299-OFF-PEAK-EC   = CWS299-OFF-PEAK-EC   +     
                                             CWS299-OFF-PEAK-F21        
                                                                        
              MOVE CWS299-OFF-PEAK           TO CWS299-ON-PEAK-T12-SEQ  
              MOVE CWS299-ON-PEAK            TO CWS299-OFF-PEAK-F21-SEQ 
           END-IF.                                                      
                                                                        
           IF CWS299-NO-ERROR                                           
              IF CWS299-ON-PEAK-EC >= 0                                 
                 COMPUTE CWS299-ON-PEAK-BI = CWS299-ON-PEAK-EC          
                 MOVE ZEROS               TO CWS299-ON-PEAK-EC          
              END-IF                                                    
                                                                        
              IF CWS299-OFF-PEAK-EC >= 0                                
                 COMPUTE CWS299-OFF-PEAK-BI = CWS299-OFF-PEAK-EC        
                 MOVE ZEROS               TO CWS299-OFF-PEAK-EC         
              END-IF                                                    
                                                                        
              IF CWS299-SHLDR-EC >= 0                                   
                 COMPUTE CWS299-SHLDR-BI = CWS299-SHLDR-EC              
                 MOVE ZEROS               TO CWS299-SHLDR-EC            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6037-CPD299-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * PROCESS NON TOU DL VOLUME.                                     *        
      ******************************************************************        
       6100-INS-UPD-VOL-DAILY.                                          
      *                                                                         
           IF CWS299-NO-ERROR                                           
              MOVE ZEROS                     TO CWS299-UNITS            
                                                ND-FIXED-FCTR-SEQ-NO    
                                                ND-FIXED-FCTR-SEQ-NO    
                                                                        
              MOVE SPACES                    TO CWS299-HOLD-DATE-READ   
                                                                        
              MOVE CWS299-VOL-TYPE-CD        TO ND-VOL-TYPE-CD          
                                                                        
              PERFORM 6110-SET-VOLUME-UNITS     THRU 6110-CPD299-EXIT   
              MOVE CWS299-HOLD-TIME-PERIOD    TO ND-CODE-TIME-PERIOD    
                                                                        
              PERFORM 6550-CPD299-GET-VOL-DLY   THRU 6550-CPD299-EXIT   
              IF SQLCODE EQUAL SUCCESSFUL-CALL                          
                 COMPUTE CWS299-HOLD-ND-NO-UNITS ROUNDED = ND-NO-UNITS  
                 IF ND-DATE-READ EQUAL CWS299-HOLD-DATE-READ            
                    IF CWS299-HOLD-ND-NO-UNITS NOT EQUAL CWS299-UNITS   
                       MOVE CWS299-UNITS      TO ND-NO-UNITS            
ID1959                 PERFORM 6150-CPD299-CHK-EXCESS-USAGE             
ID1959                    THRU 6150-CPD299-EXIT                         
                       PERFORM 6560-CPD299-UPDATE-ND                    
                                                THRU 6560-CPD299-EXIT   
                    END-IF                                              
                 ELSE                                                   
                    PERFORM 6580-CPD299-DELETE-ND                       
                                                THRU 6580-CPD299-EXIT   
                    IF CWS299-NO-ERROR                                  
                       MOVE CWS299-HOLD-DATE-READ TO ND-DATE-READ       
ID1959                 MOVE CWS299-UNITS          TO ND-NO-UNITS        
ID1959                 PERFORM 6150-CPD299-CHK-EXCESS-USAGE             
ID1959                    THRU 6150-CPD299-EXIT                         
                       PERFORM 6570-CPD299-INSERT-ND                    
                                                THRU 6570-CPD299-EXIT   
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 MOVE CWS299-UNITS            TO ND-NO-UNITS            
                 MOVE CWS299-HOLD-DATE-READ   TO ND-DATE-READ           
ID1959           PERFORM 6150-CPD299-CHK-EXCESS-USAGE                   
ID1959              THRU 6150-CPD299-EXIT                               
                 PERFORM 6570-CPD299-INSERT-ND                          
                                                THRU 6570-CPD299-EXIT   
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6100-CPD299-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * PROCESS NON TOU DL VOLUME.                                     *        
      ******************************************************************        
       6110-SET-VOLUME-UNITS.                                           
                                                                        
           EVALUATE TRUE                                                
               WHEN CWS299-VOL-TYPE-EP                                  
                    EVALUATE TRUE                                       
                        WHEN CWS299-NON-TOU-ND                          
                             MOVE CWS299-NON-TOU-EP    TO CWS299-UNITS  
                        WHEN CWS299-ON-PEAK-ND                          
                             MOVE CWS299-ON-PEAK-EP    TO CWS299-UNITS  
                        WHEN CWS299-OFF-PEAK-ND                         
                             MOVE CWS299-OFF-PEAK-EP TO CWS299-UNITS    
                        WHEN CWS299-SHOULDER-ND                         
                             MOVE CWS299-SHLDR-EP      TO CWS299-UNITS  
                    END-EVALUATE                                        
               WHEN CWS299-VOL-TYPE-DL                                  
                    EVALUATE TRUE                                       
                        WHEN CWS299-NON-TOU-ND                          
                             MOVE CWS299-NON-TOU-DL    TO CWS299-UNITS  
                        WHEN CWS299-ON-PEAK-ND                          
                             MOVE CWS299-ON-PEAK-DL    TO CWS299-UNITS  
                        WHEN CWS299-OFF-PEAK-ND                         
                             MOVE CWS299-OFF-PEAK-DL TO CWS299-UNITS    
                        WHEN CWS299-SHOULDER-ND                         
                             MOVE CWS299-SHLDR-DL      TO CWS299-UNITS  
                    END-EVALUATE                                        
               WHEN CWS299-VOL-TYPE-RV                                  
                    EVALUATE TRUE                                       
                        WHEN CWS299-NON-TOU-ND                          
                             MOVE CWS299-NON-TOU-RV    TO CWS299-UNITS  
                        WHEN CWS299-ON-PEAK-ND                          
                             MOVE CWS299-ON-PEAK-RV    TO CWS299-UNITS  
                        WHEN CWS299-OFF-PEAK-ND                         
                             MOVE CWS299-OFF-PEAK-RV TO CWS299-UNITS    
                        WHEN CWS299-SHOULDER-ND                         
                             MOVE CWS299-SHLDR-RV      TO CWS299-UNITS  
                    END-EVALUATE                                        
               WHEN CWS299-VOL-TYPE-EC                                  
                    EVALUATE TRUE                                       
                        WHEN CWS299-NON-TOU-ND                          
                             MOVE CWS299-NON-TOU-EC    TO CWS299-UNITS  
                        WHEN CWS299-ON-PEAK-ND                          
                             MOVE CWS299-ON-PEAK-EC    TO CWS299-UNITS  
                        WHEN CWS299-OFF-PEAK-ND                         
                             MOVE CWS299-OFF-PEAK-EC TO CWS299-UNITS    
                        WHEN CWS299-SHOULDER-ND                         
                             MOVE CWS299-SHLDR-EC      TO CWS299-UNITS  
                    END-EVALUATE                                        
P01175         WHEN CWS299-VOL-TYPE-EU                                  
P01175              EVALUATE TRUE                                       
P01175                  WHEN CWS299-NON-TOU-ND                          
P01175                       MOVE CWS299-NON-TOU-EU    TO CWS299-UNITS  
P01175                  WHEN CWS299-ON-PEAK-ND                          
P01175                       MOVE CWS299-ON-PEAK-EU    TO CWS299-UNITS  
P01175                  WHEN CWS299-OFF-PEAK-ND                         
P01175                       MOVE CWS299-OFF-PEAK-EU TO CWS299-UNITS    
P01175                  WHEN CWS299-SHOULDER-ND                         
P01175                       MOVE CWS299-SHLDR-EU      TO CWS299-UNITS  
P01175              END-EVALUATE                                        
               WHEN CWS299-VOL-TYPE-BI                                  
                    EVALUATE TRUE                                       
                        WHEN CWS299-NON-TOU-ND                          
                             MOVE CWS299-NON-TOU-BI    TO CWS299-UNITS  
                        WHEN CWS299-ON-PEAK-ND                          
                             MOVE CWS299-ON-PEAK-BI    TO CWS299-UNITS  
                        WHEN CWS299-OFF-PEAK-ND                         
                             MOVE CWS299-OFF-PEAK-BI TO CWS299-UNITS    
                        WHEN CWS299-SHOULDER-ND                         
                             MOVE CWS299-SHLDR-BI      TO CWS299-UNITS  
                    END-EVALUATE                                        
               WHEN CWS299-VOL-TYPE-T12                                 
                    EVALUATE TRUE                                       
                        WHEN CWS299-ON-PEAK-ND                          
                             MOVE CWS299-ON-PEAK-T12   TO CWS299-UNITS  
                             MOVE CWS299-ON-PEAK-T12-SEQ                
                                               TO ND-FIXED-FCTR-SEQ-NO  
                    END-EVALUATE                                        
               WHEN CWS299-VOL-TYPE-T32                                 
                    EVALUATE TRUE                                       
                        WHEN CWS299-SHOULDER-ND                         
                             MOVE CWS299-SHLDR-T32     TO CWS299-UNITS  
                             MOVE CWS299-SHLDR-T32-SEQ                  
                                               TO ND-FIXED-FCTR-SEQ-NO  
                    END-EVALUATE                                        
               WHEN CWS299-VOL-TYPE-T13                                 
                    EVALUATE TRUE                                       
                        WHEN CWS299-ON-PEAK-ND                          
                             MOVE CWS299-ON-PEAK-T13   TO CWS299-UNITS  
                             MOVE CWS299-ON-PEAK-T13-SEQ                
                                               TO ND-FIXED-FCTR-SEQ-NO  
                    END-EVALUATE                                        
               WHEN CWS299-VOL-TYPE-F21                                 
                    EVALUATE TRUE                                       
                        WHEN CWS299-OFF-PEAK-ND                         
                             MOVE CWS299-OFF-PEAK-F21 TO CWS299-UNITS   
                             MOVE CWS299-OFF-PEAK-F21-SEQ               
                                               TO ND-FIXED-FCTR-SEQ-NO  
                    END-EVALUATE                                        
               WHEN CWS299-VOL-TYPE-F23                                 
                    EVALUATE TRUE                                       
                        WHEN CWS299-OFF-PEAK-ND                         
                             MOVE CWS299-OFF-PEAK-F23 TO CWS299-UNITS   
                             MOVE CWS299-OFF-PEAK-F23-SEQ               
                                               TO ND-FIXED-FCTR-SEQ-NO  
                    END-EVALUATE                                        
               WHEN CWS299-VOL-TYPE-F31                                 
                    EVALUATE TRUE                                       
                        WHEN CWS299-SHOULDER-ND                         
                             MOVE CWS299-SHLDR-F31   TO CWS299-UNITS    
                             MOVE CWS299-SHLDR-F31-SEQ                  
                                               TO ND-FIXED-FCTR-SEQ-NO  
                    END-EVALUATE                                        
           END-EVALUATE.                                                
                                                                        
           EVALUATE TRUE                                                
               WHEN CWS299-NON-TOU-ND                                   
                    MOVE CWS299-NON-TOU       TO CWS299-HOLD-TIME-PERIOD
                    MOVE CWS299-NON-TOU-RDDT  TO CWS299-HOLD-DATE-READ  
               WHEN CWS299-ON-PEAK-ND                                   
                    MOVE CWS299-ON-PEAK       TO CWS299-HOLD-TIME-PERIOD
                    MOVE CWS299-ON-PEAK-RDDT                            
                                              TO CWS299-HOLD-DATE-READ  
               WHEN CWS299-OFF-PEAK-ND                                  
                    MOVE CWS299-OFF-PEAK      TO CWS299-HOLD-TIME-PERIOD
                    MOVE CWS299-OFF-PEAK-RDDT                           
                                              TO CWS299-HOLD-DATE-READ  
               WHEN CWS299-SHOULDER-ND                                  
                    MOVE CWS299-SHOULDER      TO CWS299-HOLD-TIME-PERIOD
                    MOVE CWS299-SHLDR-RDDT                              
                                              TO CWS299-HOLD-DATE-READ  
           END-EVALUATE.                                                
                                                                        
       6110-CPD299-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * PROCESS VOLUME CX.                                             *        
      ******************************************************************        
       6120-PROCESS-VOLUME.                                             
                                                                        
           MOVE 'N'                       TO CWS299-CX-NOT-FOUND        
           PERFORM 6004-CPD299-GET-CNSMPTN   THRU 6004-CPD299-EXIT      
           IF CWS299-NO-ERROR                                           
              IF CWS299-FIRST-BG                                        
                 MOVE CWS299-IN-REVENUE-MONTH  TO BG-REVENUE-MONTH      
                 IF CWS299-HOLD-REV-MTH-MM NOT EQUAL                    
                                               CWS299-CMP-BAL-RST-MM    
ID1959              MOVE CWS299-REG-TYPE-CD                             
ID1959                TO CWS299-N2-REG-TYPE-CD                          
ID1959              MOVE CWS299-CMP-BAL-FWD-RESET                       
ID1959                TO CWS299-N2-CMP-BAL-FWD-RES                      
ID1959              MOVE CWS299-BAL-RESET-MMDD                          
ID1959                TO CWS299-N2-BAL-RESET-MMDD                       
ID1959              MOVE CWS299-BAL-OFFSET-TOU                          
ID1959                TO CWS299-N2-BAL-OFFSET-TOU                       
ID1959              MOVE CWS299-ENERGY-UNIT-CD                          
ID1959                TO CWS299-N2-ENERGY-UNIT-CD                       
ID1959              MOVE CWS299-BAL-FWD-CD                              
ID1959                TO CWS299-N2-BAL-FWD-CD                           
                    PERFORM 6510-CPD299-GET-PREV-BG                     
                                             THRU 6510-CPD299-EXIT      
                    IF CWS299-NO-ERROR                                  
                       SET CWS299-NOT-NM-RATE     TO TRUE               
                       MOVE BG-RATE-PLAN-NO  TO CWS299-HOLD-RATE-PLAN   
                       PERFORM 6003-CPD299-CHK-NM-RATE                  
                                             THRU 6003-CPD299-EXIT      
                    END-IF                                              
                    IF CWS299-NM-RATE                                   
                       PERFORM 6006-CPD299-ALLOCATE-EP                  
                                             THRU 6006-CPD299-EXIT      
                    END-IF                                              
ID1959              MOVE CWS299-N2-REG-TYPE-CD                          
ID1959                TO CWS299-REG-TYPE-CD                             
ID1959              MOVE CWS299-N2-CMP-BAL-FWD-RES                      
ID1959                TO CWS299-CMP-BAL-FWD-RESET                       
ID1959              MOVE CWS299-N2-BAL-RESET-MMDD                       
ID1959                TO CWS299-BAL-RESET-MMDD                          
ID1959              MOVE CWS299-N2-BAL-OFFSET-TOU                       
ID1959                TO CWS299-BAL-OFFSET-TOU                          
ID1959              MOVE CWS299-N2-ENERGY-UNIT-CD                       
ID1959                TO CWS299-ENERGY-UNIT-CD                          
ID1959              MOVE CWS299-N2-BAL-FWD-CD                           
ID1959                TO CWS299-BAL-FWD-CD                              
                 END-IF                                                 
                 SET CWS299-NOT-FIRST-BG       TO TRUE                  
              ELSE                                                      
      *******VALIDATE CONSECUTIVE REVENUE MONTHS ARE BEING PROCESSED            
                 IF CWS299-HOLD-REV-MTH-MM EQUAL                        
                                               CWS299-CMP-BAL-RST-MM    
                    MOVE ZEROES        TO   CWS299-NON-TOU-PREV-EC      
                                            CWS299-ON-PEAK-PREV-EC      
                                            CWS299-OFF-PEAK-PREV-EC     
                                            CWS299-SHLDR-PREV-EC        
                 END-IF                                                 
                 MOVE CWS299-NON-TOU-PREV-EC                            
                                       TO CWS299-NON-TOU-EP             
                 MOVE CWS299-ON-PEAK-PREV-EC                            
                                       TO CWS299-ON-PEAK-EP             
                 MOVE CWS299-OFF-PEAK-PREV-EC                           
                                       TO CWS299-OFF-PEAK-EP            
                 MOVE CWS299-SHLDR-PREV-EC                              
                                       TO CWS299-SHLDR-EP               
              END-IF                                                    
              IF CWS299-NO-ERROR                                        
                 PERFORM 6007-CPD299-ALLOCATE-REM                       
                                       THRU 6007-CPD299-EXIT            
                 IF CWS299-NO-ERROR                                     
                    PERFORM 6008-CPD299-INSRT-UPD-VOL                   
                                       THRU 6008-CPD299-EXIT            
      *****STOPROCESSED REVENUE MONTH FOR NEXT BG VALIDATION.                   
                    MOVE CWS299-IN-REVENUE-MONTH                        
                                           TO CWS299-HOLD-REV-MONTH     
                    MOVE CWS299-NON-TOU-EC TO CWS299-NON-TOU-PREV-EC    
                    MOVE CWS299-ON-PEAK-EC                              
                                         TO CWS299-ON-PEAK-PREV-EC      
                    MOVE CWS299-OFF-PEAK-EC                             
                                         TO CWS299-OFF-PEAK-PREV-EC     
                    MOVE CWS299-SHLDR-EC                                
                                         TO CWS299-SHLDR-PREV-EC        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6120-CPD299-EXIT.                                                
           EXIT.                                                        
                                                                        
ID1959******************************************************************        
ID1959** IF MONTH OF REVENUE MONTH = EXCESS USAGE CREDIT/RESET MONTH, **        
ID1959** CREDIT/RESET USAGE                                           **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6150-CPD299-CHK-EXCESS-USAGE.                                    
ID1959*                                                                         
ID1959     IF CWS299-BAL-FWD-CD            = 'C'   AND                  
ID1959        ND-VOL-TYPE-CD               = 'EC'  AND                  
ID1959        ND-NO-UNITS                  <  0    AND                  
ID1959       ( (CWS299-HOLD-REV-MTH-MM     =  CWS299-BAL-RESET-MM)      
ID1959                                 OR                               
ID1959         (CWS299-IN-OFF-CYC-BILL-CD  = 'B'   AND                  
ID1959          BG-REV-MTH-ORIG-BILL       >  0    AND                  
ID1959          CWS299-IN-REV-MTH-LST-NRML =  BG-REV-MTH-ORIG-BILL)     
ID1959                                 OR                               
ID1959         (CWS299-IN-OFF-CYC-BILL-CD  = 'B'   AND                  
ID1959          BG-REV-MTH-ORIG-BILL       =  0)   )                    
ID1959        COMPUTE CWS299-N2-FAC-CHRG-BASE =                         
ID1959                CWS299-N2-FAC-CHRG-BASE + ND-NO-UNITS             
ID1959        END-COMPUTE                                               
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6150-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
ID1959******************************************************************        
ID1959** IF MONTH OF REVENUE MONTH = EXCESS USAGE CREDIT/RESET MONTH, **        
ID1959** CREDIT/RESET USAGE                                           **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6200-CPD299-PROCESS-CRED-FCTR.                                   
ID1959*                                                                         
ID1959     INITIALIZE                       DCLCSS-FIXED-FCTR           
ID1959                                      DCLCSS-FIXED-FCT-HIST       
ID1959                                      SA-DATE-FROM                
ID1959                                      SA-FACTOR.                  
ID1959*                                                                         
ID1959*** GET PR1 PRICE: INPUT DATE = BASED ON REVENUE MONTH,                   
ID1959*** SEASON = NON-SUMMER & TIME PERIOD = OFF-PEAK.                         
ID1959*** IF PRICE IS NOT-FOUND OR ZERO, CREATE A WQ                            
ID1959     MOVE CWS299-IN-CODE-UTIL-TYPE TO SA-CODE-UTIL-TYPE.          
ID1959     MOVE CWS299-HOLD-REV-MTH-YR   TO SA-DATE-FROM(1:4).          
ID1959     MOVE '-'                      TO SA-DATE-FROM(5:1).          
ID1959     MOVE CWS299-HOLD-REV-MTH-MM   TO SA-DATE-FROM(6:2).          
ID1959     MOVE '-'                      TO SA-DATE-FROM(8:1).          
ID1959     MOVE '01'                     TO SA-DATE-FROM(9:2).          
ID1959     PERFORM 6750-CPD299-GET-PR1-PRICE THRU 6750-CPD299-EXIT.     
ID1959     IF CWS299-NO-ERROR               AND                         
ID1959        SQLCODE EQUAL SUCCESSFUL-CALL AND                         
ID1959        SA-FACTOR > 0                                             
ID1959        CONTINUE                                                  
ID1959     ELSE                                                         
                                                                        
ID1959        MOVE 'PR1 Price missing or 0' TO CWS299-ERROR-MESSAGE     
ACT108        INITIALIZE CWS00077-FIELDS                                
ID1959        MOVE LENGTH OF CWS299-REVMTH-WQ-MSG                       
ACT108                                      TO WS-77-COMMENTS-LEN       
ACT108        MOVE CWS299-PRICE-WQ-MSG      TO WS-77-COMMENTS-TEXT      
ID1959        PERFORM 6009-CPD299-CREATE-WQ THRU 6009-CPD299-EXIT       
ID1959        GO TO 6200-CPD299-EXIT                                    
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959*** EXCESS USAGE CREDIT FACTOR:SEASON = BOTH, TIME PERIOD = ALL           
ID1959*** AND USE CODE = ENERGY                                                 
ID1959     MOVE CWS299-IN-ACCT-NO        TO FF-ACCOUNT-NO               
ID1959                                      FH-ACCOUNT-NO.              
ID1959     MOVE CWS299-IN-BILL-NO        TO FH-BILL-NO.                 
ID1959     MOVE CWS299-IN-CODE-UTIL-TYPE TO FF-CODE-UTIL-TYPE           
ID1959                                      FH-CODE-UTIL-TYPE.          
ID1959     MOVE CWS299-IN-IC-NO          TO FF-IC-NO                    
ID1959                                      FH-IC-NO.                   
ID1959     MOVE CWS299-IN-BILL-ITM-TIMESTMP                             
ID1959                                   TO FH-BILL-ITEM-TIMESTMP.      
ID1959     MOVE CWS299-CR-FCTR-FACTOR-ID TO FF-FACTOR-ID                
ID1959                                      FH-FACTOR-ID.               
ID1959     MOVE CWS299-CR-FCTR-CMPNT-ID  TO FF-CMPNT-ID-CD              
ID1959                                      FH-CMPNT-ID-CD.             
ID1959*                                                                         
ID1959*** MULTIPLY WITH -1 TO MAKE THE UNITS +VE VALUE                          
ID1959     COMPUTE CWS299-N2-FAC-CHRG-BASE  =                           
ID1959             CWS299-N2-FAC-CHRG-BASE  *  -1                       
ID1959     END-COMPUTE.                                                 
ID1959     MOVE CWS299-N2-FAC-CHRG-BASE  TO FF-FAC-CHRG-BASE-AM         
ID1959                                      FH-BILL-UNITS.              
ID1959*                                                                         
ID1959     IF CWS299-CR-FCTR-POWER-10 = 0                               
ID1959        MOVE SA-FACTOR             TO FF-FACTOR                   
ID1959     ELSE                                                         
ID1959        COMPUTE FF-FACTOR = SA-FACTOR *                           
ID1959               (10 **(CWS299-CR-FCTR-POWER-10 * -1))              
ID1959        END-COMPUTE                                               
ID1959     END-IF.                                                      
ID1959     MOVE FF-FACTOR                TO FH-FACTOR.                  
ID1959*                                                                         
ID1959     MOVE SA-DATE-FROM             TO FF-EFF-DATE-FROM            
ID1959                                      FH-EFF-DATE-FROM            
ID1959                                      FF-EFF-DATE-TO              
ID1959                                      FH-EFF-DATE-TO.             
ID1959     MOVE '28'                     TO FF-EFF-DATE-TO(9:2)         
ID1959                                      FH-EFF-DATE-TO(9:2).        
ID1959     MOVE 'B'                      TO FF-CODE-SEASON              
ID1959                                      FH-CODE-SEASON.             
ID1959     MOVE 'R'                      TO FF-INSTR-USE-TYPE-CD        
ID1959                                      FH-INSTR-USE-TYPE-CD.       
ID1959     MOVE  0                       TO FF-CODE-TIME-PERIOD         
ID1959                                      FH-CODE-TIME-PERIOD.        
ID1959     MOVE ' '                      TO FF-FIXED-FCTR-TYP-CD        
ID1959                                      FH-FIXED-FCTR-TYP-CD.       
ID1959*                                                                         
ID1959     MOVE CWS299-ENERGY-UNIT-CD    TO FH-ENERGY-UNIT-CD.          
ID1959*                                                                         
ID1959     MOVE CWS299-CR-FCTR-POWER-10  TO FH-FCTR-POWER-10.           
ID1959     MOVE CWS299-CR-FCTR-DECIMAL   TO FH-FCTR-DECIMAL-PLACE.      
ID1959     MOVE CWS299-CR-FCTR-DR-CR     TO FH-CODE-DEBIT-CREDIT.       
ID1959     MOVE CWS299-CR-FCTR-PRO-FL    TO FH-OVR-RT-VER-PRO-FL.       
ID1959     MOVE CWS299-CR-FCTR-STAT-XMT  TO FH-CODE-TAX-STAT-XMT.       
ID1959     MOVE CWS299-CR-FCTR-CITY-XMT  TO FH-CODE-TAX-CITY-XMT.       
ID1959     MOVE CWS299-CR-FCTR-OTHR-XMT  TO FH-CODE-TAX-OTHR-XMT.       
ID1959*                                                                         
ID1959     MOVE BG-CODE-REVENUE-CLASS    TO FH-CODE-REVENUE-CLASS.      
ID1959*                                                                         
ID1959*** REGULAR BILL-FIXED FCTR: SELECT EXCESS USAGE CREDIT FACTOR.           
ID1959*** IF EXISTS, UPDATE FIXED FCTR DATA ELSE INSERT                         
ID1959     IF CWS299-NO-ERROR                                           
ID1959        AND BG-REV-MTH-ORIG-BILL = 0                              
ID1959        PERFORM 6760-CPD299-GET-FACTOR-DATA                       
ID1959           THRU 6760-CPD299-EXIT                                  
ID1959        IF CWS299-NO-ERROR                                        
ID1959           IF SQLCODE EQUAL SUCCESSFUL-CALL                       
ID1959              PERFORM 6775-CPD299-UPDATE-FIXED-FCTR               
ID1959                 THRU 6775-CPD299-EXIT                            
ID1959           ELSE                                                   
ID1959              PERFORM 6790-CPD299-GET-FIXED-FCTR-SEQ              
ID1959                 THRU 6790-CPD299-EXIT                            
ID1959              IF CWS299-NO-ERROR                                  
ID1959                 PERFORM 6800-CPD299-INSERT-FIXED-FCTR            
ID1959                    THRU 6800-CPD299-EXIT                         
ID1959              END-IF                                              
ID1959           END-IF                                                 
ID1959        END-IF                                                    
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959*** CANCEL REBILL-FIXED FCTR HISTORY: SELECT EXCESS USAGE CREDIT          
ID1959*** FACTOR. IF EXISTS, UPDATE FIXED FCTR HIST DATA ELSE INSERT            
ID1959     IF CWS299-NO-ERROR                                           
ID1959        AND BG-REV-MTH-ORIG-BILL > 0                              
ID1959        PERFORM 6810-CPD299-GET-FCTR-HIST-DATA                    
ID1959           THRU 6810-CPD299-EXIT                                  
ID1959        IF CWS299-NO-ERROR                                        
ID1959           IF SQLCODE EQUAL SUCCESSFUL-CALL                       
ID1959              PERFORM 6825-CPD299-UPDATE-FCTR-HIST                
ID1959                 THRU 6825-CPD299-EXIT                            
ID1959           ELSE                                                   
ID1959              PERFORM 6840-CPD299-GET-FCTR-HIST-SEQ               
ID1959                 THRU 6840-CPD299-EXIT                            
ID1959              IF CWS299-NO-ERROR                                  
ID1959                 PERFORM 6850-CPD299-INSERT-FCTR-HIST             
ID1959                    THRU 6850-CPD299-EXIT                         
ID1959              END-IF                                              
ID1959           END-IF                                                 
ID1959        END-IF                                                    
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6200-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
      ******************************************************************        
      * GET THE PREVIOUS BILLING DETAIL.                               *        
      ******************************************************************        
       6510-CPD299-GET-PREV-BG.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) BG.BILL_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), BG.BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP,
              BG.RATE_PLAN_NO                                   
                 INTO :BG-BILL-NO                                       
                     ,:BG-BILL-ITEM-TIMESTMP                            
                     ,:BG-RATE-PLAN-NO                                  
                 FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
                WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND BG.IC_NO              = :BG-IC-NO                 
                  AND BG.CODE_BILL_CALC     = 'A'                       
                  AND BG.CODE_BILL_ITM_TYPE = 'C'                       
                  AND BG.CODE_BILL_ITM_IND  IN ('A','K')                
                  AND BG.REVENUE_MONTH      > 0                         
ACT032            AND BG.REVENUE_MONTH      <= :BG-REVENUE-MONTH        
ACT032          ORDER BY BG.REVENUE_MONTH DESC,BG.BILL_NO DESC          
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG.BILL_NO                                                
MFA-TR*              ,BG.BILL_ITEM_TIMESTMP                                     
MFA-TR*              ,BG.RATE_PLAN_NO                                           
MFA-TR*          INTO :BG-BILL-NO                                               
MFA-TR*              ,:BG-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:BG-RATE-PLAN-NO                                          
MFA-TR*          FROM CSS_BILLING_DET BG                                        
MFA-TR*         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND BG.IC_NO              = :BG-IC-NO                         
MFA-TR*           AND BG.CODE_BILL_CALC     = 'A'                               
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*           AND BG.CODE_BILL_ITM_IND  IN ('A','K')                        
MFA-TR*           AND BG.REVENUE_MONTH      > 0                                 
MFA-TR*           AND BG.REVENUE_MONTH      <= :BG-REVENUE-MONTH                
MFA-TR*         ORDER BY BG.REVENUE_MONTH DESC,BG.BILL_NO DESC                  
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR SELECTING CSS_BILLING_DET'                    
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'SELECT'               TO CWS299-ERROR-FUNCTION      
              MOVE '6510'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6510-CPD299-GET-PREV-BG'                            
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_BILLING_DET'      TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
              MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
              MOVE 'REVENUE_MONTH'        TO CWS299-ERROR-TAB-COLUMN-4  
              MOVE BG-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
              MOVE BG-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
              MOVE BG-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
              MOVE BG-REVENUE-MONTH       TO CWS299-ERROR-HOSTVAR-4     
           END-IF.                                                      
      *                                                                         
       6510-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPEN CONSUMPTION HISTORY CURSOR TO GET DL AND RV UNITS         *        
      ******************************************************************        
       6520-CPD299-OPEN-CX.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN CNSMPTN_HIST                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR OPENING CNSMPTN_HIST'                         
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'OPEN'                 TO CWS299-ERROR-FUNCTION      
              MOVE '6520'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6520-CPD299-OPEN-CX'  TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_CNSMPTN_HIST'     TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
              MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
              MOVE 'BILL_NO'              TO CWS299-ERROR-TAB-COLUMN-4  
              MOVE CX-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
              MOVE CX-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
              MOVE CX-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
              MOVE CX-BILL-NO             TO CWS299-ERROR-HOSTVAR-4     
           END-IF.                                                      
      *                                                                         
       6520-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCH CONSUMPTION HISTORY CURSOR TO GET DL AND RV UNITS        *        
      ******************************************************************        
       6530-CPD299-FETCH-CX.                                            
      *                                                                         
           EXEC SQL                                                     
               FETCH CNSMPTN_HIST                                       
                INTO :CX-NO-UNITS                                       
                    ,:CX-DATE-READ                                      
                    ,:CX-CODE-USAGE-ID                                  
                    ,:CX-CODE-TIME-PERIOD                               
                    ,:CX-CODE-DEBIT-CREDIT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR FETCHING CNSMPTN_HIST'                        
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'FETCH'                TO CWS299-ERROR-FUNCTION      
              MOVE '6530'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6530-CPD299-FETCH-CX' TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_CNSMPTN_HIST'     TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
              MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
              MOVE 'BILL_NO'              TO CWS299-ERROR-TAB-COLUMN-4  
              MOVE CX-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
              MOVE CX-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
              MOVE CX-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
              MOVE CX-BILL-NO             TO CWS299-ERROR-HOSTVAR-4     
           END-IF.                                                      
      *                                                                         
       6530-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSE CONSUMPTION HISTORY CURSOR TO GET DL AND RV UNITS        *        
      ******************************************************************        
       6540-CPD299-CLOSE-CX.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE CNSMPTN_HIST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR CLOSING CNSMPTN_HIST'                         
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'CLOSE'                TO CWS299-ERROR-FUNCTION      
              MOVE '6540'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6540-CPD299-CLOSE-CX' TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_CNSMPTN_HIST'     TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
              MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
              MOVE 'BILL_NO'              TO CWS299-ERROR-TAB-COLUMN-4  
              MOVE CX-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
              MOVE CX-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
              MOVE CX-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
              MOVE CX-BILL-NO             TO CWS299-ERROR-HOSTVAR-4     
           END-IF.                                                      
      *                                                                         
       6540-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET VOLUME DAILY UNITS FOR A PARTICULAR VOL_TYPE_CD.           *        
      ******************************************************************        
       6550-CPD299-GET-VOL-DLY.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT ND.NO_UNITS                                       
                     ,ND.DATE_READ                                      
                 INTO :ND-NO-UNITS                                      
                     ,:ND-DATE-READ                                     
                 FROM CSS_VOL_DAILY ND WITH(READUNCOMMITTED)                    
                WHERE ND.ACCOUNT_NO         = :ND-ACCOUNT-NO            
                  AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE        
                  AND ND.IC_NO              = :ND-IC-NO                 
                  AND ND.BILL_NO            = :ND-BILL-NO               
                  AND ND.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )    
                  AND ND.VOL_TYPE_CD        = :ND-VOL-TYPE-CD           
                  AND ND.ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD        
                  AND ND.CODE_TIME_PERIOD   = :ND-CODE-TIME-PERIOD      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ND.NO_UNITS                                               
MFA-TR*              ,ND.DATE_READ                                              
MFA-TR*          INTO :ND-NO-UNITS                                              
MFA-TR*              ,:ND-DATE-READ                                             
MFA-TR*          FROM CSS_VOL_DAILY ND                                          
MFA-TR*         WHERE ND.ACCOUNT_NO         = :ND-ACCOUNT-NO                    
MFA-TR*           AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE                
MFA-TR*           AND ND.IC_NO              = :ND-IC-NO                         
MFA-TR*           AND ND.BILL_NO            = :ND-BILL-NO                       
MFA-TR*           AND ND.BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP            
MFA-TR*           AND ND.VOL_TYPE_CD        = :ND-VOL-TYPE-CD                   
MFA-TR*           AND ND.ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD                
MFA-TR*           AND ND.CODE_TIME_PERIOD   = :ND-CODE-TIME-PERIOD              
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              IF SQLCODE = NOT-FOUND                                    
                 MOVE ZEROS               TO ND-NO-UNITS                
                 MOVE SPACES              TO ND-DATE-READ               
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR SELECTING CSS_VOL_DAILY'                      
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'SELECT'               TO CWS299-ERROR-FUNCTION      
              MOVE '6550'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6550-CPD299-GET-VOL-DLY'                            
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_VOL_DAILY'        TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
              MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
              MOVE 'BILL_NO'              TO CWS299-ERROR-TAB-COLUMN-4  
              MOVE ND-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
              MOVE ND-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
              MOVE ND-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
              MOVE ND-BILL-NO             TO CWS299-ERROR-HOSTVAR-4     
           END-IF.                                                      
      *                                                                         
       6550-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * UPDATE VOL_DAILY FOR PARTICULAR VOL_TYPE_CD.                   *        
      ******************************************************************        
       6560-CPD299-UPDATE-ND.                                           
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_VOL_DAILY                                     
                  SET NO_UNITS           = :ND-NO-UNITS                 
                     ,FIXED_FCTR_SEQ_NO  = :ND-FIXED-FCTR-SEQ-NO        
                WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO               
                  AND BILL_NO            = :ND-BILL-NO                  
                  AND IC_NO              = :ND-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )       
                  AND VOL_TYPE_CD        = :ND-VOL-TYPE-CD              
                  AND CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE           
                  AND ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD           
                  AND CODE_TIME_PERIOD   = :ND-CODE-TIME-PERIOD         
                  AND DATE_READ          = IIF(TRY_CONVERT(DATE, 
                                                          :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_VOL_DAILY                                             
MFA-TR*           SET NO_UNITS           = :ND-NO-UNITS                         
MFA-TR*              ,FIXED_FCTR_SEQ_NO  = :ND-FIXED-FCTR-SEQ-NO                
MFA-TR*         WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :ND-BILL-NO                          
MFA-TR*           AND IC_NO              = :ND-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP               
MFA-TR*           AND VOL_TYPE_CD        = :ND-VOL-TYPE-CD                      
MFA-TR*           AND CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE                   
MFA-TR*           AND ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD                   
MFA-TR*           AND CODE_TIME_PERIOD   = :ND-CODE-TIME-PERIOD                 
MFA-TR*           AND DATE_READ          = :ND-DATE-READ                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              SET VOL-ALLOCATED TO TRUE                                 
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR UPDATING CSS_VOL_DAILY'                       
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'UPDATE'               TO CWS299-ERROR-FUNCTION      
              MOVE '6560'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6560-CPD299-UPDATE-ND'                              
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_VOL_DAILY'        TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
              MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
              MOVE 'BILL_NO'              TO CWS299-ERROR-TAB-COLUMN-4  
              MOVE ND-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
              MOVE ND-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
              MOVE ND-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
              MOVE ND-BILL-NO             TO CWS299-ERROR-HOSTVAR-4     
           END-IF.                                                      
      *                                                                         
       6560-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * EXCLUDE ACCOUNT FROM BILLING.                                  *        
      ******************************************************************        
       6565-CPD299-UPDATE-AT.                                           
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_ACCT_BILLED = :AT-CODE-ACCT-BILLED            
               WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR UPDATING CSS_ACCOUNT'                         
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'UPDATE'               TO CWS299-ERROR-FUNCTION      
              MOVE '6565'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6565-CPD299-UPDATE-AT'                              
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_ACCOUNT'          TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE ND-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       6565-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * INSERT VOL_DAILY FOR PARTICULAR VOL_TYPE_CD.                   *        
      ******************************************************************        
       6570-CPD299-INSERT-ND.                                           
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_VOL_DAILY                                
                  (   ACCOUNT_NO                                        
                     ,BILL_NO                                           
                     ,CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,BILL_ITEM_TIMESTMP                                
                     ,VOL_TYPE_CD                                       
                     ,ENERGY_UNIT_CD                                    
                     ,DATE_READ                                         
                     ,NO_UNITS                                          
                     ,FIXED_FCTR_SEQ_NO                                 
                     ,CODE_TIME_PERIOD                                  
                  )                                                     
               VALUES                                                   
                  (   :ND-ACCOUNT-NO                                    
                     ,:ND-BILL-NO                                       
                     ,:ND-CODE-UTIL-TYPE                                
                     ,:ND-IC-NO                                         
                     ,CIS.CHAR2TIMESTAMP(:ND-BILL-ITEM-TIMESTMP)                
                     ,:ND-VOL-TYPE-CD                                   
                     ,:ND-ENERGY-UNIT-CD                                
                     ,IIF(TRY_CONVERT(DATE, :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )                                
                     ,:ND-NO-UNITS                                      
                     ,:ND-FIXED-FCTR-SEQ-NO                             
                     ,:ND-CODE-TIME-PERIOD                              
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_VOL_DAILY                                        
MFA-TR*           (   ACCOUNT_NO                                                
MFA-TR*              ,BILL_NO                                                   
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,BILL_ITEM_TIMESTMP                                        
MFA-TR*              ,VOL_TYPE_CD                                               
MFA-TR*              ,ENERGY_UNIT_CD                                            
MFA-TR*              ,DATE_READ                                                 
MFA-TR*              ,NO_UNITS                                                  
MFA-TR*              ,FIXED_FCTR_SEQ_NO                                         
MFA-TR*              ,CODE_TIME_PERIOD                                          
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (   :ND-ACCOUNT-NO                                            
MFA-TR*              ,:ND-BILL-NO                                               
MFA-TR*              ,:ND-CODE-UTIL-TYPE                                        
MFA-TR*              ,:ND-IC-NO                                                 
MFA-TR*              ,:ND-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:ND-VOL-TYPE-CD                                           
MFA-TR*              ,:ND-ENERGY-UNIT-CD                                        
MFA-TR*              ,:ND-DATE-READ                                             
MFA-TR*              ,:ND-NO-UNITS                                              
MFA-TR*              ,:ND-FIXED-FCTR-SEQ-NO                                     
MFA-TR*              ,:ND-CODE-TIME-PERIOD                                      
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              SET VOL-ALLOCATED TO TRUE                                 
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR INSERTING CSS_VOL_DAILY'                      
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'INSERT'               TO CWS299-ERROR-FUNCTION      
              MOVE '6570'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6570-CPD299-INSERT-ND'                              
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_VOL_DAILY'        TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
              MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
              MOVE 'BILL_NO'              TO CWS299-ERROR-TAB-COLUMN-4  
              MOVE ND-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
              MOVE ND-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
              MOVE ND-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
              MOVE ND-BILL-NO             TO CWS299-ERROR-HOSTVAR-4     
           END-IF.                                                      
      *                                                                         
       6570-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DELETE VOL_DAILY FOR PARTICULAR VOL_TYPE_CD.                   *        
      ******************************************************************        
       6580-CPD299-DELETE-ND.                                           
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM CSS_VOL_DAILY                                
                WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO               
                  AND BILL_NO            = :ND-BILL-NO                  
                  AND IC_NO              = :ND-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )       
                  AND VOL_TYPE_CD        = :ND-VOL-TYPE-CD              
                  AND CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE           
                  AND ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD           
                  AND CODE_TIME_PERIOD   = :ND-CODE-TIME-PERIOD         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_VOL_DAILY                                        
MFA-TR*         WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :ND-BILL-NO                          
MFA-TR*           AND IC_NO              = :ND-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP               
MFA-TR*           AND VOL_TYPE_CD        = :ND-VOL-TYPE-CD                      
MFA-TR*           AND CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE                   
MFA-TR*           AND ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD                   
MFA-TR*           AND CODE_TIME_PERIOD   = :ND-CODE-TIME-PERIOD                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR DELETING CSS_VOL_DAILY'                       
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'DELETE'               TO CWS299-ERROR-FUNCTION      
              MOVE '6580'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6580-CPD299-DELETE-ND'                              
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_VOL_DAILY'        TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
              MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
              MOVE 'BILL_NO'              TO CWS299-ERROR-TAB-COLUMN-4  
              MOVE ND-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
              MOVE ND-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
              MOVE ND-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
              MOVE ND-BILL-NO             TO CWS299-ERROR-HOSTVAR-4     
           END-IF.                                                      
      *                                                                         
       6580-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECK FOR SECURED RATE.                                        *        
      ******************************************************************        
       6590-CPD299-CHK-SECURED.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT SECURED_RATE_FL                                   
                 INTO :RD-SECURED-RATE-FL                               
                 FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                  
                WHERE RATE_PLAN_NO   = :RD-RATE-PLAN-NO                 
                  AND CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SECURED_RATE_FL                                           
MFA-TR*          INTO :RD-SECURED-RATE-FL                                       
MFA-TR*          FROM CSS_RATE_PLAN_DESC                                        
MFA-TR*         WHERE RATE_PLAN_NO   = :RD-RATE-PLAN-NO                         
MFA-TR*           AND CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                       
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR SELECTING CSS_RATE_PLAN_DESC'                 
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'SELECT'               TO CWS299-ERROR-FUNCTION      
              MOVE '6590'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6590-CPD299-CHK-SECURED'                            
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_RATE_PLAN_DESC'   TO CWS299-ERROR-TABLE1        
              MOVE 'RATE_PLAN'            TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
              MOVE RD-RATE-PLAN-NO        TO CWS299-ERROR-HOSTVAR-1     
              MOVE RD-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
           END-IF.                                                      
      *                                                                         
       6590-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * INSERT WQ.                                                     *        
      ******************************************************************        
       6600-CPD299-INSRT-WQ.                                            
      *                                                                         
      *                                                                         
ACT108     MOVE SPACES                       TO ABEND-FUNCTION.         
ACT108     MOVE ZERO                         TO RS-RETURN-CODE.         
ACT108     MOVE CWS299-IN-ACCT-NO            TO WS-77-ACCOUNT-NO.       
ACT108     MOVE PROGRAM-NAME                 TO WS-77-CREATED-BY.       
                                                                        
ACT108        CALL SCSCB077 USING CWS00077-FIELDS                       
ACT108                           ,ABEND-FILE                            
ACT108                           ,RS-RETURN-CODE                        
                                                                        
ACT108     MOVE RS-RETURN-CODE               TO WS-ACTIVE-RETURN-CODE   
                                                SQLCODE.                
ACT108                                                                  
ACT108     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR INSERTING CSS_WQ_ITEMS'                       
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'INSERT'               TO CWS299-ERROR-FUNCTION      
              MOVE '6600'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6600-CPD299-INSRT-WQ' TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_WQ_ITEMS   '      TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
ACT108        MOVE WS-77-ACCOUNT-NO       TO CWS299-ERROR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       6600-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET ACCOUNT DETAILS TO GENERATE WQ.                            *        
      ******************************************************************        
       6610-CPD299-GET-ACCT.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT COMPANY_NO                                        
                     ,PREMISE_NO                                        
                     ,CUSTOMER_NO                                       
                     ,LOCAL_OFFICE                                      
                 INTO :AT-COMPANY-NO                                    
                     ,:AT-PREMISE-NO                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-LOCAL-OFFICE                                  
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO                                                
MFA-TR*              ,PREMISE_NO                                                
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*          INTO :AT-COMPANY-NO                                            
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR SELECTING CSS_ACCOUNT'                        
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'SELECT'               TO CWS299-ERROR-FUNCTION      
              MOVE '6610'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6610-CPD299-GET-ACCT' TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_ACCOUNT'          TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE AT-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       6610-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * Find missing months.                                           *        
      ******************************************************************        
       6620-FIND-MISSING-MONTHS.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :CWS299-MISSING-MNTHS                             
                 FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
                     ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                  
                WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND BG.IC_NO              = :BG-IC-NO                 
                  AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO             
                  AND BI.BILL_NO            = BG.BILL_NO                
                  AND BG.CODE_BILL_CALC     = 'A'                       
                  AND BG.CODE_BILL_ITM_TYPE = 'C'                       
                  AND BG.CODE_BILL_ITM_IND  = 'A'                       
                  AND BG.REVENUE_MONTH      > 0                         
                  AND BG.REVENUE_MONTH      > :CWS299-IN-REVENUE-MONTH  
                  AND BI.DATE_BILLED        IS NOT NULL                 
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :CWS299-MISSING-MNTHS                                     
MFA-TR*          FROM CSS_BILLING_DET BG                                        
MFA-TR*              ,CSS_BILLING_HDR BI                                        
MFA-TR*         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND BG.IC_NO              = :BG-IC-NO                         
MFA-TR*           AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                     
MFA-TR*           AND BI.BILL_NO            = BG.BILL_NO                        
MFA-TR*           AND BG.CODE_BILL_CALC     = 'A'                               
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*           AND BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*           AND BG.REVENUE_MONTH      > 0                                 
MFA-TR*           AND BG.REVENUE_MONTH      > :CWS299-IN-REVENUE-MONTH          
MFA-TR*           AND BI.DATE_BILLED        IS NOT NULL                         
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR SELECTING CSS_BILLING_DET'                    
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'SELECT'               TO CWS299-ERROR-FUNCTION      
              MOVE '6620'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6620-FIND-MISSING-MONTHS'                           
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_BILLING_DET'      TO CWS299-ERROR-TABLE1        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
              MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
              MOVE 'REVENUE_MONTH'        TO CWS299-ERROR-TAB-COLUMN-4  
              MOVE BG-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
              MOVE BG-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
              MOVE BG-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
              MOVE CWS299-IN-REVENUE-MONTH TO CWS299-ERROR-HOSTVAR-4    
           END-IF.                                                      
      *                                                                         
       6620-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET DIFFERENCE BETWEEN 2 REVENUE MONTHS.                       *        
      ******************************************************************        
       6650-CPD299-GET-MTH-DIFF.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CIS.DECIMAL2MONTH(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                    :CWS299-DATE-CALC-A
              ) IS NULL OR (PATINDEX('%.%', :CWS299-DATE-CALC-A
              ) <> 0) OR (LEN(:CWS299-DATE-CALC-A
              ) <> 10), CIS.CHAR2DATE(:CWS299-DATE-CALC-A
              ), CONVERT(DATE, :CWS299-DATE-CALC-A) ), 
              IIF(TRY_CONVERT(DATE, :CWS299-DATE-CALC-B
              ) IS NULL OR (PATINDEX('%.%', :CWS299-DATE-CALC-B
              ) <> 0) OR (LEN(:CWS299-DATE-CALC-B
              ) <> 10), CIS.CHAR2DATE(:CWS299-DATE-CALC-B
              ), CONVERT(DATE, :CWS299-DATE-CALC-B) ) ))
            INTO
              :CWS299-RESULT-MNTHS                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :CWS299-RESULT-MNTHS =                                        
MFA-TR*            MONTH(DATE(:CWS299-DATE-CALC-A) -                            
MFA-TR*                  DATE(:CWS299-DATE-CALC-B))                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'SET'                  TO CWS299-ERROR-FUNCTION      
              MOVE '6650'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6650-CPD299-GET-MTH-DIFF'                           
                                          TO CWS299-ERROR-PARAGRAPH-NAME
           END-IF.                                                      
      *                                                                         
       6650-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPEN NET METERING RATE CURSOR.                                 *        
      ******************************************************************        
       6670-CPD299-OPEN-NM-RATE.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN NET_MTR_RATE                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR OPENING CURSOR' TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'OPEN'                 TO CWS299-ERROR-FUNCTION      
              MOVE '6670'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6670-CPD299-OPEN-NM-RATE'                           
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_RATE_CREATOR'     TO CWS299-ERROR-TABLE1        
              MOVE 'CSS_RATE_COMP_DEF'    TO CWS299-ERROR-TABLE2        
           END-IF.                                                      
      *                                                                         
       6670-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCH NET METERING RATE CURSOR.                                *        
      ******************************************************************        
       6680-CPD299-FETCH-NM-RATE.                                       
      *                                                                         
           EXEC SQL                                                     
               FETCH NET_MTR_RATE                                       
                INTO :J1-RATE-PLAN-NO                                   
                    ,:J1-CMPNT-ID-CD                                    
                    ,:J1-CODE-UTIL-TYPE                                 
                    ,:J1-REG-TYPE-CD                                    
                    ,:J1-BAL-RESET-MMDD                                 
                    ,:J1-BAL-OFFSET-TOU-CD                              
                    ,:J1-ENERGY-UNIT-CD                                 
ID1959              ,:J1-BAL-FWD-CD                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR FETCHING CURSOR'                              
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'FETCH'                TO CWS299-ERROR-FUNCTION      
              MOVE '6680'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6680-CPD299-FETCH-NM-RATE'                          
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_RATE_CREATOR'     TO CWS299-ERROR-TABLE1        
              MOVE 'CSS_RATE_COMP_DEF'    TO CWS299-ERROR-TABLE2        
           END-IF.                                                      
      *                                                                         
       6680-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSE NET METERING RATE CURSOR.                                *        
      ******************************************************************        
       6690-CPD299-CLOSE-NM-RATE.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE NET_MTR_RATE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR CLOSING CURSOR' TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'CLOSE'                TO CWS299-ERROR-FUNCTION      
              MOVE '6690'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6690-CPD299-CLOSE-NM-RATE'                          
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_RATE_CREATOR'     TO CWS299-ERROR-TABLE1        
              MOVE 'CSS_RATE_COMP_DEF'    TO CWS299-ERROR-TABLE2        
           END-IF.                                                      
      *                                                                         
       6690-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPEN BILLING_DET CURSOR.                                       *        
      ******************************************************************        
       6700-CPD299-OPEN-BG-CURS.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN BILLING_DET                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR OPENING CURSOR' TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'OPEN'                 TO CWS299-ERROR-FUNCTION      
              MOVE '6700'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6700-CPD299-OPEN-BG-CURS'                           
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_BILLING_HDR'      TO CWS299-ERROR-TABLE1        
              MOVE 'CSS_BILLING_DET'      TO CWS299-ERROR-TABLE2        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE BI-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       6700-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCH BILLING_DET CURSOR.                                      *        
      ******************************************************************        
       6710-CPD299-FETCH-BG.                                            
      *                                                                         
           EXEC SQL                                                     
               FETCH BILLING_DET                                        
                INTO :BG-ACCOUNT-NO                                     
                    ,:BG-BILL-NO                                        
                    ,:BG-CODE-UTIL-TYPE                                 
                    ,:BG-IC-NO                                          
                    ,:BG-BILL-ITEM-TIMESTMP                             
                    ,:BG-RATE-PLAN-NO                                   
                    ,:BG-REV-MTH-ORIG-BILL                              
                    ,:BG-REVENUE-MONTH                                  
ID1959              ,:BG-CODE-REVENUE-CLASS                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              IF SQLCODE = NOT-FOUND                                    
                 SET CWS299-NO-MORE-BG-ROWS TO TRUE                     
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR FETCHING CURSOR'                              
                                          TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'FETCH'                TO CWS299-ERROR-FUNCTION      
              MOVE '6710'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6710-CPD299-FETCH-BG'                               
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_BILLING_HDR'      TO CWS299-ERROR-TABLE1        
              MOVE 'CSS_BILLING_DET'      TO CWS299-ERROR-TABLE2        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE BI-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       6710-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSE BILLING_DET CURSOR.                                      *        
      ******************************************************************        
       6720-CPD299-CLOSE-BG.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE BILLING_DET                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              CONTINUE                                                  
           ELSE                                                         
              SET CWS299-DB2-ERROR        TO TRUE                       
              MOVE 'ERROR CLOSING CURSOR' TO CWS299-ERROR-MESSAGE       
              MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
              MOVE 'CLOSE'                TO CWS299-ERROR-FUNCTION      
              MOVE '6720'                 TO CWS299-ERROR-PARAGRAPH-NO  
              MOVE '6720-CPD299-CLOSE-BG'                               
                                          TO CWS299-ERROR-PARAGRAPH-NAME
              MOVE 'CSS_BILLING_HDR'      TO CWS299-ERROR-TABLE1        
              MOVE 'CSS_BILLING_DET'      TO CWS299-ERROR-TABLE2        
              MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
              MOVE BI-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
           END-IF.                                                      
      *                                                                         
       6720-CPD299-EXIT.                                                
           EXIT.                                                        
      *                                                                         
ID1959******************************************************************        
ID1959** GET SPCL FCTR DATA                                           **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6725-CPD299-GET-SPCL-FCTR.                                       
ID1959*                                                                         
ID1959     EXEC SQL                                                     
ID1959         SELECT TOP(1) SK.CMPNT_ID_CD,
              SF.FCTR_POWER_10,
              SF.FCTR_DECIMAL_PLACE,
              SF.CODE_DR_CR,
              SF.OVR_RT_VER_PRO_FL,
              SF.CODE_TAX_STAT_XMT,
              SF.CODE_TAX_CITY_XMT,
              SF.CODE_TAX_OTHR_XMT                             
ID1959           INTO :CWS299-CR-FCTR-CMPNT-ID                          
ID1959               ,:CWS299-CR-FCTR-POWER-10                          
ID1959               ,:CWS299-CR-FCTR-DECIMAL                           
ID1959               ,:CWS299-CR-FCTR-DR-CR                             
ID1959               ,:CWS299-CR-FCTR-PRO-FL                            
ID1959               ,:CWS299-CR-FCTR-STAT-XMT                          
ID1959               ,:CWS299-CR-FCTR-CITY-XMT                          
ID1959               ,:CWS299-CR-FCTR-OTHR-XMT                          
ID1959           FROM  CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)             
ID1959                ,CSS_SPCL_FCT_CMPNT  SK WITH(READUNCOMMITTED)             
ID1959          WHERE  SF.FACTOR_ID  =  :SF-FACTOR-ID                   
ID1959            AND  SF.FACTOR_ID  =   SK.FACTOR_ID                   
ID1959            AND  SK.STATUS_CD  =  'A'                             
ID1959         ORDER BY SK.CMPNT_ID_CD                                  
ID1959                                       
ID1959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SK.CMPNT_ID_CD                                           
MFA-TR*               ,SF.FCTR_POWER_10                                         
MFA-TR*               ,SF.FCTR_DECIMAL_PLACE                                    
MFA-TR*               ,SF.CODE_DR_CR                                            
MFA-TR*               ,SF.OVR_RT_VER_PRO_FL                                     
MFA-TR*               ,SF.CODE_TAX_STAT_XMT                                     
MFA-TR*               ,SF.CODE_TAX_CITY_XMT                                     
MFA-TR*               ,SF.CODE_TAX_OTHR_XMT                                     
MFA-TR*          INTO :CWS299-CR-FCTR-CMPNT-ID                                  
MFA-TR*              ,:CWS299-CR-FCTR-POWER-10                                  
MFA-TR*              ,:CWS299-CR-FCTR-DECIMAL                                   
MFA-TR*              ,:CWS299-CR-FCTR-DR-CR                                     
MFA-TR*              ,:CWS299-CR-FCTR-PRO-FL                                    
MFA-TR*              ,:CWS299-CR-FCTR-STAT-XMT                                  
MFA-TR*              ,:CWS299-CR-FCTR-CITY-XMT                                  
MFA-TR*              ,:CWS299-CR-FCTR-OTHR-XMT                                  
MFA-TR*          FROM  CSS_SPCL_FCTR       SF                                   
MFA-TR*               ,CSS_SPCL_FCT_CMPNT  SK                                   
MFA-TR*         WHERE  SF.FACTOR_ID  =  :SF-FACTOR-ID                           
MFA-TR*           AND  SF.FACTOR_ID  =   SK.FACTOR_ID                           
MFA-TR*           AND  SK.STATUS_CD  =  'A'                                     
MFA-TR*        ORDER BY SK.CMPNT_ID_CD                                          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID1959*                                                                         
ID1959     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
ID1959        CONTINUE                                                  
ID1959     ELSE                                                         
ID1959        SET CWS299-DB2-ERROR        TO TRUE                       
ID1959        MOVE 'ERROR SELECTING CSS_SPCL_FCTR'                      
ID1959                                    TO CWS299-ERROR-MESSAGE       
ID1959        MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
ID1959        MOVE 'SELECT'               TO CWS299-ERROR-FUNCTION      
ID1959        MOVE '6725'                 TO CWS299-ERROR-PARAGRAPH-NO  
ID1959        MOVE '6725-CPD299-GET-SPCL' TO CWS299-ERROR-PARAGRAPH-NAME
ID1959        MOVE 'CSS_SPCL_FCTR'        TO CWS299-ERROR-TABLE1        
ID1959        MOVE 'FACTOR_ID'            TO CWS299-ERROR-TAB-COLUMN-1  
ID1959        MOVE SF-FACTOR-ID           TO CWS299-ERROR-HOSTVAR-1     
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6725-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
ID1959******************************************************************        
ID1959** GET PR1 PRICE FOR INPUT DATE BASED ON REVENUE MONTH,         **        
ID1959** SEASON=NON-SUMMER & TIME PERIOD=OFF-PEAK                     **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6750-CPD299-GET-PR1-PRICE.                                       
ID1959*                                                                         
ID1959     EXEC SQL                                                     
ID1959         SELECT TOP(1) SA.FACTOR                                        
ID1959           INTO  :SA-FACTOR                                       
ID1959           FROM  CSS_SPCL_FCTR_APPL  SA WITH(READUNCOMMITTED)             
ID1959                ,CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)             
ID1959          WHERE  SA.FACTOR_ID         =  SF.FACTOR_ID             
ID1959            AND  SA.CODE_UTIL_TYPE    = :SA-CODE-UTIL-TYPE        
ID1959            AND  SA.RATE_PLAN_NO      = 'PR1'                     
ID1959            AND  SA.FACTOR_ID         = 'PR1PRICE'                
ID1959            AND  SA.DATE_FROM        <= IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )             
ID1959            AND  SA.DATE_TO          >= IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )             
ID1959            AND  SA.CODE_SEASON       = 'N'                       
ID1959            AND  SA.CODE_TIME_PERIOD  =  2                        
ID1959            AND  SA.CODE_STATUS      IN ('A','E')                 
ID1959************AND  SA.VERS_PRORATE_CD   = 'R'                               
ID1959         ORDER BY SA.DATE_FROM DESC                               
ID1959                                       
ID1959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SA.FACTOR                                                
MFA-TR*          INTO  :SA-FACTOR                                               
MFA-TR*          FROM  CSS_SPCL_FCTR_APPL  SA                                   
MFA-TR*               ,CSS_SPCL_FCTR       SF                                   
MFA-TR*         WHERE  SA.FACTOR_ID         =  SF.FACTOR_ID                     
MFA-TR*           AND  SA.CODE_UTIL_TYPE    = :SA-CODE-UTIL-TYPE                
MFA-TR*           AND  SA.RATE_PLAN_NO      = 'PR1'                             
MFA-TR*           AND  SA.FACTOR_ID         = 'PR1PRICE'                        
MFA-TR*           AND  SA.DATE_FROM        <= :SA-DATE-FROM                     
MFA-TR*           AND  SA.DATE_TO          >= :SA-DATE-FROM                     
MFA-TR*           AND  SA.CODE_SEASON       = 'N'                               
MFA-TR*           AND  SA.CODE_TIME_PERIOD  =  2                                
MFA-TR*           AND  SA.CODE_STATUS      IN ('A','E')                         
MFA-TR************AND  SA.VERS_PRORATE_CD   = 'R'                               
MFA-TR*        ORDER BY SA.DATE_FROM DESC                                       
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID1959*                                                                         
ID1959     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
ID1959        CONTINUE                                                  
ID1959     ELSE                                                         
ID1959        SET CWS299-DB2-ERROR        TO TRUE                       
ID1959        MOVE 'ERROR SELECTING CSS_SPCL_FCTR_APPL'                 
ID1959                                    TO CWS299-ERROR-MESSAGE       
ID1959        MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
ID1959        MOVE 'SELECT'               TO CWS299-ERROR-FUNCTION      
ID1959        MOVE '6750'                 TO CWS299-ERROR-PARAGRAPH-NO  
ID1959        MOVE '6750-CPD299-GET-PR1'  TO CWS299-ERROR-PARAGRAPH-NAME
ID1959        MOVE 'CSS_SPCL_FCTR_APPL'   TO CWS299-ERROR-TABLE1        
ID1959        MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-1  
ID1959        MOVE 'DATE_FROM'            TO CWS299-ERROR-TAB-COLUMN-2  
ID1959        MOVE SA-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-1     
ID1959        MOVE SA-DATE-FROM           TO CWS299-ERROR-HOSTVAR-2     
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6750-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
ID1959******************************************************************        
ID1959** SELECT FIXED FACTOR DATA                                     **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6760-CPD299-GET-FACTOR-DATA.                                     
ID1959*                                                                         
ID1959     EXEC SQL                                                     
ID1959         SELECT TOP(1) FF.FIXED_FCTR_SEQ_NO                             
ID1959           INTO :FF-FIXED-FCTR-SEQ-NO                             
ID1959           FROM  CSS_FIXED_FCTR    FF WITH(READUNCOMMITTED)               
ID1959          WHERE  FF.ACCOUNT_NO        = :FF-ACCOUNT-NO            
ID1959            AND  FF.CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE        
ID1959            AND  FF.IC_NO             = :FF-IC-NO                 
ID1959            AND  FF.FACTOR_ID         = :FF-FACTOR-ID             
ID1959            AND  FF.EFF_DATE_FROM     = IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )         
ID1959            AND  FF.EFF_DATE_TO      >= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )         
ID1959         ORDER BY FF.EFF_DATE_TO DESC                             
ID1959                                       
ID1959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  FF.FIXED_FCTR_SEQ_NO                                     
MFA-TR*          INTO :FF-FIXED-FCTR-SEQ-NO                                     
MFA-TR*          FROM  CSS_FIXED_FCTR    FF                                     
MFA-TR*         WHERE  FF.ACCOUNT_NO        = :FF-ACCOUNT-NO                    
MFA-TR*           AND  FF.CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE                
MFA-TR*           AND  FF.IC_NO             = :FF-IC-NO                         
MFA-TR*           AND  FF.FACTOR_ID         = :FF-FACTOR-ID                     
MFA-TR*           AND  FF.EFF_DATE_FROM     = :FF-EFF-DATE-FROM                 
MFA-TR*           AND  FF.EFF_DATE_TO      >= :FF-EFF-DATE-FROM                 
MFA-TR*        ORDER BY FF.EFF_DATE_TO DESC                                     
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID1959*                                                                         
ID1959     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
ID1959        CONTINUE                                                  
ID1959     ELSE                                                         
ID1959        SET CWS299-DB2-ERROR        TO TRUE                       
ID1959        MOVE 'ERROR SELECTING CSS_FIXED_FCTR'                     
ID1959                                    TO CWS299-ERROR-MESSAGE       
ID1959        MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
ID1959        MOVE 'SELECT'               TO CWS299-ERROR-FUNCTION      
ID1959        MOVE '6760'                 TO CWS299-ERROR-PARAGRAPH-NO  
ID1959        MOVE '6760-CPD299-GET-FACT' TO CWS299-ERROR-PARAGRAPH-NAME
ID1959        MOVE 'CSS_FIXED_FCTR'       TO CWS299-ERROR-TABLE1        
ID1959        MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
ID1959        MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
ID1959        MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
ID1959        MOVE 'EFF_DATE_FROM'        TO CWS299-ERROR-TAB-COLUMN-4  
ID1959        MOVE FF-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
ID1959        MOVE FF-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
ID1959        MOVE FF-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
ID1959        MOVE FF-EFF-DATE-FROM       TO CWS299-ERROR-HOSTVAR-4     
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6760-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
ID1959******************************************************************        
ID1959** UPDATE CSS_FIXED_FCTR                                        **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6775-CPD299-UPDATE-FIXED-FCTR.                                   
ID1959*                                                                         
ID1959     EXEC SQL                                                     
ID1959         UPDATE  CSS_FIXED_FCTR                                   
ID1959            SET  FACTOR            = :FF-FACTOR                   
ID1959                ,FAC_CHRG_BASE_AM  = :FF-FAC-CHRG-BASE-AM         
ID1959                ,LAST_UPDATE_TS    =  CIS.CURRENT$TIMESTAMP()           
ID1959          WHERE  ACCOUNT_NO        = :FF-ACCOUNT-NO               
ID1959            AND  CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE           
ID1959            AND  IC_NO             = :FF-IC-NO                    
ID1959            AND  FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO        
ID1959            AND  FACTOR_ID         = :FF-FACTOR-ID                
ID1959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE  CSS_FIXED_FCTR                                           
MFA-TR*           SET  FACTOR            = :FF-FACTOR                           
MFA-TR*               ,FAC_CHRG_BASE_AM  = :FF-FAC-CHRG-BASE-AM                 
MFA-TR*               ,LAST_UPDATE_TS    =  CURRENT TIMESTAMP                   
MFA-TR*         WHERE  ACCOUNT_NO        = :FF-ACCOUNT-NO                       
MFA-TR*           AND  CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE                   
MFA-TR*           AND  IC_NO             = :FF-IC-NO                            
MFA-TR*           AND  FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO                
MFA-TR*           AND  FACTOR_ID         = :FF-FACTOR-ID                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID1959*                                                                         
ID1959     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
ID1959        CONTINUE                                                  
ID1959     ELSE                                                         
ID1959        SET CWS299-DB2-ERROR        TO TRUE                       
ID1959        MOVE 'ERROR UPDATING CSS_FIXED_FCTR'                      
ID1959                                    TO CWS299-ERROR-MESSAGE       
ID1959        MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
ID1959        MOVE 'UPDATE'               TO CWS299-ERROR-FUNCTION      
ID1959        MOVE '6775'                 TO CWS299-ERROR-PARAGRAPH-NO  
ID1959        MOVE '6775-CPD299-UPDATE'   TO CWS299-ERROR-PARAGRAPH-NAME
ID1959        MOVE 'CSS_FIXED_FCTR'       TO CWS299-ERROR-TABLE1        
ID1959        MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
ID1959        MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
ID1959        MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
ID1959        MOVE 'FIXED_FCTR_SEQ_NO'    TO CWS299-ERROR-TAB-COLUMN-4  
ID1959        MOVE FF-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
ID1959        MOVE FF-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
ID1959        MOVE FF-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
ID1959        MOVE FF-FIXED-FCTR-SEQ-NO   TO CWS299-ERROR-HOSTVAR-4     
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6775-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
ID1959******************************************************************        
ID1959** SELECT MAX FCTR SEQ + 1                                      **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6790-CPD299-GET-FIXED-FCTR-SEQ.                                  
ID1959*                                                                         
ID1959     EXEC SQL                                                     
ID1959         SELECT  COALESCE(MAX(FF.FIXED_FCTR_SEQ_NO) + 1,1)          
ID1959           INTO :FF-FIXED-FCTR-SEQ-NO                             
ID1959           FROM  CSS_FIXED_FCTR    FF WITH(READUNCOMMITTED)               
ID1959          WHERE  FF.ACCOUNT_NO        = :FF-ACCOUNT-NO            
ID1959            AND  FF.CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE        
ID1959            AND  FF.IC_NO             = :FF-IC-NO                 
ID1959                                                           
ID1959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  IFNULL(MAX(FF.FIXED_FCTR_SEQ_NO) + 1,1)                  
MFA-TR*          INTO :FF-FIXED-FCTR-SEQ-NO                                     
MFA-TR*          FROM  CSS_FIXED_FCTR    FF                                     
MFA-TR*         WHERE  FF.ACCOUNT_NO        = :FF-ACCOUNT-NO                    
MFA-TR*           AND  FF.CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE                
MFA-TR*           AND  FF.IC_NO             = :FF-IC-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID1959*                                                                         
ID1959     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
ID1959        CONTINUE                                                  
ID1959     ELSE                                                         
ID1959        SET CWS299-DB2-ERROR        TO TRUE                       
ID1959        MOVE 'ERROR SELECTING CSS_FIXED_FCTR'                     
ID1959                                    TO CWS299-ERROR-MESSAGE       
ID1959        MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
ID1959        MOVE 'SELECT'               TO CWS299-ERROR-FUNCTION      
ID1959        MOVE '6790'                 TO CWS299-ERROR-PARAGRAPH-NO  
ID1959        MOVE '6790-CPD299-GET-FIX'  TO CWS299-ERROR-PARAGRAPH-NAME
ID1959        MOVE 'CSS_FIXED_FCTR'       TO CWS299-ERROR-TABLE1        
ID1959        MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
ID1959        MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
ID1959        MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
ID1959        MOVE FF-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
ID1959        MOVE FF-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
ID1959        MOVE FF-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6790-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
ID1959******************************************************************        
ID1959** INSERT DATA INTO CSS_FIXED_FCTR                              **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6800-CPD299-INSERT-FIXED-FCTR.                                   
ID1959*                                                                         
ID1959     EXEC SQL                                                     
ID1959         INSERT INTO CSS_FIXED_FCTR                               
ID1959            (   ACCOUNT_NO                                        
ID1959               ,CODE_UTIL_TYPE                                    
ID1959               ,IC_NO                                             
ID1959               ,FIXED_FCTR_SEQ_NO                                 
ID1959               ,FACTOR_ID                                         
ID1959               ,EFF_DATE_FROM                                     
ID1959               ,CMPNT_ID_CD                                       
ID1959               ,CODE_SEASON                                       
ID1959               ,INSTR_USE_TYPE_CD                                 
ID1959               ,CODE_TIME_PERIOD                                  
ID1959               ,EFF_DATE_TO                                       
ID1959               ,FIXED_FCTR_TYP_CD                                 
ID1959               ,FACTOR                                            
ID1959               ,FAC_CHRG_BASE_AM                                  
ID1959               ,LAST_UPDATE_TS                                    
ID1959               ,DURATION_REMAIN_NO                                
ID1959               ,RT_PKG_OPT_SEQ_NO                                 
ID1959               ,BLOCK_NO                                          
ID1959            )                                                     
ID1959         VALUES                                                   
ID1959            (                                                     
ID1959                :FF-ACCOUNT-NO                                    
ID1959               ,:FF-CODE-UTIL-TYPE                                
ID1959               ,:FF-IC-NO                                         
ID1959               ,:FF-FIXED-FCTR-SEQ-NO                             
ID1959               ,:FF-FACTOR-ID                                     
ID1959               ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )                            
ID1959               ,:FF-CMPNT-ID-CD                                   
ID1959               ,:FF-CODE-SEASON                                   
ID1959               ,:FF-INSTR-USE-TYPE-CD                             
ID1959               ,:FF-CODE-TIME-PERIOD                              
ID1959               ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                              
ID1959               ,:FF-FIXED-FCTR-TYP-CD                             
ID1959               ,:FF-FACTOR                                        
ID1959               ,:FF-FAC-CHRG-BASE-AM                              
ID1959               ,CIS.CURRENT$TIMESTAMP()                                 
ID1959               ,NULL                                              
ID1959               ,0                                                 
ID1959               ,0                                                 
ID1959            )                                                     
ID1959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIXED_FCTR                                       
MFA-TR*           (   ACCOUNT_NO                                                
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,FIXED_FCTR_SEQ_NO                                         
MFA-TR*              ,FACTOR_ID                                                 
MFA-TR*              ,EFF_DATE_FROM                                             
MFA-TR*              ,CMPNT_ID_CD                                               
MFA-TR*              ,CODE_SEASON                                               
MFA-TR*              ,INSTR_USE_TYPE_CD                                         
MFA-TR*              ,CODE_TIME_PERIOD                                          
MFA-TR*              ,EFF_DATE_TO                                               
MFA-TR*              ,FIXED_FCTR_TYP_CD                                         
MFA-TR*              ,FACTOR                                                    
MFA-TR*              ,FAC_CHRG_BASE_AM                                          
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,DURATION_REMAIN_NO                                        
MFA-TR*              ,RT_PKG_OPT_SEQ_NO                                         
MFA-TR*              ,BLOCK_NO                                                  
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*               :FF-ACCOUNT-NO                                            
MFA-TR*              ,:FF-CODE-UTIL-TYPE                                        
MFA-TR*              ,:FF-IC-NO                                                 
MFA-TR*              ,:FF-FIXED-FCTR-SEQ-NO                                     
MFA-TR*              ,:FF-FACTOR-ID                                             
MFA-TR*              ,:FF-EFF-DATE-FROM                                         
MFA-TR*              ,:FF-CMPNT-ID-CD                                           
MFA-TR*              ,:FF-CODE-SEASON                                           
MFA-TR*              ,:FF-INSTR-USE-TYPE-CD                                     
MFA-TR*              ,:FF-CODE-TIME-PERIOD                                      
MFA-TR*              ,:FF-EFF-DATE-TO                                           
MFA-TR*              ,:FF-FIXED-FCTR-TYP-CD                                     
MFA-TR*              ,:FF-FACTOR                                                
MFA-TR*              ,:FF-FAC-CHRG-BASE-AM                                      
MFA-TR*              ,CURRENT TIMESTAMP                                         
MFA-TR*              ,NULL                                                      
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID1959*                                                                         
ID1959     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
ID1959        CONTINUE                                                  
ID1959     ELSE                                                         
ID1959        SET CWS299-DB2-ERROR        TO TRUE                       
ID1959        MOVE 'ERROR INSERTING CSS_FIXED_FCTR'                     
ID1959                                    TO CWS299-ERROR-MESSAGE       
ID1959        MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
ID1959        MOVE 'INSERT'               TO CWS299-ERROR-FUNCTION      
ID1959        MOVE '6800'                 TO CWS299-ERROR-PARAGRAPH-NO  
ID1959        MOVE '6800-CPD299-INSERT'   TO CWS299-ERROR-PARAGRAPH-NAME
ID1959        MOVE 'CSS_FIXED_FCTR'       TO CWS299-ERROR-TABLE1        
ID1959        MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
ID1959        MOVE 'CODE_UTIL_TYPE'       TO CWS299-ERROR-TAB-COLUMN-2  
ID1959        MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
ID1959        MOVE 'FIXED_FCTR_SEQ_NO'    TO CWS299-ERROR-TAB-COLUMN-4  
ID1959        MOVE FF-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
ID1959        MOVE FF-CODE-UTIL-TYPE      TO CWS299-ERROR-HOSTVAR-2     
ID1959        MOVE FF-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
ID1959        MOVE FF-FIXED-FCTR-SEQ-NO   TO CWS299-ERROR-HOSTVAR-4     
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6800-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
ID1959******************************************************************        
ID1959** SELECT FIXED FACTOR HISTORY DATA                             **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6810-CPD299-GET-FCTR-HIST-DATA.                                  
ID1959*                                                                         
ID1959     EXEC SQL                                                     
ID1959         SELECT TOP(1) FH.FIXED_FCTR_SEQ_NO                             
ID1959           INTO :FH-FIXED-FCTR-SEQ-NO                             
ID1959           FROM  CSS_FIXED_FCT_HIST   FH WITH(READUNCOMMITTED)            
ID1959          WHERE  FH.ACCOUNT_NO         = :FH-ACCOUNT-NO           
ID1959            AND  FH.BILL_NO            = :FH-BILL-NO              
ID1959            AND  FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE       
ID1959            AND  FH.IC_NO              = :FH-IC-NO                
ID1959            AND  FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )   
ID1959            AND  FH.FACTOR_ID          = :FH-FACTOR-ID            
ID1959            AND  FH.EFF_DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                      :FH-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FH-EFF-DATE-FROM
              ), CONVERT(DATE, :FH-EFF-DATE-FROM) )        
ID1959            AND  FH.EFF_DATE_TO       >= IIF(TRY_CONVERT(DATE, 
                                                      :FH-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FH-EFF-DATE-FROM
              ), CONVERT(DATE, :FH-EFF-DATE-FROM) )        
ID1959         ORDER BY FH.EFF_DATE_TO DESC                             
ID1959                                       
ID1959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  FH.FIXED_FCTR_SEQ_NO                                     
MFA-TR*          INTO :FH-FIXED-FCTR-SEQ-NO                                     
MFA-TR*          FROM  CSS_FIXED_FCT_HIST   FH                                  
MFA-TR*         WHERE  FH.ACCOUNT_NO         = :FH-ACCOUNT-NO                   
MFA-TR*           AND  FH.BILL_NO            = :FH-BILL-NO                      
MFA-TR*           AND  FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE               
MFA-TR*           AND  FH.IC_NO              = :FH-IC-NO                        
MFA-TR*           AND  FH.BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP           
MFA-TR*           AND  FH.FACTOR_ID          = :FH-FACTOR-ID                    
MFA-TR*           AND  FH.EFF_DATE_FROM      = :FH-EFF-DATE-FROM                
MFA-TR*           AND  FH.EFF_DATE_TO       >= :FH-EFF-DATE-FROM                
MFA-TR*        ORDER BY FH.EFF_DATE_TO DESC                                     
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID1959*                                                                         
ID1959     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
ID1959        CONTINUE                                                  
ID1959     ELSE                                                         
ID1959        SET CWS299-DB2-ERROR        TO TRUE                       
ID1959        MOVE 'ERROR SELECTING CSS_FIXED_FCT_HIST'                 
ID1959                                    TO CWS299-ERROR-MESSAGE       
ID1959        MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
ID1959        MOVE 'SELECT'               TO CWS299-ERROR-FUNCTION      
ID1959        MOVE '6810'                 TO CWS299-ERROR-PARAGRAPH-NO  
ID1959        MOVE '6810-CPD299-GET-FCTR' TO CWS299-ERROR-PARAGRAPH-NAME
ID1959        MOVE 'CSS_FIXED_FCT_HIST'   TO CWS299-ERROR-TABLE1        
ID1959        MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
ID1959        MOVE 'BILL_NO'              TO CWS299-ERROR-TAB-COLUMN-2  
ID1959        MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
ID1959        MOVE 'BILL_ITEM_TIMESTMP'   TO CWS299-ERROR-TAB-COLUMN-4  
ID1959        MOVE FH-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
ID1959        MOVE FH-BILL-NO             TO CWS299-ERROR-HOSTVAR-2     
ID1959        MOVE FH-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
ID1959        MOVE FH-BILL-ITEM-TIMESTMP  TO CWS299-ERROR-HOSTVAR-4     
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6810-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
ID1959******************************************************************        
ID1959** UPDATE FIXED FACTOR HISTORY DATA                             **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6825-CPD299-UPDATE-FCTR-HIST.                                    
ID1959*                                                                         
ID1959     EXEC SQL                                                     
ID1959         UPDATE  CSS_FIXED_FCT_HIST                               
ID1959            SET  FACTOR          = :FH-FACTOR                     
ID1959                ,BILL_UNITS      = :FH-BILL-UNITS                 
ID1959                ,LAST_UPDATE_TS  =  CIS.CURRENT$TIMESTAMP()             
ID1959          WHERE  ACCOUNT_NO         = :FH-ACCOUNT-NO              
ID1959            AND  BILL_NO            = :FH-BILL-NO                 
ID1959            AND  CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE          
ID1959            AND  IC_NO              = :FH-IC-NO                   
ID1959            AND  BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )      
ID1959            AND  FIXED_FCTR_SEQ_NO  = :FH-FIXED-FCTR-SEQ-NO       
ID1959            AND  FACTOR_ID          = :FH-FACTOR-ID               
ID1959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE  CSS_FIXED_FCT_HIST                                       
MFA-TR*           SET  FACTOR          = :FH-FACTOR                             
MFA-TR*               ,BILL_UNITS      = :FH-BILL-UNITS                         
MFA-TR*               ,LAST_UPDATE_TS  =  CURRENT TIMESTAMP                     
MFA-TR*         WHERE  ACCOUNT_NO         = :FH-ACCOUNT-NO                      
MFA-TR*           AND  BILL_NO            = :FH-BILL-NO                         
MFA-TR*           AND  CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE                  
MFA-TR*           AND  IC_NO              = :FH-IC-NO                           
MFA-TR*           AND  BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP              
MFA-TR*           AND  FIXED_FCTR_SEQ_NO  = :FH-FIXED-FCTR-SEQ-NO               
MFA-TR*           AND  FACTOR_ID          = :FH-FACTOR-ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID1959*                                                                         
ID1959     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
ID1959        CONTINUE                                                  
ID1959     ELSE                                                         
ID1959        SET CWS299-DB2-ERROR        TO TRUE                       
ID1959        MOVE 'ERROR UPDATING CSS_FIXED_FCT_HIST'                  
ID1959                                    TO CWS299-ERROR-MESSAGE       
ID1959        MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
ID1959        MOVE 'UPDATE'               TO CWS299-ERROR-FUNCTION      
ID1959        MOVE '6825'                 TO CWS299-ERROR-PARAGRAPH-NO  
ID1959        MOVE '6825-CPD299-UPDATE'   TO CWS299-ERROR-PARAGRAPH-NAME
ID1959        MOVE 'CSS_FIXED_FCT_HIST'   TO CWS299-ERROR-TABLE1        
ID1959        MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
ID1959        MOVE 'BILL_NO'              TO CWS299-ERROR-TAB-COLUMN-2  
ID1959        MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
ID1959        MOVE 'BILL_ITEM_TIMESTMP'   TO CWS299-ERROR-TAB-COLUMN-4  
ID1959        MOVE FH-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
ID1959        MOVE FH-BILL-NO             TO CWS299-ERROR-HOSTVAR-2     
ID1959        MOVE FH-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
ID1959        MOVE FH-BILL-ITEM-TIMESTMP  TO CWS299-ERROR-HOSTVAR-4     
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6825-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
ID1959******************************************************************        
ID1959** SELECT MAX FCTR SEQ + 1                                      **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6840-CPD299-GET-FCTR-HIST-SEQ.                                   
ID1959*                                                                         
ID1959     EXEC SQL                                                     
ID1959         SELECT  COALESCE(MAX(FH.FIXED_FCTR_SEQ_NO) + 1,1)          
ID1959           INTO :FH-FIXED-FCTR-SEQ-NO                             
ID1959           FROM  CSS_FIXED_FCT_HIST   FH WITH(READUNCOMMITTED)            
ID1959          WHERE  FH.ACCOUNT_NO         = :FH-ACCOUNT-NO           
ID1959            AND  FH.BILL_NO            = :FH-BILL-NO              
ID1959            AND  FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE       
ID1959            AND  FH.IC_NO              = :FH-IC-NO                
ID1959            AND  FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )   
ID1959                                                           
ID1959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  IFNULL(MAX(FH.FIXED_FCTR_SEQ_NO) + 1,1)                  
MFA-TR*          INTO :FH-FIXED-FCTR-SEQ-NO                                     
MFA-TR*          FROM  CSS_FIXED_FCT_HIST   FH                                  
MFA-TR*         WHERE  FH.ACCOUNT_NO         = :FH-ACCOUNT-NO                   
MFA-TR*           AND  FH.BILL_NO            = :FH-BILL-NO                      
MFA-TR*           AND  FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE               
MFA-TR*           AND  FH.IC_NO              = :FH-IC-NO                        
MFA-TR*           AND  FH.BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID1959*                                                                         
ID1959     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
ID1959        CONTINUE                                                  
ID1959     ELSE                                                         
ID1959        SET CWS299-DB2-ERROR        TO TRUE                       
ID1959        MOVE 'ERROR SELECTING CSS_FIXED_FCT_HIST'                 
ID1959                                    TO CWS299-ERROR-MESSAGE       
ID1959        MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
ID1959        MOVE 'SELECT'               TO CWS299-ERROR-FUNCTION      
ID1959        MOVE '6840'                 TO CWS299-ERROR-PARAGRAPH-NO  
ID1959        MOVE '6840-CPD299-GET-FIX'  TO CWS299-ERROR-PARAGRAPH-NAME
ID1959        MOVE 'CSS_FIXED_FCT_HIST'   TO CWS299-ERROR-TABLE1        
ID1959        MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
ID1959        MOVE 'BILL_NO'              TO CWS299-ERROR-TAB-COLUMN-2  
ID1959        MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
ID1959        MOVE 'BILL_ITEM_TIMESTMP'   TO CWS299-ERROR-TAB-COLUMN-4  
ID1959        MOVE FH-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
ID1959        MOVE FH-BILL-NO             TO CWS299-ERROR-HOSTVAR-2     
ID1959        MOVE FH-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
ID1959        MOVE FH-BILL-ITEM-TIMESTMP  TO CWS299-ERROR-HOSTVAR-4     
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6840-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
ID1959******************************************************************        
ID1959** INSERT DATA INTO FIXED FACTOR HISTORY                        **        
ID1959******************************************************************        
ID1959*                                                                         
ID1959 6850-CPD299-INSERT-FCTR-HIST.                                    
ID1959*                                                                         
ID1959     EXEC SQL                                                     
ID1959         INSERT INTO CSS_FIXED_FCT_HIST                           
ID1959            (   ACCOUNT_NO                                        
ID1959               ,BILL_NO                                           
ID1959               ,CODE_UTIL_TYPE                                    
ID1959               ,IC_NO                                             
ID1959               ,BILL_ITEM_TIMESTMP                                
ID1959               ,FIXED_FCTR_SEQ_NO                                 
ID1959               ,FACTOR_ID                                         
ID1959               ,EFF_DATE_FROM                                     
ID1959               ,CMPNT_ID_CD                                       
ID1959               ,CODE_SEASON                                       
ID1959               ,INSTR_USE_TYPE_CD                                 
ID1959               ,CODE_TIME_PERIOD                                  
ID1959               ,CODE_DEBIT_CREDIT                                 
ID1959               ,CODE_REVENUE_CLASS                                
ID1959               ,CODE_TAX_STAT_XMT                                 
ID1959               ,CODE_TAX_CITY_XMT                                 
ID1959               ,CODE_TAX_OTHR_XMT                                 
ID1959               ,FACTOR                                            
ID1959               ,EFF_DATE_TO                                       
ID1959               ,FIXED_FCTR_TYP_CD                                 
ID1959               ,BILL_UNITS                                        
ID1959               ,ENERGY_UNIT_CD                                    
ID1959               ,DURATION_REMAIN_NO                                
ID1959               ,OVR_RT_VER_PRO_FL                                 
ID1959               ,RT_PKG_OPT_SEQ_NO                                 
ID1959               ,BLOCK_NO                                          
ID1959               ,FCTR_POWER_10                                     
ID1959               ,FCTR_DECIMAL_PLACE                                
ID1959               ,LAST_UPDATE_TS                                    
ID1959            )                                                     
ID1959         VALUES                                                   
ID1959            (                                                     
ID1959                :FH-ACCOUNT-NO                                    
ID1959               ,:FH-BILL-NO                                       
ID1959               ,:FH-CODE-UTIL-TYPE                                
ID1959               ,:FH-IC-NO                                         
ID1959               ,CIS.CHAR2TIMESTAMP(:FH-BILL-ITEM-TIMESTMP)                
ID1959               ,:FH-FIXED-FCTR-SEQ-NO                             
ID1959               ,:FH-FACTOR-ID                                     
ID1959               ,IIF(TRY_CONVERT(DATE, :FH-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FH-EFF-DATE-FROM
              ), CONVERT(DATE, :FH-EFF-DATE-FROM) )                            
ID1959               ,:FH-CMPNT-ID-CD                                   
ID1959               ,:FH-CODE-SEASON                                   
ID1959               ,:FH-INSTR-USE-TYPE-CD                             
ID1959               ,:FH-CODE-TIME-PERIOD                              
ID1959               ,:FH-CODE-DEBIT-CREDIT                             
ID1959               ,:FH-CODE-REVENUE-CLASS                            
ID1959               ,:FH-CODE-TAX-STAT-XMT                             
ID1959               ,:FH-CODE-TAX-CITY-XMT                             
ID1959               ,:FH-CODE-TAX-OTHR-XMT                             
ID1959               ,:FH-FACTOR                                        
ID1959               ,IIF(TRY_CONVERT(DATE, :FH-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-TO
              ) <> 0) OR (LEN(:FH-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FH-EFF-DATE-TO
              ), CONVERT(DATE, :FH-EFF-DATE-TO) )                              
ID1959               ,:FH-FIXED-FCTR-TYP-CD                             
ID1959               ,:FH-BILL-UNITS                                    
ID1959               ,:FH-ENERGY-UNIT-CD                                
ID1959               ,NULL                                              
ID1959               ,:FH-OVR-RT-VER-PRO-FL                             
ID1959               ,0                                                 
ID1959               ,0                                                 
ID1959               ,:FH-FCTR-POWER-10                                 
ID1959               ,:FH-FCTR-DECIMAL-PLACE                            
ID1959               ,CIS.CURRENT$TIMESTAMP()                                 
ID1959            )                                                     
ID1959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIXED_FCT_HIST                                   
MFA-TR*           (   ACCOUNT_NO                                                
MFA-TR*              ,BILL_NO                                                   
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,BILL_ITEM_TIMESTMP                                        
MFA-TR*              ,FIXED_FCTR_SEQ_NO                                         
MFA-TR*              ,FACTOR_ID                                                 
MFA-TR*              ,EFF_DATE_FROM                                             
MFA-TR*              ,CMPNT_ID_CD                                               
MFA-TR*              ,CODE_SEASON                                               
MFA-TR*              ,INSTR_USE_TYPE_CD                                         
MFA-TR*              ,CODE_TIME_PERIOD                                          
MFA-TR*              ,CODE_DEBIT_CREDIT                                         
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*              ,CODE_TAX_STAT_XMT                                         
MFA-TR*              ,CODE_TAX_CITY_XMT                                         
MFA-TR*              ,CODE_TAX_OTHR_XMT                                         
MFA-TR*              ,FACTOR                                                    
MFA-TR*              ,EFF_DATE_TO                                               
MFA-TR*              ,FIXED_FCTR_TYP_CD                                         
MFA-TR*              ,BILL_UNITS                                                
MFA-TR*              ,ENERGY_UNIT_CD                                            
MFA-TR*              ,DURATION_REMAIN_NO                                        
MFA-TR*              ,OVR_RT_VER_PRO_FL                                         
MFA-TR*              ,RT_PKG_OPT_SEQ_NO                                         
MFA-TR*              ,BLOCK_NO                                                  
MFA-TR*              ,FCTR_POWER_10                                             
MFA-TR*              ,FCTR_DECIMAL_PLACE                                        
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*               :FH-ACCOUNT-NO                                            
MFA-TR*              ,:FH-BILL-NO                                               
MFA-TR*              ,:FH-CODE-UTIL-TYPE                                        
MFA-TR*              ,:FH-IC-NO                                                 
MFA-TR*              ,:FH-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:FH-FIXED-FCTR-SEQ-NO                                     
MFA-TR*              ,:FH-FACTOR-ID                                             
MFA-TR*              ,:FH-EFF-DATE-FROM                                         
MFA-TR*              ,:FH-CMPNT-ID-CD                                           
MFA-TR*              ,:FH-CODE-SEASON                                           
MFA-TR*              ,:FH-INSTR-USE-TYPE-CD                                     
MFA-TR*              ,:FH-CODE-TIME-PERIOD                                      
MFA-TR*              ,:FH-CODE-DEBIT-CREDIT                                     
MFA-TR*              ,:FH-CODE-REVENUE-CLASS                                    
MFA-TR*              ,:FH-CODE-TAX-STAT-XMT                                     
MFA-TR*              ,:FH-CODE-TAX-CITY-XMT                                     
MFA-TR*              ,:FH-CODE-TAX-OTHR-XMT                                     
MFA-TR*              ,:FH-FACTOR                                                
MFA-TR*              ,:FH-EFF-DATE-TO                                           
MFA-TR*              ,:FH-FIXED-FCTR-TYP-CD                                     
MFA-TR*              ,:FH-BILL-UNITS                                            
MFA-TR*              ,:FH-ENERGY-UNIT-CD                                        
MFA-TR*              ,NULL                                                      
MFA-TR*              ,:FH-OVR-RT-VER-PRO-FL                                     
MFA-TR*              ,0                                                         
MFA-TR*              ,0                                                         
MFA-TR*              ,:FH-FCTR-POWER-10                                         
MFA-TR*              ,:FH-FCTR-DECIMAL-PLACE                                    
MFA-TR*              ,CURRENT TIMESTAMP                                         
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID1959*                                                                         
ID1959     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
ID1959        CONTINUE                                                  
ID1959     ELSE                                                         
ID1959        SET CWS299-DB2-ERROR        TO TRUE                       
ID1959        MOVE 'ERROR INSERTING CSS_FIXED_FCT_HIST'                 
ID1959                                    TO CWS299-ERROR-MESSAGE       
ID1959        MOVE SQLCODE                TO CWS299-ERROR-SQLCODE       
ID1959        MOVE 'INSERT'               TO CWS299-ERROR-FUNCTION      
ID1959        MOVE '6850'                 TO CWS299-ERROR-PARAGRAPH-NO  
ID1959        MOVE '6850-CPD299-INSERT'   TO CWS299-ERROR-PARAGRAPH-NAME
ID1959        MOVE 'CSS_FIXED_FCT_HIST'   TO CWS299-ERROR-TABLE1        
ID1959        MOVE 'ACCOUNT_NO'           TO CWS299-ERROR-TAB-COLUMN-1  
ID1959        MOVE 'BILL_NO'              TO CWS299-ERROR-TAB-COLUMN-2  
ID1959        MOVE 'IC_NO'                TO CWS299-ERROR-TAB-COLUMN-3  
ID1959        MOVE 'BILL_ITEM_TIMESTMP'   TO CWS299-ERROR-TAB-COLUMN-4  
ID1959        MOVE FH-ACCOUNT-NO          TO CWS299-ERROR-HOSTVAR-1     
ID1959        MOVE FH-BILL-NO             TO CWS299-ERROR-HOSTVAR-2     
ID1959        MOVE FH-IC-NO               TO CWS299-ERROR-HOSTVAR-3     
ID1959        MOVE FH-BILL-ITEM-TIMESTMP  TO CWS299-ERROR-HOSTVAR-4     
ID1959     END-IF.                                                      
ID1959*                                                                         
ID1959 6850-CPD299-EXIT.                                                
ID1959     EXIT.                                                        
ID1959*                                                                         
