      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                   PRICE WATERHOUSE                          **         
      **                                                             **         
      **              CUSTOMER INFORMATION SYSTEM                    **         
      *****************************************************************         
      **              P R O G R A M  S U M M A R Y                   **         
      **           COST OF GAS PERCENTAGE CALC ROUTINE               **         
      ** USED TO CALCULATE THE COST OF GAS PERCENTAGE FOR WRITE OFF  **         
      ** ACCOUNTS                                                    **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  -------   --------     ------                              **         
      **  02/15/06   JAYANTHI    INITIAL PROGRAM VERSION             **         
T34097**  02/08/07   MC95456     REPLACED CSS_MODEL_SQL WITH SET     **         
      **                                                STATEMENTS   **         
PRODFX**  06/21/07   SK88120     FIX ISSUE WITH RECOVERY             **         
      **                         (INITIALIZATION ISSUE.)             **         
C36929**  02/22/08   VP94820     SCE&G COG CHANGES.                  **         
      *****************************************************************         
      **                                                             **         
      **           ---- BASIC SEQUENCE STRUCTURE ----                **         
      **                                                             **         
      **  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION          **         
      **  1000 - 1999  INPUT PROCESSING (CREATE STRUCTURE FROM RATE) **         
      **               1100  LOAD RATE TABLE (IF FIRST TIME USED)    **         
      **               1200  BUILD BILL COMPONENT RECORD SHELL       **         
      **               1300  BUILD BILL ADJUSTMENT RECORD SHELL      **         
      **               1400  APPLY BASE RATE ADJUSTMENTS             **         
      **  2000 - 2999  OUTPUT PROCESSING (NOT USED IN SCSCA107)      **         
      **  3000 - 4999  UTILITY AND RECEIVABLE PROCESSING             **         
      **       3000 - 3299 GET NON-RTP CONSUMPTION (METERED)         **         
      **       3300 - 3300 GET UNMETERED CONSUMPTION                 **         
      **       3400 - 3499 GET RTP CONSUMPTION                       **         
      **       3500 - 3599 ADJUST READ UNITS                         **         
      **       3600 - 3699 BREAK UNITS INTO BLOCKS                   **         
      **       4000 - 4299 PRICE CONSUMPTION                         **         
      **       4300 - 4399 ADJUST COMPUTED AMOUNT                    **         
      **  5000 - 5999  COMMON PROGRAM MODULES                        **         
      **  6000 - 6999  COMMON SYSTEM MODULES (COPIES AND INCLUDES)   **         
      **  7000 - 7999  INPUT MODULES (SQL OPENS, FETCHES, SELECTS... **         
      **               THIS IS BASICALLY FOR RATE DATA SINCE THE     **         
      **               CALLING PROGRAM IS RESPONSIBLE FOR EXTRACTING **         
      **               ACCOUNT-RELATED DATA                          **         
      **  8000 - 8999  UPDATE MODULES (NO UPDATES IN SCSCA107)       **         
      **  9000 - 9999  TERMINATION, ABEND, MESSAGING (NOT USED)      **         
      **               IN THE EVENT OF AN UNRECOVERABLE SQL ERROR,   **         
      **               SUFFICIENT INFORMATION IS PASSED BACK TO THE  **         
      **               CALLING PROGRAM FOR IT TO CONTROL TERMINATION.**         
      **               AMOUNG OTHER THINGS, THIS ALLOWS SCSCA107 TO  **         
      **               EXECUTE IN BATCH OR CICS.                     **         
      **                                                             **         
      *****************************************************************         
      /                                                                         
      *****************************************************************         
       01  PROGRAM-WORK-VARIABLES.                                      
      **     THE WORK VARIABLE AREA IS USED FOR TRANSIENT DATA. IT   **         
      **     IS INITIALIZED ON EACH CALL TO THE SUBROUTINE.          **         
      **     THE OTHER WORK AREAS ARE INITIALIZED UNDER PROGRAM      **         
      **     CONTROL.  ADD ANY NEW DATA FIELDS ACCORDINGLY.          **         
      **                                                             **         
           05  WS-DATE-LFTM-HI-DMD-NULL         PIC S9(4) COMP.         
           05  WS-CURRENT-TIMESTMP              PIC X(26) VALUE SPACES. 
COB305     05 WS-COG-RECOVERED-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
COB305     05 WS-COG-REVERSAL-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
COB305     05 WS-COG-BALANCE-AM        PIC S9(9)V99 COMP-3 VALUE 0.    
COB305     05 WS-X-FACTOR        PIC S9(4)V99 COMP-3 VALUE 0.    
           05  WS-EXIT-FLAG                     PIC X(01) VALUE 'N'.    
           05  WS-CURRENT-DATE                  PIC X(10) VALUE SPACES. 
           05  WS-RETURN-CODE-NUM               PIC 9(09).              
           05  WS-RETURN-CODE-CHAR              PIC X(09).              
           05  WS-TRAN-APPL-NO                  PIC 9(03) VALUE ZERO.   
           05  WS-RETURN-CODE                 PIC S9(9) VALUE +000 COMP.
           05  WS-811                           PIC S9(9)               
                                                     VALUE -811 COMP.   
       01  WS-SWITCHES.                                                 
           05  WS-DATABASE                      PIC 9(01) VALUE ZERO.   
               88 CSR-DATABASE                       VALUE 1.           
               88 SEB-DATABASE                       VALUE 2.           
           05  WS-NSA-FLAG                      PIC 9(01) VALUE ZERO.   
               88 NSA-ACTIVE                         VALUE 1.           
               88 NSA-INACTIVE                       VALUE 0.           
                                                                        
                                                                        
      /*********** COPY MEMBERS ****************************                    
      **  WORK QUEUE WORK AREA                                                  
       COPY CWS0070B.                                                           
      **  WS-WARNING-DATA-ELEMENTS (INCL PRIMARY SQL CODES)                     
       COPY CWS00303.                                                           
           05  MULTIPLE-ROWS              PIC S9(9) VALUE -811 COMP.    
       COPY CWS00004.                                                           
      *                                                                         
       LINKAGE SECTION.                                                 
                                                                        
       COPY CWSCA225.                                                           
       COPY CWS00010.                                                           
                                                                        
       01  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.        
                                                                        
      *                                                                         
       PROCEDURE DIVISION USING CWSCA225-FIELDS,                        
                                ABEND-FILE,                             
                                RS-RETURN-CODE.                         
                                                                        
      ******************************************************************        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
      ****INITIALIZE THIS FLAG ONCE WE ENTER THE ROUTINE                        
           MOVE 'N'                         TO WS-EXIT-FLAG             
           MOVE WS-C225-ACCOUNT-NO          TO CF-ACCOUNT-NO            
           MOVE WS-C225-COMPANY-NO          TO CF-COMPANY-NO            
           MOVE WS-C225-PYMT-PRIORITY-LVL   TO CF-PYMT-PRIORITY-LVL     
                                                                        
           MOVE SPACES                      TO ABEND-FUNCTION           
                                                                        
           MOVE 'NSA-FLAG'                       TO C8-DELINQ-CD        
           PERFORM 8980-DETERMINE-DATABASE       THRU 8980-EXIT         
           MOVE C8-DELINQ-VALUE                  TO WS-NSA-FLAG         
                                                                        
           MOVE 'COG-X-FACTOR'                   TO C8-DELINQ-CD        
           PERFORM 8980-DETERMINE-DATABASE       THRU 8980-EXIT         
           MOVE C8-DELINQ-VALUE                  TO WS-X-FACTOR         
                                                                        
           PERFORM 7020-SELECT-CUR-DATE     THRU 7020-EXIT              
                                                                        
           PERFORM 1000-PROCESS-ACCOUNT THRU 1000-EXIT                  
                                                                        
           EXIT PROGRAM.                                                
      ******************************************************************        
      **                                                              **        
      **    1000-PROCESS-ACCOUNT                                      **        
      **                                                              **        
      ******************************************************************        
       1000-PROCESS-ACCOUNT.                                            
                                                                        
           MOVE 1000                         TO ACTIVE-PARAGRAPH        
      ***                                                                       
      *** IF NSA-FLAG IS ACTIVE RECOVER COG MONEY FROM NSA. OTHERWISE           
      *** RECOVER ONLY FROM UTILITY                                             
      ***                                                                       
           IF WS-C225-PYMT-PRIORITY-LVL = 20 AND NSA-INACTIVE           
              GO TO 1000-EXIT                                           
           END-IF                                                       
                                                                        
           PERFORM 7010-SELECT-CUR-TIMESTAMP THRU 7010-EXIT             
           MOVE WS-CURRENT-TIMESTMP          TO CF-CREATED-TS           
           PERFORM 7000-GET-DEFERRED-PCT     THRU 7000-EXIT             
                                                                        
           IF WS-EXIT-FLAG EQUAL 'Y'                                    
              GO TO 1000-EXIT                                           
           END-IF                                                       
      *                                                                         
C36929     IF WS-C225-COMPANY-NO = '01' AND                             
C36929        WS-C225-PYMT-PRIORITY-LVL = 20                            
C36929        COMPUTE WS-C225-ORIG-RECOVERY-AM ROUNDED =                
C36929                WS-C225-ORIG-RECOVERY-AM * CF-GAS-ALLOC-PCT / 100 
C36929     END-IF                                                       
      *                                                                         
           EVALUATE WS-C225-COG-TRAN-TYPE-CD                            
              WHEN 'V'                                                  
                 PERFORM 7100-GET-REMAINING-AMT  THRU 7100-EXIT         
                 COMPUTE WS-COG-REVERSAL-AMT =                          
                                        WS-C225-ORIG-RECOVERY-AM * -1   
                 MOVE WS-COG-REVERSAL-AMT   TO CF-WO-ADJUSTED-AM        
                 COMPUTE CF-COG-DEFERRED-AM ROUNDED =                   
                      (CF-WO-ADJUSTED-AM * CF-COG-DEFERRED-PCT) / 100   
                 COMPUTE WS-COG-BALANCE-AM ROUNDED = CF-COG-BALANCE-AM +
                                         CF-COG-DEFERRED-AM             
                 IF WS-COG-BALANCE-AM <= WS-X-FACTOR                    
                    MOVE ZEROES                  TO WS-COG-BALANCE-AM   
                 END-IF                                                 
                 MOVE WS-COG-BALANCE-AM          TO CF-COG-BALANCE-AM   
              WHEN 'C'                                                  
                 MOVE WS-C225-ORIG-RECOVERY-AM  TO CF-WO-ADJUSTED-AM    
                 COMPUTE CF-COG-DEFERRED-AM ROUNDED =                   
                      (CF-WO-ADJUSTED-AM * CF-COG-DEFERRED-PCT) / 100   
                 PERFORM 7100-GET-REMAINING-AMT  THRU 7100-EXIT         
                 COMPUTE WS-COG-BALANCE-AM ROUNDED = CF-COG-BALANCE-AM +
                                         CF-COG-DEFERRED-AM             
                 IF WS-COG-BALANCE-AM <= WS-X-FACTOR                    
                    MOVE ZEROES                  TO WS-COG-BALANCE-AM   
                 END-IF                                                 
                                                                        
                 MOVE WS-COG-BALANCE-AM          TO CF-COG-BALANCE-AM   
              WHEN OTHER                                                
                 COMPUTE WS-COG-RECOVERED-AMT ROUNDED =                 
               (CF-COG-DEFERRED-PCT * WS-C225-ORIG-RECOVERY-AM) / 100   
                                                                        
      ***                                                                       
      *** GET THE BALANCE COG AMT. IF THIS AMT IS GREATER THAN THE              
      *** THE AMOUNT TO BE RECOVERED THEN INSERT THE RECOVERY AMOUNT.           
      *** OTHERWISE, RECOVER THE BALANCE AMOUNT. CANNOT RECOVER                 
      *** MORE THAN THE BALANCE AMOUNT                                          
      ***                                                                       
                 PERFORM 7100-GET-REMAINING-AMT THRU 7100-EXIT          
                 COMPUTE WS-COG-BALANCE-AM ROUNDED = CF-COG-BALANCE-AM -
                                             WS-COG-RECOVERED-AMT       
                 IF WS-COG-RECOVERED-AMT <= CF-COG-BALANCE-AM           
                    COMPUTE WS-COG-RECOVERED-AMT =                      
                                         WS-COG-RECOVERED-AMT * -1      
                    IF WS-COG-BALANCE-AM <= WS-X-FACTOR                 
                       MOVE ZEROES               TO WS-COG-BALANCE-AM   
                    END-IF                                              
                    MOVE WS-COG-BALANCE-AM  TO CF-COG-BALANCE-AM        
                 ELSE                                                   
                 COMPUTE WS-COG-RECOVERED-AMT = CF-COG-BALANCE-AM * -1  
                    MOVE ZEROES             TO CF-COG-BALANCE-AM        
                                                  WS-COG-BALANCE-AM     
                 END-IF                                                 
                 MOVE WS-COG-RECOVERED-AMT  TO CF-COG-DEFERRED-AM       
                 COMPUTE WS-COG-REVERSAL-AMT =                          
                                        WS-C225-ORIG-RECOVERY-AM * -1   
                 MOVE WS-COG-REVERSAL-AMT     TO CF-WO-ADJUSTED-AM      
           END-EVALUATE                                                 
                                                                        
           MOVE WS-C225-COG-TRAN-TYPE-CD    TO CF-COG-TRAN-TYPE-CD      
                                                                        
           PERFORM 7200-INSERT-RECOVERY     THRU 7200-EXIT              
           .                                                            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **   7000-GET-DEFERRED-PCT                                      **        
      **        GET THE DEFERRED PERCENTAGE FROM THE COG TABLE        **        
      ******************************************************************        
       7000-GET-DEFERRED-PCT.                                           
                                                                        
           MOVE '7000'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT COG_DEFERRED_PCT                                  
                     ,GAS_ALLOC_PCT                                     
                     ,COG_DEFERRED_AM                                   
                 INTO :CF-COG-DEFERRED-PCT                              
                     ,:CF-GAS-ALLOC-PCT                                 
                     ,:CF-COG-DEFERRED-AM                               
                 FROM CSS_COST_GAS_DEFER CF                             
                WHERE ACCOUNT_NO           = :CF-ACCOUNT-NO             
                  AND COG_TRAN_TYPE_CD     = 'W'                        
                  AND COMPANY_NO           = :CF-COMPANY-NO             
                  AND PYMT_PRIORITY_LVL    = :CF-PYMT-PRIORITY-LVL      
                  AND CREATED_TS =                                      
                   (SELECT MAX(CREATED_TS)                              
                      FROM CSS_COST_GAS_DEFER CF1                       
                     WHERE CF1.ACCOUNT_NO = CF.ACCOUNT_NO               
                       AND CF1.COMPANY_NO = CF.COMPANY_NO               
                       AND CF1.PYMT_PRIORITY_LVL = CF.PYMT_PRIORITY_LVL 
                       AND CF1.COG_TRAN_TYPE_CD  = CF.COG_TRAN_TYPE_CD) 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'                    TO WS-EXIT-FLAG            
                 MOVE 100                    TO RS-RETURN-CODE          
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_COST_GAS_DEFER'      TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE CF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
      ******************************************************************        
      **   7100-GET-REMAINING-AMT                                     **        
      **        GET THE REMAINING AMOUNT TO BE RECOVERED FOR THE ACCT **        
      ******************************************************************        
       7100-GET-REMAINING-AMT.                                          
                                                                        
           MOVE '7100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT COG_BALANCE_AM                                    
                 INTO :CF-COG-BALANCE-AM                                
                 FROM CSS_COST_GAS_DEFER CF                             
                WHERE ACCOUNT_NO           = :CF-ACCOUNT-NO             
                  AND COMPANY_NO           = :CF-COMPANY-NO             
                  AND CREATED_TS =                                      
                     (SELECT MAX(CREATED_TS)                            
                        FROM CSS_COST_GAS_DEFER CF1                     
                       WHERE CF1.ACCOUNT_NO    = CF.ACCOUNT_NO          
                         AND CF1.COMPANY_NO    = CF.COMPANY_NO)         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_COST_GAS_DEFER'      TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE CF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
      ******************************************************************        
      **   7200-INSERT-RECOVERY                                       **        
      **        INSERT A RECOVERY ROW WITH THE REAMINING BALANCE      **        
      ******************************************************************        
       7200-INSERT-RECOVERY.                                            
                                                                        
           MOVE '7200'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_COST_GAS_DEFER                           
                    (ACCOUNT_NO                                         
                    ,CREATED_TS                                         
                    ,COMPANY_NO                                         
                    ,COG_TRAN_TYPE_CD                                   
                    ,PYMT_PRIORITY_LVL                                  
                    ,WO_ADJUSTED_AM                                     
                    ,COG_DEFERRED_AM                                    
                    ,COG_DEFERRED_PCT                                   
                    ,GAS_ALLOC_PCT                                      
                    ,COG_BALANCE_AM)                                    
             VALUES (:CF-ACCOUNT-NO                                     
                    ,CIS.CHAR2TIMESTAMP(:CF-CREATED-TS)                         
                    ,:CF-COMPANY-NO                                     
                    ,:CF-COG-TRAN-TYPE-CD                               
                    ,:CF-PYMT-PRIORITY-LVL                              
                    ,:CF-WO-ADJUSTED-AM                                 
                    ,:CF-COG-DEFERRED-AM                                
                    ,:CF-COG-DEFERRED-PCT                               
                    ,:CF-GAS-ALLOC-PCT                                  
                    ,:CF-COG-BALANCE-AM)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_COST_GAS_DEFER                                   
MFA-TR*             (ACCOUNT_NO                                                 
MFA-TR*             ,CREATED_TS                                                 
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,COG_TRAN_TYPE_CD                                           
MFA-TR*             ,PYMT_PRIORITY_LVL                                          
MFA-TR*             ,WO_ADJUSTED_AM                                             
MFA-TR*             ,COG_DEFERRED_AM                                            
MFA-TR*             ,COG_DEFERRED_PCT                                           
MFA-TR*             ,GAS_ALLOC_PCT                                              
MFA-TR*             ,COG_BALANCE_AM)                                            
MFA-TR*      VALUES (:CF-ACCOUNT-NO                                             
MFA-TR*             ,:CF-CREATED-TS                                             
MFA-TR*             ,:CF-COMPANY-NO                                             
MFA-TR*             ,:CF-COG-TRAN-TYPE-CD                                       
MFA-TR*             ,:CF-PYMT-PRIORITY-LVL                                      
MFA-TR*             ,:CF-WO-ADJUSTED-AM                                         
MFA-TR*             ,:CF-COG-DEFERRED-AM                                        
MFA-TR*             ,:CF-COG-DEFERRED-PCT                                       
MFA-TR*             ,:CF-GAS-ALLOC-PCT                                          
MFA-TR*             ,:CF-COG-BALANCE-AM)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_COST_GAS_DEFER'      TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE CF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
      ******************************************************************        
      **    7010-SELECT-CUR-TIMESTAMP                                 **        
      **                                                              **        
      **  GET CURRENT TIMESTAMP                                       **        
      ******************************************************************        
       7010-SELECT-CUR-TIMESTAMP.                                       
                                                                        
           MOVE '7010' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 12                        TO RS-RETURN-CODE          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7020-SELECT-CUR-DATE                                      **        
      **                                                              **        
      **  GET CURRENT DATE                                            **        
      ******************************************************************        
       7020-SELECT-CUR-DATE.                                            
                                                                        
           MOVE '7020' TO ACTIVE-PARAGRAPH.                             
                                                                        
            EXEC SQL                                                    
T34097        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SET :WS-CURRENT-DATE  = CURRENT DATE                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8980-DETERMINE-DATABASE.                                         
                                                                        
      ******************************************************************        
      *   ARE WE IN SEB OR CSR?                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY                                   
              WHERE   DELINQ_CD = :C8-DELINQ-CD                         
              AND     COMPANY_NO = :CF-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8980'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ-CD'               TO TABLE-ELEMENT-1         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8980-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
      ******************************************************************        
      * THIS ROUTINE WAS ADDED TO PACIFY CPD00067 JOURNALLING COPYBOOK *        
      ******************************************************************        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
              MOVE '9900' TO ACTIVE-PARAGRAPH                           
              DISPLAY '**  CPDCA225 PROCESSING ERROR  **'               
              DISPLAY '**      PARAGRAPH ' ACTIVE-PARAGRAPH             
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
           GO TO 9910-ABEND.                                            
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9910-ABEND                                                 *        
      *                                                                *        
      *     PERFORMED IF DB2 PROBLEM OCCURS.                           *        
      ******************************************************************        
                                                                        
       9910-ABEND.                                                      
                                                                        
           MOVE '9910' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-RETURN-CODE-NUM TO WS-RETURN-CODE-CHAR            
              DISPLAY '**  CPDCA225 PROCESSING ERROR  **'               
              DISPLAY '**  UNSUCCESSFUL ROLLBACK      **'               
              DISPLAY '**  PARAGRAPH ' ACTIVE-PARAGRAPH                 
              DISPLAY '**  RETURN CODE = ' WS-RETURN-CODE-CHAR          
           END-IF.                                                      
           MOVE WS-RETURN-CODE-NUM       TO  RETURN-CODE.               
           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT.                   
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
