      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                   PRICE WATERHOUSE                          **         
      **                                                             **         
      **              CUSTOMER INFORMATION SYSTEM                    **         
      *****************************************************************         
      **              P R O G R A M  S U M M A R Y                   **         
      **            COG PCT CALC ROUTINE FOR BILLING                 **         
      ** USED TO CALCULATE THE COST OF GAS PERCENTAGE FOR WRITE OFF  **         
      ** ACCOUNTS FROM THE BILLING DETAILS                           **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  -------   --------     ------                              **         
      **  03/03/06   JAYANTHI    INITIAL PROGRAM VERSION             **         
T34097**  14/12/07   MK92804     REPLACED CSS_MODEL_SQL SELECT STAMTS**         
T34097**                         WITH SET STAEMENTS AND ADDED WITH UR**         
T34097**                         FOR SINGELTON SELECTS AND ADDED FOR **         
T34097**                         FETCH ONLY WITH UR FOR CURSORS.     **         
C36929**  02/21/08   VP94820     SCE&G COG CHANGES.                  **         
C37826**  02/21/08   VP94820     FIX TO SQLCODE -502                 **         
P00131**  05/05/09   VP94820   A-PSNC STEP RATE CHANGES.             **         
P00131**             SK42147   B-CHANGES TO POPULATE CSS_COST_GAS_DET**         
A02036**  07/21/10   DB41297     DISPLAY CORRECT ACCOUNT-NO ON ABEND **         
A04070**  03/26/12   VIJAY       APPLY SEASON FOR PSNC COG FACTOR.   **         
ACT041**  02/08/14   VIJAY       INITIALIZE SA-FACTOR IN NOT-FOUND   **         
ACT041**  A04880                 CONDITION.                          **         
P01137**  05/05/09   VENKAT.P    DO NOT MOVE 0'S TO WS-PRICE-SCHD-1  **         
      *****************************************************************         
      **                                                             **         
      **           ---- BASIC SEQUENCE STRUCTURE ----                **         
      **                                                             **         
      **  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION          **         
      **  1000 - 1999  INPUT PROCESSING (CREATE STRUCTURE FROM RATE) **         
      **               1100  LOAD RATE TABLE (IF FIRST TIME USED)    **         
      **               1200  BUILD BILL COMPONENT RECORD SHELL       **         
      **               1300  BUILD BILL ADJUSTMENT RECORD SHELL      **         
      **               1400  APPLY BASE RATE ADJUSTMENTS             **         
      **  2000 - 2999  OUTPUT PROCESSING (NOT USED IN SCSCA107)      **         
      **  3000 - 4999  UTILITY AND RECEIVABLE PROCESSING             **         
      **       3000 - 3299 GET NON-RTP CONSUMPTION (METERED)         **         
      **       3300 - 3300 GET UNMETERED CONSUMPTION                 **         
      **       3400 - 3499 GET RTP CONSUMPTION                       **         
      **       3500 - 3599 ADJUST READ UNITS                         **         
      **       3600 - 3699 BREAK UNITS INTO BLOCKS                   **         
      **       4000 - 4299 PRICE CONSUMPTION                         **         
      **       4300 - 4399 ADJUST COMPUTED AMOUNT                    **         
      **  5000 - 5999  COMMON PROGRAM MODULES                        **         
      **  6000 - 6999  COMMON SYSTEM MODULES (COPIES AND INCLUDES)   **         
      **  7000 - 7999  INPUT MODULES (SQL OPENS, FETCHES, SELECTS... **         
      **               THIS IS BASICALLY FOR RATE DATA SINCE THE     **         
      **               CALLING PROGRAM IS RESPONSIBLE FOR EXTRACTING **         
      **               ACCOUNT-RELATED DATA                          **         
      **  8000 - 8999  UPDATE MODULES (NO UPDATES IN SCSCA107)       **         
      **  9000 - 9999  TERMINATION, ABEND, MESSAGING (NOT USED)      **         
      **               IN THE EVENT OF AN UNRECOVERABLE SQL ERROR,   **         
      **               SUFFICIENT INFORMATION IS PASSED BACK TO THE  **         
      **               CALLING PROGRAM FOR IT TO CONTROL TERMINATION.**         
      **               AMOUNG OTHER THINGS, THIS ALLOWS SCSCA107 TO  **         
      **               EXECUTE IN BATCH OR CICS.                     **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **    5500-PROCESS                                             **         
      **                                                             **         
      *****************************************************************         
       5500-PROCESS.                                                    
                                                                        
           PERFORM 5100-VALIDATE-INPUT           THRU 5100-EXIT         
           IF WS-EXIT-FL NOT EQUAL 'Y'                                  
              PERFORM 5200-INITIALIZE            THRU 5200-EXIT         
P00131        IF WS-LOAD-FL = 'Y'                                       
P00131           INITIALIZE WS-JOB-PARM-RATES-1                         
P00131           SET WS-RATE-INDX TO 1                                  
P00131           PERFORM 5550-LOAD-JOB-PARM         THRU 5550-EXIT      
P00131           MOVE 'N'      TO WS-LOAD-FL                            
P00131        END-IF                                                    
                                                                        
              PERFORM 5510-PROCESS-ACCOUNT       THRU 5510-EXIT         
           END-IF                                                       
           .                                                            
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5100-VALIDATE-INPUT                                       **        
      **                                                              **        
      ******************************************************************        
       5100-VALIDATE-INPUT.                                             
                                                                        
           MOVE 5100                        TO ACTIVE-PARAGRAPH         
                                                                        
           MOVE 'N'                         TO WS-EXIT-FL               
           IF WS-C224-ACCOUNT-NO NOT EQUAL ZEROES                       
              AND WS-C224-UTILITY-AMOUNT NOT EQUAL ZEROES               
              IF WS-C224-CODE-UTIL-TYPE EQUAL 'G' OR 'E'                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 'Y'                   TO WS-EXIT-FL               
                 MOVE 'CG0003'              TO WS-C224-ERROR-CD         
                 GO TO 5100-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              IF WS-C224-ACCOUNT-NO NOT EQUAL ZEROES                    
                 MOVE 'CG0001'               TO WS-C224-ERROR-CD        
              ELSE                                                      
                 MOVE 'CG0002'               TO WS-C224-ERROR-CD        
              END-IF                                                    
              MOVE 'Y'                       TO WS-EXIT-FL              
              GO TO 5100-EXIT                                           
           END-IF                                                       
                                                                        
           .                                                            
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5200-INITIALIZE                                           **        
      **                                                              **        
      ******************************************************************        
       5200-INITIALIZE.                                                 
                                                                        
           MOVE 5200                   TO ACTIVE-PARAGRAPH              
                                                                        
           MOVE SPACES                 TO WS-FACTOR-YY                  
                                          WS-FACTOR-MM                  
                                          WS-FACTOR-DD                  
                                          ABEND-FUNCTION                
                                                                        
           MOVE 'N'                    TO WS-EXIT-FL                    
                                                                        
           MOVE ZEROES                 TO WS-COG-AMOUNT-TOT             
                                          WS-ORIG-UTILITY-AMOUNT        
                                          WS-PREV-UTILITY-AMOUNT        
                                          WS-COG-PERCENT                
P00131                                    WS-ENTRY-NO-GB-TEMP           
P00131                                    WS-COG-AMOUNT-SUMM            
P00131     SET WS-DET-INDX TO 1                                         
P00131*                                                                         
           .                                                            
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5510-PROCESS-ACCOUNT                                      **        
      **                                                              **        
      ******************************************************************        
       5510-PROCESS-ACCOUNT.                                            
                                                                        
           MOVE 5510                        TO ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-C224-ACCOUNT-NO           TO BG-ACCOUNT-NO           
           MOVE WS-C224-CODE-UTIL-TYPE       TO BG-CODE-UTIL-TYPE       
           MOVE WS-C224-UTILITY-AMOUNT       TO WS-UTILITY-AMOUNT       
                                                WS-ORIG-UTILITY-AMOUNT  
      ***                                                                       
      *** GET THE REVENUE MONTH START FROM CSS_JOB_PARM TO CALCULATE            
      *** COST OF GAS PERCENTAGE. COG WILL BE RECOVERED ONLY FOR                
      *** THESE ACCOUNTS                                                        
      ***                                                                       
           MOVE WS-C224-COMPANY-NO          TO BG-COMPANY-NO            
           PERFORM 7900-GET-BILL-COG-DATE   THRU 7900-EXIT              
           MOVE WS-PARM-REVMTH-NUM          TO WS-PARM-REV-MTH          
      *                                                                         
           PERFORM 7910-OPEN-BG-CURSOR      THRU 7910-EXIT              
           PERFORM 7920-FETCH-BG-CURSOR     THRU 7920-EXIT              
           PERFORM 5520-PROCESS-BG-RECORDS  THRU 5520-EXIT              
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
                         OR WS-EXIT-FL = 'Y'                            
           PERFORM 7930-CLOSE-BG-CURSOR     THRU 7930-EXIT              
           IF WS-COG-AMOUNT-TOT > 0 AND WS-ORIG-UTILITY-AMOUNT > 0      
P00131        MOVE WS-COG-AMOUNT-SUMM TO WS-COG-AMOUNT-TOT              
              COMPUTE WS-COG-PERCENT ROUNDED =                          
                    WS-COG-AMOUNT-TOT * 100 / WS-ORIG-UTILITY-AMOUNT    
           ELSE                                                         
              MOVE ZEROES                    TO WS-COG-PERCENT          
           END-IF                                                       
           MOVE WS-COG-PERCENT               TO WS-C224-COG-PERCENT     
           .                                                            
       5510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5520-PROCESS-BG-RECORDS                                   **        
      **                                                              **        
      ******************************************************************        
       5520-PROCESS-BG-RECORDS.                                         
                                                                        
           MOVE 5520                        TO ACTIVE-PARAGRAPH.        
                                                                        
           IF BG-CODE-BILL-CALC = 'S' AND                               
                            BG-CODE-BILL-ITM-TYPE NOT EQUAL 'B'         
              MOVE 'CG0004'                 TO  WS-C224-ERROR-CD        
              MOVE 'Y'                      TO  WS-EXIT-FL              
              MOVE ZERO                     TO  WS-COG-AMOUNT-TOT       
C37826        GO TO 5520-EXIT                                           
           END-IF                                                       
           PERFORM 5521-INITIALIZE-BG-FIELDS      THRU 5521-EXIT        
           PERFORM 7940-SELECT-RATE-DETAILS       THRU 7940-EXIT        
           IF BG-AMT-BILL-ITEM  > 0                                     
P00131        MOVE WS-UTILITY-AMOUNT          TO WS-PREV-UTILITY-AMOUNT 
P00131*       IF BG-CODE-BILL-ITM-TYPE EQUAL 'B'                                
P00131*          COMPUTE BG-AMT-BILL-ITEM = BG-AMT-BILL-ITEM * -1               
P00131*       END-IF                                                            
P00131        IF BG-CODE-BILL-ITM-TYPE EQUAL 'B' AND                    
P00131           BG-REV-MTH-ORIG-BILL > 0                               
P00131           COMPUTE WS-UTILITY-AMOUNT ROUNDED =                    
P00131                        WS-UTILITY-AMOUNT + BG-AMT-BILL-ITEM      
P00131        ELSE                                                      
P00131           COMPUTE WS-UTILITY-AMOUNT ROUNDED =                    
P00131                        WS-UTILITY-AMOUNT - BG-AMT-BILL-ITEM      
P00131        END-IF                                                    
P00131        IF WS-UTILITY-AMOUNT < 0                                  
P00131           COMPUTE WS-ADJUSTED-COG-PCT ROUNDED                    
P00131                               =  WS-PREV-UTILITY-AMOUNT /        
P00131                                  BG-AMT-BILL-ITEM                
P00131        ELSE                                                      
P00131           MOVE 1              TO WS-ADJUSTED-COG-PCT             
P00131        END-IF                                                    
              IF BG-CODE-UTIL-TYPE = 'G' OR 'E'                         
                 PERFORM 7950-SELECT-CX-END-DATE  THRU 7950-EXIT        
                 MOVE CX-DATE-READ                TO WS-CNS-END-DATE    
                 IF BG-NO-OF-CONS-DAYS > 0                              
                    PERFORM 7960-SELECT-CX-START-DATE  THRU 7960-EXIT   
                 ELSE                                                   
                    MOVE WS-CNS-END-DATE         TO WS-CNS-START-DATE   
                 END-IF                                                 
                 IF BG-REV-MTH-ORIG-BILL = 0                            
                    PERFORM 7970-SELECT-BILLED-UNITS   THRU 7970-EXIT   
                    PERFORM 5530-GET-COG-AMOUNT        THRU 5530-EXIT   
                 ELSE                                                   
                    IF BG-CODE-BILL-ITM-TYPE  =  'B'                    
                       PERFORM 7980-SEL-BKOUT-BILLED-UNITS              
                                                      THRU 7980-EXIT    
                       PERFORM 5530-GET-COG-AMOUNT    THRU 5530-EXIT    
P00131*                COMPUTE BG-AMT-BILL-ITEM = BG-AMT-BILL-ITEM * -1         
                    ELSE                                                
                       PERFORM 7970-SELECT-BILLED-UNITS THRU 7970-EXIT  
                       PERFORM 5530-GET-COG-AMOUNT      THRU 5530-EXIT  
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
C36929           MOVE BG-ACCOUNT-NO              TO CP-ACCOUNT-NO       
C36929           MOVE BG-CODE-UTIL-TYPE          TO CP-CODE-UTIL-TYPE   
C36929           MOVE BG-IC-NO                   TO CP-IC-NO            
C36929           PERFORM 7040-CHECK-SERVICE-TYPE THRU 7040-EXIT         
C36929           IF SERVICE-TYPE-GAS                                    
C36929              CONTINUE                                            
C36929           ELSE                                                   
P00131              IF BG-CODE-BILL-ITM-TYPE EQUAL 'B' AND              
P00131                 BG-REV-MTH-ORIG-BILL > 0                         
P00131                 COMPUTE WS-UTILITY-AMOUNT ROUNDED =              
P00131                        WS-UTILITY-AMOUNT - BG-AMT-BILL-ITEM      
P00131              ELSE                                                
P00131                 COMPUTE WS-UTILITY-AMOUNT ROUNDED =              
P00131                        WS-UTILITY-AMOUNT + BG-AMT-BILL-ITEM      
P00131              END-IF                                              
C36929              PERFORM 7920-FETCH-BG-CURSOR THRU 7920-EXIT         
C36929              GO TO 5520-EXIT                                     
C36929           END-IF                                                 
                 PERFORM 7915-CHECK-VALID-RATE   THRU 7915-EXIT         
                 IF VALID-RATE                                          
                    PERFORM 5540-PROCESS-UNMETERED THRU 5540-EXIT       
                 ELSE                                                   
                    MOVE ZEROES                    TO WS-COG-AMOUNT     
                 END-IF                                                 
              END-IF                                                    
P00131*       MOVE WS-UTILITY-AMOUNT          TO WS-PREV-UTILITY-AMOUNT         
P00131*       IF BG-CODE-BILL-ITM-TYPE EQUAL 'B' AND                            
P00131*          BG-REV-MTH-ORIG-BILL > 0                                       
P00131*          COMPUTE WS-UTILITY-AMOUNT ROUNDED =                            
P00131*                       WS-UTILITY-AMOUNT - BG-AMT-BILL-ITEM              
P00131*       ELSE                                                              
P00131*          COMPUTE WS-UTILITY-AMOUNT ROUNDED =                            
P00131*                       WS-UTILITY-AMOUNT - BG-AMT-BILL-ITEM              
P00131*       END-IF                                                            
              IF WS-UTILITY-AMOUNT <= 0                                 
                 IF WS-UTILITY-AMOUNT < 0                               
P00131*             COMPUTE WS-COG-AMOUNT ROUNDED =                             
P00131*                    (WS-COG-AMOUNT  *  WS-PREV-UTILITY-AMOUNT) /         
P00131*                                 BG-AMT-BILL-ITEM                        
P00131              COMPUTE WS-COG-AMOUNT ROUNDED =                     
P00131                     (WS-COG-AMOUNT  *  WS-ADJUSTED-COG-PCT)      
                 END-IF                                                 
                 COMPUTE WS-COG-AMOUNT-TOT ROUNDED =                    
                               WS-COG-AMOUNT-TOT + WS-COG-AMOUNT        
                 MOVE  'Y'                          TO  WS-EXIT-FL      
              ELSE                                                      
                 IF BG-CODE-BILL-ITM-TYPE = 'B' AND                     
                              BG-REV-MTH-ORIG-BILL > 0                  
                    COMPUTE WS-COG-AMOUNT-TOT ROUNDED =                 
                                WS-COG-AMOUNT-TOT - WS-COG-AMOUNT       
                 ELSE                                                   
                    COMPUTE WS-COG-AMOUNT-TOT ROUNDED  =                
                                WS-COG-AMOUNT-TOT + WS-COG-AMOUNT       
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           PERFORM 7920-FETCH-BG-CURSOR             THRU 7920-EXIT      
           .                                                            
       5520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5521-INITIALIZE-BG-FIELDS                                 **        
      **                                                              **        
      ******************************************************************        
       5521-INITIALIZE-BG-FIELDS.                                       
                                                                        
           MOVE 2100                        TO ACTIVE-PARAGRAPH         
                                                                        
P00131     PERFORM 5522-INITIALIZE-PRCSCHD-FIELDS THRU                  
P00131                                         5522-EXIT                
           MOVE SPACES                      TO WS-CNS-END-DATE          
                                               WS-CNS-START-DATE        
                                               WS-WORK-FROM-DATE        
                                               WS-WORK-TO-DATE          
                                               WS-FACTOR-YY             
                                               WS-FACTOR-MM             
                                               WS-FACTOR-DD             
P00131                                         WS-STEP-CALCULATION      
P00131                                         WS-STEP-RATE             
P00131                                         WS-DATE-RANGE            
P00131                                         WS-RATE-VER              
           MOVE ZEROES                      TO WS-COG-AMOUNT            
                                               WS-WORK-NO-OF-DAYS       
                                               WS-FACTOR-PRORATE-PCT    
P00131                                         WS-ADJUSTED-COG-PCT      
                                               WS-REM-PRORATE-PCT       
P00131                                         WS-BILL-UNITS            
P00131                                         WS-RT-VER-CNT            
           .                                                            
       5521-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00131 5522-INITIALIZE-PRCSCHD-FIELDS.                                  
P00131*                                                                         
P00131     INITIALIZE WS-PRICE-SCHD-1                                   
P00131     SET WS-PRC-INDX TO 1.                                        
P00131*                                                                         
P00131 5522-EXIT.                                                       
P00131     EXIT.                                                        
      ******************************************************************        
      **                                                              **        
      **    5530-GET-COG-AMOUNT                                       **        
      **                                                              **        
      ******************************************************************        
       5530-GET-COG-AMOUNT.                                             
                                                                        
P00131     MOVE 5530                               TO ACTIVE-PARAGRAPH  
                                                                        
C36929     IF WS-C224-COMPANY-NO = '01'                                 
C36929        MOVE 'COGSCEG'                       TO SA-FACTOR-ID      
C36929     ELSE                                                         
C36929        MOVE 'COGPSNC'                       TO SA-FACTOR-ID      
C36929     END-IF                                                       
P00131*                                                                         
P00131     SET WS-RATE-INDX                        TO 1                 
P00131     SEARCH WS-JOB-PARM-RATES                                     
P00131       AT END                                                     
P00131          SET STEP-RATE-NO                   TO TRUE              
P00131          SET INVALID-DATE-RANGE             TO TRUE              
P00131       WHEN WS-RATE-PLAN(WS-RATE-INDX) = '   '                    
P00131          SET STEP-RATE-NO                   TO TRUE              
P00131          SET INVALID-DATE-RANGE             TO TRUE              
P00131       WHEN WS-RATE-PLAN(WS-RATE-INDX) = BG-RATE-PLAN-NO          
P00131            SET STEP-RATE-YES                TO TRUE              
P00131            IF (WS-EFF-DATE(WS-RATE-INDX) = '1900-01-01' OR       
P00131                WS-CNS-START-DATE >= WS-EFF-DATE(WS-RATE-INDX))   
P00131               SET VALID-DATE-RANGE          TO TRUE              
P00131            ELSE                                                  
P00131               SET INVALID-DATE-RANGE          TO TRUE            
P00131            END-IF                                                
P00131     END-SEARCH                                                   
P00131*                                                                         
P00131     IF STEP-RATE-YES AND VALID-DATE-RANGE                        
P00131        MOVE 'Y'          TO WS-STEP-CALCULATION                  
P00131        PERFORM 5560-PROCESS-STEP-RATES      THRU 5560-EXIT       
P00131        GO TO 5530-EXIT                                           
P00131     ELSE                                                         
P00131        MOVE 'N'          TO WS-STEP-CALCULATION                  
P00131     END-IF.                                                      
                                                                        
           IF RD-VERS-PRORATE-CD = 'U'                                  
              MOVE 'N'                             TO WS-VERS-EXIST-FL  
              MOVE 'N'                             TO WS-VALID-SEASON-FL
A04070        PERFORM 5600-SET-SEASON              THRU 5600-EXIT       
              PERFORM 7990-SELECT-COG-VERS-EXIST   THRU 7990-EXIT       
              PERFORM 7911A-OPEN-COG-CURSOR         THRU 7911A-EXIT     
              PERFORM 7912A-FETCH-COG-CURSOR        THRU 7912A-EXIT     
              IF WS-VERS-EXIST-FL = 'N'                                 
                 COMPUTE WS-COG-AMOUNT ROUNDED =                        
                                        BZ-BILL-UNITS * SA-FACTOR       
P00131           MOVE 1                         TO WS-FACTOR-PRORATE-PCT
P00131           PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT          
              ELSE                                                      
      ***                                                                       
      *** SPECIAL FACTOR IS VALID FOR ATLEAST A MONTH. SO GET THE               
      *** PRORATED RATE FOR UPTO TWO VERSIONS. FETCH ONLY TWICE                 
      ***                                                                       
                 MOVE SA-DATE-FROM                 TO WS-WORK-FROM-DATE 
                 MOVE WS-CNS-END-DATE              TO WS-WORK-TO-DATE   
                 PERFORM 7030-GET-DAYS-BET-DATES   THRU 7030-EXIT       
                 IF WS-WORK-NO-OF-DAYS EQUAL ZERO                       
                    MOVE 1                         TO WS-WORK-NO-OF-DAYS
                 END-IF                                                 
                 COMPUTE WS-FACTOR-PRORATE-PCT ROUNDED =                
                      WS-WORK-NO-OF-DAYS / BG-NO-OF-CONS-DAYS           
                     ON SIZE ERROR                                      
                        MOVE ZERO              TO WS-FACTOR-PRORATE-PCT 
                 END-COMPUTE                                            
                 IF WS-FACTOR-PRORATE-PCT NOT = 0                       
                    COMPUTE WS-COG-AMOUNT ROUNDED =                     
                       BZ-BILL-UNITS * SA-FACTOR * WS-FACTOR-PRORATE-PCT
P00131           PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT          
                 END-IF                                                 
                 PERFORM 7912A-FETCH-COG-CURSOR        THRU 7912A-EXIT  
                 COMPUTE WS-REM-PRORATE-PCT ROUNDED =                   
                                         1 - WS-FACTOR-PRORATE-PCT      
                 IF WS-REM-PRORATE-PCT NOT EQUAL ZERO                   
                    COMPUTE WS-COG-AMOUNT ROUNDED =                     
                       WS-COG-AMOUNT + (BZ-BILL-UNITS * SA-FACTOR *     
                                             WS-REM-PRORATE-PCT)        
P00131           MOVE WS-REM-PRORATE-PCT        TO WS-FACTOR-PRORATE-PCT
P00131           PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT          
                 END-IF                                                 
              END-IF                                                    
              PERFORM 7913A-CLOSE-COG-CURSOR           THRU 7913A-EXIT  
           ELSE                                                         
              MOVE BG-REVENUE-MONTH           TO WS-REVENUE-MONTH       
              MOVE WS-REV-MTH-YYYY            TO WS-FACTOR-YY           
              MOVE WS-REV-MTH-MM              TO WS-FACTOR-MM           
              MOVE '01'                       TO WS-FACTOR-DD           
              MOVE WS-FACTOR-EFF-DT           TO WS-CNS-START-DATE      
                                                 WS-CNS-END-DATE        
A04070        PERFORM 5600-SET-SEASON              THRU 5600-EXIT       
              PERFORM 7911A-OPEN-COG-CURSOR    THRU 7911A-EXIT          
              PERFORM 7912A-FETCH-COG-CURSOR   THRU 7912A-EXIT          
              PERFORM 7913A-CLOSE-COG-CURSOR   THRU 7913A-EXIT          
              COMPUTE WS-COG-AMOUNT ROUNDED = BZ-BILL-UNITS * SA-FACTOR 
P00131        MOVE 1                         TO WS-FACTOR-PRORATE-PCT   
P00131        PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT             
           END-IF                                                       
           .                                                            
       5530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **   5540-PROCESS-UNMETERED                                     **        
      **        PROCESS UNMETERED ACCOUNT                             **        
      ******************************************************************        
       5540-PROCESS-UNMETERED.                                          
                                                                        
           MOVE '5540'                         TO ACTIVE-PARAGRAPH      
                                                                        
C36929     IF WS-C224-COMPANY-NO = '01'                                 
C36929        MOVE 'COGSCEG'                      TO SA-FACTOR-ID       
C36929     ELSE                                                         
C36929        MOVE 'COGPSNC'                      TO SA-FACTOR-ID       
C36929     END-IF                                                       
                                                                        
           PERFORM 7914-SELECT-UM-END-DATE        THRU 7914-EXIT        
           MOVE UC-DATE-USAGE-ENDS                TO WS-CNS-END-DATE    
           IF BG-NO-OF-CONS-DAYS > 0                                    
              PERFORM 7960-SELECT-CX-START-DATE   THRU 7960-EXIT        
           ELSE                                                         
              MOVE WS-CNS-END-DATE                TO WS-CNS-START-DATE  
           END-IF                                                       
           IF BG-REV-MTH-ORIG-BILL EQUAL ZERO                           
              PERFORM 7970-SELECT-BILLED-UNITS    THRU 7970-EXIT        
              MOVE BZ-READ-UNITS                  TO  BZ-BILL-UNITS     
              PERFORM 5530-GET-COG-AMOUNT         THRU 5530-EXIT        
           ELSE                                                         
              IF BG-CODE-BILL-ITM-TYPE        =  'B'                    
                 PERFORM 7980-SEL-BKOUT-BILLED-UNITS   THRU 7980-EXIT   
                 MOVE BZ-READ-UNITS               TO  BZ-BILL-UNITS     
                 PERFORM 5530-GET-COG-AMOUNT      THRU 5530-EXIT        
P00131*          COMPUTE BG-AMT-BILL-ITEM = BG-AMT-BILL-ITEM * -1               
              ELSE                                                      
                 PERFORM 7970-SELECT-BILLED-UNITS THRU 7970-EXIT        
                 MOVE BZ-READ-UNITS               TO BZ-BILL-UNITS      
                 PERFORM 5530-GET-COG-AMOUNT      THRU 5530-EXIT        
              END-IF                                                    
           END-IF                                                       
           .                                                            
       5540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00131******************************************************************        
P00131**   5550-LOAD-JOB-PARM.                                        **        
P00131**        LOAD ALLOWE STEP RATES FROM CSS_JOB_PARM              **        
P00131******************************************************************        
P00131*                                                                         
P00131 5550-LOAD-JOB-PARM.                                              
P00131*                                                                         
P00131     MOVE '5550'                       TO ACTIVE-PARAGRAPH.       
P00131*                                                                         
P00131     MOVE 'STEPRATES'                  TO G6-PROGRAM-NAME.        
P00131     MOVE 'PARM'                       TO G6-CMND-CODE.           
P00131     MOVE 'A'                          TO G6-STATUS.              
P00131     PERFORM 7050-OPEN-STEPRATES-CUR   THRU  7050-EXIT.           
P00131     PERFORM 7051-FETCH-STEPRATES-CUR  THRU  7051-EXIT.           
P00131*                                                                         
P00131     SET WS-RATE-INDX                  TO 1.                      
P00131*                                                                         
P00131     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00131        MOVE G6-PARM-DATA           TO WS-PARM-DATA-1             
P00131        MOVE WS-RATE                TO WS-RATE-PLAN (WS-RATE-INDX)
P00131        MOVE WS-DATE                TO WS-EFF-DATE (WS-RATE-INDX) 
P00131        PERFORM 7051-FETCH-STEPRATES-CUR                          
P00131                                       THRU  7051-EXIT            
P00131        SET WS-RATE-INDX               UP BY 1                    
P00131     END-PERFORM.                                                 
P00131*                                                                         
P00131     PERFORM 7052-CLOSE-STEPRATES-CUR  THRU  7052-EXIT.           
P00131*                                                                         
P00131 5550-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131******************************************************************        
P00131**   5560-PROCESS-STEP-RATES                                    **        
P00131**        CLACULATE COG AMOUNT FOR STEP RATES                   **        
P00131******************************************************************        
P00131*                                                                         
P00131 5560-PROCESS-STEP-RATES.                                         
P00131*                                                                         
P00131     MOVE 5560                             TO ACTIVE-PARAGRAPH.   
P00131*                                                                         
P00131     MOVE BG-CODE-UTIL-TYPE                TO RT-CODE-UTIL-TYPE.  
P00131     MOVE BG-RATE-PLAN-NO                  TO RT-RATE-PLAN-NO.    
P00131     MOVE WS-CNS-START-DATE                TO WS-FACTOR-EFF-DT.   
P00131     MOVE '01'                             TO WS-FACTOR-DD.       
P00131     MOVE WS-FACTOR-EFF-DT                 TO WS-RATE-EFF-DATE.   
P00131     PERFORM 7400-SELECT-RT-VERS           THRU 7400-EXIT.        
P00131*                                                                         
P00131     IF RD-VERS-PRORATE-CD = 'U'                                  
P00131        MOVE 'N'                           TO WS-VERS-EXIST-FL    
P00131        PERFORM 7990A-SELECT-COG-VERS-EXIST THRU 7990A-EXIT       
P00131        PERFORM 5570-PRORTE-BY-DATE        THRu 5570-EXIT         
P00131     ELSE                                                         
P00131        MOVE BG-REVENUE-MONTH              TO WS-REVENUE-MONTH    
P00131        MOVE WS-REV-MTH-YYYY               TO WS-FACTOR-YY        
P00131        MOVE WS-REV-MTH-MM                 TO WS-FACTOR-MM        
P00131        MOVE '01'                          TO WS-FACTOR-DD        
P00131        MOVE WS-FACTOR-EFF-DT              TO WS-CNS-START-DATE   
P00131                                              WS-CNS-END-DATE     
P00131                                              WS-RATE-EFF-DATE    
P00131        MOVE 'N'                           TO WS-VERS-EXIST-FL    
P00131        PERFORM 5570-PRORTE-BY-DATE        THRU 5570-EXIT         
P00131     END-IF.                                                      
P00131*                                                                         
P00131 5560-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131******************************************************************        
P00131**   5570-PRORTE-BY-DATE                                        **        
P00131**        PRORATE STEP RATES BASED ON RATE/COG VERSIONS.        **        
P00131******************************************************************        
P00131*                                                                         
P00131 5570-PRORTE-BY-DATE.                                             
P00131*                                                                         
P00131     MOVE 5570                               TO ACTIVE-PARAGRAPH. 
P00131*                                                                         
P00131     EVALUATE TRUE                                                
P00131         WHEN RT-VERS-NO AND WS-VERS-EXIST-FL = 'N'               
P00131              PERFORM 7053-OPEN-RATE-CR-CUR     THRU 7053-EXIT    
P00131              PERFORM 7054-FETCH-RATE-CR-CUR    THRU 7054-EXIT    
P00131              MOVE RT-VERSION-NO-CNTRL       TO                   
P00131                                             PS-VERSION-NO-CNTRL  
P00131              MOVE BG-CODE-UTIL-TYPE         TO PS-CODE-UTIL-TYPE 
P00131              MOVE BG-RATE-PLAN-NO           TO PS-RATE-PLAN-NO   
P00131              MOVE 1                         TO                   
P00131                                             WS-FACTOR-PRORATE-PCT
P00131              PERFORM 7056-OPEN-PRICE-SCHED  THRU 7056-EXIT       
P00131              PERFORM 7057-FETCH-PRICE-SCHED THRU 7057-EXIT       
P00131              PERFORM 7911-OPEN-COG-CURSOR   THRU 7911-EXIT       
P00131              PERFORM 7912-FETCH-COG-CURSOR  THRU 7912-EXIT       
P00131              MOVE BZ-BILL-UNITS             TO WS-BILL-UNITS     
P00131              PERFORM 5580-LOAD-PRICE-SCHD   THRU 5580-EXIT       
P00131*                                                                         
P00131              SET WS-PRC-INDX                TO 1                 
P00131              PERFORM UNTIL WS-BLOCK-SIZE (WS-PRC-INDX) <= 0      
P00131                 COMPUTE WS-COG-AMOUNT ROUNDED  =                 
P00131                         WS-COG-AMOUNT          +                 
P00131                         WS-BLOCK-SIZE (WS-PRC-INDX) *            
P00131                         WS-FACTOR-VAL (WS-PRC-INDX) *            
P00131                         WS-PRORTE-PCT (WS-PRC-INDX)              
P00131                 PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT    
P00131                 SET WS-PRC-INDX             UP BY 1              
P00131              END-PERFORM                                         
P00131*                                                                         
P00131              PERFORM 7058-CLOSE-PRICE-SCHED THRU 7058-EXIT       
P00131              PERFORM 7055-CLOSE-RATE-CR-CUR THRU 7055-EXIT       
P00131              PERFORM 7913-CLOSE-COG-CURSOR  THRU 7913-EXIT       
P00131*                                                                         
P00131         WHEN RT-VERS-NO AND WS-VERS-EXIST-FL = 'Y'               
P00131*                                                                         
P00131              PERFORM 7053-OPEN-RATE-CR-CUR  THRU 7053-EXIT       
P00131              PERFORM 7054-FETCH-RATE-CR-CUR THRU 7054-EXIT       
P00131              PERFORM 7911-OPEN-COG-CURSOR   THRU 7911-EXIT       
P00131              PERFORM 7912-FETCH-COG-CURSOR  THRU 7912-EXIT       
P00131* Calculate COG Proration %                                               
P00131              MOVE SA-DATE-FROM              TO WS-WORK-FROM-DATE 
P00131              MOVE WS-CNS-END-DATE           TO WS-WORK-TO-DATE   
P00131              PERFORM 7030-GET-DAYS-BET-DATES   THRU 7030-EXIT    
P00131              IF WS-WORK-NO-OF-DAYS EQUAL ZERO                    
P00131                 MOVE 1                      TO WS-WORK-NO-OF-DAYS
P00131              END-IF                                              
P00131              COMPUTE WS-FACTOR-PRORATE-PCT ROUNDED =             
P00131                      WS-WORK-NO-OF-DAYS / BG-NO-OF-CONS-DAYS     
P00131                   ON SIZE ERROR                                  
P00131                   MOVE ZERO              TO WS-FACTOR-PRORATE-PCT
P00131              END-COMPUTE                                         
P00131* Applly COG Proration %                                                  
P00131              MOVE BG-CODE-UTIL-TYPE         TO PS-CODE-UTIL-TYPE 
P00131              MOVE BG-RATE-PLAN-NO           TO PS-RATE-PLAN-NO   
P00131              MOVE RT-VERSION-NO-CNTRL       TO                   
P00131                                             PS-VERSION-NO-CNTRL  
P00131              IF WS-FACTOR-PRORATE-PCT NOT = 0                    
P00131                 PERFORM 7056-OPEN-PRICE-SCHED  THRU 7056-EXIT    
P00131                 PERFORM 7057-FETCH-PRICE-SCHED THRU 7057-EXIT    
P00131                 MOVE BZ-BILL-UNITS             TO WS-BILL-UNITS  
P00131                 PERFORM 5580-LOAD-PRICE-SCHD   THRU 5580-EXIT    
P00131                 SET WS-PRC-INDX                TO 1              
P00131                 PERFORM UNTIL WS-BLOCK-SIZE (WS-PRC-INDX) <= 0   
P00131                    COMPUTE WS-COG-AMOUNT ROUNDED =               
P00131                            WS-COG-AMOUNT       +                 
P00131                            WS-BLOCK-SIZE (WS-PRC-INDX) *         
P00131                            WS-FACTOR-VAL (WS-PRC-INDX) *         
P00131                            WS-PRORTE-PCT (WS-PRC-INDX) *         
P00131                            WS-FACTOR-PRORATE-PCT                 
P00131                     PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT
P00131                     SET WS-PRC-INDX            UP BY 1           
P00131                 END-PERFORM                                      
P00131                 PERFORM 7058-CLOSE-PRICE-SCHED THRU 7058-EXIT    
P00131                 PERFORM 5522-INITIALIZE-PRCSCHD-FIELDS           
P00131                                                THRU 5522-EXIT    
P00131              END-IF                                              
P00131* Calculate Remaining COG Proration %                                     
P00131              COMPUTE WS-REM-PRORATE-PCT ROUNDED =                
P00131                                      1 - WS-FACTOR-PRORATE-PCT   
P00131* Apply Remaining COG Proration %                                         
P00131              IF WS-REM-PRORATE-PCT NOT = 0                       
P00131                 PERFORM 7056-OPEN-PRICE-SCHED  THRU 7056-EXIT    
P00131                 PERFORM 7057-FETCH-PRICE-SCHED THRU 7057-EXIT    
P00131                 MOVE BZ-BILL-UNITS             TO WS-BILL-UNITS  
P00131                 PERFORM 5580-LOAD-PRICE-SCHD   THRU 5580-EXIT    
P00131                 SET WS-PRC-INDX                TO 1              
P00131                 PERFORM UNTIL WS-BLOCK-SIZE (WS-PRC-INDX) <= 0   
P00131                    COMPUTE WS-COG-AMOUNT ROUNDED =               
P00131                            WS-COG-AMOUNT       +                 
P00131                            WS-BLOCK-SIZE (WS-PRC-INDX) *         
P00131                            WS-FACTOR-VAL (WS-PRC-INDX) *         
P00131                            WS-PRORTE-PCT (WS-PRC-INDX) *         
P00131                            WS-REM-PRORATE-PCT                    
P00131                     MOVE WS-REM-PRORATE-PCT TO                   
P00131                                      WS-FACTOR-PRORATE-PCT       
P00131                     PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT
P00131                     SET WS-PRC-INDX            UP BY 1           
P00131                 END-PERFORM                                      
P00131                 PERFORM 7058-CLOSE-PRICE-SCHED THRU 7058-EXIT    
P00131              END-IF                                              
P00131              PERFORM 7913-CLOSE-COG-CURSOR     THRU 7913-EXIT    
P00131              PERFORM 7055-CLOSE-RATE-CR-CUR    THRU 7055-EXIT    
P00131*                                                                         
P00131         WHEN RT-VERS-EXIST AND WS-VERS-EXIST-FL = 'N'            
P00131*                                                                         
P00131              PERFORM 7053-OPEN-RATE-CR-CUR  THRU 7053-EXIT       
P00131              PERFORM 7054-FETCH-RATE-CR-CUR THRU 7054-EXIT       
P00131* Calculate RATE  Proration %                                             
P00131              MOVE RT-FROM-EFFECTIVE-DT      TO WS-WORK-FROM-DATE 
P00131              MOVE WS-CNS-END-DATE           TO WS-WORK-TO-DATE   
P00131              MOVE 1                         TO                   
P00131                                            WS-FACTOR-PRORATE-PCT 
P00131              PERFORM 7030-GET-DAYS-BET-DATES   THRU 7030-EXIT    
P00131              IF WS-WORK-NO-OF-DAYS = 0                           
P00131                 MOVE 1                      TO WS-WORK-NO-OF-DAYS
P00131              END-IF                                              
P00131              COMPUTE WS-RATE-PRORTE-PCT    ROUNDED =             
P00131                   WS-WORK-NO-OF-DAYS / BG-NO-OF-CONS-DAYS        
P00131                   ON SIZE ERROR                                  
P00131                   MOVE 0                    TO WS-RATE-PRORTE-PCT
P00131              END-COMPUTE                                         
P00131* Apply RATE Proration %                                                  
P00131           MOVE BG-CODE-UTIL-TYPE            TO PS-CODE-UTIL-TYPE 
P00131           MOVE BG-RATE-PLAN-NO              TO PS-RATE-PLAN-NO   
P00131           MOVE RT-VERSION-NO-CNTRL          TO                   
P00131                                             PS-VERSION-NO-CNTRL  
P00131           IF WS-RATE-PRORTE-PCT NOT = 0                          
P00131              PERFORM 7056-OPEN-PRICE-SCHED  THRU 7056-EXIT       
P00131              PERFORM 7057-FETCH-PRICE-SCHED THRU 7057-EXIT       
P00131              PERFORM 7911-OPEN-COG-CURSOR   THRU 7911-EXIT       
P00131              PERFORM 7912-FETCH-COG-CURSOR  THRU 7912-EXIT       
P00131              MOVE BZ-BILL-UNITS             TO WS-BILL-UNITS     
P00131              PERFORM 5580-LOAD-PRICE-SCHD   THRU 5580-EXIT       
P00131              SET WS-PRC-INDX                TO 1                 
P00131              PERFORM UNTIL WS-BLOCK-SIZE (WS-PRC-INDX) <= 0      
P00131                 COMPUTE WS-COG-AMOUNT ROUNDED  =                 
P00131                         WS-COG-AMOUNT          +                 
P00131                         WS-BLOCK-SIZE (WS-PRC-INDX) *            
P00131                         WS-FACTOR-VAL (WS-PRC-INDX) *            
P00131                         WS-PRORTE-PCT (WS-PRC-INDX)              
P00131                  PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT   
P00131                  SET WS-PRC-INDX             UP BY 1             
P00131              END-PERFORM                                         
P00131              PERFORM 7913-CLOSE-COG-CURSOR  THRU 7913-EXIT       
P00131              PERFORM 7058-CLOSE-PRICE-SCHED THRU 7058-EXIT       
P00131              PERFORM 5522-INITIALIZE-PRCSCHD-FIELDS              
P00131                                                THRU 5522-EXIT    
P00131           END-IF                                                 
P00131* Calculate Remaining RATE Proration %                                    
P00131           COMPUTE WS-RATE-PRORTE-PCT ROUNDED =                   
P00131                         1 - WS-RATE-PRORTE-PCT                   
P00131* Apply Remaining RATE Proration %                                        
P00131           IF WS-RATE-PRORTE-PCT NOT = 0                          
P00131              PERFORM 7054-FETCH-RATE-CR-CUR THRU 7054-EXIT       
P00131              MOVE RT-VERSION-NO-CNTRL       TO                   
P00131                                             PS-VERSION-NO-CNTRL  
P00131              PERFORM 7056-OPEN-PRICE-SCHED  THRU 7056-EXIT       
P00131              PERFORM 7057-FETCH-PRICE-SCHED THRU 7057-EXIT       
P00131              PERFORM 7911-OPEN-COG-CURSOR   THRU 7911-EXIT       
P00131              PERFORM 7912-FETCH-COG-CURSOR  THRU 7912-EXIT       
P00131              MOVE BZ-BILL-UNITS             TO WS-BILL-UNITS     
P00131              PERFORM 5580-LOAD-PRICE-SCHD   THRU 5580-EXIT       
P00131              SET WS-PRC-INDX                TO 1                 
P00131              PERFORM UNTIL WS-BLOCK-SIZE (WS-PRC-INDX) <= 0      
P00131                 COMPUTE WS-COG-AMOUNT ROUNDED  =                 
P00131                         WS-COG-AMOUNT          +                 
P00131                         WS-BLOCK-SIZE (WS-PRC-INDX) *            
P00131                         WS-FACTOR-VAL (WS-PRC-INDX) *            
P00131                         WS-PRORTE-PCT (WS-PRC-INDX)              
P00131                  PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT   
P00131                  SET WS-PRC-INDX             UP BY 1             
P00131              END-PERFORM                                         
P00131              PERFORM 7058-CLOSE-PRICE-SCHED THRU 7058-EXIT       
P00131              PERFORM 7913-CLOSE-COG-CURSOR  THRU 7913-EXIT       
P00131           END-IF                                                 
P00131           PERFORM 7055-CLOSE-RATE-CR-CUR    THRU 7055-EXIT       
P00131*                                                                         
P00131        WHEN RT-VERS-EXIST AND WS-VERS-EXIST-FL = 'Y'             
P00131*                                                                         
P00131           PERFORM 7053-OPEN-RATE-CR-CUR     THRU 7053-EXIT       
P00131           PERFORM 7054-FETCH-RATE-CR-CUR    THRU 7054-EXIT       
P00131           MOVE BG-CODE-UTIL-TYPE            TO PS-CODE-UTIL-TYPE 
P00131           MOVE BG-RATE-PLAN-NO              TO PS-RATE-PLAN-NO   
P00131           MOVE RT-VERSION-NO-CNTRL          TO                   
P00131                                             PS-VERSION-NO-CNTRL  
P00131* Calculate RATE Proration %                                              
P00131           MOVE RT-FROM-EFFECTIVE-DT         TO WS-WORK-FROM-DATE 
P00131           MOVE WS-CNS-END-DATE              TO WS-WORK-TO-DATE   
P00131           PERFORM 7030-GET-DAYS-BET-DATES   THRU 7030-EXIT       
P00131           IF WS-WORK-NO-OF-DAYS = 0                              
P00131              MOVE 1                         TO WS-WORK-NO-OF-DAYS
P00131           END-IF                                                 
P00131           COMPUTE WS-RATE-PRORTE-PCT    ROUNDED =                
P00131                WS-WORK-NO-OF-DAYS / BG-NO-OF-CONS-DAYS           
P00131               ON SIZE ERROR                                      
P00131                  MOVE ZERO              TO WS-RATE-PRORTE-PCT    
P00131           END-COMPUTE                                            
P00131* Apply RATE Proration %                                                  
P00131           IF WS-RATE-PRORTE-PCT NOT = 0                          
P00131              PERFORM 7911-OPEN-COG-CURSOR   THRU 7911-EXIT       
P00131              PERFORM 7912-FETCH-COG-CURSOR  THRU 7912-EXIT       
P00131* Calculate COG Proration %                                               
P00131              MOVE SA-DATE-FROM              TO WS-WORK-FROM-DATE 
P00131              MOVE WS-CNS-END-DATE           TO WS-WORK-TO-DATE   
P00131              PERFORM 7030-GET-DAYS-BET-DATES THRU 7030-EXIT      
P00131              IF WS-WORK-NO-OF-DAYS = 0                           
P00131                 MOVE 1                      TO WS-WORK-NO-OF-DAYS
P00131              END-IF                                              
P00131              COMPUTE WS-FACTOR-PRORATE-PCT ROUNDED =             
P00131                      WS-WORK-NO-OF-DAYS / BG-NO-OF-CONS-DAYS     
P00131                      ON SIZE ERROR                               
P00131                      MOVE 0              TO WS-FACTOR-PRORATE-PCT
P00131              END-COMPUTE                                         
P00131*Apply COG Proration %                                                    
P00131              IF WS-FACTOR-PRORATE-PCT NOT = 0                    
P00131                 PERFORM 7056-OPEN-PRICE-SCHED  THRU 7056-EXIT    
P00131                 PERFORM 7057-FETCH-PRICE-SCHED THRU 7057-EXIT    
P00131                 MOVE BZ-BILL-UNITS             TO WS-BILL-UNITS  
P00131                 PERFORM 5580-LOAD-PRICE-SCHD   THRU 5580-EXIT    
P00131                 SET WS-PRC-INDX                TO 1              
P00131                 PERFORM UNTIL WS-BLOCK-SIZE (WS-PRC-INDX) <= 0   
P00131                    COMPUTE WS-COG-AMOUNT ROUNDED  =              
P00131                            WS-COG-AMOUNT          +              
P00131                            WS-BLOCK-SIZE (WS-PRC-INDX) *         
P00131                            WS-FACTOR-VAL (WS-PRC-INDX) *         
P00131                            WS-PRORTE-PCT (WS-PRC-INDX) *         
P00131                            WS-FACTOR-PRORATE-PCT                 
P00131                    PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT 
P00131                    SET WS-PRC-INDX             UP BY 1           
P00131                 END-PERFORM                                      
P00131                 PERFORM 7058-CLOSE-PRICE-SCHED THRU 7058-EXIT    
P00131                 PERFORM 5522-INITIALIZE-PRCSCHD-FIELDS           
P00131                                                THRU 5522-EXIT    
P00131              END-IF                                              
P00131* Calculate Remaining COG Proration %                                     
P00131              COMPUTE WS-REM-PRORATE-PCT ROUNDED =                
P00131                                      1 - WS-FACTOR-PRORATE-PCT   
P00131* Apply Remaining COG Proration %                                         
P00131              IF WS-REM-PRORATE-PCT NOT = 0                       
P00131                 PERFORM 7056-OPEN-PRICE-SCHED  THRU 7056-EXIT    
P00131                 PERFORM 7057-FETCH-PRICE-SCHED THRU 7057-EXIT    
P00131                 MOVE BZ-BILL-UNITS             TO WS-BILL-UNITS  
P00131                 PERFORM 5580-LOAD-PRICE-SCHD   THRU 5580-EXIT    
P00131                 SET WS-PRC-INDX                TO 1              
P00131                 PERFORM UNTIL WS-BLOCK-SIZE (WS-PRC-INDX) <= 0   
P00131                    COMPUTE WS-COG-AMOUNT ROUNDED  =              
P00131                            WS-COG-AMOUNT          +              
P00131                            WS-BLOCK-SIZE (WS-PRC-INDX) *         
P00131                            WS-FACTOR-VAL (WS-PRC-INDX) *         
P00131                            WS-PRORTE-PCT (WS-PRC-INDX) *         
P00131                            WS-REM-PRORATE-PCT                    
P00131                    MOVE WS-REM-PRORATE-PCT  TO                   
P00131                         WS-FACTOR-PRORATE-PCT                    
P00131                    PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT 
P00131                    SET WS-PRC-INDX             UP BY 1           
P00131                 END-PERFORM                                      
P00131                 PERFORM 7058-CLOSE-PRICE-SCHED THRU 7058-EXIT    
P00131                 PERFORM 5522-INITIALIZE-PRCSCHD-FIELDS           
P00131                                                THRU 5522-EXIT    
P00131              END-IF                                              
P00131              PERFORM 7913-CLOSE-COG-CURSOR     THRU 7913-EXIT    
P00131           END-IF                                                 
P00131* Calculate Remaining RATE Proration %                                    
P00131           COMPUTE WS-RATE-PRORTE-PCT ROUNDED =                   
P00131                         1 - WS-RATE-PRORTE-PCT                   
P00131* Apply Remaining RATE Proration %                                        
P00131           IF WS-RATE-PRORTE-PCT NOT = 0                          
P00131              PERFORM 7054-FETCH-RATE-CR-CUR THRU 7054-EXIT       
P00131              MOVE RT-VERSION-NO-CNTRL       TO                   
P00131                                             PS-VERSION-NO-CNTRL  
P00131              PERFORM 7911-OPEN-COG-CURSOR      THRU 7911-EXIT    
P00131              PERFORM 7912-FETCH-COG-CURSOR     THRU 7912-EXIT    
P00131* Calculate COG Proration %                                               
P00131              MOVE SA-DATE-FROM              TO WS-WORK-FROM-DATE 
P00131              MOVE WS-CNS-END-DATE           TO WS-WORK-TO-DATE   
P00131              PERFORM 7030-GET-DAYS-BET-DATES   THRU 7030-EXIT    
P00131              IF WS-WORK-NO-OF-DAYS = 0                           
P00131                 MOVE 1                   TO WS-WORK-NO-OF-DAYS   
P00131              END-IF                                              
P00131              COMPUTE WS-FACTOR-PRORATE-PCT ROUNDED =             
P00131                      WS-WORK-NO-OF-DAYS / BG-NO-OF-CONS-DAYS     
P00131                      ON SIZE ERROR                               
P00131                      MOVE 0              TO WS-FACTOR-PRORATE-PCT
P00131              END-COMPUTE                                         
P00131* Apply COG Proration %                                                   
P00131              IF WS-FACTOR-PRORATE-PCT NOT = 0                    
P00131                 PERFORM 7056-OPEN-PRICE-SCHED  THRU 7056-EXIT    
P00131                 PERFORM 7057-FETCH-PRICE-SCHED THRU 7057-EXIT    
P00131                 MOVE BZ-BILL-UNITS             TO WS-BILL-UNITS  
P00131                 PERFORM 5580-LOAD-PRICE-SCHD   THRU 5580-EXIT    
P00131                 SET WS-PRC-INDX                TO 1              
P00131                 PERFORM UNTIL WS-BLOCK-SIZE (WS-PRC-INDX) <= 0   
P00131                    COMPUTE WS-COG-AMOUNT ROUNDED  =              
P00131                            WS-COG-AMOUNT          +              
P00131                            WS-BLOCK-SIZE (WS-PRC-INDX) *         
P00131                            WS-FACTOR-VAL (WS-PRC-INDX) *         
P00131                            WS-PRORTE-PCT (WS-PRC-INDX) *         
P00131                            WS-FACTOR-PRORATE-PCT                 
P00131                    PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT 
P00131                    SET WS-PRC-INDX             UP BY 1           
P00131                 END-PERFORM                                      
P00131                 PERFORM 7058-CLOSE-PRICE-SCHED THRU 7058-EXIT    
P00131                 PERFORM 5522-INITIALIZE-PRCSCHD-FIELDS           
P00131                                                THRU 5522-EXIT    
P00131              END-IF                                              
P00131* Calculate Remaining COG Proration %                                     
P00131              COMPUTE WS-REM-PRORATE-PCT ROUNDED =                
P00131                                      1 - WS-FACTOR-PRORATE-PCT   
P00131* Apply Remaining COG Proration %                                         
P00131              IF WS-REM-PRORATE-PCT NOT = 0                       
P00131                 PERFORM 7056-OPEN-PRICE-SCHED  THRU 7056-EXIT    
P00131                 PERFORM 7057-FETCH-PRICE-SCHED THRU 7057-EXIT    
P00131                 MOVE BZ-BILL-UNITS             TO WS-BILL-UNITS  
P00131                 PERFORM 5580-LOAD-PRICE-SCHD   THRU 5580-EXIT    
P00131                 SET WS-PRC-INDX                TO 1              
P00131                 PERFORM UNTIL WS-BLOCK-SIZE (WS-PRC-INDX) <= 0   
P00131                    COMPUTE WS-COG-AMOUNT ROUNDED  =              
P00131                            WS-COG-AMOUNT          +              
P00131                            WS-BLOCK-SIZE (WS-PRC-INDX) *         
P00131                            WS-FACTOR-VAL (WS-PRC-INDX) *         
P00131                            WS-PRORTE-PCT (WS-PRC-INDX) *         
P00131                            WS-REM-PRORATE-PCT                    
P00131                    MOVE WS-REM-PRORATE-PCT    TO                 
P00131                         WS-FACTOR-PRORATE-PCT                    
P00131                    PERFORM 5590-LOAD-COST-GAS-DET THRU 5590-EXIT 
P00131                    SET WS-PRC-INDX             UP BY 1           
P00131                 END-PERFORM                                      
P00131                 PERFORM 7058-CLOSE-PRICE-SCHED THRU 7058-EXIT    
P00131              END-IF                                              
P00131              PERFORM 7913-CLOSE-COG-CURSOR     THRU 7913-EXIT    
P00131           END-IF                                                 
P00131           PERFORM 7055-CLOSE-RATE-CR-CUR       THRU 7055-EXIT    
P00131     END-EVALUATE.                                                
P00131*                                                                         
P00131 5570-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131*                                                                         
P00131******************************************************************        
P00131**   5580-LOAD-PRICE-SCHD                                       **        
P00131**        LOAD PRICE SCHEDULE AND FACTORS FOR STEP RATES.       **        
P00131******************************************************************        
P00131*                                                                         
P00131 5580-LOAD-PRICE-SCHD.                                            
P00131*                                                                         
P00131     MOVE 5580                           TO ACTIVE-PARAGRAPH.     
P00131*                                                                         
P00131     SET WS-PRC-INDX                     TO 1.                    
P00131*                                                                         
P00131     PERFORM UNTIL WS-BILL-UNITS <= 0  OR                         
P00131                   WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00131        IF PS-BLOCK-NO = SA-BLOCK-NO                              
P00131           IF WS-BILL-UNITS > PS-BLOCK-USE-OR-SVCS                
P00131              MOVE PS-BLOCK-USE-OR-SVCS  TO                       
P00131                                       WS-BLOCK-SIZE (WS-PRC-INDX)
P00131           ELSE                                                   
P00131              MOVE WS-BILL-UNITS         TO                       
P00131                                       WS-BLOCK-SIZE (WS-PRC-INDX)
P00131           END-IF                                                 
P00131           SUBTRACT PS-BLOCK-USE-OR-SVCS FROM WS-BILL-UNITS       
P00131           MOVE SA-FACTOR                TO                       
P00131                                       WS-FACTOR-VAL (WS-PRC-INDX)
P00131           MOVE PS-BLOCK-NO              TO                       
P00131                                       WS-BLOCK-NO (WS-PRC-INDX)  
P00131           IF RT-VERS-EXIST                                       
P00131              MOVE WS-RATE-PRORTE-PCT    TO                       
P00131                                       WS-PRORTE-PCT (WS-PRC-INDX)
P00131           ELSE                                                   
P00131              MOVE 1                     TO                       
P00131                                       WS-PRORTE-PCT (WS-PRC-INDX)
P00131           END-IF                                                 
P00131           PERFORM 7057-FETCH-PRICE-SCHED THRU 7057-EXIT          
P00131           PERFORM 7912-FETCH-COG-CURSOR THRU 7912-EXIT           
P00131           SET WS-PRC-INDX               UP BY 1                  
P00131        ELSE                                                      
P00131           PERFORM 7912-FETCH-COG-CURSOR THRU 7912-EXIT           
P00131        END-IF                                                    
P00131     END-PERFORM.                                                 
P00131*                                                                         
P00131 5580-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131 5590-LOAD-COST-GAS-DET.                                          
P00131        MOVE CF-ACCOUNT-NO      TO                                
P00131                                 WS-ACCOUNT-NO-GB (WS-DET-INDX)   
P00131        MOVE WS-CURRENT-TIMESTAMP TO                              
P00131                                 WS-CREATED-TS-GB (WS-DET-INDX)   
P00131        MOVE WS-C224-COMPANY-NO   TO                              
P00131                                 WS-COMPANY-NO-GB (WS-DET-INDX)   
P00131        COMPUTE WS-ENTRY-NO-GB-TEMP = WS-ENTRY-NO-GB-TEMP + 1     
P00131        MOVE WS-ENTRY-NO-GB-TEMP  TO                              
P00131                                  WS-ENTRY-NO-GB (WS-DET-INDX)    
P00131        MOVE BG-RATE-PLAN-NO      TO                              
P00131                                  WS-RATE-PLAN-NO-GB (WS-DET-INDX)
P00131        MOVE BG-BILL-NO           TO                              
P00131                                  WS-BILL-NO-GB (WS-DET-INDX)     
P00131        IF WS-STEP-CALCULATION = 'Y'                              
P00131           MOVE PS-VERSION-NO-CNTRL TO                            
P00131                                  WS-VERSION-NO-GB (WS-DET-INDX)  
P00131           MOVE WS-BLOCK-SIZE (WS-PRC-INDX) TO                    
P00131                                  WS-BILLED-UNITS-GB (WS-DET-INDX)
P00131           MOVE WS-BLOCK-NO   (WS-PRC-INDX) TO                    
P00131                                  WS-BLOCK-NO-GB (WS-DET-INDX)    
P00131           MOVE WS-FACTOR-VAL (WS-PRC-INDX) TO                    
P00131                                  WS-COG-FACTOR-GB (WS-DET-INDX)  
P00131           MOVE WS-PRORTE-PCT (WS-PRC-INDX) TO                    
P00131                          WS-RATE-PRORATE-PCT-GB (WS-DET-INDX)    
P00131        ELSE                                                      
P00131           MOVE 0                 TO                              
P00131                                  WS-VERSION-NO-GB (WS-DET-INDX)  
P00131           MOVE 0                                                 
P00131                                  TO WS-BLOCK-NO-GB (WS-DET-INDX) 
P00131           MOVE BZ-BILL-UNITS     TO                              
P00131                                  WS-BILLED-UNITS-GB (WS-DET-INDX)
P00131           MOVE SA-FACTOR         TO                              
P00131                                  WS-COG-FACTOR-GB (WS-DET-INDX)  
P00131           MOVE 1                 TO                              
P00131                          WS-RATE-PRORATE-PCT-GB (WS-DET-INDX)    
P00131        END-IF                                                    
P00131        IF BG-CODE-BILL-ITM-TYPE = 'B' AND                        
P00131           BG-REV-MTH-ORIG-BILL > 0                               
P00131           COMPUTE WS-BILLED-UNITS-GB (WS-DET-INDX) =             
P00131                      WS-BILLED-UNITS-GB (WS-DET-INDX) * -1       
P00131        END-IF                                                    
P00131        MOVE WS-FACTOR-PRORATE-PCT TO                             
P00131                          WS-FACTOR-PRORATE-PCT-GB (WS-DET-INDX)  
P00131        MOVE WS-ADJUSTED-COG-PCT   TO                             
P00131                          WS-ADJUSTED-COG-PCT-GB (WS-DET-INDX)    
P00131                                                                  
P00131        MOVE ZEROS                 TO WS-COG-AMOUNT-DETAIL.       
P00131        COMPUTE WS-COG-AMOUNT-DETAIL ROUNDED =                    
P00131               ( WS-BILLED-UNITS-GB (WS-DET-INDX)                 
P00131               * WS-ADJUSTED-COG-PCT-GB (WS-DET-INDX)             
P00131               * WS-FACTOR-PRORATE-PCT-GB (WS-DET-INDX)           
P00131               * WS-COG-FACTOR-GB (WS-DET-INDX)                   
P00131               * WS-RATE-PRORATE-PCT-GB (WS-DET-INDX)).           
P00131        COMPUTE WS-COG-AMOUNT-SUMM ROUNDED =                      
P00131                WS-COG-AMOUNT-SUMM + WS-COG-AMOUNT-DETAIL.        
P00131                                                                  
P00131        SET WS-DET-INDX               UP BY 1.                    
P00131 5590-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
A04070 5600-SET-SEASON.                                                 
                                                                        
A04070     PERFORM 7916-GET-SEASON-DATE  THRU  7916-EXIT.               
                                                                        
A04070     IF VALID-SEASON AND WS-C224-COMPANY-NO = '26'                
A04070        MOVE BG-REVENUE-MONTH TO WS-REVENUE-MONTH                 
A04070        MOVE WS-REVENUE-MONTH (5:2) TO WS-TO-MMDD (1:2)           
                                                                        
A04070        EVALUATE TRUE                                             
A04070            WHEN WS-TO-MMDD (1:2)                                 
A04070                   = '04' OR '06' OR '09' OR '11'                 
A04070               MOVE '30' TO WS-TO-MMDD (3:2)                      
A04070            WHEN WS-TO-MMDD (1:2) = '02'                          
A04070               MOVE '29' TO WS-TO-MMDD (3:2)                      
A04070            WHEN OTHER                                            
A04070               MOVE '31' TO WS-TO-MMDD (3:2)                      
A04070        END-EVALUATE                                              
A04070                                                                  
A04070        IF WS-REVENUE-MONTH < 201011                              
A04070           MOVE 'B' TO SA-CODE-SEASON                             
A04070        ELSE                                                      
A04070           IF WS-TO-MMDD >= RS-DATE-FROM                          
A04070             AND WS-TO-MMDD <= RS-DATE-TO                         
A04070              MOVE 'S' TO SA-CODE-SEASON                          
A04070           ELSE                                                   
A04070              MOVE 'N' TO SA-CODE-SEASON                          
A04070           END-IF                                                 
A04070        END-IF                                                    
A04070     ELSE                                                         
A04070           MOVE 'B' TO SA-CODE-SEASON                             
A04070     END-IF.                                                      
                                                                        
A04070 5600-EXIT.                                                       
A04070      EXIT.                                                       
      ******************************************************************        
      **    7030-GET-DAYS-BET-DATES                                   **        
      **                                                              **        
      **  GET NO OF DAYS BETWEEN TWO GIVEN DATES                      **        
      ******************************************************************        
       7030-GET-DAYS-BET-DATES.                                         
                                                                        
           MOVE '7030'                       TO ACTIVE-PARAGRAPH.       
                                                                        
            EXEC SQL                                                    
T34097         SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-WORK-TO-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-TO-DATE
              ) <> 0) OR (LEN(:WS-WORK-TO-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-WORK-TO-DATE
              ), CONVERT(DATE, :WS-WORK-TO-DATE) )) -                     
T34097                  CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                     :WS-WORK-FROM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-FROM-DATE
              ) <> 0) OR (LEN(:WS-WORK-FROM-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-WORK-FROM-DATE
              ), CONVERT(DATE, :WS-WORK-FROM-DATE) )) + 1
            INTO
              :WS-WORK-NO-OF-DAYS              
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET  :WS-WORK-NO-OF-DAYS                                         
MFA-TR*           =  DAYS(DATE(:WS-WORK-TO-DATE)) -                             
MFA-TR*                 DAYS(DATE(:WS-WORK-FROM-DATE)) + 1                      
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 12                        TO RS-RETURN-CODE          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
      *                                                                         
C36929*****************************************************************         
C36929*  CHECK IF ACCOUNT HAS UNMETERED GAS SERVICE                   *         
C36929*****************************************************************         
C36929 7040-CHECK-SERVICE-TYPE.                                         
C36929                                                                  
C36929     MOVE '7920'                  TO ACTIVE-PARAGRAPH.            
C36929                                                                  
C36929     EXEC SQL                                                     
C36929         SELECT 'G'                                               
C36929           INTO :WS-SERVICE-TYPE-FL                               
C36929           FROM CSS_CUST_PLAN CP WITH(READUNCOMMITTED)                    
C36929          WHERE ACCOUNT_NO        = :CP-ACCOUNT-NO                
C36929            AND CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE            
C36929            AND IC_NO             = :CP-IC-NO                     
C36929            AND CODE_SERVICE_TYPE = 'G'                           
C36929                                                           
C36929     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'G'                                                       
MFA-TR*          INTO :WS-SERVICE-TYPE-FL                                       
MFA-TR*          FROM CSS_CUST_PLAN CP                                          
MFA-TR*         WHERE ACCOUNT_NO        = :CP-ACCOUNT-NO                        
MFA-TR*           AND CODE_UTIL_TYPE    = :CP-CODE-UTIL-TYPE                    
MFA-TR*           AND IC_NO             = :CP-IC-NO                             
MFA-TR*           AND CODE_SERVICE_TYPE = 'G'                                   
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36929                                                                  
C36929     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
C36929                                                                  
C36929     EVALUATE WS-ACTIVE-RETURN-CODE                               
C36929         WHEN SUCCESSFUL-CALL                                     
C36929         WHEN -811                                                
C36929              CONTINUE                                            
C36929         WHEN NOT-FOUND                                           
C36929              MOVE 'E'                   TO WS-SERVICE-TYPE-FL    
C36929         WHEN OTHER                                               
C36929              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE        
C36929              MOVE SQLCODE               TO ABEND-SQLCODE         
C36929              MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
C36929              MOVE '7040'                TO ACTIVE-PARAGRAPH      
C36929              MOVE 'SELECT'              TO ABEND-FUNCTION        
C36929              MOVE SPACES                TO ABEND-SQL-PREDICATES  
C36929                                            ABEND-TABLES          
C36929              MOVE 'CSS_CUST_PLAN'       TO TABLE-1               
C36929              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
C36929              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2       
C36929              MOVE 'IC_NO'               TO TABLE-ELEMENT-3       
C36929              MOVE CP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
C36929              MOVE CP-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2     
C36929              MOVE CP-IC-NO              TO HOSTVAR-ELEMENT-3     
C36929              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
C36929     END-EVALUATE.                                                
C36929                                                                  
C36929 7040-EXIT.                                                       
C36929     EXIT.                                                        
C36929*                                                                         
P00131******************************************************************        
P00131*  OPEN THE CURSOR DECLARED FOR CSS_JOB_PARM                     *        
P00131******************************************************************        
P00131*                                                                         
P00131 7050-OPEN-STEPRATES-CUR.                                         
P00131*                                                                         
P00131     MOVE '7050'                       TO ACTIVE-PARAGRAPH.       
P00131*                                                                         
P00131     EXEC SQL                                                     
P00131         OPEN STEPRATES_CUR                                       
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131*                                                                         
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131*                                                                         
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00131           NEXT SENTENCE                                          
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7050'                    TO ACTIVE-PARAGRAPH        
P00131        MOVE 'OPEN'                    TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_JOB_PARM'            TO TABLE-1                 
P00131        MOVE 'PROGRAM_NAME'            TO TABLE-ELEMENT-1         
P00131        MOVE PROGRAM-NAME              TO HOSTVAR-ELEMENT-1       
P00131        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
P00131        MOVE G6-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131*                                                                         
P00131 7050-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131******************************************************************        
P00131*  FETCH THE CURSOR FOR CSS_JOB_PARM                             *        
P00131******************************************************************        
P00131*                                                                         
P00131 7051-FETCH-STEPRATES-CUR.                                        
P00131*                                                                         
P00131     MOVE '7051'                       TO ACTIVE-PARAGRAPH        
P00131*                                                                         
P00131     EXEC SQL                                                     
P00131         FETCH  STEPRATES_CUR                                     
P00131          INTO :G6-PARM-DATA                                      
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131*                                                                         
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131*                                                                         
P00131     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00131         WHEN SUCCESSFUL-CALL                                     
P00131         WHEN NOT-FOUND                                           
P00131              CONTINUE                                            
P00131         WHEN OTHER                                               
P00131              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE        
P00131              MOVE SQLCODE               TO ABEND-SQLCODE         
P00131              MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
P00131              MOVE '7051'                TO ACTIVE-PARAGRAPH      
P00131              MOVE 'FETCH'               TO ABEND-FUNCTION        
P00131              MOVE SPACES                TO ABEND-SQL-PREDICATES  
P00131                                            ABEND-TABLES          
P00131              MOVE 'CSS_JOB_PARM'        TO TABLE-1               
P00131              MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1       
P00131              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2       
P00131              MOVE G6-PROGRAM-NAME       TO HOSTVAR-ELEMENT-1     
P00131              MOVE G6-COMPANY-NO         TO HOSTVAR-ELEMENT-2     
P00131              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P00131     END-EVALUATE.                                                
P00131*                                                                         
P00131 7051-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131******************************************************************        
P00131*  CLOSE THE CURSOR DECLARED ON CSS_JOB_PARM                     *        
P00131******************************************************************        
P00131*                                                                         
P00131 7052-CLOSE-STEPRATES-CUR.                                        
P00131*                                                                         
P00131     MOVE '7052'                       TO ACTIVE-PARAGRAPH        
P00131                                                                  
P00131     EXEC SQL                                                     
P00131         CLOSE STEPRATES_CUR                                      
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131*                                                                         
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131*                                                                         
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00131           NEXT SENTENCE                                          
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7052'                    TO ACTIVE-PARAGRAPH        
P00131        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_JOB_PARM'            TO TABLE-1                 
P00131        MOVE SPACES                    TO TABLE-ELEMENT-1         
P00131        MOVE ZEROES                    TO HOSTVAR-ELEMENT-1       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131*                                                                         
P00131 7052-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131******************************************************************        
P00131*  OPEN THE CURSOR DECLARED FOR CSS_RATE_CREATOR                 *        
P00131******************************************************************        
P00131*                                                                         
P00131 7053-OPEN-RATE-CR-CUR.                                           
P00131*                                                                         
P00131     MOVE '7053'                       TO ACTIVE-PARAGRAPH.       
P00131*                                                                         
P00131     EXEC SQL                                                     
P00131         OPEN RATE_CR_CUR                                         
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131*                                                                         
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131*                                                                         
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00131           NEXT SENTENCE                                          
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7053'                    TO ACTIVE-PARAGRAPH        
P00131        MOVE 'OPEN'                    TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
P00131        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
P00131        MOVE RT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
P00131        MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
P00131        MOVE RT-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131*                                                                         
P00131 7053-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131******************************************************************        
P00131*  FETCH THE CURSOR FOR CSS_RATE_CREATOR                         *        
P00131******************************************************************        
P00131*                                                                         
P00131 7054-FETCH-RATE-CR-CUR.                                          
P00131*                                                                         
P00131     MOVE '7054'                       TO ACTIVE-PARAGRAPH.       
P00131*                                                                         
P00131     EXEC SQL                                                     
P00131         FETCH  RATE_CR_CUR                                       
P00131          INTO :RT-VERSION-NO-CNTRL                               
P00131              ,:RT-FROM-EFFECTIVE-DT                              
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131*                                                                         
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131*                                                                         
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00131        NEXT SENTENCE                                             
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7054'                    TO ACTIVE-PARAGRAPH        
P00131        MOVE 'FETCH'                   TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
P00131        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
P00131        MOVE RT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
P00131        MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
P00131        MOVE RT-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131*                                                                         
P00131 7054-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131******************************************************************        
P00131*  CLOSE THE CURSOR DECLARED ON CSS_RATE_CREATOR                 *        
P00131******************************************************************        
P00131*                                                                         
P00131 7055-CLOSE-RATE-CR-CUR.                                          
P00131*                                                                         
P00131     MOVE '7055'                       TO ACTIVE-PARAGRAPH        
P00131*                                                                         
P00131     EXEC SQL                                                     
P00131         CLOSE RATE_CR_CUR                                        
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131*                                                                         
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131*                                                                         
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00131           NEXT SENTENCE                                          
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7055'                    TO ACTIVE-PARAGRAPH        
P00131        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
P00131        MOVE SPACES                    TO TABLE-ELEMENT-1         
P00131        MOVE ZEROES                    TO HOSTVAR-ELEMENT-1       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131*                                                                         
P00131 7055-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131******************************************************************        
P00131*  OPEN THE CURSOR DECLARED FOR CSS_PRICE_SCHED                  *        
P00131******************************************************************        
P00131*                                                                         
P00131 7056-OPEN-PRICE-SCHED.                                           
P00131*                                                                         
P00131     MOVE '7056'                       TO ACTIVE-PARAGRAPH.       
P00131*                                                                         
P00131     EXEC SQL                                                     
P00131         OPEN PRICE_SCHED                                         
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131*                                                                         
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131*                                                                         
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00131           NEXT SENTENCE                                          
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7056'                    TO ACTIVE-PARAGRAPH        
P00131        MOVE 'OPEN'                    TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_PRICE_SCHED'         TO TABLE-1                 
P00131        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
P00131        MOVE PS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
P00131        MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
P00131        MOVE PS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131*                                                                         
P00131 7056-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131******************************************************************        
P00131*  FETCH THE CURSOR FOR CSS_PRICE_SCHED                          *        
P00131******************************************************************        
P00131*                                                                         
P00131 7057-FETCH-PRICE-SCHED.                                          
P00131*                                                                         
P00131     MOVE '7057'                       TO ACTIVE-PARAGRAPH.       
P00131*                                                                         
P00131     EXEC SQL                                                     
P00131         FETCH  PRICE_SCHED                                       
P00131          INTO :PS-BLOCK-NO                                       
P00131              ,:PS-BLOCK-USE-OR-SVCS                              
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131*                                                                         
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131*                                                                         
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00131        NEXT SENTENCE                                             
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7057'                    TO ACTIVE-PARAGRAPH        
P00131        MOVE 'FETCH'                   TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_PRICE_SCHED'         TO TABLE-1                 
P00131        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
P00131        MOVE PS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
P00131        MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
P00131        MOVE PS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131*                                                                         
P00131 7057-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131******************************************************************        
P00131*  CLOSE THE CURSOR DECLARED ON CSS_PRICE_SCHED                  *        
P00131******************************************************************        
P00131*                                                                         
P00131 7058-CLOSE-PRICE-SCHED.                                          
P00131*                                                                         
P00131     MOVE '7058'                       TO ACTIVE-PARAGRAPH        
P00131*                                                                         
P00131     EXEC SQL                                                     
P00131         CLOSE PRICE_SCHED                                        
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131*                                                                         
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131*                                                                         
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00131           NEXT SENTENCE                                          
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7058'                    TO ACTIVE-PARAGRAPH        
P00131        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_PRICE_SCHED'         TO TABLE-1                 
P00131        MOVE SPACES                    TO TABLE-ELEMENT-1         
P00131        MOVE ZEROES                    TO HOSTVAR-ELEMENT-1       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131*                                                                         
P00131 7058-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
P00131******************************************************************        
P00131*  GET THE COUNT OF QUALIFIED RATE VERSIONS FOR GIVEN DATES      *        
P00131******************************************************************        
P00131*                                                                         
P00131 7400-SELECT-RT-VERS.                                             
P00131*                                                                         
P00131     MOVE '7100'                       TO ACTIVE-PARAGRAPH        
P00131*                                                                         
P00131     EXEC SQL                                                     
P00131         SELECT                                                   
P00131                COUNT(*)                                          
P00131           INTO                                                   
P00131                :WS-RT-VER-CNT                                    
P00131           FROM                                                   
P00131                CSS_RATE_CREATOR RT                               
P00131          WHERE                                                   
P00131                CODE_UTIL_TYPE   = :RT-CODE-UTIL-TYPE             
P00131            AND RATE_PLAN_NO     = :RT-RATE-PLAN-NO               
P00131            AND FROM_EFFECTIVE_DT BETWEEN                         
P00131                IIF(TRY_CONVERT(DATE, :WS-RATE-EFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RATE-EFF-DATE
              ) <> 0) OR (LEN(:WS-RATE-EFF-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-RATE-EFF-DATE
              ), CONVERT(DATE, :WS-RATE-EFF-DATE) ) AND 
              IIF(TRY_CONVERT(DATE, :WS-CNS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-END-DATE
              ) <> 0) OR (LEN(:WS-CNS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CNS-END-DATE
              ), CONVERT(DATE, :WS-CNS-END-DATE) )            
P00131     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*               COUNT(*)                                                  
MFA-TR*          INTO                                                           
MFA-TR*               :WS-RT-VER-CNT                                            
MFA-TR*          FROM                                                           
MFA-TR*               CSS_RATE_CREATOR RT                                       
MFA-TR*         WHERE                                                           
MFA-TR*               CODE_UTIL_TYPE   = :RT-CODE-UTIL-TYPE                     
MFA-TR*           AND RATE_PLAN_NO     = :RT-RATE-PLAN-NO                       
MFA-TR*           AND FROM_EFFECTIVE_DT BETWEEN                                 
MFA-TR*               :WS-RATE-EFF-DATE AND :WS-CNS-END-DATE                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131*                                                                         
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131*                                                                         
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00131        IF WS-RT-VER-CNT > 1                                      
P00131           SET  RT-VERS-EXIST          TO TRUE                    
P00131        ELSE                                                      
P00131           SET  RT-VERS-NO             TO TRUE                    
P00131        END-IF                                                    
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7400'                    TO ACTIVE-PARAGRAPH        
P00131        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
P00131        MOVE 'RT-CODE-UTIL-TYPE'       TO TABLE-ELEMENT-1         
P00131        MOVE RT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
P00131        MOVE 'RT-RATE-PLAN-NO'         TO TABLE-ELEMENT-2         
P00131        MOVE RT-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131*                                                                         
P00131 7400-EXIT.                                                       
P00131     EXIT.                                                        
P00131*                                                                         
      ******************************************************************        
      **    7900-GET-BILL-COG-DATE                                    **        
      **                                                              **        
      **  GET THE START REVENUE MONHT TO CALCULATE THE DEFERRED COST  **        
      **  OF GAS PERCENTAGE                                           **        
      ******************************************************************        
       7900-GET-BILL-COG-DATE.                                          
                                                                        
           MOVE '7900'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT PARM_DATA                                         
                 INTO :WS-PARM-DATA                                     
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME    = 'BILCOGDATE'                    
                  AND COMPANY_NO      = :BG-COMPANY-NO                  
                  AND CMND_CODE       = :WS-CMND-CODE                   
                  AND SEQ_NO          = +0010                           
                  AND STATUS          = 'A'                             
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PARM_DATA                                                 
MFA-TR*          INTO :WS-PARM-DATA                                             
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME    = 'BILCOGDATE'                            
MFA-TR*           AND COMPANY_NO      = :BG-COMPANY-NO                          
MFA-TR*           AND CMND_CODE       = :WS-CMND-CODE                           
MFA-TR*           AND SEQ_NO          = +0010                                   
MFA-TR*           AND STATUS          = 'A'                                     
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7900'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_JOB_PARM'            TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE ZEROES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       7900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **    7910-OPEN-BG-CURSOR                                       **        
      **                                                              **        
      **  OPEN THE CURSOR DECLARED FOR CSS_BILLING_DET TABLE. THIS    **        
      **  CURSOR IS USED TO REBILL ALL EXISTING BGS FOR A GIVEN UTIL  **        
      **  TYPE                                                        **        
      ******************************************************************        
       7910-OPEN-BG-CURSOR.                                             
                                                                        
           MOVE '7910'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               OPEN BG_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7910'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE ZEROES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7920-FETCH-BG-CURSOR                                      **        
      **                                                              **        
      **  FETCH THE CURSOR DECLARED FOR CSS_BILLING_DET TABLE.        **        
      **  CURSOR IS USED TO REBILL ALL EXISTING BGS FOR A GIVEN UTIL  **        
      **  TYPE                                                        **        
      ******************************************************************        
       7920-FETCH-BG-CURSOR.                                            
                                                                        
           MOVE '7920'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               FETCH BG_CURSOR                                          
                    INTO :BG-ACCOUNT-NO,
                :BG-BILL-NO,
                :BG-CODE-UTIL-TYPE,
                :BG-IC-NO,
                :BG-BILL-ITEM-TIMESTMP,
                :BG-DATE-ORIG-BILL :WS-DATE-ORIG-BILL-NULL,
                :BG-AMT-BILL-ITEM,
                :BG-CODE-BILL-CALC,
                :BG-CODE-BILL-ITM-TYPE,
                :BG-CODE-BILL-ITM-IND,
                :BG-RATE-PLAN-NO,
                :BG-REVENUE-MONTH,
                :BG-NO-OF-CONS-DAYS,
                :BG-REV-MTH-ORIG-BILL                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ064
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH BG_CURSOR                                                  
MFA-TR*             INTO :BG-ACCOUNT-NO,                                        
MFA-TR*                  :BG-BILL-NO,                                           
MFA-TR*                  :BG-CODE-UTIL-TYPE,                                    
MFA-TR*                  :BG-IC-NO,                                             
MFA-TR*                  :BG-BILL-ITEM-TIMESTMP,                                
MFA-TR*                  :BG-DATE-ORIG-BILL:WS-DATE-ORIG-BILL-NULL,             
MFA-TR*                  :BG-AMT-BILL-ITEM,                                     
MFA-TR*                  :BG-CODE-BILL-CALC,                                    
MFA-TR*                  :BG-CODE-BILL-ITM-TYPE,                                
MFA-TR*                  :BG-CODE-BILL-ITM-IND,                                 
MFA-TR*                  :BG-RATE-PLAN-NO,                                      
MFA-TR*                  :BG-REVENUE-MONTH,                                     
MFA-TR*                  :BG-NO-OF-CONS-DAYS,                                   
MFA-TR*                  :BG-REV-MTH-ORIG-BILL,                                 
MFA-TR*                  :CX-DATE-READ                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-RETURN-CODE-NUM      
                                                BG-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              IF WS-DATE-ORIG-BILL-NULL < 0                             
                 MOVE LOW-VALUES             TO BG-DATE-ORIG-BILL       
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7920'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7440-CLOSE-BG-CURSOR                                      **        
      **                                                              **        
      **  CLOSE THE CURSOR DECLARED FOR CSS_BILLING_DET TABLE.        **        
      **  CURSOR IS USED TO REBILL ALL EXISTING BGS FOR A GIVEN UTIL  **        
      **  TYPE                                                        **        
      ******************************************************************        
       7930-CLOSE-BG-CURSOR.                                            
                                                                        
           MOVE '7930'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               CLOSE BG_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7940-SELECT-RATE-DETAILS                                  **        
      **                                                              **        
      **  GET THE PRORATE CODE FOR THE RATE PLAN                      **        
      ******************************************************************        
       7940-SELECT-RATE-DETAILS.                                        
                                                                        
           MOVE '7940'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT VERS_PRORATE_CD                                   
                 INTO :RD-VERS-PRORATE-CD                               
                 FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                  
                WHERE RATE_PLAN_NO     = :BG-RATE-PLAN-NO               
                  AND CODE_UTIL_TYPE   = :BG-CODE-UTIL-TYPE             
T34097                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VERS_PRORATE_CD                                           
MFA-TR*          INTO :RD-VERS-PRORATE-CD                                       
MFA-TR*          FROM CSS_RATE_PLAN_DESC                                        
MFA-TR*         WHERE RATE_PLAN_NO     = :BG-RATE-PLAN-NO                       
MFA-TR*           AND CODE_UTIL_TYPE   = :BG-CODE-UTIL-TYPE                     
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7940'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'RATE-PLAN-NO'            TO TABLE-ELEMENT-1         
              MOVE BG-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7950-SELECT-CX-END-DATE                                   **        
      **                                                              **        
      **  GET THE CONSUMPTION END DATE                                **        
      ******************************************************************        
       7950-SELECT-CX-END-DATE.                                         
                                                                        
           MOVE '7950'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT MAX(CX.DATE_READ)                                 
                 INTO :CX-DATE-READ                                     
                 FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                 
                WHERE CX.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND CX.BILL_NO            = :BG-BILL-NO               
                  AND CX.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND CX.IC_NO              = :BG-IC-NO                 
                  AND CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )    
T34097                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(CX.DATE_READ)                                         
MFA-TR*          INTO :CX-DATE-READ                                             
MFA-TR*          FROM CSS_CNSMPTN_HIST CX                                       
MFA-TR*         WHERE CX.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND CX.BILL_NO            = :BG-BILL-NO                       
MFA-TR*           AND CX.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND CX.IC_NO              = :BG-IC-NO                         
MFA-TR*           AND CX.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP            
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7950'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
A02036        MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7960-SELECT-CX-START-DATE                                 **        
      **                                                              **        
      **  GET THE CONSUMPTION START DATE                              **        
      ******************************************************************        
       7960-SELECT-CX-START-DATE.                                       
                                                                        
           MOVE '7320'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
T34097         SELECT
              DATEADD( DAY, 1, DATEADD( DAY, -:BG-NO-OF-CONS-DAYS, 
              IIF(TRY_CONVERT(DATE, :WS-CNS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-END-DATE
              ) <> 0) OR (LEN(:WS-CNS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CNS-END-DATE
              ), CONVERT(DATE, :WS-CNS-END-DATE) ) ) )
            INTO
              :WS-CNS-START-DATE              
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET  :WS-CNS-START-DATE   =                                      
MFA-TR*             DATE(:WS-CNS-END-DATE)                                      
MFA-TR*                - :BG-NO-OF-CONS-DAYS DAYS + 1 DAYS                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7960'                    TO ACTIVE-PARAGRAPH        
T34097        MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CNS-END-DATE'            TO TABLE-ELEMENT-1         
              MOVE WS-CNS-END-DATE           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       7960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7970-SELECT-BILLED-UNITS                                  **        
      **                                                              **        
      **  GET THE BILLED UNITS FROM CSS_BILL_CALC_DET                 **        
      ******************************************************************        
       7970-SELECT-BILLED-UNITS.                                        
                                                                        
           MOVE '7400'                       TO ACTIVE-PARAGRAPH        
                                                                        
           EXEC SQL                                                     
               SELECT SUM(BILL_UNITS)                                   
                     ,SUM(READ_UNITS)                                   
P00131           INTO :BZ-BILL-UNITS :WS-BILL-UNITS-NULL                
P00131               ,:BZ-READ-UNITS :WS-READ-UNITS-NULL                
                 FROM CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED)                
                WHERE BZ.ACCOUNT_NO           = :BG-ACCOUNT-NO          
                  AND BZ.BILL_NO              = :BG-BILL-NO             
                  AND BZ.CODE_UTIL_TYPE       = :BG-CODE-UTIL-TYPE      
                  AND BZ.IC_NO                = :BG-IC-NO               
                  AND BZ.BILL_ITEM_TIMESTMP   = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )  
                  AND BZ. INSTR_USE_TYPE_CD   = 'R'                     
T34097                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(BILL_UNITS)                                           
MFA-TR*              ,SUM(READ_UNITS)                                           
MFA-TR*          INTO :BZ-BILL-UNITS :WS-BILL-UNITS-NULL                        
MFA-TR*              ,:BZ-READ-UNITS :WS-READ-UNITS-NULL                        
MFA-TR*          FROM CSS_BILL_CALC_DET BZ                                      
MFA-TR*         WHERE BZ.ACCOUNT_NO           = :BG-ACCOUNT-NO                  
MFA-TR*           AND BZ.BILL_NO              = :BG-BILL-NO                     
MFA-TR*           AND BZ.CODE_UTIL_TYPE       = :BG-CODE-UTIL-TYPE              
MFA-TR*           AND BZ.IC_NO                = :BG-IC-NO                       
MFA-TR*           AND BZ.BILL_ITEM_TIMESTMP   = :BG-BILL-ITEM-TIMESTMP          
MFA-TR*           AND BZ. INSTR_USE_TYPE_CD   = 'R'                             
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00131        IF WS-BILL-UNITS-NULL < 0                                 
P00131           MOVE ZEROES                 TO BZ-BILL-UNITS           
P00131        END-IF                                                    
P00131        IF WS-READ-UNITS-NULL < 0                                 
P00131           MOVE ZEROES                 TO BZ-READ-UNITS           
P00131        END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7970'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
A02036        MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       7970-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7980-SEL-BKOUT-BILLED-UNITS                               **        
      **                                                              **        
      **  GET THE BILLED UNITS FOR THE BACKOUT ROW                    **        
      ******************************************************************        
       7980-SEL-BKOUT-BILLED-UNITS.                                     
                                                                        
           MOVE '7600'                       TO ACTIVE-PARAGRAPH        
                                                                        
           EXEC SQL                                                     
               SELECT SUM(BILL_UNITS)                                   
                     ,SUM(READ_UNITS)                                   
C36929           INTO :BZ-BILL-UNITS :WS-BILL-UNITS-NULL                
C36929               ,:BZ-READ-UNITS :WS-READ-UNITS-NULL                
                 FROM CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED)                
                WHERE BZ.ACCOUNT_NO            = :BG-ACCOUNT-NO         
                  AND BZ.CODE_UTIL_TYPE        = :BG-CODE-UTIL-TYPE     
                  AND BZ.IC_NO                 = :BG-IC-NO              
                  AND BZ.BILL_ITEM_TIMESTMP    = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              ) 
                  AND BZ.INSTR_USE_TYPE_CD     = 'R'                    
T34097                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(BILL_UNITS)                                           
MFA-TR*              ,SUM(READ_UNITS)                                           
MFA-TR*          INTO :BZ-BILL-UNITS :WS-BILL-UNITS-NULL                        
MFA-TR*              ,:BZ-READ-UNITS :WS-READ-UNITS-NULL                        
MFA-TR*          FROM CSS_BILL_CALC_DET BZ                                      
MFA-TR*         WHERE BZ.ACCOUNT_NO            = :BG-ACCOUNT-NO                 
MFA-TR*           AND BZ.CODE_UTIL_TYPE        = :BG-CODE-UTIL-TYPE             
MFA-TR*           AND BZ.IC_NO                 = :BG-IC-NO                      
MFA-TR*           AND BZ.BILL_ITEM_TIMESTMP    = :BG-BILL-ITEM-TIMESTMP         
MFA-TR*           AND BZ.INSTR_USE_TYPE_CD     = 'R'                            
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
C36929     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C36929        IF WS-BILL-UNITS-NULL < 0                                 
C36929           MOVE ZEROES                 TO BZ-BILL-UNITS           
C36929        END-IF                                                    
C36929        IF WS-READ-UNITS-NULL < 0                                 
C36929           MOVE ZEROES                 TO BZ-READ-UNITS           
C36929        END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       7980-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7990-SELECT-COG-VERS-EXIST                                **        
      ******************************************************************        
       7990-SELECT-COG-VERS-EXIST.                                      
                                                                        
           MOVE '7990'                       TO ACTIVE-PARAGRAPH        
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-COUNT                                         
                 FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)               
                WHERE SA.FACTOR_ID             = :SA-FACTOR-ID          
P00131            AND SA.BLOCK_NO              = 0                      
                  AND SA.CODE_STATUS           IN ('A','I')             
                  AND SA.INSTR_USE_TYPE_CD     = 'R'                    
A04070            AND SA.CODE_SEASON           = :SA-CODE-SEASON        
                  AND SA.CODE_UTIL_TYPE        = :BG-CODE-UTIL-TYPE     
                  AND SA.RATE_PLAN_NO          = :BG-RATE-PLAN-NO       
                  AND ((SA.DATE_FROM          <= IIF(TRY_CONVERT(DATE, 
                                                     :WS-CNS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-START-DATE
              ) <> 0) OR (LEN(:WS-CNS-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CNS-START-DATE
              ), CONVERT(DATE, :WS-CNS-START-DATE) )     
                        AND  SA.DATE_TO       >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-CNS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-START-DATE
              ) <> 0) OR (LEN(:WS-CNS-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CNS-START-DATE
              ), CONVERT(DATE, :WS-CNS-START-DATE) ))    
                                         OR                             
                       (SA.DATE_FROM          >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-CNS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-START-DATE
              ) <> 0) OR (LEN(:WS-CNS-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CNS-START-DATE
              ), CONVERT(DATE, :WS-CNS-START-DATE) )     
                        AND SA.DATE_TO        <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CNS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-END-DATE
              ) <> 0) OR (LEN(:WS-CNS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CNS-END-DATE
              ), CONVERT(DATE, :WS-CNS-END-DATE) ))      
                                         OR                             
                       (SA.DATE_FROM          <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CNS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-END-DATE
              ) <> 0) OR (LEN(:WS-CNS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CNS-END-DATE
              ), CONVERT(DATE, :WS-CNS-END-DATE) )       
                        AND SA.DATE_TO        >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CNS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-END-DATE
              ) <> 0) OR (LEN(:WS-CNS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CNS-END-DATE
              ), CONVERT(DATE, :WS-CNS-END-DATE) )))     
T34097                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-COUNT                                                 
MFA-TR*          FROM CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*         WHERE SA.FACTOR_ID             = :SA-FACTOR-ID                  
MFA-TR*           AND SA.BLOCK_NO              = 0                              
MFA-TR*           AND SA.CODE_STATUS           IN ('A','I')                     
MFA-TR*           AND SA.INSTR_USE_TYPE_CD     = 'R'                            
MFA-TR*           AND SA.CODE_SEASON           = :SA-CODE-SEASON                
MFA-TR*           AND SA.CODE_UTIL_TYPE        = :BG-CODE-UTIL-TYPE             
MFA-TR*           AND SA.RATE_PLAN_NO          = :BG-RATE-PLAN-NO               
MFA-TR*           AND ((SA.DATE_FROM          <= :WS-CNS-START-DATE             
MFA-TR*                 AND  SA.DATE_TO       >= :WS-CNS-START-DATE)            
MFA-TR*                                  OR                                     
MFA-TR*                (SA.DATE_FROM          >= :WS-CNS-START-DATE             
MFA-TR*                 AND SA.DATE_TO        <= :WS-CNS-END-DATE)              
MFA-TR*                                  OR                                     
MFA-TR*                (SA.DATE_FROM          <= :WS-CNS-END-DATE               
MFA-TR*                 AND SA.DATE_TO        >= :WS-CNS-END-DATE))             
MFA-TR*                 WITH UR                                                 
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-COUNT > 1                                           
                 MOVE 'Y'                    TO WS-VERS-EXIST-FL        
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7990'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'FACTOR-ID'               TO TABLE-ELEMENT-1         
              MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-1       
P00131        MOVE 'BLOCK-NO'                TO TABLE-ELEMENT-2         
P00131        MOVE '1'                       TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       7990-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00131******************************************************************        
P00131**    7990A-SELECT-COG-VERS-EXIST                               **        
P00131******************************************************************        
P00131**                                                              **        
P00131 7990A-SELECT-COG-VERS-EXIST.                                     
P00131                                                                  
P00131     MOVE '7900A'                       TO ACTIVE-PARAGRAPH       
P00131                                                                  
P00131     EXEC SQL                                                     
P00131         SELECT COUNT(*)                                          
P00131           INTO :WS-COUNT                                         
P00131           FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)               
P00131          WHERE SA.FACTOR_ID             = :SA-FACTOR-ID          
P00131            AND SA.BLOCK_NO              = 1                      
P00131            AND SA.CODE_STATUS           IN ('A','I')             
P00131            AND SA.INSTR_USE_TYPE_CD     = 'R'                    
P00131            AND SA.CODE_UTIL_TYPE        = :BG-CODE-UTIL-TYPE     
P00131            AND SA.RATE_PLAN_NO          = :BG-RATE-PLAN-NO       
P00131            AND ((SA.DATE_FROM          <= IIF(TRY_CONVERT(DATE, 
                                                     :WS-CNS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-START-DATE
              ) <> 0) OR (LEN(:WS-CNS-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CNS-START-DATE
              ), CONVERT(DATE, :WS-CNS-START-DATE) )     
P00131                  AND  SA.DATE_TO       >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-CNS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-START-DATE
              ) <> 0) OR (LEN(:WS-CNS-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CNS-START-DATE
              ), CONVERT(DATE, :WS-CNS-START-DATE) ))    
P00131                                   OR                             
P00131                 (SA.DATE_FROM          >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-CNS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-START-DATE
              ) <> 0) OR (LEN(:WS-CNS-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CNS-START-DATE
              ), CONVERT(DATE, :WS-CNS-START-DATE) )     
P00131                  AND SA.DATE_TO        <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CNS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-END-DATE
              ) <> 0) OR (LEN(:WS-CNS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CNS-END-DATE
              ), CONVERT(DATE, :WS-CNS-END-DATE) ))      
P00131                                   OR                             
P00131                 (SA.DATE_FROM          <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CNS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-END-DATE
              ) <> 0) OR (LEN(:WS-CNS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CNS-END-DATE
              ), CONVERT(DATE, :WS-CNS-END-DATE) )       
P00131                  AND SA.DATE_TO        >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CNS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-END-DATE
              ) <> 0) OR (LEN(:WS-CNS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CNS-END-DATE
              ), CONVERT(DATE, :WS-CNS-END-DATE) )))     
P00131                                                           
P00131     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-COUNT                                                 
MFA-TR*          FROM CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*         WHERE SA.FACTOR_ID             = :SA-FACTOR-ID                  
MFA-TR*           AND SA.BLOCK_NO              = 1                              
MFA-TR*           AND SA.CODE_STATUS           IN ('A','I')                     
MFA-TR*           AND SA.INSTR_USE_TYPE_CD     = 'R'                            
MFA-TR*           AND SA.CODE_UTIL_TYPE        = :BG-CODE-UTIL-TYPE             
MFA-TR*           AND SA.RATE_PLAN_NO          = :BG-RATE-PLAN-NO               
MFA-TR*           AND ((SA.DATE_FROM          <= :WS-CNS-START-DATE             
MFA-TR*                 AND  SA.DATE_TO       >= :WS-CNS-START-DATE)            
MFA-TR*                                  OR                                     
MFA-TR*                (SA.DATE_FROM          >= :WS-CNS-START-DATE             
MFA-TR*                 AND SA.DATE_TO        <= :WS-CNS-END-DATE)              
MFA-TR*                                  OR                                     
MFA-TR*                (SA.DATE_FROM          <= :WS-CNS-END-DATE               
MFA-TR*                 AND SA.DATE_TO        >= :WS-CNS-END-DATE))             
MFA-TR*                 WITH UR                                                 
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131                                                                  
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131                                                                  
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00131        IF WS-COUNT > 1                                           
P00131           MOVE 'Y'                    TO WS-VERS-EXIST-FL        
P00131        END-IF                                                    
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7990A'                   TO ACTIVE-PARAGRAPH        
P00131        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
P00131        MOVE 'FACTOR-ID'               TO TABLE-ELEMENT-1         
P00131        MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-1       
P00131        MOVE 'BLOCK-NO'                TO TABLE-ELEMENT-2         
P00131        MOVE '1'                       TO HOSTVAR-ELEMENT-1       
P00131       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT              
P00131     END-IF                                                       
P00131     .                                                            
P00131 7990A-EXIT.                                                      
P00131     EXIT.                                                        
                                                                        
       7911-OPEN-COG-CURSOR.                                            
                                                                        
      ******************************************************************        
      *  OPEN THE CURSOR DECLARED FOR CSS_SPCL_FCTR_APPL               *        
      ******************************************************************        
                                                                        
           MOVE '7911'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               OPEN COG_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7911'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE ZEROES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7911-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7912-FETCH-COG-CURSOR.                                           
                                                                        
      ******************************************************************        
      *  FETCH THE CURSOR FOR CSS_SPCL_FCTR_APPL                       *        
      ******************************************************************        
                                                                        
           MOVE '7912'                       TO ACTIVE-PARAGRAPH        
                                                                        
           EXEC SQL                                                     
               FETCH  COG_CURSOR                                        
                INTO :SA-FACTOR,                                        
                     :SA-BLOCK-NO,                                      
                     :SA-DATE-FROM,                                     
                     :SA-DATE-TO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
ACT041        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
ACT041           INITIALIZE SA-FACTOR                                   
ACT041                      SA-BLOCK-NO                                 
ACT041                      SA-DATE-FROM                                
ACT041                      SA-DATE-TO                                  
ACT041        END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7912'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'START-DATE'              TO TABLE-ELEMENT-1         
              MOVE 'END-DATE'                TO TABLE-ELEMENT-2         
              MOVE WS-CNS-START-DATE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-CNS-END-DATE           TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7912-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7913-CLOSE-COG-CURSOR.                                           
                                                                        
      ******************************************************************        
      *  CLOSE THE CURSOR DECLARED ON CSS_SPCL_FCTR_APPL               *        
      ******************************************************************        
                                                                        
           MOVE '7913'                       TO ACTIVE-PARAGRAPH        
                                                                        
           EXEC SQL                                                     
               CLOSE COG_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7913'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE ZEROES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7913-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
P00131 7911A-OPEN-COG-CURSOR.                                           
P00131                                                                  
P00131                                                                  
P00131     MOVE '7911A'                       TO ACTIVE-PARAGRAPH.      
P00131                                                                  
P00131     EXEC SQL                                                     
P00131         OPEN COG_CURSOR_OLD                                      
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131                                                                  
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131                                                                  
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00131           NEXT SENTENCE                                          
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7911A'                   TO ACTIVE-PARAGRAPH        
P00131        MOVE 'OPEN'                    TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
P00131        MOVE SPACES                    TO TABLE-ELEMENT-1         
P00131        MOVE ZEROES                    TO HOSTVAR-ELEMENT-1       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131                                                                  
P00131 7911A-EXIT.                                                      
P00131     EXIT.                                                        
HPCCDM*    EJECT                                                        
P00131                                                                  
P00131 7912A-FETCH-COG-CURSOR.                                          
P00131                                                                  
P00131******************************************************************        
P00131*  FETCH THE CURSOR FOR CSS_SPCL_FCTR_APPL                       *        
P00131******************************************************************        
P00131                                                                  
P00131     MOVE '7912A'                      TO ACTIVE-PARAGRAPH        
P00131                                                                  
P00131     EXEC SQL                                                     
P00131         FETCH  COG_CURSOR_OLD                                    
P00131          INTO :SA-FACTOR,                                        
P00131               :SA-DATE-FROM,                                     
P00131               :SA-DATE-TO                                        
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131                                                                  
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131                                                                  
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
P00131        WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
ACT041        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
ACT041           INITIALIZE SA-FACTOR                                   
ACT041                      SA-DATE-FROM                                
ACT041                      SA-DATE-TO                                  
ACT041        END-IF                                                    
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7912A'                   TO ACTIVE-PARAGRAPH        
P00131        MOVE 'FETCH'                   TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
P00131        MOVE 'START-DATE'              TO TABLE-ELEMENT-1         
P00131        MOVE 'END-DATE'                TO TABLE-ELEMENT-2         
P00131        MOVE WS-CNS-START-DATE         TO HOSTVAR-ELEMENT-1       
P00131        MOVE WS-CNS-END-DATE           TO HOSTVAR-ELEMENT-2       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131                                                                  
P00131 7912A-EXIT.                                                      
P00131     EXIT.                                                        
HPCCDM*    EJECT                                                        
P00131                                                                  
P00131 7913A-CLOSE-COG-CURSOR.                                          
P00131                                                                  
P00131******************************************************************        
P00131*  CLOSE THE CURSOR DECLARED ON CSS_SPCL_FCTR_APPL               *        
P00131******************************************************************        
P00131                                                                  
P00131     MOVE '7913A'                      TO ACTIVE-PARAGRAPH        
P00131                                                                  
P00131     EXEC SQL                                                     
P00131         CLOSE COG_CURSOR_OLD                                     
P00131     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131                                                                  
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131                                                                  
P00131     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00131           NEXT SENTENCE                                          
P00131     ELSE                                                         
P00131        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
P00131        MOVE SQLCODE                   TO ABEND-SQLCODE           
P00131        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00131        MOVE '7913A'                   TO ACTIVE-PARAGRAPH        
P00131        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
P00131        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00131                                          ABEND-TABLES            
P00131        MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
P00131        MOVE SPACES                    TO TABLE-ELEMENT-1         
P00131        MOVE ZEROES                    TO HOSTVAR-ELEMENT-1       
P00131        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00131     END-IF.                                                      
P00131                                                                  
P00131 7913A-EXIT.                                                      
P00131     EXIT.                                                        
HPCCDM*    EJECT                                                        
      ******************************************************************        
      **    7914-SELECT-UM-END-DATE                                   **        
      **                                                              **        
      **  GET THE END DATE FOR UNMETERED USAGE                        **        
      ******************************************************************        
       7914-SELECT-UM-END-DATE.                                         
                                                                        
           MOVE '7914'                       TO ACTIVE-PARAGRAPH        
                                                                        
           EXEC SQL                                                     
               SELECT MAX(DATE_USAGE_ENDS)                              
                 INTO :UC-DATE-USAGE-ENDS                               
                 FROM CSS_UM_CNSMPT_HIST UC WITH(READUNCOMMITTED)               
                WHERE UC.ACCOUNT_NO            = :BG-ACCOUNT-NO         
                  AND UC.CODE_UTIL_TYPE        = :BG-CODE-UTIL-TYPE     
                  AND UC.IC_NO                 = :BG-IC-NO              
                  AND UC.BILL_ITEM_TIMESTMP    = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              ) 
T34097                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(DATE_USAGE_ENDS)                                      
MFA-TR*          INTO :UC-DATE-USAGE-ENDS                                       
MFA-TR*          FROM CSS_UM_CNSMPT_HIST UC                                     
MFA-TR*         WHERE UC.ACCOUNT_NO            = :BG-ACCOUNT-NO                 
MFA-TR*           AND UC.CODE_UTIL_TYPE        = :BG-CODE-UTIL-TYPE             
MFA-TR*           AND UC.IC_NO                 = :BG-IC-NO                      
MFA-TR*           AND UC.BILL_ITEM_TIMESTMP    = :BG-BILL-ITEM-TIMESTMP         
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7700'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_UM_CNSMPT_DET'       TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
A02036        MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       7914-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  CHECK IF ACCOUNT HAS RATE VALID FOR COST OF AGS CALCULATION  *         
      *****************************************************************         
       7915-CHECK-VALID-RATE.                                           
                                                                        
           MOVE '7915'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-VALID-RATE-FL                                 
                 FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE   = :BG-CODE-UTIL-TYPE             
                  AND RATE_PLAN_NO     = :BG-RATE-PLAN-NO               
                  AND COMPANY_NO       = :BG-COMPANY-NO                 
C36929            AND DEFERRED_COG_FL  = 'Y'                            
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-VALID-RATE-FL                                         
MFA-TR*          FROM CSS_RATE_PLAN_DESC                                        
MFA-TR*         WHERE CODE_UTIL_TYPE   = :BG-CODE-UTIL-TYPE                     
MFA-TR*           AND RATE_PLAN_NO     = :BG-RATE-PLAN-NO                       
MFA-TR*           AND COMPANY_NO       = :BG-COMPANY-NO                         
MFA-TR*           AND DEFERRED_COG_FL  = 'Y'                                    
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET NOT-VALID-RATE       TO TRUE                       
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7915'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'RATE-PLAN-NO'            TO TABLE-ELEMENT-1         
              MOVE BG-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7915-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  GET SUMMER SEASON DATES                                      *         
      *****************************************************************         
A04070 7916-GET-SEASON-DATE.                                            
           MOVE '7916'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
                SELECT CODE_SEASON                                      
                      ,DATE_FROM                                        
                      ,DATE_TO                                          
                INTO  :RS-CODE-SEASON                                   
                     ,:RS-DATE-FROM                                     
                     ,:RS-DATE-TO                                       
                FROM  CSS_RATE_USE_SEASN RS WITH(READUNCOMMITTED)               
                WHERE CODE_UTIL_TYPE   = :BG-CODE-UTIL-TYPE             
                AND   RATE_PLAN_NO     = :BG-RATE-PLAN-NO               
                AND   VERSION_NO_CNTRL =                                
                       (SELECT MAX(VERSION_NO_CNTRL)                    
                        FROM   CSS_RATE_USE_SEASN RS1
                           WITH(READUNCOMMITTED)                   
                        WHERE RS1.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE   
                        AND   RS1.RATE_PLAN_NO   = :BG-RATE-PLAN-NO)    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CODE_SEASON                                              
MFA-TR*               ,DATE_FROM                                                
MFA-TR*               ,DATE_TO                                                  
MFA-TR*         INTO  :RS-CODE-SEASON                                           
MFA-TR*              ,:RS-DATE-FROM                                             
MFA-TR*              ,:RS-DATE-TO                                               
MFA-TR*         FROM  CSS_RATE_USE_SEASN RS                                     
MFA-TR*         WHERE CODE_UTIL_TYPE   = :BG-CODE-UTIL-TYPE                     
MFA-TR*         AND   RATE_PLAN_NO     = :BG-RATE-PLAN-NO                       
MFA-TR*         AND   VERSION_NO_CNTRL =                                        
MFA-TR*                (SELECT MAX(VERSION_NO_CNTRL)                            
MFA-TR*                 FROM   CSS_RATE_USE_SEASN RS1                           
MFA-TR*                 WHERE RS1.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE           
MFA-TR*                 AND   RS1.RATE_PLAN_NO   = :BG-RATE-PLAN-NO)            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7916                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 SET VALID-SEASON     TO TRUE                           
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7916'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_RATE_USE_SEASN'      TO TABLE-1                 
              MOVE 'RATE-PLAN-NO'            TO TABLE-ELEMENT-1         
              MOVE BG-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE 'CODE-UTIL-TYPE'          TO TABLE-ELEMENT-2         
              MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7916-EXIT.                                                       
A04070      EXIT.                                                       
      ******************************************************************        
      *     9910-ABEND                                                 *        
      *                                                                *        
      *     PERFORMED IF DB2 PROBLEM OCCURS.                           *        
      ******************************************************************        
                                                                        
       9910-ABEND.                                                      
                                                                        
           MOVE '9910' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-RETURN-CODE-NUM TO WS-RETURN-CODE-CHAR            
              DISPLAY '**  CPDCA224 PROCESSING ERROR  **'               
              DISPLAY '**  UNSUCCESSFUL ROLLBACK      **'               
              DISPLAY '**  PARAGRAPH ' ACTIVE-PARAGRAPH                 
              DISPLAY '**  FILE STATUS = ' WS-RETURN-CODE-CHAR          
           END-IF.                                                      
           MOVE WS-RETURN-CODE-NUM  TO  RETURN-CODE.                    
           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT.                   
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
