      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                   PRICE WATERHOUSE                          **         
      **                                                             **         
      **              CUSTOMER INFORMATION SYSTEM                    **         
      *****************************************************************         
      **              P R O G R A M  S U M M A R Y                   **         
      **                CANCEL/REBILL SUBROUTINE                     **         
      ** USED TO PERFORM REVENUE ADJUSTMENT TRANSACTIONS BY          **         
      ** CANCELLING AND REBILLING ALL OR A SUBSET OF UTIL TYPES      **         
      ** FOR A GIVEN BILL DATE.                                      **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  -------   --------     ------                              **         
      **  09/9/02    JS83520     INITIAL PROGRAM VERSION             **         
T29397*  08/19/03 GANESH   CHANGES ADDED TO PROVIDE AUTOMATED PROCESS**         
T29397*                    FOR COST OF GAS ADJUSTMENT.               **         
C29528*  03/12/04    GANESH   CHANGES MADE TO ADD STATE AND FRANCHISE**         
C29528*                       TAX PERCENT ON CSS_BILLING_DET.        **         
C33500** 12/05/05   NARASIMHA    INITIALZED BG-DATE-ORIG-BILL FIELD  **         
C33500**                         PROPERLY TO PREVENT WRONG VALUES    **         
C33500**                         MOVING FROM PRIOR ACCOUNTS          **         
C33362*  12/30/05    ROD      ADD FIELD WS-BC-BILL-CALC-CYCLE-BG FOR **         
C33362*                       PURCHASED GAS ADJUSTMENT.              **         
C33924*  09/20/06    SS95855 COPY BILL-ADJUSTMNT DURING CANCEL REBILL**         
C35005*  02/05/07    SS95855 INSERT BILL_ADJ REASON DESCRIPTION      **         
C35005*                      REPLACE CSS_MODEL_SQL WITH SET COMMAND  **         
C35005*  02/20/07    SS95855 INCLUDE EXEMPT-FL LOGIC AND BILL CORR-  **         
C35005*                      ECTED CODE LOGIC FROM ONLINE STORED PROC**         
C34569*  02/12/08    RH15956 SEB RATE ENHANCEMENTS.  REPLACE CHECKING**         
C34569*                      FOR GL NUMBERS WITH FACTOR HISTORY      **         
C34569*                      SWITCH.  THIS LOGIC CONTROLS WHETHER OR **         
C34569*                      NOT WE WRITE FH ROWS TO REBILLS.  ADD   **         
C34569*                      NEW COLUMNS TO BG AND FH TABLES.        **         
A00765*  01/15/09    CVNS    ADDED 9000-SEND-ERROR-RESULT PARA.      ** PCS00230
A00765*              CHENNAI                                         ** PCS00230
P00165*  09/21/09    SS97726 SEB % BILLING CHANGES.                  **         
P00246*  12/18/09    SS97726 ADD NEW COLUMNS TO CSS_BILL_ADJUSTMNT.  **         
      *                                                              **         
A02034*  03/24/10    RF10596 KEEPING THE ACCOUNT EXEMPT FIELDS       **         
A02034*                      SET TO INDEFINITE, IF THEY ALREADY WERE **         
A02034*                      SET TO INDEFINITE.                      **         
      *                                                              **         
P00251*  04/20/10    SJ94244 PROJ251 - NET METERING CHANGES -        **         
P00251*                      TO SKIP COPYING THE CX ROW WITH CODE    **         
P00251*                      USAGE SOURCE = 'K' OR 'J'               **         
      *                                                              **         
P00257*  05/06/10    RH15956 REVENUE REPORTING PROJECT CHANGES.      **         
PRJ246*  08/24/10    SS97726 ADD NEW COLUMN TO CSS_BILL_ADJUSTMNT.   **         
P00496*  09/09/11    SV95326 COPY BILL MANUAL DURING CANCEL REBILL.  **         
A03082*  12/05/11    SV95326 REMOVED DATABASE-CHECK AS IT IS NOT USED**         
A03082*                      IN ANY PROGRAM OR PROCEDURE.            **         
ACT142*  12/12/12    DB41297 FIX OPEN CURSOR ISSUE (A03967)          **         
      *                                                              **         
      *****************************************************************         
      **                                                             **         
      **           ---- BASIC SEQUENCE STRUCTURE ----                **         
      **                                                             **         
      **  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION          **         
      **  1000 - 1999  INPUT PROCESSING (CREATE STRUCTURE FROM RATE) **         
      **               1100  LOAD RATE TABLE (IF FIRST TIME USED)    **         
      **               1200  BUILD BILL COMPONENT RECORD SHELL       **         
      **               1300  BUILD BILL ADJUSTMENT RECORD SHELL      **         
      **               1400  APPLY BASE RATE ADJUSTMENTS             **         
      **  2000 - 2999  OUTPUT PROCESSING (NOT USED IN SCSCA107)      **         
      **  3000 - 4999  UTILITY AND RECEIVABLE PROCESSING             **         
      **       3000 - 3299 GET NON-RTP CONSUMPTION (METERED)         **         
      **       3300 - 3300 GET UNMETERED CONSUMPTION                 **         
      **       3400 - 3499 GET RTP CONSUMPTION                       **         
      **       3500 - 3599 ADJUST READ UNITS                         **         
      **       3600 - 3699 BREAK UNITS INTO BLOCKS                   **         
      **       4000 - 4299 PRICE CONSUMPTION                         **         
      **       4300 - 4399 ADJUST COMPUTED AMOUNT                    **         
      **  5000 - 5999  COMMON PROGRAM MODULES                        **         
      **  6000 - 6999  COMMON SYSTEM MODULES (COPIES AND INCLUDES)   **         
      **  7000 - 7999  INPUT MODULES (SQL OPENS, FETCHES, SELECTS... **         
      **               THIS IS BASICALLY FOR RATE DATA SINCE THE     **         
      **               CALLING PROGRAM IS RESPONSIBLE FOR EXTRACTING **         
      **               ACCOUNT-RELATED DATA                          **         
      **  8000 - 8999  UPDATE MODULES (NO UPDATES IN SCSCA107)       **         
      **  9000 - 9999  TERMINATION, ABEND, MESSAGING (NOT USED)      **         
      **               IN THE EVENT OF AN UNRECOVERABLE SQL ERROR,   **         
      **               SUFFICIENT INFORMATION IS PASSED BACK TO THE  **         
      **               CALLING PROGRAM FOR IT TO CONTROL TERMINATION.**         
      **               AMOUNG OTHER THINGS, THIS ALLOWS SCSCA107 TO  **         
      **               EXECUTE IN BATCH OR CICS.                     **         
      **                                                             **         
      *****************************************************************         
      /                                                                         
      *****************************************************************         
       01  PROGRAM-WORK-VARIABLES.                                      
      **     THE WORK VARIABLE AREA IS USED FOR TRANSIENT DATA. IT   **         
      **     IS INITIALIZED ON EACH CALL TO THE SUBROUTINE.          **         
      **     THE OTHER WORK AREAS ARE INITIALIZED UNDER PROGRAM      **         
      **     CONTROL.  ADD ANY NEW DATA FIELDS ACCORDINGLY.          **         
      **                                                             **         
           05  WS-DATE-LFTM-HI-DMD-NULL         PIC S9(4) COMP.         
C34569     05  WS-DURATION-NULL                 PIC S9(4) COMP.         
           05  WS-DATE-ORIG-BILL-NULL           PIC S9(4) COMP.         
           05  WS-DATE-BILLED-NULL              PIC S9(4) COMP.         
           05  WS-DATE-USAGE-ENDS-NULL          PIC S9(4) COMP.         
           05  WS-EFF-DATE-FROM-NULL            PIC S9(4) COMP.         
           05  WS-EFF-DATE-TO-NULL              PIC S9(4) COMP.         
           05  WS-DATE-READ-NULL                PIC S9(4) COMP.         
           05  WS-IDR-INFO-NULL-IND             PIC S9(4) COMP.         
P00246     05  WS-OVRD-BILL-DT-NULL             PIC S9(4) COMP VALUE +0.
           05  WS-REBILL-BILL-NO                PIC S9(09) COMP.        
           05  WS-NUM-2-SHIFT-2-HIGH            PIC S9(09) COMP.        
           05  WS-NUM-SHIFT-FROM                PIC S9(09) COMP.        
           05  WS-IC-NO-MIN                     PIC S9(4) USAGE COMP.   
           05  WS-IC-NO-MAX                     PIC S9(4) USAGE COMP.   
           05  WS-IC-NO-SAVE                    PIC S9(4) USAGE COMP.   
           05  WS-ORIG-BILL-NO                  PIC S9(09) COMP.        
           05  WS-CURRENT-TIMESTMP              PIC X(26) VALUE SPACES. 
           05  WS-TRNSP-TIMESTMP                PIC X(26) VALUE SPACES. 
           05  WS-BASERT-TIMESTMP               PIC X(26) VALUE SPACES. 
           05  WS-REBILL-TIMESTMP               PIC X(26) VALUE SPACES. 
COB305     05 WS-PARM-REV-MONTH        PIC S9(6)V COMP-3 VALUE 0.      
           05  WS-CURRENT-DATE                  PIC X(10) VALUE SPACES. 
           05  WS-TRAN-COMMENT-LEN              PIC S9(4) COMP.         
           05  WS-TRAN-COMMENT-TEXT             PIC X(210) VALUE SPACES.
COB305     05 WS-HOLD-REVENUE-MONTH        PIC S9(6) COMP-3 VALUE 0.       
           05  WS-HOLD-COMPANY-NO               PIC X(02).              
COB305     05 WS-CURRENT-ACCOUNT        PIC S9(13)V COMP-3 VALUE 0.     
C35005     05  WS-PREVIOUS-ACCOUNT              PIC S9(13)V COMP-3      
C35005                                              VALUE 0.            
C35005     05  WS-COLUMN-NAME                   PIC X(17) VALUE         
C35005                                           'BILL_CORRECTED_CD'.   
C35005     05  WS-01                            PIC X(02) VALUE '01'.   
C35005     05  WS-ALL                           PIC X(03) VALUE 'ALL'.  
C35005     05  WS-TABLE-NAME                    PIC X(18) VALUE         
                                                 'CSS_BILLING_HDR'.     
           05  WS-CHAR-ACCOUNT                  PIC X(13) VALUE SPACE.  
           05  WS-ORIG-ITEM-TIMESTMP            PIC X(26).              
           05  WS-ORIG-BG-TIMESTMP              PIC X(26).              
           05  WS-AMT-NUM                       PIC S9(11).             
           05  WS-AMT-BILL-ITEM REDEFINES WS-AMT-NUM PIC X(11)          
                                              USAGE DISPLAY.            
           05  WS-STATE-TAX-NUM                 PIC S9(09).             
           05  WS-AMT-STATE-TAX REDEFINES WS-STATE-TAX-NUM PIC X(09)    
                                              USAGE DISPLAY.            
           05  WS-CITY-TAX-NUM                  PIC S9(09).             
           05  WS-AMT-CITY-TAX REDEFINES WS-CITY-TAX-NUM PIC X(09)      
                                              USAGE DISPLAY.            
           05  WS-OTHER-TAX-NUM                 PIC S9(09).             
           05  WS-AMT-OTHER-TAX REDEFINES WS-OTHER-TAX-NUM PIC X(09)    
                                              USAGE DISPLAY.            
           05  WS-INPUT-UNITS-A                 PIC X(8).               
           05  WS-INPUT-UNITS REDEFINES WS-INPUT-UNITS-A PIC 9(8).      
           05  WS-READ-UNITS-A                  PIC X(8).               
           05  WS-READ-UNITS REDEFINES WS-READ-UNITS-A PIC 9(8).        
           05  WS-RETURN-CODE-NUM               PIC 9(09).              
           05  WS-RETURN-CODE-CHAR              PIC X(09).              
           05  WS-ORIG-BILL-DATE                PIC X(10) VALUE SPACE.  
           05  WS-REBILL-COUNT                  PIC 9(06) VALUE ZERO.   
ACT142     05  WS-RETRY-COUNT                   PIC 9(06) VALUE ZERO.   
           05  WS-TRAN-APPL-NO                  PIC 9(03) VALUE ZERO.   
           05  WS-SPACE-LINE                    PIC X(132) VALUE SPACES.
           05  BG-RETURN-CODE                 PIC S9(9) VALUE +000 COMP.
           05  WS-TRNSP-FL                      PIC X(01) VALUE 'N'.    
           05  WS-BASE-RATE-FL                  PIC X(01) VALUE 'N'.    
           05  WS-TR-TS-USED                    PIC X(01) VALUE 'N'.    
           05  WS-BR-TS-USED                    PIC X(01) VALUE 'N'.    
           05  WS-BG-EXISTS                     PIC X(01) VALUE 'N'.    
           05  WS-UNMETERED-TYPE                PIC X(01) VALUE SPACE.  
           05  WS-METER-NO-HOLD                 PIC X(09) VALUE SPACES. 
C29397     05  WS-811                           PIC S9(9)               
                                                     VALUE -811 COMP.   
ACT142     05  WS-502                           PIC S9(9)               
ACT142                                               VALUE -502 COMP.   
C29397     05  WS-BILL-IMMEDIATE-FL             PIC X(01) VALUE SPACES. 
C35005     05  WS-REVENUE-MONTH                 PIC 9(06).              
C35005     05  WS-XMT-CODES.                                            
C35005         10 WS-CODE-DISC-OK            PIC X VALUE SPACE.         
C35005         10 WS-NOTICE-EXEMPT-CD        PIC X VALUE SPACE.         
C35005         10 WS-CODE-LPC-XMT            PIC X VALUE SPACE.         
C35005         10 WS-IVR-EXEMPT-CD           PIC X VALUE SPACE.         
C35005     05  WS-XMT-SWITCHES.                                         
C35005         10 DISC-OK-CHANGED            PIC X VALUE SPACE.         
C35005         10 EXEMPT-CD-CHANGED          PIC X VALUE SPACE.         
C35005         10 LPC-XMT-CHANGED            PIC X VALUE SPACE.         
C35005         10 IVR-EXEMPT-CHANGED         PIC X VALUE SPACE.         
C35005     05  WS-MSG-LITERAL.                                          
C35005         10 FILLER                     PIC X(16)                  
C35005                                       VALUE 'CURRENT MONTH + '.  
C35005         10 WS-MSG-MONTHS              PIC X VALUE SPACE.         
C35005         10 FILLER                     PIC X(7) VALUE ' MONTHS'.  
C35005     05  WS-AT-CODES-UPDATED-SW        PIC X(01) VALUE 'N'.       
C35005         88 AT-CODES-UPDATED           VALUE 'Y'.                 
C34569     05  WS-FACTOR-HISTORY-CD          PIC X(01) VALUE 'N'.       
                                                                        
       01  WS-BI-BILL-NO                    PIC S9(9) USAGE COMP.       
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-A                             PIC X(01) VALUE 'A'.    
           05  WS-B                             PIC X(01) VALUE 'B'.    
           05  WS-C                             PIC X(01) VALUE 'C'.    
           05  WS-D                             PIC X(01) VALUE 'D'.    
           05  WS-J                             PIC X(01) VALUE 'J'.    
           05  WS-K                             PIC X(01) VALUE 'K'.    
           05  WS-O                             PIC X(01) VALUE 'O'.    
           05  WS-S                             PIC X(01) VALUE 'S'.    
C35005     05  WS-I                             PIC X(01) VALUE 'I'.    
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-HOOK-INDICATOR                PIC X(01).              
               88 WS-HOOK-IS-BEING-CREATED VALUE 'Y'.                   
           05  WS-CUST-PLAN-SW                  PIC X(01) VALUE 'N'.    
               88 HAS-CUST-PLAN                      VALUE 'Y'.         
               88 HAS-NO-CUST-PLAN                   VALUE 'N'.         
                                                                        
       01  WS-TRAN-COMM-DESC.                                           
           05  WS-CODE-BILL-CALC-DESC      PIC X(09)   VALUE SPACES.    
           05  WS-TAX-REF-CODE-DESC        PIC X(15)   VALUE SPACES.    
           05  WS-BILL-WHEN-DESC           PIC X(13)   VALUE SPACES.    
           05  WS-FUNCTION                 PIC X(13)   VALUE SPACES.    
                                                                        
      /*********** COPY MEMBERS ****************************                    
      **  WORK QUEUE WORK AREA                                                  
       COPY CWS0070B.                                                           
      **  WS-WARNING-DATA-ELEMENTS (INCL PRIMARY SQL CODES)                     
       COPY CWS00303.                                                           
           05  MULTIPLE-ROWS              PIC S9(9) VALUE -811 COMP.    
       COPY CWS00004.                                                           
                                                                        
       COPY CWS00020.                                                           
       COPY CWS00021.                                                           
       COPY CWS00026.                                                           
       COPY CWS00027.                                                           
       COPY CWS00031.                                                           
       COPY CWS00100.                                                           
                                                                        
       COPY CCA00001.                                                           
       COPY CCA00003.                                                           
                                                                        
      /*******************  CURSOR DEFINITIONS ********************             
      ******************************************************************        
      *  CURSOR DECLARATION FOR THE CSS_INTERVAL_READ TABLE.           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE INT_READ_CRSR CURSOR FOR                         
                   SELECT DATE_READ,                                    
                          REPLACE(CONVERT(CHAR(8), TIME_READ, 108), 
           ':', '.') TIME_READ,                                    
                          DST_CHNG_IND,                                 
                          CHANNEL_A_PULSES,                             
                          CHANNEL_A_STATUS,                             
                          CHANNEL_B_PULSES,                             
                          CHANNEL_B_STATUS,                             
                          CHANNEL_C_PULSES,                             
                          CHANNEL_C_STATUS                              
                     FROM CSS_INTERVAL_READ WITH(READUNCOMMITTED)               
                    WHERE METER_NO           = :CX-METER-NO             
                      AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-ORIG-ITEM-TIMESTMP
              )   
                      AND CODE_UTIL_TYPE     = :IV-CODE-UTIL-TYPE       
C33924         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE INT_READ_CRSR CURSOR FOR                                 
MFA-TR*            SELECT DATE_READ,                                            
MFA-TR*                   TIME_READ,                                            
MFA-TR*                   DST_CHNG_IND,                                         
MFA-TR*                   CHANNEL_A_PULSES,                                     
MFA-TR*                   CHANNEL_A_STATUS,                                     
MFA-TR*                   CHANNEL_B_PULSES,                                     
MFA-TR*                   CHANNEL_B_STATUS,                                     
MFA-TR*                   CHANNEL_C_PULSES,                                     
MFA-TR*                   CHANNEL_C_STATUS                                      
MFA-TR*              FROM CSS_INTERVAL_READ                                     
MFA-TR*             WHERE METER_NO           = :CX-METER-NO                     
MFA-TR*               AND BILL_ITEM_TIMESTMP = :WS-ORIG-ITEM-TIMESTMP           
MFA-TR*               AND CODE_UTIL_TYPE     = :IV-CODE-UTIL-TYPE               
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  CURSOR DECLARATION FOR THE CSS_BILLING_DET TABLE.             *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BG_CRSR CURSOR FOR                               
                   SELECT PREMISE_NO,                                   
                          BILL_NO,                                      
                          CODE_UTIL_TYPE,                               
                          IC_NO,                                        
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                           
                          DATE_ORIG_BILL,                               
                          AMT_BILL_ITEM,                                
                          CODE_BILL_CALC,                               
                          CODE_BILL_ITM_TYPE,                           
                          CODE_BILL_ITM_IND,                            
                          CODE_DR_CR_CNSMPTN,                           
                          AMT_STATE_TAX,                                
                          AMT_CITY_TAX,                                 
                          AMT_OTHER_TAX,                                
                          CODE_REVENUE_CLASS,                           
                          CODE_SIC_NO,                                  
                          RATE_PLAN_NO,                                 
                          CODE_CURTAIL_PRTY,                            
                          CODE_STAT_TAX_XMT,                            
                          CODE_CITY_TAX_XMT,                            
                          CODE_OTHR_TAX_XMT,                            
                          REV_RPT_CD,                                   
                          STANDBY_COMPLIED,                             
                          PRORATE_CD,                                   
                          NEW_RATE_PCT,                                 
                          CODE_SUB_TOTAL,                               
                          TAX_REFUND_CD,                                
                          ACCOUNT_NO,                                   
                          COMPANY_NO,                                   
                          DATE_LFTM_HI_DMD,                             
                          LFTM_HI_PEAK_DMD,                             
                          REBILL_IND,                                   
                          ADJ_REASON_CD,                                
                          REVENUE_MONTH,                                
                          GAS_BASE_USE,                                 
                          WNA_FACTOR,                                   
                          BTU_FACTOR,                                   
                          NO_OF_CONS_DAYS,                              
                          REV_MTH_ORIG_BILL,                            
                          REV_DISTRICT_CD,                              
C34569                    FUEL_SHIPPER_CD,                              
                          ALTERNATE_FUEL_CD,                            
                          TRNSP_OVER_MDQ_FL,                            
C29528                    CITY_TAX_RATE,                                
C34569                    OTHER_TAX_RATE,                               
C29528                    STATE_TAX_RATE,                               
C33362                    BILL_CALC_CYCLE,                              
C34569                    NAICS_CD,                                     
C34569                    RT_PKG_OPT_SEQ_NO                             
                     FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)              
                    WHERE BG.ACCOUNT_NO     = :BG-ACCOUNT-NO            
                      AND BG.BILL_NO        = :BG-BILL-NO               
                      AND BG.IC_NO         >= :WS-IC-NO-MIN             
                      AND BG.IC_NO         <= :WS-IC-NO-MAX             
                      AND BG.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE        
JSFIX                 AND (                                             
JSFIX                 (BG.REV_MTH_ORIG_BILL = 0                         
JSFIX                  AND BG.REVENUE_MONTH = :WS-PARM-REV-MONTH)       
JSFIX                  OR (BG.REV_MTH_ORIG_BILL =                       
JSFIX                                     :WS-PARM-REV-MONTH))          
                      AND BG.CODE_BILL_CALC <> 'S'                      
                      AND BG.CODE_BILL_ITM_IND = 'A'                    
                      AND BG.CODE_BILL_ITM_IND <> 'K'                   
                ORDER BY IC_NO, BILL_ITEM_TIMESTMP                      
C33924         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BG_CRSR CURSOR FOR                                       
MFA-TR*            SELECT PREMISE_NO,                                           
MFA-TR*                   BILL_NO,                                              
MFA-TR*                   CODE_UTIL_TYPE,                                       
MFA-TR*                   IC_NO,                                                
MFA-TR*                   BILL_ITEM_TIMESTMP,                                   
MFA-TR*                   DATE_ORIG_BILL,                                       
MFA-TR*                   AMT_BILL_ITEM,                                        
MFA-TR*                   CODE_BILL_CALC,                                       
MFA-TR*                   CODE_BILL_ITM_TYPE,                                   
MFA-TR*                   CODE_BILL_ITM_IND,                                    
MFA-TR*                   CODE_DR_CR_CNSMPTN,                                   
MFA-TR*                   AMT_STATE_TAX,                                        
MFA-TR*                   AMT_CITY_TAX,                                         
MFA-TR*                   AMT_OTHER_TAX,                                        
MFA-TR*                   CODE_REVENUE_CLASS,                                   
MFA-TR*                   CODE_SIC_NO,                                          
MFA-TR*                   RATE_PLAN_NO,                                         
MFA-TR*                   CODE_CURTAIL_PRTY,                                    
MFA-TR*                   CODE_STAT_TAX_XMT,                                    
MFA-TR*                   CODE_CITY_TAX_XMT,                                    
MFA-TR*                   CODE_OTHR_TAX_XMT,                                    
MFA-TR*                   REV_RPT_CD,                                           
MFA-TR*                   STANDBY_COMPLIED,                                     
MFA-TR*                   PRORATE_CD,                                           
MFA-TR*                   NEW_RATE_PCT,                                         
MFA-TR*                   CODE_SUB_TOTAL,                                       
MFA-TR*                   TAX_REFUND_CD,                                        
MFA-TR*                   ACCOUNT_NO,                                           
MFA-TR*                   COMPANY_NO,                                           
MFA-TR*                   DATE_LFTM_HI_DMD,                                     
MFA-TR*                   LFTM_HI_PEAK_DMD,                                     
MFA-TR*                   REBILL_IND,                                           
MFA-TR*                   ADJ_REASON_CD,                                        
MFA-TR*                   REVENUE_MONTH,                                        
MFA-TR*                   GAS_BASE_USE,                                         
MFA-TR*                   WNA_FACTOR,                                           
MFA-TR*                   BTU_FACTOR,                                           
MFA-TR*                   NO_OF_CONS_DAYS,                                      
MFA-TR*                   REV_MTH_ORIG_BILL,                                    
MFA-TR*                   REV_DISTRICT_CD,                                      
MFA-TR*                   FUEL_SHIPPER_CD,                                      
MFA-TR*                   ALTERNATE_FUEL_CD,                                    
MFA-TR*                   TRNSP_OVER_MDQ_FL,                                    
MFA-TR*                   CITY_TAX_RATE,                                        
MFA-TR*                   OTHER_TAX_RATE,                                       
MFA-TR*                   STATE_TAX_RATE,                                       
MFA-TR*                   BILL_CALC_CYCLE,                                      
MFA-TR*                   NAICS_CD,                                             
MFA-TR*                   RT_PKG_OPT_SEQ_NO                                     
MFA-TR*              FROM CSS_BILLING_DET BG                                    
MFA-TR*             WHERE BG.ACCOUNT_NO     = :BG-ACCOUNT-NO                    
MFA-TR*               AND BG.BILL_NO        = :BG-BILL-NO                       
MFA-TR*               AND BG.IC_NO         >= :WS-IC-NO-MIN                     
MFA-TR*               AND BG.IC_NO         <= :WS-IC-NO-MAX                     
MFA-TR*               AND BG.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                
MFA-TR*               AND (                                                     
MFA-TR*               (BG.REV_MTH_ORIG_BILL = 0                                 
MFA-TR*                AND BG.REVENUE_MONTH = :WS-PARM-REV-MONTH)               
MFA-TR*                OR (BG.REV_MTH_ORIG_BILL =                               
MFA-TR*                                   :WS-PARM-REV-MONTH))                  
MFA-TR*               AND BG.CODE_BILL_CALC <> 'S'                              
MFA-TR*               AND BG.CODE_BILL_ITM_IND = 'A'                            
MFA-TR*               AND BG.CODE_BILL_ITM_IND <> 'K'                           
MFA-TR*         ORDER BY IC_NO, BILL_ITEM_TIMESTMP                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  CURSOR DECLARATION FOR THE CSS_BILLING_DET TABLE FOR CIG ACCTS*        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BGCIG_CRSR CURSOR FOR                            
                   SELECT PREMISE_NO,                                   
                          BILL_NO,                                      
                          CODE_UTIL_TYPE,                               
                          IC_NO,                                        
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                           
                          DATE_ORIG_BILL,                               
                          AMT_BILL_ITEM,                                
                          CODE_BILL_CALC,                               
                          CODE_BILL_ITM_TYPE,                           
                          CODE_BILL_ITM_IND,                            
                          CODE_DR_CR_CNSMPTN,                           
                          AMT_STATE_TAX,                                
                          AMT_CITY_TAX,                                 
                          AMT_OTHER_TAX,                                
                          CODE_REVENUE_CLASS,                           
                          CODE_SIC_NO,                                  
                          RATE_PLAN_NO,                                 
                          CODE_CURTAIL_PRTY,                            
                          CODE_STAT_TAX_XMT,                            
                          CODE_CITY_TAX_XMT,                            
                          CODE_OTHR_TAX_XMT,                            
                          REV_RPT_CD,                                   
                          STANDBY_COMPLIED,                             
                          PRORATE_CD,                                   
                          NEW_RATE_PCT,                                 
                          CODE_SUB_TOTAL,                               
                          TAX_REFUND_CD,                                
                          ACCOUNT_NO,                                   
                          COMPANY_NO,                                   
                          DATE_LFTM_HI_DMD,                             
                          LFTM_HI_PEAK_DMD,                             
                          REBILL_IND,                                   
                          ADJ_REASON_CD,                                
                          REVENUE_MONTH,                                
                          GAS_BASE_USE,                                 
                          WNA_FACTOR,                                   
                          BTU_FACTOR,                                   
                          NO_OF_CONS_DAYS,                              
                          REV_MTH_ORIG_BILL,                            
                          REV_DISTRICT_CD,                              
C34569                    FUEL_SHIPPER_CD,                              
                          ALTERNATE_FUEL_CD,                            
                          TRNSP_OVER_MDQ_FL,                            
C29528                    CITY_TAX_RATE,                                
C34569                    OTHER_TAX_RATE,                               
C29528                    STATE_TAX_RATE,                               
C33362                    BILL_CALC_CYCLE,                              
C34569                    NAICS_CD,                                     
C34569                    RT_PKG_OPT_SEQ_NO                             
                     FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)              
                    WHERE BG.ACCOUNT_NO     = :BG-ACCOUNT-NO            
                      AND BG.BILL_NO        = :BG-BILL-NO               
                      AND BG.IC_NO         >= :WS-IC-NO-MIN             
                      AND BG.IC_NO         <= :WS-IC-NO-MAX             
                      AND BG.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE        
                      AND BG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                   :WS-ORIG-BG-TIMESTMP
              )  
                      AND BG.CODE_BILL_CALC <> 'S'                      
                      AND BG.CODE_BILL_ITM_IND = 'A'                    
                      AND BG.CODE_BILL_ITM_IND <> 'K'                   
                ORDER BY IC_NO, BILL_ITEM_TIMESTMP                      
C33924         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BGCIG_CRSR CURSOR FOR                                    
MFA-TR*            SELECT PREMISE_NO,                                           
MFA-TR*                   BILL_NO,                                              
MFA-TR*                   CODE_UTIL_TYPE,                                       
MFA-TR*                   IC_NO,                                                
MFA-TR*                   BILL_ITEM_TIMESTMP,                                   
MFA-TR*                   DATE_ORIG_BILL,                                       
MFA-TR*                   AMT_BILL_ITEM,                                        
MFA-TR*                   CODE_BILL_CALC,                                       
MFA-TR*                   CODE_BILL_ITM_TYPE,                                   
MFA-TR*                   CODE_BILL_ITM_IND,                                    
MFA-TR*                   CODE_DR_CR_CNSMPTN,                                   
MFA-TR*                   AMT_STATE_TAX,                                        
MFA-TR*                   AMT_CITY_TAX,                                         
MFA-TR*                   AMT_OTHER_TAX,                                        
MFA-TR*                   CODE_REVENUE_CLASS,                                   
MFA-TR*                   CODE_SIC_NO,                                          
MFA-TR*                   RATE_PLAN_NO,                                         
MFA-TR*                   CODE_CURTAIL_PRTY,                                    
MFA-TR*                   CODE_STAT_TAX_XMT,                                    
MFA-TR*                   CODE_CITY_TAX_XMT,                                    
MFA-TR*                   CODE_OTHR_TAX_XMT,                                    
MFA-TR*                   REV_RPT_CD,                                           
MFA-TR*                   STANDBY_COMPLIED,                                     
MFA-TR*                   PRORATE_CD,                                           
MFA-TR*                   NEW_RATE_PCT,                                         
MFA-TR*                   CODE_SUB_TOTAL,                                       
MFA-TR*                   TAX_REFUND_CD,                                        
MFA-TR*                   ACCOUNT_NO,                                           
MFA-TR*                   COMPANY_NO,                                           
MFA-TR*                   DATE_LFTM_HI_DMD,                                     
MFA-TR*                   LFTM_HI_PEAK_DMD,                                     
MFA-TR*                   REBILL_IND,                                           
MFA-TR*                   ADJ_REASON_CD,                                        
MFA-TR*                   REVENUE_MONTH,                                        
MFA-TR*                   GAS_BASE_USE,                                         
MFA-TR*                   WNA_FACTOR,                                           
MFA-TR*                   BTU_FACTOR,                                           
MFA-TR*                   NO_OF_CONS_DAYS,                                      
MFA-TR*                   REV_MTH_ORIG_BILL,                                    
MFA-TR*                   REV_DISTRICT_CD,                                      
MFA-TR*                   FUEL_SHIPPER_CD,                                      
MFA-TR*                   ALTERNATE_FUEL_CD,                                    
MFA-TR*                   TRNSP_OVER_MDQ_FL,                                    
MFA-TR*                   CITY_TAX_RATE,                                        
MFA-TR*                   OTHER_TAX_RATE,                                       
MFA-TR*                   STATE_TAX_RATE,                                       
MFA-TR*                   BILL_CALC_CYCLE,                                      
MFA-TR*                   NAICS_CD,                                             
MFA-TR*                   RT_PKG_OPT_SEQ_NO                                     
MFA-TR*              FROM CSS_BILLING_DET BG                                    
MFA-TR*             WHERE BG.ACCOUNT_NO     = :BG-ACCOUNT-NO                    
MFA-TR*               AND BG.BILL_NO        = :BG-BILL-NO                       
MFA-TR*               AND BG.IC_NO         >= :WS-IC-NO-MIN                     
MFA-TR*               AND BG.IC_NO         <= :WS-IC-NO-MAX                     
MFA-TR*               AND BG.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                
MFA-TR*               AND BG.BILL_ITEM_TIMESTMP = :WS-ORIG-BG-TIMESTMP          
MFA-TR*               AND BG.CODE_BILL_CALC <> 'S'                              
MFA-TR*               AND BG.CODE_BILL_ITM_IND = 'A'                            
MFA-TR*               AND BG.CODE_BILL_ITM_IND <> 'K'                           
MFA-TR*         ORDER BY IC_NO, BILL_ITEM_TIMESTMP                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  CURSOR DECLARATION FOR THE CSS_UM_CNSMPT_HIST TABLE.          *        
      *  THIS CURSOR IS USED IN MAINTAINING UNMETERED CONSUMPTION ROWS.*        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE UM_CRSR CURSOR FOR                               
                      SELECT RATE_ITEM_CODE,                            
                             ITEM_SEQ_NO,                               
                             NO_UNITS,                                  
                             NO_DAYS,                                   
                             CODE_DEBIT_CREDIT,                         
                             USAGE_FIXED,                               
                             DATE_USAGE_ENDS,                           
                             CODE_SERVICE_TYPE,                         
                             CODE_ITEM_STATUS,                          
                             CODE_SOURCE_ID,                            
                             MTHLY_AMOUNT_FIXED,                        
                             DIST_NO,                                   
                             LIGHT_NO,                                  
                             POLE_NO                                    
                     FROM CSS_UM_CNSMPT_HIST WITH(READUNCOMMITTED)              
                    WHERE ACCOUNT_NO         = :UC-ACCOUNT-NO AND       
                          BILL_NO            = :UC-BILL-NO AND          
                          CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE AND   
                          IC_NO              = :UC-IC-NO AND            
                          BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )   
C33924         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UM_CRSR CURSOR FOR                                       
MFA-TR*               SELECT RATE_ITEM_CODE,                                    
MFA-TR*                      ITEM_SEQ_NO,                                       
MFA-TR*                      NO_UNITS,                                          
MFA-TR*                      NO_DAYS,                                           
MFA-TR*                      CODE_DEBIT_CREDIT,                                 
MFA-TR*                      USAGE_FIXED,                                       
MFA-TR*                      DATE_USAGE_ENDS,                                   
MFA-TR*                      CODE_SERVICE_TYPE,                                 
MFA-TR*                      CODE_ITEM_STATUS,                                  
MFA-TR*                      CODE_SOURCE_ID,                                    
MFA-TR*                      MTHLY_AMOUNT_FIXED,                                
MFA-TR*                      DIST_NO,                                           
MFA-TR*                      LIGHT_NO,                                          
MFA-TR*                      POLE_NO                                            
MFA-TR*              FROM CSS_UM_CNSMPT_HIST                                    
MFA-TR*             WHERE ACCOUNT_NO         = :UC-ACCOUNT-NO AND               
MFA-TR*                   BILL_NO            = :UC-BILL-NO AND                  
MFA-TR*                   CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE AND           
MFA-TR*                   IC_NO              = :UC-IC-NO AND                    
MFA-TR*                   BILL_ITEM_TIMESTMP = :UC-BILL-ITEM-TIMESTMP           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATION FOR THE CSS_CNSMPTN_HIST TABLE.            *        
      *  THIS CURSOR IS USED IN REBILLING METERED CONSUMPTION ROWS.    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE CNS_REBILL_CRSR CURSOR FOR                       
                      SELECT MTR_REF_NO,                                
                             REG_ID_NO,                                 
                             CODE_TIME_PERIOD,                          
                             ITEM_SEQ_NO,                               
                             CODE_USAGE_TYPE,                           
                             CODE_USAGE_ID,                             
                             CODE_USAGE_SOURCE,                         
                             METER_NO,                                  
                             DATE_READ,                                 
                             CODE_METER_READ,                           
                             CODE_METER_NO_READ,                        
                             METER_READING,                             
                             DEMAND_READING,                            
                             EMPLOYEE_NO,                               
                             NO_UNITS,                                  
                             NO_DEMAND_UNITS,                           
                             NO_DAYS,                                   
                             CODE_SOURCE_ID,                            
                             CODE_DEBIT_CREDIT,                         
                             CODE_ITEM_STATUS,                          
                             CODE_DISCOUNT,                             
                             CONSTANT,                                  
                             NO_DIALS,                                  
                             COMPANY_NO,                                
                             EXCEPT_OVERRIDE_CD,                        
                             REQUESTED_USAGE,                           
                             DIGTL_INTRL_MTR_NO,                        
                             DIGTL_MTR_TYPE,                            
                             CODE_TOU_SEASN,                            
                             EXCL_DMD_RCHT_IND,                         
                             MTR_READ_SOURCE_CD,                        
                             BTU_FACTOR,                                
C30989                       PCOMP_FCT                                  
                     FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                
                    WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO AND       
                          BILL_NO            = :CX-BILL-NO AND          
                          CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE AND   
                          IC_NO              = :CX-IC-NO AND            
                          BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )   
C33924         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CNS_REBILL_CRSR CURSOR FOR                               
MFA-TR*               SELECT MTR_REF_NO,                                        
MFA-TR*                      REG_ID_NO,                                         
MFA-TR*                      CODE_TIME_PERIOD,                                  
MFA-TR*                      ITEM_SEQ_NO,                                       
MFA-TR*                      CODE_USAGE_TYPE,                                   
MFA-TR*                      CODE_USAGE_ID,                                     
MFA-TR*                      CODE_USAGE_SOURCE,                                 
MFA-TR*                      METER_NO,                                          
MFA-TR*                      DATE_READ,                                         
MFA-TR*                      CODE_METER_READ,                                   
MFA-TR*                      CODE_METER_NO_READ,                                
MFA-TR*                      METER_READING,                                     
MFA-TR*                      DEMAND_READING,                                    
MFA-TR*                      EMPLOYEE_NO,                                       
MFA-TR*                      NO_UNITS,                                          
MFA-TR*                      NO_DEMAND_UNITS,                                   
MFA-TR*                      NO_DAYS,                                           
MFA-TR*                      CODE_SOURCE_ID,                                    
MFA-TR*                      CODE_DEBIT_CREDIT,                                 
MFA-TR*                      CODE_ITEM_STATUS,                                  
MFA-TR*                      CODE_DISCOUNT,                                     
MFA-TR*                      CONSTANT,                                          
MFA-TR*                      NO_DIALS,                                          
MFA-TR*                      COMPANY_NO,                                        
MFA-TR*                      EXCEPT_OVERRIDE_CD,                                
MFA-TR*                      REQUESTED_USAGE,                                   
MFA-TR*                      DIGTL_INTRL_MTR_NO,                                
MFA-TR*                      DIGTL_MTR_TYPE,                                    
MFA-TR*                      CODE_TOU_SEASN,                                    
MFA-TR*                      EXCL_DMD_RCHT_IND,                                 
MFA-TR*                      MTR_READ_SOURCE_CD,                                
MFA-TR*                      BTU_FACTOR,                                        
MFA-TR*                      PCOMP_FCT                                          
MFA-TR*              FROM CSS_CNSMPTN_HIST                                      
MFA-TR*             WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO AND               
MFA-TR*                   BILL_NO            = :CX-BILL-NO AND                  
MFA-TR*                   CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE AND           
MFA-TR*                   IC_NO              = :CX-IC-NO AND                    
MFA-TR*                   BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                        
                                                                        
HPCCDM*    EJECT                                                        
      ******************************************************************        
      *                                                                *        
      *  DECLARE A CURSOR FOR THE CSS_BILLING_DET TABLE.  THIS CURSOR  *        
      *  IS USED FOR SHIFTING BILL HOOKS.                              *        
      *  CJP 11/09/89.                                                 *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BG_SHFT_CRSR CURSOR FOR                          
                      SELECT PREMISE_NO,                                
                             BILL_NO,                                   
                             CODE_UTIL_TYPE,                            
                             IC_NO,                                     
                             REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                        
                             DATE_ORIG_BILL,                            
                             AMT_BILL_ITEM,                             
                             CODE_BILL_CALC,                            
                             CODE_BILL_ITM_TYPE,                        
                             CODE_BILL_ITM_IND,                         
                             CODE_DR_CR_CNSMPTN,                        
                             AMT_STATE_TAX,                             
                             AMT_CITY_TAX,                              
                             AMT_OTHER_TAX,                             
                             CODE_REVENUE_CLASS,                        
                             CODE_SIC_NO,                               
                             RATE_PLAN_NO,                              
                             CODE_CURTAIL_PRTY,                         
                             CODE_STAT_TAX_XMT,                         
                             CODE_CITY_TAX_XMT,                         
                             CODE_OTHR_TAX_XMT,                         
                             REV_RPT_CD,                                
                             STANDBY_COMPLIED,                          
                             PRORATE_CD,                                
                             NEW_RATE_PCT,                              
                             CODE_SUB_TOTAL,                            
                             TAX_REFUND_CD,                             
                             ACCOUNT_NO,                                
                             COMPANY_NO,                                
                             DATE_LFTM_HI_DMD,                          
                             LFTM_HI_PEAK_DMD,                          
                             REBILL_IND,                                
                             ADJ_REASON_CD,                             
                             REVENUE_MONTH,                             
                             GAS_BASE_USE,                              
                             WNA_FACTOR,                                
                             BTU_FACTOR,                                
                             NO_OF_CONS_DAYS,                           
                             REV_MTH_ORIG_BILL,                         
                             REV_DISTRICT_CD,                           
T25731                       FUEL_SHIPPER_CD,                           
                             ALTERNATE_FUEL_CD,                         
                             TRNSP_OVER_MDQ_FL,                         
C29528                       CITY_TAX_RATE,                             
C34569                       OTHER_TAX_RATE,                            
C29528                       STATE_TAX_RATE,                            
C33362                       BILL_CALC_CYCLE,                           
C34569                       NAICS_CD,                                  
C34569                       RT_PKG_OPT_SEQ_NO                          
                 FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :BG-ACCOUNT-NO                       
                  AND BILL_NO    = :BG-BILL-NO                          
C33924         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BG_SHFT_CRSR CURSOR FOR                                  
MFA-TR*               SELECT PREMISE_NO,                                        
MFA-TR*                      BILL_NO,                                           
MFA-TR*                      CODE_UTIL_TYPE,                                    
MFA-TR*                      IC_NO,                                             
MFA-TR*                      BILL_ITEM_TIMESTMP,                                
MFA-TR*                      DATE_ORIG_BILL,                                    
MFA-TR*                      AMT_BILL_ITEM,                                     
MFA-TR*                      CODE_BILL_CALC,                                    
MFA-TR*                      CODE_BILL_ITM_TYPE,                                
MFA-TR*                      CODE_BILL_ITM_IND,                                 
MFA-TR*                      CODE_DR_CR_CNSMPTN,                                
MFA-TR*                      AMT_STATE_TAX,                                     
MFA-TR*                      AMT_CITY_TAX,                                      
MFA-TR*                      AMT_OTHER_TAX,                                     
MFA-TR*                      CODE_REVENUE_CLASS,                                
MFA-TR*                      CODE_SIC_NO,                                       
MFA-TR*                      RATE_PLAN_NO,                                      
MFA-TR*                      CODE_CURTAIL_PRTY,                                 
MFA-TR*                      CODE_STAT_TAX_XMT,                                 
MFA-TR*                      CODE_CITY_TAX_XMT,                                 
MFA-TR*                      CODE_OTHR_TAX_XMT,                                 
MFA-TR*                      REV_RPT_CD,                                        
MFA-TR*                      STANDBY_COMPLIED,                                  
MFA-TR*                      PRORATE_CD,                                        
MFA-TR*                      NEW_RATE_PCT,                                      
MFA-TR*                      CODE_SUB_TOTAL,                                    
MFA-TR*                      TAX_REFUND_CD,                                     
MFA-TR*                      ACCOUNT_NO,                                        
MFA-TR*                      COMPANY_NO,                                        
MFA-TR*                      DATE_LFTM_HI_DMD,                                  
MFA-TR*                      LFTM_HI_PEAK_DMD,                                  
MFA-TR*                      REBILL_IND,                                        
MFA-TR*                      ADJ_REASON_CD,                                     
MFA-TR*                      REVENUE_MONTH,                                     
MFA-TR*                      GAS_BASE_USE,                                      
MFA-TR*                      WNA_FACTOR,                                        
MFA-TR*                      BTU_FACTOR,                                        
MFA-TR*                      NO_OF_CONS_DAYS,                                   
MFA-TR*                      REV_MTH_ORIG_BILL,                                 
MFA-TR*                      REV_DISTRICT_CD,                                   
MFA-TR*                      FUEL_SHIPPER_CD,                                   
MFA-TR*                      ALTERNATE_FUEL_CD,                                 
MFA-TR*                      TRNSP_OVER_MDQ_FL,                                 
MFA-TR*                      CITY_TAX_RATE,                                     
MFA-TR*                      OTHER_TAX_RATE,                                    
MFA-TR*                      STATE_TAX_RATE,                                    
MFA-TR*                      BILL_CALC_CYCLE,                                   
MFA-TR*                      NAICS_CD,                                          
MFA-TR*                      RT_PKG_OPT_SEQ_NO                                  
MFA-TR*          FROM CSS_BILLING_DET                                           
MFA-TR*         WHERE ACCOUNT_NO = :BG-ACCOUNT-NO                               
MFA-TR*           AND BILL_NO    = :BG-BILL-NO                                  
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  CURSOR DECLARATION FOR THE CSS_FIXED_FCT_HIST TABLE.          *        
      *  THIS CURSOR IS USED IN MAINTAINING FIXED FACTOR HISTORY ROWS. *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE FIX_FCTR_HST_CRSR CURSOR FOR                     
                      SELECT FIXED_FCTR_SEQ_NO,                         
C34569                       FH.FACTOR_ID,                              
                             EFF_DATE_FROM,                             
                             CMPNT_ID_CD,                               
                             CODE_SEASON,                               
                             INSTR_USE_TYPE_CD,                         
                             CODE_TIME_PERIOD,                          
                             CODE_DEBIT_CREDIT,                         
                             CODE_REVENUE_CLASS,                        
C34569                       FH.CODE_TAX_STAT_XMT,                      
C34569                       FH.CODE_TAX_CITY_XMT,                      
C34569                       FH.CODE_TAX_OTHR_XMT,                      
                             FACTOR,                                    
                             EFF_DATE_TO,                               
                             FIXED_FCTR_TYP_CD,                         
                             BILL_UNITS,                                
                             ENERGY_UNIT_CD,                            
C34569                       DURATION_REMAIN_NO,                        
C34569                       FH.OVR_RT_VER_PRO_FL,                      
C34569                       RT_PKG_OPT_SEQ_NO,                         
C34569                       FACTOR_HISTORY_CD,                         
P00165                       BLOCK_NO,                                  
P00496                       FH.FCTR_POWER_10                           
                     FROM CSS_FIXED_FCT_HIST FH WITH(READUNCOMMITTED),          
C34569                    CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                
                    WHERE ACCOUNT_NO         = :FH-ACCOUNT-NO AND       
                          BILL_NO            = :FH-BILL-NO AND          
                          CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE AND   
                          IC_NO              = :FH-IC-NO AND            
                          BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )   
C34569                    AND FH.FACTOR_ID   = SF.FACTOR_ID             
C33924         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FIX_FCTR_HST_CRSR CURSOR FOR                             
MFA-TR*               SELECT FIXED_FCTR_SEQ_NO,                                 
MFA-TR*                      FH.FACTOR_ID,                                      
MFA-TR*                      EFF_DATE_FROM,                                     
MFA-TR*                      CMPNT_ID_CD,                                       
MFA-TR*                      CODE_SEASON,                                       
MFA-TR*                      INSTR_USE_TYPE_CD,                                 
MFA-TR*                      CODE_TIME_PERIOD,                                  
MFA-TR*                      CODE_DEBIT_CREDIT,                                 
MFA-TR*                      CODE_REVENUE_CLASS,                                
MFA-TR*                      FH.CODE_TAX_STAT_XMT,                              
MFA-TR*                      FH.CODE_TAX_CITY_XMT,                              
MFA-TR*                      FH.CODE_TAX_OTHR_XMT,                              
MFA-TR*                      FACTOR,                                            
MFA-TR*                      EFF_DATE_TO,                                       
MFA-TR*                      FIXED_FCTR_TYP_CD,                                 
MFA-TR*                      BILL_UNITS,                                        
MFA-TR*                      ENERGY_UNIT_CD,                                    
MFA-TR*                      DURATION_REMAIN_NO,                                
MFA-TR*                      FH.OVR_RT_VER_PRO_FL,                              
MFA-TR*                      RT_PKG_OPT_SEQ_NO,                                 
MFA-TR*                      FACTOR_HISTORY_CD,                                 
MFA-TR*                      BLOCK_NO,                                          
MFA-TR*                      FH.FCTR_POWER_10                                   
MFA-TR*              FROM CSS_FIXED_FCT_HIST FH,                                
MFA-TR*                   CSS_SPCL_FCTR SF                                      
MFA-TR*             WHERE ACCOUNT_NO         = :FH-ACCOUNT-NO AND               
MFA-TR*                   BILL_NO            = :FH-BILL-NO AND                  
MFA-TR*                   CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE AND           
MFA-TR*                   IC_NO              = :FH-IC-NO AND                    
MFA-TR*                   BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP           
MFA-TR*                   AND FH.FACTOR_ID   = SF.FACTOR_ID                     
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *  CURSOR DECLARATION FOR THE CSS_VOL_DAILY TABLE.               *        
      *  THIS CURSOR IS USED TO COPY AND REBILL THE DAILY VOLUMES.     *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE ND_DAILY_CRSR CURSOR FOR                         
                      SELECT VOL_TYPE_CD,                               
                             ENERGY_UNIT_CD,                            
                             DATE_READ,                                 
                             NO_UNITS,                                  
                             FIXED_FCTR_SEQ_NO                          
                     FROM CSS_VOL_DAILY WITH(READUNCOMMITTED)                   
                    WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO AND       
                          BILL_NO            = :ND-BILL-NO AND          
                          CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE AND   
                          IC_NO              = :ND-IC-NO AND            
                          BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )   
C33924         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ND_DAILY_CRSR CURSOR FOR                                 
MFA-TR*               SELECT VOL_TYPE_CD,                                       
MFA-TR*                      ENERGY_UNIT_CD,                                    
MFA-TR*                      DATE_READ,                                         
MFA-TR*                      NO_UNITS,                                          
MFA-TR*                      FIXED_FCTR_SEQ_NO                                  
MFA-TR*              FROM CSS_VOL_DAILY                                         
MFA-TR*             WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO AND               
MFA-TR*                   BILL_NO            = :ND-BILL-NO AND                  
MFA-TR*                   CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE AND           
MFA-TR*                   IC_NO              = :ND-IC-NO AND                    
MFA-TR*                   BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *  CURSOR DECLARATION FOR THE CSS_MTR_IDENT_HIST TABLE.          *        
      *  THIS CURSOR IS USED TO COPY AND REBILL THE MTR IDENT HISTORY  *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE MTR_IDENT_CRSR CURSOR FOR                        
                   SELECT MTR_REF_NO,                                   
                          METER_NO,                                     
                          IDR_IDENT_NO,                                 
                          INTERVALS_PER_HR,                             
                          CHANNEL_A_UOM,                                
                          CHANNEL_B_UOM,                                
                          CHANNEL_C_UOM,                                
                          IDR_INFO_RETENT_DT,                           
                          CT_UPPER_RATIO,                               
                          PT_UPPER_RATIO,                               
                          CT_LOWER_RATIO,                               
                          PT_LOWER_RATIO,                               
                          INDUST_BTU_ID                                 
                     FROM CSS_MTR_IDENT_HIST WITH(READUNCOMMITTED)              
                    WHERE ACCOUNT_NO         = :GA-ACCOUNT-NO           
                      AND BILL_NO            = :GA-BILL-NO              
                      AND CODE_UTIL_TYPE     = :GA-CODE-UTIL-TYPE       
                      AND IC_NO              = :GA-IC-NO                
                      AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :GA-BILL-ITEM-TIMESTMP
              )   
C33924         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MTR_IDENT_CRSR CURSOR FOR                                
MFA-TR*            SELECT MTR_REF_NO,                                           
MFA-TR*                   METER_NO,                                             
MFA-TR*                   IDR_IDENT_NO,                                         
MFA-TR*                   INTERVALS_PER_HR,                                     
MFA-TR*                   CHANNEL_A_UOM,                                        
MFA-TR*                   CHANNEL_B_UOM,                                        
MFA-TR*                   CHANNEL_C_UOM,                                        
MFA-TR*                   IDR_INFO_RETENT_DT,                                   
MFA-TR*                   CT_UPPER_RATIO,                                       
MFA-TR*                   PT_UPPER_RATIO,                                       
MFA-TR*                   CT_LOWER_RATIO,                                       
MFA-TR*                   PT_LOWER_RATIO,                                       
MFA-TR*                   INDUST_BTU_ID                                         
MFA-TR*              FROM CSS_MTR_IDENT_HIST                                    
MFA-TR*             WHERE ACCOUNT_NO         = :GA-ACCOUNT-NO                   
MFA-TR*               AND BILL_NO            = :GA-BILL-NO                      
MFA-TR*               AND CODE_UTIL_TYPE     = :GA-CODE-UTIL-TYPE               
MFA-TR*               AND IC_NO              = :GA-IC-NO                        
MFA-TR*               AND BILL_ITEM_TIMESTMP = :GA-BILL-ITEM-TIMESTMP           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
C33924                                                                  
C33924******************************************************************        
C33924*                                                                *        
C33924*  CURSOR DECLARATION FOR THE CSS_BILL_ADJUSTMNT TABLE.          *        
C33924*  THIS CURSOR IS USED IN MAINTAINING BILL ADJUSTMNT ROWS.       *        
C33924*                                                                *        
C33924******************************************************************        
C33924     EXEC SQL                                                     
C33924         DECLARE BILL_ADJ_CRSR CURSOR FOR                         
C33924             SELECT  ACCOUNT_NO                                   
C33924                    ,BILL_NO                                      
C33924                    ,CODE_UTIL_TYPE                               
C33924                    ,IC_NO                                        
C33924                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                           
C33924                    ,ADJ_TYPE_CD                                  
C33924                    ,REVENUE_MONTH                                
C33924                    ,ADJ_REASON_DESC                              
P00246                    ,OVRRIDE_RT_REV_MTH                           
P00246                    ,OVRRIDE_RT_BILL_DT                           
P00246                    ,OVRRIDE_RT_BILL_CY                           
PRJ246                    ,SPECIAL_PROCESS_CD                           
C33924             FROM  CSS_BILL_ADJUSTMNT WITH(READUNCOMMITTED)               
C33924             WHERE ACCOUNT_NO         = :BP-ACCOUNT-NO            
C33924             AND   BILL_NO            = :BP-BILL-NO               
C33924             AND   CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE        
C33924             AND   IC_NO              = :BP-IC-NO                 
C33924             AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BP-BILL-ITEM-TIMESTMP
              )    
C33924         FOR READ ONLY                                    
C33924     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILL_ADJ_CRSR CURSOR FOR                                 
MFA-TR*            SELECT  ACCOUNT_NO                                           
MFA-TR*                   ,BILL_NO                                              
MFA-TR*                   ,CODE_UTIL_TYPE                                       
MFA-TR*                   ,IC_NO                                                
MFA-TR*                   ,BILL_ITEM_TIMESTMP                                   
MFA-TR*                   ,ADJ_TYPE_CD                                          
MFA-TR*                   ,REVENUE_MONTH                                        
MFA-TR*                   ,ADJ_REASON_DESC                                      
MFA-TR*                   ,OVRRIDE_RT_REV_MTH                                   
MFA-TR*                   ,OVRRIDE_RT_BILL_DT                                   
MFA-TR*                   ,OVRRIDE_RT_BILL_CY                                   
MFA-TR*                   ,SPECIAL_PROCESS_CD                                   
MFA-TR*            FROM  CSS_BILL_ADJUSTMNT                                     
MFA-TR*            WHERE ACCOUNT_NO         = :BP-ACCOUNT-NO                    
MFA-TR*            AND   BILL_NO            = :BP-BILL-NO                       
MFA-TR*            AND   CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE                
MFA-TR*            AND   IC_NO              = :BP-IC-NO                         
MFA-TR*            AND   BILL_ITEM_TIMESTMP = :BP-BILL-ITEM-TIMESTMP            
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
P00496******************************************************************01478000
P00496*  CURSOR DECLARATION FOR THE CSS_BILL_MAN_DET TABLE.            *01479100
P00496******************************************************************01479400
P00496     EXEC SQL                                                     
P00496         DECLARE BILL_MAN_DET CURSOR FOR                          
P00496             SELECT  NU.ACCOUNT_NO                                
P00496                    ,NU.BILL_NO                                   
P00496                    ,NU.CODE_UTIL_TYPE                            
P00496                    ,NU.IC_NO                                     
P00496                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           NU.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                        
P00496                    ,NU.BILL_MAN_DET_SEQ                          
P00496                    ,NU.BILL_MANUAL_TBL_ID                        
P00496                    ,NU.BILL_MANUAL_DATA                          
P00496             FROM  CSS_BILL_MAN_DET NU WITH(READUNCOMMITTED)              
P00496             WHERE NU.ACCOUNT_NO         = :NU-ACCOUNT-NO         
P00496             AND   NU.BILL_NO            = :NU-BILL-NO            
P00496             AND   NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE     
P00496             AND   NU.IC_NO              = :NU-IC-NO              
P00496             AND   NU.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NU-BILL-ITEM-TIMESTMP
              ) 
P00496             FOR READ ONLY                              
P00496                                                      
P00496     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01479500
MFA-TR*        DECLARE BILL_MAN_DET CURSOR FOR                          01479600
MFA-TR*            SELECT  NU.ACCOUNT_NO                                01479700
MFA-TR*                   ,NU.BILL_NO                                   01479800
MFA-TR*                   ,NU.CODE_UTIL_TYPE                            01479900
MFA-TR*                   ,NU.IC_NO                                     01480000
MFA-TR*                   ,NU.BILL_ITEM_TIMESTMP                        01480100
MFA-TR*                   ,NU.BILL_MAN_DET_SEQ                          01480200
MFA-TR*                   ,NU.BILL_MANUAL_TBL_ID                        01480300
MFA-TR*                   ,NU.BILL_MANUAL_DATA                          01480400
MFA-TR*            FROM  CSS_BILL_MAN_DET NU                            01480500
MFA-TR*            WHERE NU.ACCOUNT_NO         = :NU-ACCOUNT-NO         01480600
MFA-TR*            AND   NU.BILL_NO            = :NU-BILL-NO            01480700
MFA-TR*            AND   NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE     01480800
MFA-TR*            AND   NU.IC_NO              = :NU-IC-NO              01480900
MFA-TR*            AND   NU.BILL_ITEM_TIMESTMP = :NU-BILL-ITEM-TIMESTMP 01481000
MFA-TR*            FOR   FETCH ONLY WITH UR                             01481100
MFA-TR*            QUERYNO 7975                                                 
MFA-TR*    END-EXEC.                                                    01481200
       LINKAGE SECTION.                                                 
                                                                        
       COPY CWSCA190.                                                           
       COPY CWS00010.                                                           
                                                                        
       01  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.        
                                                                        
      *                                                                         
       PROCEDURE DIVISION USING CWSCA190-FIELDS,                        
                                ABEND-FILE,                             
                                RS-RETURN-CODE.                         
                                                                        
      ******************************************************************        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
                                                                        
           MOVE WS-C190-ACCOUNT-NO  TO BG-ACCOUNT-NO                    
                                       BI-ACCOUNT-NO                    
                                       AT-ACCOUNT-NO                    
                                       WS-CURRENT-ACCOUNT               
           MOVE WS-C190-CODE-UTIL-TYPE TO BG-CODE-UTIL-TYPE             
           MOVE WS-C190-BILL-NO     TO BG-BILL-NO                       
                                       BI-BILL-NO                       
                                       WS-ORIG-BILL-NO                  
                                                                        
      *****************************************************************         
      * IF IC-NO IS PASSED SELECT THE RECORD FOR THAT IC_NO ELSE      *         
      * SELECT ALL THE IC_NOS ATTACHED TO THAT ACCOUNT                *         
      *****************************************************************         
           IF WS-C190-IC-NO > ZEROES                                    
              MOVE WS-C190-IC-NO     TO WS-IC-NO-MIN                    
                                        WS-IC-NO-MAX                    
           ELSE                                                         
              MOVE ZEROES            TO WS-IC-NO-MIN                    
              MOVE +9999             TO WS-IC-NO-MAX                    
           END-IF                                                       
                                                                        
JSFIX      MOVE WS-C190-REVENUE-MONTH  TO WS-PARM-REV-MONTH             
                                                                        
           MOVE SPACES               TO WS-REBILL-TIMESTMP              
                                        WS-TRNSP-TIMESTMP               
                                        WS-BASERT-TIMESTMP              
                                        WS-ORIG-BILL-DATE               
                                        WS-ORIG-ITEM-TIMESTMP           
                                        WS-METER-NO-HOLD                
                                        ABEND-FUNCTION                  
                                                                        
           MOVE 'N'                  TO WS-TRNSP-FL                     
                                        WS-BASE-RATE-FL                 
                                        WS-TR-TS-USED                   
                                        WS-BR-TS-USED                   
                                        WS-BG-EXISTS                    
                                        WS-CUST-PLAN-SW                 
                                                                        
           MOVE ZEROES               TO WS-REBILL-COUNT                 
ACT142                                  WS-RETRY-COUNT                  
                                        WS-IC-NO-SAVE                   
                                                                        
           PERFORM 7005-GET-ACCOUNT-INFO THRU 7005-EXIT                 
                                                                        
           PERFORM 7020-SELECT-CUR-DATE THRU 7020-EXIT                  
           MOVE AT-COMPANY-NO           TO WS-HOLD-COMPANY-NO           
                                                                        
           PERFORM 1000-PROCESS-ACCOUNT THRU 1000-EXIT                  
                                                                        
           EXIT PROGRAM.                                                
      ******************************************************************        
      **                                                              **        
      **    1000-PROCESS-ACCOUNT                                      **        
      **                                                              **        
      ******************************************************************        
       1000-PROCESS-ACCOUNT.                                            
                                                                        
           MOVE 5000                TO ACTIVE-PARAGRAPH.                
           PERFORM 7420-OPEN-BG-CRSR THRU 7420-EXIT.                    
           PERFORM 7430-FETCH-BG-CRSR THRU 7430-EXIT.                   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 7440-CLOSE-BG-CRSR THRU 7440-EXIT                 
           ELSE                                                         
              PERFORM 7440-CLOSE-BG-CRSR THRU 7440-EXIT                 
              MOVE 'NOBGDETL'            TO ABEND-FUNCTION              
              GO TO 1000-EXIT                                           
           END-IF.                                                      
           PERFORM 7010-SELECT-CUR-TIMESTAMP THRU 7010-EXIT.            
           IF WS-C190-CALL-FLAG = 'B'                                   
              PERFORM 7620-SELECT-RB-HOOK THRU 7620-EXIT                
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 7625-CHK-BILLING-DET    THRU 7625-EXIT         
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    OR MULTIPLE-ROWS                                    
                    GO TO 1000-EXIT                                     
                 ELSE                                                   
                    MOVE WS-BI-BILL-NO         TO WS-REBILL-BILL-NO     
                                                  BI-BILL-NO            
                    PERFORM 7775-SELECT-BILLED-DATE THRU 7775-EXIT      
                    MOVE BI-DATE-BILLED        TO WS-ORIG-BILL-DATE     
                 END-IF                                                 
              ELSE                                                      
                 MOVE ZEROES                   TO WS-NUM-2-SHIFT-2-HIGH 
                 PERFORM 7771-SELECT-BILL-HEADER THRU 7771-EXIT         
                 MOVE BI-DATE-BILLED           TO WS-ORIG-BILL-DATE     
                 IF WS-C190-BILL-TYPE = 'I'                             
                    PERFORM 5750-SHIFT-BILL-NO THRU 5750-EXIT           
                    PERFORM 5501-CREATE-REBILL-HEADER THRU 5501-EXIT    
                 ELSE                                                   
                    PERFORM 7785-SELECT-BILL-HOOK THRU 7785-EXIT        
                    MOVE BI-BILL-NO            TO WS-REBILL-BILL-NO     
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF WS-C190-CALL-FLAG = 'O'                                
                 PERFORM 7630-GET-REBILL-BILL-NO  THRU 7630-EXIT        
                 ADD +1                       TO WS-BI-BILL-NO          
C29397***CHECK FOR BILL IMMEDIATE CONDITION IF BILL TYPE IS FUTURE              
C29397           IF WS-C190-BILL-TYPE = 'F'                             
C29397              MOVE 'N'                  TO WS-BILL-IMMEDIATE-FL   
C29397              PERFORM 7631-CHK-BILL-IMMEDIATE THRU 7631-EXIT      
C29397              IF WS-BILL-IMMEDIATE-FL = 'N'                       
C29397                 ADD +1                 TO WS-BI-BILL-NO          
C29397              END-IF                                              
C29397           END-IF                                                 
                 MOVE WS-BI-BILL-NO           TO WS-REBILL-BILL-NO      
                 PERFORM 7771-SELECT-BILL-HEADER THRU 7771-EXIT         
                 MOVE BI-DATE-BILLED          TO WS-ORIG-BILL-DATE      
                 IF WS-C190-BILL-ITM-TS > SPACES                        
                    MOVE WS-C190-BILL-ITM-TS TO WS-CURRENT-TIMESTMP     
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           PERFORM 5500-CANCEL-BILL           THRU 5500-EXIT            
           IF WS-C190-CALL-FLAG = 'B'                                   
              MOVE WS-CURRENT-DATE            TO AT-DATE-LAST-ACTION    
RGBFIX*       IF AT-CODE-ACCT-STAT EQUAL WS-A                                   
RGBFIX*          MOVE WS-B                    TO AT-CODE-BILL-PEND              
RGBFIX*       ELSE                                                              
              MOVE WS-A                    TO AT-CODE-BILL-PEND         
RGBFIX*       END-IF                                                            
              IF WS-C190-BILL-TYPE = 'F'                                
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 5003-UPDATE-OFF-CYCL THRU 5003-EXIT            
              END-IF                                                    
      *       PERFORM 7010-SELECT-CUR-TIMESTAMP THRU 7010-EXIT                  
              MOVE WS-CURRENT-TIMESTMP TO AT-LAST-UPDATE-TS             
C35005        MOVE WS-C190-TEMP-PULL-CD TO AT-CODE-TEMP-BILL            
              PERFORM 8550-UPDATE-ACCOUNT     THRU 8550-EXIT            
           END-IF                                                       
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5003-UPDATE-OFF-CYCL                                      **        
      **                                                              **        
      ******************************************************************        
       5003-UPDATE-OFF-CYCL.                                            
                                                                        
           MOVE 5003 TO ACTIVE-PARAGRAPH.                               
                                                                        
           MOVE AT-ACCOUNT-NO TO OC-ACCOUNT-NO.                         
           MOVE AT-CUSTOMER-NO TO OC-CUSTOMER-NO.                       
           MOVE WS-O TO OC-CODE-BILL-OFF-CYCL.                          
           PERFORM 8970-INSERT-OFF-CYCL-ACCT THRU 8970-EXIT.            
                                                                        
       5003-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5010-JRNL-TRAN-HDR                                        **        
      **                                                              **        
      **    JOURNALS THE MAINTENANCE TRANSACTION HEADER               **        
      ******************************************************************        
                                                                        
       5010-JRNL-TRAN-HDR.                                              
                                                                        
           MOVE '5010' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE BG-BILL-ITEM-TIMESTMP        TO MH-TRANS-HIST-SEQ-NO.   
           MOVE WS-CURRENT-DATE              TO MH-DATE-TRANS.          
           MOVE 'F'                          TO MH-CODE-TRAN-TYPE.      
           MOVE '437'                        TO MH-RESP-AREA-ID.        
           MOVE WS-CURRENT-ACCOUNT           TO MH-ACCOUNT-NO.          
           MOVE ZEROS                        TO MH-CUSTOMER-NO.         
           MOVE ZEROS                        TO MH-PREMISE-NO.          
           MOVE 'SYSTEM '                    TO MH-USER-ID.             
           IF WS-C190-CALL-FLAG = 'B'                                   
              MOVE 'SCSCA190'                TO MH-APPL-PROGRAM-ID      
           ELSE                                                         
              IF WS-C190-CALL-FLAG = 'O'                                
                 MOVE 'SCSCO190'             TO MH-APPL-PROGRAM-ID      
              END-IF                                                    
           END-IF                                                       
           MOVE WS-TRAN-COMMENT-LEN          TO MH-TRAN-COMMENT-LEN.    
           MOVE WS-TRAN-COMMENT-TEXT         TO MH-TRAN-COMMENT-TEXT.   
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5015-JRNL-TRAN-DTLS                                       **        
      **                                                              **        
      **    JOURNALS THE MAINTENANCE TRANSACTION DETAILS              **        
      ******************************************************************        
                                                                        
       5015-JRNL-TRAN-DTLS.                                             
                                                                        
           MOVE '5015' TO ACTIVE-PARAGRAPH.                             
C35005     INITIALIZE DCLCSS-MT-TRN-HST-DET.                            
                                                                        
           MOVE BG-BILL-ITEM-TIMESTMP TO MI-TRANS-HIST-SEQ-NO           
           MOVE 1                    TO WS-TRAN-APPL-NO                 
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
           IF WS-C190-CALL-FLAG = 'B'                                   
              MOVE 'BATCH C/R      ' TO MI-COLUMN-DESC                  
           ELSE                                                         
              IF WS-C190-CALL-FLAG = 'O'                                
                 MOVE 'CANCEL/REBILL  '    TO MI-COLUMN-DESC            
              END-IF                                                    
           END-IF                                                       
           MOVE 71                   TO MI-CHG-COLUMN-VALUE-LEN         
           MOVE SPACES               TO MI-TABLE-ID                     
           MOVE 22                   TO MI-PRV-COLUMN-VALUE-LEN         
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
C35005     IF WS-C190-CALL-FLAG = 'B' AND                               
C35005        WS-CURRENT-ACCOUNT NOT EQUAL WS-PREVIOUS-ACCOUNT          
C35005* TRAN HISTORY FOR ADJUSTMENT REASON DESCRIPTION                          
C35005        MOVE WS-CURRENT-TIMESTMP    TO MI-TRANS-HIST-SEQ-NO       
C35005        ADD 1                       TO WS-TRAN-APPL-NO            
C35005        MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
C35005        MOVE 'ADJUSTMENT RSN'       TO MI-COLUMN-DESC             
C35005        MOVE 24                     TO MI-PRV-COLUMN-VALUE-LEN    
C35005        MOVE SPACES                 TO MI-PRV-COLUMN-VALUE-TEXT   
C35005        MOVE WS-C190-ADJ-REASN-CODE TO K0-ADJ-REASON-CD           
C35005        PERFORM 7805-SELECT-ADJ-REASON-DESC THRU 7805-EXIT        
C35005        MOVE 71                     TO MI-CHG-COLUMN-VALUE-LEN    
C35005        MOVE K0-ADJ-REASON-DESC     TO MI-CHG-COLUMN-VALUE-TEXT   
C35005        PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
C35005                                                                  
C35005* TRAN HISTORY FOR TEMP PULL CODE                                         
C35005        MOVE WS-CURRENT-TIMESTMP    TO MI-TRANS-HIST-SEQ-NO       
C35005        ADD 1                       TO WS-TRAN-APPL-NO            
C35005        MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
C35005        MOVE 'TEMP PULL CODE'       TO MI-COLUMN-DESC             
C35005        MOVE 24                     TO MI-PRV-COLUMN-VALUE-LEN    
C35005        MOVE AT-CODE-TEMP-BILL      TO MI-PRV-COLUMN-VALUE-TEXT   
C35005        MOVE 24                     TO MI-CHG-COLUMN-VALUE-LEN    
C35005        MOVE WS-C190-TEMP-PULL-CD   TO MI-CHG-COLUMN-VALUE-TEXT   
C35005        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
C35005                                                                  
C35005* TRAN HISTORY FOR EXEMPT-FLAG                                            
C35005        IF DISC-OK-CHANGED = WS-Y                                 
C35005           MOVE WS-CURRENT-TIMESTMP  TO MI-TRANS-HIST-SEQ-NO      
C35005           ADD 1                     TO WS-TRAN-APPL-NO           
C35005           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO           
C35005           MOVE 'DISCONNECT CODE'    TO MI-COLUMN-DESC            
C35005           IF WS-CODE-DISC-OK > SPACE                             
C35005              MOVE 24                TO MI-PRV-COLUMN-VALUE-LEN   
C35005              MOVE WS-CODE-DISC-OK   TO WS-MSG-MONTHS             
C35005              MOVE WS-MSG-LITERAL    TO MI-PRV-COLUMN-VALUE-TEXT  
C35005           ELSE                                                   
C35005              MOVE SPACE             TO MI-PRV-COLUMN-VALUE-TEXT  
C35005           END-IF                                                 
C35005           MOVE 24                   TO MI-CHG-COLUMN-VALUE-LEN   
C35005           MOVE '2'                  TO WS-MSG-MONTHS             
C35005           MOVE WS-MSG-LITERAL       TO MI-CHG-COLUMN-VALUE-TEXT  
C35005           MOVE SPACES               TO MI-TABLE-ID               
C35005           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
C35005        END-IF                                                    
C35005        IF EXEMPT-CD-CHANGED = WS-Y                               
C35005           MOVE WS-CURRENT-TIMESTMP  TO MI-TRANS-HIST-SEQ-NO      
C35005           ADD 1                     TO WS-TRAN-APPL-NO           
C35005           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO           
C35005           MOVE 'NOTICE XMT CODE'    TO MI-COLUMN-DESC            
C35005           IF WS-NOTICE-EXEMPT-CD > SPACE                         
C35005              MOVE 24                TO MI-PRV-COLUMN-VALUE-LEN   
C35005              MOVE WS-NOTICE-EXEMPT-CD TO WS-MSG-MONTHS           
C35005              MOVE WS-MSG-LITERAL    TO MI-PRV-COLUMN-VALUE-TEXT  
C35005           ELSE                                                   
C35005              MOVE SPACE             TO MI-PRV-COLUMN-VALUE-TEXT  
C35005           END-IF                                                 
C35005           MOVE 24                   TO MI-CHG-COLUMN-VALUE-LEN   
C35005           MOVE '2'                  TO WS-MSG-MONTHS             
C35005           MOVE WS-MSG-LITERAL       TO MI-CHG-COLUMN-VALUE-TEXT  
C35005           MOVE SPACES               TO MI-TABLE-ID               
C35005           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
C35005        END-IF                                                    
C35005        IF LPC-XMT-CHANGED = WS-Y                                 
C35005           MOVE WS-CURRENT-TIMESTMP  TO MI-TRANS-HIST-SEQ-NO      
C35005           ADD 1                     TO WS-TRAN-APPL-NO           
C35005           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO           
C35005           MOVE 'LPC EXEMPT CODE'    TO MI-COLUMN-DESC            
C35005           IF WS-CODE-LPC-XMT > SPACE                             
C35005              MOVE 24                TO MI-PRV-COLUMN-VALUE-LEN   
C35005              MOVE WS-CODE-LPC-XMT   TO WS-MSG-MONTHS             
C35005              MOVE WS-MSG-LITERAL    TO MI-PRV-COLUMN-VALUE-TEXT  
C35005           ELSE                                                   
C35005              MOVE SPACE             TO MI-PRV-COLUMN-VALUE-TEXT  
C35005           END-IF                                                 
C35005           MOVE 24                   TO MI-CHG-COLUMN-VALUE-LEN   
C35005           MOVE '2'                  TO WS-MSG-MONTHS             
C35005           MOVE WS-MSG-LITERAL       TO MI-CHG-COLUMN-VALUE-TEXT  
C35005           MOVE SPACES               TO MI-TABLE-ID               
C35005           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
C35005        END-IF                                                    
C35005        IF IVR-EXEMPT-CHANGED = WS-Y                              
C35005           MOVE WS-CURRENT-TIMESTMP  TO MI-TRANS-HIST-SEQ-NO      
C35005           ADD 1                     TO WS-TRAN-APPL-NO           
C35005           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO           
C35005           MOVE 'IVR EXEMPT CODE'    TO MI-COLUMN-DESC            
C35005           IF WS-IVR-EXEMPT-CD > SPACE                            
C35005              MOVE 24                TO MI-PRV-COLUMN-VALUE-LEN   
C35005              MOVE WS-IVR-EXEMPT-CD  TO WS-MSG-MONTHS             
C35005              MOVE WS-MSG-LITERAL    TO MI-PRV-COLUMN-VALUE-TEXT  
C35005           ELSE                                                   
C35005              MOVE SPACE             TO MI-PRV-COLUMN-VALUE-TEXT  
C35005           END-IF                                                 
C35005           MOVE 24                   TO MI-CHG-COLUMN-VALUE-LEN   
C35005           MOVE '2'                  TO WS-MSG-MONTHS             
C35005           MOVE WS-MSG-LITERAL       TO MI-CHG-COLUMN-VALUE-TEXT  
C35005           MOVE SPACES               TO MI-TABLE-ID               
C35005           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
C35005        END-IF                                                    
C35005                                                                  
C35005        MOVE WS-CURRENT-ACCOUNT  TO WS-PREVIOUS-ACCOUNT           
C35005     END-IF.                                                      
                                                                        
       5015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5500-CANCEL-BILL                                          **        
      **                                                              **        
      ******************************************************************        
       5500-CANCEL-BILL.                                                
                                                                        
           MOVE 5500 TO ACTIVE-PARAGRAPH.                               
                                                                        
C35005     IF WS-C190-CALL-FLAG = 'B'                                   
C35005        IF WS-C190-BILL-TYPE = 'F'                                
C35005           MOVE WS-C190-BILL-CORRECTED-CD TO BI-BILL-CORRECTED-CD 
C35005        END-IF                                                    
C35005        IF WS-C190-BILL-TYPE = 'I' AND                            
C35005           WS-C190-BILL-CORRECTED-CD = WS-O                       
C35005           MOVE WS-ORIG-BILL-NO      TO BI-BILL-NO                
C35005           MOVE WS-I                 TO BI-BILL-CORRECTED-CD      
C35005        END-IF                                                    
C35005        PERFORM 8963-UPDATE-BILL-CORRECTED-CD THRU 8963-EXIT      
C35005     END-IF                                                       
                                                                        
           IF WS-C190-CODE-UTIL-TYPE = 'E'                              
              MOVE WS-C190-CODE-UTIL-TYPE TO BG-CODE-UTIL-TYPE          
              MOVE WS-ORIG-BILL-NO TO BG-BILL-NO                        
              PERFORM 7420-OPEN-BG-CRSR THRU 7420-EXIT                  
              PERFORM 7430-FETCH-BG-CRSR THRU 7430-EXIT                 
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 5525-CHK-CUST-PLAN THRU 5525-EXIT              
                 MOVE BG-BILL-ITEM-TIMESTMP TO WS-ORIG-ITEM-TIMESTMP    
                 PERFORM 5600-REBILL THRU 5600-EXIT                     
                    UNTIL BG-RETURN-CODE = NOT-FOUND                    
              END-IF                                                    
              PERFORM 7440-CLOSE-BG-CRSR THRU 7440-EXIT                 
           END-IF.                                                      
           IF WS-C190-CODE-UTIL-TYPE = 'G'                              
              MOVE WS-C190-CODE-UTIL-TYPE TO BG-CODE-UTIL-TYPE          
              MOVE WS-ORIG-BILL-NO       TO BG-BILL-NO                  
              IF WS-C190-CUSTOMER-FL = 'G' AND                          
                 WS-C190-CALL-FLAG = 'O' AND                            
                 WS-C190-BILL-ITM-TS > SPACES                           
                 MOVE WS-C190-ORIG-ITM-TS      TO WS-ORIG-BG-TIMESTMP   
                 PERFORM 7421-OPEN-BGCIG-CRSR     THRU 7421-EXIT        
                 PERFORM 7422-FETCH-BGCIG-CRSR    THRU 7422-EXIT        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 5525-CHK-CUST-PLAN THRU 5525-EXIT           
                    MOVE BG-BILL-ITEM-TIMESTMP TO WS-ORIG-ITEM-TIMESTMP 
                    PERFORM 5600-REBILL THRU 5600-EXIT                  
                       UNTIL BG-RETURN-CODE = NOT-FOUND                 
                 END-IF                                                 
                 PERFORM 7423-CLOSE-BGCIG-CRSR    THRU 7423-EXIT        
              ELSE                                                      
                 PERFORM 7420-OPEN-BG-CRSR THRU 7420-EXIT               
                 PERFORM 7430-FETCH-BG-CRSR THRU 7430-EXIT              
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 5525-CHK-CUST-PLAN THRU 5525-EXIT           
      *          PERFORM 7010-SELECT-CUR-TIMESTAMP THRU 7010-EXIT               
                    MOVE BG-BILL-ITEM-TIMESTMP TO WS-ORIG-ITEM-TIMESTMP 
                    PERFORM 5600-REBILL THRU 5600-EXIT                  
                       UNTIL BG-RETURN-CODE = NOT-FOUND                 
                 END-IF                                                 
                 PERFORM 7440-CLOSE-BG-CRSR THRU 7440-EXIT              
              END-IF                                                    
           END-IF.                                                      
           IF WS-C190-CODE-UTIL-TYPE = 'U'                              
              MOVE WS-C190-CODE-UTIL-TYPE TO BG-CODE-UTIL-TYPE          
              MOVE WS-ORIG-BILL-NO       TO BG-BILL-NO                  
              PERFORM 7420-OPEN-BG-CRSR  THRU 7420-EXIT                 
              PERFORM 7430-FETCH-BG-CRSR THRU 7430-EXIT                 
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 5525-CHK-CUST-PLAN THRU 5525-EXIT              
      *          PERFORM 7010-SELECT-CUR-TIMESTAMP THRU 7010-EXIT               
                 MOVE BG-BILL-ITEM-TIMESTMP TO WS-ORIG-ITEM-TIMESTMP    
                 PERFORM 5600-REBILL THRU 5600-EXIT                     
                    UNTIL BG-RETURN-CODE = NOT-FOUND                    
              END-IF                                                    
              PERFORM 7440-CLOSE-BG-CRSR THRU 7440-EXIT                 
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5525-CHK-CUST-PLAN.                                       **        
      **                                                              **        
      ******************************************************************        
       5525-CHK-CUST-PLAN.                                              
                                                                        
           MOVE 5525                        TO ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-C190-CODE-UTIL-TYPE      TO BG-CODE-UTIL-TYPE        
           MOVE BG-ACCOUNT-NO               TO CP-ACCOUNT-NO            
           MOVE BG-CODE-UTIL-TYPE           TO CP-CODE-UTIL-TYPE        
           MOVE BG-IC-NO                    TO CP-IC-NO                 
           PERFORM 8225-SELECT-CUST-PLAN THRU 8225-EXIT                 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              SET HAS-CUST-PLAN             TO TRUE                     
           ELSE                                                         
              SET HAS-NO-CUST-PLAN          TO TRUE                     
           END-IF                                                       
           .                                                            
       5525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5550-JOURNAL-REBILL.                                      **        
      **                                                              **        
      ******************************************************************        
       5550-JOURNAL-REBILL.                                             
                                                                        
           MOVE 5550 TO ACTIVE-PARAGRAPH.                               
                                                                        
           MOVE 'BATCH C/R' TO WS-FUNCTION                              
           IF WS-C190-BILL-TYPE = 'I'                                   
              MOVE 'IMMEDIATELY:'  TO WS-BILL-WHEN-DESC                 
           ELSE                                                         
              IF WS-C190-BILL-TYPE = 'F'                                
                 MOVE 'FUTURE BILL:' TO WS-BILL-WHEN-DESC               
              END-IF                                                    
           END-IF                                                       
                                                                        
C35005     MOVE +01                       TO UV-CODE-VALUE-LEN          
C35005     MOVE WS-C190-BILL-CORRECTED-CD TO UV-CODE-VALUE-TEXT         
C35005     MOVE +17                       TO UV-COLUMN-NA-LEN           
C35005     MOVE WS-COLUMN-NAME            TO UV-COLUMN-NA-TEXT          
C35005     MOVE WS-01                     TO UV-COMPANY-NO              
C35005     MOVE WS-ALL                    TO UV-PROGRAM-ID              
C35005     MOVE +18                       TO UV-TABLE-NA-LEN            
C35005     MOVE WS-TABLE-NAME             TO UV-TABLE-NA-TEXT           
C35005     PERFORM 7619-GET-BILL-CORR-CD-DEEC THRU 7619-EXIT            
                                                                        
           MOVE 1      TO WS-TRAN-COMMENT-LEN.                          
C35005      STRING 'FUNCTION - '          DELIMITED BY SIZE             
                   WS-FUNCTION            DELIMITED BY ' '              
                   ';RATE PLAN NO - '     DELIMITED BY SIZE             
                   BG-RATE-PLAN-NO        DELIMITED BY SIZE             
                   ';BILL WHEN - '        DELIMITED BY SIZE             
                   WS-BILL-WHEN-DESC      DELIMITED BY ':'              
C35005             ';REVENUE MONTH - '    DELIMITED BY SIZE             
C35005             WS-C190-REVENUE-MONTH  DELIMITED BY SIZE             
C35005             ';CODE UTIL TYPE - '   DELIMITED BY SIZE             
C35005             WS-C190-CODE-UTIL-TYPE DELIMITED BY SIZE             
C35005             ';BILL CORRECTED CD - ' DELIMITED BY SIZE            
C35005             UV-CODE-SHORT-DESC-TEXT DELIMITED BY SIZE            
           INTO WS-TRAN-COMMENT-TEXT                                    
           POINTER WS-TRAN-COMMENT-LEN.                                 
           PERFORM 5010-JRNL-TRAN-HDR THRU 5010-EXIT.                   
           MOVE 0 TO WS-TRAN-APPL-NO.                                   
           PERFORM 5015-JRNL-TRAN-DTLS THRU 5015-EXIT.                  
                                                                        
       5550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5600-REBILL                                               **        
      **                                                              **        
      ******************************************************************        
       5600-REBILL.                                                     
                                                                        
           MOVE 5600 TO ACTIVE-PARAGRAPH.                               
      ****************************************************************          
      * CANCEL THE ORIGINAL BG                                       *          
      ****************************************************************          
           MOVE WS-K                   TO BG-CODE-BILL-ITM-IND          
           IF BG-REV-MTH-ORIG-BILL > ZERO                               
              MOVE BG-REV-MTH-ORIG-BILL TO WS-HOLD-REVENUE-MONTH        
           ELSE                                                         
              MOVE BG-REVENUE-MONTH TO WS-HOLD-REVENUE-MONTH
           END-IF.           
           PERFORM 8902-UPDATE-BILL-DET-CAN THRU 8902-EXIT.             
      ****************************************************************          
      * CREATE BACKOUT AND WRITE IT TO THE REBILL                    *          
      ****************************************************************          
           MOVE WS-A                   TO BG-CODE-BILL-ITM-IND          
           MOVE WS-B                   TO BG-CODE-BILL-ITM-TYPE         
           MOVE WS-S                   TO BG-CODE-BILL-CALC             
           IF BG-DATE-ORIG-BILL NOT > SPACE                             
              MOVE WS-ORIG-BILL-DATE TO BG-DATE-ORIG-BILL               
              MOVE ZERO                TO WS-DATE-ORIG-BILL-NULL        
           ELSE                                                         
              MOVE ZERO                TO WS-DATE-ORIG-BILL-NULL        
           END-IF                                                       
           IF BG-DATE-LFTM-HI-DMD (6:2) NOT > ZERO                      
               MOVE LOW-VALUES TO BG-DATE-LFTM-HI-DMD                   
               MOVE -1 TO WS-DATE-LFTM-HI-DMD-NULL                      
           ELSE                                                         
               MOVE 0 TO WS-DATE-LFTM-HI-DMD-NULL                       
           END-IF                                                       
           IF BG-CODE-DR-CR-CNSMPTN EQUAL WS-C                          
               MOVE WS-D               TO BG-CODE-DR-CR-CNSMPTN         
           ELSE                                                         
               MOVE WS-C               TO BG-CODE-DR-CR-CNSMPTN         
           END-IF                                                       
           MOVE WS-C190-ADJ-REASN-CODE TO BG-ADJ-REASON-CD              
           MOVE 'N'                    TO BG-REBILL-IND                 
           MOVE WS-REBILL-BILL-NO      TO BG-BILL-NO                    
           MOVE WS-HOLD-COMPANY-NO     TO BG-COMPANY-NO                 
           MOVE WS-HOLD-REVENUE-MONTH TO BG-REV-MTH-ORIG-BILL           
           MOVE 0                      TO BG-REVENUE-MONTH              
           PERFORM 8771-INSERT-BILL-DETAIL THRU 8771-EXIT               
      ****************************************************************          
      * UPDATE BILL HEADER IF FINALLED AND BACKOUT CNSMPTION AND     *          
      * FIXED FACTOR HISTORY IF THERE IS ANY.                        *          
      ****************************************************************          
           IF WS-C190-BILL-TYPE = 'I'                                   
C35005        IF WS-C190-CALL-FLAG = 'B'                                
C35005           AND WS-C190-EXEMPT-FL = 'Y'                            
C35005           AND AT-CODE-ACCT-STAT EQUAL WS-A                       
C35005               MOVE SPACES TO WS-XMT-CODES,                       
C35005                              WS-XMT-SWITCHES                     
      *                                                                         
A02034               IF AT-CODE-DISC-OK  = SPACES OR                    
A02034                  AT-CODE-DISC-OK IS NUMERIC                      
C35005                  IF AT-CODE-DISC-OK < '2'                        
C35005                     MOVE WS-Y TO DISC-OK-CHANGED                 
C35005                     MOVE AT-CODE-DISC-OK TO WS-CODE-DISC-OK      
C35005                     MOVE '2' TO AT-CODE-DISC-OK                  
C35005                  END-IF                                          
A02034               END-IF                                             
      *                                                                         
A02034               IF AT-NOTICE-EXEMPT-CD = SPACES OR                 
A02034                  AT-NOTICE-EXEMPT-CD IS NUMERIC                  
C35005                  IF AT-NOTICE-EXEMPT-CD < '2'                    
C35005                     MOVE WS-Y TO EXEMPT-CD-CHANGED               
C35005                     MOVE AT-NOTICE-EXEMPT-CD                     
C35005                           TO WS-NOTICE-EXEMPT-CD                 
C35005                     MOVE '2' TO AT-NOTICE-EXEMPT-CD              
C35005                  END-IF                                          
A02034               END-IF                                             
      *                                                                         
A02034               IF AT-CODE-LPC-XMT = SPACES OR                     
A02034                  AT-CODE-LPC-XMT IS NUMERIC                      
C35005                  IF AT-CODE-LPC-XMT < '2'                        
C35005                     MOVE WS-Y TO LPC-XMT-CHANGED                 
C35005                     MOVE AT-CODE-LPC-XMT TO WS-CODE-LPC-XMT      
C35005                     MOVE '2' TO AT-CODE-LPC-XMT                  
C35005                  END-IF                                          
A02034               END-IF                                             
      *                                                                         
A02034               IF AT-IVR-EXEMPT-CD = SPACES OR                    
A02034                  AT-IVR-EXEMPT-CD IS NUMERIC                     
C35005                  IF AT-IVR-EXEMPT-CD < '2'                       
C35005                     MOVE WS-Y TO IVR-EXEMPT-CHANGED              
C35005                     MOVE AT-IVR-EXEMPT-CD TO WS-IVR-EXEMPT-CD    
C35005                     MOVE '2' TO AT-IVR-EXEMPT-CD                 
C35005                  END-IF                                          
A02034               END-IF                                             
      *                                                                         
C35005               PERFORM 8961-SET-EXEMPT THRU 8961-EXIT             
C35005        END-IF                                                    
              IF AT-CODE-ACCT-STAT NOT EQUAL WS-A                       
                  MOVE WS-B            TO BI-CODE-BILL-TYPE             
                  PERFORM 8960-UPDATE-BILL-HDR-TYPE THRU 8960-EXIT      
              END-IF                                                    
           END-IF                                                       
           PERFORM 5510-BACKOUT-HIST THRU 5510-EXIT.                    
      ****************************************************************          
      * CREATE REBILL INFORMATION                                    *          
      ****************************************************************          
           MOVE WS-ORIG-BILL-NO           TO BG-BILL-NO                 
           MOVE WS-ORIG-ITEM-TIMESTMP     TO BG-BILL-ITEM-TIMESTMP      
           PERFORM 7783-GET-BG            THRU 7783-EXIT                
           MOVE WS-REBILL-BILL-NO         TO BG-BILL-NO                 
           IF WS-C190-BILL-ITM-TS > SPACES                              
              MOVE WS-C190-BILL-ITM-TS TO BG-BILL-ITEM-TIMESTMP         
           ELSE                                                         
              IF WS-C190-CALL-FLAG = 'O'                                
                 IF WS-C190-CUSTOMER-FL = 'G'                           
                    PERFORM 5610-GET-CIG-TIMESTMP THRU 5610-EXIT        
                 ELSE                                                   
                   MOVE WS-CURRENT-TIMESTMP TO BG-BILL-ITEM-TIMESTMP    
                 END-IF                                                 
              ELSE                                                      
                 IF WS-C190-CALL-FLAG = 'B'                             
                    IF WS-C190-CUSTOMER-FL = 'G'                        
                       PERFORM 5610-GET-CIG-TIMESTMP THRU 5610-EXIT     
                    ELSE                                                
                       MOVE WS-CURRENT-TIMESTMP TO                      
                                           BG-BILL-ITEM-TIMESTMP        
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           MOVE BG-BILL-ITEM-TIMESTMP TO WS-REBILL-TIMESTMP             
           MOVE WS-C                   TO BG-CODE-BILL-ITM-TYPE         
           MOVE WS-A                   TO BG-CODE-BILL-ITM-IND          
           IF BG-DATE-ORIG-BILL NOT > SPACE                             
              MOVE WS-ORIG-BILL-DATE TO BG-DATE-ORIG-BILL               
              MOVE ZERO                TO WS-DATE-ORIG-BILL-NULL        
           ELSE                                                         
              MOVE ZERO                TO WS-DATE-ORIG-BILL-NULL        
           END-IF                                                       
           IF BG-DATE-LFTM-HI-DMD (6:2) NOT > ZERO                      
               MOVE LOW-VALUES TO BG-DATE-LFTM-HI-DMD                   
               MOVE -1 TO WS-DATE-LFTM-HI-DMD-NULL                      
           ELSE                                                         
               MOVE 0 TO WS-DATE-LFTM-HI-DMD-NULL                       
           END-IF                                                       
           MOVE WS-HOLD-REVENUE-MONTH     TO BG-REV-MTH-ORIG-BILL       
           MOVE ZEROES                    TO BG-REVENUE-MONTH           
                                          BG-WNA-FACTOR                 
           MOVE 'Y'                       TO BG-REBILL-IND              
           MOVE WS-C190-ADJ-REASN-CODE TO BG-ADJ-REASON-CD              
           MOVE ZERO                      TO BG-NO-OF-CONS-DAYS         
           IF BG-CODE-BILL-CALC EQUAL WS-S                              
              CONTINUE                                                  
           ELSE                                                         
              IF BG-CODE-BILL-CALC EQUAL WS-J                           
                 MOVE ZEROES            TO BG-AMT-STATE-TAX             
                                           BG-AMT-CITY-TAX              
                                           BG-AMT-OTHER-TAX             
              ELSE                                                      
                 MOVE ZEROES TO BG-AMT-BILL-ITEM                        
                                BG-AMT-STATE-TAX                        
                                BG-AMT-CITY-TAX                         
                                BG-AMT-OTHER-TAX                        
              END-IF                                                    
           END-IF                                                       
           MOVE WS-HOLD-COMPANY-NO TO BG-COMPANY-NO                     
           PERFORM 8771-INSERT-BILL-DETAIL THRU 8771-EXIT               
      ****************************************************************          
      * REBILL ALL CONSUMPTION INFO AND IDR IF APPLICABLE            *          
      ****************************************************************          
           PERFORM 5520-REBILL-BILL         THRU 5520-EXIT.             
           PERFORM 5730-COPY-DAILY          THRU 5730-EXIT              
           MOVE WS-REBILL-BILL-NO           TO BG-BILL-NO.              
           IF WS-C190-BILL-ITM-TS > SPACES                              
              MOVE WS-C190-BILL-ITM-TS      TO BG-BILL-ITEM-TIMESTMP    
           ELSE                                                         
              IF WS-TR-TS-USED = 'Y'                                    
                 MOVE WS-BASERT-TIMESTMP TO BG-BILL-ITEM-TIMESTMP       
                 MOVE 'N'                   TO WS-TR-TS-USED            
              ELSE                                                      
                 IF WS-BR-TS-USED = 'Y'                                 
                    MOVE WS-TRNSP-TIMESTMP  TO BG-BILL-ITEM-TIMESTMP    
                    MOVE 'N'                TO WS-BR-TS-USED            
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           PERFORM 7783-GET-BG              THRU 7783-EXIT              
           PERFORM 5550-JOURNAL-REBILL      THRU 5550-EXIT              
           MOVE WS-ORIG-BILL-NO             TO BG-BILL-NO               
           MOVE WS-ORIG-ITEM-TIMESTMP       TO BG-BILL-ITEM-TIMESTMP    
           IF WS-C190-CUSTOMER-FL = 'G' AND WS-C190-CALL-FLAG = 'O'     
              AND WS-C190-BILL-ITM-TS > SPACES                          
              PERFORM 7422-FETCH-BGCIG-CRSR THRU 7422-EXIT              
           ELSE                                                         
              PERFORM 7430-FETCH-BG-CRSR    THRU 7430-EXIT              
           END-IF                                                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE BG-BILL-ITEM-TIMESTMP    TO WS-ORIG-ITEM-TIMESTMP    
           END-IF.                                                      
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5610-GET-CIG-TIMESTMP                                     **        
      **                                                              **        
      ******************************************************************        
       5610-GET-CIG-TIMESTMP.                                           
                                                                        
           MOVE 5610 TO ACTIVE-PARAGRAPH.                               
                                                                        
           IF BG-IC-NO  EQUAL WS-IC-NO-SAVE                             
              IF WS-TRNSP-FL = 'Y'                                      
                 MOVE WS-BASERT-TIMESTMP     TO BG-BILL-ITEM-TIMESTMP   
                                                WS-CURRENT-TIMESTMP     
                 MOVE 'N'                    TO WS-TRNSP-FL             
                 MOVE 'Y'                    TO WS-TR-TS-USED           
              ELSE                                                      
                 IF WS-BASE-RATE-FL = 'Y'                               
                    MOVE WS-TRNSP-TIMESTMP   TO BG-BILL-ITEM-TIMESTMP   
                                                WS-CURRENT-TIMESTMP     
                    MOVE 'N'                 TO WS-BASE-RATE-FL         
                    MOVE 'Y'                 TO WS-BR-TS-USED           
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
NEWFIX*       IF BG-CODE-REVENUE-CLASS = '000'                                  
NEWFIX*          IF AT-CODE-COMPANY-ACCT NOT EQUAL 'B'                          
NEWFIX        IF BG-REV-RPT-CD EQUAL 'T'                                
                    MOVE WS-CURRENT-TIMESTMP TO BG-BILL-ITEM-TIMESTMP   
                                                WS-TRNSP-TIMESTMP       
                    PERFORM 7998-SUB-ONE-MICROSEC  THRU 7998-EXIT       
                    MOVE 'Y'                 TO WS-TRNSP-FL             
NEWFIX*          ELSE                                                           
NEWFIX*             GO TO 5610-EXIT                                             
NEWFIX*          END-IF                                                         
              ELSE                                                      
                 MOVE WS-CURRENT-TIMESTMP TO BG-BILL-ITEM-TIMESTMP      
                                             WS-BASERT-TIMESTMP         
                 PERFORM 7999-ADD-ONE-MICROSEC     THRU 7999-EXIT       
                 MOVE 'Y'                    TO WS-BASE-RATE-FL         
              END-IF                                                    
              MOVE BG-IC-NO                  TO WS-IC-NO-SAVE           
           END-IF                                                       
           .                                                            
       5610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5501-CREATE-REBILL-HEADER                                 **        
      **                                                              **        
      ******************************************************************        
       5501-CREATE-REBILL-HEADER.                                       
                                                                        
           MOVE 5501 TO ACTIVE-PARAGRAPH.                               
                                                                        
           MOVE WS-REBILL-BILL-NO TO BI-BILL-NO.                        
           MOVE WS-A   TO BI-CODE-BILL-TYPE.                            
           MOVE WS-C   TO BI-CODE-BILL-STATUS.                          
           MOVE WS-A   TO BI-CODE-BILL-REASON.                          
           MOVE SPACE  TO BI-CODE-SPCL-BILL.                            
           MOVE LOW-VALUES TO BI-DATE-BILLED.                           
           MOVE -1 TO WS-DATE-BILLED-NULL.                              
           MOVE ZEROS  TO BI-TOT-OTHER-CHARGES                          
                          BI-TOTAL-ARREARS.                             
           MOVE WS-CURRENT-TIMESTMP TO BI-LAST-UPDATE-TS.               
                                                                        
C35005     IF WS-C190-BILL-CORRECTED-CD = WS-C                          
C35005        MOVE WS-C190-BILL-CORRECTED-CD TO BI-BILL-CORRECTED-CD    
C35005     END-IF.                                                      
P00257                                                                  
P00257     IF AT-CODE-ACCT-STAT NOT EQUAL WS-A                          
P00257        MOVE WS-B            TO BI-CODE-BILL-TYPE                 
P00257     END-IF.                                                      
                                                                        
           PERFORM 8770-INSERT-BILL-HEADER THRU 8770-EXIT.              
                                                                        
       5501-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5510-BACKOUT-HIST                                         **        
      **                                                              **        
      ******************************************************************        
       5510-BACKOUT-HIST.                                               
                                                                        
           MOVE 5510 TO ACTIVE-PARAGRAPH.                               
                                                                        
      **************************************************************            
      * CREATE BACKOUT UCS AND WRITE THEM TO THE REBILL                         
      **************************************************************            
           IF HAS-CUST-PLAN                                             
               MOVE WS-CURRENT-ACCOUNT     TO UC-ACCOUNT-NO             
               MOVE WS-ORIG-BILL-NO        TO UC-BILL-NO                
               MOVE BG-CODE-UTIL-TYPE      TO UC-CODE-UTIL-TYPE         
               MOVE BG-IC-NO               TO UC-IC-NO                  
               MOVE WS-ORIG-ITEM-TIMESTMP  TO UC-BILL-ITEM-TIMESTMP     
               PERFORM 7470-OPEN-UM-CRSR THRU 7470-EXIT                 
               PERFORM 5511-CANCEL-UM-CNSMPTN THRU 5511-EXIT            
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
               PERFORM 7476-CLOSE-UM-CRSR THRU 7476-EXIT                
               GO TO 5510-EXIT                                          
           ELSE                                                         
      ******************************************************************        
      * CREATE BACKOUT CXS AND FXS AND WRITE THEM TO THE REBILL       **        
      ******************************************************************        
              MOVE WS-CURRENT-ACCOUNT      TO CX-ACCOUNT-NO             
              MOVE WS-ORIG-BILL-NO         TO CX-BILL-NO                
              MOVE BG-CODE-UTIL-TYPE       TO CX-CODE-UTIL-TYPE         
              MOVE BG-IC-NO                TO CX-IC-NO                  
              MOVE WS-ORIG-ITEM-TIMESTMP   TO CX-BILL-ITEM-TIMESTMP     
              PERFORM 7550-OPEN-CX-REBILL-CRSR THRU 7550-EXIT           
              PERFORM 5512-BACKOUT-CNSMPTN THRU 5512-EXIT               
                    UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND         
              PERFORM 7556-CLOSE-CX-REBILL-CRSR THRU 7556-EXIT          
           END-IF                                                       
                                                                        
           MOVE WS-CURRENT-ACCOUNT         TO FH-ACCOUNT-NO.            
           MOVE WS-ORIG-BILL-NO            TO FH-BILL-NO.               
           MOVE BG-CODE-UTIL-TYPE          TO FH-CODE-UTIL-TYPE.        
           MOVE BG-IC-NO                   TO FH-IC-NO.                 
           MOVE WS-ORIG-ITEM-TIMESTMP      TO FH-BILL-ITEM-TIMESTMP.    
           PERFORM 7490-OPEN-FH-MAINT-CRSR THRU 7490-EXIT.              
           PERFORM 5513-BACKOUT-FH-HIST THRU 5513-EXIT                  
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.           
           PERFORM 7500-CLOSE-FH-CRSR THRU 7500-EXIT.                   
                                                                        
C33924     MOVE WS-CURRENT-ACCOUNT          TO BP-ACCOUNT-NO.           
C33924     MOVE WS-ORIG-BILL-NO             TO BP-BILL-NO.              
C33924     MOVE BG-CODE-UTIL-TYPE           TO BP-CODE-UTIL-TYPE.       
C33924     MOVE BG-IC-NO                    TO BP-IC-NO.                
C33924     MOVE WS-ORIG-ITEM-TIMESTMP       TO BP-BILL-ITEM-TIMESTMP.   
C33924     PERFORM 7800-OPEN-BILL-ADJ-CRSR  THRU 7800-EXIT.             
C33924     PERFORM 5560-BACKOUT-BILLADJ     THRU 5560-EXIT              
C33924             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
C33924     PERFORM 7820-CLOSE-BILL-ADJ-CRSR THRU 7820-EXIT.             
C33924                                                                  
P00496*                                                                         
P00496     MOVE WS-CURRENT-ACCOUNT         TO NG-ACCOUNT-NO             
P00496                                        NU-ACCOUNT-NO.            
P00496     MOVE WS-ORIG-BILL-NO            TO NG-BILL-NO                
P00496                                        NU-BILL-NO.               
P00496     MOVE BG-CODE-UTIL-TYPE          TO NG-CODE-UTIL-TYPE         
P00496                                        NU-CODE-UTIL-TYPE.        
P00496     MOVE BG-IC-NO                   TO NG-IC-NO                  
P00496                                        NU-IC-NO.                 
P00496     MOVE WS-ORIG-ITEM-TIMESTMP   TO NG-BILL-ITEM-TIMESTMP        
P00496                                     NU-BILL-ITEM-TIMESTMP.       
P00496     PERFORM 7970-GET-BILL-MANUAL THRU 7970-EXIT.                 
P00496     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00496        PERFORM 7975-OPEN-BILLMAN-CRSR  THRU 7975-EXIT            
P00496        PERFORM 5920-BACKOUT-BILLMAN    THRU 5920-EXIT            
P00496          UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND             
P00496        PERFORM 7985-CLOSE-BILLMAN-CRSR THRU 7985-EXIT            
P00496     END-IF.                                                      
P00496*                                                                         
           MOVE WS-CURRENT-ACCOUNT         TO GA-ACCOUNT-NO             
           MOVE WS-ORIG-BILL-NO            TO GA-BILL-NO                
           MOVE BG-CODE-UTIL-TYPE          TO GA-CODE-UTIL-TYPE         
           MOVE BG-IC-NO                   TO GA-IC-NO                  
           MOVE WS-ORIG-ITEM-TIMESTMP      TO GA-BILL-ITEM-TIMESTMP     
           PERFORM 7510-OPEN-MTR-CRSR      THRU 7510-EXIT               
           PERFORM 5773-BACKOUT-MTR-ALL    THRU 5773-EXIT               
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
           PERFORM 7530-CLOSE-MTR-CRSR     THRU 7530-EXIT.              
P00257                                                                  
P00257     MOVE WS-CURRENT-ACCOUNT        TO ND-ACCOUNT-NO              
P00257     MOVE WS-ORIG-BILL-NO           TO ND-BILL-NO                 
P00257     MOVE BG-CODE-UTIL-TYPE         TO ND-CODE-UTIL-TYPE          
P00257     MOVE BG-IC-NO                  TO ND-IC-NO                   
P00257     MOVE WS-ORIG-ITEM-TIMESTMP     TO ND-BILL-ITEM-TIMESTMP      
P00257     PERFORM 5737-COPY-DAILY-VOL THRU 5737-EXIT.                  
                                                                        
       5510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5511-CANCEL-UM-CNSMPTN                                    **        
      **                                                              **        
      ******************************************************************        
       5511-CANCEL-UM-CNSMPTN.                                          
                                                                        
           MOVE 5511                             TO ACTIVE-PARAGRAPH    
                                                                        
           MOVE WS-ORIG-BILL-NO TO UC-BILL-NO                           
           PERFORM 7475-FETCH-UM-CRSR THRU 7475-EXIT                    
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5511-EXIT
           END-IF.                                         
                                                                        
           MOVE WS-REBILL-BILL-NO TO UC-BILL-NO                         
           PERFORM 8015-INSERT-UM-CNSMPTN-ROW THRU 8015-EXIT            
           .                                                            
       5511-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5512-BACKOUT-CNSMPTN                                      **        
      **                                                              **        
      ******************************************************************        
       5512-BACKOUT-CNSMPTN.                                            
                                                                        
           MOVE 5512 TO ACTIVE-PARAGRAPH.                               
                                                                        
           PERFORM 7555-FETCH-CX-REBILL-CRSR THRU 7555-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5512-EXIT
           END-IF.                                         
                                                                        
P00251     IF CX-CODE-USAGE-SOURCE = 'K' OR 'J'                         
P00251*--- DO NOT COPY CONSUMPTION FROM AN ADDITIVE                             
P00251*--- OR SUBTRACTIVE METER.  THESE WILL BE                                 
P00251*--- REGENERATED IN SCSCA104.                                             
P00251        GO TO 5512-EXIT
           END-IF.                                          
                                                                        
           MOVE WS-REBILL-BILL-NO TO CX-BILL-NO.                        
           PERFORM 8020-INSERT-CNSMPTN-ROW THRU 8020-EXIT.              
                                                                        
       5512-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5513-BACKOUT-FH-HIST                                      **        
      **                                                              **        
      ******************************************************************        
       5513-BACKOUT-FH-HIST.                                            
                                                                        
           MOVE WS-ORIG-BILL-NO TO FH-BILL-NO.                          
           PERFORM 7495-FETCH-FH-MAINT-CRSR THRU 7495-EXIT              
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5513-EXIT
           END-IF.                                         
                                                                        
           MOVE WS-REBILL-BILL-NO TO FH-BILL-NO.                        
           PERFORM 8774-INSERT-FH THRU 8774-EXIT.                       
                                                                        
       5513-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5520-REBILL-BILL                                          **        
      **                                                              **        
      ******************************************************************        
       5520-REBILL-BILL.                                                
                                                                        
           MOVE 5520 TO ACTIVE-PARAGRAPH.                               
                                                                        
           IF HAS-CUST-PLAN                                             
              MOVE WS-CURRENT-ACCOUNT     TO UC-ACCOUNT-NO              
              MOVE WS-ORIG-BILL-NO        TO UC-BILL-NO                 
              MOVE BG-CODE-UTIL-TYPE      TO UC-CODE-UTIL-TYPE          
              MOVE BG-IC-NO               TO UC-IC-NO                   
              MOVE WS-ORIG-ITEM-TIMESTMP  TO UC-BILL-ITEM-TIMESTMP      
              PERFORM 7470-OPEN-UM-CRSR THRU 7470-EXIT                  
              PERFORM 5521-REBILL-UM-CNSMPTN THRU 5521-EXIT             
                UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND             
              PERFORM 7476-CLOSE-UM-CRSR THRU 7476-EXIT                 
              GO TO 5520-EXIT                                           
           END-IF                                                       
                                                                        
           MOVE WS-CURRENT-ACCOUNT          TO CX-ACCOUNT-NO            
           MOVE WS-ORIG-BILL-NO             TO CX-BILL-NO               
           MOVE BG-CODE-UTIL-TYPE           TO CX-CODE-UTIL-TYPE        
           MOVE BG-IC-NO                    TO CX-IC-NO                 
           MOVE WS-ORIG-ITEM-TIMESTMP       TO CX-BILL-ITEM-TIMESTMP    
           PERFORM 7550-OPEN-CX-REBILL-CRSR THRU 7550-EXIT              
           PERFORM 5522-REBILL-CNSMPTN THRU 5522-EXIT                   
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
           PERFORM 7556-CLOSE-CX-REBILL-CRSR THRU 7556-EXIT             
                                                                        
           MOVE WS-CURRENT-ACCOUNT         TO GA-ACCOUNT-NO             
           MOVE WS-ORIG-BILL-NO            TO GA-BILL-NO                
           MOVE BG-CODE-UTIL-TYPE          TO GA-CODE-UTIL-TYPE         
           MOVE BG-IC-NO                   TO GA-IC-NO                  
           MOVE WS-ORIG-ITEM-TIMESTMP      TO GA-BILL-ITEM-TIMESTMP     
           PERFORM 7510-OPEN-MTR-CRSR      THRU 7510-EXIT               
           PERFORM 5772-COPY-MTR-ALL       THRU 5772-EXIT               
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND              
           PERFORM 7530-CLOSE-MTR-CRSR     THRU 7530-EXIT               
                                                                        
           MOVE WS-CURRENT-ACCOUNT         TO FH-ACCOUNT-NO             
           MOVE WS-ORIG-BILL-NO            TO FH-BILL-NO                
           MOVE BG-CODE-UTIL-TYPE          TO FH-CODE-UTIL-TYPE         
           MOVE BG-IC-NO                   TO FH-IC-NO                  
           MOVE WS-ORIG-ITEM-TIMESTMP      TO FH-BILL-ITEM-TIMESTMP     
           PERFORM 7490-OPEN-FH-MAINT-CRSR THRU 7490-EXIT               
           PERFORM 5523-REBILL-FF-HIST THRU 5523-EXIT                   
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
           PERFORM 7500-CLOSE-FH-CRSR THRU 7500-EXIT                    
C33924                                                                  
C33924     MOVE WS-CURRENT-ACCOUNT         TO BP-ACCOUNT-NO             
P00496                                        NG-ACCOUNT-NO             
P00496                                        NU-ACCOUNT-NO.            
C33924     MOVE WS-ORIG-BILL-NO            TO BP-BILL-NO                
P00496                                        NG-BILL-NO                
P00496                                        NU-BILL-NO.               
C33924     MOVE BG-CODE-UTIL-TYPE          TO BP-CODE-UTIL-TYPE         
P00496                                        NG-CODE-UTIL-TYPE         
P00496                                        NU-CODE-UTIL-TYPE.        
C33924     MOVE BG-IC-NO                   TO BP-IC-NO                  
P00496                                        NG-IC-NO                  
P00496                                        NU-IC-NO.                 
C33924     MOVE WS-ORIG-ITEM-TIMESTMP      TO BP-BILL-ITEM-TIMESTMP     
P00496                                        NG-BILL-ITEM-TIMESTMP     
P00496                                        NU-BILL-ITEM-TIMESTMP.    
C33924     PERFORM 7800-OPEN-BILL-ADJ-CRSR THRU 7800-EXIT.              
C33924     PERFORM 5570-REBILL-BILLADJ     THRU 5570-EXIT               
C33924             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
C33924     PERFORM 7820-CLOSE-BILL-ADJ-CRSR THRU 7820-EXIT              
P00496*                                                                         
P00496     PERFORM 7970-GET-BILL-MANUAL THRU 7970-EXIT.                 
P00496     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00496        PERFORM 7975-OPEN-BILLMAN-CRSR  THRU 7975-EXIT            
P00496        PERFORM 5930-REBILL-BILLMAN     THRU 5930-EXIT            
P00496          UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND             
P00496        PERFORM 7985-CLOSE-BILLMAN-CRSR THRU 7985-EXIT            
P00496     END-IF.                                                      
P00496*                                                                         
       5520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5521-REBILL-UM-CNSMPTN                                    **        
      **                                                              **        
      ******************************************************************        
       5521-REBILL-UM-CNSMPTN.                                          
                                                                        
           MOVE 5521                     TO ACTIVE-PARAGRAPH.           
                                                                        
           MOVE WS-ORIG-BILL-NO          TO UC-BILL-NO                  
           MOVE WS-ORIG-ITEM-TIMESTMP    TO UC-BILL-ITEM-TIMESTMP       
           PERFORM 7475-FETCH-UM-CRSR    THRU 7475-EXIT                 
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5521-EXIT
           END-IF.                                         
                                                                        
           MOVE WS-REBILL-BILL-NO        TO UC-BILL-NO                  
           MOVE WS-CURRENT-TIMESTMP      TO UC-BILL-ITEM-TIMESTMP       
           PERFORM 8015-INSERT-UM-CNSMPTN-ROW THRU 8015-EXIT            
           .                                                            
       5521-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5522-REBILL-CNSMPTN                                       **        
      **                                                              **        
      ******************************************************************        
       5522-REBILL-CNSMPTN.                                             
                                                                        
           MOVE WS-ORIG-BILL-NO       TO CX-BILL-NO                     
           MOVE WS-ORIG-ITEM-TIMESTMP TO CX-BILL-ITEM-TIMESTMP.         
           PERFORM 7555-FETCH-CX-REBILL-CRSR THRU 7555-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               MOVE SPACES            TO WS-METER-NO-HOLD               
               GO TO 5522-EXIT
           END-IF.                                         
           MOVE WS-REBILL-BILL-NO     TO CX-BILL-NO.                    
           MOVE WS-CURRENT-TIMESTMP   TO CX-BILL-ITEM-TIMESTMP          
                                                                        
P00251     IF CX-CODE-USAGE-SOURCE = 'K' OR 'J'                         
P00251*--- DO NOT COPY CONSUMPTION FROM AN ADDITIVE                             
P00251*--- OR SUBTRACTIVE METER.  THESE WILL BE                                 
P00251*--- REGENERATED IN SCSCA104.                                             
P00251         NEXT SENTENCE                                            
P00251     ELSE                                                         
              PERFORM 8020-INSERT-CNSMPTN-ROW THRU 8020-EXIT            
P00251     END-IF.                                                      
                                                                        
           MOVE CX-METER-READING   TO MN-LAST-VAL-RD-VALUE.             
           PERFORM 8021-UPDATE-MTRD-ENVRNMENT THRU 8021-EXIT.           
           IF (CX-MTR-READ-SOURCE-CD = 'M'                              
              AND CX-METER-NO    NOT = WS-METER-NO-HOLD) OR             
              (WS-C190-CUSTOMER-FL   = 'G'                              
              AND CX-METER-NO    NOT = WS-METER-NO-HOLD)                
              PERFORM 5725-COPY-IDR         THRU 5725-EXIT              
           END-IF.                                                      
                                                                        
       5522-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5523-REBILL-FF-HIST                                       **        
      **                                                              **        
      ******************************************************************        
       5523-REBILL-FF-HIST.                                             
                                                                        
           PERFORM 7495-FETCH-FH-MAINT-CRSR THRU 7495-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C34569        OR WS-FACTOR-HISTORY-CD NOT = 'R'                         
                 GO TO 5523-EXIT                                        
C34569     END-IF.                                                      
                                                                        
           MOVE WS-REBILL-BILL-NO TO FH-BILL-NO.                        
           MOVE WS-CURRENT-TIMESTMP TO FH-BILL-ITEM-TIMESTMP            
           PERFORM 8774-INSERT-FH THRU 8774-EXIT.                       
                                                                        
       5523-EXIT.                                                       
           EXIT.                                                        
                                                                        
C33924 5560-BACKOUT-BILLADJ.                                            
C33924******************************************************************        
C33924**                                                              **        
C33924**    5560-BACKOUT-BILLADJ                                      **        
C33924**                                                              **        
C33924******************************************************************        
C33924                                                                  
C33924     MOVE WS-ORIG-BILL-NO TO BP-BILL-NO.                          
C33924     PERFORM 7810-FETCH-BILL-ADJ-CRSR THRU 7810-EXIT              
C33924     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C33924         GO TO 5560-EXIT
           END-IF.                                         
C33924                                                                  
C33924     MOVE WS-REBILL-BILL-NO TO BP-BILL-NO.                        
C33924     PERFORM 8010-INSERT-BILL-ADJ THRU 8010-EXIT.                 
C33924                                                                  
C33924 5560-EXIT.                                                       
C33924     EXIT.                                                        
C33924                                                                  
C33924 5570-REBILL-BILLADJ.                                             
C33924******************************************************************        
C33924**                                                              **        
C33924**    5570-REBILL-BILLADJ                                       **        
C33924**                                                              **        
C33924******************************************************************        
C33924                                                                  
C33924     PERFORM 7810-FETCH-BILL-ADJ-CRSR THRU 7810-EXIT.             
C33924                                                                  
C33924     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C33924         GO TO 5570-EXIT
           END-IF.                                         
C33924                                                                  
C33924     MOVE WS-REBILL-BILL-NO        TO BP-BILL-NO.                 
C33924     MOVE WS-CURRENT-TIMESTMP      TO BP-BILL-ITEM-TIMESTMP       
C33924     PERFORM 8010-INSERT-BILL-ADJ  THRU 8010-EXIT.                
C33924                                                                  
C33924 5570-EXIT.                                                       
C33924     EXIT.                                                        
      ******************************************************************        
      **                                                              **        
      **    5725-COPY-IDR                                             **        
      **                                                              **        
      ******************************************************************        
       5725-COPY-IDR.                                                   
                                                                        
           MOVE CX-METER-NO            TO IV-METER-NO.                  
           MOVE WS-C190-CODE-UTIL-TYPE TO IV-CODE-UTIL-TYPE             
           PERFORM 7700-OPEN-IDR-CRSR THRU 7700-EXIT.                   
           PERFORM 5726-COPY-IDR-ALL THRU 5726-EXIT                     
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
           PERFORM 7710-CLOSE-IDR-CRSR THRU 7710-EXIT.                  
                                                                        
       5725-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5730-COPY-DAILY                                           **        
      **                                                              **        
      ******************************************************************        
       5730-COPY-DAILY.                                                 
                                                                        
           MOVE WS-CURRENT-ACCOUNT        TO ND-ACCOUNT-NO              
           MOVE WS-ORIG-BILL-NO           TO ND-BILL-NO                 
           MOVE BG-CODE-UTIL-TYPE         TO ND-CODE-UTIL-TYPE          
           MOVE BG-IC-NO                  TO ND-IC-NO                   
           MOVE WS-ORIG-ITEM-TIMESTMP     TO ND-BILL-ITEM-TIMESTMP      
                                                                        
           PERFORM 7720-OPEN-DAILY-CRSR THRU 7720-EXIT.                 
           PERFORM 5736-COPY-DAILY-ALL  THRU 5736-EXIT                  
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
           PERFORM 7730-CLOSE-DAILY-CRSR THRU 7730-EXIT.                
                                                                        
       5730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5726-COPY-IDR-ALL                                         **        
      **                                                              **        
      ******************************************************************        
       5726-COPY-IDR-ALL.                                               
                                                                        
           PERFORM 7705-FETCH-IDR-CRSR  THRU 7705-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5726-EXIT
           END-IF.                                         
           MOVE WS-CURRENT-TIMESTMP TO IV-BILL-ITEM-TIMESTMP            
           PERFORM 7715-INSERT-IDR THRU 7715-EXIT                       
           MOVE CX-METER-NO             TO WS-METER-NO-HOLD.            
                                                                        
       5726-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5736-COPY-DAILY-ALL                                       **        
      **                                                              **        
      ******************************************************************        
       5736-COPY-DAILY-ALL.                                             
                                                                        
           PERFORM 7725-FETCH-DAILY-CRSR  THRU 7725-EXIT                
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5736-EXIT
           END-IF.                                         
                                                                        
           MOVE WS-REBILL-BILL-NO         TO ND-BILL-NO                 
      *    MOVE WS-REBILL-TIMESTMP        TO ND-BILL-ITEM-TIMESTMP              
           MOVE WS-CURRENT-TIMESTMP       TO ND-BILL-ITEM-TIMESTMP      
           PERFORM 7735-INSERT-DAILY-VOL  THRU 7735-EXIT.               
                                                                        
       5736-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00257**************************************************************            
P00257*  COPY CSS_VOL_DAILY DATA TO THE BACKOUT                                 
P00257**************************************************************            
P00257                                                                  
P00257 5737-COPY-DAILY-VOL.                                             
P00257                                                                  
P00257     PERFORM 7720-OPEN-DAILY-CRSR THRU 7720-EXIT.                 
P00257     PERFORM 5738-COPY-VOL-ALL THRU 5738-EXIT                     
P00257        UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
P00257     PERFORM 7730-CLOSE-DAILY-CRSR THRU 7730-EXIT.                
P00257                                                                  
P00257 5737-EXIT.                                                       
P00257     EXIT.                                                        
P00257                                                                  
P00257 5738-COPY-VOL-ALL.                                               
P00257                                                                  
P00257     PERFORM 7725-FETCH-DAILY-CRSR  THRU 7725-EXIT                
P00257     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
P00257         GO TO 5738-EXIT
           END-IF.                                         
P00257     MOVE WS-REBILL-BILL-NO         TO ND-BILL-NO                 
P00257     PERFORM 7735-INSERT-DAILY-VOL  THRU 7735-EXIT.               
P00257                                                                  
P00257                                                                  
P00257                                                                  
P00257 5738-EXIT.                                                       
P00257     EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5750-SHIFT-BILL-NO                                        **        
      **                                                              **        
      **     THIS MODULE IS USED TO 'SHIFT' AN EXISTING BILL HOOK     **        
      **     UP 1 BILL_NO IN ORDER THAT A REBILL HOOK CAN BE INSERTED **        
      **     AND THE PROPER ORDER OF BILL HOOKS IS MAINTAINED.        **        
      **                                                              **        
      ** WS-NUM-2-SHIFT-2-HIGH                                        **        
      **     = 0 WHEN MOVING EXISTING HOOK                            **        
      **     = MOVED HOOK'S PRIOR BILL_NO WHEN SETTING UP REBILL AND  **        
      **       BACKOUT                                                **        
      **                                                              **        
      **                                                              **        
      ** WS-NUM-SHIFT-FROM                                            **        
      **     = BILL_NO OF BILL BEING CANCELLED                        **        
      ******************************************************************        
       5750-SHIFT-BILL-NO.                                              
                                                                        
           IF WS-NUM-2-SHIFT-2-HIGH = ZERO                              
               ADD 1  AT-NXT-BILL-NO GIVING WS-NUM-2-SHIFT-2-HIGH       
                                              AT-NXT-BILL-NO            
               COMPUTE WS-NUM-SHIFT-FROM EQUAL                          
                                        WS-NUM-2-SHIFT-2-HIGH - 1       
               MOVE WS-NUM-SHIFT-FROM TO WS-REBILL-BILL-NO              
      *        PERFORM 7010-SELECT-CUR-TIMESTAMP THRU 7010-EXIT                 
               MOVE WS-CURRENT-TIMESTMP TO AT-LAST-UPDATE-TS            
               PERFORM 8999-UPDATE-ACCOUNT THRU 8999-EXIT               
           ELSE                                                         
               MOVE WS-NUM-2-SHIFT-2-HIGH TO WS-REBILL-BILL-NO          
               GO TO 5750-EXIT                                          
           END-IF                                                       
           MOVE WS-REBILL-BILL-NO         TO BI-BILL-NO                 
                                             BG-BILL-NO                 
           PERFORM 7771-SELECT-BILL-HEADER      THRU 7771-EXIT          
           PERFORM 5755-SHIFT-BILL-HEADER       THRU 5755-EXIT          
           PERFORM 7772-OPEN-BILL-DET-SHFT-CRSR THRU 7772-EXIT          
           PERFORM 5756-SHIFT-BILL-DETAIL-ALL THRU 5756-EXIT            
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
           PERFORM 7774-CLOSE-BILL-DET-SHFT-CRSR THRU 7774-EXIT         
           SET HAS-NO-CUST-PLAN           TO TRUE                       
           MOVE WS-NUM-SHIFT-FROM TO BI-BILL-NO                         
           PERFORM 8775-DELETE-BILL-HEADER THRU 8775-EXIT.              
       5750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5755-SHIFT-BILL-HEADER                                    **        
      **                                                              **        
      **  CREATE NEW FUTURE BILL HEADER                               **        
      ******************************************************************        
                                                                        
       5755-SHIFT-BILL-HEADER.                                          
                                                                        
           MOVE WS-NUM-2-SHIFT-2-HIGH TO BI-BILL-NO.                    
           MOVE WS-CURRENT-TIMESTMP TO BI-LAST-UPDATE-TS.               
           PERFORM 8770-INSERT-BILL-HEADER THRU 8770-EXIT.              
                                                                        
       5755-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5756-SHIFT-BILL-DETAIL-ALL                                **        
      **                                                              **        
      ******************************************************************        
       5756-SHIFT-BILL-DETAIL-ALL.                                      
                                                                        
           MOVE LOW-VALUES           TO BG-DATE-ORIG-BILL               
           MOVE SPACE                TO BG-RATE-PLAN-NO                 
           MOVE SPACE                TO BG-CODE-REVENUE-CLASS           
           PERFORM 7773-FETCH-BILL-DET-SHFT-CRSR  THRU 7773-EXIT        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5756-EXIT
           END-IF.                                         
NEWFIX*    IF BG-CODE-REVENUE-CLASS NOT EQUAL '000'                             
NEWFIX     IF BG-REV-RPT-CD         NOT EQUAL 'T'                       
              MOVE BI-BILL-NO        TO BG-BILL-NO                      
              IF BG-DATE-ORIG-BILL (6:2) NOT > ZERO                     
                  MOVE LOW-VALUES TO BG-DATE-ORIG-BILL                  
                  MOVE -1            TO WS-DATE-ORIG-BILL-NULL          
              ELSE                                                      
                  MOVE 0             TO WS-DATE-ORIG-BILL-NULL          
              END-IF                                                    
              IF BG-DATE-LFTM-HI-DMD (6:2) NOT > ZERO                   
                  MOVE LOW-VALUES TO BG-DATE-LFTM-HI-DMD                
                  MOVE -1 TO WS-DATE-LFTM-HI-DMD-NULL                   
              ELSE                                                      
                  MOVE 0 TO WS-DATE-LFTM-HI-DMD-NULL                    
              END-IF                                                    
              MOVE WS-HOLD-COMPANY-NO TO BG-COMPANY-NO                  
              PERFORM 8771-INSERT-BILL-DETAIL THRU 8771-EXIT            
           END-IF                                                       
                                                                        
           MOVE BG-ACCOUNT-NO               TO CP-ACCOUNT-NO            
           MOVE BG-CODE-UTIL-TYPE           TO CP-CODE-UTIL-TYPE        
           MOVE BG-IC-NO                    TO CP-IC-NO                 
           PERFORM 8225-SELECT-CUST-PLAN    THRU 8225-EXIT              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              SET HAS-CUST-PLAN             TO TRUE                     
           ELSE                                                         
              SET HAS-NO-CUST-PLAN          TO TRUE                     
           END-IF                                                       
           IF HAS-CUST-PLAN                                             
               MOVE BG-ACCOUNT-NO           TO UC-ACCOUNT-NO            
               MOVE WS-NUM-SHIFT-FROM       TO UC-BILL-NO               
               MOVE BG-CODE-UTIL-TYPE       TO UC-CODE-UTIL-TYPE        
               MOVE BG-IC-NO                TO UC-IC-NO                 
               MOVE BG-BILL-ITEM-TIMESTMP   TO UC-BILL-ITEM-TIMESTMP    
               PERFORM 7470-OPEN-UM-CRSR    THRU 7470-EXIT              
               PERFORM 5758-SHIFT-UC-CNSMPTN-HIST THRU 5758-EXIT        
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
               PERFORM 7476-CLOSE-UM-CRSR   THRU 7476-EXIT              
               GO TO 5756-EXIT                                          
           END-IF                                                       
                                                                        
           MOVE BG-ACCOUNT-NO           TO CX-ACCOUNT-NO                
           MOVE WS-NUM-SHIFT-FROM       TO CX-BILL-NO                   
           MOVE BG-CODE-UTIL-TYPE       TO CX-CODE-UTIL-TYPE            
           MOVE BG-IC-NO                TO CX-IC-NO                     
           MOVE BG-BILL-ITEM-TIMESTMP TO CX-BILL-ITEM-TIMESTMP          
           PERFORM 7550-OPEN-CX-REBILL-CRSR THRU 7550-EXIT              
           PERFORM 5759-SHIFT-CNSMPTN-HIST        THRU 5759-EXIT        
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
           PERFORM 7556-CLOSE-CX-REBILL-CRSR THRU 7556-EXIT             
                                                                        
           MOVE BG-ACCOUNT-NO           TO FH-ACCOUNT-NO                
           MOVE WS-NUM-SHIFT-FROM       TO FH-BILL-NO                   
           MOVE BG-CODE-UTIL-TYPE       TO FH-CODE-UTIL-TYPE            
           MOVE BG-IC-NO                TO FH-IC-NO                     
           MOVE BG-BILL-ITEM-TIMESTMP TO FH-BILL-ITEM-TIMESTMP          
           PERFORM 7490-OPEN-FH-MAINT-CRSR     THRU 7490-EXIT           
           PERFORM 5760-SHIFT-FH-HIST          THRU 5760-EXIT           
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
           PERFORM 7500-CLOSE-FH-CRSR        THRU 7500-EXIT             
C33924                                                                  
C33924     MOVE BG-ACCOUNT-NO           TO BP-ACCOUNT-NO                
P00496                                     NG-ACCOUNT-NO                
P00496                                     NU-ACCOUNT-NO.               
C33924     MOVE WS-NUM-SHIFT-FROM       TO BP-BILL-NO                   
P00496                                     NG-BILL-NO                   
P00496                                     NU-BILL-NO.                  
C33924     MOVE BG-CODE-UTIL-TYPE       TO BP-CODE-UTIL-TYPE            
P00496                                     NG-CODE-UTIL-TYPE            
P00496                                     NU-CODE-UTIL-TYPE.           
C33924     MOVE BG-IC-NO                TO BP-IC-NO                     
P00496                                     NG-IC-NO                     
P00496                                     NU-IC-NO.                    
C33924     MOVE BG-BILL-ITEM-TIMESTMP TO BP-BILL-ITEM-TIMESTMP          
P00496                                   NG-BILL-ITEM-TIMESTMP          
P00496                                   NU-BILL-ITEM-TIMESTMP.         
C33924     PERFORM 7800-OPEN-BILL-ADJ-CRSR  THRU 7800-EXIT.             
C33924     PERFORM 5780-SHIFT-BILLADJ       THRU 5780-EXIT              
C33924             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
C33924     PERFORM 7820-CLOSE-BILL-ADJ-CRSR THRU 7820-EXIT.             
P00496     PERFORM 7970-GET-BILL-MANUAL THRU 7970-EXIT.                 
P00496     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00496        PERFORM 7975-OPEN-BILLMAN-CRSR  THRU 7975-EXIT            
P00496        PERFORM 5940-SHIFT-BILLADJ      THRU 5940-EXIT            
P00496          UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND             
P00496        PERFORM 7985-CLOSE-BILLMAN-CRSR THRU 7985-EXIT            
P00496     END-IF.                                                      
                                                                        
           MOVE BG-ACCOUNT-NO              TO GA-ACCOUNT-NO             
           MOVE WS-NUM-SHIFT-FROM          TO GA-BILL-NO                
           MOVE BG-CODE-UTIL-TYPE          TO GA-CODE-UTIL-TYPE         
           MOVE BG-IC-NO                   TO GA-IC-NO                  
           MOVE BG-BILL-ITEM-TIMESTMP      TO GA-BILL-ITEM-TIMESTMP     
           PERFORM 7510-OPEN-MTR-CRSR      THRU 7510-EXIT               
           PERFORM 5770-COPY-MTR-ALL       THRU 5770-EXIT               
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND              
           PERFORM 7530-CLOSE-MTR-CRSR     THRU 7530-EXIT               
           .                                                            
       5756-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5758-SHIFT-UC-CNSMPTN-HIST.                               **        
      **                                                              **        
      ******************************************************************        
       5758-SHIFT-UC-CNSMPTN-HIST.                                      
                                                                        
           MOVE WS-NUM-SHIFT-FROM             TO UC-BILL-NO             
           PERFORM 7475-FETCH-UM-CRSR         THRU 7475-EXIT            
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5758-EXIT
           END-IF.                                         
           MOVE WS-NUM-2-SHIFT-2-HIGH         TO UC-BILL-NO             
           PERFORM 8015-INSERT-UM-CNSMPTN-ROW THRU 8015-EXIT            
           .                                                            
       5758-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5759-SHIFT-CNSMPTN-HIST.                                  **        
      **                                                              **        
      ******************************************************************        
       5759-SHIFT-CNSMPTN-HIST.                                         
                                                                        
           PERFORM 7555-FETCH-CX-REBILL-CRSR THRU 7555-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5759-EXIT
           END-IF.                                         
                                                                        
P00251     IF CX-CODE-USAGE-SOURCE = 'K' OR 'J'                         
P00251*--- DO NOT COPY CONSUMPTION FROM AN ADDITIVE                             
P00251*--- OR SUBTRACTIVE METER.  THESE WILL BE                                 
P00251*--- REGENERATED IN SCSCA104.                                             
P00251        GO TO 5759-EXIT
           END-IF.                                          
                                                                        
           MOVE WS-NUM-2-SHIFT-2-HIGH      TO CX-BILL-NO.               
           IF WS-REBILL-TIMESTMP NOT EQUAL SPACES                       
              MOVE WS-REBILL-TIMESTMP      TO CX-BILL-ITEM-TIMESTMP     
           END-IF                                                       
           PERFORM 8020-INSERT-CNSMPTN-ROW THRU 8020-EXIT.              
                                                                        
       5759-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5760-SHIFT-FH-HIST                                        **        
      **                                                              **        
      ******************************************************************        
       5760-SHIFT-FH-HIST.                                              
                                                                        
           PERFORM 7495-FETCH-FH-MAINT-CRSR THRU 7495-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5760-EXIT
           END-IF.                                         
           MOVE WS-NUM-2-SHIFT-2-HIGH TO FH-BILL-NO.                    
           PERFORM 8774-INSERT-FH THRU 8774-EXIT.                       
                                                                        
       5760-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5770-COPY-MTR-ALL                                         **        
      **                                                              **        
      ******************************************************************        
       5770-COPY-MTR-ALL.                                               
                                                                        
           PERFORM 7520-FETCH-MTR-CRSR      THRU 7520-EXIT              
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5770-EXIT
           END-IF.                                         
           MOVE WS-NUM-2-SHIFT-2-HIGH       TO GA-BILL-NO               
           PERFORM 8776-INSERT-MTR-ID-HST   THRU 8776-EXIT.             
                                                                        
       5770-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5772-COPY-MTR-ALL                                         **        
      **                                                              **        
      ******************************************************************        
       5772-COPY-MTR-ALL.                                               
                                                                        
           PERFORM 7520-FETCH-MTR-CRSR      THRU 7520-EXIT              
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5772-EXIT
           END-IF.                                         
           MOVE WS-REBILL-BILL-NO           TO GA-BILL-NO               
           MOVE WS-CURRENT-TIMESTMP         TO GA-BILL-ITEM-TIMESTMP    
           PERFORM 8776-INSERT-MTR-ID-HST   THRU 8776-EXIT.             
                                                                        
       5772-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5773-BACKOUT-MTR-ALL                                     **         
      **                                                              **        
      ******************************************************************        
       5773-BACKOUT-MTR-ALL.                                            
                                                                        
           PERFORM 7520-FETCH-MTR-CRSR      THRU 7520-EXIT              
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               GO TO 5773-EXIT
           END-IF.                                         
           MOVE WS-REBILL-BILL-NO           TO GA-BILL-NO               
           PERFORM 8776-INSERT-MTR-ID-HST   THRU 8776-EXIT.             
                                                                        
       5773-EXIT.                                                       
           EXIT.                                                        
                                                                        
C33924 5780-SHIFT-BILLADJ.                                              
C33924******************************************************************        
C33924**                                                              **        
C33924**    5780-SHIFT-BILLADJ                                        **        
C33924**                                                              **        
C33924******************************************************************        
C33924                                                                  
C33924     PERFORM 7810-FETCH-BILL-ADJ-CRSR THRU 7810-EXIT.             
C33924     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C33924         GO TO 5780-EXIT
           END-IF.                                         
C33924                                                                  
C33924     MOVE WS-NUM-2-SHIFT-2-HIGH TO BP-BILL-NO.                    
C33924     PERFORM 8010-INSERT-BILL-ADJ  THRU 8010-EXIT.                
C33924                                                                  
C33924 5780-EXIT.                                                       
C33924     EXIT.                                                        
C33924                                                                  
P00496******************************************************************04914000
P00496*  5920-BACKOUT-BILLMAN.                                         *04915000
P00496******************************************************************04916000
P00496 5920-BACKOUT-BILLMAN.                                            
P00496*                                                                         
P00496     PERFORM 7980-FETCH-BILLADJ-CRSR THRU 7980-EXIT               
P00496     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00496        MOVE WS-ORIG-BILL-NO TO NG-BILL-NO                        
P00496                                NU-BILL-NO                        
P00496        PERFORM 8030-INSERT-BILLMAN THRU 8030-EXIT                
P00496        PERFORM 8040-INSERT-MANDET  THRU 8040-EXIT                
P00496     END-IF.                                                      
P00496*                                                                         
P00496 5920-EXIT.                                                       
P00496     EXIT.                                                        
P00496                                                                  
P00496******************************************************************04914000
P00496*  5930-REBILL-BILLMAN.                                          *04915000
P00496******************************************************************04916000
P00496 5930-REBILL-BILLMAN.                                             
P00496*                                                                         
P00496     PERFORM 7980-FETCH-BILLADJ-CRSR THRU 7980-EXIT               
P00496     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00496        MOVE WS-REBILL-BILL-NO     TO NG-BILL-NO                  
P00496                                      NU-BILL-NO                  
P00496        MOVE BG-BILL-ITEM-TIMESTMP TO NG-BILL-ITEM-TIMESTMP       
P00496                                      NU-BILL-ITEM-TIMESTMP       
P00496        PERFORM 8030-INSERT-BILLMAN THRU 8030-EXIT                
P00496        PERFORM 8040-INSERT-MANDET  THRU 8040-EXIT                
P00496     END-IF.                                                      
P00496*                                                                         
P00496 5930-EXIT.                                                       
P00496     EXIT.                                                        
                                                                        
P00496******************************************************************04914000
P00496*  5940-SHIFT-BILLADJ.                                           *04915000
P00496******************************************************************04916000
P00496 5940-SHIFT-BILLADJ.                                              
P00496*                                                                         
P00496     PERFORM 7980-FETCH-BILLADJ-CRSR THRU 7980-EXIT               
P00496     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00496        MOVE WS-NUM-2-SHIFT-2-HIGH TO NG-BILL-NO                  
P00496                                      NU-BILL-NO                  
P00496        PERFORM 8030-INSERT-BILLMAN THRU 8030-EXIT                
P00496        PERFORM 8040-INSERT-MANDET  THRU 8040-EXIT                
P00496     END-IF.                                                      
P00496*                                                                         
P00496 5940-EXIT.                                                       
P00496     EXIT.                                                        
P00496                                                                  
      ******************************************************************        
      **   7005-GET-ACCOUNT-INFO                                      **        
      **        SELECT NEXT BILL NUMBER FROM CSS_ACCOUNT              **        
      ******************************************************************        
       7005-GET-ACCOUNT-INFO.                                           
                                                                        
           MOVE '7005' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT CUSTOMER_NO,                                      
                      CODE_ACCT_STAT,                                   
                      CODE_BILL_PEND,                                   
                      COMPANY_NO,                                       
                      CODE_COMPANY_ACCT,                                
C35005                CODE_TEMP_BILL,                                   
C35005                NXT_BILL_NO,                                      
C35005                CODE_DISC_OK,                                     
C35005                NOTICE_EXEMPT_CD,                                 
C35005                CODE_LPC_XMT,                                     
C35005                IVR_EXEMPT_CD                                     
                 INTO :AT-CUSTOMER-NO,                                  
                      :AT-CODE-ACCT-STAT,                               
                      :AT-CODE-BILL-PEND,                               
                      :AT-COMPANY-NO,                                   
                      :AT-CODE-COMPANY-ACCT,                            
C35005                :AT-CODE-TEMP-BILL,                               
C35005                :AT-NXT-BILL-NO,                                  
C35005                :AT-CODE-DISC-OK,                                 
C35005                :AT-NOTICE-EXEMPT-CD,                             
C35005                :AT-CODE-LPC-XMT,                                 
C35005                :AT-IVR-EXEMPT-CD                                 
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
C33924                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO,                                              
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               CODE_BILL_PEND,                                           
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               CODE_COMPANY_ACCT,                                        
MFA-TR*               CODE_TEMP_BILL,                                           
MFA-TR*               NXT_BILL_NO,                                              
MFA-TR*               CODE_DISC_OK,                                             
MFA-TR*               NOTICE_EXEMPT_CD,                                         
MFA-TR*               CODE_LPC_XMT,                                             
MFA-TR*               IVR_EXEMPT_CD                                             
MFA-TR*          INTO :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-CODE-BILL-PEND,                                       
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-CODE-COMPANY-ACCT,                                    
MFA-TR*               :AT-CODE-TEMP-BILL,                                       
MFA-TR*               :AT-NXT-BILL-NO,                                          
MFA-TR*               :AT-CODE-DISC-OK,                                         
MFA-TR*               :AT-NOTICE-EXEMPT-CD,                                     
MFA-TR*               :AT-CODE-LPC-XMT,                                         
MFA-TR*               :AT-IVR-EXEMPT-CD                                         
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7005'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
      ******************************************************************        
      **    7010-SELECT-CUR-TIMESTAMP                                 **        
      **                                                              **        
      **  GET CURRENT TIMESTAMP                                       **        
      ******************************************************************        
       7010-SELECT-CUR-TIMESTAMP.                                       
                                                                        
           MOVE '7010' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 12                        TO RS-RETURN-CODE          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7020-SELECT-CUR-DATE                                      **        
      **                                                              **        
      **  GET CURRENT DATE                                            **        
      ******************************************************************        
       7020-SELECT-CUR-DATE.                                            
                                                                        
           MOVE '7020' TO ACTIVE-PARAGRAPH.                             
                                                                        
            EXEC SQL                                                    
C35005         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
      ******************************************************************        
      **    7420-OPEN-BG-CRSR                                         **        
      **                                                              **        
      **  OPEN THE CURSOR DECLARED FOR CSS_BILLING_DET TABLE. THIS    **        
      **  CURSOR IS USED TO REBILL ALL EXISTING BGS FOR A GIVEN UTIL  **        
      **  TYPE                                                        **        
      ******************************************************************        
       7420-OPEN-BG-CRSR.                                               
                                                                        
           MOVE '7420' TO ACTIVE-PARAGRAPH.                             
                                                                        
ACT142 7420-START.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN BG_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT142                                                                  
ACT142     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT142     WHEN SUCCESSFUL-CALL                                         
ACT142        CONTINUE                                                  
ACT142     WHEN OTHER                                                   
ACT142        IF WS-ACTIVE-RETURN-CODE = WS-502 AND WS-RETRY-COUNT = 0  
ACT142          ADD 1 TO WS-RETRY-COUNT                                 
ACT142          PERFORM 7440-CLOSE-BG-CRSR THRU 7440-EXIT               
ACT142          GO TO 7420-START                                        
ACT142        END-IF                                                    
ACT142        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
ACT142        MOVE SQLCODE                   TO ABEND-SQLCODE           
ACT142        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT142        MOVE '7420'                    TO ACTIVE-PARAGRAPH        
ACT142        MOVE 'OPEN'                    TO ABEND-FUNCTION          
ACT142        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT142                                          ABEND-TABLES            
ACT142        MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
ACT142        MOVE SPACES                    TO TABLE-ELEMENT-1         
ACT142        MOVE ZEROES                    TO HOSTVAR-ELEMENT-1       
ACT142        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT142     END-EVALUATE.                                                
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7430-FETCH-BG-CRSR                                        **        
      **                                                              **        
      **  FETCH THE CURSOR DECLARED FOR CSS_BILLING_DET TABLE.        **        
      **  CURSOR IS USED TO REBILL ALL EXISTING BGS FOR A GIVEN UTIL  **        
      **  TYPE                                                        **        
      ******************************************************************        
       7430-FETCH-BG-CRSR.                                              
                                                                        
           MOVE '7430' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               FETCH BG_CRSR                                            
                    INTO :BG-PREMISE-NO,                                
                         :BG-BILL-NO,                                   
                         :BG-CODE-UTIL-TYPE,                            
                         :BG-IC-NO,                                     
                         :BG-BILL-ITEM-TIMESTMP,                        
                         :BG-DATE-ORIG-BILL :WS-DATE-ORIG-BILL-NULL,     
                         :BG-AMT-BILL-ITEM,                             
                         :BG-CODE-BILL-CALC,                            
                         :BG-CODE-BILL-ITM-TYPE,                        
                         :BG-CODE-BILL-ITM-IND,                         
                         :BG-CODE-DR-CR-CNSMPTN,                        
                         :BG-AMT-STATE-TAX,                             
                         :BG-AMT-CITY-TAX,                              
                         :BG-AMT-OTHER-TAX,                             
                         :BG-CODE-REVENUE-CLASS,                        
                         :BG-CODE-SIC-NO,                               
                         :BG-RATE-PLAN-NO,                              
                         :BG-CODE-CURTAIL-PRTY,                         
                         :BG-CODE-STAT-TAX-XMT,                         
                         :BG-CODE-CITY-TAX-XMT,                         
                         :BG-CODE-OTHR-TAX-XMT,                         
                         :BG-REV-RPT-CD,                                
                         :BG-STANDBY-COMPLIED,                          
                         :BG-PRORATE-CD,                                
                         :BG-NEW-RATE-PCT,                              
                         :BG-CODE-SUB-TOTAL,                            
                         :BG-TAX-REFUND-CD,                             
                         :BG-ACCOUNT-NO,                                
                         :BG-COMPANY-NO,                                
                         :BG-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD-NULL, 
                         :BG-LFTM-HI-PEAK-DMD,                          
                         :BG-REBILL-IND,                                
                         :BG-ADJ-REASON-CD,                             
                         :BG-REVENUE-MONTH,                             
                         :BG-GAS-BASE-USE,                              
                         :BG-WNA-FACTOR,                                
                         :BG-BTU-FACTOR,                                
                         :BG-NO-OF-CONS-DAYS,                           
                         :BG-REV-MTH-ORIG-BILL,                         
                         :BG-REV-DISTRICT-CD,                           
                         :BG-FUEL-SHIPPER-CD,                           
                         :BG-ALTERNATE-FUEL-CD,                         
                         :BG-TRNSP-OVER-MDQ-FL,                         
C29528                   :BG-CITY-TAX-RATE,                             
C34569                   :BG-OTHER-TAX-RATE,                            
C29528                   :BG-STATE-TAX-RATE,                            
C33362                   :BG-BILL-CALC-CYCLE,                           
C34569                   :BG-NAICS-CD,                                  
C34569                   :BG-RT-PKG-OPT-SEQ-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-RETURN-CODE-NUM                           
                           BG-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C33500        IF WS-DATE-ORIG-BILL-NULL < 0                             
C33500           MOVE LOW-VALUES  TO BG-DATE-ORIG-BILL                  
C33500        END-IF                                                    
C33500        IF WS-DATE-LFTM-HI-DMD-NULL < 0                           
C33500           MOVE LOW-VALUES  TO BG-DATE-LFTM-HI-DMD                
C33500        END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7430'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE WS-IC-NO-MIN              TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7440-CLOSE-BG-CRSR                                        **        
      **                                                              **        
      **  CLOSE THE CURSOR DECLARED FOR CSS_BILLING_DET TABLE.        **        
      **  CURSOR IS USED TO REBILL ALL EXISTING BGS FOR A GIVEN UTIL  **        
      **  TYPE                                                        **        
      ******************************************************************        
       7440-CLOSE-BG-CRSR.                                              
                                                                        
           MOVE '7440' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               CLOSE BG_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7440'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7421-OPEN-BGCIG-CRSR                                      **        
      **                                                              **        
      **  OPEN THE CURSOR DECLARED FOR CSS_BILLING_DET TABLE. THIS    **        
      **  CURSOR IS USED TO REBILL ALL EXISTING BGS FOR A GIVEN UTIL  **        
      **  TYPE FOR THAT REVENUE MONTH FOR A CIG ACCOUNT               **        
      ******************************************************************        
       7421-OPEN-BGCIG-CRSR.                                            
                                                                        
           MOVE '7421' TO ACTIVE-PARAGRAPH.                             
                                                                        
ACT142 7421-START.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN BGCIG_CRSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT142                                                                  
ACT142     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT142     WHEN SUCCESSFUL-CALL                                         
ACT142        CONTINUE                                                  
ACT142     WHEN OTHER                                                   
ACT142        IF WS-ACTIVE-RETURN-CODE = WS-502 AND WS-RETRY-COUNT = 0  
ACT142          ADD 1 TO WS-RETRY-COUNT                                 
ACT142          PERFORM 7423-CLOSE-BGCIG-CRSR THRU 7423-EXIT            
ACT142          GO TO 7421-START                                        
ACT142        END-IF                                                    
ACT142        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
ACT142        MOVE SQLCODE                   TO ABEND-SQLCODE           
ACT142        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT142        MOVE '7421'                    TO ACTIVE-PARAGRAPH        
ACT142        MOVE 'OPEN'                    TO ABEND-FUNCTION          
ACT142        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT142                                          ABEND-TABLES            
ACT142        MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
ACT142        MOVE SPACES                    TO TABLE-ELEMENT-1         
ACT142        MOVE ZEROES                    TO HOSTVAR-ELEMENT-1       
ACT142        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT142     END-EVALUATE.                                                
                                                                        
       7421-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7422-FETCH-BGCIG-CRSR                                     **        
      **                                                              **        
      **  FETCH THE CURSOR DECLARED FOR CSS_BILLING_DET TABLE.        **        
      **  CURSOR IS USED TO REBILL ALL EXISTING BGS FOR A GIVEN UTIL  **        
      **  TYPE FOR A GIVEN REVENUE MONTH FOR CIG ACCOUNTS             **        
      ******************************************************************        
       7422-FETCH-BGCIG-CRSR.                                           
                                                                        
           MOVE '7422' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               FETCH BGCIG_CRSR                                         
                    INTO :BG-PREMISE-NO,                                
                         :BG-BILL-NO,                                   
                         :BG-CODE-UTIL-TYPE,                            
                         :BG-IC-NO,                                     
                         :BG-BILL-ITEM-TIMESTMP,                        
                         :BG-DATE-ORIG-BILL :WS-DATE-ORIG-BILL-NULL,     
                         :BG-AMT-BILL-ITEM,                             
                         :BG-CODE-BILL-CALC,                            
                         :BG-CODE-BILL-ITM-TYPE,                        
                         :BG-CODE-BILL-ITM-IND,                         
                         :BG-CODE-DR-CR-CNSMPTN,                        
                         :BG-AMT-STATE-TAX,                             
                         :BG-AMT-CITY-TAX,                              
                         :BG-AMT-OTHER-TAX,                             
                         :BG-CODE-REVENUE-CLASS,                        
                         :BG-CODE-SIC-NO,                               
                         :BG-RATE-PLAN-NO,                              
                         :BG-CODE-CURTAIL-PRTY,                         
                         :BG-CODE-STAT-TAX-XMT,                         
                         :BG-CODE-CITY-TAX-XMT,                         
                         :BG-CODE-OTHR-TAX-XMT,                         
                         :BG-REV-RPT-CD,                                
                         :BG-STANDBY-COMPLIED,                          
                         :BG-PRORATE-CD,                                
                         :BG-NEW-RATE-PCT,                              
                         :BG-CODE-SUB-TOTAL,                            
                         :BG-TAX-REFUND-CD,                             
                         :BG-ACCOUNT-NO,                                
                         :BG-COMPANY-NO,                                
                         :BG-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD-NULL, 
                         :BG-LFTM-HI-PEAK-DMD,                          
                         :BG-REBILL-IND,                                
                         :BG-ADJ-REASON-CD,                             
                         :BG-REVENUE-MONTH,                             
                         :BG-GAS-BASE-USE,                              
                         :BG-WNA-FACTOR,                                
                         :BG-BTU-FACTOR,                                
                         :BG-NO-OF-CONS-DAYS,                           
                         :BG-REV-MTH-ORIG-BILL,                         
                         :BG-REV-DISTRICT-CD,                           
C34569                   :BG-FUEL-SHIPPER-CD,                           
                         :BG-ALTERNATE-FUEL-CD,                         
                         :BG-TRNSP-OVER-MDQ-FL,                         
C29528                   :BG-CITY-TAX-RATE,                             
C34569                   :BG-OTHER-TAX-RATE,                            
C29528                   :BG-STATE-TAX-RATE,                            
C33362                   :BG-BILL-CALC-CYCLE,                           
C34569                   :BG-NAICS-CD,                                  
C34569                   :BG-RT-PKG-OPT-SEQ-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-RETURN-CODE-NUM                           
                           BG-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7422'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE WS-IC-NO-MIN              TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7422-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7423-CLOSE-BGCIG-CRSR                                     **        
      **                                                              **        
      **  CLOSE THE CURSOR DECLARED FOR CSS_BILLING_DET TABLE.        **        
      **  CURSOR IS USED TO REBILL ALL EXISTING BGS FOR A GIVEN UTIL  **        
      **  TYPE FOR A REVENUE MONTH FOR CIG ACCOUNTS                   **        
      ******************************************************************        
       7423-CLOSE-BGCIG-CRSR.                                           
                                                                        
           MOVE '7423' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               CLOSE BGCIG_CRSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7423'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7423-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7470-OPEN-UM-CRSR                                         **        
      **                                                              **        
      ** FETCH THE CURSOR DECLARED FOR CSS_UM_CNSMPT_HIST TABLE.      **        
      ** THIS CURSOR IS USED IN MAINTAINING UNMETERED CONSUMPTION HIS-**        
      ** TORY ROWS.                                                   **        
      ******************************************************************        
       7470-OPEN-UM-CRSR.                                               
                                                                        
           MOVE '7470' TO ACTIVE-PARAGRAPH.                             
                                                                        
ACT142 7470-START.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN UM_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT142                                                                  
ACT142     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT142     WHEN SUCCESSFUL-CALL                                         
ACT142        CONTINUE                                                  
ACT142     WHEN OTHER                                                   
ACT142        IF WS-ACTIVE-RETURN-CODE = WS-502 AND WS-RETRY-COUNT = 0  
ACT142          ADD 1 TO WS-RETRY-COUNT                                 
ACT142          PERFORM 7476-CLOSE-UM-CRSR    THRU 7476-EXIT            
ACT142          GO TO 7470-START                                        
ACT142        END-IF                                                    
ACT142        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
ACT142        MOVE SQLCODE                   TO ABEND-SQLCODE           
ACT142        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT142        MOVE '7470'                    TO ACTIVE-PARAGRAPH        
ACT142        MOVE 'OPEN'                    TO ABEND-FUNCTION          
ACT142        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT142                                          ABEND-TABLES            
ACT142        MOVE 'CSS_UM_CNSMPT_HIST'      TO TABLE-1                 
ACT142        MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
ACT142        MOVE UC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
ACT142        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT142     END-EVALUATE.                                                
                                                                        
       7470-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7470-FETCH-UM-CRSR                                        **        
      **                                                              **        
      ** FETCH THE CURSOR DECLARED FOR CSS_UM_CNSMPT_HIST TABLE.      **        
      ** THIS CURSOR IS USED IN MAINTAINING UNMETERED CONSUMPTION     **        
      ** HISTORY ROWS.                                                **        
      ******************************************************************        
       7475-FETCH-UM-CRSR.                                              
                                                                        
           MOVE '7475' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               FETCH UM_CRSR                                            
                    INTO :UC-RATE-ITEM-CODE,                            
                         :UC-ITEM-SEQ-NO,                               
                         :UC-NO-UNITS,                                  
                         :UC-NO-DAYS,                                   
                         :UC-CODE-DEBIT-CREDIT,                         
                         :UC-USAGE-FIXED,                               
                         :UC-DATE-USAGE-ENDS :WS-DATE-USAGE-ENDS-NULL,   
                         :UC-CODE-SERVICE-TYPE,                         
                         :UC-CODE-ITEM-STATUS,                          
                         :UC-CODE-SOURCE-ID,                            
                         :UC-MTHLY-AMOUNT-FIXED,                        
                         :UC-DIST-NO,                                   
                         :UC-LIGHT-NO,                                  
                         :UC-POLE-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7475'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_UM_CNSMPT_HIST'      TO TABLE-1                 
              MOVE UC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE UC-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE UC-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7475-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7476-CLOSE-UM-CRSR                                        **        
      **                                                              **        
      ** CLOSE THE CURSOR DECLARED FOR CSS_UM_CNSMPT_HIST TABLE.      **        
      ******************************************************************        
       7476-CLOSE-UM-CRSR.                                              
                                                                        
           MOVE '7476' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               CLOSE UM_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7476'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_UM_CNSMPT_HIST'      TO TABLE-1                 
              MOVE UC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7476-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7490-OPEN-FH-MAINT-CRSR.                                         
      ******************************************************************        
      *                                                               **        
      *  OPEN  THE CURSOR DECLARED FOR CSS_FIXED_FCT_HIST TABLE.      **        
      *  THIS CURSOR IS USED IN MAINTAINING FIXED FACTOR HISTORY ROWS.**        
      *                                                               **        
      ******************************************************************        
                                                                        
           MOVE '7490' TO ACTIVE-PARAGRAPH.                             
                                                                        
ACT142 7490-START.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN FIX_FCTR_HST_CRSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT142                                                                  
ACT142     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT142     WHEN SUCCESSFUL-CALL                                         
ACT142        CONTINUE                                                  
ACT142     WHEN OTHER                                                   
ACT142        IF WS-ACTIVE-RETURN-CODE = WS-502 AND WS-RETRY-COUNT = 0  
ACT142          ADD 1 TO WS-RETRY-COUNT                                 
ACT142          PERFORM 7500-CLOSE-FH-CRSR    THRU 7500-EXIT            
ACT142          GO TO 7490-START                                        
ACT142        END-IF                                                    
ACT142        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
ACT142        MOVE SQLCODE                   TO ABEND-SQLCODE           
ACT142        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT142        MOVE '7490'                    TO ACTIVE-PARAGRAPH        
ACT142        MOVE 'OPEN'                    TO ABEND-FUNCTION          
ACT142        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT142                                          ABEND-TABLES            
ACT142        MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
ACT142        MOVE SPACES                    TO TABLE-ELEMENT-1         
ACT142        MOVE FH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
ACT142        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT142     END-EVALUATE.                                                
                                                                        
       7490-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7495-FETCH-FH-MAINT-CRSR.                                        
      ******************************************************************        
      *  FETCH THE CURSOR DECLARED FOR CSS_FIXED_FCT_HIST              *        
      *  THIS CURSOR IS USED IN MAINTAINING FIXED FACTOR HISTORY ROWS. *        
      ******************************************************************        
                                                                        
           MOVE '7495' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               FETCH FIX_FCTR_HST_CRSR                                  
                      INTO  :FH-FIXED-FCTR-SEQ-NO,                      
                            :FH-FACTOR-ID,                              
                            :FH-EFF-DATE-FROM :WS-EFF-DATE-FROM-NULL,    
                            :FH-CMPNT-ID-CD,                            
                            :FH-CODE-SEASON,                            
                            :FH-INSTR-USE-TYPE-CD,                      
                            :FH-CODE-TIME-PERIOD,                       
                            :FH-CODE-DEBIT-CREDIT,                      
                            :FH-CODE-REVENUE-CLASS,                     
                            :FH-CODE-TAX-STAT-XMT,                      
                            :FH-CODE-TAX-CITY-XMT,                      
                            :FH-CODE-TAX-OTHR-XMT,                      
                            :FH-FACTOR,                                 
                            :FH-EFF-DATE-TO :WS-EFF-DATE-TO-NULL,        
                            :FH-FIXED-FCTR-TYP-CD,                      
                            :FH-BILL-UNITS,                             
                            :FH-ENERGY-UNIT-CD,                         
C34569                      :FH-DURATION-REMAIN-NO :WS-DURATION-NULL,    
C34569                      :FH-OVR-RT-VER-PRO-FL,                      
C34569                      :FH-RT-PKG-OPT-SEQ-NO,                      
C34569                      :WS-FACTOR-HISTORY-CD,                      
P00165                      :FH-BLOCK-NO,                               
P00496                      :FH-FCTR-POWER-10                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              NOT-FOUND                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7495'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE FH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FH-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE FH-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7495-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-CLOSE-FH-CRSR.                                              
      ******************************************************************        
      *                                                                *        
      *  CLOSE THE CURSOR DECLARED CSS_FIXED_FCT_HIST FOR BILL HOOK    *        
      *  SHIFT.                                                        *        
      ******************************************************************        
                                                                        
           MOVE '7500' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               CLOSE FIX_FCTR_HST_CRSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE FH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7510-OPEN-MTR-CRSR.                                              
                                                                        
      ******************************************************************        
      *  OPEN THE CURSOR DECLARED FOR CSS_MTR_IDENT_HIST.              *        
      ******************************************************************        
                                                                        
           MOVE '7510' TO ACTIVE-PARAGRAPH.                             
                                                                        
ACT142 7510-START.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN MTR_IDENT_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT142                                                                  
ACT142     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT142     WHEN SUCCESSFUL-CALL                                         
ACT142        CONTINUE                                                  
ACT142     WHEN OTHER                                                   
ACT142        IF WS-ACTIVE-RETURN-CODE = WS-502 AND WS-RETRY-COUNT = 0  
ACT142          ADD 1 TO WS-RETRY-COUNT                                 
ACT142          PERFORM 7530-CLOSE-MTR-CRSR   THRU 7530-EXIT            
ACT142          GO TO 7510-START                                        
ACT142        END-IF                                                    
ACT142        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
ACT142        MOVE SQLCODE                   TO ABEND-SQLCODE           
ACT142        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT142        MOVE '7510'                    TO ACTIVE-PARAGRAPH        
ACT142        MOVE 'OPEN'                    TO ABEND-FUNCTION          
ACT142        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT142                                          ABEND-TABLES            
ACT142        MOVE 'CSS_MTR_IDENT_HIST'      TO TABLE-1                 
ACT142        MOVE SPACES                    TO TABLE-ELEMENT-1         
ACT142        MOVE GA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
ACT142        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT142     END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7520-FETCH-MTR-CRSR.                                             
                                                                        
      ******************************************************************        
      *  SELECT A MTR IDENT HIST ROW.                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               FETCH MTR_IDENT_CRSR                                     
                INTO :GA-MTR-REF-NO,                                    
                     :GA-METER-NO,                                      
                     :GA-IDR-IDENT-NO,                                  
                     :GA-INTERVALS-PER-HR,                              
                     :GA-CHANNEL-A-UOM,                                 
                     :GA-CHANNEL-B-UOM,                                 
                     :GA-CHANNEL-C-UOM,                                 
                     :GA-IDR-INFO-RETENT-DT :WS-IDR-INFO-NULL-IND,       
                     :GA-CT-UPPER-RATIO,                                
                     :GA-PT-UPPER-RATIO,                                
                     :GA-CT-LOWER-RATIO,                                
                     :GA-PT-LOWER-RATIO,                                
                     :GA-INDUST-BTU-ID                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              NOT-FOUND                                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7520'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTR_IDENT_HIST'      TO TABLE-1                 
              MOVE GA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE GA-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE GA-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7530-CLOSE-MTR-CRSR.                                             
                                                                        
      ******************************************************************        
      *  CLOSE THE CURSOR DECLARED CSS_MTR_IDENT_HIST                  *        
      ******************************************************************        
           EXEC SQL                                                     
               CLOSE MTR_IDENT_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7530'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTR_IDENT_HIST'      TO TABLE-1                 
              MOVE GA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7550-OPEN-CX-REBILL-CRSR.                                        
                                                                        
      ******************************************************************        
      *  OPEN THE CURSOR DECLARED FOR CSS_CNSMPTN_HIST TABLE.          *        
      *  THIS CURSOR IS USED FOR REBILLING METERED CONSUMPTION ROWS.   *        
      ******************************************************************        
                                                                        
           MOVE '7550' TO ACTIVE-PARAGRAPH.                             
                                                                        
ACT142 7550-START.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN CNS_REBILL_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT142                                                                  
ACT142     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT142     WHEN SUCCESSFUL-CALL                                         
ACT142        CONTINUE                                                  
ACT142     WHEN OTHER                                                   
ACT142        IF WS-ACTIVE-RETURN-CODE = WS-502 AND WS-RETRY-COUNT = 0  
ACT142          ADD 1 TO WS-RETRY-COUNT                                 
ACT142          PERFORM 7556-CLOSE-CX-REBILL-CRSR THRU 7556-EXIT        
ACT142          GO TO 7550-START                                        
ACT142        END-IF                                                    
ACT142        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
ACT142        MOVE SQLCODE                   TO ABEND-SQLCODE           
ACT142        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT142        MOVE '7550'                    TO ACTIVE-PARAGRAPH        
ACT142        MOVE 'OPEN'                    TO ABEND-FUNCTION          
ACT142        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT142                                          ABEND-TABLES            
ACT142        MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
ACT142        MOVE SPACES                    TO TABLE-ELEMENT-1         
ACT142        MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
ACT142        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT142     END-EVALUATE.                                                
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7555-FETCH-CX-REBILL-CRSR.                                       
                                                                        
      ******************************************************************        
      *  FETCH THE CURSOR DECLARED FOR CSS_CNSMPTN_HIST TABLE.         *        
      *  THIS CURSOR IS USED FOR REBILLING METERED CONSUMPTION ROWS.   *        
      ******************************************************************        
                                                                        
           MOVE '7555' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               FETCH CNS_REBILL_CRSR                                    
                      INTO :CX-MTR-REF-NO,                              
                           :CX-REG-ID-NO,                               
                           :CX-CODE-TIME-PERIOD,                        
                           :CX-ITEM-SEQ-NO,                             
                           :CX-CODE-USAGE-TYPE,                         
                           :CX-CODE-USAGE-ID,                           
                           :CX-CODE-USAGE-SOURCE,                       
                           :CX-METER-NO,                                
                           :CX-DATE-READ :WS-DATE-READ-NULL,             
                           :CX-CODE-METER-READ,                         
                           :CX-CODE-METER-NO-READ,                      
                           :CX-METER-READING,                           
                           :CX-DEMAND-READING,                          
                           :CX-EMPLOYEE-NO,                             
                           :CX-NO-UNITS,                                
                           :CX-NO-DEMAND-UNITS,                         
                           :CX-NO-DAYS,                                 
                           :CX-CODE-SOURCE-ID,                          
                           :CX-CODE-DEBIT-CREDIT,                       
                           :CX-CODE-ITEM-STATUS,                        
                           :CX-CODE-DISCOUNT,                           
                           :CX-CONSTANT,                                
                           :CX-NO-DIALS,                                
                           :CX-COMPANY-NO,                              
                           :CX-EXCEPT-OVERRIDE-CD,                      
                           :CX-REQUESTED-USAGE,                         
                           :CX-DIGTL-INTRL-MTR-NO,                      
                           :CX-DIGTL-MTR-TYPE,                          
                           :CX-CODE-TOU-SEASN,                          
                           :CX-EXCL-DMD-RCHT-IND,                       
                           :CX-MTR-READ-SOURCE-CD,                      
                           :CX-BTU-FACTOR,                              
C30989                     :CX-PCOMP-FCT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7555'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7555-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7556-CLOSE-CX-REBILL-CRSR.                                       
                                                                        
      ******************************************************************        
      *  CLOSE THE CURSOR DECLARED FOR CSS_CNSMPTN_HIST TABLE          *        
      *  THIS CURSOR IS USED FOR REBILLING METERED CONSUMPTION ROWS.   *        
      ******************************************************************        
                                                                        
           MOVE '7556' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               CLOSE CNS_REBILL_CRSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7556'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7556-EXIT.                                                       
           EXIT.                                                        
                                                                        
C35005******************************************************************        
C35005**    7619-GET-BILL-CORR-CD-DEEC                                **        
C35005**                                                              **        
C35005**  GET BILL CORRECTED CODE DESCRIPTION                         **        
C35005******************************************************************        
C35005 7619-GET-BILL-CORR-CD-DEEC.                                      
C35005                                                                  
C35005     MOVE '7619' TO ACTIVE-PARAGRAPH.                             
C35005                                                                  
C35005     EXEC SQL                                                     
C35005         SELECT CODE_SHORT_DESC                                   
C35005            INTO   :UV-CODE-SHORT-DESC                            
C35005            FROM   CSS_CODE_VALUE WITH(READUNCOMMITTED)                   
C35005            WHERE  CODE_VALUE = :UV-CODE-VALUE                    
C35005               AND COLUMN_NA  = :UV-COLUMN-NA                     
C35005               AND COMPANY_NO = :UV-COMPANY-NO                    
C35005               AND PROGRAM_ID = :UV-PROGRAM-ID                    
C35005               AND TABLE_NA   = :UV-TABLE-NA                      
C35005                                                           
C35005     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_SHORT_DESC                                           
MFA-TR*           INTO   :UV-CODE-SHORT-DESC                                    
MFA-TR*           FROM   CSS_CODE_VALUE                                         
MFA-TR*           WHERE  CODE_VALUE = :UV-CODE-VALUE                            
MFA-TR*              AND COLUMN_NA  = :UV-COLUMN-NA                             
MFA-TR*              AND COMPANY_NO = :UV-COMPANY-NO                            
MFA-TR*              AND PROGRAM_ID = :UV-PROGRAM-ID                            
MFA-TR*              AND TABLE_NA   = :UV-TABLE-NA                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35005                                                                  
C35005     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
C35005                                                                  
C35005     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
C35005        WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C35005           NEXT SENTENCE                                          
C35005     ELSE                                                         
C35005        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
C35005        MOVE SQLCODE                   TO ABEND-SQLCODE           
C35005        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C35005        MOVE '7619'                    TO ACTIVE-PARAGRAPH        
C35005        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C35005        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
C35005                                          ABEND-TABLES            
C35005        MOVE 'CSS_CODE_VALUE'          TO TABLE-1                 
C35005        MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
C35005        MOVE WS-CURRENT-ACCOUNT        TO HOSTVAR-ELEMENT-1       
C35005        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C35005     END-IF.                                                      
C35005                                                                  
C35005 7619-EXIT.                                                       
C35005     EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7620-SELECT-RB-HOOK                                       **        
      **                                                              **        
      **  DETERMINE IF A REBILL HOOK ALREADY EXISTS FOR THE CURRENT   **        
      **  ACCOUNT                                                     **        
      ******************************************************************        
       7620-SELECT-RB-HOOK.                                             
                                                                        
           MOVE '7620' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT BILL_NO                                           
                  INTO :WS-BI-BILL-NO                                   
                  FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                 
                  WHERE  DATE_BILLED         IS NULL                    
                     AND CODE_BILL_STATUS = :WS-C                       
                     AND ACCOUNT_NO       = :BI-ACCOUNT-NO              
C33924                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BILL_NO                                                   
MFA-TR*           INTO :WS-BI-BILL-NO                                           
MFA-TR*           FROM CSS_BILLING_HDR BI                                       
MFA-TR*           WHERE  DATE_BILLED         IS NULL                            
MFA-TR*              AND CODE_BILL_STATUS = :WS-C                               
MFA-TR*              AND ACCOUNT_NO       = :BI-ACCOUNT-NO                      
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7620'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE WS-CURRENT-ACCOUNT        TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7625-CHK-BILLING-DET                                      **        
      **                                                              **        
      **  DETERMINE IF BILLING DETAIL IS AVAILABLE FOR THE REBILL     **        
      **  HOOK FOR THE CURRENT ACCOUNT                                **        
      ******************************************************************        
       7625-CHK-BILLING-DET.                                            
                                                                        
           MOVE '7625' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                  INTO :WS-BG-EXISTS                                    
                  FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO              
                   AND BILL_NO            = :WS-BI-BILL-NO              
                   AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE          
                   AND IC_NO              = :BG-IC-NO                   
C33924                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*           INTO :WS-BG-EXISTS                                            
MFA-TR*           FROM CSS_BILLING_DET                                          
MFA-TR*          WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                      
MFA-TR*            AND BILL_NO            = :WS-BI-BILL-NO                      
MFA-TR*            AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                  
MFA-TR*            AND IC_NO              = :BG-IC-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              NOT-FOUND OR MULTIPLE-ROWS                                
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7620'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE WS-CURRENT-ACCOUNT        TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7625-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    7630-GET-REBILL-BILL-NO                                   **        
      **                                                              **        
      **  FOR A ONLINE CALL GET THE REBILL-BILL-NO                    **        
      **                                                              **        
      ******************************************************************        
       7630-GET-REBILL-BILL-NO.                                         
                                                                        
           MOVE '7630' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT BILL_NO                                           
                  INTO :WS-BI-BILL-NO                                   
                  FROM CSS_BILLING_HDR T1 WITH(READUNCOMMITTED)                 
                  WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                    
                    AND BILL_NO =                                       
                              (SELECT MAX(BILL_NO)                      
                                 FROM CSS_BILLING_HDR T2
                           WITH(READUNCOMMITTED)                
                                WHERE T2.ACCOUNT_NO = T1.ACCOUNT_NO     
                                  AND DATE_BILLED   IS NOT NULL)        
C33924                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BILL_NO                                                   
MFA-TR*           INTO :WS-BI-BILL-NO                                           
MFA-TR*           FROM CSS_BILLING_HDR T1                                       
MFA-TR*           WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                            
MFA-TR*             AND BILL_NO =                                               
MFA-TR*                       (SELECT MAX(BILL_NO)                              
MFA-TR*                          FROM CSS_BILLING_HDR T2                        
MFA-TR*                         WHERE T2.ACCOUNT_NO = T1.ACCOUNT_NO             
MFA-TR*                           AND DATE_BILLED   IS NOT NULL)                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7630'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE WS-CURRENT-ACCOUNT        TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
C29397******************************************************************        
START **    7631-CHK-BILL-IMMEDIATE                                   **        
      **                                                              **        
      **  FOR A ONLINE CALL GET THE REBILL-BILL-NO                    **        
      **                                                              **        
      ******************************************************************        
       7631-CHK-BILL-IMMEDIATE.                                         
                                                                        
           MOVE '7631' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                  INTO :WS-BILL-IMMEDIATE-FL                            
                  FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                    
                  WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                    
                    AND BILL_NO     = :WS-BI-BILL-NO                    
                    AND REV_MTH_ORIG_BILL = 0                           
                    AND REVENUE_MONTH     = 0                           
                    AND DATE_ORIG_BILL IS NULL                          
C33924                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*           INTO :WS-BILL-IMMEDIATE-FL                                    
MFA-TR*           FROM CSS_BILLING_DET                                          
MFA-TR*           WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                            
MFA-TR*             AND BILL_NO     = :WS-BI-BILL-NO                            
MFA-TR*             AND REV_MTH_ORIG_BILL = 0                                   
MFA-TR*             AND REVENUE_MONTH     = 0                                   
MFA-TR*             AND DATE_ORIG_BILL IS NULL                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR WS-811     
                                            OR NOT-FOUND                
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7631'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE WS-CURRENT-ACCOUNT        TO HOSTVAR-ELEMENT-1       
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE WS-BI-BILL-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
END    7631-EXIT.                                                       
C29397     EXIT.                                                        
C33924                                                                  
C33924 7800-OPEN-BILL-ADJ-CRSR.                                         
C33924******************************************************************        
C33924*                                                               **        
C33924*  OPEN  THE CURSOR DECLARED FOR CSS_BILL_ADJUSTMNT TABLE.      **        
C33924*  THIS CURSOR IS USED IN MAINTAINING BILL ADJUSTMNT ROWS.      **        
C33924*                                                               **        
C33924******************************************************************        
C33924                                                                  
C33924     MOVE '7800' TO ACTIVE-PARAGRAPH.                             
C33924                                                                  
ACT142 7800-START.                                                      
C33924                                                                  
C33924     EXEC SQL                                                     
C33924         OPEN BILL_ADJ_CRSR                                       
C33924     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33924                                                                  
C33924     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT142                                                                  
ACT142     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT142     WHEN SUCCESSFUL-CALL                                         
ACT142        CONTINUE                                                  
ACT142     WHEN OTHER                                                   
ACT142        IF WS-ACTIVE-RETURN-CODE = WS-502 AND WS-RETRY-COUNT = 0  
ACT142          ADD 1 TO WS-RETRY-COUNT                                 
ACT142          PERFORM 7820-CLOSE-BILL-ADJ-CRSR  THRU 7820-EXIT        
ACT142          GO TO 7800-START                                        
ACT142        END-IF                                                    
ACT142        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
ACT142        MOVE SQLCODE                   TO ABEND-SQLCODE           
ACT142        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT142        MOVE '7800'                    TO ACTIVE-PARAGRAPH        
ACT142        MOVE 'OPEN'                    TO ABEND-FUNCTION          
ACT142        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT142                                          ABEND-TABLES            
ACT142        MOVE 'CSS_BILL_ADJUSTMNT'      TO TABLE-1                 
ACT142        MOVE SPACES                    TO TABLE-ELEMENT-1         
ACT142        MOVE BP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
ACT142        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT142     END-EVALUATE.                                                
                                                                        
C33924                                                                  
C33924 7800-EXIT.                                                       
C33924     EXIT.                                                        
C33924                                                                  
C33924 7810-FETCH-BILL-ADJ-CRSR.                                        
C33924******************************************************************        
C33924*  FETCH THE CURSOR DECLARED FOR CSS_BILL_ADJUSTMNT              *        
C33924*  THIS CURSOR IS USED IN MAINTAINING BILL ADJUSTMENT ROWS.      *        
C33924******************************************************************        
C33924                                                                  
C33924     MOVE '7810' TO ACTIVE-PARAGRAPH.                             
C33924                                                                  
C33924     EXEC SQL                                                     
C33924         FETCH BILL_ADJ_CRSR                                      
C33924                INTO  :BP-ACCOUNT-NO,                             
C33924                      :BP-BILL-NO,                                
C33924                      :BP-CODE-UTIL-TYPE,                         
C33924                      :BP-IC-NO,                                  
C33924                      :BP-BILL-ITEM-TIMESTMP,                     
C33924                      :BP-ADJ-TYPE-CD,                            
C33924                      :BP-REVENUE-MONTH,                          
C33924                      :BP-ADJ-REASON-DESC,                        
P00246                      :BP-OVRRIDE-RT-REV-MTH,                     
P00246                      :BP-OVRRIDE-RT-BILL-DT 
                            :WS-OVRD-BILL-DT-NULL,
P00246                      :BP-OVRRIDE-RT-BILL-CY,                     
PRJ246                      :BP-SPECIAL-PROCESS-CD                      
C33924     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33924     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
C33924                                                                  
C33924     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
C33924        NOT-FOUND                                                 
P00246        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00246           IF WS-OVRD-BILL-DT-NULL < 0                            
P00246              MOVE SPACES              TO BP-OVRRIDE-RT-BILL-DT   
P00246           ELSE                                                   
P00246              NEXT SENTENCE                                       
P00246           END-IF                                                 
PRJ246           IF WS-C190-BILL-TYPE = 'F' AND                         
PRJ246              BP-SPECIAL-PROCESS-CD > SPACES                      
PRJ246              MOVE SPACES              TO BP-SPECIAL-PROCESS-CD   
PRJ246           END-IF                                                 
P00246        ELSE                                                      
C33924           NEXT SENTENCE                                          
P00246        END-IF                                                    
C33924     ELSE                                                         
C33924        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
C33924        MOVE SQLCODE                   TO ABEND-SQLCODE           
C33924        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33924        MOVE '7810'                    TO ACTIVE-PARAGRAPH        
C33924        MOVE 'FETCH'                   TO ABEND-FUNCTION          
C33924        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
C33924                                          ABEND-TABLES            
C33924        MOVE 'CSS_BILL_ADJUSTMNT'      TO TABLE-1                 
C33924        MOVE BP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
C33924        MOVE BP-BILL-NO                TO HOSTVAR-ELEMENT-2       
C33924        MOVE BP-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
C33924        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33924     END-IF.                                                      
C33924                                                                  
C33924 7810-EXIT.                                                       
C33924     EXIT.                                                        
C33924                                                                  
C33924 7820-CLOSE-BILL-ADJ-CRSR.                                        
C33924******************************************************************        
C33924*                                                                *        
C33924*  CLOSE THE CURSOR DECLARED CSS_BILL_ADJUSTMNT FOR BILL HOOK    *        
C33924*  SHIFT.                                                        *        
C33924******************************************************************        
C33924                                                                  
C33924     MOVE '7820' TO ACTIVE-PARAGRAPH.                             
C33924                                                                  
C33924     EXEC SQL                                                     
C33924         CLOSE BILL_ADJ_CRSR                                      
C33924     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33924                                                                  
C33924     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
C33924                                                                  
C33924     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33924           NEXT SENTENCE                                          
C33924     ELSE                                                         
C33924        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
C33924        MOVE SQLCODE                   TO ABEND-SQLCODE           
C33924        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33924        MOVE '7820'                    TO ACTIVE-PARAGRAPH        
C33924        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
C33924        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
C33924                                          ABEND-TABLES            
C33924        MOVE 'CSS_BILL_ADJUSTMNT'      TO TABLE-1                 
C33924        MOVE BP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
C33924        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33924     END-IF.                                                      
C33924                                                                  
C33924 7820-EXIT.                                                       
C33924     EXIT.                                                        
C33924                                                                  
       7700-OPEN-IDR-CRSR.                                              
                                                                        
      ******************************************************************        
      *  OPEN THE CURSOR DECLARED FOR CSS_INTERVAL_READS.              *        
      ******************************************************************        
                                                                        
           MOVE '7700' TO ACTIVE-PARAGRAPH.                             
                                                                        
ACT142 7700-START.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN INT_READ_CRSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT142                                                                  
ACT142     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT142     WHEN SUCCESSFUL-CALL                                         
ACT142        CONTINUE                                                  
ACT142     WHEN OTHER                                                   
ACT142        IF WS-ACTIVE-RETURN-CODE = WS-502 AND WS-RETRY-COUNT = 0  
ACT142          ADD 1 TO WS-RETRY-COUNT                                 
ACT142          PERFORM 7710-CLOSE-IDR-CRSR       THRU 7710-EXIT        
ACT142          GO TO 7700-START                                        
ACT142        END-IF                                                    
ACT142        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
ACT142        MOVE SQLCODE                   TO ABEND-SQLCODE           
ACT142        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT142        MOVE '7700'                    TO ACTIVE-PARAGRAPH        
ACT142        MOVE 'OPEN'                    TO ABEND-FUNCTION          
ACT142        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT142                                          ABEND-TABLES            
ACT142        MOVE 'CSS_INTERVAL_READ'       TO TABLE-1                 
ACT142        MOVE 'METER-NO'                TO TABLE-ELEMENT-1         
ACT142        MOVE CX-METER-NO               TO HOSTVAR-ELEMENT-1       
ACT142        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT142     END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7705-FETCH-IDR-CRSR.                                             
                                                                        
      ******************************************************************        
      *  SELECT AN INTERVAL READ ROW.                                  *        
      ******************************************************************        
                                                                        
           MOVE '7705' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               FETCH  INT_READ_CRSR                                     
                INTO :IV-DATE-READ :WS-DATE-READ-NULL,                   
                     :IV-TIME-READ,                                     
                     :IV-DST-CHNG-IND,                                  
                     :IV-CHANNEL-A-PULSES,                              
                     :IV-CHANNEL-A-STATUS,                              
                     :IV-CHANNEL-B-PULSES,                              
                     :IV-CHANNEL-B-STATUS,                              
                     :IV-CHANNEL-C-PULSES,                              
                     :IV-CHANNEL-C-STATUS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7705'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_INTERVAL_READ'       TO TABLE-1                 
              MOVE 'METER-NO'                TO TABLE-ELEMENT-1         
              MOVE 'BILL-ITEM-TIMESTAMP'     TO TABLE-ELEMENT-2         
              MOVE 'CODE-UTIL-TYPE'          TO TABLE-ELEMENT-3         
              MOVE CX-METER-NO               TO HOSTVAR-ELEMENT-1       
              MOVE WS-ORIG-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-2       
              MOVE IV-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7705-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7710-CLOSE-IDR-CRSR.                                             
                                                                        
      ******************************************************************        
      *  CLOSE THE CURSOR DECLARED CSS_INTERVAL_READ                   *        
      ******************************************************************        
                                                                        
           MOVE '7710' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               CLOSE INT_READ_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7710'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_INTERVAL_READ'       TO TABLE-1                 
              MOVE 'METER-NO'                TO TABLE-ELEMENT-1         
              MOVE CX-METER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7715-INSERT-IDR.                                                 
                                                                        
      ******************************************************************        
      *  INSERT A ROW INTO CSS_INTERVAL_READ FROM THE ORIGINAL BILL    *        
      ******************************************************************        
                                                                        
           MOVE '7715' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_INTERVAL_READ                            
                    (METER_NO,                                          
                     BILL_ITEM_TIMESTMP,                                
                     DATE_READ,                                         
                     TIME_READ,                                         
                     DST_CHNG_IND,                                      
                     CHANNEL_A_PULSES,                                  
                     CHANNEL_A_STATUS,                                  
                     CHANNEL_B_PULSES,                                  
                     CHANNEL_B_STATUS,                                  
                     CHANNEL_C_PULSES,                                  
                     CHANNEL_C_STATUS,                                  
                     CODE_UTIL_TYPE)                                    
             VALUES (:IV-METER-NO,                                      
                     CIS.CHAR2TIMESTAMP(:IV-BILL-ITEM-TIMESTMP),                
                     IIF(TRY_CONVERT(DATE, :IV-DATE-READ 
                                           :WS-DATE-READ-NULL
              ) IS NULL OR (PATINDEX('%.%', :IV-DATE-READ 
                                                     :WS-DATE-READ-NULL
              ) <> 0) OR (LEN(:IV-DATE-READ :WS-DATE-READ-NULL
              ) <> 10), CIS.CHAR2DATE(:IV-DATE-READ :WS-DATE-READ-NULL
              ), CONVERT(DATE, :IV-DATE-READ :WS-DATE-READ-NULL) ),            
                     CIS.CHAR2TIME(:IV-TIME-READ),                              
                     :IV-DST-CHNG-IND,                                  
                     :IV-CHANNEL-A-PULSES,                              
                     :IV-CHANNEL-A-STATUS,                              
                     :IV-CHANNEL-B-PULSES,                              
                     :IV-CHANNEL-B-STATUS,                              
                     :IV-CHANNEL-C-PULSES,                              
                     :IV-CHANNEL-C-STATUS,                              
                     :IV-CODE-UTIL-TYPE)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_INTERVAL_READ                                    
MFA-TR*             (METER_NO,                                                  
MFA-TR*              BILL_ITEM_TIMESTMP,                                        
MFA-TR*              DATE_READ,                                                 
MFA-TR*              TIME_READ,                                                 
MFA-TR*              DST_CHNG_IND,                                              
MFA-TR*              CHANNEL_A_PULSES,                                          
MFA-TR*              CHANNEL_A_STATUS,                                          
MFA-TR*              CHANNEL_B_PULSES,                                          
MFA-TR*              CHANNEL_B_STATUS,                                          
MFA-TR*              CHANNEL_C_PULSES,                                          
MFA-TR*              CHANNEL_C_STATUS,                                          
MFA-TR*              CODE_UTIL_TYPE)                                            
MFA-TR*      VALUES (:IV-METER-NO,                                              
MFA-TR*              :IV-BILL-ITEM-TIMESTMP,                                    
MFA-TR*              :IV-DATE-READ:WS-DATE-READ-NULL,                           
MFA-TR*              :IV-TIME-READ,                                             
MFA-TR*              :IV-DST-CHNG-IND,                                          
MFA-TR*              :IV-CHANNEL-A-PULSES,                                      
MFA-TR*              :IV-CHANNEL-A-STATUS,                                      
MFA-TR*              :IV-CHANNEL-B-PULSES,                                      
MFA-TR*              :IV-CHANNEL-B-STATUS,                                      
MFA-TR*              :IV-CHANNEL-C-PULSES,                                      
MFA-TR*              :IV-CHANNEL-C-STATUS,                                      
MFA-TR*              :IV-CODE-UTIL-TYPE)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7715'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_INTERVAL_READ'       TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7715-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7720-OPEN-DAILY-CRSR.                                            
                                                                        
      ******************************************************************        
      *  OPEN THE CURSOR DECLARED FOR CSS_INTERVAL_READS.              *        
      ******************************************************************        
                                                                        
           MOVE '7720' TO ACTIVE-PARAGRAPH.                             
                                                                        
ACT142 7720-START.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN ND_DAILY_CRSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT142                                                                  
ACT142     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT142     WHEN SUCCESSFUL-CALL                                         
ACT142        CONTINUE                                                  
ACT142     WHEN OTHER                                                   
ACT142        IF WS-ACTIVE-RETURN-CODE = WS-502 AND WS-RETRY-COUNT = 0  
ACT142          ADD 1 TO WS-RETRY-COUNT                                 
ACT142          PERFORM 7730-CLOSE-DAILY-CRSR     THRU 7730-EXIT        
ACT142          GO TO 7720-START                                        
ACT142        END-IF                                                    
ACT142        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
ACT142        MOVE SQLCODE                   TO ABEND-SQLCODE           
ACT142        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT142        MOVE '7720'                    TO ACTIVE-PARAGRAPH        
ACT142        MOVE 'OPEN'                    TO ABEND-FUNCTION          
ACT142        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT142                                          ABEND-TABLES            
ACT142        MOVE 'CSS_VOL_DAILY'           TO TABLE-1                 
ACT142        MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
ACT142        MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
ACT142        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT142     END-EVALUATE.                                                
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7725-FETCH-DAILY-CRSR.                                           
                                                                        
      ******************************************************************        
      *  SELECT AN INTERVAL READ ROW.                                  *        
      ******************************************************************        
                                                                        
           MOVE '7725' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               FETCH  ND_DAILY_CRSR                                     
                INTO :ND-VOL-TYPE-CD,                                   
                     :ND-ENERGY-UNIT-CD,                                
                     :ND-DATE-READ,                                     
                     :ND-NO-UNITS,                                      
                     :ND-FIXED-FCTR-SEQ-NO                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7725'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_VOL_DAILY'           TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE 'IC-NO'                   TO TABLE-ELEMENT-3         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7725-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7730-CLOSE-DAILY-CRSR.                                           
                                                                        
      ******************************************************************        
      *  CLOSE THE CURSOR DECLARED CSS_INTERVAL_READ                   *        
      ******************************************************************        
                                                                        
           MOVE '7730' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               CLOSE ND_DAILY_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7730'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_VOL_DAILY'           TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7730-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7735-INSERT-DAILY-VOL.                                           
                                                                        
      ******************************************************************        
      *  INSERT A ROW INTO CSS_VOL_DAILY FROM THE ORIGINAL BILL        *        
      ******************************************************************        
                                                                        
           MOVE '7735' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_VOL_DAILY                                
                    (ACCOUNT_NO,                                        
                     BILL_NO,                                           
                     CODE_UTIL_TYPE,                                    
                     IC_NO,                                             
                     BILL_ITEM_TIMESTMP,                                
                     VOL_TYPE_CD,                                       
                     ENERGY_UNIT_CD,                                    
                     DATE_READ,                                         
                     NO_UNITS,                                          
                     FIXED_FCTR_SEQ_NO)                                 
             VALUES (:ND-ACCOUNT-NO,                                    
                     :ND-BILL-NO,                                       
                     :ND-CODE-UTIL-TYPE,                                
                     :ND-IC-NO,                                         
                     CIS.CHAR2TIMESTAMP(:ND-BILL-ITEM-TIMESTMP),                
                     :ND-VOL-TYPE-CD,                                   
                     :ND-ENERGY-UNIT-CD,                                
                     IIF(TRY_CONVERT(DATE, :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) ),                               
                     :ND-NO-UNITS,                                      
                     :ND-FIXED-FCTR-SEQ-NO)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_VOL_DAILY                                        
MFA-TR*             (ACCOUNT_NO,                                                
MFA-TR*              BILL_NO,                                                   
MFA-TR*              CODE_UTIL_TYPE,                                            
MFA-TR*              IC_NO,                                                     
MFA-TR*              BILL_ITEM_TIMESTMP,                                        
MFA-TR*              VOL_TYPE_CD,                                               
MFA-TR*              ENERGY_UNIT_CD,                                            
MFA-TR*              DATE_READ,                                                 
MFA-TR*              NO_UNITS,                                                  
MFA-TR*              FIXED_FCTR_SEQ_NO)                                         
MFA-TR*      VALUES (:ND-ACCOUNT-NO,                                            
MFA-TR*              :ND-BILL-NO,                                               
MFA-TR*              :ND-CODE-UTIL-TYPE,                                        
MFA-TR*              :ND-IC-NO,                                                 
MFA-TR*              :ND-BILL-ITEM-TIMESTMP,                                    
MFA-TR*              :ND-VOL-TYPE-CD,                                           
MFA-TR*              :ND-ENERGY-UNIT-CD,                                        
MFA-TR*              :ND-DATE-READ,                                             
MFA-TR*              :ND-NO-UNITS,                                              
MFA-TR*              :ND-FIXED-FCTR-SEQ-NO)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7735'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_VOL_DAILY'           TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7735-EXIT.                                                       
           EXIT.                                                        
       7771-SELECT-BILL-HEADER.                                         
                                                                        
      *****************************************************************         
      *  SELECT A BILL HEADER ROW FROM CSS_BILLING_HDR.               *         
      *****************************************************************         
                                                                        
            MOVE '7771' TO ACTIVE-PARAGRAPH.                            
                                                                        
            EXEC SQL                                                    
                SELECT PREMISE_NO,                                      
                       BILL_NO,                                         
                       DATE_BILLED,                                     
                       CODE_BILL_REASON,                                
                       CODE_BILL_STATUS,                                
                       CODE_BILL_TYPE,                                  
                       CUSTOMER_NO,                                     
                       ACCOUNT_NO,                                      
                       CODE_SPCL_BILL,                                  
                       PREM_ACCT_SEQ_NO,                                
                       SMRY_BILL_NO,                                    
                       SMRY_REBILL_NO,                                  
                       ACCOUNT_NO_SUMM,                                 
                       COMPANY_NO,                                      
                       REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                       TOT_OTHER_CHARGES,                               
C35005                 BILL_CORRECTED_CD,                               
                       TOTAL_ARREARS                                    
                 INTO :BI-PREMISE-NO,                                   
                      :BI-BILL-NO,                                      
                      :BI-DATE-BILLED :WS-DATE-BILLED-NULL,              
                      :BI-CODE-BILL-REASON,                             
                      :BI-CODE-BILL-STATUS,                             
                      :BI-CODE-BILL-TYPE,                               
                      :BI-CUSTOMER-NO,                                  
                      :BI-ACCOUNT-NO,                                   
                      :BI-CODE-SPCL-BILL,                               
                      :BI-PREM-ACCT-SEQ-NO,                             
                      :BI-SMRY-BILL-NO,                                 
                      :BI-SMRY-REBILL-NO,                               
                      :BI-ACCOUNT-NO-SUMM,                              
                      :BI-COMPANY-NO,                                   
                      :BI-LAST-UPDATE-TS,                               
                      :BI-TOT-OTHER-CHARGES,                            
C35005                :BI-BILL-CORRECTED-CD,                            
                      :BI-TOTAL-ARREARS                                 
                 FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :BI-ACCOUNT-NO AND                   
                      BILL_NO    = :BI-BILL-NO                          
C33924                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT PREMISE_NO,                                              
MFA-TR*                BILL_NO,                                                 
MFA-TR*                DATE_BILLED,                                             
MFA-TR*                CODE_BILL_REASON,                                        
MFA-TR*                CODE_BILL_STATUS,                                        
MFA-TR*                CODE_BILL_TYPE,                                          
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                CODE_SPCL_BILL,                                          
MFA-TR*                PREM_ACCT_SEQ_NO,                                        
MFA-TR*                SMRY_BILL_NO,                                            
MFA-TR*                SMRY_REBILL_NO,                                          
MFA-TR*                ACCOUNT_NO_SUMM,                                         
MFA-TR*                COMPANY_NO,                                              
MFA-TR*                LAST_UPDATE_TS,                                          
MFA-TR*                TOT_OTHER_CHARGES,                                       
MFA-TR*                BILL_CORRECTED_CD,                                       
MFA-TR*                TOTAL_ARREARS                                            
MFA-TR*          INTO :BI-PREMISE-NO,                                           
MFA-TR*               :BI-BILL-NO,                                              
MFA-TR*               :BI-DATE-BILLED:WS-DATE-BILLED-NULL,                      
MFA-TR*               :BI-CODE-BILL-REASON,                                     
MFA-TR*               :BI-CODE-BILL-STATUS,                                     
MFA-TR*               :BI-CODE-BILL-TYPE,                                       
MFA-TR*               :BI-CUSTOMER-NO,                                          
MFA-TR*               :BI-ACCOUNT-NO,                                           
MFA-TR*               :BI-CODE-SPCL-BILL,                                       
MFA-TR*               :BI-PREM-ACCT-SEQ-NO,                                     
MFA-TR*               :BI-SMRY-BILL-NO,                                         
MFA-TR*               :BI-SMRY-REBILL-NO,                                       
MFA-TR*               :BI-ACCOUNT-NO-SUMM,                                      
MFA-TR*               :BI-COMPANY-NO,                                           
MFA-TR*               :BI-LAST-UPDATE-TS,                                       
MFA-TR*               :BI-TOT-OTHER-CHARGES,                                    
MFA-TR*               :BI-BILL-CORRECTED-CD,                                    
MFA-TR*               :BI-TOTAL-ARREARS                                         
MFA-TR*          FROM CSS_BILLING_HDR                                           
MFA-TR*         WHERE ACCOUNT_NO = :BI-ACCOUNT-NO AND                           
MFA-TR*               BILL_NO    = :BI-BILL-NO                                  
MFA-TR*         WITH UR                                                         
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE  
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                  NEXT SENTENCE                                         
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE SQLCODE                   TO ABEND-SQLCODE          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7771'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_BILLING_HDR'         TO TABLE-1                
               MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1        
               MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2        
               MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE BI-BILL-NO                TO HOSTVAR-ELEMENT-2      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
            END-IF.                                                     
                                                                        
       7771-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7775-SELECT-BILLED-DATE.                                         
                                                                        
      *****************************************************************         
      *  SELECT A BILLED DATE FROM CSS_BILLING_DET                    *         
      *****************************************************************         
                                                                        
            MOVE '7775' TO ACTIVE-PARAGRAPH.                            
                                                                        
            EXEC SQL                                                    
                SELECT DISTINCT DATE_ORIG_BILL                          
                 INTO :BI-DATE-BILLED                                   
                 FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :BG-ACCOUNT-NO AND                   
                      BILL_NO    = :BI-BILL-NO    AND                   
                      REV_MTH_ORIG_BILL <> 0   AND                      
                      DATE_ORIG_BILL IS NOT NULL                        
C33924                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT DISTINCT DATE_ORIG_BILL                                  
MFA-TR*          INTO :BI-DATE-BILLED                                           
MFA-TR*          FROM CSS_BILLING_DET                                           
MFA-TR*         WHERE ACCOUNT_NO = :BG-ACCOUNT-NO AND                           
MFA-TR*               BILL_NO    = :BI-BILL-NO    AND                           
MFA-TR*               REV_MTH_ORIG_BILL <> 0   AND                              
MFA-TR*               DATE_ORIG_BILL IS NOT NULL                                
MFA-TR*         WITH UR                                                         
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE  
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR WS-811    
                 IF WS-ACTIVE-RETURN-CODE = WS-811                      
                    DISPLAY 'INVALID TIMESTAMP-7775' BG-ACCOUNT-NO      
                 END-IF                                                 
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE SQLCODE                   TO ABEND-SQLCODE          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7775'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_BILLING_DET'         TO TABLE-1                
               MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1        
               MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2        
               MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE BI-BILL-NO                TO HOSTVAR-ELEMENT-2      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
            END-IF.                                                     
                                                                        
       7775-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7772-OPEN-BILL-DET-SHFT-CRSR.                                    
                                                                        
      ******************************************************************        
      *  OPEN THE CURSOR DECLARED CSS_BILLING_DET FOR BILL HOOK SHIFT. *        
      ******************************************************************        
                                                                        
           MOVE '7772' TO ACTIVE-PARAGRAPH.                             
                                                                        
ACT142 7772-START.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN BG_SHFT_CRSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT142                                                                  
ACT142     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT142     WHEN SUCCESSFUL-CALL                                         
ACT142        CONTINUE                                                  
ACT142     WHEN OTHER                                                   
ACT142        IF WS-ACTIVE-RETURN-CODE = WS-502 AND WS-RETRY-COUNT = 0  
ACT142          ADD 1 TO WS-RETRY-COUNT                                 
ACT142          PERFORM 7774-CLOSE-BILL-DET-SHFT-CRSR THRU 7774-EXIT    
ACT142          GO TO 7772-START                                        
ACT142        END-IF                                                    
ACT142        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
ACT142        MOVE SQLCODE                   TO ABEND-SQLCODE           
ACT142        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT142        MOVE '7772'                    TO ACTIVE-PARAGRAPH        
ACT142        MOVE 'OPEN'                    TO ABEND-FUNCTION          
ACT142        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT142                                          ABEND-TABLES            
ACT142        MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
ACT142        MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
ACT142        MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
ACT142        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT142     END-EVALUATE.                                                
                                                                        
       7772-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7773-FETCH-BILL-DET-SHFT-CRSR.                                   
                                                                        
      ******************************************************************        
      *  SELECT A BILL DETAIL ROW FROM CSS_BILLING_DET.                *        
      ******************************************************************        
                                                                        
           MOVE '7773' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               FETCH BG_SHFT_CRSR                                       
                INTO :BG-PREMISE-NO,                                    
                     :BG-BILL-NO,                                       
                     :BG-CODE-UTIL-TYPE,                                
                     :BG-IC-NO,                                         
                     :BG-BILL-ITEM-TIMESTMP,                            
                     :BG-DATE-ORIG-BILL :WS-DATE-ORIG-BILL-NULL,         
                     :BG-AMT-BILL-ITEM,                                 
                     :BG-CODE-BILL-CALC,                                
                     :BG-CODE-BILL-ITM-TYPE,                            
                     :BG-CODE-BILL-ITM-IND,                             
                     :BG-CODE-DR-CR-CNSMPTN,                            
                     :BG-AMT-STATE-TAX,                                 
                     :BG-AMT-CITY-TAX,                                  
                     :BG-AMT-OTHER-TAX,                                 
                     :BG-CODE-REVENUE-CLASS,                            
                     :BG-CODE-SIC-NO,                                   
                     :BG-RATE-PLAN-NO,                                  
                     :BG-CODE-CURTAIL-PRTY,                             
                     :BG-CODE-STAT-TAX-XMT,                             
                     :BG-CODE-CITY-TAX-XMT,                             
                     :BG-CODE-OTHR-TAX-XMT,                             
                     :BG-REV-RPT-CD,                                    
                     :BG-STANDBY-COMPLIED,                              
                     :BG-PRORATE-CD,                                    
                     :BG-NEW-RATE-PCT,                                  
                     :BG-CODE-SUB-TOTAL,                                
                     :BG-TAX-REFUND-CD,                                 
                     :BG-ACCOUNT-NO,                                    
                     :BG-COMPANY-NO,                                    
                     :BG-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD-NULL,     
                     :BG-LFTM-HI-PEAK-DMD,                              
                     :BG-REBILL-IND,                                    
                     :BG-ADJ-REASON-CD,                                 
                     :BG-REVENUE-MONTH,                                 
                     :BG-GAS-BASE-USE,                                  
                     :BG-WNA-FACTOR,                                    
                     :BG-BTU-FACTOR,                                    
                     :BG-NO-OF-CONS-DAYS,                               
                     :BG-REV-MTH-ORIG-BILL,                             
                     :BG-REV-DISTRICT-CD,                               
T25731               :BG-FUEL-SHIPPER-CD,                               
                     :BG-ALTERNATE-FUEL-CD,                             
                     :BG-TRNSP-OVER-MDQ-FL,                             
C29528               :BG-CITY-TAX-RATE,                                 
C34569               :BG-OTHER-TAX-RATE,                                
C29528               :BG-STATE-TAX-RATE,                                
C33362               :BG-BILL-CALC-CYCLE,                               
C34569               :BG-NAICS-CD,                                      
C34569               :BG-RT-PKG-OPT-SEQ-NO                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7773'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7773-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7774-CLOSE-BILL-DET-SHFT-CRSR.                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      * CLOSE THE CURSOR DECLARED CSS_BILLING_DET FOR BILL HOOK SHIFT. *        
      *                                                                *        
      ******************************************************************        
                                                                        
           MOVE '7774' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               CLOSE BG_SHFT_CRSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7774'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7774-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7783-GET-BG.                                                     
                                                                        
      ******************************************************************        
      *  SELECT A BILL DETAIL ROW FROM CSS_BILLING_DET.                *        
      ******************************************************************        
                                                                        
           MOVE '7783' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT PREMISE_NO,                                       
                      BILL_NO,                                          
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                               
                      DATE_ORIG_BILL,                                   
                      AMT_BILL_ITEM,                                    
                      CODE_BILL_CALC,                                   
                      CODE_BILL_ITM_TYPE,                               
                      CODE_BILL_ITM_IND,                                
                      CODE_DR_CR_CNSMPTN,                               
                      AMT_STATE_TAX,                                    
                      AMT_CITY_TAX,                                     
                      AMT_OTHER_TAX,                                    
                      CODE_REVENUE_CLASS,                               
                      CODE_SIC_NO,                                      
                      RATE_PLAN_NO,                                     
                      CODE_CURTAIL_PRTY,                                
                      CODE_STAT_TAX_XMT,                                
                      CODE_CITY_TAX_XMT,                                
                      CODE_OTHR_TAX_XMT,                                
                      REV_RPT_CD,                                       
                      STANDBY_COMPLIED,                                 
                      PRORATE_CD,                                       
                      NEW_RATE_PCT,                                     
                      CODE_SUB_TOTAL,                                   
                      TAX_REFUND_CD,                                    
                      ACCOUNT_NO,                                       
                      COMPANY_NO,                                       
                      DATE_LFTM_HI_DMD,                                 
                      LFTM_HI_PEAK_DMD,                                 
                      REBILL_IND,                                       
                      ADJ_REASON_CD,                                    
                      REVENUE_MONTH,                                    
                      GAS_BASE_USE,                                     
                      WNA_FACTOR,                                       
                      BTU_FACTOR,                                       
                      NO_OF_CONS_DAYS,                                  
                      REV_MTH_ORIG_BILL,                                
                      REV_DISTRICT_CD,                                  
T25731                FUEL_SHIPPER_CD,                                  
T27237                ALTERNATE_FUEL_CD,                                
T27237                TRNSP_OVER_MDQ_FL,                                
C29528                CITY_TAX_RATE,                                    
C34569                OTHER_TAX_RATE,                                   
C29528                STATE_TAX_RATE,                                   
C33362                BILL_CALC_CYCLE,                                  
C34569                NAICS_CD,                                         
C34569                RT_PKG_OPT_SEQ_NO                                 
                 INTO :BG-PREMISE-NO,                                   
                      :BG-BILL-NO,                                      
                      :BG-CODE-UTIL-TYPE,                               
                      :BG-IC-NO,                                        
                      :BG-BILL-ITEM-TIMESTMP,                           
                      :BG-DATE-ORIG-BILL :WS-DATE-ORIG-BILL-NULL,        
                      :BG-AMT-BILL-ITEM,                                
                      :BG-CODE-BILL-CALC,                               
                      :BG-CODE-BILL-ITM-TYPE,                           
                      :BG-CODE-BILL-ITM-IND,                            
                      :BG-CODE-DR-CR-CNSMPTN,                           
                      :BG-AMT-STATE-TAX,                                
                      :BG-AMT-CITY-TAX,                                 
                      :BG-AMT-OTHER-TAX,                                
                      :BG-CODE-REVENUE-CLASS,                           
                      :BG-CODE-SIC-NO,                                  
                      :BG-RATE-PLAN-NO,                                 
                      :BG-CODE-CURTAIL-PRTY,                            
                      :BG-CODE-STAT-TAX-XMT,                            
                      :BG-CODE-CITY-TAX-XMT,                            
                      :BG-CODE-OTHR-TAX-XMT,                            
                      :BG-REV-RPT-CD,                                   
                      :BG-STANDBY-COMPLIED,                             
                      :BG-PRORATE-CD,                                   
                      :BG-NEW-RATE-PCT,                                 
                      :BG-CODE-SUB-TOTAL,                               
                      :BG-TAX-REFUND-CD,                                
                      :BG-ACCOUNT-NO,                                   
                      :BG-COMPANY-NO,                                   
                      :BG-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD-NULL,    
                      :BG-LFTM-HI-PEAK-DMD,                             
                      :BG-REBILL-IND,                                   
                      :BG-ADJ-REASON-CD,                                
                      :BG-REVENUE-MONTH,                                
                      :BG-GAS-BASE-USE,                                 
                      :BG-WNA-FACTOR,                                   
                      :BG-BTU-FACTOR,                                   
                      :BG-NO-OF-CONS-DAYS,                              
                      :BG-REV-MTH-ORIG-BILL,                            
                      :BG-REV-DISTRICT-CD,                              
T25731                :BG-FUEL-SHIPPER-CD,                              
T27237                :BG-ALTERNATE-FUEL-CD,                            
T27237                :BG-TRNSP-OVER-MDQ-FL,                            
C29528                :BG-CITY-TAX-RATE,                                
C34569                :BG-OTHER-TAX-RATE,                               
C29528                :BG-STATE-TAX-RATE,                               
C33362                :BG-BILL-CALC-CYCLE,                              
C34569                :BG-NAICS-CD,                                     
C34569                :BG-RT-PKG-OPT-SEQ-NO                             
                 FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO AND           
                      BILL_NO            = :BG-BILL-NO AND              
                      CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE AND       
                      IC_NO              = :BG-IC-NO AND                
                      BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
C33924                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO,                                               
MFA-TR*               BILL_NO,                                                  
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               IC_NO,                                                    
MFA-TR*               BILL_ITEM_TIMESTMP,                                       
MFA-TR*               DATE_ORIG_BILL,                                           
MFA-TR*               AMT_BILL_ITEM,                                            
MFA-TR*               CODE_BILL_CALC,                                           
MFA-TR*               CODE_BILL_ITM_TYPE,                                       
MFA-TR*               CODE_BILL_ITM_IND,                                        
MFA-TR*               CODE_DR_CR_CNSMPTN,                                       
MFA-TR*               AMT_STATE_TAX,                                            
MFA-TR*               AMT_CITY_TAX,                                             
MFA-TR*               AMT_OTHER_TAX,                                            
MFA-TR*               CODE_REVENUE_CLASS,                                       
MFA-TR*               CODE_SIC_NO,                                              
MFA-TR*               RATE_PLAN_NO,                                             
MFA-TR*               CODE_CURTAIL_PRTY,                                        
MFA-TR*               CODE_STAT_TAX_XMT,                                        
MFA-TR*               CODE_CITY_TAX_XMT,                                        
MFA-TR*               CODE_OTHR_TAX_XMT,                                        
MFA-TR*               REV_RPT_CD,                                               
MFA-TR*               STANDBY_COMPLIED,                                         
MFA-TR*               PRORATE_CD,                                               
MFA-TR*               NEW_RATE_PCT,                                             
MFA-TR*               CODE_SUB_TOTAL,                                           
MFA-TR*               TAX_REFUND_CD,                                            
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               DATE_LFTM_HI_DMD,                                         
MFA-TR*               LFTM_HI_PEAK_DMD,                                         
MFA-TR*               REBILL_IND,                                               
MFA-TR*               ADJ_REASON_CD,                                            
MFA-TR*               REVENUE_MONTH,                                            
MFA-TR*               GAS_BASE_USE,                                             
MFA-TR*               WNA_FACTOR,                                               
MFA-TR*               BTU_FACTOR,                                               
MFA-TR*               NO_OF_CONS_DAYS,                                          
MFA-TR*               REV_MTH_ORIG_BILL,                                        
MFA-TR*               REV_DISTRICT_CD,                                          
MFA-TR*               FUEL_SHIPPER_CD,                                          
MFA-TR*               ALTERNATE_FUEL_CD,                                        
MFA-TR*               TRNSP_OVER_MDQ_FL,                                        
MFA-TR*               CITY_TAX_RATE,                                            
MFA-TR*               OTHER_TAX_RATE,                                           
MFA-TR*               STATE_TAX_RATE,                                           
MFA-TR*               BILL_CALC_CYCLE,                                          
MFA-TR*               NAICS_CD,                                                 
MFA-TR*               RT_PKG_OPT_SEQ_NO                                         
MFA-TR*          INTO :BG-PREMISE-NO,                                           
MFA-TR*               :BG-BILL-NO,                                              
MFA-TR*               :BG-CODE-UTIL-TYPE,                                       
MFA-TR*               :BG-IC-NO,                                                
MFA-TR*               :BG-BILL-ITEM-TIMESTMP,                                   
MFA-TR*               :BG-DATE-ORIG-BILL:WS-DATE-ORIG-BILL-NULL,                
MFA-TR*               :BG-AMT-BILL-ITEM,                                        
MFA-TR*               :BG-CODE-BILL-CALC,                                       
MFA-TR*               :BG-CODE-BILL-ITM-TYPE,                                   
MFA-TR*               :BG-CODE-BILL-ITM-IND,                                    
MFA-TR*               :BG-CODE-DR-CR-CNSMPTN,                                   
MFA-TR*               :BG-AMT-STATE-TAX,                                        
MFA-TR*               :BG-AMT-CITY-TAX,                                         
MFA-TR*               :BG-AMT-OTHER-TAX,                                        
MFA-TR*               :BG-CODE-REVENUE-CLASS,                                   
MFA-TR*               :BG-CODE-SIC-NO,                                          
MFA-TR*               :BG-RATE-PLAN-NO,                                         
MFA-TR*               :BG-CODE-CURTAIL-PRTY,                                    
MFA-TR*               :BG-CODE-STAT-TAX-XMT,                                    
MFA-TR*               :BG-CODE-CITY-TAX-XMT,                                    
MFA-TR*               :BG-CODE-OTHR-TAX-XMT,                                    
MFA-TR*               :BG-REV-RPT-CD,                                           
MFA-TR*               :BG-STANDBY-COMPLIED,                                     
MFA-TR*               :BG-PRORATE-CD,                                           
MFA-TR*               :BG-NEW-RATE-PCT,                                         
MFA-TR*               :BG-CODE-SUB-TOTAL,                                       
MFA-TR*               :BG-TAX-REFUND-CD,                                        
MFA-TR*               :BG-ACCOUNT-NO,                                           
MFA-TR*               :BG-COMPANY-NO,                                           
MFA-TR*               :BG-DATE-LFTM-HI-DMD:WS-DATE-LFTM-HI-DMD-NULL,            
MFA-TR*               :BG-LFTM-HI-PEAK-DMD,                                     
MFA-TR*               :BG-REBILL-IND,                                           
MFA-TR*               :BG-ADJ-REASON-CD,                                        
MFA-TR*               :BG-REVENUE-MONTH,                                        
MFA-TR*               :BG-GAS-BASE-USE,                                         
MFA-TR*               :BG-WNA-FACTOR,                                           
MFA-TR*               :BG-BTU-FACTOR,                                           
MFA-TR*               :BG-NO-OF-CONS-DAYS,                                      
MFA-TR*               :BG-REV-MTH-ORIG-BILL,                                    
MFA-TR*               :BG-REV-DISTRICT-CD,                                      
MFA-TR*               :BG-FUEL-SHIPPER-CD,                                      
MFA-TR*               :BG-ALTERNATE-FUEL-CD,                                    
MFA-TR*               :BG-TRNSP-OVER-MDQ-FL,                                    
MFA-TR*               :BG-CITY-TAX-RATE,                                        
MFA-TR*               :BG-OTHER-TAX-RATE,                                       
MFA-TR*               :BG-STATE-TAX-RATE,                                       
MFA-TR*               :BG-BILL-CALC-CYCLE,                                      
MFA-TR*               :BG-NAICS-CD,                                             
MFA-TR*               :BG-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*          FROM CSS_BILLING_DET                                           
MFA-TR*         WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO AND                   
MFA-TR*               BILL_NO            = :BG-BILL-NO AND                      
MFA-TR*               CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE AND               
MFA-TR*               IC_NO              = :BG-IC-NO AND                        
MFA-TR*               BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7783'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE 'IC-NO'                   TO TABLE-ELEMENT-3         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7783-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7785-SELECT-BILL-HOOK.                                           
                                                                        
      ******************************************************************        
      *  SELECT BILL HOOK FOR PREMISE FROM CSS_BILLING_HDR.            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               SELECT MAX(BILL_NO)                                      
                 INTO :BI-BILL-NO                                       
                 FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :BG-ACCOUNT-NO AND                   
                      (CODE_BILL_STATUS = :WS-A OR                      
                      CODE_BILL_STATUS = :WS-B)                         
C33924                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(BILL_NO)                                              
MFA-TR*          INTO :BI-BILL-NO                                               
MFA-TR*          FROM CSS_BILLING_HDR                                           
MFA-TR*         WHERE ACCOUNT_NO = :BG-ACCOUNT-NO AND                           
MFA-TR*               (CODE_BILL_STATUS = :WS-A OR                              
MFA-TR*               CODE_BILL_STATUS = :WS-B)                                 
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7785'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7785-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
C35005 7805-SELECT-ADJ-REASON-DESC.                                     
C35005******************************************************************        
C35005*  SELECT ADJ REASON DESCRIPTION FROM CSS_BILL_ADJ_REASN.        *        
C35005******************************************************************        
C35005     EXEC SQL                                                     
C35005         SELECT ADJ_REASON_DESC                                   
C35005         INTO   :K0-ADJ-REASON-DESC                               
C35005         FROM   CSS_BILL_ADJ_REASN WITH(READUNCOMMITTED)                  
C35005         WHERE  ADJ_REASON_CD = :K0-ADJ-REASON-CD                 
C35005                                                           
C35005     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADJ_REASON_DESC                                           
MFA-TR*        INTO   :K0-ADJ-REASON-DESC                                       
MFA-TR*        FROM   CSS_BILL_ADJ_REASN                                        
MFA-TR*        WHERE  ADJ_REASON_CD = :K0-ADJ-REASON-CD                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35005                                                                  
C35005     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35005                                                                  
C35005     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35005        CONTINUE                                                  
C35005     ELSE                                                         
C35005        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
C35005        MOVE SQLCODE                   TO ABEND-SQLCODE           
C35005        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C35005        MOVE '7805'                    TO ACTIVE-PARAGRAPH        
C35005        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C35005        MOVE SPACES                    TO ABEND-SQL-PREDICATES,   
C35005                                          ABEND-TABLES            
C35005        MOVE 'CSS_BILL_ADJ_REASN'      TO TABLE-1                 
C35005        MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
C35005        MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
C35005        MOVE 'ADJ REASON CD'           TO TABLE-ELEMENT-2         
C35005        MOVE WS-C190-ADJ-REASN-CODE    TO HOSTVAR-ELEMENT-2       
C35005        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C35005     END-IF.                                                      
C35005                                                                  
C35005 7805-EXIT.                                                       
C35005     EXIT.                                                        
                                                                        
P00496******************************************************************04966000
P00496*  CHECK THE ACCOUNT IN CSS_BILL_MANUAL TABLE.                   *04967000
P00496******************************************************************04968000
P00496 7970-GET-BILL-MANUAL.                                            
P00496*                                                                 04969000
P00496     EXEC SQL                                                     
P00496        SELECT  ACCOUNT_NO                                        
P00496               ,BILL_NO                                           
P00496               ,CODE_UTIL_TYPE                                    
P00496               ,IC_NO                                             
P00496               ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                
P00496               ,BILL_MAN_STATUS_CD                                
P00496               ,BILL_MAN_SOURCE_CD                                
P00496               ,LAST_UPDATE_USERID                                
P00496               ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
P00496          INTO  :NG-ACCOUNT-NO                                    
P00496               ,:NG-BILL-NO                                       
P00496               ,:NG-CODE-UTIL-TYPE                                
P00496               ,:NG-IC-NO                                         
P00496               ,:NG-BILL-ITEM-TIMESTMP                            
P00496               ,:NG-BILL-MAN-STATUS-CD                            
P00496               ,:NG-BILL-MAN-SOURCE-CD                            
P00496               ,:NG-LAST-UPDATE-USERID                            
P00496               ,:NG-LAST-UPDATE-TS                                
P00496          FROM  CSS_BILL_MANUAL NG WITH(READUNCOMMITTED)                  
P00496         WHERE  ACCOUNT_NO          = :NG-ACCOUNT-NO              
P00496           AND  BILL_NO             = :NG-BILL-NO                 
P00496           AND  CODE_UTIL_TYPE      = :NG-CODE-UTIL-TYPE          
P00496           AND  IC_NO               = :NG-IC-NO                   
P00496           AND  BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :NG-BILL-ITEM-TIMESTMP
              )      
P00496                                                           
P00496                                                      
P00496     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04970000
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*              ,BILL_NO                                                   
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,BILL_ITEM_TIMESTMP                                        
MFA-TR*              ,BILL_MAN_STATUS_CD                                        
MFA-TR*              ,BILL_MAN_SOURCE_CD                                        
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*         INTO  :NG-ACCOUNT-NO                                            
MFA-TR*              ,:NG-BILL-NO                                               
MFA-TR*              ,:NG-CODE-UTIL-TYPE                                        
MFA-TR*              ,:NG-IC-NO                                                 
MFA-TR*              ,:NG-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:NG-BILL-MAN-STATUS-CD                                    
MFA-TR*              ,:NG-BILL-MAN-SOURCE-CD                                    
MFA-TR*              ,:NG-LAST-UPDATE-USERID                                    
MFA-TR*              ,:NG-LAST-UPDATE-TS                                        
MFA-TR*         FROM  CSS_BILL_MANUAL NG                                        
MFA-TR*        WHERE  ACCOUNT_NO          = :NG-ACCOUNT-NO                      
MFA-TR*          AND  BILL_NO             = :NG-BILL-NO                         
MFA-TR*          AND  CODE_UTIL_TYPE      = :NG-CODE-UTIL-TYPE                  
MFA-TR*          AND  IC_NO               = :NG-IC-NO                           
MFA-TR*          AND  BILL_ITEM_TIMESTMP  = :NG-BILL-ITEM-TIMESTMP              
MFA-TR*         WITH UR                                                 04974100
MFA-TR*       QUERYNO 7970                                                      
MFA-TR*    END-EXEC.                                                    04975000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00496                                                                  
P00496     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00496                                                                  
P00496     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00496         NEXT SENTENCE                                            
P00496     ELSE                                                         
P00496         MOVE 'CSR02071'              TO ABEND-PROGRAM            
P00496         MOVE '7970'                  TO ACTIVE-PARAGRAPH         
P00496         MOVE 'SELECT'                TO ABEND-FUNCTION           
P00496         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
P00496                                         ABEND-TABLES             
P00496         MOVE 'CSS_BILL_MANUAL'       TO TABLE-1                  
P00496         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
P00496         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
P00496         MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3          
P00496         MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
P00496         MOVE NG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
P00496         MOVE NG-BILL-NO              TO HOSTVAR-ELEMENT-2        
P00496         MOVE NG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3        
P00496         MOVE NG-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
P00496         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00496         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
P00496     END-IF.                                                      
P00496*                                                                 04994000
P00496 7970-EXIT.                                                       
P00496     EXIT.                                                        
P00496*                                                                         
P00496******************************************************************06682000
P00496*  OPEN  THE CURSOR DECLARED FOR CSS_BILL_MAN_DET TABLE.         *06684000
P00496******************************************************************06684300
P00496*                                                                         
P00496 7975-OPEN-BILLMAN-CRSR.                                          
P00496*                                                                         
           MOVE '7975' TO ACTIVE-PARAGRAPH.                             
                                                                        
ACT142 7975-START.                                                      
P00496                                                                  
P00496     EXEC SQL                                                     
P00496         OPEN BILL_MAN_DET                                        
P00496     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00496                                                                  
P00496     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT142                                                                  
ACT142     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT142     WHEN SUCCESSFUL-CALL                                         
ACT142        CONTINUE                                                  
ACT142     WHEN OTHER                                                   
ACT142        IF WS-ACTIVE-RETURN-CODE = WS-502 AND WS-RETRY-COUNT = 0  
ACT142          ADD 1 TO WS-RETRY-COUNT                                 
ACT142          PERFORM 7985-CLOSE-BILLMAN-CRSR       THRU 7985-EXIT    
ACT142          GO TO 7975-START                                        
ACT142        END-IF                                                    
ACT142        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
ACT142        MOVE '7975'                  TO ACTIVE-PARAGRAPH          
ACT142        MOVE 'OPEN'                  TO ABEND-FUNCTION            
ACT142        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
ACT142                                        ABEND-TABLES              
ACT142        MOVE 'CSS_BILL_MAN_DET'      TO TABLE-1                   
ACT142        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
ACT142        MOVE 'BILL_NO'               TO TABLE-ELEMENT-2           
ACT142        MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
ACT142        MOVE 'IC_NO'                 TO TABLE-ELEMENT-4           
ACT142        MOVE NU-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
ACT142        MOVE NU-BILL-NO              TO HOSTVAR-ELEMENT-2         
ACT142        MOVE NU-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
ACT142        MOVE NU-IC-NO                TO HOSTVAR-ELEMENT-4         
ACT142        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
ACT142     END-EVALUATE.                                                
P00496                                                                  
P00496 7975-EXIT.                                                       
P00496      EXIT.                                                       
P00496                                                                  
P00496******************************************************************06687400
P00496*  OPEN  THE CURSOR DECLARED FOR CSS_BILL_MAN_DET TABLE.         *06687600
P00496******************************************************************06687800
P00496 7980-FETCH-BILLADJ-CRSR.                                         
P00496*                                                                         
P00496     EXEC SQL                                                     
P00496         FETCH BILL_MAN_DET                                       
P00496               INTO  :NU-ACCOUNT-NO                               
P00496                    ,:NU-BILL-NO                                  
P00496                    ,:NU-CODE-UTIL-TYPE                           
P00496                    ,:NU-IC-NO                                    
P00496                    ,:NU-BILL-ITEM-TIMESTMP                       
P00496                    ,:NU-BILL-MAN-DET-SEQ                         
P00496                    ,:NU-BILL-MANUAL-TBL-ID                       
P00496                    ,:NU-BILL-MANUAL-DATA                         
P00496     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00496                                                                  
P00496     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00496                                                                  
P00496     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00496           NEXT SENTENCE                                          
P00496     ELSE                                                         
P00496        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
P00496        MOVE '7980'                  TO ACTIVE-PARAGRAPH          
P00496        MOVE 'FETCH'                 TO ABEND-FUNCTION            
P00496        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
P00496                                        ABEND-TABLES              
P00496        MOVE 'CSS_BILL_MAN_DET'      TO TABLE-1                   
P00496        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
P00496        MOVE 'BILL_NO'               TO TABLE-ELEMENT-2           
P00496        MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
P00496        MOVE 'IC_NO'                 TO TABLE-ELEMENT-4           
P00496        MOVE NU-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
P00496        MOVE NU-BILL-NO              TO HOSTVAR-ELEMENT-2         
P00496        MOVE NU-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
P00496        MOVE NU-IC-NO                TO HOSTVAR-ELEMENT-4         
P00496        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00496     END-IF.                                                      
P00496                                                                  
P00496 7980-EXIT.                                                       
P00496      EXIT.                                                       
P00496                                                                  
P00496******************************************************************06697400
P00496*  CLOSE THE CURSOR DECLARED CSS_BILL_MAN_DET FOR BILL HOOK      *06697600
P00496*  SHIFT.                                                        *06697700
P00496******************************************************************06697900
P00496 7985-CLOSE-BILLMAN-CRSR.                                         
P00496     EXEC SQL                                                     
P00496         CLOSE BILL_MAN_DET                                       
P00496     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00496                                                                  
P00496     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00496                                                                  
P00496     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00496           NEXT SENTENCE                                          
P00496     ELSE                                                         
P00496        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
P00496        MOVE '7985'                  TO ACTIVE-PARAGRAPH          
P00496        MOVE 'CLOSE'                 TO ABEND-FUNCTION            
P00496        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
P00496                                        ABEND-TABLES              
P00496        MOVE 'CSS_BILL_MAN_DET'      TO TABLE-1                   
P00496        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
P00496        MOVE 'BILL_NO'               TO TABLE-ELEMENT-2           
P00496        MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
P00496        MOVE 'IC_NO'                 TO TABLE-ELEMENT-4           
P00496        MOVE NU-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
P00496        MOVE NU-BILL-NO              TO HOSTVAR-ELEMENT-2         
P00496        MOVE NU-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
P00496        MOVE NU-IC-NO                TO HOSTVAR-ELEMENT-4         
P00496        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00496     END-IF.                                                      
P00496                                                                  
P00496                                                                  
P00496 7985-EXIT.                                                       
P00496      EXIT.                                                       
P00496                                                                  
       7998-SUB-ONE-MICROSEC.                                           
                                                                        
      ******************************************************************        
      *  SUBTRACT ONE MICROSECOND FROM THE GIVEN TIMESTMP              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
C35005        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, -1
              , CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) ), 121), 
           ' ', '-'), ':', '.')
            INTO
              :WS-BASERT-TIMESTMP   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-BASERT-TIMESTMP                                           
MFA-TR*           = TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) - 1 MICROSECOND           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7998'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'TIMESTMP'                TO TABLE-ELEMENT-1         
              MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7998-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       7999-ADD-ONE-MICROSEC.                                           
                                                                        
      ******************************************************************        
      *  ADD ONE MICROSECOND TO THE GIVEN TIMESTMP                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
C35005        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, 
              1, CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) ), 121), 
           ' ', '-'), ':', '.')
            INTO
              :WS-TRNSP-TIMESTMP   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-TRNSP-TIMESTMP                                            
MFA-TR*           = TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) + 1 MICROSECOND           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7999'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'TIMESTMP'                TO TABLE-ELEMENT-1         
              MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7999-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
C33924                                                                  
C33924 8010-INSERT-BILL-ADJ.                                            
C33924******************************************************************        
C33924*  INSERT A BILL ADJUSTMNT ROW INTO CSS_BILL_ADJUSTMNT           *        
C33924******************************************************************        
C33924                                                                  
C33924     MOVE '8010' TO ACTIVE-PARAGRAPH.                             
C33924                                                                  
C33924     EXEC SQL                                                     
C33924         INSERT INTO CSS_BILL_ADJUSTMNT(                          
C33924                     ACCOUNT_NO                                   
C33924                    ,BILL_NO                                      
C33924                    ,CODE_UTIL_TYPE                               
C33924                    ,IC_NO                                        
C33924                    ,BILL_ITEM_TIMESTMP                           
C33924                    ,ADJ_TYPE_CD                                  
C33924                    ,REVENUE_MONTH                                
C33924                    ,ADJ_REASON_DESC                              
P00246                    ,OVRRIDE_RT_REV_MTH                           
P00246                    ,OVRRIDE_RT_BILL_DT                           
P00246                    ,OVRRIDE_RT_BILL_CY                           
PRJ246                    ,SPECIAL_PROCESS_CD)                          
C33924         VALUES  (  :BP-ACCOUNT-NO,                               
C33924                    :BP-BILL-NO,                                  
C33924                    :BP-CODE-UTIL-TYPE,                           
C33924                    :BP-IC-NO,                                    
C33924                    CIS.CHAR2TIMESTAMP(:BP-BILL-ITEM-TIMESTMP),           
C33924                    :BP-ADJ-TYPE-CD,                              
C33924                    :BP-REVENUE-MONTH,                            
C33924                    :BP-ADJ-REASON-DESC,                          
P00246                    :BP-OVRRIDE-RT-REV-MTH,                       
P00246                    IIF(TRY_CONVERT(DATE, :BP-OVRRIDE-RT-BILL-DT 
                                                :WS-OVRD-BILL-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :BP-OVRRIDE-RT-BILL-DT 
                                                  :WS-OVRD-BILL-DT-NULL
              ) <> 0) OR (LEN(:BP-OVRRIDE-RT-BILL-DT 
                                                  :WS-OVRD-BILL-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:BP-OVRRIDE-RT-BILL-DT 
                                                  :WS-OVRD-BILL-DT-NULL
              ), CONVERT(DATE, :BP-OVRRIDE-RT-BILL-DT 
                                                  :WS-OVRD-BILL-DT-NULL
              ) ),  
P00246                    :BP-OVRRIDE-RT-BILL-CY,                       
PRJ246                    :BP-SPECIAL-PROCESS-CD)                       
C33924     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILL_ADJUSTMNT(                                  
MFA-TR*                    ACCOUNT_NO                                           
MFA-TR*                   ,BILL_NO                                              
MFA-TR*                   ,CODE_UTIL_TYPE                                       
MFA-TR*                   ,IC_NO                                                
MFA-TR*                   ,BILL_ITEM_TIMESTMP                                   
MFA-TR*                   ,ADJ_TYPE_CD                                          
MFA-TR*                   ,REVENUE_MONTH                                        
MFA-TR*                   ,ADJ_REASON_DESC                                      
MFA-TR*                   ,OVRRIDE_RT_REV_MTH                                   
MFA-TR*                   ,OVRRIDE_RT_BILL_DT                                   
MFA-TR*                   ,OVRRIDE_RT_BILL_CY                                   
MFA-TR*                   ,SPECIAL_PROCESS_CD)                                  
MFA-TR*        VALUES  (  :BP-ACCOUNT-NO,                                       
MFA-TR*                   :BP-BILL-NO,                                          
MFA-TR*                   :BP-CODE-UTIL-TYPE,                                   
MFA-TR*                   :BP-IC-NO,                                            
MFA-TR*                   :BP-BILL-ITEM-TIMESTMP,                               
MFA-TR*                   :BP-ADJ-TYPE-CD,                                      
MFA-TR*                   :BP-REVENUE-MONTH,                                    
MFA-TR*                   :BP-ADJ-REASON-DESC,                                  
MFA-TR*                   :BP-OVRRIDE-RT-REV-MTH,                               
MFA-TR*                   :BP-OVRRIDE-RT-BILL-DT:WS-OVRD-BILL-DT-NULL,          
MFA-TR*                   :BP-OVRRIDE-RT-BILL-CY,                               
MFA-TR*                   :BP-SPECIAL-PROCESS-CD)                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33924                                                                  
C33924     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
C33924                                                                  
C33924     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C33924           NEXT SENTENCE                                          
C33924     ELSE                                                         
C33924        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
C33924        MOVE SQLCODE                   TO ABEND-SQLCODE           
C33924        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33924        MOVE '8010'                    TO ACTIVE-PARAGRAPH        
C33924        MOVE 'INSERT'                  TO ABEND-FUNCTION          
C33924        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
C33924                                          ABEND-TABLES            
C33924        MOVE 'CSS_BILL_ADJUSTMNT'      TO TABLE-1                 
C33924        MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
C33924        MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
C33924        MOVE BP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
C33924        MOVE BP-BILL-NO                TO HOSTVAR-ELEMENT-2       
C33924        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33924     END-IF.                                                      
C33924                                                                  
C33924 8010-EXIT.                                                       
C33924     EXIT.                                                        
                                                                        
       8015-INSERT-UM-CNSMPTN-ROW.                                      
                                                                        
      ******************************************************************        
      *  INSERT INTO CSS_UM_CNSMPT_HIST.                               *        
      ******************************************************************        
                                                                        
           MOVE '8015' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_UM_CNSMPT_HIST                           
                     (ACCOUNT_NO,                                       
                      BILL_NO,                                          
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      BILL_ITEM_TIMESTMP,                               
                      RATE_ITEM_CODE,                                   
                      ITEM_SEQ_NO,                                      
                      NO_UNITS,                                         
                      NO_DAYS,                                          
                      CODE_DEBIT_CREDIT,                                
                      USAGE_FIXED,                                      
                      DATE_USAGE_ENDS,                                  
                      CODE_SERVICE_TYPE,                                
                      CODE_ITEM_STATUS,                                 
                      CODE_SOURCE_ID,                                   
                      MTHLY_AMOUNT_FIXED,                               
                      DIST_NO,                                          
                      LIGHT_NO,                                         
                      POLE_NO)                                          
               VALUES(:UC-ACCOUNT-NO,                                   
                      :UC-BILL-NO,                                      
                      :UC-CODE-UTIL-TYPE,                               
                      :UC-IC-NO,                                        
                      CIS.CHAR2TIMESTAMP(:UC-BILL-ITEM-TIMESTMP),               
                      :UC-RATE-ITEM-CODE,                               
                      :UC-ITEM-SEQ-NO,                                  
                      :UC-NO-UNITS,                                     
                      :UC-NO-DAYS,                                      
                      :UC-CODE-DEBIT-CREDIT,                            
                      :UC-USAGE-FIXED,                                  
                      IIF(TRY_CONVERT(DATE, :UC-DATE-USAGE-ENDS 
                                            :WS-DATE-USAGE-ENDS-NULL
              ) IS NULL OR (PATINDEX('%.%', :UC-DATE-USAGE-ENDS 
                                               :WS-DATE-USAGE-ENDS-NULL
              ) <> 0) OR (LEN(:UC-DATE-USAGE-ENDS 
                                               :WS-DATE-USAGE-ENDS-NULL
              ) <> 10), CIS.CHAR2DATE(:UC-DATE-USAGE-ENDS 
                                               :WS-DATE-USAGE-ENDS-NULL
              ), CONVERT(DATE, :UC-DATE-USAGE-ENDS 
                                               :WS-DATE-USAGE-ENDS-NULL
              ) ),      
                      :UC-CODE-SERVICE-TYPE,                            
                      :UC-CODE-ITEM-STATUS,                             
                      :UC-CODE-SOURCE-ID,                               
                      :UC-MTHLY-AMOUNT-FIXED,                           
                      :UC-DIST-NO,                                      
                      :UC-LIGHT-NO,                                     
                      :UC-POLE-NO)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_UM_CNSMPT_HIST                                   
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               BILL_NO,                                                  
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               IC_NO,                                                    
MFA-TR*               BILL_ITEM_TIMESTMP,                                       
MFA-TR*               RATE_ITEM_CODE,                                           
MFA-TR*               ITEM_SEQ_NO,                                              
MFA-TR*               NO_UNITS,                                                 
MFA-TR*               NO_DAYS,                                                  
MFA-TR*               CODE_DEBIT_CREDIT,                                        
MFA-TR*               USAGE_FIXED,                                              
MFA-TR*               DATE_USAGE_ENDS,                                          
MFA-TR*               CODE_SERVICE_TYPE,                                        
MFA-TR*               CODE_ITEM_STATUS,                                         
MFA-TR*               CODE_SOURCE_ID,                                           
MFA-TR*               MTHLY_AMOUNT_FIXED,                                       
MFA-TR*               DIST_NO,                                                  
MFA-TR*               LIGHT_NO,                                                 
MFA-TR*               POLE_NO)                                                  
MFA-TR*        VALUES(:UC-ACCOUNT-NO,                                           
MFA-TR*               :UC-BILL-NO,                                              
MFA-TR*               :UC-CODE-UTIL-TYPE,                                       
MFA-TR*               :UC-IC-NO,                                                
MFA-TR*               :UC-BILL-ITEM-TIMESTMP,                                   
MFA-TR*               :UC-RATE-ITEM-CODE,                                       
MFA-TR*               :UC-ITEM-SEQ-NO,                                          
MFA-TR*               :UC-NO-UNITS,                                             
MFA-TR*               :UC-NO-DAYS,                                              
MFA-TR*               :UC-CODE-DEBIT-CREDIT,                                    
MFA-TR*               :UC-USAGE-FIXED,                                          
MFA-TR*               :UC-DATE-USAGE-ENDS:WS-DATE-USAGE-ENDS-NULL,              
MFA-TR*               :UC-CODE-SERVICE-TYPE,                                    
MFA-TR*               :UC-CODE-ITEM-STATUS,                                     
MFA-TR*               :UC-CODE-SOURCE-ID,                                       
MFA-TR*               :UC-MTHLY-AMOUNT-FIXED,                                   
MFA-TR*               :UC-DIST-NO,                                              
MFA-TR*               :UC-LIGHT-NO,                                             
MFA-TR*               :UC-POLE-NO)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8015'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_UM_CNSMPT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL NO'                 TO TABLE-ELEMENT-2         
              MOVE 'IC NO'                   TO TABLE-ELEMENT-3         
              MOVE 'TIMESTMP'                TO TABLE-ELEMENT-4         
              MOVE UC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE UC-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE UC-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE UC-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       8015-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       8020-INSERT-CNSMPTN-ROW.                                         
                                                                        
      ******************************************************************        
      *  INSERT INTO CSS_CNSMPTN_HIST.                                 *        
      ******************************************************************        
                                                                        
           MOVE '8020' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CNSMPTN_HIST                             
                     (ACCOUNT_NO,                                       
                      BILL_NO,                                          
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      BILL_ITEM_TIMESTMP,                               
                      CODE_TIME_PERIOD,                                 
                      MTR_REF_NO,                                       
                      CODE_USAGE_TYPE,                                  
                      CODE_USAGE_ID,                                    
                      CODE_USAGE_SOURCE,                                
                      ITEM_SEQ_NO,                                      
                      METER_NO,                                         
                      REG_ID_NO,                                        
                      DATE_READ,                                        
                      CODE_METER_READ,                                  
                      CODE_METER_NO_READ,                               
                      METER_READING,                                    
                      DEMAND_READING,                                   
                      EMPLOYEE_NO,                                      
                      NO_UNITS,                                         
                      NO_DEMAND_UNITS,                                  
                      NO_DAYS,                                          
                      CODE_SOURCE_ID,                                   
                      CODE_DEBIT_CREDIT,                                
                      CODE_ITEM_STATUS,                                 
                      CODE_DISCOUNT,                                    
                      CONSTANT,                                         
                      NO_DIALS,                                         
                      COMPANY_NO,                                       
                      EXCEPT_OVERRIDE_CD,                               
                      REQUESTED_USAGE,                                  
                      DIGTL_INTRL_MTR_NO,                               
                      DIGTL_MTR_TYPE,                                   
                      CODE_TOU_SEASN,                                   
                      EXCL_DMD_RCHT_IND,                                
                      MTR_READ_SOURCE_CD,                               
                      BTU_FACTOR,                                       
C30989                PCOMP_FCT)                                        
              VALUES (:CX-ACCOUNT-NO,                                   
                      :CX-BILL-NO,                                      
                      :CX-CODE-UTIL-TYPE,                               
                      :CX-IC-NO,                                        
                      CIS.CHAR2TIMESTAMP(:CX-BILL-ITEM-TIMESTMP),               
                      :CX-CODE-TIME-PERIOD,                             
                      :CX-MTR-REF-NO,                                   
                      :CX-CODE-USAGE-TYPE,                              
                      :CX-CODE-USAGE-ID,                                
                      :CX-CODE-USAGE-SOURCE,                            
                      :CX-ITEM-SEQ-NO,                                  
                      :CX-METER-NO,                                     
                      :CX-REG-ID-NO,                                    
                      IIF(TRY_CONVERT(DATE, :CX-DATE-READ 
                                            :WS-DATE-READ-NULL
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ 
                                                     :WS-DATE-READ-NULL
              ) <> 0) OR (LEN(:CX-DATE-READ :WS-DATE-READ-NULL
              ) <> 10), CIS.CHAR2DATE(:CX-DATE-READ :WS-DATE-READ-NULL
              ), CONVERT(DATE, :CX-DATE-READ :WS-DATE-READ-NULL) ),            
                      :CX-CODE-METER-READ,                              
                      :CX-CODE-METER-NO-READ,                           
                      :CX-METER-READING,                                
                      :CX-DEMAND-READING,                               
                      :CX-EMPLOYEE-NO,                                  
                      :CX-NO-UNITS,                                     
                      :CX-NO-DEMAND-UNITS,                              
                      :CX-NO-DAYS,                                      
                      :CX-CODE-SOURCE-ID,                               
                      :CX-CODE-DEBIT-CREDIT,                            
                      :CX-CODE-ITEM-STATUS,                             
                      :CX-CODE-DISCOUNT,                                
                      :CX-CONSTANT,                                     
                      :CX-NO-DIALS,                                     
                      :CX-COMPANY-NO,                                   
                      :CX-EXCEPT-OVERRIDE-CD,                           
                      :CX-REQUESTED-USAGE,                              
                      :CX-DIGTL-INTRL-MTR-NO,                           
                      :CX-DIGTL-MTR-TYPE,                               
                      :CX-CODE-TOU-SEASN,                               
                      :CX-EXCL-DMD-RCHT-IND,                            
                      :CX-MTR-READ-SOURCE-CD,                           
                      :CX-BTU-FACTOR,                                   
C30989                :CX-PCOMP-FCT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CNSMPTN_HIST                                     
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               BILL_NO,                                                  
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               IC_NO,                                                    
MFA-TR*               BILL_ITEM_TIMESTMP,                                       
MFA-TR*               CODE_TIME_PERIOD,                                         
MFA-TR*               MTR_REF_NO,                                               
MFA-TR*               CODE_USAGE_TYPE,                                          
MFA-TR*               CODE_USAGE_ID,                                            
MFA-TR*               CODE_USAGE_SOURCE,                                        
MFA-TR*               ITEM_SEQ_NO,                                              
MFA-TR*               METER_NO,                                                 
MFA-TR*               REG_ID_NO,                                                
MFA-TR*               DATE_READ,                                                
MFA-TR*               CODE_METER_READ,                                          
MFA-TR*               CODE_METER_NO_READ,                                       
MFA-TR*               METER_READING,                                            
MFA-TR*               DEMAND_READING,                                           
MFA-TR*               EMPLOYEE_NO,                                              
MFA-TR*               NO_UNITS,                                                 
MFA-TR*               NO_DEMAND_UNITS,                                          
MFA-TR*               NO_DAYS,                                                  
MFA-TR*               CODE_SOURCE_ID,                                           
MFA-TR*               CODE_DEBIT_CREDIT,                                        
MFA-TR*               CODE_ITEM_STATUS,                                         
MFA-TR*               CODE_DISCOUNT,                                            
MFA-TR*               CONSTANT,                                                 
MFA-TR*               NO_DIALS,                                                 
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               EXCEPT_OVERRIDE_CD,                                       
MFA-TR*               REQUESTED_USAGE,                                          
MFA-TR*               DIGTL_INTRL_MTR_NO,                                       
MFA-TR*               DIGTL_MTR_TYPE,                                           
MFA-TR*               CODE_TOU_SEASN,                                           
MFA-TR*               EXCL_DMD_RCHT_IND,                                        
MFA-TR*               MTR_READ_SOURCE_CD,                                       
MFA-TR*               BTU_FACTOR,                                               
MFA-TR*               PCOMP_FCT)                                                
MFA-TR*       VALUES (:CX-ACCOUNT-NO,                                           
MFA-TR*               :CX-BILL-NO,                                              
MFA-TR*               :CX-CODE-UTIL-TYPE,                                       
MFA-TR*               :CX-IC-NO,                                                
MFA-TR*               :CX-BILL-ITEM-TIMESTMP,                                   
MFA-TR*               :CX-CODE-TIME-PERIOD,                                     
MFA-TR*               :CX-MTR-REF-NO,                                           
MFA-TR*               :CX-CODE-USAGE-TYPE,                                      
MFA-TR*               :CX-CODE-USAGE-ID,                                        
MFA-TR*               :CX-CODE-USAGE-SOURCE,                                    
MFA-TR*               :CX-ITEM-SEQ-NO,                                          
MFA-TR*               :CX-METER-NO,                                             
MFA-TR*               :CX-REG-ID-NO,                                            
MFA-TR*               :CX-DATE-READ:WS-DATE-READ-NULL,                          
MFA-TR*               :CX-CODE-METER-READ,                                      
MFA-TR*               :CX-CODE-METER-NO-READ,                                   
MFA-TR*               :CX-METER-READING,                                        
MFA-TR*               :CX-DEMAND-READING,                                       
MFA-TR*               :CX-EMPLOYEE-NO,                                          
MFA-TR*               :CX-NO-UNITS,                                             
MFA-TR*               :CX-NO-DEMAND-UNITS,                                      
MFA-TR*               :CX-NO-DAYS,                                              
MFA-TR*               :CX-CODE-SOURCE-ID,                                       
MFA-TR*               :CX-CODE-DEBIT-CREDIT,                                    
MFA-TR*               :CX-CODE-ITEM-STATUS,                                     
MFA-TR*               :CX-CODE-DISCOUNT,                                        
MFA-TR*               :CX-CONSTANT,                                             
MFA-TR*               :CX-NO-DIALS,                                             
MFA-TR*               :CX-COMPANY-NO,                                           
MFA-TR*               :CX-EXCEPT-OVERRIDE-CD,                                   
MFA-TR*               :CX-REQUESTED-USAGE,                                      
MFA-TR*               :CX-DIGTL-INTRL-MTR-NO,                                   
MFA-TR*               :CX-DIGTL-MTR-TYPE,                                       
MFA-TR*               :CX-CODE-TOU-SEASN,                                       
MFA-TR*               :CX-EXCL-DMD-RCHT-IND,                                    
MFA-TR*               :CX-MTR-READ-SOURCE-CD,                                   
MFA-TR*               :CX-BTU-FACTOR,                                           
MFA-TR*               :CX-PCOMP-FCT)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8021-UPDATE-MTRD-ENVRNMENT.                                      
                                                                        
      ******************************************************************        
      *  UPDATE CSS_ACCOUNT.  DATE_LAST_ACTION AND CODE_BILL_PEND ARE  *        
      *  ARE UPDATED IN 1000-PROCESS_ACCOUNT                           *        
      ******************************************************************        
                                                                        
           MOVE '8021' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_MTRD_ENVRNMT                                  
                     SET LAST_VAL_RD_VALUE = :MN-LAST-VAL-RD-VALUE      
                   WHERE ACCOUNT_NO     = :CX-ACCOUNT-NO                
                    AND  CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE            
                    AND  IC_NO          = :CX-IC-NO                     
                    AND  MTR_REF_NO     = :CX-MTR-REF-NO                
                    AND  METER_NO       = :CX-METER-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL  OR NOT-FOUND               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8021'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'IC-NO'                   TO TABLE-ELEMENT-2         
              MOVE 'METER-NO'                TO TABLE-ELEMENT-3         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-2       
              MOVE CX-METER-NO               TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8021-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8225-SELECT-CUST-PLAN.                                           
                                                                        
      ******************************************************************        
      *  PERFORM SELECT ON CSS_CUST_PLAN TO DETERMINE IF WE ARE DEALING*        
      *  WITH UNMETERED CONSUMPTION OR CONSUMPTION HISTORY             *        
      ******************************************************************        
                                                                        
           MOVE '8225'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             SELECT DISTINCT CODE_SERVICE_TYPE                          
               INTO :WS-UNMETERED-TYPE                                  
               FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                         
              WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                     
                AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                 
                AND IC_NO          = :CP-IC-NO                          
C33924                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DISTINCT CODE_SERVICE_TYPE                                  
MFA-TR*        INTO :WS-UNMETERED-TYPE                                          
MFA-TR*        FROM CSS_CUST_PLAN                                               
MFA-TR*       WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                             
MFA-TR*         AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                         
MFA-TR*         AND IC_NO          = :CP-IC-NO                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8225'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'IC-NO'                   TO TABLE-ELEMENT-2         
              MOVE CP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CP-IC-NO                  TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       8225-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00496******************************************************************06691800
P00496*  INSERT A ROW IN TABLE CSS_BILL_MANUAL FOR BILL HOOK           *06692000
P00496******************************************************************06692200
P00496 8030-INSERT-BILLMAN.                                             
P00496*                                                                         
P00496     EXEC SQL                                                     
P00496         INSERT INTO CSS_BILL_MANUAL(                             
P00496                     ACCOUNT_NO                                   
P00496                    ,BILL_NO                                      
P00496                    ,CODE_UTIL_TYPE                               
P00496                    ,IC_NO                                        
P00496                    ,BILL_ITEM_TIMESTMP                           
P00496                    ,BILL_MAN_STATUS_CD                           
P00496                    ,BILL_MAN_SOURCE_CD                           
P00496                    ,LAST_UPDATE_USERID                           
P00496                    ,LAST_UPDATE_TS )                             
P00496        VALUES     (:NG-ACCOUNT-NO                                
P00496                   ,:NG-BILL-NO                                   
P00496                   ,:NG-CODE-UTIL-TYPE                            
P00496                   ,:NG-IC-NO                                     
P00496                   ,CIS.CHAR2TIMESTAMP(:NG-BILL-ITEM-TIMESTMP)            
P00496                   ,:NG-BILL-MAN-STATUS-CD                        
P00496                   ,:NG-BILL-MAN-SOURCE-CD                        
P00496                   ,:NG-LAST-UPDATE-USERID                        
P00496                   ,CIS.CHAR2TIMESTAMP(:NG-LAST-UPDATE-TS))               
P00496     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06692300
MFA-TR*        INSERT INTO CSS_BILL_MANUAL(                             06692400
MFA-TR*                    ACCOUNT_NO                                           
MFA-TR*                   ,BILL_NO                                              
MFA-TR*                   ,CODE_UTIL_TYPE                                       
MFA-TR*                   ,IC_NO                                                
MFA-TR*                   ,BILL_ITEM_TIMESTMP                                   
MFA-TR*                   ,BILL_MAN_STATUS_CD                                   
MFA-TR*                   ,BILL_MAN_SOURCE_CD                                   
MFA-TR*                   ,LAST_UPDATE_USERID                                   
MFA-TR*                   ,LAST_UPDATE_TS )                                     
MFA-TR*       VALUES     (:NG-ACCOUNT-NO                                        
MFA-TR*                  ,:NG-BILL-NO                                           
MFA-TR*                  ,:NG-CODE-UTIL-TYPE                                    
MFA-TR*                  ,:NG-IC-NO                                             
MFA-TR*                  ,:NG-BILL-ITEM-TIMESTMP                                
MFA-TR*                  ,:NG-BILL-MAN-STATUS-CD                                
MFA-TR*                  ,:NG-BILL-MAN-SOURCE-CD                                
MFA-TR*                  ,:NG-LAST-UPDATE-USERID                                
MFA-TR*                  ,:NG-LAST-UPDATE-TS)                                   
MFA-TR*    END-EXEC.                                                    06694400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00496                                                                  
P00496     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00496                                                                  
P00496     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
P00496           NEXT SENTENCE                                          
P00496     ELSE                                                         
P00496        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
P00496        MOVE '8030'                  TO ACTIVE-PARAGRAPH          
P00496        MOVE 'INSERT'                TO ABEND-FUNCTION            
P00496        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
P00496                                        ABEND-TABLES              
P00496        MOVE 'CSS_BILL_MANUAL'       TO TABLE-1                   
P00496        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
P00496        MOVE 'BILL_NO'               TO TABLE-ELEMENT-2           
P00496        MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
P00496        MOVE 'IC_NO'                 TO TABLE-ELEMENT-4           
P00496        MOVE NG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
P00496        MOVE NG-BILL-NO              TO HOSTVAR-ELEMENT-2         
P00496        MOVE NG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
P00496        MOVE NG-IC-NO                TO HOSTVAR-ELEMENT-4         
P00496        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00496     END-IF.                                                      
P00496                                                                  
P00496 8030-EXIT.                                                       
P00496      EXIT.                                                       
P00496******************************************************************06691800
P00496*  INSERT A ROW IN TABLE CSS_BILL_MAN_DET FOR BILL HOOK          *06692000
P00496******************************************************************06692200
P00496 8040-INSERT-MANDET.                                              
P00496*                                                                         
P00496     EXEC SQL                                                     
P00496         INSERT INTO CSS_BILL_MAN_DET(                            
P00496                     ACCOUNT_NO                                   
P00496                    ,BILL_NO                                      
P00496                    ,CODE_UTIL_TYPE                               
P00496                    ,IC_NO                                        
P00496                    ,BILL_ITEM_TIMESTMP                           
P00496                    ,BILL_MAN_DET_SEQ                             
P00496                    ,BILL_MANUAL_TBL_ID                           
P00496                    ,BILL_MANUAL_DATA)                            
P00496          VALUES  (  :NU-ACCOUNT-NO                               
P00496                    ,:NU-BILL-NO                                  
P00496                    ,:NU-CODE-UTIL-TYPE                           
P00496                    ,:NU-IC-NO                                    
P00496                    ,CIS.CHAR2TIMESTAMP(:NU-BILL-ITEM-TIMESTMP)           
P00496                    ,:NU-BILL-MAN-DET-SEQ                         
P00496                    ,:NU-BILL-MANUAL-TBL-ID                       
P00496                    ,:NU-BILL-MANUAL-DATA)                        
P00496     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06692300
MFA-TR*        INSERT INTO CSS_BILL_MAN_DET(                            06692400
MFA-TR*                    ACCOUNT_NO                                   06692500
MFA-TR*                   ,BILL_NO                                      06692900
MFA-TR*                   ,CODE_UTIL_TYPE                               06693000
MFA-TR*                   ,IC_NO                                        06693100
MFA-TR*                   ,BILL_ITEM_TIMESTMP                           06693200
MFA-TR*                   ,BILL_MAN_DET_SEQ                             06693300
MFA-TR*                   ,BILL_MANUAL_TBL_ID                           06693400
MFA-TR*                   ,BILL_MANUAL_DATA)                            06693500
MFA-TR*         VALUES  (  :NU-ACCOUNT-NO                               06693600
MFA-TR*                   ,:NU-BILL-NO                                  06693700
MFA-TR*                   ,:NU-CODE-UTIL-TYPE                           06693800
MFA-TR*                   ,:NU-IC-NO                                    06693900
MFA-TR*                   ,:NU-BILL-ITEM-TIMESTMP                       06694000
MFA-TR*                   ,:NU-BILL-MAN-DET-SEQ                         06694100
MFA-TR*                   ,:NU-BILL-MANUAL-TBL-ID                       06694200
MFA-TR*                   ,:NU-BILL-MANUAL-DATA)                        06694300
MFA-TR*    END-EXEC.                                                    06694400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00496                                                                  
P00496     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00496                                                                  
P00496     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
P00496           NEXT SENTENCE                                          
P00496     ELSE                                                         
P00496        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
P00496        MOVE '8040'                  TO ACTIVE-PARAGRAPH          
P00496        MOVE 'INSERT'                TO ABEND-FUNCTION            
P00496        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
P00496                                        ABEND-TABLES              
P00496        MOVE 'CSS_BILL_MAN_DET'      TO TABLE-1                   
P00496        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
P00496        MOVE 'BILL_NO'               TO TABLE-ELEMENT-2           
P00496        MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
P00496        MOVE 'IC_NO'                 TO TABLE-ELEMENT-4           
P00496        MOVE NU-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
P00496        MOVE NU-BILL-NO              TO HOSTVAR-ELEMENT-2         
P00496        MOVE NU-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
P00496        MOVE NU-IC-NO                TO HOSTVAR-ELEMENT-4         
P00496        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00496     END-IF.                                                      
P00496                                                                  
P00496 8040-EXIT.                                                       
P00496      EXIT.                                                       
P00496                                                                  
       8550-UPDATE-ACCOUNT.                                             
                                                                        
      ******************************************************************        
      *  UPDATE CSS_ACCOUNT.  DATE_LAST_ACTION AND CODE_BILL_PEND ARE  *        
      *  ARE UPDATED IN 1000-PROCESS_ACCOUNT                           *        
      ******************************************************************        
                                                                        
           MOVE '8550' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                     SET DATE_LAST_ACTION = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:AT-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-LAST-ACTION
              ), CONVERT(DATE, :AT-DATE-LAST-ACTION) ),       
                         CODE_BILL_PEND = :AT-CODE-BILL-PEND,           
C35005                   CODE_TEMP_BILL = :AT-CODE-TEMP-BILL,           
                         LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )            
                   WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*              SET DATE_LAST_ACTION = :AT-DATE-LAST-ACTION,               
MFA-TR*                  CODE_BILL_PEND = :AT-CODE-BILL-PEND,                   
MFA-TR*                  CODE_TEMP_BILL = :AT-CODE-TEMP-BILL,                   
MFA-TR*                  LAST_UPDATE_TS = :AT-LAST-UPDATE-TS                    
MFA-TR*            WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8550'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8770-INSERT-BILL-HEADER.                                         
                                                                        
      ******************************************************************        
      *  INSERT A BILL HEADER ROW INTO CSS_BILLING_HDR.                *        
      ******************************************************************        
           MOVE '8770' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_BILLING_HDR                              
                     (PREMISE_NO,                                       
                     BILL_NO,                                           
                     DATE_BILLED,                                       
                     CODE_BILL_REASON,                                  
                     CODE_BILL_STATUS,                                  
                     CODE_BILL_TYPE,                                    
                     CUSTOMER_NO,                                       
                     ACCOUNT_NO,                                        
                     CODE_SPCL_BILL,                                    
                     PREM_ACCT_SEQ_NO,                                  
                     SMRY_BILL_NO,                                      
                     SMRY_REBILL_NO,                                    
                     ACCOUNT_NO_SUMM,                                   
                     COMPANY_NO,                                        
                     LAST_UPDATE_TS,                                    
                     TOT_OTHER_CHARGES,                                 
C35005               BILL_CORRECTED_CD,                                 
                     TOTAL_ARREARS)                                     
             VALUES  (:BI-PREMISE-NO,                                   
                     :BI-BILL-NO,                                       
                     IIF(TRY_CONVERT(DATE, :BI-DATE-BILLED 
                                           :WS-DATE-BILLED-NULL
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED 
                                                   :WS-DATE-BILLED-NULL
              ) <> 0) OR (LEN(:BI-DATE-BILLED :WS-DATE-BILLED-NULL
              ) <> 10), CIS.CHAR2DATE(:BI-DATE-BILLED 
                                                   :WS-DATE-BILLED-NULL
              ), CONVERT(DATE, :BI-DATE-BILLED :WS-DATE-BILLED-NULL) ),        
                     :BI-CODE-BILL-REASON,                              
                     :BI-CODE-BILL-STATUS,                              
                     :BI-CODE-BILL-TYPE,                                
                     :BI-CUSTOMER-NO,                                   
                     :BI-ACCOUNT-NO,                                    
                     :BI-CODE-SPCL-BILL,                                
                     :BI-PREM-ACCT-SEQ-NO,                              
                     :BI-SMRY-BILL-NO,                                  
                     :BI-SMRY-REBILL-NO,                                
                     :BI-ACCOUNT-NO-SUMM,                               
                     :BI-COMPANY-NO,                                    
                     CIS.CHAR2TIMESTAMP(:BI-LAST-UPDATE-TS),                    
                     :BI-TOT-OTHER-CHARGES,                             
C35005               :BI-BILL-CORRECTED-CD,                             
                     :BI-TOTAL-ARREARS)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILLING_HDR                                      
MFA-TR*              (PREMISE_NO,                                               
MFA-TR*              BILL_NO,                                                   
MFA-TR*              DATE_BILLED,                                               
MFA-TR*              CODE_BILL_REASON,                                          
MFA-TR*              CODE_BILL_STATUS,                                          
MFA-TR*              CODE_BILL_TYPE,                                            
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              CODE_SPCL_BILL,                                            
MFA-TR*              PREM_ACCT_SEQ_NO,                                          
MFA-TR*              SMRY_BILL_NO,                                              
MFA-TR*              SMRY_REBILL_NO,                                            
MFA-TR*              ACCOUNT_NO_SUMM,                                           
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              TOT_OTHER_CHARGES,                                         
MFA-TR*              BILL_CORRECTED_CD,                                         
MFA-TR*              TOTAL_ARREARS)                                             
MFA-TR*      VALUES  (:BI-PREMISE-NO,                                           
MFA-TR*              :BI-BILL-NO,                                               
MFA-TR*              :BI-DATE-BILLED:WS-DATE-BILLED-NULL,                       
MFA-TR*              :BI-CODE-BILL-REASON,                                      
MFA-TR*              :BI-CODE-BILL-STATUS,                                      
MFA-TR*              :BI-CODE-BILL-TYPE,                                        
MFA-TR*              :BI-CUSTOMER-NO,                                           
MFA-TR*              :BI-ACCOUNT-NO,                                            
MFA-TR*              :BI-CODE-SPCL-BILL,                                        
MFA-TR*              :BI-PREM-ACCT-SEQ-NO,                                      
MFA-TR*              :BI-SMRY-BILL-NO,                                          
MFA-TR*              :BI-SMRY-REBILL-NO,                                        
MFA-TR*              :BI-ACCOUNT-NO-SUMM,                                       
MFA-TR*              :BI-COMPANY-NO,                                            
MFA-TR*              :BI-LAST-UPDATE-TS,                                        
MFA-TR*              :BI-TOT-OTHER-CHARGES,                                     
MFA-TR*              :BI-BILL-CORRECTED-CD,                                     
MFA-TR*              :BI-TOTAL-ARREARS)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8770'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BI-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8770-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8771-INSERT-BILL-DETAIL.                                         
                                                                        
      ******************************************************************        
      *  INSERT A BILL DETAIL ROW INTO CSS_BILLING_DET.                *        
      ******************************************************************        
                                                                        
           MOVE '8771' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_BILLING_DET                              
                     (PREMISE_NO,                                       
                      BILL_NO,                                          
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      BILL_ITEM_TIMESTMP,                               
                      DATE_ORIG_BILL,                                   
                      AMT_BILL_ITEM,                                    
                      CODE_BILL_CALC,                                   
                      CODE_BILL_ITM_TYPE,                               
                      CODE_BILL_ITM_IND,                                
                      CODE_DR_CR_CNSMPTN,                               
                      AMT_STATE_TAX,                                    
                      AMT_CITY_TAX,                                     
                      AMT_OTHER_TAX,                                    
                      CODE_REVENUE_CLASS,                               
                      CODE_SIC_NO,                                      
                      RATE_PLAN_NO,                                     
                      CODE_CURTAIL_PRTY,                                
                      CODE_STAT_TAX_XMT,                                
                      CODE_CITY_TAX_XMT,                                
                      CODE_OTHR_TAX_XMT,                                
                      REV_RPT_CD,                                       
                      STANDBY_COMPLIED,                                 
                      PRORATE_CD,                                       
                      NEW_RATE_PCT,                                     
                      CODE_SUB_TOTAL,                                   
                      TAX_REFUND_CD,                                    
                      ACCOUNT_NO,                                       
                      COMPANY_NO,                                       
                      DATE_LFTM_HI_DMD,                                 
                      LFTM_HI_PEAK_DMD,                                 
                      REBILL_IND,                                       
                      ADJ_REASON_CD,                                    
                      REVENUE_MONTH,                                    
                      GAS_BASE_USE,                                     
                      WNA_FACTOR,                                       
                      BTU_FACTOR,                                       
                      NO_OF_CONS_DAYS,                                  
                      REV_MTH_ORIG_BILL,                                
                      REV_DISTRICT_CD,                                  
T25731                FUEL_SHIPPER_CD,                                  
                      ALTERNATE_FUEL_CD,                                
                      TRNSP_OVER_MDQ_FL,                                
C29528                CITY_TAX_RATE,                                    
C34569                OTHER_TAX_RATE,                                   
C29528                STATE_TAX_RATE,                                   
C33362                BILL_CALC_CYCLE,                                  
C34569                NAICS_CD,                                         
C34569                RT_PKG_OPT_SEQ_NO)                                
              VALUES (:BG-PREMISE-NO,                                   
                     :BG-BILL-NO,                                       
                     :BG-CODE-UTIL-TYPE,                                
                     :BG-IC-NO,                                         
                     CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP),                
                     IIF(TRY_CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                           :WS-DATE-ORIG-BILL-NULL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL 
                                                :WS-DATE-ORIG-BILL-NULL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL 
                                                :WS-DATE-ORIG-BILL-NULL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL 
                                                :WS-DATE-ORIG-BILL-NULL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                                :WS-DATE-ORIG-BILL-NULL
              ) ),         
                     :BG-AMT-BILL-ITEM,                                 
                     :BG-CODE-BILL-CALC,                                
                     :BG-CODE-BILL-ITM-TYPE,                            
                     :BG-CODE-BILL-ITM-IND,                             
                     :BG-CODE-DR-CR-CNSMPTN,                            
                     :BG-AMT-STATE-TAX,                                 
                     :BG-AMT-CITY-TAX,                                  
                     :BG-AMT-OTHER-TAX,                                 
                     :BG-CODE-REVENUE-CLASS,                            
                     :BG-CODE-SIC-NO,                                   
                     :BG-RATE-PLAN-NO,                                  
                     :BG-CODE-CURTAIL-PRTY,                             
                     :BG-CODE-STAT-TAX-XMT,                             
                     :BG-CODE-CITY-TAX-XMT,                             
                     :BG-CODE-OTHR-TAX-XMT,                             
                     :BG-REV-RPT-CD,                                    
                     :BG-STANDBY-COMPLIED,                              
                     :BG-PRORATE-CD,                                    
                     :BG-NEW-RATE-PCT,                                  
                     :BG-CODE-SUB-TOTAL,                                
                     :BG-TAX-REFUND-CD,                                 
                     :BG-ACCOUNT-NO,                                    
                     :BG-COMPANY-NO,                                    
                     IIF(TRY_CONVERT(DATE, :BG-DATE-LFTM-HI-DMD 
                                           :WS-DATE-LFTM-HI-DMD-NULL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-LFTM-HI-DMD 
                                              :WS-DATE-LFTM-HI-DMD-NULL
              ) <> 0) OR (LEN(:BG-DATE-LFTM-HI-DMD 
                                              :WS-DATE-LFTM-HI-DMD-NULL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-LFTM-HI-DMD 
                                              :WS-DATE-LFTM-HI-DMD-NULL
              ), CONVERT(DATE, :BG-DATE-LFTM-HI-DMD 
                                              :WS-DATE-LFTM-HI-DMD-NULL
              ) ),     
                     :BG-LFTM-HI-PEAK-DMD,                              
                     :BG-REBILL-IND,                                    
                     :BG-ADJ-REASON-CD,                                 
                     :BG-REVENUE-MONTH,                                 
                     :BG-GAS-BASE-USE,                                  
                     :BG-WNA-FACTOR,                                    
                     :BG-BTU-FACTOR,                                    
                     :BG-NO-OF-CONS-DAYS,                               
                     :BG-REV-MTH-ORIG-BILL,                             
                     :BG-REV-DISTRICT-CD,                               
T25731               :BG-FUEL-SHIPPER-CD,                               
                     :BG-ALTERNATE-FUEL-CD,                             
                     :BG-TRNSP-OVER-MDQ-FL,                             
C29528               :BG-CITY-TAX-RATE,                                 
C29528               :BG-OTHER-TAX-RATE,                                
C29528               :BG-STATE-TAX-RATE,                                
C33362               :BG-BILL-CALC-CYCLE,                               
C34569               :BG-NAICS-CD,                                      
C34569               :BG-RT-PKG-OPT-SEQ-NO)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILLING_DET                                      
MFA-TR*              (PREMISE_NO,                                               
MFA-TR*               BILL_NO,                                                  
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               IC_NO,                                                    
MFA-TR*               BILL_ITEM_TIMESTMP,                                       
MFA-TR*               DATE_ORIG_BILL,                                           
MFA-TR*               AMT_BILL_ITEM,                                            
MFA-TR*               CODE_BILL_CALC,                                           
MFA-TR*               CODE_BILL_ITM_TYPE,                                       
MFA-TR*               CODE_BILL_ITM_IND,                                        
MFA-TR*               CODE_DR_CR_CNSMPTN,                                       
MFA-TR*               AMT_STATE_TAX,                                            
MFA-TR*               AMT_CITY_TAX,                                             
MFA-TR*               AMT_OTHER_TAX,                                            
MFA-TR*               CODE_REVENUE_CLASS,                                       
MFA-TR*               CODE_SIC_NO,                                              
MFA-TR*               RATE_PLAN_NO,                                             
MFA-TR*               CODE_CURTAIL_PRTY,                                        
MFA-TR*               CODE_STAT_TAX_XMT,                                        
MFA-TR*               CODE_CITY_TAX_XMT,                                        
MFA-TR*               CODE_OTHR_TAX_XMT,                                        
MFA-TR*               REV_RPT_CD,                                               
MFA-TR*               STANDBY_COMPLIED,                                         
MFA-TR*               PRORATE_CD,                                               
MFA-TR*               NEW_RATE_PCT,                                             
MFA-TR*               CODE_SUB_TOTAL,                                           
MFA-TR*               TAX_REFUND_CD,                                            
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               DATE_LFTM_HI_DMD,                                         
MFA-TR*               LFTM_HI_PEAK_DMD,                                         
MFA-TR*               REBILL_IND,                                               
MFA-TR*               ADJ_REASON_CD,                                            
MFA-TR*               REVENUE_MONTH,                                            
MFA-TR*               GAS_BASE_USE,                                             
MFA-TR*               WNA_FACTOR,                                               
MFA-TR*               BTU_FACTOR,                                               
MFA-TR*               NO_OF_CONS_DAYS,                                          
MFA-TR*               REV_MTH_ORIG_BILL,                                        
MFA-TR*               REV_DISTRICT_CD,                                          
MFA-TR*               FUEL_SHIPPER_CD,                                          
MFA-TR*               ALTERNATE_FUEL_CD,                                        
MFA-TR*               TRNSP_OVER_MDQ_FL,                                        
MFA-TR*               CITY_TAX_RATE,                                            
MFA-TR*               OTHER_TAX_RATE,                                           
MFA-TR*               STATE_TAX_RATE,                                           
MFA-TR*               BILL_CALC_CYCLE,                                          
MFA-TR*               NAICS_CD,                                                 
MFA-TR*               RT_PKG_OPT_SEQ_NO)                                        
MFA-TR*       VALUES (:BG-PREMISE-NO,                                           
MFA-TR*              :BG-BILL-NO,                                               
MFA-TR*              :BG-CODE-UTIL-TYPE,                                        
MFA-TR*              :BG-IC-NO,                                                 
MFA-TR*              :BG-BILL-ITEM-TIMESTMP,                                    
MFA-TR*              :BG-DATE-ORIG-BILL:WS-DATE-ORIG-BILL-NULL,                 
MFA-TR*              :BG-AMT-BILL-ITEM,                                         
MFA-TR*              :BG-CODE-BILL-CALC,                                        
MFA-TR*              :BG-CODE-BILL-ITM-TYPE,                                    
MFA-TR*              :BG-CODE-BILL-ITM-IND,                                     
MFA-TR*              :BG-CODE-DR-CR-CNSMPTN,                                    
MFA-TR*              :BG-AMT-STATE-TAX,                                         
MFA-TR*              :BG-AMT-CITY-TAX,                                          
MFA-TR*              :BG-AMT-OTHER-TAX,                                         
MFA-TR*              :BG-CODE-REVENUE-CLASS,                                    
MFA-TR*              :BG-CODE-SIC-NO,                                           
MFA-TR*              :BG-RATE-PLAN-NO,                                          
MFA-TR*              :BG-CODE-CURTAIL-PRTY,                                     
MFA-TR*              :BG-CODE-STAT-TAX-XMT,                                     
MFA-TR*              :BG-CODE-CITY-TAX-XMT,                                     
MFA-TR*              :BG-CODE-OTHR-TAX-XMT,                                     
MFA-TR*              :BG-REV-RPT-CD,                                            
MFA-TR*              :BG-STANDBY-COMPLIED,                                      
MFA-TR*              :BG-PRORATE-CD,                                            
MFA-TR*              :BG-NEW-RATE-PCT,                                          
MFA-TR*              :BG-CODE-SUB-TOTAL,                                        
MFA-TR*              :BG-TAX-REFUND-CD,                                         
MFA-TR*              :BG-ACCOUNT-NO,                                            
MFA-TR*              :BG-COMPANY-NO,                                            
MFA-TR*              :BG-DATE-LFTM-HI-DMD:WS-DATE-LFTM-HI-DMD-NULL,             
MFA-TR*              :BG-LFTM-HI-PEAK-DMD,                                      
MFA-TR*              :BG-REBILL-IND,                                            
MFA-TR*              :BG-ADJ-REASON-CD,                                         
MFA-TR*              :BG-REVENUE-MONTH,                                         
MFA-TR*              :BG-GAS-BASE-USE,                                          
MFA-TR*              :BG-WNA-FACTOR,                                            
MFA-TR*              :BG-BTU-FACTOR,                                            
MFA-TR*              :BG-NO-OF-CONS-DAYS,                                       
MFA-TR*              :BG-REV-MTH-ORIG-BILL,                                     
MFA-TR*              :BG-REV-DISTRICT-CD,                                       
MFA-TR*              :BG-FUEL-SHIPPER-CD,                                       
MFA-TR*              :BG-ALTERNATE-FUEL-CD,                                     
MFA-TR*              :BG-TRNSP-OVER-MDQ-FL,                                     
MFA-TR*              :BG-CITY-TAX-RATE,                                         
MFA-TR*              :BG-OTHER-TAX-RATE,                                        
MFA-TR*              :BG-STATE-TAX-RATE,                                        
MFA-TR*              :BG-BILL-CALC-CYCLE,                                       
MFA-TR*              :BG-NAICS-CD,                                              
MFA-TR*              :BG-RT-PKG-OPT-SEQ-NO)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8771'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE 'IC-NO'                   TO TABLE-ELEMENT-3         
              MOVE 'BILL-ITEM-TIMESTMP'      TO TABLE-ELEMENT-4         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE BG-BILL-ITEM-TIMESTMP     TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8771-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8774-INSERT-FH.                                                  
                                                                        
      ******************************************************************        
      *  INSERT A FACTOR HISTORY ROW INTO CSS_FIXED_FCT_HIST           *        
      ******************************************************************        
                                                                        
           MOVE '8774' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_FIXED_FCT_HIST                           
                      (ACCOUNT_NO,                                      
                       BILL_NO,                                         
                       CODE_UTIL_TYPE,                                  
                       IC_NO,                                           
                       BILL_ITEM_TIMESTMP,                              
                       FIXED_FCTR_SEQ_NO,                               
                       FACTOR_ID,                                       
                       EFF_DATE_FROM,                                   
                       CMPNT_ID_CD,                                     
                       CODE_SEASON,                                     
                       INSTR_USE_TYPE_CD,                               
                       CODE_TIME_PERIOD,                                
                       CODE_DEBIT_CREDIT,                               
                       CODE_REVENUE_CLASS,                              
                       CODE_TAX_STAT_XMT,                               
                       CODE_TAX_CITY_XMT,                               
                       CODE_TAX_OTHR_XMT,                               
                       FACTOR,                                          
                       EFF_DATE_TO,                                     
                       FIXED_FCTR_TYP_CD,                               
                       BILL_UNITS,                                      
                       ENERGY_UNIT_CD,                                  
C34569                 DURATION_REMAIN_NO,                              
C34569                 OVR_RT_VER_PRO_FL,                               
C34569                 RT_PKG_OPT_SEQ_NO,                               
P00165                 BLOCK_NO,                                        
P00496                 FCTR_POWER_10)                                   
              VALUES (:FH-ACCOUNT-NO,                                   
                      :FH-BILL-NO,                                      
                      :FH-CODE-UTIL-TYPE,                               
                      :FH-IC-NO,                                        
                      CIS.CHAR2TIMESTAMP(:FH-BILL-ITEM-TIMESTMP),               
                      :FH-FIXED-FCTR-SEQ-NO,                            
                      :FH-FACTOR-ID,                                    
                      IIF(TRY_CONVERT(DATE, :FH-EFF-DATE-FROM 
                                            :WS-EFF-DATE-FROM-NULL
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM 
                                                 :WS-EFF-DATE-FROM-NULL
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM :WS-EFF-DATE-FROM-NULL
              ) <> 10), CIS.CHAR2DATE(:FH-EFF-DATE-FROM 
                                                 :WS-EFF-DATE-FROM-NULL
              ), CONVERT(DATE, :FH-EFF-DATE-FROM :WS-EFF-DATE-FROM-NULL
              ) ),          
                      :FH-CMPNT-ID-CD,                                  
                      :FH-CODE-SEASON,                                  
                      :FH-INSTR-USE-TYPE-CD,                            
                      :FH-CODE-TIME-PERIOD,                             
                      :FH-CODE-DEBIT-CREDIT,                            
                      :FH-CODE-REVENUE-CLASS,                           
                      :FH-CODE-TAX-STAT-XMT,                            
                      :FH-CODE-TAX-CITY-XMT,                            
                      :FH-CODE-TAX-OTHR-XMT,                            
                      :FH-FACTOR,                                       
                      IIF(TRY_CONVERT(DATE, :FH-EFF-DATE-TO 
                                            :WS-EFF-DATE-TO-NULL
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-TO 
                                                   :WS-EFF-DATE-TO-NULL
              ) <> 0) OR (LEN(:FH-EFF-DATE-TO :WS-EFF-DATE-TO-NULL
              ) <> 10), CIS.CHAR2DATE(:FH-EFF-DATE-TO 
                                                   :WS-EFF-DATE-TO-NULL
              ), CONVERT(DATE, :FH-EFF-DATE-TO :WS-EFF-DATE-TO-NULL) ),        
                      :FH-FIXED-FCTR-TYP-CD,                            
                      :FH-BILL-UNITS,                                   
                      :FH-ENERGY-UNIT-CD,                               
C34569                :FH-DURATION-REMAIN-NO :WS-DURATION-NULL,          
C34569                :FH-OVR-RT-VER-PRO-FL,                            
C34569                :FH-RT-PKG-OPT-SEQ-NO,                            
P00165                :FH-BLOCK-NO,                                     
P00496                :FH-FCTR-POWER-10)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIXED_FCT_HIST                                   
MFA-TR*               (ACCOUNT_NO,                                              
MFA-TR*                BILL_NO,                                                 
MFA-TR*                CODE_UTIL_TYPE,                                          
MFA-TR*                IC_NO,                                                   
MFA-TR*                BILL_ITEM_TIMESTMP,                                      
MFA-TR*                FIXED_FCTR_SEQ_NO,                                       
MFA-TR*                FACTOR_ID,                                               
MFA-TR*                EFF_DATE_FROM,                                           
MFA-TR*                CMPNT_ID_CD,                                             
MFA-TR*                CODE_SEASON,                                             
MFA-TR*                INSTR_USE_TYPE_CD,                                       
MFA-TR*                CODE_TIME_PERIOD,                                        
MFA-TR*                CODE_DEBIT_CREDIT,                                       
MFA-TR*                CODE_REVENUE_CLASS,                                      
MFA-TR*                CODE_TAX_STAT_XMT,                                       
MFA-TR*                CODE_TAX_CITY_XMT,                                       
MFA-TR*                CODE_TAX_OTHR_XMT,                                       
MFA-TR*                FACTOR,                                                  
MFA-TR*                EFF_DATE_TO,                                             
MFA-TR*                FIXED_FCTR_TYP_CD,                                       
MFA-TR*                BILL_UNITS,                                              
MFA-TR*                ENERGY_UNIT_CD,                                          
MFA-TR*                DURATION_REMAIN_NO,                                      
MFA-TR*                OVR_RT_VER_PRO_FL,                                       
MFA-TR*                RT_PKG_OPT_SEQ_NO,                                       
MFA-TR*                BLOCK_NO,                                                
MFA-TR*                FCTR_POWER_10)                                           
MFA-TR*       VALUES (:FH-ACCOUNT-NO,                                           
MFA-TR*               :FH-BILL-NO,                                              
MFA-TR*               :FH-CODE-UTIL-TYPE,                                       
MFA-TR*               :FH-IC-NO,                                                
MFA-TR*               :FH-BILL-ITEM-TIMESTMP,                                   
MFA-TR*               :FH-FIXED-FCTR-SEQ-NO,                                    
MFA-TR*               :FH-FACTOR-ID,                                            
MFA-TR*               :FH-EFF-DATE-FROM:WS-EFF-DATE-FROM-NULL,                  
MFA-TR*               :FH-CMPNT-ID-CD,                                          
MFA-TR*               :FH-CODE-SEASON,                                          
MFA-TR*               :FH-INSTR-USE-TYPE-CD,                                    
MFA-TR*               :FH-CODE-TIME-PERIOD,                                     
MFA-TR*               :FH-CODE-DEBIT-CREDIT,                                    
MFA-TR*               :FH-CODE-REVENUE-CLASS,                                   
MFA-TR*               :FH-CODE-TAX-STAT-XMT,                                    
MFA-TR*               :FH-CODE-TAX-CITY-XMT,                                    
MFA-TR*               :FH-CODE-TAX-OTHR-XMT,                                    
MFA-TR*               :FH-FACTOR,                                               
MFA-TR*               :FH-EFF-DATE-TO:WS-EFF-DATE-TO-NULL,                      
MFA-TR*               :FH-FIXED-FCTR-TYP-CD,                                    
MFA-TR*               :FH-BILL-UNITS,                                           
MFA-TR*               :FH-ENERGY-UNIT-CD,                                       
MFA-TR*               :FH-DURATION-REMAIN-NO:WS-DURATION-NULL,                  
MFA-TR*               :FH-OVR-RT-VER-PRO-FL,                                    
MFA-TR*               :FH-RT-PKG-OPT-SEQ-NO,                                    
MFA-TR*               :FH-BLOCK-NO,                                             
MFA-TR*               :FH-FCTR-POWER-10)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8774'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_FIXED_FCT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE FH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FH-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8774-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8775-DELETE-BILL-HEADER.                                         
                                                                        
      ******************************************************************        
      *  DELETE A BILL HEADER ROW FROM CSS_BILLING_HDR.  THIS DELETE   *        
      *  IS USED WHEN SHIFTING BILL HOOKS.                             *        
      ******************************************************************        
                                                                        
           MOVE '8775' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_BILLING_HDR                              
                     WHERE ACCOUNT_NO = :BI-ACCOUNT-NO AND              
                           BILL_NO = :BI-BILL-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8775'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BI-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8775-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       8776-INSERT-MTR-ID-HST.                                          
                                                                        
      ******************************************************************        
      *  INSERT A ROW INTO CSS_MTR_IDENT_HST FROM THE ORIGINAL BILL    *        
      ******************************************************************        
                                                                        
           MOVE '8776' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MTR_IDENT_HIST                           
                    (ACCOUNT_NO,                                        
                     BILL_NO,                                           
                     CODE_UTIL_TYPE,                                    
                     IC_NO,                                             
                     BILL_ITEM_TIMESTMP,                                
                     MTR_REF_NO,                                        
                     METER_NO,                                          
                     IDR_IDENT_NO,                                      
                     INTERVALS_PER_HR,                                  
                     CHANNEL_A_UOM,                                     
                     CHANNEL_B_UOM,                                     
                     CHANNEL_C_UOM,                                     
                     IDR_INFO_RETENT_DT,                                
                     CT_UPPER_RATIO,                                    
                     PT_UPPER_RATIO,                                    
                     CT_LOWER_RATIO,                                    
                     PT_LOWER_RATIO,                                    
                     INDUST_BTU_ID)                                     
             VALUES (:GA-ACCOUNT-NO,                                    
                     :GA-BILL-NO,                                       
                     :GA-CODE-UTIL-TYPE,                                
                     :GA-IC-NO,                                         
                     CIS.CHAR2TIMESTAMP(:GA-BILL-ITEM-TIMESTMP),                
                     :GA-MTR-REF-NO,                                    
                     :GA-METER-NO,                                      
                     :GA-IDR-IDENT-NO,                                  
                     :GA-INTERVALS-PER-HR,                              
                     :GA-CHANNEL-A-UOM,                                 
                     :GA-CHANNEL-B-UOM,                                 
                     :GA-CHANNEL-C-UOM,                                 
                     IIF(TRY_CONVERT(DATE, :GA-IDR-INFO-RETENT-DT 
                                           :WS-IDR-INFO-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :GA-IDR-INFO-RETENT-DT 
                                                  :WS-IDR-INFO-NULL-IND
              ) <> 0) OR (LEN(:GA-IDR-INFO-RETENT-DT 
                                                  :WS-IDR-INFO-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:GA-IDR-INFO-RETENT-DT 
                                                  :WS-IDR-INFO-NULL-IND
              ), CONVERT(DATE, :GA-IDR-INFO-RETENT-DT 
                                                  :WS-IDR-INFO-NULL-IND
              ) ),       
                     :GA-CT-UPPER-RATIO,                                
                     :GA-PT-UPPER-RATIO,                                
                     :GA-CT-LOWER-RATIO,                                
                     :GA-PT-LOWER-RATIO,                                
                     :GA-INDUST-BTU-ID)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MTR_IDENT_HIST                                   
MFA-TR*             (ACCOUNT_NO,                                                
MFA-TR*              BILL_NO,                                                   
MFA-TR*              CODE_UTIL_TYPE,                                            
MFA-TR*              IC_NO,                                                     
MFA-TR*              BILL_ITEM_TIMESTMP,                                        
MFA-TR*              MTR_REF_NO,                                                
MFA-TR*              METER_NO,                                                  
MFA-TR*              IDR_IDENT_NO,                                              
MFA-TR*              INTERVALS_PER_HR,                                          
MFA-TR*              CHANNEL_A_UOM,                                             
MFA-TR*              CHANNEL_B_UOM,                                             
MFA-TR*              CHANNEL_C_UOM,                                             
MFA-TR*              IDR_INFO_RETENT_DT,                                        
MFA-TR*              CT_UPPER_RATIO,                                            
MFA-TR*              PT_UPPER_RATIO,                                            
MFA-TR*              CT_LOWER_RATIO,                                            
MFA-TR*              PT_LOWER_RATIO,                                            
MFA-TR*              INDUST_BTU_ID)                                             
MFA-TR*      VALUES (:GA-ACCOUNT-NO,                                            
MFA-TR*              :GA-BILL-NO,                                               
MFA-TR*              :GA-CODE-UTIL-TYPE,                                        
MFA-TR*              :GA-IC-NO,                                                 
MFA-TR*              :GA-BILL-ITEM-TIMESTMP,                                    
MFA-TR*              :GA-MTR-REF-NO,                                            
MFA-TR*              :GA-METER-NO,                                              
MFA-TR*              :GA-IDR-IDENT-NO,                                          
MFA-TR*              :GA-INTERVALS-PER-HR,                                      
MFA-TR*              :GA-CHANNEL-A-UOM,                                         
MFA-TR*              :GA-CHANNEL-B-UOM,                                         
MFA-TR*              :GA-CHANNEL-C-UOM,                                         
MFA-TR*              :GA-IDR-INFO-RETENT-DT:WS-IDR-INFO-NULL-IND,               
MFA-TR*              :GA-CT-UPPER-RATIO,                                        
MFA-TR*              :GA-PT-UPPER-RATIO,                                        
MFA-TR*              :GA-CT-LOWER-RATIO,                                        
MFA-TR*              :GA-PT-LOWER-RATIO,                                        
MFA-TR*              :GA-INDUST-BTU-ID)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8776'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MTR_IDENT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE 'IC-NO'                   TO TABLE-ELEMENT-3         
              MOVE GA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE GA-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE GA-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8776-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
                                                                        
       8902-UPDATE-BILL-DET-CAN.                                        
                                                                        
      ******************************************************************        
      *  UPDATE CSS_BILLING_DET OF A CANCELLED BILL.                   *        
      ******************************************************************        
                                                                        
           MOVE '8902' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILLING_DET                                   
                    SET CODE_BILL_ITM_IND = :BG-CODE-BILL-ITM-IND       
                   WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO AND        
                         BILL_NO            = :BG-BILL-NO AND           
                         CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE AND    
                         IC_NO              = :BG-IC-NO AND             
                         BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILLING_DET                                           
MFA-TR*             SET CODE_BILL_ITM_IND = :BG-CODE-BILL-ITM-IND               
MFA-TR*            WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO AND                
MFA-TR*                  BILL_NO            = :BG-BILL-NO AND                   
MFA-TR*                  CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE AND            
MFA-TR*                  IC_NO              = :BG-IC-NO AND                     
MFA-TR*                  BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8902'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE 'IC-NO'                   TO TABLE-ELEMENT-3         
              MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8902-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8960-UPDATE-BILL-HDR-TYPE.                                       
                                                                        
      ******************************************************************        
      *  UPDATE THE CODE-BILL-TYPE ON THE CSS_BILLING_HDR TABLE.       *        
      ******************************************************************        
                                                                        
           MOVE '8960' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILLING_HDR                                   
                    SET CODE_BILL_TYPE = :BI-CODE-BILL-TYPE             
                   WHERE ACCOUNT_NO = :BI-ACCOUNT-NO AND                
                         BILL_NO = :BI-BILL-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8960'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL-NO'                 TO TABLE-ELEMENT-2         
              MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE BI-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8960-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
C35005 8961-SET-EXEMPT.                                                 
C35005                                                                  
C35005******************************************************************        
C35005*  SET CODES ON CSS_ACCOUNT TO INDICATE THE ACCOUNT IS EXEMPT    *        
C35005*  FROM LPC, NOTICES, AND DISCONNECTS.                           *        
C35005******************************************************************        
C35005                                                                  
C35005     EXEC SQL                                                     
C35005         UPDATE CSS_ACCOUNT                                       
C35005         SET CODE_LPC_XMT     = :AT-CODE-LPC-XMT                  
C35005            ,NOTICE_EXEMPT_CD = :AT-NOTICE-EXEMPT-CD              
C35005            ,IVR_EXEMPT_CD    = :AT-IVR-EXEMPT-CD                 
C35005            ,CODE_DISC_OK     = :AT-CODE-DISC-OK                  
C35005         WHERE ACCOUNT_NO     = :BI-ACCOUNT-NO                    
C35005     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35005                                                                  
C35005     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35005                                                                  
C35005     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35005           MOVE WS-Y TO WS-AT-CODES-UPDATED-SW                    
C35005     ELSE                                                         
C35005        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
C35005        MOVE SQLCODE                   TO ABEND-SQLCODE           
C35005        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C35005        MOVE '8961'                    TO ACTIVE-PARAGRAPH        
C35005        MOVE 'UPDATE'                  TO ABEND-FUNCTION          
C35005        MOVE SPACES                    TO ABEND-SQL-PREDICATES,   
C35005                                          ABEND-TABLES            
C35005        MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
C35005        MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
C35005        MOVE 'CODE_LPC_XMT'            TO TABLE-ELEMENT-2         
C35005        MOVE 'NOTICE_EXEMPT_CD'        TO TABLE-ELEMENT-3         
C35005        MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
C35005        MOVE AT-CODE-LPC-XMT           TO HOSTVAR-ELEMENT-2       
C35005        MOVE AT-NOTICE-EXEMPT-CD       TO HOSTVAR-ELEMENT-3       
C35005        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C35005     END-IF.                                                      
C35005                                                                  
C35005 8961-EXIT.                                                       
C35005     EXIT.                                                        
C35005                                                                  
C35005 8963-UPDATE-BILL-CORRECTED-CD.                                   
C35005                                                                  
C35005******************************************************************        
C35005*  UPDATE THE BILL-CORRECTED-CODE ON THE CSS_BILLING_HDR TABLE   *        
C35005******************************************************************        
C35005                                                                  
C35005     EXEC SQL                                                     
C35005         UPDATE CSS_BILLING_HDR                                   
C35005         SET   BILL_CORRECTED_CD = :BI-BILL-CORRECTED-CD          
C35005         WHERE ACCOUNT_NO        = :BI-ACCOUNT-NO                 
C35005         AND   BILL_NO           = :BI-BILL-NO                    
C35005     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35005                                                                  
C35005     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35005                                                                  
C35005     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C35005           NEXT SENTENCE                                          
C35005     ELSE                                                         
C35005        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
C35005        MOVE SQLCODE                   TO ABEND-SQLCODE           
C35005        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C35005        MOVE '8963'                    TO ACTIVE-PARAGRAPH        
C35005        MOVE 'UPDATE'                  TO ABEND-FUNCTION          
C35005        MOVE SPACES                    TO ABEND-SQL-PREDICATES,   
C35005                                          ABEND-TABLES            
C35005         MOVE 'CSS_BILLING_HDR'       TO TABLE-1                  
C35005         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
C35005         MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
C35005         MOVE BI-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
C35005         MOVE BI-BILL-NO              TO HOSTVAR-ELEMENT-2        
C35005         PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
C35005     END-IF.                                                      
C35005                                                                  
C35005 8963-EXIT.                                                       
C35005     EXIT.                                                        
C35005                                                                  
       8970-INSERT-OFF-CYCL-ACCT.                                       
                                                                        
      ******************************************************************        
      *  INSERT CSS_OFF_CYCL_ACCT.                                     *        
      ******************************************************************        
                                                                        
           MOVE '8970' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_OFF_CYCL_ACCT                            
                       (ACCOUNT_NO,                                     
                        CODE_BILL_OFF_CYCL,                             
                        CUSTOMER_NO)                                    
                    VALUES                                              
                       (:OC-ACCOUNT-NO,                                 
                        :OC-CODE-BILL-OFF-CYCL,                         
                        :OC-CUSTOMER-NO)                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             OR WS-ACTIVE-RETURN-CODE EQUAL ALREADY-EXISTS              
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8970'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_OFF_CYCL_ACCT'       TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE-BILL-OFF-CYCL'      TO TABLE-ELEMENT-2         
              MOVE OC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE OC-CODE-BILL-OFF-CYCL     TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8970-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8999-UPDATE-ACCOUNT.                                             
                                                                        
      ******************************************************************        
      *  UPDATE THE NXT-BILL-NO COLUMN ON THE CSS_ACCOUNT TABLE.       *        
      ******************************************************************        
                                                                        
           MOVE '8999' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                    SET NXT_BILL_NO    = :AT-NXT-BILL-NO,               
                        LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )             
                   WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*             SET NXT_BILL_NO    = :AT-NXT-BILL-NO,                       
MFA-TR*                 LAST_UPDATE_TS = :AT-LAST-UPDATE-TS                     
MFA-TR*            WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8999'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00765****************************************************************          
A00765* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *          
A00765****************************************************************          
A00765 9000-SEND-ERROR-RESULT.                                          
A00765                                                                  
A00765 9000-EXIT.                                                       
A00765*                                                                         
      ******************************************************************        
      * THIS ROUTINE WAS ADDED TO PACIFY CPD00067 JOURNALLING COPYBOOK *        
      ******************************************************************        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
              MOVE '9900' TO ACTIVE-PARAGRAPH                           
              DISPLAY '**  CPDCA190 PROCESSING ERROR  **'               
              DISPLAY '**      PARAGRAPH ' ACTIVE-PARAGRAPH             
              DISPLAY '**  FILE STATUS = ' WS-ACTIVE-RETURN-CODE        
           GO TO 9910-ABEND.                                            
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9910-ABEND                                                 *        
      *                                                                *        
      *     PERFORMED IF DB2 PROBLEM OCCURS.                           *        
      ******************************************************************        
                                                                        
       9910-ABEND.                                                      
                                                                        
           MOVE '9910' TO ACTIVE-PARAGRAPH.                             
A00765     MOVE WS-ACTIVE-RETURN-CODE  TO ABEND-SQLCODE                 
A00765                                    RS-RETURN-CODE.               
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE WS-RETURN-CODE-NUM TO WS-RETURN-CODE-CHAR            
              DISPLAY '**  CPDCA190 PROCESSING ERROR  **'               
              DISPLAY '**  UNSUCCESSFUL ROLLBACK      **'               
              DISPLAY '**  PARAGRAPH ' ACTIVE-PARAGRAPH                 
              DISPLAY '**  FILE STATUS = ' WS-RETURN-CODE-CHAR          
           END-IF.                                                      
           MOVE WS-RETURN-CODE-NUM  TO  RETURN-CODE.                    
           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT.                   
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
