      ******************************************************************        
      * CPDCA167                                                       *        
      *                                                                *        
      * This copybook has the common routines used between SCSCA167 and*        
      * PCSCA293. The information required will be parm to know if this*        
      * was called from SCSCA167 or PCSCA293.                          *        
      * ****************************************************************        
      * PREREQUISITES: THE INPUT VARIABLES SHOULD BE POPULATED         *        
      *                PRIOR TO INVOKING THIS ROUTINE.                 *        
      ******************************************************************        
      * INPUT  : AT-ACCOUNT-NO                                         *        
      *          AR-DATE-TRANS                                         *        
      * OUTPUT : RETURNS TRANSCATION DETAILS                           *        
      ******************************************************************        
      *                COPYBOOK MODIFICATION LOG                       *        
      *               ________________________________                 *        
      *  DATE     INITIALS          REASON                             *        
      * ______    ________    ____________________________________     *        
      * 10/10/13  MR7E794     INITIAL VERSION                          *        
      * 02/21/14  RAJ         MERGE SUBORDINATION CHANGES.             *        
A05058* 07/16/15  RB19957   1)ADDED MONEY ORDER TEST WHEN CHECKING     *        
A05058*          RICK BLACK   FOR CHECK OR DRAFT.                      *        
A05058*                     2)REMOVED WS-CHECK-OR-DRAFT VARIABLE USE.  *        
A05058*                       AND USED APPL PGM ID INSTEAD.            *        
I01959*10/09/15   DMS         FOR COGEN TRANSFER GET ACCOUNT NAME FROM *        
I01959*                       TRANS HIST COMMENT TO PRINT ON BILL      *        
P01137* 11/28/16  DMS         SET WS-AR-TRN-INDX OUTSIDE OF IF STMT    *        
      ******************************************************************        
      *                                                                         
      **************************************************                24700036
      ** CALL CONTRACT TABLE TO GET NAME CD TO      ****                24710036
      ** DETERMINE LITERAL                          ****                24720036
      **************************************************                24730036
       1016-GET-CONTRACT-DESC.                                          
           MOVE SPACES                         TO WS-HOLD-CONTRACT-MSG. 
           MOVE WS-ITEM-ID-AU (WS-AU-DET-INDX) TO CT-CNT-ITEM-ID        
           MOVE WS-ACCOUNT-NO-AU (WS-AU-DET-INDX) TO CT-ACCOUNT-NO      
           EXEC SQL                                                     
              SELECT CNT_NAME_CD                                        
                INTO :CT-CNT-NAME-CD                                    
                FROM CSS_CONTRACT                                       
               WHERE ACCOUNT_NO = :CT-ACCOUNT-NO                        
                 AND CNT_ITEM_ID = :CT-CNT-ITEM-ID                      
                 AND CODE_CONTRACT_TYPE = 'F'                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               DISPLAY 'SCSCA167:1016'                                  
               MOVE 'CT' TO WS-DB2-TABLE-ID                             
               MOVE 'SELECT' TO WS-DB2-FUNCTION                         
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
               MOVE '167' TO WS-DB2-MODULE-ID                           
               MOVE '1016' TO WS-DB2-PARAGRAPH                          
               MOVE WS-ACCOUNT-NO-SEARCH TO WS-DB2-KEY-1N               
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.                   
           PERFORM 1017-SELECT-CNTRT-NAME-DESC  THRU 1017-EXIT.         
                                                                        
       1016-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 25020036
      * SELECT THE CONTRACT NAME DESCRIPTION FROM THE CONTRACT INFO   * 25030036
      * TABLE FOR A CONTRACT CODE.                                    * 25040036
      ***************************************************************** 25050036
      *                                                                 25060036
       1017-SELECT-CNTRT-NAME-DESC.                                     
                                                                        
           MOVE CT-CNT-NAME-CD                 TO K6-CNT-NAME-CD.       
                                                                        
           EXEC SQL                                                     
                SELECT  CNT_NAME_DESC                                   
                  INTO :K6-CNT-NAME-DESC                                
                  FROM  CSS_CONTRACT_INFO                               
                 WHERE  CNT_NAME_CD = :K6-CNT-NAME-CD                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE K6-CNT-NAME-DESC       TO WS-HOLD-CONTRACT-MSG  
               WHEN NOT-FOUND                                           
                   MOVE CT-CNT-NAME-CD         TO WS-BAD-CNT-NAMECD     
                   DISPLAY WS-BAD-CNT-DESC-MSG                          
                   MOVE WS-BAD-CNT-DESC-MSG    TO WS-MISC-MSG-TEXT      
                   MOVE +50                    TO WS-MISC-MSG-LEN       
                   MOVE 9                      TO RETURN-CODE           
                   PERFORM 9910-MISC-ERROR     THRU 9910-EXIT           
                   MOVE SPACES                 TO WS-HOLD-CONTRACT-MSG  
               WHEN OTHER                                               
                   DISPLAY 'SCSCA167:1017'                              
                   MOVE 'K6'                   TO WS-DB2-TABLE-ID       
                   MOVE 'SELECT'               TO WS-DB2-FUNCTION       
                   MOVE SQLCODE                TO WS-DB2-RETURN-CODE    
                   MOVE '167'                  TO WS-DB2-MODULE-ID      
                   MOVE '1017'                 TO WS-DB2-PARAGRAPH      
                   MOVE WS-ACCOUNT-NO-SEARCH   TO WS-DB2-KEY-1N         
                   MOVE 12                     TO RETURN-CODE           
                   PERFORM 9900-SQL-ERROR      THRU 9900-EXIT           
           END-EVALUATE.                                                
                                                                        
       1017-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25450036
A04557******************************************************************83130036
A04557*   1018-SUBORD-FEE   .                                         **83140036
A04557*        Check if the transaction has subordinate fee.          **83150036
A04557******************************************************************83160036
       1018-SUBORD-FEE.                                                 
                                                                        
A04557     EXEC SQL                                                     
A04557        SELECT CNT_NAME_DESC                                      
A04557          INTO :K6-CNT-NAME-DESC                                  
A04557          FROM CSS_CONTRACT CT                                    
A04557              ,CSS_CONTRACT_INFO K6                               
A04557         WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO              
A04557           AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID             
A04557           AND CT.PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL       
A04557           AND CT.LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :CT-LAST-UPDATE-TS
              )          
A04557           AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD              
A04557     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CNT_NAME_DESC                                              
MFA-TR*         INTO :K6-CNT-NAME-DESC                                          
MFA-TR*         FROM CSS_CONTRACT CT                                            
MFA-TR*             ,CSS_CONTRACT_INFO K6                                       
MFA-TR*        WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO                      
MFA-TR*          AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID                     
MFA-TR*          AND CT.PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL               
MFA-TR*          AND CT.LAST_UPDATE_TS    = :CT-LAST-UPDATE-TS                  
MFA-TR*          AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    INITIALIZE K6-CNT-NAME-DESC                         
               WHEN OTHER                                               
                   DISPLAY 'SCSCA167:7810'                              
                   MOVE 'CT'               TO WS-DB2-TABLE-ID           
                   MOVE 'SELECT '          TO WS-DB2-FUNCTION           
                   MOVE SQLCODE            TO WS-DB2-RETURN-CODE        
                   MOVE '167'              TO WS-DB2-MODULE-ID          
                   MOVE '1018'             TO WS-DB2-PARAGRAPH          
                   MOVE AU-ACCOUNT-NO      TO WS-DB2-KEY-1N             
                   MOVE 12                 TO RETURN-CODE               
                   PERFORM 9900-SQL-ERROR THRU 9900-EXIT                
           END-EVALUATE.                                                
                                                                        
       1018-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 39260036
      *  MOVE THE DATABASE VALUES FROM AR TRANS HIST TO THE COPYBOOK  * 39270036
      *  TO BE WRITTEN FOR OUTPUT.                                    * 39280036
      ***************************************************************** 39290036
                                                                        
       1100-LOAD-TRANS-HIST.                                            
                                                                        
           IF WS-AR-TRN-INDX > 200                                      
              IF WS-AR-TRAN-EXCESS-MSG = 'N'                            
                 MOVE 'Y'                    TO WS-AR-TRAN-EXCESS-MSG   
                 DISPLAY " BILL PRINT NOT TO HANDLE MORE THAN 200 AR "  
                      "TRANS!!! PLEASE CHECK THE ACCOUNT " AR-ACCOUNT-NO
                 MOVE 9                   TO RETURN-CODE                
                 MOVE AR-ACCOUNT-NO       TO WS-BAD-TRN-ACCOUNT         
                 MOVE WS-BAD-AR-TRN-MSG   TO WS-MISC-MSG-TEXT           
                 MOVE 83                  TO WS-MISC-MSG-LEN            
                 PERFORM 9910-MISC-ERROR THRU 9910-EXIT                 
              END-IF                                                    
              IF WS-CODE-TEMP-BILL-AT = 'R'                             
                 AND SEB-DATABASE                                       
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 'T' TO WS-CODE-TEMP-BILL-AT                       
              END-IF                                                    
              GO TO 1100-EXIT                                           
           END-IF.                                                      
           MOVE AR-ACCOUNT-NO TO                                        
                WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX).                      
           MOVE AR-TRANS-HIST-SEQ-NO TO                                 
                WS-TRANS-HIST-SEQ-NO-AR (WS-AR-TRN-INDX).               
           MOVE AR-DATE-TRANS TO                                        
                WS-DATE-TRANS-AR (WS-AR-TRN-INDX).                      
           MOVE AR-CODE-TRAN-TYPE TO                                    
                WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX).                  
           IF WS-AMOUNT-PREPAY NOT = ZERO AND                           
              WS-AMOUNT-PREPAY NOT = AR-AMT-ORIG-ENTERED                
              MOVE WS-AMOUNT-PREPAY  TO                                 
                   WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)              
              MOVE ZERO              TO WS-AMOUNT-PREPAY                
           ELSE                                                         
            IF WS-CONTRACT-CREDIT NOT = ZERO                            
              MOVE WS-CONTRACT-CREDIT TO                                
                   WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)              
              MOVE ZERO              TO WS-CONTRACT-CREDIT              
            ELSE                                                        
              MOVE AR-AMT-ORIG-ENTERED TO                               
                   WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)              
            END-IF                                                      
           END-IF.                                                      
           MOVE AR-AMT-BILLED-UNPAID TO                                 
                WS-AMT-BILLED-UNPAID-AR (WS-AR-TRN-INDX).               
           MOVE AR-RESP-AREA-ID TO                                      
                WS-RESP-AREA-ID-AR (WS-AR-TRN-INDX).                    
           MOVE AR-APPL-PROGRAM-ID TO                                   
                WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX).                 
           MOVE AR-PYMT-FACILITY-CD TO                                  
                WS-PYMT-FACILITY-CD-AR (WS-AR-TRN-INDX).                
           MOVE AR-USER-ID TO                                           
                WS-USER-ID-AR (WS-AR-TRN-INDX).                         
           MOVE AR-COMPANY-NO TO                                        
                WS-COMPANY-NO-AR (WS-AR-TRN-INDX).                      
           MOVE AR-RECORD-ONLY-FL TO                                    
                WS-RECORD-ONLY-FL-AR (WS-AR-TRN-INDX).                  
           MOVE AR-DATE-ORIG-PYMT TO                                    
                WS-DATE-ORIG-PYMT-AR (WS-AR-TRN-INDX).                  
           MOVE AR-TRAN-COMMENT-LEN TO                                  
                WS-TRAN-COMMENT-LEN-AR (WS-AR-TRN-INDX).                
           MOVE AR-TRAN-COMMENT-TEXT TO                                 
                WS-TRAN-COMMENT-TEXT-AR (WS-AR-TRN-INDX).               
           MOVE WS-XFER-REFUND-AMT TO                                   
                WS-AR-REFUND-XFER-AMT-CALC (WS-AR-TRN-INDX).            
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 40010036
      *  MOVE THE DATABASE VALUES FROM AR_TRN_HST_DET TO THE COPYBOOK * 40020036
      *  TO BE WRITTEN FOR OUTPUT.                                    * 40030036
      ***************************************************************** 40040036
                                                                        
       1150-LOAD-TRN-HST-DET.                                           
                                                                        
           MOVE AU-ACCOUNT-NO TO                                        
                WS-ACCOUNT-NO-AU (WS-AU-DET-INDX).                      
           MOVE AU-TRANS-HIST-SEQ-NO TO                                 
                WS-TRANS-HIST-SEQ-NO-AU (WS-AU-DET-INDX).               
           MOVE AU-TRAN-APPL-NO TO                                      
                WS-TRAN-APPL-NO-AU (WS-AU-DET-INDX).                    
           MOVE AU-CODE-AR-AGE TO                                       
                WS-CODE-AR-AGE-AU (WS-AU-DET-INDX).                     
           MOVE AU-GL-ACCT-CREDIT TO                                    
                WS-GL-ACCT-CREDIT-AU (WS-AU-DET-INDX).                  
           MOVE AU-GL-ACCT-DEBIT TO                                     
                WS-GL-ACCT-DEBIT-AU (WS-AU-DET-INDX).                   
           MOVE AU-AMT-POSTED TO                                        
                WS-AMT-POSTED-AU (WS-AU-DET-INDX).                      
           MOVE AU-ITEM-ID TO                                           
                WS-ITEM-ID-AU (WS-AU-DET-INDX).                         
           MOVE AU-CODE-CONTRACT-TYPE TO                                
                WS-CODE-CONTRACT-TYPE-AU (WS-AU-DET-INDX).              
           MOVE AU-CURRENCY-TYPE TO                                     
                WS-CURRENCY-TYPE-AU (WS-AU-DET-INDX).                   
           MOVE AU-CURRENCY-AMT TO                                      
                WS-CURRENCY-AMT-AU (WS-AU-DET-INDX).                    
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 43000036
       1400-LOAD-BILL-MSG.                                              
           PERFORM VARYING WS-MSG-INDX FROM 1 BY 1                      
             UNTIL WS-MSG-INDX > 10                                     
              IF WS-BILL-MESSAGE-NO-CALC (WS-MSG-INDX) <= 0             
                 MOVE WS-BILL-MESSAGE                                   
                     TO WS-BILL-MESSAGE-NO-CALC (WS-MSG-INDX)           
                 MOVE 11 TO WS-MSG-INDX                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 43100036
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 43130036
       4050-GET-CNT-AR-CODE-AGE.                                        
           MOVE AR-ACCOUNT-NO TO AU-ACCOUNT-NO.                         
           MOVE AR-TRANS-HIST-SEQ-NO TO AU-TRANS-HIST-SEQ-NO.           
           EXEC SQL                                                     
             SELECT DISTINCT CODE_AR_AGE                                
                   ,GL_ACCT_CREDIT                                      
                   ,GL_ACCT_DEBIT                                       
               INTO :AU-CODE-AR-AGE                                     
                   ,:AU-GL-ACCT-CREDIT                                  
                   ,:AU-GL-ACCT-DEBIT                                   
               FROM CSS_AR_TRN_HST_DET                                  
              WHERE ACCOUNT_NO = :AU-ACCOUNT-NO                         
                AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AU-TRANS-HIST-SEQ-NO
              )           
                AND CODE_CONTRACT_TYPE <> ' '                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     59070036
MFA-TR*      SELECT DISTINCT CODE_AR_AGE                                59080036
MFA-TR*            ,GL_ACCT_CREDIT                                      59090036
MFA-TR*            ,GL_ACCT_DEBIT                                       59100036
MFA-TR*        INTO :AU-CODE-AR-AGE                                     59110036
MFA-TR*            ,:AU-GL-ACCT-CREDIT                                  59120036
MFA-TR*            ,:AU-GL-ACCT-DEBIT                                   59130036
MFA-TR*        FROM CSS_AR_TRN_HST_DET                                  59140036
MFA-TR*       WHERE ACCOUNT_NO = :AU-ACCOUNT-NO                         59150036
MFA-TR*         AND TRANS_HIST_SEQ_NO = :AU-TRANS-HIST-SEQ-NO           59160036
MFA-TR*         AND CODE_CONTRACT_TYPE <> ' '                           59170036
MFA-TR*    END-EXEC.                                                    59180036

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               EXEC SQL                                                 
                 SELECT DISTINCT CODE_AR_AGE                            
                   INTO :AU-CODE-AR-AGE                                 
                   FROM CSS_AR_TRN_HST_DET                              
                  WHERE ACCOUNT_NO = :AU-ACCOUNT-NO                     
                    AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AU-TRANS-HIST-SEQ-NO
              )       
               END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                 59210036
MFA-TR*          SELECT DISTINCT CODE_AR_AGE                            59220036
MFA-TR*            INTO :AU-CODE-AR-AGE                                 59230036
MFA-TR*            FROM CSS_AR_TRN_HST_DET                              59240036
MFA-TR*           WHERE ACCOUNT_NO = :AU-ACCOUNT-NO                     59250036
MFA-TR*             AND TRANS_HIST_SEQ_NO = :AU-TRANS-HIST-SEQ-NO       59260036
MFA-TR*        END-EXEC.                                                59270036
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL


           END-IF.                                                
       4050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
      * EXTRACT AR TRANS HIST FOR BILLED ROW.                                   
      *================================================================*        
      *                                                                         
       6100-GET-BILL-AR-TRANS.                                          
                                                                        
           MOVE 'B'                       TO AR-CODE-TRAN-TYPE.         
P01137     SET WS-AR-TRN-INDX             TO 1.                         
           PERFORM 6900-OPEN-BILL-AR-TRANS      THRU 6900-EXIT.         
           PERFORM 6901-FETCH-BILL-AR-TRANS     THRU 6901-EXIT.         
           IF WS-AR-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
              MOVE AR-ACCOUNT-NO        TO AU-ACCOUNT-NO                
              MOVE AR-TRANS-HIST-SEQ-NO TO AU-TRANS-HIST-SEQ-NO         
                                           WS-CURR-HST-SEQ-NO           
                                           WS-CURR-SEQ-NO               
      *check if this can be done in scsca167 setting the indx to 1.             
              IF CA167-CALL                                             
                 MOVE WS-DATE-BILLED-BI TO WS-DATE-TRANS-SEARCH         
                 MOVE 'C' TO WS-AR-PRINT-CONTROL-IND (WS-AR-TRN-INDX)   
                 PERFORM 1100-LOAD-TRANS-HIST THRU 1100-EXIT            
                 SET WS-AR-TRN-INDX UP BY 1                             
                 SET WS-AU-DET-INDX TO 1                                
                 INITIALIZE WS-AMT-EPP-ADJ-HOLD                         
                            WS-AMT-EPP-CIA-HOLD                         
              END-IF                                                    
              PERFORM 6910-OPEN-AR-TRANS-DET   THRU 6910-EXIT           
              PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT           
              PERFORM 6110-LOAD-OTHER-CHGS     THRU 6110-EXIT UNTIL     
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
              PERFORM 6912-CLOSE-AR-TRANS-DET  THRU 6912-EXIT           
           END-IF.                                                      
           PERFORM 6902-CLOSE-BILL-AR-TRANS    THRU 6902-EXIT.          
                                                                        
       6100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       6110-LOAD-OTHER-CHGS.                                            
                                                                        
           PERFORM 6115-PROCESS-TRANS-DET  THRU 6115-EXIT.              
           PERFORM 6911-FETCH-AR-TRANS-DET THRU 6911-EXIT.              
                                                                        
       6110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6115-PROCESS-TRANS-DET.                                          
           IF CA167-CALL                                                
             PERFORM 1150-LOAD-TRN-HST-DET THRU 1150-EXIT               
             IF AU-CODE-AR-AGE = 'A'                                    
                 MOVE 'N' TO WS-PROCESS-FLAG-CALC (WS-AU-DET-INDX)      
                 MOVE 'BYPASS - CODE_AR_AGE = A' TO                     
                      WS-TRANS-DESC-CALC (WS-AU-DET-INDX)               
                 SET WS-AU-DET-INDX UP BY 1                             
                 GO TO 6115-EXIT                                        
             END-IF                                                     
             IF AU-CODE-AR-AGE = 'E'                                    
                 MOVE 'Y' TO WS-PROCESS-FLAG-CALC (WS-AU-DET-INDX)      
                                                                        
                 ADD AU-AMT-POSTED TO WS-AMT-EPP-ADJ-HOLD               
                 MOVE 'ADJUSTMENT TO BBP OUTSTANDING BALANCE' TO        
                      WS-TRANS-DESC-CALC (WS-AU-DET-INDX)               
                 MOVE 'U' TO WS-TRANS-TYPE-CALC (WS-AU-DET-INDX)        
                 SET WS-AU-DET-INDX UP BY 1                             
                 GO TO 6115-EXIT                                        
             END-IF                                                     
           END-IF.                                                      
                                                                        
      * WE HAVE THE GL NUMBERS FROM THE DATABASE.  TRANSLATE THEM               
      * INTO THE CORRECT MNEMONICS.                                             
           MOVE SPACES TO WS-GL-CREDIT-NAME WS-GL-DEBIT-NAME.           
           MOVE SPACES TO WS-GL-CREDIT-CLASS WS-GL-DEBIT-CLASS.         
           MOVE ' '                    TO WS-GL-MATCH.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           MOVE AU-GL-ACCT-DEBIT       TO WS-HOLD-GL-ACCT.              
           PERFORM 6120-PROCESS-GL-NAME     THRU 6120-EXIT.             
           MOVE WS-HOLD-GL-NAME        TO WS-GL-DEBIT-NAME.             
           MOVE WS-HOLD-GL-CLASS       TO WS-GL-DEBIT-CLASS.            
           MOVE ' '                    TO WS-GL-MATCH.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           MOVE AU-GL-ACCT-CREDIT      TO WS-HOLD-GL-ACCT.              
           PERFORM 6120-PROCESS-GL-NAME     THRU 6120-EXIT.             
           MOVE WS-HOLD-GL-NAME        TO WS-GL-CREDIT-NAME.            
           MOVE WS-HOLD-GL-CLASS       TO WS-GL-CREDIT-CLASS.           
      *                                                                         
      * IGNORE DETAIL RECORDS THAT DO NOT HAVE AN A/R ACCOUNT AS                
      * EITHER THE DEBIT OR CREDIT.                                             
           MOVE 'N' TO WS-CREDIT-AR-SW WS-DEBIT-AR-SW.                  
           MOVE WS-GL-CREDIT-NAME TO WS-CHECK-GL-ACCT.                  
           IF WS-AR-ACCOUNT                                             
               MOVE 'Y' TO WS-CREDIT-AR-SW
           END-IF.                             
           MOVE WS-GL-DEBIT-NAME TO WS-CHECK-GL-ACCT.                   
           IF WS-AR-ACCOUNT                                             
               MOVE 'Y' TO WS-DEBIT-AR-SW
           END-IF.                              
           IF WS-CREDIT-AR-SW = 'Y' OR WS-DEBIT-AR-SW = 'Y'             
               NEXT SENTENCE                                            
           ELSE                                                         
               GO TO 6115-EXIT                                          
           END-IF.                                                      
      *                                                                         
      ****************************************************************          
      * THE FOLLOWING CODE IS VALID ONLY FOR SEB. THIS IS BECAUSE THE*          
      * PRESENTATION IS DIFFERENT FOR SEB WHEN COMPARED TO SCEG/PSNC.*          
      ****************************************************************          
           IF SEB-DATABASE AND CA167-CALL                               
              IF WS-TOTAL-AR-BALANCE-AT < 0                             
                 IF AU-CODE-AR-AGE    = 'P' AND                         
                    EPP-ANNIV-MTH  AND                                  
                    WS-GL-CREDIT-NAME = 'AR-BUD' AND                    
                    WS-GL-DEBIT-NAME  = 'AR-CIA'                        
                     MOVE 'Y' TO WS-PROCESS-FLAG-CALC (WS-AU-DET-INDX)  
                     ADD AU-AMT-POSTED TO WS-AMT-EPP-ADJ-HOLD           
                     MOVE 'ADJUSTMENT TO BBP OUTSTANDING BALANCE' TO    
                           WS-TRANS-DESC-CALC (WS-AU-DET-INDX)          
                     MOVE 'U' TO WS-TRANS-TYPE-CALC (WS-AU-DET-INDX)    
                    SET WS-AU-DET-INDX UP BY 1                          
                    GO TO 6115-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
      * IGNORE CLOSED CONTRACT PAID OFF BY CIA                                  
           MOVE AU-GL-ACCT-DEBIT TO WS-HOLD-GL-ACCOUNT                  
           IF (AU-GL-ACCT-CREDIT = 142.0900 AND                         
              WS-HOLD-GL-ACCOUNT (1:3) = 253) AND CA167-CALL            
               MOVE 'N' TO WS-PROCESS-FLAG-CALC (WS-AU-DET-INDX)        
               MOVE 'BYPASS - CONTRACT CREDIT' TO                       
                    WS-TRANS-DESC-CALC (WS-AU-DET-INDX)                 
               SET WS-AU-DET-INDX UP BY 1                               
               GO TO 6115-EXIT                                          
           END-IF                                                       
                                                                        
      * IGNORE TAX CHARGES.                                                     
                                                                        
           MOVE WS-GL-CREDIT-NAME TO WS-CHECK-GL-ACCT.                  
           IF WS-TAX-ACCOUNT AND CA167-CALL                             
               MOVE 'N' TO WS-PROCESS-FLAG-CALC (WS-AU-DET-INDX)        
               MOVE 'BYPASS - TAX RECORD' TO                            
                    WS-TRANS-DESC-CALC (WS-AU-DET-INDX)                 
               SET WS-AU-DET-INDX UP BY 1                               
               GO TO 6115-PROCESS-TRANS-DET                             
           END-IF                                                       
                                                                        
           INITIALIZE WS-HOLD-PROCESS-FLAG                              
                      WS-HOLD-APPL-PGM-ID                               
                      WS-HOLD-CHG-MSG                                   
                      WS-HOLD-CHG-AMT                                   
                      WS-HOLD-TRANS-TYPE.                               
           EVALUATE WS-GL-DEBIT-NAME                                    
               WHEN 'AR-LPC'                                            
               WHEN 'AR-LPN'                                            
                   IF WS-GL-CREDIT-NAME = 'AR-CIA'                      
                     MOVE 'N'                   TO WS-HOLD-PROCESS-FLAG 
                   ELSE                                                 
                     MOVE 'Y'                   TO WS-LOAD-STMT-CHRG-SW 
                     MOVE 'Y'                   TO WS-HOLD-PROCESS-FLAG 
                     IF CA167-CALL                                      
                        MOVE 'Late Payment Charge   ' TO WS-HOLD-CHG-MSG
                     ELSE                                               
                        MOVE 'Late Payment Charge(s)' TO WS-HOLD-CHG-MSG
                     END-IF                                             
                     MOVE 'C'                   TO WS-HOLD-TRANS-TYPE   
                     MOVE AU-AMT-POSTED         TO WS-HOLD-CHG-AMT      
                     MOVE 1                     TO WS-STMT-CHG-SUB      
                     PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT      
                   END-IF                                               
               WHEN 'AR-PJS'                                            
                   MOVE 'Y'                     TO WS-HOLD-PROCESS-FLAG 
                   IF AR-COMPANY-NO = '01'                              
                     MOVE 'Project Share Donation' TO WS-HOLD-CHG-MSG   
                   ELSE                                                 
                     MOVE 'Heat Care Donation'     TO WS-HOLD-CHG-MSG   
                   END-IF                                               
                   MOVE AU-AMT-POSTED           TO WS-HOLD-CHG-AMT      
                   MOVE 'E'                     TO WS-HOLD-TRANS-TYPE   
                   MOVE 'Y'                     TO WS-LOAD-STMT-CHRG-SW 
                   MOVE 1                       TO WS-STMT-CHG-SUB      
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
      * AR-UTE, AR-UTG check how to handle transfer from previous               
      * Accounts                                                                
               WHEN 'AR-UTE'                                            
                    IF WS-GL-CREDIT-NAME = 'AR-UTE'                     
                      IF AU-CODE-AR-AGE  = 'P'                          
                         IF CA167-CALL                                  
                           MOVE 'N'              TO WS-HOLD-PROCESS-FLAG
                           MOVE 'PAY UTIL W/ CREDIT BALANCE'            
                                                 TO WS-HOLD-CHG-MSG     
                         END-IF                                         
                      ELSE                                              
                         MOVE 'Y'               TO WS-HOLD-PROCESS-FLAG 
                         MOVE 'Transfer from previous account'          
                                                TO WS-HOLD-CHG-MSG      
                         MOVE AU-AMT-POSTED     TO WS-HOLD-CHG-AMT      
                         MOVE 'N'               TO WS-HOLD-TRANS-TYPE   
                         MOVE 'Y'               TO WS-LOAD-STMT-CHRG-SW 
                      END-IF                                            
                      MOVE 1                    TO WS-STMT-CHG-SUB      
                      PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT     
                    ELSE                                                
                      IF CA167-CALL                                     
                       MOVE 'Y'                 TO WS-HOLD-PROCESS-FLAG 
                       IF WS-GL-CREDIT-NAME = 'AR-BUD' AND              
                         (AU-CODE-AR-AGE  = '3' OR '6' OR '9')          
                           MOVE 'BBP BALANCE DUE' TO WS-HOLD-CHG-MSG    
                           MOVE 'O'             TO WS-HOLD-TRANS-TYPE   
                           MOVE AU-AMT-POSTED   TO WS-HOLD-CHG-AMT      
                       ELSE                                             
                           IF WS-GL-CREDIT-NAME =                       
                                  ('CLR-AR-XFR' OR 'CLR-MSTSUB')        
                              AND (WS-ACCT-XFER-TO-AT > ZERO OR         
                                   WS-MST-SUB-ACCT-IND-AT = 'M')        
                               MOVE WS-ACCT-XFER-TO-AT TO               
                                    WS-DISPLAY-ACCOUNT                  
                               MOVE WS-DISPLAY-ACCOUNT TO               
                                    WS-DISPLAY-ACCOUNT-D                
                               INSPECT WS-DISPLAY-ACCOUNT-D             
                                   REPLACING ALL '/' BY '-'             
                               STRING 'Transfer to Acct #'              
                                      WS-DISPLAY-ACCOUNT-D              
                                      DELIMITED BY SIZE                 
                                      INTO WS-HOLD-CHG-MSG              
                               MOVE 'M'         TO WS-HOLD-TRANS-TYPE   
                           ELSE                                         
                               MOVE 'ELECTRIC CHARGES' TO               
                                                   WS-HOLD-CHG-MSG      
                               MOVE 'K'         TO WS-HOLD-TRANS-TYPE   
                           END-IF                                       
                       END-IF                                           
                       MOVE 1                 TO WS-STMT-CHG-SUB        
                       PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT    
                      END-IF                                            
                    END-IF                                              
               WHEN 'AR-UTG'                                            
                    IF WS-GL-CREDIT-NAME = 'AR-UTG'                     
                       IF AU-CODE-AR-AGE = 'P'                          
                         IF CA167-CALL                                  
                           MOVE 'N'             TO WS-HOLD-PROCESS-FLAG 
                           MOVE 'PAY UTIL W/ CREDIT BALANCE' TO         
                                                   WS-HOLD-CHG-MSG      
                         END-IF                                         
                       ELSE                                             
                         MOVE 'Y'               TO WS-HOLD-PROCESS-FLAG 
                         MOVE 'Y'               TO WS-LOAD-STMT-CHRG-SW 
                         MOVE 'Transfer from previous account'          
                                                TO WS-HOLD-CHG-MSG      
                         MOVE AU-AMT-POSTED     TO WS-HOLD-CHG-AMT      
                         MOVE 'N'               TO WS-HOLD-TRANS-TYPE   
                       END-IF                                           
                       MOVE 1                   TO WS-STMT-CHG-SUB      
                       PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT    
                    ELSE                                                
                       IF CA167-CALL                                    
                         MOVE 'Y'               TO WS-HOLD-PROCESS-FLAG 
                         IF WS-GL-CREDIT-NAME =                         
                              ('CLR-AR-XFR' OR 'CLR-MSTSUB')            
                          AND (WS-ACCT-XFER-TO-AT > ZERO OR             
                               WS-MST-SUB-ACCT-IND-AT = 'M')            
                           MOVE WS-ACCT-XFER-TO-AT TO                   
                                WS-DISPLAY-ACCOUNT                      
                           MOVE WS-DISPLAY-ACCOUNT TO                   
                                WS-DISPLAY-ACCOUNT-D                    
                           INSPECT WS-DISPLAY-ACCOUNT-D                 
                               REPLACING ALL '/' BY '-'                 
                           STRING 'Transfer to Acct #'                  
                                  WS-DISPLAY-ACCOUNT-D                  
                                  DELIMITED BY SIZE                     
                                  INTO WS-HOLD-CHG-MSG                  
                           MOVE 'M'             TO WS-HOLD-TRANS-TYPE   
                         ELSE                                           
                           MOVE 'GAS CHARGES'   TO WS-HOLD-CHG-MSG      
                           MOVE 'L'             TO WS-HOLD-TRANS-TYPE   
                         END-IF                                         
                         MOVE 1                 TO WS-STMT-CHG-SUB      
                         PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT  
                       END-IF                                           
                    END-IF                                              
               WHEN 'AR-BUD'                                            
                   IF CA167-CALL                                        
                      MOVE WS-GL-CREDIT-NAME TO WS-CHECK-GL-ACCT        
                      IF AU-CODE-AR-AGE = ' ' AND                       
                         WS-GL-CREDIT-CLASS = '4' OR '5'                
                          MOVE 'N'              TO WS-HOLD-PROCESS-FLAG 
                          MOVE 'BYPASS - BBP REVENUE JOURNAL'           
                                                TO WS-HOLD-CHG-MSG      
                          MOVE 1                 TO WS-STMT-CHG-SUB     
                          PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT 
                      ELSE                                              
                        IF WS-GL-CREDIT-NAME = 'AR-BUD'                 
                            MOVE 'Y'            TO WS-HOLD-PROCESS-FLAG 
                            MOVE 'BBP AMOUNT'   TO WS-HOLD-CHG-MSG      
                            MOVE 'F'            TO WS-HOLD-TRANS-TYPE   
                            MOVE 1              TO WS-STMT-CHG-SUB      
                           PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT
                        END-IF                                          
                      END-IF                                            
                      IF WS-GL-CREDIT-NAME = 'AR-CIA'                   
                        COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1      
                        MOVE AU-AMT-POSTED   TO WS-AMT-EPP-CIA-HOLD     
                      END-IF                                            
                   END-IF                                               
               WHEN 'AR-CCC'                                            
                   MOVE 'Y'                     TO WS-HOLD-PROCESS-FLAG 
                   MOVE 'Reconnect Charge'      TO WS-HOLD-CHG-MSG      
                   MOVE 'D'                     TO WS-HOLD-TRANS-TYPE   
                   MOVE 'Y'                     TO WS-LOAD-STMT-CHRG-SW 
                   MOVE AU-AMT-POSTED           TO WS-HOLD-CHG-AMT      
                   MOVE 1                       TO WS-STMT-CHG-SUB      
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN 'AR-DFA'                                            
                 IF CA167-CALL                                          
                   MOVE 'Y'                     TO WS-HOLD-PROCESS-FLAG 
                   MOVE 'DFA/DPP CHARGE'        TO WS-HOLD-CHG-MSG      
                   MOVE 'G'                     TO WS-HOLD-TRANS-TYPE   
                   MOVE 1                       TO WS-STMT-CHG-SUB      
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
                 END-IF                                                 
               WHEN 'AR-CIA'                                            
      * CHECK HOW TO HANDLE 'CLR-AR-XFR' OR 'CLR-MSTSUB' TRANSFERS              
                   IF WS-CREDIT-AR-SW = 'Y'                             
                      MOVE 'N'                  TO WS-HOLD-PROCESS-FLAG 
                      MOVE 'BYPASS - CIA DEBIT' TO WS-HOLD-CHG-MSG      
                      IF CA167-CALL                                     
                         MOVE 1                 TO WS-STMT-CHG-SUB      
                         PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT  
                      END-IF                                            
                   END-IF                                               
                   IF WS-GL-CREDIT-NAME = 'CLR-CK-ISS'                  
                      MOVE 'N'                  TO WS-HOLD-PROCESS-FLAG 
                      MOVE 'BYPASS - CHECK ISSUED' TO WS-HOLD-CHG-MSG   
                      IF CA167-CALL                                     
                         MOVE 1                 TO WS-STMT-CHG-SUB      
                         PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT  
                      END-IF                                            
                   END-IF                                               
                   IF WS-GL-CREDIT-NAME = 'CLR-AR-XFR' OR 'CLR-MSTSUB'  
                      AND CA167-CALL                                    
I01959                IF WS-COGEN-AR-XFER-IND = 'Y'                     
I01959                   MOVE AR-TRAN-COMMENT-TEXT (54:155)             
I01959                     TO WS-HOLD-CHG-MSG                           
I01959                ELSE                                              
I01959                   MOVE WS-ACCT-XFER-TO-AT   TO WS-DISPLAY-ACCOUNT
I01959                   MOVE WS-DISPLAY-ACCOUNT                        
I01959                     TO WS-DISPLAY-ACCOUNT-D                      
I01959                   INSPECT WS-DISPLAY-ACCOUNT-D                   
I01959                           REPLACING ALL '/' BY '-'               
I01959                   STRING 'Transfer to Acct #'                    
I01959                          WS-DISPLAY-ACCOUNT-D                    
I01959                          DELIMITED BY SIZE                       
I01959                          INTO WS-HOLD-CHG-MSG                    
I01959                END-IF                                            
I01959                MOVE 'Y'                  TO WS-HOLD-PROCESS-FLAG 
I01959                MOVE 'M'                  TO WS-HOLD-TRANS-TYPE   
I01959                MOVE 1                    TO WS-STMT-CHG-SUB      
I01959                PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT     
                   END-IF                                               
                   IF WS-GL-CREDIT-NAME = 'EREV-LPC' OR 'GREV-LPC'      
                      MOVE 'Y'                  TO WS-HOLD-PROCESS-FLAG 
                      MOVE 'Y'                  TO WS-LOAD-STMT-CHRG-SW 
                      MOVE AU-AMT-POSTED        TO WS-HOLD-CHG-AMT      
                      IF CA167-CALL                                     
                        MOVE 'Late Payment Charge   ' TO WS-HOLD-CHG-MSG
                      ELSE                                              
                        MOVE 'Late Payment Charge(s)' TO WS-HOLD-CHG-MSG
                      END-IF                                            
                      MOVE 'C'                  TO WS-HOLD-TRANS-TYPE   
                      MOVE 1                    TO WS-STMT-CHG-SUB      
                      PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT     
                   END-IF                                               
               WHEN 'AR-DEP'                                            
                   MOVE WS-GL-CREDIT-NAME      TO WS-CHECK-GL-ACCT      
                   IF WS-AR-ACCOUNT-LESS-DEP OR AU-CODE-AR-AGE = 'P'    
                      MOVE 'N'                 TO WS-HOLD-PROCESS-FLAG  
                      MOVE 'BYPASS - DEPOSIT AR' TO WS-HOLD-CHG-MSG     
                   ELSE                                                 
                      MOVE 'Y'                 TO WS-HOLD-PROCESS-FLAG  
                      MOVE 'Y'                 TO WS-LOAD-STMT-CHRG-SW  
                      MOVE 'Deposit'           TO WS-HOLD-CHG-MSG       
                      MOVE AU-AMT-POSTED       TO WS-HOLD-CHG-AMT       
                      MOVE 'H'                 TO WS-HOLD-TRANS-TYPE    
                   END-IF                                               
                   MOVE 1                   TO WS-STMT-CHG-SUB          
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN 'AR-CNT'                                            
                   EVALUATE AU-CODE-CONTRACT-TYPE                       
                       WHEN 'A'                                         
                       WHEN 'B'                                         
                           MOVE AU-AMT-POSTED  TO WS-HOLD-CHG-AMT       
                           MOVE 'MARKETING CONTRACT' TO WS-HOLD-CHG-MSG 
                           MOVE 'Y'            TO WS-HOLD-PROCESS-FLAG  
                           MOVE 'A'            TO WS-HOLD-TRANS-TYPE    
                       WHEN 'C'                                         
                           MOVE AU-AMT-POSTED  TO WS-HOLD-CHG-AMT       
                           MOVE 'Service Work' TO WS-HOLD-CHG-MSG       
                           MOVE 'Y'            TO WS-HOLD-PROCESS-FLAG  
                           MOVE 'B'            TO WS-HOLD-TRANS-TYPE    
                       WHEN 'D'                                         
                           MOVE AU-AMT-POSTED  TO WS-HOLD-CHG-AMT       
                           MOVE 'Energy Diversion Charge'               
                                                TO WS-HOLD-CHG-MSG      
                           MOVE 'B'             TO WS-HOLD-TRANS-TYPE   
                           MOVE 'Y'             TO WS-HOLD-PROCESS-FLAG 
                       WHEN 'E'                                         
                           MOVE AU-AMT-POSTED   TO WS-HOLD-CHG-AMT      
                           IF CA167-CALL                                
                              MOVE 'Miscellaneous Charge   '            
                                                TO WS-HOLD-CHG-MSG      
                           ELSE                                         
                              MOVE 'Miscellaneous Charge(s)'            
                                                TO WS-HOLD-CHG-MSG      
                           END-IF                                       
                           MOVE 'B'             TO WS-HOLD-TRANS-TYPE   
                           MOVE 'Y'             TO WS-HOLD-PROCESS-FLAG 
                       WHEN 'F'                                         
                           IF CA167-CALL                                
                              PERFORM 1016-GET-CONTRACT-DESC            
                                 THRU 1016-EXIT                         
                              MOVE WS-HOLD-CONTRACT-MSG                 
                                                TO WS-HOLD-CHG-MSG      
                           ELSE                                         
                              MOVE AU-AMT-POSTED TO WS-HOLD-CHG-AMT     
                              IF CA167-CALL                             
                                 MOVE 'Miscellaneous Charge   '         
                                                TO WS-HOLD-CHG-MSG      
                              ELSE                                      
                                 MOVE 'Miscellaneous Charge(s)'         
                                                TO WS-HOLD-CHG-MSG      
                              END-IF                                    
                           END-IF                                       
                           MOVE 'B'             TO WS-HOLD-TRANS-TYPE   
                           MOVE 'Y'             TO WS-HOLD-PROCESS-FLAG 
                       WHEN 'G'                                         
                           MOVE AU-AMT-POSTED   TO WS-HOLD-CHG-AMT      
                           MOVE 'CONTRIBUTION IN AID' TO WS-HOLD-CHG-MSG
                           MOVE 'A'             TO WS-HOLD-TRANS-TYPE   
                           MOVE 'Y'             TO WS-HOLD-PROCESS-FLAG 
                       WHEN 'H'                                         
                           MOVE AU-AMT-POSTED   TO WS-HOLD-CHG-AMT      
                           MOVE 'GASBOY CONTRACT CHARGE'                
                                                TO WS-HOLD-CHG-MSG      
                           MOVE 'A'             TO WS-HOLD-TRANS-TYPE   
                           MOVE 'Y'             TO WS-HOLD-PROCESS-FLAG 
                       WHEN OTHER                                       
                           MOVE AU-AMT-POSTED   TO WS-HOLD-CHG-AMT      
                           MOVE 'MARKETING CONTRACT' TO WS-HOLD-CHG-MSG 
                           MOVE 'A'             TO WS-HOLD-TRANS-TYPE   
                           MOVE 'Y'             TO WS-HOLD-PROCESS-FLAG 
                   END-EVALUATE                                         
                   IF WS-HOLD-PROCESS-FLAG = 'Y'                        
                      MOVE 1                    TO WS-STMT-CHG-SUB      
                      PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT     
                   END-IF                                               
               WHEN 'AR-NSA'                                            
               WHEN 'AR-NSN'                                            
                   MOVE 'Y'                      TO WS-HOLD-PROCESS-FLAG
                   MOVE 'Return Check'           TO WS-HOLD-CHG-MSG     
                   MOVE AU-AMT-POSTED            TO WS-HOLD-CHG-AMT     
                   MOVE 'J'                      TO WS-HOLD-TRANS-TYPE  
                   MOVE 1                        TO WS-STMT-CHG-SUB     
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN 'AR-NSC'                                            
                   MOVE 'Y'                      TO WS-HOLD-PROCESS-FLAG
                   MOVE 'Return Check Charge'    TO WS-HOLD-CHG-MSG     
                   MOVE AU-AMT-POSTED            TO WS-HOLD-CHG-AMT     
                   MOVE 'I'                      TO WS-HOLD-TRANS-TYPE  
                   MOVE 1                        TO WS-STMT-CHG-SUB     
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN OTHER                                               
                   EVALUATE TRUE                                        
                      WHEN WS-GL-DEBIT-NAME = 'EREV-LPC'                
                      WHEN WS-GL-DEBIT-NAME = 'GREV-LPC'                
                      WHEN WS-GL-DEBIT-NAME = 'PEREV-LPC'               
                      WHEN WS-GL-DEBIT-NAME = 'EXP-HIEFF'               
                       CONTINUE                                         
                      WHEN WS-GL-DEBIT-NAME  = 'LIA-UN-CMP'             
                      WHEN WS-GL-DEBIT-CLASS = '4'                      
                      WHEN WS-GL-DEBIT-CLASS = '5'                      
                         MOVE 'N'                TO WS-HOLD-PROCESS-FLAG
           END-EVALUATE.                                                
           IF WS-HOLD-PROCESS-FLAG = ' '                                
              EVALUATE WS-GL-CREDIT-NAME                                
               WHEN 'AR-UTE'                                            
               WHEN 'AR-UTG'                                            
                   IF WS-GL-DEBIT-NAME = 'CLR-AR-XFR' OR 'CLR-MSTSUB'   
                      AND CA167-CALL                                    
                      MOVE WS-ACCT-XFER-TO-AT TO WS-DISPLAY-ACCOUNT     
                      MOVE WS-DISPLAY-ACCOUNT TO WS-DISPLAY-ACCOUNT-D   
                      INSPECT WS-DISPLAY-ACCOUNT-D                      
                              REPLACING ALL '/' BY '-'                  
                      COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1        
                      MOVE AU-AMT-POSTED        TO WS-HOLD-CHG-AMT      
                      MOVE 'Y'                  TO WS-HOLD-PROCESS-FLAG 
                      STRING 'Transfer to Acct #'                       
                             WS-DISPLAY-ACCOUNT-D                       
                             DELIMITED BY SIZE                          
                             INTO WS-HOLD-CHG-MSG                       
                      MOVE 'M'                  TO WS-HOLD-TRANS-TYPE   
                      MOVE 1                    TO WS-STMT-CHG-SUB      
                      PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT     
                   END-IF                                               
                   IF WS-GL-DEBIT-NAME = 'EXP-HIEFF'                    
                       COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1       
                       MOVE AU-AMT-POSTED       TO WS-HOLD-CHG-AMT      
                       MOVE 'Off Peak Water Heating Credit' TO          
                            WS-HOLD-CHG-MSG                             
                       MOVE 'Y'                 TO WS-HOLD-PROCESS-FLAG 
                       MOVE 'P'                 TO WS-HOLD-TRANS-TYPE   
                       MOVE 1                   TO WS-STMT-CHG-SUB      
                       PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT    
                   END-IF                                               
                   IF WS-GL-DEBIT-NAME = 'AGL-CHARGE'                   
                       MOVE 'N'                 TO WS-HOLD-PROCESS-FLAG 
                       MOVE 'GAS CHARGES'       TO WS-HOLD-CHG-MSG      
                       MOVE 1                   TO WS-STMT-CHG-SUB      
                       PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT    
                   END-IF                                               
               WHEN 'AR-LPC'                                            
               WHEN 'AR-LPN'                                            
                   COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1           
                   MOVE AU-AMT-POSTED         TO WS-HOLD-CHG-AMT        
                   MOVE 'Y'                   TO WS-HOLD-PROCESS-FLAG   
                   MOVE '1'                     TO WS-HOLD-TRANS-TYPE   
                   IF CA167-CALL                                        
                      MOVE 'Late Payment Credit   ' TO WS-HOLD-CHG-MSG  
                   ELSE                                                 
                      MOVE 'Late Payment Credit(s)' TO WS-HOLD-CHG-MSG  
                   END-IF                                               
                   MOVE 1                        TO WS-STMT-CHG-SUB     
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN 'AR-PJS'                                            
                   COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1           
                   MOVE 'Y'                     TO WS-HOLD-PROCESS-FLAG 
                   IF AR-COMPANY-NO = '01'                              
                      MOVE 'Project Share Credit' TO WS-HOLD-CHG-MSG    
                   ELSE                                                 
                      MOVE 'Heat Care Credit'     TO WS-HOLD-CHG-MSG    
                   END-IF                                               
                   MOVE AU-AMT-POSTED           TO WS-HOLD-CHG-AMT      
                   MOVE '2'                     TO WS-HOLD-TRANS-TYPE   
                   MOVE 1                       TO WS-STMT-CHG-SUB      
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN 'AR-BUD'                                            
                   IF CA167-CALL                                        
                      IF WS-GL-DEBIT-NAME = 'AGL-CHARGE'                
                         MOVE 'N'              TO WS-HOLD-PROCESS-FLAG  
                         MOVE 'Bypass - RE-Bill'                        
                                                TO WS-HOLD-CHG-MSG      
                         MOVE 1                 TO WS-STMT-CHG-SUB      
                         PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT  
                      ELSE                                              
                         COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1     
                         MOVE 'Y'            TO WS-HOLD-PROCESS-FLAG    
                         IF WS-GL-DEBIT-NAME = 'EXP-HIEFF'              
                           MOVE 'Off Peak Water Heating Credit'         
                                             TO WS-HOLD-CHG-MSG         
                         ELSE                                           
                           MOVE 'BBP CREDIT' TO WS-HOLD-CHG-MSG         
                         END-IF                                         
                         MOVE AU-AMT-POSTED  TO WS-HOLD-CHG-AMT         
                         MOVE '3'            TO WS-HOLD-TRANS-TYPE      
                         MOVE 1              TO WS-STMT-CHG-SUB         
                         PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT  
                      END-IF                                            
                      IF WS-GL-CREDIT-NAME = 'AR-CIA'                   
                        COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1      
                        MOVE AU-AMT-POSTED      TO WS-AMT-EPP-CIA-HOLD  
                      END-IF                                            
                   END-IF                                               
               WHEN 'AR-CCC'                                            
                   COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1           
                   MOVE 'Y'                     TO WS-HOLD-PROCESS-FLAG 
                   MOVE 'Reconnect Credit'      TO WS-HOLD-CHG-MSG      
                   MOVE '4'                     TO WS-HOLD-TRANS-TYPE   
                   MOVE AU-AMT-POSTED           TO WS-HOLD-CHG-AMT      
                   MOVE 1                       TO WS-STMT-CHG-SUB      
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN 'AR-DFA'                                            
                 IF CA167-CALL                                          
                   COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1           
                   MOVE 'Y'                     TO WS-HOLD-PROCESS-FLAG 
                   IF WS-GL-DEBIT-NAME = 'EXP-HIEFF'                    
                      MOVE 'Off Peak Water Heating Credit'              
                                                TO WS-HOLD-CHG-MSG      
                   ELSE                                                 
                      MOVE 'DFA/DPP Credit'     TO WS-HOLD-CHG-MSG      
                   END-IF                                               
                   MOVE '5'                     TO WS-HOLD-TRANS-TYPE   
                   MOVE AU-AMT-POSTED           TO WS-HOLD-CHG-AMT      
                   MOVE 1                       TO WS-STMT-CHG-SUB      
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
                 END-IF                                                 
               WHEN 'AR-CIA'                                            
                   IF WS-GL-DEBIT-NAME = 'AR-BUD'                       
                      MOVE 'N'                 TO WS-HOLD-PROCESS-FLAG  
                      MOVE 'BYPASS - CIA CREDIT' TO WS-HOLD-CHG-MSG     
                   ELSE                                                 
                      COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1        
                      MOVE AU-AMT-POSTED         TO WS-HOLD-CHG-AMT     
                      MOVE 'Y'                   TO WS-HOLD-PROCESS-FLAG
                      MOVE '6'                   TO WS-HOLD-TRANS-TYPE  
                      IF WS-GL-DEBIT-NAME = 'EXP-HIEFF'                 
                         MOVE 'Off Peak Water Heating Credit' TO        
                              WS-HOLD-CHG-MSG                           
                      ELSE                                              
                         MOVE 'CIA Credit'       TO WS-HOLD-CHG-MSG     
                      END-IF                                            
                      MOVE AU-AMT-POSTED         TO WS-HOLD-CHG-AMT     
                   END-IF                                               
                   MOVE 1                        TO WS-STMT-CHG-SUB     
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN 'AR-DEP'                                            
                   COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1           
                   MOVE AU-AMT-POSTED           TO WS-HOLD-CHG-AMT      
                   MOVE '7'                     TO WS-HOLD-TRANS-TYPE   
                   MOVE 'Y'                     TO WS-HOLD-PROCESS-FLAG 
                   MOVE 'Deposit and/or Interest Applied' TO            
                        WS-HOLD-CHG-MSG                                 
                   MOVE 1                       TO WS-STMT-CHG-SUB      
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN 'AR-CNT'                                            
                   IF AU-CODE-AR-AGE  = '0'                             
                      MOVE 'N'                  TO WS-HOLD-PROCESS-FLAG 
                      MOVE 'BYPASS - CREDIT CONTRACT W/ AGE 0'          
                                              TO WS-HOLD-CHG-MSG        
                   ELSE                                                 
                      COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1        
                      MOVE AU-AMT-POSTED        TO WS-HOLD-CHG-AMT      
                      MOVE 'Y'                  TO WS-HOLD-PROCESS-FLAG 
                      MOVE 'Contract Credit'    TO WS-HOLD-CHG-MSG      
                      MOVE '8'                  TO WS-HOLD-TRANS-TYPE   
                   END-IF                                               
                   MOVE 1                       TO WS-STMT-CHG-SUB      
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN 'AR-NSA'                                            
               WHEN 'AR-NSN'                                            
                   COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1           
                   MOVE AU-AMT-POSTED           TO WS-HOLD-CHG-AMT      
                   MOVE 'Y'                     TO WS-HOLD-PROCESS-FLAG 
                   MOVE 'Return Check Credit'   TO WS-HOLD-CHG-MSG      
                   MOVE '9'                     TO WS-HOLD-TRANS-TYPE   
                   MOVE 1                       TO WS-STMT-CHG-SUB      
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN 'AR-NSC'                                            
                   COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1           
                   MOVE AU-AMT-POSTED           TO WS-HOLD-CHG-AMT      
                   MOVE 'Y'                     TO WS-HOLD-PROCESS-FLAG 
                   MOVE 'Credit Return Check Charge' TO WS-HOLD-CHG-MSG 
                   MOVE '0'                     TO WS-HOLD-TRANS-TYPE   
                   MOVE 1                       TO WS-STMT-CHG-SUB      
                   PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT        
               WHEN OTHER                                               
                   IF WS-GL-CREDIT-NAME      = 'EXP-GSVCCH'             
                      MOVE 'N'                 TO WS-HOLD-PROCESS-FLAG  
                   END-IF                                               
           END-EVALUATE
           END-IF.                                                
           IF CA167-CALL AND WS-HOLD-PROCESS-FLAG > ' '                 
              MOVE WS-HOLD-PROCESS-FLAG TO                              
                   WS-PROCESS-FLAG-CALC(WS-AU-DET-INDX)                 
              SET WS-AU-DET-INDX UP BY 1                                
           END-IF.                                                      
      *                                                                         
       6115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6120-PROCESS-GL-NAME.                                            
      *                                                                         
           PERFORM UNTIL WS-GL-ACCT (WS-GL-SUB1) = 0.0000 OR            
                         WS-GL-SUB1 > 1000 OR WS-GL-MATCH = 'Y'         
             IF WS-GL-ACCT (WS-GL-SUB1) = WS-HOLD-GL-ACCT               
                MOVE WS-GL-NAME (WS-GL-SUB1)      TO WS-HOLD-GL-NAME    
                MOVE WS-GL-ACCT-CLASS(WS-GL-SUB1) TO WS-HOLD-GL-CLASS   
                MOVE 'Y'                          TO WS-GL-MATCH        
             END-IF                                                     
             ADD 1                                TO WS-GL-SUB1         
           END-PERFORM.                                                 
           IF WS-GL-MATCH NOT = 'Y'                                     
               DISPLAY 'ACCOUNT-NO ' AT-ACCOUNT-NO                      
               IF WS-HOLD-GL-ACCT = AU-GL-ACCT-DEBIT                    
                  DISPLAY 'BAD GL ACCT DEBIT' AU-GL-ACCT-DEBIT          
               END-IF                                                   
               IF WS-HOLD-GL-ACCT = AU-GL-ACCT-CREDIT                   
                  DISPLAY 'BAD GL ACCT CREDIT' AU-GL-ACCT-CREDIT        
               END-IF                                                   
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
           END-IF.                                                      
      *                                                                         
       6120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *LOAD OTHER MISC CHARGES                                                  
       6130-LOAD-STMT-CHARGES.                                          
      *                                                                         
           IF CA167-CALL                                                
              MOVE WS-HOLD-CHG-MSG    TO                                
                           WS-TRANS-DESC-CALC(WS-AU-DET-INDX)           
              IF WS-HOLD-CHG-AMT NOT = 0                                
                 MOVE WS-HOLD-CHG-AMT    TO                             
                           WS-AMT-POSTED-AU (WS-AU-DET-INDX)            
              END-IF                                                    
              IF WS-HOLD-APPL-PGM-ID > SPACES                           
                 MOVE WS-HOLD-APPL-PGM-ID TO                            
                           WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)       
              END-IF                                                    
              MOVE WS-HOLD-TRANS-TYPE TO                                
                           WS-TRANS-TYPE-CALC (WS-AU-DET-INDX)          
              MOVE WS-HOLD-PROCESS-FLAG TO                              
                           WS-PROCESS-FLAG-CALC (WS-AU-DET-INDX)        
           ELSE                                                         
              MOVE 'Y'               TO WS-LOAD-STMT-CHRG-SW            
              PERFORM 6135-DETERMINE-CHG-SUB   THRU 6135-EXIT           
              IF WS-LOAD-STMT-CHRG-SW = 'Y'                             
                 MOVE WS-HOLD-CHG-MSG       TO WS-STMT-CHG-MSG          
                                        (WS-STMT-SUB, WS-STMT-CHG-SUB)  
                 MOVE WS-HOLD-CHG-AMT       TO WS-STMT-CHG-AMT          
                                        (WS-STMT-SUB, WS-STMT-CHG-SUB)  
              END-IF                                                    
                                                                        
              INITIALIZE WS-HOLD-CHG-MSG WS-HOLD-CHG-AMT                
           END-IF.                                                      
      *                                                                         
       6130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6135-DETERMINE-CHG-SUB.                                          
      *                                                                         
           PERFORM VARYING WS-STMT-CHG-SUB FROM 1 BY 1                  
             UNTIL WS-STMT-CHG-SUB > 200 OR                             
             WS-STMT-CHG-MSG (WS-STMT-SUB WS-STMT-CHG-SUB) <= SPACES    
             IF WS-STMT-CHG-MSG (WS-STMT-SUB WS-STMT-CHG-SUB) =         
                WS-HOLD-CHG-MSG AND  NOT CA167-CALL AND                 
               (WS-HOLD-CHG-MSG = 'Miscellaneous Charge(s)' OR          
                WS-HOLD-CHG-MSG = 'Late Payment Charge(s)')             
                ADD WS-HOLD-CHG-AMT    TO WS-STMT-CHG-AMT               
                                        (WS-STMT-SUB, WS-STMT-CHG-SUB)  
                MOVE 'N'               TO WS-LOAD-STMT-CHRG-SW          
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
           IF WS-LOAD-STMT-CHRG-SW = 'Y'                                
              PERFORM VARYING WS-STMT-CHG-SUB FROM 1 BY 1               
                UNTIL WS-STMT-CHG-SUB > 200 OR                          
                WS-STMT-CHG-MSG (WS-STMT-SUB WS-STMT-CHG-SUB) <= SPACES 
              END-PERFORM                                               
           END-IF.                                                      
      *                                                                         
           IF WS-STMT-CHG-SUB > 200                                     
              DISPLAY 'MORE THAN 200 MISC/OTHER CHARGES '               
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
           END-IF.                                                      
      *                                                                         
       6135-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *PREV AR TRANS                                                            
       6150-GET-PREV-AR-TRANS.                                          
           MOVE WS-ACCOUNT-NO-AT            TO AR-ACCOUNT-NO.           
           MOVE 'B'                         TO AR-CODE-TRAN-TYPE.       
           IF CA167-CALL                                                
              MOVE 'P'      TO WS-AR-PRINT-CONTROL-IND (WS-AR-TRN-INDX) 
           END-IF                                                       
           PERFORM 6920-OPEN-PREV-AR-BILL    THRU 6920-EXIT.            
           PERFORM 6921-FETCH-PREV-AR-BILL   THRU 6921-EXIT.            
           PERFORM 6922-CLOSE-PREV-AR-BILL   THRU 6922-EXIT.            
      *  THERE IS NO PREVIOUS BILL ON TRANSACTION HISTORY                       
           IF WS-END-OF-AR-RECS                                         
               MOVE 'Y'               TO WS-OLDEST-TRAN-SW              
               MOVE WS-DEFAULT-SEQ-NO TO WS-PREV-HST-SEQ-NO             
               MOVE 0.00              TO WS-PREV-BILL-UNPAID            
           ELSE                                                         
               MOVE 'N'               TO WS-OLDEST-TRAN-SW              
               MOVE AR-DATE-TRANS     TO WS-PREV-DATE-TRANS             
               MOVE AR-AMT-BILLED-UNPAID TO WS-PREV-BILL-UNPAID         
               MOVE AR-TRANS-HIST-SEQ-NO TO WS-PREV-HST-SEQ-NO          
               IF CA167-CALL                                            
                 PERFORM 1100-LOAD-TRANS-HIST THRU 1100-EXIT            
                 SET WS-AR-TRN-INDX UP BY 1                             
               END-IF                                                   
           END-IF.                                                      
       6150-EXIT.                                                       
           EXIT.                                                        
      *OLDEST AR TRANS                                                          
       6175-GET-OLDEST-AR-TRANS.                                        
           MOVE 'N'                         TO WS-END-OF-AR-RECS-SW.    
           MOVE WS-ACCOUNT-NO-SEARCH        TO AR-ACCOUNT-NO.           
           MOVE WS-DATE-BILLED-BI           TO AR-DATE-TRANS.           
           PERFORM 6930-OPEN-OLDEST-AR-TRANS   THRU 6930-EXIT.          
           PERFORM 6931-FETCH-OLDEST-AR-TRANS  THRU 6931-EXIT.          
           PERFORM 6932-CLOSE-OLDEST-AR-TRANS  THRU 6932-EXIT.          
      *****************************************************************         
      ** BYPASS DETAIL PROCESSING OF ROW IF IT IS MARKED RECORD-ONLY            
      ** AND IS NOT A SEB EPP SETUP/DELETE TRANSACTION.                         
      *****************************************************************         
           IF AR-RECORD-ONLY-FL  = 'Y'                                  
           AND AR-APPL-PROGRAM-ID NOT = 'PANEL147D'                     
           AND AR-APPL-PROGRAM-ID NOT = 'PANEL147B'                     
              MOVE AR-AMT-BILLED-UNPAID TO WS-PREV-BILL-UNPAID          
              GO TO 6175-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *** HANDLE THESE AFTER YOU PROCESS THE SINCE BILLING TRANS HISTORY        
           INITIALIZE WS-PROCESS-FURTHER-SW.                            
           IF NOT WS-END-OF-AR-RECS                                     
              MOVE AR-TRANS-HIST-SEQ-NO    TO WS-PREV-HST-SEQ-NO        
              IF AR-AMT-BILLED-UNPAID NOT = WS-PREV-BILL-UNPAID         
                  IF (AR-CODE-TRAN-TYPE = 'P') OR                       
                     (AR-CODE-TRAN-TYPE = 'C' AND                       
                      AR-APPL-PROGRAM-ID = 'PANEL373') OR               
                     (AR-CODE-TRAN-TYPE = 'T' AND                       
                      AR-APPL-PROGRAM-ID = 'PCSSO066')                  
                      PERFORM 6243-OMIT-PREPAYMENTS THRU 6243-EXIT      
                  END-IF                                                
                  IF AR-APPL-PROGRAM-ID = 'PANEL069' AND                
                     AR-CODE-TRAN-TYPE = 'T'                            
                     PERFORM 6265-BACKOUT-AGECODE THRU 6265-EXIT        
                  END-IF                                                
      *           INCLUDED CHECK FOR PANEL259I.                                 
                  IF (AR-APPL-PROGRAM-ID = 'PANEL259' OR 'PANEL259I')   
                  AND AR-CODE-TRAN-TYPE = 'R'                           
                      PERFORM 6270-TRANSFER-REFUND THRU 6270-EXIT       
                  END-IF                                                
                  IF AR-AMT-BILLED-UNPAID < WS-PREV-BILL-UNPAID         
                  AND AR-AMT-ORIG-ENTERED > 0                           
                      COMPUTE AR-AMT-ORIG-ENTERED =                     
                              AR-AMT-ORIG-ENTERED * -1                  
                  END-IF                                                
                  IF AR-AMT-BILLED-UNPAID = WS-PREV-BILL-UNPAID AND     
                     AR-CODE-TRAN-TYPE = 'P'                            
                      COMPUTE AR-AMT-ORIG-ENTERED =                     
                              AR-AMT-ORIG-ENTERED * -1                  
                  END-IF                                                
                  IF WS-XFER-CIA NOT = ZERO                             
                     MOVE WS-XFER-CIA TO AR-AMT-BILLED-UNPAID           
                     COMPUTE AR-AMT-ORIG-ENTERED = WS-XFER-CIA * -1     
                  ELSE                                                  
                     MOVE 0.00 TO AR-AMT-BILLED-UNPAID                  
                  END-IF                                                
                  MOVE AR-AMT-BILLED-UNPAID TO WS-PREV-BILL-UNPAID      
                  IF CA167-CALL                                         
                     PERFORM 1100-LOAD-TRANS-HIST THRU 1100-EXIT        
                     MOVE AR-AMT-BILLED-UNPAID TO WS-PREV-BILL-UNPAID   
                     SET WS-AR-TRN-INDX UP BY 1                         
                  END-IF                                                
                  IF NOT CA167-CALL                                     
                     IF WS-PROCESS-FURTHER-SW NOT = 'N'                 
                        PERFORM 6285-PROCESS-OTHER-AR THRU 6285-EXIT    
                     END-IF                                             
                  END-IF                                                
                 END-IF                                                 
              END-IF.                                                   
                                                                        
       6175-EXIT.                                                       
           EXIT.                                                        
       6200-PROCESS-AR-DETAIL-RECORDS.                                  
           MOVE 'N'                    TO WS-END-ON-CYCLE-SW.           
           PERFORM 6940-OPEN-AR-TRANS-HIST        THRU 6940-EXIT.       
           PERFORM 6210-PROCESS-AR-RECORDS        THRU 6210-EXIT        
             UNTIL WS-END-ON-CYCLE.                                     
           PERFORM 6942-CLOSE-AR-TRANS-HIST       THRU 6942-EXIT.       
       6200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6210-PROCESS-AR-RECORDS.                                         
           PERFORM 6941-FETCH-AR-TRANS-HIST       THRU 6941-EXIT.       
      *                                                                         
           INITIALIZE WS-PROCESS-FURTHER-SW.                            
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN NOT-FOUND                                           
                   MOVE 'Y'            TO WS-END-ON-CYCLE-SW            
               WHEN SUCCESSFUL-CALL                                     
                   INITIALIZE WS-CONTRACT-CREDIT                        
                   IF AR-APPL-PROGRAM-ID = 'MKT009' AND                 
                      AR-CODE-TRAN-TYPE  = 'A'                          
                      GO TO 6210-EXIT                                   
                   END-IF                                               
                   IF OLDEST-TRANSACTION AND                            
                      WS-PREV-HST-SEQ-NO = AR-TRANS-HIST-SEQ-NO         
                      MOVE AR-AMT-BILLED-UNPAID TO WS-PREV-BILL-UNPAID  
                      MOVE 'N'                  TO WS-OLDEST-TRAN-SW    
                      GO TO 6210-EXIT                                   
                   END-IF                                               
                   INITIALIZE WS-BILL-MESSAGE                           
                   IF CA167-CALL AND SEB-DATABASE                       
                      EVALUATE AR-APPL-PROGRAM-ID                       
                          WHEN 'PCSCA099X'                              
                          WHEN 'PCSCA099T'                              
                             MOVE 93157            TO WS-BILL-MESSAGE   
                          WHEN 'PCSCA099Y'                              
                             MOVE 93158            TO WS-BILL-MESSAGE   
                          WHEN 'PCSCA99A1'                              
                             MOVE 93161            TO WS-BILL-MESSAGE   
                          WHEN 'PCSCA99B1'                              
                          WHEN 'PCSCA099Z'                              
                             MOVE 93162            TO WS-BILL-MESSAGE   
                          WHEN 'PCSCA099V'                              
                          WHEN 'PCSCA099U'                              
                             MOVE 93163            TO WS-BILL-MESSAGE   
                          WHEN 'PCSCA99C1'                              
                             MOVE 93164            TO WS-BILL-MESSAGE   
                          WHEN 'PCSCA099W'                              
                             MOVE 93165            TO WS-BILL-MESSAGE   
                          WHEN 'PCSCA99D1'                              
                             MOVE 93166            TO WS-BILL-MESSAGE   
                      END-EVALUATE                                      
                      IF WS-BILL-MESSAGE > 0                            
                         PERFORM 1400-LOAD-BILL-MSG THRU 1400-EXIT      
                      END-IF                                            
                   END-IF                                               
                   IF AR-APPL-PROGRAM-ID = 'BFC REFND' AND CA167-CALL   
                      MOVE 93023                TO WS-BILL-MESSAGE      
                      PERFORM 1400-LOAD-BILL-MSG THRU 1400-EXIT         
                   END-IF                                               
      *When a Payment is coming as a Directed payment then omit all the         
      *Reconnect and display a line item for it.                                
                   IF AR-RECORD-ONLY-FL NOT = 'Y' AND                   
                      AR-CODE-TRAN-TYPE = 'I'                           
                      PERFORM 6241-OMIT-PAYMENTS THRU 6241-EXIT         
                   END-IF                                               
                   IF (AR-RECORD-ONLY-FL = 'Y') OR                      
                      (AR-AMT-BILLED-UNPAID = WS-PREV-BILL-UNPAID AND   
                       AR-CODE-TRAN-TYPE NOT = 'P' AND                  
                      (AR-APPL-PROGRAM-ID NOT = 'PCSCA099D' AND         
                                                'PCSCA099K' AND         
                                                'PCSCA099L' AND         
                                                'PCSCA099P' AND         
                                                'PCSCA099S' AND         
                                                'PCSCA099F' AND         
                                                'PCSCA099M' AND         
                                                'PCSCA099Q' AND         
                                                'PCSCA099E')) OR        
                      (AR-APPL-PROGRAM-ID     = 'PCSCA099W' OR          
                                                'PCSCA099V' OR          
                                                'PCSCA099U' OR          
                                                'PCSCA099Z' OR          
                                                'PCSCA099T' OR          
                                                'PCSCA099X' OR          
                                                'PCSCA099Y' OR          
                                                'PCSCA99A1' OR          
                                                'PCSCA99B1' OR          
                                                'PCSCA99C1' OR          
                                                'PCSCA99D1') OR         
                      (CA167-CALL AND AR-CODE-TRAN-TYPE = 'B' AND       
                       AR-DATE-TRANS = WS-DATE-CAN-BILL)                
                       IF SEB-DATABASE AND CA167-CALL AND               
                          (AR-APPL-PROGRAM-ID = 'PANEL147D' OR          
                           AR-APPL-PROGRAM-ID = 'PANEL147B') AND        
                          (AR-CODE-TRAN-TYPE = 'D' OR 'A')              
                          IF AR-AMT-BILLED-UNPAID < WS-PREV-BILL-UNPAID 
                          AND AR-AMT-ORIG-ENTERED > 0                   
                              COMPUTE AR-AMT-ORIG-ENTERED =             
                                      AR-AMT-ORIG-ENTERED * -1          
                          END-IF                                        
                          PERFORM 1100-LOAD-TRANS-HIST THRU 1100-EXIT   
                          SET WS-AR-TRN-INDX UP BY 1                    
                       END-IF                                           
                       MOVE AR-AMT-BILLED-UNPAID TO WS-PREV-BILL-UNPAID 
                   ELSE                                                 
                    IF SEB-DATABASE AND CA167-CALL                      
                       IF AR-APPL-PROGRAM-ID = 'PCSCA099D'              
                          IF WS-REGULATED-CD-AT = '02'                  
                              MOVE 93069            TO WS-BILL-MESSAGE  
                          ELSE                                          
                              MOVE 91046            TO WS-BILL-MESSAGE  
                          END-IF                                        
                          PERFORM 1400-LOAD-BILL-MSG THRU 1400-EXIT     
                       END-IF                                           
                       IF AR-APPL-PROGRAM-ID = 'PCSCA099E'              
                          IF WS-REGULATED-CD-AT = '02'                  
                              MOVE 93070            TO WS-BILL-MESSAGE  
                          ELSE                                          
                              MOVE 91047            TO WS-BILL-MESSAGE  
                          END-IF                                        
                          PERFORM 1400-LOAD-BILL-MSG THRU 1400-EXIT     
                       END-IF                                           
                       IF AR-APPL-PROGRAM-ID = 'PCSCA099K'              
                          MOVE 93021            TO WS-BILL-MESSAGE      
                          PERFORM 1400-LOAD-BILL-MSG THRU 1400-EXIT     
                       END-IF                                           
                       IF AR-APPL-PROGRAM-ID = 'PCSCA099L'              
                          MOVE 93020            TO WS-BILL-MESSAGE      
                          PERFORM 1400-LOAD-BILL-MSG THRU 1400-EXIT     
                       END-IF                                           
                       IF AR-APPL-PROGRAM-ID = 'PCSCA099P'              
                          MOVE 93054            TO WS-BILL-MESSAGE      
                          PERFORM 1400-LOAD-BILL-MSG THRU 1400-EXIT     
                       END-IF                                           
                       IF AR-APPL-PROGRAM-ID = 'PCSCA099S'              
                          MOVE 93105            TO WS-BILL-MESSAGE      
                          PERFORM 1400-LOAD-BILL-MSG THRU 1400-EXIT     
                       END-IF                                           
                     END-IF                                             
                       IF (AR-CODE-TRAN-TYPE = 'P') OR                  
                          (AR-CODE-TRAN-TYPE = 'C' AND                  
                           AR-APPL-PROGRAM-ID = 'PANEL373') OR          
                          (AR-CODE-TRAN-TYPE = 'T' AND                  
                           AR-APPL-PROGRAM-ID = 'PCSSO066')             
                               PERFORM 6243-OMIT-PREPAYMENTS THRU       
                                       6243-EXIT                        
                       END-IF                                           
                       IF AR-APPL-PROGRAM-ID = 'PANEL181A' OR           
A05058                                         'PANEL181B' OR           
A05058                                         'PANEL181M'              
                           PERFORM 6260-RETURN-CHECK THRU 6260-EXIT     
                       END-IF                                           
                       IF AR-APPL-PROGRAM-ID = 'PANEL069' AND           
                          AR-CODE-TRAN-TYPE = 'T'                       
      *check how can we process transfers                                       
                          PERFORM 6265-BACKOUT-AGECODE THRU 6265-EXIT   
                       END-IF                                           
      *                INCLUDED CHECK FOR PANEL259I.                            
                       IF (AR-APPL-PROGRAM-ID = 'PANEL259' OR           
                                                'PANEL259I')            
                       AND AR-CODE-TRAN-TYPE = 'R'                      
                          PERFORM 6270-TRANSFER-REFUND THRU 6270-EXIT   
                       END-IF                                           
                       IF AR-AMT-BILLED-UNPAID < WS-PREV-BILL-UNPAID    
                           COMPUTE AR-AMT-ORIG-ENTERED =                
                                   AR-AMT-ORIG-ENTERED * -1             
                       END-IF                                           
                       IF AR-AMT-BILLED-UNPAID >= WS-PREV-BILL-UNPAID   
                         AND  AR-CODE-TRAN-TYPE = 'P'                   
                           COMPUTE AR-AMT-ORIG-ENTERED =                
                                   AR-AMT-ORIG-ENTERED * -1             
                       END-IF                                           
                       MOVE AR-AMT-BILLED-UNPAID TO WS-PREV-BILL-UNPAID 
      *Do not process to have "Acct Balance Prepay" for Deposits,               
      *Contracts and Reconnect Charges.                                         
                       MOVE ZERO              TO WS-AMOUNT-PREPAY       
                       IF (AR-CODE-TRAN-TYPE  = 'A' AND                 
                           AR-APPL-PROGRAM-ID = ('PANEL113H'            
                                             OR 'PANEL310S'             
                                             OR 'PANEL373'))            
                          PERFORM 6275-OMIT-PAYMENTS    THRU 6275-EXIT  
                          IF WS-PROCESS-FURTHER-SW = 'Y'                
                             CONTINUE                                   
                          ELSE                                          
                             GO TO 6210-EXIT                            
                          END-IF                                        
                       END-IF                                           
                       IF AR-TRANS-HIST-SEQ-NO = WS-CURR-HST-SEQ-NO OR  
                                                 WS-PREV-HST-SEQ-NO     
                           CONTINUE                                     
                       ELSE                                             
                           IF WS-RETURN-CHECK = 'Y' AND                 
                              WS-RETURN-CHECK-CHARGE = 'Y'              
                              PERFORM 6280-CHECK-AND-CHARGE THRU        
                                      6280-EXIT                         
                        ELSE                                            
                          IF CA167-CALL                                 
                             IF WS-ACCOUNT-TYPE-CODE-AT = 'N'           
                                PERFORM 4050-GET-CNT-AR-CODE-AGE THRU   
                                        4050-EXIT                       
                                IF (WS-NO-SCHED-PYMTS-CT (WS-CNT-SUB)   
                                    = 1 AND AU-CODE-AR-AGE NOT = '0')   
                                   OR ((AR-TRANS-HIST-SEQ-NO NOT =      
                                         WS-CURR-HST-SEQ-NO OR          
                                         WS-PREV-HST-SEQ-NO) AND        
                                       (AR-CODE-TRAN-TYPE = 'P' OR 'I'  
                                    OR 'R' OR 'C' OR 'S' OR 'T' OR 'D'))
                                   OR (AR-APPL-PROGRAM-ID = 'PANEL113H' 
                                   AND AU-GL-ACCT-CREDIT = 142.0600     
                                   AND AU-GL-ACCT-DEBIT = 142.0600)     
                                   PERFORM 1100-LOAD-TRANS-HIST THRU    
                                           1100-EXIT                    
                                   SET WS-AR-TRN-INDX UP BY 1           
                                ELSE                                    
                                   CONTINUE                             
                                END-IF                                  
                                IF WS-CNT-ITEM-ID-CT(WS-CNT-SUB) =      
                                   WS-HOLD-CNT-ITEM-ID-CT               
                                   CONTINUE                             
                                ELSE                                    
                                   MOVE WS-CNT-ITEM-ID-CT(WS-CNT-SUB) TO
                                        WS-HOLD-CNT-ITEM-ID-CT          
                                   ADD 1 TO WS-CNT-SUB                  
                                END-IF                                  
                             ELSE                                       
                               IF CA167-CALL                            
                                  PERFORM 1100-LOAD-TRANS-HIST THRU     
                                          1100-EXIT                     
                                  SET WS-AR-TRN-INDX UP BY 1            
                               END-IF                                   
                          END-IF                                        
                          END-IF                                        
                            IF NOT CA167-CALL                           
                             IF WS-PROCESS-FURTHER-SW NOT = 'N'         
                                PERFORM 6285-PROCESS-OTHER-AR THRU      
                                        6285-EXIT                       
                             END-IF                                     
                           END-IF                                       
                          END-IF                                        
                     END-IF                                             
                   END-IF                                               
           END-EVALUATE.                                                
      *                                                                         
       6210-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       6241-OMIT-PAYMENTS.                                              
           MOVE 0.00 TO WS-RECONNECT WS-GAS-SERVICE-CHARGE              
                        WS-CONTRACT-PRINCIPAL                           
                        WS-CONTRACT-CREDIT                              
                        WS-PNC-SERVICE-CHARGE.                          
           MOVE AR-ACCOUNT-NO           TO AU-ACCOUNT-NO.               
           MOVE AR-TRANS-HIST-SEQ-NO    TO AU-TRANS-HIST-SEQ-NO.        
           PERFORM 6910-OPEN-AR-TRANS-DET   THRU 6910-EXIT.             
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
           PERFORM 6242-BACKOUT-PREPAYMENTS THRU 6242-EXIT UNTIL        
                   WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 6912-CLOSE-AR-TRANS-DET   THRU 6912-EXIT.            
           IF WS-RECONNECT > 0.00                                       
              IF CA167-CALL                                             
                 PERFORM 1100-LOAD-TRANS-HIST THRU 1100-EXIT            
                 MOVE WS-RECONNECT TO                                   
                      WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)           
                 MOVE 'PANEL309D' TO                                    
                      WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)            
                 MOVE 'S' TO WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)      
                 SET WS-AR-TRN-INDX UP BY 1                             
              ELSE                                                      
                 MOVE WS-RECONNECT               TO WS-HOLD-CHG-AMT     
                 MOVE 'Reconnect Charge       '  TO WS-HOLD-CHG-MSG     
                 MOVE 1                          TO WS-STMT-CHG-SUB     
                 PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT          
              END-IF                                                    
           END-IF.                                                      
           IF WS-GAS-SERVICE-CHARGE > 0.00                              
              IF CA167-CALL                                             
                 PERFORM 1100-LOAD-TRANS-HIST THRU 1100-EXIT            
                 MOVE WS-GAS-SERVICE-CHARGE TO                          
                      WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)           
                 MOVE 'SCSCA167I' TO                                    
                      WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)            
                 MOVE 'S' TO WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)      
                 SET WS-AR-TRN-INDX UP BY 1                             
              ELSE                                                      
                 MOVE 'Gas Service Charge     '  TO WS-HOLD-CHG-MSG     
                 MOVE WS-GAS-SERVICE-CHARGE      TO WS-HOLD-CHG-AMT     
                 MOVE 1                          TO WS-STMT-CHG-SUB     
                 PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-PNC-SERVICE-CHARGE > 0.00                              
              IF CA167-CALL                                             
                 PERFORM 1100-LOAD-TRANS-HIST THRU 1100-EXIT            
                 MOVE WS-PNC-SERVICE-CHARGE TO                          
                      WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)           
                 MOVE 'SCSCA167J' TO                                    
                      WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)            
                 MOVE 'S' TO WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)      
                 SET WS-AR-TRN-INDX UP BY 1                             
              ELSE                                                      
                 MOVE 'Service Charge         '  TO WS-HOLD-CHG-MSG     
                 MOVE WS-PNC-SERVICE-CHARGE      TO WS-HOLD-CHG-AMT     
                 MOVE 1                          TO WS-STMT-CHG-SUB     
                 PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CONTRACT-PRINCIPAL > 0.00                              
              IF CA167-CALL                                             
                 PERFORM 1100-LOAD-TRANS-HIST THRU 1100-EXIT            
                 MOVE WS-CONTRACT-PRINCIPAL TO                          
                      WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)           
                 MOVE 'SCSCA167B' TO                                    
                      WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)            
                 MOVE 'A' TO WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)      
                 SET WS-AR-TRN-INDX UP BY 1                             
              ELSE                                                      
                 MOVE 'Contract Principal     '  TO WS-HOLD-CHG-MSG     
                 MOVE WS-CONTRACT-PRINCIPAL      TO WS-HOLD-CHG-AMT     
                 MOVE 1                          TO WS-STMT-CHG-SUB     
                 PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-CONTRACT-CREDIT NOT = 0.00                             
              IF NOT CA167-CALL                                         
                 MOVE 'Contract Credit        '  TO WS-HOLD-CHG-MSG     
                 MOVE WS-CONTRACT-CREDIT         TO WS-HOLD-CHG-AMT     
                 MOVE 1                          TO WS-STMT-CHG-SUB     
                 PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6241-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6242-BACKOUT-PREPAYMENTS.                                        
                                                                        
           PERFORM 6242A-BACKOUT-PREPAY     THRU 6242A-EXIT.            
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
                                                                        
       6242-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6242A-BACKOUT-PREPAY.                                            
                                                                        
           IF AU-CODE-AR-AGE = 'P'                                      
           OR AR-APPL-PROGRAM-ID = 'PANEL310E'                          
               NEXT SENTENCE                                            
           ELSE                                                         
               GO TO 6242A-EXIT                                         
           END-IF.                                                      
      *                                                                         
           MOVE 'N'                    TO WS-PROCESS-FURTHER-SW.        
           MOVE SPACES TO WS-GL-CREDIT-NAME WS-GL-DEBIT-NAME.           
           MOVE SPACES TO WS-GL-CREDIT-CLASS WS-GL-DEBIT-CLASS.         
           MOVE ' '                    TO WS-GL-MATCH.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           MOVE AU-GL-ACCT-DEBIT       TO WS-HOLD-GL-ACCT.              
           PERFORM 6120-PROCESS-GL-NAME     THRU 6120-EXIT.             
           MOVE WS-HOLD-GL-NAME        TO WS-GL-DEBIT-NAME.             
           MOVE WS-HOLD-GL-CLASS       TO WS-GL-DEBIT-CLASS.            
           MOVE ' '                    TO WS-GL-MATCH.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           MOVE AU-GL-ACCT-CREDIT      TO WS-HOLD-GL-ACCT.              
           PERFORM 6120-PROCESS-GL-NAME     THRU 6120-EXIT.             
           MOVE WS-HOLD-GL-NAME        TO WS-GL-CREDIT-NAME.            
           MOVE WS-HOLD-GL-CLASS       TO WS-GL-CREDIT-CLASS.           
      *                                                                         
           IF AR-APPL-PROGRAM-ID = 'PANEL310E' AND                      
              WS-GL-CREDIT-NAME = 'AR-CNT' AND                          
              (AU-CODE-AR-AGE = '0' OR '3' OR '6' OR '9')               
                COMPUTE AU-AMT-POSTED = AU-AMT-POSTED * -1              
                ADD AU-AMT-POSTED        TO WS-CONTRACT-CREDIT          
                GO TO 6242A-EXIT                                        
           END-IF.                                                      
           IF WS-GL-CREDIT-NAME = 'AR-CCC'                              
               ADD AU-AMT-POSTED         TO WS-RECONNECT                
           END-IF.                                                      
                                                                        
           IF WS-GL-CREDIT-NAME = 'AR-CNT' AND                          
              WS-GL-DEBIT-NAME  = 'EXP-GSVCCH'                          
               ADD AU-AMT-POSTED         TO WS-GAS-SERVICE-CHARGE       
           END-IF.                                                      
                                                                        
           IF WS-GL-CREDIT-NAME = 'AR-CNT' AND                          
              WS-GL-DEBIT-NAME  = 'PE-SVCCHRG'                          
               ADD AU-AMT-POSTED         TO WS-PNC-SERVICE-CHARGE       
           END-IF.                                                      
                                                                        
           IF WS-GL-CREDIT-NAME = 'AR-CNT' AND                          
              WS-GL-DEBIT-NAME  = 'PE-WLFUR'                            
               ADD AU-AMT-POSTED         TO WS-CONTRACT-PRINCIPAL       
           END-IF.                                                      
                                                                        
       6242A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       6243-OMIT-PREPAYMENTS.                                           
                                                                        
           MOVE 0.00 TO WS-CONTRACT-PREPAY WS-CONTRACT-PRINCIPAL        
                        WS-RECONNECT                                    
                        WS-CONTRACT-INTEREST WS-XFER-CONTRACT           
                        WS-HOLD-CHG-AMT                                 
                        WS-XFER-DEP WS-XFER-DFA                         
                        WS-XFER-CIA                                     
                        WS-DEPOSIT-PREPAY.                              
           INITIALIZE WS-HOLD-CHG-MSG.                                  
           MOVE AR-ACCOUNT-NO           TO AU-ACCOUNT-NO.               
           MOVE AR-TRANS-HIST-SEQ-NO    TO AU-TRANS-HIST-SEQ-NO.        
           PERFORM 6910-OPEN-AR-TRANS-DET   THRU 6910-EXIT.             
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
           PERFORM 6244-BACKOUT-PREPAYMENTS THRU 6244-EXIT UNTIL        
                   WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 6912-CLOSE-AR-TRANS-DET   THRU 6912-EXIT.            
                                                                        
           IF CA167-CALL                                                
              IF WS-XFER-DFA     > 0.00                                 
                 PERFORM 1100-LOAD-TRANS-HIST        THRU 1100-EXIT     
                 MOVE WS-XFER-DFA           TO                          
                      WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)           
                 MOVE 'SCSCA167G'           TO                          
                      WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)            
                 MOVE 'T'                   TO                          
                      WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)             
                 SET WS-AR-TRN-INDX UP BY 1                             
              END-IF                                                    
           END-IF                                                       
           IF WS-CONTRACT-PREPAY > 0.00                                 
              IF CA167-CALL                                             
                  PERFORM 1100-LOAD-TRANS-HIST        THRU 1100-EXIT    
              END-IF                                                    
               IF WS-CONTRACT-INTEREST > 0.00                           
                   COMPUTE WS-HOLD-CHG-AMT = WS-CONTRACT-PREPAY +       
                           WS-CONTRACT-INTEREST                         
                   MOVE 'Contract Principal and Interest'  TO           
                        WS-HOLD-CHG-MSG                                 
                   IF CA167-CALL                                        
                      MOVE WS-HOLD-CHG-AMT  TO                          
                           WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)      
                      MOVE 'SCSCA167D'           TO                     
                           WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)       
                   END-IF                                               
               ELSE                                                     
                   MOVE WS-CONTRACT-PREPAY       TO WS-HOLD-CHG-AMT     
                   MOVE 'Contract Principal'     TO WS-HOLD-CHG-MSG     
                   IF CA167-CALL                                        
                      MOVE WS-HOLD-CHG-AMT  TO                          
                           WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)      
                      IF WS-SUBORD-FEE-SW = 'Y'                         
                         MOVE 'SCSCA167K' TO                            
                           WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)       
                      ELSE                                              
                          MOVE 'SCSCA167B'           TO                 
                           WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)       
                      END-IF                                            
                   END-IF                                               
               END-IF                                                   
               IF CA167-CALL                                            
                  MOVE 'A'                   TO                         
                      WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)             
                  SET WS-AR-TRN-INDX UP BY 1                            
               END-IF                                                   
           END-IF.                                                      
           IF WS-CONTRACT-PRINCIPAL > 0.00                              
               COMPUTE WS-HOLD-CHG-AMT = WS-CONTRACT-PRINCIPAL * -1     
               MOVE 'Reverse Contract Principal' TO  WS-HOLD-CHG-MSG    
               IF CA167-CALL                                            
                  PERFORM 1100-LOAD-TRANS-HIST        THRU 1100-EXIT    
                  MOVE 'SCSCA167C'           TO                         
                        WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)          
                  MOVE 'A'                   TO                         
                        WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)           
                  MOVE WS-HOLD-CHG-AMT  TO                              
                        WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)         
                  SET WS-AR-TRN-INDX UP BY 1                            
               END-IF                                                   
           END-IF.                                                      
           IF WS-CONTRACT-INTEREST > 0.00                               
               COMPUTE WS-HOLD-CHG-AMT = WS-CONTRACT-INTEREST * -1      
               MOVE 'Contract Payoff Interest Credit' TO WS-HOLD-CHG-MSG
               IF CA167-CALL                                            
                  PERFORM 1100-LOAD-TRANS-HIST        THRU 1100-EXIT    
                  MOVE 'SCSCA167E'           TO                         
                        WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)          
                  MOVE 'A'                   TO                         
                        WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)           
                  MOVE WS-HOLD-CHG-AMT  TO                              
                        WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)         
                  SET WS-AR-TRN-INDX UP BY 1                            
               END-IF                                                   
           END-IF.                                                      
           IF WS-RECONNECT > 0.00                                       
               MOVE WS-RECONNECT                 TO WS-HOLD-CHG-AMT     
               MOVE 'Reconnect Charge '          TO WS-HOLD-CHG-MSG     
               IF CA167-CALL                                            
                  PERFORM 1100-LOAD-TRANS-HIST        THRU 1100-EXIT    
                  MOVE 'PANEL309D'           TO                         
                        WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)          
                  MOVE 'S'                   TO                         
                        WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)           
                  MOVE WS-HOLD-CHG-AMT  TO                              
                        WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)         
                  SET WS-AR-TRN-INDX UP BY 1                            
               END-IF                                                   
           END-IF.                                                      
           IF WS-XFER-CONTRACT > 0.00                                   
               COMPUTE WS-HOLD-CHG-AMT = WS-XFER-CONTRACT * -1          
               MOVE 'Transfer Contract Balance ' TO WS-HOLD-CHG-MSG     
               IF CA167-CALL                                            
                  PERFORM 1100-LOAD-TRANS-HIST        THRU 1100-EXIT    
                  MOVE 'SCSCA167F'           TO                         
                        WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)          
                  MOVE 'T'                   TO                         
                        WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)           
                  MOVE WS-HOLD-CHG-AMT  TO                              
                        WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)         
                  SET WS-AR-TRN-INDX UP BY 1                            
               END-IF                                                   
           END-IF.                                                      
           IF WS-XFER-DEP > 0.00                                        
               MOVE WS-XFER-DEP                  TO WS-HOLD-CHG-AMT     
               MOVE 'Transfer Installment Billing'                      
                                                 TO WS-HOLD-CHG-MSG     
               IF CA167-CALL                                            
                  PERFORM 1100-LOAD-TRANS-HIST        THRU 1100-EXIT    
                  MOVE 'SCSCA167G'           TO                         
                        WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)          
                  MOVE 'T'                   TO                         
                        WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)           
                  MOVE WS-HOLD-CHG-AMT  TO                              
                        WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)         
                  SET WS-AR-TRN-INDX UP BY 1                            
               END-IF                                                   
           END-IF.                                                      
           IF WS-DEPOSIT-PREPAY > 0.00                                  
               MOVE WS-DEPOSIT-PREPAY            TO WS-HOLD-CHG-AMT     
               MOVE 'Deposit Charge '            TO WS-HOLD-CHG-MSG     
               IF CA167-CALL                                            
                  PERFORM 1100-LOAD-TRANS-HIST        THRU 1100-EXIT    
                  MOVE 'SCSCA167H'           TO                         
                        WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)          
                  MOVE WS-HOLD-CHG-AMT  TO                              
                        WS-AMT-ORIG-ENTERED-AR (WS-AR-TRN-INDX)         
                  MOVE 'C'                   TO                         
                        WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX)           
                  SET WS-AR-TRN-INDX UP BY 1                            
               END-IF                                                   
           END-IF.                                                      
           IF WS-HOLD-CHG-MSG > SPACES AND NOT CA167-CALL               
              MOVE 1                     TO WS-STMT-CHG-SUB             
              PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT             
           END-IF.                                                      
       6243-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6244-BACKOUT-PREPAYMENTS.                                        
                                                                        
           PERFORM 6244A-BACKOUT-PREPAY     THRU 6244A-EXIT.            
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
                                                                        
       6244-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6244A-BACKOUT-PREPAY.                                            
                                                                        
           IF AU-CODE-AR-AGE = 'P'                                      
               NEXT SENTENCE                                            
           ELSE                                                         
               GO TO 6244A-EXIT                                         
           END-IF.                                                      
                                                                        
           MOVE 'N'                    TO WS-PROCESS-FURTHER-SW.        
           MOVE SPACES TO WS-GL-CREDIT-NAME WS-GL-DEBIT-NAME.           
           MOVE SPACES TO WS-GL-CREDIT-CLASS WS-GL-DEBIT-CLASS.         
           MOVE ' '                    TO WS-GL-MATCH.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           MOVE AU-GL-ACCT-DEBIT       TO WS-HOLD-GL-ACCT.              
           PERFORM 6120-PROCESS-GL-NAME     THRU 6120-EXIT.             
           MOVE WS-HOLD-GL-NAME        TO WS-GL-DEBIT-NAME.             
           MOVE WS-HOLD-GL-CLASS       TO WS-GL-DEBIT-CLASS.            
           MOVE ' '                    TO WS-GL-MATCH.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           MOVE AU-GL-ACCT-CREDIT      TO WS-HOLD-GL-ACCT.              
           PERFORM 6120-PROCESS-GL-NAME     THRU 6120-EXIT.             
           MOVE WS-HOLD-GL-NAME        TO WS-GL-CREDIT-NAME.            
           MOVE WS-HOLD-GL-CLASS       TO WS-GL-CREDIT-CLASS.           
      *                                                                         
           IF WS-GL-CREDIT-NAME = 'AR-CNT' AND                          
              WS-GL-DEBIT-NAME  = 'CLR-CASH'                            
A04557        IF CA167-CALL                                             
A04557         PERFORM 6244B-CHECK-SUBORDINATION-FEE    THRU 6244B-EXIT 
              END-IF                                                    
                  ADD AU-AMT-POSTED TO WS-CONTRACT-PREPAY
           END-IF.              
           IF WS-GL-CREDIT-NAME = 'AR-CNT' AND                          
              WS-GL-DEBIT-NAME (1:4) = 'DINT'                           
                  ADD AU-AMT-POSTED TO WS-CONTRACT-INTEREST
           END-IF.            
           IF WS-GL-CREDIT-NAME = 'CLR-CASH' AND                        
              WS-GL-DEBIT-NAME  = 'AR-CNT'                              
                  ADD AU-AMT-POSTED TO WS-CONTRACT-PRINCIPAL
           END-IF.           
           IF WS-GL-CREDIT-NAME = 'AR-CCC'                              
               ADD AU-AMT-POSTED TO WS-RECONNECT
           END-IF.                       
           IF WS-GL-CREDIT-NAME = 'AR-DEP' AND                          
              WS-GL-DEBIT-NAME = 'CLR-CASH'                             
                  ADD AU-AMT-POSTED TO WS-DEPOSIT-PREPAY
           END-IF.               
           IF WS-GL-DEBIT-NAME = 'CLR-AR-XFR' OR 'CLR-MSTSUB'           
               EVALUATE WS-GL-CREDIT-NAME                               
                   WHEN 'AR-CNT'                                        
                       ADD AU-AMT-POSTED TO WS-XFER-CONTRACT            
                   WHEN 'AR-DFA'                                        
                      ADD AU-AMT-POSTED TO WS-XFER-DFA                  
                   WHEN 'AR-DEP'                                        
                      ADD AU-AMT-POSTED TO WS-XFER-DEP                  
                   WHEN 'AR-PJS'                                        
                      COMPUTE AR-AMT-ORIG-ENTERED =                     
                              AR-AMT-ORIG-ENTERED - AU-AMT-POSTED       
                   WHEN 'AR-UTE'                                        
                   WHEN 'AR-UTG'                                        
                       IF AR-CODE-TRAN-TYPE = 'T'                       
                          MOVE  'Transfer to Acct #' TO WS-HOLD-CHG-MSG 
                       END-IF                                           
                   WHEN 'AR-CIA'                                        
                        IF ((NOT CA167-CALL AND WS-BILL-NO = 1) OR      
                            (CA167-CALL AND WS-BILL-NO-BI = 1)) AND     
                           AR-TRAN-COMMENT-TEXT(1:14) = 'TRANSFER FROM '
                           MOVE AU-AMT-POSTED TO WS-XFER-CIA            
                        END-IF                                          
               END-EVALUATE                                             
           END-IF.                                                      
           IF WS-GL-CREDIT-NAME = 'CLR-AR-XFR' OR 'CLR-MSTSUB'          
               EVALUATE WS-GL-DEBIT-NAME                                
                   WHEN 'AR-UTE'                                        
                   WHEN 'AR-UTG'                                        
                       IF AR-CODE-TRAN-TYPE = 'T'                       
                          MOVE 'Transfer to Acct #' TO WS-HOLD-CHG-MSG  
                       END-IF                                           
               END-EVALUATE                                             
           END-IF.                                                      
                                                                        
       6244A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
       6244B-CHECK-SUBORDINATION-FEE.                                   
           INITIALIZE WS-SUBORD-FEE-SW.                                 
           MOVE AU-ACCOUNT-NO                 TO CT-ACCOUNT-NO.         
           MOVE AU-ITEM-ID                    TO CT-CNT-ITEM-ID.        
           MOVE 100                           TO CT-PYMT-PRIORITY-LVL.  
           MOVE AR-TRANS-HIST-SEQ-NO          TO CT-LAST-UPDATE-TS.     
           PERFORM 1018-SUBORD-FEE THRU 1018-EXIT.                      
           MOVE K6-CNT-NAME-DESC              TO WS-CNT-NAME-DESC.      
           IF SUBORDINATE-FEE                                           
              MOVE 'Y'                        TO WS-SUBORD-FEE-SW       
           ELSE                                                         
              MOVE 'N'                        TO WS-SUBORD-FEE-SW       
           END-IF.                                                      
       6244B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
       6260-RETURN-CHECK.                                               
                                                                        
           INITIALIZE WS-RETURN-CHECK-FIELDS.                           
           MOVE AR-ACCOUNT-NO           TO AU-ACCOUNT-NO.               
           MOVE AR-TRANS-HIST-SEQ-NO    TO AU-TRANS-HIST-SEQ-NO.        
           PERFORM 6910-OPEN-AR-TRANS-DET   THRU 6910-EXIT.             
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
           PERFORM 6261-RETURN-CHECK-DETAIL THRU 6261-EXIT UNTIL        
                   WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 6912-CLOSE-AR-TRANS-DET  THRU 6912-EXIT.             
                                                                        
       6260-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6261-RETURN-CHECK-DETAIL.                                        
                                                                        
           PERFORM 6261A-RETURN-CHECK       THRU 6261A-EXIT.            
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
      *                                                                         
       6261-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6261A-RETURN-CHECK.                                              
                                                                        
           MOVE SPACES TO WS-GL-CREDIT-NAME WS-GL-DEBIT-NAME.           
           MOVE ' '                    TO WS-GL-MATCH.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           MOVE AU-GL-ACCT-DEBIT       TO WS-HOLD-GL-ACCT.              
           PERFORM 6120-PROCESS-GL-NAME     THRU 6120-EXIT.             
           MOVE WS-HOLD-GL-NAME        TO WS-GL-DEBIT-NAME.             
           MOVE WS-HOLD-GL-CLASS       TO WS-GL-DEBIT-CLASS.            
           MOVE WS-GL-DEBIT-NAME       TO WS-CHECK-GL-ACCT              
           IF WS-RETURN-CHECK-ACCOUNT                                   
               MOVE 'Y'                TO WS-RETURN-CHECK               
               ADD AU-AMT-POSTED       TO WS-CHECK-AMT                  
           END-IF.                                                      
           IF WS-CHECK-CHARGE-ACCOUNT                                   
               MOVE 'Y'                TO WS-RETURN-CHECK-CHARGE        
               ADD AU-AMT-POSTED       TO WS-CHARGE-AMT                 
           END-IF.                                                      
      *                                                                         
       6261A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       6265-BACKOUT-AGECODE.                                            
                                                                        
           MOVE ZEROS             TO WS-HOLD-GL-ACCOUNT-DEBIT.          
           MOVE ZEROS             TO WS-HOLD-GL-ACCOUNT-CREDIT.         
           MOVE AR-ACCOUNT-NO           TO AU-ACCOUNT-NO.               
           MOVE AR-TRANS-HIST-SEQ-NO    TO AU-TRANS-HIST-SEQ-NO.        
           PERFORM 6910-OPEN-AR-TRANS-DET   THRU 6910-EXIT.             
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
           PERFORM 6266-AGECODE-DETAIL      THRU 6266-EXIT UNTIL        
                   WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE ZEROS             TO WS-HOLD-GL-ACCOUNT-DEBIT        
              MOVE ZEROS             TO WS-HOLD-GL-ACCOUNT-CREDIT       
              IF CA167-CALL                                             
                 IF WS-HOLD-AR-AMT-ORIG-ENTERED < 0.00                  
                    COMPUTE WS-HOLD-AR-AMT-ORIG-ENTERED =               
                                 WS-HOLD-AR-AMT-ORIG-ENTERED * -1       
                 END-IF                                                 
                 MOVE WS-HOLD-AR-AMT-ORIG-ENTERED                       
                                               TO AR-AMT-ORIG-ENTERED   
              ELSE                                                      
                 MOVE 'N'                      TO WS-PROCESS-FURTHER-SW 
                 MOVE WS-HOLD-AR-AMT-ORIG-ENTERED TO WS-HOLD-CHG-AMT    
                 MOVE 'Transfer from acct      '  TO WS-HOLD-CHG-MSG    
                 MOVE 1                           TO WS-STMT-CHG-SUB    
                 PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT          
              END-IF                                                    
              INITIALIZE WS-HOLD-AR-AMT-ORIG-ENTERED                    
           END-IF.                                                      
           PERFORM 6912-CLOSE-AR-TRANS-DET  THRU 6912-EXIT.             
                                                                        
       6265-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6266-AGECODE-DETAIL.                                             
                                                                        
           PERFORM 6266A-AGECODE-DET        THRU 6266A-EXIT.            
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
                                                                        
       6266-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6266A-AGECODE-DET.                                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AU-GL-ACCT-DEBIT  TO WS-HOLD-GL-ACCOUNT-DEBIT        
              MOVE AU-GL-ACCT-CREDIT TO WS-HOLD-GL-ACCOUNT-CREDIT       
              IF AU-CODE-AR-AGE = '0' OR '3' OR '6' OR '9' OR           
                 (AU-CODE-AR-AGE = 'P' AND AU-GL-ACCT-DEBIT = 142.0700) 
              OR (AU-CODE-AR-AGE = 'P' AND AU-GL-ACCT-CREDIT = 142.0700)
                IF WS-HOLD-GL-ACCOUNT-DEBIT(1:3) = 142                  
                   ADD AU-AMT-POSTED TO WS-HOLD-AR-AMT-ORIG-ENTERED     
                END-IF                                                  
                IF WS-HOLD-GL-ACCOUNT-CREDIT(1:3) = 142                 
                 SUBTRACT AU-AMT-POSTED FROM WS-HOLD-AR-AMT-ORIG-ENTERED
                END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6266A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       6270-TRANSFER-REFUND.                                            
                                                                        
           MOVE 0.00 TO WS-XFER-REFUND-AMT.                             
           MOVE AR-ACCOUNT-NO           TO AU-ACCOUNT-NO.               
           MOVE AR-TRANS-HIST-SEQ-NO    TO AU-TRANS-HIST-SEQ-NO.        
           PERFORM 6910-OPEN-AR-TRANS-DET   THRU 6910-EXIT.             
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
           PERFORM 6271-REFUND-DETAIL       THRU 6271-EXIT UNTIL        
                   WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 6912-CLOSE-AR-TRANS-DET  THRU 6912-EXIT.             
                                                                        
           IF WS-XFER-REFUND-AMT NOT = ZERO                             
                                                                        
              MOVE WS-XFER-REFUND-AMT    TO WS-HOLD-CHG-AMT             
              MOVE 'Refund Deposit '     TO WS-HOLD-CHG-MSG             
              MOVE 1                     TO WS-STMT-CHG-SUB             
              PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT             
           END-IF.                                                      
       6270-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6271-REFUND-DETAIL.                                              
                                                                        
           PERFORM 6271A-REFUND-DET         THRU 6271A-EXIT.            
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
                                                                        
       6271-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6271A-REFUND-DET.                                                
                                                                        
           MOVE SPACES TO WS-GL-CREDIT-NAME WS-GL-DEBIT-NAME.           
           MOVE SPACES TO WS-GL-CREDIT-CLASS WS-GL-DEBIT-CLASS.         
           MOVE ' '                    TO WS-GL-MATCH.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           MOVE AU-GL-ACCT-DEBIT       TO WS-HOLD-GL-ACCT.              
           PERFORM 6120-PROCESS-GL-NAME     THRU 6120-EXIT.             
           MOVE WS-HOLD-GL-NAME        TO WS-GL-DEBIT-NAME.             
           MOVE WS-HOLD-GL-CLASS       TO WS-GL-DEBIT-CLASS.            
           MOVE ' '                    TO WS-GL-MATCH.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           MOVE AU-GL-ACCT-CREDIT      TO WS-HOLD-GL-ACCT.              
           PERFORM 6120-PROCESS-GL-NAME     THRU 6120-EXIT.             
           MOVE WS-HOLD-GL-NAME        TO WS-GL-CREDIT-NAME.            
           MOVE WS-HOLD-GL-CLASS       TO WS-GL-CREDIT-CLASS.           
      *                                                                         
           IF WS-GL-CREDIT-NAME = 'ACASH' OR 'CLR-CK-ISS' OR            
                                  'CLR-AR-XFR' OR 'CLR-MSTSUB'          
              SUBTRACT AU-AMT-POSTED FROM AR-AMT-ORIG-ENTERED           
           END-IF.                                                      
           IF WS-GL-CREDIT-NAME = 'CLR-AR-XFR' OR 'CLR-MSTSUB'          
              ADD AU-AMT-POSTED      TO WS-XFER-REFUND-AMT              
           END-IF.                                                      
                                                                        
       6271A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       6275-OMIT-PAYMENTS.                                              
                                                                        
           MOVE AR-ACCOUNT-NO           TO AU-ACCOUNT-NO.               
           MOVE AR-TRANS-HIST-SEQ-NO    TO AU-TRANS-HIST-SEQ-NO.        
           PERFORM 6910-OPEN-AR-TRANS-DET   THRU 6910-EXIT.             
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
           PERFORM 6276-BACKOUT-PREPAYMENTS THRU 6276-EXIT UNTIL        
                   WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 6912-CLOSE-AR-TRANS-DET  THRU 6912-EXIT.             
           IF WS-AMOUNT-PREPAY NOT = ZERO AND NOT CA167-CALL            
              MOVE 'N'                        TO WS-PROCESS-FURTHER-SW  
              MOVE 'Account Balance Prepay '  TO WS-HOLD-CHG-MSG        
              MOVE WS-AMOUNT-PREPAY           TO WS-HOLD-CHG-AMT        
              MOVE 1                          TO WS-STMT-CHG-SUB        
              PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT             
           END-IF.                                                      
      *                                                                         
       6275-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6276-BACKOUT-PREPAYMENTS.                                        
                                                                        
           PERFORM 6276A-BACKOUT-PREPAY     THRU 6276A-EXIT.            
           PERFORM 6911-FETCH-AR-TRANS-DET  THRU 6911-EXIT.             
                                                                        
       6276-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6276A-BACKOUT-PREPAY.                                            
                                                                        
           MOVE SPACES TO WS-GL-CREDIT-NAME WS-GL-DEBIT-NAME.           
           MOVE SPACES TO WS-GL-CREDIT-CLASS WS-GL-DEBIT-CLASS.         
           MOVE ' '                    TO WS-GL-MATCH.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           MOVE AU-GL-ACCT-DEBIT       TO WS-HOLD-GL-ACCT.              
           PERFORM 6120-PROCESS-GL-NAME     THRU 6120-EXIT.             
           MOVE WS-HOLD-GL-NAME        TO WS-GL-DEBIT-NAME.             
           MOVE WS-HOLD-GL-CLASS       TO WS-GL-DEBIT-CLASS.            
           MOVE ' '                    TO WS-GL-MATCH.                  
           MOVE 1                      TO WS-GL-SUB1.                   
           MOVE AU-GL-ACCT-CREDIT      TO WS-HOLD-GL-ACCT.              
           PERFORM 6120-PROCESS-GL-NAME     THRU 6120-EXIT.             
           MOVE WS-HOLD-GL-NAME        TO WS-GL-CREDIT-NAME.            
           MOVE WS-HOLD-GL-CLASS       TO WS-GL-CREDIT-CLASS.           
      *                                                                         
                                                                        
           IF (WS-GL-CREDIT-NAME = 'AR-DEP'   AND                       
               WS-GL-DEBIT-NAME  = 'AR-DEP')   OR                       
              (WS-GL-CREDIT-NAME = 'AR-CNT'   AND                       
               WS-GL-DEBIT-NAME  = 'AR-CNT')   OR                       
              (WS-GL-CREDIT-NAME = 'AR-CCC'   AND                       
               WS-GL-DEBIT-NAME  = 'AR-CCC')                            
              IF WS-PROCESS-FURTHER-SW NOT = 'Y'                        
                 MOVE 'N'                TO WS-PROCESS-FURTHER-SW       
              END-IF                                                    
           ELSE                                                         
              MOVE 'Y'                   TO WS-PROCESS-FURTHER-SW       
              ADD AU-AMT-POSTED          TO WS-AMOUNT-PREPAY            
           END-IF.                                                      
                                                                        
       6276A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
       6280-CHECK-AND-CHARGE.                                           
      *************************************************                         
      ** APPL-PROGRAM-ID       APPL-PROGRAM-DESC     **                         
      ** PANEL181A             RETURNED CHECK        **                         
      ** PANEL181B             RETURNED DRAFT        **                         
      ** PANEL181M             RETURNED MONEY ORDER  **                         
      ** PANEL181X             RETURNED CHECK CHG    **                         
      ** PANEL181Z             RETURNED DRAFT CHG    **                         
      ** PANEL181W             RETURNED MO ORDR CHG  **                         
      *************************************************                         
      *                                                                         
A05058     MOVE WS-CHECK-AMT TO WS-HOLD-CHG-AMT.                        
A05058     MOVE AR-APPL-PROGRAM-ID TO K9-APPL-PROGRAM-ID.               
A05058     PERFORM 7000-GET-APPL-PGM-DESC THRU 7000-CPD167-EXIT.        
A05058     MOVE K9-BILL-PRINT-DESC TO WS-HOLD-CHG-MSG.                  
           IF CA167-CALL                                                
              MOVE WS-CHECK-AMT                 TO AR-AMT-ORIG-ENTERED  
              PERFORM 1100-LOAD-TRANS-HIST THRU 1100-EXIT               
              SET WS-AR-TRN-INDX UP BY 1                                
           ELSE                                                         
              MOVE 1                            TO WS-STMT-CHG-SUB      
              PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT             
           END-IF.                                                      
                                                                        
A05058     MOVE WS-CHARGE-AMT TO WS-HOLD-CHG-AMT.                       
A05058     EVALUATE AR-APPL-PROGRAM-ID                                  
              WHEN 'PANEL181A'                                          
                MOVE 'PANEL181X' TO AR-APPL-PROGRAM-ID                  
A05058                              K9-APPL-PROGRAM-ID                  
A05058        WHEN 'PANEL181M'                                          
A05058          MOVE 'PANEL181W' TO AR-APPL-PROGRAM-ID                  
A05058                              K9-APPL-PROGRAM-ID                  
              WHEN OTHER                                                
                MOVE 'PANEL181Z' TO AR-APPL-PROGRAM-ID                  
A05058                              K9-APPL-PROGRAM-ID                  
A05058     END-EVALUATE.                                                
A05058     PERFORM 7000-GET-APPL-PGM-DESC THRU 7000-CPD167-EXIT.        
A05058     MOVE K9-BILL-PRINT-DESC TO WS-HOLD-CHG-MSG.                  
           MOVE 1                               TO WS-STMT-CHG-SUB.     
           IF CA167-CALL                                                
              MOVE WS-CHARGE-AMT TO AR-AMT-ORIG-ENTERED                 
              PERFORM 1100-LOAD-TRANS-HIST THRU 1100-EXIT               
              SET WS-AR-TRN-INDX UP BY 1                                
           ELSE                                                         
              MOVE 1                            TO WS-STMT-CHG-SUB      
              PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT             
           END-IF                                                       
           INITIALIZE WS-RETURN-CHECK-FIELDS.                           
                                                                        
       6280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6285-PROCESS-OTHER-AR.                                           
                                                                        
           IF AR-APPL-PROGRAM-ID = ('PANEL164S' OR 'CAATRN1'  OR        
                                    'PANEL164A' OR 'PANEL378' OR        
                                    'PANEL164D')                        
              CONTINUE                                                  
           ELSE                                                         
               PERFORM 6286-OTHER-AR-CHRGS     THRU 6286-EXIT           
           END-IF.                                                      
                                                                        
       6285-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6286-OTHER-AR-CHRGS.                                             
      *                                                                         
           PERFORM 6287-PROCESS-PL-DETAILS   THRU 6287-EXIT.            
      *                                                                         
           IF WS-PL-MATCH-FOUND = ' '                                   
              PERFORM 6288-PROCESS-K9-DETAILS THRU 6288-EXIT            
           END-IF.                                                      
      *                                                                         
       6286-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6287-PROCESS-PL-DETAILS.                                         
      *                                                                         
           MOVE SPACES                   TO WS-HOLD-BILL-LITERAL.       
           MOVE 1                        TO WS-PL-SUB.                  
           MOVE ' '                      TO WS-PL-MATCH-FOUND.          
           PERFORM UNTIL WS-PL-MATCH-FOUND = 'Y' OR WS-PL-SUB > 20      
             IF AR-APPL-PROGRAM-ID  =                                   
                WS-PL-PROGRAM-ID (WS-PL-SUB) AND                        
                AR-CODE-TRAN-TYPE   =                                   
                WS-PL-TRANS-TYPE (WS-PL-SUB)                            
                  MOVE WS-PL-BILL-LITERAL(WS-PL-SUB) TO WS-HOLD-CHG-MSG 
                  MOVE AR-AMT-ORIG-ENTERED       TO WS-HOLD-CHG-AMT     
                  MOVE 1                         TO WS-STMT-CHG-SUB     
                  PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT         
                  MOVE 'Y'                       TO WS-PL-MATCH-FOUND   
               ELSE                                                     
                   ADD 1 TO WS-PL-SUB                                   
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
       6287-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6288-PROCESS-K9-DETAILS.                                         
      *                                                                         
           INITIALIZE WS-APPL-MATCH.                                    
           PERFORM VARYING WS-APPL-SUB FROM 1 BY 1 UNTIL                
SCA006       WS-APPL-SUB > 1000 OR 
SCA006       WS-APPL-MATCH = 'Y' OR 
             WS-APPL-PROGRAM-ID (WS-APPL-SUB) = SPACES                  
             IF WS-APPL-PROGRAM-ID (WS-APPL-SUB) = AR-APPL-PROGRAM-ID   
                MOVE WS-BILL-PRINT-DESC (WS-APPL-SUB)                   
                                              TO WS-HOLD-BILL-LITERAL   
                MOVE 'Y'                      TO WS-APPL-MATCH          
             END-IF                                                     
           END-PERFORM.                                                 
           IF WS-APPL-MATCH NOT = 'Y'                                   
               DISPLAY 'ACCOUNT-NO ' AR-ACCOUNT-NO                      
               DISPLAY 'MATCH NOT FOUND APPL PGM ID' AR-APPL-PROGRAM-ID 
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
           ELSE                                                         
               IF WS-HOLD-BILL-LITERAL (1:7) = 'Payment'                
               OR WS-HOLD-BILL-LITERAL (1:8) = 'ePayment'               
               OR WS-HOLD-BILL-LITERAL       = 'Payment Thank You'      
               OR WS-HOLD-BILL-LITERAL       = 'ePayment Thank You'     
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE WS-HOLD-BILL-LITERAL   TO WS-HOLD-CHG-MSG        
                  MOVE AR-AMT-ORIG-ENTERED       TO WS-HOLD-CHG-AMT     
                  MOVE 1                         TO WS-STMT-CHG-SUB     
                  PERFORM 6130-LOAD-STMT-CHARGES THRU 6130-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       6288-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
      * EXTRACT AR TRANS HIST FOR BILLED ROW.                                   
      *================================================================*        
      *                                                                         
       6900-OPEN-BILL-AR-TRANS.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN BILL_AR_TRANS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    CPDCA167 - PARA: 6900    **'               
              DISPLAY '**    CSS_AR_TRANS_HIST        **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1                
              MOVE 'OPEN  '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE_TRANS'               TO TABLE-ELEMENT-1        
              MOVE AR-DATE-TRANS              TO HOSTVAR-ELEMENT-1      
              MOVE '6900'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * FETCH AR TRANS HIST FOR BILLED ROW.                                     
      *================================================================*        
      *                                                                         
       6901-FETCH-BILL-AR-TRANS.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH BILL_AR_TRANS                                      
                INTO :AR-ACCOUNT-NO,                                    
                     :AR-AMT-BILLED-UNPAID,                             
                     :AR-AMT-ORIG-ENTERED,                              
                     :AR-APPL-PROGRAM-ID,                               
                     :AR-CODE-TRAN-TYPE,                                
                     :AR-COMPANY-NO,                                    
                     :AR-DATE-ORIG-PYMT :WS-NULL-IND-1,                 
                     :AR-DATE-TRANS :WS-NULL-IND-2,                     
                     :AR-RECORD-ONLY-FL,                                
                     :AR-RESP-AREA-ID,                                  
                     :AR-TRAN-COMMENT,                                  
                     :AR-TRANS-HIST-SEQ-NO,                             
                     :AR-USER-ID                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-AR-ACTIVE-RETURN-CODE.                    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**    CPDCA167 - PARA: 6901    **'               
              DISPLAY '**    CSS_AR_TRANS_HIST        **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1                
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE_TRANS'               TO TABLE-ELEMENT-1        
              MOVE AR-DATE-TRANS              TO HOSTVAR-ELEMENT-1      
              MOVE '6901'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6901-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * CLOSE AR TRANS HIST FOR BILLED ROW.                                     
      *================================================================*        
      *                                                                         
       6902-CLOSE-BILL-AR-TRANS.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE BILL_AR_TRANS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    CPDCA167 - PARA: 6902    **'               
              DISPLAY '**    CSS_AR_TRANS_HIST        **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1                
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE_TRANS'               TO TABLE-ELEMENT-1        
              MOVE AR-DATE-TRANS              TO HOSTVAR-ELEMENT-1      
              MOVE '6902'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6902-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * EXTRACT AR TRANS HIST DET FOR BILLED ROW.                               
      *================================================================*        
      *                                                                         
       6910-OPEN-AR-TRANS-DET.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN AR_TRN_HST_DET                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    CPDCA167 - PARA: 6910    **'               
              DISPLAY '**    CSS_AR_TRANS_HIST_DET    **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRN_HST_DET   '    TO TABLE-1                
              MOVE 'OPEN  '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'TIME_HIST_SEQ_NO'         TO TABLE-ELEMENT-1        
              MOVE AU-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              MOVE '6910'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * FETCH AR TRANS HIST DET FOR BILLED ROW.                                 
      *================================================================*        
      *                                                                         
       6911-FETCH-AR-TRANS-DET.                                         
      *                                                                         
           EXEC SQL                                                     
               FETCH AR_TRN_HST_DET                                     
                INTO :AU-TRAN-APPL-NO,                                  
                     :AU-CODE-AR-AGE,                                   
                     :AU-GL-ACCT-CREDIT,                                
                     :AU-GL-ACCT-DEBIT,                                 
                     :AU-AMT-POSTED,                                    
                     :AU-ITEM-ID,                                       
                     :AU-CODE-CONTRACT-TYPE,                            
                     :AU-CURRENCY-TYPE,                                 
                     :AU-CURRENCY-AMT                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-AR-ACTIVE-RETURN-CODE.                    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**    CPDCA167 - PARA: 6911    **'               
              DISPLAY '**    CSS_AR_TRN_HST_DET       **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRN_HST_DET   '    TO TABLE-1                
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'TIME_HIST_SEQ_NO'         TO TABLE-ELEMENT-1        
              MOVE AU-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              MOVE '6911'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6911-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * CLOSE AR TRANS HIST DET FOR BILLED ROW.                                 
      *================================================================*        
      *                                                                         
       6912-CLOSE-AR-TRANS-DET.                                         
      *                                                                         
           EXEC SQL                                                     
               CLOSE AR_TRN_HST_DET                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    CPDCA167 - PARA: 6912    **'               
              DISPLAY '**    CSS_AR_TRN_HST_DET       **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRN_HST_DET   '    TO TABLE-1                
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'TIME_HIST_SEQ_NO'         TO TABLE-ELEMENT-1        
              MOVE AU-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              MOVE '6912'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6912-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * EXTRACT AR TRANS HIST FOR PREV BILLED ROW.                              
      *================================================================*        
      *                                                                         
       6920-OPEN-PREV-AR-BILL.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN PREV_AR_TRANS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    CPDCA167 - PARA: 6920    **'               
              DISPLAY '**    CSS_AR_TRANS_HIST        **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1                
              MOVE 'OPEN  '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE '6920'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * FETCH AR TRANS HIST FOR PREV BILLED ROW.                                
      *================================================================*        
      *                                                                         
       6921-FETCH-PREV-AR-BILL.                                         
      *                                                                         
           EXEC SQL                                                     
               FETCH PREV_AR_TRANS                                      
               INTO :AR-TRANS-HIST-SEQ-NO,                              
                    :AR-DATE-TRANS :WS-NULL-IND-1,                      
                    :AR-CODE-TRAN-TYPE,                                 
                    :AR-AMT-ORIG-ENTERED,                               
                    :AR-AMT-BILLED-UNPAID,                              
                    :AR-RESP-AREA-ID,                                   
                    :AR-APPL-PROGRAM-ID,                                
                    :AR-PYMT-FACILITY-CD,                               
                    :AR-USER-ID,                                        
                    :AR-COMPANY-NO,                                     
                    :AR-TRAN-COMMENT,                                   
                    :AR-RECORD-ONLY-FL,                                 
                    :AR-DATE-ORIG-PYMT :WS-NULL-IND-2                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'Y'              TO WS-END-OF-AR-RECS-SW        
               WHEN OTHER                                               
                   DISPLAY '**    CPDCA167 - PARA: 6921    **'          
                   DISPLAY '**    CSS_AR_TRANS_HIST        **'          
                   DISPLAY '**    SQL CODE =  ' SQLCODE                 
                   DISPLAY '**    PROCESSING TERMINATED    **'          
                   MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1           
                   MOVE 'FETCH '                   TO ABEND-FUNCTION    
                   MOVE SQLCODE                    TO WS-DB2-RETURN-CODE
                   MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1   
                   MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1 
                   MOVE '6921'                     TO ACTIVE-PARAGRAPH  
                   MOVE 12                         TO RETURN-CODE       
                   PERFORM 9900-SQL-ERROR THRU 9900-EXIT                
           END-EVALUATE.                                                
                                                                        
       6921-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * CLOSE AR TRANS HIST FOR PREV BILLED ROW.                                
      *================================================================*        
      *                                                                         
       6922-CLOSE-PREV-AR-BILL.                                         
      *                                                                         
           EXEC SQL                                                     
               CLOSE PREV_AR_TRANS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    CPDCA167 - PARA: 6922    **'               
              DISPLAY '**    CSS_AR_TRANS_HIST        **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1                
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE '6922'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6922-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * SELECT OLDEST AR TRANS HIST HEADER ROW FROM CSS_AR_TRANS_HIST.          
      *================================================================*        
      *                                                                         
       6930-OPEN-OLDEST-AR-TRANS.                                       
      *                                                                         
           EXEC SQL                                                     
               OPEN OLDEST_AR_TRANS                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    CPDCA167 - PARA: 6930    **'               
              DISPLAY '**    CSS_AR_TRANS_HIST        **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1                
              MOVE 'OPEN  '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE_TRANS'               TO TABLE-ELEMENT-2        
              MOVE AR-DATE-TRANS              TO HOSTVAR-ELEMENT-2      
              MOVE '6930'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6931-FETCH-OLDEST-AR-TRANS.                                      
      *                                                                         
           EXEC SQL                                                     
               FETCH OLDEST_AR_TRANS                                    
               INTO :AR-TRANS-HIST-SEQ-NO,                              
                    :AR-DATE-TRANS :WS-NULL-IND-1,                      
                    :AR-CODE-TRAN-TYPE,                                 
                    :AR-AMT-ORIG-ENTERED,                               
                    :AR-AMT-BILLED-UNPAID,                              
                    :AR-RESP-AREA-ID,                                   
                    :AR-APPL-PROGRAM-ID,                                
                    :AR-PYMT-FACILITY-CD,                               
                    :AR-USER-ID,                                        
                    :AR-COMPANY-NO,                                     
                    :AR-TRAN-COMMENT,                                   
                    :AR-RECORD-ONLY-FL,                                 
                    :AR-DATE-ORIG-PYMT :WS-NULL-IND-2                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'Y' TO WS-END-OF-AR-RECS-SW                     
               WHEN OTHER                                               
                   DISPLAY '**    CPDCA167 - PARA: 6931    **'          
                   DISPLAY '**    CSS_AR_TRANS_HIST        **'          
                   DISPLAY '**    SQL CODE =  ' SQLCODE                 
                   DISPLAY '**    PROCESSING TERMINATED    **'          
                   MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1           
                   MOVE 'FETCH '                   TO ABEND-FUNCTION    
                   MOVE SQLCODE                    TO WS-DB2-RETURN-CODE
                   MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1   
                   MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1 
                   MOVE 'DATE_TRANS'               TO TABLE-ELEMENT-2   
                   MOVE AR-DATE-TRANS              TO HOSTVAR-ELEMENT-2 
                   MOVE '6931'                     TO ACTIVE-PARAGRAPH  
                   MOVE 12                         TO RETURN-CODE       
                   PERFORM 9900-SQL-ERROR THRU 9900-EXIT                
           END-EVALUATE.                                                
                                                                        
       6931-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6932-CLOSE-OLDEST-AR-TRANS.                                      
      *                                                                         
           EXEC SQL                                                     
               CLOSE OLDEST_AR_TRANS                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    CPDCA167 - PARA: 6932    **'               
              DISPLAY '**    CSS_AR_TRANS_HIST        **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1                
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE_TRANS'               TO TABLE-ELEMENT-2        
              MOVE AR-DATE-TRANS              TO HOSTVAR-ELEMENT-2      
              MOVE '6932'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6932-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * SELECT OLDEST AR TRANS HIST HEADER ROW FROM CSS_AR_TRANS_HIST.          
      *================================================================*        
      *                                                                         
       6940-OPEN-AR-TRANS-HIST.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN AR_TRANS_HIST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    CPDCA167 - PARA: 6940     **'              
              DISPLAY '**    CSS_AR_TRANS_HIST        **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1                
              MOVE 'OPEN  '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE_TRANS'               TO TABLE-ELEMENT-2        
              MOVE AR-DATE-TRANS              TO HOSTVAR-ELEMENT-2      
              MOVE '6940'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6940-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6941-FETCH-AR-TRANS-HIST.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH AR_TRANS_HIST                                      
               INTO :AR-TRANS-HIST-SEQ-NO,                              
                    :AR-DATE-TRANS :WS-NULL-IND-1,                      
                    :AR-CODE-TRAN-TYPE,                                 
                    :AR-AMT-ORIG-ENTERED,                               
                    :AR-AMT-BILLED-UNPAID,                              
                    :AR-RESP-AREA-ID,                                   
                    :AR-APPL-PROGRAM-ID,                                
                    :AR-PYMT-FACILITY-CD,                               
                    :AR-USER-ID,                                        
                    :AR-COMPANY-NO,                                     
                    :AR-TRAN-COMMENT,                                   
                    :AR-RECORD-ONLY-FL,                                 
                    :AR-DATE-ORIG-PYMT :WS-NULL-IND-2                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**    CPDCA167 - PARA: 6941    **'               
              DISPLAY '**    CSS_AR_TRANS_HIST        **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1                
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE_TRANS'               TO TABLE-ELEMENT-2        
              MOVE AR-DATE-TRANS              TO HOSTVAR-ELEMENT-2      
              MOVE '6941'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6941-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6942-CLOSE-AR-TRANS-HIST.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE AR_TRANS_HIST                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    CPDCA167 - PARA: 6942    **'               
              DISPLAY '**    CSS_AR_TRANS_HIST        **'               
              DISPLAY '**    SQL CODE =  ' SQLCODE                      
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CSS_AR_TRANS_HIST    '    TO TABLE-1                
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE_TRANS'               TO TABLE-ELEMENT-2        
              MOVE AR-DATE-TRANS              TO HOSTVAR-ELEMENT-2      
              MOVE '6942'                     TO ACTIVE-PARAGRAPH       
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       6942-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05058**************************************************                24700036
A05058** CALL CSS_APPL_PGM_DESC TO GET THE BILL     ****                24710036
A05058** PRINT DESCRIPTION.                         ****                24720036
A05058**************************************************                24730036
A05058 7000-GET-APPL-PGM-DESC.                                          
A05058*                                                                 24750036
A05058     EXEC SQL                                                     
A05058        SELECT BILL_PRINT_DESC                                    
A05058          INTO :K9-BILL-PRINT-DESC                                
A05058          FROM CSS_APPL_PGM_DESC                                  
A05058         WHERE APPL_PROGRAM_ID = :K9-APPL-PROGRAM-ID              
A05058     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05058     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05058     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A05058         DISPLAY 'SCSCA167:7000'                                  
A05058         MOVE 'K9' TO WS-DB2-TABLE-ID                             
A05058         MOVE 'SELECT' TO WS-DB2-FUNCTION                         
A05058         MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
A05058         MOVE '167' TO WS-DB2-MODULE-ID                           
A05058         MOVE '7000' TO WS-DB2-PARAGRAPH                          
A05058         MOVE WS-ACCOUNT-NO-SEARCH TO WS-DB2-KEY-1N               
A05058         MOVE 12 TO RETURN-CODE                                   
A05058         PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.                   
A05058*                                                                 24980036
A05058 7000-CPD167-EXIT.                                                
A05058     EXIT.                                                        
                                                                        
       9900-SQL-ERROR.                                                  
                                                                        
           IF LS-CURR-WQ-ITEM = 50                                      
               DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                
               DISPLAY 'PROCESSING TERMINATED'                          
               MOVE 16 TO RETURN-CODE                                   
           ELSE                                                         
               MOVE 'Y' TO WS-WQ-CREATED-SW                             
               ADD 1 TO LS-CURR-WQ-ITEM                                 
               SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM
           END-IF.                  
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX).          
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1.                
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:).  
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
