      *****************************************************************         
      **                    COPYBOOK CPDCA165                        **         
      *****************************************************************         
      ** PURPOSE:DETERMINE CORR-MAIL UID FOR INPUT CORR TYPE         **         
      ** 1.GENERATE UID IF "PROCESS" JOB PARM IS SET                 **         
      ** 2.USE DB2 SEQ OBJECT APPROACH FOR "NONMKT" CORR TYPE ONLY   **         
      ** 3.USE JOB PARM APPROACH FOR ALL OTHER CORR TYPE             **         
      ** 4.INSERT DATA INTO CSS_CORR_MAIL_STAT IF UID GENERATION IS  **         
      **   SUCCESSFUL                                                **         
      **                                                             **         
      ** INCLUDE CWSCA165 IN THE CALLING PROGRAM                     ** 31300000
      **                                                             **         
      ** BATCH  - SCSCA165:PROGRAM WILL ABEND FOR DB2 EXCEPTIONS     **         
      ** ONLINE - MCSCB165:PROGRAM WILL SEND ERROR RETURN CODE       **         
      *****************************************************************         
      ** INPUT : WS-CA165IN-CORR-TYPE                                **         
      **         WS-CA165IN-ACCOUNT-NO                               **         
      **         WS-CA165IN-PROCESS-DATE                             ** 00100000
      **         WS-CA165IN-DATABASE                                 ** 00110000
      **         WS-CA165IN-COMPANY-NO                               ** 00120000
      **         WS-CA165IN-REG-GROUP-CD                             ** 00130000
      **         WS-CA165IN-TP-MEMO-PROCESS                          ** 00140000
      **         WS-CA165IN-LOCAL-OFFICE                             ** 00150000
      **         WS-CA165IN-OK-TO-PROCESS                            ** 00160000
      **         WS-CA165IN-END-OF-PROG-FL                           ** 00160000
      **         WS-CA165IN-UPDATE-SEQ-FL                            **         
      **         WS-CA165IN-UPDATE-USERID                            **         
      **         WS-CA165IN-APPL-PROGRAM-ID                          **         
      **                                                             **         
      ** OUTPUT: RS-RETURN-CODE                                      ** 00170000
      **         WS-CA165OUT-UNIQ-ID                                 **         
      **         WS-CA165OUT-CUR-STATUS                              **         
      *****************************************************************         
      **                                                             **         
      **              COPYBOOK MODIFICATION  LOG                     **         
      **              --------------------------                     **         
      **    DATE    INITIALS   REASON                                **         
      **  --------  --------   ------                                **         
      **  05/09     SDHAL      COPYBOOK ORIGINALLY WRITTEN.          **         
P00527**  03/12     SV         CUSTOMER BILL STATEMENT               **         
A04296**  09/12/12  GD43988    REWRITE-USE FOR BOTH BATCH & ONLINE   **         
      *****************************************************************         
      *                                                                         
       0100-MAIN-PROCESS.                                               
      *                                                                         
      *** ALWAYS SET FIRST CALL FLAG = Y FOR ONLINE VERSION SO THAT             
      *** RETRY WILL BE PROCESSED CORRECTLY                                     
           IF PROGRAM-NAME = 'MCSCB165'                                 
              MOVE 'Y'                   TO WS-CA165-FIRST-CALL-FL      
           END-IF.                                                      
      *                                                                         
      *** VALIDATE "PROCESS" JOB PARM INPUT                                     
      *                                                                         
           MOVE WS-CA165IN-PROCESS-DATE  TO WS-PARM-PROCESS-DT.         
           MOVE 'SCSCA165'               TO G6-PROGRAM-NAME.            
           MOVE '01'                     TO G6-COMPANY-NO.              
           MOVE 'PARM'                   TO G6-CMND-CODE.               
           IF WS-CA165-FIRST-CALL-FL = 'Y'                              
              PERFORM 1000-CHECK-PROCESS-FLAG  THRU  1000-EXIT          
           END-IF.                                                      
      *                                                                         
      *** GET NEXT AVLB SEQ FROM DB2 SEQ OBJ WHEN CORR TYPE = "NONMKT"          
      *** UPDATE JOB PARM SEQ WHEN UPDATE-SEQ-FL = "Y"                          
      *** UPDATE JOB PARM SEQ & RESET STATUS WHEN END-OF-PROG-FL = 'Y'          
      *                                                                         
           IF WS-CA165IN-OK-TO-PROCESS = 'Y'                            
              EVALUATE TRUE                                             
                  WHEN WS-CA165IN-CORR-TYPE      = 'NONMKT'             
                       PERFORM 2000-BUILD-SEQUENCE  THRU  2000-EXIT     
                  WHEN WS-CA165IN-END-OF-PROG-FL = 'Y'                  
                       PERFORM 0200-GET-JOB-PARM-PROGRAM THRU 0200-EXIT 
                       PERFORM 2200-UPDATE-SEQ           THRU 2200-EXIT 
                       PERFORM 2300-UPDATE-EOP           THRU 2300-EXIT 
                  WHEN WS-CA165IN-UPDATE-SEQ-FL  = 'Y'                  
                       PERFORM 0200-GET-JOB-PARM-PROGRAM THRU 0200-EXIT 
                       PERFORM 2200-UPDATE-SEQ           THRU 2200-EXIT 
                  WHEN OTHER                                            
                       PERFORM 0200-GET-JOB-PARM-PROGRAM THRU 0200-EXIT 
                       PERFORM 2000-BUILD-SEQUENCE       THRU 2000-EXIT 
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *** SET PROGRAM NAME                                                      
      *                                                                         
       0200-GET-JOB-PARM-PROGRAM.                                       
      *                                                                         
           INITIALIZE                       G6-PROGRAM-NAME.            
      *                                                                         
           EVALUATE WS-CA165IN-CORR-TYPE                                
               WHEN 'PART01'                                            
                    MOVE 'SCSC1165'      TO G6-PROGRAM-NAME             
               WHEN 'PART02'                                            
                    MOVE 'SCSC2165'      TO G6-PROGRAM-NAME             
               WHEN 'PART03'                                            
                    MOVE 'SCSC3165'      TO G6-PROGRAM-NAME             
               WHEN 'PART04'                                            
                    MOVE 'SCSC4165'      TO G6-PROGRAM-NAME             
               WHEN 'PART05'                                            
                    MOVE 'SCSC5165'      TO G6-PROGRAM-NAME             
               WHEN 'BLLPRT'                                            
                    MOVE 'SCSC7165'      TO G6-PROGRAM-NAME             
               WHEN OTHER                                               
                    MOVE 'SCSCZ165'      TO G6-PROGRAM-NAME             
                    MOVE -1              TO G6-SEQ-NO                   
           END-EVALUATE.                                                
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET "PROCESS" JOB PARM INPUT                               **          
      ****************************************************************          
      *                                                                         
       1000-CHECK-PROCESS-FLAG.                                         
      *                                                                         
           DISPLAY '*** FIRST CALL TO SCSCA165 ***'.                    
           PERFORM 7300-GET-G6-PARM      THRU  7300-EXIT.               
           MOVE G6-PARM-DATA(9:1)        TO WS-CA165IN-OK-TO-PROCESS.   
           DISPLAY 'JOB PARM PROCESS FL= '  WS-CA165IN-OK-TO-PROCESS.   
           IF WS-CA165IN-OK-TO-PROCESS = 'N'                            
              MOVE 'N'                   TO WS-CA165-FIRST-CALL-FL      
           END-IF.                                                      
      *                                                                         
           IF WS-CA165IN-OK-TO-PROCESS = 'Y'                            
              PERFORM 7100-GET-JULIAN-DAY   THRU  7100-EXIT             
              MOVE WS-CUR-JULIAN-DY      TO WS-CA165OUT-CUR-JULIAN-DAY  
              IF CA165-SEB                                              
                 MOVE '12'               TO WS-PARM-PROCESS-DT(6:2)     
                 MOVE '31'               TO WS-PARM-PROCESS-DT(9:2)     
                 MOVE 0                  TO WS-CUR-JULIAN-DY            
                 PERFORM 7100-GET-JULIAN-DAY  THRU  7100-EXIT           
                 ADD WS-CUR-JULIAN-DY    TO WS-CA165OUT-CUR-JULIAN-DAY  
              END-IF                                                    
              DISPLAY 'JULIAN DAY = '       WS-CA165OUT-CUR-JULIAN-DAY  
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GENERATE UID USING JOB PARM DATA / DB2 SEQ OBJECT          **          
      ****************************************************************          
      *                                                                         
       2000-BUILD-SEQUENCE.                                             
      *                                                                         
           MOVE WS-CA165IN-ACCOUNT-NO       TO MW-ACCOUNT-NO.           
      *                                                                         
           IF WS-CA165IN-CORR-TYPE = 'NONMKT'                           
              PERFORM 2500-GET-SEQ-OBJ-BARCODE-UID   THRU  2500-EXIT    
           ELSE                                                         
              PERFORM 2550-GET-JOB-PARM-BARCODE-UID  THRU  2550-EXIT    
           END-IF.                                                      
           MOVE WS-CA165OUT-UNIQ-ID         TO MW-BARCODE-UNIQUE-ID.    
      *                                                                         
           MOVE WS-CA165IN-PROCESS-DATE     TO MW-CREATE-DT.            
      *                                                                         
           PERFORM 2610-GET-COMM-TYPE-CODE   THRU  2610-EXIT.           
      *                                                                         
           PERFORM 2620-GET-TRACKING-STATUS  THRU  2620-EXIT.           
      *                                                                         
           MOVE SPACES                      TO MW-COMM-IMAGE-FL.        
           IF WS-CA165IN-UPDATE-USERID > ' '                            
              MOVE WS-CA165IN-UPDATE-USERID TO MW-USER-ID               
           ELSE                                                         
              MOVE 'SYSTEM'                 TO MW-USER-ID               
           END-IF.                                                      
           MOVE WS-CA165IN-APPL-PROGRAM-ID  TO MW-APPL-PROGRAM-ID.      
           MOVE WS-CA165IN-CUSTOMER-NO      TO MW-CUSTOMER-NO.          
      *                                                                         
           PERFORM 8000-INSERT-CORR-MAIL    THRU 8000-EXIT.             
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** UPDATE JOB PARM SEQ                                        **          
      ****************************************************************          
      *                                                                         
       2200-UPDATE-SEQ.                                                 
      *                                                                         
           DISPLAY '*** UPDATING CSS_JOB_PARM ***'.                     
           INITIALIZE                          WS-G6-PARM-STR.          
           PERFORM 7300-GET-G6-PARM         THRU 7300-EXIT.             
           MOVE G6-PARM-DATA                TO WS-G6-PARM-STR.          
           MOVE WS-CA165OUT-CUR-SEQ-NO      TO WS-LAST-USED-SEQ-NO.     
           MOVE WS-G6-PARM-STR              TO G6-PARM-DATA.            
           DISPLAY ' LAST SEQ = ' WS-CA165OUT-CUR-SEQ-NO.               
           PERFORM 8200-UPDATE-G6-PARM      THRU 8200-EXIT.             
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** END OF UID PROCESSING: SET JOB PARM STATUS AS INACTIVE     **          
      ****************************************************************          
      *                                                                         
       2300-UPDATE-EOP.                                                 
      *                                                                         
           MOVE 'I'                         TO G6-STATUS.               
           PERFORM 8300-UPDATE-G6-STS       THRU 8300-EXIT.             
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GENERATE UID USING DB2 SEQ OBJECT                          **          
      ****************************************************************          
      *                                                                         
       2500-GET-SEQ-OBJ-BARCODE-UID.                                    
      *                                                                         
           INITIALIZE                          WS-TMP-DB2-OBJ-SEQ-NO.   
           PERFORM 7400-GET-SEQ-OBJ-BARCODE-UID   THRU  7400-EXIT.      
           MOVE WS-TMP-DB2-OBJ-SEQ-NO       TO WS-CA165OUT-CUR-SEQ-NO.  
      *                                                                         
           IF WS-CA165-FIRST-CALL-FL = 'Y'                              
              MOVE 'N'                      TO WS-CA165-FIRST-CALL-FL   
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GENERATE UID USING JOB PARM DATA                           **          
      ****************************************************************          
      *                                                                         
       2550-GET-JOB-PARM-BARCODE-UID.                                   
      *                                                                         
           IF WS-CA165-FIRST-CALL-FL = 'Y'                              
              MOVE 'A'                      TO G6-STATUS                
              PERFORM 8300-UPDATE-G6-STS    THRU 8300-EXIT              
              DISPLAY 'CSS_JOB_PARM STATUS UPDATED'                     
              INITIALIZE                       WS-G6-PARM-STR           
              PERFORM 7300-GET-G6-PARM      THRU 7300-EXIT              
              MOVE G6-PARM-DATA             TO WS-G6-PARM-STR           
              MOVE WS-LAST-USED-SEQ-NO      TO WS-TMP-SEQ-NO            
              MOVE WS-MAX-SEQ-NO            TO WS-TMP-MAX-SEQ-NO        
              MOVE 'N'                      TO WS-CA165-FIRST-CALL-FL   
           END-IF.                                                      
      *                                                                         
           ADD 1                            TO WS-TMP-SEQ-NO.           
           IF WS-TMP-SEQ-NO > WS-TMP-MAX-SEQ-NO                         
              DISPLAY '**************************************'          
              DISPLAY '****** MAX SEQ NO EXCEEDED *****'                
              DISPLAY '****** SEQ NO = ' WS-TMP-SEQ-NO                  
              DISPLAY '**************************************'          
              PERFORM 9500-BAIL-OUT         THRU  9500-EXIT             
           END-IF.                                                      
           MOVE WS-TMP-SEQ-NO               TO WS-CA165OUT-CUR-SEQ-NO.  
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** POPULATE COMM TYPE CODE                                    **          
      ****************************************************************          
      *                                                                         
       2610-GET-COMM-TYPE-CODE.                                         
      *                                                                         
           INITIALIZE                     MW-COMM-TYPE-CODE.            
           IF CA165-SEB                                                 
              IF WS-CA165IN-REG-GROUP-CD > SPACES                       
                 MOVE '4'              TO MW-COMM-TYPE-CODE(1:1)        
              ELSE                                                      
                 IF WS-CA165IN-LOCAL-OFFICE = '301' OR '302' OR '303'   
                    MOVE '5'           TO MW-COMM-TYPE-CODE(1:1)        
                 ELSE                                                   
                    MOVE '3'           TO MW-COMM-TYPE-CODE(1:1)        
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF WS-CA165IN-COMPANY-NO = '01'                           
                 MOVE '1'              TO MW-COMM-TYPE-CODE(1:1)        
              ELSE                                                      
                 MOVE '2'              TO MW-COMM-TYPE-CODE(1:1)        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EVALUATE TRUE                                                
               WHEN WS-CA165IN-APPL-PROGRAM-ID = 'PCSCA293'             
                    MOVE '5'           TO MW-COMM-TYPE-CODE(2:1)        
               WHEN (WS-CA165IN-TP-MEMO-PROCESS     > ' ' AND           
                     WS-CA165IN-TP-MEMO-PROCESS NOT = 'N' )             
                    MOVE '4'           TO MW-COMM-TYPE-CODE(2:1)        
               WHEN WS-CA165IN-CORR-TYPE = 'BLLPRT'                     
                    MOVE '3'           TO MW-COMM-TYPE-CODE(2:1)        
               WHEN WS-CA165IN-CORR-TYPE = 'NONMKT'                     
                    MOVE '2'           TO MW-COMM-TYPE-CODE(2:1)        
               WHEN OTHER                                               
                    MOVE '1'           TO MW-COMM-TYPE-CODE(2:1)        
           END-EVALUATE.                                                
      *                                                                         
       2610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** POPULATE TRACKING STATUS                                   **          
      ****************************************************************          
      *                                                                         
       2620-GET-TRACKING-STATUS.                                        
      *                                                                         
           INITIALIZE                     MW-TRACKING-STATUS-CD.        
           MOVE 'E'                    TO MW-TRACKING-STATUS-CD(1:1).   
           EVALUATE WS-CA165IN-CORR-TYPE                                
               WHEN 'NONMKT'                                            
                    MOVE 'N'           TO MW-TRACKING-STATUS-CD(2:1)    
               WHEN 'BLLPRT'                                            
                    EVALUATE TRUE                                       
                      WHEN WS-CA165IN-APPL-PROGRAM-ID = 'PCSCA293'      
                           MOVE 'Z'    TO MW-TRACKING-STATUS-CD(2:1)    
                      WHEN (WS-CA165IN-TP-MEMO-PROCESS = 'T' OR 'L'     
                                                      OR 'A' OR 'H')    
                        MOVE WS-CA165IN-TP-MEMO-PROCESS                 
                                       TO MW-TRACKING-STATUS-CD(2:1)    
                      WHEN WS-CA165IN-TP-MEMO-PROCESS = 'M'             
                        MOVE 'O'       TO MW-TRACKING-STATUS-CD(2:1)    
                      WHEN OTHER                                        
                        MOVE 'M'       TO MW-TRACKING-STATUS-CD(2:1)    
                    END-EVALUATE                                        
               WHEN OTHER                                               
                    MOVE 'B'           TO MW-TRACKING-STATUS-CD(2:1)    
           END-EVALUATE.                                                
      *                                                                         
           MOVE MW-TRACKING-STATUS-CD  TO WS-CA165OUT-CUR-STATUS.       
      *                                                                         
       2620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET "DAY OF THE YEAR"                                      **          
      ****************************************************************          
      *                                                                         
       7100-GET-JULIAN-DAY.                                             
      *                                                                         
           EXEC SQL                                                     
             SELECT
              DATEPART(DAYOFYEAR, IIF(TRY_CONVERT(DATE, 
                                                    :WS-PARM-PROCESS-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PARM-PROCESS-DT
              ) <> 0) OR (LEN(:WS-PARM-PROCESS-DT
              ) <> 10), CIS.CHAR2DATE(:WS-PARM-PROCESS-DT
              ), CONVERT(DATE, :WS-PARM-PROCESS-DT) ))
            INTO
              :WS-CUR-JULIAN-DY     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CUR-JULIAN-DY = DAYOFYEAR(:WS-PARM-PROCESS-DT)             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SPACES                   TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'WS-PARM-PROCESS-DT'     TO TABLE-ELEMENT-2          
              MOVE WS-CA165IN-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1        
              MOVE WS-PARM-PROCESS-DT       TO HOSTVAR-ELEMENT-2        
              PERFORM 9500-BAIL-OUT         THRU 9500-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET "PARM DATA"                                            **          
      ****************************************************************          
      *                                                                         
       7300-GET-G6-PARM.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT G6.PARM_DATA                                     
                 INTO :G6-PARM-DATA                                     
                FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                      
                WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
                AND G6.COMPANY_NO     = :G6-COMPANY-NO                  
                AND G6.CMND_CODE      = :G6-CMND-CODE                   
                AND G6.STATUS         = 'A'                             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT G6.PARM_DATA                                             
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*         FROM CSS_JOB_PARM G6                                            
MFA-TR*         WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                        
MFA-TR*         AND G6.COMPANY_NO     = :G6-COMPANY-NO                          
MFA-TR*         AND G6.CMND_CODE      = :G6-CMND-CODE                           
MFA-TR*         AND G6.STATUS         = 'A'                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE 'CMND_CODE'              TO TABLE-ELEMENT-3          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-4          
              MOVE G6-PROGRAM-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE G6-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE G6-CMND-CODE             TO HOSTVAR-ELEMENT-3        
              MOVE WS-CA165IN-ACCOUNT-NO    TO HOSTVAR-ELEMENT-4        
              PERFORM 9500-BAIL-OUT         THRU 9500-EXIT              
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET NEXT VALUE FROM DB2 SEQ OBJ SEQ_MW_BARCODE_UNIQUE_ID   **          
      ****************************************************************          
      *                                                                         
       7400-GET-SEQ-OBJ-BARCODE-UID.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT
              NEXT VALUE FOR SEQ_MW_BARCODE_UNIQUE_ID
            INTO
              :WS-TMP-DB2-OBJ-SEQ-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-TMP-DB2-OBJ-SEQ-NO =                                       
MFA-TR*           NEXT VALUE FOR SEQ_MW_BARCODE_UNIQUE_ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SPACES                   TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PROCESS DATE'           TO TABLE-ELEMENT-2          
              MOVE WS-CA165IN-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1        
              MOVE WS-CA165IN-PROCESS-DATE  TO HOSTVAR-ELEMENT-2        
              PERFORM 9500-BAIL-OUT         THRU 9500-EXIT              
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** INSERT DATA                                                **          
      ****************************************************************          
      *                                                                         
       8000-INSERT-CORR-MAIL.                                           
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_CORR_MAIL_STAT (                        
                         CREATE_DT                                      
                        ,ACCOUNT_NO                                     
                        ,BARCODE_UNIQUE_ID                              
                        ,COMM_TYPE_CODE                                 
                        ,TRACKING_STATUS_CD                             
                        ,COMM_IMAGE_FL                                  
                        ,USER_ID                                        
                        ,APPL_PROGRAM_ID                                
                        ,CUSTOMER_NO                                    
                        ,LAST_UPDATE_TS)                                
                 VALUES (IIF(TRY_CONVERT(DATE, :MW-CREATE-DT
              ) IS NULL OR (PATINDEX('%.%', :MW-CREATE-DT
              ) <> 0) OR (LEN(:MW-CREATE-DT) <> 10), CIS.CHAR2DATE(
                                                          :MW-CREATE-DT
              ), CONVERT(DATE, :MW-CREATE-DT) )                                
                        ,:MW-ACCOUNT-NO                                 
                        ,:MW-BARCODE-UNIQUE-ID                          
                        ,:MW-COMM-TYPE-CODE                             
                        ,:MW-TRACKING-STATUS-CD                         
                        ,:MW-COMM-IMAGE-FL                              
                        ,:MW-USER-ID                                    
                        ,:MW-APPL-PROGRAM-ID                            
                        ,:MW-CUSTOMER-NO                                
                        , CIS.CURRENT$TIMESTAMP())                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_CORR_MAIL_STAT (                                
MFA-TR*                  CREATE_DT                                              
MFA-TR*                 ,ACCOUNT_NO                                             
MFA-TR*                 ,BARCODE_UNIQUE_ID                                      
MFA-TR*                 ,COMM_TYPE_CODE                                         
MFA-TR*                 ,TRACKING_STATUS_CD                                     
MFA-TR*                 ,COMM_IMAGE_FL                                          
MFA-TR*                 ,USER_ID                                                
MFA-TR*                 ,APPL_PROGRAM_ID                                        
MFA-TR*                 ,CUSTOMER_NO                                            
MFA-TR*                 ,LAST_UPDATE_TS)                                        
MFA-TR*          VALUES (:MW-CREATE-DT                                          
MFA-TR*                 ,:MW-ACCOUNT-NO                                         
MFA-TR*                 ,:MW-BARCODE-UNIQUE-ID                                  
MFA-TR*                 ,:MW-COMM-TYPE-CODE                                     
MFA-TR*                 ,:MW-TRACKING-STATUS-CD                                 
MFA-TR*                 ,:MW-COMM-IMAGE-FL                                      
MFA-TR*                 ,:MW-USER-ID                                            
MFA-TR*                 ,:MW-APPL-PROGRAM-ID                                    
MFA-TR*                 ,:MW-CUSTOMER-NO                                        
MFA-TR*                 , CURRENT TIMESTAMP)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '**** ERROR INSERT CORR MAIL****'                 
              DISPLAY 'SQLCODE = ' WS-ACTIVE-RETURN-CODE                
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE RS-RETURN-CODE           TO RS-RETURN-CODE-DISP      
              DISPLAY 'SQLCODE = ' RS-RETURN-CODE-DISP                  
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CORR_MAIL_STAT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BRCODE_UNIQUE_ID'       TO TABLE-ELEMENT-2          
              MOVE 'CREATE_DT'              TO TABLE-ELEMENT-3          
              MOVE 'COMM_TYPE_CODE'         TO TABLE-ELEMENT-4          
              MOVE MW-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE MW-BARCODE-UNIQUE-ID     TO HOSTVAR-ELEMENT-2        
              MOVE MW-CREATE-DT             TO HOSTVAR-ELEMENT-3        
              MOVE MW-COMM-TYPE-CODE        TO HOSTVAR-ELEMENT-4        
              PERFORM 9500-BAIL-OUT         THRU 9500-EXIT              
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** UPDATE "PARM DATA"                                         **          
      ****************************************************************          
      *                                                                         
       8200-UPDATE-G6-PARM.                                             
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                 SET PARM_DATA = :G6-PARM-DATA                          
                WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
                AND COMPANY_NO     = :G6-COMPANY-NO                     
                AND CMND_CODE      = :G6-CMND-CODE                      
                AND STATUS         = 'A'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE 'CMND_CODE'              TO TABLE-ELEMENT-3          
              MOVE 'PARM_DATA'              TO TABLE-ELEMENT-4          
              MOVE G6-PROGRAM-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE G6-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE G6-CMND-CODE             TO HOSTVAR-ELEMENT-3        
              MOVE G6-PARM-DATA             TO HOSTVAR-ELEMENT-4        
              PERFORM 9500-BAIL-OUT         THRU 9500-EXIT              
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** UPDATE "STATUS"                                            **          
      ****************************************************************          
      *                                                                         
       8300-UPDATE-G6-STS.                                              
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                 SET STATUS = :G6-STATUS                                
                WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
                AND COMPANY_NO     = :G6-COMPANY-NO                     
                AND CMND_CODE      = :G6-CMND-CODE                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE 'CMND_CODE'              TO TABLE-ELEMENT-3          
              MOVE 'STATUS'                 TO TABLE-ELEMENT-4          
              MOVE G6-PROGRAM-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE G6-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE G6-CMND-CODE             TO HOSTVAR-ELEMENT-3        
              MOVE G6-STATUS                TO HOSTVAR-ELEMENT-4        
              PERFORM 9500-BAIL-OUT         THRU 9500-EXIT              
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
