      *****************************************************************         
      *****************************************************************         
      ** CPDCA122.                                                   **         
      **     COMMON COPYBOOK FOR SCSCA122/MCSCB122.                  **         
      *****************************************************************         
      *---------------------------------------------------------------*         
      *  NOTE:                                                        *         
      *      WHEN MODIFYING THIS MEMBER, SCSCA122/MCSCB122 SHOULD BE  *         
      *      EVALUATED FOR CORRESPONDING MODIFICATIONS.               *         
      *---------------------------------------------------------------*         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  -------   --------     ------                              **         
      **  7/15/14   HA7A338      INITIAL PROGRAM VERSION             **         
PRJ821**  7/24/14   RH15956      UPDATES TO INITIAL PROGRAM VERSION  **         
      *****************************************************************         
       6000-TAX-CALCULATION.                                            
           MOVE ZERO TO RETURN-CODE.                                    
           MOVE '0'  TO WS-ERROR-SW.                                    
           MOVE '0' TO WS-PROCESSING-BOTH-SW.                           
           MOVE 200  TO WS-BC-MAX-ENTRY.                                
           INITIALIZE WORK-VARIABLES                                    
                      WS-SQL-ERROR-TXT-WQ.                              
           SET WS-ADJUSTMNT-INDEX TO 1.                                 
           SET WS-BC-ADJUSTMNT-INDEX TO 1.                              
           SET WS-PK-INDX            TO 1.                              
           SET NO-WNA     TO TRUE.                                      
           SET WS-LO-INDX TO 1                                          
           MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT       
           SET LS-THERE-IS-NO-CRNT-CHG TO TRUE                          
           SET LS-THERE-IS-NO-BILLING-DTL TO TRUE                       
           MOVE WS-CODE-BILL-STATUS-BI                                  
             TO WS-BC-CODE-BILL-STATUS-BI                               
           IF WS-COMPANY-NO-AT = '26' AND                               
              WS-PSNC-RT-REVIEW-START-DATE = SPACES                     
              AND NOT SEB-DATABASE                                      
              MOVE '26'                       TO C8-COMPANY-NO          
              MOVE 'ANNUAL-RT-REVIEW-ST'      TO C8-DELINQ-CD           
              PERFORM 7100-SELECT-DELINQ-VALUE THRU 7100-EXIT           
              MOVE C8-DELINQ-VALUE             TO                       
                 WS-PSNC-RT-REVIEW-START-DT                             
                 MOVE LS-CURR-REVENUE-MONTH(1:4) TO                     
                      WS-PSNC-RT-REVIEW-START-DATE(1:4)                 
                 MOVE '-'        TO WS-PSNC-RT-REVIEW-START-DATE(5:1)   
                 MOVE WS-PSNC-MM TO WS-PSNC-RT-REVIEW-START-DATE(6:2)   
                 MOVE '-'        TO WS-PSNC-RT-REVIEW-START-DATE(8:1)   
                 MOVE WS-PSNC-DD TO WS-PSNC-RT-REVIEW-START-DATE(9:2)   
              MOVE 'ANNUAL-RT-REVIEW-MTH'     TO C8-DELINQ-CD           
              PERFORM 7100-SELECT-DELINQ-VALUE THRU 7100-EXIT           
              MOVE C8-DELINQ-VALUE             TO                       
                  WS-PSNC-RT-REVIEW-START-DT                            
                  MOVE WS-PSNC-RT-REVIEW-START-DT(1:6) TO               
                       WS-PSNC-RT-REVIEW-EFF-MTHS                       
           END-IF.                                                      
      **-- PSNC STATE TAX START DATE                                            
           IF CSR-DATABASE                    AND                       
              WS-COMPANY-NO-AT         = '26' AND                       
              WS-PSNC-SALES-TAX-START  = SPACES                         
                MOVE '26'                                               
                  TO C8-COMPANY-NO                                      
                MOVE WS-PSNC-SALES-TAX-START-LIT                        
                  TO C8-DELINQ-CD                                       
                PERFORM 7100-SELECT-DELINQ-VALUE                        
                   THRU 7100-EXIT                                       
                MULTIPLY C8-DELINQ-VALUE BY 10000                       
                  GIVING WS-PSNC-SALES-TAX-START-WORK                   
                MOVE WS-PSNC-SALES-TAX-START-WORK(1:4)                  
                  TO WS-PSNC-SALES-TAX-START(1:4)                       
                MOVE '-'                                                
                  TO WS-PSNC-SALES-TAX-START(5:1)                       
                MOVE WS-PSNC-SALES-TAX-START-WORK(5:2)                  
                  TO WS-PSNC-SALES-TAX-START(6:2)                       
                MOVE '-'                                                
                  TO WS-PSNC-SALES-TAX-START(8:1)                       
                MOVE WS-PSNC-SALES-TAX-START-WORK(7:2)                  
                  TO WS-PSNC-SALES-TAX-START(9:2)                       
           END-IF.                                                      
                                                                        
      ***  LOAD EXEMPT RATES FOR STATE TAX ---------                            
           IF CSR-DATABASE                    AND                       
              WS-COMPANY-NO-AT         = '26' AND                       
              WS-EXMT-RATES-COUNT      = 0                              
               INITIALIZE WS-EXMT-RATES-DATA                            
               MOVE 'EXMTRATES'                  TO G6-PROGRAM-NAME     
               MOVE 'PARM'                       TO G6-CMND-CODE        
               MOVE 'A'                          TO G6-STATUS           
               PERFORM 7712-OPEN-EXMT-RATES-LIST  THRU 7712-EXIT        
               PERFORM 7713-FETCH-EXMT-RATES-LIST THRU 7713-EXIT        
               PERFORM VARYING WS-EXMT-RATES-INDX FROM 1 BY 1           
                 UNTIL SQLCODE = NOT-FOUND                              
                    OR WS-EXMT-RATES-INDX > 25                          
                 ADD +1     TO WS-EXMT-RATES-COUNT                      
                 IF WS-EXMT-RATES-COUNT > +25                           
                    MOVE 'EXEMPT RATES TABLE OVERFLOW'                  
                      TO WS-MISC-MSG-TEXT                               
                    MOVE 27                                             
                      TO WS-MISC-MSG-LEN                                
                    MOVE 16  TO WS-ACTIVE-RETURN-CODE                   
                    MOVE 137 TO WS-MISC-WQ-CAT-ID                       
                    PERFORM 9910-MISC-ERROR THRU 9910-EXIT              
                 ELSE                                                   
                     MOVE G6-PARM-DATA (11:3)                           
                       TO WS-RATE-PLAN-NO-EXMT (WS-EXMT-RATES-INDX)     
                     PERFORM 7713-FETCH-EXMT-RATES-LIST                 
                        THRU 7713-EXIT                                  
                 END-IF                                                 
               END-PERFORM                                              
               PERFORM 7714-CLOSE-EXMT-RATES-LIST THRU 7714-EXIT        
           END-IF.                                                      
                                                                        
           MOVE ZERO TO LS-BILL-BACK-OUT-UTL-DOLLARS                    
                        LS-TOTAL-UTILITY-DOLLARS                        
                        LS-BILL-BACK-OUT-GAS-DOLLARS                    
                        LS-TOTAL-GAS-DOLLARS                            
           PERFORM 0010-PROCESS-REGULAR THRU 0010-EXIT.                 
      *                                                                         
       6000-CPD122-EXIT.                                                
           EXIT.                                                        
      /                                                                         
       0010-PROCESS-REGULAR.                                            
                                                                        
      *    INITIALIZE WS-BILL-CONTRACT-BK                                       
      *               WS-CNSMPTN-HOURLY.                                        
      *    PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1                          
      *            UNTIL WS-BILLING-INDX > 30                                   
      *               OR WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = ZERO              
           IF WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'U'              
              MOVE SPACES TO WS-UM-SERVICE-TYPE                         
              SET WS-CUST-PLAN-INDX TO 1                                
              SEARCH WS-CUST-PLAN-DATA                                  
                WHEN WS-ACCOUNT-NO-CP (WS-CUST-PLAN-INDX) = ZEROES      
                   PERFORM 7140-FIND-SERVICE-TYPE THRU 7140-EXIT        
                WHEN WS-ACCOUNT-NO-CP (WS-CUST-PLAN-INDX)               
                       = WS-ACCOUNT-NO-BG (WS-BILLING-INDX)             
                      AND WS-CODE-UTIL-TYPE-CP (WS-CUST-PLAN-INDX)      
                       = WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)         
                      AND WS-IC-NO-CP (WS-CUST-PLAN-INDX)               
                       = WS-IC-NO-BG (WS-BILLING-INDX)                  
                     MOVE WS-CODE-SERVICE-TYPE-CP (WS-CUST-PLAN-INDX)   
                       TO WS-UM-SERVICE-TYPE                            
              END-SEARCH                                                
           END-IF.                                                      
                                                                        
           IF WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX)                 
                 = WS-CLERK-CANCEL OR WS-CALC-CANCEL                    
              MOVE WS-NO-BILL TO WS-CODE-BILL-STATUS-BI                 
           ELSE                                                         
      * CHECK IF THE IC HAS A MANUAL BILL ASSOCIATED                            
              PERFORM 0020-CHECK-MANUAL-BILL-DETAILS THRU 0020-EXIT     
      * DO NOT CALL BILL CALC FOR PRE-CALC BILLS                                
              IF WS-CODE-BILL-CALC-BG (WS-BILLING-INDX)                 
                    = WS-PRE-CALC OR WS-TAX-ONLY OR                     
                ( SEB-DATABASE                                          
                  AND WS-FIRST-ESTD-BILL-PK(WS-PK-INDX)  )              
                 IF CPD107B-HAS-BILL-MAN                                
                    PERFORM 0021-GET-MANUAL-BILL-DETAILS                
                                                   THRU 0021-EXIT       
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF CPD107B-HAS-BILL-MAN                                   
      * SINCE MANUAL BILLS WILL NOT GO THROUGH TAX CALCULATIONS UPDATE          
      * THE TAX AMOUNTS AND PERCENTAGES FROM MANUAL BILL DETAIL TABLE           
                 MOVE WS-BC-AMT-STATE-TAX-BG                            
                   TO WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)             
                 MOVE WS-BC-AMT-CITY-TAX-BG                             
                   TO WS-AMT-CITY-TAX-BG  (WS-BILLING-INDX)             
                 MOVE WS-BC-AMT-OTHER-TAX-BG                            
                   TO WS-AMT-OTHER-TAX-BG (WS-BILLING-INDX)             
                 IF WS-BC-AMT-BILL-ITEM-BG > 0 AND                      
                    ((WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) > 0 AND     
                      WS-STATE-TX-RATE-CALC (WS-BILLING-INDX) = 0) OR   
                     (WS-AMT-CITY-TAX-BG (WS-BILLING-INDX) > 0  AND     
                      WS-FRANCHISE-TX-RATE-CALC                         
                                         (WS-BILLING-INDX) = 0))        
                    MOVE WS-BC-ACCOUNT-NO-BG     TO NU-ACCOUNT-NO       
                    MOVE WS-BC-BILL-NO-BG        TO NU-BILL-NO          
                    MOVE WS-BC-CODE-UTIL-TYPE-BG TO NU-CODE-UTIL-TYPE   
                    MOVE WS-BC-IC-NO-BG          TO NU-IC-NO            
                    MOVE WS-BC-BILL-ITEM-TIMESTMP-BG                    
                      TO NU-BILL-ITEM-TIMESTMP                          
                    MOVE WS-BG                                          
                      TO NU-BILL-MANUAL-TBL-ID                          
                    PERFORM 7690-GET-MANUAL-BILL-TAX-RATES              
                       THRU 7690-EXIT                                   
                    IF SQLCODE = SUCCESSFUL-CALL                        
                       INITIALIZE WS-N-BILLING-BG                       
                       MOVE NU-BILL-MANUAL-DATA-TEXT                    
                         TO WS-N-BILLING-BG                             
                       MOVE WS-N-STATE-TX-RATE-CALC                     
                         TO WS-STATE-TX-RATE-CALC (WS-BILLING-INDX)     
                       MOVE WS-N-FRANCHISE-TX-RATE-CALC                 
                         TO WS-FRANCHISE-TX-RATE-CALC                   
                                                  (WS-BILLING-INDX)     
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-CODE-BILL-CALC-BG (WS-BILLING-INDX)                 
                       = WS-PRE-CALC OR WS-TAX-ONLY                     
                 MOVE WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX)         
                   TO WS-BC-CODE-BILL-ITM-IND-BG                        
                 MOVE WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)             
                   TO WS-BC-AMT-BILL-ITEM-BG                            
                 MOVE WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)             
                   TO WS-BC-AMT-STATE-TAX-BG                            
                 MOVE WS-AMT-CITY-TAX-BG (WS-BILLING-INDX)              
                   TO WS-BC-AMT-CITY-TAX-BG                             
                 MOVE WS-AMT-OTHER-TAX-BG (WS-BILLING-INDX)             
                   TO WS-BC-AMT-OTHER-TAX-BG                            
                 MOVE WS-CODE-DR-CR-CNSMPTN-BG (WS-BILLING-INDX)        
                   TO WS-BC-CODE-DR-CR-CNSMPTN-BG                       
                 IF (WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) > 0 )        
                    AND (WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX) > 0 )    
                    AND WS-STATE-TX-RATE-CALC (WS-BILLING-INDX) = 0     
                    AND WS-COMPANY-NO-BG (WS-BILLING-INDX)              
                                                   NOT  = WS-PSNC       
                   COMPUTE WS-ST-TX-RATE-CALC  ROUNDED                  
                    = (WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)) /         
                       (WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX))          
                   MOVE WS-ST-TX-RATE-CALC   TO                         
                        WS-STATE-TX-RATE-CALC (WS-BILLING-INDX)         
                 END-IF                                                 
                 IF WS-CODE-BILL-CALC-BG (WS-BILLING-INDX)              
                      = WS-TAX-ONLY                                     
      ** NEED TO SET UP CNSMPTN START/END DATES FOR TAX PRORATION               
                    IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) > SPACE   
                       MOVE WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX)      
                         TO WS-BC-CNSMPTN-END-DATE                      
                    ELSE                                                
PRJ821                 MOVE WS-BC-CALC-DATE TO WS-BC-CNSMPTN-END-DATE   
                    END-IF                                              
                                                                        
                    PERFORM 7125-GET-CNSMPTN-START-DATE                 
                       THRU 7125-EXIT                                   
                    MOVE WS-DATE-1 TO WS-BC-CNSMPTN-START-DATE          
                    MOVE WS-NO-OF-CONS-DAYS-BG (WS-BILLING-INDX)        
                      TO WS-BC-NO-CNSMPTN-DAYS                          
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-BC-CODE-BILL-STATUS-BI                              
                   = WS-NO-BILL                                         
                 MOVE WS-NO-BILL TO WS-CODE-BILL-STATUS-BI              
              ELSE                                                      
      ** PRE-CALC AND TAX-ONLY DETAILS GO THROUGH BILL CALC ANYWAY,             
      ** BUT ONLY TO FLAX EXCEPTIONS; RESULTS ARE NOT SAVED                     
                 IF WS-CODE-BILL-CALC-BG (WS-BILLING-INDX)              
                       NOT = WS-PRE-CALC                                
                    AND NOT ( SEB-DATABASE AND                          
                         WS-FIRST-ESTD-BILL-PK(WS-PK-INDX) )            
                    AND NOT CPD107B-HAS-BILL-MAN                        
PRJ821              PERFORM 7118-REV-DIST-CODE THRU 7118-EXIT           
                    PERFORM 2500-COMPUTE-TAXES THRU 2500-EXIT           
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *    END-PERFORM.                                                         
                                                                        
       0010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      * CHECK IF MANUAL BILL CALCULATIONS ARE PRESENT FOR THE IC                
      *                                                                         
       0020-CHECK-MANUAL-BILL-DETAILS.                                  
      *                                                                         
           MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX)                      
                                           TO WS-CPD107B-ACCOUNT-NO.    
           MOVE WS-BILL-NO-BG (WS-BILLING-INDX)                         
                                           TO WS-CPD107B-BILL-NO.       
           MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)                  
                                           TO WS-CPD107B-CODE-UTIL-TYPE.
           MOVE WS-IC-NO-BG (WS-BILLING-INDX)                           
                                           TO WS-CPD107B-IC-NO.         
           MOVE WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)              
                                           TO WS-CPD107B-BILL-TIMESTMP. 
                                                                        
           PERFORM 6005-CPD107B-INPUT-PROCESS   THRU 6005-CPD107B-EXIT. 
           PERFORM 6060-CPD107B-GET-MANBILL-HDR THRU 6060-CPD107B-EXIT. 
                                                                        
           IF CPD107B-HAS-BILL-MAN                                      
              AND WS-CPD107B-RETURN-CODE EQUAL SUCCESSFUL-CALL          
              MOVE ZERO                        TO RETURN-CODE           
           ELSE                                                         
              IF WS-CPD107B-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL       
                 MOVE WS-CPD107B-RETURN-CODE   TO WS-DB2-RETURN-CODE    
                 MOVE WS-CPD107B-DB2-TABLE-ID  TO WS-DB2-TABLE-ID       
                 MOVE WS-CPD107B-DB2-FUNCTION  TO WS-DB2-FUNCTION       
                 MOVE '105'                    TO WS-DB2-MODULE-ID      
                 MOVE WS-CPD107B-DB2-PARAGRAPH TO WS-DB2-PARAGRAPH      
                 MOVE WS-CPD107B-DB2-KEY-1N    TO WS-DB2-KEY-1N         
                 MOVE WS-CPD107B-DB2-KEY-2N    TO WS-DB2-KEY-2N         
                 MOVE WS-CPD107B-DB2-KEY-3     TO WS-DB2-KEY-3          
                 MOVE WS-CPD107B-DB2-KEY-4N    TO WS-DB2-KEY-4N         
                 MOVE 12                     TO RETURN-CODE             
                 PERFORM 9900-SQL-ERROR       THRU 9900-CPD122-EXIT     
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * GET THE MANUAL BILL DETAILS FOR THE IC                                  
      *                                                                         
       0021-GET-MANUAL-BILL-DETAILS.                                    
      *                                                                         
           PERFORM 6000-CPD107B-MAIN-PROCESS   THRU 6000-CPD107B-EXIT.  
                                                                        
           IF WS-CPD107B-RETURN-CODE EQUAL SUCCESSFUL-CALL              
              MOVE ZERO                        TO RETURN-CODE           
      *       PERFORM 2600-STORE-RESULTS       THRU 2600-EXIT                   
           ELSE                                                         
              IF WS-CPD107B-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL       
                 MOVE WS-CPD107B-RETURN-CODE   TO WS-DB2-RETURN-CODE    
                 MOVE WS-CPD107B-DB2-TABLE-ID  TO WS-DB2-TABLE-ID       
                 MOVE WS-CPD107B-DB2-FUNCTION  TO WS-DB2-FUNCTION       
                 MOVE '105'                    TO WS-DB2-MODULE-ID      
                 MOVE WS-CPD107B-DB2-PARAGRAPH TO WS-DB2-PARAGRAPH      
                 MOVE WS-CPD107B-DB2-KEY-1N    TO WS-DB2-KEY-1N         
                 MOVE WS-CPD107B-DB2-KEY-2N    TO WS-DB2-KEY-2N         
                 MOVE WS-CPD107B-DB2-KEY-3     TO WS-DB2-KEY-3          
                 MOVE WS-CPD107B-DB2-KEY-4N    TO WS-DB2-KEY-4N         
                 MOVE 12                       TO RETURN-CODE           
                 PERFORM 9900-SQL-ERROR        THRU 9900-CPD122-EXIT    
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0021-EXIT.                                                       
           EXIT.                                                        
      /***************************************************************          
      **    2500-COMPUTE-TAXES.                                     **          
      **                                                            **          
      ****************************************************************          
       2500-COMPUTE-TAXES.                                              
      * CHECK IF RATE OVERRIDE REVENUE MONTH IS PRESENT.                        
           SET NO-RT-REV-MTH-OVRD    TO TRUE.                           
           SET WS-BC-ADJUSTMNT-INDEX TO 1.                              
           MOVE ZEROS                TO WS-RTOV-HLD-REV-MTH             
           SEARCH WS-BC-BILL-ADJUSTMNT-DATA                             
             AT END                                                     
                  CONTINUE                                              
             WHEN WS-BC-ACCOUNT-NO-BP(WS-BC-ADJUSTMNT-INDEX)            
                = WS-ACCOUNT-NO-BG(WS-BILLING-INDX)                     
              AND WS-BC-BILL-NO-BP(WS-BC-ADJUSTMNT-INDEX)               
                = WS-BILL-NO-BG(WS-BILLING-INDX)                        
              AND WS-BC-CODE-UTIL-TYPE-BP(WS-BC-ADJUSTMNT-INDEX)        
                = WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                 
              AND WS-BC-IC-NO-BP(WS-BC-ADJUSTMNT-INDEX)                 
                = WS-IC-NO-BG(WS-BILLING-INDX)                          
              AND WS-BC-BILL-ITEM-TIMESTMP-BP(WS-BC-ADJUSTMNT-INDEX)    
                = WS-BILL-ITEM-TIMESTMP-BG(WS-BILLING-INDX)             
              AND WS-BC-ADJ-TYPE-CD-BP(WS-BC-ADJUSTMNT-INDEX)           
                = WS-RT-PARM-OVRD                                       
                  IF WS-BC-OVRRIDE-RT-REV-MTH-BP                        
                                         (WS-BC-ADJUSTMNT-INDEX) > 0    
                     MOVE WS-BC-OVRRIDE-RT-REV-MTH-BP                   
                                         (WS-BC-ADJUSTMNT-INDEX)        
                       TO WS-RTOV-HLD-REV-MTH                           
                     SET  RT-REV-MTH-OVRD TO TRUE                       
                  END-IF                                                
           END-SEARCH.                                                  
                                                                        
           IF WS-TAX-TABLE-ENTRIES = ZERO                               
              PERFORM 2510-LOAD-TAX-RATES    THRU 2510-EXIT             
              PERFORM 2511-LOAD-EXCISE-RATES THRU 2511-EXIT             
           END-IF.                                                      
                                                                        
      ** DETERMINE CLASS-BASED EXEMPTIONS                                       
                                                                        
           PERFORM 2520-GET-SPECIAL-EXEMPTIONS THRU 2520-EXIT           
                                                                        
      ** DETERMINE TAXABLE BASE                                                 
           MOVE ZERO TO WS-STATE-TAXABLE-AMT                            
                        WS-CITY-TAXABLE-AMT                             
                        WS-OTHER-TAXABLE-AMT                            
                                                                        
           MOVE 'N'  TO WS-ACCT-ST-TAXABLE-CD                           
                        WS-ACCT-CT-TAXABLE-CD                           
                        WS-ACCT-OTH-TAXABLE-CD.                         
                                                                        
           MOVE 'N'  TO WS-EXEMPT-RATE-FLAG.                            
                                                                        
      **-- FROM 2014-07-01 EXEMPT FROM STATE TAX FOR RATES 175, 180 etc         
      **   'A' INDICATES 'NO PARAGRAPH'                                         
           IF WS-COMPANY-NO-AT = '26'                                   
              PERFORM VARYING WS-EXMT-RATES-INDX FROM 1 BY 1            
SCA006          UNTIL EXEMPT-RATE-FOUND OR 
                      WS-EXMT-RATES-INDX > 25 OR 
                      WS-RATE-PLAN-NO-EXMT (WS-EXMT-RATES-INDX) = SPACES        
                IF WS-RATE-PLAN-NO-EXMT (WS-EXMT-RATES-INDX)            
                   =  WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)              
                    MOVE 'A'                                            
                      TO WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX)      
                    SET EXEMPT-RATE-FOUND TO TRUE                       
                END-IF                                                  
              END-PERFORM                                               
           END-IF                                                       
                                                                        
      ******-------------------------------------------------------*****        
      ** STARTING IN 2007-09, THE EXCISE TAX FOR PSNC CUSTOMERS WHICH           
      ** ARE MANUFACTURERS OR FARMERS WILL BE REDUCED OVER A FOUR YEAR          
      ** PERIOD TO EVENTUALLY MAKE THEM EXCISE TAX EXEMPT. THE ACCOUNTS         
      ** ARE IDENTIFIED BY WS-CODE-STAT-TAX-XMT-BG = 'Z'.                       
                                                                        
      ** WS-CODE-STAT-TAX-XMT-BG = 'V' IDENTIFIES THE SEB ACCOUNTS THAT         
      ** ARE ELIGIBLE TO GET THE PARTIAL SALES TAX CREDIT                       
      ******-------------------------------------------------------*****        
                                                                        
           IF WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX) = 'N' OR SPACE  
              OR (WS-COMPANY-NO-AT = '26' AND                           
                  WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX) = 'Z')      
              OR (WS-COMPANY-NO-AT = '01' AND                           
                  SEB-DATABASE            AND                           
                  WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX) = 'V')      
              OR (WS-COMPANY-NO-AT = '01' AND                           
                  SEB-DATABASE            AND                           
                  WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX) =           
                                           WS-GA-MFG-SALES-TAX-XMT)     
              MOVE WS-BC-AMT-BILL-ITEM-BG TO WS-STATE-TAXABLE-AMT       
              SET ACCOUNT-STATE-TAXABLE TO TRUE                         
              IF WS-CODE-OTHR-TAX-XMT-BG (WS-BILLING-INDX)              
                = 'N' OR SPACE                                          
                 MOVE WS-BC-AMT-BILL-ITEM-BG TO WS-OTHER-TAXABLE-AMT    
                 SET ACCOUNT-OTH-TAXABLE TO TRUE                        
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX) = 'N' OR SPACE  
              MOVE WS-BC-AMT-BILL-ITEM-BG TO WS-CITY-TAXABLE-AMT        
              SET ACCOUNT-CITY-TAXABLE TO TRUE                          
           END-IF                                                       
                                                                        
      ** BACK OUT ANY NON-TAXABLE ADJUSTMENTS FROM THE TOTAL BILL AMT           
      ** (SPECIAL/FIXED FACTORS CAN BE SEPARATELY IDENTIFIED AS NON             
      **  TAXABLE)                                                              
                                                                        
      ** REMOVED > 0 CHECK FOR STATE, CITY AND OTHER TAXABLE AMOUNT             
      ** AS IT IS BEING CHECKED WITHIN THE PERFORM LOOP FOR ADD/REPL            
      ** COMPONENT. FOR SUB COMPONENT THIS CHECK IS NOT REQUIRED AS             
      ** WE NEED TO ADD THE ADJUSTMENT BACK BEFORE CALCULATING TAXES            
      ** IN ALL SCENARIOS WHEN THE STATE, CITY OR OTHER TAXABLE AMOUNT          
      ** RETURNED FROM CPDCA107 IS +VE, -VE OR ZEROS.                           
              PERFORM VARYING BA-INDX FROM 1 BY 1                       
                      UNTIL BA-INDX > 200                               
                         OR WS-BC-FACTOR-ID (BA-INDX) = SPACE           
                 IF ADD-TO-COMPONENT-AMT (BA-INDX)                      
                       OR REPL-COMPONENT-AMT (BA-INDX)                  
                  IF WS-BC-FCT-RATE-VERSION (BA-INDX) = 1               
                    IF (WS-BC-STATE-TAX-XMPT-ADJ (BA-INDX) = 'Y'        
                           AND ACCOUNT-STATE-TAXABLE)                   
                       SUBTRACT WS-BC-AMT-ADJUSTMENT (BA-INDX)          
                          FROM WS-STATE-TAXABLE-AMT                     
                    END-IF                                              
                    IF (WS-BC-CITY-TAX-XMPT-ADJ (BA-INDX) = 'Y'         
                           AND ACCOUNT-CITY-TAXABLE)                    
                       SUBTRACT WS-BC-AMT-ADJUSTMENT (BA-INDX)          
                          FROM WS-CITY-TAXABLE-AMT                      
                    END-IF                                              
                    IF (WS-BC-OTHER-TAX-XMPT-ADJ (BA-INDX) = 'Y'        
                           AND ACCOUNT-OTH-TAXABLE)                     
                       SUBTRACT WS-BC-AMT-ADJUSTMENT (BA-INDX)          
                          FROM WS-OTHER-TAXABLE-AMT                     
                    END-IF                                              
                  END-IF                                                
                 ELSE                                                   
      ******************************************************************        
      *  ADD BACK TAX EXEMPT SUBTRACTIVE FACTORS OR TAX-ONLY FACTORS   *        
      *  (EXCLUDING SEB COMMERCIAL PARTIAL TAX CREDIT)                 *        
      ******************************************************************        
                   IF SUB-FROM-COMPONENT-AMT (BA-INDX)                  
                      OR TAX-ONLY (BA-INDX)                             
                     IF WS-BC-FCT-RATE-VERSION (BA-INDX) = 1            
                       IF (WS-BC-STATE-TAX-XMPT-ADJ (BA-INDX) = 'Y'     
                            OR TAX-ONLY (BA-INDX))                      
                           AND ACCOUNT-STATE-TAXABLE                    
                         COMPUTE WS-STATE-TAXABLE-AMT =                 
                                 WS-STATE-TAXABLE-AMT +                 
                                 WS-BC-AMT-ADJUSTMENT (BA-INDX)         
                       END-IF                                           
                       IF (WS-BC-CITY-TAX-XMPT-ADJ (BA-INDX) = 'Y'      
                            OR TAX-ONLY (BA-INDX))                      
                           AND ACCOUNT-CITY-TAXABLE                     
                         COMPUTE WS-CITY-TAXABLE-AMT =                  
                                 WS-CITY-TAXABLE-AMT +                  
                                 WS-BC-AMT-ADJUSTMENT (BA-INDX)         
                       END-IF                                           
                       IF (WS-BC-OTHER-TAX-XMPT-ADJ (BA-INDX) = 'Y'     
                            OR TAX-ONLY (BA-INDX))                      
                           AND ACCOUNT-OTH-TAXABLE                      
                         COMPUTE WS-OTHER-TAXABLE-AMT =                 
                                 WS-OTHER-TAXABLE-AMT +                 
                                 WS-BC-AMT-ADJUSTMENT (BA-INDX)         
                       END-IF                                           
                     END-IF                                             
                   END-IF                                               
                 END-IF                                                 
              END-PERFORM.                                              
                                                                        
      **IF TAXABLE AMT < 0,CALC NEGATIVE TAX EXCEPT "PR1" & "TRNSP"             
           MOVE 'Y'             TO WS-NEGATIVE-TAX-IND.                 
           IF WS-REV-RPT-CD-BG (WS-BILLING-INDX)   = 'T'   OR           
              WS-RATE-PLAN-NO-BG (WS-BILLING-INDX) = 'PR1'              
              MOVE 'N'          TO WS-NEGATIVE-TAX-IND                  
           END-IF.                                                      
      ** FRANCHISE TAXES (CITY) ARE THEMSELVES SUBJECT TO STATE                 
      ** TAXES IN SC. CALCULATE THIS FIRST THEN ADD RESULT TO                   
      ** STATE TAX BASIS                                                        
           IF (WS-CITY-TAXABLE-AMT > 0 )  OR                            
              (WS-CITY-TAXABLE-AMT < 0 AND WS-NEGATIVE-TAX-IND = 'Y')   
              PERFORM 2540-CALCULATE-CITY-TAX THRU 2540-EXIT            
              IF WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX)              
                     = 'N' OR SPACE                                     
                 ADD WS-AMT-CITY-TAX-BG (WS-BILLING-INDX)               
                   TO WS-STATE-TAXABLE-AMT                              
                 ADD WS-AMT-CITY-TAX-BG (WS-BILLING-INDX)               
                   TO WS-OTHER-TAXABLE-AMT                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF (WS-STATE-TAXABLE-AMT > 0 )  OR                           
              (WS-STATE-TAXABLE-AMT < 0 AND WS-NEGATIVE-TAX-IND = 'Y')  
              PERFORM 2530-CALCULATE-STATE-TAX THRU 2530-EXIT           
           END-IF.                                                      
                                                                        
           IF SEB-DATABASE                                              
             AND WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)  >  0            
             AND WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX) (2:1) = '1' 
                PERFORM 2539-SEB-SPCL-TAX-CREDIT THRU 2539-EXIT         
                MOVE ZERO TO WS-NET-ENERGY-AMT                          
                             WS-SEB-TAX-CRD-AMT                         
           END-IF.                                                      
           IF NOT SEB-DATABASE                                          
             AND WS-COMPANY-NO-AT = '01'                                
             AND ( (WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) > 0 ) OR      
                   (WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) < 0  AND      
                    WS-NEGATIVE-TAX-IND = 'Y'                 ) )       
                PERFORM 7105-GET-SALES-TAX-DATA THRU 7105-EXIT          
                PERFORM 2533-SCE-SPCL-TAX-CREDIT THRU 2533-EXIT         
                MOVE ZERO TO WS-SCE-TAX-CRD-AMT                         
           END-IF.                                                      
                                                                        
           IF SEB-DATABASE                                              
              AND WS-COMPANY-NO-AT = '01'                               
              AND WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)  >  0           
              AND WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX) = 'V'       
                                                                        
              MOVE ZEROS              TO WS-COM-TXCRD-FCTR              
                                         WS-TOT-TXCRD-UNITS             
                                         WS-HLD-OTHER-TAX-RATE          
                                         WS-HOLD-DDC-AMOUNT             
                                         WS-HLD-BC-AMT-NET-RATE         
                                         WS-SALES-TXCRD-PCT             
                                         WS-AVG-TWOPRT-UNIT-PR          
                                         WS-TAX-CRD-AMT                 
                                         WS-SALES-TXCRD-AMT             
                                                                        
              SET SEB-TXCRD-NOT-FOUND TO TRUE                           
              PERFORM VARYING BA-INDX FROM 1 BY 1                       
SCA006          UNTIL SEB-TXCRD-FOUND OR 
                      BA-INDX > 200 OR 
                      WS-BC-FACTOR-ID (BA-INDX) = SPACE                         
                   IF PRICE-PER-UNIT-ABOVE-MIN (BA-INDX)                
                      MOVE WS-BC-FACTOR (BA-INDX) TO WS-COM-TXCRD-FCTR  
                      SET SEB-TXCRD-FOUND TO TRUE                       
                                                                        
                      PERFORM 2501-GET-TOT-BILLED-UNITS THRU 2501-EXIT  
                      PERFORM 2502-GET-SALES-TXCRD-FCTR THRU 2502-EXIT  
                                                                        
                      SET NOT-TWO-PART-RT TO TRUE                       
                      PERFORM VARYING BA-INDX FROM 1 BY 1               
SCA006                  UNTIL TWO-PART-RT OR 
                              BA-INDX > 200 OR 
                              WS-BC-FACTOR-ID (BA-INDX) = SPACE                 
                           IF WS-BC-SPCL-GROUP-CD (BA-INDX) = 'DD'      
                              SET TWO-PART-RT TO TRUE                   
                              MOVE WS-BC-FACTOR (BA-INDX)               
                                TO WS-HOLD-DDC-AMOUNT                   
                           END-IF                                       
                      END-PERFORM                                       
                                                                        
                      IF WS-TOT-TXCRD-UNITS > ZERO                      
                         PERFORM 2503-CALC-SALES-TXCRD THRU 2503-EXIT   
                      ELSE                                              
                         MOVE ZEROS TO WS-SALES-TXCRD-AMT               
                         PERFORM 2504-UPDATE-BA-FH-AREAS THRU 2504-EXIT 
                      END-IF                                            
                   END-IF                                               
              END-PERFORM                                               
              IF SEB-TXCRD-NOT-FOUND                                    
                 IF LS-CURR-WQ-ITEM = 50                                
                    DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'           
                    DISPLAY 'PROCESSING TERMINATED'                     
                    MOVE 16 TO RETURN-CODE                              
                    PERFORM 9999-CPD122-BAIL-OUT THRU 9999-CPD122-EXIT  
                 ELSE                                                   
                    ADD 1 TO LS-CURR-WQ-ITEM                            
                    SET WS-BILL-WQ-INDX     TO LS-CURR-WQ-ITEM          
                    MOVE WS-NO-TX-FCT-FOR-AT                            
                      TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)  
                    MOVE WS-REJECT          TO WS-EXCEPTION-CODE-WQ     
                    PERFORM 5100-PROCESS-EXCEPTION THRU 5100-CPD122-EXIT
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE ZEROS TO WS-SALES-TXCRD-AMT                          
              PERFORM 2504-UPDATE-BA-FH-AREAS THRU 2504-EXIT            
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2501-GET-TOT-BILLED-UNITS.                                       
                                                                        
           MOVE ZEROS TO WS-HLD-BC-AMT-NET-RATE.                        
           PERFORM VARYING BC-INDX FROM 1 BY 1                          
             UNTIL BC-INDX > WS-BC-MAX-ENTRY                            
                OR WS-BC-COMPONENT-ID (BC-INDX) = SPACES                
                PERFORM VARYING BLK-INDX FROM 1 BY 1                    
                  UNTIL BLK-INDX > 9                                    
                     OR WS-BC-BLOCK-SIZE (BC-INDX BLK-INDX) = ZERO      
                     COMPUTE WS-TOT-TXCRD-UNITS = WS-TOT-TXCRD-UNITS +  
                             WS-BC-UNITS-BILLED (BC-INDX BLK-INDX)      
                     IF WS-BC-AMT-NET-RATE (BC-INDX BLK-INDX) > 0       
                        AND WS-HLD-BC-AMT-NET-RATE = ZERO               
                        MOVE WS-BC-AMT-NET-RATE (BC-INDX BLK-INDX)      
                          TO WS-HLD-BC-AMT-NET-RATE                     
                     END-IF                                             
                END-PERFORM                                             
           END-PERFORM.                                                 
                                                                        
       2501-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2502-GET-SALES-TXCRD-FCTR.                                       
                                                                        
           INITIALIZE WS-TAX-COMPARE-KEY.                               
           MOVE WS-REV-DISTRICT-CD TO WS-TAX-JURISDICTION-CD.           
           MOVE 'C'                   TO WS-TAX-COMPARE-TYPE.           
                                                                        
           PERFORM VARYING TC-INDX FROM 1 BY 1                          
             UNTIL TC-INDX > WS-TAX-TABLE-ENTRIES                       
                OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES                 
                IF WS-TC-TAX-ID (TC-INDX) = WS-TAX-COMPARE-KEY          
                   AND WS-TC-TAX-CNTRL-NO (TC-INDX) >= 20               
                   AND WS-TC-TAX-CNTRL-NO (TC-INDX)  < 90               
                   PERFORM 2502A-GET-OTHER-TX-VERSION                   
                      THRU 2502A-EXIT                                   
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
           COMPUTE WS-SALES-TXCRD-PCT ROUNDED = WS-HLD-STATE-TAX-RATE   
                                              - WS-HLD-OTHER-TAX-RATE.  
           DISPLAY 'TAX RATE COMPARE KEY = ' WS-TAX-COMPARE-KEY.        
           DISPLAY 'SALES TAX PERCENTAGE = ' WS-SALES-TXCRD-PCT.        
           DISPLAY 'STATE TAX PERCENTAGE = ' WS-HLD-STATE-TAX-RATE.     
           DISPLAY 'OTHER TAX PERCENTAGE = ' WS-HLD-OTHER-TAX-RATE.     
                                                                        
       2502-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2502A-GET-OTHER-TX-VERSION.                                      
                                                                        
            IF WS-TU-CALC-INST (TC-INDX) = 'R'                          
                                                                        
              IF WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX) > 0          
                 MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)         
                   TO WS-REV-MONTH-TEST                                 
              ELSE                                                      
                 MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)             
                   TO WS-REV-MONTH-TEST                                 
              END-IF                                                    
                                                                        
              IF WS-REV-MONTH-TEST > 0                                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE LS-CURR-REVENUE-MONTH TO WS-REV-MONTH-TEST        
              END-IF                                                    
                                                                        
              IF RT-REV-MTH-OVRD                                        
                 MOVE WS-RTOV-HLD-REV-MTH   TO WS-REV-MONTH-TEST        
              END-IF                                                    
                                                                        
              MOVE WS-REV-MONTH-TEST(1:4) TO WS-TEMP-WORK-DATE (1:4)    
              MOVE '-'                    TO WS-TEMP-WORK-DATE (5:1)    
              MOVE WS-REV-MONTH-TEST(5:2) TO WS-TEMP-WORK-DATE (6:2)    
              MOVE '-'                    TO WS-TEMP-WORK-DATE (8:1)    
              MOVE '01'                   TO WS-TEMP-WORK-DATE (9:2)    
                                                                        
              PERFORM 2534A-GET-TAX-RATE-VERSION THRU 2534A-EXIT        
                                                                        
              COMPUTE WS-HLD-OTHER-TAX-RATE =                           
                         WS-HLD-OTHER-TAX-RATE + WS-TAX-RATE-CALC       
              END-COMPUTE                                               
                                                                        
            END-IF.                                                     
                                                                        
       2502A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       2503-CALC-SALES-TXCRD.                                           
      * 1. FOR TWO-PART RATE :                                                  
      *      AVG PRICE PER THERM = ((BASE RATE * BILLED UNITS) +                
      *                           DDC-AMOUNT) / BILLED UNITS.                   
      *      TAX CREDIT AMOUNT = UNITS BILLED * (AVG PRICE PER THERM -          
      *                                     CREDIT FCTR ON THERM PRICE)         
      * 2. FOR NON-TWO-PART RATE :                                              
      *      TAX CREDIT AMOUNT = UNITS BILLED * (BASE RATE -                    
      *                                     CREDIT FCTR ON THERM PRICE)         
      *                                                                         
      * SALES TAX CREDIT AMOUNT = TAX CREDIT AMT * SALES TAX CREDIT PCT         
      * REDUCED TAX AMOUNT = STATE TAX AMOUNT - SALES TAX CREDIT AMOUNT         
                                                                        
           IF TWO-PART-RT                                               
              COMPUTE WS-AVG-TWOPRT-UNIT-PR ROUNDED =                   
                    ((WS-TOT-TXCRD-UNITS * WS-HLD-BC-AMT-NET-RATE) +    
                      WS-HOLD-DDC-AMOUNT) / WS-TOT-TXCRD-UNITS          
              COMPUTE WS-TAX-CRD-AMT ROUNDED =                          
                      WS-TOT-TXCRD-UNITS *                              
                     (WS-AVG-TWOPRT-UNIT-PR - WS-COM-TXCRD-FCTR)        
           ELSE                                                         
              COMPUTE WS-TAX-CRD-AMT ROUNDED =                          
                      WS-TOT-TXCRD-UNITS *                              
                     (WS-HLD-BC-AMT-NET-RATE - WS-COM-TXCRD-FCTR)       
           END-IF.                                                      
                                                                        
           IF WS-TAX-CRD-AMT < 0                                        
              MOVE ZEROS TO WS-SALES-TXCRD-AMT                          
           ELSE                                                         
              COMPUTE WS-SALES-TXCRD-AMT ROUNDED =                      
                      WS-TAX-CRD-AMT * WS-SALES-TXCRD-PCT               
                                                                        
              DISPLAY 'PARTIAL SALES TAX CREDIT ON '                    
                                   WS-AMT-STATE-TAX-BG(WS-BILLING-INDX) 
                      ' OF ' WS-SALES-TXCRD-AMT                         
                      ' STATE TAX AMT = ' WS-STATE-TAXABLE-AMT          
              COMPUTE WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) ROUNDED =   
                      WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) -           
                      WS-SALES-TXCRD-AMT                                
           END-IF.                                                      
                                                                        
           PERFORM 2504-UPDATE-BA-FH-AREAS THRU 2504-EXIT.              
                                                                        
       2503-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2504-UPDATE-BA-FH-AREAS.                                         
                                                                        
           SET SEB-TXCRD-NOT-FOUND TO TRUE.                             
           MOVE SPACES TO WS-HLD-FACTOR-ID.                             
                                                                        
           PERFORM VARYING BA-INDX FROM 1 BY 1                          
SCA006       UNTIL SEB-TXCRD-FOUND OR 
                   BA-INDX > 200 OR 
                   WS-BC-FACTOR-ID (BA-INDX) = SPACE                            
                IF PRICE-PER-UNIT-ABOVE-MIN (BA-INDX)                   
                   MOVE WS-SALES-TXCRD-AMT                              
                     TO WS-BC-FACTOR (BA-INDX)                          
                        WS-BC-AMT-ADJUSTMENT (BA-INDX)                  
                   MOVE WS-BC-FACTOR-ID (BA-INDX) TO WS-HLD-FACTOR-ID   
                   SET SEB-TXCRD-FOUND TO TRUE                          
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
           SET SEB-TXCRD-NOT-FOUND TO TRUE.                             
                                                                        
           PERFORM VARYING FH-INDX FROM 1 BY 1                          
SCA006       UNTIL SEB-TXCRD-FOUND OR 
                   FH-INDX > 200 OR 
                   WS-BC-FACTOR-ID-FH (FH-INDX) = SPACES                        
                IF WS-BC-FACTOR-ID-FH (FH-INDX) = WS-HLD-FACTOR-ID      
                   MOVE WS-SALES-TXCRD-AMT TO WS-BC-FACTOR-FH (FH-INDX) 
                   SET SEB-TXCRD-FOUND TO TRUE                          
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
           MOVE ZEROS              TO WS-COM-TXCRD-FCTR                 
                                      WS-TOT-TXCRD-UNITS                
                                      WS-HLD-STATE-TAX-RATE             
                                      WS-HLD-OTHER-TAX-RATE             
                                      WS-HOLD-DDC-AMOUNT                
                                      WS-HLD-BC-AMT-NET-RATE            
                                      WS-SALES-TXCRD-PCT                
                                      WS-AVG-TWOPRT-UNIT-PR             
                                      WS-TAX-CRD-AMT                    
                                      WS-SALES-TXCRD-AMT.               
                                                                        
       2504-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2510-LOAD-TAX-RATES.                                             
           MOVE HIGH-VALUES TO WS-TAX-RATE-TABLE.                       
           SET TC-INDX TO 1                                             
           MOVE ZERO TO WS-TAX-TABLE-ENTRIES.                           
           PERFORM 7110-OPEN-TAX-DATA THRU 7110-EXIT                    
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              PERFORM 7112-FETCH-TAX-DATA THRU 7112-EXIT                
              IF SQLCODE = SUCCESSFUL-CALL                              
                 IF WS-TAX-TABLE-ENTRIES = WS-TAX-TABLE-ENTRIES-MAX     
                    MOVE 'TAX RATE TABLE OVERFLOW'                      
                          TO WS-MISC-MSG-TEXT                           
                    MOVE +23 TO WS-MISC-MSG-LEN                         
                    MOVE 16 TO RETURN-CODE                              
                    MOVE 137                TO WS-MISC-WQ-CAT-ID        
                    PERFORM 9910-MISC-ERROR THRU 9910-EXIT              
                 ELSE                                                   
                    PERFORM 2512-LOAD-TAX-ENTRY THRU 2512-EXIT          
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM                                                  
           PERFORM 7114-CLOSE-TAX-DATA THRU 7114-EXIT.                  
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2511-LOAD-EXCISE-RATES.                                          
           INITIALIZE WS-TAX-EXCISE-TABLE.                              
           SET X6-INDX TO 1 .                                           
           MOVE ZERO TO WS-TAX-EX-ENTRIES.                              
           PERFORM 7115-OPEN-EX-DATA THRU 7115-EXIT.                    
           PERFORM 7116-FETCH-EX-DATA THRU 7116-EXIT                    
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              IF WS-TAX-EX-ENTRIES = WS-TAX-EX-ENTRIES-MAX              
                    MOVE 'EXCISE DATA TABLE OVERFLOW'                   
                          TO WS-MISC-MSG-TEXT                           
                    MOVE +26 TO WS-MISC-MSG-LEN                         
                    MOVE 16 TO RETURN-CODE                              
                    MOVE 137                TO WS-MISC-WQ-CAT-ID        
                    PERFORM 9910-MISC-ERROR THRU 9910-EXIT              
                 ELSE                                                   
                    PERFORM 2513-LOAD-EX-ENTRY THRU 2513-EXIT           
              END-IF                                                    
              PERFORM 7116-FETCH-EX-DATA THRU 7116-EXIT                 
           END-PERFORM.                                                 
           PERFORM 7117-CLOSE-EX-DATA THRU 7117-EXIT.                   
       2511-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2512-LOAD-TAX-ENTRY.                                             
           IF WS-TC-TAX-TYPE (TC-INDX) = TC-TAX-TYPE                    
            AND WS-TR-TAX-JURISDICTION (TC-INDX) = TR-DETAIL-ID         
            AND WS-TC-TAX-CNTRL-NO (TC-INDX) = TC-TAX-CNTRL-NO          
              SET TR-INDX UP BY 1                                       
              IF TR-INDX > 10                                           
                 MOVE 'TAX RATE VERSION OVERFLOW '                      
                   TO WS-MISC-MSG-TEXT                                  
                 MOVE +26        TO WS-MISC-MSG-LEN                     
                 MOVE WS-REJECT  TO WS-EXCEPTION-CODE-WQ                
                 MOVE WS-NO-BILL TO WS-CODE-BILL-STATUS-BI              
                 MOVE 17         TO WS-MISC-WQ-CAT-ID                   
                 PERFORM 9910-MISC-ERROR THRU 9910-EXIT                 
              ELSE                                                      
                MOVE TR-DATE-FROM TO WS-TR-DATE-FROM (TC-INDX TR-INDX)  
                IF TR-DATE-TO > LOW-VALUES                              
                   MOVE TR-DATE-TO   TO WS-TR-DATE-TO (TC-INDX TR-INDX) 
                ELSE                                                    
                   MOVE '9999-99-99' TO WS-TR-DATE-TO (TC-INDX TR-INDX) 
                END-IF                                                  
                MOVE TR-TAX-RATE     TO WS-TAX-RATE (TC-INDX TR-INDX)   
              END-IF                                                    
           ELSE                                                         
              ADD 1 TO WS-TAX-TABLE-ENTRIES                             
              SET TC-INDX TO WS-TAX-TABLE-ENTRIES                       
              SET TR-INDX TO 1                                          
              MOVE TC-TAX-TYPE TO WS-TC-TAX-TYPE (TC-INDX)              
              MOVE TR-DETAIL-ID TO WS-TR-TAX-JURISDICTION (TC-INDX)     
              MOVE TU-CODE-TAX-CALC-INST TO WS-TU-CALC-INST (TC-INDX)   
              MOVE TU-TAX-ELEC           TO WS-TU-ELECT (TC-INDX)       
              MOVE TU-TAX-GAS            TO WS-TU-GAS   (TC-INDX)       
              MOVE TU-TAX-MDSE           TO WS-TU-MDSE  (TC-INDX)       
              MOVE TU-TAX-WATER          TO WS-TU-WATER (TC-INDX)       
              MOVE TU-TAX-SEWER          TO WS-TU-SEWER (TC-INDX)       
              MOVE TU-TAX-TRASH          TO WS-TU-TRASH (TC-INDX)       
              MOVE TC-TAX-CNTRL-NO       TO WS-TC-TAX-CNTRL-NO(TC-INDX) 
              MOVE TC-FACTOR-ID          TO WS-TU-FACTOR-ID (TC-INDX)   
              MOVE TC-CODE-APPL-COND     TO                             
                                         WS-TU-CODE-APPL-COND(TC-INDX)  
                                                                        
              MOVE TR-DATE-FROM TO WS-TR-DATE-FROM (TC-INDX TR-INDX)    
              IF TR-DATE-TO > LOW-VALUES                                
                 MOVE TR-DATE-TO   TO WS-TR-DATE-TO (TC-INDX TR-INDX)   
              ELSE                                                      
                 MOVE '9999-99-99' TO WS-TR-DATE-TO (TC-INDX TR-INDX)   
              END-IF                                                    
              MOVE TR-TAX-RATE     TO WS-TAX-RATE (TC-INDX TR-INDX)     
                                                                        
           END-IF.                                                      
                                                                        
       2512-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2513-LOAD-EX-ENTRY.                                              
              ADD  1                TO WS-TAX-EX-ENTRIES.               
              SET  X6-INDX          TO WS-TAX-EX-ENTRIES.               
              MOVE X6-TAX-CNTRL-NO  TO WS-X6-TAX-CNTRL-NO (X6-INDX).    
              MOVE X6-DATE-FROM     TO WS-X6-TAX-DATE-FROM (X6-INDX).   
              MOVE X6-BLOCK-NO      TO WS-X6-BLOCK-NO (X6-INDX)    .    
              MOVE X6-BLOCK-UNITS   TO WS-X6-BLOCK-UNITS (X6-INDX) .    
              MOVE X6-EXCISE-TAX-UNIT-AM                                
                                  TO WS-X6-EXCISE-TAX-UNIT-AM(X6-INDX). 
       2513-EXIT .                                                      
            EXIT.                                                       
                                                                        
       2520-GET-SPECIAL-EXEMPTIONS.                                     
           MOVE WS-COMPANY-NO-AT TO F2-COMPANY-NO                       
                                    F3-COMPANY-NO                       
           MOVE WS-REV-DISTRICT-CD                                      
              TO F2-REV-DISTRICT-CD                                     
           MOVE WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX)              
              TO F2-CODE-REVENUE-CLASS                                  
                 F3-CODE-REVENUE-CLASS                                  
           IF  (WS-BC-CIG-CUSTOMER-IND-BG = 'Y')   AND                  
               (WS-BC-CIG-TRNSP-DET-BG    = 'Y')   AND                  
               WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX) = '000'       
               MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX) TO BG-ACCOUNT-NO 
               MOVE WS-BILL-NO-BG (WS-BILLING-INDX)    TO BG-BILL-NO    
               MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)              
                                                   TO BG-CODE-UTIL-TYPE 
               MOVE WS-IC-NO-BG (WS-BILLING-INDX)  TO BG-IC-NO          
               MOVE WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX) TO       
                                                 BG-BILL-ITEM-TIMESTMP  
               PERFORM 8662-GET-BASE-TIME-STAMP THRU 8662-CPD122-EXIT   
               PERFORM 8663-GET-BASE-REVENUE-CLASS THRU 8663-CPD122-EXIT
               MOVE WS-BASE-REVENUE-CLASS                               
                                          TO F2-CODE-REVENUE-CLASS      
                                             F3-CODE-REVENUE-CLASS      
           END-IF                                                       
                                                                        
           MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)                  
              TO F2-CODE-UTIL-TYPE                                      
                 F3-CODE-UTIL-TYPE                                      
                                                                        
           IF WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX) = SPACE         
              PERFORM 7340-GET-FRAN-TX-XMPTN THRU 7340-EXIT             
              IF WS-FT-XMPT = 'Y'                                       
                 MOVE 'Y' TO WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX)  
              END-IF                                                    
           END-IF.                                                      
           IF WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX) = SPACE         
              PERFORM 7342-GET-STATE-TX-XMPTN THRU 7342-EXIT            
              IF WS-ST-XMPT = 'Y'                                       
      ** THIS IS THE CASE WHERE THE REVENUE CLASS IS EXEMPT BUT THERE           
      ** IS NO EXEMPTION SET IN THE UTIL-ENVRNMT ROW. 'A' INDICATES             
      ** 'NO PARAGRAPH'                                                         
                 MOVE 'A' TO WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX)  
                 MOVE 'A' TO WS-CODE-OTHR-TAX-XMT-BG (WS-BILLING-INDX)  
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2530-CALCULATE-STATE-TAX.                                        
           MOVE WS-REV-DISTRICT-CD TO WS-TAX-JURISDICTION-CD            
           MOVE 'A' TO WS-TAX-COMPARE-TYPE                              
           PERFORM VARYING TC-INDX FROM 1 BY 1                          
             UNTIL TC-INDX > WS-TAX-TABLE-ENTRIES                       
                OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES                 
              IF WS-TC-TAX-ID (TC-INDX) = WS-TAX-COMPARE-KEY            
                 IF (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'E'       
                        AND WS-TU-ELECT (TC-INDX) = 'Y')                
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'U'  
                            AND WS-UM-SERVICE-TYPE = 'E'                
                            AND WS-TU-ELECT (TC-INDX) = 'Y')            
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'U'  
                            AND WS-UM-SERVICE-TYPE = 'G'                
                            AND WS-TU-GAS (TC-INDX) = 'Y')              
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'G'  
                        AND WS-TU-GAS (TC-INDX) = 'Y')                  
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'W'  
                        AND WS-TU-WATER (TC-INDX) = 'Y')                
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'S'  
                        AND WS-TU-SEWER (TC-INDX) = 'Y')                
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'T'  
                        AND WS-TU-TRASH (TC-INDX) = 'Y')                
                    PERFORM 2534-APPLY-TAX THRU 2534-EXIT               
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
       2530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2533-SCE-SPCL-TAX-CREDIT.                                        
                                                                        
      ***************************************************************           
      * CALCULATES CONSUMPTION DAYS AND START AND END CONSUMPTION   *           
      * RANGE, AND CHECKS IF THE DATE PASSED IS IN THAT RANGE.      *           
      ***************************************************************           
                                                                        
           MOVE 'Y' TO WS-PROCESS-VALID-FL.                             
           MOVE WS-HLDY-DATE-1 TO WS-PROCESS-START-DATE.                
                                                                        
           PERFORM 5721-CHECK-DATE-RANGE THRU 5721-EXIT.                
                                                                        
           IF WS-PROCESS-VALID-FL = 'Y' AND                             
              WS-BC-NO-CNSMPTN-DAYS > 0                                 
               COMPUTE WS-SCE-TAX-CRD-AMT ROUNDED =                     
               ((WS-STATE-TAXABLE-AMT * WS-HOLIDAY-DAYS)                
              * (WS-SCE-TAX-CRD-RATE)) /                                
                WS-BC-NO-CNSMPTN-DAYS                                   
               DISPLAY 'DAYS CNSMP = '                                  
                WS-BC-NO-CNSMPTN-DAYS                                   
                ' SALES TAX REDUCED FROM '                              
                 WS-AMT-STATE-TAX-BG(WS-BILLING-INDX)                   
               ' BY ' WS-SCE-TAX-CRD-AMT                                
               ' STATE TAX AMT = ' WS-STATE-TAXABLE-AMT                 
               SUBTRACT WS-SCE-TAX-CRD-AMT FROM                         
                        WS-AMT-STATE-TAX-BG(WS-BILLING-INDX)            
               MOVE WS-MSG-SALES-TAX  TO WS-BILL-MESSAGE                
               PERFORM 3440-LOAD-BILL-MESSAGE THRU 3440-EXIT            
           END-IF.                                                      
                                                                        
       2533-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2534-APPLY-TAX.                                                  
                                                                        
      ** FOR PSNC THE TAX CALC INSTRUCTION WILL BE = R                          
      ** FOR SEB ACCTS THE TAX CALC INSTRUCTION WILL BE = R                     
                                                                        
           IF WS-TU-CALC-INST (TC-INDX) = 'R'                           
                                                                        
              IF WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX) > 0          
                 MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)         
                   TO WS-REV-MONTH-TEST                                 
              ELSE                                                      
                 MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)             
                   TO WS-REV-MONTH-TEST                                 
              END-IF                                                    
                                                                        
              IF WS-REV-MONTH-TEST > 0                                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE LS-CURR-REVENUE-MONTH TO WS-REV-MONTH-TEST        
              END-IF                                                    
                                                                        
              IF RT-REV-MTH-OVRD                                        
                 MOVE WS-RTOV-HLD-REV-MTH   TO WS-REV-MONTH-TEST        
              END-IF                                                    
                                                                        
              IF WS-DATE-BILLED-BI = LOW-VALUES                         
PRJ821           MOVE WS-BC-CALC-DATE TO WS-DATE-BILLED-BI              
              END-IF                                                    
                                                                        
              IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) > SPACES        
                 MOVE WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX)            
                   TO WS-DATE-BILLED-TEST                               
              ELSE                                                      
                 MOVE WS-DATE-BILLED-BI TO WS-DATE-BILLED-TEST          
              END-IF                                                    
                                                                        
      ****--  CALCULATE NC STATE TAX  BILLED DATE >= 2014-07-01 --****          
      ****--  CALCULATE NC EXCISE TAX BILLED DATE <  2014-07-01 --****          
      ****--  WS-PSNC-SALES-TAX-START IS FROM DELIQUENCY        --****          
                                                                        
              IF WS-DATE-BILLED-TEST >= WS-PSNC-SALES-TAX-START AND     
                 WS-COMPANY-NO-BG (WS-BILLING-INDX) = WS-PSNC           
                  MOVE WS-DATE-BILLED-TEST    TO WS-TEMP-WORK-DATE      
                  MOVE 'N'                    TO WS-EXCISE-TAX-CALC     
              ELSE                                                      
                  MOVE WS-REV-MONTH-TEST(1:4) TO WS-TEMP-WORK-DATE (1:4)
                  MOVE '-'                    TO WS-TEMP-WORK-DATE (5:1)
                  MOVE WS-REV-MONTH-TEST(5:2) TO WS-TEMP-WORK-DATE (6:2)
                  MOVE '-'                    TO WS-TEMP-WORK-DATE (8:1)
                  MOVE '01'                   TO WS-TEMP-WORK-DATE (9:2)
                  MOVE 'Y'                    TO WS-EXCISE-TAX-CALC     
              END-IF                                                    
                                                                        
              PERFORM 2534A-GET-TAX-RATE-VERSION THRU 2534A-EXIT        
                                                                        
              IF WS-EXCISE-TAX-CALC = 'Y'        AND                    
                 WS-COMPANY-NO-BG (WS-BILLING-INDX) = WS-PSNC           
                     PERFORM 2535-PSNC-TAX-CALC   THRU 2535-EXIT        
              ELSE                                                      
                 IF SEB-DATABASE                                        
                    AND  WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX) =    
                                               WS-GA-MFG-SALES-TAX-XMT  
                      MOVE ZERO              TO WS-OLD-STATE-TAX-PCT    
                                                WS-STATE-TAX-RATE       
                      MOVE WS-TAX-RATE-CALC                             
                                             TO WS-OLD-STATE-TAX-PCT    
                      PERFORM 2535A-SEB-SALE-TAX-XMPT THRU 2535A-EXIT   
                                                                        
                      COMPUTE   WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)   
                      ROUNDED = WS-STATE-TAXABLE-AMT                    
                              * WS-STATE-TAX-RATE                       
PRJ821                MOVE WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) TO     
PRJ821                     WS-BC-AMT-STATE-TAX-BG                       
                      MOVE WS-STATE-TAX-RATE TO                         
                           WS-STATE-TX-RATE-CALC (WS-BILLING-INDX)      
PRJ821                     BG-STATE-TAX-RATE                            
PRJ821                     WS-HLD-STATE-TAX-RATE                        
                      MOVE 'S'               TO                         
                           WS-STATE-TAX-TYPE-CALC-BG(WS-BILLING-INDX)   
                 ELSE                                                   
                   COMPUTE WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)        
                      ROUNDED = WS-STATE-TAXABLE-AMT                    
                              * WS-TAX-RATE-CALC                        
PRJ821                MOVE WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) TO     
PRJ821                     WS-BC-AMT-STATE-TAX-BG                       
PRJ821                MOVE WS-TAX-RATE-CALC TO                          
                           WS-STATE-TX-RATE-CALC (WS-BILLING-INDX)      
PRJ821                     BG-STATE-TAX-RATE                            
PRJ821                     WS-HLD-STATE-TAX-RATE                        
                      MOVE 'S'               TO                         
                           WS-STATE-TAX-TYPE-CALC-BG(WS-BILLING-INDX)   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2534-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***---------------------------------------------------------------        
      *** GET TAX RATE VERSION FOR THE PERIOD                                   
      ***---------------------------------------------------------------        
       2534A-GET-TAX-RATE-VERSION.                                      
           INITIALIZE WS-VERSION-FOUND                                  
                      WS-TAX-RATE-CALC .                                
           PERFORM VARYING TR-INDX FROM 1 BY 1                          
SCA006       UNTIL VERSION-FOUND OR 
                   TR-INDX > 10 OR 
                   WS-TR-DATE-FROM (TC-INDX TR-INDX) = HIGH-VALUES              
              IF WS-TR-DATE-FROM (TC-INDX TR-INDX) <= WS-TEMP-WORK-DATE 
                               AND                                      
                 WS-TR-DATE-TO (TC-INDX TR-INDX)   >= WS-TEMP-WORK-DATE 
                   MOVE WS-TAX-RATE (TC-INDX TR-INDX)                   
                     TO WS-TAX-RATE-CALC                                
                   MOVE 'Y'                                             
                     TO WS-VERSION-FOUND                                
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF WS-VERSION-FOUND NOT = 'Y'                                
              DISPLAY 'TAX RATE VERSION NOT FOUND ' WS-TAX-COMPARE-KEY  
              DISPLAY 'TAX WORK DATE              ' WS-TEMP-WORK-DATE   
           END-IF.                                                      
                                                                        
       2534A-EXIT.                                                      
             EXIT.                                                      
                                                                        
       2535-PSNC-TAX-CALC .                                             
                                                                        
           MOVE ZERO TO WS-TOT-EXCISE-TAX-AMT                           
                        WS-WORK-UNITS.                                  
                                                                        
           PERFORM VARYING BC-INDX FROM 1 BY 1                          
                                   UNTIL BC-INDX > WS-BC-MAX-ENTRY      
                 OR WS-BC-COMPONENT-ID (BC-INDX) = SPACE                
              IF WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = WS-UNMETERED  
                 PERFORM VARYING WS-CUST-PLAN-INDX FROM 1 BY 1          
                         UNTIL WS-CUST-PLAN-INDX  > WS-CP-MAX-ENTRY     
                         OR WS-ACCOUNT-NO-CP (WS-CUST-PLAN-INDX) = ZERO 
                   IF   WS-ACCOUNT-NO-CP (WS-CUST-PLAN-INDX)            
                               = WS-ACCOUNT-NO-BG (WS-BILLING-INDX)     
                        AND  WS-CODE-UTIL-TYPE-CP (WS-CUST-PLAN-INDX)   
                               =  WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) 
                        AND WS-IC-NO-CP (WS-CUST-PLAN-INDX)             
                               = WS-IC-NO-BG (WS-BILLING-INDX)          
                       IF WS-USAGE-FIXED-CP (WS-CUST-PLAN-INDX ) = 0    
                          COMPUTE WS-WORK-UNITS ROUNDED = WS-WORK-UNITS 
                                 + (WS-BC-FIXED-UM-KWH (BC-INDX)        
                                   * WS-NO-UNITS-CP(WS-CUST-PLAN-INDX)) 
                       ELSE                                             
                             ADD  WS-USAGE-FIXED-CP(WS-CUST-PLAN-INDX ) 
                                  TO WS-WORK-UNITS                      
                       END-IF                                           
                   END-IF                                               
                 END-PERFORM                                            
              ELSE                                                      
                 ADD   WS-BC-NET-UNITS  (BC-INDX) TO WS-WORK-UNITS      
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF WS-WORK-UNITS  > 0                                        
      ** STARTING IN 2007-09, THE EXCISE TAX FOR PSNC CUSTOMERS WHICH           
      ** ARE MANUFACTURERS OR FARMERS WILL BE REDUCED OVER A FOUR YEAR          
      ** PERIOD TO EVENTUALLY MAKE THEM EXCISE TAX EXEMPT. THE ACCOUNTS         
      ** ARE IDENTIFIED BY WS-CODE-STAT-TAX-XMT-BG = 'Z' AND WILL USE           
      ** TAX_CNTRL_NO OF 12 INSTEAD OF 11 FOR REDUCED EXCISE.                   
             IF (WS-COMPANY-NO-AT = '26' AND                            
                 WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX) = 'Z')       
               MOVE 13 TO WS-WORK-TAX-CNTRL-NO                          
               IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) > SPACES       
                 MOVE WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) TO         
                                            WS-TEMP-WORK-DATE           
               ELSE                                                     
PRJ821           MOVE WS-BC-CALC-DATE TO WS-TEMP-WORK-DATE              
               END-IF                                                   
             ELSE                                                       
               MOVE 11 TO WS-WORK-TAX-CNTRL-NO                          
               MOVE WS-REV-MONTH-TEST(1:4) TO WS-TEMP-WORK-DATE (1:4)   
               MOVE '-' TO WS-TEMP-WORK-DATE (5:1)                      
               MOVE WS-REV-MONTH-TEST(5:2) TO WS-TEMP-WORK-DATE (6:2)   
               MOVE '-' TO WS-TEMP-WORK-DATE (8:1)                      
               MOVE '01'                   TO WS-TEMP-WORK-DATE (9:2)   
             END-IF                                                     
             SET X6-INDX TO 1                                           
             MOVE SPACES TO WS-REV-MONTH-FLAG                           
             PERFORM 2537-TEST-REV-MONTH THRU 2537-EXIT                 
                   UNTIL WS-REV-MONTH-FOUND OR                          
                         X6-INDX > WS-TAX-EX-ENTRIES-MAX                
                                                                        
             SET X6-INDX-CORRECT TO 1                                   
             SET X6-INDX         TO 1                                   
             MOVE SPACES TO WS-ENTRIES-FLAG                             
             PERFORM 2538-EXDATA-FOR-REV-MONTH THRU 2538-EXIT           
                    UNTIL  X6-INDX > WS-TAX-EX-ENTRIES-MAX OR           
                           WS-ENTRIES-NOT-FOUND                         
                                                                        
             SET X6-INDX-CORRECT TO 1                                   
             PERFORM  UNTIL  X6-INDX-CORRECT > 9 OR                     
                                      WS-WORK-UNITS <= ZERO             
               IF WS-WORK-UNITS > WS-X6-BLOCK-UNITS-C(X6-INDX-CORRECT)  
                 COMPUTE WS-EXCISE-TAX-AMT ROUNDED =                    
                            WS-X6-BLOCK-UNITS-C(X6-INDX-CORRECT) *      
                            WS-X6-EXCISE-TAX-UNIT-AM-C(X6-INDX-CORRECT) 
                 COMPUTE WS-WORK-UNITS = WS-WORK-UNITS -                
                            WS-X6-BLOCK-UNITS-C(X6-INDX-CORRECT)        
                 ADD WS-EXCISE-TAX-AMT TO WS-TOT-EXCISE-TAX-AMT         
                 SET X6-INDX-CORRECT UP BY 1                            
               ELSE                                                     
                 COMPUTE WS-EXCISE-TAX-AMT ROUNDED =                    
                            WS-WORK-UNITS *                             
                            WS-X6-EXCISE-TAX-UNIT-AM-C(X6-INDX-CORRECT) 
                 COMPUTE WS-WORK-UNITS = WS-WORK-UNITS -                
                            WS-X6-BLOCK-UNITS-C(X6-INDX-CORRECT)        
                 ADD WS-EXCISE-TAX-AMT TO WS-TOT-EXCISE-TAX-AMT         
               END-IF                                                   
             END-PERFORM                                                
           END-IF.                                                      
                                                                        
           MOVE WS-TOT-EXCISE-TAX-AMT  TO                               
                      WS-AMT-STATE-TAX-BG(WS-BILLING-INDX)              
PRJ821                WS-BC-AMT-STATE-TAX-BG.                           
                                                                        
           MOVE 'E' TO WS-STATE-TAX-TYPE-CALC-BG(WS-BILLING-INDX).      
                                                                        
       2535-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2535A-SEB-SALE-TAX-XMPT.                                         
                                                                        
           MOVE ZERO                         TO WS-OLD-LOCAL-TAX-TOT    
                                                WS-NEW-LOCAL-TAX-TOT    
                                                WS-OLD-LOCAL-TAX-PCT    
                                                WS-NEW-LOCAL-TAX-PCT    
                                                WS-NEW-STATE-TAX-PCT    
                                                WS-TEMP-V1-REV-MTH      
                                                WS-TEMP-V2-REV-MTH      
                                                WS-TEMP-V1-END-REV-MTH  
                                                WS-TEMP-V2-END-REV-MTH  
                                                WS-TEMP-INDX.           
                                                                        
      **MOVE TAX-RATE TABLE INDX VALUE TO TEMP-INDX.                            
           SET  WS-TEMP-INDX                 TO TC-INDX.                
                                                                        
      **GET TEMP-WORK-DATE TO COMPARE WITH TAX-EXCISE TABLE FROM DATE           
           MOVE WS-REV-MONTH-TEST(1:4)       TO WS-TEMP-WORK-DATE (1:4).
           MOVE '-'                          TO WS-TEMP-WORK-DATE (5:1).
           MOVE WS-REV-MONTH-TEST(5:2)       TO WS-TEMP-WORK-DATE (6:2).
           MOVE '-'                          TO WS-TEMP-WORK-DATE (8:1).
           MOVE '01'                         TO WS-TEMP-WORK-DATE (9:2).
                                                                        
           MOVE WS-OTHER-TAX                 TO WS-TAX-COMPARE-TYPE.    
                                                                        
           PERFORM VARYING TC-INDX FROM 1 BY 1 UNTIL TC-INDX >          
                           WS-TAX-TABLE-ENTRIES                         
                        OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES         
              IF WS-TC-TAX-ID (TC-INDX)  = WS-TAX-COMPARE-KEY           
                 MOVE ZERO                   TO WS-OLD-LOCAL-TAX-PCT    
                 PERFORM 2534A-GET-TAX-RATE-VERSION THRU 2534A-EXIT     
                 MOVE WS-TAX-RATE-CALC    TO WS-OLD-LOCAL-TAX-PCT       
                                                                        
      **GET THE EXEMPTED PERCENTAGE FOR ALL COUNTIES                            
                 MOVE 1                      TO WS-COUNTY-XMT-PCT       
                 MOVE WS-TC-TAX-CNTRL-NO (TC-INDX)                      
                                             TO WS-TAX-CNTRL-NO         
                                                                        
                 PERFORM 2535C-GET-TAX-EXCISE-AMT THRU 2535C-EXIT       
                                                                        
      **CALCULATE TOTAL EXEMPT TAX PERCENTAGE AT COUNTY LEVEL                   
                 COMPUTE WS-NEW-LOCAL-TAX-PCT ROUNDED                   
                       = WS-OLD-LOCAL-TAX-PCT * WS-COUNTY-XMT-PCT       
                 COMPUTE WS-NEW-LOCAL-TAX-TOT                           
                       = WS-NEW-LOCAL-TAX-TOT + WS-NEW-LOCAL-TAX-PCT    
                 IF WS-TU-CODE-APPL-COND (TC-INDX) NOT                  
                                         = WS-GA-MFG-SALES-TAX-XMT      
                    COMPUTE WS-OLD-LOCAL-TAX-TOT                        
                          = WS-OLD-LOCAL-TAX-TOT + WS-OLD-LOCAL-TAX-PCT 
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
      **GET THE EXEMPT TAX PERCENTAGE FOR STATE                                 
           MOVE 1                            TO WS-STATE-XMT-PCT.       
           MOVE 10                           TO WS-TAX-CNTRL-NO.        
                                                                        
           PERFORM 2535C-GET-TAX-EXCISE-AMT THRU 2535C-EXIT.            
                                                                        
      **CALCULATE NEW STATE TAX RATE AFTER EXEMPTION                            
           COMPUTE WS-OLD-STATE-TAX-PCT                                 
                 = WS-OLD-STATE-TAX-PCT - WS-OLD-LOCAL-TAX-TOT.         
           COMPUTE WS-NEW-STATE-TAX-PCT ROUNDED                         
                 = WS-OLD-STATE-TAX-PCT * WS-STATE-XMT-PCT.             
           COMPUTE WS-STATE-TAX-RATE                                    
                 = WS-NEW-STATE-TAX-PCT + WS-NEW-LOCAL-TAX-TOT.         
                                                                        
      **SET BACK ORIGINAL VALUES TO THE INDEX & COMPARE-TYPE                    
           SET TC-INDX                       TO WS-TEMP-INDX.           
           MOVE 'A'                          TO WS-TAX-COMPARE-TYPE.    
                                                                        
       2535A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       2535C-GET-TAX-EXCISE-AMT.                                        
      ** GET THE EXEMT RATE FOR THE COUNTY & STATE                              
                                                                        
           MOVE WS-NO                        TO WS-TAX-XMT-FOUND        
                                                                        
           PERFORM VARYING X6-INDX FROM 1 BY 1                          
                    UNTIL  X6-INDX > WS-TAX-EX-ENTRIES OR               
                           WS-TAX-XMT-FOUND      = WS-YES               
              IF WS-TEMP-WORK-DATE              >=                      
                 WS-X6-TAX-DATE-FROM (X6-INDX)     AND                  
                 WS-X6-TAX-CNTRL-NO  (X6-INDX)   = WS-TAX-CNTRL-NO      
                 SET TAX-XMT-FOUND           TO TRUE                    
                 IF WS-TAX-CNTRL-NO              = 10                   
                    MOVE WS-X6-EXCISE-TAX-UNIT-AM (X6-INDX)             
                                             TO WS-STATE-XMT-PCT        
                 ELSE                                                   
                    MOVE WS-X6-EXCISE-TAX-UNIT-AM (X6-INDX)             
                                             TO WS-COUNTY-XMT-PCT       
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2535C-EXIT.                                                      
           EXIT.                                                        
                                                                        
                                                                        
       2537-TEST-REV-MONTH .                                            
                                                                        
           MOVE WS-X6-TAX-DATE-FROM(X6-INDX) TO WS-WORK-DATE.           
      ** ADD TAX_CNTRL_NO WHILE PERFORMING THE REV MONTH SEARCH                 
           IF (WS-TEMP-WORK-DATE >= WS-WORK-DATE AND                    
             WS-X6-TAX-CNTRL-NO(X6-INDX) = WS-WORK-TAX-CNTRL-NO)        
              SET WS-REV-MONTH-FOUND TO TRUE                            
           ELSE                                                         
              CONTINUE                                                  
           END-IF.                                                      
                                                                        
           SET X6-INDX  UP BY 1.                                        
                                                                        
       2537-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2538-EXDATA-FOR-REV-MONTH.                                       
           SEARCH WS-TAX-EX-ENTRY                                       
               AT END                                                   
                 MOVE 'NO BLOCK ENTRIES FOUND FOR PSNC'                 
                   TO WS-MISC-MSG-TEXT                                  
                 MOVE +31 TO WS-MISC-MSG-LEN                            
                 MOVE 16 TO RETURN-CODE                                 
                 MOVE 137                TO WS-MISC-WQ-CAT-ID           
                 PERFORM 9910-MISC-ERROR THRU 9910-EXIT                 
               WHEN WS-X6-TAX-DATE-FROM (X6-INDX) = SPACES              
                    SET WS-ENTRIES-NOT-FOUND TO TRUE                    
               WHEN WS-X6-TAX-DATE-FROM (X6-INDX) = WS-WORK-DATE        
                AND WS-X6-TAX-CNTRL-NO (X6-INDX) = WS-WORK-TAX-CNTRL-NO 
                    MOVE WS-X6-BLOCK-NO (X6-INDX) TO                    
                                   WS-X6-BLOCK-NO-C(X6-INDX-CORRECT)    
                    MOVE WS-X6-BLOCK-UNITS (X6-INDX) TO                 
                                 WS-X6-BLOCK-UNITS-C(X6-INDX-CORRECT)   
                    MOVE WS-X6-EXCISE-TAX-UNIT-AM (X6-INDX) TO          
                            WS-X6-EXCISE-TAX-UNIT-AM-C(X6-INDX-CORRECT) 
                       SET X6-INDX-CORRECT UP BY 1                      
           END-SEARCH.                                                  
           SET X6-INDX UP BY 1.                                         
                                                                        
       2538-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2539-SEB-SPCL-TAX-CREDIT.                                        
                                                                        
           IF WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX) > 0             
              MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)            
                            TO WS-TX-CRD-EFF-MONTH                      
           ELSE                                                         
              MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)                
                            TO WS-TX-CRD-EFF-MONTH                      
           END-IF.                                                      
           IF WS-TX-CRD-EFF-MONTH >= 200601                             
              AND WS-BC-CNSMPTN-END-DATE <= '2006-04-30'                
                 PERFORM VARYING BC-INDX FROM 1 BY 1                    
                    UNTIL BC-INDX > WS-BC-MAX-ENTRY                     
                       OR WS-BC-COMPONENT-ID (BC-INDX) = SPACE          
                         ADD WS-BC-CALC-COMPONENT-AMT (BC-INDX)         
                              TO WS-NET-ENERGY-AMT                      
                 END-PERFORM                                            
                 IF WS-NET-ENERGY-AMT > 0                               
                    COMPUTE WS-SEB-TAX-CRD-AMT ROUNDED                  
                       = WS-NET-ENERGY-AMT * WS-SEB-TAX-CRD-RATE        
                 END-IF                                                 
                 IF WS-SEB-TAX-CRD-AMT > 0 AND                          
                    WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)               
                        > WS-SEB-TAX-CRD-AMT                            
                    COMPUTE WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) =     
                       WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)            
                                - WS-SEB-TAX-CRD-AMT                    
                 END-IF                                                 
           ELSE                                                         
              CONTINUE                                                  
           END-IF.                                                      
                                                                        
       2539-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2540-CALCULATE-CITY-TAX.                                         
           MOVE WS-REV-DISTRICT-CD TO WS-TAX-JURISDICTION-CD            
           MOVE 'B' TO WS-TAX-COMPARE-TYPE                              
           PERFORM VARYING TC-INDX FROM 1 BY 1                          
             UNTIL TC-INDX > WS-TAX-TABLE-ENTRIES                       
                OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES                 
              IF WS-TC-TAX-ID (TC-INDX) = WS-TAX-COMPARE-KEY            
                 IF (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'E'       
                        AND WS-TU-ELECT (TC-INDX) = 'Y')                
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'U'  
                            AND WS-UM-SERVICE-TYPE = 'E'                
                            AND WS-TU-ELECT (TC-INDX) = 'Y')            
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'U'  
                            AND WS-UM-SERVICE-TYPE = 'G'                
                            AND WS-TU-GAS (TC-INDX) = 'Y')              
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'G'  
                        AND WS-TU-GAS (TC-INDX) = 'Y')                  
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'W'  
                        AND WS-TU-WATER (TC-INDX) = 'Y')                
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'S'  
                        AND WS-TU-SEWER (TC-INDX) = 'Y')                
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'T'  
                        AND WS-TU-TRASH (TC-INDX) = 'Y')                
                    PERFORM 2544-APPLY-TAX THRU 2544-EXIT               
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
       2540-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2544-APPLY-TAX.                                                  
           IF WS-TU-CALC-INST (TC-INDX) = 'R'                           
              IF WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX) > 0          
                 MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)         
                   TO WS-REV-MONTH-TEST                                 
              ELSE                                                      
                 MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)             
                   TO WS-REV-MONTH-TEST                                 
              END-IF                                                    
                                                                        
              IF WS-REV-MONTH-TEST > 0                                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE LS-CURR-REVENUE-MONTH TO WS-REV-MONTH-TEST        
              END-IF                                                    
                                                                        
              IF RT-REV-MTH-OVRD                                        
                 MOVE WS-RTOV-HLD-REV-MTH   TO WS-REV-MONTH-TEST        
              END-IF                                                    
                                                                        
              MOVE WS-REV-MONTH-TEST(1:4) TO WS-TEMP-WORK-DATE (1:4)    
              MOVE '-'                    TO WS-TEMP-WORK-DATE (5:1)    
              MOVE WS-REV-MONTH-TEST(5:2) TO WS-TEMP-WORK-DATE (6:2)    
              MOVE '-'                    TO WS-TEMP-WORK-DATE (8:1)    
              MOVE '01'                   TO WS-TEMP-WORK-DATE (9:2)    
                                                                        
              PERFORM 2534A-GET-TAX-RATE-VERSION THRU 2534A-EXIT        
                                                                        
              COMPUTE WS-AMT-CITY-TAX-BG (WS-BILLING-INDX) ROUNDED      
                   = WS-CITY-TAXABLE-AMT * WS-TAX-RATE-CALC             
              END-COMPUTE                                               
                                                                        
PRJ821        MOVE WS-AMT-CITY-TAX-BG (WS-BILLING-INDX) TO              
PRJ821             WS-BC-AMT-CITY-TAX-BG                                
              MOVE WS-TAX-RATE-CALC                                     
                   TO WS-FRANCHISE-TX-RATE-CALC (WS-BILLING-INDX)       
PRJ821                BG-CITY-TAX-RATE                                  
           END-IF.                                                      
                                                                        
       2544-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2550-CALCULATE-OTHER-TAX.                                        
           MOVE WS-REV-DISTRICT-CD TO WS-TAX-JURISDICTION-CD            
           MOVE WS-OTHER-TAX TO WS-TAX-COMPARE-TYPE                     
           PERFORM VARYING TC-INDX FROM 1 BY 1                          
             UNTIL TC-INDX > WS-TAX-TABLE-ENTRIES                       
                OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES                 
              IF WS-TC-TAX-ID (TC-INDX) = WS-TAX-COMPARE-KEY            
                 IF (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'E'       
                        AND WS-TU-ELECT (TC-INDX) = 'Y')                
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'U'  
                            AND WS-UM-SERVICE-TYPE = 'E'                
                            AND WS-TU-ELECT (TC-INDX) = 'Y')            
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'U'  
                            AND WS-UM-SERVICE-TYPE = 'G'                
                            AND WS-TU-GAS (TC-INDX) = 'Y')              
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'G'  
                        AND WS-TU-GAS (TC-INDX) = 'Y')                  
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'W'  
                        AND WS-TU-WATER (TC-INDX) = 'Y')                
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'S'  
                        AND WS-TU-SEWER (TC-INDX) = 'Y')                
                      OR (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'T'  
                        AND WS-TU-TRASH (TC-INDX) = 'Y')                
                    PERFORM 2555-APPLY-OTHER-TAX THRU 2555-EXIT         
                    IF WS-AMT-OTHER-TAX > 0                             
                      MOVE WS-TU-FACTOR-ID (TC-INDX) TO WS-TAX-FACTOR-ID
                      PERFORM 5140-CREATE-FCTR-HIST                     
                                              THRU 5140-CPD122-EXIT     
                      ADD WS-AMT-OTHER-TAX                              
                       TO WS-AMT-OTHER-TAX-BG (WS-BILLING-INDX)         
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
       2550-EXIT.                                                       
           EXIT.                                                        
       2555-APPLY-OTHER-TAX.                                            
           IF WS-TU-CALC-INST (TC-INDX) = 'R'                           
                                                                        
              IF WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX) > 0          
                 MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)         
                   TO WS-REV-MONTH-TEST                                 
              ELSE                                                      
                 MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)             
                   TO WS-REV-MONTH-TEST                                 
              END-IF                                                    
                                                                        
              IF WS-REV-MONTH-TEST > 0                                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE LS-CURR-REVENUE-MONTH TO WS-REV-MONTH-TEST        
              END-IF                                                    
                                                                        
              IF RT-REV-MTH-OVRD                                        
                 MOVE WS-RTOV-HLD-REV-MTH   TO WS-REV-MONTH-TEST        
              END-IF                                                    
                                                                        
              MOVE WS-REV-MONTH-TEST(1:4) TO WS-TEMP-WORK-DATE (1:4)    
              MOVE '-'                    TO WS-TEMP-WORK-DATE (5:1)    
              MOVE WS-REV-MONTH-TEST(5:2) TO WS-TEMP-WORK-DATE (6:2)    
              MOVE '-'                    TO WS-TEMP-WORK-DATE (8:1)    
              MOVE '01'                   TO WS-TEMP-WORK-DATE (9:2)    
                                                                        
              PERFORM 2534A-GET-TAX-RATE-VERSION THRU 2534A-EXIT        
                                                                        
              COMPUTE WS-AMT-OTHER-TAX ROUNDED                          
                      = WS-OTHER-TAXABLE-AMT                            
                            * WS-TAX-RATE-CALC                          
              END-COMPUTE                                               
                                                                        
           END-IF.                                                      
                                                                        
       2555-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       3440-LOAD-BILL-MESSAGE.                                          
      *                                                                       49
           PERFORM VARYING WS-MSG-INDX FROM 1 BY 1                      
             UNTIL WS-MSG-INDX > 10                                     
                OR WS-BILL-MESSAGE-NO-CALC (WS-MSG-INDX)                
                      = WS-BILL-MESSAGE                                 
              IF WS-BILL-MESSAGE-NO-CALC (WS-MSG-INDX) <= 0             
                 MOVE WS-BILL-MESSAGE                                   
                     TO WS-BILL-MESSAGE-NO-CALC (WS-MSG-INDX)           
                 MOVE 11 TO WS-MSG-INDX                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                       49
       3440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       4705-GET-OLDEST-REV-MONTH.                                       
            IF WS-FCA00-REV-MONTH (WS-INDEX) =                          
                  WS-PREV-REVENUE-MONTH                                 
                CONTINUE                                                
            ELSE                                                        
                ADD 1 TO WS-REV-COUNT                                   
              IF WS-PREV-REVENUE-MONTH = ZEROES                         
                    MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO                
                         WS-OLDEST-REV-MONTH                            
              END-IF                                                    
              IF WS-FCA00-REV-MONTH (WS-INDEX) <=  WS-PREV-REVENUE-MONTH
                 AND WS-FCA00-REV-MONTH (WS-INDEX) NOT = ZEROES         
                    MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO                
                         WS-OLDEST-REV-MONTH                            
              END-IF                                                    
            END-IF                                                      
            MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO                        
                                          WS-PREV-REVENUE-MONTH.        
            ADD 1                             TO WS-INDEX.              
                                                                        
       4705-EXIT.                                                       
           EXIT.                                                        
      *                                                                 45540000
       4710-LOAD-REVENUE-MONTH.                                         
            IF WS-REV-COUNT = 1                                         
               PERFORM 4720-LOAD-ONE-REVENUE-MONTH THRU 4720-EXIT       
            ELSE                                                        
               IF WS-OFF-CYCLE-FINAL OR WS-OFF-CYCLE-REBILL             
                  SET WS-BILL-CYC-INDX TO 1                             
                  SEARCH WS-FCA00-BILLING-CYCLES                        
                     AT END                                             
                       MOVE WS-OLDEST-REV-MONTH TO                      
                                 WS-REVENUE-MONTH-BG(WS-BILLING-INDX)   
                  WHEN (WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX) EQUAL     
                        WS-REV-MTH-LST-NRML-AT) AND                     
                       (WS-REV-MTH-LST-NRML-AT NOT =  ZERO)             
                        MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX) TO   
                                   WS-REVENUE-MONTH-BG(WS-BILLING-INDX) 
                  END-SEARCH                                            
               ELSE                                                     
                  SET WS-BILL-CYC-INDX TO 1                             
                  SEARCH WS-FCA00-BILLING-CYCLES                        
                     AT END                                             
                     MOVE WS-OLDEST-REV-MONTH  TO                       
                                   WS-REVENUE-MONTH-BG(WS-BILLING-INDX) 
                  WHEN WS-FCA00-BLCYC-NUMBER (WS-BILL-CYC-INDX) EQUAL   
                        WS-BILL-CYCLE-AT                                
                  MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX)  TO        
                                   WS-REVENUE-MONTH-BG(WS-BILLING-INDX) 
                  END-SEARCH                                            
               END-IF                                                   
            END-IF.                                                     
       4710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 45780000
       4720-LOAD-ONE-REVENUE-MONTH.                                     
           SET WS-BILL-CYC-INDX TO 1                                    
           SEARCH WS-FCA00-BILLING-CYCLES                               
              AT END                                                    
                MOVE LS-CURR-REVENUE-MONTH TO                           
                                 WS-REVENUE-MONTH-BG(WS-BILLING-INDX)   
              WHEN WS-FCA00-BLCYC-NUMBER (WS-BILL-CYC-INDX) EQUAL       
                   WS-BILL-CYCLE-AT                                     
                 MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX) TO          
                      WS-REVENUE-MONTH-BG(WS-BILLING-INDX)              
           END-SEARCH.                                                  
       4720-EXIT.                                                       
           EXIT.                                                        
       5100-PROCESS-EXCEPTION.                                          
           IF WS-EXCEPTION-CODE-WQ = WS-WARNING                         
              IF WS-UPDATE-ACTION-IND-BI NOT = WS-INSERT                
                 MOVE WS-UPDATE  TO WS-UPDATE-ACTION-IND-BI             
              END-IF                                                    
              MOVE WS-YES TO WS-WARNING-BILL-IND-BI                     
           ELSE                                                         
              MOVE WS-NO-BILL TO WS-CODE-BILL-STATUS-BI                 
           END-IF                                                       
                                                                        
           MOVE WS-BILL-NO-BG (WS-BILLING-INDX) TO WS-BILL-NO-WQ        
           MOVE WS-PGRMNAME                                             
             TO WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                      
           MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)                  
             TO  WS-CODE-UTIL-TYPE-WQ                                   
           MOVE WS-IC-NO-BG (WS-BILLING-INDX)  TO  WS-IC-NO-WQ          
           MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                    
             TO  WS-RATE-PLAN-NO-WQ                                     
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1                 
           MOVE WS-SUPPLEMENTAL-TXT-WQ                                  
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SUPPLEMENTAL-TXT-LEN-WQ                               
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
      *                                                                         
       5100-CPD122-EXIT.                                                
           EXIT.                                                        
      *                                                                         
       5140-CREATE-FCTR-HIST.                                           
           PERFORM VARYING FH-INDX FROM 1 BY 1                          
             UNTIL FH-INDX > 20                                         
                OR WS-BC-ACCOUNT-NO-FH (FH-INDX) = ZERO                 
           END-PERFORM.                                                 
           IF FH-INDX > 20                                              
              MOVE 'FH TABLE OVERFLOW'                                  
                TO WS-MISC-MSG-TEXT                                     
              MOVE +17 TO WS-MISC-MSG-LEN                               
              MOVE 16 TO RETURN-CODE                                    
              MOVE 137                TO WS-MISC-WQ-CAT-ID              
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
           ELSE                                                         
              MOVE WS-BC-ACCOUNT-NO-BG                                  
                TO WS-BC-ACCOUNT-NO-FH (FH-INDX)                        
              MOVE WS-BC-BILL-NO-BG                                     
                TO WS-BC-BILL-NO-FH (FH-INDX)                           
              MOVE WS-BC-CODE-UTIL-TYPE-BG                              
                TO WS-BC-CODE-UTIL-TYPE-FH (FH-INDX)                    
              MOVE WS-BC-BILL-ITEM-TIMESTMP-BG                          
                TO WS-BC-BILL-ITEM-TIMESTMP-FH (FH-INDX)                
              MOVE WS-BC-IC-NO-BG                                       
                TO WS-BC-IC-NO-FH (FH-INDX)                             
              MOVE 0                                                    
                TO WS-BC-CODE-TIME-PERIOD-FH (FH-INDX)                  
              MOVE WS-BC-CNSMPTN-START-DATE                             
                TO WS-BC-EFF-DATE-FROM-FH (FH-INDX)                     
              MOVE WS-TAX-FACTOR-ID                                     
                TO WS-BC-FACTOR-ID-FH (FH-INDX)                         
              MOVE WS-DEBIT TO WS-BC-CODE-DEBIT-CREDIT-FH (FH-INDX)     
              MOVE WS-BC-COMPONENT-ID (BC-INDX)                         
                TO WS-BC-CMPNT-ID-CD-FH (FH-INDX)                       
              MOVE WS-BC-CODE-SEASON (BC-INDX)                          
                TO WS-BC-CODE-SEASON-FH (FH-INDX)                       
              IF DEMAND-COMPONENT (BC-INDX)                             
                 MOVE 'D' TO WS-BC-INSTR-USE-TYPE-CD-FH (FH-INDX)       
              ELSE                                                      
                 MOVE 'R' TO WS-BC-INSTR-USE-TYPE-CD-FH (FH-INDX)       
              END-IF                                                    
              MOVE WS-BC-CODE-REVENUE-CLASS-BG                          
                TO WS-BC-CODE-REVENUE-CLASS-FH (FH-INDX)                
              MOVE WS-AMT-OTHER-TAX                                     
                TO WS-BC-FACTOR-FH (FH-INDX)                            
              MOVE WS-BC-CNSMPTN-END-DATE                               
                TO WS-BC-EFF-DATE-TO-FH (FH-INDX)                       
              MOVE WS-INSERT                                            
                TO WS-BC-UPDATE-ACTION-IND-FH (FH-INDX)                 
              SET WS-BC-FIXED-FCTR-SEQ-NO-FH (FH-INDX) TO FH-INDX       
           END-IF.                                                      
       5140-CPD122-EXIT.                                                
           EXIT.                                                        
      /                                                                         
       5715-MOVE-BILL-ADJ-DATA.                                         
                                                                        
           MOVE WS-ACCOUNT-NO-BP(WS-ADJUSTMNT-INDEX)                 TO 
                WS-BC-ACCOUNT-NO-BP(WS-BC-ADJUSTMNT-INDEX)              
           MOVE WS-BILL-NO-BP(WS-ADJUSTMNT-INDEX)                    TO 
                WS-BC-BILL-NO-BP(WS-BC-ADJUSTMNT-INDEX)                 
           MOVE WS-CODE-UTIL-TYPE-BP(WS-ADJUSTMNT-INDEX)             TO 
                WS-BC-CODE-UTIL-TYPE-BP(WS-BC-ADJUSTMNT-INDEX)          
           MOVE WS-IC-NO-BP(WS-ADJUSTMNT-INDEX)                      TO 
                WS-BC-IC-NO-BP(WS-BC-ADJUSTMNT-INDEX)                   
           MOVE WS-BILL-ITEM-TIMESTMP-BP(WS-ADJUSTMNT-INDEX)         TO 
                WS-BC-BILL-ITEM-TIMESTMP-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE WS-ADJ-TYPE-CD-BP(WS-ADJUSTMNT-INDEX)                TO 
                WS-BC-ADJ-TYPE-CD-BP(WS-BC-ADJUSTMNT-INDEX)             
           MOVE WS-REVENUE-MONTH-BP(WS-ADJUSTMNT-INDEX)              TO 
                WS-BC-REVENUE-MONTH-BP(WS-BC-ADJUSTMNT-INDEX)           
           MOVE WS-ADJ-REASON-DESC-LEN-BP(WS-ADJUSTMNT-INDEX)        TO 
                WS-BC-ADJ-REASON-DESC-LEN-BP(WS-BC-ADJUSTMNT-INDEX)     
           MOVE WS-ADJ-REASON-DESC-TEXT-BP(WS-ADJUSTMNT-INDEX)(1:3)  TO 
             WS-BC-ADJ-REASON-DESC-TEXT-BP(WS-BC-ADJUSTMNT-INDEX)(1:3)  
           MOVE SPACES                                               TO 
                WS-BC-UPDATE-ACTION-IND-BP(WS-BC-ADJUSTMNT-INDEX)       
           MOVE WS-OVRRIDE-RT-REV-MTH-BP(WS-ADJUSTMNT-INDEX)         TO 
                WS-BC-OVRRIDE-RT-REV-MTH-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE WS-OVRRIDE-RT-BILL-DT-BP(WS-ADJUSTMNT-INDEX)         TO 
                WS-BC-OVRRIDE-RT-BILL-DT-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE WS-OVRRIDE-RT-BILL-CY-BP(WS-ADJUSTMNT-INDEX)         TO 
                WS-BC-OVRRIDE-RT-BILL-CY-BP(WS-BC-ADJUSTMNT-INDEX)      
           IF WS-ADJ-TYPE-CD-BP(WS-ADJUSTMNT-INDEX) > SPACES            
              MOVE 'H' TO WS-CODE-P-BILL-DEST-AT                        
              MOVE 'O' TO WS-CODE-TEMP-BILL-AT                          
           END-IF.                                                      
                                                                        
       5715-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5721-CHECK-DATE-RANGE.                                           
                                                                        
           MOVE SPACES TO WS-DATE-MAX.                                  
                                                                        
           IF WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'E' OR 'G'        
             PERFORM VARYING CX-INDX FROM 1 BY 1                        
                     UNTIL CX-INDX GREATER THAN 200                     
                       OR WS-BC-ACCOUNT-NO-CX (CX-INDX) = ZERO          
              IF WS-BC-BG-KEY-CX (CX-INDX) =                            
                 WS-BILLING-KEY (WS-BILLING-INDX)                       
                 IF (WS-BC-CODE-ITEM-STATUS-CX (CX-INDX)                
                      = WS-ACTIVE OR WS-ACTIVE-LIMITED                  
                        OR WS-SONP)                                     
                    IF WS-BC-DATE-READ-CX(CX-INDX) > WS-DATE-MAX        
                       MOVE WS-BC-DATE-READ-CX(CX-INDX) TO              
                            WS-DATE-MAX                                 
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
             END-PERFORM                                                
           ELSE                                                         
             PERFORM VARYING UC-INDX  FROM 1 BY 1                       
                     UNTIL UC-INDX >                                    
                           WS-UC-MAX-ENTRY                              
                     OR WS-BC-ACCOUNT-NO-UC (UC-INDX) = 0               
               IF WS-BC-BG-KEY-UC (UC-INDX) =                           
                 WS-BILLING-KEY (WS-BILLING-INDX)                       
                 IF (WS-BC-CODE-ITEM-STATUS-UC (UC-INDX)                
                     = WS-ACTIVE OR WS-ACTIVE-LIMITED                   
                       OR WS-SONP)                                      
                   IF  WS-BC-DATE-USAGE-ENDS-UC(UC-INDX) >              
                       WS-DATE-MAX                                      
                     MOVE WS-BC-DATE-USAGE-ENDS-UC(UC-INDX)             
                       TO  WS-DATE-MAX                                  
                   END-IF                                               
                 END-IF                                                 
               END-IF                                                   
             END-PERFORM                                                
           END-IF.                                                      
                                                                        
           IF WS-DATE-MAX = SPACES                                      
              MOVE 'N' TO WS-PROCESS-VALID-FL                           
              GO TO 5721-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE WS-BC-NO-CNSMPTN-DAYS TO WS-NO-DAYS-CNS.                
                                                                        
           MOVE WS-DATE-MAX            TO WS-CNS-END-DATE.              
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, 1, DATEADD( DAY, -:WS-NO-DAYS-CNS, 
              IIF(TRY_CONVERT(DATE, :WS-CNS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CNS-END-DATE
              ) <> 0) OR (LEN(:WS-CNS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CNS-END-DATE
              ), CONVERT(DATE, :WS-CNS-END-DATE) ) ) )
            INTO
              :WS-CNS-START-DATE                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CNS-START-DATE =                                          
MFA-TR*            DATE(:WS-CNS-END-DATE)                                       
MFA-TR*         - :WS-NO-DAYS-CNS DAYS + 1 DAY                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  WS-CNS-START-DATE      <=                                
               WS-PROCESS-START-DATE        AND                         
               WS-CNS-END-DATE        >=                                
               WS-PROCESS-START-DATE                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'N' TO WS-PROCESS-VALID-FL                           
           END-IF.                                                      
                                                                        
       5721-EXIT.                                                       
           EXIT.                                                        
      *                                                                       36
      *5721-CHECK-DATE-RANGE.                                                   
      *                                                                         
      *    MOVE SPACES TO WS-DATE-MAX.                                          
      *                                                                         
      *    IF WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'E' OR 'G'                
      *      PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                        
      *              UNTIL WS-CNSMPTN-INDX GREATER THAN 200                     
      *                OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = ZERO             
      *       IF WS-BILLING-KEY-CX(WS-CNSMPTN-INDX) =                           
      *          WS-BILLING-KEY(WS-BILLING-INDX)                                
      *          IF (WS-CODE-ITEM-STATUS-CX (WS-CNSMPTN-INDX)                   
      *               = WS-ACTIVE OR WS-ACTIVE-LIMITED                          
      *                 OR WS-SONP)                                             
      *             IF WS-DATE-READ-CX(WS-CNSMPTN-INDX) > WS-DATE-MAX           
      *                MOVE WS-DATE-READ-CX(WS-CNSMPTN-INDX) TO                 
      *                     WS-DATE-MAX                                         
      *             END-IF                                                      
      *          END-IF                                                         
      *       END-IF                                                            
      *      END-PERFORM                                                        
      *    ELSE                                                                 
      *      PERFORM VARYING WS-UNMTRD-CNSMPTN-INDX  FROM 1 BY 1                
      *              UNTIL WS-UNMTRD-CNSMPTN-INDX >                             
      *                    WS-UC-MAX-ENTRY                                      
      *              OR WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) = 0           
      *        IF WS-BILLING-KEY-UC(WS-UNMTRD-CNSMPTN-INDX) =                   
      *          WS-BILLING-KEY(WS-BILLING-INDX)                                
      *          IF (WS-CODE-ITEM-STATUS-UC (WS-UNMTRD-CNSMPTN-INDX)            
      *              = WS-ACTIVE OR WS-ACTIVE-LIMITED                           
      *                OR WS-SONP)                                              
      *            IF  WS-DATE-USAGE-ENDS-UC(WS-UNMTRD-CNSMPTN-INDX) >          
      *                WS-DATE-MAX                                              
      *              MOVE WS-DATE-USAGE-ENDS-UC(WS-UNMTRD-CNSMPTN-INDX)         
      *                TO  WS-DATE-MAX                                          
      *            END-IF                                                       
      *          END-IF                                                         
      *        END-IF                                                           
      *      END-PERFORM                                                        
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-DATE-MAX = SPACES                                              
      *       MOVE 'N' TO WS-PROCESS-VALID-FL                                   
      *       GO TO 5721-EXIT                                                   
      *    END-IF.                                                              
      *                                                                         
      *    MOVE WS-BC-NO-CNSMPTN-DAYS TO WS-NO-DAYS-CNS.                        
      *                                                                         
      *    MOVE WS-DATE-MAX            TO WS-CNS-END-DATE.                      
      *    EXEC SQL                                                             
      *       SET :WS-CNS-START-DATE =                                          
      *            DATE(:WS-CNS-END-DATE)                                       
      *         - :WS-NO-DAYS-CNS DAYS + 1 DAY                                  
      *    END-EXEC.                                                            
      *                                                                         
      *    IF  WS-CNS-START-DATE      <=                                        
      *        WS-PROCESS-START-DATE        AND                                 
      *        WS-CNS-END-DATE        >=                                        
      *        WS-PROCESS-START-DATE                                            
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE 'N' TO WS-PROCESS-VALID-FL                                   
      *    END-IF.                                                              
      *                                                                         
      *5721-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                       36
      ******************************************************************36130000
      **  DB2 CALLS                                                   **36140000
      ** SELECTS DELINQUENCY VALUE FOR PSNC RATE DELINQUENCY CODES    **36150000
      ******************************************************************36160000
      *                                                                 36170000
       7100-SELECT-DELINQ-VALUE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     36190000
MFA-TR*       SELECT DELINQ_VALUE                                       36200000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   36210000
MFA-TR*         FROM CSS_DELINQUENCY                                    36220000
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         36230000
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                        36240000
MFA-TR*        WITH UR                                                  36250000
MFA-TR*    END-EXEC.                                                    36260000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36270000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'C8'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT '            TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '105'                TO WS-DB2-MODULE-ID             
              MOVE '7100'               TO WS-DB2-PARAGRAPH             
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-CPD122-EXIT          
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************36130000
      **  DB2 CALLS                                                   **36140000
      ** SELECTS DELINQUENCY VALUE FOR SC SALES TAX HOLIDAY           **36150000
      ******************************************************************36160000
      *                                                                 36170000
       7105-GET-SALES-TAX-DATA.                                         
                                                                        
           IF WS-X9-VAL(1) > 0                                          
              GO TO 7105-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE '01' TO C8-COMPANY-NO.                                  
                                                                        
           PERFORM VARYING X9-INDX FROM 1 BY 1 UNTIL X9-INDX > 2        
              MOVE WS-TAX-HOLIDAY-TBL(X9-INDX) TO C8-DELINQ-CD          
              EXEC SQL                                                  
                 SELECT TOP(1) DELINQ_VALUE                                    
                   INTO :C8-DELINQ-VALUE                                
                   FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                   
                  WHERE DELINQ_CD  = :C8-DELINQ-CD                      
                    AND COMPANY_NO = :C8-COMPANY-NO                     
                  ORDER BY DELINQ_VALUE DESC                            
                                                    
                                                                 
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                  36190000
MFA-TR*          SELECT DELINQ_VALUE                                    36200000
MFA-TR*            INTO :C8-DELINQ-VALUE                                36210000
MFA-TR*            FROM CSS_DELINQUENCY                                 36220000
MFA-TR*           WHERE DELINQ_CD  = :C8-DELINQ-CD                      36230000
MFA-TR*             AND COMPANY_NO = :C8-COMPANY-NO                     36240000
MFA-TR*           ORDER BY DELINQ_VALUE DESC                                    
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*           WITH UR                                               36250000
MFA-TR*       END-EXEC                                                  36260000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE               
              EVALUATE TRUE                                             
              WHEN WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                 MOVE C8-DELINQ-VALUE TO WS-X9-VAL(X9-INDX)             
              WHEN WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                 DISPLAY 'SALES TAX HOLIDAY CODE ' C8-DELINQ-CD         
                 ' NOT FOUND'                                           
                 MOVE 0 TO WS-X9-VAL(X9-INDX)                           
              WHEN OTHER                                                
                 MOVE 'C8'                 TO WS-DB2-TABLE-ID           
                 MOVE 'SELECT '            TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '105'                TO WS-DB2-MODULE-ID          
                 MOVE '7105'               TO WS-DB2-PARAGRAPH          
                 MOVE 16 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-CPD122-EXIT       
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
           MOVE WS-X9-VAL(1)(1:4) TO WS-HLDY-DATE-1(1:4)                
           MOVE '-'               TO WS-HLDY-DATE-1(5:1)                
           MOVE WS-X9-VAL(1)(5:2) TO WS-HLDY-DATE-1(6:2)                
           MOVE '-'               TO WS-HLDY-DATE-1(8:1)                
           MOVE WS-X9-VAL(1)(7:2) TO WS-HLDY-DATE-1(9:2)                
           MOVE WS-X9-DD(1)       TO WS-HOLIDAY-DAYS.                   
           MOVE WS-X9-VAL(2) TO WS-SCE-TAX-CRD-RATE.                    
                                                                        
           DISPLAY 'TAX CREDIT RATE = ' WS-SCE-TAX-CRD-RATE.            
           DISPLAY 'HOLIDAY DAYS = ' WS-HOLIDAY-DAYS.                   
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7110-OPEN-TAX-DATA.                                              
           EXEC SQL                                                     
              OPEN TAX-DATA                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'TC'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN  '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '105'                TO WS-DB2-MODULE-ID             
              MOVE '7110'               TO WS-DB2-PARAGRAPH             
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-CPD122-EXIT          
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7112-FETCH-TAX-DATA.                                             
           EXEC SQL                                                     
              FETCH TAX-DATA                                            
                INTO :TC-TAX-TYPE,                                      
                     :TR-DETAIL-ID,                                     
                     :TR-DATE-FROM,                                     
                     :TR-DATE-TO :WS-NULL-IND,                          
                     :TR-TAX-RATE,                                      
                     :TU-CODE-TAX-CALC-INST,                            
                     :TU-TAX-ELEC,                                      
                     :TU-TAX-GAS,                                       
                     :TU-TAX-MDSE,                                      
                     :TU-TAX-WATER,                                     
                     :TU-TAX-SEWER,                                     
                     :TU-TAX-TRASH,                                     
                     :TC-TAX-CNTRL-NO,                                  
                     :TC-FACTOR-ID                                      
                    ,:TC-CODE-APPL-COND                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
              MOVE 'TC'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '105'                TO WS-DB2-MODULE-ID             
              MOVE '7112'               TO WS-DB2-PARAGRAPH             
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-CPD122-EXIT          
           END-IF.                                                      
                                                                        
       7112-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7114-CLOSE-TAX-DATA.                                             
           EXEC SQL                                                     
              CLOSE TAX-DATA                                            
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7114-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
       7115-OPEN-EX-DATA.                                               
           EXEC SQL                                                     
              OPEN TAX-EXCISE-DATA                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'TC'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN  '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '105'                TO WS-DB2-MODULE-ID             
              MOVE '7115'               TO WS-DB2-PARAGRAPH             
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-CPD122-EXIT          
           END-IF.                                                      
                                                                        
       7115-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7116-FETCH-EX-DATA.                                              
           EXEC SQL                                                     
              FETCH TAX-EXCISE-DATA                                     
                INTO :X6-BLOCK-NO,                                      
                     :X6-BLOCK-UNITS,                                   
                     :X6-DATE-FROM,                                     
                     :X6-TAX-CNTRL-NO,                                  
                     :X6-EXCISE-TAX-UNIT-AM                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
              MOVE 'XX'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '105'                TO WS-DB2-MODULE-ID             
              MOVE '7116'               TO WS-DB2-PARAGRAPH             
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-CPD122-EXIT          
           END-IF.                                                      
                                                                        
       7116-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7117-CLOSE-EX-DATA.                                              
           EXEC SQL                                                     
              CLOSE TAX-EXCISE-DATA                                     
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7117-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ821*                                                                       36
PRJ821******************************************************************36130000
PRJ821** SELECTS TAX JURISDICTION CODE FOR PREMISE                    **36150000
PRJ821******************************************************************36160000
PRJ821*                                                                 36170000
PRJ821 7118-REV-DIST-CODE.                                              
PRJ821                                                                  
PRJ821     EXEC SQL                                                     
PRJ821        SELECT REV_DISTRICT_CD                                    
PRJ821          INTO :WS-REV-DISTRICT-CD                                
PRJ821          FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
PRJ821         WHERE PREMISE_NO = :WS-BC-PREMISE-NO-BG                  
PRJ821                                                           
PRJ821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     36190000
MFA-TR*       SELECT REV_DISTRICT_CD                                    36200000
MFA-TR*         INTO :WS-REV-DISTRICT-CD                                36210000
MFA-TR*         FROM CSS_PREMISE                                        36220000
MFA-TR*        WHERE PREMISE_NO = :WS-BC-PREMISE-NO-BG                  36230000
MFA-TR*        WITH UR                                                  36250000
MFA-TR*    END-EXEC.                                                    36260000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ821*                                                                 36270000
PRJ821     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PRJ821     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ821        CONTINUE                                                  
PRJ821     ELSE                                                         
PRJ821        MOVE 'PR'                 TO WS-DB2-TABLE-ID              
PRJ821        MOVE 'SELECT '            TO WS-DB2-FUNCTION              
PRJ821        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
PRJ821        MOVE '686'                TO WS-DB2-MODULE-ID             
PRJ821        MOVE '7118'               TO WS-DB2-PARAGRAPH             
PRJ821        MOVE 16 TO RETURN-CODE                                    
PRJ821        PERFORM 9900-SQL-ERROR     THRU 9900-CPD122-EXIT          
PRJ821     END-IF.                                                      
PRJ821                                                                  
PRJ821 7118-EXIT.                                                       
PRJ821     EXIT.                                                        
PRJ821                                                                  
       7125-GET-CNSMPTN-START-DATE.                                     
           MOVE WS-BC-CNSMPTN-END-DATE TO WS-DATE-2                     
           MOVE WS-NO-OF-CONS-DAYS-BG (WS-BILLING-INDX)                 
             TO WS-DAYS-AT-CURRENT                                      
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -:WS-DAYS-AT-CURRENT, IIF(TRY_CONVERT(DATE, 
                                                             :WS-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-2) <> 0) OR (LEN(
                                                             :WS-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-2), CONVERT(DATE, 
                                                             :WS-DATE-2
              ) ) )
            INTO
              :WS-DATE-1                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-1 =                                                  
MFA-TR*            DATE(:WS-DATE-2)                                             
MFA-TR*                 - :WS-DAYS-AT-CURRENT DAYS                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'MS'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '105'                TO WS-DB2-MODULE-ID             
              MOVE '7125'               TO WS-DB2-PARAGRAPH             
              MOVE WS-DATE-2            TO WS-DB2-KEY-1                 
              MOVE WS-DAYS-AT-CURRENT   TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-CPD122-EXIT          
           END-IF.                                                      
       7125-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       7140-FIND-SERVICE-TYPE.                                          
                                                                        
           MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX) TO WS-ACCOUNT-NO.    
           MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)                  
                                TO WS-CODE-UTIL-TYPE.                   
           MOVE WS-IC-NO-BG (WS-BILLING-INDX) TO WS-IC-NO.              
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT (CODE_SERVICE_TYPE)                       
                INTO :CP-CODE-SERVICE-TYPE                              
                FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO     = :WS-CPD122-ACCOUNT-NO            
                  AND CODE_UTIL_TYPE = :WS-CPD122-CODE-UTIL-TYPE        
                  AND IC_NO          = :WS-CPD122-IC-NO                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT (CODE_SERVICE_TYPE)                               
MFA-TR*         INTO :CP-CODE-SERVICE-TYPE                                      
MFA-TR*         FROM CSS_CUST_PLAN                                              
MFA-TR*         WHERE ACCOUNT_NO     = :WS-CPD122-ACCOUNT-NO                    
MFA-TR*           AND CODE_UTIL_TYPE = :WS-CPD122-CODE-UTIL-TYPE                
MFA-TR*           AND IC_NO          = :WS-CPD122-IC-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE CP-CODE-SERVICE-TYPE TO WS-UM-SERVICE-TYPE           
           ELSE                                                         
              MOVE 'NO CP FOR UNMETERED BG'                             
                 TO WS-MISC-MSG-TEXT                                    
              MOVE +22 TO WS-MISC-MSG-LEN                               
              MOVE 12 TO RETURN-CODE                                    
              MOVE 17                 TO WS-MISC-WQ-CAT-ID              
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-GET-SPLY-SENSITIVE-IND.                                     
                                                                        
           PERFORM VARYING WS-UTIL-INDX FROM 1 BY 1                     
SCA006       UNTIL WS-UTIL-INDX > 40 OR 
                   WS-ACCOUNT-NO-UT (WS-UTIL-INDX) = 0                          
                IF WS-ACCOUNT-NO-UT (WS-UTIL-INDX)                      
                    = WS-ACCOUNT-NO-BG (WS-BILLING-INDX)                
                   AND WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX)              
                    = WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)            
                   AND WS-IC-NO-UT (WS-UTIL-INDX)                       
                    = WS-IC-NO-BG (WS-BILLING-INDX)                     
                   MOVE WS-SPLY-SENSITIVE-IND-UT (WS-UTIL-INDX)         
                     TO WS-SPLY-SENSITIVE-IND-BG (WS-BILLING-INDX)      
                   MOVE WS-CODE-MTR-READ-FREQ-UT (WS-UTIL-INDX)         
                     TO WS-CODE-MTR-READ-FREQ-BG (WS-BILLING-INDX)      
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7340-GET-FRAN-TX-XMPTN.                                          
           EXEC SQL                                                     
              SELECT 'Y' INTO :WS-FT-XMPT                               
                FROM CSS_FRNCHS_TX_XMPT WITH(READUNCOMMITTED)                   
                WHERE REV_DISTRICT_CD    = :F2-REV-DISTRICT-CD          
                  AND CODE_REVENUE_CLASS = :F2-CODE-REVENUE-CLASS       
                  AND CODE_UTIL_TYPE     = :F2-CODE-UTIL-TYPE           
                  AND COMPANY_NO         = :F2-COMPANY-NO               
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y' INTO :WS-FT-XMPT                                       
MFA-TR*         FROM CSS_FRNCHS_TX_XMPT                                         
MFA-TR*         WHERE REV_DISTRICT_CD    = :F2-REV-DISTRICT-CD                  
MFA-TR*           AND CODE_REVENUE_CLASS = :F2-CODE-REVENUE-CLASS               
MFA-TR*           AND CODE_UTIL_TYPE     = :F2-CODE-UTIL-TYPE                   
MFA-TR*           AND COMPANY_NO         = :F2-COMPANY-NO                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-FT-XMPT                                 
              WHEN OTHER                                                
                 MOVE 'F2'                 TO WS-DB2-TABLE-ID           
                 MOVE 'SELECT'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '105'                TO WS-DB2-MODULE-ID          
                 MOVE '7340'               TO WS-DB2-PARAGRAPH          
                 MOVE F2-REV-DISTRICT-CD   TO WS-DB2-KEY-1              
                 MOVE F2-CODE-REVENUE-CLASS TO WS-DB2-KEY-2             
                 MOVE F2-CODE-UTIL-TYPE     TO WS-DB2-KEY-3             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-CPD122-EXIT       
           END-EVALUATE.                                                
       7340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7342-GET-STATE-TX-XMPTN.                                         
           EXEC SQL                                                     
              SELECT 'Y' INTO :WS-ST-XMPT                               
                FROM CSS_REVENUE_CLASS WITH(READUNCOMMITTED)                    
                WHERE CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS       
                  AND CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE           
                  AND COMPANY_NO         = :F3-COMPANY-NO               
                  AND ST_TAX_XMPT_IND    = 'Y'                          
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y' INTO :WS-ST-XMPT                                       
MFA-TR*         FROM CSS_REVENUE_CLASS                                          
MFA-TR*         WHERE CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS               
MFA-TR*           AND CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE                   
MFA-TR*           AND COMPANY_NO         = :F3-COMPANY-NO                       
MFA-TR*           AND ST_TAX_XMPT_IND    = 'Y'                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-ST-XMPT                                 
              WHEN OTHER                                                
                 MOVE 'F2'                 TO WS-DB2-TABLE-ID           
                 MOVE 'SELECT'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '105'                TO WS-DB2-MODULE-ID          
                 MOVE '7342'               TO WS-DB2-PARAGRAPH          
                 MOVE F3-CODE-REVENUE-CLASS TO WS-DB2-KEY-1             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-CPD122-EXIT       
           END-EVALUATE.                                                
       7342-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *                                                                         
       7690-GET-MANUAL-BILL-TAX-RATES.                                  
      *                                                                         
            EXEC SQL                                                    
                 SELECT TOP(1) NU.BILL_MANUAL_DATA                            
                   INTO :NU-BILL-MANUAL-DATA                            
                   FROM  CSS_BILL_MAN_DET NU WITH(READUNCOMMITTED)              
                  WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO         
                    AND  NU.BILL_NO            = :NU-BILL-NO            
                    AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE     
                    AND  NU.IC_NO              = :NU-IC-NO              
                    AND  NU.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NU-BILL-ITEM-TIMESTMP
              ) 
                    AND  NU.BILL_MANUAL_TBL_ID = :NU-BILL-MANUAL-TBL-ID 
                                                   
                                                                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                    58660000
MFA-TR*          SELECT  NU.BILL_MANUAL_DATA                            58680000
MFA-TR*            INTO :NU-BILL-MANUAL-DATA                            58680000
MFA-TR*            FROM  CSS_BILL_MAN_DET NU                            58690000
MFA-TR*           WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO         58700000
MFA-TR*             AND  NU.BILL_NO            = :NU-BILL-NO            58700000
MFA-TR*             AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE     58700000
MFA-TR*             AND  NU.IC_NO              = :NU-IC-NO              58700000
MFA-TR*             AND  NU.BILL_ITEM_TIMESTMP = :NU-BILL-ITEM-TIMESTMP 58700000
MFA-TR*             AND  NU.BILL_MANUAL_TBL_ID = :NU-BILL-MANUAL-TBL-ID 58700000
MFA-TR*           FETCH  FIRST ROW ONLY                                         
MFA-TR*            WITH  UR                                                     
MFA-TR*     END-EXEC.                                                   58710000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 58920000
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NU'                  TO WS-DB2-TABLE-ID             
              MOVE 'SELECT'              TO WS-DB2-FUNCTION             
              MOVE SQLCODE               TO WS-DB2-RETURN-CODE          
              MOVE '105'                 TO WS-DB2-MODULE-ID            
              MOVE '7690'                TO WS-DB2-PARAGRAPH            
              MOVE NU-ACCOUNT-NO         TO WS-DB2-KEY-1N               
              MOVE NU-CODE-UTIL-TYPE     TO WS-DB2-KEY-2                
              MOVE NU-IC-NO              TO WS-DB2-KEY-3N               
              MOVE NU-BILL-ITEM-TIMESTMP TO WS-DB2-KEY-4                
              MOVE 12                    TO RETURN-CODE                 
              PERFORM 9900-SQL-ERROR        THRU 9900-CPD122-EXIT       
           END-IF.                                                      
      *                                                                 59200000
       7690-EXIT.                                                       
           EXIT.                                                        
      *                                                                 59230000
      **********************************************************                
      ** OPEN EXMT_RATES CURSOR                                                 
      **      TO GET LIST OF EXEMPT RATES FROM STATE TAX                        
      **********************************************************                
       7712-OPEN-EXMT-RATES-LIST.                                       
                                                                        
           EXEC SQL                                                     
              OPEN EXMT_RATES                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'G6'                  TO WS-DB2-TABLE-ID             
              MOVE 'OPEN'                TO WS-DB2-FUNCTION             
              MOVE SQLCODE               TO WS-DB2-RETURN-CODE          
              MOVE '105'                 TO WS-DB2-MODULE-ID            
              MOVE '7712'                TO WS-DB2-PARAGRAPH            
              MOVE 16                    TO RETURN-CODE                 
              PERFORM 9900-SQL-ERROR        THRU 9900-CPD122-EXIT       
           END-IF.                                                      
                                                                        
       7712-EXIT.                                                       
            EXIT.                                                       
                                                                        
      **********************************************************                
      ** FETCH EXMT_RATES CURSOR                                                
      **********************************************************                
       7713-FETCH-EXMT-RATES-LIST.                                      
           EXEC SQL                                                     
              FETCH EXMT_RATES                                          
              INTO :G6-PARM-DATA                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
              MOVE 'G6'                  TO WS-DB2-TABLE-ID             
              MOVE 'FETCH'               TO WS-DB2-FUNCTION             
              MOVE SQLCODE               TO WS-DB2-RETURN-CODE          
              MOVE '105'                 TO WS-DB2-MODULE-ID            
              MOVE '7713'                TO WS-DB2-PARAGRAPH            
              MOVE 16                    TO RETURN-CODE                 
              PERFORM 9900-SQL-ERROR        THRU 9900-CPD122-EXIT       
           END-IF.                                                      
                                                                        
       7713-EXIT.                                                       
            EXIT.                                                       
                                                                        
      **********************************************************                
      ** CLOSE EXMT_RATES CURSOR                                                
      **********************************************************                
       7714-CLOSE-EXMT-RATES-LIST.                                      
           EXEC SQL                                                     
              CLOSE EXMT_RATES                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'G6'                  TO WS-DB2-TABLE-ID             
              MOVE 'CLOSE'               TO WS-DB2-FUNCTION             
              MOVE SQLCODE               TO WS-DB2-RETURN-CODE          
              MOVE '105'                 TO WS-DB2-MODULE-ID            
              MOVE '7714'                TO WS-DB2-PARAGRAPH            
              MOVE 16                    TO RETURN-CODE                 
              PERFORM 9900-SQL-ERROR        THRU 9900-CPD122-EXIT       
           END-IF.                                                      
                                                                        
       7714-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      * TO LOAD THE TIMESTAMP FOR THE CIG CUSTOMERS FOR THE BASE RATE*          
      ****************************************************************          
                                                                        
       8662-GET-BASE-TIME-STAMP.                                        
            EXEC SQL                                                    
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, -1
              , CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) ), 121), 
           ' ', '-'), ':', '.')
            INTO
              :BG-BILL-ITEM-TIMESTMP              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SET :BG-BILL-ITEM-TIMESTMP =                                      
MFA-TR*           TIMESTAMP(:BG-BILL-ITEM-TIMESTMP)                             
MFA-TR*                                    - 1 MICROSECOND                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            IF SQLCODE NOT = SUCCESSFUL-CALL                            
              MOVE 'MD'                       TO WS-DB2-TABLE-ID        
              MOVE 'SELECT'                   TO WS-DB2-FUNCTION        
              MOVE SQLCODE                    TO WS-DB2-RETURN-CODE     
              MOVE '105'                      TO WS-DB2-MODULE-ID       
              MOVE '8662'                     TO WS-DB2-PARAGRAPH       
              MOVE BG-BILL-ITEM-TIMESTMP      TO WS-DB2-KEY-1           
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-CPD122-EXIT          
           END-IF.                                                      
       8662-CPD122-EXIT.                                                
           EXIT.                                                        
       8663-GET-BASE-REVENUE-CLASS.                                     
           EXEC SQL                                                     
              SELECT CODE_REVENUE_CLASS                                 
                INTO :BG-CODE-REVENUE-CLASS                             
              FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                        
              WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO                
                 AND BILL_NO            = :BG-BILL-NO                   
                 AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE            
                 AND IC_NO              = :BG-IC-NO                     
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_REVENUE_CLASS                                         
MFA-TR*         INTO :BG-CODE-REVENUE-CLASS                                     
MFA-TR*       FROM CSS_BILLING_DET                                              
MFA-TR*       WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO                        
MFA-TR*          AND BILL_NO            = :BG-BILL-NO                           
MFA-TR*          AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                    
MFA-TR*          AND IC_NO              = :BG-IC-NO                             
MFA-TR*          AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE  = SUCCESSFUL-CALL OR NOT-FOUND                   
              IF SQLCODE  = SUCCESSFUL-CALL                             
                 MOVE BG-CODE-REVENUE-CLASS   TO WS-BASE-REVENUE-CLASS  
              ELSE                                                      
                 MOVE '000'                   TO WS-BASE-REVENUE-CLASS  
              END-IF                                                    
           END-IF                                                       
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'BG'                    TO WS-DB2-TABLE-ID           
              MOVE 'SELECT'                TO WS-DB2-FUNCTION           
              MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
              MOVE '105'                   TO WS-DB2-MODULE-ID          
              MOVE '8663'                  TO WS-DB2-PARAGRAPH          
              MOVE BG-ACCOUNT-NO           TO WS-DB2-KEY-1              
              MOVE BG-IC-NO                TO WS-DB2-KEY-2              
              MOVE BG-BILL-NO              TO WS-DB2-KEY-3              
              MOVE BG-BILL-ITEM-TIMESTMP   TO WS-DB2-KEY-4              
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR THRU 9900-CPD122-EXIT              
           END-IF.                                                      
       8663-CPD122-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      /*****************************************************************        
      *                                                                *        
      *     CONTROLS ABNORMAL PROGRAM TERMINATION                      *        
      *                                                                *        
      ******************************************************************        
       9900-SQL-ERROR.                                                  
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
                                                                        
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1                 
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
                                                                        
           PERFORM 9999-CPD122-BAIL-OUT THRU 9999-CPD122-EXIT.          
       9900-CPD122-EXIT.                                                
           EXIT.                                                        
      **                                                                        
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
                                                                        
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
                                                                        
              MOVE WS-BILL-NO-BG (WS-BILLING-INDX) TO WS-BILL-NO-WQ     
              MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)               
                TO  WS-CODE-UTIL-TYPE-WQ                                
              MOVE WS-IC-NO-BG (WS-BILLING-INDX)  TO  WS-IC-NO-WQ       
              MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                 
                TO  WS-RATE-PLAN-NO-WQ                                  
                                                                        
              COMPUTE WS-START-POS                                      
                = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1              
              MOVE WS-SUPPLEMENTAL-TXT-WQ                               
                TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX)(WS-START-POS:) 
              ADD WS-SUPPLEMENTAL-TXT-LEN-WQ                            
                TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX)                 
           END-IF.                                                      
                                                                        
           PERFORM 9999-CPD122-BAIL-OUT THRU 9999-CPD122-EXIT.          
       9910-EXIT.                                                       
           EXIT.                                                        
      **                                                                        
       9999-CPD122-BAIL-OUT.                                            
           EXIT PROGRAM.                                                
                                                                        
       9999-CPD122-EXIT.                                                
           EXIT.                                                        
