      *****************************************************************         
      *****************************************************************         
      **  THIS COPYBOOK CAN BE INCLUDED IN ONLINE AND BATCH PROGRAMS **         
      **  TO CALCULATE USAGE HIGH & LOW LIMITS BASED ON HISTORY DATA.**         
      **                                                             **         
      **  INPUT DATA:                                                **         
      **            CWS72-ACCOUNT-NO                                 **         
      **            CWS72-UTIL-TYPE                                  **         
      **            CWS72-IC-NO                                      **         
      **            CWS72-MTR-REF-NO                                 **         
      **            CWS72-TIME-PERIOD                                **         
P00251**            CWS72-CODE-USAGE-ID                              **         
      **            CWS72-RATE-PLAN                                  **         
      **            CWS72-REV-MTH-LST-NRML                           **         
      **            CWS72-ENVIRONMENT (BATCH (B) OR ONLINE (O))      **         
      **                                                             **         
      **  OUTPUT DATA:                                               **         
      **            CWS72-LO-KWH              CWS72-HI-KWH           **         
      **            CWS72-LO-KW               CWS72-HI-KW            **         
      **            CWS72-LO-KVA              CWS72-HI-KVA           **         
      **            CWS72-LO-UNC              CWS72-HI-UNC           **         
      **            CWS72-LO-INT              CWS72-HI-INT           **         
      **            CWS72-LO-UNC-RATIO        CWS72-HI-UNC-RATIO     **         
      **            CWS72-LO-INT-RATIO        CWS72-HI-INT-RATIO     **         
      **            CWS72-LO-MKT-USAGE-PCT    CWS72-HI-MKT-USAGE-PCT **         
      **            CWS72-LO-MKT-DEMAND-PCT   CWS72-HI-MKT-DEMAND-PCT**         
      **            CWS72-LO-POWER-FACTOR     CWS72-HI-POWER-FACTOR  **         
      **            CWS72-LO-LOAD-FACTOR      CWS72-HI-LOAD-FACTOR   **         
      **                                                             **         
      ** IT REQUIRES FOLLOWING COPYBOOKS INCLUDED IN CALLING PROCESS **         
      **        CPDCA072 (PD)          CWS00072 (WS)                 **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              COPYBOOK MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** --------   --------      -----------------------------------**         
      ** 11/23/09   BILLING       NEW CODE                           **         
P00251** 02/15/10   NC94746       NET-METERING RELATED CHANGES       **         
      *****************************************************************         
      *****************************************************************         
      *================================================================*        
       6351-CPD72-HI-LO-MAIN.                                           
      *================================================================*        
      *                                                                         
           PERFORM 6353-CPD72-INITIALIZE THRU 6353-CPD72-EXIT.          
      *                                                                         
           PERFORM 6355-CPD72-VALIDATE   THRU 6355-CPD72-EXIT.          
      *                                                                         
           IF CWS72-REV-MTH-LST-NRML > 0 AND CWS72-NO-ERROR             
              PERFORM 6377-CPD72-GET-CNS-DATA THRU 6377-CPD72-EXIT      
           END-IF                                                       
      *                                                                         
           IF CWS72-NO-ERROR                                            
              PERFORM 6383-CPD72-COMPUTE-REG-PCT THRU 6383-CPD72-EXIT   
           END-IF.                                                      
      *                                                                         
       6351-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6353-CPD72-INITIALIZE.                                           
      *================================================================*        
      *** INITIALIZE ALL OUTPUT VARIABLES WITH DEFAULT VALUES.                  
      *                                                                         
           MOVE ZEROS                TO CWS72-LO-KWH                    
                                        CWS72-LO-KWH-RND                
                                        CWS72-LO-KW                     
                                        CWS72-LO-KVA                    
                                        CWS72-LO-UNC                    
                                        CWS72-LO-UNC-RND                
                                        CWS72-LO-INT                    
                                        CWS72-LO-INT-RND                
                                        CWS72-LO-UNC-RATIO              
                                        CWS72-LO-INT-RATIO.             
           MOVE CWS72-HILO-MAX-LIMIT TO CWS72-HI-KWH                    
                                        CWS72-HI-KWH-RND                
                                        CWS72-HI-KW                     
                                        CWS72-HI-KVA                    
                                        CWS72-HI-UNC                    
                                        CWS72-HI-UNC-RND                
                                        CWS72-HI-INT                    
                                        CWS72-HI-INT-RND.               
           MOVE +99.999              TO CWS72-HI-UNC-RATIO              
                                        CWS72-HI-INT-RATIO.             
      *                                                                         
           MOVE ZEROS                TO CWS72-PREV-MONTH1               
                                        CWS72-PREV-MONTH2               
                                        CWS72-PREV-MONTH3               
                                        CWS72-PREV-MONTH4.              
      *                                                                         
           SET CWS72-NO-CNS-DATA TO TRUE                                
           MOVE SPACES         TO CWS72-ERROR-TYPE                      
      *                                                                         
           MOVE 209912           TO CWS72-RMTH1                         
                                    CWS72-RMTH2                         
                                    CWS72-RMTH3                         
                                    CWS72-RMTH4.                        
      *                                                                         
       6353-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6355-CPD72-VALIDATE.                                             
      *================================================================*        
      *                                                                         
           IF CWS72-ACCOUNT-NO       > 0                                
              AND CWS72-MTR-REF-NO   > 0                                
              AND CWS72-IC-NO        > 0                                
              AND CWS72-UTIL-TYPE    > SPACES                           
              AND CWS72-RATE-PLAN    > SPACES                           
              AND CWS72-REV-MTH-LST-NRML >= 0                           
              AND CWS72-TIME-PERIOD >= 0                                
              CONTINUE                                                  
           ELSE                                                         
              SET CWS72-NON-DB2-ERROR TO TRUE                           
              MOVE 'NOT VALID INPUT DATA'  TO CWS72-ERROR-MESSAGE       
           END-IF.                                                      
      *                                                                         
P00251     IF CWS72-CODE-USAGE-ID > SPACES                              
P00251        CONTINUE                                                  
P00251     ELSE                                                         
P00251        MOVE 'A'                 TO CWS72-CODE-USAGE-ID           
P00251     END-IF                                                       
P00251*                                                                         
           IF CWS72-JOB-PARM-NOT-FETCHED AND CWS72-NO-ERROR             
              PERFORM 6357-CPD72-GET-JOB-PARM THRU 6357-CPD72-EXIT      
           END-IF.                                                      
      *                                                                         
           IF CWS72-BATCH-CALL AND CWS72-NO-ERROR                       
              AND  CWS72-BATCH-TABLE-NOT-BUILT                          
              PERFORM 6359-CPD72-BUILD-BATCH-TABLE                      
                 THRU 6359-CPD72-EXIT                                   
           END-IF.                                                      
      *                                                                         
           IF CWS72-NO-ERROR                                            
              IF CWS72-BATCH-CALL                                       
                 PERFORM 6361-CPD72-GET-HILO-BATCH                      
                    THRU 6361-CPD72-EXIT                                
              ELSE                                                      
                 PERFORM 6371-CPD72-GET-HILO-ONLINE                     
                    THRU 6371-CPD72-EXIT                                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6355-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6357-CPD72-GET-JOB-PARM.                                         
      *================================================================*        
      *                                                                         
           MOVE  CWS72-PGM-CPDCA072        TO WS-PROGRAM.               
           MOVE  WS-PARM                   TO WS-COMMAND.               
           MOVE  ZEROS                     TO WS-SEQUENCE.              
           MOVE  SPACES                    TO WS-SYSIPT.                
           MOVE  WS-KEY-AREA               TO E-FJC01-KEY.              
           MOVE SPACES                   TO CWS72-GAS-FACTORS-SW        
                                            CWS72-ELEC-FACTORS-SW       
                                            CWS72-ADJ-FACTOR-ACTIVE-SW  
           PERFORM 7600-START-FCSJC01        THRU 7600-EXIT.            
           PERFORM 7610-READ-FCSJC01         THRU 7610-EXIT.            
           PERFORM UNTIL END-OF-SYSIPT                                  
              EVALUATE TRUE                                             
                 WHEN WS-INPUT-DATA-BREAKDOWN(1:6) = 'GASR1='           
                      AND INPUT-ACTIVE                                  
                   MOVE G6-PARM-DATA       TO CWS72-GAS-FCTR-DATA       
                   IF CWS72-GAS-RANGE1    IS NUMERIC                    
                      OR CWS72-GAS-RANGE2 IS NUMERIC                    
                      OR CWS72-GAS-LPER1 IS NUMERIC                     
                      OR CWS72-GAS-LPER2 IS NUMERIC                     
                      OR CWS72-GAS-LPER3 IS NUMERIC                     
                      OR CWS72-GAS-HPER1 IS NUMERIC                     
                      OR CWS72-GAS-HPER2 IS NUMERIC                     
                      OR CWS72-GAS-HPER3 IS NUMERIC                     
                      SET CWS72-GAS-FACTORS-PRESENT TO TRUE             
                   END-IF                                               
                 WHEN WS-INPUT-DATA-BREAKDOWN(1:7) = 'ELECR1='          
                      AND INPUT-ACTIVE                                  
                   MOVE G6-PARM-DATA     TO CWS72-ELEC-FCTR-DATA        
                   IF CWS72-ELEC-RANGE1    IS NUMERIC                   
                      OR CWS72-ELEC-RANGE2 IS NUMERIC                   
                      OR CWS72-ELEC-LPER1 IS NUMERIC                    
                      OR CWS72-ELEC-LPER2 IS NUMERIC                    
                      OR CWS72-ELEC-LPER3 IS NUMERIC                    
                      OR CWS72-ELEC-HPER1 IS NUMERIC                    
                      OR CWS72-ELEC-HPER2 IS NUMERIC                    
                      OR CWS72-ELEC-HPER3 IS NUMERIC                    
                      SET CWS72-ELEC-FACTORS-PRESENT TO TRUE            
                   END-IF                                               
                 WHEN OTHER                                             
                    CONTINUE                                            
              END-EVALUATE                                              
              PERFORM 7610-READ-FCSJC01         THRU 7610-EXIT          
           END-PERFORM.                                                 
      *                                                                         
           IF CWS72-ELEC-FACTORS-PRESENT AND CWS72-GAS-FACTORS-PRESENT  
              SET CWS72-ADJ-FCTR-ACTIVE  TO TRUE                        
              SET CWS72-JOB-PARM-FETCHED TO TRUE                        
           ELSE                                                         
              SET CWS72-NON-DB2-ERROR TO TRUE                           
              MOVE 'ELEC & GAS FACTORS NOT PRESENT'                     
                                         TO CWS72-ERROR-MESSAGE         
              MOVE '6357'   TO CWS72-ERROR-PARAGRAPH-NO                 
              MOVE '6357-CPD72-GET-JOB-PARM'                            
                           TO CWS72-ERROR-PARAGRAPH-NAME                
           END-IF.                                                      
      *                                                                         
       6357-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6359-CPD72-BUILD-BATCH-TABLE.                                    
      *================================================================*        
      *                                                                         
           SET CWS72-BATCH-TABLE-BUILT TO TRUE                          
      *                                                                         
           INITIALIZE CWS72-USAGE-TABLE                                 
           PERFORM VARYING CWS72-HL-IDX FROM 1 BY 1                     
             UNTIL CWS72-HL-IDX > 300                                   
              MOVE HIGH-VALUES TO CWS72-HL-TBL-KEY (CWS72-HL-IDX)       
           END-PERFORM                                                  
      *                                                                         
           PERFORM 7861-CPD72-OPEN-HILO    THRU 7861-CPD72-EXIT.        
      *                                                                         
           IF SQLCODE  = ZERO                                           
              PERFORM 7863-CPD72-FETCH-HILO   THRU 7863-CPD72-EXIT      
           END-IF                                                       
      *                                                                         
           IF CWS72-HL-MAX = 300                                        
              SET CWS72-WARNING        TO TRUE                          
              MOVE 'TABLE CSS_RATE_HIGH_LOW HAS >300 ROWS'              
                            TO CWS72-ERROR-MESSAGE                      
              MOVE '6359'   TO CWS72-ERROR-PARAGRAPH-NO                 
              MOVE '6359-CPD72-BUILD-BATCH-TABLE'                       
                           TO CWS72-ERROR-PARAGRAPH-NAME                
           END-IF.                                                      
      *                                                                         
           IF CWS72-HL-MAX = 0                                          
              SET CWS72-NON-DB2-ERROR  TO TRUE                          
              MOVE 'TABLE CSS_RATE_HIGH_LOW HAS ZERO ROWS'              
                            TO CWS72-ERROR-MESSAGE                      
              MOVE '6359'   TO CWS72-ERROR-PARAGRAPH-NO                 
              MOVE '6359-CPD72-BUILD-BATCH-TABLE'                       
                           TO CWS72-ERROR-PARAGRAPH-NAME                
              GO TO 6359-CPD72-EXIT                                     
           END-IF.                                                      
      *                                                                         
           PERFORM 7865-CPD72-CLOSE-HILO   THRU 7865-CPD72-EXIT         
      *                                                                         
           PERFORM 6373-CPD72-LOAD-HILO THRU 6373-CPD72-EXIT            
                   VARYING CWS72-HL-SUB FROM 1 BY 1                     
                  UNTIL CWS72-HL-SUB > CWS72-HL-MAX.                    
      *                                                                         
       6359-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       6361-CPD72-GET-HILO-BATCH.                                       
      *================================================================*        
      *                                                                         
           SEARCH ALL CWS72-HI-LO-TABLE                                 
              AT END                                                    
                 PERFORM 6371-CPD72-GET-HILO-ONLINE                     
                    THRU 6371-CPD72-EXIT                                
              WHEN CWS72-HL-TBL-KEY (CWS72-HL-IDX) EQUAL                
                   CWS72-HI-LO-KEY                                      
                 PERFORM 6375-CPD72-LOAD-HILO-HOST                      
                    THRU 6375-CPD72-EXIT                                
           END-SEARCH.                                                  
      *                                                                         
       6361-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6371-CPD72-GET-HILO-ONLINE.                                      
      *================================================================*        
      *                                                                         
           MOVE CWS72-RATE-PLAN TO O9-RATE-PLAN-NO                      
           MOVE CWS72-UTIL-TYPE TO O9-CODE-UTIL-TYPE                    
      *                                                                         
           PERFORM 7867-CPD72-SELECT-HILO   THRU 7867-CPD72-EXIT        
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
      *                                                                         
             IF O9-PREVIOUS-MONTH1(1:1) = ' '                           
                MOVE '0'                     TO O9-PREVIOUS-MONTH1(1:1) 
             END-IF                                                     
             IF O9-PREVIOUS-MONTH1(2:1) = ' '                           
                MOVE O9-PREVIOUS-MONTH1(1:1) TO O9-PREVIOUS-MONTH1(2:1) 
                MOVE '0'                     TO O9-PREVIOUS-MONTH1(1:1) 
             END-IF                                                     
      *                                                                         
             IF O9-PREVIOUS-MONTH2(1:1) = ' '                           
                MOVE '0'                     TO O9-PREVIOUS-MONTH2(1:1) 
             END-IF                                                     
             IF O9-PREVIOUS-MONTH2(2:1) = ' '                           
                MOVE O9-PREVIOUS-MONTH2(1:1) TO O9-PREVIOUS-MONTH2(2:1) 
                MOVE '0'                     TO O9-PREVIOUS-MONTH2(1:1) 
             END-IF                                                     
      *                                                                         
             IF O9-PREVIOUS-MONTH3(1:1) = ' '                           
                MOVE '0'                     TO O9-PREVIOUS-MONTH3(1:1) 
             END-IF                                                     
             IF O9-PREVIOUS-MONTH3(2:1) = ' '                           
                MOVE O9-PREVIOUS-MONTH3(1:1) TO O9-PREVIOUS-MONTH3(2:1) 
                MOVE '0'                     TO O9-PREVIOUS-MONTH3(1:1) 
             END-IF                                                     
      *                                                                         
             IF O9-PREVIOUS-MONTH4(1:1) = ' '                           
                MOVE '0'                     TO O9-PREVIOUS-MONTH4(1:1) 
             END-IF                                                     
             IF O9-PREVIOUS-MONTH4(2:1) = ' '                           
                MOVE O9-PREVIOUS-MONTH4(1:1) TO O9-PREVIOUS-MONTH4(2:1) 
                MOVE '0'                     TO O9-PREVIOUS-MONTH4(1:1) 
             END-IF                                                     
      *                                                                         
             MOVE O9-PREVIOUS-MONTH1         TO CWS72-PREV-MONTH1       
             MOVE O9-PREVIOUS-MONTH2         TO CWS72-PREV-MONTH2       
             MOVE O9-PREVIOUS-MONTH3         TO CWS72-PREV-MONTH3       
             MOVE O9-PREVIOUS-MONTH4         TO CWS72-PREV-MONTH4       
      *                                                                         
           END-IF.                                                      
      *                                                                         
       6371-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6373-CPD72-LOAD-HILO.                                            
      *================================================================*        
      *                                                                         
           MOVE CWS72-TB-UTIL-TYPE (CWS72-HL-SUB)                       
                        TO CWS72-HL-UTIL-TYPE (CWS72-HL-SUB)            
           MOVE CWS72-TB-RATE-PLAN-NO (CWS72-HL-SUB)                    
                        TO CWS72-HL-RATE-PLAN (CWS72-HL-SUB)            
           MOVE CWS72-TB-USAGE-HPCT (CWS72-HL-SUB)                      
                        TO CWS72-HL-USAGE-HPCT (CWS72-HL-SUB)           
           MOVE CWS72-TB-USAGE-LPCT (CWS72-HL-SUB)                      
                        TO CWS72-HL-USAGE-LPCT (CWS72-HL-SUB)           
           MOVE CWS72-TB-DEMAND-HPCT (CWS72-HL-SUB)                     
                        TO CWS72-HL-DEMAND-HPCT (CWS72-HL-SUB)          
           MOVE CWS72-TB-DEMAND-LPCT (CWS72-HL-SUB)                     
                        TO CWS72-HL-DEMAND-LPCT (CWS72-HL-SUB)          
           MOVE CWS72-TB-IBILL-MIN-KVA (CWS72-HL-SUB)                   
                        TO CWS72-HL-IBILL-MIN-KVA (CWS72-HL-SUB)        
           MOVE CWS72-TB-IBILL-MAX-KVA (CWS72-HL-SUB)                   
                        TO CWS72-HL-IBILL-MAX-KVA (CWS72-HL-SUB)        
           MOVE CWS72-TB-IBILL-MIN-KW   (CWS72-HL-SUB)                  
                        TO CWS72-HL-IBILL-MIN-KW (CWS72-HL-SUB)         
           MOVE CWS72-TB-IBILL-MAX-KW   (CWS72-HL-SUB)                  
                        TO CWS72-HL-IBILL-MAX-KW (CWS72-HL-SUB)         
           MOVE CWS72-TB-IBILL-MIN-KWH (CWS72-HL-SUB)                   
                        TO CWS72-HL-IBILL-MIN-KWH (CWS72-HL-SUB)        
           MOVE CWS72-TB-IBILL-MAX-KWH (CWS72-HL-SUB)                   
                        TO CWS72-HL-IBILL-MAX-KWH (CWS72-HL-SUB)        
           MOVE CWS72-TB-MKT-DEMAND-LPCT (CWS72-HL-SUB)                 
                        TO CWS72-HL-MKT-DEMAND-LPCT (CWS72-HL-SUB)      
           MOVE CWS72-TB-MKT-DEMAND-HPCT (CWS72-HL-SUB)                 
                        TO CWS72-HL-MKT-DEMAND-HPCT (CWS72-HL-SUB)      
           MOVE CWS72-TB-MKT-USAGE-LPCT (CWS72-HL-SUB)                  
                        TO CWS72-HL-MKT-USAGE-LPCT (CWS72-HL-SUB)       
           MOVE CWS72-TB-MKT-USAGE-HPCT (CWS72-HL-SUB)                  
                        TO CWS72-HL-MKT-USAGE-HPCT (CWS72-HL-SUB)       
           MOVE CWS72-TB-MIN-PFACTOR    (CWS72-HL-SUB)                  
                        TO CWS72-HL-MIN-PFACTOR (CWS72-HL-SUB)          
           MOVE CWS72-TB-MAX-PFACTOR    (CWS72-HL-SUB)                  
                        TO CWS72-HL-MAX-PFACTOR (CWS72-HL-SUB)          
           MOVE CWS72-TB-MIN-LFACTOR    (CWS72-HL-SUB)                  
                        TO CWS72-HL-MIN-LFACTOR (CWS72-HL-SUB)          
           MOVE CWS72-TB-MAX-LFACTOR    (CWS72-HL-SUB)                  
                        TO CWS72-HL-MAX-LFACTOR (CWS72-HL-SUB)          
      *                                                                         
           IF CWS72-TB-PREV-MONTH1 (CWS72-HL-SUB)(1:1) = ' '            
              MOVE '0'  TO CWS72-TB-PREV-MONTH1 (CWS72-HL-SUB)(1:1)     
           END-IF                                                       
           IF CWS72-TB-PREV-MONTH1 (CWS72-HL-SUB)(2:1) = ' '            
              MOVE CWS72-TB-PREV-MONTH1 (CWS72-HL-SUB)(1:1)             
                        TO CWS72-TB-PREV-MONTH1 (CWS72-HL-SUB)(2:1)     
              MOVE '0'  TO CWS72-TB-PREV-MONTH1 (CWS72-HL-SUB)(1:1)     
           END-IF                                                       
           MOVE CWS72-TB-PREV-MONTH1 (CWS72-HL-SUB)                     
                      TO CWS72-HL-PREV-MONTH1 (CWS72-HL-SUB)            
      *                                                                         
           IF CWS72-TB-PREV-MONTH2 (CWS72-HL-SUB)(1:1) = ' '            
              MOVE '0'  TO CWS72-TB-PREV-MONTH2 (CWS72-HL-SUB)(1:1)     
           END-IF                                                       
           IF CWS72-TB-PREV-MONTH2 (CWS72-HL-SUB)(2:1) = ' '            
              MOVE CWS72-TB-PREV-MONTH2 (CWS72-HL-SUB)(1:1)             
                        TO CWS72-TB-PREV-MONTH2 (CWS72-HL-SUB)(2:1)     
              MOVE '0'  TO CWS72-TB-PREV-MONTH2 (CWS72-HL-SUB)(1:1)     
           END-IF                                                       
           MOVE CWS72-TB-PREV-MONTH2 (CWS72-HL-SUB)                     
                      TO CWS72-HL-PREV-MONTH2 (CWS72-HL-SUB)            
      *                                                                         
           IF CWS72-TB-PREV-MONTH3 (CWS72-HL-SUB)(1:1) = ' '            
              MOVE '0'  TO CWS72-TB-PREV-MONTH3 (CWS72-HL-SUB)(1:1)     
           END-IF                                                       
           IF CWS72-TB-PREV-MONTH3 (CWS72-HL-SUB)(2:1) = ' '            
              MOVE CWS72-TB-PREV-MONTH3 (CWS72-HL-SUB)(1:1)             
                        TO CWS72-TB-PREV-MONTH3 (CWS72-HL-SUB)(2:1)     
              MOVE '0'  TO CWS72-TB-PREV-MONTH3 (CWS72-HL-SUB)(1:1)     
           END-IF                                                       
           MOVE CWS72-TB-PREV-MONTH3 (CWS72-HL-SUB)                     
                      TO CWS72-HL-PREV-MONTH3 (CWS72-HL-SUB)            
      *                                                                         
           IF CWS72-TB-PREV-MONTH4 (CWS72-HL-SUB)(1:1) = ' '            
              MOVE '0'  TO CWS72-TB-PREV-MONTH4 (CWS72-HL-SUB)(1:1)     
           END-IF                                                       
           IF CWS72-TB-PREV-MONTH4 (CWS72-HL-SUB)(2:1) = ' '            
              MOVE CWS72-TB-PREV-MONTH4 (CWS72-HL-SUB)(1:1)             
                        TO CWS72-TB-PREV-MONTH4 (CWS72-HL-SUB)(2:1)     
              MOVE '0'  TO CWS72-TB-PREV-MONTH4 (CWS72-HL-SUB)(1:1)     
           END-IF                                                       
           MOVE CWS72-TB-PREV-MONTH4 (CWS72-HL-SUB)                     
                      TO CWS72-HL-PREV-MONTH4 (CWS72-HL-SUB).           
      *                                                                         
       6373-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       6375-CPD72-LOAD-HILO-HOST.                                       
      *================================================================*        
      *                                                                         
           MOVE CWS72-HL-UTIL-TYPE   (CWS72-HL-IDX)                     
                                       TO O9-CODE-UTIL-TYPE             
           MOVE CWS72-HL-RATE-PLAN   (CWS72-HL-IDX)                     
                                       TO O9-RATE-PLAN-NO               
           MOVE CWS72-HL-PREV-MONTH1 (CWS72-HL-IDX)                     
                                       TO O9-PREVIOUS-MONTH1            
                                          CWS72-PREV-MONTH1             
           MOVE CWS72-HL-PREV-MONTH2 (CWS72-HL-IDX)                     
                                       TO O9-PREVIOUS-MONTH2            
                                          CWS72-PREV-MONTH2             
           MOVE CWS72-HL-PREV-MONTH3 (CWS72-HL-IDX)                     
                                       TO O9-PREVIOUS-MONTH3            
                                          CWS72-PREV-MONTH3             
           MOVE CWS72-HL-PREV-MONTH4 (CWS72-HL-IDX)                     
                                       TO O9-PREVIOUS-MONTH4            
                                          CWS72-PREV-MONTH4             
           MOVE CWS72-HL-USAGE-HPCT  (CWS72-HL-IDX)                     
                                       TO O9-USAGE-HIGH-PCT             
           MOVE CWS72-HL-USAGE-LPCT  (CWS72-HL-IDX)                     
                                       TO O9-USAGE-LOW-PCT              
           MOVE CWS72-HL-DEMAND-HPCT (CWS72-HL-IDX)                     
                                       TO O9-DEMAND-HIGH-PCT            
           MOVE CWS72-HL-DEMAND-LPCT (CWS72-HL-IDX)                     
                                       TO O9-DEMAND-LOW-PCT             
           MOVE CWS72-HL-IBILL-MIN-KVA (CWS72-HL-IDX)                   
                                       TO O9-INIT-BILL-MIN-KVA          
           MOVE CWS72-HL-IBILL-MAX-KVA (CWS72-HL-IDX)                   
                                       TO O9-INIT-BILL-MAX-KVA          
           MOVE CWS72-HL-IBILL-MIN-KW  (CWS72-HL-IDX)                   
                                       TO O9-INIT-BILL-MIN-KW           
           MOVE CWS72-HL-IBILL-MAX-KW  (CWS72-HL-IDX)                   
                                       TO O9-INIT-BILL-MAX-KW           
           MOVE CWS72-HL-IBILL-MIN-KWH (CWS72-HL-IDX)                   
                                       TO O9-INIT-BILL-MIN-KWH          
           MOVE CWS72-HL-IBILL-MAX-KWH (CWS72-HL-IDX)                   
                                       TO O9-INIT-BILL-MAX-KWH          
           MOVE CWS72-HL-MIN-PFACTOR   (CWS72-HL-IDX)                   
                                       TO O9-MIN-POWER-FACTOR           
           MOVE CWS72-HL-MAX-PFACTOR   (CWS72-HL-IDX)                   
                                       TO O9-MAX-POWER-FACTOR           
           MOVE CWS72-HL-MIN-LFACTOR   (CWS72-HL-IDX)                   
                                       TO O9-MIN-LOAD-FACTOR            
           MOVE CWS72-HL-MAX-LFACTOR   (CWS72-HL-IDX)                   
                                       TO O9-MAX-LOAD-FACTOR            
           MOVE CWS72-HL-MKT-DEMAND-LPCT (CWS72-HL-IDX)                 
                                       TO O9-MKT-DEMAND-LOW-PCT         
           MOVE CWS72-HL-MKT-DEMAND-HPCT (CWS72-HL-IDX)                 
                                       TO O9-MKT-DEMAND-HI-PCT          
           MOVE CWS72-HL-MKT-USAGE-LPCT  (CWS72-HL-IDX)                 
                                       TO O9-MKT-USAGE-LOW-PCT          
           MOVE CWS72-HL-MKT-USAGE-HPCT  (CWS72-HL-IDX)                 
                                       TO O9-MKT-USAGE-HIGH-PCT.        
      *                                                                         
       6375-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6377-CPD72-GET-CNS-DATA.                                         
      *================================================================*        
      *                                                                         
           MOVE CWS72-REV-MTH-LST-NRML TO CWS72-WORK-DATE               
           PERFORM VARYING CWS72-MNTH-SUB   FROM 1 BY 1                 
                   UNTIL CWS72-MNTH-SUB     GREATER THAN 25             
              EVALUATE TRUE                                             
                 WHEN CWS72-PREV-MONTH1 =     CWS72-MNTH-SUB            
                      MOVE CWS72-WORK-DATE TO CWS72-RMTH1               
                 WHEN CWS72-PREV-MONTH2 =     CWS72-MNTH-SUB            
                      MOVE CWS72-WORK-DATE TO CWS72-RMTH2               
                 WHEN CWS72-PREV-MONTH3 =     CWS72-MNTH-SUB            
                      MOVE CWS72-WORK-DATE TO CWS72-RMTH3               
                 WHEN CWS72-PREV-MONTH4 =     CWS72-MNTH-SUB            
                      MOVE CWS72-WORK-DATE TO CWS72-RMTH4               
                 WHEN OTHER                                             
                      CONTINUE                                          
              END-EVALUATE                                              
      *                                                                         
              IF CWS72-WORK-MM = 01                                     
                 MOVE 12 TO CWS72-WORK-MM                               
                 SUBTRACT 1 FROM CWS72-WORK-CCYY                        
              ELSE                                                      
                 SUBTRACT 1 FROM CWS72-WORK-MM                          
              END-IF                                                    
      *                                                                         
           END-PERFORM.                                                 
      *                                                                         
           INITIALIZE CWS72-CONSUMPTION-DATA                            
           MOVE CWS72-ACCOUNT-NO     TO BG-ACCOUNT-NO                   
           MOVE CWS72-RATE-PLAN      TO BG-RATE-PLAN-NO                 
           MOVE CWS72-UTIL-TYPE      TO BG-CODE-UTIL-TYPE               
           MOVE CWS72-IC-NO          TO BG-IC-NO                        
           MOVE CWS72-MTR-REF-NO     TO CX-MTR-REF-NO                   
           MOVE CWS72-TIME-PERIOD    TO CX-CODE-TIME-PERIOD             
P00251     MOVE CWS72-CODE-USAGE-ID  TO CX-CODE-USAGE-ID                
      *                                                                         
           PERFORM 7869-CPD72-OPEN-HIST-CSR THRU 7869-CPD72-EXIT.       
      *                                                                         
           IF SQLCODE = 0                                               
              PERFORM 7871-CPD72-FETCH-HIST-CSR THRU 7871-CPD72-EXIT    
           END-IF                                                       
      *                                                                         
           IF SQLCODE = 0                                               
              PERFORM 6395-CPD72-SET-INIT-MIN-MAX THRU 6395-CPD72-EXIT  
           END-IF                                                       
      *                                                                         
           PERFORM 6379-CPD72-PROCESS-HIST  THRU 6379-CPD72-EXIT        
                UNTIL SQLCODE EQUAL NOT-FOUND OR CWS72-ERROR            
      *                                                                         
           PERFORM 7873-CPD72-CLOSE-HIST-CSR THRU 7873-CPD72-EXIT.      
      *                                                                         
           MOVE SPACES               TO CWS72-ADJ-FACTOR-NEEDED-SW      
           PERFORM VARYING CWS72-MC-IDX FROM 1 BY 1                     
                           UNTIL CWS72-MC-IDX > 4                       
              IF CWS72-MC-DATA-EXISTS (CWS72-MC-IDX) = 'Y'              
                 PERFORM 6381-CPD72-COMP-REG-HILO THRU 6381-CPD72-EXIT  
              ELSE                                                      
                 SET CWS72-ADJ-FCTR-NEEDED TO TRUE                      
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           COMPUTE CWS72-HI-KWH-RND ROUNDED = CWS72-HI-KWH              
           COMPUTE CWS72-LO-KWH-RND ROUNDED = CWS72-LO-KWH.             
           COMPUTE CWS72-HI-UNC-RND ROUNDED = CWS72-HI-UNC.             
           COMPUTE CWS72-LO-UNC-RND ROUNDED = CWS72-LO-UNC.             
           COMPUTE CWS72-HI-INT-RND ROUNDED = CWS72-HI-INT.             
           COMPUTE CWS72-LO-INT-RND ROUNDED = CWS72-LO-INT.             
      *                                                                         
       6377-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6379-CPD72-PROCESS-HIST.                                         
      *================================================================*        
      *                                                                         
           EVALUATE TRUE                                                
              WHEN CWS72-RMTH1 = BG-REVENUE-MONTH                       
                 SET CWS72-MC-IDX TO 1                                  
              WHEN CWS72-RMTH2 = BG-REVENUE-MONTH                       
                 SET CWS72-MC-IDX TO 2                                  
              WHEN CWS72-RMTH3 = BG-REVENUE-MONTH                       
                 SET CWS72-MC-IDX TO 3                                  
              WHEN CWS72-RMTH4 = BG-REVENUE-MONTH                       
                 SET CWS72-MC-IDX TO 4                                  
              WHEN OTHER                                                
                 CONTINUE                                               
           END-EVALUATE.                                                
      *                                                                         
           MOVE 'Y'              TO CWS72-MC-DATA-EXISTS (CWS72-MC-IDX) 
           MOVE BG-REVENUE-MONTH TO CWS72-MC-REV-MONTH (CWS72-MC-IDX)   
           MOVE CX-CONSTANT      TO CWS72-MC-CONSTANT (CWS72-MC-IDX)    
           EVALUATE  CX-CODE-USAGE-TYPE                                 
             WHEN 'B' WHEN 'C'                                          
                COMPUTE CWS72-MC-KWH-CCF-READ(CWS72-MC-IDX) =           
                  CWS72-MC-KWH-CCF-READ(CWS72-MC-IDX) + CX-NO-UNITS     
                COMPUTE CWS72-MC-NO-DAYS-KWH (CWS72-MC-IDX) =           
                  CWS72-MC-NO-DAYS-KWH (CWS72-MC-IDX) + CX-NO-DAYS      
                MOVE CX-CONSTANT TO CWS72-MC-CONSTANT (CWS72-MC-IDX)    
             WHEN 'J'                                                   
               IF CX-NO-DEMAND-UNITS > CWS72-MC-KW-READ (CWS72-MC-IDX)  
                  MOVE CX-NO-DEMAND-UNITS                               
                     TO CWS72-MC-KW-READ (CWS72-MC-IDX)                 
               END-IF                                                   
             WHEN 'E'                                                   
               IF CX-NO-DEMAND-UNITS > CWS72-MC-KVA-READ (CWS72-MC-IDX) 
                  MOVE CX-NO-DEMAND-UNITS                               
                    TO CWS72-MC-KVA-READ (CWS72-MC-IDX)                 
               END-IF                                                   
             WHEN 'U'                                                   
               COMPUTE CWS72-MC-UNC-READ (CWS72-MC-IDX) =               
                       CWS72-MC-UNC-READ (CWS72-MC-IDX) + CX-NO-UNITS   
                COMPUTE CWS72-MC-NO-DAYS-UNC (CWS72-MC-IDX) =           
                  CWS72-MC-NO-DAYS-UNC (CWS72-MC-IDX) + CX-NO-DAYS      
             WHEN 'I'                                                   
               COMPUTE CWS72-MC-INT-READ (CWS72-MC-IDX) =               
                       CWS72-MC-INT-READ (CWS72-MC-IDX) + CX-NO-UNITS   
                COMPUTE CWS72-MC-NO-DAYS-INT (CWS72-MC-IDX) =           
                  CWS72-MC-NO-DAYS-INT (CWS72-MC-IDX) + CX-NO-DAYS      
           END-EVALUATE.                                                
                                                                        
           PERFORM 7871-CPD72-FETCH-HIST-CSR THRU 7871-CPD72-EXIT.      
      *                                                                         
       6379-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6381-CPD72-COMP-REG-HILO.                                        
      *================================================================*        
      *                                                                         
           IF CWS72-MC-NO-DAYS-KWH (CWS72-MC-IDX) < 1                   
              MOVE 1        TO CWS72-MC-NO-DAYS-KWH (CWS72-MC-IDX)      
           END-IF.                                                      
           IF CWS72-MC-CONSTANT (CWS72-MC-IDX) < 1                      
              MOVE 1        TO CWS72-MC-CONSTANT (CWS72-MC-IDX)         
           END-IF.                                                      
           IF CWS72-MC-KWH-CCF-READ (CWS72-MC-IDX) > 0                  
              COMPUTE CWS72-MC-KWH-CCF-READ (CWS72-MC-IDX) ROUNDED      
                 = CWS72-MC-KWH-CCF-READ (CWS72-MC-IDX)                 
                   / CWS72-MC-NO-DAYS-KWH (CWS72-MC-IDX)                
           END-IF                                                       
           IF CWS72-MC-UNC-READ (CWS72-MC-IDX) > 0                      
              IF CWS72-MC-NO-DAYS-UNC (CWS72-MC-IDX) < 1                
                 MOVE 1   TO  CWS72-MC-NO-DAYS-UNC (CWS72-MC-IDX)       
              END-IF                                                    
              COMPUTE CWS72-MC-UNC-READ (CWS72-MC-IDX) ROUNDED          
               = CWS72-MC-UNC-READ (CWS72-MC-IDX)                       
                  / CWS72-MC-NO-DAYS-UNC (CWS72-MC-IDX)                 
              IF CWS72-MC-UNC-READ (CWS72-MC-IDX) > 0                   
                 COMPUTE CWS72-MC-UNC-RATIO (CWS72-MC-IDX) ROUNDED      
                  = (CWS72-MC-KWH-CCF-READ (CWS72-MC-IDX)               
                    / CWS72-MC-UNC-READ (CWS72-MC-IDX)) * 1.000         
              ELSE                                                      
                 MOVE ZEROS   TO CWS72-MC-UNC-RATIO (CWS72-MC-IDX)      
              END-IF                                                    
           END-IF                                                       
           IF CWS72-MC-INT-READ (CWS72-MC-IDX) > 0                      
              IF CWS72-MC-NO-DAYS-INT (CWS72-MC-IDX) < 1                
                 MOVE 1   TO  CWS72-MC-NO-DAYS-INT (CWS72-MC-IDX)       
              END-IF                                                    
              COMPUTE CWS72-MC-INT-READ (CWS72-MC-IDX) ROUNDED          
                 = CWS72-MC-INT-READ (CWS72-MC-IDX)                     
                   / CWS72-MC-NO-DAYS-INT (CWS72-MC-IDX)                
              IF CWS72-MC-INT-READ (CWS72-MC-IDX) > 0                   
                 COMPUTE CWS72-MC-INT-RATIO (CWS72-MC-IDX) ROUNDED      
                  = (CWS72-MC-KWH-CCF-READ (CWS72-MC-IDX)               
                    / CWS72-MC-INT-READ (CWS72-MC-IDX)) * 1.000         
              ELSE                                                      
                 MOVE ZEROS   TO CWS72-MC-INT-RATIO (CWS72-MC-IDX)      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF CWS72-MC-KWH-CCF-READ (CWS72-MC-IDX) < CWS72-LO-KWH       
              MOVE CWS72-MC-KWH-CCF-READ (CWS72-MC-IDX) TO CWS72-LO-KWH 
           END-IF.                                                      
           IF CWS72-MC-KWH-CCF-READ (CWS72-MC-IDX) > CWS72-HI-KWH       
              MOVE CWS72-MC-KWH-CCF-READ (CWS72-MC-IDX) TO CWS72-HI-KWH 
           END-IF.                                                      
           IF CWS72-MC-KW-READ (CWS72-MC-IDX) < CWS72-LO-KW             
              MOVE CWS72-MC-KW-READ (CWS72-MC-IDX) TO CWS72-LO-KW       
           END-IF.                                                      
           IF CWS72-MC-KW-READ (CWS72-MC-IDX) > CWS72-HI-KW             
              MOVE CWS72-MC-KW-READ (CWS72-MC-IDX) TO CWS72-HI-KW       
           END-IF.                                                      
           IF CWS72-MC-KVA-READ (CWS72-MC-IDX) < CWS72-LO-KVA           
              MOVE CWS72-MC-KVA-READ (CWS72-MC-IDX) TO CWS72-LO-KVA     
           END-IF.                                                      
           IF CWS72-MC-KVA-READ (CWS72-MC-IDX) > CWS72-HI-KVA           
              MOVE CWS72-MC-KVA-READ (CWS72-MC-IDX) TO CWS72-HI-KVA     
           END-IF.                                                      
           IF CWS72-MC-UNC-READ (CWS72-MC-IDX) < CWS72-LO-UNC           
              MOVE CWS72-MC-UNC-READ (CWS72-MC-IDX) TO CWS72-LO-UNC     
           END-IF.                                                      
           IF CWS72-MC-UNC-READ (CWS72-MC-IDX) > CWS72-HI-UNC           
              MOVE CWS72-MC-UNC-READ (CWS72-MC-IDX) TO CWS72-HI-UNC     
           END-IF.                                                      
           IF CWS72-MC-INT-READ (CWS72-MC-IDX) < CWS72-LO-INT           
              MOVE CWS72-MC-INT-READ (CWS72-MC-IDX) TO CWS72-LO-INT     
           END-IF.                                                      
           IF CWS72-MC-INT-READ (CWS72-MC-IDX) > CWS72-HI-INT           
              MOVE CWS72-MC-INT-READ (CWS72-MC-IDX) TO CWS72-HI-INT     
           END-IF.                                                      
           IF CWS72-MC-UNC-RATIO (CWS72-MC-IDX) < CWS72-LO-UNC-RATIO    
              MOVE CWS72-MC-UNC-RATIO(CWS72-MC-IDX)                     
                                         TO CWS72-LO-UNC-RATIO          
           END-IF.                                                      
           IF CWS72-MC-UNC-RATIO (CWS72-MC-IDX) > CWS72-HI-UNC-RATIO    
              MOVE CWS72-MC-UNC-RATIO(CWS72-MC-IDX)                     
                                         TO CWS72-HI-UNC-RATIO          
           END-IF.                                                      
           IF CWS72-MC-INT-RATIO (CWS72-MC-IDX) < CWS72-LO-INT-RATIO    
              MOVE CWS72-MC-INT-RATIO(CWS72-MC-IDX)                     
                                         TO CWS72-LO-INT-RATIO          
           END-IF.                                                      
           IF CWS72-MC-INT-RATIO (CWS72-MC-IDX) > CWS72-HI-INT-RATIO    
              MOVE CWS72-MC-INT-RATIO(CWS72-MC-IDX)                     
                                         TO CWS72-HI-INT-RATIO          
           END-IF.                                                      
      *                                                                         
       6381-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6383-CPD72-COMPUTE-REG-PCT.                                      
      *================================================================*        
      *                                                                         
           EVALUATE TRUE                                                
              WHEN CWS72-CNS-DATA-FOUND                                 
                   AND CWS72-ADJ-FCTR-NEEDED                            
                 PERFORM 6385-CPD72-SEL-FACTOR-PARMS                    
                    THRU 6385-CPD72-EXIT                                
                 PERFORM 6387-CPD72-REG-WITH-ADJ                        
                    THRU 6387-CPD72-EXIT                                
              WHEN CWS72-CNS-DATA-FOUND                                 
                 PERFORM 6389-CPD72-REG-WITH-HILO                       
                    THRU 6389-CPD72-EXIT                                
              WHEN OTHER                                                
                 CONTINUE                                               
           END-EVALUATE.                                                
      *                                                                         
           IF CWS72-UTIL-TYPE EQUAL 'E'                                 
              IF CWS72-HI-KWH <= 4.0                                    
                 MOVE 12.0               TO CWS72-HI-KWH                
                 MOVE  0.0               TO CWS72-LO-KWH                
              END-IF                                                    
              IF CWS72-LO-KWH < 5                                       
                 MOVE 0 TO CWS72-LO-KWH                                 
              END-IF                                                    
           ELSE                                                         
              IF CWS72-HI-KWH <= 3.0                                    
                 MOVE  3.0               TO CWS72-HI-KWH                
              END-IF                                                    
              IF CWS72-LO-KWH < 4                                       
                 MOVE 0 TO CWS72-LO-KWH                                 
              END-IF                                                    
              IF CWS72-HI-UNC <= 3.0                                    
                 MOVE  3.0            TO CWS72-HI-UNC                   
              END-IF                                                    
              IF CWS72-LO-UNC < 4                                       
                 MOVE 0 TO CWS72-LO-UNC                                 
              END-IF                                                    
              IF CWS72-HI-INT <= 3.0                                    
                 MOVE  3.0            TO CWS72-HI-INT                   
              END-IF                                                    
              IF CWS72-LO-INT < 4                                       
                 MOVE 0 TO CWS72-LO-INT                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 6391-CPD72-COMP-MISSING-REG THRU 6391-CPD72-EXIT.    
      *                                                                         
           MOVE O9-MIN-POWER-FACTOR TO CWS72-LO-POWER-FACTOR            
           MOVE O9-MAX-POWER-FACTOR TO CWS72-HI-POWER-FACTOR            
           MOVE O9-MIN-LOAD-FACTOR  TO CWS72-LO-LOAD-FACTOR             
           MOVE O9-MAX-LOAD-FACTOR  TO CWS72-HI-LOAD-FACTOR             
           MOVE O9-MKT-DEMAND-LOW-PCT TO CWS72-LO-MKT-DEMAND-PCT        
           MOVE O9-MKT-DEMAND-HI-PCT  TO CWS72-HI-MKT-DEMAND-PCT        
           MOVE O9-MKT-USAGE-LOW-PCT  TO CWS72-LO-MKT-USAGE-PCT         
           MOVE O9-MKT-USAGE-HIGH-PCT TO CWS72-HI-MKT-USAGE-PCT.        
      *                                                                         
       6383-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6385-CPD72-SEL-FACTOR-PARMS.                                     
      *================================================================*        
      *                                                                         
           IF CWS72-UTIL-TYPE = 'E'                                     
              IF CWS72-HI-KWH-RND < CWS72-ELEC-RANGE1                   
                 MOVE CWS72-ELEC-HPER1   TO CWS72-HI-FCTR-PARM          
              ELSE                                                      
                 IF CWS72-HI-KWH-RND > CWS72-ELEC-RANGE2                
                    MOVE CWS72-ELEC-HPER3 TO CWS72-HI-FCTR-PARM         
                 ELSE                                                   
                    MOVE CWS72-ELEC-HPER2 TO CWS72-HI-FCTR-PARM         
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              IF CWS72-LO-KWH-RND < CWS72-ELEC-RANGE1                   
                 MOVE CWS72-ELEC-LPER1   TO CWS72-LO-FCTR-PARM          
              ELSE                                                      
                 IF CWS72-LO-KWH-RND > CWS72-ELEC-RANGE2                
                    MOVE CWS72-ELEC-LPER3 TO CWS72-LO-FCTR-PARM         
                 ELSE                                                   
                    MOVE CWS72-ELEC-LPER2 TO CWS72-LO-FCTR-PARM         
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF CWS72-HI-KWH-RND < CWS72-GAS-RANGE1                    
                 MOVE CWS72-GAS-HPER1    TO CWS72-HI-FCTR-PARM          
              ELSE                                                      
                 IF CWS72-HI-KWH-RND > CWS72-GAS-RANGE2                 
                    MOVE CWS72-GAS-HPER3 TO CWS72-HI-FCTR-PARM          
                 ELSE                                                   
                    MOVE CWS72-GAS-HPER2 TO CWS72-HI-FCTR-PARM          
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              IF CWS72-LO-KWH-RND < CWS72-GAS-RANGE1                    
                 MOVE CWS72-GAS-LPER1    TO CWS72-LO-FCTR-PARM          
              ELSE                                                      
                 IF CWS72-LO-KWH-RND > CWS72-GAS-RANGE2                 
                    MOVE CWS72-GAS-LPER3 TO CWS72-LO-FCTR-PARM          
                 ELSE                                                   
                    MOVE CWS72-GAS-LPER2 TO CWS72-LO-FCTR-PARM          
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6385-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       6387-CPD72-REG-WITH-ADJ.                                         
      *================================================================*        
      *                                                                         
           COMPUTE CWS72-HI-KWH-RND ROUNDED =                           
                    CWS72-HI-KWH-RND * (CWS72-HI-FCTR-PARM / 100)       
           MOVE CWS72-HI-KWH-RND         TO CWS72-HI-KWH                
      *                                                                         
           COMPUTE CWS72-LO-KWH-RND ROUNDED =                           
                    CWS72-LO-KWH-RND * (CWS72-LO-FCTR-PARM / 100)       
           MOVE CWS72-LO-KWH-RND         TO CWS72-LO-KWH                
      *                                                                         
           IF CWS72-HI-KW = 0                                           
              MOVE CWS72-HILO-MAX-LIMIT  TO CWS72-HI-KW                 
              MOVE ZEROS                 TO CWS72-LO-KW                 
           ELSE                                                         
              COMPUTE CWS72-HI-KW ROUNDED = CWS72-HI-KW *               
                      (CWS72-HI-FCTR-PARM / 100)                        
              COMPUTE CWS72-LO-KW ROUNDED = CWS72-LO-KW *               
                      (CWS72-LO-FCTR-PARM / 100)                        
           END-IF.                                                      
      *                                                                         
           IF CWS72-HI-KVA = 0                                          
              MOVE CWS72-HILO-MAX-LIMIT  TO CWS72-HI-KVA                
              MOVE ZEROS                 TO CWS72-LO-KVA                
           ELSE                                                         
              COMPUTE CWS72-HI-KVA ROUNDED = CWS72-HI-KVA *             
                      (CWS72-HI-FCTR-PARM / 100)                        
              COMPUTE CWS72-LO-KVA ROUNDED = CWS72-LO-KVA *             
                      (CWS72-LO-FCTR-PARM / 100)                        
           END-IF.                                                      
      *                                                                         
           IF CWS72-HI-UNC = 0                                          
              MOVE CWS72-HILO-MAX-LIMIT  TO CWS72-HI-UNC                
              MOVE ZEROS                 TO CWS72-LO-UNC                
           ELSE                                                         
              COMPUTE CWS72-HI-UNC-RND ROUNDED = CWS72-HI-UNC-RND *     
                         (CWS72-HI-FCTR-PARM / 100)                     
              MOVE CWS72-HI-UNC-RND   TO CWS72-HI-UNC                   
      *                                                                         
              COMPUTE CWS72-LO-UNC-RND ROUNDED = CWS72-LO-UNC-RND *     
                         (CWS72-LO-FCTR-PARM / 100)                     
              MOVE CWS72-LO-UNC-RND   TO CWS72-LO-UNC                   
           END-IF                                                       
      *                                                                         
           IF CWS72-HI-INT = 0                                          
              MOVE CWS72-HILO-MAX-LIMIT  TO CWS72-HI-INT                
              MOVE ZEROS                 TO CWS72-LO-INT                
           ELSE                                                         
              COMPUTE CWS72-HI-INT-RND ROUNDED = CWS72-HI-INT-RND *     
                         (CWS72-HI-FCTR-PARM / 100)                     
              MOVE CWS72-HI-INT-RND   TO CWS72-HI-INT                   
      *                                                                         
              COMPUTE CWS72-LO-INT-RND ROUNDED = CWS72-LO-INT-RND *     
                         (CWS72-LO-FCTR-PARM / 100)                     
              MOVE CWS72-LO-INT-RND   TO CWS72-LO-INT                   
           END-IF.                                                      
      *                                                                         
       6387-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6389-CPD72-REG-WITH-HILO.                                        
      *================================================================*        
      *                                                                         
           IF O9-USAGE-HIGH-PCT > 0                                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE +1    TO  O9-USAGE-HIGH-PCT                          
           END-IF.                                                      
           IF O9-USAGE-LOW-PCT > 0                                      
              CONTINUE                                                  
           ELSE                                                         
              MOVE +1     TO  O9-USAGE-LOW-PCT                          
           END-IF.                                                      
           IF O9-DEMAND-HIGH-PCT > 0                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE +1    TO   O9-DEMAND-HIGH-PCT                        
           END-IF.                                                      
           IF O9-DEMAND-LOW-PCT > 0                                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE +1   TO   O9-DEMAND-LOW-PCT                          
           END-IF.                                                      
      *                                                                         
           COMPUTE CWS72-HI-KWH-RND ROUNDED = CWS72-HI-KWH-RND *        
                   O9-USAGE-HIGH-PCT                                    
           MOVE CWS72-HI-KWH-RND        TO CWS72-HI-KWH                 
      *                                                                         
           COMPUTE CWS72-LO-KWH-RND ROUNDED = CWS72-LO-KWH-RND *        
                   O9-USAGE-LOW-PCT                                     
           MOVE CWS72-LO-KWH-RND      TO CWS72-LO-KWH                   
      *                                                                         
           IF CWS72-HI-KW = 0                                           
              MOVE CWS72-HILO-MAX-LIMIT  TO CWS72-HI-KW                 
              MOVE ZEROS                 TO CWS72-LO-KW                 
           ELSE                                                         
              COMPUTE CWS72-HI-KW ROUNDED = CWS72-HI-KW *               
                      O9-DEMAND-HIGH-PCT                                
      *                                                                         
              COMPUTE CWS72-LO-KW ROUNDED = CWS72-LO-KW *               
                      O9-DEMAND-LOW-PCT                                 
           END-IF                                                       
      *                                                                         
           IF CWS72-HI-KVA = 0                                          
              MOVE CWS72-HILO-MAX-LIMIT  TO CWS72-HI-KVA                
              MOVE ZEROS                 TO CWS72-LO-KVA                
           ELSE                                                         
              COMPUTE CWS72-HI-KVA ROUNDED = CWS72-HI-KVA *             
                      O9-DEMAND-HIGH-PCT                                
              COMPUTE CWS72-LO-KVA ROUNDED = CWS72-LO-KVA *             
                      O9-DEMAND-LOW-PCT                                 
           END-IF                                                       
      *                                                                         
           IF CWS72-HI-UNC = 0                                          
              MOVE CWS72-HILO-MAX-LIMIT  TO CWS72-HI-UNC                
              MOVE ZEROS                 TO CWS72-LO-UNC                
           ELSE                                                         
              COMPUTE CWS72-HI-UNC-RND ROUNDED = CWS72-HI-UNC-RND *     
                      O9-USAGE-HIGH-PCT                                 
              MOVE CWS72-HI-UNC-RND   TO CWS72-HI-UNC                   
      *                                                                         
              COMPUTE CWS72-LO-UNC-RND ROUNDED = CWS72-LO-UNC-RND *     
                      O9-USAGE-LOW-PCT                                  
              MOVE CWS72-LO-UNC-RND   TO CWS72-LO-UNC                   
           END-IF                                                       
      *                                                                         
           IF CWS72-HI-INT = 0                                          
              MOVE CWS72-HILO-MAX-LIMIT  TO CWS72-HI-INT                
              MOVE ZEROS                 TO CWS72-LO-INT                
           ELSE                                                         
              COMPUTE CWS72-HI-INT-RND ROUNDED = CWS72-HI-INT-RND *     
                      O9-USAGE-HIGH-PCT                                 
              MOVE CWS72-HI-INT-RND   TO CWS72-HI-INT                   
      *                                                                         
              COMPUTE CWS72-LO-INT-RND ROUNDED = CWS72-LO-INT-RND *     
                      O9-USAGE-LOW-PCT                                  
              MOVE CWS72-LO-INT-RND   TO CWS72-LO-INT                   
           END-IF.                                                      
      *                                                                         
       6389-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6391-CPD72-COMP-MISSING-REG.                                     
      *================================================================*        
      *                                                                         
            IF CWS72-HI-KWH = CWS72-HILO-MAX-LIMIT                      
               OR CWS72-HI-KWH = ZEROS                                  
               IF O9-INIT-BILL-MAX-KWH > 0                              
                  MOVE O9-INIT-BILL-MAX-KWH TO CWS72-HI-KWH             
                  MOVE O9-INIT-BILL-MIN-KWH TO CWS72-LO-KWH             
               ELSE                                                     
                  MOVE CWS72-HILO-MAX-LIMIT TO CWS72-HI-KWH             
                  MOVE ZEROS                TO CWS72-LO-KWH             
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
            IF CWS72-HI-UNC = CWS72-HILO-MAX-LIMIT                      
               OR CWS72-HI-UNC = ZEROS                                  
               IF O9-INIT-BILL-MAX-KWH > 0                              
                  MOVE O9-INIT-BILL-MAX-KWH TO CWS72-HI-UNC             
                  MOVE O9-INIT-BILL-MIN-KWH TO CWS72-LO-UNC             
               ELSE                                                     
                  MOVE CWS72-HILO-MAX-LIMIT TO CWS72-HI-UNC             
                  MOVE ZEROS                TO CWS72-LO-UNC             
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
            IF CWS72-HI-INT = CWS72-HILO-MAX-LIMIT                      
               OR CWS72-HI-INT = ZEROS                                  
               IF O9-INIT-BILL-MAX-KWH > 0                              
                  MOVE O9-INIT-BILL-MAX-KWH TO CWS72-HI-INT             
                  MOVE O9-INIT-BILL-MIN-KWH TO CWS72-LO-INT             
               ELSE                                                     
                  MOVE CWS72-HILO-MAX-LIMIT TO CWS72-HI-INT             
                  MOVE ZEROS                TO CWS72-LO-INT             
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
            IF CWS72-HI-KW  = CWS72-HILO-MAX-LIMIT                      
               OR CWS72-HI-KW  = ZEROS                                  
               IF O9-INIT-BILL-MAX-KW  > 0                              
                  MOVE O9-INIT-BILL-MAX-KW  TO CWS72-HI-KW              
                  MOVE O9-INIT-BILL-MIN-KW  TO CWS72-LO-KW              
               ELSE                                                     
                  MOVE CWS72-HILO-MAX-LIMIT TO CWS72-HI-KW              
                  MOVE ZEROS                TO CWS72-LO-KW              
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
            IF CWS72-HI-KVA = CWS72-HILO-MAX-LIMIT                      
               OR CWS72-HI-KVA = ZEROS                                  
               IF O9-INIT-BILL-MAX-KVA > 0                              
                  MOVE O9-INIT-BILL-MAX-KVA TO CWS72-HI-KVA             
                  MOVE O9-INIT-BILL-MIN-KVA TO CWS72-LO-KVA             
               ELSE                                                     
                  MOVE CWS72-HILO-MAX-LIMIT TO CWS72-HI-KVA             
                  MOVE ZEROS                TO CWS72-LO-KVA             
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
           IF CWS72-HI-UNC-RATIO = +99.999                              
              OR CWS72-HI-UNC-RATIO = ZEROS                             
              MOVE +99.999        TO CWS72-HI-UNC-RATIO                 
              MOVE ZEROS          TO CWS72-LO-UNC-RATIO                 
           ELSE                                                         
      **** UNC RATIO +-20% (PER SCOTT SWINDLER)                                 
               COMPUTE CWS72-HI-UNC-RATIO ROUNDED                       
                                = CWS72-HI-UNC-RATIO * 1.20             
               COMPUTE CWS72-LO-UNC-RATIO ROUNDED                       
                                = CWS72-LO-UNC-RATIO * 0.80             
           END-IF.                                                      
      *                                                                         
           IF CWS72-HI-INT-RATIO = +99.999                              
              OR CWS72-HI-INT-RATIO  = 0                                
              MOVE +99.999        TO CWS72-HI-INT-RATIO                 
              MOVE ZEROS          TO CWS72-LO-INT-RATIO                 
           ELSE                                                         
      **** INT RATIO +-20% (PER SCOTT SWINDLER)                                 
              COMPUTE CWS72-HI-INT-RATIO ROUNDED                        
                                = CWS72-HI-INT-RATIO * 1.20             
              COMPUTE CWS72-LO-INT-RATIO ROUNDED                        
                                = CWS72-LO-INT-RATIO * 0.80             
           END-IF.                                                      
      *                                                                         
       6391-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       6395-CPD72-SET-INIT-MIN-MAX.                                     
      *================================================================*        
      *** SET ALL HIGH LIMITS TO ZEROS AND LOW LIMITS TO ALL 9'S.               
      *                                                                         
           SET CWS72-CNS-DATA-FOUND TO TRUE                             
           MOVE CWS72-HILO-MAX-LIMIT TO CWS72-LO-KWH                    
                                        CWS72-LO-KW                     
                                        CWS72-LO-KVA                    
                                        CWS72-LO-UNC                    
                                        CWS72-LO-INT.                   
           MOVE +99.999              TO CWS72-LO-UNC-RATIO              
                                        CWS72-LO-INT-RATIO.             
           MOVE ZEROS                TO CWS72-HI-KWH                    
                                        CWS72-HI-KW                     
                                        CWS72-HI-KVA                    
                                        CWS72-HI-UNC                    
                                        CWS72-HI-INT                    
                                        CWS72-HI-UNC-RATIO              
                                        CWS72-HI-INT-RATIO.             
      *                                                                         
       6395-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7861-CPD72-OPEN-HILO.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN CWS72_HI_LO_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT = ZERO                                        
              SET CWS72-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR IN OPEN CWS72_HI_LO_CSR'                      
                            TO CWS72-ERROR-MESSAGE                      
              MOVE SQLCODE TO CWS72-ERROR-SQLCODE                       
              MOVE 'OPEN'  TO CWS72-ERROR-FUNCTION                      
              MOVE '7861'   TO CWS72-ERROR-PARAGRAPH-NO                 
              MOVE '7861-CPD72-OPEN-HILO'                               
                           TO CWS72-ERROR-PARAGRAPH-NAME                
              MOVE 'CSS_RATE_HIGH_LOW' TO CWS72-ERROR-TABLE1            
           END-IF.                                                      
      *                                                                         
       7861-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7863-CPD72-FETCH-HILO.                                           

MSQ008     MOVE 300 TO MSQ008-CWS72-HI-LO-CSR
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FOR :MSQ008-CWS72-HI-LO-CSR
              FETCH 
              FROM CWS72_HI_LO_CSR       
                INTO :CWS72-TB-UTIL-TYPE                                
                    ,:CWS72-TB-RATE-PLAN-NO                             
                    ,:CWS72-TB-PREV-MONTH1                              
                    ,:CWS72-TB-PREV-MONTH2                              
                    ,:CWS72-TB-PREV-MONTH3                              
                    ,:CWS72-TB-PREV-MONTH4                              
                    ,:CWS72-TB-USAGE-HPCT                               
                    ,:CWS72-TB-USAGE-LPCT                               
                    ,:CWS72-TB-DEMAND-HPCT                              
                    ,:CWS72-TB-DEMAND-LPCT                              
                    ,:CWS72-TB-IBILL-MIN-KVA                            
                    ,:CWS72-TB-IBILL-MAX-KVA                            
                    ,:CWS72-TB-IBILL-MIN-KW                             
                    ,:CWS72-TB-IBILL-MAX-KW                             
                    ,:CWS72-TB-IBILL-MIN-KWH                            
                    ,:CWS72-TB-IBILL-MAX-KWH                            
                    ,:CWS72-TB-MIN-PFACTOR                              
                    ,:CWS72-TB-MAX-PFACTOR                              
                    ,:CWS72-TB-MIN-LFACTOR                              
                    ,:CWS72-TB-MAX-LFACTOR                              
                    ,:CWS72-TB-MKT-DEMAND-LPCT                          
                    ,:CWS72-TB-MKT-DEMAND-HPCT                          
                    ,:CWS72-TB-MKT-USAGE-LPCT                           
                    ,:CWS72-TB-MKT-USAGE-HPCT                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM CWS72_HI_LO_CSR FOR 300 ROWS              
MFA-TR*         INTO :CWS72-TB-UTIL-TYPE                                        
MFA-TR*             ,:CWS72-TB-RATE-PLAN-NO                                     
MFA-TR*             ,:CWS72-TB-PREV-MONTH1                                      
MFA-TR*             ,:CWS72-TB-PREV-MONTH2                                      
MFA-TR*             ,:CWS72-TB-PREV-MONTH3                                      
MFA-TR*             ,:CWS72-TB-PREV-MONTH4                                      
MFA-TR*             ,:CWS72-TB-USAGE-HPCT                                       
MFA-TR*             ,:CWS72-TB-USAGE-LPCT                                       
MFA-TR*             ,:CWS72-TB-DEMAND-HPCT                                      
MFA-TR*             ,:CWS72-TB-DEMAND-LPCT                                      
MFA-TR*             ,:CWS72-TB-IBILL-MIN-KVA                                    
MFA-TR*             ,:CWS72-TB-IBILL-MAX-KVA                                    
MFA-TR*             ,:CWS72-TB-IBILL-MIN-KW                                     
MFA-TR*             ,:CWS72-TB-IBILL-MAX-KW                                     
MFA-TR*             ,:CWS72-TB-IBILL-MIN-KWH                                    
MFA-TR*             ,:CWS72-TB-IBILL-MAX-KWH                                    
MFA-TR*             ,:CWS72-TB-MIN-PFACTOR                                      
MFA-TR*             ,:CWS72-TB-MAX-PFACTOR                                      
MFA-TR*             ,:CWS72-TB-MIN-LFACTOR                                      
MFA-TR*             ,:CWS72-TB-MAX-LFACTOR                                      
MFA-TR*             ,:CWS72-TB-MKT-DEMAND-LPCT                                  
MFA-TR*             ,:CWS72-TB-MKT-DEMAND-HPCT                                  
MFA-TR*             ,:CWS72-TB-MKT-USAGE-LPCT                                   
MFA-TR*             ,:CWS72-TB-MKT-USAGE-HPCT                                   
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-CWS72-HI-LO-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              MOVE SQLERRD(3)              TO CWS72-HL-MAX              
           ELSE                                                         
              SET CWS72-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR IN FETCH CWS72_HI_LO_CSR'                     
                            TO CWS72-ERROR-MESSAGE                      
              MOVE SQLCODE TO CWS72-ERROR-SQLCODE                       
              MOVE 'FETCH'  TO CWS72-ERROR-FUNCTION                     
              MOVE '7863'   TO CWS72-ERROR-PARAGRAPH-NO                 
              MOVE '7863-CPD72-FETCH-HILO'                              
                           TO CWS72-ERROR-PARAGRAPH-NAME                
              MOVE 'CSS_RATE_HIGH_LOW' TO CWS72-ERROR-TABLE1            
           END-IF.                                                      
      *                                                                         
       7863-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7865-CPD72-CLOSE-HILO.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE CWS72_HI_LO_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT = ZERO                                        
              SET CWS72-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR IN CLOSE CWS72_HI_LO_CSR'                     
                            TO CWS72-ERROR-MESSAGE                      
              MOVE SQLCODE TO CWS72-ERROR-SQLCODE                       
              MOVE 'CLOSE'  TO CWS72-ERROR-FUNCTION                     
              MOVE '7865'   TO CWS72-ERROR-PARAGRAPH-NO                 
              MOVE '7865-CPD72-CLOSE-HILO'                              
                           TO CWS72-ERROR-PARAGRAPH-NAME                
              MOVE 'CSS_RATE_HIGH_LOW' TO CWS72-ERROR-TABLE1            
           END-IF.                                                      
      *                                                                         
       7865-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7867-CPD72-SELECT-HILO.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT PREVIOUS_MONTH1                                    
                    ,PREVIOUS_MONTH2                                    
                    ,PREVIOUS_MONTH3                                    
                    ,PREVIOUS_MONTH4                                    
                    ,USAGE_HIGH_PCT                                     
                    ,USAGE_LOW_PCT                                      
                    ,DEMAND_HIGH_PCT                                    
                    ,DEMAND_LOW_PCT                                     
                    ,INIT_BILL_MIN_KVA                                  
                    ,INIT_BILL_MAX_KVA                                  
                    ,INIT_BILL_MIN_KW                                   
                    ,INIT_BILL_MAX_KW                                   
                    ,INIT_BILL_MIN_KWH                                  
                    ,INIT_BILL_MAX_KWH                                  
                    ,MIN_POWER_FACTOR                                   
                    ,MAX_POWER_FACTOR                                   
                    ,MIN_LOAD_FACTOR                                    
                    ,MAX_LOAD_FACTOR                                    
                    ,MKT_DEMAND_LOW_PCT                                 
                    ,MKT_DEMAND_HI_PCT                                  
                    ,MKT_USAGE_LOW_PCT                                  
                    ,MKT_USAGE_HIGH_PCT                                 
                INTO :O9-PREVIOUS-MONTH1                                
                    ,:O9-PREVIOUS-MONTH2                                
                    ,:O9-PREVIOUS-MONTH3                                
                    ,:O9-PREVIOUS-MONTH4                                
                    ,:O9-USAGE-HIGH-PCT                                 
                    ,:O9-USAGE-LOW-PCT                                  
                    ,:O9-DEMAND-HIGH-PCT                                
                    ,:O9-DEMAND-LOW-PCT                                 
                    ,:O9-INIT-BILL-MIN-KVA                              
                    ,:O9-INIT-BILL-MAX-KVA                              
                    ,:O9-INIT-BILL-MIN-KW                               
                    ,:O9-INIT-BILL-MAX-KW                               
                    ,:O9-INIT-BILL-MIN-KWH                              
                    ,:O9-INIT-BILL-MAX-KWH                              
                    ,:O9-MIN-POWER-FACTOR                               
                    ,:O9-MAX-POWER-FACTOR                               
                    ,:O9-MIN-LOAD-FACTOR                                
                    ,:O9-MAX-LOAD-FACTOR                                
                    ,:O9-MKT-DEMAND-LOW-PCT                             
                    ,:O9-MKT-DEMAND-HI-PCT                              
                    ,:O9-MKT-USAGE-LOW-PCT                              
                    ,:O9-MKT-USAGE-HIGH-PCT                             
              FROM CSS_RATE_HIGH_LOW WITH(READUNCOMMITTED)                      
              WHERE RATE_PLAN_NO = :O9-RATE-PLAN-NO                     
                AND CODE_UTIL_TYPE = :O9-CODE-UTIL-TYPE                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREVIOUS_MONTH1                                            
MFA-TR*             ,PREVIOUS_MONTH2                                            
MFA-TR*             ,PREVIOUS_MONTH3                                            
MFA-TR*             ,PREVIOUS_MONTH4                                            
MFA-TR*             ,USAGE_HIGH_PCT                                             
MFA-TR*             ,USAGE_LOW_PCT                                              
MFA-TR*             ,DEMAND_HIGH_PCT                                            
MFA-TR*             ,DEMAND_LOW_PCT                                             
MFA-TR*             ,INIT_BILL_MIN_KVA                                          
MFA-TR*             ,INIT_BILL_MAX_KVA                                          
MFA-TR*             ,INIT_BILL_MIN_KW                                           
MFA-TR*             ,INIT_BILL_MAX_KW                                           
MFA-TR*             ,INIT_BILL_MIN_KWH                                          
MFA-TR*             ,INIT_BILL_MAX_KWH                                          
MFA-TR*             ,MIN_POWER_FACTOR                                           
MFA-TR*             ,MAX_POWER_FACTOR                                           
MFA-TR*             ,MIN_LOAD_FACTOR                                            
MFA-TR*             ,MAX_LOAD_FACTOR                                            
MFA-TR*             ,MKT_DEMAND_LOW_PCT                                         
MFA-TR*             ,MKT_DEMAND_HI_PCT                                          
MFA-TR*             ,MKT_USAGE_LOW_PCT                                          
MFA-TR*             ,MKT_USAGE_HIGH_PCT                                         
MFA-TR*         INTO :O9-PREVIOUS-MONTH1                                        
MFA-TR*             ,:O9-PREVIOUS-MONTH2                                        
MFA-TR*             ,:O9-PREVIOUS-MONTH3                                        
MFA-TR*             ,:O9-PREVIOUS-MONTH4                                        
MFA-TR*             ,:O9-USAGE-HIGH-PCT                                         
MFA-TR*             ,:O9-USAGE-LOW-PCT                                          
MFA-TR*             ,:O9-DEMAND-HIGH-PCT                                        
MFA-TR*             ,:O9-DEMAND-LOW-PCT                                         
MFA-TR*             ,:O9-INIT-BILL-MIN-KVA                                      
MFA-TR*             ,:O9-INIT-BILL-MAX-KVA                                      
MFA-TR*             ,:O9-INIT-BILL-MIN-KW                                       
MFA-TR*             ,:O9-INIT-BILL-MAX-KW                                       
MFA-TR*             ,:O9-INIT-BILL-MIN-KWH                                      
MFA-TR*             ,:O9-INIT-BILL-MAX-KWH                                      
MFA-TR*             ,:O9-MIN-POWER-FACTOR                                       
MFA-TR*             ,:O9-MAX-POWER-FACTOR                                       
MFA-TR*             ,:O9-MIN-LOAD-FACTOR                                        
MFA-TR*             ,:O9-MAX-LOAD-FACTOR                                        
MFA-TR*             ,:O9-MKT-DEMAND-LOW-PCT                                     
MFA-TR*             ,:O9-MKT-DEMAND-HI-PCT                                      
MFA-TR*             ,:O9-MKT-USAGE-LOW-PCT                                      
MFA-TR*             ,:O9-MKT-USAGE-HIGH-PCT                                     
MFA-TR*       FROM CSS_RATE_HIGH_LOW                                            
MFA-TR*       WHERE RATE_PLAN_NO = :O9-RATE-PLAN-NO                             
MFA-TR*         AND CODE_UTIL_TYPE = :O9-CODE-UTIL-TYPE                         
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              SET CWS72-DB2-ERROR  TO TRUE                              
              IF SQLCODE = NOT-FOUND                                    
                 MOVE 'RATE NOT IN HIGH LOW TABLE'                      
                                      TO CWS72-ERROR-MESSAGE            
              ELSE                                                      
                 MOVE 'ERROR IN SELECT CSS_RATE_HIGH_LOW'               
                                      TO CWS72-ERROR-MESSAGE            
              END-IF                                                    
              MOVE SQLCODE TO CWS72-ERROR-SQLCODE                       
              MOVE 'SELECT'  TO CWS72-ERROR-FUNCTION                    
              MOVE '7867'   TO CWS72-ERROR-PARAGRAPH-NO                 
              MOVE '7867-CPD72-SELECT-HILO'                             
                           TO CWS72-ERROR-PARAGRAPH-NAME                
              MOVE 'CSS_RATE_HIGH_LOW' TO CWS72-ERROR-TABLE1            
              MOVE 'RATE_PLAN_NO'      TO CWS72-ERROR-TAB-COLUMN-1      
              MOVE 'CODE_UTIL_TYPE'    TO CWS72-ERROR-TAB-COLUMN-2      
              MOVE O9-RATE-PLAN-NO     TO CWS72-ERROR-HOSTVAR-1         
              MOVE O9-CODE-UTIL-TYPE   TO CWS72-ERROR-HOSTVAR-2         
           END-IF.                                                      
      *                                                                         
       7867-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7869-CPD72-OPEN-HIST-CSR.                                        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN CWS72_HIST_CSR                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT = ZERO                                        
              SET CWS72-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR IN OPEN CWS72_HIST_CSR'                       
                            TO CWS72-ERROR-MESSAGE                      
              MOVE SQLCODE TO CWS72-ERROR-SQLCODE                       
              MOVE 'OPEN'  TO CWS72-ERROR-FUNCTION                      
              MOVE '7869'   TO CWS72-ERROR-PARAGRAPH-NO                 
              MOVE '7869-CPD72-OPEN-HIST-CSR'                           
                           TO CWS72-ERROR-PARAGRAPH-NAME                
              MOVE 'CSS_BILLING_DET' TO CWS72-ERROR-TABLE1              
              MOVE 'CSS_CNSMPTN_HIST'  TO CWS72-ERROR-TABLE2            
              MOVE 'ACCOUNT_NO'        TO CWS72-ERROR-TAB-COLUMN-1      
              MOVE 'CODE_UTIL_TYPE'    TO CWS72-ERROR-TAB-COLUMN-2      
              MOVE 'IC_NO         '    TO CWS72-ERROR-TAB-COLUMN-3      
              MOVE 'MTR_REF_NO   '     TO CWS72-ERROR-TAB-COLUMN-4      
              MOVE BG-ACCOUNT-NO       TO CWS72-ERROR-HOSTVAR-1         
              MOVE BG-CODE-UTIL-TYPE   TO CWS72-ERROR-HOSTVAR-2         
              MOVE BG-IC-NO            TO CWS72-ERROR-HOSTVAR-3         
              MOVE CX-MTR-REF-NO       TO CWS72-ERROR-HOSTVAR-4         
           END-IF.                                                      
      *                                                                         
       7869-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7871-CPD72-FETCH-HIST-CSR.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH CWS72_HIST_CSR                                     
                INTO :BG-REVENUE-MONTH                                  
                    ,:CX-NO-UNITS                                       
                    ,:CX-NO-DEMAND-UNITS                                
                    ,:CX-CONSTANT                                       
                    ,:CX-CODE-USAGE-TYPE                                
                    ,:CX-CODE-TOU-SEASN                                 
                    ,:CX-NO-DAYS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
              CONTINUE                                                  
           ELSE                                                         
              SET CWS72-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR IN FETCH CWS72_HIST_CSR'                      
                            TO CWS72-ERROR-MESSAGE                      
              MOVE SQLCODE TO CWS72-ERROR-SQLCODE                       
              MOVE 'FETCH'  TO CWS72-ERROR-FUNCTION                     
              MOVE '7871'   TO CWS72-ERROR-PARAGRAPH-NO                 
              MOVE '7871-CPD72-FETCH-HIST-CSR'                          
                           TO CWS72-ERROR-PARAGRAPH-NAME                
              MOVE 'CSS_BILLING_DET' TO CWS72-ERROR-TABLE1              
              MOVE 'CSS_CNSMPTN_HIST'  TO CWS72-ERROR-TABLE2            
              MOVE 'ACCOUNT_NO'        TO CWS72-ERROR-TAB-COLUMN-1      
              MOVE 'CODE_UTIL_TYPE'    TO CWS72-ERROR-TAB-COLUMN-2      
              MOVE 'IC_NO         '    TO CWS72-ERROR-TAB-COLUMN-3      
              MOVE 'MTR_REF_NO   '     TO CWS72-ERROR-TAB-COLUMN-4      
              MOVE BG-ACCOUNT-NO       TO CWS72-ERROR-HOSTVAR-1         
              MOVE BG-CODE-UTIL-TYPE   TO CWS72-ERROR-HOSTVAR-2         
              MOVE BG-IC-NO            TO CWS72-ERROR-HOSTVAR-3         
              MOVE CX-MTR-REF-NO       TO CWS72-ERROR-HOSTVAR-4         
           END-IF.                                                      
      *                                                                         
       7871-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7873-CPD72-CLOSE-HIST-CSR.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE CWS72_HIST_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT = ZERO                                        
              SET CWS72-DB2-ERROR  TO TRUE                              
              MOVE 'ERROR IN CLOSE CWS72_HIST_CSR'                      
                            TO CWS72-ERROR-MESSAGE                      
              MOVE SQLCODE TO CWS72-ERROR-SQLCODE                       
              MOVE 'CLOSE'  TO CWS72-ERROR-FUNCTION                     
              MOVE '7873'   TO CWS72-ERROR-PARAGRAPH-NO                 
              MOVE '7873-CPD72-CLOSE-HIST-CSR'                          
                           TO CWS72-ERROR-PARAGRAPH-NAME                
              MOVE 'CSS_BILLING_DET' TO CWS72-ERROR-TABLE1              
              MOVE 'CSS_CNSMPTN_HIST'  TO CWS72-ERROR-TABLE2            
              MOVE 'ACCOUNT_NO'        TO CWS72-ERROR-TAB-COLUMN-1      
              MOVE 'CODE_UTIL_TYPE'    TO CWS72-ERROR-TAB-COLUMN-2      
              MOVE 'IC_NO         '    TO CWS72-ERROR-TAB-COLUMN-3      
              MOVE 'MTR_REF_NO   '     TO CWS72-ERROR-TAB-COLUMN-4      
              MOVE BG-ACCOUNT-NO       TO CWS72-ERROR-HOSTVAR-1         
              MOVE BG-CODE-UTIL-TYPE   TO CWS72-ERROR-HOSTVAR-2         
              MOVE BG-IC-NO            TO CWS72-ERROR-HOSTVAR-3         
              MOVE CX-MTR-REF-NO       TO CWS72-ERROR-HOSTVAR-4         
           END-IF.                                                      
      *                                                                         
       7873-CPD72-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
