      *****************************************************************         
      **   CPD04822 COPYBOOK TO SET UP CONTRACT.                     **         
      **                                                             **         
      **   THIS COPYBOOK CAN BE INCLUDED IN ONLINE AND BATCH PROGRAMS**         
      **   TO SYNC SERVICE CONTRACT (PCSBW822) AND OTHER BATCH PGMS. **         
      **                                                             **         
      **   THE FOLLOWING COPYBOOKS MUST BE INCLUDED IN THE SOURCE    **         
      **   CODE FROM WHICH THIS COMMON PROCEDURE DIVISION IS BEING   **         
      **                         EXECUTED:                           **         
      **                                                             **         
      **   CPD0006A, CPD00008, CPD00010, CPD0062C, CPD00067,         **         
      **   CPD00073, CPD00075, CPD0010S, CPD00300                    **         
      *****************************************************************         
      *****************************************************************         
      *    BEFORE SETUP THE NEW CONTRACT WE USED TO CALL CSR04821     *         
      *    RETRIEVE SPCB TO GET DEFALUT CONTRACT VALUES AND GENERATE  *         
      *    NEW CONTARCT ID BASED ON THE CONTARCT TYPE AND CONTRACT    *         
      *    NAME. BUT THIS PROCESS WON'T HAPPEN WHEN WE CALL THIS FROM *         
      *    OTHER MODULE LIKE LMS, MSE ETC.                            *         
      *                                                               *         
      *    THE BELOW PARAMETERS ARE REQUIRED FIELD TO CREATE CONTRACT *         
      *    SO MAKE SURE THAT YOU ARE PASSING THESE VALUES OR HANDLED  *         
      *    IN THE COPYBOOK.                                           *         
      *                                                               *         
      *    APPL_CODE                                                  *         
      *    APPL_PGM_ID                                                *         
      *    UPDATE_TYPE                                                *         
      *    PGM_CALLED_FROM                                            *         
      *    ACCOUNT_NO                                                 *         
      *    CODE_CONTRACT_TYPE                                         *         
      *    CNT_STATUS_CODE                                            *         
      *    CNT_NAME_CD                                                *         
      *    CNT_ITEM_ID                                                *         
      *    AMT_MO_PYMT                                                *         
      *    NO_SCHED_PYMTS                                             *         
      *    AMT_ORIG_ENTERED                                           *         
      *    CODE_BILL_TYPE                                             *         
      *    CNT_COMMENTS_TXT                                           *         
      *    DTL_CHRG_AMT                                               *         
      *                                                               *         
      *    THIS APPL WILL RETURN THE BELOW RETURN CODES.              *         
      *                                                               *         
      *    1000- INPUT INVALID                                        *         
      *    5000- A/R LOCKOUT IS IN EFFECT.                            *         
      *    5001- ERROR - ACCOUNT HAS ALREADY BEEN TRANSFERRED TO ACCT *         
      *    5003- PYMT-WAS-NOT-SUCCESSFUL                              *         
      *    5004- UNSUCCESSFUL JOURNAL - FOR TERMINATE-JRNL            *         
      *    5005- UNSUCCESSFUL JOURNAL - FOR JRNL - REBATE             *         
      *    5006- UNSUCCESSFUL JOURNAL - FOR JRNL - INTEREST           *         
      *    5007- UNSUCCESSFUL JOURNAL - FOR JRNL - DOWN PAYMENT       *         
      *    5008- UNSUCCESSFUL JOURNAL - FOR JRNL - WRITE-FM           *         
      *    5009- UNSUCCESSFUL JOURNAL - FOR JRNL - CHARGE AMOUNT      *         
      *    5010- UNSUCCESSFUL JOURNAL - FOR JRNL - TAX                *         
      *                                                               *         
      *****************************************************************         
      **  PERFORM THE BELOW ACTIONS:                                 **         
      **                                                             **         
      **      1. CONTRACT INSERT:                                    **         
      **         SET-UP THE NEW CONTRACT BASED ON THE CONTRACT TYPE  **         
      **         AND CONTRCAT NAME                                   **         
      **                                                             **         
      **      2. CONTRACT UPDATE:                                    **         
      **         CHANGE THE CONTRACT STATUS TO...                    **         
      **         A-PENDING                                           **         
      **         B-ACTIVE                                            **         
      **         C-PAID                                              **         
      **         D-CANCELLED                                         **         
      **         E-CLOSED                                            **         
      **         F-WRITTEN-OFF                                       **         
      **         G-FINAL BILL                                        **         
      **         P-REPOSSESSED                                       **         
      **         R-TRANSFERRED                                       **         
      **                                                             **         
      **      2. CONTRACT DELETE:  IT WONT DELETE ANY CONTARCT       **         
      **         INSTEAD IT WILL CHANGE THE CONTRACT STATUS TO       **         
      **         D-CANCELLED                                         **         
      **         E-CLOSED                                            **         
      **                                                             **         
      **      3. WHENEVER SETUP THE NEW CONTARCT OR ANY PAYMENT      **         
      **         INFO CHANGE, WILL PERFORM THE JOURNAL PROCESS.      **         
      **                                                             **         
      **      4. THE BELOW TABLES ARE USED TO SET-UP THE CONTRACT    **         
      **         1.CSS_CONTRACT                                      **         
      **         2.CSS_CNT_DETAIL                                    **         
      **         3.CSS_AR_CNTL                                       **         
      **         4.CSS_AR_TRN_HST_DET                                **         
      **         5.CSS_AR_TRANS_HIST                                 **         
      **         6.CSS_SPCL_BILL_MSG                                 **         
      **         7.CSS_ACCOUNT                                       **         
      **                                                             **         
      *****************************************************************         
      *               M A I N T E N A N C E   L O G                   *         
      *                                                               *         
      *   DATE      INITIALS     COMMENTS                             *         
      *  ------     -------      --------------------------------     *         
PRJ851* 10-20-2014  MS93554      INTIALLY WRITTEN.                    *         
PRJ851* 04-20-2015  MS93554      MADE CHANGES TO AVOID TRANSFER ACCT  *         
      *                          VALIDATION FOR FEW APPLICATION.      *         
PRJ851* 04-29-2015  MS93554      GL ACCOUNT NO WAS MISSING ON CNT DET *         
PRJ851* 05-05-2015  MS93554      COMMENTED ALL REBATE RELATED CODES.  *         
      *             ACT-1                                             *         
A05136* 08-23-2015  SM93554      ADDED FILING FEE AMOUNT TO UPDATE    *         
      *             ACT-160      IN CONTRACT DETAIL TABLE             *         
A05136* 11-12-2015  SM93554      INTRODUCED TRANS COMMENT OPTION ON   *         
      *             ACT-229      EDIT DIALOG SCREEN AS PART OF CNTRCT *         
A05207* 01-19-2016  SM93554      CHANGED THE GL LOGIC FOR FILING FEES *         
      *             ACT004       BASED ON THE MSE SYSTEM AND ADDED    *         
      *                          ADDITIONAL LOGIC FOR SALS-FRCE-CNT.  *         
      *                          AND CHANGED THE APPL PGM ID FOR DOWN *         
      *                          PAYMENT.                             *         
A05460* 05-26-2016  MS7M727      TO MOVE ZERO TO INTRST_PRIOR_YR FIELD*         
      *             ACT181       WHEN INSERT/UPDATE PERFORM           *         
A05460* 08-05-2016  SM93554      REMOVED UNUSED TBL AS PART OF DROP   *         
      *             ACT245       TBL AND ADDED DB2 RETURN CODE WHEN   *         
      *                          IT FAILS WITH HARD ERROR.            *         
A05460* 10-05-2016  TP7R341      REMOVED UNWANTED COLUMNS FROM        *         
      *             ACT278       CONTRACT AND CONTRACT DETAIL TABLES  *         
A05460* 12-04-2016  SM93554      ADDED GL LOGIC FOR REBATE TO CREDIT  *         
      *             ACT368       ACCOUNT CONTRACTS AND DSM REBATE     *         
      *                          CONTRACT BILLING TYPE SHOULD BE SPACE*         
A05460* 12-07-2016  SM93554      INITIALIZE BEFORE AR INSERT PROCESS  *         
      *             ACT373                                            *         
A05460* 12-09-2016  SM93554      TOTAL AR BALANCE WAS NOT UPDATING    *         
      *             ACT380       AFTER REBATE CREDIT TO ACCT.         *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      *                                                                         
      * CURSOR TO GET ALL TAX DETAILS.                                          
      *****************************************************************         
           EXEC SQL                                                     
                DECLARE OTHER_TAX_CSR CURSOR FOR                        
                 SELECT A.TAX_RATE,                                     
                        A.TAX_CNTRL_NO,                                 
                        A.TAX_ENTRY_SEQ_NO,                             
                        C.GL_ACCT_NO                                    
                   FROM CSS_TAX_RATE A WITH(READUNCOMMITTED),                   
                        CSS_TAX_CNTL B WITH(READUNCOMMITTED),                   
                        CSS_SPCL_FCTR C WITH(READUNCOMMITTED)                   
                  WHERE A.DETAIL_ID     = :TR-DETAIL-ID                 
                    AND ENERGY_TAX_FL   = 'N'                           
                    AND A.DATE_FROM    <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-REVENUE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REVENUE-DATE
              ) <> 0) OR (LEN(:WS-REVENUE-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-REVENUE-DATE
              ), CONVERT(DATE, :WS-REVENUE-DATE) )              
                    AND A.DATE_TO       > IIF(TRY_CONVERT(DATE, 
                                                       :WS-REVENUE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REVENUE-DATE
              ) <> 0) OR (LEN(:WS-REVENUE-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-REVENUE-DATE
              ), CONVERT(DATE, :WS-REVENUE-DATE) )              
                    AND A.OPER_MODE     = B.OPER_MODE                   
                    AND A.TAX_CNTRL_NO  = B.TAX_CNTRL_NO                
                    AND B.FACTOR_ID     = C.FACTOR_ID                   
                  ORDER BY A.TAX_CNTRL_NO,                              
                           A.TAX_ENTRY_SEQ_NO                           
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE OTHER_TAX_CSR CURSOR FOR                                
MFA-TR*          SELECT A.TAX_RATE,                                             
MFA-TR*                 A.TAX_CNTRL_NO,                                         
MFA-TR*                 A.TAX_ENTRY_SEQ_NO,                                     
MFA-TR*                 C.GL_ACCT_NO                                            
MFA-TR*            FROM CSS_TAX_RATE A,                                         
MFA-TR*                 CSS_TAX_CNTL B,                                         
MFA-TR*                 CSS_SPCL_FCTR C                                         
MFA-TR*           WHERE A.DETAIL_ID     = :TR-DETAIL-ID                         
MFA-TR*             AND ENERGY_TAX_FL   = 'N'                                   
MFA-TR*             AND A.DATE_FROM    <= :WS-REVENUE-DATE                      
MFA-TR*             AND A.DATE_TO       > :WS-REVENUE-DATE                      
MFA-TR*             AND A.OPER_MODE     = B.OPER_MODE                           
MFA-TR*             AND A.TAX_CNTRL_NO  = B.TAX_CNTRL_NO                        
MFA-TR*             AND B.FACTOR_ID     = C.FACTOR_ID                           
MFA-TR*           ORDER BY A.TAX_CNTRL_NO,                                      
MFA-TR*                    A.TAX_ENTRY_SEQ_NO                                   
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-START-CONTRACT-OPERATION.                                *         
      *****************************************************************         
       6000-START-CONTRACT-OPERATION.                                   
                                                                        
                                                                        
           PERFORM 6001-INITIAL-VALIDATION     THRU 6001-EXIT           
           PERFORM 6050-UPDATE-OPERATION       THRU 6050-EXIT.          
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6001-INITIAL-VALIDATION.                                      *         
      *****************************************************************         
       6001-INITIAL-VALIDATION.                                         
                                                                        
           MOVE WS-4822-ACCOUNT-NO          TO WS-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               AC-ACCOUNT-NO            
                                               CT-ACCOUNT-NO.           
                                                                        
      *    IF THE BELOW INPUT IS INVALID RETURN 1000 AS APPL RETURN CD          
           IF WS-4822-CNT-APPL-PGM-ID GREATER THAN SPACES AND           
              WS-4822-CNT-APPL-CODE   GREATER THAN SPACES AND           
              WS-4822-UPDATE-TYPE     GREATER THAN SPACES AND           
              WS-4822-PGM-CALLED-FROM GREATER THAN SPACES               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ZERO                 TO WS-4822-DB2-ERR-RETURN-CD 
              MOVE WS-INPUT-INVALID        TO WS-4822-APPL-CNT-RETURN-CD
P00851        SET  CPD4822-DB2-ERR-FOUND   TO TRUE                      
              PERFORM 9910-SQL-ERROR          THRU 9910-EXIT            
           END-IF.                                                      
                                                                        
      *****************************************************************         
      *                                                               *         
      * UNREG-CONTRACT      - CSR04822                                          
      * LMS-CONTRACT        - CSR0****                                          
      * SALS-FRCE-CONTRACT  - CSR04792                                          
      * MSE-CONTRACT        - CSR0****                                          
      * SRVCE-CARE-CONTRCAT - PCSBW822                                          
      *****************************************************************         
                                                                        
           EVALUATE WS-4822-CNT-APPL-CODE                               
               WHEN 'UNREG CNT'                                         
                    SET UNREG-CONTRACT      TO TRUE                     
               WHEN 'SRVC CARE'                                         
                    SET SRVCE-CARE-CONTRCAT TO TRUE                     
               WHEN 'LMS'                                               
                    SET LMS-CONTRACT        TO TRUE                     
               WHEN 'SALS FRCE'                                         
                    SET SALS-FRCE-CONTRACT  TO TRUE                     
               WHEN 'MSE'                                               
                    SET MSE-CONTRACT        TO TRUE                     
               WHEN OTHER                                               
                    CONTINUE                                            
           END-EVALUATE.                                                
                                                                        
           PERFORM 7001-GET-CURRENT-DATE       THRU 7001-EXIT.          
                                                                        
           EVALUATE TRUE                                                
                                                                        
      *        DEFAULT VALUES ARE POPULATING FOR LMS CONTRACT 407.              
               WHEN LMS-CONTRACT                                        
                    MOVE WS-ZERO            TO WS-4822-CNT-ITEM-ID      
                    MOVE WS-ONE             TO WS-4822-NO-SCHED-PYMTS   
                    MOVE 'SYSTEM'           TO WS-4822-USER-ID          
                    MOVE WS-ONE-TIME-CHARGE TO WS-4822-CODE-BILL-TYPE   
                    MOVE WS-4822-AMT-ORIG-ENTERED                       
                                            TO WS-4822-DTL-CHRG-AMT     
                    MOVE 99999.99           TO WS-4822-AMT-MO-PYMT      
                    MOVE WS-CONTRACT-CLOSED TO WS-4822-CNT-STATUS-CD    
                    MOVE 451.0100           TO WS-4822-DTL-GL-NO        
                    MOVE 0670.0603          TO WS-4822-DTL-WRT-OFF-GL-NO
                    MOVE 'CREATED THROUGH'  TO WS-4822-CNT-COMMENTS-TXT 
                    IF CALLED-FROM-BATCH                                
                       MOVE WS-JRNL-SELECT-AND-OR-INS TO                
                                               WS-JRNL-OPERATION-RQST   
                    MOVE 'A014'             TO WS-PAR-EIBTRNID          
                    END-IF                                              
                                                                        
      *        CREATING THROUGH PCSBW822 BATCH PGM                              
               WHEN SRVCE-CARE-CONTRCAT                                 
                    IF CONTRACT-INSERT OR CONTRACT-UPDATE               
                       MOVE WS-YES          TO WS-UPDATE-CNT-AMT        
                    ELSE                                                
                       MOVE WS-NO           TO WS-UPDATE-CNT-AMT        
                    END-IF                                              
                    MOVE WS-JRNL-SELECT-AND-OR-INS TO                   
                         WS-JRNL-OPERATION-RQST                         
                    MOVE 'B822'             TO WS-PAR-EIBTRNID          
                                                                        
      *        CREATING THROUGH CSR04792                                        
               WHEN SALS-FRCE-CONTRACT                                  
                                                                        
ACT368              IF WS-4822-REBATE-CD NOT EQUAL WS-NO-REBATE         
                       MOVE WS-ZERO         TO WS-4822-AMT-MO-PYMT      
ACT368*                DSM REBATE CONTRACT BILLING TYPE SHOULD BE SPACE         
ACT368                 IF WS-4822-REBATE-CD EQUAL WS-DSM-ISSUE-CECKS    
ACT368                    MOVE SPACES       TO WS-4822-CODE-BILL-TYPE   
ACT368                 ELSE                                             
ACT368                    MOVE WS-ONE-TIME-CHARGE                       
ACT368                                      TO WS-4822-CODE-BILL-TYPE   
ACT368                 END-IF                                           
                       MOVE WS-4822-AMT-ORIG-ENTERED                    
                                            TO WS-4822-DTL-CHRG-AMT     
                    END-IF                                              
                                                                        
                    MOVE 'CREATED THROUGH'  TO WS-4822-CNT-COMMENTS-TXT 
                    MOVE 'S822'             TO WS-PAR-EIBTRNID          
                                                                        
               WHEN OTHER                                               
                    CONTINUE                                            
                                                                        
           END-EVALUATE.                                                
                                                                        
           IF CALLED-FROM-ONLINE                                        
                                                                        
      *      DO NOT PROCEED IF SYSTEM IS LOCKED. LOGIC IS IN CPD00075.  10420000
             PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT            
             IF AL-AR-LOCKOUT-IND EQUAL WS-YES                          
                MOVE 5000              TO  WS-4822-APPL-CNT-RETURN-CD   
P00851          SET  CPD4822-DB2-ERR-FOUND   TO TRUE                    
                PERFORM 9910-SQL-ERROR     THRU 9910-EXIT               
             END-IF                                                     
ACT245     END-IF                                                       
                                                                        
           PERFORM 7015-SELECT-RESP-AREA       THRU 7015-EXIT           
           PERFORM 7000-GET-ACCOUNT-INFO       THRU 7000-EXIT           
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT    
                                                                        
      *    DO NOT PROCEED IF ACCOUNT TRANSFERRED AND                            
      *    ACCOUNT IS NOT A CONSOLIDATED SUB ACCOUNT.                           
P00851     IF LMS-CONTRACT OR MSE-CONTRACT OR SRVCE-CARE-CONTRCAT       
P00851        CONTINUE                                                  
P00851     ELSE                                                         
P00851        IF AT-AR-XFER-IND EQUAL WS-YES                            
P00851           AND AT-MST-SUB-ACCT-IND NOT EQUAL WS-CNSLDTD-SUB-ACCT  
P00851           MOVE AT-ACCT-XFER-TO      TO WS-4822-ACCT-XFER-TO      
P00851           MOVE 5001                 TO WS-4822-APPL-CNT-RETURN-CD
P00851           SET  CPD4822-DB2-ERR-FOUND TO TRUE                     
P00851           PERFORM 9910-SQL-ERROR     THRU 9910-EXIT              
P00851        END-IF                                                    
P00851     END-IF.                                                      
                                                                        
      *    LOAD ALL GL NUMBERS BASED ON TEH GL ACCT NAME.                       
           PERFORM 6002-LOAD-GL-NUMBERS        THRU 6002-EXIT.          
                                                                        
      *    GET A NEW MAX ID IN CASE SOMEONE INSERTED A ROW WITH THAT ID         
      *    INTO CSS_CONTRACT TABLE ALREADY. SKIP THIS PROCESS IF AN             
      *    ADVANCE COLLECTION EXISTS FOR THE CONTRACT IN WHICH CASE THER        
      *    WILL BE A ROW EXISTING IN CSS_CONTRACT.                              
                                                                        
           MOVE WS-PYMT-PRIORITY-100        TO CT-PYMT-PRIORITY-LVL.    
           MOVE WS-4822-CNT-ITEM-ID         TO CT-CNT-ITEM-ID.          
           IF WS-4822-ADV-COLL NOT EQUAL WS-YES                         
             PERFORM 7110-GET-CONTRACT-HDR-INFO                         
                                               THRU 7110-EXIT           
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR          
                WS-4822-CNT-ITEM-ID EQUAL WS-ZERO                       
                IF CONTRACT-INSERT                                      
                   PERFORM 6004-GET-MAX-CNT-ITM-ID                      
                                               THRU 6004-EXIT           
                ELSE                                                    
                  IF CONTRACT-UPDATE                                    
                                                                        
      *              ALLOW TO UPDATE THE AMT ORIG ENTERED FIELD                 
      *              ONLY FOR SERVICE CARE BATCH CONTRACT PROCESS               
      *              SHOULD NOT ALLOW TO CHANGE FOR REMAINING PROCESS.          
                     IF SRVCE-CARE-CONTRCAT                             
                        MOVE WS-4822-AMT-ORIG-ENTERED                   
                                            TO CT-AMT-ORIG-ENTERED      
                     END-IF                                             
                                                                        
      *              WHENEVER USER CHANGE PAYMENT INFO WILL UPDT THE            
      *              CONTRACT AMOUNT DETAILS ELSE ONLY CONTRACT HDR.            
                     IF CT-INTRST-RATE NOT EQUAL WS-4822-INTRST-RATE OR 
                        CT-AMT-MO-PYMT NOT EQUAL WS-4822-AMT-MO-PYMT OR 
                        EA-CHARGE-AM   NOT EQUAL WS-4822-DTL-CHRG-AMT   
                        MOVE WS-YES           TO WS-UPDATE-CNT-AMT      
                     END-IF                                             
                  END-IF                                                
                END-IF                                                  
             END-IF                                                     
           END-IF.                                                      
                                                                        
ACT-1      IF CONTRACT-UPDATE OR CONTRACT-DELETE                        
ACT-1         PERFORM 7111-GET-CURR-CNT-STATUS THRU 7111-EXIT           
ACT-1         IF CT-CNT-STATUS-CD NOT EQUAL WS-4822-CNT-STATUS-CD       
ACT-1            MOVE WS-CURRENT-DATE TO WS-4822-STATUS-CHANGE-DT       
ACT-1         END-IF                                                    
ACT-1      END-IF.                                                      
                                                                        
      *    BUILD THE CONTRACT COMMENTS TO IDENTIFY THROUGH WHICH                
      *    APPLICATION IT CREATED.                                              
      *    MOVE WS-4822-CNT-COMMENTS-TXT TO  WS-CNT-INPUT-COMMENT               
      *    MOVE WS-4822-CNT-APPL-CODE    TO  WS-CNT-APPL-CODE                   
      *    MOVE WS-4822-CNT-APPL-PGM-ID  TO  WS-CNT-APPL-PGM-ID                 
      *                                                                         
           IF SRVCE-CARE-CONTRCAT                                       
              MOVE SPACES                   TO WS-4822-CNT-APPL-CODE    
           END-IF.                                                      
                                                                        
ACT-1      IF WS-4822-CNT-COMMENTS-TXT EQUAL SPACES                     
ACT-1         STRING WS-4822-CNT-APPL-CODE    DELIMITED BY '  '         
ACT-1                '-'                      DELIMITED BY SIZE         
ACT-1                WS-4822-CNT-APPL-PGM-ID  DELIMITED BY '  '         
ACT-1           INTO WS-4822-CNT-COMMENTS-TXT                           
ACT-1      ELSE                                                         
SAKTHI        IF CONTRACT-INSERT                                        
ACT-1            STRING WS-4822-CNT-COMMENTS-TXT DELIMITED BY '  '      
ACT-1                '-'                      DELIMITED BY SIZE         
ACT-1                WS-4822-CNT-APPL-PGM-ID  DELIMITED BY '  '         
ACT-1            INTO WS-4822-CNT-COMMENTS-TXT                          
SAKTHI        ELSE                                                      
SAKTHI           MOVE WS-4822-CNT-COMMENTS-TXT                          
SAKTHI                                     TO WS-4822-CNT-COMMENTS-TXT  
SAKTHI        END-IF                                                    
ACT-1      END-IF.                                                      
                                                                        
           MOVE LENGTH OF WS-4822-CNT-COMMENTS-TXT                      
                                            TO WS-CNT-COMMENTS-LEN.     
                                                                        
       6001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 6002-LOAD-GL-NUMBERS.                                                   
      *****************************************************************         
       6002-LOAD-GL-NUMBERS.                                            
                                                                        
           MOVE WS-SCEG                     TO GO-COMPANY-NO.           
           MOVE WS-GL-CASH-KEY              TO GO-GL-ACCT-NAME.         
           PERFORM 7300-SELECT-GL-ACCT         THRU 7300-EXIT.          
           MOVE GO-GL-ACCT-NO               TO WS-GEN-LED-CASH.         
                                                                        
           MOVE WS-GL-CONTRACT-KEY          TO GO-GL-ACCT-NAME.         
           PERFORM 7300-SELECT-GL-ACCT         THRU 7300-EXIT.          
           MOVE GO-GL-ACCT-NO               TO WS-GEN-LED-CONTRACT.     
                                                                        
           MOVE WS-GL-TAX-STAT-KEY          TO GO-GL-ACCT-NAME.         
           PERFORM 7300-SELECT-GL-ACCT         THRU 7300-EXIT.          
           MOVE GO-GL-ACCT-NO               TO WS-GEN-LED-STATE-TAX.    
                                                                        
           MOVE WS-GL-TAX-CITY-KEY          TO GO-GL-ACCT-NAME.         
           PERFORM 7300-SELECT-GL-ACCT         THRU 7300-EXIT.          
           MOVE GO-GL-ACCT-NO               TO WS-GEN-LED-CITY-TAX.     
                                                                        
           MOVE WS-GL-GREV-FCHG-KEY         TO GO-GL-ACCT-NAME.         
           PERFORM 7300-SELECT-GL-ACCT         THRU 7300-EXIT.          
           MOVE GO-GL-ACCT-NO               TO WS-GEN-LED-GREV-FCHG.    
                                                                        
           MOVE WS-GL-EREV-FCHG-KEY         TO GO-GL-ACCT-NAME.         
           PERFORM 7300-SELECT-GL-ACCT         THRU 7300-EXIT.          
           MOVE GO-GL-ACCT-NO               TO WS-GEN-LED-EREV-FCHG.    
                                                                        
           MOVE WS-GL-INSP-FEE-KEY          TO GO-GL-ACCT-NAME.         
           PERFORM 7300-SELECT-GL-ACCT         THRU 7300-EXIT.          
           MOVE GO-GL-ACCT-NO               TO WS-GEN-LED-INSP-FEE.     
                                                                        
SAKTHI*    FOR FILING-FEE-AM FROM MSE                                           
SAKTHI     MOVE WS-GL-FILING-FEE-KEY        TO GO-GL-ACCT-NAME.         
SAKTHI     PERFORM 7300-SELECT-GL-ACCT         THRU 7300-EXIT.          
SAKTHI     MOVE GO-GL-ACCT-NO               TO WS-GEN-LED-FILING-FEE.   
                                                                        
ACT368*    FOR REBATE CREDIT TO ACOCUNT                                         
ACT368     MOVE WS-GL-AR-CIA-KEY            TO GO-GL-ACCT-NAME.         
ACT368     PERFORM 7300-SELECT-GL-ACCT         THRU 7300-EXIT.          
ACT368     MOVE GO-GL-ACCT-NO               TO WS-GEN-LED-REBATE.       
                                                                        
       6002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 6004-GET-MAX-CNT-ITM-ID.                                                
      *****************************************************************         
       6004-GET-MAX-CNT-ITM-ID.                                         
                                                                        
           PERFORM 7250-SELECT-MAX-ITEM-ID     THRU 7250-EXIT.          
           IF WS-NEW-CNT-ITEM-ID GREATER THAN WS-ZERO                   
              ADD 1 TO WS-NEW-CNT-ITEM-ID GIVING WS-4822-CNT-ITEM-ID    
           ELSE                                                         
              MOVE '5000000'                TO WS-4822-CNT-ITEM-ID      
           END-IF.                                                      
                                                                        
      *    USING THE BELOW RETURN VALUE TO DISPLAY THE ITEM ID                  
      *    TO USER WHILE SETTING UP NEW CONTARCT.                               
           MOVE WS-4822-CNT-ITEM-ID         TO WS-4822-NEW-ITEM-ID.     
                                                                        
       6004-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 6007-DETERMINE-GL-NUMBERS                                               
      *****************************************************************         
       6007-DETERMINE-GL-NUMBERS.                                       
                                                                        
           MOVE AT-COMPANY-NO               TO GL-COMPANY-NO.           
           MOVE AT-LOCAL-OFFICE             TO GL-LOCAL-OFFICE.         
                                                                        
      *    CPD00061 - WILL PERFORM THE BELOW ACTION                             
           PERFORM 0700-LOAD-GL-NO-VALUES      THRU 0700-EXIT           
              VARYING WS-GL-SUB FROM 1 BY 1                             
                  UNTIL WS-GL-SUB GREATER THAN WS-MAX-CO                
                     OR WS-VALID-CO-NO (WS-GL-SUB) EQUAL WS-GL-99.      
                                                                        
           PERFORM VARYING WS-GL-SUB FROM 1 BY 1                        
              UNTIL WS-GL-SUB > 5                                       
                 OR AT-COMPANY-NO = WS-VALID-CO-NO (WS-GL-SUB)          
                 OR WS-VALID-CO-NO (WS-GL-SUB) = WS-GL-99               
                                                                        
             IF AT-COMPANY-NO = WS-VALID-CO-NO (WS-GL-SUB)              
                 MOVE WS-YES                TO WS-COMPANY-IN-TABLE      
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       6007-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 6010-INS-SPCL-BIL-MSG.                                                  
      *****************************************************************         
       6010-INS-SPCL-BIL-MSG.                                           
                                                                        
           MOVE CT-ACCOUNT-NO               TO U1-ACCOUNT-NO.           
           MOVE AT-COMPANY-NO               TO U1-COMPANY-NO.           
           MOVE '95172'                     TO U1-BILL-MSG-ID.          
           MOVE 'M'                         TO U1-MSG-TYPE-CD.          
           MOVE WS-ONE                      TO U1-BILL-CYCLE-ST.        
           MOVE 21                          TO U1-BILL-CYCLE-END.       
                                                                        
           IF AT-REV-MTH-LST-NRML GREATER THAN WS-ZERO                  
              MOVE AT-REV-MTH-LST-NRML      TO WS-REVENUE-MONTH-1       
              COMPUTE WS-REVMTH-MM EQUAL WS-REVMTH-MM + 1               
              IF WS-REVMTH-MM > 12                                      
                 ADD 1 TO WS-REVMTH-CCYY                                
                 COMPUTE WS-REVMTH-MM = WS-REVMTH-MM - 12               
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
              MOVE WS-REVENUE-MONTH-1       TO U1-REVENUE-MO-END        
              MOVE U1-REVENUE-MO-END        TO U1-REVENUE-MO-ST         
           ELSE                                                         
              MOVE AT-BILL-CYCLE            TO BN-BILL-CYCLE            
              PERFORM 8070-SEL-REV-MONTH       THRU 8070-EXIT           
              MOVE BN-REVENUE-MONTH         TO U1-REVENUE-MO-END        
                                               U1-REVENUE-MO-ST         
           END-IF.                                                      
                                                                        
           PERFORM 8060-INSERT-BILL-MSG     THRU 8060-EXIT.             
                                                                        
       6010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6050-UPDATE-OPERATION.                                        *         
      *****************************************************************         
       6050-UPDATE-OPERATION.                                           
                                                                        
      *    GET DATABASE FROM DELIENQUENCY TABLE.                                
           MOVE WS-DATABASE                 TO C8-DELINQ-CD.            
           MOVE AT-COMPANY-NO               TO C8-COMPANY-NO            
           PERFORM 7005-GET-DATABASE        THRU 7005-EXIT              
           MOVE AT-COMPANY-NO               TO WS-100-COMPANY-NO.       
                                                                        
           MOVE WS-NINE                     TO WS-TRAN-OPER-LEVEL.      
           MOVE WS-ONE                      TO WS-TRAN-OCAP-FIELD       
                                               WS-TRAN-OCAP-VALUE.      
                                                                        
           IF CONTRACT-UPDATE                                           
              MOVE WS-M                     TO WS-TRAN-JRNL-TYPE        
           ELSE                                                         
              MOVE WS-C                     TO WS-TRAN-JRNL-TYPE        
           END-IF.                                                      
                                                                        
           MOVE WS-NO                       TO WS-TRAN-HOLD-EXEMPT-FLAG.
                                                                        
           PERFORM 6055-JRNL-OPER-RQST-ROUTINE THRU 6055-EXIT.          
           PERFORM 6065-CALL-JRNL-ROUTINE      THRU 6065-EXIT.          
           MOVE WS-JRNL-OL-OPR-LOC          TO WS-TERM-LOC.             
           PERFORM 6060-JRNL-ONLY-JRNL-ROUTINE THRU 6060-EXIT.          
                                                                        
           IF CALLED-FROM-ONLINE                                        
              PERFORM 6070-JRNL-TERM-LOC-ROUTINE                        
                                               THRU 6070-EXIT           
           END-IF.                                                      
                                                                        
           MOVE WS-JRNL-VALIDATE-OPER       TO WS-JRNL-OPERATION-RQST.  
           MOVE WS-C                        TO WS-JRNL-SOURCE-CODE.     
                                                                        
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE      TO WS-JRNL-OL-AUTH-TYPE     
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE  TO WS-JRNL-OL-AUTH-TYPE     
           END-IF.                                                      
           PERFORM 6065-CALL-JRNL-ROUTINE      THRU 6065-EXIT.          
                                                                        
           MOVE WS-A                        TO WS-100-JRNL-SORT-ID.     
           MOVE AT-ACCOUNT-NO               TO WS-100-ACCT-NO.          
           MOVE AT-CUSTOMER-NO              TO WS-100-CUSTOMER-NO.      
           MOVE AT-PREMISE-NO               TO WS-100-PREMISE-NO.       
           MOVE WS-PAR-EIBTRNID             TO WS-100-CODE-TERMINAL-TRAN
           ADD 1                            TO WS-100-JRNL-TRAN-APPL-NO.
           MOVE WS-CURRENT-DATE             TO WS-100-DATE-LAST-ACTION  
                                               AT-DATE-LAST-ACTION.     
           MOVE WS-C                        TO WS-100-CODE-ENTRY-SOURCE.
           MOVE AT-LOCAL-OFFICE             TO WS-100-LOCAL-OFFICE-CD.  
                                                                        
           PERFORM 6105-FNCTN-TO-PERFORM-UPDATE THRU 6105-EXIT.         
      *    PERFORM 8310-UPDATE-ACCOUNT          THRU 8310-EXIT.                 
                                                                        
       6050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6055-JRNL-OPER-RQST-ROUTINE.                                  *         
      *****************************************************************         
       6055-JRNL-OPER-RQST-ROUTINE.                                     
                                                                        
           IF CALLED-FROM-ONLINE                                        
              MOVE WS-4822-USER-ID          TO WS-JRNL-OL-TEMP-ID       
              MOVE WS-JRNL-CK-OPER-ID       TO WS-JRNL-OPERATION-RQST   
              MOVE WS-JRNL-OL-OPR-LOC       TO WS-TERM-LOC              
           ELSE                                                         
              PERFORM 6060-JRNL-ONLY-JRNL-ROUTINE THRU 6060-EXIT        
           END-IF.                                                      
                                                                        
       6055-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6060-JRNL-ONLY-JRNL-ROUTINE.                                   *        
      ******************************************************************        
       6060-JRNL-ONLY-JRNL-ROUTINE.                                     
                                                                        
           IF CALLED-FROM-BATCH                                         
              MOVE WS-CD-COMPANY-NO         TO WS-JRNL-BT-BAT-COMPANY   
              MOVE WS-CD-LOCAL-OFFICE       TO WS-JRNL-BT-BAT-LOC-OFF   
              MOVE WS-CD-REPORT-NO          TO WS-JRNL-BT-BAT-REPORT-NO 
              MOVE WS-CD-REPORT-DATE        TO WS-JRNL-BT-BAT-REPORT-DT 
              MOVE WS-CASH-DRAWER-ID        TO WS-JRNL-BT-BAT-CASH-DRWR 
           ELSE                                                         
              MOVE WS-CD-COMPANY-NO         TO WS-JRNL-OL-COMPANY       
              MOVE WS-CD-LOCAL-OFFICE       TO WS-JRNL-OL-LOC-OFF       
              MOVE WS-CD-REPORT-NO          TO WS-JRNL-OL-REPORT-NO     
              MOVE WS-CD-REPORT-DATE        TO WS-JRNL-OL-REPORT-DT     
              MOVE WS-CASH-DRAWER-ID        TO WS-JRNL-OL-CASH-DRWR     
           END-IF.                                                      
                                                                        
       6060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6070-JRNL-TERM-LOC-ROUTINE.                                    *        
      ******************************************************************        
       6070-JRNL-TERM-LOC-ROUTINE.                                      
                                                                        
           MOVE WS-TERM-LOC                 TO WS-JRNL-OL-TERM-LOC      
                                               WS-JRNL-OL-CASH-LOC      
                                               WS-JRNL-OL-OPR-LOC.      
       6070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6080-LOAD-AR-TRANS-HIST.                                       *        
      ******************************************************************        
       6080-LOAD-AR-TRANS-HIST.                                         
                                                                        
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT.        
                                                                        
       6080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6105-FNCTN-TO-PERFORM-UPDATE.                                  *        
      ******************************************************************        
       6105-FNCTN-TO-PERFORM-UPDATE.                                    
                                                                        
           EVALUATE TRUE                                                
                                                                        
             WHEN CONTRACT-UPDATE                                       
               PERFORM 5105-WRITE-TRAN-HIST-UPDT      THRU 5105-EXIT    
               PERFORM 6800-MOVE-CONTRACT-VARIABLES   THRU 6800-EXIT    
                                                                        
               IF WS-UPDATE-CNT-AMT EQUAL WS-YES                        
                  PERFORM 8080-UPDATE-CNT-HDR-AMT     THRU 8080-EXIT    
                  PERFORM 8306-UPDATE-CNT-DETAIL-AMT  THRU 8306-EXIT    
               ELSE                                                     
                  PERFORM 8300-UPDATE-CONTRACT        THRU 8300-EXIT    
               END-IF                                                   
                                                                        
               MOVE WS-CURRENT-DATE         TO AT-DATE-LAST-ACTION      
               PERFORM 8310-UPDATE-ACCOUNT            THRU 8310-EXIT    
               PERFORM 9910-SQL-ERROR                 THRU 9910-EXIT    
                                                                        
      *      WHEN CONTRACT STATUS IS CLOSED OR CANCELLED PERFORM                
      *      THE BELOW ACTION.                                                  
             WHEN CONTRACT-DELETE                                       
               MOVE WS-ZERO                 TO WS-AMT-POSTED-TOTAL      
               MOVE WS-PYMT-PRIORITY-100    TO AC-PYMT-PRIORITY-LVL     
               MOVE WS-4822-CNT-ITEM-ID     TO AC-ITEM-ID               
               MOVE WS-ZERO                 TO AC-AMT-TRAN-BALANCE      
               PERFORM 7100-SELECT-AR-CNTL     THRU 7100-EXIT           
                                                                        
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  IF WS-4822-CODE-BILL-TYPE EQUAL WS-MNTHLY-CREDIT OR   
                                                  WS-ONETIME-REBATE-CHK 
                     CONTINUE                                           
                  ELSE                                                  
                     SET  CPD4822-DB2-ERR-FOUND TO TRUE                 
ACT245               MOVE WS-ACTIVE-RETURN-CODE                         
ACT245                                      TO WS-4822-DB2-ERR-RETURN-CD
                     MOVE PROGRAM-NAME      TO ABEND-PROGRAM            
                     MOVE '6100'            TO ACTIVE-PARAGRAPH         
                     MOVE 'SELECT'          TO ABEND-FUNCTION           
                     MOVE SPACES            TO ABEND-SQL-PREDICATES     
                                                  ABEND-TABLES          
                     MOVE 'CSS_AR_CNTL'     TO TABLE-1                  
                     MOVE AC-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1        
                     MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2     
                     MOVE AC-ITEM-ID        TO HOSTVAR-ELEMENT-3        
                     PERFORM 9910-SQL-ERROR    THRU 9910-EXIT           
                  END-IF                                                
               ELSE                                                     
                  ADD AC-AMT-AR-DAY-00                                  
                      AC-AMT-AR-DAY-30                                  
                      AC-AMT-AR-DAY-60                                  
                      AC-AMT-AR-DAY-90                                  
                      GIVING WS-DETAIL-END-AR-BAL                       
                  MOVE WS-DETAIL-END-AR-BAL TO WS-DETAIL-AR-BAL         
               END-IF                                                   
      *        BELOW ACTION SHOULD PERFORM ONLY FOR CACEL CONTRACT              
               PERFORM 6110-PROCESS-FOR-CANCEL-CNT                      
                                               THRU 6110-EXIT           
                                                                        
               IF WS-4822-CNT-STATUS-CD EQUAL WS-CONTRACT-CANCELLED     
                  IF (CT-CODE-BILL-TYPE  NOT EQUAL WS-MNTHLY-CHARGE) OR 
                     (CT-CODE-BILL-TYPE EQUAL WS-MNTHLY-CHARGE AND      
                      AC-AMT-TRAN-BALANCE EQUAL WS-ZERO)                
                      PERFORM 6120-CANCEL-CONTRACT THRU 6120-EXIT       
                  END-IF                                                
               ELSE                                                     
                  MOVE WS-CONTRACT-CLOSED   TO WS-4822-CNT-STATUS-CD    
                  PERFORM 6130-CLOSE-CONTRACT  THRU 6130-EXIT           
               END-IF                                                   
                                                                        
             WHEN CONTRACT-INSERT                                       
                                                                        
ACT368*        DO NOT CRETAE ANY GL / AR FOR DSM DEBATE CONTRACTS.              
ACT368         IF WS-4822-REBATE-CD EQUAL WS-DSM-ISSUE-CECKS            
ACT368            PERFORM 6600-INSERT-CONTRACT     THRU 6600-EXIT       
ACT368            PERFORM 8310-UPDATE-ACCOUNT      THRU 8310-EXIT       
ACT368            GO TO 6105-EXIT                                       
ACT368         END-IF                                                   
                                                                        
               MOVE WS-ZERO TO WS-AMT-POSTED-TOTAL                      
               MOVE WS-PYMT-PRIORITY-100    TO AC-PYMT-PRIORITY-LVL     
               MOVE WS-4822-CNT-ITEM-ID     TO AC-ITEM-ID               
               MOVE WS-ZERO TO AC-AMT-TRAN-BALANCE                      
               PERFORM 7100-SELECT-AR-CNTL     THRU 7100-EXIT           
               PERFORM 6140-INSERT-JRNL-PROCESS                         
                                               THRU 6140-EXIT           
               PERFORM 6150-NEW-CONTRACT-PROCESS                        
                                               THRU 6150-EXIT           
                                                                        
      *        =======================================================          
      *        THIS LOGIC ONLY FOR WHEN WE CREIT THE REBATE TO ACCOUNT.         
      *        COMES THROUGH SALES FORCE PROCESS.                               
      *        ======================================================           
      *                                                                         
ACT368         IF WS-4822-REBATE-CD EQUAL WS-REBATE-TO-CREDIT-ACCT      
ACT368            IF CALLED-FROM-ONLINE                                 
ACT368               PERFORM 6145-REBATE-JRNL-PROCESS                   
ACT368                                         THRU 6145-EXIT           
ACT368*              =====================================                      
ACT368*              **MAY NEED TO CLEAN UP THIS IN FUTURE**                    
ACT368*              PERFORM 6160-POST-CREDIT-TO-THE-ACCT THRU 6160-EXIT        
ACT368*              =====================================                      
ACT368            END-IF                                                
ACT368         END-IF                                                   
                                                                        
           END-EVALUATE.                                                
                                                                        
           PERFORM 6170-TERMINATE-JRNL         THRU 6170-EXIT.          
           PERFORM 8310-UPDATE-ACCOUNT         THRU 8310-EXIT.          
                                                                        
           IF CONTRACT-INSERT OR ( CONTRACT-DELETE AND                  
              WS-4822-CNT-STATUS-CD EQUAL WS-CONTRACT-CANCELLED)        
              IF CSR-DATABASE-4822 AND AT-COMPANY-NO = WS-PSNC AND      
                 WS-4822-CODE-CONTRACT-TYPE EQUAL WS-PSNC-FACILITIES-DMG
                 PERFORM 6180-EXMPT-PSNC-FCLTY-DAMG-CNT                 
                                               THRU 6180-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6110-PROCESS-FOR-CANCEL-CNT.                                   *        
      ******************************************************************        
       6110-PROCESS-FOR-CANCEL-CNT.                                     
                                                                        
           IF NOT (WS-4822-CODE-BILL-TYPE EQUAL WS-MNTHLY-CHARGE OR     
                   WS-4822-CODE-BILL-TYPE EQUAL                         
                   WS-MNTHLY-CREDIT OR WS-ONETIME-REBATE-CHK )          
                                                                        
             IF WS-4822-CNT-STATUS-CD EQUAL WS-CONTRACT-CANCELLED       
                IF (AC-AMT-AR-DAY-00 +                                  
                    AC-AMT-AR-DAY-30 +                                  
                    AC-AMT-AR-DAY-60 +                                  
                    AC-AMT-AR-DAY-90) GREATER THAN ZERO                 
                    PERFORM 6175-WRITE-FM      THRU 6175-EXIT           
                END-IF                                                  
                                                                        
      *         IF (WS-4822-REBATE-AMOUNT GREATER THAN WS-ZERO AND              
      *             WS-4822-REBATE-CD EQUAL W-LT-REDUCE-FINANCE )               
      *             MOVE WS-ZERO            TO WS-AMT-POSTED-TOTAL              
      *                                        WS-CNT-TRAN-APPL-NO              
      *             PERFORM 6190-JRNL-REBATE   THRU 6190-EXIT                   
      *         END-IF                                                          
                                                                        
                COMPUTE WS-UNPAID-BALANCE = AC-AMT-TRAN-BALANCE         
                                          - WS-4822-ADD-ON-INTRST       
                                          + WS-4822-REBATE-AMOUNT       
                IF WS-UNPAID-BALANCE GREATER THAN WS-ZERO               
                   PERFORM 7010-SELECT-TIMESTAMP                        
                                               THRU 7010-EXIT           
                   COMPUTE WS-AMT-POSTED-TOTAL = AC-AMT-TRAN-BALANCE    
                                               + WS-4822-REBATE-AMOUNT  
                   PERFORM 6200-JRNL-LOOP      THRU 6200-EXIT           
                END-IF                                                  
                                                                        
      *         JOURNAL PROCESS FOR SIMPLE INTEREST FINANCE CHARGE              
                IF WS-4822-ADD-ON-INTRST  GREATER THAN WS-ZERO          
                   PERFORM 6210-JRNL-INTEREST  THRU 6210-EXIT           
                END-IF                                                  
                                                                        
             END-IF                                                     
           END-IF.                                                      
                                                                        
       6110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6120-CANCEL-CONTRACT.                                          *        
      ******************************************************************        
       6120-CANCEL-CONTRACT.                                            
                                                                        
      *    MONTHLY CHARGE AND MONTHLY CREDIT CONTRACTS WILL HAVE A              
      *    MAINT TRAN ROW FOR STATUS CHANGE.                                    
           IF  WS-4822-CODE-BILL-TYPE EQUAL WS-MNTHLY-CHARGE  OR        
                                            WS-MNTHLY-CREDIT OR         
                                            WS-ONETIME-REBATE-CHK       
               PERFORM 5110-INSERT-MNT-TRN-HST-CNCL                     
                                               THRU 5110-EXIT           
           END-IF                                                       
                                                                        
      *    THERE IS NO AC ROW FOR TYPE E: MONTHLY CREDIT                        
           IF WS-4822-CODE-BILL-TYPE EQUAL  WS-MNTHLY-CREDIT OR         
                                            WS-ONETIME-REBATE-CHK       
              MOVE WS-ZERO                  TO WS-4822-ADD-ON-INTRST    
              PERFORM 8300-UPDATE-CONTRACT     THRU 8300-EXIT           
              GO TO 6120-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE AT-ACCOUNT-NO               TO AC-ACCOUNT-NO.           
           MOVE WS-PYMT-PRIORITY-100        TO AC-PYMT-PRIORITY-LVL.    
           MOVE WS-ZERO                     TO AC-ITEM-ID.              
                                                                        
           PERFORM 7500-SELECT-AR-CNTL-SUMM    THRU 7500-EXIT.          
                                                                        
           SUBTRACT AC-AMT-AR-DAY-00 FROM WS-SUMM-AC-AMT-AR-DAY-00.     
           SUBTRACT AC-AMT-AR-DAY-30 FROM WS-SUMM-AC-AMT-AR-DAY-30.     
           SUBTRACT AC-AMT-AR-DAY-60 FROM WS-SUMM-AC-AMT-AR-DAY-60.     
           SUBTRACT AC-AMT-AR-DAY-90 FROM WS-SUMM-AC-AMT-AR-DAY-90.     
           MOVE WS-4822-CNT-ITEM-ID         TO AC-ITEM-ID.              
                                                                        
           PERFORM 8035-DELETE-CSS-AR-CNTL     THRU 8035-EXIT           
           MOVE WS-ZERO                     TO WS-4822-ADD-ON-INTRST    
                                                                        
           PERFORM 8305-UPDATE-CONTRACT-AMT    THRU 8305-EXIT           
           MOVE WS-ZERO                     TO WS-SUM-AR-BAL            
                                               AC-ITEM-ID.              
                                                                        
           PERFORM 8040-COUNT-AC-ROWS          THRU 8040-EXIT.          
           IF WS-SUM-AR-BAL EQUAL ZEROES                                
              MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT    
              MOVE SPACES                   TO WS-CODE-CONTRACT         
              MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT    
              MOVE WS-ZERO                  TO AC-ITEM-ID               
              PERFORM 8035-DELETE-CSS-AR-CNTL  THRU 8035-EXIT           
           ELSE                                                         
              MOVE WS-ZERO                  TO AC-ITEM-ID               
              PERFORM 8030-UPDATE-AR-CNTL-SUMM THRU 8030-EXIT           
           END-IF.                                                      
                                                                        
       6120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6130-CLOSE-CONTRACT.                                           *        
      ******************************************************************        
       6130-CLOSE-CONTRACT.                                             
                                                                        
           IF CT-CODE-CONTRACT-TYPE NOT EQUAL WS-PACE-CONTRIBUTION      
              MOVE  99999.99                TO WS-4822-AMT-MO-PYMT      
           END-IF.                                                      
           PERFORM 5105-WRITE-TRAN-HIST-UPDT   THRU 5105-EXIT.          
           PERFORM 8305-UPDATE-CONTRACT-AMT    THRU 8305-EXIT.          
                                                                        
           IF AC-AMT-TRAN-BALANCE EQUAL WS-ZERO                         
              PERFORM 8035-DELETE-CSS-AR-CNTL  THRU 8035-EXIT           
           END-IF                                                       
                                                                        
           MOVE WS-ZERO                     TO WS-SUM-AR-BAL            
                                               AC-ITEM-ID.              
                                                                        
           PERFORM 8040-COUNT-AC-ROWS          THRU 8040-EXIT.          
           IF WS-SUM-AR-BAL EQUAL WS-ZERO                               
              MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT    
              MOVE SPACES                   TO WS-CODE-CONTRACT         
              MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT    
              MOVE WS-ZERO                  TO AC-ITEM-ID               
              PERFORM 8035-DELETE-CSS-AR-CNTL  THRU 8035-EXIT           
           END-IF.                                                      
                                                                        
       6130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6130-CLOSE-CONTRACT.                                           *        
      ******************************************************************        
       6140-INSERT-JRNL-PROCESS.                                        
                                                                        
           IF NOT (WS-4822-CODE-BILL-TYPE EQUAL WS-MNTHLY-CHARGE OR     
                   WS-4822-CODE-BILL-TYPE EQUAL                         
                   WS-MNTHLY-CREDIT OR WS-ONETIME-REBATE-CHK)           
                                                                        
              PERFORM 7010-SELECT-TIMESTAMP    THRU 7010-EXIT           
              IF WS-4822-ADV-COLL EQUAL WS-YES                          
                 MOVE AC-AMT-TRAN-BALANCE   TO WS-AMT-POSTED-TOTAL      
              ELSE                                                      
                 MOVE WS-ZERO               TO WS-AMT-POSTED-TOTAL      
              END-IF                                                    
                                                                        
              PERFORM 6200-JRNL-LOOP           THRU 6200-EXIT           
                                                                        
      *       JOURNAL PROCESS FOR SIMPLE INTEREST FINANCE CHARGE                
              IF WS-4822-ADD-ON-INTRST GREATER THAN WS-ZERO             
                    PERFORM 6210-JRNL-INTEREST THRU 6210-EXIT           
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE WS-A   TO AT-CODE-P-BILL-DEST                           
      *    IF ( WS-4822-REBATE-AMOUNT GREATER THAN WS-ZERO AND                  
      *         WS-4822-REBATE-CD EQUAL W-LT-REDUCE-FINANCE )                   
      *       MOVE WS-ZERO                  TO WS-AMT-POSTED-TOTAL              
      *                                        WS-CNT-TRAN-APPL-NO              
      *       PERFORM 6190-JRNL-REBATE         THRU 6190-EXIT                   
      *    END-IF                                                               
                                                                        
           IF WS-4822-AMT-DOWN-PYMT GREATER THAN WS-ZERO                
              IF WS-4822-ADV-COLL EQUAL WS-YES                          
      *          ADJUST DOWN PAYMENT AGAINST ADVANCE COLLECTION AMT.            
                 COMPUTE WS-DOWN-PMT-JRNL-AMT EQUAL                     
                    WS-4822-AMT-DOWN-PYMT  + AC-AMT-TRAN-BALANCE        
                 IF WS-DOWN-PMT-JRNL-AMT GREATER THAN WS-ZERO           
                    PERFORM 6220-WRITE-DOWN-PYMT THRU 6220-EXIT         
                 ELSE                                                   
                    MOVE 0 TO WS-DOWN-PMT-JRNL-AMT                      
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-4822-AMT-DOWN-PYMT TO WS-DOWN-PMT-JRNL-AMT     
                 PERFORM 6220-WRITE-DOWN-PYMT  THRU 6220-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6145-REBATE-JRNL-PROCESS.                                      *        
      ******************************************************************        
ACT368 6145-REBATE-JRNL-PROCESS.                                        
ACT368                                                                  
ACT368     MOVE SPACES                     TO WS-105-CASH-DRAWER-USED.  
ACT368     MOVE 105                        TO WS-105-JRNL-FORMAT-NO.    
ACT368     IF WS-105-QUANTITY-ENTERED NOT NUMERIC                       
ACT368        MOVE 0                       TO WS-105-QUANTITY-ENTERED   
ACT368     END-IF.                                                      
ACT368     MOVE WS-4822-AMT-ORIG-ENTERED   TO WS-105-AMT-POSTED         
ACT368                                        WS-AMT-POSTED-TOTAL.      
ACT368     MOVE WS-4822-AMT-ORIG-ENTERED   TO WS-105-AMOUNT-ENTERED.    
ACT368     MOVE SPACES                     TO WS-105-COST-CENTER.       
ACT368     MOVE SPACES                     TO                           
ACT368                                     WS-105-NATURE-OF-EXPENDITURE.
ACT368     MOVE SPACES                     TO WS-105-FUNCTION-CODE.     
ACT368     MOVE WS-GEN-LED-REBATE          TO WS-105-ACCT-GEN-LED-CR    
ACT368                                        AU-GL-ACCT-CREDIT         
ACT368     MOVE WS-4822-DTL-GL-NO          TO WS-105-ACCT-GEN-LED-DR    
ACT368                                        AU-GL-ACCT-DEBIT          
ACT368     MOVE SPACES                     TO WS-105-AR-AGE             
ACT368                                        AU-CODE-AR-AGE            
ACT368     MOVE WS-S                       TO AR-CODE-TRAN-TYPE         
ACT368     MOVE 'CSR04822B'                TO AR-APPL-PROGRAM-ID        
ACT368     MOVE 23                         TO AR-TRAN-COMMENT-LEN       
ACT368     MOVE 'APPLIED TO THIS ACCOUNT'  TO AR-TRAN-COMMENT-TEXT      
ACT368                                                                  
ACT368     MOVE WS-CURRENT-DATE            TO WS-105-DATE-AR-BILLED.    
ACT368     MOVE WS-4822-CNT-ITEM-ID        TO WS-105-ITEM-ID-NO.        
ACT368                                                                  
ACT380     COMPUTE AT-TOTAL-AR-BALANCE =                                
ACT380             AT-TOTAL-AR-BALANCE - WS-AMT-POSTED-TOTAL.           
ACT368                                                                  
ACT368     MOVE ZEROES                     TO WS-105-DETAIL-END-AR-BAL. 
ACT380     MOVE AT-TOTAL-AR-BALANCE        TO WS-105-ACCT-END-AR-BAL    
ACT380                                        WS-105-DETAIL-END-BAL.    
ACT368     MOVE WS-4822-REV-DISTRICT-CD    TO                           
ACT368                                     WS-105-CODE-REVENUE-DISTRICT.
ACT368     MOVE PR-CODE-PREMISE-STAT       TO                           
ACT368                                     WS-105-CODE-PREMISE-STATUS.  
ACT368     MOVE CU-CODE-EMPL-ACCT          TO WS-105-CODE-EMPL-ACCT.    
ACT368     MOVE AT-CODE-COMPANY-ACCT       TO WS-105-CODE-COMPANY-ACCT. 
ACT368     MOVE AT-CODE-ACCT-STAT          TO                           
ACT368                                     WS-105-CODE-ACCOUNT-STATUS.  
ACT368     MOVE 1                          TO WS-100-JRNL-TRAN-APPL-NO. 
ACT368     MOVE WS-AMT-POSTED-TOTAL        TO WS-JRNL-CASH-DEBIT-AMT    
ACT368                                        WS-JRNL-RCV-CREDIT-AMT.   
ACT368     MOVE CJF00105                   TO WS-100-USER-DEFINED-AREA. 
ACT368     MOVE WS-JRNL-ONLY               TO WS-JRNL-OPERATION-RQST.   
ACT368                                                                  
ACT368     PERFORM 6060-JRNL-ONLY-JRNL-ROUTINE THRU 6060-EXIT.          
ACT368     PERFORM 6065-CALL-JRNL-ROUTINE      THRU 6065-EXIT.          
ACT368                                                                  
ACT368     IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
ACT368        NEXT SENTENCE                                             
ACT368     ELSE                                                         
ACT368        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT368        MOVE '6145'                    TO ACTIVE-PARAGRAPH        
ACT368        MOVE 'USER ABEND'              TO ABEND-FUNCTION          
ACT368        MOVE WS-Y                      TO WS-USER-FORCE-ABEND     
ACT368        SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT368        PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
ACT368     END-IF.                                                      
ACT368                                                                  
ACT368     MOVE AT-ACCOUNT-NO              TO AR-ACCOUNT-NO             
ACT368                                        AU-ACCOUNT-NO.            
ACT368     MOVE WS-CURRENT-TIMESTAMP       TO AR-TRANS-HIST-SEQ-NO      
ACT368                                        AU-TRANS-HIST-SEQ-NO.     
ACT368     MOVE WS-CURRENT-DATE            TO AR-DATE-TRANS.            
ACT368     MOVE 1                          TO AU-TRAN-APPL-NO.          
ACT380     MOVE WS-AMT-POSTED-TOTAL        TO AR-AMT-ORIG-ENTERED       
ACT380                                        AU-AMT-POSTED.            
ACT368     MOVE ZEROES                     TO AR-AMT-BILLED-UNPAID.     
ACT368     MOVE WS-105-DETAIL-END-BAL      TO AR-AMT-BILLED-UNPAID.     
ACT368     MOVE WS-4822-CNT-ITEM-ID        TO AU-ITEM-ID.               
ACT368     MOVE PF-RESP-AREA-ID            TO AR-RESP-AREA-ID.          
ACT368     MOVE SPACES                     TO AR-PYMT-FACILITY-CD.      
ACT368     MOVE WS-4822-USER-ID            TO AR-USER-ID.               
ACT368     MOVE AT-COMPANY-NO              TO AR-COMPANY-NO.            
ACT368                                                                  
ACT368     MOVE WS-CD-LOCAL-OFFICE         TO AR-CASH-LOCAL-OFFICE.     
ACT368     MOVE WS-CD-COMPANY-NO           TO AR-CASH-COMPANY-NO.       
ACT368     MOVE WS-CD-REPORT-NO            TO AR-CASH-REPORT-NO.        
ACT368     MOVE WS-CD-REPORT-DATE          TO AR-DATE-CASH-REPORT.      
ACT368     MOVE WS-CASH-DRAWER-ID          TO AR-CASH-DRAWER-ID.        
ACT368                                                                  
ACT368     MOVE SPACES                     TO AR-RECORD-ONLY-FL         
ACT368                                        AR-DATE-ORIG-PYMT.        
ACT368     MOVE -1                         TO WS-DATE-ORIG-PYMT-IND.    
ACT368     MOVE WS-4822-CODE-CONTRACT-TYPE TO AU-CODE-CONTRACT-TYPE.    
ACT368     MOVE SPACES                     TO AU-CURRENCY-TYPE.         
ACT368     MOVE ZEROES                     TO AU-CURRENCY-AMT.          
ACT368                                                                  
ACT368     PERFORM 6080-LOAD-AR-TRANS-HIST    THRU 6080-EXIT.           
ACT368     PERFORM 8310-UPDATE-ACCOUNT        THRU 8310-EXIT.           
ACT368                                                                  
ACT368     PERFORM 9910-SQL-ERROR             THRU 9910-EXIT.           
ACT368                                                                  
ACT368 6145-EXIT.                                                       
ACT368     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6150-NEW-CONTRACT-PROCESS.                                     *        
      ******************************************************************        
       6150-NEW-CONTRACT-PROCESS.                                       
                                                                        
           IF WS-4822-AMT-ORIG-ENTERED EQUAL WS-ZERO                    
              GO TO 6150-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-4822-CODE-BILL-TYPE EQUAL WS-MNTHLY-CREDIT  OR         
                                           WS-MNTHLY-CHARGE  OR         
                                           WS-ONETIME-REBATE-CHK        
              PERFORM 5120-WRITE-TRAN-HIST-INSERT                       
                                               THRU 5120-EXIT           
           END-IF.                                                      
                                                                        
           IF WS-4822-CODE-BILL-TYPE EQUAL WS-MNTHLY-CREDIT  OR         
ACT368        WS-4822-REBATE-CD      EQUAL WS-REBATE-TO-CREDIT-ACCT OR  
ACT368                                     WS-ONETIME-REBATE-CHK        
ACT368        IF WS-4822-REBATE-CD EQUAL WS-REBATE-TO-CREDIT-ACCT       
ACT368           PERFORM 6155-CREATE-AR-CNTL   THRU 6155-EXIT           
ACT368        END-IF                                                    
                                                                        
              PERFORM 6600-INSERT-CONTRACT     THRU 6600-EXIT           
              GO TO 6150-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE AT-ACCOUNT-NO               TO AC-ACCOUNT-NO.           
           MOVE WS-PYMT-PRIORITY-100        TO AC-PYMT-PRIORITY-LVL.    
           MOVE WS-ZERO                     TO AC-ITEM-ID.              
                                                                        
           PERFORM 7500-SELECT-AR-CNTL-SUMM    THRU 7500-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-ZERO               TO WS-SUMM-AC-AMT-AR-DAY-00    
                                            WS-SUMM-AC-AMT-AR-DAY-30    
                                            WS-SUMM-AC-AMT-AR-DAY-60    
                                            WS-SUMM-AC-AMT-AR-DAY-90    
                                            WS-SUMM-AC-AMT-UNUSED-CR    
                                            WS-SUMM-AC-AMT-TRAN-BALANCE 
                                            WS-SUMM-AC-TOT-SUMM-UNBILLED
              MOVE WS-CURRENT-TIMESTAMP  TO WS-AC-LAST-UPDATE-TS-SUMM   
              PERFORM 8015-INSERT-SUMM-CSS-AR-CNTL THRU 8015-EXIT       
           END-IF.                                                      
                                                                        
      *    AMT-TRAN-BALANCE IS 0 FOR TYPE B - MONTHLY CHARGE BECAUSE            
      *    WE'RE GOING TO CHARGE CUSTOMER FOREVER AND EVER.                     
           IF WS-4822-CODE-BILL-TYPE EQUAL WS-MNTHLY-CHARGE             
              MOVE WS-ZERO                  TO AC-AMT-TRAN-BALANCE      
                                               AC-AMT-AR-DAY-00         
           ELSE                                                         
              ADD WS-4822-AMT-ORIG-ENTERED  TO AC-AMT-TRAN-BALANCE      
              IF WS-4822-AMT-DOWN-PYMT GREATER THAN WS-ZERO             
                 MOVE WS-DOWN-PMT-JRNL-AMT  TO AC-AMT-AR-DAY-00         
              ELSE                                                      
                 MOVE WS-ZERO               TO AC-AMT-AR-DAY-00         
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *    IF WS-4822-REBATE-CD EQUAL W-LT-REDUCE-FINANCE                       
      *       SUBTRACT WS-4822-REBATE-AMOUNT FROM AC-AMT-TRAN-BALANCE           
      *    END-IF.                                                              
                                                                        
           MOVE WS-4822-CNT-ITEM-ID         TO AC-ITEM-ID.              
           MOVE ZEROES                      TO AC-AMT-AR-DAY-30         
                                               AC-AMT-AR-DAY-60         
                                               AC-AMT-AR-DAY-90         
                                               AC-AMT-UNUSED-CR         
                                               AC-TOT-SUMM-UNBILLED     
                                                                        
           IF WS-4822-ADV-COLL NOT EQUAL WS-YES                         
              PERFORM 8020-INSERT-AR-CNTL-DET  THRU 8020-EXIT           
           ELSE                                                         
              IF AC-AMT-TRAN-BALANCE EQUAL WS-ZERO                      
                 PERFORM 8035-DELETE-CSS-AR-CNTL                        
                                               THRU 8035-EXIT           
                 MOVE WS-CONTRACT-PAID      TO WS-4822-CNT-STATUS-CD    
                 MOVE WS-CURRENT-DATE       TO WS-4822-STATUS-CHANGE-DT 
              ELSE                                                      
                 PERFORM 8025-UPDATE-AR-CNTL-DET                        
                                               THRU 8025-EXIT           
              END-IF                                                    
           END-IF                                                       
                                                                        
           ADD AC-AMT-AR-DAY-00             TO AT-TOTAL-AR-BALANCE      
                                               WS-SUMM-AC-AMT-AR-DAY-00.
           MOVE WS-ZERO                     TO AC-ITEM-ID.              
           PERFORM 8030-UPDATE-AR-CNTL-SUMM    THRU 8030-EXIT.          
           PERFORM 6600-INSERT-CONTRACT        THRU 6600-EXIT.          
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.   
           MOVE WS-A                        TO WS-CODE-CONTRACT.        
           MOVE WS-CODES-DATA-PRESENT       TO AT-CODES-DATA-PRESENT.   
                                                                        
       6150-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT368******************************************************************10702900
ACT368*                                                                 10703000
ACT368* 6155-CREATE-AR-CNTL                                             10703100
ACT368******************************************************************10703300
ACT368 6155-CREATE-AR-CNTL.                                             
ACT368*                                                                 10703600
ACT368                                                                  
ACT373     MOVE WS-ZERO                TO WS-SUMM-AC-AMT-AR-DAY-00      
ACT373                                    WS-SUMM-AC-AMT-AR-DAY-30      
ACT373                                    WS-SUMM-AC-AMT-AR-DAY-60      
ACT373                                    WS-SUMM-AC-AMT-AR-DAY-90      
ACT373                                    WS-SUMM-AC-AMT-UNUSED-CR      
ACT373                                    WS-SUMM-AC-AMT-TRAN-BALANCE   
ACT373                                    WS-SUMM-AC-TOT-SUMM-UNBILLED. 
ACT373     MOVE WS-CURRENT-TIMESTAMP   TO WS-AC-LAST-UPDATE-TS-SUMM.    
ACT368                                                                  
ACT368*    AR CONTROL HEADER PROCESS                                    10703600
ACT368     MOVE AT-ACCOUNT-NO          TO AC-ACCOUNT-NO.                
ACT368     MOVE WS-AR-CIA              TO AC-PYMT-PRIORITY-LVL.         
ACT368     MOVE 0                      TO AC-ITEM-ID.                   
ACT368     PERFORM 7500-SELECT-AR-CNTL-SUMM       THRU 7500-EXIT        
ACT368*                                                                 10704300
ACT368     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT368         COMPUTE WS-SUMM-AC-AMT-UNUSED-CR =                       
ACT368               WS-SUMM-AC-AMT-UNUSED-CR - WS-4822-AMT-ORIG-ENTERED
ACT368         MOVE WS-SUMM-AC-AMT-UNUSED-CR   TO AC-AMT-UNUSED-CR      
ACT368         PERFORM 8025-UPDATE-AR-CNTL-DET    THRU 8025-EXIT        
ACT368     ELSE                                                         
ACT368         MOVE WS-4822-AMT-ORIG-ENTERED TO AC-AMT-UNUSED-CR        
ACT368         COMPUTE WS-SUMM-AC-AMT-UNUSED-CR = AC-AMT-UNUSED-CR * -1 
ACT368         MOVE ZEROES             TO WS-SUMM-AC-AMT-TRAN-BALANCE   
ACT368         MOVE ZEROES             TO WS-SUMM-AC-TOT-SUMM-UNBILLED  
ACT368         PERFORM 8015-INSERT-SUMM-CSS-AR-CNTL THRU 8015-EXIT      
ACT368     END-IF.                                                      
ACT373                                                                  
ACT373*    AR CONTROL DETAIL PROCESS                                            
ACT373     MOVE WS-ZERO                TO WS-SUMM-AC-AMT-AR-DAY-00      
ACT373                                    WS-SUMM-AC-AMT-AR-DAY-30      
ACT373                                    WS-SUMM-AC-AMT-AR-DAY-60      
ACT373                                    WS-SUMM-AC-AMT-AR-DAY-90      
ACT373                                    WS-SUMM-AC-AMT-UNUSED-CR      
ACT373                                    WS-SUMM-AC-AMT-TRAN-BALANCE   
ACT373                                    WS-SUMM-AC-TOT-SUMM-UNBILLED. 
ACT373     MOVE WS-CURRENT-TIMESTAMP   TO WS-AC-LAST-UPDATE-TS-SUMM.    
ACT373                                                                  
ACT368     MOVE AT-ACCOUNT-NO          TO AC-ACCOUNT-NO.                
ACT368     MOVE WS-AR-CIA              TO AC-PYMT-PRIORITY-LVL.         
ACT368     MOVE 1                      TO AC-ITEM-ID.                   
ACT368                                                                  
ACT368     PERFORM  7500-SELECT-AR-CNTL-SUMM      THRU 7500-EXIT        
ACT368*                                                                 10704300
ACT368     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT368         COMPUTE WS-SUMM-AC-AMT-UNUSED-CR =                       
ACT368            WS-SUMM-AC-AMT-UNUSED-CR - WS-4822-AMT-ORIG-ENTERED   
ACT368         MOVE WS-SUMM-AC-AMT-UNUSED-CR    TO AC-AMT-UNUSED-CR     
ACT368         COMPUTE WS-SUMM-AC-AMT-TRAN-BALANCE =                    
ACT368            WS-SUMM-AC-AMT-TRAN-BALANCE - WS-4822-AMT-ORIG-ENTERED
ACT368         MOVE WS-SUMM-AC-AMT-TRAN-BALANCE TO AC-AMT-TRAN-BALANCE  
ACT368         PERFORM 8025-UPDATE-AR-CNTL-DET    THRU 8025-EXIT        
ACT368     ELSE                                                         
ACT368         MOVE WS-4822-AMT-ORIG-ENTERED    TO AC-AMT-UNUSED-CR     
ACT373         COMPUTE WS-SUMM-AC-AMT-UNUSED-CR = AC-AMT-UNUSED-CR * -1 
ACT376         MOVE WS-SUMM-AC-AMT-UNUSED-CR    TO                      
ACT373                                       WS-SUMM-AC-AMT-TRAN-BALANCE
ACT373         PERFORM 8015-INSERT-SUMM-CSS-AR-CNTL THRU 8015-EXIT      
ACT368     END-IF.                                                      
ACT368                                                                  
ACT368 6155-EXIT.                                                       
ACT368     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6160-POST-CREDIT-TO-THE-ACCT.                                  *        
      ******************************************************************        
ACT368*6160-POST-CREDIT-TO-THE-ACCT.                                            
ACT368*                                                                         
ACT368*    LOAD ALL GL NUMBERS FOR UNDIRECTED                                   
ACT368*    PERFORM 6007-DETERMINE-GL-NUMBERS   THRU 6007-EXIT.                  
ACT368*                                                                         
ACT368*    LOAD VARIABLES AND PAYMENT PRIORITY TABLE                            
ACT368*    MOVE WS-U                        TO WS-PAR-UPDATE-TYPE               
ACT368*    MOVE WS-ONE                      TO C9-PMT-PRTY-SCHEDULE.            
ACT368*                                                                         
ACT368*    CPD0010S - THIS WILL PERFROM THE BELOW ACTION.                       
ACT368*    PERFORM 6722B-OPEN-AR-PMT-PRTY      THRU 6722B-EXIT.                 
ACT368*    PERFORM 6722C-FETCH-AR-PMT-PRTY     THRU 6722C-EXIT.                 
ACT368*    PERFORM 6722D-LOAD-AR-PMT-PRTY      THRU 6722D-EXIT                  
ACT368*       VARYING WS-PAR-SUB FROM 1 BY 1                                    
ACT368*         UNTIL WS-PAR-SUB GREATER THAN 52                                
ACT368*            OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.                    
ACT368*    PERFORM 6722E-CLOSE-AR-PMT-PRTY     THRU 6722E-EXIT.                 
ACT368*                                                                         
ACT368*    REBATE AMOUNT - DECIDED TO STORE IT IN AMT-ORIG-ENTERED CLMN         
ACT368*    MOVE WS-4822-REBATE-AMOUNT       TO WS-AMT-CASH.                     
ACT368*    MOVE WS-4822-AMT-ORIG-ENTERED    TO WS-AMT-CASH.                     
ACT368*    MOVE WS-YES                      TO WS-PAR-JOURNAL-105.              
ACT368*                                                                         
ACT368*    PROCESS THE UPDATE FOR CREDIT REBATE                                 
ACT368*    PERFORM 6165-SETUP-AND-EXEC-CP010   THRU 6165-EXIT.                  
ACT368*                                                                         
ACT368*    PERFORM 9910-SQL-ERROR              THRU 9910-EXIT.                  
ACT368*                                                                         
ACT368*6160-EXIT.                                                               
ACT368*    EXIT.                                                                
                                                                        
ACT368******************************************************************        
ACT368*                                                                *        
ACT368* 6165-SETUP-AND-EXEC-CP010.                                     *        
ACT368******************************************************************        
ACT368*6165-SETUP-AND-EXEC-CP010.                                               
ACT368*                                                                         
ACT368*    MOVE WS-AMT-CASH                 TO WS-PAYMENT-AMOUNT                
ACT368*                                        WS-PAYMENT-AMOUNT-TOTAL.         
ACT368*                                                                         
ACT368*    MOVE WS-ZERO                     TO WS-AMT-CHECK                     
ACT368*                                        WS-AMT-MONEY-ORDER               
ACT368*                                        WS-AMT-LIHEAP                    
ACT368*                                        WS-AMT-CREDIT-CARD.              
ACT368*                                                                         
ACT368*    MOVE SPACES                      TO WS-PAR-MESSAGE-NO.               
ACT368*                                                                         
ACT368*    MOVE AT-COMPANY-NO               TO WS-100-COMPANY-NO.               
ACT368*    MOVE WS-NINE                     TO WS-TRAN-OPER-LEVEL.              
ACT368*    MOVE WS-ONE                      TO WS-TRAN-OCAP-FIELD               
ACT368*                                        WS-TRAN-OCAP-VALUE.              
ACT368*    MOVE WS-C                        TO WS-TRAN-JRNL-TYPE.               
ACT368*    MOVE WS-N                        TO WS-TRAN-HOLD-EXEMPT-FLAG.        
ACT368*                                                                         
ACT368*    MOVE WS-4822-USER-ID             TO WS-JRNL-OL-TEMP-ID.              
ACT368*    MOVE WS-JRNL-CK-OPER-ID          TO WS-JRNL-OPERATION-RQST.          
ACT368*    MOVE WS-PAR-EIBTRNID             TO                                  
ACT368*                                     WS-100-CODE-TERMINAL-TRAN.          
ACT368*                                                                         
ACT368*    PERFORM 6065-CALL-JRNL-ROUTINE      THRU 6065-EXIT.                  
ACT368*    MOVE WS-JRNL-OL-OPR-LOC          TO WS-TERM-LOC.                     
ACT368*                                                                         
ACT368*    PERFORM 6060-JRNL-ONLY-JRNL-ROUTINE THRU 6060-EXIT.                  
ACT368*                                                                         
ACT368*    PERFORM 6070-JRNL-TERM-LOC-ROUTINE  THRU 6070-EXIT.                  
ACT368*                                                                         
ACT368*    MOVE WS-JRNL-VALIDATE-OPER       TO WS-JRNL-OPERATION-RQST.          
ACT368*    PERFORM 6065-CALL-JRNL-ROUTINE      THRU 6065-EXIT.                  
ACT368*                                                                         
ACT368*    MOVE WS-A                        TO WS-100-JRNL-SORT-ID.             
ACT368*    MOVE AT-ACCOUNT-NO               TO WS-100-ACCT-NO.                  
ACT368*    MOVE AT-CUSTOMER-NO              TO WS-100-CUSTOMER-NO.              
ACT368*    MOVE AT-PREMISE-NO               TO WS-100-PREMISE-NO.               
ACT368*    MOVE WS-PAR-EIBTRNID             TO WS-100-CODE-TERMINAL-TRAN        
ACT368*    ADD WS-ONE                       TO WS-100-JRNL-TRAN-APPL-NO.        
ACT368*    MOVE WS-CURRENT-DATE             TO WS-100-DATE-LAST-ACTION          
ACT368*                                        AT-DATE-LAST-ACTION.             
ACT368*    MOVE WS-C                        TO WS-100-CODE-ENTRY-SOURCE.        
ACT368*    MOVE AT-LOCAL-OFFICE             TO WS-100-LOCAL-OFFICE-CD.          
ACT368*                                                                         
ACT368*    MOVE WS-TERM-LOC                 TO WS-PAR-ACCESS-LOC.               
ACT368*    MOVE WS-4822-USER-ID             TO WS-PAR-OPERATOR-ID.              
ACT368*    MOVE PF-RESP-AREA-ID             TO WS-PAR-RESP-AREA.                
ACT368*    MOVE WS-I                        TO WS-PAR-CODE-TRAN-TYPE.           
ACT368*    MOVE 'CSR04822B'                 TO WS-PAR-APPL-PROG-ID.             
ACT368*    MOVE SPACES                      TO WS-PAR-PYMT-FACILITY-CD.         
ACT368*    MOVE CT-CNT-ITEM-ID              TO WS-4822-CNT-ITEM-ID.             
ACT368*                                                                         
ACT368*                                                                         
ACT368*    MOVE 'APPLIED TO THIS ACCOUNT'   TO                                  
ACT368*                                     WS-PAR-AR-TRAN-COMMENT-TEXT.        
ACT368*    MOVE 23                          TO                                  
ACT368*                                     WS-PAR-AR-TRAN-COMMENT-LEN.         
ACT368*    MOVE WS-CURRENT-DATE             TO WS-PAR-REPORT-DATE.              
ACT368*                                                                         
ACT368*    MOVE WS-CD-COMPANY-NO            TO WS-JRNL-OL-COMPANY.              
ACT368*    MOVE WS-CD-LOCAL-OFFICE          TO WS-JRNL-OL-LOC-OFF.              
ACT368*    MOVE WS-CD-REPORT-NO             TO WS-JRNL-OL-REPORT-NO.            
ACT368*    MOVE WS-CD-REPORT-DATE           TO WS-JRNL-OL-REPORT-DT.            
ACT368*    MOVE WS-CASH-DRAWER-ID           TO WS-JRNL-OL-CASH-DRWR.            
ACT368*                                                                         
ACT368*    MOVE WS-CD-COMPANY-NO            TO WS-PAR-COMPANY-NO.               
ACT368*    MOVE WS-CD-LOCAL-OFFICE          TO WS-PAR-LOCAL-OFFICE.             
ACT368*    MOVE WS-CD-REPORT-NO             TO WS-PAR-REPORT-NO.                
ACT368*    MOVE WS-CD-REPORT-DATE           TO WS-PAR-REPORT-DATE.              
ACT368*    MOVE WS-CASH-DRAWER-ID           TO WS-PAR-CASH-DRAWER.              
ACT368*    MOVE WS-4822-REBATE-AMOUNT       TO WS-PAR-GEN-LEDG-DB.              
ACT368*                                                                         
ACT368*    CPD00010 - WILL PERFROM THE BELOW ACTION                             
ACT368*    PERFORM 6700-APPLY-PAYMENT          THRU 6700-EXIT.                  
ACT368*                                                                         
ACT368*    IF PYMT-WAS-NOT-SUCCESSFUL                                           
ACT368*       MOVE 5003                    TO WS-4822-APPL-CNT-RETURN-CD        
ACT368*       MOVE PROGRAM-NAME            TO ABEND-PROGRAM                     
ACT368*       MOVE '6165'                  TO ACTIVE-PARAGRAPH                  
ACT368*       MOVE 'USERABEN'              TO ABEND-FUNCTION                    
ACT368*       MOVE W-LT-YES                TO WS-USER-FORCE-ABEND               
ACT368*       MOVE 'PAYMENT ABEND'         TO DSNTIAR-MESSAGE-1                 
P00851*       SET  CPD4822-DB2-ERR-FOUND   TO TRUE                              
ACT368*       PERFORM 9910-SQL-ERROR          THRU 9910-EXIT                    
ACT368*    END-IF.                                                              
ACT368*                                                                         
ACT368*6165-EXIT.                                                               
ACT368*    EXIT.                                                                
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6170-TERMINATE-JRNL.                                           *        
      ******************************************************************        
       6170-TERMINATE-JRNL.                                             
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY          TO WS-JRNL-OPERATION-RQST.  
           PERFORM 6065-CALL-JRNL-ROUTINE      THRU 6065-EXIT.          
                                                                        
           IF WS-JRNL-RTRN-CODE NOT EQUAL SPACES                        
              MOVE 5004                    TO WS-4822-APPL-CNT-RETURN-CD
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '6170'                  TO ACTIVE-PARAGRAPH          
              MOVE 'USER ABEND'            TO ABEND-FUNCTION            
              MOVE WS-YES                  TO WS-USER-FORCE-ABEND       
              MOVE 'UNSUCCESSFUL JOURNAL'  TO DSNTIAR-MESSAGE-1         
P00851        SET  CPD4822-DB2-ERR-FOUND   TO TRUE                      
              PERFORM 9910-SQL-ERROR          THRU 9910-EXIT            
           END-IF.                                                      
                                                                        
       6170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6175-WRITE-FM.                                                 *        
      ******************************************************************        
       6175-WRITE-FM.                                                   
                                                                        
           PERFORM 7010-SELECT-TIMESTAMP       THRU 7010-EXIT.          
                                                                        
           MOVE 1                           TO WS-100-JRNL-TRAN-APPL-NO.
           MOVE WS-CURRENT-DATE             TO AR-DATE-TRANS.           
           MOVE WS-A                        TO AR-CODE-TRAN-TYPE.       
           MOVE 1                           TO AU-TRAN-APPL-NO.         
           MOVE WS-4822-CNT-ITEM-ID         TO WS-105-ITEM-ID-NO.       
                                                                        
           ADD  AC-AMT-AR-DAY-00                                        
                AC-AMT-AR-DAY-30                                        
                AC-AMT-AR-DAY-60                                        
                AC-AMT-AR-DAY-90                                        
                GIVING AR-AMT-ORIG-ENTERED.                             
                                                                        
           MOVE AR-AMT-ORIG-ENTERED         TO AU-AMT-POSTED            
                                               WS-105-AMT-POSTED        
                                               WS-105-AMOUNT-ENTERED    
                                               WS-JRNL-GEN-LEG-DEBIT-AMT
                                               WS-JRNL-RCV-CREDIT-AMT.  
           MOVE AC-AMT-TRAN-BALANCE         TO WS-105-DETAIL-END-BAL.   
           MOVE WS-GEN-LED-CONTRACT         TO AU-GL-ACCT-CREDIT        
                                               AU-GL-ACCT-DEBIT         
                                               WS-105-ACCT-GEN-LED-CR   
                                               WS-105-ACCT-GEN-LED-DR.  
           SUBTRACT AU-AMT-POSTED FROM AT-TOTAL-AR-BALANCE.             
                                                                        
           MOVE AT-TOTAL-AR-BALANCE         TO AR-AMT-BILLED-UNPAID     
                                               WS-105-ACCT-END-AR-BAL   
                                               WS-105-DETAIL-END-AR-BAL.
           MOVE SPACES                      TO WS-105-CASH-DRAWER-USED. 
           MOVE 105                         TO WS-105-JRNL-FORMAT-NO.   
           MOVE WS-F                        TO WS-105-AR-AGE            
                                               AU-CODE-AR-AGE.          
           MOVE WS-CURRENT-DATE             TO WS-105-DATE-AR-BILLED    
                                               AR-DATE-TRANS.           
           MOVE WS-4822-CNT-ITEM-ID         TO WS-105-ITEM-ID-NO        
                                               AU-ITEM-ID.              
                                                                        
           MOVE WS-4822-REV-DISTRICT-CD     TO                          
                                     WS-105-CODE-REVENUE-DISTRICT.      
           MOVE PR-CODE-PREMISE-STAT        TO                          
                                            WS-105-CODE-PREMISE-STATUS. 
           MOVE CU-CODE-EMPL-ACCT           TO WS-105-CODE-EMPL-ACCT.   
           MOVE AT-CODE-COMPANY-ACCT        TO WS-105-CODE-COMPANY-ACCT.
           MOVE AT-CODE-ACCT-STAT           TO                          
                                            WS-105-CODE-ACCOUNT-STATUS. 
           MOVE AT-DATE-LAST-ACTION         TO WS-100-DATE-LAST-ACTION. 
           MOVE CJF00105                    TO WS-100-USER-DEFINED-AREA.
           MOVE WS-JRNL-ONLY                TO WS-JRNL-OPERATION-RQST.  
           PERFORM 6060-JRNL-ONLY-JRNL-ROUTINE THRU 6060-EXIT.          
           PERFORM 6065-CALL-JRNL-ROUTINE      THRU 6065-EXIT.          
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE 5008                    TO WS-4822-APPL-CNT-RETURN-CD
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '6175'                   TO ACTIVE-PARAGRAPH         
              MOVE 'USER ABEND'             TO ABEND-FUNCTION           
              MOVE WS-YES                   TO WS-USER-FORCE-ABEND      
              MOVE 'UNSUCCESSFUL JOURNAL'   TO DSNTIAR-MESSAGE-1        
P00851        SET  CPD4822-DB2-ERR-FOUND    TO TRUE                     
              PERFORM 9910-SQL-ERROR THRU 9910-EXIT                     
           END-IF.                                                      
                                                                        
           MOVE AT-ACCOUNT-NO               TO AR-ACCOUNT-NO            
                                               AU-ACCOUNT-NO.           
           MOVE WS-CURRENT-TIMESTAMP        TO AR-TRANS-HIST-SEQ-NO     
                                               AU-TRANS-HIST-SEQ-NO.    
           MOVE PF-RESP-AREA-ID             TO AR-RESP-AREA-ID.         
           MOVE 'CSR04822D'                 TO AR-APPL-PROGRAM-ID       
           MOVE SPACES                      TO AR-PYMT-FACILITY-CD.     
           MOVE WS-4822-USER-ID             TO AR-USER-ID.              
           MOVE AT-COMPANY-NO               TO AR-COMPANY-NO.           
                                                                        
           MOVE WS-CD-LOCAL-OFFICE          TO AR-CASH-LOCAL-OFFICE.    
           MOVE WS-CD-COMPANY-NO            TO AR-CASH-COMPANY-NO.      
           MOVE WS-CD-REPORT-NO             TO AR-CASH-REPORT-NO.       
           MOVE WS-CD-REPORT-DATE           TO AR-DATE-CASH-REPORT.     
           MOVE WS-CASH-DRAWER-ID           TO AR-CASH-DRAWER-ID.       
                                                                        
           MOVE 19                          TO AR-TRAN-COMMENT-LEN      
           MOVE 'CANCEL DOWN PAYMENT'       TO AR-TRAN-COMMENT-TEXT     
           MOVE SPACES                      TO AR-RECORD-ONLY-FL        
                                               AR-DATE-ORIG-PYMT.       
           MOVE -1                          TO WS-DATE-ORIG-PYMT-IND.   
           MOVE WS-4822-CODE-CONTRACT-TYPE                              
                                            TO AU-CODE-CONTRACT-TYPE.   
           MOVE SPACES                      TO AU-CURRENCY-TYPE.        
           MOVE ZEROES                      TO AU-CURRENCY-AMT.         
                                                                        
           PERFORM 6080-LOAD-AR-TRANS-HIST     THRU 6080-EXIT.          
                                                                        
           MOVE WS-ZERO                     TO AC-AMT-AR-DAY-00         
                                               AC-AMT-AR-DAY-30         
                                               AC-AMT-AR-DAY-60         
                                               AC-AMT-AR-DAY-90.        
       6175-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6180-EXMPT-PSNC-FCLTY-DAMG-CNT.                                *        
      ******************************************************************        
       6180-EXMPT-PSNC-FCLTY-DAMG-CNT. .                                
                                                                        
           MOVE AT-CODE-LPC-XMT             TO WS-PREV-CODE-LPC-XMT     
           MOVE AT-CODE-DISC-OK             TO WS-PREV-CODE-DISC-OK     
           MOVE AT-NOTICE-EXEMPT-CD         TO WS-PREV-NOTICE-EXEMPT    
           MOVE AT-IVR-EXEMPT-CD            TO WS-PREV-IVR-EXEMPT       
           MOVE WS-NO                       TO WS-EXEMPT-UPDT           
                                                                        
           IF  CONTRACT-DELETE                                          
               MOVE WS-NO                   TO WS-OTHER-FAC-DMG-EXIST   
               PERFORM 7270-CHECK-OTHER-FACDMG THRU 7270-EXIT           
               IF OTHER-FAC-DMG-EXIST                                   
                  GO TO 6050-EXIT                                       
               END-IF                                                   
                                                                        
               IF WS-PREV-CODE-LPC-XMT NOT EQUAL SPACES                 
                  SET EXEMPT-UPDT           TO TRUE                     
                  MOVE SPACES               TO AT-CODE-LPC-XMT          
               END-IF                                                   
                                                                        
               IF WS-PREV-CODE-DISC-OK NOT EQUAL SPACES                 
                  SET EXEMPT-UPDT           TO TRUE                     
                  MOVE SPACES               TO AT-CODE-DISC-OK          
               END-IF                                                   
                                                                        
               IF WS-PREV-NOTICE-EXEMPT NOT EQUAL SPACES                
                  SET EXEMPT-UPDT           TO TRUE                     
                  MOVE SPACES               TO AT-NOTICE-EXEMPT-CD      
               END-IF                                                   
                                                                        
               IF WS-PREV-IVR-EXEMPT NOT EQUAL SPACES                   
                  SET EXEMPT-UPDT           TO TRUE                     
                  MOVE SPACES               TO AT-IVR-EXEMPT-CD         
               END-IF                                                   
                                                                        
               MOVE 'CSR04822D'             TO WS-APPL-PROGRAM-ID       
           ELSE                                                         
               IF WS-PREV-CODE-LPC-XMT NOT EQUAL 'L'                    
                  SET EXEMPT-UPDT           TO TRUE                     
                  MOVE 'L'                  TO AT-CODE-LPC-XMT          
               END-IF                                                   
                                                                        
               IF WS-PREV-CODE-DISC-OK NOT EQUAL 'L'                    
                  SET EXEMPT-UPDT           TO TRUE                     
                  MOVE 'L'                  TO AT-CODE-DISC-OK          
               END-IF                                                   
                                                                        
               IF WS-PREV-NOTICE-EXEMPT NOT EQUAL 'L'                   
                  SET EXEMPT-UPDT           TO TRUE                     
                  MOVE 'L'                  TO AT-NOTICE-EXEMPT-CD      
               END-IF                                                   
                                                                        
               IF WS-PREV-IVR-EXEMPT NOT EQUAL 'L'                      
                  SET EXEMPT-UPDT           TO TRUE                     
                  MOVE 'L'                  TO AT-IVR-EXEMPT-CD         
               END-IF                                                   
                                                                        
               MOVE 'CSR04822A'             TO WS-APPL-PROGRAM-ID       
           END-IF                                                       
                                                                        
           IF EXEMPT-UPDT                                               
              PERFORM 8050-UPDATE-EXEMPTIONS      THRU 8050-EXIT        
              PERFORM 5100-WRITE-TRAN-HIST-HEADER THRU 5100-EXIT        
              PERFORM 5130-WRITE-TRAN-DET-PSNC    THRU 5130-EXIT        
           END-IF.                                                      
                                                                        
       6180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6185-JOURNAL-CHARGE-AMT.                                       *        
      ******************************************************************        
       6185-JOURNAL-CHARGE-AMT.                                         
                                                                        
           IF CONTRACT-INSERT                                           
              MOVE  WS-4822-DTL-CHRG-AMT    TO AU-AMT-POSTED            
                                               WS-105-AMT-POSTED        
              MOVE WS-4822-DTL-GL-NO        TO WS-105-ACCT-GEN-LED-CR   
                                               AU-GL-ACCT-CREDIT        
              MOVE WS-GEN-LED-CONTRACT      TO WS-105-ACCT-GEN-LED-DR   
                                               AU-GL-ACCT-DEBIT         
              ADD  AU-AMT-POSTED            TO WS-AMT-POSTED-TOTAL      
              MOVE AU-AMT-POSTED            TO                          
                                          WS-JRNL-GEN-LEG-CREDIT-AMT    
                                          WS-JRNL-RCV-DEBIT-AMT         
           ELSE                                                         
              IF CONTRACT-DELETE                                        
                 COMPUTE WS-CHRG-AMT-HOLD ROUNDED =                     
                    WS-UNPAID-BALANCE * WS-4822-DTL-CHRG-AMT /          
                   ( WS-4822-AMT-ORIG-ENTERED  - WS-4822-ADD-ON-INTRST )
                                                                        
              MOVE  WS-CHRG-AMT-HOLD        TO AU-AMT-POSTED            
                                               WS-105-AMT-POSTED        
              MOVE WS-4822-DTL-GL-NO        TO WS-105-ACCT-GEN-LED-DR   
                                               AU-GL-ACCT-DEBIT         
              MOVE WS-GEN-LED-CONTRACT      TO WS-105-ACCT-GEN-LED-CR   
                                               AU-GL-ACCT-CREDIT        
              SUBTRACT AU-AMT-POSTED        FROM WS-AMT-POSTED-TOTAL    
              MOVE     AU-AMT-POSTED        TO WS-JRNL-GEN-LEG-DEBIT-AMT
                                               WS-JRNL-RCV-CREDIT-AMT   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-POSTED-TOTAL         TO WS-105-DETAIL-END-BAL.   
           MOVE ZEROES                      TO WS-105-DETAIL-END-AR-BAL.
           ADD 1                            TO WS-CNT-TRAN-APPL-NO.     
           MOVE WS-CNT-TRAN-APPL-NO         TO WS-100-JRNL-TRAN-APPL-NO 
                                               AU-TRAN-APPL-NO.         
           MOVE CJF00105                    TO WS-100-USER-DEFINED-AREA.
           MOVE WS-JRNL-ONLY                TO WS-JRNL-OPERATION-RQST.  
                                                                        
           PERFORM 6060-JRNL-ONLY-JRNL-ROUTINE THRU 6060-EXIT.          
           PERFORM 6065-CALL-JRNL-ROUTINE      THRU 6065-EXIT.          
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE 5009                    TO WS-4822-APPL-CNT-RETURN-CD
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6185'                    TO ACTIVE-PARAGRAPH        
              MOVE 'USER ABEND'              TO ABEND-FUNCTION          
              MOVE WS-YES                    TO WS-USER-FORCE-ABEND     
              MOVE 'UNSUCCESSFUL JOURNAL'    TO DSNTIAR-MESSAGE-1       
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
              PERFORM 9910-SQL-ERROR THRU 9910-EXIT                     
           END-IF.                                                      
                                                                        
      *    CPD00008 TO PERFORM AR TRANS HIST AND DETAILS TABLE                  
           PERFORM 6080-LOAD-AR-TRANS-HIST THRU 6080-EXIT.              
                                                                        
       6185-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6190-JRNL-REBATE.                                             *         
      *****************************************************************         
      *6190-JRNL-REBATE.                                                        
                                                                        
      *    MOVE SPACES                      TO WS-105-CASH-DRAWER-USED.         
      *    MOVE 105                         TO WS-105-JRNL-FORMAT-NO.           
                                                                        
      *    IF  WS-105-QUANTITY-ENTERED NOT NUMERIC                              
      *        MOVE WS-ZERO                 TO WS-105-QUANTITY-ENTERED          
      *    END-IF.                                                              
                                                                        
      *    MOVE WS-4822-REBATE-AMOUNT       TO WS-105-AMT-POSTED                
      *                                        WS-AMT-POSTED-TOTAL.             
      *    MOVE WS-4822-REBATE-AMOUNT       TO WS-105-AMOUNT-ENTERED.           
      *                                                                         
      *    IF CONTRACT-INSERT                                                   
      *       MOVE WS-GEN-LED-CONTRACT      TO WS-105-ACCT-GEN-LED-CR           
      *                                        AU-GL-ACCT-CREDIT                
      *       MOVE WS-P                     TO WS-105-AR-AGE                    
      *                                        AU-CODE-AR-AGE                   
      *       MOVE WS-I                     TO AR-CODE-TRAN-TYPE                
      *       MOVE 'CSR04822B'              TO AR-APPL-PROGRAM-ID               
      *       MOVE 16                       TO AR-TRAN-COMMENT-LEN              
      *       MOVE 'REDUCED FINANCES'       TO AR-TRAN-COMMENT-TEXT             
      *    ELSE                                                                 
      *       MOVE WS-GEN-LED-CONTRACT      TO WS-105-ACCT-GEN-LED-DR           
      *                                        AU-GL-ACCT-DEBIT                 
      *       MOVE SPACES                   TO WS-105-AR-AGE                    
      *                                        AU-CODE-AR-AGE                   
      *       MOVE WS-S                     TO AR-CODE-TRAN-TYPE                
      *       MOVE 'CSR04822E'              TO AR-APPL-PROGRAM-ID               
      *       MOVE WS-CNT-COMMENTS-LEN      TO AR-TRAN-COMMENT-LEN              
      *       MOVE WS-4822-CNT-COMMENTS-TXT TO AR-TRAN-COMMENT-TEXT             
      *    END-IF.                                                              
      *                                                                         
      *    MOVE WS-CURRENT-DATE             TO WS-105-DATE-AR-BILLED.           
      *    MOVE WS-4822-CNT-ITEM-ID         TO WS-105-ITEM-ID-NO.               
      *                                                                         
      *    IF CONTRACT-INSERT                                                   
      *       SUBTRACT WS-AMT-POSTED-TOTAL                                      
      *       FROM WS-4822-AMT-ORIG-ENTERED                                     
      *       GIVING WS-105-DETAIL-END-BAL                                      
      *       IF WS-4822-ADV-COLL EQUAL WS-YES                                  
      *          ADD AC-AMT-TRAN-BALANCE    TO WS-105-DETAIL-END-BAL            
      *       END-IF                                                            
      *    ELSE                                                                 
      *       ADD WS-AMT-POSTED-TOTAL       TO AC-AMT-TRAN-BALANCE              
      *       GIVING WS-105-DETAIL-END-BAL                                      
      *    END-IF.                                                              
      *                                                                         
      *    MOVE WS-ZERO                  TO WS-105-DETAIL-END-AR-BAL.           
      *    MOVE AT-TOTAL-AR-BALANCE      TO WS-105-ACCT-END-AR-BAL.             
      *    MOVE WS-4822-REV-DISTRICT-CD  TO WS-105-CODE-REVENUE-DISTRICT        
      *    MOVE PR-CODE-PREMISE-STAT     TO WS-105-CODE-PREMISE-STATUS.         
      *    MOVE CU-CODE-EMPL-ACCT        TO WS-105-CODE-EMPL-ACCT.              
      *    MOVE AT-CODE-COMPANY-ACCT     TO WS-105-CODE-COMPANY-ACCT.           
      *    MOVE AT-CODE-ACCT-STAT        TO WS-105-CODE-ACCOUNT-STATUS.         
      *    MOVE 1                        TO WS-100-JRNL-TRAN-APPL-NO.           
      *    MOVE WS-AMT-POSTED-TOTAL      TO WS-JRNL-CASH-DEBIT-AMT              
      *                                     WS-JRNL-RCV-CREDIT-AMT.             
      *    MOVE CJF00105                 TO WS-100-USER-DEFINED-AREA.           
      *    MOVE WS-JRNL-ONLY             TO WS-JRNL-OPERATION-RQST.             
      *    PERFORM 6065-CALL-JRNL-ROUTINE   THRU 6065-EXIT.                     
      *                                                                         
      *    IF WS-JRNL-RTRN-CODE NOT EQUAL SPACES                                
      *       MOVE 5005                    TO WS-4822-APPL-CNT-RETURN-CD        
      *       MOVE PROGRAM-NAME            TO ABEND-PROGRAM                     
      *       MOVE '6190'                  TO ACTIVE-PARAGRAPH                  
      *       MOVE 'USER ABEND'            TO ABEND-FUNCTION                    
      *       MOVE WS-YES                  TO WS-USER-FORCE-ABEND               
      *       MOVE 'UNSUCCESSFUL JOURNAL'  TO DSNTIAR-MESSAGE-1                 
P00851*       SET  CPD4822-DB2-ERR-FOUND   TO TRUE                              
      *       PERFORM 9910-SQL-ERROR          THRU 9910-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *    MOVE AT-ACCOUNT-NO               TO AR-ACCOUNT-NO                    
      *                                        AU-ACCOUNT-NO.                   
      *    PERFORM 7010-SELECT-TIMESTAMP       THRU 7010-EXIT.                  
      *    MOVE WS-CURRENT-TIMESTAMP        TO AR-TRANS-HIST-SEQ-NO             
      *                                        AU-TRANS-HIST-SEQ-NO.            
      *    MOVE WS-CURRENT-DATE             TO AR-DATE-TRANS.                   
      *    MOVE WS-ONE                      TO AU-TRAN-APPL-NO.                 
      *    MOVE WS-4822-REBATE-AMOUNT       TO AR-AMT-ORIG-ENTERED.             
      *    MOVE WS-4822-REBATE-AMOUNT       TO AU-AMT-POSTED                    
      *    MOVE ZEROES                      TO AR-AMT-BILLED-UNPAID             
      *     ADD AT-TOTAL-AR-BALANCE         TO AR-AMT-BILLED-UNPAID             
      *    MOVE WS-4822-CNT-ITEM-ID         TO AU-ITEM-ID.                      
      *                                                                         
      *    TO BE CHANGE THIS                                                    
      *    MOVE PF-RESP-AREA-ID             TO AR-RESP-AREA-ID.                 
      *    MOVE SPACES                      TO AR-PYMT-FACILITY-CD.             
      *    MOVE WS-4822-USER-ID             TO AR-USER-ID.                      
      *    MOVE AT-COMPANY-NO               TO AR-COMPANY-NO.                   
      *                                                                         
      *    MOVE WS-CD-LOCAL-OFFICE          TO AR-CASH-LOCAL-OFFICE.            
      *    MOVE WS-CD-COMPANY-NO            TO AR-CASH-COMPANY-NO.              
      *    MOVE WS-CD-REPORT-NO             TO AR-CASH-REPORT-NO.               
      *    MOVE WS-CD-REPORT-DATE           TO AR-DATE-CASH-REPORT.             
      *    MOVE WS-CASH-DRAWER-ID           TO AR-CASH-DRAWER-ID.               
      *                                                                         
      *    MOVE SPACES                      TO AR-RECORD-ONLY-FL                
      *                                        AR-DATE-ORIG-PYMT.               
      *    MOVE -1                          TO WS-DATE-ORIG-PYMT-IND.           
      *    MOVE WS-4822-CODE-CONTRACT-TYPE  TO AU-CODE-CONTRACT-TYPE.           
      *    MOVE SPACES                      TO AU-CURRENCY-TYPE.                
      *    MOVE WS-ZERO                     TO AU-CURRENCY-AMT.                 
      *    PERFORM 6080-LOAD-AR-TRANS-HIST     THRU 6080-EXIT.                  
      *                                                                         
      *    MOVE WS-4822-CNT-ITEM-ID         TO WS-105-ITEM-ID-NO.               
      *                                                                         
      *6190-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6195-JOURNAL-TAX.                                              *        
      ******************************************************************        
       6195-JOURNAL-TAX.                                                
                                                                        
           MOVE  AU-AMT-POSTED              TO WS-105-AMT-POSTED.       
                                                                        
           IF CONTRACT-INSERT                                           
              MOVE WS-GEN-LED-TAX           TO WS-105-ACCT-GEN-LED-CR   
                                               AU-GL-ACCT-CREDIT        
              MOVE WS-GEN-LED-CONTRACT      TO WS-105-ACCT-GEN-LED-DR   
                                               AU-GL-ACCT-DEBIT         
              ADD AU-AMT-POSTED             TO WS-AMT-POSTED-TOTAL      
              MOVE AU-AMT-POSTED            TO                          
                                            WS-JRNL-GEN-LEG-CREDIT-AMT  
                                            WS-JRNL-RCV-DEBIT-AMT       
           ELSE                                                         
              MOVE WS-GEN-LED-TAX           TO WS-105-ACCT-GEN-LED-DR   
                                               AU-GL-ACCT-DEBIT         
              MOVE WS-GEN-LED-CONTRACT      TO WS-105-ACCT-GEN-LED-CR   
                                               AU-GL-ACCT-CREDIT        
              SUBTRACT AU-AMT-POSTED        FROM WS-AMT-POSTED-TOTAL    
              MOVE AU-AMT-POSTED            TO                          
                                        WS-JRNL-GEN-LEG-DEBIT-AMT       
                                        WS-JRNL-RCV-CREDIT-AMT          
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-POSTED-TOTAL         TO WS-105-DETAIL-END-BAL.   
           MOVE ZEROES                      TO WS-105-DETAIL-END-AR-BAL.
                                                                        
                                                                        
           ADD 1                            TO WS-CNT-TRAN-APPL-NO.     
           MOVE WS-CNT-TRAN-APPL-NO         TO WS-100-JRNL-TRAN-APPL-NO 
                                               AU-TRAN-APPL-NO.         
                                                                        
           MOVE CJF00105                    TO WS-100-USER-DEFINED-AREA.
           MOVE WS-JRNL-ONLY                TO WS-JRNL-OPERATION-RQST.  
                                                                        
           PERFORM 6060-JRNL-ONLY-JRNL-ROUTINE THRU 6060-EXIT.          
           PERFORM 6065-CALL-JRNL-ROUTINE      THRU 6065-EXIT.          
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE 5010                    TO WS-4822-APPL-CNT-RETURN-CD
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '6195'                  TO ACTIVE-PARAGRAPH          
              MOVE 'USER ABEND'            TO ABEND-FUNCTION            
              MOVE WS-YES                  TO WS-USER-FORCE-ABEND       
              MOVE 'UNSUCCESSFUL JOURNAL'  TO DSNTIAR-MESSAGE-1         
P00851        SET  CPD4822-DB2-ERR-FOUND   TO TRUE                      
              PERFORM 9910-SQL-ERROR          THRU 9910-EXIT            
           END-IF.                                                      
                                                                        
      *    CALL CPD00008 TO PERFORM AR TRANS HIST AND DETAILS TABLE             
           PERFORM 6080-LOAD-AR-TRANS-HIST THRU 6080-EXIT.              
                                                                        
       6195-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6200-JRNL-LOOP                                                *         
      *****************************************************************         
       6200-JRNL-LOOP.                                                  
                                                                        
           IF WS-4822-DTL-CHRG-AMT   EQUAL WS-ZERO                      
              GO TO 6200-EXIT                                           
           END-IF.                                                      
                                                                        
           IF CONTRACT-INSERT                                           
              MOVE WS-S                     TO AR-CODE-TRAN-TYPE        
              MOVE WS-4822-AMT-ORIG-ENTERED TO WS-105-AMOUNT-ENTERED    
                                               AR-AMT-ORIG-ENTERED      
           ELSE                                                         
              IF CONTRACT-DELETE                                        
                 MOVE WS-I                  TO AR-CODE-TRAN-TYPE        
                 MOVE WS-AMT-POSTED-TOTAL   TO WS-105-AMOUNT-ENTERED    
                                               AR-AMT-ORIG-ENTERED      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE AT-TOTAL-AR-BALANCE         TO AR-AMT-BILLED-UNPAID     
                                               WS-105-ACCT-END-AR-BAL.  
           MOVE SPACES                      TO WS-105-CASH-DRAWER-USED. 
           MOVE 105                         TO WS-105-JRNL-FORMAT-NO.   
           MOVE SPACES                      TO WS-105-AR-AGE            
                                               AU-CODE-AR-AGE.          
           MOVE WS-CURRENT-DATE             TO WS-105-DATE-AR-BILLED    
                                               AR-DATE-TRANS.           
           MOVE WS-4822-CNT-ITEM-ID         TO WS-105-ITEM-ID-NO        
                                               AU-ITEM-ID.              
                                                                        
           MOVE WS-4822-REV-DISTRICT-CD  TO WS-105-CODE-REVENUE-DISTRICT
           MOVE PR-CODE-PREMISE-STAT TO WS-105-CODE-PREMISE-STATUS.     
           MOVE CU-CODE-EMPL-ACCT    TO WS-105-CODE-EMPL-ACCT.          
           MOVE AT-CODE-COMPANY-ACCT TO WS-105-CODE-COMPANY-ACCT.       
           MOVE AT-CODE-ACCT-STAT    TO WS-105-CODE-ACCOUNT-STATUS.     
           MOVE AT-DATE-LAST-ACTION  TO WS-100-DATE-LAST-ACTION.        
           MOVE WS-CURRENT-DATE      TO AT-DATE-LAST-ACTION.            
           MOVE SPACES               TO WS-105-BENE-COST-CENTER.        
           MOVE SPACES               TO WS-105-COST-CENTER.             
           MOVE SPACES               TO WS-105-NATURE-OF-EXPENDITURE.   
           MOVE SPACES               TO WS-105-CODE-PROPERTY-UNIT.      
           MOVE SPACES               TO WS-105-CODE-WORK-ORDER-NO.      
           MOVE SPACES               TO WS-105-CODE-UNIT-OF-MEASURE.    
           MOVE WS-ZERO              TO WS-105-QUANTITY-ENTERED.        
           MOVE SPACES               TO WS-105-FUNCTION-CODE.           
                                                                        
           IF CONTRACT-INSERT                                           
              IF WS-100-CODE-TRAN-ERRORS (1) EQUAL LOW-VALUES OR SPACES 
                 MOVE WS-J           TO WS-100-CODE-TRAN-ERRORS (1)     
              ELSE                                                      
                 MOVE WS-J           TO WS-100-CODE-TRAN-ERRORS (2)     
           END-IF
           END-IF.                                                      
                                                                        
           MOVE WS-CURRENT-DATE      TO WS-JRNL-OL-REPORT-DT.           
                                                                        
           MOVE SPACES               TO WS-100-TRANS-ERRORS.            
           MOVE AT-ACCOUNT-NO        TO AR-ACCOUNT-NO                   
                                        AU-ACCOUNT-NO.                  
           MOVE WS-CURRENT-TIMESTAMP TO AR-TRANS-HIST-SEQ-NO            
                                        AU-TRANS-HIST-SEQ-NO.           
           MOVE PF-RESP-AREA-ID      TO AR-RESP-AREA-ID.                
                                                                        
           IF CONTRACT-INSERT                                           
              MOVE 'CSR04822A'       TO AR-APPL-PROGRAM-ID              
           ELSE                                                         
              IF CONTRACT-DELETE                                        
                 MOVE 'CSR04822D'    TO AR-APPL-PROGRAM-ID              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE SPACES               TO AR-PYMT-FACILITY-CD.            
           MOVE WS-4822-USER-ID      TO AR-USER-ID.                     
           MOVE AT-COMPANY-NO        TO AR-COMPANY-NO.                  
                                                                        
           MOVE WS-CD-LOCAL-OFFICE   TO AR-CASH-LOCAL-OFFICE.           
           MOVE WS-CD-COMPANY-NO     TO AR-CASH-COMPANY-NO.             
           MOVE WS-CD-REPORT-NO      TO AR-CASH-REPORT-NO.              
           MOVE WS-CD-REPORT-DATE    TO AR-DATE-CASH-REPORT.            
           MOVE WS-CASH-DRAWER-ID    TO AR-CASH-DRAWER-ID.              
                                                                        
      *    MOVE WS-CNT-COMMENTS-LEN  TO AR-TRAN-COMMENT-LEN.                    
      *    MOVE WS-4822-CNT-COMMENTS-TXT TO AR-TRAN-COMMENT-TEXT.               
                                                                        
SAKTHI     IF NOT CONTRACT-INSERT                                       
SAKTHI        MOVE LENGTH OF WS-4822-CNT-TRAN-COMMENT-TXT               
SAKTHI                                      TO AR-TRAN-COMMENT-LEN      
SAKTHI        MOVE WS-4822-CNT-TRAN-COMMENT-TXT                         
SAKTHI                                      TO AR-TRAN-COMMENT-TEXT     
SAKTHI     ELSE                                                         
SAKTHI        MOVE WS-CNT-COMMENTS-LEN      TO AR-TRAN-COMMENT-LEN      
SAKTHI        MOVE WS-4822-CNT-COMMENTS-TXT TO AR-TRAN-COMMENT-TEXT     
SAKTHI     END-IF.                                                      
                                                                        
           MOVE SPACES               TO AR-RECORD-ONLY-FL               
                                        AR-DATE-ORIG-PYMT.              
           MOVE -1                   TO WS-DATE-ORIG-PYMT-IND.          
           MOVE WS-4822-CODE-CONTRACT-TYPE                              
                                     TO AU-CODE-CONTRACT-TYPE.          
           MOVE SPACES               TO AU-CURRENCY-TYPE.               
           MOVE ZEROES               TO AU-CURRENCY-AMT.                
                                                                        
ACT368*    IF THE CONTARCT IS REBATE THROUGH SALES FORCE,SHOULD NOT             
ACT368*    WRITE CIS GL, HAVE SEPARATE GL PROCESS FOR REBATE CNT.               
ACT368     IF WS-4822-REBATE-CD NOT EQUAL WS-REBATE-TO-CREDIT-ACCT      
ACT368        PERFORM 6185-JOURNAL-CHARGE-AMT THRU 6185-EXIT            
ACT368     END-IF.                                                      
                                                                        
      *    TO BE CHANGE  THESE VALUES FROM CONTRACT TABLE                       
           IF WS-4822-AMT-TAX-STATE GREATER THAN WS-ZERO                
              IF WS-4822-UPDATE-TYPE EQUAL WS-I                         
                 MOVE WS-4822-AMT-TAX-STATE  TO AU-AMT-POSTED           
              ELSE                                                      
                 IF WS-4822-CNT-STATUS-CD EQUAL WS-CONTRACT-CANCELLED   
                   COMPUTE WS-STATE-TAX-HOLD ROUNDED EQUAL              
                   WS-UNPAID-BALANCE * WS-4822-AMT-TAX-STATE /          
                 ( WS-4822-AMT-ORIG-ENTERED  - WS-4822-ADD-ON-INTRST  ) 
                   MOVE WS-STATE-TAX-HOLD TO AU-AMT-POSTED              
                 END-IF                                                 
              END-IF                                                    
              MOVE WS-GEN-LED-STATE-TAX TO WS-GEN-LED-TAX               
              PERFORM 6195-JOURNAL-TAX THRU 6195-EXIT                   
           END-IF.                                                      
                                                                        
           IF WS-4822-AMT-TAX-CITY GREATER THAN WS-ZERO                 
              IF CONTRACT-INSERT                                        
                 MOVE WS-4822-AMT-TAX-CITY          TO AU-AMT-POSTED    
              ELSE                                                      
                 IF CONTRACT-DELETE                                     
                   COMPUTE WS-CITY-TAX-HOLD ROUNDED =                   
                   WS-UNPAID-BALANCE * WS-4822-AMT-TAX-CITY /           
                 ( WS-4822-AMT-ORIG-ENTERED  - WS-4822-ADD-ON-INTRST  ) 
                   MOVE WS-CITY-TAX-HOLD TO AU-AMT-POSTED               
                 END-IF                                                 
              END-IF                                                    
              MOVE WS-GEN-LED-CITY-TAX   TO WS-GEN-LED-TAX              
              PERFORM 6195-JOURNAL-TAX      THRU 6195-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-4822-AMT-TAX-OTHER  GREATER THAN WS-ZERO               
              IF CONTRACT-INSERT                                        
                 MOVE WS-4822-AMT-TAX-OTHER  TO WS-TOT-TAX-OTHER        
                                                WS-RMNG-TAX-OTHER       
              ELSE                                                      
                 IF CONTRACT-DELETE                                     
                   COMPUTE WS-OTHER-TAX-HOLD ROUNDED =                  
                   WS-UNPAID-BALANCE * WS-4822-AMT-TAX-OTHER /          
                 ( WS-4822-AMT-ORIG-ENTERED  - WS-4822-ADD-ON-INTRST  ) 
                   MOVE WS-OTHER-TAX-HOLD TO WS-TOT-TAX-OTHER           
                                             WS-RMNG-TAX-OTHER          
                 END-IF                                                 
              END-IF                                                    
                                                                        
              PERFORM 7260-SEL-CUR-REV-MONTH THRU 7260-EXIT             
              STRING WS-REVENUE-MONTH-CHAR(2:4) DELIMITED BY SIZE       
                     '-'                        DELIMITED BY SIZE       
                     WS-REVENUE-MONTH-CHAR(6:2) DELIMITED BY SIZE       
                     '-01'                      DELIMITED BY SIZE       
                INTO WS-REVENUE-DATE                                    
                                                                        
              MOVE WS-4822-REV-DISTRICT-CD      TO TR-DETAIL-ID         
              PERFORM 7900-OPEN-OTHER-TAX-CURSOR    THRU 7900-EXIT      
              PERFORM 7905-FETCH-OTHER-TAX-CURSOR   THRU 7905-EXIT      
                                                                        
              PERFORM VARYING WS-SUB2 FROM 1 BY 1                       
                  UNTIL WS-SUB2 GREATER THAN WS-NBR-TAX-OTHER-MAX       
                     OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND           
                MOVE WS-SUB2       TO WS-NBR-TAX-OTHER                  
                ADD  TR-TAX-RATE   TO WS-TOT-TAX-OTHER-RATE             
                MOVE TR-TAX-RATE   TO WS-TAX-OTHER-RATE(WS-SUB2)        
                MOVE SF-GL-ACCT-NO TO WS-TAX-OTHER-GL-NBR(WS-SUB2)      
                PERFORM 7905-FETCH-OTHER-TAX-CURSOR THRU 7905-EXIT      
              END-PERFORM                                               
                                                                        
              PERFORM 7910-CLOSE-OTHER-TAX-CURSOR   THRU 7910-EXIT      
                                                                        
              PERFORM VARYING WS-SUB2 FROM 1 BY 1                       
                UNTIL WS-SUB2 GREATER THAN WS-NBR-TAX-OTHER             
                 MOVE WS-TAX-OTHER-GL-NBR(WS-SUB2) TO WS-GEN-LED-TAX    
                 IF WS-SUB2 NOT EQUAL WS-NBR-TAX-OTHER                  
                    COMPUTE AU-AMT-POSTED ROUNDED =                     
                       WS-TOT-TAX-OTHER * (WS-TAX-OTHER-RATE(WS-SUB2) / 
                       WS-TOT-TAX-OTHER-RATE)                           
                    END-COMPUTE                                         
                    SUBTRACT AU-AMT-POSTED FROM WS-RMNG-TAX-OTHER       
                 ELSE                                                   
                    MOVE WS-RMNG-TAX-OTHER TO AU-AMT-POSTED             
                 END-IF                                                 
                 PERFORM 6195-JOURNAL-TAX THRU 6195-EXIT                
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
           IF WS-4822-DTL-DISP-FEE GREATER THAN WS-ZERO                 
              MOVE WS-4822-DTL-DISP-FEE     TO AU-AMT-POSTED            
              PERFORM 7400-SELECT-GL           THRU 7400-EXIT           
              MOVE SF-GL-ACCT-NO            TO WS-GEN-LED-TAX           
              PERFORM 6195-JOURNAL-TAX         THRU 6195-EXIT           
           END-IF.                                                      
                                                                        
           IF WS-4822-DTL-INSP-FEE GREATER THAN WS-ZERO                 
              MOVE WS-4822-DTL-INSP-FEE     TO AU-AMT-POSTED            
              MOVE WS-GEN-LED-INSP-FEE      TO WS-GEN-LED-TAX           
              PERFORM 6195-JOURNAL-TAX         THRU 6195-EXIT           
           END-IF.                                                      
                                                                        
ACT160     IF WS-4822-DTL-FILING-FEE GREATER THAN WS-ZERO               
ACT160        MOVE WS-4822-DTL-FILING-FEE   TO AU-AMT-POSTED            
ACT160*       MOVE WS-4822-DTL-GL-NO        TO WS-GEN-LED-TAX                   
ACT160        MOVE WS-GEN-LED-FILING-FEE    TO WS-GEN-LED-TAX           
ACT160        PERFORM 6195-JOURNAL-TAX         THRU 6195-EXIT           
ACT160     END-IF.                                                      
                                                                        
       6200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6210-JRNL-INTEREST.                                           *         
      *****************************************************************         
       6210-JRNL-INTEREST.                                              
                                                                        
           MOVE SPACES                  TO WS-105-BENE-COST-CENTER.     
           MOVE SPACES                  TO WS-105-CODE-PROPERTY-UNIT.   
           MOVE SPACES                  TO WS-105-CODE-WORK-ORDER-NO.   
           MOVE SPACES                  TO WS-105-CODE-UNIT-OF-MEASURE. 
           MOVE WS-ZERO                 TO WS-105-QUANTITY-ENTERED.     
                                                                        
           MOVE WS-4822-ADD-ON-INTRST   TO AU-AMT-POSTED.               
           MOVE AU-AMT-POSTED           TO WS-105-AMT-POSTED.           
                                                                        
           IF CONTRACT-INSERT                                           
              MOVE WS-4822-GL-ACCT-NO-DEF-INT                           
                                        TO WS-105-ACCT-GEN-LED-CR       
                                           AU-GL-ACCT-CREDIT            
              MOVE WS-GEN-LED-CONTRACT  TO WS-105-ACCT-GEN-LED-DR       
                                           AU-GL-ACCT-DEBIT             
           ELSE                                                         
              MOVE WS-4822-GL-ACCT-NO-DEF-INT                           
                                        TO WS-105-ACCT-GEN-LED-DR       
                                           AU-GL-ACCT-DEBIT             
              MOVE WS-GEN-LED-CONTRACT  TO WS-105-ACCT-GEN-LED-CR       
                                           AU-GL-ACCT-CREDIT            
           END-IF.                                                      
                                                                        
           IF CONTRACT-INSERT                                           
              ADD AU-AMT-POSTED         TO WS-AMT-POSTED-TOTAL          
           ELSE                                                         
              SUBTRACT AU-AMT-POSTED    FROM WS-AMT-POSTED-TOTAL
           END-IF.       
           MOVE WS-AMT-POSTED-TOTAL     TO WS-105-DETAIL-END-BAL.       
           MOVE WS-ZERO                 TO WS-105-DETAIL-END-AR-BAL.    
                                                                        
           IF CONTRACT-INSERT                                           
              MOVE AU-AMT-POSTED        TO WS-JRNL-GEN-LEG-CREDIT-AMT   
                                           WS-JRNL-RCV-DEBIT-AMT        
           ELSE                                                         
              MOVE AU-AMT-POSTED        TO WS-JRNL-GEN-LEG-DEBIT-AMT    
                                           WS-JRNL-RCV-CREDIT-AMT       
           END-IF.                                                      
                                                                        
           ADD 1                        TO WS-CNT-TRAN-APPL-NO.         
           MOVE WS-CNT-TRAN-APPL-NO     TO WS-100-JRNL-TRAN-APPL-NO     
                                           AU-TRAN-APPL-NO.             
                                                                        
           MOVE CJF00105                TO WS-100-USER-DEFINED-AREA.    
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST.      
                                                                        
           PERFORM 6060-JRNL-ONLY-JRNL-ROUTINE THRU 6060-EXIT.          
           PERFORM 6065-CALL-JRNL-ROUTINE      THRU 6065-EXIT.          
                                                                        
           IF WS-JRNL-RTRN-CODE NOT EQUAL SPACES                        
              MOVE 5006                 TO WS-4822-APPL-CNT-RETURN-CD   
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '6210'               TO ACTIVE-PARAGRAPH             
              MOVE 'USER ABEND'         TO ABEND-FUNCTION               
              MOVE WS-YES               TO WS-USER-FORCE-ABEND          
              MOVE 'UNSUCCESSFUL JOURNAL' TO DSNTIAR-MESSAGE-1          
P00851        SET  CPD4822-DB2-ERR-FOUND  TO TRUE                       
              PERFORM 9910-SQL-ERROR       THRU 9910-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 6080-LOAD-AR-TRANS-HIST THRU 6080-EXIT.              
                                                                        
       6210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6220-WRITE-DOWN-PYMT.                                         *         
      *****************************************************************         
       6220-WRITE-DOWN-PYMT.                                            
                                                                        
           PERFORM 7010-SELECT-TIMESTAMP     THRU 7010-EXIT.            
           MOVE 1                         TO WS-100-JRNL-TRAN-APPL-NO.  
                                                                        
           MOVE WS-A                      TO AR-CODE-TRAN-TYPE.         
                                                                        
           MOVE 105                       TO WS-105-JRNL-FORMAT-NO.     
           MOVE SPACES                    TO WS-105-CASH-DRAWER-USED.   
           MOVE WS-DOWN-PMT-JRNL-AMT      TO AR-AMT-ORIG-ENTERED        
                                             WS-105-AMOUNT-ENTERED      
                                             AU-AMT-POSTED              
                                             WS-105-AMT-POSTED          
                                             WS-105-DETAIL-END-AR-BAL.  
                                                                        
      *    IF WS-4822-REBATE-CD EQUAL W-LT-REDUCE-FINANCE                       
      *       SUBTRACT WS-4822-REBATE-AMOUNT                                    
      *       FROM WS-4822-AMT-ORIG-ENTERED                                     
      *       GIVING WS-105-DETAIL-END-BAL                                      
      *    ELSE                                                                 
      *       MOVE WS-4822-AMT-ORIG-ENTERED                                     
      *                                   TO WS-105-DETAIL-END-BAL              
      *    END-IF.                                                              
                                                                        
           IF WS-4822-ADV-COLL EQUAL WS-YES                             
              ADD AC-AMT-TRAN-BALANCE     TO WS-105-DETAIL-END-BAL      
           END-IF                                                       
                                                                        
           MOVE WS-CURRENT-DATE           TO AR-DATE-TRANS              
                                             WS-105-DATE-AR-BILLED.     
           MOVE WS-ONE                    TO AU-TRAN-APPL-NO.           
           MOVE WS-GEN-LED-CONTRACT       TO AU-GL-ACCT-CREDIT          
                                             AU-GL-ACCT-DEBIT           
                                             WS-105-ACCT-GEN-LED-DR     
                                             WS-105-ACCT-GEN-LED-CR.    
           ADD WS-DOWN-PMT-JRNL-AMT                                     
               AT-TOTAL-AR-BALANCE                                      
               GIVING AR-AMT-BILLED-UNPAID.                             
                                                                        
           MOVE AR-AMT-BILLED-UNPAID TO WS-105-ACCT-END-AR-BAL.         
           MOVE ZEROES               TO AU-CODE-AR-AGE                  
                                        WS-105-AR-AGE.                  
           MOVE WS-4822-CNT-ITEM-ID  TO AU-ITEM-ID                      
                                        WS-105-ITEM-ID-NO.              
           MOVE WS-4822-REV-DISTRICT-CD TO WS-105-CODE-REVENUE-DISTRICT 
           MOVE PR-CODE-PREMISE-STAT TO WS-105-CODE-PREMISE-STATUS.     
           MOVE CU-CODE-EMPL-ACCT    TO WS-105-CODE-EMPL-ACCT.          
           MOVE AT-CODE-COMPANY-ACCT TO WS-105-CODE-COMPANY-ACCT.       
           MOVE AT-CODE-ACCT-STAT    TO WS-105-CODE-ACCOUNT-STATUS.     
           MOVE CJF00105             TO WS-100-USER-DEFINED-AREA.       
           MOVE WS-JRNL-ONLY         TO WS-JRNL-OPERATION-RQST.         
           PERFORM 6065-CALL-JRNL-ROUTINE THRU 6065-EXIT.               
                                                                        
           IF WS-JRNL-RTRN-CODE NOT EQUAL SPACES                        
              MOVE 5007              TO WS-4822-APPL-CNT-RETURN-CD      
              MOVE PROGRAM-NAME      TO ABEND-PROGRAM                   
              MOVE '6220'            TO ACTIVE-PARAGRAPH                
              MOVE 'USER ABEND'      TO ABEND-FUNCTION                  
              MOVE WS-YES            TO WS-USER-FORCE-ABEND             
              MOVE 'UNSUCCESSFUL JOURNAL'  TO DSNTIAR-MESSAGE-1         
P00851        SET  CPD4822-DB2-ERR-FOUND   TO TRUE                      
              PERFORM 9910-SQL-ERROR          THRU 9910-EXIT            
           END-IF.                                                      
                                                                        
           MOVE AT-ACCOUNT-NO        TO AR-ACCOUNT-NO                   
                                        AU-ACCOUNT-NO.                  
           MOVE WS-CURRENT-TIMESTAMP TO AR-TRANS-HIST-SEQ-NO            
                                        AU-TRANS-HIST-SEQ-NO.           
           MOVE PF-RESP-AREA-ID      TO AR-RESP-AREA-ID.                
ACT004     MOVE 'CSR04822I'          TO AR-APPL-PROGRAM-ID              
                                                                        
           MOVE SPACES               TO AR-PYMT-FACILITY-CD.            
           MOVE WS-4822-USER-ID      TO AR-USER-ID.                     
           MOVE AT-COMPANY-NO        TO AR-COMPANY-NO.                  
           MOVE WS-CD-LOCAL-OFFICE   TO AR-CASH-LOCAL-OFFICE.           
           MOVE WS-CD-COMPANY-NO     TO AR-CASH-COMPANY-NO.             
           MOVE WS-CD-REPORT-NO      TO AR-CASH-REPORT-NO.              
           MOVE WS-CD-REPORT-DATE    TO AR-DATE-CASH-REPORT.            
           MOVE WS-CASH-DRAWER-ID    TO AR-CASH-DRAWER-ID.              
                                                                        
           MOVE 12                   TO AR-TRAN-COMMENT-LEN             
           MOVE 'DOWN PAYMENT'       TO AR-TRAN-COMMENT-TEXT            
                                                                        
           MOVE SPACES               TO AR-RECORD-ONLY-FL               
                                        AR-DATE-ORIG-PYMT.              
           MOVE -1                   TO WS-DATE-ORIG-PYMT-IND.          
           MOVE WS-4822-CODE-CONTRACT-TYPE                              
                                     TO AU-CODE-CONTRACT-TYPE.          
           MOVE SPACES               TO AU-CURRENCY-TYPE.               
           MOVE ZEROES               TO AU-CURRENCY-AMT.                
                                                                        
           PERFORM 6080-LOAD-AR-TRANS-HIST THRU 6080-EXIT.              
                                                                        
       6220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6300-INSERT-CONTRACT-DETAIL                                    *        
      ******************************************************************        
       6300-INSERT-CONTRACT-DET.                                        
                                                                        
           MOVE CT-ACCOUNT-NO               TO EA-ACCOUNT-NO.           
           MOVE CT-CNT-ITEM-ID              TO EA-CNT-ITEM-ID.          
           MOVE WS-4822-DTL-CHRG-AMT        TO EA-CHARGE-AM.            
           MOVE WS-4822-DTL-CHRG-TYPE       TO EA-CHARGE-TYPE-CD.       
           MOVE WS-4822-DTL-DISP-FEE        TO EA-DISPOSAL-FEE-AM.      
           MOVE WS-4822-DTL-INSP-FEE        TO EA-INSPECTION-FEE-AM.    
ACT160     MOVE WS-4822-DTL-FILING-FEE      TO EA-FILING-FEE-AM.        
           MOVE WS-4822-DTL-GL-NO           TO EA-GL-ACCT-NO.           
           MOVE WS-4822-DTL-WRT-OFF-GL-NO   TO EA-WRT-OFF-GL-ACCT-NO.   
           MOVE WS-4822-COST-CENTER         TO EA-COST-CENTER.          
                                                                        
           PERFORM 8010-INSERT-CNT-DETAIL      THRU 8010-EXIT.          
                                                                        
       6300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6600-INSERT-CONTRACT.                                          *        
      ******************************************************************        
       6600-INSERT-CONTRACT.                                            
                                                                        
           MOVE ZEROES                      TO WS-AMT-POSTED-TOTAL      
                                               WS-CNT-TRAN-APPL-NO.     
                                                                        
           MOVE AT-ACCOUNT-NO               TO CT-ACCOUNT-NO.           
           MOVE WS-PYMT-PRIORITY-100        TO CT-PYMT-PRIORITY-LVL.    
           MOVE WS-4822-CNT-ITEM-ID         TO CT-CNT-ITEM-ID.          
           MOVE WS-4822-DATE-CONTRACT       TO CT-DATE-CONTRACT.        
           IF WS-4822-DATE-CONTRACT <= SPACES                           
              MOVE WS-CURRENT-DATE          TO CT-DATE-CONTRACT         
           END-IF                                                       
           MOVE WS-4822-AMT-MO-PYMT         TO CT-AMT-MO-PYMT           
           MOVE WS-4822-DATE-PYMT-START     TO CT-DATE-PYMT-START.      
           IF WS-4822-DATE-PYMT-START <= SPACES                         
              MOVE WS-CURRENT-DATE          TO CT-DATE-PYMT-START       
           END-IF                                                       
           MOVE WS-4822-CODE-INTRST-METH    TO CT-CODE-INTRST-METH.     
           IF WS-4822-CODE-INTRST-METH EQUAL WS-ADD-ON                  
              MOVE WS-4822-ADD-ON-INTRST    TO CT-AMT-DEF-INTEREST      
           ELSE                                                         
              MOVE ZEROES                   TO CT-AMT-DEF-INTEREST      
           END-IF.                                                      
                                                                        
           MOVE WS-4822-INTRST-RATE         TO CT-INTRST-RATE.          
           MOVE WS-ZERO                     TO CT-INTRST-YTD            
ACT181                                         CT-INTRST-PRIOR-YR.      
           MOVE WS-4822-ADD-ON-INTRST       TO CT-SIMPLE-INT-FIN-CHG.   
           MOVE WS-4822-NO-SCHED-PYMTS      TO CT-NO-SCHED-PYMTS.       
           MOVE WS-4822-AMT-ORIG-ENTERED    TO CT-AMT-ORIG-ENTERED.     
           MOVE WS-4822-AMT-DOWN-PYMT       TO CT-AMT-DOWN-PYMT.        
           MOVE WS-4822-AMT-TAX-STATE       TO CT-AMT-TAX-STATE.        
           MOVE WS-4822-AMT-TAX-CITY        TO CT-AMT-TAX-CITY.         
           MOVE WS-4822-AMT-TAX-OTHER       TO CT-AMT-TAX-OTHER.        
           MOVE WS-4822-CODE-CONTRACT-TYPE  TO CT-CODE-CONTRACT-TYPE.   
           MOVE WS-4822-CNT-STATUS-CD       TO CT-CNT-STATUS-CD.        
           MOVE WS-4822-CNT-NAME-CD         TO CT-CNT-NAME-CD.          
           MOVE WS-4822-USER-ID             TO CT-USER-ID.              
           MOVE WS-4822-LIEN-CD             TO CT-LIEN-CD.              
                                                                        
           MOVE WS-4822-REBATE-AMOUNT       TO CT-REBATE-AMOUNT.        
           MOVE WS-4822-REBATE-CD           TO CT-REBATE-CD.            
           MOVE WS-4822-CODE-BILL-TYPE      TO CT-CODE-BILL-TYPE.       
                                                                        
           IF WS-4822-ADV-COLL NOT EQUAL WS-YES                         
             MOVE SPACES                    TO CT-STATUS-CHANGE-DT      
             MOVE -1                        TO WS-NULL-IND              
           ELSE                                                         
             MOVE WS-4822-STATUS-CHANGE-DT  TO CT-STATUS-CHANGE-DT      
             IF CT-STATUS-CHANGE-DT EQUAL SPACES                        
               MOVE -1                      TO WS-NULL-IND              
             ELSE                                                       
               MOVE WS-ZERO                 TO WS-NULL-IND              
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE WS-CNT-COMMENTS-LEN        TO CT-CONTRACT-COMMENTS-LEN. 
           MOVE WS-4822-CNT-COMMENTS-TXT   TO CT-CONTRACT-COMMENTS-TEXT.
           MOVE WS-4822-REV-DISTRICT-CD    TO CT-REV-DISTRICT-CD.       
           MOVE WS-4822-GL-ACCT-NO-ERN-INT TO CT-GL-ACCT-NO-ERN-INT.    
           MOVE WS-4822-GL-ACCT-NO-DEF-INT TO CT-GL-ACCT-NO-DEF-INT.    
           MOVE WS-4822-CNT-ADDL-DESC-TEXT TO CT-CNT-ADDL-DESC-TEXT.    
           MOVE LENGTH OF CT-CNT-ADDL-DESC-TEXT TO CT-CNT-ADDL-DESC-LEN.
                                                                        
           IF WS-4822-ADV-COLL NOT EQUAL WS-YES                         
             IF CT-CODE-CONTRACT-TYPE EQUAL WS-PSNC-JOBBING             
                AND CT-CNT-NAME-CD    EQUAL WS-ENERGY-AUDIT-PGM         
                PERFORM 6010-INS-SPCL-BIL-MSG    THRU 6010-EXIT         
             END-IF                                                     
             PERFORM 8000-INSERT-CONTRACT-HEADER THRU 8000-EXIT         
           ELSE                                                         
             PERFORM 8005-UPDATE-ADV-COLL-CNT    THRU 8005-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 6300-INSERT-CONTRACT-DET      THRU 6300-EXIT         
                                                                        
                                                                        
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.   
           MOVE WS-A                        TO WS-CODE-CONTRACT.        
           MOVE WS-CODES-DATA-PRESENT       TO AT-CODES-DATA-PRESENT.   
                                                                        
       6600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6800-MOVE-CONTRACT-VARIABLES.                                 *         
      *****************************************************************         
       6800-MOVE-CONTRACT-VARIABLES.                                    
                                                                        
           MOVE WS-4822-INTRST-RATE     TO CT-INTRST-RATE               
           MOVE WS-4822-AMT-MO-PYMT     TO CT-AMT-MO-PYMT               
           MOVE WS-4822-AMT-ORIG-ENTERED                                
                                        TO CT-AMT-ORIG-ENTERED          
           MOVE WS-4822-ADD-ON-INTRST   TO CT-SIMPLE-INT-FIN-CHG        
ACT-1      MOVE WS-4822-DEFERRED-INTEREST                               
ACT-1                                   TO CT-AMT-DEF-INTEREST          
           MOVE WS-4822-NO-SCHED-PYMTS  TO CT-NO-SCHED-PYMTS            
           MOVE WS-4822-DATE-CONTRACT   TO CT-DATE-CONTRACT             
           MOVE WS-4822-DATE-PYMT-START TO CT-DATE-PYMT-START           
           MOVE WS-4822-LIEN-CD         TO CT-LIEN-CD                   
           MOVE WS-4822-CNT-STATUS-CD   TO CT-CNT-STATUS-CD             
           MOVE WS-4822-REV-DISTRICT-CD TO CT-REV-DISTRICT-CD           
           MOVE WS-4822-DTL-CHRG-AMT    TO EA-CHARGE-AM                 
ACT-1      MOVE WS-4822-STATUS-CHANGE-DT                                
ACT-1                                   TO CT-STATUS-CHANGE-DT          
                                                                        
           IF CT-STATUS-CHANGE-DT      EQUAL SPACES                     
              MOVE -1                   TO WS-NULL-IND                  
           ELSE                                                         
              MOVE    ZERO              TO WS-NULL-IND                  
           END-IF                                                       
                                                                        
           MOVE WS-4822-CNT-COMMENTS-TXT                                
                                        TO CT-CONTRACT-COMMENTS-TEXT    
           MOVE LENGTH OF CT-CONTRACT-COMMENTS-TEXT                     
                                        TO CT-CONTRACT-COMMENTS-LEN     
           MOVE WS-4822-CNT-ADDL-DESC-TEXT                              
                                        TO CT-CNT-ADDL-DESC-TEXT        
           MOVE LENGTH OF CT-CNT-ADDL-DESC-TEXT                         
                                        TO CT-CNT-ADDL-DESC-LEN.        
                                                                        
       6800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5100-WRITE-TRAN-HIST-HEADER.                                   *        
      ******************************************************************        
       5100-WRITE-TRAN-HIST-HEADER.                                     
                                                                        
SAKTHI     IF NOT CONTRACT-INSERT                                       
SAKTHI        MOVE LENGTH OF WS-4822-CNT-TRAN-COMMENT-TXT               
SAKTHI                                      TO MH-TRAN-COMMENT-LEN      
SAKTHI        MOVE WS-4822-CNT-TRAN-COMMENT-TXT                         
SAKTHI                                      TO MH-TRAN-COMMENT-TEXT     
SAKTHI     ELSE                                                         
SAKTHI        MOVE WS-CNT-COMMENTS-LEN      TO MH-TRAN-COMMENT-LEN      
SAKTHI        MOVE WS-4822-CNT-COMMENTS-TXT TO MH-TRAN-COMMENT-TEXT     
SAKTHI     END-IF.                                                      
                                                                        
           MOVE WS-F                        TO MH-CODE-TRAN-TYPE.       
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE AT-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE WS-ZERO                     TO MH-CUSTOMER-NO.          
           MOVE WS-ZERO                     TO MH-PREMISE-NO.           
           MOVE WS-4822-USER-ID             TO MH-USER-ID.              
           MOVE WS-APPL-PROGRAM-ID          TO MH-APPL-PROGRAM-ID.      
           MOVE +1                          TO WS-TRAN-APPL-NO.         
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO     
                                               MI-TRANS-HIST-SEQ-NO.    
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5105-WRITE-TRAN-HIST-UPDT.                                    *         
      *****************************************************************         
       5105-WRITE-TRAN-HIST-UPDT.                                       
                                                                        
           MOVE 'CSR04822C'                 TO WS-APPL-PROGRAM-ID.      
           PERFORM 5100-WRITE-TRAN-HIST-HEADER THRU 5100-EXIT.          
                                                                        
      *    WRITE TRANSACTION DETAILS.                                           
           IF CT-INTRST-RATE NOT EQUAL WS-4822-INTRST-RATE              
              MOVE WS-INTEREST-RATE         TO MI-COLUMN-DESC           
              MOVE CT-INTRST-RATE           TO WS-EDIT-RATE             
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE +6                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-EDIT-RATE             TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-4822-INTRST-RATE      TO WS-EDIT-RATE             
              MOVE +6                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-EDIT-RATE             TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF CT-AMT-DEF-INTEREST NOT EQUAL WS-4822-DEFERRED-INTEREST   
              MOVE 'DEFERRED INTRST'        TO MI-COLUMN-DESC           
              MOVE CT-AMT-DEF-INTEREST      TO WS-EDIT-INTEREST         
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE +9                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-EDIT-INTEREST         TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-4822-DEFERRED-INTEREST TO WS-EDIT-INTEREST        
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-EDIT-INTEREST         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF EA-CHARGE-AM        NOT EQUAL WS-4822-DTL-CHRG-AMT        
              MOVE 'CHARGE AMOUNT'          TO MI-COLUMN-DESC           
              MOVE EA-CHARGE-AM             TO WS-EDIT-INTEREST         
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE +9                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-EDIT-INTEREST         TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-4822-DTL-CHRG-AMT     TO WS-EDIT-INTEREST         
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-EDIT-INTEREST         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF CT-CNT-STATUS-CD NOT EQUAL WS-4822-CNT-STATUS-CD          
              MOVE WS-STATUS-CODE           TO MI-COLUMN-DESC           
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE CT-CNT-STATUS-CD         TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-4822-CNT-STATUS-CD    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '15'                     TO MI-TABLE-ID              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF CT-CONTRACT-COMMENTS-TEXT(1:CT-CONTRACT-COMMENTS-LEN)     
PRJ851        NOT EQUAL                                                 
                    WS-4822-CNT-COMMENTS-TXT(1:WS-CNT-COMMENTS-LEN )    
                                                                        
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE WS-CONTRACT-COMMENT      TO MI-COLUMN-DESC           
              MOVE CT-CONTRACT-COMMENTS-LEN TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE CT-CONTRACT-COMMENTS-TEXT                            
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-CNT-COMMENTS-LEN      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-4822-CNT-COMMENTS-TXT TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF CT-AMT-MO-PYMT  NOT EQUAL WS-4822-AMT-MO-PYMT             
PRJ851*       OR WS-4822-AMT-MO-PYMT NOT EQUAL   99999.99                       
                                                                        
              MOVE 'MONTHLY PMT'            TO MI-COLUMN-DESC           
              MOVE CT-AMT-MO-PYMT           TO WS-EDIT-AMOUNTS          
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE +14                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-EDIT-AMOUNTS          TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-4822-AMT-MO-PYMT      TO WS-EDIT-AMOUNTS          
              MOVE +14                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-EDIT-AMOUNTS          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF CT-NO-SCHED-PYMTS NOT EQUAL WS-4822-NO-SCHED-PYMTS        
              MOVE 'NO OF PAYMENTS'         TO MI-COLUMN-DESC           
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE +14                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE CT-NO-SCHED-PYMTS        TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +14                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-4822-NO-SCHED-PYMTS   TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           IF CT-LIEN-CD NOT EQUAL WS-4822-LIEN-CD                      
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE 'LIEN CODE'              TO MI-COLUMN-DESC           
              MOVE +9                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE CT-LIEN-CD               TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-4822-LIEN-CD          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5110-INSERT-MNT-TRN-HST-CNCL.                                  *        
      ******************************************************************        
       5110-INSERT-MNT-TRN-HST-CNCL.                                    
                                                                        
           MOVE 'CSR04822D'                 TO WS-APPL-PROGRAM-ID.      
           PERFORM 5100-WRITE-TRAN-HIST-HEADER THRU 5100-EXIT.          
                                                                        
           MOVE WS-STATUS-CODE              TO MI-COLUMN-DESC.          
           MOVE +1                          TO MI-PRV-COLUMN-VALUE-LEN  
           MOVE CT-CNT-STATUS-CD            TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE WS-4822-CNT-STATUS-CD       TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE +1                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE '15'                        TO MI-TABLE-ID              
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO WS-TRAN-APPL-NO.         
                                                                        
           MOVE 'STAT CHANGE DT'            TO MI-COLUMN-DESC           
           MOVE SPACES                      TO MI-TABLE-ID              
           MOVE +10                         TO MI-PRV-COLUMN-VALUE-LEN  
           MOVE CT-STATUS-CHANGE-DT         TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE +10                         TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE WS-4822-STATUS-CHANGE-DT    TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.          
           ADD 1                            TO WS-TRAN-APPL-NO.         
                                                                        
       5110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5120-WRITE-TRAN-HIST-INSERT.                                   *        
      ******************************************************************        
       5120-WRITE-TRAN-HIST-INSERT.                                     
                                                                        
           MOVE 'CSR04822A'                 TO WS-APPL-PROGRAM-ID.      
           PERFORM 5100-WRITE-TRAN-HIST-HEADER THRU 5100-EXIT.          
                                                                        
           MOVE 'BILLING OPTION'            TO MI-COLUMN-DESC           
           MOVE '17'                        TO MI-TABLE-ID              
           MOVE +5                          TO MI-PRV-COLUMN-VALUE-LEN  
           MOVE '*NEW*'                     TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE +1                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE WS-4822-CODE-BILL-TYPE      TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO WS-TRAN-APPL-NO.         
                                                                        
           MOVE 'CONTRACT ID'               TO MI-COLUMN-DESC           
           MOVE '17'                        TO MI-TABLE-ID              
           MOVE +5                          TO MI-PRV-COLUMN-VALUE-LEN  
           MOVE '*NEW*'                     TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE WS-4822-CNT-ITEM-ID         TO WS-EDIT-CONTRACT-ID      
           MOVE +7                          TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE WS-EDIT-CONTRACT-ID         TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO WS-TRAN-APPL-NO.         
                                                                        
           MOVE 'MONTHLY PMT'               TO MI-COLUMN-DESC           
           MOVE CT-AMT-MO-PYMT              TO WS-EDIT-AMOUNTS          
           MOVE SPACES                      TO MI-TABLE-ID              
           MOVE +5                          TO MI-PRV-COLUMN-VALUE-LEN  
           MOVE '*NEW*'                     TO MI-PRV-COLUMN-VALUE-TEXT 
           MOVE WS-4822-AMT-MO-PYMT         TO WS-EDIT-AMOUNTS          
           MOVE +14                         TO MI-CHG-COLUMN-VALUE-LEN  
           MOVE WS-EDIT-AMOUNTS             TO MI-CHG-COLUMN-VALUE-TEXT 
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT           
           ADD 1                            TO WS-TRAN-APPL-NO.         
                                                                        
       5120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5130-WRITE-TRAN-DET-PSNC.                                      *        
      ******************************************************************        
       5130-WRITE-TRAN-DET-PSNC.                                        
                                                                        
           IF WS-PREV-CODE-LPC-XMT NOT EQUAL AT-CODE-LPC-XMT            
              MOVE 'LATE PAYMENT EXMPTN' TO MI-COLUMN-DESC              
              MOVE '11'                  TO MI-TABLE-ID                 
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE WS-PREV-CODE-LPC-XMT                                 
                                         TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE AT-CODE-LPC-XMT       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                            THRU 6530-EXIT              
              ADD 1                      TO WS-TRAN-APPL-NO             
           END-IF                                                       
                                                                        
           IF WS-PREV-CODE-DISC-OK NOT EQUAL AT-CODE-DISC-OK            
              MOVE 'DISCONNECT EXMPTN'   TO MI-COLUMN-DESC              
              MOVE '12'                  TO MI-TABLE-ID                 
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE WS-PREV-CODE-DISC-OK  TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE AT-CODE-DISC-OK       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
                                                                        
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                            THRU 6530-EXIT              
              ADD 1                      TO WS-TRAN-APPL-NO             
            END-IF                                                      
                                                                        
            IF WS-PREV-NOTICE-EXEMPT NOT EQUAL AT-NOTICE-EXEMPT-CD      
               MOVE 'SEND NOTICE EXMPTN' TO MI-COLUMN-DESC              
               MOVE '13'                 TO MI-TABLE-ID                 
               MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-NOTICE-EXEMPT                               
                                         TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE AT-NOTICE-EXEMPT-CD  TO MI-CHG-COLUMN-VALUE-TEXT    
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                     TO WS-TRAN-APPL-NO             
            END-IF                                                      
                                                                        
            IF WS-PREV-IVR-EXEMPT NOT EQUAL AT-IVR-EXEMPT-CD            
               MOVE 'SEND IVR EXMPTN'    TO MI-COLUMN-DESC              
               MOVE '13'                 TO MI-TABLE-ID                 
               MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-IVR-EXEMPT   TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE AT-IVR-EXEMPT-CD     TO MI-CHG-COLUMN-VALUE-TEXT    
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               PERFORM 6530-LOAD-MNT-TRANS-HIST                         
                                            THRU 6530-EXIT              
            END-IF.                                                     
                                                                        
       5130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-GET-ACCOUNT-INFO.                                        *         
      *****************************************************************         
                                                                        
       7000-GET-ACCOUNT-INFO.                                           
           EXEC SQL                                                     
              SELECT AT.CUSTOMER_NO,                                    
                     AT.CODE_ACCT_STAT,                                 
                     AT.TOTAL_AR_BALANCE,                               
                     AT.DATE_LAST_ACTION,                               
                     AT.LOCAL_OFFICE,                                   
                     AT.PREMISE_NO,                                     
                     AT.CUSTOMER_NO,                                    
                     AT.CODES_DATA_PRESENT,                             
                     AT.COMPANY_NO,                                     
                     AT.AR_XFER_IND,                                    
                     AT.ACCT_XFER_TO,                                   
                     AT.BANKRUPTCY_IND,                                 
                     AT.CREDIT_GROUP,                                   
                     REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                     AT.NOTICE_EXEMPT_CD,                               
                     AT.CODE_DISC_OK,                                   
                     AT.DATE_BILL_DAY_00,                               
                     AT.DATE_BILL_DAY_30,                               
                     AT.DATE_BILL_DAY_60,                               
                     AT.DATE_BILL_DAY_90,                               
                     AT.MST_SUB_ACCT_IND,                               
                     AT.CODE_PRNT_BLL_MST,                              
                     AT.IVR_EXEMPT_CD,                                  
                     AT.CODE_LPC_XMT,                                   
                     AT.REV_MTH_LST_NRML,                               
                     AT.BILL_CYCLE,                                     
                     PR.CODE_PREMISE_STAT,                              
                     CU.CODE_EMPL_ACCT,                                 
                     CU.CODE_CUST_STATUS,                               
                     CAST(SYSDATETIMEOFFSET() AS DATE),                         
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-CODE-ACCT-STAT,                                
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-DATE-LAST-ACTION,                              
                     :AT-LOCAL-OFFICE,                                  
                     :AT-PREMISE-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-COMPANY-NO,                                    
                     :AT-AR-XFER-IND,                                   
                     :AT-ACCT-XFER-TO,                                  
                     :AT-BANKRUPTCY-IND,                                
                     :AT-CREDIT-GROUP,                                  
                     :AT-LAST-UPDATE-TS,                                
                     :AT-NOTICE-EXEMPT-CD,                              
                     :AT-CODE-DISC-OK,                                  
                     :AT-DATE-BILL-DAY-00 :WS-NULL-IND-AT-1,             
                     :AT-DATE-BILL-DAY-30 :WS-NULL-IND-AT-2,             
                     :AT-DATE-BILL-DAY-60 :WS-NULL-IND-AT-3,             
                     :AT-DATE-BILL-DAY-90 :WS-NULL-IND-AT-4,             
                     :AT-MST-SUB-ACCT-IND,                              
                     :AT-CODE-PRNT-BLL-MST,                             
                     :AT-IVR-EXEMPT-CD,                                 
                     :AT-CODE-LPC-XMT,                                  
                     :AT-REV-MTH-LST-NRML,                              
                     :AT-BILL-CYCLE,                                    
                     :PR-CODE-PREMISE-STAT,                             
                     :CU-CODE-EMPL-ACCT,                                
                     :CU-CODE-CUST-STATUS,                              
                     :WS-CURRENT-DATE,                                  
                     :WS-CURRENT-TIMESTAMP                              
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_PREMISE PR WITH(READUNCOMMITTED)                       
                    ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
               WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                    
                 AND AT.PREMISE_NO  =  PR.PREMISE_NO                    
                 AND AT.CUSTOMER_NO =  CU.CUSTOMER_NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CUSTOMER_NO,                                            
MFA-TR*              AT.CODE_ACCT_STAT,                                         
MFA-TR*              AT.TOTAL_AR_BALANCE,                                       
MFA-TR*              AT.DATE_LAST_ACTION,                                       
MFA-TR*              AT.LOCAL_OFFICE,                                           
MFA-TR*              AT.PREMISE_NO,                                             
MFA-TR*              AT.CUSTOMER_NO,                                            
MFA-TR*              AT.CODES_DATA_PRESENT,                                     
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              AT.AR_XFER_IND,                                            
MFA-TR*              AT.ACCT_XFER_TO,                                           
MFA-TR*              AT.BANKRUPTCY_IND,                                         
MFA-TR*              AT.CREDIT_GROUP,                                           
MFA-TR*              AT.LAST_UPDATE_TS,                                         
MFA-TR*              AT.NOTICE_EXEMPT_CD,                                       
MFA-TR*              AT.CODE_DISC_OK,                                           
MFA-TR*              AT.DATE_BILL_DAY_00,                                       
MFA-TR*              AT.DATE_BILL_DAY_30,                                       
MFA-TR*              AT.DATE_BILL_DAY_60,                                       
MFA-TR*              AT.DATE_BILL_DAY_90,                                       
MFA-TR*              AT.MST_SUB_ACCT_IND,                                       
MFA-TR*              AT.CODE_PRNT_BLL_MST,                                      
MFA-TR*              AT.IVR_EXEMPT_CD,                                          
MFA-TR*              AT.CODE_LPC_XMT,                                           
MFA-TR*              AT.REV_MTH_LST_NRML,                                       
MFA-TR*              AT.BILL_CYCLE,                                             
MFA-TR*              PR.CODE_PREMISE_STAT,                                      
MFA-TR*              CU.CODE_EMPL_ACCT,                                         
MFA-TR*              CU.CODE_CUST_STATUS,                                       
MFA-TR*              CURRENT DATE,                                              
MFA-TR*              CURRENT TIMESTAMP                                          
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-TOTAL-AR-BALANCE,                                      
MFA-TR*              :AT-DATE-LAST-ACTION,                                      
MFA-TR*              :AT-LOCAL-OFFICE,                                          
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-CODES-DATA-PRESENT,                                    
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-AR-XFER-IND,                                           
MFA-TR*              :AT-ACCT-XFER-TO,                                          
MFA-TR*              :AT-BANKRUPTCY-IND,                                        
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-LAST-UPDATE-TS,                                        
MFA-TR*              :AT-NOTICE-EXEMPT-CD,                                      
MFA-TR*              :AT-CODE-DISC-OK,                                          
MFA-TR*              :AT-DATE-BILL-DAY-00:WS-NULL-IND-AT-1,                     
MFA-TR*              :AT-DATE-BILL-DAY-30:WS-NULL-IND-AT-2,                     
MFA-TR*              :AT-DATE-BILL-DAY-60:WS-NULL-IND-AT-3,                     
MFA-TR*              :AT-DATE-BILL-DAY-90:WS-NULL-IND-AT-4,                     
MFA-TR*              :AT-MST-SUB-ACCT-IND,                                      
MFA-TR*              :AT-CODE-PRNT-BLL-MST,                                     
MFA-TR*              :AT-IVR-EXEMPT-CD,                                         
MFA-TR*              :AT-CODE-LPC-XMT,                                          
MFA-TR*              :AT-REV-MTH-LST-NRML,                                      
MFA-TR*              :AT-BILL-CYCLE,                                            
MFA-TR*              :PR-CODE-PREMISE-STAT,                                     
MFA-TR*              :CU-CODE-EMPL-ACCT,                                        
MFA-TR*              :CU-CODE-CUST-STATUS,                                      
MFA-TR*              :WS-CURRENT-DATE,                                          
MFA-TR*              :WS-CURRENT-TIMESTAMP                                      
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_PREMISE PR                                             
MFA-TR*             ,CSS_CUSTOMER CU                                            
MFA-TR*        WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                            
MFA-TR*          AND AT.PREMISE_NO  =  PR.PREMISE_NO                            
MFA-TR*          AND AT.CUSTOMER_NO =  CU.CUSTOMER_NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-CURRENT-DATE           TO WS-CD-REPORT-DATE       
              IF WS-NULL-IND-AT-1 < WS-ZERO                             
                 MOVE LOW-VALUES             TO AT-DATE-BILL-DAY-00     
              END-IF                                                    
              IF WS-NULL-IND-AT-2 < WS-ZERO                             
                 MOVE LOW-VALUES             TO AT-DATE-BILL-DAY-30     
              END-IF                                                    
              IF WS-NULL-IND-AT-3 < WS-ZERO                             
                 MOVE LOW-VALUES             TO AT-DATE-BILL-DAY-60     
              END-IF                                                    
              IF WS-NULL-IND-AT-4 < WS-ZERO                             
                 MOVE LOW-VALUES             TO AT-DATE-BILL-DAY-90     
              END-IF                                                    
           ELSE                                                         
              SET CPD4822-DB2-ERR-FOUND      TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22160000
      *                                                                *22160000
      * 7001-GET-CURRENT-DATE.                                          22170000
      ******************************************************************22180000
       7001-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               SET CPD4822-DB2-ERR-FOUND    TO TRUE                     
ACT245         MOVE WS-ACTIVE-RETURN-CODE   TO                          
ACT245                                      WS-4822-DB2-ERR-RETURN-CD   
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7001'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                                 ABEND-TABLES           
               MOVE 'CURRENT DATE'          TO TABLE-ELEMENT-1          
               MOVE WS-CURRENT-DATE         TO HOSTVAR-ELEMENT-1        
               PERFORM 9910-SQL-ERROR          THRU 9910-EXIT           
           END-IF.                                                      
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7005-GET-DATABASE.                                            *         
      *****************************************************************         
       7005-GET-DATABASE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD   =  :C8-DELINQ-CD                    
                 AND C8.COMPANY_NO  =  :C8-COMPANY-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD   =  :C8-DELINQ-CD                            
MFA-TR*          AND C8.COMPANY_NO  =  :C8-COMPANY-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7005                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE C8-DELINQ-VALUE           TO WS-DATABASE-4822        
           ELSE                                                         
              SET CPD4822-DB2-ERR-FOUND      TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7005'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7010-SELECT-TIMESTAMP.                                        *         
      *****************************************************************         
       7010-SELECT-TIMESTAMP.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              SET CPD4822-DB2-ERR-FOUND      TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE   TO                           
ACT245                                     WS-4822-DB2-ERR-RETURN-CD    
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7015-SELECT-RESP-AREA.                                        *         
      *****************************************************************         
       7015-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE PF.USER_ID = :WS-4822-USER-ID                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.RESP_AREA_ID                                            
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE PF.USER_ID = :WS-4822-USER-ID                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7015                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL              
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND TO TRUE                        
ACT245        MOVE WS-ACTIVE-RETURN-CODE   TO                           
ACT245                                     WS-4822-DB2-ERR-RETURN-CD    
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7015'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                              ABEND-TABLES              
              MOVE 'CSS_USER_PROFILE'   TO TABLE-1                      
              MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE WS-4822-USER-ID      TO HOSTVAR-ELEMENT-1            
              MOVE WS-4822-ACCOUNT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9910-SQL-ERROR       THRU 9910-EXIT               
           END-IF.                                                      
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7100-SELECT-AR-CNTL.                                          *         
      *****************************************************************         
       7100-SELECT-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
              SELECT AMT_AR_DAY_00,                                     
                     AMT_AR_DAY_30,                                     
                     AMT_AR_DAY_60,                                     
                     AMT_AR_DAY_90,                                     
                     AMT_TRAN_BALANCE,                                  
                     AMT_UNUSED_CR,                                     
                     REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO :AC-AMT-AR-DAY-00,                                 
                     :AC-AMT-AR-DAY-30,                                 
                     :AC-AMT-AR-DAY-60,                                 
                     :AC-AMT-AR-DAY-90,                                 
                     :AC-AMT-TRAN-BALANCE,                              
                     :AC-AMT-UNUSED-CR,                                 
                     :WS-AC-LAST-UPDATE-TS-DET                          
                FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                       
               WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO              
                 AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL       
                 AND AC.ITEM_ID           = :AC-ITEM-ID                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_AR_DAY_00,                                             
MFA-TR*              AMT_AR_DAY_30,                                             
MFA-TR*              AMT_AR_DAY_60,                                             
MFA-TR*              AMT_AR_DAY_90,                                             
MFA-TR*              AMT_TRAN_BALANCE,                                          
MFA-TR*              AMT_UNUSED_CR,                                             
MFA-TR*              LAST_UPDATE_TS                                             
MFA-TR*         INTO :AC-AMT-AR-DAY-00,                                         
MFA-TR*              :AC-AMT-AR-DAY-30,                                         
MFA-TR*              :AC-AMT-AR-DAY-60,                                         
MFA-TR*              :AC-AMT-AR-DAY-90,                                         
MFA-TR*              :AC-AMT-TRAN-BALANCE,                                      
MFA-TR*              :AC-AMT-UNUSED-CR,                                         
MFA-TR*              :WS-AC-LAST-UPDATE-TS-DET                                  
MFA-TR*         FROM CSS_AR_CNTL AC                                             
MFA-TR*        WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                      
MFA-TR*          AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL               
MFA-TR*          AND AC.ITEM_ID           = :AC-ITEM-ID                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF (WS-4822-ADV-COLL EQUAL WS-YES AND                     
                  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND)                
                 SET  CPD4822-DB2-ERR-FOUND  TO TRUE                    
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '7100'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'ADV COLL'             TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSS_AR_CNTL'          TO TABLE-1                 
                 MOVE AC-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE AC-PYMT-PRIORITY-LVL   TO HOSTVAR-ELEMENT-2       
                 MOVE AC-ITEM-ID             TO HOSTVAR-ELEMENT-3       
                 PERFORM 9910-SQL-ERROR         THRU 9910-EXIT          
              END-IF                                                    
           ELSE                                                         
              SET CPD4822-DB2-ERR-FOUND      TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7250-SELECT-MAX-ITEM-ID.                                      *         
      *****************************************************************         
       7250-SELECT-MAX-ITEM-ID.                                         
                                                                        
           EXEC SQL                                                     
              SELECT MAX(CNT_ITEM_ID)                                   
                INTO  :WS-NEW-CNT-ITEM-ID :WS-NULL-INDICATOR             
                FROM CSS_CONTRACT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(CNT_ITEM_ID)                                           
MFA-TR*         INTO  :WS-NEW-CNT-ITEM-ID:WS-NULL-INDICATOR                     
MFA-TR*         FROM CSS_CONTRACT                                               
MFA-TR*        WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND OR SUCCESSFUL-CALL  
              CONTINUE                                                  
           ELSE                                                         
              SET CPD4822-DB2-ERR-FOUND      TO TRUE                    
              MOVE WS-ACTIVE-RETURN-CODE   TO                           
                                           WS-4822-DB2-ERR-RETURN-CD    
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CT-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7110-GET-CONTRACT-HDR-INFO.                                    *        
      ******************************************************************        
       7110-GET-CONTRACT-HDR-INFO.                                      
                                                                        
           EXEC SQL                                                     
               SELECT CT.ACCOUNT_NO,                                    
                      CT.PYMT_PRIORITY_LVL,                             
                      CT.CNT_ITEM_ID,                                   
                      CT.DATE_CONTRACT,                                 
                      CT.AMT_MO_PYMT,                                   
                      CT.CODE_INTRST_METH,                              
                      CT.INTRST_RATE,                                   
                      CT.INTRST_PRIOR_YR,                               
                      CT.INTRST_YTD,                                    
                      CT.NO_SCHED_PYMTS,                                
                      CT.AMT_ORIG_ENTERED,                              
                      CT.AMT_DOWN_PYMT,                                 
                      CT.AMT_TAX_STATE,                                 
                      CT.AMT_TAX_CITY,                                  
                      CT.AMT_TAX_OTHER,                                 
                      CT.CODE_CONTRACT_TYPE,                            
                      CT.SIMPLE_INT_FIN_CHG,                            
                      CT.CNT_STATUS_CD,                                 
                      CT.CNT_NAME_CD,                                   
                      CT.USER_ID,                                       
                      CT.LIEN_CD,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           CT.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                                
                      CT.AMT_DEF_INTEREST,                              
                      CT.REBATE_AMOUNT,                                 
                      CT.REBATE_CD,                                     
                      CT.CODE_BILL_TYPE,                                
                      CT.STATUS_CHANGE_DT,                              
                      CT.CONTRACT_COMMENTS,                             
                      CT.REV_DISTRICT_CD,                               
                      CT.GL_ACCT_NO_ERN_INT,                            
                      CT.GL_ACCT_NO_DEF_INT,                            
                      EA.CHARGE_AM                                      
                 INTO :CT-ACCOUNT-NO,                                   
                      :CT-PYMT-PRIORITY-LVL,                            
                      :CT-CNT-ITEM-ID,                                  
                      :CT-DATE-CONTRACT,                                
                      :CT-AMT-MO-PYMT,                                  
                      :CT-CODE-INTRST-METH,                             
                      :CT-INTRST-RATE,                                  
                      :CT-INTRST-PRIOR-YR,                              
                      :CT-INTRST-YTD,                                   
                      :CT-NO-SCHED-PYMTS,                               
                      :CT-AMT-ORIG-ENTERED,                             
                      :CT-AMT-DOWN-PYMT,                                
                      :CT-AMT-TAX-STATE,                                
                      :CT-AMT-TAX-CITY,                                 
                      :CT-AMT-TAX-OTHER,                                
                      :CT-CODE-CONTRACT-TYPE,                           
                      :CT-SIMPLE-INT-FIN-CHG,                           
                      :CT-CNT-STATUS-CD,                                
                      :CT-CNT-NAME-CD,                                  
                      :CT-USER-ID,                                      
                      :CT-LIEN-CD,                                      
                      :CT-LAST-UPDATE-TS,                               
                      :CT-AMT-DEF-INTEREST,                             
                      :CT-REBATE-AMOUNT,                                
                      :CT-REBATE-CD,                                    
                      :CT-CODE-BILL-TYPE,                               
                      :CT-STATUS-CHANGE-DT :WS-NULL-IND,                 
                      :CT-CONTRACT-COMMENTS,                            
                      :CT-REV-DISTRICT-CD,                              
                      :CT-GL-ACCT-NO-ERN-INT,                           
                      :CT-GL-ACCT-NO-DEF-INT,                           
                      :EA-CHARGE-AM                                     
                 FROM CSS_CONTRACT  CT WITH(READUNCOMMITTED)                    
                     ,CSS_CNT_DETAIL EA WITH(READUNCOMMITTED)                   
                WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO             
                  AND CT.PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL      
                  AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID            
                  AND CT.ACCOUNT_NO        = EA.ACCOUNT_NO              
                  AND CT.CNT_ITEM_ID       = EA.CNT_ITEM_ID             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CT.ACCOUNT_NO,                                            
MFA-TR*               CT.PYMT_PRIORITY_LVL,                                     
MFA-TR*               CT.CNT_ITEM_ID,                                           
MFA-TR*               CT.DATE_CONTRACT,                                         
MFA-TR*               CT.AMT_MO_PYMT,                                           
MFA-TR*               CT.CODE_INTRST_METH,                                      
MFA-TR*               CT.INTRST_RATE,                                           
MFA-TR*               CT.INTRST_PRIOR_YR,                                       
MFA-TR*               CT.INTRST_YTD,                                            
MFA-TR*               CT.NO_SCHED_PYMTS,                                        
MFA-TR*               CT.AMT_ORIG_ENTERED,                                      
MFA-TR*               CT.AMT_DOWN_PYMT,                                         
MFA-TR*               CT.AMT_TAX_STATE,                                         
MFA-TR*               CT.AMT_TAX_CITY,                                          
MFA-TR*               CT.AMT_TAX_OTHER,                                         
MFA-TR*               CT.CODE_CONTRACT_TYPE,                                    
MFA-TR*               CT.SIMPLE_INT_FIN_CHG,                                    
MFA-TR*               CT.CNT_STATUS_CD,                                         
MFA-TR*               CT.CNT_NAME_CD,                                           
MFA-TR*               CT.USER_ID,                                               
MFA-TR*               CT.LIEN_CD,                                               
MFA-TR*               CT.LAST_UPDATE_TS,                                        
MFA-TR*               CT.AMT_DEF_INTEREST,                                      
MFA-TR*               CT.REBATE_AMOUNT,                                         
MFA-TR*               CT.REBATE_CD,                                             
MFA-TR*               CT.CODE_BILL_TYPE,                                        
MFA-TR*               CT.STATUS_CHANGE_DT,                                      
MFA-TR*               CT.CONTRACT_COMMENTS,                                     
MFA-TR*               CT.REV_DISTRICT_CD,                                       
MFA-TR*               CT.GL_ACCT_NO_ERN_INT,                                    
MFA-TR*               CT.GL_ACCT_NO_DEF_INT,                                    
MFA-TR*               EA.CHARGE_AM                                              
MFA-TR*          INTO :CT-ACCOUNT-NO,                                           
MFA-TR*               :CT-PYMT-PRIORITY-LVL,                                    
MFA-TR*               :CT-CNT-ITEM-ID,                                          
MFA-TR*               :CT-DATE-CONTRACT,                                        
MFA-TR*               :CT-AMT-MO-PYMT,                                          
MFA-TR*               :CT-CODE-INTRST-METH,                                     
MFA-TR*               :CT-INTRST-RATE,                                          
MFA-TR*               :CT-INTRST-PRIOR-YR,                                      
MFA-TR*               :CT-INTRST-YTD,                                           
MFA-TR*               :CT-NO-SCHED-PYMTS,                                       
MFA-TR*               :CT-AMT-ORIG-ENTERED,                                     
MFA-TR*               :CT-AMT-DOWN-PYMT,                                        
MFA-TR*               :CT-AMT-TAX-STATE,                                        
MFA-TR*               :CT-AMT-TAX-CITY,                                         
MFA-TR*               :CT-AMT-TAX-OTHER,                                        
MFA-TR*               :CT-CODE-CONTRACT-TYPE,                                   
MFA-TR*               :CT-SIMPLE-INT-FIN-CHG,                                   
MFA-TR*               :CT-CNT-STATUS-CD,                                        
MFA-TR*               :CT-CNT-NAME-CD,                                          
MFA-TR*               :CT-USER-ID,                                              
MFA-TR*               :CT-LIEN-CD,                                              
MFA-TR*               :CT-LAST-UPDATE-TS,                                       
MFA-TR*               :CT-AMT-DEF-INTEREST,                                     
MFA-TR*               :CT-REBATE-AMOUNT,                                        
MFA-TR*               :CT-REBATE-CD,                                            
MFA-TR*               :CT-CODE-BILL-TYPE,                                       
MFA-TR*               :CT-STATUS-CHANGE-DT:WS-NULL-IND,                         
MFA-TR*               :CT-CONTRACT-COMMENTS,                                    
MFA-TR*               :CT-REV-DISTRICT-CD,                                      
MFA-TR*               :CT-GL-ACCT-NO-ERN-INT,                                   
MFA-TR*               :CT-GL-ACCT-NO-DEF-INT,                                   
MFA-TR*               :EA-CHARGE-AM                                             
MFA-TR*          FROM CSS_CONTRACT  CT                                          
MFA-TR*              ,CSS_CNT_DETAIL EA                                         
MFA-TR*         WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO                     
MFA-TR*           AND CT.PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL              
MFA-TR*           AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID                    
MFA-TR*           AND CT.ACCOUNT_NO        = EA.ACCOUNT_NO                      
MFA-TR*           AND CT.CNT_ITEM_ID       = EA.CNT_ITEM_ID                     
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE   TO                           
ACT245                                     WS-4822-DB2-ERR-RETURN-CD    
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CT-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE CT-CNT-ITEM-ID            TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7111-GET-CURR-CNT-STATUS.                                      *        
      ******************************************************************        
       7111-GET-CURR-CNT-STATUS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT CT.CNT_STATUS_CD                                  
                 INTO :CT-CNT-STATUS-CD                                 
                 FROM CSS_CONTRACT  CT WITH(READUNCOMMITTED)                    
                WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO             
                  AND CT.PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL      
                  AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CT.CNT_STATUS_CD                                          
MFA-TR*          INTO :CT-CNT-STATUS-CD                                         
MFA-TR*          FROM CSS_CONTRACT  CT                                          
MFA-TR*         WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO                     
MFA-TR*           AND CT.PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL              
MFA-TR*           AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID                    
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7111                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE   TO                           
ACT245                                     WS-4822-DB2-ERR-RETURN-CD    
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7111'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CT-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE CT-CNT-ITEM-ID            TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7111-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7260-SEL-CUR-REV-MONTH.                                        *        
      ******************************************************************        
       7260-SEL-CUR-REV-MONTH.                                          
                                                                        
           EXEC SQL                                                     
              SELECT MIN(CIS.DECIMAL2CHAR(B.REVENUE_MONTH))                     
                INTO :WS-REVENUE-MONTH-CHAR                             
                FROM CSS_ACCOUNT A WITH(READUNCOMMITTED),                       
                     CSS_BILL_WINDOW B WITH(READUNCOMMITTED)                    
               WHERE A.ACCOUNT_NO      = :AT-ACCOUNT-NO                 
                 AND B.DATE_EXTRACT   >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                 AND A.BILL_CYCLE      = B.BILL_CYCLE                   
                 AND B.CODE_BILL_COND  = 'C'                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(CHAR(B.REVENUE_MONTH))                                 
MFA-TR*         INTO :WS-REVENUE-MONTH-CHAR                                     
MFA-TR*         FROM CSS_ACCOUNT A,                                             
MFA-TR*              CSS_BILL_WINDOW B                                          
MFA-TR*        WHERE A.ACCOUNT_NO      = :AT-ACCOUNT-NO                         
MFA-TR*          AND B.DATE_EXTRACT   >= CURRENT DATE                           
MFA-TR*          AND A.BILL_CYCLE      = B.BILL_CYCLE                           
MFA-TR*          AND B.CODE_BILL_COND  = 'C'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND      TO TRUE                   
ACT245        MOVE WS-ACTIVE-RETURN-CODE      TO                        
ACT245                                        WS-4822-DB2-ERR-RETURN-CD 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7260'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT '                  TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'CSS_ACCOUNT'              TO TABLE-2                
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9910-SQL-ERROR             THRU 9910-EXIT         
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7270-CHECK-OTHER-FACDMG.                                       *        
      ******************************************************************        
       7270-CHECK-OTHER-FACDMG.                                         
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-OTHER-FAC-DMG-EXIST                            
                FROM CSS_CONTRACT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO                
                 AND CODE_CONTRACT_TYPE = 'L'                           
                 AND CNT_ITEM_ID        <> :CT-CNT-ITEM-ID              
                 AND CNT_STATUS_CD      <> 'D'                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-OTHER-FAC-DMG-EXIST                                    
MFA-TR*         FROM CSS_CONTRACT                                               
MFA-TR*        WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO                        
MFA-TR*          AND CODE_CONTRACT_TYPE = 'L'                                   
MFA-TR*          AND CNT_ITEM_ID        <> :CT-CNT-ITEM-ID                      
MFA-TR*          AND CNT_STATUS_CD      <> 'D'                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               SET  CPD4822-DB2-ERR-FOUND     TO TRUE                   
ACT245         MOVE WS-ACTIVE-RETURN-CODE     TO                        
ACT245                                        WS-4822-DB2-ERR-RETURN-CD 
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7270'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT '                 TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                  ABEND-TABLES          
               MOVE 'CSS_CONTRACT'            TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE 'CNT_ITEM_ID'             TO TABLE-ELEMENT-2        
               MOVE WS-4822-CNT-ITEM-ID       TO HOSTVAR-ELEMENT-2      
               PERFORM 9910-SQL-ERROR           THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7300-SELECT-GL-ACCT.                                          *         
      *****************************************************************         
       7300-SELECT-GL-ACCT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT GL_ACCT_NO                                         
                INTO :GO-GL-ACCT-NO                                     
                FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
               WHERE COMPANY_NO        = :WS-SCEG                       
                 AND GL_ACCT_NAME      = :GO-GL-ACCT-NAME               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NO                                                 
MFA-TR*         INTO :GO-GL-ACCT-NO                                             
MFA-TR*         FROM CSS_GL_ACCT_NO                                             
MFA-TR*        WHERE COMPANY_NO        = :WS-SCEG                               
MFA-TR*          AND GL_ACCT_NAME      = :GO-GL-ACCT-NAME                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND OR SUCCESSFUL-CALL  
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_GL_ACCT_NO'          TO TABLE-1                 
              MOVE '01'                      TO HOSTVAR-ELEMENT-1       
              MOVE GO-GL-ACCT-NAME           TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-SELECT-GL.                                                *        
      ******************************************************************        
       7400-SELECT-GL.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT SF.GL_ACCT_NO                                      
                INTO :SF-GL-ACCT-NO                                     
                FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                     
               WHERE FACTOR_ID = '@WHTGDSN'                             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SF.GL_ACCT_NO                                              
MFA-TR*         INTO :SF-GL-ACCT-NO                                             
MFA-TR*         FROM CSS_SPCL_FCTR SF                                           
MFA-TR*        WHERE FACTOR_ID = '@WHTGDSN'                                     
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-1                 
              MOVE '@WHTGDSN'                TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-SELECT-AR-CNTL-SUMM.                                      *        
      ******************************************************************        
       7500-SELECT-AR-CNTL-SUMM.                                        
                                                                        
           EXEC SQL                                                     
              SELECT AMT_AR_DAY_00,                                     
                     AMT_AR_DAY_30,                                     
                     AMT_AR_DAY_60,                                     
                     AMT_AR_DAY_90,                                     
                     AMT_TRAN_BALANCE,                                  
                     AMT_UNUSED_CR,                                     
                     TOT_SUMM_UNBILLED,                                 
                     REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO :WS-SUMM-AC-AMT-AR-DAY-00,                         
                     :WS-SUMM-AC-AMT-AR-DAY-30,                         
                     :WS-SUMM-AC-AMT-AR-DAY-60,                         
                     :WS-SUMM-AC-AMT-AR-DAY-90,                         
                     :WS-SUMM-AC-AMT-TRAN-BALANCE,                      
                     :WS-SUMM-AC-AMT-UNUSED-CR,                         
                     :WS-SUMM-AC-TOT-SUMM-UNBILLED,                     
                     :WS-AC-LAST-UPDATE-TS-SUMM                         
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_AR_DAY_00,                                             
MFA-TR*              AMT_AR_DAY_30,                                             
MFA-TR*              AMT_AR_DAY_60,                                             
MFA-TR*              AMT_AR_DAY_90,                                             
MFA-TR*              AMT_TRAN_BALANCE,                                          
MFA-TR*              AMT_UNUSED_CR,                                             
MFA-TR*              TOT_SUMM_UNBILLED,                                         
MFA-TR*              LAST_UPDATE_TS                                             
MFA-TR*         INTO :WS-SUMM-AC-AMT-AR-DAY-00,                                 
MFA-TR*              :WS-SUMM-AC-AMT-AR-DAY-30,                                 
MFA-TR*              :WS-SUMM-AC-AMT-AR-DAY-60,                                 
MFA-TR*              :WS-SUMM-AC-AMT-AR-DAY-90,                                 
MFA-TR*              :WS-SUMM-AC-AMT-TRAN-BALANCE,                              
MFA-TR*              :WS-SUMM-AC-AMT-UNUSED-CR,                                 
MFA-TR*              :WS-SUMM-AC-TOT-SUMM-UNBILLED,                             
MFA-TR*              :WS-AC-LAST-UPDATE-TS-SUMM                                 
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           = :AC-ITEM-ID                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-1       
              MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7900-OPEN-OTHER-TAX-CURSOR.                                    *        
      ******************************************************************        
       7900-OPEN-OTHER-TAX-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN OTHER_TAX_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND      TO TRUE                   
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7900'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN   '                  TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_TAX_RATE'             TO TABLE-1                
              MOVE 'CSS_TAX_CNTL'             TO TABLE-2                
              MOVE 'CSS_SPCL_FCTR'            TO TABLE-3                
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9910-SQL-ERROR             THRU 9910-EXIT         
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7905-FETCH-OTHER-TAX-CURSOR.                                  *         
      *****************************************************************         
       7905-FETCH-OTHER-TAX-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
              FETCH OTHER_TAX_CSR                                       
               INTO :TR-TAX-RATE,                                       
                    :TR-TAX-CNTRL-NO,                                   
                    :TR-TAX-ENTRY-SEQ-NO,                               
                    :SF-GL-ACCT-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              (WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND AND                
               WS-SUB2 NOT EQUAL ZERO)                                  
              CONTINUE                                                  
           ELSE                                                         
             IF (PROGRAM-NAME (1:4) = 'S043' OR                         
                 PROGRAM-NAME = 'CSR04822'   OR                         
                 PROGRAM-NAME = 'MCSCB822')  AND                        
                WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND AND               
                WS-SUB2 EQUAL ZERO                                      
                SET CPD4822-DB2-ERR-FOUND TO TRUE                       
                MOVE 5011                 TO WS-4822-APPL-CNT-RETURN-CD 
             ELSE                                                       
                SET  CPD4822-DB2-ERR-FOUND TO TRUE                      
ACT245          MOVE WS-ACTIVE-RETURN-CODE TO                           
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE '7905'               TO ACTIVE-PARAGRAPH           
                MOVE 'FETCH  '            TO ABEND-FUNCTION             
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                MOVE 'CSS_TAX_RATE'       TO TABLE-1                    
                MOVE 'CSS_TAX_CNTL'       TO TABLE-2                    
                MOVE 'CSS_SPCL_FCTR'      TO TABLE-3                    
                MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1          
             END-IF                                                     
             PERFORM 9910-SQL-ERROR             THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7905-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7910-CLOSE-OTHER-TAX-CURSOR..                                  *        
      ******************************************************************        
       7910-CLOSE-OTHER-TAX-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE OTHER_TAX_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7910'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE  '                 TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_TAX_RATE'            TO TABLE-1                 
              MOVE 'CSS_TAX_CNTL'            TO TABLE-2                 
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-3                 
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8000-INSERT-CONTRACT-HEADER.                                   *        
      ******************************************************************        
       8000-INSERT-CONTRACT-HEADER.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CONTRACT                                  
                (  ACCOUNT_NO                                           
                  ,PYMT_PRIORITY_LVL                                    
                  ,CNT_ITEM_ID                                          
                  ,DATE_CONTRACT                                        
                  ,AMT_MO_PYMT                                          
                  ,DATE_PYMT_START                                      
                  ,CODE_INTRST_METH                                     
                  ,INTRST_RATE                                          
                  ,INTRST_PRIOR_YR                                      
                  ,INTRST_YTD                                           
                  ,NO_SCHED_PYMTS                                       
                  ,AMT_ORIG_ENTERED                                     
                  ,AMT_DOWN_PYMT                                        
                  ,AMT_TAX_STATE                                        
                  ,AMT_TAX_CITY                                         
                  ,AMT_TAX_OTHER                                        
                  ,CODE_CONTRACT_TYPE                                   
                  ,SIMPLE_INT_FIN_CHG                                   
                  ,CNT_STATUS_CD                                        
                  ,CNT_NAME_CD                                          
                  ,USER_ID                                              
                  ,LIEN_CD                                              
                  ,CODE_COMPLY_HIST                                     
                  ,LAST_UPDATE_TS                                       
                  ,AMT_DEF_INTEREST                                     
                  ,REBATE_AMOUNT                                        
                  ,REBATE_CD                                            
                  ,CODE_BILL_TYPE                                       
                  ,REV_DISTRICT_CD                                      
                  ,STATUS_CHANGE_DT                                     
                  ,CONTRACT_COMMENTS                                    
                  ,GL_ACCT_NO_ERN_INT                                   
                  ,GL_ACCT_NO_DEF_INT                                   
ACT278            ,CNT_XFER_ITEM_ID                                     
ACT278            ,CNT_XFER_ACCT_NO                                     
                  ,CNT_ADDL_DESC                                        
ACT278            ,CREDIT_EXEMPT_CODE )                                 
          VALUES ( :CT-ACCOUNT-NO                                       
                  ,:CT-PYMT-PRIORITY-LVL                                
                  ,:CT-CNT-ITEM-ID                                      
                  ,IIF(TRY_CONVERT(DATE, :CT-DATE-CONTRACT
              ) IS NULL OR (PATINDEX('%.%', :CT-DATE-CONTRACT
              ) <> 0) OR (LEN(:CT-DATE-CONTRACT) <> 10), CIS.CHAR2DATE(
                                                      :CT-DATE-CONTRACT
              ), CONVERT(DATE, :CT-DATE-CONTRACT) )                            
                  ,:CT-AMT-MO-PYMT                                      
                  ,IIF(TRY_CONVERT(DATE, :CT-DATE-PYMT-START
              ) IS NULL OR (PATINDEX('%.%', :CT-DATE-PYMT-START
              ) <> 0) OR (LEN(:CT-DATE-PYMT-START
              ) <> 10), CIS.CHAR2DATE(:CT-DATE-PYMT-START
              ), CONVERT(DATE, :CT-DATE-PYMT-START) )                          
                  ,:CT-CODE-INTRST-METH                                 
                  ,:CT-INTRST-RATE                                      
                  ,:CT-INTRST-PRIOR-YR                                  
                  ,:CT-INTRST-YTD                                       
                  ,:CT-NO-SCHED-PYMTS                                   
                  ,:CT-AMT-ORIG-ENTERED                                 
                  ,:CT-AMT-DOWN-PYMT                                    
                  ,:CT-AMT-TAX-STATE                                    
                  ,:CT-AMT-TAX-CITY                                     
                  ,:CT-AMT-TAX-OTHER                                    
                  ,:CT-CODE-CONTRACT-TYPE                               
                  ,:CT-SIMPLE-INT-FIN-CHG                               
                  ,:CT-CNT-STATUS-CD                                    
                  ,:CT-CNT-NAME-CD                                      
                  ,:CT-USER-ID                                          
                  ,:CT-LIEN-CD                                          
                  ,:CT-CODE-COMPLY-HIST                                 
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:CT-AMT-DEF-INTEREST                                 
                  ,:CT-REBATE-AMOUNT                                    
                  ,:CT-REBATE-CD                                        
                  ,:CT-CODE-BILL-TYPE                                   
                  ,:CT-REV-DISTRICT-CD                                  
                  ,IIF(TRY_CONVERT(DATE, :CT-STATUS-CHANGE-DT 
                                         :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :CT-STATUS-CHANGE-DT 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ), CONVERT(DATE, :CT-STATUS-CHANGE-DT :WS-NULL-IND) )            
                  ,:CT-CONTRACT-COMMENTS                                
                  ,:CT-GL-ACCT-NO-ERN-INT                               
                  ,:CT-GL-ACCT-NO-DEF-INT                               
ACT278            ,:CT-CNT-XFER-ITEM-ID                                 
ACT278            ,:CT-CNT-XFER-ACCT-NO                                 
                  ,:CT-CNT-ADDL-DESC                                    
ACT278            ,'' )                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CONTRACT                                          
MFA-TR*         (  ACCOUNT_NO                                                   
MFA-TR*           ,PYMT_PRIORITY_LVL                                            
MFA-TR*           ,CNT_ITEM_ID                                                  
MFA-TR*           ,DATE_CONTRACT                                                
MFA-TR*           ,AMT_MO_PYMT                                                  
MFA-TR*           ,DATE_PYMT_START                                              
MFA-TR*           ,CODE_INTRST_METH                                             
MFA-TR*           ,INTRST_RATE                                                  
MFA-TR*           ,INTRST_PRIOR_YR                                              
MFA-TR*           ,INTRST_YTD                                                   
MFA-TR*           ,NO_SCHED_PYMTS                                               
MFA-TR*           ,AMT_ORIG_ENTERED                                             
MFA-TR*           ,AMT_DOWN_PYMT                                                
MFA-TR*           ,AMT_TAX_STATE                                                
MFA-TR*           ,AMT_TAX_CITY                                                 
MFA-TR*           ,AMT_TAX_OTHER                                                
MFA-TR*           ,CODE_CONTRACT_TYPE                                           
MFA-TR*           ,SIMPLE_INT_FIN_CHG                                           
MFA-TR*           ,CNT_STATUS_CD                                                
MFA-TR*           ,CNT_NAME_CD                                                  
MFA-TR*           ,USER_ID                                                      
MFA-TR*           ,LIEN_CD                                                      
MFA-TR*           ,CODE_COMPLY_HIST                                             
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,AMT_DEF_INTEREST                                             
MFA-TR*           ,REBATE_AMOUNT                                                
MFA-TR*           ,REBATE_CD                                                    
MFA-TR*           ,CODE_BILL_TYPE                                               
MFA-TR*           ,REV_DISTRICT_CD                                              
MFA-TR*           ,STATUS_CHANGE_DT                                             
MFA-TR*           ,CONTRACT_COMMENTS                                            
MFA-TR*           ,GL_ACCT_NO_ERN_INT                                           
MFA-TR*           ,GL_ACCT_NO_DEF_INT                                           
MFA-TR*           ,CNT_XFER_ITEM_ID                                             
MFA-TR*           ,CNT_XFER_ACCT_NO                                             
MFA-TR*           ,CNT_ADDL_DESC                                                
MFA-TR*           ,CREDIT_EXEMPT_CODE )                                         
MFA-TR*   VALUES ( :CT-ACCOUNT-NO                                               
MFA-TR*           ,:CT-PYMT-PRIORITY-LVL                                        
MFA-TR*           ,:CT-CNT-ITEM-ID                                              
MFA-TR*           ,:CT-DATE-CONTRACT                                            
MFA-TR*           ,:CT-AMT-MO-PYMT                                              
MFA-TR*           ,:CT-DATE-PYMT-START                                          
MFA-TR*           ,:CT-CODE-INTRST-METH                                         
MFA-TR*           ,:CT-INTRST-RATE                                              
MFA-TR*           ,:CT-INTRST-PRIOR-YR                                          
MFA-TR*           ,:CT-INTRST-YTD                                               
MFA-TR*           ,:CT-NO-SCHED-PYMTS                                           
MFA-TR*           ,:CT-AMT-ORIG-ENTERED                                         
MFA-TR*           ,:CT-AMT-DOWN-PYMT                                            
MFA-TR*           ,:CT-AMT-TAX-STATE                                            
MFA-TR*           ,:CT-AMT-TAX-CITY                                             
MFA-TR*           ,:CT-AMT-TAX-OTHER                                            
MFA-TR*           ,:CT-CODE-CONTRACT-TYPE                                       
MFA-TR*           ,:CT-SIMPLE-INT-FIN-CHG                                       
MFA-TR*           ,:CT-CNT-STATUS-CD                                            
MFA-TR*           ,:CT-CNT-NAME-CD                                              
MFA-TR*           ,:CT-USER-ID                                                  
MFA-TR*           ,:CT-LIEN-CD                                                  
MFA-TR*           ,:CT-CODE-COMPLY-HIST                                         
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:CT-AMT-DEF-INTEREST                                         
MFA-TR*           ,:CT-REBATE-AMOUNT                                            
MFA-TR*           ,:CT-REBATE-CD                                                
MFA-TR*           ,:CT-CODE-BILL-TYPE                                           
MFA-TR*           ,:CT-REV-DISTRICT-CD                                          
MFA-TR*           ,:CT-STATUS-CHANGE-DT:WS-NULL-IND                             
MFA-TR*           ,:CT-CONTRACT-COMMENTS                                        
MFA-TR*           ,:CT-GL-ACCT-NO-ERN-INT                                       
MFA-TR*           ,:CT-GL-ACCT-NO-DEF-INT                                       
MFA-TR*           ,:CT-CNT-XFER-ITEM-ID                                         
MFA-TR*           ,:CT-CNT-XFER-ACCT-NO                                         
MFA-TR*           ,:CT-CNT-ADDL-DESC                                            
MFA-TR*           ,'' )                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT-PRIORITY-LVL'       TO TABLE-ELEMENT-2         
              MOVE 'CNT-ITEM-ID'             TO TABLE-ELEMENT-3         
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CT-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE CT-CNT-ITEM-ID            TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8005-UPDATE-ADV-COLL-CNT.                                      *        
      ******************************************************************        
       8005-UPDATE-ADV-COLL-CNT.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTRACT                                       
                 SET DATE_CONTRACT      = IIF(TRY_CONVERT(DATE, 
                                                      :CT-DATE-CONTRACT
              ) IS NULL OR (PATINDEX('%.%', :CT-DATE-CONTRACT
              ) <> 0) OR (LEN(:CT-DATE-CONTRACT) <> 10), CIS.CHAR2DATE(
                                                      :CT-DATE-CONTRACT
              ), CONVERT(DATE, :CT-DATE-CONTRACT) ),            
                     AMT_MO_PYMT        = :CT-AMT-MO-PYMT,              
                     CODE_INTRST_METH   = :CT-CODE-INTRST-METH,         
                     INTRST_RATE        = :CT-INTRST-RATE,              
                     INTRST_PRIOR_YR    = :CT-INTRST-PRIOR-YR,          
                     INTRST_YTD         = :CT-INTRST-YTD,               
                     NO_SCHED_PYMTS     = :CT-NO-SCHED-PYMTS,           
                     AMT_ORIG_ENTERED   = :CT-AMT-ORIG-ENTERED,         
                     AMT_DOWN_PYMT      = :CT-AMT-DOWN-PYMT,            
                     AMT_TAX_STATE      = :CT-AMT-TAX-STATE,            
                     AMT_TAX_CITY       = :CT-AMT-TAX-CITY,             
                     AMT_TAX_OTHER      = :CT-AMT-TAX-OTHER,            
                     SIMPLE_INT_FIN_CHG = :CT-SIMPLE-INT-FIN-CHG,       
                     CNT_STATUS_CD      = :CT-CNT-STATUS-CD,            
                     LIEN_CD            = :CT-LIEN-CD,                  
                     LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP(),            
                     AMT_DEF_INTEREST   = :CT-AMT-DEF-INTEREST,         
                     REBATE_AMOUNT      = :CT-REBATE-AMOUNT,            
                     REBATE_CD          = :CT-REBATE-CD,                
                     CODE_BILL_TYPE     = :CT-CODE-BILL-TYPE,           
                     STATUS_CHANGE_DT   = IIF(TRY_CONVERT(DATE, 
                                                  :CT-STATUS-CHANGE-DT 
                                                           :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :CT-STATUS-CHANGE-DT 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ), CONVERT(DATE, :CT-STATUS-CHANGE-DT :WS-NULL-IND) ),           
                     CONTRACT_COMMENTS  = :CT-CONTRACT-COMMENTS,        
                     REV_DISTRICT_CD    = :CT-REV-DISTRICT-CD,          
                     GL_ACCT_NO_ERN_INT = :CT-GL-ACCT-NO-ERN-INT,       
                     GL_ACCT_NO_DEF_INT = :CT-GL-ACCT-NO-DEF-INT,       
                     USER_ID            = :CT-USER-ID,                  
                     CNT_ADDL_DESC      = :CT-CNT-ADDL-DESC             
               WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO                
                 AND PYMT_PRIORITY_LVL  = :CT-PYMT-PRIORITY-LVL         
                 AND CNT_ITEM_ID        = :CT-CNT-ITEM-ID               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTRACT                                               
MFA-TR*          SET DATE_CONTRACT      = :CT-DATE-CONTRACT,                    
MFA-TR*              AMT_MO_PYMT        = :CT-AMT-MO-PYMT,                      
MFA-TR*              CODE_INTRST_METH   = :CT-CODE-INTRST-METH,                 
MFA-TR*              INTRST_RATE        = :CT-INTRST-RATE,                      
MFA-TR*              INTRST_PRIOR_YR    = :CT-INTRST-PRIOR-YR,                  
MFA-TR*              INTRST_YTD         = :CT-INTRST-YTD,                       
MFA-TR*              NO_SCHED_PYMTS     = :CT-NO-SCHED-PYMTS,                   
MFA-TR*              AMT_ORIG_ENTERED   = :CT-AMT-ORIG-ENTERED,                 
MFA-TR*              AMT_DOWN_PYMT      = :CT-AMT-DOWN-PYMT,                    
MFA-TR*              AMT_TAX_STATE      = :CT-AMT-TAX-STATE,                    
MFA-TR*              AMT_TAX_CITY       = :CT-AMT-TAX-CITY,                     
MFA-TR*              AMT_TAX_OTHER      = :CT-AMT-TAX-OTHER,                    
MFA-TR*              SIMPLE_INT_FIN_CHG = :CT-SIMPLE-INT-FIN-CHG,               
MFA-TR*              CNT_STATUS_CD      = :CT-CNT-STATUS-CD,                    
MFA-TR*              LIEN_CD            = :CT-LIEN-CD,                          
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP,                    
MFA-TR*              AMT_DEF_INTEREST   = :CT-AMT-DEF-INTEREST,                 
MFA-TR*              REBATE_AMOUNT      = :CT-REBATE-AMOUNT,                    
MFA-TR*              REBATE_CD          = :CT-REBATE-CD,                        
MFA-TR*              CODE_BILL_TYPE     = :CT-CODE-BILL-TYPE,                   
MFA-TR*              STATUS_CHANGE_DT   = :CT-STATUS-CHANGE-DT                  
MFA-TR*                                   :WS-NULL-IND,                         
MFA-TR*              CONTRACT_COMMENTS  = :CT-CONTRACT-COMMENTS,                
MFA-TR*              REV_DISTRICT_CD    = :CT-REV-DISTRICT-CD,                  
MFA-TR*              GL_ACCT_NO_ERN_INT = :CT-GL-ACCT-NO-ERN-INT,               
MFA-TR*              GL_ACCT_NO_DEF_INT = :CT-GL-ACCT-NO-DEF-INT,               
MFA-TR*              USER_ID            = :CT-USER-ID,                          
MFA-TR*              CNT_ADDL_DESC      = :CT-CNT-ADDL-DESC                     
MFA-TR*        WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO                        
MFA-TR*          AND PYMT_PRIORITY_LVL  = :CT-PYMT-PRIORITY-LVL                 
MFA-TR*          AND CNT_ITEM_ID        = :CT-CNT-ITEM-ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8005'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT-PRIORITY-LVL'       TO TABLE-ELEMENT-2         
              MOVE 'CNT-ITEM-ID'             TO TABLE-ELEMENT-3         
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CT-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE CT-CNT-ITEM-ID            TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-CNT-DETAIL.                                        *        
      ******************************************************************        
       8010-INSERT-CNT-DETAIL.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CNT_DETAIL                                
               ( ACCOUNT_NO,                                            
                 CNT_ITEM_ID,                                           
                 CODE_SERVICE_TYPE,                                     
                 CHARGE_AM,                                             
                 CHARGE_TYPE_CD,                                        
                 GL_ACCT_NO,                                            
                 WRT_OFF_GL_ACCT_NO,                                    
                 DISPOSAL_FEE_AM,                                       
                 INSPECTION_FEE_AM,                                     
ACT160           FILING_FEE_AM,                                         
ACT278           PYMT_PRIORITY_LVL,                                     
                 COST_CENTER)                                           
               VALUES                                                   
               ( :EA-ACCOUNT-NO,                                        
                 :EA-CNT-ITEM-ID,                                       
                 :EA-CODE-SERVICE-TYPE,                                 
                 :EA-CHARGE-AM,                                         
                 :EA-CHARGE-TYPE-CD,                                    
                 :EA-GL-ACCT-NO,                                        
                 :EA-WRT-OFF-GL-ACCT-NO,                                
                 :EA-DISPOSAL-FEE-AM,                                   
                 :EA-INSPECTION-FEE-AM,                                 
ACT160           :EA-FILING-FEE-AM,                                     
ACT278           100,                                                   
                 :EA-COST-CENTER)                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNT_DETAIL'          TO TABLE-1                 
              MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1         
              MOVE 'CNT-ITEM-ID'             TO TABLE-ELEMENT-2         
              MOVE 'PYMT-PRIORITY-LVL'       TO TABLE-ELEMENT-3         
              MOVE EA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE EA-CNT-ITEM-ID            TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8015-INSERT-SUMM-CSS-AR-CNTL.                                  *        
      ******************************************************************        
       8015-INSERT-SUMM-CSS-AR-CNTL.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_AR_CNTL                                   
                   ( ACCOUNT_NO,                                        
                     PYMT_PRIORITY_LVL,                                 
                     ITEM_ID,                                           
                     AMT_AR_DAY_00,                                     
                     AMT_AR_DAY_30,                                     
                     AMT_AR_DAY_60,                                     
                     AMT_AR_DAY_90,                                     
                     AMT_UNUSED_CR,                                     
                     AMT_TRAN_BALANCE,                                  
                     TOT_SUMM_UNBILLED,                                 
                     LAST_UPDATE_TS )                                   
             VALUES (:AC-ACCOUNT-NO,                                    
                     :AC-PYMT-PRIORITY-LVL,                             
                     :AC-ITEM-ID,                                       
                     :WS-SUMM-AC-AMT-AR-DAY-00,                         
                     :WS-SUMM-AC-AMT-AR-DAY-30,                         
                     :WS-SUMM-AC-AMT-AR-DAY-60,                         
                     :WS-SUMM-AC-AMT-AR-DAY-90,                         
                     :WS-SUMM-AC-AMT-UNUSED-CR,                         
                     :WS-SUMM-AC-AMT-TRAN-BALANCE,                      
                     :WS-SUMM-AC-TOT-SUMM-UNBILLED,                     
                     CIS.CHAR2TIMESTAMP(:WS-AC-LAST-UPDATE-TS-SUMM))            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_AR_CNTL                                           
MFA-TR*            ( ACCOUNT_NO,                                                
MFA-TR*              PYMT_PRIORITY_LVL,                                         
MFA-TR*              ITEM_ID,                                                   
MFA-TR*              AMT_AR_DAY_00,                                             
MFA-TR*              AMT_AR_DAY_30,                                             
MFA-TR*              AMT_AR_DAY_60,                                             
MFA-TR*              AMT_AR_DAY_90,                                             
MFA-TR*              AMT_UNUSED_CR,                                             
MFA-TR*              AMT_TRAN_BALANCE,                                          
MFA-TR*              TOT_SUMM_UNBILLED,                                         
MFA-TR*              LAST_UPDATE_TS )                                           
MFA-TR*      VALUES (:AC-ACCOUNT-NO,                                            
MFA-TR*              :AC-PYMT-PRIORITY-LVL,                                     
MFA-TR*              :AC-ITEM-ID,                                               
MFA-TR*              :WS-SUMM-AC-AMT-AR-DAY-00,                                 
MFA-TR*              :WS-SUMM-AC-AMT-AR-DAY-30,                                 
MFA-TR*              :WS-SUMM-AC-AMT-AR-DAY-60,                                 
MFA-TR*              :WS-SUMM-AC-AMT-AR-DAY-90,                                 
MFA-TR*              :WS-SUMM-AC-AMT-UNUSED-CR,                                 
MFA-TR*              :WS-SUMM-AC-AMT-TRAN-BALANCE,                              
MFA-TR*              :WS-SUMM-AC-TOT-SUMM-UNBILLED,                             
MFA-TR*              :WS-AC-LAST-UPDATE-TS-SUMM)                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8015'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-AR-CNTL-DET.                                       *        
      ******************************************************************        
       8020-INSERT-AR-CNTL-DET.                                         
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_AR_CNTL                                   
                   ( ACCOUNT_NO,                                        
                     PYMT_PRIORITY_LVL,                                 
                     ITEM_ID,                                           
                     AMT_AR_DAY_00,                                     
                     AMT_AR_DAY_30,                                     
                     AMT_AR_DAY_60,                                     
                     AMT_AR_DAY_90,                                     
                     AMT_UNUSED_CR,                                     
                     TOT_SUMM_UNBILLED,                                 
                     AMT_TRAN_BALANCE,                                  
                     LAST_UPDATE_TS)                                    
              VALUES (                                                  
                     :AC-ACCOUNT-NO,                                    
                     :AC-PYMT-PRIORITY-LVL,                             
                     :AC-ITEM-ID,                                       
                     :AC-AMT-AR-DAY-00,                                 
                     :AC-AMT-AR-DAY-30,                                 
                     :AC-AMT-AR-DAY-60,                                 
                     :AC-AMT-AR-DAY-90,                                 
                     :AC-AMT-UNUSED-CR,                                 
                     :AC-TOT-SUMM-UNBILLED,                             
                     :AC-AMT-TRAN-BALANCE,                              
                     CIS.CURRENT$TIMESTAMP())                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_AR_CNTL                                           
MFA-TR*            ( ACCOUNT_NO,                                                
MFA-TR*              PYMT_PRIORITY_LVL,                                         
MFA-TR*              ITEM_ID,                                                   
MFA-TR*              AMT_AR_DAY_00,                                             
MFA-TR*              AMT_AR_DAY_30,                                             
MFA-TR*              AMT_AR_DAY_60,                                             
MFA-TR*              AMT_AR_DAY_90,                                             
MFA-TR*              AMT_UNUSED_CR,                                             
MFA-TR*              TOT_SUMM_UNBILLED,                                         
MFA-TR*              AMT_TRAN_BALANCE,                                          
MFA-TR*              LAST_UPDATE_TS)                                            
MFA-TR*       VALUES (                                                          
MFA-TR*              :AC-ACCOUNT-NO,                                            
MFA-TR*              :AC-PYMT-PRIORITY-LVL,                                     
MFA-TR*              :AC-ITEM-ID,                                               
MFA-TR*              :AC-AMT-AR-DAY-00,                                         
MFA-TR*              :AC-AMT-AR-DAY-30,                                         
MFA-TR*              :AC-AMT-AR-DAY-60,                                         
MFA-TR*              :AC-AMT-AR-DAY-90,                                         
MFA-TR*              :AC-AMT-UNUSED-CR,                                         
MFA-TR*              :AC-TOT-SUMM-UNBILLED,                                     
MFA-TR*              :AC-AMT-TRAN-BALANCE,                                      
MFA-TR*              CURRENT TIMESTAMP)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT
           END-IF.         
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8025-UPDATE-AR-CNTL-DET.                                       *        
      ******************************************************************        
       8025-UPDATE-AR-CNTL-DET.                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_AR_CNTL                                       
                  SET AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,            
                      AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30,            
                      AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60,            
                      AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90,            
                      AMT_UNUSED_CR     = :AC-AMT-UNUSED-CR,            
                      AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE,         
                      LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()             
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
                  AND ITEM_ID           = :AC-ITEM-ID                   
ACT368            AND LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                             :WS-AC-LAST-UPDATE-TS-SUMM
              )    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_AR_CNTL                                               
MFA-TR*           SET AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,                    
MFA-TR*               AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30,                    
MFA-TR*               AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60,                    
MFA-TR*               AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90,                    
MFA-TR*               AMT_UNUSED_CR     = :AC-AMT-UNUSED-CR,                    
MFA-TR*               AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE,                 
MFA-TR*               LAST_UPDATE_TS    = CURRENT TIMESTAMP                     
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                 
MFA-TR*           AND ITEM_ID           = :AC-ITEM-ID                           
MFA-TR*           AND LAST_UPDATE_TS    = :WS-AC-LAST-UPDATE-TS-SUMM            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8025'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8025-UPDATE-AR-CNTL-DET.                                       *        
      ******************************************************************        
       8030-UPDATE-AR-CNTL-SUMM.                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
                 SET AMT_AR_DAY_00     = :WS-SUMM-AC-AMT-AR-DAY-00,     
                     AMT_AR_DAY_30     = :WS-SUMM-AC-AMT-AR-DAY-30,     
                     AMT_AR_DAY_60     = :WS-SUMM-AC-AMT-AR-DAY-60,     
                     AMT_AR_DAY_90     = :WS-SUMM-AC-AMT-AR-DAY-90,     
                     AMT_UNUSED_CR     = :WS-SUMM-AC-AMT-UNUSED-CR,     
                     AMT_TRAN_BALANCE  = :WS-SUMM-AC-AMT-TRAN-BALANCE,  
                     TOT_SUMM_UNBILLED = :WS-SUMM-AC-TOT-SUMM-UNBILLED, 
                     LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()              
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
                 AND LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                             :WS-AC-LAST-UPDATE-TS-SUMM
              )     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_AR_CNTL                                                
MFA-TR*          SET AMT_AR_DAY_00     = :WS-SUMM-AC-AMT-AR-DAY-00,             
MFA-TR*              AMT_AR_DAY_30     = :WS-SUMM-AC-AMT-AR-DAY-30,             
MFA-TR*              AMT_AR_DAY_60     = :WS-SUMM-AC-AMT-AR-DAY-60,             
MFA-TR*              AMT_AR_DAY_90     = :WS-SUMM-AC-AMT-AR-DAY-90,             
MFA-TR*              AMT_UNUSED_CR     = :WS-SUMM-AC-AMT-UNUSED-CR,             
MFA-TR*              AMT_TRAN_BALANCE  = :WS-SUMM-AC-AMT-TRAN-BALANCE,          
MFA-TR*              TOT_SUMM_UNBILLED = :WS-SUMM-AC-TOT-SUMM-UNBILLED,         
MFA-TR*              LAST_UPDATE_TS    = CURRENT TIMESTAMP                      
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           = :AC-ITEM-ID                            
MFA-TR*          AND LAST_UPDATE_TS    = :WS-AC-LAST-UPDATE-TS-SUMM             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8035-DELETE-CSS-AR-CNTL.                                       *        
      ******************************************************************        
       8035-DELETE-CSS-AR-CNTL.                                         
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_AR_CNTL                                   
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8035'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8035-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8040-COUNT-AC-ROWS.                                            *        
      ******************************************************************        
       8040-COUNT-AC-ROWS.                                              
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-SUM-AR-BAL :WS-NULL-IND                         
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           > :AC-ITEM-ID                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-SUM-AR-BAL:WS-NULL-IND                                 
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           > :AC-ITEM-ID                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8050-UPDATE-EXEMPTIONS.                                        *        
      ******************************************************************        
       8050-UPDATE-EXEMPTIONS.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET NOTICE_EXEMPT_CD   = :AT-NOTICE-EXEMPT-CD,         
                     CODE_DISC_OK       = :AT-CODE-DISC-OK,             
                     CODE_LPC_XMT       = :AT-CODE-LPC-XMT,             
                     IVR_EXEMPT_CD      = :AT-IVR-EXEMPT-CD,            
                     LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET NOTICE_EXEMPT_CD   = :AT-NOTICE-EXEMPT-CD,                 
MFA-TR*              CODE_DISC_OK       = :AT-CODE-DISC-OK,                     
MFA-TR*              CODE_LPC_XMT       = :AT-CODE-LPC-XMT,                     
MFA-TR*              IVR_EXEMPT_CD      = :AT-IVR-EXEMPT-CD,                    
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               SET  CPD4822-DB2-ERR-FOUND    TO TRUE                    
ACT245         MOVE WS-ACTIVE-RETURN-CODE    TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8050'                   TO ACTIVE-PARAGRAPH        
               MOVE 'UPDATE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                 ABEND-TABLES           
               MOVE 'CSS_ACCOUNT'            TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               PERFORM 9910-SQL-ERROR           THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8060-INSERT-BILL-MSG.                                          *        
      ******************************************************************        
       8060-INSERT-BILL-MSG.                                            
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_SPCL_BILL_MSG                              
                  ( REVENUE_MO_ST                                       
                   ,ACCOUNT_NO                                          
                   ,BILL_MSG_ID                                         
                   ,MSG_TYPE_CD                                         
                   ,COMPANY_NO                                          
                   ,BILL_CYCLE_ST                                       
                   ,BILL_CYCLE_END                                      
                   ,REVENUE_MO_END                                      
                  )                                                     
             VALUES                                                     
                  ( :U1-REVENUE-MO-ST                                   
                   ,:U1-ACCOUNT-NO                                      
                   ,:U1-BILL-MSG-ID                                     
                   ,:U1-MSG-TYPE-CD                                     
                   ,:U1-COMPANY-NO                                      
                   ,:U1-BILL-CYCLE-ST                                   
                   ,:U1-BILL-CYCLE-END                                  
                   ,:U1-REVENUE-MO-END                                  
                  )                                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_MSG_ID'             TO TABLE-ELEMENT-2         
              MOVE 'REVENUE_MO_END'          TO TABLE-ELEMENT-3         
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE U1-BILL-MSG-ID            TO HOSTVAR-ELEMENT-2       
              MOVE U1-REVENUE-MO-END         TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8070-SEL-REV-MONTH.                                            *        
      ******************************************************************        
       8070-SEL-REV-MONTH.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) BN.REVENUE_MONTH                                   
                INTO :BN-REVENUE-MONTH                                  
                FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
               WHERE BILL_CYCLE     =  :BN-BILL-CYCLE                   
                 AND DATE_EXTRACT  >= CAST(SYSDATETIMEOFFSET() AS DATE)         
               ORDER BY DATE_EXTRACT                                    
                                                                 
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BN.REVENUE_MONTH                                           
MFA-TR*         INTO :BN-REVENUE-MONTH                                          
MFA-TR*         FROM CSS_BILL_WINDOW BN                                         
MFA-TR*        WHERE BILL_CYCLE     =  :BN-BILL-CYCLE                           
MFA-TR*          AND DATE_EXTRACT  >= CURRENT DATE                              
MFA-TR*        ORDER BY DATE_EXTRACT                                            
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_WINDOW'         TO TABLE-1                 
              MOVE 'BILL_CYCLE'              TO TABLE-ELEMENT-1         
              MOVE BN-BILL-CYCLE             TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8080-UPDATE-CNT-HDR-AMT.                                       *        
      ******************************************************************        
       8080-UPDATE-CNT-HDR-AMT.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTRACT                                       
                 SET AMT_MO_PYMT        = :CT-AMT-MO-PYMT,              
                     NO_SCHED_PYMTS     = :CT-NO-SCHED-PYMTS,           
                     DATE_CONTRACT      = IIF(TRY_CONVERT(DATE, 
                                                      :CT-DATE-CONTRACT
              ) IS NULL OR (PATINDEX('%.%', :CT-DATE-CONTRACT
              ) <> 0) OR (LEN(:CT-DATE-CONTRACT) <> 10), CIS.CHAR2DATE(
                                                      :CT-DATE-CONTRACT
              ), CONVERT(DATE, :CT-DATE-CONTRACT) ),            
                     DATE_PYMT_START    = IIF(TRY_CONVERT(DATE, 
                                                    :CT-DATE-PYMT-START
              ) IS NULL OR (PATINDEX('%.%', :CT-DATE-PYMT-START
              ) <> 0) OR (LEN(:CT-DATE-PYMT-START
              ) <> 10), CIS.CHAR2DATE(:CT-DATE-PYMT-START
              ), CONVERT(DATE, :CT-DATE-PYMT-START) ),          
                     SIMPLE_INT_FIN_CHG = :CT-SIMPLE-INT-FIN-CHG,       
ACT-1                AMT_DEF_INTEREST   = :CT-AMT-DEF-INTEREST,         
                     LIEN_CD            = :CT-LIEN-CD,                  
                     LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP(),            
                     CNT_STATUS_CD      = :CT-CNT-STATUS-CD,            
ACT-1                STATUS_CHANGE_DT   = IIF(TRY_CONVERT(DATE, 
                                                  :CT-STATUS-CHANGE-DT 
                                                           :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :CT-STATUS-CHANGE-DT 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ), CONVERT(DATE, :CT-STATUS-CHANGE-DT :WS-NULL-IND) ),           
                     CONTRACT_COMMENTS  = :CT-CONTRACT-COMMENTS,        
                     REV_DISTRICT_CD    = :CT-REV-DISTRICT-CD,          
                     CNT_ADDL_DESC      = :CT-CNT-ADDL-DESC,            
                     AMT_ORIG_ENTERED   = :CT-AMT-ORIG-ENTERED          
               WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO                
                 AND CNT_ITEM_ID        = :CT-CNT-ITEM-ID               
                 AND PYMT_PRIORITY_LVL  = :CT-PYMT-PRIORITY-LVL         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTRACT                                               
MFA-TR*          SET AMT_MO_PYMT        = :CT-AMT-MO-PYMT,                      
MFA-TR*              NO_SCHED_PYMTS     = :CT-NO-SCHED-PYMTS,                   
MFA-TR*              DATE_CONTRACT      = :CT-DATE-CONTRACT,                    
MFA-TR*              DATE_PYMT_START    = :CT-DATE-PYMT-START,                  
MFA-TR*              SIMPLE_INT_FIN_CHG = :CT-SIMPLE-INT-FIN-CHG,               
MFA-TR*              AMT_DEF_INTEREST   = :CT-AMT-DEF-INTEREST,                 
MFA-TR*              LIEN_CD            = :CT-LIEN-CD,                          
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP,                    
MFA-TR*              CNT_STATUS_CD      = :CT-CNT-STATUS-CD,                    
MFA-TR*              STATUS_CHANGE_DT   = :CT-STATUS-CHANGE-DT                  
MFA-TR*                                   :WS-NULL-IND,                         
MFA-TR*              CONTRACT_COMMENTS  = :CT-CONTRACT-COMMENTS,                
MFA-TR*              REV_DISTRICT_CD    = :CT-REV-DISTRICT-CD,                  
MFA-TR*              CNT_ADDL_DESC      = :CT-CNT-ADDL-DESC,                    
MFA-TR*              AMT_ORIG_ENTERED   = :CT-AMT-ORIG-ENTERED                  
MFA-TR*        WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO                        
MFA-TR*          AND CNT_ITEM_ID        = :CT-CNT-ITEM-ID                       
MFA-TR*          AND PYMT_PRIORITY_LVL  = :CT-PYMT-PRIORITY-LVL                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               SET  CPD4822-DB2-ERR-FOUND    TO TRUE                    
ACT245         MOVE WS-ACTIVE-RETURN-CODE    TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8080'                   TO ACTIVE-PARAGRAPH        
               MOVE 'UPDATE'                 TO ABEND-FUNCTION          
               MOVE 'CSS_CONTRACT'           TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE 'CNT_ITEM_ID'            TO TABLE-ELEMENT-2         
               MOVE 'PYMT_PRIORITY_LVL'      TO TABLE-ELEMENT-3         
               MOVE CT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               MOVE CT-CNT-ITEM-ID           TO HOSTVAR-ELEMENT-2       
               MOVE CT-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-3       
               PERFORM 9910-SQL-ERROR           THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8080-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8300-UPDATE-CONTRACT.                                          *        
      ******************************************************************25720000
       8300-UPDATE-CONTRACT.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTRACT                                       
                 SET INTRST_RATE         = :CT-INTRST-RATE,             
P00851               SIMPLE_INT_FIN_CHG  = :CT-SIMPLE-INT-FIN-CHG,      
ACT-1                AMT_DEF_INTEREST    = :CT-AMT-DEF-INTEREST,        
                     NO_SCHED_PYMTS      = :CT-NO-SCHED-PYMTS,          
                     CNT_STATUS_CD       = :CT-CNT-STATUS-CD,           
                     LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP(),           
                     STATUS_CHANGE_DT    = IIF(TRY_CONVERT(DATE, 
                                                  :CT-STATUS-CHANGE-DT 
                                                           :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :CT-STATUS-CHANGE-DT 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ), CONVERT(DATE, :CT-STATUS-CHANGE-DT :WS-NULL-IND) ),           
                     CONTRACT_COMMENTS   = :CT-CONTRACT-COMMENTS,       
                     LIEN_CD             = :CT-LIEN-CD,                 
                     REV_DISTRICT_CD     = :CT-REV-DISTRICT-CD,         
                     CNT_ADDL_DESC       = :CT-CNT-ADDL-DESC            
               WHERE ACCOUNT_NO          = :CT-ACCOUNT-NO               
                 AND PYMT_PRIORITY_LVL   = :CT-PYMT-PRIORITY-LVL        
                 AND CNT_ITEM_ID         = :CT-CNT-ITEM-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTRACT                                               
MFA-TR*          SET INTRST_RATE         = :CT-INTRST-RATE,                     
MFA-TR*              SIMPLE_INT_FIN_CHG  = :CT-SIMPLE-INT-FIN-CHG,              
MFA-TR*              AMT_DEF_INTEREST    = :CT-AMT-DEF-INTEREST,                
MFA-TR*              NO_SCHED_PYMTS      = :CT-NO-SCHED-PYMTS,                  
MFA-TR*              CNT_STATUS_CD       = :CT-CNT-STATUS-CD,                   
MFA-TR*              LAST_UPDATE_TS      = CURRENT TIMESTAMP,                   
MFA-TR*              STATUS_CHANGE_DT    = :CT-STATUS-CHANGE-DT                 
MFA-TR*                                    :WS-NULL-IND,                        
MFA-TR*              CONTRACT_COMMENTS   = :CT-CONTRACT-COMMENTS,               
MFA-TR*              LIEN_CD             = :CT-LIEN-CD,                         
MFA-TR*              REV_DISTRICT_CD     = :CT-REV-DISTRICT-CD,                 
MFA-TR*              CNT_ADDL_DESC       = :CT-CNT-ADDL-DESC                    
MFA-TR*        WHERE ACCOUNT_NO          = :CT-ACCOUNT-NO                       
MFA-TR*          AND PYMT_PRIORITY_LVL   = :CT-PYMT-PRIORITY-LVL                
MFA-TR*          AND CNT_ITEM_ID         = :CT-CNT-ITEM-ID                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CT-CNT-ITEM-ID            TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8305-UPDATE-CONTRACT-AMT.                                      *        
      ******************************************************************        
       8305-UPDATE-CONTRACT-AMT.                                        
                                                                        
           MOVE WS-4822-INTRST-RATE        TO CT-INTRST-RATE.           
           MOVE WS-4822-CNT-STATUS-CD      TO CT-CNT-STATUS-CD.         
           MOVE WS-4822-STATUS-CHANGE-DT   TO CT-STATUS-CHANGE-DT.      
           MOVE WS-4822-AMT-MO-PYMT        TO CT-AMT-MO-PYMT.           
           MOVE WS-4822-AMT-ORIG-ENTERED   TO CT-AMT-ORIG-ENTERED.      
           MOVE WS-4822-ADD-ON-INTRST      TO CT-AMT-DEF-INTEREST.      
           MOVE WS-4822-LIEN-CD              TO CT-LIEN-CD.             
           MOVE WS-4822-REV-DISTRICT-CD   TO CT-REV-DISTRICT-CD.        
                                                                        
           IF WS-4822-STATUS-CHANGE-DT EQUAL SPACES                     
              MOVE -1                  TO WS-NULL-IND                   
           ELSE                                                         
              MOVE ZEROES              TO WS-NULL-IND                   
           END-IF.                                                      
                                                                        
           MOVE WS-CNT-COMMENTS-LEN        TO CT-CONTRACT-COMMENTS-LEN. 
           MOVE WS-4822-CNT-COMMENTS-TXT   TO CT-CONTRACT-COMMENTS-TEXT 
      *    MOVE WS-4822-CNT-ADDL-DESC-LEN  TO CT-CNT-ADDL-DESC-LEN.             
           MOVE WS-4822-CNT-ADDL-DESC-TEXT TO CT-CNT-ADDL-DESC-TEXT.    
           MOVE LENGTH OF CT-CNT-ADDL-DESC-TEXT TO CT-CNT-ADDL-DESC-LEN.
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTRACT                                       
                 SET INTRST_RATE        = :CT-INTRST-RATE,              
                     CNT_STATUS_CD      = :CT-CNT-STATUS-CD,            
                     AMT_MO_PYMT        = :CT-AMT-MO-PYMT,              
                     AMT_ORIG_ENTERED   = :CT-AMT-ORIG-ENTERED,         
                     LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP(),            
                     STATUS_CHANGE_DT   = IIF(TRY_CONVERT(DATE, 
                                                  :CT-STATUS-CHANGE-DT 
                                                           :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :CT-STATUS-CHANGE-DT 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ), CONVERT(DATE, :CT-STATUS-CHANGE-DT :WS-NULL-IND) ),           
                     CONTRACT_COMMENTS  = :CT-CONTRACT-COMMENTS,        
                     REV_DISTRICT_CD    = :CT-REV-DISTRICT-CD,          
                     LIEN_CD            = :CT-LIEN-CD,                  
                     CNT_ADDL_DESC      = :CT-CNT-ADDL-DESC             
               WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO                
                 AND PYMT_PRIORITY_LVL  = :CT-PYMT-PRIORITY-LVL         
                 AND CNT_ITEM_ID        = :CT-CNT-ITEM-ID               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTRACT                                               
MFA-TR*          SET INTRST_RATE        = :CT-INTRST-RATE,                      
MFA-TR*              CNT_STATUS_CD      = :CT-CNT-STATUS-CD,                    
MFA-TR*              AMT_MO_PYMT        = :CT-AMT-MO-PYMT,                      
MFA-TR*              AMT_ORIG_ENTERED   = :CT-AMT-ORIG-ENTERED,                 
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP,                    
MFA-TR*              STATUS_CHANGE_DT   = :CT-STATUS-CHANGE-DT                  
MFA-TR*                                   :WS-NULL-IND,                         
MFA-TR*              CONTRACT_COMMENTS  = :CT-CONTRACT-COMMENTS,                
MFA-TR*              REV_DISTRICT_CD    = :CT-REV-DISTRICT-CD,                  
MFA-TR*              LIEN_CD            = :CT-LIEN-CD,                          
MFA-TR*              CNT_ADDL_DESC      = :CT-CNT-ADDL-DESC                     
MFA-TR*        WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO                        
MFA-TR*          AND PYMT_PRIORITY_LVL  = :CT-PYMT-PRIORITY-LVL                 
MFA-TR*          AND CNT_ITEM_ID        = :CT-CNT-ITEM-ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8305'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CT-CNT-ITEM-ID            TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8305-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8306-UPDATE-CNT-DETAIL-AMT.                                    *        
      ******************************************************************        
       8306-UPDATE-CNT-DETAIL-AMT.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CNT_DETAIL                                     
                 SET CHARGE_AM   = :EA-CHARGE-AM                        
               WHERE ACCOUNT_NO  = :CT-ACCOUNT-NO                       
                 AND CNT_ITEM_ID = :CT-CNT-ITEM-ID                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8306'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNT_DETAIL'          TO TABLE-1                 
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CT-CNT-ITEM-ID            TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8306-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8310-UPDATE-ACCOUNT.                                           *        
      ******************************************************************        
       8310-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET DATE_LAST_ACTION   = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:AT-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-LAST-ACTION
              ), CONVERT(DATE, :AT-DATE-LAST-ACTION) ),         
                     CODE_P_BILL_DEST   = :AT-CODE-P-BILL-DEST,         
                     CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,       
                     TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,         
                     LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
                 AND LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET DATE_LAST_ACTION   = :AT-DATE-LAST-ACTION,                 
MFA-TR*              CODE_P_BILL_DEST   = :AT-CODE-P-BILL-DEST,                 
MFA-TR*              CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,               
MFA-TR*              TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,                 
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                        
MFA-TR*          AND LAST_UPDATE_TS     = :AT-LAST-UPDATE-TS                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET  CPD4822-DB2-ERR-FOUND     TO TRUE                    
ACT245        MOVE WS-ACTIVE-RETURN-CODE     TO                         
ACT245                                       WS-4822-DB2-ERR-RETURN-CD  
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9910-SQL-ERROR.                                               *         
      *****************************************************************         
       9910-SQL-ERROR.                                                  
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
