      *****************************************************************         
      **  CPD04517 COPYBOOK TO CALL ONLINE BILL CALC FOR NONE CALC   **         
      **                       BPA PANEL                             **         
      **.............................................................**         
      **                                                             **         
      **  I/O: CWS04517 COPYBOOK                                     **         
      **                                                             **         
      **  REQUIRED INPUT PARAMETERS:                                 **         
      **       WS-CPD4517-ACCOUNT-NO                                 **         
      **       WS-CPD4517-BILL-NO                                    **         
      **       WS-CPD4517-CODE-UTIL-TYPE                             **         
      **       WS-CPD4517-IC-NO                                      **         
      **       WS-CPD4517-BILL-TIMESTMP                              **         
      **                                                             **         
      **  OPTIONAL INPUT PARAMETERS:                                 **         
      **       WS-CPD4517-REVENUE-MONTH                              **         
      **                                                             **         
      **  PROCEDURE REFERENCE: CSR04515/CSR04517                     **         
      **                                                             **         
      **  ADDITIONAL INFORMATION:                                    **         
      **    THIS COPYBOOK LOGIC IS INVOKED FROM                      **         
      **    1. NONE CALC RETRIEVE SP CSR04515 TO GET THE BILL DETAILS**         
      **       FOR BILLED ROW WHEN THE DETAILS ARE NOT PRESENT IN    **         
      **       CSS_BILL_MAN* TABLES.                                 **         
      **                                                             **         
      **    2. NONE CALC UPDATE SP CSR04517 TO GET ADDITIONAL BILL   **         
      **       DETAILS TO STORE IN THE CSS_BILL_MAN* TABLES WHEN THE **         
      **       INTIAL BILL DATA IS UPLOADED FROM EXCEL SPREADSHEET.  **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      *   MODIFICATION LOG -                                          *         
      *                                                               *         
      *   DATE     INITIALS        COMMENTS                           *         
      *  ------    --------        -----------------------------------*         
      * 09/07/11   SS97726         INTIALLY WRITTEN.                  *         
A03956* 09/17/12   VIJAY           MICHELIN CHANGES.                  *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      * 6000-CPD4517-MAIN-PROCESS.                                    *         
      * POPULATE REQUIRED PARAMETERS AND CALL ONLINE BILL CALC.       *         
      *****************************************************************         
      *                                                                         
       6000-CPD4517-MAIN-PROCESS.                                       
      *                                                                         
           PERFORM 6005-CPD4517-INIT-107-WS THRU 6005-CPD4517-EXIT.     
                                                                        
           MOVE WS-CPD4517-ACCOUNT-NO       TO AT-ACCOUNT-NO            
                                               BI-ACCOUNT-NO            
                                               BG-ACCOUNT-NO            
                                               BP-ACCOUNT-NO            
                                               CP-ACCOUNT-NO            
                                               CX-ACCOUNT-NO            
                                               MN-ACCOUNT-NO            
                                               UC-ACCOUNT-NO.           
                                                                        
           MOVE WS-CPD4517-CODE-UTIL-TYPE   TO BG-CODE-UTIL-TYPE        
                                               BP-CODE-UTIL-TYPE        
                                               CP-CODE-UTIL-TYPE        
                                               CX-CODE-UTIL-TYPE        
                                               MN-CODE-UTIL-TYPE        
                                               UC-CODE-UTIL-TYPE.       
                                                                        
           MOVE WS-CPD4517-IC-NO            TO BG-IC-NO                 
                                               BP-IC-NO                 
                                               CP-IC-NO                 
                                               CX-IC-NO                 
                                               MN-IC-NO                 
                                               UC-IC-NO.                
                                                                        
           MOVE WS-CPD4517-BILL-NO          TO BG-BILL-NO               
                                               BP-BILL-NO               
                                               CX-BILL-NO               
                                               UC-BILL-NO.              
                                                                        
           MOVE WS-CPD4517-BILL-TIMESTMP    TO BG-BILL-ITEM-TIMESTMP    
                                               BP-BILL-ITEM-TIMESTMP    
                                               CX-BILL-ITEM-TIMESTMP    
                                               UC-BILL-ITEM-TIMESTMP.   
                                                                        
           PERFORM 6050-CPD4517-GET-BILL-HDR                            
                                            THRU 6050-CPD4517-EXIT.     
                                                                        
           PERFORM 6150-CPD4517-SEL-COMPANY-NO                          
                                            THRU 6150-CPD4517-EXIT.     
                                                                        
           PERFORM 6010-CPD4517-BUILD-PASS-AREA                         
                                            THRU 6010-CPD4517-EXIT.     
           IF WS-CPD4517-REVENUE-MONTH > 0                              
              MOVE WS-CPD4517-REVENUE-MONTH  TO WS-BC-REVENUE-MONTH-BG  
           ELSE                                                         
              IF WS-BC-REV-MTH-ORIG-BILL-BG > 0 AND                     
                 WS-BC-REVENUE-MONTH-BG = 0                             
                 MOVE WS-BC-REV-MTH-ORIG-BILL-BG                        
                                             TO WS-BC-REVENUE-MONTH-BG  
              ELSE                                                      
                 IF WS-BC-REVENUE-MONTH-BG  = 0                         
                    PERFORM 6155-CPD4517-GET-BW-REV-MTH                 
                                             THRU 6155-CPD4517-EXIT     
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       MOVE BN-REVENUE-MONTH TO WS-BC-REVENUE-MONTH-BG  
                    ELSE                                                
                       MOVE ZEROS            TO BN-REVENUE-MONTH        
                       PERFORM 6160-CPD4517-GET-MIN-REVMTH              
                                             THRU 6160-CPD4517-EXIT     
                       IF BN-REVENUE-MONTH = 0 OR                       
                          BN-REVENUE-MONTH = AT-REV-MTH-LST-NRML        
A03956                    IF WS-CPD4517-REVENUE-MONTH > 0               
A03956                       MOVE WS-CPD4517-REVENUE-MONTH              
                                             TO WS-BC-REVENUE-MONTH-BG  
A03956                    ELSE                                          
                             PERFORM 6165-CPD4517-GET-CMN-REVMTH        
                                              THRU 6165-CPD4517-EXIT    
                             MOVE WS-CPD4517-CMN-REVMTH-NUM             
                                              TO WS-BC-REVENUE-MONTH-BG 
A03956                    END-IF                                        
                       ELSE                                             
                          MOVE BN-REVENUE-MONTH                         
                                             TO WS-BC-REVENUE-MONTH-BG  
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE 'S'                         TO WS-BC-CALC-MODE.         
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
           PERFORM 6145-CPD4517-SEL-DELINQUENCY                         
                                            THRU 6145-CPD4517-EXIT.     
           MOVE C8-DELINQ-VALUE             TO LS-DATABASE.             
                                                                        
A03956     IF WS-CPD4517-CALL-TYPE = 'B'                                
A03956        MOVE 'B'                      TO WS-BC-CALC-MODE          
A03956        PERFORM 6046-CPD4517-CALL-SCSCA107                        
A03956                                      THRU 6046-CPD4517-EXIT      
A03956     ELSE                                                         
A03956        MOVE 'S'                      TO WS-BC-CALC-MODE          
              PERFORM 6045-CPD4517-CALL-BILL-CALC                       
                                            THRU 6045-CPD4517-EXIT      
A03956     END-IF.                                                      
      *                                                                         
       6000-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6005-CPD4517-INIT-107-WS.                                      *        
      ******************************************************************        
      *                                                                         
       6005-CPD4517-INIT-107-WS.                                        
      *                                                                         
           INITIALIZE LS-PCSCA100-COMM-AREA                             
                      WS-BILLING-CALC-WORK                              
                      WS-BILLING-COMPONENT                              
                      WS-BILLING-ADJUSTMENT                             
                      WS-BILL-CALC-BG                                   
                      WS-BILL-CALC-CX                                   
                      WS-BILL-CALC-UC                                   
                      WS-BILL-CALC-FH                                   
                      WS-BILL-CONTRACT-BK                               
                      WS-FIXED-FCTR-TABLE-FF                            
A03956                WS-BC-BILL-DET-BT                                 
A03956                WS-BC-ACCT-RTPK-AGR-DF                            
A03956                WS-BC-FIXED-FCTR-FF                               
                      WS-BILL-CNTR-HIST-BX                              
                      WS-PEAK-HIST-PH                                   
                      WS-INTERRUPT-ACCT-IP                              
                      WS-STANDBY-GEN-SE                                 
                      WS-INTERRUPT-IR                                   
                      WS-MTRD-ENVRNMT-TABLE-MN                          
                      WS-HOLD-CX-DATA                                   
                      WS-HOLD-BC-DATA                                   
                      WS-HOLD-BA-DATA                                   
                      WS-BILLING-WQ-ITEMS-WF                            
                      WS-REFUND-RN                                      
                      WS-BC-BILL-ADJUSTMNT                              
                      WS-BC-VOL-DAILY-ND                                
                      WS-BILL-CALC-DETAIL-X                             
                      WS-BILL-BSLN-CNTR-LN                              
                      WS-BILL-BSLN-HIST-LO                              
                      WS-UTL-BILL-REL-TABLE-UR                          
                      WS-INTERRUPT-NZ                                   
                      WS-CNSMPTN-HOURLY.                                
                                                                        
           MOVE ZEROES                    TO WS-CPD4517-RETURN-CODE.    
      *                                                                         
       6005-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6010-CPD4517-BUILD-PASS-AREA.                                  *        
      ******************************************************************        
      *                                                                         
       6010-CPD4517-BUILD-PASS-AREA.                                    
      *                                                                         
           MOVE SPACE                     TO WS-BC-PRORATE-OVERRIDE-IND.
                                                                        
           PERFORM 6060-CPD4517-SEL-BILL-DET      THRU 6060-CPD4517-EXIT
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 6015-CPD4517-LOAD-BILLING-DET                     
                                                  THRU 6015-CPD4517-EXIT
           END-IF                                                       
                                                                        
           IF BG-DATE-ORIG-BILL     = SPACES                            
              AND BI-DATE-BILLED    = SPACES                            
              AND BI-CODE-BILL-STATUS NOT = 'C'                         
A03956        IF WS-CPD4517-COMMON-DATE > SPACES                        
A03956           MOVE WS-CPD4517-COMMON-DATE TO BI-DATE-BILLED          
A03956        ELSE                                                      
                 PERFORM 6055-CPD4517-GET-COMMON-DT  THRU               
                         6055-CPD4517-EXIT                              
                 MOVE WS-CPD4517-COMMON-DATE TO BI-DATE-BILLED          
A03956        END-IF                                                    
           ELSE                                                         
              IF BG-DATE-ORIG-BILL > SPACES                             
                 AND BG-CODE-BILL-ITM-TYPE = 'C'                        
                 MOVE BG-DATE-ORIG-BILL   TO BI-DATE-BILLED             
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE BI-DATE-BILLED            TO WS-BC-CALC-DATE.           
           MOVE BI-CODE-BILL-STATUS       TO WS-BC-CODE-BILL-STATUS-BI. 
                                                                        
           SET WS-BC-ADJUSTMNT-INDEX      TO 1.                         
                                                                        
           PERFORM 6095-CPD4517-OPEN-BP           THRU 6095-CPD4517-EXIT
           PERFORM 6100-CPD4517-FETCH-BP          THRU 6100-CPD4517-EXIT
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 6105-CPD4517-CLOSE-BP       THRU 6105-CPD4517-EXIT
           ELSE                                                         
              PERFORM 6040-CPD4517-LOAD-BILL-ADJ  THRU 6040-CPD4517-EXIT
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
                                                                        
              PERFORM 6105-CPD4517-CLOSE-BP       THRU 6105-CPD4517-EXIT
           END-IF.                                                      
                                                                        
           MOVE 'N'                       TO WS-CPD4517-CUST-PLAN-SW.   
           PERFORM 6125-CPD4517-OPEN-CP           THRU 6125-CPD4517-EXIT
           PERFORM 6130-CPD4517-FETCH-CP          THRU 6130-CPD4517-EXIT
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              SET CPD4517-HAS-CUST-PLAN           TO TRUE               
           END-IF.                                                      
           PERFORM 6135-CPD4517-CLOSE-CP          THRU 6135-CPD4517-EXIT
                                                                        
           IF NOT CPD4517-HAS-CUST-PLAN                                 
              SET WS-MTRD-INDX            TO 1                          
              PERFORM 6110-CPD4517-OPEN-MN        THRU 6110-CPD4517-EXIT
              PERFORM 6115-CPD4517-FETCH-MN       THRU 6115-CPD4517-EXIT
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 6035-CPD4517-LOAD-MTRD-ENV                     
                                                  THRU 6035-CPD4517-EXIT
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              END-IF                                                    
                                                                        
              PERFORM 6120-CPD4517-CLOSE-MN       THRU 6120-CPD4517-EXIT
                                                                        
              SET CX-INDX                 TO 1                          
              PERFORM 6065-CPD4517-OPEN-CX        THRU 6065-CPD4517-EXIT
              PERFORM 6070-CPD4517-FETCH-CX       THRU 6070-CPD4517-EXIT
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 6025-CPD4517-LOAD-MTRD-CX                      
                                                  THRU 6025-CPD4517-EXIT
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              END-IF                                                    
                                                                        
              PERFORM 6075-CPD4517-CLOSE-CX       THRU 6075-CPD4517-EXIT
           ELSE                                                         
              SET UC-INDX                 TO 1                          
              PERFORM 6080-CPD4517-OPEN-UC        THRU 6080-CPD4517-EXIT
              PERFORM 6085-CPD4517-FETCH-UC       THRU 6085-CPD4517-EXIT
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 6030-CPD4517-LOAD-UNMTRD-UC                    
                                                  THRU 6030-CPD4517-EXIT
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              END-IF                                                    
              PERFORM 6090-CPD4517-CLOSE-UC       THRU 6090-CPD4517-EXIT
           END-IF.                                                      
      *                                                                         
       6010-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6015-CPD4517-LOAD-BILLING-DET.                                *         
      *****************************************************************         
      *                                                                         
       6015-CPD4517-LOAD-BILLING-DET.                                   
      *                                                                         
           MOVE BG-ACCOUNT-NO          TO WS-BC-ACCOUNT-NO-BG           
                                          WS-ACCOUNT-NO-AT.             
           MOVE BG-BILL-NO             TO WS-BC-BILL-NO-BG.             
           MOVE BG-CODE-UTIL-TYPE      TO WS-BC-CODE-UTIL-TYPE-BG.      
           MOVE BG-IC-NO               TO WS-BC-IC-NO-BG.               
           MOVE BG-BILL-ITEM-TIMESTMP  TO WS-BC-BILL-ITEM-TIMESTMP-BG.  
           MOVE BG-PREMISE-NO          TO WS-BC-PREMISE-NO-BG.          
           MOVE BG-DATE-ORIG-BILL      TO WS-BC-DATE-ORIG-BILL-BG.      
           MOVE BG-AMT-BILL-ITEM       TO WS-BC-AMT-BILL-ITEM-BG.       
           MOVE BG-CODE-BILL-CALC      TO WS-BC-CODE-BILL-CALC-BG.      
           MOVE BG-CODE-BILL-ITM-TYPE  TO WS-BC-CODE-BILL-ITM-TYPE-BG.  
           MOVE BG-CODE-BILL-ITM-IND   TO WS-BC-CODE-BILL-ITM-IND-BG.   
           MOVE BG-CODE-DR-CR-CNSMPTN  TO WS-BC-CODE-DR-CR-CNSMPTN-BG.  
           MOVE BG-AMT-STATE-TAX       TO WS-BC-AMT-STATE-TAX-BG.       
           MOVE BG-AMT-CITY-TAX        TO WS-BC-AMT-CITY-TAX-BG.        
           MOVE BG-AMT-OTHER-TAX       TO WS-BC-AMT-OTHER-TAX-BG.       
           MOVE BG-CODE-REVENUE-CLASS  TO WS-BC-CODE-REVENUE-CLASS-BG.  
           MOVE BG-CODE-SIC-NO         TO WS-BC-CODE-SIC-NO-BG.         
           MOVE BG-RATE-PLAN-NO        TO WS-BC-RATE-PLAN-NO-BG.        
                                                                        
           PERFORM 6020-CPD4517-GET-BASE-RATE                           
                                       THRU 6020-CPD4517-EXIT.          
                                                                        
           MOVE UT-CODE-MTR-READ-FREQ  TO WS-BC-CODE-MTR-READ-FREQ-BG.  
                                                                        
           IF BG-RATE-PLAN-NO = '160'                                   
              MOVE UT-RATE-PLAN-NO     TO WS-BC-RATE-PLAN-NO-BG         
           END-IF.                                                      
                                                                        
           MOVE BG-CODE-CURTAIL-PRTY   TO WS-BC-CODE-CURTAIL-PRTY-BG.   
           MOVE BG-CODE-STAT-TAX-XMT   TO WS-BC-CODE-STAT-TAX-XMT-BG.   
           MOVE BG-CODE-CITY-TAX-XMT   TO WS-BC-CODE-CITY-TAX-XMT-BG.   
           MOVE BG-CODE-OTHR-TAX-XMT   TO WS-BC-CODE-OTHR-TAX-XMT-BG.   
           MOVE BG-REV-RPT-CD          TO WS-BC-REV-RPT-CD-BG.          
           MOVE BG-STANDBY-COMPLIED    TO WS-BC-STANDBY-COMPLIED-BG.    
           MOVE BG-PRORATE-CD          TO WS-BC-PRORATE-CD-BG.          
           MOVE BG-NEW-RATE-PCT        TO WS-BC-NEW-RATE-PCT-BG.        
           MOVE BG-CODE-SUB-TOTAL      TO WS-BC-CODE-SUB-TOTAL-BG.      
           MOVE BG-TAX-REFUND-CD       TO WS-BC-TAX-REFUND-CD-BG.       
           MOVE BG-COMPANY-NO          TO WS-BC-COMPANY-NO-BG.          
           MOVE BG-DATE-LFTM-HI-DMD    TO WS-BC-DATE-LFTM-HI-DMD-BG.    
           MOVE BG-LFTM-HI-PEAK-DMD    TO WS-BC-LFTM-HI-PEAK-DMD-BG.    
           MOVE BG-REBILL-IND          TO WS-BC-REBILL-IND-BG.          
           MOVE BG-REVENUE-MONTH       TO WS-BC-REVENUE-MONTH-BG.       
           MOVE BG-GAS-BASE-USE        TO WS-BC-GAS-BASE-USE-BG.        
           MOVE BG-ADJ-REASON-CD       TO WS-BC-ADJ-REASON-CD-BG.       
           MOVE BG-WNA-FACTOR          TO WS-BC-WNA-FACTOR-BG.          
           MOVE BG-BTU-FACTOR          TO WS-BC-BTU-FACTOR-BG.          
           MOVE BG-REV-MTH-ORIG-BILL   TO WS-BC-REV-MTH-ORIG-BILL-BG.   
           MOVE BG-BILL-CALC-CYCLE     TO WS-BC-BILL-CALC-CYCLE-BG.     
           MOVE BG-RT-PKG-OPT-SEQ-NO   TO WS-BC-RT-PKG-OPT-SEQ-NO-BG.   
      *                                                                         
       6015-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6020-CPD4517-GET-BASE-RATE.                                   *         
      *****************************************************************         
      *                                                                         
       6020-CPD4517-GET-BASE-RATE.                                      
      *                                                                         
           MOVE BG-ACCOUNT-NO          TO UT-ACCOUNT-NO.                
           MOVE BG-CODE-UTIL-TYPE      TO UT-CODE-UTIL-TYPE.            
           MOVE BG-IC-NO               TO UT-IC-NO.                     
                                                                        
           PERFORM 6140-CPD4517-SEL-BASE-RATE                           
                                       THRU 6140-CPD4517-EXIT.          
      *                                                                         
       6020-CPD4517-EXIT.                                               
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 6025-CPD4517-LOAD-MTRD-CX.                                    *         
      *****************************************************************         
      *                                                                         
       6025-CPD4517-LOAD-MTRD-CX.                                       
      *                                                                         
           MOVE CX-ACCOUNT-NO         TO WS-BC-ACCOUNT-NO-CX(CX-INDX).  
           MOVE CX-BILL-NO            TO WS-BC-BILL-NO-CX(CX-INDX).     
           MOVE CX-CODE-UTIL-TYPE     TO                                
                                  WS-BC-CODE-UTIL-TYPE-CX(CX-INDX).     
           MOVE CX-IC-NO              TO WS-BC-IC-NO-CX(CX-INDX).       
           MOVE CX-BILL-ITEM-TIMESTMP TO                                
                                  WS-BC-BILL-ITEM-TIMESTMP-CX(CX-INDX). 
           MOVE CX-MTR-REF-NO         TO WS-BC-MTR-REF-NO-CX(CX-INDX).  
           MOVE CX-CODE-USAGE-TYPE    TO                                
                                  WS-BC-CODE-USAGE-TYPE-CX(CX-INDX).    
           MOVE CX-CODE-USAGE-ID     TO                                 
                                  WS-BC-CODE-USAGE-ID-CX(CX-INDX).      
           MOVE CX-CODE-USAGE-SOURCE  TO                                
                                  WS-BC-CODE-USAGE-SOURCE-CX(CX-INDX).  
           MOVE CX-CODE-TIME-PERIOD   TO                                
                                  WS-BC-CODE-TIME-PERIOD-CX(CX-INDX).   
           MOVE CX-ITEM-SEQ-NO        TO WS-BC-ITEM-SEQ-NO-CX(CX-INDX). 
           MOVE CX-METER-NO           TO WS-BC-METER-NO-CX(CX-INDX).    
           MOVE CX-REG-ID-NO          TO WS-BC-REG-ID-NO-CX(CX-INDX).   
           MOVE CX-DATE-READ          TO WS-BC-DATE-READ-CX(CX-INDX).   
           MOVE CX-CODE-METER-READ    TO                                
                                  WS-BC-CODE-METER-READ-CX(CX-INDX).    
           MOVE CX-CODE-METER-NO-READ TO                                
                                  WS-BC-CODE-METER-NO-READ-CX(CX-INDX). 
           MOVE CX-METER-READING      TO                                
                                  WS-BC-METER-READING-CX(CX-INDX).      
           MOVE CX-DEMAND-READING     TO                                
                                  WS-BC-DEMAND-READING-CX(CX-INDX).     
           MOVE CX-EMPLOYEE-NO        TO WS-BC-EMPLOYEE-NO-CX(CX-INDX). 
           MOVE CX-NO-UNITS           TO WS-BC-NO-UNITS-CX (CX-INDX).   
           MOVE CX-NO-DEMAND-UNITS    TO                                
                                  WS-BC-NO-DEMAND-UNITS-CX (CX-INDX).   
           MOVE CX-NO-DAYS            TO WS-BC-NO-DAYS-CX (CX-INDX).    
           MOVE CX-CODE-SOURCE-ID     TO                                
                                  WS-BC-CODE-SOURCE-ID-CX (CX-INDX).    
           MOVE CX-CODE-DEBIT-CREDIT  TO                                
                                  WS-BC-CODE-DEBIT-CREDIT-CX (CX-INDX). 
           MOVE CX-CODE-ITEM-STATUS   TO                                
                                  WS-BC-CODE-ITEM-STATUS-CX (CX-INDX).  
           MOVE CX-CODE-DISCOUNT      TO                                
                                  WS-BC-CODE-DISCOUNT-CX (CX-INDX).     
           MOVE CX-CONSTANT           TO WS-BC-CONSTANT-CX (CX-INDX).   
           MOVE CX-NO-DIALS           TO WS-BC-NO-DIALS-CX (CX-INDX).   
           MOVE CX-COMPANY-NO         TO WS-BC-COMPANY-NO-CX (CX-INDX). 
           MOVE CX-EXCEPT-OVERRIDE-CD TO                                
                                  WS-BC-EXCEPT-OVERRIDE-CD-CX (CX-INDX).
           MOVE CX-REQUESTED-USAGE    TO                                
                                   WS-BC-REQUESTED-USAGE-CX (CX-INDX).  
           MOVE CX-DIGTL-INTRL-MTR-NO TO                                
                                  WS-BC-DIGTL-INTRL-MTR-NO-CX (CX-INDX).
           MOVE CX-DIGTL-MTR-TYPE     TO                                
                                  WS-BC-DIGTL-MTR-TYPE-CX (CX-INDX).    
           MOVE CX-CODE-TOU-SEASN     TO                                
                                  WS-BC-CODE-TOU-SEASN-CX (CX-INDX).    
           MOVE CX-EXCL-DMD-RCHT-IND  TO                                
                                  WS-BC-EXCL-DMD-RCHT-IND-CX (CX-INDX). 
           MOVE SPACE                 TO                                
                                  WS-BC-UPDATE-ACTION-IND-CX (CX-INDX). 
           SET CX-INDX                UP BY 1.                          
                                                                        
           PERFORM 6070-CPD4517-FETCH-CX                                
                                      THRU  6070-CPD4517-EXIT.          
      *                                                                         
       6025-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6030-CPD4517-LOAD-UNMTRD-UC.                                  *         
      *****************************************************************         
      *                                                                         
       6030-CPD4517-LOAD-UNMTRD-UC.                                     
                                                                        
           MOVE UC-ACCOUNT-NO         TO WS-BC-ACCOUNT-NO-UC (UC-INDX). 
           MOVE UC-BILL-NO            TO WS-BC-BILL-NO-UC (UC-INDX).    
           MOVE UC-CODE-UTIL-TYPE     TO                                
                                  WS-BC-CODE-UTIL-TYPE-UC (UC-INDX).    
           MOVE UC-IC-NO              TO WS-BC-IC-NO-UC (UC-INDX).      
           MOVE UC-BILL-ITEM-TIMESTMP TO                                
                                  WS-BC-BILL-ITEM-TIMESTMP-UC (UC-INDX).
           MOVE UC-RATE-ITEM-CODE     TO                                
                                  WS-BC-RATE-ITEM-CODE-UC (UC-INDX).    
           MOVE UC-ITEM-SEQ-NO        TO WS-BC-ITEM-SEQ-NO-UC (UC-INDX).
           MOVE UC-NO-UNITS           TO WS-BC-NO-UNITS-UC (UC-INDX).   
           MOVE UC-NO-DAYS            TO WS-BC-NO-DAYS-UC (UC-INDX).    
           MOVE UC-CODE-DEBIT-CREDIT  TO                                
                                  WS-BC-CODE-DEBIT-CREDIT-UC (UC-INDX). 
           MOVE UC-USAGE-FIXED        TO WS-BC-USAGE-FIXED-UC (UC-INDX).
           MOVE UC-DATE-USAGE-ENDS    TO                                
                                  WS-BC-DATE-USAGE-ENDS-UC (UC-INDX).   
           MOVE UC-CODE-SERVICE-TYPE  TO                                
                                  WS-BC-CODE-SERVICE-TYPE-UC (UC-INDX). 
           MOVE UC-CODE-ITEM-STATUS   TO                                
                                  WS-BC-CODE-ITEM-STATUS-UC (UC-INDX).  
           MOVE UC-CODE-SOURCE-ID     TO                                
                                  WS-BC-CODE-SOURCE-ID-UC (UC-INDX).    
           MOVE UC-POLE-NO            TO WS-BC-POLE-NO-UC (UC-INDX).    
                                                                        
           SET UC-INDX UP BY 1.                                         
                                                                        
           PERFORM 6085-CPD4517-FETCH-UC                                
                                      THRU 6085-CPD4517-EXIT.           
      *                                                                         
       6030-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6035-CPD4517-LOAD-MTRD-ENV.                                   *         
      *****************************************************************         
      *                                                                         
       6035-CPD4517-LOAD-MTRD-ENV.                                      
      *                                                                         
           MOVE  MN-ACCOUNT-NO        TO                                
                 WS-ACCOUNT-NO-MN (WS-MTRD-INDX).                       
           MOVE  MN-CODE-UTIL-TYPE    TO                                
                 WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX).                   
           MOVE  MN-IC-NO             TO                                
                 WS-IC-NO-MN (WS-MTRD-INDX).                            
           MOVE  MN-MTR-REF-NO        TO                                
                 WS-MTR-REF-NO-MN (WS-MTRD-INDX).                       
           MOVE  MN-CODE-TIME-PERIOD  TO                                
                 WS-CODE-TIME-PERIOD-MN (WS-MTRD-INDX).                 
           MOVE  MN-METER-NO          TO                                
                 WS-METER-NO-MN (WS-MTRD-INDX).                         
           MOVE  MN-CODE-DISCOUNT     TO                                
                 WS-CODE-DISCOUNT-MN (WS-MTRD-INDX).                    
           MOVE  MN-CODE-METER-LOC    TO                                
                 WS-CODE-METER-LOC-MN (WS-MTRD-INDX).                   
           MOVE  MN-CODE-METER-STATUS TO                                
                 WS-CODE-METER-STATUS-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-STATUS-REAS  TO                                
                 WS-CODE-STATUS-REAS-MN  (WS-MTRD-INDX).                
           MOVE  MN-CODE-ALRT-CHNG-IND TO                               
                 WS-CODE-ALRT-CHNG-IND-MN (WS-MTRD-INDX).               
           MOVE  MN-DIST-NODE-POINT   TO                                
                 WS-DIST-NODE-POINT-MN (WS-MTRD-INDX).                  
           MOVE  MN-CODE-DIVERSION    TO                                
                 WS-CODE-DIVERSION-MN (WS-MTRD-INDX).                   
           MOVE  MN-DATE-MTR-INSTALL  TO                                
                 WS-DATE-MTR-INSTALL-MN (WS-MTRD-INDX).                 
           MOVE  MN-CODE-SPCL-SEAL    TO                                
                 WS-CODE-SPCL-SEAL-MN (WS-MTRD-INDX).                   
           MOVE  MN-EST-USAGE         TO                                
                 WS-EST-USAGE-MN (WS-MTRD-INDX).                        
           MOVE  MN-SPCL-MTR-CONDITION TO                               
                 WS-SPCL-MTR-CONDITION-MN (WS-MTRD-INDX).               
           MOVE  MN-CODE-DATA-PRESENT TO                                
                 WS-CODE-DATA-PRESENT-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-USAGE-TYPE   TO                                
                 WS-CODE-USAGE-TYPE-MN (WS-MTRD-INDX).                  
           MOVE  MN-CODE-USAGE-ID     TO                                
                 WS-CODE-USAGE-ID-MN (WS-MTRD-INDX).                    
           MOVE  MN-CODE-USAGE-SOURCE TO                                
                 WS-CODE-USAGE-SOURCE-MN (WS-MTRD-INDX).                
           MOVE  MN-REG-ID-NO         TO                                
                 WS-REG-ID-NO-MN (WS-MTRD-INDX).                        
           MOVE  MN-REGISTER-RD-SEQ   TO                                
                 WS-REGISTER-RD-SEQ-MN (WS-MTRD-INDX).                  
           MOVE  MN-CODE-CRNT-REG-READ TO                               
                 WS-CODE-CRNT-REG-READ-MN (WS-MTRD-INDX).               
           MOVE  MN-CODE-NO-RD-REASON TO                                
                 WS-CODE-NO-RD-REASON-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-LAST-REG-READ TO                               
                 WS-CODE-LAST-REG-READ-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-REG-READ-TIME TO                               
                 WS-LAST-REG-READ-TIME-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-REG-READ-DATE TO                               
                 WS-LAST-REG-READ-DATE-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-READ-VALUE    TO                               
                 WS-LAST-READ-VALUE-MN (WS-MTRD-INDX).                  
           MOVE  MN-NO-CONSEC-CRD-READ TO                               
                 WS-NO-CONSEC-CRD-READ-MN (WS-MTRD-INDX).               
           MOVE  MN-NO-CONSEC-ESTIMATE TO                               
                 WS-NO-CONSEC-ESTIMATE-MN (WS-MTRD-INDX).               
           MOVE  MN-POINT-ID           TO                               
                 WS-POINT-ID-MN (WS-MTRD-INDX).                         
           MOVE  MN-LOCK-TYPE-ID       TO                               
                 WS-LOCK-TYPE-ID-MN (WS-MTRD-INDX).                     
           MOVE  MN-SEAL-CODE-ID       TO                               
                 WS-SEAL-CODE-ID-MN (WS-MTRD-INDX).                     
           MOVE  MN-HEXAGRAM-LOCATION  TO                               
                 WS-HEXAGRAM-LOCATION-MN (WS-MTRD-INDX).                
           MOVE  MN-INSULATED-IND      TO                               
                 WS-INSULATED-IND-MN (WS-MTRD-INDX).                    
           MOVE  MN-METER-SUPPLYING    TO                               
                 WS-METER-SUPPLYING-MN (WS-MTRD-INDX).                  
           MOVE  MN-LAST-VALID-READ-TM TO                               
                 WS-LAST-VALID-READ-TM-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-VALID-READ-DT TO                               
                 WS-LAST-VALID-READ-DT-MN (WS-MTRD-INDX).               
           MOVE  MN-READ-CARD-PRINT-DT TO                               
                 WS-READ-CARD-PRINT-DT-MN (WS-MTRD-INDX).               
           MOVE  MN-EXCEPT-OVERRIDE-CD TO                               
                 WS-EXCEPT-OVERRIDE-CD-MN (WS-MTRD-INDX).               
           MOVE  MN-CODE-MTR-RD-INST1  TO                               
                 WS-CODE-MTR-RD-INST1-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-MTR-RD-INST2  TO                               
                 WS-CODE-MTR-RD-INST2-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-MTR-RD-INST3  TO                               
                 WS-CODE-MTR-RD-INST3-MN (WS-MTRD-INDX).                
           MOVE  MN-DIGTL-MTR-TYPE     TO                               
                 WS-DIGTL-MTR-TYPE-MN (WS-MTRD-INDX).                   
           MOVE  MN-LAST-VAL-RD-VALUE  TO                               
                 WS-LAST-VAL-RD-VALUE-MN (WS-MTRD-INDX).                
           MOVE  MN-CODE-LAST-VALID-RD TO                               
                 WS-CODE-LAST-VALID-RD-MN (WS-MTRD-INDX).               
           MOVE  MN-LAST-UPDATE-TS     TO                               
                 WS-LAST-UPDATE-TS-MN (WS-MTRD-INDX).                   
           MOVE  MN-REMOTE-READ-IND    TO                               
                 WS-REMOTE-READ-IND-MN (WS-MTRD-INDX).                  
           MOVE  MN-MTR-READ-SOURCE-CD TO                               
                 WS-MTR-READ-SOURCE-CD-MN (WS-MTRD-INDX).               
           MOVE  MN-UTILITY-SOURCE-CD  TO                               
                 WS-UTILITY-SOURCE-CD-MN (WS-MTRD-INDX)                 
           MOVE  MN-DELIVERY-LEVEL-CD  TO                               
                 WS-DELIVERY-LEVEL-CD-MN (WS-MTRD-INDX)                 
           MOVE  MN-MTR-STATUS-CHNG-DT TO                               
                 WS-MTR-STATUS-CHNG-DT-MN (WS-MTRD-INDX)                
                                                                        
           SET WS-MTRD-INDX UP BY 1.                                    
                                                                        
           PERFORM 6115-CPD4517-FETCH-MN                                
                                       THRU  6115-CPD4517-EXIT.         
      *                                                                         
       6035-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6040-CPD4517-LOAD-BILL-ADJ.                                    *        
      ******************************************************************        
      *                                                                         
       6040-CPD4517-LOAD-BILL-ADJ.                                      
      *                                                                         
           MOVE BP-ACCOUNT-NO          TO                               
                WS-BC-ACCOUNT-NO-BP(WS-BC-ADJUSTMNT-INDEX)              
           MOVE BP-BILL-NO             TO                               
                WS-BC-BILL-NO-BP(WS-BC-ADJUSTMNT-INDEX)                 
           MOVE BP-CODE-UTIL-TYPE      TO                               
                WS-BC-CODE-UTIL-TYPE-BP(WS-BC-ADJUSTMNT-INDEX)          
           MOVE BP-IC-NO               TO                               
                WS-BC-IC-NO-BP(WS-BC-ADJUSTMNT-INDEX)                   
           MOVE BP-BILL-ITEM-TIMESTMP  TO                               
                WS-BC-BILL-ITEM-TIMESTMP-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE BP-ADJ-TYPE-CD         TO                               
                WS-BC-ADJ-TYPE-CD-BP(WS-BC-ADJUSTMNT-INDEX)             
           MOVE BP-REVENUE-MONTH       TO                               
                WS-BC-REVENUE-MONTH-BP(WS-BC-ADJUSTMNT-INDEX)           
           MOVE BP-ADJ-REASON-DESC-LEN TO                               
                WS-BC-ADJ-REASON-DESC-LEN-BP(WS-BC-ADJUSTMNT-INDEX)     
           MOVE BP-ADJ-REASON-DESC-TEXT TO                              
                WS-BC-ADJ-REASON-DESC-TEXT-BP(WS-BC-ADJUSTMNT-INDEX)    
           MOVE BP-OVRRIDE-RT-REV-MTH  TO                               
                WS-BC-OVRRIDE-RT-REV-MTH-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE BP-OVRRIDE-RT-BILL-DT  TO                               
                WS-BC-OVRRIDE-RT-BILL-DT-BP(WS-BC-ADJUSTMNT-INDEX)      
           MOVE BP-OVRRIDE-RT-BILL-CY  TO                               
                WS-BC-OVRRIDE-RT-BILL-CY-BP(WS-BC-ADJUSTMNT-INDEX)      
                                                                        
           SET WS-BC-ADJUSTMNT-INDEX UP BY +1.                          
                                                                        
           PERFORM 6100-CPD4517-FETCH-BP                                
                                       THRU 6100-CPD4517-EXIT.          
      *                                                                         
       6040-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6045-CPD4517-CALL-BILL-CALC.                                  *         
      * CALL BILL CALCULATION ROUTINE.                                *         
      *****************************************************************         
      *                                                                         
       6045-CPD4517-CALL-BILL-CALC.                                     
      *                                                                         
           CALL MCSCB107 USING   LS-PCSCA100-COMM-AREA                  
                                ,WS-BILLING-CALC-WORK                   
                                ,WS-BILLING-COMPONENT                   
                                ,WS-BILLING-ADJUSTMENT                  
                                ,WS-BILL-CALC-BG                        
                                ,WS-BILL-CALC-CX                        
                                ,WS-BILL-CALC-UC                        
                                ,WS-BILL-CALC-FH                        
                                ,WS-BILL-CONTRACT-BK                    
                                ,WS-FIXED-FCTR-TABLE-FF                 
                                ,WS-BILL-CNTR-HIST-BX                   
                                ,WS-PEAK-HIST-PH                        
                                ,WS-INTERRUPT-ACCT-IP                   
                                ,WS-MTRD-ENVRNMT-TABLE-MN               
                                ,WS-STANDBY-GEN-SE                      
                                ,WS-INTERRUPT-IR                        
                                ,WS-HOLD-CX-DATA                        
                                ,WS-HOLD-BC-DATA                        
                                ,WS-HOLD-BA-DATA                        
                                ,WS-BILLING-WQ-ITEMS-WF                 
                                ,WS-REFUND-RN                           
                                ,WS-ACCOUNT-AT                          
                                ,WS-BC-BILL-ADJUSTMNT                   
                                ,WS-BC-ACCT-RTPK-AGR-DF                 
                                ,WS-BC-FIXED-FCTR-FF                    
                                ,WS-BC-BILL-DET-BT                      
                                ,WS-CWS22B-MAX-TBL-LIMITS               
                                ,WS-BILL-CALC-DETAIL-X                  
                                ,WS-BC-VOL-DAILY-ND                     
                                ,WS-BILL-BSLN-CNTR-LN                   
                                ,WS-BILL-BSLN-HIST-LO                   
                                ,WS-UTL-BILL-REL-TABLE-UR               
                                ,WS-INTERRUPT-NZ                        
                                ,WS-CNSMPTN-HOURLY.                     
                                                                        
           MOVE ZERO                          TO WS-CPD4517-REJ-WQ-CNT. 
           PERFORM VARYING WS-BILL-WQ-INDX FROM 1 BY 1                  
SCA006       UNTIL WS-CPD4517-REJ-WQ-CNT > 0 OR 
                   WS-BILL-WQ-INDX       > 50 OR 
                   WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX) = 0                      
             INSPECT  WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX)             
             TALLYING WS-CPD4517-REJ-WQ-CNT FOR ALL 'EXCEPTION TYPE = R'
           END-PERFORM.                                                 
                                                                        
           IF RETURN-CODE NOT EQUAL ZERO                                
              MOVE RETURN-CODE                TO WS-CPD4517-RETURN-CODE 
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
                                                                        
           IF WS-CPD4517-REJ-WQ-CNT > 0                                 
              MOVE 9999                       TO WS-CPD4517-RETURN-CODE 
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
                                                                        
           IF WS-CALC-ERROR NOT EQUAL SPACES                            
              MOVE 12                         TO WS-CPD4517-RETURN-CODE 
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6045-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
A03956*****************************************************************         
A03956* 6046-CPD4517-CALL-SCSCA107.                                   *         
A03956* CALL BILL CALCULATION ROUTINE.                                *         
A03956*****************************************************************         
A03956*                                                                         
A03956 6046-CPD4517-CALL-SCSCA107.                                      
A03956*                                                                         
A03956     CALL SCSCA107 USING   LS-PCSCA100-COMM-AREA                  
A03956                          ,WS-BILLING-CALC-WORK                   
A03956                          ,WS-BILLING-COMPONENT                   
A03956                          ,WS-BILLING-ADJUSTMENT                  
A03956                          ,WS-BILL-CALC-BG                        
A03956                          ,WS-BILL-CALC-CX                        
A03956                          ,WS-BILL-CALC-UC                        
A03956                          ,WS-BILL-CALC-FH                        
A03956                          ,WS-BILL-CONTRACT-BK                    
A03956                          ,WS-FIXED-FCTR-TABLE-FF                 
A03956                          ,WS-BILL-CNTR-HIST-BX                   
A03956                          ,WS-PEAK-HIST-PH                        
A03956                          ,WS-INTERRUPT-ACCT-IP                   
A03956                          ,WS-MTRD-ENVRNMT-TABLE-MN               
A03956                          ,WS-STANDBY-GEN-SE                      
A03956                          ,WS-INTERRUPT-IR                        
A03956                          ,WS-HOLD-CX-DATA                        
A03956                          ,WS-HOLD-BC-DATA                        
A03956                          ,WS-HOLD-BA-DATA                        
A03956                          ,WS-BILLING-WQ-ITEMS-WF                 
A03956                          ,WS-REFUND-RN                           
A03956                          ,WS-ACCOUNT-AT                          
A03956                          ,WS-BC-BILL-ADJUSTMNT                   
A03956                          ,WS-BC-ACCT-RTPK-AGR-DF                 
A03956                          ,WS-BC-FIXED-FCTR-FF                    
A03956                          ,WS-BC-BILL-DET-BT                      
A03956                          ,WS-CWS22B-MAX-TBL-LIMITS               
A03956                          ,WS-BILL-CALC-DETAIL-X                  
A03956                          ,WS-BC-VOL-DAILY-ND                     
A03956                          ,WS-BILL-BSLN-CNTR-LN                   
A03956                          ,WS-BILL-BSLN-HIST-LO                   
A03956                          ,WS-UTL-BILL-REL-TABLE-UR               
A03956                          ,WS-INTERRUPT-NZ                        
A03956                          ,WS-CNSMPTN-HOURLY.                     
A03956                                                                  
A03956     MOVE ZERO                          TO WS-CPD4517-REJ-WQ-CNT. 
A03956     PERFORM VARYING WS-BILL-WQ-INDX FROM 1 BY 1                  
SCA006       UNTIL WS-CPD4517-REJ-WQ-CNT > 0 OR 
                   WS-BILL-WQ-INDX       > 50 OR 
                   WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX) = 0                      
A03956       INSPECT  WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX)             
A03956       TALLYING WS-CPD4517-REJ-WQ-CNT FOR ALL 'EXCEPTION TYPE = R'
A03956     END-PERFORM.                                                 
A03956                                                                  
A03956     IF RETURN-CODE NOT EQUAL ZERO                                
A03956        MOVE RETURN-CODE                TO WS-CPD4517-RETURN-CODE 
A03956        PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
A03956     END-IF.                                                      
A03956                                                                  
A03956     IF WS-CPD4517-REJ-WQ-CNT > 0                                 
A03956        MOVE 9999                       TO WS-CPD4517-RETURN-CODE 
A03956        PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
A03956     END-IF.                                                      
A03956                                                                  
A03956     IF WS-CALC-ERROR NOT EQUAL SPACES                            
A03956        MOVE 12                         TO WS-CPD4517-RETURN-CODE 
A03956        PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
A03956     END-IF.                                                      
A03956                                                                  
A03956 6046-CPD4517-EXIT.                                               
A03956     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6050-CPD4517-GET-BILL-HDR.                                     *        
      ******************************************************************        
      *                                                                         
       6050-CPD4517-GET-BILL-HDR.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT  BI.DATE_BILLED                                   
                      ,BI.CODE_BILL_STATUS                              
                 INTO  :BI-DATE-BILLED :WS-CPD4517-NULL-IND-15           
                      ,:BI-CODE-BILL-STATUS                             
                 FROM  CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                 
                WHERE  BI.ACCOUNT_NO = :BI-ACCOUNT-NO                   
                  AND  BI.BILL_NO    = :BG-BILL-NO                      
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  BI.DATE_BILLED                                           
MFA-TR*               ,BI.CODE_BILL_STATUS                                      
MFA-TR*          INTO  :BI-DATE-BILLED:WS-CPD4517-NULL-IND-15                   
MFA-TR*               ,:BI-CODE-BILL-STATUS                                     
MFA-TR*          FROM  CSS_BILLING_HDR BI                                       
MFA-TR*         WHERE  BI.ACCOUNT_NO = :BI-ACCOUNT-NO                           
MFA-TR*           AND  BI.BILL_NO    = :BG-BILL-NO                              
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  6050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-CPD4517-NULL-IND-15 EQUAL -1                        
                 MOVE SPACES                  TO BI-DATE-BILLED         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE BI-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6050-CPD4517-EXIT.                                               
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 6055-CPD4517-GET-COMMON-DT.                                    *        
      ******************************************************************        
      *                                                                         
       6055-CPD4517-GET-COMMON-DT.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT  CIS.SUBSTR3(PARM_DATA,10,10)                          
                 INTO  :WS-CPD4517-COMMON-DATE                          
                 FROM  CSS_JOB_PARM WITH(READUNCOMMITTED)                       
                WHERE  PROGRAM_NAME = 'COMMON'                          
                  AND  COMPANY_NO   = '01'                              
                  AND  CMND_CODE    = 'DATE'                            
                  AND  SEQ_NO       = 10                                
                  AND  STATUS       = 'A'                               
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SUBSTR(PARM_DATA,10,10)                                  
MFA-TR*          INTO  :WS-CPD4517-COMMON-DATE                                  
MFA-TR*          FROM  CSS_JOB_PARM                                             
MFA-TR*         WHERE  PROGRAM_NAME = 'COMMON'                                  
MFA-TR*           AND  COMPANY_NO   = '01'                                      
MFA-TR*           AND  CMND_CODE    = 'DATE'                                    
MFA-TR*           AND  SEQ_NO       = 10                                        
MFA-TR*           AND  STATUS       = 'A'                                       
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  6055                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_JOB_PARM'             TO TABLE-1                
              MOVE 'PROGRAM_NAME'             TO TABLE-ELEMENT-1        
              MOVE 'CMD_CODE'                 TO TABLE-ELEMENT-2        
              MOVE 'SEQ_NO'                   TO TABLE-ELEMENT-3        
              MOVE 'COMMON'                   TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE'                     TO HOSTVAR-ELEMENT-2      
              MOVE '10'                       TO HOSTVAR-ELEMENT-3      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6055-CPD4517-EXIT.                                               
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 6060-CPD4517-SEL-BILL-DET.                                     *        
      ******************************************************************        
      *                                                                         
       6060-CPD4517-SEL-BILL-DET.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT BG.PREMISE_NO                                     
                     ,BG.DATE_ORIG_BILL                                 
                     ,BG.AMT_BILL_ITEM                                  
                     ,BG.CODE_BILL_CALC                                 
                     ,BG.CODE_BILL_ITM_TYPE                             
                     ,BG.CODE_BILL_ITM_IND                              
                     ,BG.CODE_DR_CR_CNSMPTN                             
                     ,BG.AMT_STATE_TAX                                  
                     ,BG.AMT_CITY_TAX                                   
                     ,BG.AMT_OTHER_TAX                                  
                     ,BG.CODE_REVENUE_CLASS                             
                     ,BG.CODE_SIC_NO                                    
                     ,BG.RATE_PLAN_NO                                   
                     ,BG.CODE_CURTAIL_PRTY                              
                     ,BG.CODE_STAT_TAX_XMT                              
                     ,BG.CODE_CITY_TAX_XMT                              
                     ,BG.CODE_OTHR_TAX_XMT                              
                     ,BG.REV_RPT_CD                                     
                     ,BG.STANDBY_COMPLIED                               
                     ,BG.PRORATE_CD                                     
                     ,BG.NEW_RATE_PCT                                   
                     ,BG.CODE_SUB_TOTAL                                 
                     ,BG.TAX_REFUND_CD                                  
                     ,BG.ACCOUNT_NO                                     
                     ,BG.COMPANY_NO                                     
                     ,BG.DATE_LFTM_HI_DMD                               
                     ,BG.LFTM_HI_PEAK_DMD                               
                     ,BG.REBILL_IND                                     
                     ,BG.ADJ_REASON_CD                                  
                     ,BG.REVENUE_MONTH                                  
                     ,BG.GAS_BASE_USE                                   
                     ,BG.WNA_FACTOR                                     
                     ,BG.BTU_FACTOR                                     
                     ,BG.REV_MTH_ORIG_BILL                              
                     ,BG.BILL_CALC_CYCLE                                
                     ,BG.RT_PKG_OPT_SEQ_NO                              
                     ,BG.CITY_TAX_RATE                                  
                     ,BG.STATE_TAX_RATE                                 
                INTO :BG-PREMISE-NO                                     
                    ,:BG-DATE-ORIG-BILL :WS-CPD4517-NULL-IND-12          
                    ,:BG-AMT-BILL-ITEM                                  
                    ,:BG-CODE-BILL-CALC                                 
                    ,:BG-CODE-BILL-ITM-TYPE                             
                    ,:BG-CODE-BILL-ITM-IND                              
                    ,:BG-CODE-DR-CR-CNSMPTN                             
                    ,:BG-AMT-STATE-TAX                                  
                    ,:BG-AMT-CITY-TAX                                   
                    ,:BG-AMT-OTHER-TAX                                  
                    ,:BG-CODE-REVENUE-CLASS                             
                    ,:BG-CODE-SIC-NO                                    
                    ,:BG-RATE-PLAN-NO                                   
                    ,:BG-CODE-CURTAIL-PRTY                              
                    ,:BG-CODE-STAT-TAX-XMT                              
                    ,:BG-CODE-CITY-TAX-XMT                              
                    ,:BG-CODE-OTHR-TAX-XMT                              
                    ,:BG-REV-RPT-CD                                     
                    ,:BG-STANDBY-COMPLIED                               
                    ,:BG-PRORATE-CD                                     
                    ,:BG-NEW-RATE-PCT                                   
                    ,:BG-CODE-SUB-TOTAL                                 
                    ,:BG-TAX-REFUND-CD                                  
                    ,:BG-ACCOUNT-NO                                     
                    ,:BG-COMPANY-NO                                     
                    ,:BG-DATE-LFTM-HI-DMD :WS-CPD4517-NULL-IND-16        
                    ,:BG-LFTM-HI-PEAK-DMD                               
                    ,:BG-REBILL-IND                                     
                    ,:BG-ADJ-REASON-CD                                  
                    ,:BG-REVENUE-MONTH                                  
                    ,:BG-GAS-BASE-USE                                   
                    ,:BG-WNA-FACTOR                                     
                    ,:BG-BTU-FACTOR                                     
                    ,:BG-REV-MTH-ORIG-BILL                              
                    ,:BG-BILL-CALC-CYCLE                                
                    ,:BG-RT-PKG-OPT-SEQ-NO :WS-CPD4517-NULL-IND-13       
                    ,:BG-CITY-TAX-RATE                                  
                    ,:BG-STATE-TAX-RATE                                 
                 FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
                WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.BILL_NO            = :BG-BILL-NO               
                  AND BG.IC_NO              = :BG-IC-NO                 
                  AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND BG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG.PREMISE_NO                                             
MFA-TR*              ,BG.DATE_ORIG_BILL                                         
MFA-TR*              ,BG.AMT_BILL_ITEM                                          
MFA-TR*              ,BG.CODE_BILL_CALC                                         
MFA-TR*              ,BG.CODE_BILL_ITM_TYPE                                     
MFA-TR*              ,BG.CODE_BILL_ITM_IND                                      
MFA-TR*              ,BG.CODE_DR_CR_CNSMPTN                                     
MFA-TR*              ,BG.AMT_STATE_TAX                                          
MFA-TR*              ,BG.AMT_CITY_TAX                                           
MFA-TR*              ,BG.AMT_OTHER_TAX                                          
MFA-TR*              ,BG.CODE_REVENUE_CLASS                                     
MFA-TR*              ,BG.CODE_SIC_NO                                            
MFA-TR*              ,BG.RATE_PLAN_NO                                           
MFA-TR*              ,BG.CODE_CURTAIL_PRTY                                      
MFA-TR*              ,BG.CODE_STAT_TAX_XMT                                      
MFA-TR*              ,BG.CODE_CITY_TAX_XMT                                      
MFA-TR*              ,BG.CODE_OTHR_TAX_XMT                                      
MFA-TR*              ,BG.REV_RPT_CD                                             
MFA-TR*              ,BG.STANDBY_COMPLIED                                       
MFA-TR*              ,BG.PRORATE_CD                                             
MFA-TR*              ,BG.NEW_RATE_PCT                                           
MFA-TR*              ,BG.CODE_SUB_TOTAL                                         
MFA-TR*              ,BG.TAX_REFUND_CD                                          
MFA-TR*              ,BG.ACCOUNT_NO                                             
MFA-TR*              ,BG.COMPANY_NO                                             
MFA-TR*              ,BG.DATE_LFTM_HI_DMD                                       
MFA-TR*              ,BG.LFTM_HI_PEAK_DMD                                       
MFA-TR*              ,BG.REBILL_IND                                             
MFA-TR*              ,BG.ADJ_REASON_CD                                          
MFA-TR*              ,BG.REVENUE_MONTH                                          
MFA-TR*              ,BG.GAS_BASE_USE                                           
MFA-TR*              ,BG.WNA_FACTOR                                             
MFA-TR*              ,BG.BTU_FACTOR                                             
MFA-TR*              ,BG.REV_MTH_ORIG_BILL                                      
MFA-TR*              ,BG.BILL_CALC_CYCLE                                        
MFA-TR*              ,BG.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*              ,BG.CITY_TAX_RATE                                          
MFA-TR*              ,BG.STATE_TAX_RATE                                         
MFA-TR*         INTO :BG-PREMISE-NO                                             
MFA-TR*             ,:BG-DATE-ORIG-BILL:WS-CPD4517-NULL-IND-12                  
MFA-TR*             ,:BG-AMT-BILL-ITEM                                          
MFA-TR*             ,:BG-CODE-BILL-CALC                                         
MFA-TR*             ,:BG-CODE-BILL-ITM-TYPE                                     
MFA-TR*             ,:BG-CODE-BILL-ITM-IND                                      
MFA-TR*             ,:BG-CODE-DR-CR-CNSMPTN                                     
MFA-TR*             ,:BG-AMT-STATE-TAX                                          
MFA-TR*             ,:BG-AMT-CITY-TAX                                           
MFA-TR*             ,:BG-AMT-OTHER-TAX                                          
MFA-TR*             ,:BG-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:BG-CODE-SIC-NO                                            
MFA-TR*             ,:BG-RATE-PLAN-NO                                           
MFA-TR*             ,:BG-CODE-CURTAIL-PRTY                                      
MFA-TR*             ,:BG-CODE-STAT-TAX-XMT                                      
MFA-TR*             ,:BG-CODE-CITY-TAX-XMT                                      
MFA-TR*             ,:BG-CODE-OTHR-TAX-XMT                                      
MFA-TR*             ,:BG-REV-RPT-CD                                             
MFA-TR*             ,:BG-STANDBY-COMPLIED                                       
MFA-TR*             ,:BG-PRORATE-CD                                             
MFA-TR*             ,:BG-NEW-RATE-PCT                                           
MFA-TR*             ,:BG-CODE-SUB-TOTAL                                         
MFA-TR*             ,:BG-TAX-REFUND-CD                                          
MFA-TR*             ,:BG-ACCOUNT-NO                                             
MFA-TR*             ,:BG-COMPANY-NO                                             
MFA-TR*             ,:BG-DATE-LFTM-HI-DMD:WS-CPD4517-NULL-IND-16                
MFA-TR*             ,:BG-LFTM-HI-PEAK-DMD                                       
MFA-TR*             ,:BG-REBILL-IND                                             
MFA-TR*             ,:BG-ADJ-REASON-CD                                          
MFA-TR*             ,:BG-REVENUE-MONTH                                          
MFA-TR*             ,:BG-GAS-BASE-USE                                           
MFA-TR*             ,:BG-WNA-FACTOR                                             
MFA-TR*             ,:BG-BTU-FACTOR                                             
MFA-TR*             ,:BG-REV-MTH-ORIG-BILL                                      
MFA-TR*             ,:BG-BILL-CALC-CYCLE                                        
MFA-TR*             ,:BG-RT-PKG-OPT-SEQ-NO:WS-CPD4517-NULL-IND-13               
MFA-TR*             ,:BG-CITY-TAX-RATE                                          
MFA-TR*             ,:BG-STATE-TAX-RATE                                         
MFA-TR*          FROM CSS_BILLING_DET BG                                        
MFA-TR*         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.BILL_NO            = :BG-BILL-NO                       
MFA-TR*           AND BG.IC_NO              = :BG-IC-NO                         
MFA-TR*           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND BG.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 6060                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-CPD4517-NULL-IND-12 EQUAL -1                        
                 MOVE SPACES                  TO BG-DATE-ORIG-BILL      
                 MOVE ZEROES                  TO WS-CPD4517-NULL-IND-12 
              END-IF                                                    
              IF WS-CPD4517-NULL-IND-13 EQUAL -1                        
                 MOVE ZEROES                  TO BG-RT-PKG-OPT-SEQ-NO   
                                                 WS-CPD4517-NULL-IND-13 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6060'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-4        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6060-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6065-CPD4517-OPEN-CX.                                          *        
      ******************************************************************        
      *                                                                         
       6065-CPD4517-OPEN-CX.                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN CNSMPTN_HIST                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6065'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6065-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6070-CPD4517-FETCH-CX.                                         *        
      ******************************************************************        
      *                                                                         
       6070-CPD4517-FETCH-CX.                                           
      *                                                                         
           EXEC SQL                                                     
               FETCH CNSMPTN_HIST                                       
                INTO :CX-CODE-TIME-PERIOD                               
                    ,:CX-MTR-REF-NO                                     
                    ,:CX-CODE-USAGE-TYPE                                
                    ,:CX-CODE-USAGE-ID                                  
                    ,:CX-CODE-USAGE-SOURCE                              
                    ,:CX-ITEM-SEQ-NO                                    
                    ,:CX-METER-NO                                       
                    ,:CX-REG-ID-NO                                      
                    ,:CX-DATE-READ :WS-CPD4517-NULL-IND-11               
                    ,:CX-CODE-METER-READ                                
                    ,:CX-CODE-METER-NO-READ                             
                    ,:CX-METER-READING                                  
                    ,:CX-DEMAND-READING                                 
                    ,:CX-EMPLOYEE-NO                                    
                    ,:CX-NO-UNITS                                       
                    ,:CX-NO-DEMAND-UNITS                                
                    ,:CX-NO-DAYS                                        
                    ,:CX-CODE-SOURCE-ID                                 
                    ,:CX-CODE-DEBIT-CREDIT                              
                    ,:CX-CODE-ITEM-STATUS                               
                    ,:CX-CODE-DISCOUNT                                  
                    ,:CX-CONSTANT                                       
                    ,:CX-NO-DIALS                                       
                    ,:CX-COMPANY-NO                                     
                    ,:CX-EXCEPT-OVERRIDE-CD                             
                    ,:CX-REQUESTED-USAGE                                
                    ,:CX-DIGTL-INTRL-MTR-NO                             
                    ,:CX-DIGTL-MTR-TYPE                                 
                    ,:CX-CODE-TOU-SEASN                                 
                    ,:CX-EXCL-DMD-RCHT-IND                              
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6070'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6070-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6075-CPD4517-CLOSE-CX.                                         *        
      ******************************************************************        
       6075-CPD4517-CLOSE-CX.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE CNSMPTN_HIST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6075'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6075-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6080-CPD4517-OPEN-UC.                                          *        
      ******************************************************************        
      *                                                                         
       6080-CPD4517-OPEN-UC.                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN UM_CNSMPT_HIST                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6080'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_UM_CNSMPT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE UC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UC-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE UC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE UC-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6080-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6085-CPD4517-FETCH-UC.                                         *        
      ******************************************************************        
      *                                                                         
       6085-CPD4517-FETCH-UC.                                           
      *                                                                         
           EXEC SQL                                                     
               FETCH UM_CNSMPT_HIST                                     
                INTO :UC-RATE-ITEM-CODE                                 
                    ,:UC-ITEM-SEQ-NO                                    
                    ,:UC-NO-UNITS                                       
                    ,:UC-NO-DAYS                                        
                    ,:UC-CODE-DEBIT-CREDIT                              
                    ,:UC-USAGE-FIXED                                    
                    ,:UC-DATE-USAGE-ENDS :WS-CPD4517-NULL-IND-10         
                    ,:UC-CODE-SERVICE-TYPE                              
                    ,:UC-CODE-ITEM-STATUS                               
                    ,:UC-CODE-SOURCE-ID                                 
                    ,:UC-MTHLY-AMOUNT-FIXED                             
                    ,:UC-DIST-NO                                        
                    ,:UC-LIGHT-NO                                       
                    ,:UC-POLE-NO                                        
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6085'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_UM_CNSMPT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE UC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UC-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE UC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE UC-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6085-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6090-CPD4517-CLOSE-UC.                                         *        
      ******************************************************************        
      *                                                                         
       6090-CPD4517-CLOSE-UC.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE UM_CNSMPT_HIST                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6090'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_UM_CNSMPT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE UC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UC-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE UC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE UC-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6090-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6095-CPD4517-OPEN-BP.                                          *        
      ******************************************************************        
      *                                                                         
       6095-CPD4517-OPEN-BP.                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN BILL_ADJ_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6095'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_BILL_ADJUSTMENT'      TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BP-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BP-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6095-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6100-CPD4517-FETCH-BP.                                         *        
      ******************************************************************        
      *                                                                         
       6100-CPD4517-FETCH-BP.                                           
      *                                                                         
           EXEC SQL                                                     
               FETCH BILL_ADJ_CSR                                       
                INTO :BP-ADJ-TYPE-CD                                    
                    ,:BP-REVENUE-MONTH                                  
                    ,:BP-ADJ-REASON-DESC                                
                    ,:BP-OVRRIDE-RT-REV-MTH                             
                    ,:BP-OVRRIDE-RT-BILL-DT :WS-CPD4517-NULL-IND-14      
                    ,:BP-OVRRIDE-RT-BILL-CY                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-CPD4517-NULL-IND-14 < 0                          
                    MOVE SPACES               TO BP-OVRRIDE-RT-BILL-DT  
                 ELSE                                                   
                    CONTINUE                                            
                 END-IF                                                 
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6100'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_BILL_ADJUSTMENT'      TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BP-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BP-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6100-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6105-CPD4517-CLOSE-BP.                                         *        
      ******************************************************************        
      *                                                                         
       6105-CPD4517-CLOSE-BP.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE BILL_ADJ_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6105'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_BILL_ADJUSTMENT'      TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BP-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BP-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6105-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6110-CPD4517-OPEN-MN.                                          *        
      ******************************************************************        
      *                                                                         
       6110-CPD4517-OPEN-MN.                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN MTRD_ENVRNMT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6110'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE MN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE MN-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE MN-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6110-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6115-CPD4517-FETCH-MN.                                         *        
      ******************************************************************        
      *                                                                         
       6115-CPD4517-FETCH-MN.                                           
      *                                                                         
           EXEC SQL                                                     
               FETCH MTRD_ENVRNMT                                       
                INTO :MN-MTR-REF-NO                                     
                    ,:MN-CODE-TIME-PERIOD                               
                    ,:MN-METER-NO                                       
                    ,:MN-CODE-DISCOUNT                                  
                    ,:MN-CODE-METER-LOC                                 
                    ,:MN-CODE-METER-STATUS                              
                    ,:MN-CODE-STATUS-REAS                               
                    ,:MN-CODE-ALRT-CHNG-IND                             
                    ,:MN-DIST-NODE-POINT                                
                    ,:MN-CODE-DIVERSION                                 
                    ,:MN-DATE-MTR-INSTALL :WS-CPD4517-NULL-IND-01       
                    ,:MN-CODE-SPCL-SEAL                                 
                    ,:MN-EST-USAGE                                      
                    ,:MN-SPCL-MTR-CONDITION                             
                    ,:MN-CODE-DATA-PRESENT                              
                    ,:MN-CODE-USAGE-TYPE                                
                    ,:MN-CODE-USAGE-ID                                  
                    ,:MN-CODE-USAGE-SOURCE                              
                    ,:MN-REG-ID-NO                                      
                    ,:MN-REGISTER-RD-SEQ                                
                    ,:MN-CODE-CRNT-REG-READ                             
                    ,:MN-CODE-NO-RD-REASON                              
                    ,:MN-CODE-LAST-REG-READ                             
                    ,:MN-LAST-REG-READ-TIME :WS-CPD4517-NULL-IND-03     
                    ,:MN-LAST-REG-READ-DATE :WS-CPD4517-NULL-IND-04     
                    ,:MN-LAST-READ-VALUE                                
                    ,:MN-NO-CONSEC-CRD-READ                             
                    ,:MN-NO-CONSEC-ESTIMATE                             
                    ,:MN-POINT-ID                                       
                    ,:MN-LOCK-TYPE-ID                                   
                    ,:MN-SEAL-CODE-ID                                   
                    ,:MN-HEXAGRAM-LOCATION                              
                    ,:MN-INSULATED-IND                                  
                    ,:MN-METER-SUPPLYING                                
                    ,:MN-LAST-VALID-READ-TM :WS-CPD4517-NULL-IND-05     
                    ,:MN-LAST-VALID-READ-DT :WS-CPD4517-NULL-IND-06     
                    ,:MN-READ-CARD-PRINT-DT :WS-CPD4517-NULL-IND-07     
                    ,:MN-EXCEPT-OVERRIDE-CD                             
                    ,:MN-CODE-MTR-RD-INST1                              
                    ,:MN-CODE-MTR-RD-INST2                              
                    ,:MN-CODE-MTR-RD-INST3                              
                    ,:MN-DIGTL-MTR-TYPE                                 
                    ,:MN-LAST-UPDATE-TS :WS-CPD4517-NULL-IND-08         
                    ,:MN-LAST-VAL-RD-VALUE                              
                    ,:MN-CODE-LAST-VALID-RD                             
                    ,:MN-REMOTE-READ-IND                                
                    ,:MN-MTR-READ-SOURCE-CD                             
                    ,:MN-UTILITY-SOURCE-CD                              
                    ,:MN-DELIVERY-LEVEL-CD                              
                    ,:MN-MTR-STATUS-CHNG-DT :WS-CPD4517-NULL-IND-09     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-CPD4517-NULL-IND-01 EQUAL -1                         
                 MOVE LOW-VALUES TO   MN-DATE-MTR-INSTALL               
             END-IF                                                     
             IF WS-CPD4517-NULL-IND-03 EQUAL -1                         
                 MOVE LOW-VALUES TO   MN-LAST-REG-READ-TIME             
             END-IF                                                     
             IF WS-CPD4517-NULL-IND-04 EQUAL -1                         
                 MOVE LOW-VALUES TO   MN-LAST-REG-READ-DATE             
             END-IF                                                     
             IF WS-CPD4517-NULL-IND-05 EQUAL -1                         
                 MOVE LOW-VALUES TO   MN-LAST-VALID-READ-TM             
             END-IF                                                     
             IF WS-CPD4517-NULL-IND-06 EQUAL -1                         
                 MOVE LOW-VALUES TO   MN-LAST-VALID-READ-DT             
             END-IF                                                     
             IF WS-CPD4517-NULL-IND-07 EQUAL -1                         
                 MOVE LOW-VALUES TO   MN-READ-CARD-PRINT-DT             
             END-IF                                                     
             IF WS-CPD4517-NULL-IND-08 EQUAL -1                         
                 MOVE LOW-VALUES TO   MN-LAST-UPDATE-TS                 
             END-IF                                                     
             IF WS-CPD4517-NULL-IND-09 EQUAL -1                         
                 MOVE LOW-VALUES TO   MN-MTR-STATUS-CHNG-DT             
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6115'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE MN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE MN-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE MN-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6115-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6120-CPD4517-CLOSE-MN.                                         *        
      ******************************************************************        
      *                                                                         
       6120-CPD4517-CLOSE-MN.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE MTRD_ENVRNMT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6120'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE MN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE MN-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE MN-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6120-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6125-CPD4517-OPEN-CP.                                          *        
      ******************************************************************        
      *                                                                         
       6125-CPD4517-OPEN-CP.                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN CUST_PLAN_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6125'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE CP-IC-NO                   TO HOSTVAR-ELEMENT-3      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6125-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6130-CPD4517-FETCH-CP.                                         *        
      ******************************************************************        
      *                                                                         
       6130-CPD4517-FETCH-CP.                                           
      *                                                                         
           EXEC SQL                                                     
               FETCH CUST_PLAN_CRSR                                     
                INTO :CP-POLE-NO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6130' TO ACTIVE-PARAGRAPH                           
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE CP-IC-NO                   TO HOSTVAR-ELEMENT-3      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6130-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6135-CPD4517-CLOSE-CP.                                         *        
      ******************************************************************        
      *                                                                         
       6135-CPD4517-CLOSE-CP.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE CUST_PLAN_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7820'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE CP-IC-NO                   TO HOSTVAR-ELEMENT-3      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6135-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6140-CPD4517-SEL-BASE-RATE.                                    *        
      ******************************************************************        
      *                                                                         
       6140-CPD4517-SEL-BASE-RATE.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT  UT.RATE_PLAN_NO                                  
                      ,UT.CODE_MTR_READ_FREQ                            
                 INTO  :UT-RATE-PLAN-NO                                 
                      ,:UT-CODE-MTR-READ-FREQ                           
                 FROM  CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                WHERE  UT.ACCOUNT_NO     = :UT-ACCOUNT-NO               
                  AND  UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE           
                  AND  UT.IC_NO          = :UT-IC-NO                    
                                                                
                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  UT.RATE_PLAN_NO                                          
MFA-TR*               ,UT.CODE_MTR_READ_FREQ                                    
MFA-TR*          INTO  :UT-RATE-PLAN-NO                                         
MFA-TR*               ,:UT-CODE-MTR-READ-FREQ                                   
MFA-TR*          FROM  CSS_UTIL_ENVRNMT UT                                      
MFA-TR*         WHERE  UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                       
MFA-TR*           AND  UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                   
MFA-TR*           AND  UT.IC_NO          = :UT-IC-NO                            
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  6140                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6140'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE UT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE UT-IC-NO                   TO HOSTVAR-ELEMENT-3      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6140-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6145-CPD4517-SEL-DELINQUENCY.                                  *        
      ******************************************************************        
      *                                                                         
       6145-CPD4517-SEL-DELINQUENCY.                                    
      *                                                                         
           EXEC SQL                                                     
               SELECT  DELINQ_VALUE                                     
                 INTO  :C8-DELINQ-VALUE                                 
                 FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
                WHERE  DELINQ_CD  = :C8-DELINQ-CD                       
                  AND  COMPANY_NO = :AT-COMPANY-NO                      
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DELINQ_VALUE                                             
MFA-TR*          INTO  :C8-DELINQ-VALUE                                         
MFA-TR*          FROM  CSS_DELINQUENCY                                          
MFA-TR*         WHERE  DELINQ_CD  = :C8-DELINQ-CD                               
MFA-TR*           AND  COMPANY_NO = :AT-COMPANY-NO                              
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  6145                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6145'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6145-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6150-CPD4517-SEL-COMPANY-NO.                                   *        
      ******************************************************************        
      *                                                                         
       6150-CPD4517-SEL-COMPANY-NO.                                     
      *                                                                         
           EXEC SQL                                                     
               SELECT  COMPANY_NO                                       
                      ,CODE_ACCT_STAT                                   
                      ,BILL_CYCLE                                       
                      ,REV_MTH_LST_NRML                                 
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
                 INTO  :AT-COMPANY-NO                                   
                      ,:AT-CODE-ACCT-STAT                               
                      ,:AT-BILL-CYCLE                                   
                      ,:AT-REV-MTH-LST-NRML                             
                      ,:AT-ACCT-FINALED-DT :WS-CPD4517-NULL-IND-02      
                 FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                        
                WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                      
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COMPANY_NO                                               
MFA-TR*               ,CODE_ACCT_STAT                                           
MFA-TR*               ,BILL_CYCLE                                               
MFA-TR*               ,REV_MTH_LST_NRML                                         
MFA-TR*               ,ACCT_FINALED_DT                                          
MFA-TR*          INTO  :AT-COMPANY-NO                                           
MFA-TR*               ,:AT-CODE-ACCT-STAT                                       
MFA-TR*               ,:AT-BILL-CYCLE                                           
MFA-TR*               ,:AT-REV-MTH-LST-NRML                                     
MFA-TR*               ,:AT-ACCT-FINALED-DT :WS-CPD4517-NULL-IND-02              
MFA-TR*          FROM  CSS_ACCOUNT                                              
MFA-TR*         WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  6150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-CPD4517-NULL-IND-02 EQUAL -1                        
                 MOVE LOW-VALUES              TO AT-ACCT-FINALED-DT     
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6150-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET REVENUE MONTH FROM CSS_BILL_WINDOW TABLE USING             *        
      * AT-BILL-CYCLE & WS-COMMON-DATE                                 *        
      ******************************************************************        
      *                                                                         
       6155-CPD4517-GET-BW-REV-MTH.                                     
      *                                                                         
            EXEC SQL                                                    
               SELECT REVENUE_MONTH                                     
                 INTO :BN-REVENUE-MONTH                                 
                 FROM CSS_BILL_WINDOW  BN WITH(READUNCOMMITTED)                 
                WHERE BN.BILL_CYCLE     = :AT-BILL-CYCLE                
                  AND BN.DATE_EXTRACT   = IIF(TRY_CONVERT(DATE, 
                                                :WS-CPD4517-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD4517-COMMON-DATE
              ) <> 0) OR (LEN(:WS-CPD4517-COMMON-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CPD4517-COMMON-DATE
              ), CONVERT(DATE, :WS-CPD4517-COMMON-DATE) )       
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT REVENUE_MONTH                                             
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW  BN                                       
MFA-TR*         WHERE BN.BILL_CYCLE     = :AT-BILL-CYCLE                        
MFA-TR*           AND BN.DATE_EXTRACT   = :WS-CPD4517-COMMON-DATE               
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 6155                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6155'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_EXTRACT'             TO TABLE-ELEMENT-2        
              MOVE  AT-BILL-CYCLE             TO HOSTVAR-ELEMENT-1      
              MOVE  WS-CPD4517-COMMON-DATE    TO HOSTVAR-ELEMENT-2      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6155-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET MIN REVENUE MONTH FOR THE EXTRACT DATE = COMMON DATE       *        
      ******************************************************************        
      *                                                                         
       6160-CPD4517-GET-MIN-REVMTH.                                     
      *                                                                         
            EXEC SQL                                                    
               SELECT COALESCE(MIN(REVENUE_MONTH),0)                      
                 INTO :BN-REVENUE-MONTH                                 
                 FROM CSS_BILL_WINDOW  BN WITH(READUNCOMMITTED)                 
                WHERE BN.DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                :WS-CPD4517-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD4517-COMMON-DATE
              ) <> 0) OR (LEN(:WS-CPD4517-COMMON-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CPD4517-COMMON-DATE
              ), CONVERT(DATE, :WS-CPD4517-COMMON-DATE) )         
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT IFNULL(MIN(REVENUE_MONTH),0)                              
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW  BN                                       
MFA-TR*         WHERE BN.DATE_EXTRACT = :WS-CPD4517-COMMON-DATE                 
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 6160                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6160'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'DATE_EXTRACT'             TO TABLE-ELEMENT-1        
              MOVE  WS-CPD4517-COMMON-DATE    TO HOSTVAR-ELEMENT-1      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6160-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET COMMON REVENUE MONTH FROM CSS_JOB_PARM                     *        
      ******************************************************************        
      *                                                                         
       6165-CPD4517-GET-CMN-REVMTH.                                     
      *                                                                         
            EXEC SQL                                                    
               SELECT CIS.SUBSTR3(PARM_DATA,15,6)                            
                 INTO :WS-CPD4517-CMN-REVMTH                            
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME   = 'COMMON'                         
                  AND CMND_CODE      = 'DATE'                           
                  AND SEQ_NO         =  20                              
                  AND STATUS         = 'A'                              
                  AND COMPANY_NO     = '01'                             
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT SUBSTR(PARM_DATA,15,6)                                    
MFA-TR*          INTO :WS-CPD4517-CMN-REVMTH                                    
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME   = 'COMMON'                                 
MFA-TR*           AND CMND_CODE      = 'DATE'                                   
MFA-TR*           AND SEQ_NO         =  20                                      
MFA-TR*           AND STATUS         = 'A'                                      
MFA-TR*           AND COMPANY_NO     = '01'                                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 6165                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CPD4517-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6165'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_JOB_PARM '            TO TABLE-1                
              MOVE 'PROGRAM_NAME'             TO TABLE-ELEMENT-1        
              MOVE 'CMND_CODE'                TO TABLE-ELEMENT-2        
              MOVE 'COMPANY_NO   '            TO TABLE-ELEMENT-3        
              MOVE 'COMMON'                   TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE'                     TO HOSTVAR-ELEMENT-2      
              MOVE '01'                       TO HOSTVAR-ELEMENT-3      
              PERFORM 6999-CPD4517-ERROR-PROCESS THRU 6999-CPD4517-EXIT 
           END-IF.                                                      
      *                                                                         
       6165-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
