      ******************************************************************31298000
      **                       COPYBOOK CPD04515                      **31300000
      ******************************************************************31320000
      ** PURPOSE: CALL MCSCB102 & MCSCB105 USING INPUT ACCOUNT.       **31300000
      **                                                              **        
      ** INPUTS: WS-CPD4515-ACCT-NO                                   **        
      **         WS-CPD4515-BILL-CYCLE                                **        
      **         WS-CPD4515-COMPANY-NO                                **        
      **         WS-CPD4515-INPUT-DATE                                **        
      **         WS-CPD4515-REV-MTH                                   **        
      **         WS-CPD4515-DATE-ORIG-BILL                            **        
      **         WS-CPD4515-CALL-TYPE (B -> BATCH ELSE ONLINE)        **        
      **                                                              **        
      ** OUTPUT: BILL CALC RESULTS FROM MCSCB102 & MCSCB105           **        
      **                                                              **        
      ** REQUIRED MAIN PGM COPYBOOKS: CWS04515                        **        
      **                              TBWTHTRD(CSS_WEATHER_TREND)     **31300000
      **                              TBRDWNDW(CSS_READ_WINDOW)       **31300000
      **                              BILL CALC COPYBOOKS             **31300000
      **                                                              **31300000
      ** REQUIRED MAIN PGM PARA: 6999-ERROR-ROUTINE-CPD4515           **31300000
      **                                                              **31300000
      ******************************************************************31360000
      **               COPYBOOK MODIFICATION  LOG                     **        
      **                                                              **        
      **    DATE     INITIALS                 REASON                  **        
      **  ________   ________   ___________________________________   **        
      **  09/07/11   GD97441    NEW COPYBOOK.                         **        
ACT068**  26/02/15   SS7F226    ADD CREATED BY FIELD LOGIC.           **        
ACT068**             A04860                                           **        
I01959**  10/27/15   SS45239    NEM 2.0                               **        
      ******************************************************************        
      *                                                                         
      *****************************************************************         
      ** BATCH CALL :CALL SCSCA102 & SCSCA105 USING INPUT PARAMETERS **         
      ** ONLINE CALL:CALL MCSCB102 & MCSCB105 USING INPUT PARAMETERS **         
      *****************************************************************         
      *                                                                         
       6000-PROCESS-BILLCALC-CPD4515.                                   
      *                                                                         
           MOVE '6000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           PERFORM 6005-INITIALIZE-LS-CPD4515  THRU                     
                   6005-CPD4515-EXIT.                                   
      *                                                                         
           SET  ONLINE-CALL               TO TRUE.                      
      *                                                                         
           MOVE WS-CPD4515-ACCT-NO        TO WS-FDB07-ACCT-NO.          
           MOVE WS-CPD4515-COMPANY-NO     TO WT-COMPANY-NO              
                                             C8-COMPANY-NO              
                                             G6-COMPANY-NO.             
      *                                                                         
      **** IF DATE ORIG BILL > 0 --> CANCEL-REBILL SCENARIO                     
           IF WS-CPD4515-DATE-ORIG-BILL > SPACES                        
              SET WS-OFF-CYCLE-REBILL     TO TRUE                       
           END-IF.                                                      
      *                                                                         
           MOVE 'DATABASE'                TO C8-DELINQ-CD.              
           PERFORM 6010-GET-DELINQ-DATA-CPD4515  THRU                   
                   6010-CPD4515-EXIT.                                   
           IF CPD4515-NO-ERRORS                                         
              MOVE C8-DELINQ-VALUE        TO LS-DATABASE                
           END-IF.                                                      
      *                                                                         
           IF CPD4515-NO-ERRORS AND WS-CPD4515-INPUT-DATE <= SPACES     
              PERFORM 6025-GET-COMMON-DT-CPD4515  THRU                  
                      6025-CPD4515-EXIT                                 
           END-IF.                                                      
           IF CPD4515-NO-ERRORS                                         
              MOVE WS-CPD4515-INPUT-DATE  TO LS-INPUT-DATE              
                                             WT-DATE-BILL               
                                             BN-DATE-EXTRACT            
           END-IF.                                                      
      *                                                                         
      **** POPULATE "BILL CYCLES" ARRAY.USE BILL CYCLE "00" TO STOP             
      **** ARRAY PROCESSING. USE INPUT REV MTH / MIN REV MTH FROM               
      **** BILL WINDOW / JOB PARM-COMMON REV MTH                                
      *                                                                         
           IF CPD4515-NO-ERRORS AND WS-CPD4515-REV-MTH <= 0             
              MOVE WS-CPD4515-BILL-CYCLE TO BN-BILL-CYCLE               
              PERFORM 6050-GET-BW-REV-MTH-CPD4515  THRU                 
                      6050-CPD4515-EXIT                                 
              MOVE BN-REVENUE-MONTH      TO WS-CPD4515-REV-MTH          
           END-IF.                                                      
           IF CPD4515-NO-ERRORS AND WS-CPD4515-REV-MTH <= 0             
              PERFORM 6060-GET-MIN-REV-MTH-CPD4515  THRU                
                      6060-CPD4515-EXIT                                 
              MOVE BN-REVENUE-MONTH      TO WS-CPD4515-REV-MTH          
           END-IF.                                                      
           IF CPD4515-NO-ERRORS AND WS-CPD4515-REV-MTH <= 0             
              PERFORM 6075-GET-COM-REV-MTH-CPD4515  THRU                
                      6075-CPD4515-EXIT                                 
              MOVE G6-PARM-DATA(15:6)    TO WS-CPD4515-REV-MTH          
           END-IF.                                                      
           IF CPD4515-NO-ERRORS                                         
              MOVE WS-CPD4515-BILL-CYCLE TO WS-FCA00-BLCYC-NUMBER (1)   
              MOVE WS-CPD4515-REV-MTH    TO WS-FCA00-REV-MONTH (1)      
              MOVE '00'                  TO WS-FCA00-BLCYC-NUMBER (2)   
           END-IF.                                                      
      *                                                                         
      **** LOAD WEATHER TREND DATA                                              
      *                                                                         
           IF CPD4515-NO-ERRORS                                         
              PERFORM 6100-OPEN-WTHR-TRND-CPD4515  THRU                 
                      6100-CPD4515-EXIT                                 
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                      OR CPD4515-ERRORS                                 
             PERFORM 6110-FETCH-WTHR-TRND-CPD4515  THRU                 
                     6110-CPD4515-EXIT                                  
             IF CPD4515-NO-ERRORS    AND                                
                WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD 1                  TO WS-WFT-CNTRL                  
                IF WS-WFT-CNTRL > 100                                   
                   SET  CPD4515-ERRORS TO TRUE                          
                   MOVE 999            TO WS-CPD4515-RETURN-CODE        
                ELSE                                                    
                   SET  WS-WFT-INDEX   TO WS-WFT-CNTRL                  
                   MOVE WT-CODE-REVENUE-CLASS TO                        
                                     WS-REV-CLASS-WFT (WS-WFT-INDEX)    
                   MOVE WT-CODE-UTIL-TYPE     TO                        
                                WS-CODE-UTIL-TYPE-WFT (WS-WFT-INDEX)    
                   MOVE WT-FACTOR  TO WS-FACTOR-WFT (WS-WFT-INDEX)      
                   MOVE WT-UNITS-ACCUM        TO                        
                                   WS-ACCUM-USAGE-WFT (WS-WFT-INDEX)    
                END-IF                                                  
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
           IF CPD4515-NO-ERRORS                                         
              PERFORM 6120-CLOSE-WTHR-TRND-CPD4515  THRU                
                      6120-CPD4515-EXIT                                 
           END-IF.                                                      
      *                                                                         
      **** LOAD READ WINDOW DATA                                                
      *                                                                         
           IF CPD4515-NO-ERRORS                                         
              PERFORM 6200-OPEN-READ-WINDOW-CPD4515  THRU               
                      6200-CPD4515-EXIT                                 
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                      OR CPD4515-ERRORS                                 
             PERFORM 6210-FETCH-READ-WINDOW-CPD4515  THRU               
                     6210-CPD4515-EXIT                                  
             IF CPD4515-NO-ERRORS    AND                                
                WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                MOVE RW-READ-CYCLE           TO WS-READ-CYCLE-NUM       
                IF WS-READ-CYCLE-NUM > ZERO AND <= 21                   
                   SET  WS-OPT-RD-DATE-INDX  TO WS-READ-CYCLE-NUM       
                   MOVE RW-READ-CYCLE        TO                         
                              WS-READ-CYCLE-OP (WS-OPT-RD-DATE-INDX)    
                   MOVE RW-OPTIMUM-READ-DATE TO                         
                             WS-OPT-RD-DATE-OP (WS-OPT-RD-DATE-INDX)    
                END-IF                                                  
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
           IF CPD4515-NO-ERRORS                                         
              PERFORM 6220-CLOSE-READ-WINDOW-CPD4515  THRU              
                      6220-CPD4515-EXIT                                 
           END-IF.                                                      
      *                                                                         
    ***** CALL SCSCA102 / MCSCB102 BASED ON CALL TYPE                           
           IF CPD4515-NO-ERRORS                                         
              IF WS-CPD4515-CALL-TYPE = 'B'                             
                 PERFORM 6505-CALL-SCSCA102-CPD4515  THRU               
                         6505-CPD4515-EXIT                              
              ELSE                                                      
                 PERFORM 6500-CALL-MCSCB102-CPD4515  THRU               
                         6500-CPD4515-EXIT                              
              END-IF                                                    
              PERFORM 6900-CHK-BILLCALC-RES-CPD4515  THRU               
                      6900-CPD4515-EXIT                                 
           END-IF.                                                      
      *                                                                         
    ***** CALL SCSCA105 / MCSCB105 BASED ON CALL TYPE                           
           IF CPD4515-NO-ERRORS                                         
              IF WS-CPD4515-CALL-TYPE = 'B'                             
                 PERFORM 6555-CALL-SCSCA105-CPD4515  THRU               
                         6555-CPD4515-EXIT                              
              ELSE                                                      
                 PERFORM 6550-CALL-MCSCB105-CPD4515  THRU               
                         6550-CPD4515-EXIT                              
              END-IF                                                    
              PERFORM 6900-CHK-BILLCALC-RES-CPD4515  THRU               
                      6900-CPD4515-EXIT                                 
           END-IF.                                                      
      *                                                                         
           IF CPD4515-ERRORS                                            
              PERFORM 6999-ERROR-ROUTINE-CPD4515  THRU                  
                      6999-CPD4515-EXIT                                 
           END-IF.                                                      
      *                                                                         
       6000-CPD4515-EXIT.                                               
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INITIALIZE LINKAGE VARIABLES OF MCSCB102 & MCSCB105          **        
      ******************************************************************        
      *                                                                         
       6005-INITIALIZE-LS-CPD4515.                                      
      *                                                                         
           MOVE '6005'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           SET  CPD4515-NO-ERRORS         TO TRUE.                      
      *                                                                         
      *** INITIALIZE COPYBOOK VARIABLES                                         
           INITIALIZE          WS-CPD4515-RETURN-VAR                    
                               BN-REVENUE-MONTH                         
                               G6-PARM-DATA.                            
      *                                                                         
      *** INITIALIZE BILL CALC LS VARIABLES                                     
           INITIALIZE          LS-PCSCA100-COMM-AREA                    
                               SCSCA103-ACCUMULATORS                    
                               WS-12-MONTH-DATA-EPP                     
                               WS-ACCOUNT-AT                            
                               WS-ACCT-ATTRIBUTE-YP                     
                               WS-ACCT-BILL-NMES-AB                     
                               WS-ACCT-MKT-TIER-DD                      
                               WS-ACCT-RTPK-AGR-DF                      
                               WS-ADDR-FORMATTED-DY                     
                               WS-ADDR-FREEFORM-DZ                      
**********                     WS-ADV-COLL-AD                                   
                               WS-AR-CNTRL-AC                           
                               WS-BANK-EFT-BE                           
                               WS-BI-FIXED-FCTR-FF                      
                               WS-BILL-ADJUST-DETAIL                    
                               WS-BILL-ADJUSTMNT                        
                               WS-BILL-BSLN-CNTR-LN                     
                               WS-BILL-BSLN-HIST-LO                     
                               WS-BILL-CALC-DETAIL                      
                               WS-BILL-CALC-X-DETAIL                    
                               WS-BILL-CNTR-HIST-BX                     
                               WS-BILL-CONTRACT-BK                      
                               WS-BILL-DET-BT                           
                               WS-BILLING-BG                            
                               WS-BILLING-BI                            
                               WS-BILLING-WQ-ITEMS-WF                   
                               WS-BUDGET-PLAN-BU                        
                               WS-BUS-CUST-STATS-BS                     
                               WS-CALL-ENVIRONMENT                      
                               WS-CHRG-OFF-CO                           
                               WS-CNSMPTN-HIST-CX                       
                               WS-CONNECT-CHRG-CC                       
                               WS-CONTACT-CN                            
                               WS-CONTRACT-CONT-1C                      
                               WS-CONTRACT-CT                           
                               WS-CONTRACT-DETAIL-TABLE-EA              
                               WS-CORR-MAIL-STAT-MW                     
                               WS-CRED-COLL-CL                          
                               WS-CREDIT-PROFILE-CZ                     
                               WS-CUST-ALERT-CA                         
                               WS-CUSTOMER-CU                           
                               WS-CUST-PLAN-TABLE-CP                    
                               WS-CUST-PREM-HIST-CH                     
                               WS-CUST-STATS-CE                         
**********                     WS-CWS1000B-MAX-TBL-LIMITS                       
**********                     WS-CWS1001B-MAX-TBL-LIMITS                       
                               WS-DEP-ON-HAND-DO                        
                               WS-DEP-REQ-DR                            
                               WS-DFA-ACCT-DA                           
                               WS-DFA-RECV-DV                           
                               WS-EQUIPMENT-TABLE-EQ                    
                               WS-FCA00-BILL-CYCLES-RECORD              
                               WS-FINAL-WO-ACTN-KD                      
                               WS-FINAL-WO-COLL-IZ                      
                               WS-FINAL-WO-FW                           
                               WS-FIODB07                               
                               WS-FIXED-FCTR-HIST-FH                    
                               WS-FIXED-FCTR-TABLE-FF                   
                               WS-GL-ACCT-MAJOR-FIELDS                  
                               WS-GL-ACCT-NO-TABLE                      
                               WS-GL-NAME-INFO                          
                               WS-HOLD-WK03                             
                               WS-INTERRUPT-ACCT-IP                     
                               WS-INTERRUPT-IR                          
                               WS-LOCAL-AND-TOTAL-ACCUM-TABLE           
                               WS-LIEAP-LI                              
                               WS-MTR-CAP-TABLE-MC                      
                               WS-MTRD-ENVRNMT-TABLE-MN                 
                               WS-PART-NO                               
                               WS-PEAK-HIST-PH                          
                               WS-PREMISE-DIRECT-PP                     
                               WS-PREMISE-INSTR-PS                      
                               WS-PREMISE-PAD-PC                        
                               WS-PREMISE-PR                            
                               WS-PREPAY-HIST-PK                        
                               WS-PROJECT-SHARE-PJ                      
                               WS-RATE-COMPARE-RC                       
                               WS-REFUND-RN                             
                               WS-REGISTER-READ-TABLE-RG                
                               WS-SHORT-TERM-AGMT-SA                    
                               WS-STANDBY-GEN-SE                        
                               WS-SURETY-BOND-SB                        
                               WS-UNMTRD-CNSMPTN-UC                     
                               WS-USAGE-HIST-TABLE-UH                   
                               WS-UTILITY-TABLE-UT                      
                               WS-UTL-BILL-REL-TABLE-UR                 
                               WS-UTL-BI-REL-HST-TABLE-UX               
                               WS-VOL-DAILY-ND                          
                               WS-WNA-REVENUE-SUMMARY-TABLE             
                               WS-INTERRUPT-NZ                          
                               WS-CNSMPTN-HOURLY.                       
      *                                                                         
       6005-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET DELINQUENCY DATA                                        **        
      ******************************************************************        
      *                                                                         
       6010-GET-DELINQ-DATA-CPD4515.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT  C8.DELINQ_VALUE                                    
               INTO  :C8-DELINQ-VALUE                                   
               FROM  CSS_DELINQUENCY  C8 WITH(READUNCOMMITTED)                  
              WHERE  C8.DELINQ_CD   =  :C8-DELINQ-CD                    
                AND  C8.COMPANY_NO  =  :C8-COMPANY-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  C8.DELINQ_VALUE                                            
MFA-TR*        INTO  :C8-DELINQ-VALUE                                           
MFA-TR*        FROM  CSS_DELINQUENCY  C8                                        
MFA-TR*       WHERE  C8.DELINQ_CD   =  :C8-DELINQ-CD                            
MFA-TR*         AND  C8.COMPANY_NO  =  :C8-COMPANY-NO                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 6010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPD4515-ERRORS             TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-CPD4515-RETURN-CODE 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DELINQ_CD '               TO TABLE-ELEMENT-2        
              MOVE 'COMPANY_NO '              TO TABLE-ELEMENT-3        
              MOVE WS-CPD4515-ACCT-NO         TO HOSTVAR-ELEMENT-1      
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-2      
              MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
           END-IF.                                                      
      *                                                                         
       6010-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET COMMON DATE                                             **        
      ******************************************************************        
      *                                                                         
       6025-GET-COMMON-DT-CPD4515.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT  CIS.SUBSTR3(G6.PARM_DATA,10,10)                         
               INTO  :WS-CPD4515-INPUT-DATE                             
               FROM  CSS_JOB_PARM   G6 WITH(READUNCOMMITTED)                    
              WHERE  G6.PROGRAM_NAME  =  'COMMON'                       
                AND  G6.COMPANY_NO    =  '01'                           
                AND  G6.CMND_CODE     =  'DATE'                         
                AND  G6.SEQ_NO        =  10                             
                AND  G6.STATUS        =  'A'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  SUBSTR(G6.PARM_DATA,10,10)                                 
MFA-TR*        INTO  :WS-CPD4515-INPUT-DATE                                     
MFA-TR*        FROM  CSS_JOB_PARM   G6                                          
MFA-TR*       WHERE  G6.PROGRAM_NAME  =  'COMMON'                               
MFA-TR*         AND  G6.COMPANY_NO    =  '01'                                   
MFA-TR*         AND  G6.CMND_CODE     =  'DATE'                                 
MFA-TR*         AND  G6.SEQ_NO        =  10                                     
MFA-TR*         AND  G6.STATUS        =  'A'                                    
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 6025                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPD4515-ERRORS             TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-CPD4515-RETURN-CODE 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6025'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_JOB_PARM'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-CPD4515-ACCT-NO         TO HOSTVAR-ELEMENT-1      
           END-IF.                                                      
      *                                                                         
       6025-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET REVENUE MONTH FOR INPUT CYCLE AND DATE                  **        
      ******************************************************************        
      *                                                                         
       6050-GET-BW-REV-MTH-CPD4515.                                     
      *                                                                         
           EXEC SQL                                                     
             SELECT  COALESCE(BN.REVENUE_MONTH,0)                         
               INTO  :BN-REVENUE-MONTH                                  
               FROM  CSS_BILL_WINDOW  BN WITH(READUNCOMMITTED)                  
              WHERE  BN.BILL_CYCLE    =  :BN-BILL-CYCLE                 
                AND  BN.DATE_EXTRACT  =  IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  IFNULL(BN.REVENUE_MONTH,0)                                 
MFA-TR*        INTO  :BN-REVENUE-MONTH                                          
MFA-TR*        FROM  CSS_BILL_WINDOW  BN                                        
MFA-TR*       WHERE  BN.BILL_CYCLE    =  :BN-BILL-CYCLE                         
MFA-TR*         AND  BN.DATE_EXTRACT  =  :BN-DATE-EXTRACT                       
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 6050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPD4515-ERRORS             TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-CPD4515-RETURN-CODE 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-2        
              MOVE 'DATE_EXTRACT'             TO TABLE-ELEMENT-3        
              MOVE WS-CPD4515-ACCT-NO         TO HOSTVAR-ELEMENT-1      
              MOVE BN-BILL-CYCLE              TO HOSTVAR-ELEMENT-2      
              MOVE BN-DATE-EXTRACT            TO HOSTVAR-ELEMENT-3      
           END-IF.                                                      
      *                                                                         
       6050-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET MINIMUM REVENUE MONTH FOR INPUT DATE                    **        
      ******************************************************************        
      *                                                                         
       6060-GET-MIN-REV-MTH-CPD4515.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT  COALESCE(MIN(BN.REVENUE_MONTH),0)                    
               INTO  :BN-REVENUE-MONTH                                  
               FROM  CSS_BILL_WINDOW  BN WITH(READUNCOMMITTED)                  
              WHERE  BN.DATE_EXTRACT  =  IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  IFNULL(MIN(BN.REVENUE_MONTH),0)                            
MFA-TR*        INTO  :BN-REVENUE-MONTH                                          
MFA-TR*        FROM  CSS_BILL_WINDOW  BN                                        
MFA-TR*       WHERE  BN.DATE_EXTRACT  =  :BN-DATE-EXTRACT                       
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 6060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPD4515-ERRORS             TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-CPD4515-RETURN-CODE 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6060'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_EXTRACT'             TO TABLE-ELEMENT-2        
              MOVE WS-CPD4515-ACCT-NO         TO HOSTVAR-ELEMENT-1      
              MOVE BN-DATE-EXTRACT            TO HOSTVAR-ELEMENT-2      
           END-IF.                                                      
      *                                                                         
       6060-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET "COMMON-REVENUE MONTH" FROM JOB PARM                    **        
      ******************************************************************        
      *                                                                         
       6075-GET-COM-REV-MTH-CPD4515.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT  G6.PARM_DATA                                       
               INTO :G6-PARM-DATA                                       
               FROM  CSS_JOB_PARM  G6 WITH(READUNCOMMITTED)                     
              WHERE  G6.PROGRAM_NAME  =  'COMMON'                       
                AND  G6.CMND_CODE     =  'DATE'                         
                AND  G6.SEQ_NO        =  20                             
                AND  G6.STATUS        =  'A'                            
                AND  G6.COMPANY_NO    =  :G6-COMPANY-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  G6.PARM_DATA                                               
MFA-TR*        INTO :G6-PARM-DATA                                               
MFA-TR*        FROM  CSS_JOB_PARM  G6                                           
MFA-TR*       WHERE  G6.PROGRAM_NAME  =  'COMMON'                               
MFA-TR*         AND  G6.CMND_CODE     =  'DATE'                                 
MFA-TR*         AND  G6.SEQ_NO        =  20                                     
MFA-TR*         AND  G6.STATUS        =  'A'                                    
MFA-TR*         AND  G6.COMPANY_NO    =  :G6-COMPANY-NO                         
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 6075                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPD4515-ERRORS             TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-CPD4515-RETURN-CODE 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6075'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_JOB_PARM'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-CPD4515-ACCT-NO         TO HOSTVAR-ELEMENT-1      
              MOVE G6-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
           END-IF.                                                      
      *                                                                         
       6075-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN WEATHER_TREND CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       6100-OPEN-WTHR-TRND-CPD4515.                                     
      *                                                                         
           EXEC SQL                                                     
               OPEN WEATHER_TREND                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPD4515-ERRORS             TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-CPD4515-RETURN-CODE 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WEATHER_TREND'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_BILL'                TO TABLE-ELEMENT-2        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
              MOVE WS-CPD4515-ACCT-NO         TO HOSTVAR-ELEMENT-1      
              MOVE WT-DATE-BILL               TO HOSTVAR-ELEMENT-2      
              MOVE WT-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
           END-IF.                                                      
      *                                                                         
       6100-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH WEATHER_TREND CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       6110-FETCH-WTHR-TRND-CPD4515.                                    
      *                                                                         
           EXEC SQL                                                     
              FETCH WEATHER_TREND                                       
               INTO :WT-CODE-REVENUE-CLASS                              
                   ,:WT-FACTOR                                          
                   ,:WT-UNITS-ACCUM                                     
                   ,:WT-CODE-UTIL-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPD4515-ERRORS             TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-CPD4515-RETURN-CODE 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WEATHER_TREND'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_BILL'                TO TABLE-ELEMENT-2        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
              MOVE WS-CPD4515-ACCT-NO         TO HOSTVAR-ELEMENT-1      
              MOVE WT-DATE-BILL               TO HOSTVAR-ELEMENT-2      
              MOVE WT-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
           END-IF.                                                      
      *                                                                         
       6110-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE WEATHER_TREND CURSOR                                  **        
      ******************************************************************        
      *                                                                         
       6120-CLOSE-WTHR-TRND-CPD4515.                                    
      *                                                                         
           EXEC SQL                                                     
              CLOSE WEATHER_TREND                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPD4515-ERRORS             TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-CPD4515-RETURN-CODE 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_WEATHER_TREND'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_BILL'                TO TABLE-ELEMENT-2        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
              MOVE WS-CPD4515-ACCT-NO         TO HOSTVAR-ELEMENT-1      
              MOVE WT-DATE-BILL               TO HOSTVAR-ELEMENT-2      
              MOVE WT-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
           END-IF.                                                      
      *                                                                         
       6120-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN READ_WIN_CUR CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       6200-OPEN-READ-WINDOW-CPD4515.                                   
      *                                                                         
           EXEC SQL                                                     
               OPEN READ_WIN_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPD4515-ERRORS             TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-CPD4515-RETURN-CODE 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_READ_WINDOW'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-2        
              MOVE WS-CPD4515-ACCT-NO         TO HOSTVAR-ELEMENT-1      
              MOVE WS-CPD4515-INPUT-DATE      TO HOSTVAR-ELEMENT-2      
           END-IF.                                                      
      *                                                                         
       6200-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH READ_WIN_CUR CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       6210-FETCH-READ-WINDOW-CPD4515.                                  
      *                                                                         
           EXEC SQL                                                     
              FETCH READ_WIN_CUR                                        
               INTO :RW-READ-CYCLE                                      
                   ,:RW-OPTIMUM-READ-DATE                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPD4515-ERRORS             TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-CPD4515-RETURN-CODE 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_READ_WINDOW'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-2        
              MOVE WS-CPD4515-ACCT-NO         TO HOSTVAR-ELEMENT-1      
              MOVE WS-CPD4515-INPUT-DATE      TO HOSTVAR-ELEMENT-2      
           END-IF.                                                      
      *                                                                         
       6210-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE READ_WIN_CUR CURSOR                                   **        
      ******************************************************************        
      *                                                                         
       6220-CLOSE-READ-WINDOW-CPD4515.                                  
      *                                                                         
           EXEC SQL                                                     
              CLOSE READ_WIN_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  CPD4515-ERRORS             TO TRUE                   
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-CPD4515-RETURN-CODE 
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6220'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_READ_WINDOW'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'INPUT DATE'               TO TABLE-ELEMENT-2        
              MOVE WS-CPD4515-ACCT-NO         TO HOSTVAR-ELEMENT-1      
              MOVE WS-CPD4515-INPUT-DATE      TO HOSTVAR-ELEMENT-2      
           END-IF.                                                      
      *                                                                         
       6220-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CALL MCSCB102                                                **        
      ******************************************************************        
      *                                                                         
       6500-CALL-MCSCB102-CPD4515.                                      
      *                                                                         
           MOVE '6500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           CALL MCSCB102 USING  LS-PCSCA100-COMM-AREA                   
                               ,WS-FIODB07                              
                               ,WS-PART-NO                              
                               ,WS-PREMISE-PR                           
                               ,WS-PREMISE-INSTR-PS                     
                               ,WS-PREMISE-DIRECT-PP                    
                               ,WS-PREMISE-PAD-PC                       
                               ,WS-CUSTOMER-CU                          
                               ,WS-CUST-PREM-HIST-CH                    
                               ,WS-ACCOUNT-AT                           
                               ,WS-DEP-ON-HAND-DO                       
                               ,WS-CHRG-OFF-CO                          
                               ,WS-CUST-STATS-CE                        
                               ,WS-CUST-ALERT-CA                        
                               ,WS-BANK-EFT-BE                          
                               ,WS-CRED-COLL-CL                         
                               ,WS-SURETY-BOND-SB                       
                               ,WS-LIEAP-LI                             
                               ,WS-PEAK-HIST-PH                         
                               ,WS-BILLING-BI                           
                               ,WS-BILLING-BG                           
                               ,WS-BILL-CALC-DETAIL                     
                               ,WS-BILL-ADJUST-DETAIL                   
                               ,WS-CNSMPTN-HIST-CX                      
                               ,WS-UNMTRD-CNSMPTN-UC                    
                               ,WS-FIXED-FCTR-HIST-FH                   
                               ,WS-BILL-CONTRACT-BK                     
                               ,WS-BILL-CNTR-HIST-BX                    
                               ,WS-AR-CNTRL-AC                          
                               ,WS-BUDGET-PLAN-BU                       
                               ,WS-CONNECT-CHRG-CC                      
                               ,WS-DFA-ACCT-DA                          
                               ,WS-DFA-RECV-DV                          
                               ,WS-DEP-REQ-DR                           
                               ,WS-CONTRACT-CT                          
                               ,WS-CONTRACT-DETAIL-TABLE-EA             
**********                     ,WS-ADV-COLL-AD                          02060000
                               ,WS-BUS-CUST-STATS-BS                    
                               ,WS-CONTACT-CN                           
                               ,WS-ACCT-BILL-NMES-AB                    
                               ,WS-ADDR-FREEFORM-DZ                     
                               ,WS-ADDR-FORMATTED-DY                    
                               ,WS-CREDIT-PROFILE-CZ                    
                               ,WS-SHORT-TERM-AGMT-SA                   
                               ,WS-PROJECT-SHARE-PJ                     
                               ,WS-INTERRUPT-ACCT-IP                    
                               ,WS-STANDBY-GEN-SE                       
                               ,WS-INTERRUPT-IR                         
                               ,WS-FINAL-WO-FW                          
                               ,WS-UTILITY-TABLE-UT                     
                               ,WS-USAGE-HIST-TABLE-UH                  
                               ,WS-REGISTER-READ-TABLE-RG               
                               ,WS-UTL-BILL-REL-TABLE-UR                
                               ,WS-FIXED-FCTR-TABLE-FF                  
                               ,WS-MTRD-ENVRNMT-TABLE-MN                
                               ,WS-MTR-CAP-TABLE-MC                     
                               ,WS-EQUIPMENT-TABLE-EQ                   
                               ,WS-CUST-PLAN-TABLE-CP                   
                               ,WS-FCA00-BILL-CYCLES-RECORD             
                               ,WS-BILLING-WQ-ITEMS-WF                  
                               ,WS-12-MONTH-DATA-EPP                    
                               ,WS-RATE-COMPARE-RC                      
                               ,WS-GL-ACCT-NO-TABLE                     
                               ,WS-HOLD-WK03                            
                               ,WS-REFUND-RN                            
                               ,WS-ACCT-ATTRIBUTE-YP                    
                               ,WS-ACCT-MKT-TIER-DD                     
                               ,WS-ACCT-RTPK-AGR-DF                     
                               ,WS-BI-FIXED-FCTR-FF                     
                               ,WS-BILL-DET-BT                          
                               ,WS-BILL-ADJUSTMNT                       
                               ,WS-FINAL-WO-ACTN-KD                     
                               ,WS-FINAL-WO-COLL-IZ                     
                               ,WS-CWS1001B-MAX-TBL-LIMITS              
                               ,WS-CWS1000B-MAX-TBL-LIMITS              
                               ,WS-CONTRACT-CONT-1C                     
                               ,WS-CORR-MAIL-STAT-MW                    
                               ,WS-BILL-CALC-X-DETAIL                   
                               ,WS-VOL-DAILY-ND                         
                               ,WS-UTL-BI-REL-HST-TABLE-UX              
                               ,WS-PREPAY-HIST-PK                       
                               ,WS-BILL-BSLN-CNTR-LN                    
                               ,WS-BILL-BSLN-HIST-LO                    
                               ,WS-CALL-ENVIRONMENT                     
                               ,WS-INTERRUPT-NZ                         
                               ,WS-CNSMPTN-HOURLY                       
I01959                         ,WS-AR-CNTRL-ASGNE-XFER-AX.              
      *                                                                         
       6500-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CALL SCSCA102                                                **        
      ******************************************************************        
      *                                                                         
       6505-CALL-SCSCA102-CPD4515.                                      
      *                                                                         
           MOVE '6505'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           CALL SCSCA102 USING  LS-PCSCA100-COMM-AREA                   
                               ,WS-FIODB07                              
                               ,WS-PART-NO                              
                               ,WS-PREMISE-PR                           
                               ,WS-PREMISE-INSTR-PS                     
                               ,WS-PREMISE-DIRECT-PP                    
                               ,WS-PREMISE-PAD-PC                       
                               ,WS-CUSTOMER-CU                          
                               ,WS-CUST-PREM-HIST-CH                    
                               ,WS-ACCOUNT-AT                           
                               ,WS-DEP-ON-HAND-DO                       
                               ,WS-CHRG-OFF-CO                          
                               ,WS-CUST-STATS-CE                        
                               ,WS-CUST-ALERT-CA                        
                               ,WS-BANK-EFT-BE                          
                               ,WS-CRED-COLL-CL                         
                               ,WS-SURETY-BOND-SB                       
                               ,WS-LIEAP-LI                             
                               ,WS-PEAK-HIST-PH                         
                               ,WS-BILLING-BI                           
                               ,WS-BILLING-BG                           
                               ,WS-BILL-CALC-DETAIL                     
                               ,WS-BILL-ADJUST-DETAIL                   
                               ,WS-CNSMPTN-HIST-CX                      
                               ,WS-UNMTRD-CNSMPTN-UC                    
                               ,WS-FIXED-FCTR-HIST-FH                   
                               ,WS-BILL-CONTRACT-BK                     
                               ,WS-BILL-CNTR-HIST-BX                    
                               ,WS-AR-CNTRL-AC                          
                               ,WS-BUDGET-PLAN-BU                       
                               ,WS-CONNECT-CHRG-CC                      
                               ,WS-DFA-ACCT-DA                          
                               ,WS-DFA-RECV-DV                          
                               ,WS-DEP-REQ-DR                           
                               ,WS-CONTRACT-CT                          
                               ,WS-CONTRACT-DETAIL-TABLE-EA             
**********                     ,WS-ADV-COLL-AD                          02060000
                               ,WS-BUS-CUST-STATS-BS                    
                               ,WS-CONTACT-CN                           
                               ,WS-ACCT-BILL-NMES-AB                    
                               ,WS-ADDR-FREEFORM-DZ                     
                               ,WS-ADDR-FORMATTED-DY                    
                               ,WS-CREDIT-PROFILE-CZ                    
                               ,WS-SHORT-TERM-AGMT-SA                   
                               ,WS-PROJECT-SHARE-PJ                     
                               ,WS-INTERRUPT-ACCT-IP                    
                               ,WS-STANDBY-GEN-SE                       
                               ,WS-INTERRUPT-IR                         
                               ,WS-FINAL-WO-FW                          
                               ,WS-UTILITY-TABLE-UT                     
                               ,WS-USAGE-HIST-TABLE-UH                  
                               ,WS-REGISTER-READ-TABLE-RG               
                               ,WS-UTL-BILL-REL-TABLE-UR                
                               ,WS-FIXED-FCTR-TABLE-FF                  
                               ,WS-MTRD-ENVRNMT-TABLE-MN                
                               ,WS-MTR-CAP-TABLE-MC                     
                               ,WS-EQUIPMENT-TABLE-EQ                   
                               ,WS-CUST-PLAN-TABLE-CP                   
                               ,WS-FCA00-BILL-CYCLES-RECORD             
                               ,WS-BILLING-WQ-ITEMS-WF                  
                               ,WS-12-MONTH-DATA-EPP                    
                               ,WS-RATE-COMPARE-RC                      
                               ,WS-GL-ACCT-NO-TABLE                     
                               ,WS-HOLD-WK03                            
                               ,WS-REFUND-RN                            
                               ,WS-ACCT-ATTRIBUTE-YP                    
                               ,WS-ACCT-MKT-TIER-DD                     
                               ,WS-ACCT-RTPK-AGR-DF                     
                               ,WS-BI-FIXED-FCTR-FF                     
                               ,WS-BILL-DET-BT                          
                               ,WS-BILL-ADJUSTMNT                       
                               ,WS-FINAL-WO-ACTN-KD                     
                               ,WS-FINAL-WO-COLL-IZ                     
                               ,WS-CWS1001B-MAX-TBL-LIMITS              
                               ,WS-CWS1000B-MAX-TBL-LIMITS              
                               ,WS-CONTRACT-CONT-1C                     
                               ,WS-CORR-MAIL-STAT-MW                    
                               ,WS-BILL-CALC-X-DETAIL                   
                               ,WS-VOL-DAILY-ND                         
                               ,WS-UTL-BI-REL-HST-TABLE-UX              
                               ,WS-PREPAY-HIST-PK                       
                               ,WS-BILL-BSLN-CNTR-LN                    
                               ,WS-BILL-BSLN-HIST-LO                    
                               ,WS-CALL-ENVIRONMENT                     
                               ,WS-INTERRUPT-NZ                         
                               ,WS-CNSMPTN-HOURLY                       
I01959                         ,WS-AR-CNTRL-ASGNE-XFER-AX.              
      *                                                                         
       6505-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CALL MCSCB105                                                **        
      ******************************************************************        
      *                                                                         
       6550-CALL-MCSCB105-CPD4515.                                      
      *                                                                         
           MOVE '6550'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           CALL MCSCB105 USING  LS-PCSCA100-COMM-AREA                   
                               ,WS-FIODB07                              
                               ,SCSCA103-ACCUMULATORS                   
                               ,WS-PREMISE-PR                           
                               ,WS-CUSTOMER-CU                          
                               ,WS-ACCOUNT-AT                           
                               ,WS-AR-CNTRL-AC                          
                               ,WS-BILLING-BI                           
                               ,WS-BILLING-BG                           
                               ,WS-BILL-CALC-DETAIL                     
                               ,WS-BILL-ADJUST-DETAIL                   
                               ,WS-CNSMPTN-HIST-CX                      
                               ,WS-UNMTRD-CNSMPTN-UC                    
                               ,WS-FIXED-FCTR-HIST-FH                   
                               ,WS-BILL-CONTRACT-BK                     
                               ,WS-CUST-PLAN-TABLE-CP                   
                               ,WS-FIXED-FCTR-TABLE-FF                  
                               ,WS-BILL-CNTR-HIST-BX                    
                               ,WS-PEAK-HIST-PH                         
                               ,WS-INTERRUPT-ACCT-IP                    
                               ,WS-STANDBY-GEN-SE                       
                               ,WS-INTERRUPT-IR                         
                               ,WS-UTILITY-TABLE-UT                     
                               ,WS-REGISTER-READ-TABLE-RG               
                               ,WS-MTRD-ENVRNMT-TABLE-MN                
                               ,WS-MTR-CAP-TABLE-MC                     
                               ,WS-UTL-BILL-REL-TABLE-UR                
                               ,WS-EQUIPMENT-TABLE-EQ                   
                               ,WS-FCA00-BILL-CYCLES-RECORD             
                               ,WS-BILLING-WQ-ITEMS-WF                  
                               ,WS-LOCAL-AND-TOTAL-ACCUM-TABLE          
                               ,WS-GL-NAME-INFO                         
                               ,WS-GL-ACCT-NO-TABLE                     
                               ,WS-GL-ACCT-MAJOR-FIELDS                 
                               ,WS-HOLD-WK03                            
                               ,WS-WNA-REVENUE-SUMMARY-TABLE            
                               ,WS-REFUND-RN                            
                               ,WS-ACCT-ATTRIBUTE-YP                    
                               ,WS-ACCT-MKT-TIER-DD                     
                               ,WS-ACCT-RTPK-AGR-DF                     
                               ,WS-BI-FIXED-FCTR-FF                     
                               ,WS-BILL-DET-BT                          
                               ,WS-BILL-ADJUSTMNT                       
                               ,WS-CWS1000B-MAX-TBL-LIMITS              
                               ,WS-CWS1001B-MAX-TBL-LIMITS              
                               ,WS-BILL-CALC-X-DETAIL                   
                               ,WS-VOL-DAILY-ND                         
                               ,WS-UTL-BI-REL-HST-TABLE-UX              
                               ,WS-PREPAY-HIST-PK                       
                               ,WS-BILL-BSLN-CNTR-LN                    
                               ,WS-BILL-BSLN-HIST-LO                    
                               ,WS-CALL-ENVIRONMENT                     
                               ,WS-INTERRUPT-NZ                         
                               ,WS-CNSMPTN-HOURLY                       
I01959                         ,WS-AR-CNTRL-ASGNE-XFER-AX.              
      *                                                                         
       6550-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CALL SCSCA105                                                **        
      ******************************************************************        
      *                                                                         
       6555-CALL-SCSCA105-CPD4515.                                      
      *                                                                         
           MOVE '6555'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           CALL SCSCA105 USING  LS-PCSCA100-COMM-AREA                   
                               ,WS-FIODB07                              
                               ,SCSCA103-ACCUMULATORS                   
                               ,WS-PREMISE-PR                           
                               ,WS-CUSTOMER-CU                          
                               ,WS-ACCOUNT-AT                           
                               ,WS-AR-CNTRL-AC                          
                               ,WS-BILLING-BI                           
                               ,WS-BILLING-BG                           
                               ,WS-BILL-CALC-DETAIL                     
                               ,WS-BILL-ADJUST-DETAIL                   
                               ,WS-CNSMPTN-HIST-CX                      
                               ,WS-UNMTRD-CNSMPTN-UC                    
                               ,WS-FIXED-FCTR-HIST-FH                   
                               ,WS-BILL-CONTRACT-BK                     
                               ,WS-CUST-PLAN-TABLE-CP                   
                               ,WS-FIXED-FCTR-TABLE-FF                  
                               ,WS-BILL-CNTR-HIST-BX                    
                               ,WS-PEAK-HIST-PH                         
                               ,WS-INTERRUPT-ACCT-IP                    
                               ,WS-STANDBY-GEN-SE                       
                               ,WS-INTERRUPT-IR                         
                               ,WS-UTILITY-TABLE-UT                     
                               ,WS-REGISTER-READ-TABLE-RG               
                               ,WS-MTRD-ENVRNMT-TABLE-MN                
                               ,WS-MTR-CAP-TABLE-MC                     
                               ,WS-UTL-BILL-REL-TABLE-UR                
                               ,WS-EQUIPMENT-TABLE-EQ                   
                               ,WS-FCA00-BILL-CYCLES-RECORD             
                               ,WS-BILLING-WQ-ITEMS-WF                  
                               ,WS-LOCAL-AND-TOTAL-ACCUM-TABLE          
                               ,WS-GL-NAME-INFO                         
                               ,WS-GL-ACCT-NO-TABLE                     
                               ,WS-GL-ACCT-MAJOR-FIELDS                 
                               ,WS-HOLD-WK03                            
                               ,WS-WNA-REVENUE-SUMMARY-TABLE            
                               ,WS-REFUND-RN                            
                               ,WS-ACCT-ATTRIBUTE-YP                    
                               ,WS-ACCT-MKT-TIER-DD                     
                               ,WS-ACCT-RTPK-AGR-DF                     
                               ,WS-BI-FIXED-FCTR-FF                     
                               ,WS-BILL-DET-BT                          
                               ,WS-BILL-ADJUSTMNT                       
                               ,WS-CWS1000B-MAX-TBL-LIMITS              
                               ,WS-CWS1001B-MAX-TBL-LIMITS              
                               ,WS-BILL-CALC-X-DETAIL                   
                               ,WS-VOL-DAILY-ND                         
                               ,WS-UTL-BI-REL-HST-TABLE-UX              
                               ,WS-PREPAY-HIST-PK                       
                               ,WS-BILL-BSLN-CNTR-LN                    
                               ,WS-BILL-BSLN-HIST-LO                    
                               ,WS-CALL-ENVIRONMENT                     
                               ,WS-INTERRUPT-NZ                         
                               ,WS-CNSMPTN-HOURLY                       
I01959                         ,WS-AR-CNTRL-ASGNE-XFER-AX.              
      *                                                                         
       6555-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CHECK CALL RESULTS OF ***102 / ***105 BILL CALC CALLS        **        
      ******************************************************************        
      *                                                                         
       6900-CHK-BILLCALC-RES-CPD4515.                                   
      *                                                                         
           MOVE '6900'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           PERFORM VARYING WS-BILL-WQ-INDX FROM 1 BY 1                  
SCA006       UNTIL WS-CPD4515-REJ-WQ-CNT > 0 OR 
                   WS-BILL-WQ-INDX   > 50 OR 
                   WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX) = 0                      
             INSPECT WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX)              
                     TALLYING WS-CPD4515-REJ-WQ-CNT FOR ALL             
                              'EXCEPTION TYPE = R'                      
             IF WS-CPD4515-REJ-WQ-CNT > 0                               
                SET  CPD4515-ERRORS       TO TRUE                       
                MOVE 9999                 TO WS-CPD4515-RETURN-CODE     
                MOVE WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX)                
                                          TO WS-CPD4515-WQ-CAT-ID       
                MOVE WS-PRIORITY-WF (WS-BILL-WQ-INDX)                   
                                          TO WS-CPD4515-WQ-PRTY         
                MOVE WS-ROUTE-CATEGORY-WF (WS-BILL-WQ-INDX)             
                                          TO WS-CPD4515-WQ-ROUTE-CAT    
                MOVE WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX)              
                                          TO WS-CPD4515-WQ-TEXT         
ACT068          MOVE WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                 
ACT068                                    TO WS-CPD4515-WQ-CREATED-BY   
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
           IF RETURN-CODE NOT = 0 AND WS-CPD4515-REJ-WQ-CNT = 0         
              SET  CPD4515-ERRORS         TO TRUE                       
              MOVE 9999                   TO WS-CPD4515-RETURN-CODE     
           END-IF.                                                      
      *                                                                         
       6900-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
