      ******************************************************************31298000
      **                       COPYBOOK CPD00444                      **31300000
      ******************************************************************31320000
      ** PURPOSE:VALIDATE CSC DISCOUNTS ELIGIBILITY                   **31300000
      **                                                              **        
      ** INPUTS: ACCOUNT NO(REQUIRED)                                 **        
      **         PROGRAM ID(OPTIONAL)                                 **        
      **         USER ID   (OPTIONAL)                                 **        
      **                                                              **        
      ** OUTPUT: SETS DISCOUNT ELIGIBILITY/RECEIVING/PROMOTE FLAGS    **        
      **                                                              **        
      ** NOTE:   WHEN MODIFYING THIS MEMBER, EVALUATE COMPONENTS      **        
      **         CPD00444, CWS00444, CWS0444E, MCSCB444 & SCSCA444    **31300000
      **                                                              **31300000
      ******************************************************************31360000
      **               COPYBOOK MODIFICATION  LOG                     **        
      **                                                              **        
      **  DATE       INITIALS   REASON                                **        
      **  ________   ________   ___________________________________   **        
P805CS**  03/03/16   GD43988    NEW COPYBOOK.                         **        
P805C2**  06/10/16   SS45239    CSC DISCOUNTS-PROMOTE SECTION CHANGES **        
      ******************************************************************        
      *                                                                         
      *                                                                         
      ******************************************************************PCS03340
      ** PROCESS DISCOUNT ELIGIBILITY FOR ALL CSC DISOCUNT TYPE CODES **PCS03320
      ******************************************************************PCS03340
      *                                                                         
       6000-CPD444-CSC-DISCOUNT-ELIG.                                   
      *                                                                         
           MOVE '6000'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           INITIALIZE                       WS-444-OUTPUT-VAR           
                                            WS-444-MISC-VAR             
                                            WS-444-MISC-STORAGE         
                                            WS-444-AT-STORAGE           
                                            WS-444-UT-STORAGE           
                                            WS-444-DF-STORAGE           
                                            WS-444-FI-STORAGE           
                                            WS-444-DD-STORAGE           
                                            WS-444-G6-STORAGE           
                                            WS-444-C8-STORAGE           
                                            WS-444-FF-STORAGE           
                                            WS-444-YP-STORAGE           
                                            WS-444-NF-STORAGE.          
      *                                                                         
           MOVE 'Y'                      TO WS-444-O-ACCT-QLFY-FL.      
P805C2     MOVE 'N'                      TO WS-444-O-PAPERLESS-FL       
P805C2                                      WS-444-O-AUTOCARD-FL        
P805C2                                      WS-444-O-BANK-EFT-FL.       
      *                                                                         
           PERFORM 6025-CPD444-VALIDATE-INPUT THRU 6025-CPD444-EXIT.    
      *                                                                         
      *** DISQUALIFY & EXIT IF AT/UT/DF DATA NOT EXISTS                         
           MOVE WS-444-I-ACCT-NO         TO W4AT-ACCOUNT-NO.            
           MOVE '01'                     TO W4AT-COMPANY-NO             
                                            W4G6-COMPANY-NO             
                                            W4C8-COMPANY-NO.            
           MOVE 'G'                      TO W4UT-CODE-UTIL-TYPE.        
           PERFORM 7000-CPD444-GET-ACCT-DATA THRU 7000-CPD444-EXIT.     
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE W4AT-CODES-DATA-PRESENT                              
                                         TO WS-CODES-DATA-PRESENT       
           ELSE                                                         
              MOVE 'N'                   TO WS-444-O-ACCT-QLFY-FL       
              MOVE  999                  TO WS-ACTIVE-RETURN-CODE       
P805C2        GO TO 6000-CPD444-EXIT                                    
           END-IF.                                                      
      *                                                                         
      *** DISQUALIFY IF ACCT TYPE NOT DEREGULATED/ACN/BUSINESS OWNER            
           IF W4DD-TIER-ACCT-TYPE-CD = 'D' OR 'A' OR 'B'                
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'N'                   TO WS-444-O-ACCT-QLFY-FL       
           END-IF.                                                      
      *                                                                         
      *** GET COMMON DATE & POPULATE NEW DISCOUNT BEG/END DATE,                 
      *** OLD DISCOUNT END DATE, TRANS HIST DATE/TIMESTAMP                      
           MOVE 'COMMON'                 TO W4G6-PROGRAM-NAME.          
           MOVE 'DATE'                   TO W4G6-CMND-CODE.             
           MOVE  10                      TO W4G6-SEQ-NO.                
           MOVE SPACES                   TO W4G6-PARM-DATA.             
           PERFORM 7050-CPD444-GET-COMMON-DT THRU 7050-CPD444-EXIT.     
           MOVE W4G6-PARM-DATA(10:10)    TO WS-444-COMMON-DT            
                                            WS-444-NEWFCTR-BEG-DT.      
           MOVE '2999-12-31'             TO WS-444-NEWFCTR-END-DT.      
           PERFORM 7075-CPD444-GET-DATE-AND-TS THRU 7075-CPD444-EXIT.   
      *                                                                         
           MOVE SPACES                   TO W4G6-PARM-DATA.             
      *                                                                         
           PERFORM 7100-CPD444-OPEN-DISCOUNTS  THRU 7100-CPD444-EXIT.   
      *                                                                         
           PERFORM 7125-CPD444-FETCH-DISCOUNTS THRU 7125-CPD444-EXIT.   
      *                                                                         
           PERFORM 6100-CPD444-PROCESS-DISCOUNTS THRU 6100-CPD444-EXIT  
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
      *                                                                         
           PERFORM 7150-CPD444-CLOSE-DISCOUNTS THRU 7150-CPD444-EXIT.   
      *                                                                         
      *** CHECK AND MODIFY QUALIFY FLAG BASED ON ARRAY                          
           IF WS-444-O-ACCT-QLFY-FL = 'Y'                               
              MOVE 'N'                   TO WS-444-O-ACCT-QLFY-FL       
              PERFORM VARYING WS-444-S FROM 1 BY 1                      
SCA006          UNTIL WS-444-O-ACCT-QLFY-FL = 'Y' OR 
                      WS-444-S > 10 OR 
                      WS-444-O-ELIG-FL(WS-444-S) = SPACES                       
                IF WS-444-O-ELIG-FL(WS-444-S) = 'Y'                     
                   MOVE 'Y'              TO WS-444-O-ACCT-QLFY-FL       
                END-IF                                                  
              END-PERFORM                                               
           END-IF.                                                      
      *                                                                         
       6000-CPD444-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** VALIDATE INPUT PARAMETERS                                    **        
      ******************************************************************        
      *                                                                         
       6025-CPD444-VALIDATE-INPUT.                                      
      *                                                                         
           MOVE '6025'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
      *** DISQUALIFY & EXIT IF ACCT NO IS INVALID                               
           IF WS-444-I-ACCT-NO > 0                                      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'N'                   TO WS-444-O-ACCT-QLFY-FL       
              MOVE  999                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
           IF WS-444-I-PGM-ID > ' '                                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO WS-444-I-PGM-ID             
           END-IF.                                                      
      *                                                                         
           IF WS-444-I-USER-ID > ' '                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'SYSTEM'              TO WS-444-I-USER-ID            
           END-IF.                                                      
      *                                                                         
       6025-CPD444-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ******************************************************************PCS03340
      ** POPULATE DISCOUNT ELIGIBILITY OUTPUT TABLE ARRAY             **PCS03320
      ******************************************************************PCS03340
      *                                                                         
       6100-CPD444-PROCESS-DISCOUNTS.                                   
      *                                                                         
           MOVE '6100'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           INITIALIZE                       WS-444-DISC-TYPE-CD         
                                            WS-444-DISC-FCTR-ID.        
      *                                                                         
           MOVE W4G6-PARM-DATA(15:9)     TO WS-444-DISC-TYPE-CD.        
           MOVE W4G6-PARM-DATA(35:9)     TO WS-444-DISC-FCTR-ID.        
      *                                                                         
           MOVE WS-444-DISC-FCTR-ID      TO W4C8-DELINQ-CD.             
           PERFORM 7200-CPD444-GET-DELINQ-DATA THRU 7200-CPD444-EXIT.   
      *                                                                         
           MOVE 'N'                      TO WS-444-FCTR-EXIST-FL.       
           MOVE WS-444-I-ACCT-NO         TO W4FF-ACCOUNT-NO.            
           MOVE W4UT-CODE-UTIL-TYPE      TO W4FF-CODE-UTIL-TYPE.        
           MOVE W4UT-IC-NO               TO W4FF-IC-NO.                 
           MOVE WS-444-DISC-FCTR-ID      TO W4FF-FACTOR-ID.             
           MOVE WS-444-NEWFCTR-BEG-DT    TO W4FF-EFF-DATE-FROM          
                                            W4FF-EFF-DATE-TO.           
           PERFORM 7225-CPD444-GET-FIXED-FCTR THRU 7225-CPD444-EXIT.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE 'Y'                   TO WS-444-FCTR-EXIST-FL        
           END-IF.                                                      
      *                                                                         
      *** POPULATE DISOCUNT TYPE CODE, FACTOR ID AND DELINQ VALUE               
           ADD 1                         TO WS-444-S.                   
           MOVE WS-444-DISC-TYPE-CD      TO WS-444-O-DISC-CD(WS-444-S). 
           MOVE WS-444-DISC-FCTR-ID      TO WS-444-O-FCTR-ID(WS-444-S). 
           MOVE W4C8-DELINQ-VALUE        TO                             
                                         WS-444-O-DELINQ-VAL(WS-444-S). 
      *                                                                         
      *** POPULATE ELIGIBILITY FLAG & PROMOTE FLAG                              
           MOVE 'N'                   TO WS-444-O-ELIG-FL(WS-444-S).    
           MOVE 'N'                   TO WS-444-O-PROMOTE-FL(WS-444-S). 
           IF WS-444-O-ACCT-QLFY-FL = 'Y'                               
              PERFORM 6150-CPD444-CHK-ELIGIBILITY                       
                 THRU 6150-CPD444-EXIT                                  
           END-IF.                                                      
      *                                                                         
      *** POPULATE RECEIVING FLAG AND FACTOR DATA                               
           EVALUATE WS-444-O-ELIG-FL(WS-444-S)                          
             ALSO   WS-444-FCTR-EXIST-FL                                
             WHEN   'Y' ALSO 'Y'                                        
             WHEN   'N' ALSO 'Y'                                        
               MOVE 'Y'                   TO WS-444-O-RECV-FL(WS-444-S) 
               MOVE W4FF-EFF-DATE-FROM    TO WS-444-O-DT-FROM(WS-444-S) 
               MOVE W4FF-EFF-DATE-TO      TO WS-444-O-DT-TO(WS-444-S)   
               IF W4FF-FACTOR < 0                                       
                  COMPUTE W4FF-FACTOR = W4FF-FACTOR * -1                
                  END-COMPUTE                                           
               END-IF                                                   
               MOVE W4FF-FACTOR           TO WS-444-O-FACTOR(WS-444-S)  
               MOVE W4FF-FIXED-FCTR-SEQ-NO                              
                 TO WS-444-O-FCTR-SEQ-NO(WS-444-S)                      
             WHEN   'Y' ALSO 'N'                                        
               MOVE 'N'                   TO WS-444-O-RECV-FL(WS-444-S) 
               MOVE WS-444-NEWFCTR-BEG-DT TO WS-444-O-DT-FROM(WS-444-S) 
               MOVE WS-444-NEWFCTR-END-DT TO WS-444-O-DT-TO(WS-444-S)   
               MOVE W4C8-DELINQ-VALUE     TO WS-444-O-FACTOR(WS-444-S)  
               MOVE 0                 TO WS-444-O-FCTR-SEQ-NO(WS-444-S) 
            WHEN    'N' ALSO 'N'                                        
               MOVE 'N'                   TO WS-444-O-RECV-FL(WS-444-S) 
               MOVE SPACES                TO WS-444-O-DT-FROM(WS-444-S) 
               MOVE SPACES                TO WS-444-O-DT-TO(WS-444-S)   
               MOVE 0                     TO WS-444-O-FACTOR(WS-444-S)  
               MOVE 0                 TO WS-444-O-FCTR-SEQ-NO(WS-444-S) 
           END-EVALUATE.                                                
      *                                                                         
           INITIALIZE                       W4G6-PARM-DATA.             
      *                                                                         
           PERFORM 7125-CPD444-FETCH-DISCOUNTS THRU 7125-CPD444-EXIT.   
      *                                                                         
       6100-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03340
      ** VALIDATE ELIGIBILITY AND SET THE FLAG                        **PCS03320
      ******************************************************************PCS03340
      *                                                                         
       6150-CPD444-CHK-ELIGIBILITY.                                     
      *                                                                         
           MOVE '6150'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
      *** CUSTOMERS MAY NOT BE ELIGIBLE BASED ON EXCLUSION CRITERIA             
      *** ACCT TYPE/RATE/OPTION TYPE/DURATION ETC.                              
           MOVE 'N'                      TO WS-444-XCLUDE-DISC-FL.      
           PERFORM 7250-CPD444-CHK-XCLUDE-DISC THRU 7250-CPD444-EXIT    
           IF WS-444-XCLUDE-DISC-FL = 'Y'                               
              GO TO 6150-CPD444-EXIT                                    
           END-IF.                                                      
      *                                                                         
      *** AUTO RENEWAL DISCOUNT VALIDATION                                      
           IF WS-444-DISC-TYPE-CD     = 'AUTORENEW' AND                 
              W4FI-OPT-CALC-TYPE-CD   = 'FP'                            
              EVALUATE W4DF-AUTO-REN-OPT-IN-FL                          
                WHEN 'A'                                                
                WHEN 'I'                                                
                  MOVE 'Y'             TO WS-444-O-ELIG-FL(WS-444-S)    
                WHEN 'E'                                                
                WHEN 'O'                                                
                  MOVE 'Y'             TO WS-444-O-PROMOTE-FL(WS-444-S) 
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
      **** PAPERLESS DISCOUNT VALIDATION                                        
           IF WS-444-DISC-TYPE-CD = 'PAPERLESS'                         
P805C2**** PAPERLESS BILLING                                                    
              IF W4AT-NO-BILL-COPIES =  0                               
P805C2           MOVE 'Y'               TO WS-444-O-PAPERLESS-FL        
P805C2        END-IF                                                    
P805C2**** BANK DRAFT/E-DRAFT                                                   
              IF WS-CODE-BANK-EFT = 'A'                                 
P805C2           MOVE 'Y'               TO WS-444-O-BANK-EFT-FL         
P805C2        END-IF                                                    
P805C2**** AUTO CARD PAY                                                        
              PERFORM 7275-CPD444-GET-ACCT-ATTRIBUTE                    
                 THRU 7275-CPD444-EXIT                                  
P805C2        IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL           
P805C2           MOVE 'Y'               TO WS-444-O-AUTOCARD-FL         
P805C2        END-IF                                                    
P805C2**** PAPERLESS BILLING AND RECURRING PAYMENTS DISCOUNT ELIGIBILITY        
P805C2        IF WS-444-O-PAPERLESS-FL     = 'Y'                        
P805C2           IF ((WS-444-O-BANK-EFT-FL = 'Y' OR                     
P805C2                WS-444-O-AUTOCARD-FL = 'Y')                       
P805C2               AND W4AT-MST-SUB-ACCT-IND NOT = 'M'                
P805C2               AND W4AT-MST-SUB-ACCT-IND NOT = 'S')               
P805C2              MOVE 'Y'            TO WS-444-O-ELIG-FL(WS-444-S)   
P805C2           END-IF                                                 
P805C2        END-IF                                                    
              IF WS-444-O-ELIG-FL(WS-444-S) = 'N'                       
P805C2            AND W4AT-MST-SUB-ACCT-IND NOT = 'M'                   
P805C2            AND W4AT-MST-SUB-ACCT-IND NOT = 'S'                   
                 MOVE 'Y'               TO WS-444-O-PROMOTE-FL(WS-444-S)
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6150-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** GET ACCOUNT AND RATE DATA                                   **         
      *****************************************************************         
      *                                                                         
       7000-CPD444-GET-ACCT-DATA.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) AT.CUSTOMER_NO,
              AT.PREMISE_NO,
              AT.LOCAL_OFFICE,
              AT.BILL_CYCLE,
              AT.CODE_ACCT_STAT,
              AT.NO_BILL_COPIES,
              AT.CODES_DATA_PRESENT,
              AT.REV_MTH_LST_NRML,
              AT.MST_SUB_ACCT_IND,
              UT.IC_NO,
              UT.RATE_PLAN_NO,
              DF.RT_PKG_OPT_SEQ_NO,
              DF.OFFER_CD,
              DF.OPTION_CD,
              DF.STATUS_CD,
              DF.OPT_AGRMT_EFF_DT,
              DF.AUTO_REN_OPT_IN_FL,
              FI.OPT_CALC_TYPE_CD,
              DD.TIER_CUST_STAT_CD,
              DD.TIER_ACCT_TYPE_CD                              
                INTO :W4AT-CUSTOMER-NO                                  
                    ,:W4AT-PREMISE-NO                                   
                    ,:W4AT-LOCAL-OFFICE                                 
                    ,:W4AT-BILL-CYCLE                                   
                    ,:W4AT-CODE-ACCT-STAT                               
                    ,:W4AT-NO-BILL-COPIES                               
                    ,:W4AT-CODES-DATA-PRESENT                           
                    ,:W4AT-REV-MTH-LST-NRML                             
P805C2              ,:W4AT-MST-SUB-ACCT-IND                             
                    ,:W4UT-IC-NO                                        
                    ,:W4UT-RATE-PLAN-NO                                 
                    ,:W4DF-RT-PKG-OPT-SEQ-NO                            
                    ,:W4DF-OFFER-CD                                     
                    ,:W4DF-OPTION-CD                                    
                    ,:W4DF-STATUS-CD                                    
                    ,:W4DF-OPT-AGRMT-EFF-DT                             
                    ,:W4DF-AUTO-REN-OPT-IN-FL                           
                    ,:W4FI-OPT-CALC-TYPE-CD                             
                    ,:W4DD-TIER-CUST-STAT-CD                            
                    ,:W4DD-TIER-ACCT-TYPE-CD                            
                                                                        
                FROM CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                
                    ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                
                    ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)                
                    ,CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)                
                    ,CSS_ACCT_MKT_TIER  DD WITH(READUNCOMMITTED)                
                                                                        
               WHERE AT.ACCOUNT_NO           = :W4AT-ACCOUNT-NO         
                 AND AT.ACCOUNT_NO           =  UT.ACCOUNT_NO           
                 AND AT.ACCOUNT_NO           =  DF.ACCOUNT_NO           
                 AND AT.ACCOUNT_NO           =  DD.ACCOUNT_NO           
                 AND AT.COMPANY_NO           = :W4AT-COMPANY-NO         
                 AND AT.COMPANY_NO           =  UT.COMPANY_NO           
                 AND AT.COMPANY_NO           =  DF.COMPANY_NO           
                 AND AT.COMPANY_NO           =  FI.COMPANY_NO           
                 AND AT.COMPANY_NO           =  DD.COMPANY_NO           
                 AND UT.CODE_UTIL_TYPE       = :W4UT-CODE-UTIL-TYPE     
                 AND UT.CODE_UTIL_TYPE       =  DF.CODE_UTIL_TYPE       
                 AND UT.CODE_UTIL_TYPE       =  FI.CODE_UTIL_TYPE       
                 AND UT.IC_NO                =  DF.IC_NO                
                 AND UT.RT_PKG_OPT_SEQ_NO    =  DF.RT_PKG_OPT_SEQ_NO    
                 AND FI.OPTION_CD            =  DF.OPTION_CD            
                 AND FI.OPTION_START_DT     <=  DF.OPT_AGRMT_EFF_DT     
                 AND FI.OPTION_END_DT       >=  DF.OPT_AGRMT_EFF_DT     
                 AND CAST(FI.OPT_VSTART_TS AS DATE) <=  
           DF.OPT_AGRMT_EFF_DT     
                 AND CAST(FI.OPT_VEND_TS AS DATE)   >=  
           DF.OPT_AGRMT_EFF_DT     
                 AND FI.PROC_STATUS_CD       = 'AC'                     
                 AND DD.EFF_START_DT     IN                             
                    (SELECT MAX(EFF_START_DT)                           
                       FROM CSS_ACCT_MKT_TIER DD1 WITH(READUNCOMMITTED)         
                      WHERE DD1.ACCOUNT_NO = DD.ACCOUNT_NO)             
              ORDER BY FI.OPT_VSTART_TS DESC                            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.NO_BILL_COPIES                                         
MFA-TR*              ,AT.CODES_DATA_PRESENT                                     
MFA-TR*              ,AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.MST_SUB_ACCT_IND                                       
MFA-TR*              ,UT.IC_NO                                                  
MFA-TR*              ,UT.RATE_PLAN_NO                                           
MFA-TR*              ,DF.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*              ,DF.OFFER_CD                                               
MFA-TR*              ,DF.OPTION_CD                                              
MFA-TR*              ,DF.STATUS_CD                                              
MFA-TR*              ,DF.OPT_AGRMT_EFF_DT                                       
MFA-TR*              ,DF.AUTO_REN_OPT_IN_FL                                     
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,DD.TIER_CUST_STAT_CD                                      
MFA-TR*              ,DD.TIER_ACCT_TYPE_CD                                      
MFA-TR*         INTO :W4AT-CUSTOMER-NO                                          
MFA-TR*             ,:W4AT-PREMISE-NO                                           
MFA-TR*             ,:W4AT-LOCAL-OFFICE                                         
MFA-TR*             ,:W4AT-BILL-CYCLE                                           
MFA-TR*             ,:W4AT-CODE-ACCT-STAT                                       
MFA-TR*             ,:W4AT-NO-BILL-COPIES                                       
MFA-TR*             ,:W4AT-CODES-DATA-PRESENT                                   
MFA-TR*             ,:W4AT-REV-MTH-LST-NRML                                     
MFA-TR*             ,:W4AT-MST-SUB-ACCT-IND                                     
MFA-TR*             ,:W4UT-IC-NO                                                
MFA-TR*             ,:W4UT-RATE-PLAN-NO                                         
MFA-TR*             ,:W4DF-RT-PKG-OPT-SEQ-NO                                    
MFA-TR*             ,:W4DF-OFFER-CD                                             
MFA-TR*             ,:W4DF-OPTION-CD                                            
MFA-TR*             ,:W4DF-STATUS-CD                                            
MFA-TR*             ,:W4DF-OPT-AGRMT-EFF-DT                                     
MFA-TR*             ,:W4DF-AUTO-REN-OPT-IN-FL                                   
MFA-TR*             ,:W4FI-OPT-CALC-TYPE-CD                                     
MFA-TR*             ,:W4DD-TIER-CUST-STAT-CD                                    
MFA-TR*             ,:W4DD-TIER-ACCT-TYPE-CD                                    
MFA-TR*                                                                         
MFA-TR*         FROM CSS_ACCOUNT        AT                                      
MFA-TR*             ,CSS_UTIL_ENVRNMT   UT                                      
MFA-TR*             ,CSS_ACCT_RTPK_AGR  DF                                      
MFA-TR*             ,CRM_RT_PKG_OPTION  FI                                      
MFA-TR*             ,CSS_ACCT_MKT_TIER  DD                                      
MFA-TR*                                                                         
MFA-TR*        WHERE AT.ACCOUNT_NO           = :W4AT-ACCOUNT-NO                 
MFA-TR*          AND AT.ACCOUNT_NO           =  UT.ACCOUNT_NO                   
MFA-TR*          AND AT.ACCOUNT_NO           =  DF.ACCOUNT_NO                   
MFA-TR*          AND AT.ACCOUNT_NO           =  DD.ACCOUNT_NO                   
MFA-TR*          AND AT.COMPANY_NO           = :W4AT-COMPANY-NO                 
MFA-TR*          AND AT.COMPANY_NO           =  UT.COMPANY_NO                   
MFA-TR*          AND AT.COMPANY_NO           =  DF.COMPANY_NO                   
MFA-TR*          AND AT.COMPANY_NO           =  FI.COMPANY_NO                   
MFA-TR*          AND AT.COMPANY_NO           =  DD.COMPANY_NO                   
MFA-TR*          AND UT.CODE_UTIL_TYPE       = :W4UT-CODE-UTIL-TYPE             
MFA-TR*          AND UT.CODE_UTIL_TYPE       =  DF.CODE_UTIL_TYPE               
MFA-TR*          AND UT.CODE_UTIL_TYPE       =  FI.CODE_UTIL_TYPE               
MFA-TR*          AND UT.IC_NO                =  DF.IC_NO                        
MFA-TR*          AND UT.RT_PKG_OPT_SEQ_NO    =  DF.RT_PKG_OPT_SEQ_NO            
MFA-TR*          AND FI.OPTION_CD            =  DF.OPTION_CD                    
MFA-TR*          AND FI.OPTION_START_DT     <=  DF.OPT_AGRMT_EFF_DT             
MFA-TR*          AND FI.OPTION_END_DT       >=  DF.OPT_AGRMT_EFF_DT             
MFA-TR*          AND DATE(FI.OPT_VSTART_TS) <=  DF.OPT_AGRMT_EFF_DT             
MFA-TR*          AND DATE(FI.OPT_VEND_TS)   >=  DF.OPT_AGRMT_EFF_DT             
MFA-TR*          AND FI.PROC_STATUS_CD       = 'AC'                             
MFA-TR*          AND DD.EFF_START_DT     IN                                     
MFA-TR*             (SELECT MAX(EFF_START_DT)                                   
MFA-TR*                FROM CSS_ACCT_MKT_TIER DD1                               
MFA-TR*               WHERE DD1.ACCOUNT_NO = DD.ACCOUNT_NO)                     
MFA-TR*       ORDER BY FI.OPT_VSTART_TS DESC                                    
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3             
              MOVE W4AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE W4AT-COMPANY-NO       TO HOSTVAR-ELEMENT-2           
              MOVE W4UT-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-3           
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
       7000-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** GET COMMON DATE FROM JOB PARM                               **         
      *****************************************************************         
      *                                                                         
       7050-CPD444-GET-COMMON-DT.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT  G6.PARM_DATA                                      
                INTO :W4G6-PARM-DATA                                    
                FROM  CSS_JOB_PARM  G6 WITH(READUNCOMMITTED)                    
               WHERE  G6.PROGRAM_NAME  =  :W4G6-PROGRAM-NAME            
                 AND  G6.COMPANY_NO    =  :W4G6-COMPANY-NO              
                 AND  G6.CMND_CODE     =  :W4G6-CMND-CODE               
                 AND  G6.SEQ_NO        =  :W4G6-SEQ-NO                  
                 AND  G6.STATUS        =  'A'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  G6.PARM_DATA                                              
MFA-TR*         INTO :W4G6-PARM-DATA                                            
MFA-TR*         FROM  CSS_JOB_PARM  G6                                  02535001
MFA-TR*        WHERE  G6.PROGRAM_NAME  =  :W4G6-PROGRAM-NAME            02536001
MFA-TR*          AND  G6.COMPANY_NO    =  :W4G6-COMPANY-NO              02539001
MFA-TR*          AND  G6.CMND_CODE     =  :W4G6-CMND-CODE               02537001
MFA-TR*          AND  G6.SEQ_NO        =  :W4G6-SEQ-NO                  02538001
MFA-TR*          AND  G6.STATUS        =  'A'                           02539001
MFA-TR*       WITH UR                                                   02557001
MFA-TR*       QUERYNO 7050                                              02557001
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE 'CMND_CODE'           TO TABLE-ELEMENT-3             
              MOVE 'SEQ_NO'              TO TABLE-ELEMENT-4             
              MOVE W4G6-PROGRAM-NAME     TO HOSTVAR-ELEMENT-1           
              MOVE W4G6-COMPANY-NO       TO HOSTVAR-ELEMENT-2           
              MOVE W4G6-CMND-CODE        TO HOSTVAR-ELEMENT-3           
              MOVE W4G6-SEQ-NO           TO HOSTVAR-ELEMENT-4           
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
       7050-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** GET OLD DISCOUNT END DATE, CURRENT DATE & CURRENT TIMESTAMP **         
      *****************************************************************         
      *                                                                         
       7075-CPD444-GET-DATE-AND-TS.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                 :WS-444-NEWFCTR-BEG-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-444-NEWFCTR-BEG-DT
              ) <> 0) OR (LEN(:WS-444-NEWFCTR-BEG-DT
              ) <> 10), CIS.CHAR2DATE(:WS-444-NEWFCTR-BEG-DT
              ), CONVERT(DATE, :WS-444-NEWFCTR-BEG-DT) ) )
            INTO
              :WS-444-OLDFCTR-END-DT                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-444-OLDFCTR-END-DT = DATE(:WS-444-NEWFCTR-BEG-DT)         
MFA-TR*                                  - 1 DAY                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7075'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE 'CSS_MODEL_SQL'       TO TABLE-1                     
              MOVE 'NEWFCTR_BEG_DT'      TO TABLE-ELEMENT-1             
              MOVE WS-444-NEWFCTR-BEG-DT TO HOSTVAR-ELEMENT-1           
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
       7075-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** OPEN DISCOUNT TYPE CODES CURSOR                             **         
      *****************************************************************         
      *                                                                         
       7100-CPD444-OPEN-DISCOUNTS.                                      
      *                                                                         
           EXEC SQL                                                     
                OPEN DISCOUNT_TYPE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE W4AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
       7100-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** FETCH DISCOUNT TYPE CODES CURSOR                            **         
      *****************************************************************         
      *                                                                         
       7125-CPD444-FETCH-DISCOUNTS.                                     
      *                                                                         
           EXEC SQL                                                     
                FETCH DISCOUNT_TYPE                                     
                 INTO :W4G6-PARM-DATA                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7125'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE W4AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
       7125-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** CLOSE DISCOUNT TYPE CODES CURSOR                            **         
      *****************************************************************         
      *                                                                         
       7150-CPD444-CLOSE-DISCOUNTS.                                     
      *                                                                         
           EXEC SQL                                                     
                CLOSE DISCOUNT_TYPE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE W4AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
       7150-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** SELECT DELINQUENCY DATA                                     **         
      *****************************************************************         
      *                                                                         
       7200-CPD444-GET-DELINQ-DATA.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT  C8.DELINQ_VALUE                                   
                INTO :W4C8-DELINQ-VALUE                                 
                FROM CSS_DELINQUENCY  C8 WITH(READUNCOMMITTED)                  
               WHERE C8.DELINQ_CD   =  :W4C8-DELINQ-CD                  
                 AND C8.COMPANY_NO  =  :W4C8-COMPANY-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C8.DELINQ_VALUE                                           
MFA-TR*         INTO :W4C8-DELINQ-VALUE                                         
MFA-TR*         FROM CSS_DELINQUENCY  C8                                        
MFA-TR*        WHERE C8.DELINQ_CD   =  :W4C8-DELINQ-CD                          
MFA-TR*          AND C8.COMPANY_NO  =  :W4C8-COMPANY-NO                         
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE W4C8-DELINQ-CD        TO HOSTVAR-ELEMENT-1           
              MOVE W4C8-COMPANY-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
       7200-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** SELECT FIXED FCTR DATA                                      **         
      *****************************************************************         
      *                                                                         
       7225-CPD444-GET-FIXED-FCTR.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT  FF.FIXED_FCTR_SEQ_NO                              
                     ,FF.EFF_DATE_FROM                                  
                     ,FF.EFF_DATE_TO                                    
                     ,FF.FACTOR                                         
                INTO  :W4FF-FIXED-FCTR-SEQ-NO                           
                     ,:W4FF-EFF-DATE-FROM                               
                     ,:W4FF-EFF-DATE-TO                                 
                     ,:W4FF-FACTOR                                      
                FROM CSS_FIXED_FCTR  FF WITH(READUNCOMMITTED)                   
               WHERE FF.ACCOUNT_NO      =  :W4FF-ACCOUNT-NO             
                 AND FF.CODE_UTIL_TYPE  =  :W4FF-CODE-UTIL-TYPE         
                 AND FF.IC_NO           =  :W4FF-IC-NO                  
                 AND FF.FACTOR_ID       =  :W4FF-FACTOR-ID              
                 AND FF.EFF_DATE_FROM  <=  IIF(TRY_CONVERT(DATE, 
                                                    :W4FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :W4FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:W4FF-EFF-DATE-FROM
              ) <> 10), CIS.CHAR2DATE(:W4FF-EFF-DATE-FROM
              ), CONVERT(DATE, :W4FF-EFF-DATE-FROM) )          
                 AND FF.EFF_DATE_TO    >=  IIF(TRY_CONVERT(DATE, 
                                                      :W4FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :W4FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:W4FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                      :W4FF-EFF-DATE-TO
              ), CONVERT(DATE, :W4FF-EFF-DATE-TO) )            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FF.FIXED_FCTR_SEQ_NO                                      
MFA-TR*              ,FF.EFF_DATE_FROM                                          
MFA-TR*              ,FF.EFF_DATE_TO                                            
MFA-TR*              ,FF.FACTOR                                                 
MFA-TR*         INTO  :W4FF-FIXED-FCTR-SEQ-NO                                   
MFA-TR*              ,:W4FF-EFF-DATE-FROM                                       
MFA-TR*              ,:W4FF-EFF-DATE-TO                                         
MFA-TR*              ,:W4FF-FACTOR                                              
MFA-TR*         FROM CSS_FIXED_FCTR  FF                                         
MFA-TR*        WHERE FF.ACCOUNT_NO      =  :W4FF-ACCOUNT-NO                     
MFA-TR*          AND FF.CODE_UTIL_TYPE  =  :W4FF-CODE-UTIL-TYPE                 
MFA-TR*          AND FF.IC_NO           =  :W4FF-IC-NO                          
MFA-TR*          AND FF.FACTOR_ID       =  :W4FF-FACTOR-ID                      
MFA-TR*          AND FF.EFF_DATE_FROM  <=  :W4FF-EFF-DATE-FROM                  
MFA-TR*          AND FF.EFF_DATE_TO    >=  :W4FF-EFF-DATE-TO                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7225                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7225'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'FACTOR_ID'           TO TABLE-ELEMENT-4             
              MOVE W4FF-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE W4FF-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2           
              MOVE W4FF-IC-NO            TO HOSTVAR-ELEMENT-3           
              MOVE W4FF-FACTOR-ID        TO HOSTVAR-ELEMENT-4           
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
       7225-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** CUSTOMERS MAY NOT BE ELIGIBLE BASED ON EXCLUSION CRITERIA   **         
      ** ACCT TYPE/RATE/OPTION TYPE/DURATION ETC.                    **         
      *****************************************************************         
      *                                                                         
       7250-CPD444-CHK-XCLUDE-DISC.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT  'Y'                                               
                INTO :WS-444-XCLUDE-DISC-FL                             
                FROM CSS_JOB_PARM  G6 WITH(READUNCOMMITTED)                     
               WHERE G6.PROGRAM_NAME        = 'CPD00444'                
                 AND G6.COMPANY_NO          = :W4G6-COMPANY-NO          
                 AND G6.CMND_CODE           = 'OPTN'                    
                 AND G6.STATUS              = 'A'                       
                 AND CIS.SUBSTR3(PARM_DATA,1,9)  = :WS-444-DISC-TYPE-CD      
                 AND CIS.SUBSTR3(PARM_DATA,11,1) = 
                                                :W4DD-TIER-ACCT-TYPE-CD   
                 AND CIS.SUBSTR3(PARM_DATA,13,1) = 
                                                :W4DD-TIER-CUST-STAT-CD   
                 AND CIS.SUBSTR3(PARM_DATA,15,3) = :W4UT-RATE-PLAN-NO        
                 AND CIS.SUBSTR3(PARM_DATA,19,2) = 
                                                 :W4FI-OPT-CALC-TYPE-CD    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-444-XCLUDE-DISC-FL                                     
MFA-TR*         FROM CSS_JOB_PARM  G6                                   02535001
MFA-TR*        WHERE G6.PROGRAM_NAME        = 'CPD00444'                02536001
MFA-TR*          AND G6.COMPANY_NO          = :W4G6-COMPANY-NO          02537001
MFA-TR*          AND G6.CMND_CODE           = 'OPTN'                    02538001
MFA-TR*          AND G6.STATUS              = 'A'                       02539001
MFA-TR*          AND SUBSTR(PARM_DATA,1,9)  = :WS-444-DISC-TYPE-CD      02539001
MFA-TR*          AND SUBSTR(PARM_DATA,11,1) = :W4DD-TIER-ACCT-TYPE-CD   02539001
MFA-TR*          AND SUBSTR(PARM_DATA,13,1) = :W4DD-TIER-CUST-STAT-CD   02539001
MFA-TR*          AND SUBSTR(PARM_DATA,15,3) = :W4UT-RATE-PLAN-NO        02539001
MFA-TR*          AND SUBSTR(PARM_DATA,19,2) = :W4FI-OPT-CALC-TYPE-CD    02539001
MFA-TR*       WITH UR                                                   02557001
MFA-TR*       QUERYNO 7250                                              02557001
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7250'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-1             
              MOVE W4UT-RATE-PLAN-NO     TO HOSTVAR-ELEMENT-1           
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
       7250-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** SELECT ACOCUNT ATTRIBUTE DATA                               **         
      *****************************************************************         
      *                                                                         
       7275-CPD444-GET-ACCT-ATTRIBUTE.                                  
      *                                                                         
           EXEC SQL                                                     
              SELECT  YP.ATTRIBUTE_VALUE_DT                             
                INTO :W4YP-ATTRIBUTE-VALUE-DT                           
                FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
               WHERE YP.ACCOUNT_NO          = :W4AT-ACCOUNT-NO          
                 AND YP.ATTRIBUTE_VALUE_DT <= IIF(TRY_CONVERT(DATE, 
                                                 :WS-444-NEWFCTR-BEG-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-444-NEWFCTR-BEG-DT
              ) <> 0) OR (LEN(:WS-444-NEWFCTR-BEG-DT
              ) <> 10), CIS.CHAR2DATE(:WS-444-NEWFCTR-BEG-DT
              ), CONVERT(DATE, :WS-444-NEWFCTR-BEG-DT) )    
                 AND YP.ATTRIBUTE_DESC      = 'AUTO_CARD_PAY'           
                 AND YP.STATUS_CD           = 'A'                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  YP.ATTRIBUTE_VALUE_DT                                     
MFA-TR*         INTO :W4YP-ATTRIBUTE-VALUE-DT                                   
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                                      
MFA-TR*        WHERE YP.ACCOUNT_NO          = :W4AT-ACCOUNT-NO                  
MFA-TR*          AND YP.ATTRIBUTE_VALUE_DT <= :WS-444-NEWFCTR-BEG-DT            
MFA-TR*          AND YP.ATTRIBUTE_DESC      = 'AUTO_CARD_PAY'                   
MFA-TR*          AND YP.STATUS_CD           = 'A'                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7275                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7275'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'NEWFCTR_BEG_DT'      TO TABLE-ELEMENT-2             
              MOVE W4AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE WS-444-NEWFCTR-BEG-DT TO HOSTVAR-ELEMENT-2           
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
       7275-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
